<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'h5p', language 'sv', version '4.4'.
 *
 * @package     h5p
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptTerms'] = 'Jag accepterar <a href=":url" target="_blank">användarvillkoren</a>';
$string['accountDetailsLinkText'] = 'här';
$string['actions'] = 'Åtgärder';
$string['add'] = 'Lägg till';
$string['addedandupdatedpp'] = 'Lade till {$a->%new} nya H5P-bibliotek och uppdaterade {$a->%old} gamla.';
$string['addedandupdatedps'] = 'Lade till {$a->%new} nya H5P-bibliotek och uppdaterade {$a->%old} gammalt.';
$string['addedandupdatedsp'] = 'Lade till {$a->%new} nytt H5P-bibliotek och uppdaterade {$a->%old} gamla.';
$string['addedandupdatedss'] = 'Lade till {$a->%new} nytt H5P-bibliotek och uppdaterade {$a->%old} gammalt.';
$string['addednewlibraries'] = 'Lade till {$a->%new} nya H5P-bibliotek.';
$string['addednewlibrary'] = 'Lade till {$a->%new} nytt H5P-bibliotek';
$string['additionallicenseinfo'] = 'Ytterligare information om licensen';
$string['address'] = 'Adress';
$string['age'] = 'Typisk ålder';
$string['altText'] = 'Alternativ text';
$string['atto_h5p'] = 'Infoga H5P-knapp';
$string['atto_h5p_description'] = 'Knappen <em>Infoga H5P</em> i Atto-redigeraren gör det möjligt för användare att infoga H5P-innehåll genom att antingen ange en URL- eller inbäddningskod, eller genom att ladda upp en H5P-fil.';
$string['author'] = 'Författare';
$string['authorcomments'] = 'Författarens kommentarer';
$string['authorcommentsdescription'] = 'Kommentarer från redaktören för innehållet. (Denna text kommer inte att publiceras som en del av upphovsrättsinformationen).';
$string['authorname'] = 'Författarens namn';
$string['authorrole'] = 'Författarens roll';
$string['back'] = 'Tillbaka';
$string['by'] = 'av';
$string['cancelPublishConfirmationDialogCancelButtonText'] = 'Nej';
$string['cancelPublishConfirmationDialogConfirmButtonText'] = 'Ja';
$string['cancelPublishConfirmationDialogDescription'] = 'Är du säker på att du vill stoppa delningen?';
$string['cancelPublishConfirmationDialogTitle'] = 'Stoppa delning';
$string['cancellabel'] = 'Avbryt';
$string['ccattribution'] = 'Attribution (CC BY)';
$string['ccattributionnc'] = 'Attribution-NonCommercial (CC BY-NC)';
$string['ccattributionncnd'] = 'Attribution-NonCommercial-NoDerivs (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Attribution-NonCommercial-ShareAlike (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Attribution-NoDerivs (CC BY-ND)';
$string['ccattributionsa'] = 'Attribution-ShareAlike (CC BY-SA)';
$string['ccpdd'] = 'Public Domain Dedication (CC0)';
$string['changedby'] = 'Ändrad av';
$string['changedescription'] = 'Beskrivning av ändringen';
$string['changelog'] = 'Ändringslogg';
$string['changeplaceholder'] = 'Bild beskuren, text ändrad osv.';
$string['city'] = 'Stad';
$string['close'] = 'Stäng';
$string['confirmdialogbody'] = 'Vänligen bekräfta att du vill fortsätta. Denna åtgärd går inte att ångra.';
$string['confirmdialogheader'] = 'Bekräfta åtgärd';
$string['confirmlabel'] = 'Bekräfta';
$string['connectionLost'] = 'Anslutningen förlorades. Resultaten lagras och kommer skickas när anslutningen återupprättats.';
$string['connectionReestablished'] = 'Anslutning återupprättad.';
$string['contactPerson'] = 'Kontaktperson';
$string['contentCopied'] = 'Innehåll kopierat till urklipp';
$string['contentchanged'] = 'Innehållet har ändrats sedan du senast använde det.';
$string['contentinuse'] = 'Detta innehåll kan vara i bruk på andra platser.';
$string['contenttype'] = 'Innehållstyp';
$string['copyright'] = 'Användningsrättigheter';
$string['copyrightinfo'] = 'Upphovsrättsinformation';
$string['copyrightstring'] = 'Copyright';
$string['copyrighttitle'] = 'Visa upphovsrättsinformation för detta innehåll.';
$string['couldNotParseJSONFromZip'] = 'Det gick inte att tolka JSON från paketet: {$a->%fileName}';
$string['couldNotReadFileFromZip'] = 'Kunde inte läsa fil från paketet: {$a->%fileName}';
$string['country'] = 'Land';
$string['creativecommons'] = 'Creative Commons';
$string['currentStep'] = 'Steg :step av :total';
$string['date'] = 'Datum';
$string['deletelibraryconfirm'] = '<p>Är du säker på att du vill ta bort version <em>\'{$a->version}\'</em> från bibliotek <em>\'{$a->name}\'</em>? Detta kommer att ta bort biblioteket från webbplatsen samt från alla platser där det används.</p><p>Denna åtgärd går inte att ångra.</p>';
$string['deletelibraryversion'] = 'Ta bort version';
$string['deleting'] = 'Tar bort bibliotek';
$string['description'] = 'Beskrivning';
$string['disablefullscreen'] = 'Inaktivera helskärm';
$string['disciplineLabel'] = 'Discipliner';
$string['disciplineLimitReachedMessage'] = 'Du kan välja upp till :numDisciplines discipliner';
$string['disciplines'] = 'Discipliner';
$string['download'] = 'Ladda ner';
$string['downloadtitle'] = 'Ladda ner detta innehåll som en H5P-fil.';
$string['editInfoTitle'] = 'Redigera information för <strong>:title</strong>';
$string['editcontent'] = 'Redigera H5P-innehåll';
$string['editingFailed'] = 'Redigeringen misslyckades.';
$string['editor'] = 'Redigerare';
$string['emailAddress'] = 'E-postadress';
$string['embed'] = 'Bädda in';
$string['embedtitle'] = 'Visa inbäddningskoden för detta innehåll.';
$string['error:emptycontentid'] = 'Den angivna URL:en är fel eller så kan du inte redigera den här filen.';
$string['eventh5pdeleted'] = 'H5P borttaget';
$string['eventh5pviewed'] = 'H5P-innehåll visat';
$string['feature'] = 'Funktion';
$string['fetchtypesfailure'] = 'Det gick inte att hämta information om tillgängliga H5P-innehållstyper. Fel i anslutningen till lagringsplatsen för H5P-innehåll.';
$string['fileExceedsMaxSize'] = 'Storleken på en av filerna i paketet överskrider den tillåtna filstorleken. ({$a->%file} {$a->%used} > {$a->%max})';
$string['filter_displayh5p'] = 'Visa H5P-filter';
$string['filter_displayh5p_description'] = '<em>Visa H5P-filter</em> omvandlar webbadresser till inbäddat H5P-innehåll.';
$string['fullscreen'] = 'Helskärm';
$string['gpl'] = 'General Public License v3';
$string['h5p'] = 'H5P';
$string['h5peditor'] = 'H5P-redigerare';
$string['h5pfilenotfound'] = 'Hittade inte H5P-fil';
$string['h5pinvalidurl'] = 'Ogiltig H5P-innehålls URL.';
$string['h5plibraryhandler'] = 'Hanterare för H5P-ramverk';
$string['h5plibraryhandler_help'] = 'H5P-ramverket som används för att visa H5P-innehåll. Den senaste versionen rekommenderas.';
$string['h5pmanage'] = 'Hantera innehållstyper';
$string['h5poverview'] = 'Översikt';
$string['h5ppackage'] = 'Innehållstyp';
$string['h5ppackage_help'] = 'En H5P-innehållstyp är en fil med en H5P- eller ZIP-filändelse som innehåller alla bibliotek som krävs för att visa innehållet.';
$string['h5pprivatefile'] = 'Det här H5P-innehållet kan inte visas eftersom du inte har tillgång till .h5p-filen.';
$string['h5psettings'] = 'Inställningar';
$string['h5ptitle'] = 'Besök h5p.org för att se mer innehåll.';
$string['height'] = 'höjd';
$string['helpChoosingLicense'] = 'Hjälp mig välja licenstyp';
$string['hideadvanced'] = 'Dölj avancerade inställningar';
$string['icon'] = 'Ikon';
$string['installedcontentlibraries'] = 'Installerade H5P-bibliotek';
$string['installedcontenttypes'] = 'Installerade H5P-innehållstyper';
$string['installedh5p'] = 'Installerade H5P-resurser';
$string['invalidcontextid'] = 'Kunde inte hitta H5P-fil (ogiltigt kontext-id)';
$string['invalidfile'] = 'Filen "{$a->%filename}" är inte tillåten. Endast filer med följande filändelser tillåts: {$a->%files-allowed}.';
$string['invalidlanguagefile'] = 'Ogiltig språkfil {$a->%file} i biblioteket {$a->%library}';
$string['invalidlanguagefile2'] = 'En ogiltig språkfil {$a->%languageFile} har inkluderats i biblioteket {$a->%name}';
$string['invalidlibrarydata'] = 'Ogiltiga data för egenskap {$a->%property} i {$a->%library}';
$string['invalidlibrarydataboolean'] = 'Ogiltiga data för egenskap {$a->%property} i {$a->%library}. Ett Booleskt värde förväntades.';
$string['invalidlibraryname'] = 'Ogiltigt namn på bibliotek: {$a->%name}';
$string['invalidlibrarynamed'] = 'H5P-biblioteket {$a->%library} som används i innehållet är ogiltigt';
$string['invalidlibraryoption'] = 'Otillåtet alternativ {$a->%option} i {$a->%library}';
$string['invalidlibraryproperty'] = 'Kan inte läsa egenskapen {$a->%property} i {$a->%library}';
$string['invalidmainjson'] = 'En giltig h5p.json huvudfil saknas';
$string['invalidmultiselectoption'] = 'Ogiltigt markerat alternativ i flerval.';
$string['invalidpackage'] = 'Ogiltig H5P-innehållstyp';
$string['invalidselectoption'] = 'Ogiltigt markerat alternativ i markera.';
$string['invalidsemanticsjson'] = 'En ogiltig semantics.json fil har inkluderats i biblioteket {$a->%name}';
$string['invalidsemanticstype'] = 'Internt H5P-fel: Okänd innehållstyp "{$a->@type}" i semantics.json. Tar bort innehåll!';
$string['invalidstring'] = 'Tillhandahållen sträng är inte giltig enligt regexp i Förutsatt sträng är inte giltig enligt regexp i semantik. (värde: "{$a->%value}", regexp: "{$a->%regexp}"). (värde: "{$a->%value}", regexp: "{$a->%regexp}")';
$string['keywords'] = 'Nyckelord';
$string['keywordsPlaceholder'] = 'Lägg till nyckelord';
$string['language'] = 'Språk';
$string['level'] = 'Nivå';
$string['librariesmanagerdescription'] = '<p>H5P gör det möjligt för användare att skapa interaktivt innehåll genom att tillhandahålla ett utbud av innehållstyper.</p>
<p>För att säkerställa att endast betrodda H5P-innehållstyper används på din webbplats behöver du:</p><ul><li>Ladda upp H5P-innehållstyper från h5p.org <i>eller</i></li><li>Aktivera den schemalagda aktiviteten \'Hämta tillgängliga H5P-innehållstyper från h5p.org\'</li></ul><p>Observera att användarna endast kommer att kunna använda de H5P innehållstyper som är installerade på webbplatsen.</p>';
$string['librarydirectoryerror'] = 'Bibliotekskatalogens namn måste matcha machineName eller machineName-majorVersion.minorVersion (från library.json). (Katalog: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['license'] = 'Licens';
$string['licenseCC010'] = 'CC0 1.0 Universal (CC0 1.0) Public Domain Dedication';
$string['licenseCC010U'] = 'CC0 1.0 Universal';
$string['licenseCC10'] = '1.0 Generic';
$string['licenseCC20'] = '2.0 Generic';
$string['licenseCC25'] = '2.5 Generic';
$string['licenseCC30'] = '3.0 Unported';
$string['licenseCC40'] = '4.0 International';
$string['licenseDescription'] = 'Välj en licens för ditt innehåll';
$string['licenseDetails'] = 'Licensdetaljer';
$string['licenseGPL'] = 'General Public License';
$string['licenseV1'] = 'Version 1';
$string['licenseV2'] = 'Version 2';
$string['licenseV3'] = 'Version 3';
$string['licenseVersionDescription'] = 'Välj licensversion';
$string['licensee'] = 'Licensinnehavare';
$string['licenseextras'] = 'Övrig licensinformation';
$string['licenseversion'] = 'Licensversion';
$string['lockh5pdeploy'] = 'Det går inte att komma åt det här H5P-innehållet eftersom det håller på att installeras. Försök igen senare.';
$string['longDescription'] = 'Utförlig beskrivning';
$string['longDescriptionPlaceholder'] = 'Utförlig beskrivning av ditt innehåll';
$string['mainTitle'] = 'Delar <strong>:title</strong>';
$string['mainlibrarydisabled'] = 'Det går inte att visa den här filen eftersom dess innehållstyp är inaktiverad. Kontakta administratören för att be att innehållstypen
aktiveras.';
$string['missingcontentfolder'] = 'En giltig mapp för innehålls saknas';
$string['missingcoreversion'] = 'Systemet kunde inte installera komponenten {$a->%component} från paketet eftersom det kräver en nyare version av H5P-pluginmodulen. Den här webbplatsen kör för närvarande version {$a->%current}, medan den nödvändiga versionen är {$a->%required} eller senare. Vänligen uppgradera och försök sedan igen.';
$string['missingdependency'] = 'Saknat beroende {$a->@dep} som krävs av {$a->@lib}.';
$string['missinglibrary'] = 'Nödvändigt bibliotek {$a->@library} saknas';
$string['missinglibraryfile'] = 'Filen "{$a->%file}" saknas i biblioteket: "{$a->%name}"';
$string['missinglibraryjson'] = 'Kunde inte hitta filen library.json i ett giltigt jsonformat för bibliotek {$a->%name}';
$string['missinglibraryproperty'] = 'Den obligatoriska egenskapen {$a->%property} saknas i {$a->%library}';
$string['missingmbstring'] = 'Den PHP-tillägget mbstring är inte laddat. Det krävs för att H5P ska fungera korrekt.';
$string['missinguploadpermissions'] = 'Observera att biblioteken kan finnas i den fil du har laddat upp, men att du inte får ladda upp nya bibliotek. Kontakta din administratör.';
$string['next'] = 'Nästa';
$string['nocopyright'] = 'Det finns ingen upphovsrättsinformation för detta innehåll.';
$string['noextension'] = 'Filen du laddade upp är inte ett giltigt HTML5-paket. (Den har inte filtillägget .h5p.)';
$string['noh5plibhandlerdefined'] = 'Det finns inte någon ramverkshanterare för H5P installerad. H5P-innehåll kan därför inte visas.';
$string['nojson'] = 'Huvudfilen h5p.json är ogiltig.';
$string['nopermissiontodeploy'] = 'Den här filen kan inte visas eftersom den har laddats upp av en användare utan den nödvändiga behörigheten att distribuera H5P-innehåll.';
$string['nopermissiontoedit'] = 'Du har inte behörighet att redigera H5P-innehåll.';
$string['notrustablefile'] = 'Den här filen kan inte visas eftersom den har laddats upp av en användare utan behörighet att uppdatera H5P-innehållstyper. Kontakta administratören för att be om att innehållstypen ska installeras.';
$string['nounzip'] = 'Filen du laddade upp är inte ett giltigt HTML5-paket. (Det går inte att packa upp den.)';
$string['offlineDialogBody'] = 'Vi kunde inte skicka information om ditt slutförande av denna uppgift. Vänligen kontrollera internetanslutningen.';
$string['offlineDialogHeader'] = 'Anslutningen till servern förlorades';
$string['offlineDialogRetryButtonLabel'] = 'Försök igen';
$string['offlineDialogRetryMessage'] = 'Försöker igen om :num....';
$string['offlineSuccessfulSubmit'] = 'Resultaten skickades.';
$string['optionalInfo'] = 'Valfri information';
$string['originator'] = 'Skapare';
$string['pd'] = 'Public Domain';
$string['pddl'] = 'Public Domain Dedication and Licence';
$string['pdm'] = 'Public Domain Mark (PDM)';
$string['phone'] = 'Telefon';
$string['pleaseWait'] = 'Vänta...';
$string['pluginname'] = 'H5P-paket';
$string['privacy:metadata'] = 'H5P-systemet lagrar ingen användarinformation.';
$string['registrationFailed'] = 'Ett fel inträffade';
$string['remove'] = 'Ta bort';
$string['removeChip'] = 'Ta bort :chip från listan';
$string['removeImage'] = 'Ta bort bild';
$string['requiredInfo'] = 'Obligatorisk information';
$string['resizescript'] = 'Inkludera detta skript på din webbplats om du vill att inbäddat innehåll anpassas automatiskt efter visningsfönstrets storlek:';
$string['resubmitScores'] = 'Försöker skicka in lagrade resultat.';
$string['reuse'] = 'Återanvänd';
$string['reuseContent'] = 'Återanvänd innehåll';
$string['reuseDescription'] = 'Återanvänd detta innehåll.';
$string['reviewAndSave'] = 'Granska & spara';
$string['reviewAndShare'] = 'Granska & dela';
$string['reviewInfo'] = 'Granska information';
$string['saveChanges'] = 'Spara ändringar';
$string['screenshots'] = 'Skärmbilder';
$string['share'] = 'Dela';
$string['shareFailed'] = 'Delningen misslyckades.';
$string['shared'] = 'Delad';
$string['shortDescription'] = 'Kort beskrivning';
$string['shortDescriptionPlaceholder'] = 'Kort beskrivning av innehåller';
$string['showadvanced'] = 'Visa avancerade inställningar';
$string['showless'] = 'Visa mindre';
$string['showmore'] = 'Visa mer';
$string['size'] = 'Storlek';
$string['someKeywordsExits'] = 'Några av de här nyckelorden finns redan';
$string['source'] = 'Källa';
$string['startingover'] = 'Du kommer att börja om från början.';
$string['status'] = 'Status';
$string['sublevel'] = 'Undernivå';
$string['submitted'] = 'Inskickad!';
$string['task_h5p'] = 'Schemalagd H5P-uppgift';
$string['task_h5p_description'] = 'Den schemalagda uppgiften hämtar tillgängliga H5P-innehållstyper från h5p.org.';
$string['thumbnail'] = 'Tumnagel';
$string['title'] = 'Titel';
$string['undisclosed'] = 'Hemlig';
$string['unpackedFilesExceedsMaxSize'] = 'Den totala storleken på de uppackade filerna överskrider den tillåtna maxstorleken. ({$a->%used} > {$a->%max})';
$string['updatedlibraries'] = 'Uppdaterade {$a->%old} H5P-bibliotek.';
$string['updatedlibrary'] = 'Uppdaterade {$a->%old} H5P-bibliotek.';
$string['uploadlibraries'] = 'Ladda upp H5P-innehållstyper';
$string['uploadsuccess'] = 'Innehållstyperna har laddats upp';
$string['wrongversion'] = 'Den version av H5P-biblioteket {$a->%machineName} som används i det här innehållet är inte giltigt. Innehållet innehåller {$a->%contentLibrary}, men det skulle vara {$a->%semanticsLibrary}.';
$string['year'] = 'År';
$string['years'] = 'År';
$string['yearsfrom'] = 'År (från)';
$string['yearsto'] = 'År (till)';
