<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'sv', version '4.4'.
 *
 * @package     moodle
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'på väg att installeras';
$string['accept'] = 'Acceptera';
$string['action'] = 'Åtgärd';
$string['actionchoice'] = 'Vad vill du göra med filen \'{$a}\'?';
$string['actions'] = 'Åtgärder';
$string['actionsfor'] = 'Åtgärder för {$a}';
$string['actionsmenu'] = 'Åtgärdsmeny';
$string['active'] = 'Aktiv';
$string['activeusers'] = 'Aktiva användare';
$string['activities'] = 'Aktiviteter';
$string['activities_help'] = 'Aktiviteter, såsom forum, quizzar och wikis, aktiverar interaktivt innehåll som kan läggas till kursen.';
$string['activity'] = 'Aktivitet';
$string['activityclipboard'] = 'Flyttar denna aktivitet: {$a}';
$string['activityheader'] = 'Aktivitetsmeny';
$string['activityicon'] = '{$a} ikon';
$string['activityiscurrentlyhidden'] = 'Tyvärr, den här aktiviteten är för tillfället dold';
$string['activitymodule'] = 'Aktivitetsmodul';
$string['activitymodules'] = 'Aktivitetsmoduler';
$string['activitynotready'] = 'Aktiviteten är inte klar ännu';
$string['activityreport'] = 'Aktivitetsrapport';
$string['activityreports'] = 'Aktivitetsrapporter';
$string['activityselect'] = 'Välj den här aktiviteten och flytta den någon annanstans';
$string['activitysince'] = 'Aktiviteter sedan {$a}';
$string['activitytypetitle'] = '{$a->activity} - {$a->type}';
$string['activityweighted'] = 'Aktivitet per användare';
$string['add'] = 'Lägg till';
$string['addactivity'] = 'Lägg till en aktivitet...';
$string['addactivitytosection'] = 'Lägg en aktivitet i sektion \'{$a}\'';
$string['addadmin'] = 'Lägg till administratör';
$string['addblock'] = 'Lägg till ett block';
$string['addcomment'] = 'Lägg till kommentar...';
$string['addcondition'] = 'Lägg till villkor';
$string['addcountertousername'] = 'Skapa en användare genom att lägga till ett tal till användarnamnet';
$string['addcreator'] = 'Lägg till kursutvecklare';
$string['adddots'] = 'Lägg till...';
$string['added'] = 'Lade till {$a}';
$string['addedtogroup'] = 'Lade till till grupp "{$a}"';
$string['addedtogroupnot'] = 'Inte tillagd till grupp "{$a}"';
$string['addedtogroupnotenrolled'] = 'Ej tillagd i {$a}-gruppen eftersom användaren inte är registrerad på kursen';
$string['addfilehere'] = 'Lägg till fil(er) här för att placera dem längst ner i sektionen';
$string['addfilesdrop'] = 'Du kan dra och släppa filer här för att ladda upp eller klicka för att välja.';
$string['addinganew'] = 'Ny {$a}';
$string['addinganewto'] = 'Lägger till en ny {$a->what} till {$a->to}';
$string['addingdatatoexisting'] = 'Lägger till data till befintlig';
$string['additionalcustomnav'] = 'Ytterligare anpassad navigering';
$string['additionalnames'] = 'Ytterligare namn';
$string['addlinkhere'] = 'Lägg till länk här';
$string['addnew'] = 'Lägg till ny {$a}';
$string['addnewcategory'] = 'Lägg till ny kategori';
$string['addnewcourse'] = 'Lägg till ny kurs';
$string['addnewuser'] = 'Lägg till ny användare';
$string['addnousersrecip'] = 'Lägg till användare som inte har har besökt den här {$a} till listan över mottagare';
$string['addpagehere'] = 'Lägg till text här';
$string['addresource'] = 'Lägg till resurs...';
$string['addresourceoractivity'] = 'Lägg till aktivitet eller resurs';
$string['addresourcetosection'] = 'Lägg till en resurs i avsnitt \'{$a}\'';
$string['address'] = 'Adress';
$string['addsections'] = 'Lägg till avsnitt';
$string['addstudent'] = 'Lägg till student';
$string['addsubcategory'] = 'Lägg till underkategori';
$string['addteacher'] = 'Lägg till lärare';
$string['admin'] = 'Administration';
$string['adminhelpaddnewuser'] = 'För att skapa ett nytt användarkonto manuellt';
$string['adminhelpassignadmins'] = 'Administratörer kan göra vad som helst och har tillgång till hela webbplatsen';
$string['adminhelpassigncreators'] = 'Kursutvecklare kan skapa nya kurser';
$string['adminhelpassignsiteroles'] = 'Tillämpa definerade webbplatsroller åt specifika användare';
$string['adminhelpassignstudents'] = 'Gå in i en kurs och lägg till studenter från menyn för administration';
$string['adminhelpauthentication'] = 'Du kan använda interna användarkonton eller externa databaser';
$string['adminhelpbackup'] = 'Konfigurera automatisk säkerhetskopiering och dess schema';
$string['adminhelpconfiguration'] = 'Konfigurera hur webbplatsen ser ut och fungerar';
$string['adminhelpconfigvariables'] = 'Konfigurera variabler som påverkar webbplatsen på ett övergripande sätt';
$string['adminhelpcourses'] = 'Definiera kurser och kategorier, tilldela personer till dem, redigera väntande kurser';
$string['adminhelpeditorsettings'] = 'Ange grundläggande inställningar för HTML-redigeraren';
$string['adminhelpedituser'] = 'Gå igenom listan över konton och
redigera valfritt konto';
$string['adminhelpenvironment'] = 'Kontrollera hur servern uppfyller nuvarande och framtida installationskrav';
$string['adminhelpfailurelogs'] = 'Gå igenom loggarna för misslyckade inloggningar';
$string['adminhelplanguage'] = 'För att kontrollera och redigera det aktuella språkpaketet';
$string['adminhelplogs'] = 'Gå igenom loggarna för alla aktivitet på webbplatsen';
$string['adminhelpmanageblocks'] = 'Hantera installerade block och deras inställningar';
$string['adminhelpmanagedatabase'] = 'Direkt åtkomst till databasen (var försiktig!)';
$string['adminhelpmanagefilters'] = 'Välj textfilter och relaterade inställningar';
$string['adminhelpmanagemodules'] = 'Administrera installerade moduler och deras inställningar';
$string['adminhelpmanageroles'] = 'Skapa och definiera roller som kan tillämpas för användare';
$string['adminhelpmymoodle'] = 'Konfigurera användarblock på översiktssidan';
$string['adminhelpreports'] = 'Rapporter på webbplatsnivå';
$string['adminhelpsitefiles'] = 'För att publicera allmänna filer eller ladda upp externa säkerhetskopior';
$string['adminhelpsitesettings'] = 'Definiera hur startsidan på webbplatsen ser ut';
$string['adminhelpstickyblocks'] = 'Konfigurera fasta block som gäller för hela Moodle';
$string['adminhelpthemes'] = 'Välj hur webbplatsen ska se ut (färger, typsnitt osv)';
$string['adminhelpuploadusers'] = 'Importera nya användarkonton från en textfil';
$string['adminhelpusers'] = 'Definiera dina användare och sätt upp autentisering';
$string['adminhelpxmldbeditor'] = 'Gränssnitt för att redigera XMLDB-filerna. Endast för utvecklare.';
$string['administration'] = 'Administration';
$string['administrationsite'] = 'Hantera webbplats';
$string['administrator'] = 'Administratör';
$string['administratordescription'] = 'Administratörer kan normalt sett göra allt på webbplatsen, i alla kurser.';
$string['administrators'] = 'Administratörer';
$string['administratorsall'] = 'Alla administratörer';
$string['administratorsandteachers'] = 'Administratörer och lärare';
$string['advanced'] = 'Avancerat';
$string['advancedfilter'] = 'Avancerad sökning';
$string['advancedsettings'] = 'Avancerade inställningar';
$string['afterresource'] = 'Efter resurs "{$a}"';
$string['aftersection'] = 'Efter avsnitt "{$a}"';
$string['again'] = 'igen';
$string['agelocationverification'] = 'Ålder- och platsverifiering';
$string['ajaxuse'] = 'AJAX och Javascript';
$string['all'] = 'Alla';
$string['allactions'] = 'Alla åtgärder';
$string['allactivities'] = 'Alla aktiviteter';
$string['allcategories'] = 'Alla kategorier';
$string['allchanges'] = 'Alla ändringar';
$string['alldays'] = 'Alla dagar';
$string['allfiles'] = 'Alla filer';
$string['allgroups'] = 'Alla grupper';
$string['alllogs'] = 'Alla loggar';
$string['allmods'] = 'Alla {$a}';
$string['allow'] = 'Tillåt';
$string['allowinternal'] = 'Tillåt även interna metoder.';
$string['allownone'] = 'Tillåt inga';
$string['allownot'] = 'Tillåt inte';
$string['allowstealthmodules'] = 'Tillåt osynliga aktiviteter';
$string['allowstealthmodules_help'] = 'Om aktiverad kan aktiviteter göras tillgängliga, men vara osynliga, i avsnitt på kurssidan. Om så måste länkar till de osynliga aktiviteterna tillhandahållas från annat håll, till exempel från en sidresurs. Osynliga aktiviteter är fortfarande synliga i betygsböcker och andra rapporter.';
$string['allparticipants'] = 'Alla deltagare';
$string['allteachers'] = 'Alla lärare';
$string['alphanumerical'] = 'Kan endast innehålla alfanumeriska tecken, bindestreck (-) eller punkt (.)';
$string['alreadyconfirmed'] = 'Registreringen har redan bekräftats.';
$string['alternatename'] = 'Alternativt namn';
$string['always'] = 'Alltid';
$string['and'] = '{$a->one} och  {$a->two}';
$string['answer'] = 'Svar';
$string['any'] = 'Någon';
$string['appearance'] = 'Utseende';
$string['apply'] = 'Använd';
$string['applyfilters'] = 'Använd filter';
$string['approve'] = 'Godkänn';
$string['areyousure'] = 'Är du säker?';
$string['areyousuretorestorethis'] = 'Vill du fortsätta?';
$string['areyousuretorestorethisinfo'] = 'Senare i den här processen kommer du att kunna välja om du vill lägga till den här säkerhetskopieringen till en befintlig kurs eller om du vill skapa en helt ny kurs.';
$string['asc'] = 'Stigande';
$string['assessment'] = 'Bedömning';
$string['assignadmins'] = 'Tilldela administratörer';
$string['assigncreators'] = 'Tilldela kursutvecklare';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Tilldela webbplatsövergripande roller';
$string['authenticateduser'] = 'Inloggad användare';
$string['authenticateduserdescription'] = 'Alla inloggade användare';
$string['authentication'] = 'Autentisering';
$string['authenticationplugins'] = 'Pluginmoduler för autentisering';
$string['autosubscribe'] = 'Automatisk prenumeration på forum';
$string['autosubscribeno'] = 'Nej: anmäl mig inte automatiskt som prenumerant på forumdiskussioner';
$string['autosubscribeyes'] = 'Ja, registrera mig som prenumerant när jag gör ett inlägg i forumet';
$string['availability'] = 'Tillgänglighet';
$string['availablecourses'] = 'Kursutbud';
$string['back'] = 'Tillbaka';
$string['backto'] = 'Tillbaka till {$a}';
$string['backtocourselisting'] = 'Tillbaka till kurslistan';
$string['backtohome'] = 'Tillbaka till startsidan';
$string['backtopageyouwereon'] = 'Tillbaka till föregående sida';
$string['backup'] = 'Säkerhetskopiera';
$string['backupactivehelp'] = 'Välj huruvida du vill ställa in automatisk säkerhetskopiering eller inte.';
$string['backupadhocpending'] = 'Väntande ad-hoc säkerhetskopiering (kurs)';
$string['backupcancelled'] = 'Säkerhetskopieringen avbröts';
$string['backupcoursefileshelp'] = 'Om den här inställningen är aktiverad så kommer kursfilerna automatiskt att tas med i säkerhetskopieringarna.';
$string['backupdate'] = 'Datum för säkerhetskopiering';
$string['backupdatenew'] = '&nbsp; {$a->TAG} är nu {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} var {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Detaljer för säkerhetskopia';
$string['backuperrorinvaliddestination'] = 'Målkatalogen för säkerhetskopiering finns inte eller så är den inte skrivbar.';
$string['backupexecuteathelp'] = 'Välj vid vilken tid automatiska säkerhetskopieringar ska genomföras.';
$string['backupfailed'] = 'Vissa kurser sparades inte!';
$string['backupfilename'] = 'säkerhetskopia';
$string['backupfinished'] = 'Säkerhetskopieringen slutfördes';
$string['backupfromthissite'] = 'Har den den här webbplatsen säkerhetskopierats?';
$string['backupgradebookhistoryhelp'] = 'Om detta är aktiverat kommer historiken för betygskatalogen att ingå i automatiska säkerhetskopieringar. Observera att du inte behöver inaktivera historiken för betygssättningen i inställningarna för servern (disablegradehistory) för att detta ska fungera.';
$string['backupincludemoduleshelp'] = 'För att välja om du vill ta med kursmoduler med eller utan användardata i säkerhetskopieringen.';
$string['backupincludemoduleuserdatahelp'] = 'Välj huruvida Du vill ta med användardata för modul i automatiska säkerhetskopieringar.';
$string['backupinfo'] = 'Gör en kopia av den här kursen, inklusive allt innehåll och all aktivitet hittills. Du kan använda säkerhetskopian för att återställa kursen.';
$string['backuplogdetailed'] = 'Detaljerad körningslogg';
$string['backuploglaststatus'] = 'Senaste körningsloggen';
$string['backupmissinguserinfoperms'] = 'Obs: Denna säkerhetskopia innehåller inga användardata. Övnings och Workshop aktiviteterna kommer inte att ingå i säkerhetskopian, eftersom dessa moduler inte är kompatibla med den här typen av säkerhetskopiering.';
$string['backupnext'] = 'Nästa säkerhetskopiering';
$string['backupnonisowarning'] = 'Varning: den här säkerhetskopian kommer från en icke-Unicode version av Moodle (äldre än 1.6). Om den här säkerhetskopian innehåller några icke-ISO-8859-1 texter kan de SKADAS om du försöker återställa dem till denna Unicode-version av Moodle. Se <a href="https://docs.moodle.org/sv/Backup_FAQ">Backup FAQ</a> mer information om hur du återställer säkerhetskopian korrekt.';
$string['backupnotyetrun'] = 'Väntande säkerhetskopiering';
$string['backuporiginalname'] = 'Namn på säkerhetskopia';
$string['backuproleassignments'] = 'Säkerhetskopiera rolltilldelningarna för dessa roller';
$string['backupsavetohelp'] = 'Hela sökvägen till katalogen där du vill spara säkerhetskopiorna. Lämna fältet tomt om du vill spara dem i standardkatalogen.';
$string['backupsitefileshelp'] = 'Om detta är aktiverat så kommer de filer på webbplatsen som används i kurser att  tas med vid automatisk säkerhetskopiering.';
$string['backuptakealook'] = 'Kontrollera loggen:
  {$a}';
$string['backupuserfileshelp'] = 'Välj om Du vill ta med användarfiler (avatarer eller bilder ur profilen) i den automatiska säkerhetskopieringen.';
$string['backupversion'] = 'Säkerhetskopieversion';
$string['badges'] = 'Märken';
$string['block'] = 'Block';
$string['blockconfiga'] = 'Konfigurerar blocket {$a}';
$string['blockconfigbad'] = 'Det här blocket har inte implementerats på ett korrekt sätt och kan därför inte erbjuda något gränssnitt för konfiguration.';
$string['blocks'] = 'Block';
$string['blocks_main'] = 'Huvudinnehållsblock';
$string['blocks_supplementary'] = 'Kompletterande block';
$string['blocksaddedit'] = 'Lägg till/redigera block';
$string['blockseditoff'] = 'Avsluta redigering';
$string['blocksediton'] = 'Redigera block';
$string['blocksetup'] = 'Sätter upp tabeller för block';
$string['blocksuccess'] = '{$a} tabeller har satts upp korrekt';
$string['brief'] = 'Kortfattat';
$string['bulkactions'] = 'Massåtgärder';
$string['bulkactionselect'] = '{$a} bulk åtgärdsval';
$string['bulkcancel'] = 'Stäng massredigeringen';
$string['bulkmovecoursessuccess'] = 'Framgångsrikt flyttat {$a->courses} kurser till {$a->category}';
$string['bulkselection'] = '{$a} har valts';
$string['bycourseorder'] = 'Ordna enligt kurser';
$string['byname'] = 'av {$a}';
$string['bypassed'] = 'Förbikopplad';
$string['cachecontrols'] = 'Cachekontroll';
$string['calltofeedback'] = 'Skaparna av denna mjukvara skulle vilja ha din feedback.';
$string['calltofeedback_give'] = 'Ge feedback på denna mjukvara.';
$string['calltofeedback_remind'] = 'Påminn mig senare';
$string['cancel'] = 'Avbryt';
$string['cancelled'] = 'Avbruten';
$string['categories'] = 'Kurskategorier';
$string['categoriesandcourses'] = 'Kurskategorier och kurser';
$string['category'] = 'Kategori';
$string['categoryadded'] = 'Kategorin \'{$a}\' lades till';
$string['categorybulkaction'] = 'Bulk åtgärdsval för valda kategorier';
$string['categorycontents'] = 'Underkategorier och kurser';
$string['categorycurrentcontents'] = 'Innehåll i {$a}';
$string['categorydeleted'] = 'Kategorin \'{$a}\' togs bort';
$string['categoryduplicate'] = 'Kategorin \'{$a}\' finns redan!';
$string['categoryheader'] = 'Kategorimeny';
$string['categoryhidden'] = '(dold)';
$string['categorymodifiedcancel'] = 'Kategorin har modifierats! Vänligen avbryt och försök igen.';
$string['categoryname'] = 'Namn på kategori';
$string['categorypath'] = 'Kategorisökväg';
$string['categorysubcategoryof'] = '{$a->category} - underkategori av {$a->parentcategory}';
$string['categoryupdated'] = 'Kategorin \'{$a}\' uppdaterades';
$string['changedpassword'] = 'Ändrat lösenord';
$string['changepassword'] = 'Ändra lösenord';
$string['changesmade'] = 'Ändringar gjorda';
$string['changesmadereallygoaway'] = 'Du har gjort ändringar. Vill du lämna sidan och förlora dina ändringar?';
$string['changessaved'] = 'Ändringar sparade';
$string['check'] = 'Kontrollera';
$string['checkactual'] = 'Faktisk';
$string['checkall'] = 'Kontrollera alla';
$string['checkerror'] = 'Det gick inte att hämta resultatet av kontrollen \'{$a}\'. Kontrollera webbläsarkonsolen för mer information.';
$string['checkexpected'] = 'Förväntad';
$string['checkingbackup'] = 'Kontrollerar säkerhetskopia';
$string['checkingcourse'] = 'Kontrollerar kurs';
$string['checkingforbbexport'] = 'Kontrollerar BlackBoard-export';
$string['checkinginstances'] = 'Kontrollerar instanser';
$string['checkingsections'] = 'Kontrollerar sektioner';
$string['checklanguage'] = 'Kontrollera språk';
$string['checkloading'] = 'Får resultatet av kontrollen \'{$a}\'';
$string['checknone'] = 'Kontrollera inte någon';
$string['checks'] = 'Kontroller';
$string['checksok'] = 'Alla \'{$a}\'-kontroller är OK';
$string['childcoursenotfound'] = 'Underkurs hittades inte';
$string['childcourses'] = 'Underkurser';
$string['choose'] = 'Välj';
$string['choosecourse'] = 'Välj en kurs';
$string['choosedots'] = 'Välj...';
$string['chooselivelogs'] = 'Eller se på nuvarande aktivitet';
$string['chooselogs'] = 'Välj loggar att visa';
$string['choosereportfilter'] = 'Välj ett filter för rapporten';
$string['choosetheme'] = 'Välj layouttema';
$string['chooseuser'] = 'Välj en användare';
$string['city'] = 'Stad';
$string['cleaningtempdata'] = 'Tömmer tillfälliga data';
$string['clear'] = 'Rensa';
$string['clearfilterrow'] = 'Ta bort filterrad';
$string['clearfilters'] = 'Rensa filter';
$string['clearsearch'] = 'Rensa sökfältet';
$string['clickhelpiconformoreinfo'] = '... fortsätter ... Klicka på ikonen för hjälp för att läsa hela artikeln';
$string['clickhere'] = 'Klicka här...';
$string['clicktochangeinbrackets'] = '{$a} (Klicka för att ändra)';
$string['clicktohideshow'] = 'Klicka för att expandera eller fälla ihop';
$string['closeblockdrawer'] = 'Stäng blockmeny';
$string['closebuttontitle'] = 'Stäng';
$string['closecourseindex'] = 'Stäng kursindex';
$string['closedrawer'] = 'Stäng meny';
$string['closewindow'] = 'Stäng detta fönster';
$string['collapse'] = 'Fäll ihop';
$string['collapseall'] = 'Fäll ihop allt';
$string['collapsecategory'] = 'Komprimera {$a}';
$string['comebacklater'] = 'Vänligen återkom senare.';
$string['commentincontext'] = 'Hitta den här kommentaren i sitt sammanhang';
$string['comments'] = 'Kommentarer';
$string['commentscount'] = 'Kommentarer ({$a})';
$string['commentsnotenabled'] = 'Kommentar funktionaliteten är inte aktiverad.';
$string['commentsrequirelogin'] = 'Du måste logga in för att se kommentarerna';
$string['comparelanguage'] = 'Jämför och redigera det aktuella språket.';
$string['complete'] = 'Komplett';
$string['completed'] = 'Slutförd';
$string['completereport'] = 'Fullständig rapport';
$string['configuration'] = 'Konfiguration';
$string['confirm'] = 'Bekräfta';
$string['confirmaccount'] = 'Bekräfta konto';
$string['confirmcheckfull'] = 'Är Du helt säker på att Du vill bekräfta {$a} ?';
$string['confirmcoursemove'] = 'Är du säker på att du vill flytta den här kursen ({$a->course}) in i den här kategorin ({$a->category})?';
$string['confirmdeletesection'] = 'Är du helt säker på att du vill ta bort "{$a}" fullständigt och alla aktiviteter den innehåller?';
$string['confirmed'] = 'Din registrering har blivit bekräftad.';
$string['confirmednot'] = 'Din registrering har inte blivit bekräftad ännu. V.g. kolla din e-post om du har fått ett bekräftelsemejl.';
$string['considereddigitalminor'] = 'Du är för ung för att skapa ett konto på denna webbplats.';
$string['content'] = 'Innehåll';
$string['contentbank'] = 'Innehållsbank';
$string['contentexport_aboutthiscourse'] = 'Kursöversikt';
$string['contentexport_coursesummary'] = 'Den här filen är en del av innehållet som laddats ned från <a href="{$a->courselink}">{$a->coursename}</a>.';
$string['contentexport_footersummary'] = 'Den här filen är en del av innehållet som laddats ned från <a href="{$a->courselink}">{$a->coursename}</a> av {$a->userfullname} den {$a->date}.';
$string['contentexport_modulesummary'] = 'Den här sidan är en del av innehållet som laddats ned från <a href="{$a->modulelink}">{$a->modulename}</a> den {$a->date}. Observera att visst innehåll och eventuella filer som är större än {$a->maxfilesize} inte hämtas.';
$string['contentexport_viewfilename'] = 'Visa filen {$a}';
$string['context'] = 'Kontext';
$string['contextlevel'] = 'Kontextnivå';
$string['contextname'] = 'Kontextnamn';
$string['contextparent'] = 'Förälder';
$string['contexturl'] = 'Kontext-URL';
$string['continue'] = 'Fortsätt';
$string['continuetocourse'] = 'Klicka här för få tillträde till din kurs.';
$string['convertingwikitomarkdown'] = 'Konverterar Wiki till Markdown-format';
$string['cookiesenabled'] = 'Du måste tillåta <em>Cookies</em> i din webbläsare';
$string['cookiesenabled_help'] = 'Två cookies används på denna webbplats:

Den väsentliga är sessionscookien, vanligen kallad <em>MoodleSession</em>. Du måste tillåta denna cookie i din webbläsare för att få kontinuitet och för att förbli inloggad när du surfar på webbplatsen. När du loggar ut eller stänger webbläsaren förstörs denna cookie (både i din webbläsare och på servern).

Den andra cookien (vanligen kallad <em>MOODLEID</em>) är enbart till för din bekvämlighet. Den används för att komma ihåg ditt användarnamn i webbläsaren. Det innebär att när du återvänder till den här webbplatsen är fältet för användarnamn redan ifyllt åt dig på inloggningssidan. Det är säkert att vägra denna cookie - det enda som då händer är att du behöver ange ditt användarnamn varje gång du loggar in.';
$string['cookiesenabled_help_html'] = 'Två cookies används på denna webbplats:<br/><br/>

Den viktigaste är sessionscookien, vanligtvis kallad <em>MoodleSession</em>. Du måste tillåta denna cookie i din webbläsare för kontinuitet och för att förbli inloggad när du surfar på webbplatsen. När du loggar ut eller stänger webbläsaren förstörs denna cookie (i din webbläsare och på servern).<br/><br/>

Den andra cookien används enbart för din bekvämlighet. Denna cookie heter vanligtvis <em>MOODLEID</em> eller något liknande. Den används enbart för att komma ihåg ditt användarnamn i webbläsaren. Detta innebär att när du återvänder till den här webbplatsen är användarnamnsfältet på inloggningssidan redan ifyllt åt dig. Det är ingen fara att vägra denna cookie - det som då händer är bara att du måste skriva in ditt användarnamn varje gång du loggar in.';
$string['cookiesenabledonlysession'] = 'Du måste tillåta <em>Cookies</em> i din webbläsare';
$string['cookiesenabledonlysession_help'] = 'Den här webbplatsen använder en sessionscookie, vanligtvis kallad <em>MoodleSession</em>. Du måste tillåta denna cookie i din webbläsare för kontinuitet och för att förblir inloggad när du surfar på webbplatsen. När du loggar ut eller stänger webbläsaren förstörs denna cookie (i din webbläsare och på servern).';
$string['cookiesnotenabled'] = 'Cookies är inte aktiverade i din webbläsare';
$string['cookiesnotice'] = 'Information om cookies';
$string['copy'] = 'Kopiera';
$string['copyasnoun'] = 'kopiera';
$string['copycourse'] = 'Kopiera kurs';
$string['copyingcoursefiles'] = 'Kopierar kursfiler...';
$string['copyingsitefiles'] = 'Kopierar filer på webbplatsen som används i kurs';
$string['copyinguserfiles'] = 'Kopierar användarfiler...';
$string['copyingzipfile'] = 'Kopierar ZIP-fil...';
$string['copyrightnotice'] = 'Copyrightmeddelande';
$string['copytoclipboard'] = 'Kopiera till urklipp';
$string['coresystem'] = 'System';
$string['cost'] = 'Kostnad';
$string['costdefault'] = 'Standardkostnad';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Land';
$string['course'] = 'Kurs';
$string['courseadministration'] = 'Kursadministration';
$string['courseapprovedemail'] = 'Den kurs du har efterfrågat, <a href="{$a->url}">{$a->name}</a>, har godkänts och du har gjorts till {$a->teacher} för den';
$string['courseapprovedemail2'] = 'Den kurs du har efterfrågat, {$a->name}, har godkänts:  <a href="{$a->url}">{$a->name}</a>.';
$string['courseapprovedfailed'] = 'Det gick inte att spara kursen som godkänd!';
$string['courseapprovedsubject'] = 'Din kurs har blivit godkänd!';
$string['courseavailable'] = 'Den här kursen är tillgänglig för studenter.';
$string['courseavailablenot'] = 'Den här kursen är inte tillgänglig för studenter.';
$string['coursebackup'] = 'Säkerhetskopiering av kurs';
$string['coursebulkaction'] = 'Bulk åtgärdsval för valda kurser';
$string['coursecategories'] = 'Kurskategorier';
$string['coursecategory'] = 'Kurskategori';
$string['coursecategory_help'] = 'Den här inställningen bestämmer kategorin under vilken kursen visas i kurslistan.';
$string['coursecategorydeleted'] = 'Tog bort kurskategorin {$a}';
$string['coursecatmanagement'] = 'Kurs- och kategorihantering';
$string['coursecompletion'] = 'Slutförande av kurs';
$string['coursecompletions'] = 'Slutförande av kurser';
$string['coursecreators'] = 'Kursutvecklare';
$string['coursecreatorsdescription'] = 'Kursutvecklare kan skapa nya kurser.';
$string['coursedeleted'] = 'Tog bort kursen {$a}';
$string['coursedetails'] = 'Kursdetaljer';
$string['coursedisplay'] = 'Kurslayout';
$string['coursedisplay_help'] = 'Kursavsnitt kan visas på en sida eller delas upp på flera sidor.';
$string['coursedisplay_multi'] = 'Visa en sektion per sida';
$string['coursedisplay_single'] = 'Visa alla sektioner på en stor sida.';
$string['courseduration'] = 'Kurslängd';
$string['courseduration_desc'] = 'Kursens varaktighet används för att räkna ut det standardmässiga slutdatumet för kursen. Kursens slutdatum avgör om en kurs visas i en användares kurslista eller ej. Det kan även användas för att anpassa rapporter. Användare kan komma in i kursen även när slutdatumet har passerats.';
$string['courseenddateenabled'] = 'Kursens slutdatum är aktiverat som standard';
$string['courseenddateenabled_desc'] = 'Denna inställning avgör om kursens slutdatum kommer att aktiveras som standard för nya kurser och ställs in på det datum som beräknas utifrån kursens längd.';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Kursfiler i äldre format';
$string['coursefilesedit'] = 'Redigera kursfiler i äldre format';
$string['coursefileswarning'] = 'Kursfilerna är föråldrade';
$string['coursefileswarning_help'] = 'Kursfiler används inte sedan Moodle 2,0, använd externa arkiv istället så mycket som möjligt.';
$string['courseformatdata'] = 'Data för kursformat';
$string['courseformatoptions'] = 'Formateringsalternativ för {$a}';
$string['courseformats'] = 'Kursformat';
$string['courseformatudpate'] = 'Uppdatera format';
$string['coursegrades'] = 'Kursbetyg';
$string['courseheader'] = 'Kursmeny';
$string['coursehelpcategory'] = 'Positionera kursen i kurslistan och gör det lättare för kursdeltagare att hitta den.';
$string['coursehelpforce'] = 'Tvinga kursens gruppläge till varje aktivitet i kursen.';
$string['coursehelpformat'] = 'Kursens huvudsida kommer att visas i detta format.';
$string['coursehelphiddensections'] = 'Hur de dolda sektionerna i kursen ska visas för studenter.';
$string['coursehelpmaximumupload'] = 'Ange en maximal storlek för de filer som kan laddas upp till den här kursen. Detta anger en begränsning som gäller för hela webbplatsen.';
$string['coursehelpnewsitemsnumber'] = 'Antal senaste nyheter från nyhetsforumet som visas i blocket för senaste nytt på kurssidan. Om satt till noll så visas inte blocket.';
$string['coursehelpnumberweeks'] = 'Antal sektioner i kursen (enbart applicerbart på vissa kursformat).';
$string['coursehelpshowgrades'] = 'Aktivera visning av betygsboken. Detta förhindrar inte att betyg visas för de individuella aktiviteterna.';
$string['coursehidden'] = 'Den här kursen är inte tillgänglig för studenter.';
$string['courseinfo'] = 'Kursinformation';
$string['courselegacyfiles'] = 'Kursfiler i äldre format';
$string['courselegacyfiles_help'] = 'Lagringsytan för kursfiler erbjuder viss bakåtkompatibilitet med Moodle 1.9 och tidigare. Alla filer på denna plats är alltid tillgängliga för alla deltagare i kursen (oavsett om du länkar till dem eller inte) och det finns inget sätt att veta var någon av dessa filer används i Moodle.

Om du använder den här platsen för att lagra kursfiler kan du utsätta dig för ett antal integritets- och säkerhetsproblem samt uppleva saknade filer i säkerhetskopior, kursimporter och när innehåll delas eller används igen. Det är därför rekommenderat att inte använda denna plats såvida du inte verkligen vet vad du gör.';
$string['courselegacyfiles_link'] = 'coursefiles2';
$string['courselegacyfilesofcourse'] = 'Äldre kursfiler: {$a}';
$string['coursenotaccessible'] = 'Den här kursen tillåter inte publik åtkomst';
$string['courseoverview'] = 'Kursöversikt';
$string['courseoverviewfiles'] = 'Kursbild';
$string['courseoverviewfiles_help'] = 'Kursbilden visas i Mina kurser och i listan över tillgängliga kurser på Hem-sidan. Webbplatsadministratörer kan aktivera ytterligare filtyper och användning av flera filer. Om du använder flera filer kommer de alla att visas i listan över tillgängliga kurser på startsidan.';
$string['courseoverviewfilesext'] = 'Filändelser för kursbilder';
$string['courseoverviewfileslimit'] = 'Maximalt antal filer för kursbilder';
$string['courseoverviewgraph'] = 'Kursöversiktsgraf';
$string['courseprofiles'] = 'Kursprofiler';
$string['coursereasonforrejecting'] = 'Orsaker till att du avslår denna förfrågan';
$string['coursereasonforrejectingemail'] = 'Detta kommer att skickas till med e-post till den som har gjort förfrågan.';
$string['coursereject'] = 'Avvisa kursförfrågan';
$string['courserejected'] = 'Kursförfrågan har avvisats och den som gjort förfrågan har fått meddelande om detta.';
$string['courserejectemail'] = 'Din förfrågan om en kurs har avvisats av följande skäl:

{$a}';
$string['courserejectreason'] = 'Ange dina skäl för att avvisa den här kursen<br />(detta kommer att skickas via e-post till beställaren)';
$string['courserejectsubject'] = 'Din kursförfrågan har avvisats';
$string['coursereport'] = 'Kursrapport';
$string['coursereports'] = 'Kursrapporter';
$string['courserequest'] = 'Ansökan om kurs';
$string['courserequestdetails'] = 'Detaljer angående den kurs du efterfrågar';
$string['courserequestfailed'] = 'Av samma anledning gick det inte att spara din ansökan om en kurs.';
$string['courserequestintro'] = 'Använd det här formuläret för att ansöka om att en kurs ska skapas för dig.<br />Försök att fylla i så mycket information som möjligt för<br />att underlätta för administratörerna att förstå varför du vill ha denna kurs.';
$string['courserequestreason'] = 'Skäl för att du vill ha den här kursen.';
$string['courserequestroleerror'] = 'Skaparnas roll i nya kurser är ogiltig. Se <a href="{$a}">användarpolicyn</a>.';
$string['courserequestsuccess'] = 'Din kursansökan har skickats.';
$string['courserequestsupport'] = 'Kompletterande information för att underlätta för administratören att utvärdera denna förfrågan.';
$string['courserequestwarning'] = 'Användaren som begär denna kurs kommer automatisk att registreras och tilldelas rollen som {$a}.';
$string['courserestore'] = 'Återställ kurs';
$string['coursereuse'] = 'Återanvändning av kurs';
$string['coursereusenavigationmenu'] = 'Navigeringsmeny för återanvändning av kurs';
$string['courses'] = 'Kurser';
$string['coursesearch'] = 'Sök kurser';
$string['coursesearch_help'] = 'Du kan söka efter flera ord samtidigt och kan förfina sökningen på följande sätt:

* ord - hitta någon förekomst av detta ord i texten
* +word - endast exakta matchande ord kommer att hittas
* -word - inkludera inte resultat som innehåller det här ordet';
$string['coursesectionsummaries'] = 'Sammanfattningar för kursavsnitt';
$string['coursesectiontitle'] = '{$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitlebulkediting'] = 'Massredigera {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitleediting'] = 'Redigera {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesettings'] = 'Standardinställningar för kurs';
$string['coursesmovedout'] = 'Kurser som har flyttats ut ur {$a}';
$string['coursespending'] = 'Kurser i kö för att bli godkända';
$string['coursestart'] = 'Startdatum för kurs';
$string['coursesummary'] = 'Kurssammanfattning';
$string['coursesummary_help'] = 'En kort beskrivning av din kurs. Innehållet du lägger till här är sökbart.';
$string['coursetitle'] = 'Kurs: {$a->course}';
$string['coursetitlebulkediting'] = 'Massredigera kurs: {$a->course}';
$string['coursetitleediting'] = 'Redigera kurs: {$a->course}';
$string['courseupdates'] = 'Kursuppdateringar';
$string['coursevisibility'] = 'Kursens synlighet';
$string['coursevisibility_help'] = '* Visa: Kursen visas i listan över kurser och studenter kan komma åt den.
* Dölj: Åtkomsten är begränsad till lärare och andra användare med möjlighet att se dolda kurser.';
$string['create'] = 'Skapa';
$string['createaccount'] = 'Skapa mitt nya konto';
$string['createcategory'] = 'Skapa kategori';
$string['createfolder'] = 'Skapa en mapp i {$a}';
$string['createnew'] = 'Skapa ny';
$string['createnewcategory'] = 'Skapa ny kategori';
$string['createnewcourse'] = 'Skapa ny kurs';
$string['createnewsubcategory'] = 'Skapa ny underkategori';
$string['createsubcategoryof'] = 'Skapa underkategori till {$a}';
$string['createuser'] = 'Skapa användare';
$string['createziparchive'] = 'Skapa ZIP-fil';
$string['creatingblocks'] = 'Skapar block';
$string['creatingblocksroles'] = 'Skapar tilldelningar av och åsidosättanden för roller på blocknivå.';
$string['creatingblogsinfo'] = 'Skapar info om bloggar';
$string['creatingcategoriesandquestions'] = 'Skapar kategorier och frågor';
$string['creatingcoursemodules'] = 'Skapar kursmoduler...';
$string['creatingcourseroles'] = 'Skapar tilldelningar av och åsidosättanden för roller på kursnivå.';
$string['creatingevents'] = 'Skapar händelser';
$string['creatinggradebook'] = 'Skapar betygsbok';
$string['creatinggroupings'] = 'Skapar gruppindelningar';
$string['creatinggroupingsgroups'] = 'Lägger till grupper till grupperingar';
$string['creatinggroups'] = 'Skapar grupper';
$string['creatinglogentries'] = 'Skapar loggposter';
$string['creatingmessagesinfo'] = 'Skapar meddelandeinfo';
$string['creatingmodroles'] = 'Skapar tilldelningar av och åsidosättanden för roller på modulnivå.';
$string['creatingnewcourse'] = 'Skapar ny kurs...';
$string['creatingrolesdefinitions'] = 'Skapar rolldefinitioner';
$string['creatingscales'] = 'Skapar skalor...';
$string['creatingsections'] = 'Skapar avsnitt...';
$string['creatingtemporarystructures'] = 'Skapar tillfälliga strukturer...';
$string['creatinguserroles'] = 'Skapar tilldelningar av och åsidosättanden för roller på användarnivå.';
$string['creatingusers'] = 'Skapar användare...';
$string['creatingxmlfile'] = 'Skapar XML-fil...';
$string['currency'] = 'Valuta';
$string['currentcourse'] = 'Aktuell kurs';
$string['currentcourseadding'] = 'Aktuell kurs, lägger till data...';
$string['currentcoursedeleting'] = 'Aktuell kurs, tar bort den först...';
$string['currentlanguage'] = 'Aktuellt språk';
$string['currentlocaltime'] = 'nuvarande lokal tid';
$string['currentpicture'] = 'Aktuell bild';
$string['currentrelease'] = 'Aktuell versionsinformation';
$string['currenttheme'] = 'Nuvarande tema';
$string['currentversion'] = 'Aktuell version';
$string['databasechecking'] = 'Uppgraderar Moodles databas från version {$a->oldversion} till {$a->newversion}';
$string['databaseperformance'] = 'Databasprestanda';
$string['databasesetup'] = 'Konfigurerar databas';
$string['databasesuccess'] = 'Databasen har uppgraderats';
$string['databaseupgradebackups'] = 'Säkerhetskopians versionen är nu {$a}';
$string['databaseupgradeblocks'] = 'Blockversion är nu {$a}';
$string['databaseupgradegroups'] = 'Gruppversion är nu {$a}';
$string['databaseupgradelocal'] = 'Versionsnumret för de lokala databasanpassningarna är nu {$a}';
$string['databaseupgrades'] = 'Uppgraderar databas...';
$string['dataformats'] = 'Dataformat';
$string['date'] = 'Datum';
$string['datechanged'] = 'Datum för ändring';
$string['datemostrecentfirst'] = 'Datum - det senaste först';
$string['datemostrecentlast'] = 'Datum - det senaste sist';
$string['day'] = 'dag';
$string['days'] = 'dagar';
$string['decodinginternallinks'] = 'Avkodar interna länkar';
$string['default'] = 'Standard';
$string['defaultcategoryname'] = 'Kategori 1';
$string['defaultcompetencescale'] = 'Standardskala kompetenser';
$string['defaultcompetencescaledesc'] = 'En binär skala som inte ger mer information mer än att visa att någon har visat en färdighet eller inte.';
$string['defaultcompetencescalenotproficient'] = 'Ännu ej kompetent';
$string['defaultcompetencescaleproficient'] = 'Kompetent';
$string['defaultcoursestudent'] = 'Student';
$string['defaultcoursestudentdescription'] = 'Studenter har normalt sett färre rättigheter inom en kurs.';
$string['defaultcoursestudents'] = 'Studenter';
$string['defaultcoursesummary'] = 'Här kan du skriva ett kortfattat och intressant stycke som förklarar vad denna kurs handlar om och vilka villkor som gäller för deltagande.';
$string['defaultcourseteacher'] = 'Lärare';
$string['defaultcourseteacherdescription'] = 'Lärare kan hantera allt inom sin kurs, inklusive att ändra aktiviteter och betygssätta kursdeltagare.';
$string['defaultcourseteachers'] = 'Lärare';
$string['defaulteditor'] = 'Standardredigerare';
$string['defaulthomepageuser'] = 'Startsida';
$string['defaulthomepageuser_help'] = 'Vilken sida ska du omdirigeras till efter att ha loggat in på sidan?';
$string['delete'] = 'Ta bort';
$string['deleteablock'] = 'Ta bort ett block';
$string['deleteall'] = 'Ta bort alla';
$string['deleteallcannotundo'] = 'Ta bort allt - detta kan inte göras ogjort';
$string['deleteallcomments'] = 'Ta bort alla kommentarer';
$string['deleteallratings'] = 'Ta bort alla bedömningar';
$string['deletecategory'] = 'Ta bort kategori: {$a}';
$string['deletecategorycheck'] = 'Är du absolut säker på att du vill ta bort den här kategorin <b>\'{$a}\'</b>?<br />Det här flyttar alla kurser till föräldrakategorin om det det finns någon eller till \'Övrigt\'.';
$string['deletecategorycheck2'] = 'Om du tar bort denna kategori måste du välja vad du vill göra med de kurser och underkategorier som den innehåller.';
$string['deletecategoryempty'] = 'Den här kategorin är tom.';
$string['deletecheck'] = 'Ta bort {$a} ?';
$string['deletecheckfiles'] = 'Är du säker på att du vill ta bort de här filerna?';
$string['deletecheckfull'] = 'Är du helt säker på att du vill ta bort användaren <strong>{$a}</strong>, inklusive deras kursregistreringar, aktiviteter och andra användardata?';
$string['deletechecktype'] = 'Är du säker på att du vill ta bort {$a->type}?';
$string['deletechecktypename'] = 'Är du säker på att du vill ta bort {$a->type} "{$a->name}"?';
$string['deletecheckwarning'] = 'Du håller på att ta bort dessa filer.';
$string['deletecommentbyon'] = 'Ta bort kommentarer gjorda av {$a->user}, {$a->time}';
$string['deletecompletely'] = 'Ta bort helt';
$string['deletecourse'] = 'Ta bort en kurs';
$string['deletecoursecheck'] = 'Är du säker på att du helt vill ta bort denna kurs och alla data den innehåller?';
$string['deleted'] = 'Borttaget';
$string['deletedactivity'] = 'Tog bort {$a}';
$string['deletedcourse'] = '{$a} har tagits bort helt';
$string['deletednot'] = 'Kunde inte ta bort {$a} !';
$string['deletepicture'] = 'Ta bort';
$string['deletesection'] = 'Radera';
$string['deleteselected'] = 'Ta bort det som är markerat';
$string['deleteselectedkey'] = 'Ta bort den valda nyckeln';
$string['deletingcourse'] = 'Tar bort {$a}';
$string['deletingexistingcoursedata'] = 'Tar bort befintliga kursdata';
$string['deletingolddata'] = 'Tar bort gamla data';
$string['department'] = 'Avdelning';
$string['deprecatedeventname'] = '{$a} (används inte längre)';
$string['desc'] = 'Fallande';
$string['description'] = 'Beskrivning';
$string['deselectall'] = 'Avmarkera allt';
$string['deselectnos'] = 'Avmarkera alla "Nej"';
$string['detailedless'] = 'Mindre detaljerad';
$string['detailedmore'] = 'Mer detaljerad';
$string['details'] = 'Detaljer';
$string['digitalminor'] = 'Digital ålder för minderårig';
$string['digitalminor_desc'] = 'Vänligen be din förälder/vårdnadshavare kontakta:';
$string['directory'] = 'Katalog';
$string['disable'] = 'Inaktivera';
$string['disabledcomments'] = 'Kommentarer är inaktiverade';
$string['dismissnotification'] = 'Avfärda denna notis';
$string['displayingfirst'] = 'Endast de första {$a->count} {$a->things} visas';
$string['displayingrecords'] = 'Visar {$a} poster';
$string['displayingusers'] = 'Visar användare {$a->start} till {$a->end}';
$string['displayonpage'] = 'Visa på sida';
$string['dndcourse'] = 'Du kan dra och släppa den här kursen för att ändra dess sortering eller för att flytta den till en annan kategori.';
$string['dndenabled_inbox'] = 'Du kan dra och släppa filer här för att lägga till dem.';
$string['dndnotsupported'] = 'Dra- och släppuppladdning stöds ej';
$string['dndnotsupported_help'] = 'Din webbläsare stödjer inte dra och släpp för uppladdning. Den här funktionen är tillgänglig i alla nyare versioner av Chrome, Firefox, Edge och Safari, samt Internet Explorer version 10 eller högre.';
$string['dndnotsupported_insentence'] = 'Dra och släpp stöds ej';
$string['dnduploadwithoutcontent'] = 'Denna uppladdning har inget innehåll';
$string['dndworkingfile'] = 'Dra och släpp filer på kursavsnitt för att ladda upp dem';
$string['dndworkingfilelink'] = 'Dra och släpp filer eller länkar på kursavsnitt för att ladda upp dem';
$string['dndworkingfiletext'] = 'Dra och släpp filer eller text på kursavsnitt för att ladda upp dem';
$string['dndworkingfiletextlink'] = 'Dra och släpp filer, text eller länkar på kursavsnitt för att ladda upp dem';
$string['dndworkinglink'] = 'Dra och släpp länkar på kursavsnitt för att ladda upp dem';
$string['dndworkingtext'] = 'Dra och släpp text på kursavsnitt för att ladda upp den';
$string['dndworkingtextlink'] = 'Dra och släpp text eller länkar på kursavsnitt för att ladda upp dem';
$string['documentation'] = 'Moodle-dokumentation';
$string['dontsortcategories'] = 'Sortera inte kategorier';
$string['dontsortcourses'] = 'Sortera inte kurser';
$string['down'] = 'Ner';
$string['download'] = 'Hämta';
$string['downloadall'] = 'Hämta allt';
$string['downloadexcel'] = 'Ladda ner i Excelformat';
$string['downloadfile'] = 'Ladda ner fil';
$string['downloadods'] = 'Ladda ner i ODS-format';
$string['downloadtext'] = 'Ladda ner i textformat';
$string['doyouagree'] = 'Har du läst dessa villkor och förstått dem?';
$string['droptoupload'] = 'Släpp filer här för att ladda upp';
$string['duplicate'] = 'Kopiera';
$string['duplicatedmodule'] = '{$a} (kopia)';
$string['duplicatedsection'] = '{$a} (kopia)';
$string['edhelpaspellpath'] = 'För att använda stavningskontroll inom redigeraren <strong>MÅSTE aspell 0.50</strong> eller senare vara installerat på din server och du måste ange rätt sökväg till aspell-filerna. På Unix-/Linux-system är den här sökvägen vanligtvis <strong>/usr/bin/aspell</strong>, men den kan vara någonting annat.';
$string['edhelpbgcolor'] = 'Definiera bakgrundsfärgen för det område som du vill redigera.<br />Giltiga värden är t.ex. #ffffff eller "white".';
$string['edhelpcleanword'] = 'Den här inställningen aktiverar eller inaktiverar formatfiltrering som är specifik för Word.';
$string['edhelpenablespelling'] = 'Aktivera eller inaktivera stavningskontroll. När den är aktiverad så måste <strong>aspell</strong> vara aktiverat på servern.';
$string['edhelpfontfamily'] = 'Egenskapen för typsnittsfamilj är en lista över namn på olika typsnitt eller på generella sådana (med eller utan seriffer t.ex.). Dessa namn på typsnitt måste vara kommaseparerade.';
$string['edhelpfontlist'] = 'Definiera de typsnitt som du vill ha med i redigerarens utfällbara meny för typsnitt (fonter).';
$string['edhelpfontsize'] = 'Standardstorleken på typsnittet (fonten) anger storleken på typsnittet.<br />Giltiga värden är t.ex.: medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'Redigera';
$string['edita'] = 'Redigera {$a}';
$string['editcategorysettings'] = 'Redigera kategoriinställningar';
$string['editcategorythis'] = 'Redigera den här kategorin';
$string['editcoursesettings'] = 'Redigera kursinställningar';
$string['editfiles'] = 'Redigera filer';
$string['editgroupprofile'] = 'Redigera gruppbeskrivning';
$string['editinga'] = 'Redigerar {$a}';
$string['editingteachershort'] = 'Redigerare';
$string['editlock'] = 'Detta värde kan inte ändras!';
$string['editmode'] = 'Redigeringsläge';
$string['editmyprofile'] = 'Redigera profil';
$string['editorbgcolor'] = 'Bakgrundsfärg';
$string['editorcleanonpaste'] = 'Rensa HTML skapad av Word när du klistrar in';
$string['editorcommonsettings'] = 'Generella inställningar';
$string['editordefaultfont'] = 'Standardteckensnitt';
$string['editorenablespelling'] = 'Aktivera stavningskontroll';
$string['editorfontlist'] = 'Lista över typsnitt';
$string['editorfontsize'] = 'Standardteckenstorlek';
$string['editorpreferences'] = 'Välj textredigerare';
$string['editorresettodefaults'] = 'Återställ till standardvärden';
$string['editorsettings'] = 'Inställningar för redigerare';
$string['editorshortcutkeys'] = 'Kortkommandon för redigerare';
$string['editsection'] = 'Redigera inställningar';
$string['editsectionname'] = 'Redigera avsnittsnamn';
$string['editsectionsettings'] = 'Redigera avsnittsinställningar';
$string['editsectiontitle'] = 'Redigera avsnitt: {$a}';
$string['editsettings'] = 'Redigera inställningar';
$string['editsummary'] = 'Redigera sammanfattning';
$string['editthisactivity'] = 'Redigera denna aktivitet';
$string['editthiscategory'] = 'Redigera denna kategori';
$string['edittitle'] = 'Redigera titel';
$string['edittitleinstructions'] = 'Escape för att avbryta, Enter för att avsluta';
$string['edituser'] = 'Redigera användarkonton';
$string['edulevel'] = 'Alla händelser';
$string['edulevel_help'] = '* Undervisning - åtgärder som utförs av en lärare, t.ex. uppdatering av en resurs
* Deltagande - åtgärder som utförs av en student, t.ex. göra inlägg i ett forum
* Övriga - åtgärder som utförs av en användare med en annan roll än lärare eller elev';
$string['edulevelother'] = 'Övriga';
$string['edulevelparticipating'] = 'Deltagande';
$string['edulevelteacher'] = 'Undervisning';
$string['email'] = 'E-postadress';
$string['emailactive'] = 'E-post är aktiverat';
$string['emailagain'] = 'E-post (igen)';
$string['emailalreadysent'] = 'Ett meddelande om lösenordsåterställning har redan skickats. Vänligen kontrollera din epost.';
$string['emailcharset'] = 'Teckenuppsättning för e-post';
$string['emailconfirm'] = 'Bekräfta konto';
$string['emailconfirmation'] = 'Hej,

Någon (antagligen du) har använt din e-postadress för att beställa ett nytt konto på: \'{$a->sitename}\'.

För att bekräfta kontot, gå till:

{$a->link}

I de flesta e-postprogram behöver du bara klicka på länken. Om det inte fungerar, kan du klippa ut adressen här och klistra in den i adressrutan på din webbläsare.

Om du behöver hjälp kan du gärna kontakta administratören för webbplatsen, {$a->admin}';
$string['emailconfirmationresend'] = 'Skicka om bekräftelsemejl';
$string['emailconfirmationsubject'] = '{$a}: bekräftelse av konto';
$string['emailconfirmsent'] = '<p>Vi har skickat ett e-postmeddelande som du bör ha fått<br /> till din adress på <b>{$a}</b></p>
<p>Det innehåller enkla instruktioner som hjälper dig<br />att slutföra registreringen.</p>
<p>Om du stöter på problem är du välkommen att <br />kontakta webbplatsadministratören.</p>';
$string['emailconfirmsentfailure'] = 'Bekräftelsemejlet kunde inte skickas.';
$string['emailconfirmsentsuccess'] = 'Bekräftelsemejlet har skickats.';
$string['emaildigest'] = 'Typ av e-postsammanfattning';
$string['emaildigest_help'] = 'Det här är inställningen för dagliga forumsammanfattningar som kommer användas som standard.

* Ingen sammanfattning - du kommer få ett e-postmeddelande per foruminlägg;
* Sammanfattning - hela inlägg - du kommer få ett sammandrag per dag via epost med det fullständiga innehållet i varje foruminlägg;
* Sammanfattning - endast rubriker - du kommer få ett sammandrag per dag via e-post som enbart innehåller rubriker för varje foruminlägg.

Du kan också välja olika inställningar för varje forum om du så vill.';
$string['emaildigestcomplete'] = 'Sammanfattning - hela inlägg';
$string['emaildigestoff'] = 'Ingen sammanfattning';
$string['emaildigestsubjects'] = 'Sammanfattning - endast rubriker';
$string['emaildisable'] = 'Den här e-postadressen är inaktiverad.';
$string['emaildisableclick'] = 'Klicka här för att inaktivera alla möjligheter att skicka e-post till den här adressen.';
$string['emaildisplay'] = 'Synlighet för e-post';
$string['emaildisplay_help'] = '* Dold - Endast användare med lämpliga behörigheter så som lärare kan se din e-postadress.
* Synlig för alla - Alla användare på sidan kan se din e-postadress.
* Synlig för kursdeltagare - Endast deltagare i kurser du är anmäld till kan se din e-postadress.';
$string['emaildisplaycourse'] = 'Synlig för kursdeltagare';
$string['emaildisplaycoursemembersonly'] = '(Synlig för andra kursdeltagare)';
$string['emaildisplayeveryone'] = '(Synlig för alla)';
$string['emaildisplayhide'] = '(Dold för alla utom användare med korrekta rättigheter)';
$string['emaildisplayno'] = 'Dold';
$string['emaildisplayyes'] = 'Synlig för alla';
$string['emailenable'] = 'Den här e-postadressen är aktiverad.';
$string['emailenableclick'] = 'Klicka här för att aktivera alla möjligheter att skicka e-post till den här adressen.';
$string['emailexists'] = 'Din e-postadress är redan registrerad.';
$string['emailexistshintlink'] = 'Hämta bortglömt användarnamn eller lösenord.';
$string['emailexistssignuphint'] = 'Har du kanske skapat ett konto tidigare?';
$string['emailformat'] = 'E-postformat';
$string['emailmustbereal'] = '<strong>OBS!</strong> Din e-postadress måste finnas och vara giltig';
$string['emailnotallowed'] = 'E-postadresser i de här domänerna är inte tillåtna ({$a}).';
$string['emailnotfound'] = 'Det gick inte att hitta e-postadressen i databasen.';
$string['emailonlyallowed'] = 'Den här e-postdomänen kan inte användas. Tillåtna epostdomäner är: {$a}.';
$string['emailpasswordchangeinfo'] = 'Hej {$a->firstname},
Någon (troligen du) har beställt ett nytt lösenord för ditt konto hos
\'{$a->sitename}\'.

För att byta lösenordet, gå till följande adress:

{$a->link}

I de flesta e-postprogram kommer den att visas som en blå länk som du bara behöver klicka på.

Om det inte fungerar, kan du klippa ut adressen och klistra in den i adressfönstret på din webbläsare, klicka sedan på Gå eller tryck på
radmatningen (Enter).

Om du behöver hjälp så är du välkommen att
kontakta den som är ansvarig för webbplatsen,
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Hej {$a->firstname},
Någon (troligen du) har beställt
ett nytt lösenord för ditt konto hos:

\'{$a->sitename}\'.

Tyvärr har ditt konto på den här webbplatsen inaktiverats och det
går inte att återställa det.

Var god kontakta administratören
för webbplatsen:
{$a->admin}';
$string['emailpasswordchangeinfofail'] = 'Hej {$a->firstname},
Någon (troligen du) har beställt
ett nytt lösenord för ditt konto hos:

\'{$a->sitename}\'.

Det går tyvärr inte att återställa
lösenord på den här webbplatsen.

Var god kontakta administratören
för webbplatsen:
{$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: information om byte av lösenord';
$string['emailpasswordconfirmation'] = 'Hej {$a->firstname}!

Någon (antagligen du) har beställt ett nytt lösenord till ditt konto på: \'{$a->sitename}\'.

Om du vill bekräfta detta och att vi ska skicka
det nya lösenordet med e-post så behöver du koppla
upp dig till den följande webbadressen:

{$a->link}

I de flesta e-postprogram kommer den att visas som
en blå länk som du bara behöver klicka på.

Om det inte fungerar, kan du klippa ut adressen
här och klistra in den i adressfönstret på din
webbläsare, klicka sedan på Gå eller tryck på
radmatningen (Enter).

Om du behöver hjälp så är du välkommen att
kontakta den som är ansvarig för webbplatsen,
{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: bekräftelse av ändrat lösenord';
$string['emailpasswordconfirmmaybesent'] = '<p>Om du angav ett korrekt användarnamn eller en unik e-postadress skickas ett e-postmeddelande till dig.</p>
<p>Det innehåller enkla instruktioner för att bekräfta och slutföra denna lösenordsändring.
Om du fortfarande har problem kontaktar du webbplatsadministratören..</p>';
$string['emailpasswordconfirmnoemail'] = '<p>Användarkontot du specificerade har ingen epostadress registrerad.</p>
   <p>Vänligen kontakta webbplatsens administratör.</p>';
$string['emailpasswordconfirmnotsent'] = '<p>Användardetaljen du tillhandahöll identifierar inte ett existerande användarkonto.</p>
   <p>Vänligen kontrollera informationen du angav och försök sen igen.
Om problemen fortsätter, kontakta webbplatsens administratör.</p>';
$string['emailpasswordconfirmsent'] = 'Vi har skickat ett e-postbrev till din adress på:
<b>{$a}</b>

Det innehåller enkla instruktioner för att du ska
kunna bekräfta och fullfölja detta byte av lösenord.

Om du stöter på problem, är du välkommen att
kontakta den som ansvarar för webbplatsen.';
$string['emailpasswordsent'] = 'Tack för att du bekräftade bytet av lösenord.

Vi har skickat ett e-postbrev som innehåller
lösenordet till din adress på:
<b>{$a->email}</b>

Det nya lösenordet har skapats automatiskt -
och du kanske vill <a href="{$a->link}">byta ditt
lösenord</a> till något som är lättare att komma ihåg.';
$string['emailresetconfirmation'] = 'Hej {$a->firstname}!

En lösenordsåterställning har begärts för ditt konto \'{$a->username}\' på {$a->sitename}.

För att bekräfta återställningen och ange ett nytt lösenord för ditt konto, gå till följande webbadress:
<a href="{$a->link}">{$a->link}</a>

(Den här länken är giltig i {$a->resetminutes} minuter från det att denna återställning begärdes.)

Om denna lösenordsåterställning inte begärdes av dig, behövs ingen åtgärd.

Om du behöver hjälp, kontakta webbplatsens administratör, {$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: Begäran om återställning av lösenord';
$string['emailresetconfirmsent'] = 'Ett epostmeddelande har skickats till din adress <b>{$a}</b>.
<br />Det innehåller enkla instruktioner för att bekräfta och slutföra det här bytet av lösenord.
Om problemen fortsätter, kontakta webbplatsens administratör.';
$string['emailstop'] = 'Inaktivera notifikationer';
$string['emailtoprivatefiles'] = 'Du kan även skicka filer som e-postbilagor direkt till dina privata filer. Du behöver endast bifoga dina filer i ett e-post och skicka till {$a}';
$string['emailtoprivatefilesdenied'] = 'Administratören har tagit bort möjligheten att ladda upp dina egna privata filer.';
$string['emailvia'] = '{$a->name} (via {$a->siteshortname})';
$string['emojicategoryactivities'] = 'Aktiviteter';
$string['emojicategoryanimalsnature'] = 'Djur & natur';
$string['emojicategoryflags'] = 'Flaggor';
$string['emojicategoryfooddrink'] = 'Mat & dryck';
$string['emojicategoryobjects'] = 'Objekt';
$string['emojicategorypeoplebody'] = 'Människor & kroppen';
$string['emojicategoryrecent'] = 'Senaste';
$string['emojicategorysmileysemotion'] = 'Smileys & känsla';
$string['emojicategorysymbols'] = 'Symboler';
$string['emojicategorytravelplaces'] = 'Resor & platser';
$string['emptycmids'] = 'Tomma kursmodul-ID:n';
$string['emptydragdropregion'] = 'tom region';
$string['emptysectionids'] = 'Tomma sektions-ID:n';
$string['enable'] = 'Aktivera';
$string['encryptedcode'] = 'Krypterad kod';
$string['enddate'] = 'Kursens slutdatum';
$string['enddate_help'] = 'Slutdatumet begränsar inte studenternas åtkomst till kursen. Det avgör om en kurs är listad som Tidigare i Mina kurser.';
$string['enddatewithtaskenabled'] = 'Kursens slutdatum';
$string['enddatewithtaskenabled_help'] = 'Datumet då kursen döljs för studenter och de inte längre kan komma åt den.';
$string['english'] = 'Engelska';
$string['enrolmentmethods'] = 'Registreringsmetoder';
$string['entercourse'] = 'Klicka för att nå denna kurs';
$string['enteremail'] = 'Mata in din e-postadress';
$string['enteremailaddress'] = 'Mata in din e-postadress för att nollställa ditt
lösenord så skickar vi det nya lösenordet till dig via e-post.';
$string['enterusername'] = 'Mata in ditt användarnamn';
$string['entries'] = 'Poster';
$string['error'] = 'Fel';
$string['errorcreatingactivity'] = 'Det gick inte att skapainstans av aktiviteten \'{$a}\'';
$string['errorfiletoobig'] = 'Filen var större än gränsen på {$a} byte';
$string['errornouploadrepo'] = 'Det finns ingen arkiv för uppladdning aktiverat för den här webbplatsen';
$string['errorwhenconfirming'] = 'Du är inte bekräftad ännu eftersom det uppstod ett fel.
Om du klickade på en länk i ett e-postmeddelande för att
komma hit så får du kolla att raden med länken inte var uppdelad på två rader.
Du kanske måste "klippa och klistra" för att forma länken på rätt sätt.';
$string['eventcommentcreated'] = 'Kommentar skapad';
$string['eventcommentdeleted'] = 'Kommentar borttagen';
$string['eventcommentsviewed'] = 'Kommentar visade';
$string['eventconfiglogcreated'] = 'Konfigurationslogg skapad';
$string['eventcontentviewed'] = 'Innehåll visat';
$string['eventcoursebackupcreated'] = 'Kursbackup skapad';
$string['eventcoursecategorycreated'] = 'Kategori skapad';
$string['eventcoursecategorydeleted'] = 'Kategori borttagen';
$string['eventcoursecategoryupdated'] = 'Kategori uppdaterad';
$string['eventcoursecategoryviewed'] = 'Kategori visad';
$string['eventcoursecontentdeleted'] = 'Kursinnehåll borttaget';
$string['eventcoursecreated'] = 'Kurs skapad';
$string['eventcoursedeleted'] = 'Kurs borttagen';
$string['eventcourseended'] = 'Kursen avslutad';
$string['eventcourseinformationviewed'] = 'Kurssammanfattning visad';
$string['eventcoursemodulecreated'] = 'Kursmodul skapad';
$string['eventcoursemoduledeleted'] = 'Kursmodul borttagen';
$string['eventcoursemoduleinstancelistviewed'] = 'Lista över kursmodul instanser visad';
$string['eventcoursemoduleupdated'] = 'Kursmodul uppdaterad';
$string['eventcoursemoduleviewed'] = 'Kursmodul visad';
$string['eventcourseresetended'] = 'Kursåterställning avslutad';
$string['eventcourseresetstarted'] = 'Kursåterställning startad';
$string['eventcourserestored'] = 'Kurs återskapad';
$string['eventcoursesectioncreated'] = 'Kurssektion skapad';
$string['eventcoursesectiondeleted'] = 'Kurssektion raderad';
$string['eventcoursesectionupdated'] = 'Kurssektion uppdaterad';
$string['eventcoursessearched'] = 'Sökta kurser';
$string['eventcoursestarted'] = 'Kursen startad';
$string['eventcourseupdated'] = 'Kurs uppdaterad';
$string['eventcourseuserreportviewed'] = 'Kursens användarrapport visad';
$string['eventcourseviewed'] = 'Kurs visad';
$string['eventdashboardreset'] = 'Återställ översiktssidan';
$string['eventdashboardsreset'] = 'Återställ översiktssidorna';
$string['eventdashboardviewed'] = 'Översiktssidan har besökts';
$string['eventdatabasetextfieldcontentreplaced'] = 'Global sök och ersätt i databas';
$string['eventemailfailed'] = 'E-postmeddelande skickades inte';
$string['eventmycoursesviewed'] = 'Visade Mina kurser';
$string['eventname'] = 'Händelsenamn';
$string['eventrecentactivityviewed'] = 'Senast visade aktivitet';
$string['eventsearchindexed'] = 'Sökdata indexerad';
$string['eventsearchresultsviewed'] = 'Sökresultaten har setts';
$string['eventsectionviewed'] = 'Avsnitt visat';
$string['eventunknownlogged'] = 'Okänd händelse';
$string['eventurlblocked'] = 'URL blockerades';
$string['eventusercreated'] = 'Användare skapad';
$string['eventuserdeleted'] = 'Användare borttagen';
$string['eventuserfeedbackgiven'] = 'Feedbacklänken har klickats';
$string['eventuserfeedbackremind'] = 'Länk för påminnelse om återkoppling klickad';
$string['eventuserinfocategorycreated'] = 'Kategori för användarprofil-fält skapad';
$string['eventuserinfocategorydeleted'] = 'Kategori för användarprofil-fält borttagen';
$string['eventuserinfocategoryupdated'] = 'Kategori för användarprofil-fält uppdaterad';
$string['eventuserinfofieldcreated'] = 'Fält i användarprofil skapat';
$string['eventuserinfofielddeleted'] = 'Fält i användarprofil raderat';
$string['eventuserinfofieldupdated'] = 'Fält i användarprofil uppdaterat';
$string['eventuserlistviewed'] = 'Användarlista visad';
$string['eventuserloggedout'] = 'Användare loggade ut';
$string['eventuserpasswordpolicyfailed'] = 'Användarlösenord uppfyllde inte kraven i lösenordsprincipen';
$string['eventuserpasswordupdated'] = 'Användarlösenord uppdaterat';
$string['eventuserprofileviewed'] = 'Användarprofil visad';
$string['eventuserupdated'] = 'Användare uppdaterad';
$string['everybody'] = 'Alla';
$string['executeat'] = 'Genomför vid';
$string['existing'] = 'Finns';
$string['existingadmins'] = 'Befintliga administratörer';
$string['existingcourse'] = 'Befintlig kurs';
$string['existingcourseadding'] = 'Befintlig kurs, lägger till data';
$string['existingcoursedeleting'] = 'Befintlig kurs, tar först bort den';
$string['existingcreators'] = 'Befintliga kursutvecklare';
$string['existingstudents'] = 'Registrerade kursdeltagare';
$string['existingteachers'] = 'Befintliga lärarna';
$string['expand'] = 'Expandera';
$string['expandall'] = 'Expandera allt';
$string['expandcategory'] = 'Expandera {$a}';
$string['explanation'] = 'Förklaring';
$string['explanationdigitalminor'] = 'Denna information krävs för att avgöra om din ålder är över den digitala åldern för samtycke. Detta är den ålder då en individ kan samtycka till villkor och deras uppgifter lagras och behandlas lagenligt.';
$string['extendperiod'] = 'Förlängd period';
$string['extendsession'] = 'Förläng sessionen';
$string['failedloginattempts'] = '{$a->attempts} misslyckade försök att logga in sedan din senaste login.';
$string['failedtaskbody'] = '<p>Hej {$a->firstname},</p>
<p>Aktiviteten <b>{$a->taskname}</b> har misslyckats flera gånger och kräver åtgärd.</p>
<p><a href="{$a->link}">Se aktivitet</a></p>';
$string['failedtaskcontexturlname'] = 'Statusrapport';
$string['failedtasksubject'] = 'Aktivitet misslyckades: {$a}';
$string['favourites'] = 'Favoriter';
$string['feedback'] = 'Återkoppling';
$string['file'] = 'Fil';
$string['fileexists'] = 'Det finns redan en fil med namnet {$a}';
$string['filemissing'] = '{$a} saknas';
$string['filereaderror'] = 'Kunde inte läsa filen \'{$a}\'. Vänligen kontrollera att den verkligen är en fil och inte en folder.';
$string['files'] = 'Filer';
$string['filesanduploads'] = 'Filer och uppladdningar';
$string['filesfolders'] = 'Filer/mappar';
$string['fileuploadwithcontent'] = 'Filuppladdningar bör inte inkludera innehållsparametrar';
$string['filloutallfields'] = 'Vänligen fyll i alla fält i det här formuläret';
$string['filter'] = 'Filter';
$string['filteroption'] = '{$a->criteria}: {$a->value}';
$string['filterrowlegend'] = 'Filter {$a}';
$string['filters'] = 'Filter';
$string['filtersetmatchdescription'] = 'Hur multipla filter ska kombineras';
$string['filtertype'] = 'Typ av filter';
$string['findmorecourses'] = 'Sök fler kurser...';
$string['first'] = 'Första';
$string['firstaccess'] = 'Första inloggning';
$string['firstname'] = 'Förnamn';
$string['firstnamephonetic'] = 'Förnamn - fonetiskt';
$string['firstpage'] = 'Första sidan';
$string['firstsiteaccess'] = 'Första inloggning';
$string['firsttime'] = 'Är det första gången du är här?';
$string['folder'] = 'Katalog';
$string['folderclosed'] = 'Stängd katalog';
$string['folderopened'] = 'Öppnad katalog';
$string['followingoptional'] = 'Följande punkter är valfria';
$string['followingrequired'] = 'Följande punkter krävs';
$string['for'] = 'För';
$string['force'] = 'Tvinga';
$string['forcelanguage'] = 'Tvinga språkval';
$string['forceno'] = 'Tvinga inte';
$string['forcepasswordchange'] = 'Påtvinga lösenordsbyte';
$string['forcepasswordchange_help'] = 'Om kryssrutan är markerad uppmanas användaren byta lösenord vid nästa inloggning';
$string['forcepasswordchangecheckfull'] = 'Är du helt säker på att du vill göra en ändring av lösenord till {$a}?';
$string['forcepasswordchangenot'] = 'Det gick inte att tvinga ett lösenordbyte {$a}';
$string['forcepasswordchangenotice'] = 'Du måste byta ditt lösenord för att fortsätta.';
$string['forcepasswordresetfailurenotice'] = 'Ditt nuvarande lösenord uppfyller inte längre kraven i den angivna lösenordsprincipen. Kontakta din Moodle-administratör för att få hjälp.
  {$a}';
$string['forcepasswordresetnotice'] = 'Ditt nuvarande lösenord uppfyller inte längre kraven i den angivna lösenordsprincipen. Du behöver återställa ditt lösenord för att logga in.
  {$a}';
$string['forcetheme'] = 'Tvinga tema';
$string['forgotaccount'] = 'Glömt lösenordet?';
$string['forgotten'] = 'Glömt användarnamn eller lösenord?';
$string['forgottenduplicate'] = 'Den här e-postadressen används av ett flertal konton. Ange ett användarnamn istället.';
$string['forgotteninvalidurl'] = 'URL till återställning av ogiltigt lösenord.';
$string['format'] = 'Format';
$string['format_help'] = 'Kursformatet bestämmer kurssidans layout.

* Enskild aktivitet - För att visa en enda aktivitet eller resurs (till exempel ett test- eller SCORM-paket) på kurssidan
* Socialt format - Ett forum visas på kurssidan
* Ämnesformat - Kurssidan är organiserad i ämnesavsnitt
* Veckoformat - Kurssidan är organiserad i veckoavsnitt, med den första veckan som börjar på kursens startdatum';
$string['formathtml'] = 'HTML-format';
$string['formatmarkdown'] = 'Markdown format';
$string['formatplain'] = 'Oformaterad text';
$string['formattext'] = 'Autoformat för Moodle';
$string['forumpreferences'] = 'Foruminställningar';
$string['framesetinfo'] = 'Det här dokumentet i ramverksformat innehåller:';
$string['from'] = 'Från';
$string['fromdate'] = 'Från';
$string['fromsender'] = 'Från';
$string['frontpagecategorycombo'] = 'Kombinationslista';
$string['frontpagecategorynames'] = 'Kategorilista';
$string['frontpagecourselist'] = 'Kurslista';
$string['frontpagecoursesearch'] = 'Rutan för kurssökning';
$string['frontpagedescription'] = 'Sammanfattning av sidan';
$string['frontpagedescriptionhelp'] = 'Denna sammanfattning kan visas på startsidan med hjälp av kurs-/webbplatssammanfattningsblocket.';
$string['frontpageenrolledcourselist'] = 'Användarens kurser';
$string['frontpageformat'] = 'Startsideformat';
$string['frontpageformatloggedin'] = 'Startsideformat när man är inloggad';
$string['frontpagenews'] = 'Nyheter';
$string['frontpagesettings'] = 'Inställningar för startsidan';
$string['fulllistofcourses'] = 'Alla kurser';
$string['fullname'] = 'Fullständigt namn';
$string['fullnamecourse'] = 'Kursnamn';
$string['fullnamecourse_help'] = 'Namnet som visas i Mina kurser och i listan över tillgängliga kurser på Hem-sidan.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Fullständigt namn';
$string['fullprofile'] = 'Hela profilen';
$string['fullsitename'] = 'Fullständigt webbplatsnamn';
$string['functiondisabled'] = 'Den funktionaliteten är för närvarande inaktiverad';
$string['general'] = 'Allmänt';
$string['geolocation'] = 'latitud - longitud';
$string['gettheselogs'] = 'Hämta loggar';
$string['go'] = 'Gå';
$string['gpl'] = 'Copyright (C) 1999 och framåt Martin Dougiamas (https://moodle.com)

Detta program är fri programvara; du kan distribuera den och/eller modifiera den enligt villkoren i GNU General Public License som publicerats av Free Software Foundation; antingen version 2 av licensen eller (efter eget val) någon senare version.

Detta program distribueras i hopp om att det ska vara användbart, men UTAN NÅGON GARANTI; utan ens den underförstådda garantin för SÄLJBARHET eller LÄMPLIGHET FÖR ETT SÄRSKILT ÄNDAMÅL.

Se informationssidan för Moodle License för fullständig information: https://moodledev.io/general/license';
$string['gpl3'] = 'Copyright (C) 1999 och framåt Martin Dougiamas (https://moodle.com)

Detta program är fri programvara: du kan distribuera det och/eller modifiera det under villkoren i GNU General Public License som publicerats av Free Software Foundation, antingen version 3 av licensen, eller (efter eget val) valfri senare version.

Detta program distribueras i hopp om att det ska vara användbart, men UTAN NÅGON GARANTI; utan ens den underförstådda garantin för SÄLJBARHET eller LÄMPLIGHET FÖR ETT SÄRSKILT ÄNDAMÅL.

Se informationssidan för Moodle License för fullständig information: https://moodledev.io/general/license';
$string['gpllicense'] = 'GPL licens';
$string['gradenoun'] = 'Betyg';
$string['grades'] = 'Betyg';
$string['gradeverb'] = 'Betyg';
$string['gravatarenabled'] = '<a href="http://www.gravatar.com/">Gravatar</a> har aktiverats för den här webbplatsen. Om du inte laddar upp en profilbild kommer Moodle försöka hämta en profilbild till dig från Gravatar.';
$string['group'] = 'Grupp';
$string['groupadd'] = 'Lägg till en ny grupp';
$string['groupaddusers'] = 'Lägg till det valda till grupp';
$string['groupfor'] = 'för grupp';
$string['groupinfo'] = 'Info om vald grupp';
$string['groupinfoedit'] = 'Redigera inställningar för grupp';
$string['groupinfomembers'] = 'Info om valda medlemmar';
$string['groupinfopeople'] = 'Info om valda personer';
$string['groupmembers'] = 'Gruppmedlemmar';
$string['groupmemberssee'] = 'Visa gruppmedlemmar';
$string['groupmembersselected'] = 'Medlemmar i vald grupp';
$string['groupmode'] = 'Gruppläge';
$string['groupmodeforce'] = 'Framtvinga gruppläge';
$string['groupmy'] = 'Min grupp';
$string['groupnonmembers'] = 'Personer som inte är med i någon grupp';
$string['groupnotamember'] = 'Du är tyvärr inte medlem i den gruppen.';
$string['grouprandomassign'] = 'Dela slumpmässigt in alla i grupper.';
$string['groupremove'] = 'Ta bort vald grupp';
$string['groupremovemembers'] = 'Ta bort valda medlemmar';
$string['groups'] = 'Grupper';
$string['groupsnone'] = 'Inga grupper';
$string['groupsseparate'] = 'Separata grupper';
$string['groupsvisible'] = 'Synliga grupper';
$string['guest'] = 'Gäst';
$string['guestdescription'] = 'Gäster har mycket begränsade rättigheter och kan normalt sett inte skriva in text någonstans.';
$string['guestskey'] = 'Tillåt gäster som har nyckeln.';
$string['guestsno'] = 'Tillåt inte gäster';
$string['guestsnotallowed'] = 'Tyvärr,  \'{$a}\'  tillåter inte tillträde för gäster.';
$string['guestsyes'] = 'Tillåt gäster utan nyckeln';
$string['guestuser'] = 'Gästanvändare';
$string['guestuserinfo'] = 'Denna användare är en speciell användare som tillåts endast läsbehörighet till några kurser.';
$string['help'] = 'Hjälp';
$string['helpprefix2'] = 'Hjälp med {$a}';
$string['helpwiththis'] = 'Hjälp med detta';
$string['hiddenassign'] = 'Dold uppgift';
$string['hiddenfromstudents'] = 'Dold för studenter';
$string['hiddenoncoursepage'] = 'Tillgänglig men inte synlig på kurssidan';
$string['hiddensections'] = 'Dolda sektioner';
$string['hiddensections_help'] = 'Dolda avsnitt kan visas för studenter som "ej tillgängliga" på kurssidan, eller hållas helt dolda.';
$string['hiddensectionscollapsed'] = 'Dolda avsnitt visas som ej tillgängliga';
$string['hiddensectionsinvisible'] = 'Dolda sektioner är helt och hållet osynliga.';
$string['hiddenwithbrackets'] = '(dold)';
$string['hide'] = 'Dölj';
$string['hideadvancedsettings'] = 'Dölj avancerade inställningar.';
$string['hidechartdata'] = 'Dölj diagram';
$string['hidefromstudents'] = 'Dölj på kurssidan';
$string['hideoncoursepage'] = 'Gör tillgänglig, men visa inte på kurssidan';
$string['hidepopoverwindow'] = 'Dölj popover-fönstret';
$string['hidesection'] = 'Dölj sektion {$a}';
$string['hidesettings'] = 'Dölj inställningar.';
$string['hideshowblocks'] = 'Dölja eller visa block';
$string['highlight'] = 'Markera';
$string['highlighted'] = 'Markerad';
$string['highlightoff'] = 'Ta bort markering';
$string['hits'] = 'Besök';
$string['hitsoncourse'] = 'Besök på {$a->coursename} av {$a->username}';
$string['hitsoncoursetoday'] = 'Dagens besök på {$a->coursename} av {$a->username}';
$string['home'] = 'Startsida';
$string['homeheader'] = 'Hem';
$string['hour'] = 'timme';
$string['hours'] = 'timmar';
$string['howtomakethemes'] = 'Så gör du ett nytt tema.';
$string['htmleditor'] = 'Använd HTML-editor';
$string['htmleditoravailable'] = 'Richtext-redigeraren är tillgänglig';
$string['htmleditordisabled'] = 'Du har valt bort Richtext-redigeraren i din användarprofil.';
$string['htmleditordisabledadmin'] = 'Administratören har inaktiverat HTML-redigeraren på den här webbplatsen';
$string['htmleditordisabledbrowser'] = 'HTML-redigeraren är inte tillgänglig eftersom du använder en inkompatibel webbläsare';
$string['htmlfilesonly'] = 'Endast HTML-filer';
$string['htmlformat'] = 'HTML-format';
$string['icon'] = 'Ikon';
$string['idnumber'] = 'ID nummer';
$string['idnumbercourse'] = 'ID-nummer för kurs';
$string['idnumbercourse_help'] = 'Används endast för att koppla ihop kursen med externa system. Lämna tomt om du inte har ett officiellt kurs-ID.';
$string['idnumbercoursecategory'] = 'Kategori ID-nummer';
$string['idnumbercoursecategory_help'] = 'ID-numret för en kurskategori används endast när kategorin matchas mot externa system och visas inte någonstans på webbplatsen. Om kategorin har ett officiellt kodnamn kan det anges, annars kan fältet lämnas tomt.';
$string['idnumbergroup'] = 'ID-nummer för grupp';
$string['idnumbergroup_help'] = 'ID-numret för en grupp används bara när gruppen matchas mot externa system och visas inte någonstans på webbplatsen. Om gruppen har ett officiellt kodnamn kan det anges, annars kan fältet lämnas tomt.';
$string['idnumbergrouping'] = 'Gruppering ID-nummer';
$string['idnumbergrouping_help'] = 'ID-numret för en gruppering används endast när grupperingen matchas mot externa system och visas inte någonstans på webbplatsen. Om grupperingen har ett officiellt kodnamn kan det anges, annars kan fältet lämnas tomt.';
$string['idnumbermod'] = 'ID-nummer';
$string['idnumbermod_help'] = 'Att ange ett ID-nummer är ett sätt att identifiera aktiviteten eller resursen för ändamål som resultatberäkning eller anpassad rapportering. I annat fall kan fältet lämnas tomt.

För bedömningsbara aktiviteter kan ID-numret också anges i betygsboken, även om det bara kan redigeras på sidan för aktivitetsinställningarna.';
$string['idnumbertaken'] = 'Det här ID-numret används redan';
$string['imagealt'] = 'Bildbeskrivning';
$string['import'] = 'Importera';
$string['importdata'] = 'Importera kursdata';
$string['importdataexported'] = 'Data har exporterats från \'från\'-kurs med framgång.<br />Fortsätt med att importera till din \'till\'-kurs.';
$string['importdatafinished'] = 'Importen är klar!  Fortsätt till din kurs.';
$string['importdatafrom'] = 'Hitta en kurs att importera data från:';
$string['importinfo'] = 'Importera föremål från andra kurser, såsom aktiviteter, block eller kalenderhändelser. Ingen användardata kommer att importeras.';
$string['inactive'] = 'Inaktiv';
$string['include'] = 'Ta med';
$string['includeallusers'] = 'Inkludera alla användare';
$string['includecoursefiles'] = 'Inkludera alla kursfiler';
$string['includecourseusers'] = 'Inkludera alla lärande';
$string['included'] = 'Ingår';
$string['includelogentries'] = 'Inkludera loggar';
$string['includemodules'] = 'Inkludera moduler';
$string['includemoduleuserdata'] = 'Ta med användardata för modulen';
$string['includeneededusers'] = 'Inkludera nödvändiga användare';
$string['includenoneusers'] = 'Inkludera icke-användare';
$string['includeroleassignments'] = 'Ta med rolltilldelningar';
$string['includesitefiles'] = 'Inkludera filer på webbplatsnivå som används i den här kursen';
$string['includesubcategories'] = 'Inkludera underkategorier';
$string['includeuserfiles'] = 'Inkludera användarfiler';
$string['increasesections'] = 'Öka antalet sektioner';
$string['indicator:accessesafterend'] = 'Kursen användes efter slutdatum';
$string['indicator:accessesafterend_help'] = 'Denna indikator återspeglar om studenten fick tillträde till kursen efter kursens slutdatum.';
$string['indicator:accessesbeforestart'] = 'Kursen användes före startdatum';
$string['indicator:accessesbeforestart_help'] = 'Denna indikator återspeglar om studenten fick tillträde till kursen före kursens startdatum.';
$string['indicator:activitiesdue'] = 'Aktiviteter som förfaller';
$string['indicator:activitiesdue_help'] = 'Denna användare har aktiviteter som förfallit.';
$string['indicator:anycourseaccess'] = 'Åtkomst till kurs';
$string['indicator:anycourseaccess_help'] = 'Denna indikator återspeglar tillgång till varje kurs användaren är registrerad på.';
$string['indicator:anywrite'] = 'Varje skrivhändelse';
$string['indicator:anywrite_help'] = '';
$string['indicator:anywriteincourse'] = 'Valfri skrivåtgärd i kursen';
$string['indicator:anywriteincourse_help'] = 'Denna indikator representerar eventuella skriv (skicka) -åtgärder som utförts av studenten i någon kursaktivitet.';
$string['indicator:completeduserprofile'] = 'Användarprofilen komplett';
$string['indicator:completeduserprofile_help'] = 'Denna indikator representerar att studenten fyllt i sin användarprofil helt.';
$string['indicator:completeduserprofiledef'] = 'Användarprofilen är klar';
$string['indicator:completeduserprofiledef_help'] = 'Webbplatspolicyerna har godkänts och användaren har fyllt i följande fält: Institution, Avdelning, Adress, Ort, Land, URL.';
$string['indicator:completionenabled'] = 'Spårning av slutförande aktiv';
$string['indicator:completionenabled_help'] = 'Denna indikator återspeglar att spårning av slutförande har aktiverats för denna kurs.';
$string['indicator:nostudent'] = 'Studentregistreringar';
$string['indicator:nostudent_help'] = 'Denna indikator återspeglar att tillgängliga studenter finns för kursen.';
$string['indicator:noteacher'] = 'Lärares tillgänglighet';
$string['indicator:noteacher_help'] = 'Denna indikator reflekterar tillgängligheten av lärare i denna kurs.';
$string['indicator:potentialcognitive'] = 'Potentiellt kognitivt djup i kursen';
$string['indicator:potentialcognitive_help'] = 'Denna indikator är baserad på det potentiellt kognitiva djup som kan uppnås av en student som deltar i kursaktiviteter.';
$string['indicator:potentialcognitivedef'] = 'Potentiellt kognitivt djup i kursen';
$string['indicator:potentialcognitivedef_help'] = 'Den grad till vilken kursen erbjuder ett ”djupt” kognitivt engagemang, som t.ex. inlämning av arbete som ska bedömas, möjligheten att granska andras arbeten samt möjligheten att revidera och skicka in sitt arbete på nytt.';
$string['indicator:potentialcognitivedef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:potentialsocial'] = 'Potentiell social bredd i kursen';
$string['indicator:potentialsocial_help'] = 'Denna indikator är baserad på den potentiella sociala bredd som kan uppnås genom studentens deltagande i kursaktiviteter.';
$string['indicator:potentialsocialdef'] = 'Potentiell social bredd i kursen';
$string['indicator:potentialsocialdef_help'] = 'I vilken grad kursen erbjuder "brett" socialt engagemang, interagera med andra deltagare och med gemenskapen bortom klassen.';
$string['indicator:potentialsocialdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indicator:readactions'] = 'Antal läshändelser';
$string['indicator:readactions_help'] = 'Denna indikator representerar antalet läsåtgärder (visningar) som utförts av studenten.';
$string['indicator:userforumstracking'] = 'Användaren följer forum';
$string['indicator:userforumstracking_help'] = 'Denna indikator representerar huruvida studenten har spårning aktiverad i forumen, eller ej.';
$string['info'] = 'Information';
$string['inprogress'] = 'Pågående';
$string['insertresourceoractivitybefore'] = 'Infoga aktivitet eller resurs före \'{$a->activityname}\'';
$string['institution'] = 'Institution';
$string['instudentview'] = 'i lärandevy';
$string['interests'] = 'Intressen';
$string['interestslist'] = 'Lista över intressen';
$string['interestslist_help'] = 'Ange dina intressen, separerade med kommatecken. Dina intressen kommer att visas på din profilsida som etiketter.';
$string['invalidemail'] = 'Ogiltig e-postadress';
$string['invalidlogin'] = 'Ogiltigt login - vänligen försök igen';
$string['invalidtaskclassname'] = 'Ogiltig aktivitetsklass {$a}';
$string['invalidtaskid'] = 'Ogiltigt uppgifts-ID';
$string['invalidusername'] = 'Användarnamnet får bara innehålla alfanumeriska gemener, understreck (_), bindestreck (-), punkt (.), eller at-symbolen (@).';
$string['invalidusernameupload'] = 'Ogiltigt användarnamn';
$string['ip_address'] = 'IP-adress';
$string['jump'] = 'Hoppa';
$string['jumpto'] = 'Hoppa till...';
$string['keep'] = 'Behåll';
$string['labelvalue'] = '{$a->label}: {$a->value}';
$string['langltr'] = 'Språkriktning vänster-till-höger';
$string['langrtl'] = 'Språkriktning höger-till-vänster';
$string['language'] = 'Språk';
$string['languagegood'] = 'Detta språkpaket är det senaste!  :-)';
$string['languageselector'] = 'Språkväljare';
$string['last'] = 'Sista';
$string['lastaccess'] = 'Senaste åtkomst';
$string['lastcourseaccess'] = 'Senaste åtkomst till kurs';
$string['lastedited'] = 'Senast redigerad';
$string['lastip'] = 'Senaste IP-adress';
$string['lastlogin'] = 'Senaste inloggning';
$string['lastmodified'] = 'Senast ändrad';
$string['lastname'] = 'Efternamn';
$string['lastnamephonetic'] = 'Efternamn - fonetiskt';
$string['lastpage'] = 'Sista sidan';
$string['lastsiteaccess'] = 'Senaste inloggning';
$string['lastyear'] = 'Det senaste året';
$string['latestlanguagepack'] = 'Sök efter det senaste språkpaketet på moodle.org.';
$string['layouttable'] = 'Tabell för layout';
$string['leavetokeep'] = 'Lämna detta tomt om du vill behålla ditt nuvarande lösenord.';
$string['legacylogginginuse'] = 'Den här webbplatsen har för närvarande skrivning till en loggplats i det gamla formatet aktiverad. Skrivning till denna loggplats har avvecklats. Skriv gärna till en loggplats som stöds, som "standard" eller "extern".';
$string['legacythemeinuse'] = 'Denna webbplats visas för dig i kompatibilitetsläge eftersom din webbläsare är för gammal.';
$string['license'] = 'Licens';
$string['licenses'] = 'Licenser';
$string['liketologin'] = 'Vill du logga in nu med ett komplett användarkonto?';
$string['list'] = 'Lista';
$string['listfiles'] = 'Lista över filer i {$a}';
$string['listofallpeople'] = 'Lista över samtliga personer';
$string['listofcourses'] = 'Lista över kurser';
$string['loading'] = 'Laddar';
$string['loadinghelp'] = 'Laddar...';
$string['local'] = 'Lokal';
$string['localplugins'] = 'Lokala pluginmoduler';
$string['localpluginsmanage'] = 'Hantera lokala pluginmoduler';
$string['location'] = 'Plats';
$string['locktimeout'] = 'Operationens tidsgräns överskreds i väntan på låsning.';
$string['log_excel_date_format'] = 'åååå mmmm d t::m';
$string['loggedinas'] = 'Du är inloggad som {$a}';
$string['loggedinasguest'] = 'Du besöker oss just nu som gäst';
$string['loggedinnot'] = 'Du är inte inloggad';
$string['login'] = 'Logga in';
$string['login_failure_logs'] = 'Loggar över misslyckade försök att logga in.';
$string['loginactivity'] = 'Inloggningar';
$string['loginagain'] = 'Logga in på nytt';
$string['loginalready'] = 'Du är redan inloggad.';
$string['loginas'] = 'Logga in som';
$string['loginaspasswordexplain'] = '<p>Du måste mata in det specifika "logga in som, lösenord" för att kunna utnyttja den här egenskapen.<br />Om du inte kan lösenordet, kontakta administratören.</p>';
$string['loginguest'] = 'Logga in som gäst';
$string['loginsite'] = 'Logga in på webbplatsen';
$string['loginsteps'] = 'För att få full åtkomst till denna webbplats måste du först skapa ett konto.';
$string['loginstepsnone'] = 'Hej!
<p>För att få full tillgång till de kurser som du vill delta i måste du skapa ett användarkonto. </p>
<p>Det enda du behöver göra är att skaffa ett användarnamn och lösenord och använda det i formuläret tilll vänster på denna sida!</p>
<p>Om någon annan redan har valt ditt användarnamn så får du försöka igen med ett annat.</p>';
$string['loginto'] = 'Logga in på {$a}';
$string['logoof'] = 'Logo för {$a}';
$string['logout'] = 'Logga ut';
$string['logoutconfirm'] = 'Vill du verkligen logga ut?';
$string['logs'] = 'Loggar';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">mer</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">mer</a> ]';
$string['lookback'] = 'Se tillbaka';
$string['mailadmins'] = 'Informera administratörer';
$string['mailstudents'] = 'Informera studenter';
$string['mailteachers'] = 'Informera lärare';
$string['maincoursepage'] = 'Huvudsida för kurs';
$string['makeafolder'] = 'Skapa mapp';
$string['makeavailable'] = 'Gör tillgänglig';
$string['makeeditable'] = 'Om du gör \'{$a}\' redigerbar via webbservern (t.ex. apache) så kan du redigera denna fil direkt från denna sida.';
$string['makethismyhome'] = 'Gör denna sida till min startsida';
$string['makeunavailable'] = 'Gör otillgänglig';
$string['manageblocks'] = 'Block';
$string['managecategories'] = 'Hantera kurskategorier';
$string['managecategorythis'] = 'Hantera den här kategorin';
$string['managecombined'] = 'Hantera kurskategorier och kurser';
$string['managecontentbanktypes'] = 'Hantera innehållstyper';
$string['managecourses'] = 'Hantera kurser';
$string['managedatabase'] = 'Databas';
$string['managedataformats'] = 'Hantera dataformat';
$string['manageeditorfiles'] = 'Hantera filer som används av editorn';
$string['managefilters'] = 'Filter';
$string['managemodules'] = 'Moduler';
$string['manageroles'] = 'Roller och rättigheter';
$string['markallread'] = 'Markera allt som lästa';
$string['markedthistopic'] = 'Det här ämnet är markerat som det just nu aktuella ämnet.';
$string['markthistopic'] = 'Markera detta ämne som aktuellt  ämne.';
$string['match'] = 'Matcha';
$string['matchingsearchandrole'] = 'Matchande \'{$a->search} "och {$a->role}';
$string['matchofthefollowing'] = 'av följande:';
$string['maxareabytesreached'] = 'Filen (eller den totala storleken av flera filer) är större än det kvarstående utrymmet i den här arean.';
$string['maxfilesize'] = 'Maximal filstorlek: {$a}';
$string['maxfilesreached'] = 'Det är tillåtet att bifoga högst {$a} fil (er) till det här objektet';
$string['maximumchars'] = 'Maximum av {$a} tecken';
$string['maximumgrade'] = 'Maxbetyg';
$string['maximumgradex'] = 'Maxbetyg: {$a}';
$string['maximumshort'] = 'Max';
$string['maximumupload'] = 'Maximal storlek på uppladdade filer.';
$string['maximumupload_help'] = 'Den maximala filstorleken som tillåts för studentuppladdningar till kursen. Dessutom kan du ytterligare begränsa den maximala uppladdningsstorleken för varje aktivitet.';
$string['maxnumberweeks'] = 'Maximalt antal sektioner';
$string['maxnumberweeks_desc'] = 'Det maximala värdet i listrutan "Antal sektioner" (gäller endast för vissa kursformat).';
$string['maxnumcoursesincombo'] = 'Bläddra <a href="{$a->link}">{$a->numberofcourses} kurser</a>';
$string['maxsectionslimit'] = 'Kan inte skapa ny sektion eftersom detta skulle överskrida det maximala antalet tillåtna sektioner ({$a}) för denna kurs.';
$string['maxsize'] = 'Max storlek: {$a}';
$string['maxsizeandareasize'] = 'Maximal filstorlek: {$a->size}, total gräns: {$a->areasize}';
$string['maxsizeandattachments'] = 'Maximal filstorlek: {$a->size}, max antal bilagor: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Maximal filstorlek: {$a->size}, max antal filer: {$a->attachments}, maximal total filstorlek: {$a->areasize}';
$string['memberincourse'] = 'Personer i kursen.';
$string['menu'] = 'Meny';
$string['message'] = 'Meddelande';
$string['messagebody'] = 'Brödtext i meddelande';
$string['messagedselectedusers'] = 'Valda användare har blivit meddelade och mottagarlistan har återställts.';
$string['messagedselectedusersfailed'] = 'Något fel uppstod under det att markerade användare skulle informeras. En del har möjligen inte fått något e-postmeddelande.';
$string['messageprovider:asyncbackupnotification'] = 'Aviseringar om asynkrona säkerhetskopieringar/återställningar';
$string['messageprovider:availableupdate'] = 'Meddelande om nya uppdateringar';
$string['messageprovider:backup'] = 'Notiser om säkerhetskopiering';
$string['messageprovider:badgecreatornotice'] = 'Märkesskapares notiser';
$string['messageprovider:badgerecipientnotice'] = 'Märkesmottagares notiser';
$string['messageprovider:competencyplancomment'] = 'Studieplan kommenterad';
$string['messageprovider:competencyusercompcomment'] = 'Kompetens kommenterad';
$string['messageprovider:coursecompleted'] = 'Kurs slutförd';
$string['messageprovider:coursecontentupdated'] = 'Innehållsändringar i kurs';
$string['messageprovider:courserequestapproved'] = 'Meddelande om godkänd begäran av ny kurs';
$string['messageprovider:courserequested'] = 'Meddelande om begäran av ny kurs';
$string['messageprovider:courserequestrejected'] = 'Meddelande om avvisad begäran av ny kurs';
$string['messageprovider:enrolcoursewelcomemessage'] = 'Välkomstmeddelande för nya kursregistreringar';
$string['messageprovider:errors'] = 'Allvarliga fel med webbplatsen';
$string['messageprovider:errors_help'] = 'Dessa är viktiga fel som en administratör bör veta om.';
$string['messageprovider:failedtaskmaxdelay'] = 'Aktiviteten når sin maximala felfördröjning';
$string['messageprovider:gradenotifications'] = 'Betygsaviseringar';
$string['messageprovider:infected'] = 'Aviseringar om antivirusfel';
$string['messageprovider:insights'] = 'Insikter genererade av förutsägelsemodeller';
$string['messageprovider:instantmessage'] = 'Personliga meddelanden mellan användare';
$string['messageprovider:instantmessage_help'] = 'Detta avsnitt konfigurerar vad som händer med meddelanden som skickas till dig direkt från andra användare på denna webbplats.';
$string['messageprovider:messagecontactrequests'] = 'Notis om kontaktförfrågan';
$string['messageprovider:newlogin'] = 'Aviseringar om ny inloggning';
$string['messageprovider:notices'] = 'Meddelanden om mindre problem';
$string['messageprovider:notices_help'] = 'Dessa är meddelanden som en administratör kan vara intresserad av att se.';
$string['messageprovider:reportbuilderschedule'] = 'Anpassade scheman för rapportbyggare';
$string['messageselect'] = 'Välj den här användaren som mottagare av meddelanden';
$string['messageselectadd'] = 'Skicka meddelande';
$string['middlename'] = 'Mellannamn';
$string['migratinggrades'] = 'Migrerar (flyttar) betyg';
$string['min'] = 'min';
$string['mins'] = 'min';
$string['minute'] = 'minut';
$string['minutes'] = 'minuter';
$string['miscellaneous'] = 'Diverse';
$string['missingcategory'] = 'Du måste välja en kategori.';
$string['missingdescription'] = 'Beskrivning saknas';
$string['missingemail'] = 'E-postadress saknas';
$string['missingfirstname'] = 'Förnamn saknas';
$string['missingfromdisk'] = 'Saknas från skivan';
$string['missingfullname'] = 'Fullständigt namn saknas';
$string['missinglastname'] = 'Efternamn saknas';
$string['missingname'] = 'Ett namn saknas';
$string['missingnewpassword'] = 'Nytt lösenord saknas';
$string['missingpassword'] = 'Lösenord saknas';
$string['missingrecaptchachallengefield'] = 'Misslyckad reCAPTCHA-utmaning. Försök igen.';
$string['missingreqreason'] = 'Skäl saknas';
$string['missingshortname'] = 'Kort namn saknas';
$string['missingshortsitename'] = 'Kortform av webbplatsens namn saknas';
$string['missingsitedescription'] = 'Webbplatsbeskrivning saknas';
$string['missingsitename'] = 'Webbplatsnamn saknas';
$string['missingstrings'] = 'Kontrollera för oöversatta ord eller fraser';
$string['missingstudent'] = 'Du måste välja något';
$string['missingsummary'] = 'Sammanfattning saknas';
$string['missingteacher'] = 'Du måste välja något';
$string['missingurl'] = 'URL saknas';
$string['missingusername'] = 'Användarnamn saknas';
$string['moddoesnotsupporttype'] = 'Aktiviteten {$a->modname} stöder inte uppladdning av filer av typen {$a->type}';
$string['modhide'] = 'Dölj';
$string['modified'] = 'Modifierad';
$string['modshow'] = 'Visa';
$string['moduleintro'] = 'Beskrivning';
$string['modulesetup'] = 'Sätter upp modultabeller...';
$string['modulesuccess'] = '{$a} tabeller har satts upp korrekt.';
$string['modulesused'] = 'Använda moduler';
$string['modvisible'] = 'Tillgänglighet';
$string['modvisible_help'] = '* Visa på kurssidan: Tillgänglig för studenter (med förbehåll för eventuella åtkomstbegränsningar som kan ställas in).
* Dölj på kurssida: Ej tillgängligt för studenter.';
$string['modvisiblehiddensection'] = 'Tillgänglighet';
$string['modvisiblehiddensection_help'] = '* Dölj på kurssida: Ej tillgängligt för studenter.
* Tillgänglig men visa inte på kurssidan: Tillgänglig för studenter om du anger en länk. Aktiviteter kommer fortfarande att visas i betygsboken och andra rapporter.';
$string['modvisiblewithstealth'] = 'Tillgänglighet';
$string['modvisiblewithstealth_help'] = '* Visa på kurssidan: Tillgänglig för studenter (med förbehåll för eventuella åtkomstbegränsningar som kan ställas in).
* Dölj på kurssida: Ej tillgängligt för studenter.
* Tillgänglig men visa inte på kurssidan: Tillgänglig för studenter om du anger en länk. Aktiviteter kommer fortfarande att visas i betygsboken och andra rapporter.';
$string['month'] = 'Månad';
$string['months'] = 'Månader';
$string['moodledocs'] = 'Moodle-dokumentation';
$string['moodledocslink'] = 'Hjälp och dokumentation';
$string['moodlelogo'] = 'Moodie-logotyp';
$string['moodlenet:cannotconnecttoserver'] = 'Kunde inte koppla upp mot MoodleNet-servern';
$string['moodlenet:columnname'] = 'Namn';
$string['moodlenet:columnsenddate'] = 'Skicka datum';
$string['moodlenet:columnsendstatus'] = 'Skicka status';
$string['moodlenet:columntype'] = 'Typ';
$string['moodlenet:configoauthservice'] = 'Välj en MoodleNet OAuth 2-tjänst för att möjliggöra delning till den MoodleNet-webbplatsen. Om tjänsten inte finns ännu måste du <a href="{$a}">skapa</a> den.';
$string['moodlenet:deletedactivity'] = 'Raderad aktivitet';
$string['moodlenet:deletedcourse'] = 'Raderad kurs';
$string['moodlenet:eventresourceexported'] = 'Resurs exporterad';
$string['moodlenet:gotomoodlenet'] = 'Gå till MoodleNet-utkast';
$string['moodlenet:issuerisnotauthorized'] = 'MoodleNet-utgivaren är inte auktoriserad';
$string['moodlenet:issuerisnotenabled'] = 'MoodleNet-utgivaren är inte aktiverad';
$string['moodlenet:issuerisnotset'] = 'MoodleNet-utgivaren är inte webbplatsadministratör';
$string['moodlenet:nosharedresources'] = 'Det finns inga delade resurser att visa för närvarande.';
$string['moodlenet:outboundsettings'] = 'MoodleNet utgående inställningar';
$string['moodlenet:packagingandsending'] = 'Packar din fil och skickar till MoodleNet...';
$string['moodlenet:sharefailtext'] = 'Ett fel uppstod när ditt innehåll skulle skickas till MoodleNet.<br>Försök gärna igen senare.';
$string['moodlenet:sharefailtextwithsitesupport'] = 'Det uppstod ett fel när ditt innehåll skulle delas till MoodleNet.<br>Försök igen senare eller <a href="{$a}">kontakta webbplatssupporten</a>.';
$string['moodlenet:sharefailtitle'] = 'Ett fel uppstod';
$string['moodlenet:sharefilesizelimitexceeded'] = 'Storleken på resursen som delas ({$a->filesize} bytes) överskrider gränsen på {$a->filesizelimit} bytes.';
$string['moodlenet:sharenoticeactivity'] = 'Denna aktivitet delas med MoodleNet som en resurs.';
$string['moodlenet:sharenoticecourse'] = 'Den här kursen delas med MoodleNet som en resurs.';
$string['moodlenet:sharenoticepartial'] = 'De utvalda aktiviteterna delas med MoodleNet som en resurs.';
$string['moodlenet:sharesuccesstext'] = 'Snart klar! Gå till dina utkast i MoodleNet för att slutföra uppgiften att dela ditt innehåll.';
$string['moodlenet:sharesuccesstitle'] = 'Sparad till utkast i MoodleNet';
$string['moodlenet:sharetomoodlenet'] = 'Spara i MoodleNet';
$string['moodlenet:sharetyperesource'] = 'resurs';
$string['moodlenet:sharinglargefile'] = 'Det kan ta lite tid om filen är stor.';
$string['moodlenet:sharingstatus'] = 'Sparar i MoodleNet';
$string['moodlenet:sharingto'] = 'Delar till:';
$string['moodlerelease'] = 'Moodleversion';
$string['moodleservicesandsupport'] = 'Service och support';
$string['moodleversion'] = 'Moodleversion';
$string['more'] = 'mer';
$string['moreactions'] = 'Fler åtgärder';
$string['morehelp'] = 'Mer hjälp';
$string['morehelpaboutmodule'] = 'Ytterligare hjälp för {$a}-aktiviteten';
$string['moreinfo'] = 'Mer information';
$string['moreinformation'] = 'Mer information om detta fel.';
$string['moremenu'] = 'Mer';
$string['morenavigationlinks'] = 'Mer...';
$string['moreprofileinfoneeded'] = 'Berätta mer om dig själv';
$string['mostrecently'] = 'allra senaste';
$string['move'] = 'Flytta';
$string['movecategoriessuccess'] = 'Flyttade {$a->count} kategorier in i kategori \'{$a->to}\'';
$string['movecategoriestotopsuccess'] = 'Flyttade framgångsrikt {$a->count} kategorier till högsta nivå';
$string['movecategorycontentto'] = 'Flytta till';
$string['movecategorysuccess'] = 'Flyttade kategori \'{$a->moved}\' in i kategori \'{$a->to}\'';
$string['movecategoryto'] = 'Flytta kategori till:';
$string['movecategorytotopsuccess'] = 'Flyttade framgångsrikt kategori {$a->count} till högsta nivå';
$string['movecontent'] = 'Flytta {$a}';
$string['movecontentafter'] = 'Efter "{$a}"';
$string['movecontentstoanothercategory'] = 'Flytta innehåll till en annan kategori';
$string['movecontenttothetop'] = 'Till början av listan';
$string['movecoursemodule'] = 'Flytta aktivitet';
$string['movecoursesection'] = 'Flytta sektion';
$string['movecourseto'] = 'Flytta kurs till:';
$string['movedown'] = 'Flytta ner';
$string['movefilestohere'] = 'Flytta filerna hit';
$string['movefull'] = 'Flytta {$a} hit:';
$string['movehere'] = 'Flytta hit:';
$string['moveleft'] = 'Flytta till vänster';
$string['moveright'] = 'Flytta till höger';
$string['movesection'] = 'Flytta sektion {$a}';
$string['moveselectedcategoriesto'] = 'Flytta valda kategorier till';
$string['moveselectedcoursesto'] = 'Flytta valda kurser till...';
$string['movetoanotherfolder'] = 'Flytta till en annan mapp';
$string['moveup'] = 'Flytta upp';
$string['mustchangepassword'] = 'Det nya lösenordet måste vara ett annat än det nuvarande.';
$string['mustconfirm'] = 'Du måste bekräfta ditt konto';
$string['mycourses'] = 'Mina kurser';
$string['myfiles'] = 'Mina privata filer';
$string['myfilesmanage'] = 'Hantera mina privata filer';
$string['myhome'] = 'Översikt';
$string['mymoodledashboard'] = 'Min Moodle panel';
$string['myprofile'] = 'Min profil';
$string['name'] = 'Namn';
$string['namedfiletoolarge'] = 'Filen  \'{$a->filename}\' är för stor och kan inte laddas upp';
$string['nameforlink'] = 'Vad vill du kalla den här länken?';
$string['nameforpage'] = 'Namn';
$string['navigation'] = 'Navigering';
$string['needed'] = 'Nödvändig';
$string['networkdropped'] = 'Vi har upptäckt att din Internet-anslutning är opålitlig eller har avbrutits. <br /> Var medveten om att ändringar inte kan sparas på rätt sätt förrän din anslutning förbättras.';
$string['never'] = 'Aldrig';
$string['neverdeletelogs'] = 'Ta aldrig bort loggar';
$string['new'] = 'Nytt';
$string['newaccount'] = 'Nytt konto';
$string['newactivityname'] = 'Nytt namn för aktiviteten {$a}';
$string['newcourse'] = 'Ny kurs';
$string['newloginnotificationbodyfull'] = '<p>Hej {$a->userfullname},</p>
<p>Ditt {$a->sitename}-konto användes precis för att logga in från en annan enhet.</p>
<ul>
<li>Konto: {$a->username} {$a->useremail}</li>
<li>{$a->logintime}</li>
<li>Enhet: {$a->logindevice}</li>
<li>IP: {$a->loginip}</li>
</ul>
<p>Om detta är du behöver du inte göra något.</p>
<p>Om det <strong>inte</strong> är du, vänligen <a href="{$a->changepasswordlink}">ändra ditt lösenord</a></p>';
$string['newloginnotificationbodysmall'] = 'Ditt {$a}-konto användes precis för att logga in från en annan enhet.';
$string['newloginnotificationtitle'] = 'Ny inloggning till ditt {$a}-konto';
$string['newpassword'] = 'Nytt lösenord';
$string['newpassword_help'] = 'Ange ett nytt lösenord eller lämna tomt för att behålla nuvarande lösenord.';
$string['newpasswordfromlost'] = '<strong>OBS!</strong>ditt</strong> nuvarande lösenord<strong> har skickats till dig i det<strong> andra</strong> av de två e-postmeddelanden som har skickats som del av den här processen för att återställa lösenordet. Se till att du har fått det nya lösenordet innan du fortsätter med den här skärmen.';
$string['newpasswordtext'] = 'Hej {$a->firstname},

Ditt kontolösenord på {$a->sitename} har återställts
och du har fått ett nytt tillfälligt lösenord.

Dina nuvarande inloggningsuppgifter är nu:
   användarnamn: {$a->username}
   lösenord: {$a->newpassword}

Gå till den här sidan för att ändra ditt lösenord:
   {$a->link}

I de flesta e-postprogram bör detta visas som en blå länk som du kan klicka på. Om det inte fungerar kan du klippa ut adressen och klistra in den i adressfältet högst upp i webbläsarfönstret.

Hälsningar från administratören på {$a->sitename},

 {$a->signoff}';
$string['newpicture'] = 'Ny bild';
$string['newpicture_help'] = 'Om du vill lägga till en ny bild bläddrar du och väljer en bild (i JPG- eller PNG-format) och klickar sedan på "Uppdatera profil". Bilden kommer att beskäras till en fyrkant som är 100x100 pixlar.';
$string['newpictureusernotsetup'] = 'Du måste först spara all obligatorisk profilinformation innan du kan ladda upp en profilbild.';
$string['newsectionname'] = 'Nytt namn för sektionen {$a}';
$string['newsitem'] = 'Notis';
$string['newsitems'] = 'nyheter';
$string['newsitemsnumber'] = 'Antal nyhetsnotiser att visa';
$string['newsitemsnumber_help'] = 'Forumet \'Nyheter\' är ett speciellt forum som skapas automatiskt i kursen. För detta forum är prenumeration som standard satt till obligatorisk och endast användare med rätt behörighet (som standard lärare) kan göra inlägg i det.

Om ett nyhetsforum inte krävs i kursen, bör den här inställningen anges till noll.

Den här inställningen avgör hur många \'senaste nyheter\' som ska visas i blocket Senaste nyheter.';
$string['newuser'] = 'Ny användare';
$string['newusernewpasswordsubj'] = 'Nytt användarkonto';
$string['newusernewpasswordtext'] = 'Hej {$a->firstname}!

Ett konto har skapats åt dig på \'{$a->sitename}\'.

 användarnamn: {$a->username}
 lösenord: {$a->newpassword}

(Du kommer att bli ombedd att ändra ditt lösenord när du loggar in för första gången.)

För att börja använda \'{$a->sitename}\', logga in på
 {$a->link}

Om du behöver hjälp, kontakta webbplatsens administratör,
{$a->signoff}';
$string['newusers'] = 'Nya användare';
$string['newwindow'] = 'Nytt fönster';
$string['next'] = 'Nästa';
$string['nextpage'] = 'Nästa sida';
$string['nextsection'] = 'Nästa sektion';
$string['no'] = 'Nej';
$string['noblockstoaddhere'] = 'Det finns inga block som du kan lägga till den här sidan.';
$string['nobody'] = 'Ingen';
$string['nochange'] = 'Ingen förändring';
$string['nocomments'] = 'Inga kommentarer';
$string['nocourses'] = 'Inga kurser';
$string['nocoursesfound'] = 'Inga kurser som innehåller orden \'{$a}\' kunde hittas.';
$string['nocoursestarttime'] = 'Kursen har inget startdatum.';
$string['nocoursesyet'] = 'Inga kurser i denna kategori';
$string['nodstpresets'] = 'Administratören har inte aktiverat stöd för sommartid.';
$string['nofilesselected'] = 'Inga filer har valts för att återställas.';
$string['nofilesyet'] = 'Inga filer har laddats upp till din kurs ännu.';
$string['nofiltersapplied'] = 'Inga aktiva filter';
$string['nograde'] = 'Inget betyg';
$string['nohelpforactivityorresource'] = 'Det finns för närvarande ingen hjälp för denna resurs eller aktivitet';
$string['noimagesyet'] = 'Inga bilder har laddats upp till din kurs ännu.';
$string['nologsfound'] = 'Det gick inte att hitta några loggar';
$string['nomatchingusers'] = 'Inga användare matchar \'{$a}\'';
$string['nomorecourses'] = 'Inga fler matchande kurser kunde hittas.';
$string['nomoreidnumber'] = 'För att undvika kollisioner används inga id-nummer.';
$string['none'] = 'Ingen';
$string['noneditingteacher'] = 'Icke-redigerande lärare';
$string['noneditingteacherdescription'] = 'Icke-redigerande lärare kan undervisa på kurser och betygssätta/avge omdömen om studenter men inte ändra aktiviteter.';
$string['nonstandard'] = 'Icke-standard';
$string['nopendingcourses'] = 'Det finns inga kurser som väntar på godkännande';
$string['nopotentialadmins'] = 'Inga möjliga administratörer';
$string['nopotentialcreators'] = 'Inga möjliga kursutvecklare';
$string['nopotentialstudents'] = 'Inga möjliga studenter';
$string['nopotentialteachers'] = 'Inga möjliga lärarna';
$string['norecentactivity'] = 'Ingen aktivitet på sistone';
$string['noreplybouncemessage'] = 'Du har skickat ett svar till e-postadress som inte tar emot några svar. Om du försökte att besvara ett inlägg i ett forum, var då snäll och svara genom att använda {$a} forumen.

Det nedanstående är innehållet i ditt e-postmeddelande:';
$string['noreplybouncesubject'] = '{$a} - returnerad e-post';
$string['noreplyname'] = 'Svara inte på detta e-postmeddelande';
$string['noresetrecord'] = 'Det går inte att hitta någon information om den här återställningsbegäran. Vänligen påbörja en ny begäran om lösenordsåterställning.';
$string['noresults'] = 'Inga resultat';
$string['noresultsfor'] = 'Inga resultat för "{$a}"';
$string['normal'] = 'Normal';
$string['normalfilter'] = 'Normalt filter';
$string['nosite'] = 'Det gick inte att hitta en kurs på webbplatsnivå.';
$string['nostudentsfound'] = 'Hittade ingen/inga  {$a}';
$string['nostudentsingroup'] = 'Det finns inga studenter i den här gruppen ännu.';
$string['nostudentsyet'] = 'Det finns inga deltagare i den här kursen.';
$string['nosuchemail'] = 'Ingen sådan e-postadress';
$string['notavailable'] = 'Ej tillgänglig';
$string['notavailablecourse'] = '{$a} är ej tillgänglig';
$string['noteachersyet'] = 'Inga lärarna för denna kurs ännu.';
$string['noteachingupcomingcourses'] = 'Kommande kurser saknar lärare eller studenter';
$string['notenrolled'] = '{$a} är inte registrerad på denna kurs.';
$string['notenrolledprofile'] = 'Den här profilen är inte tillgänglig eftersom den här användaren inte är registrerad på den här kursen.';
$string['noteusercannotrolldatesoncontext'] = 'Möjligheten att ändra  startdatum (rulla datum) vid återställning av denna säkerhetskopia har inaktiverats eftersom du saknar den behörighet som krävs';
$string['noteuserschangednonetocourse'] = 'OBS! När användardata återställs måste användarna av denna kurs också återställas. Denna inställning har ändrats för dig.';
$string['nothingnew'] = 'Inget nytt sedan din senaste inloggning.';
$string['nothingtodisplay'] = 'Inget att visa.';
$string['notice'] = 'Notis';
$string['noticenewerbackup'] = 'Den här säkerhetskopierade filen har skapats med Moodles {$a->backuprelease} ({$a->backupversion}) och den är nyare än din nyligen installerade Moodle {$a->serverrelease} ({$a->serverversion}). Det här kan skapa en del ev oönskade förändringar eftersom det inte går att garantera bakåtkompatibilitet för säkerhetskopierade filer.';
$string['notifications'] = 'Uppdateringar';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Användare: {$a->info}, Fullständigt namn: {$a->name}';
$string['notifyloginfailuresmessageend'] = 'Du kan se dessa loggar på {$a}.';
$string['notifyloginfailuresmessagestart'] = 'Här är en lista över misslyckade försök att logga in på {$a} sedan du senast fick meddelande om sådana.';
$string['notifyloginfailuressubject'] = '{$a} :: Information om misslyckade försök att logga in.';
$string['notincluded'] = 'Ej inkluderat';
$string['notingroup'] = 'Du måste tyvärr vara med i en grupp för att se den här sidan.';
$string['notpublic'] = 'Inte offentlig';
$string['nousersfound'] = 'Det gick inte att hitta några användare';
$string['nousersmatching'] = 'Inga användare som matchar \'{$a}\'  kunde hittas.';
$string['nousersyet'] = 'Det finns inga användare ännu.';
$string['novalidcourses'] = 'Inga giltiga kurser kommer att visas';
$string['now'] = 'nu';
$string['numattempts'] = '{$a} misslyckade försök att logga in.';
$string['numberofcourses'] = 'Antal kurser';
$string['numberweeks'] = 'Antal sektioner';
$string['numday'] = '{$a} dag';
$string['numdays'] = '{$a} dagar';
$string['numhours'] = '{$a} timmar';
$string['numletters'] = '{$a} bokstäver';
$string['numminutes'] = '{$a} minuter';
$string['nummonth'] = '{$a} månad';
$string['nummonths'] = '{$a} månader';
$string['numseconds'] = '{$a} sekunder';
$string['numviews'] = '{$a} besök';
$string['numweek'] = '{$a} vecka';
$string['numweeks'] = '{$a} veckor';
$string['numwords'] = '{$a} ord';
$string['numyear'] = '{$a} år';
$string['numyears'] = '{$a} år';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Nuvarande lösenord';
$string['olduserdirectory'] = 'Detta är den GAMLA katalogen över användare och den behövs inte längre. Du kan lugnt ta bort den. De filer som den innehåller har kopierats över till den NYA
katalogen över användare.';
$string['opendrawerblocks'] = 'Öppna blockmeny';
$string['opendrawerindex'] = 'Öppna kurskatalog';
$string['opensinnewwindow'] = 'Öppnas i nytt fönster';
$string['operator_and'] = 'och';
$string['operator_andnot'] = 'och';
$string['operator_or'] = 'eller';
$string['optional'] = 'valfri';
$string['options'] = 'alternativ';
$string['order'] = 'Ordning';
$string['originalpath'] = 'Original sökväg';
$string['orphanedactivitiesinsectionno'] = 'Föräldralösa aktiviteter (sektion {$a})';
$string['other'] = 'Annat';
$string['outline'] = 'Disposition';
$string['outlinereport'] = 'Översiktsrapport';
$string['page'] = 'Sida';
$string['pagea'] = 'Sida {$a}';
$string['pagedcontentnavigation'] = 'Sidvis navigering';
$string['pagedcontentnavigationactiveitem'] = 'Aktuell sida, sida {$a}';
$string['pagedcontentnavigationitem'] = 'Gå till sida {$a}';
$string['pagedcontentpagingbaritemsperpage'] = 'Visa {$a} poster per sida';
$string['pageheaderconfigablock'] = 'Konfigurerar ett block i {$a->fullname}';
$string['pagepath'] = 'Sidans sökväg';
$string['pageshouldredirect'] = 'Denna sida bör automatiskt omdirigeras. Om ingenting händer kan du använda Fortsätt länken nedan.';
$string['parentcategory'] = 'Överliggande kategori';
$string['parentcoursenotfound'] = 'Det gick inte att hitta någon \'föräldra\'-kurs.';
$string['parentfolder'] = '\'Föräldra\'-katalog';
$string['participants'] = 'Deltagare';
$string['participantslist'] = 'Deltagarlistan';
$string['participationratio'] = 'Omfattning av deltagande';
$string['participationreport'] = 'Deltaganderapport';
$string['password'] = 'Lösenord';
$string['passwordchanged'] = 'Lösenordet har ändrats.';
$string['passwordconfirmchange'] = 'Bekräfta ändring av lösenord';
$string['passwordextlink'] = 'Den följande länken är till för att hjälpa dig att återvinna ditt förlorade lösenord. du kommer att lämna Moodle.';
$string['passwordforgotten'] = 'Glömt lösenord';
$string['passwordforgotteninstructions'] = 'Moodle måste först hitta uppgifter om din person i databasen. Skriv därför in <strong> antingen</strong> ditt användarnamn eller den e-postadress som du har registrerat. Du behöver inte skriva in båda.';
$string['passwordforgotteninstructions2'] = 'För att återställa ditt lösenord, fyll i ditt användarnamn eller e-postadress nedan. Om vi kan hitta dig i databasen skickar vi ett meddelande till din e-postadress med vidare instruktioner.';
$string['passwordnohelp'] = 'Det går inte att hitta ditt lösenord. Vänligen kontakta din Moodle-administratör.';
$string['passwordpolicynomatch'] = 'Ditt nuvarande lösenord uppfyller inte längre lösenordskraven. {$a}';
$string['passwordrecovery'] = 'Ja, hjälp mig att logga in';
$string['passwordsdiffer'] = 'Dessa lösenord matchar inte.';
$string['passwordsent'] = 'Lösenord har skickats.';
$string['passwordsenttext'] = '<p>Vi har skickat ett e-postbrev till din adress:<br /> {$a->email}.</p>
   <p><b>Läs e-postmeddelandet för att se ditt nya lösenord</b></p>
   <p>Detta lösenord har skapats automatiskt och om du vill kan du<br />
   <a href="{$a->link}">ändra lösenordet</a>  till något som är lättare att komma ihåg.</p>';
$string['passwordset'] = 'Ditt lösenord har uppdaterats.';
$string['path'] = 'Sökväg';
$string['pathnotexists'] = 'Sökvägen finns inte på din server!';
$string['pathslasherror'] = 'Sökvägar kan inte avslutas med snedstreck (\'/\' eller \'\\\')';
$string['paymentinstant'] = 'Använd knappen nedan för att betala och bli registrerad inom några minuter!';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> avvaktande</small>)';
$string['paymentrequired'] = 'För att få tillgång till den här kursen måste du först betala.';
$string['payments'] = 'Betalningar';
$string['paymentsorry'] = 'Tack för din betalning! Tyvärr är din betalning ännu inte helt färdigbehandlad och du är ännu inte registrerad för att komma in i kursen "{$a->fullname}". Försök gärna gå till kursen igen om några sekunder. Om du fortsätter att ha problem att komma åt kursen, meddela {$a->teacher} eller webbplatsadministratören.';
$string['paymentthanks'] = 'Tack för din betalning! Du är nu registrerad på din kurs: <br />"{$a}"';
$string['pendingrequests'] = 'Väntande förfrågningar';
$string['percents'] = '{$a}%';
$string['periodending'] = 'Perioden upphör ({$a})';
$string['perpage'] = 'Per sida';
$string['perpagea'] = 'Per sida: {$a}';
$string['personal'] = 'Personlig';
$string['personalprofile'] = 'Personlig profil';
$string['phone'] = 'Telefon';
$string['phone1'] = 'Telefon';
$string['phone2'] = 'Mobiltelefon';
$string['phpinfo'] = 'PHP-info';
$string['picture'] = 'Bild';
$string['pictureof'] = 'Bild på {$a}';
$string['pictureofuser'] = 'Användarbild';
$string['placeholdertypeorselect'] = 'Skriv eller välj...';
$string['pleaseclose'] = 'V.g. stäng detta fönster nu.';
$string['pleasesearchmore'] = 'Var god och sök mer';
$string['pleaseusesearch'] = 'Använd sök';
$string['plugin'] = 'Pluginmodul';
$string['pluginarea'] = 'Område';
$string['plugincheck'] = 'Kontroll av plugins';
$string['plugindeletefiles'] = 'All data som är associerad med pluginmodulen <em>{$a->name}</em> har tagits bort från databasen. För att förhindra att den installeras på nytt bör du nu ta bort den här katalogen från servern: <em>{$a->directory}</em>';
$string['pluginitemid'] = 'Objekt-ID';
$string['pluginmissingfromdisk'] = '{$a->name} (saknas på disken)';
$string['pluginsetup'] = 'Installerar tabeller för pluginmoduler';
$string['policyaccept'] = 'Jag förstår och accepterar';
$string['policyagree'] = 'Du måste godkänna denna policy för få fortsätta att använda denna webbplats. Godkänner du denna policy?';
$string['policyagreement'] = 'Webbplatspolicy';
$string['policyagreementclick'] = 'Länk till webbplatspolicyn';
$string['popup'] = 'popup';
$string['popupwindow'] = 'Öppna filen i ett nytt fönster .';
$string['popupwindowname'] = 'Popup-fönster';
$string['post'] = 'Inlägg';
$string['posts'] = 'Inlägg';
$string['potentialadmins'] = 'Möjliga administratörer';
$string['potentialcreators'] = 'Möjliga kursutvecklare';
$string['potentialstudents'] = 'Möjliga studenter';
$string['potentialteachers'] = 'Möjliga lärarna';
$string['poweredbymoodle'] = 'Byggt med <a href="https://moodle.com">Moodle</a>';
$string['preferences'] = 'Inställningar';
$string['preferredlanguage'] = 'Välj språk';
$string['preferredtheme'] = 'Det tema du föredrar att använda';
$string['preprocessingbackupfile'] = 'Förbehandlar säkerhetskopian';
$string['prev'] = 'Föreg';
$string['preview'] = 'Förhandsgranska';
$string['previeworchoose'] = 'Förhandsgranska eller välj ett tema';
$string['previewthemename'] = 'Förhandsgranska tema \'{$a}\'';
$string['previous'] = 'Föregående';
$string['previouslyselectedusers'] = 'Tidigare valda användare matchar inte \'{$a}\'';
$string['previouspage'] = 'Föregående sida';
$string['previoussection'] = 'Föregående sektion';
$string['primaryadminsetup'] = 'Konfigurera ett administratörskonto';
$string['privacy:metadata:config_log'] = 'Logg över förändringar i inställningarna.';
$string['privacy:metadata:config_log:name'] = 'Namnet på inställningen ändras.';
$string['privacy:metadata:config_log:oldvalue'] = 'Det tidigare värdet för denna inställning.';
$string['privacy:metadata:config_log:plugin'] = 'Pluginmodul som ändrats.';
$string['privacy:metadata:config_log:timemodified'] = 'Tidpunkten för ändringen.';
$string['privacy:metadata:config_log:userid'] = 'Användaren som gjorde ändringen.';
$string['privacy:metadata:config_log:value'] = 'Det nya värdet för denna inställning.';
$string['privacy:metadata:events_queue'] = 'Kön med användarhändelser som väntar på att behandlas.';
$string['privacy:metadata:events_queue:eventdata'] = 'Händelsedata';
$string['privacy:metadata:events_queue:stackdump'] = 'Eventuell stacktrace kopplad till denna händelse.';
$string['privacy:metadata:events_queue:timecreated'] = 'Tidpunkten då denna händelse skapades.';
$string['privacy:metadata:events_queue:userid'] = 'Användar-ID kopplat till denna händelse';
$string['privacy:metadata:log'] = 'En samling med tidigare händelser';
$string['privacy:metadata:log:action'] = 'En beskrivning av åtgärden';
$string['privacy:metadata:log:cmid'] = 'cmid';
$string['privacy:metadata:log:course'] = 'Kurs';
$string['privacy:metadata:log:info'] = 'Ytterligare information';
$string['privacy:metadata:log:ip'] = 'IP-adressen som användes vid tidpunkten för händelsen';
$string['privacy:metadata:log:module'] = 'Modul';
$string['privacy:metadata:log:time'] = 'Tidpunkten då åtgärden ägde rum';
$string['privacy:metadata:log:url'] = 'URL associerad med händelsen';
$string['privacy:metadata:log:userid'] = 'ID för användaren som utförde åtgärden';
$string['privacy:metadata:oauth2_refresh_token'] = 'Uppdatera token som används för OAuth 2.0-kommunikation';
$string['privacy:metadata:oauth2_refresh_token:issuerid'] = 'ID för den användare detta token avser';
$string['privacy:metadata:oauth2_refresh_token:scopehash'] = 'ID för den användare detta token motsvarar';
$string['privacy:metadata:oauth2_refresh_token:timecreated'] = 'Tidpunkt då detta token skapades';
$string['privacy:metadata:oauth2_refresh_token:timemodified'] = 'Tidpunkt då detta token senast uppdaterades';
$string['privacy:metadata:oauth2_refresh_token:token'] = 'Uppdaterings-token för respektive scope och användare';
$string['privacy:metadata:oauth2_refresh_token:userid'] = 'ID för den användare detta token motsvarar';
$string['privacy:metadata:task_adhoc'] = 'Status för oplanerade åtgärder.';
$string['privacy:metadata:task_adhoc:component'] = 'Komponent som är ägare av uppgiften.';
$string['privacy:metadata:task_adhoc:nextruntime'] = 'Tidigaste tidpunkten att köra uppgiften.';
$string['privacy:metadata:task_adhoc:userid'] = 'Användare som används för att köra uppgiften.';
$string['privacy:metadata:task_log'] = 'Output för logg';
$string['privacy:metadata:task_log:component'] = 'Komponent som är ägare av uppgiften.';
$string['privacy:metadata:task_log:userid'] = 'Användaren uppgiften tillhörde.';
$string['privacy:metadata:upgrade_log'] = 'Uppgraderingsloggen.';
$string['privacy:metadata:upgrade_log:backtrace'] = 'Backtrace kopplad till detta uppgraderingssteg.';
$string['privacy:metadata:upgrade_log:details'] = 'Ytterligare information relaterat till uppgraderingen.';
$string['privacy:metadata:upgrade_log:info'] = 'Huvudinformation för detta uppgraderingssteg.';
$string['privacy:metadata:upgrade_log:plugin'] = 'Pluginmodul som uppgraderats.';
$string['privacy:metadata:upgrade_log:targetversion'] = 'Ny version att uppgradera till.';
$string['privacy:metadata:upgrade_log:timemodified'] = 'Tidpunkten för uppgraderingen.';
$string['privacy:metadata:upgrade_log:type'] = 'Typ av loggpost.';
$string['privacy:metadata:upgrade_log:userid'] = 'Användaren som utförde uppgraderingen.';
$string['privacy:metadata:upgrade_log:version'] = 'Pluginmodulens gamla version.';
$string['private_files_handler'] = 'Spara bilagor till ett e-post i användarens privata bibliotek.';
$string['private_files_handler_name'] = 'E-post till till privat bibliotek.';
$string['privatefiles'] = 'Privata filer';
$string['privatefilesmanage'] = 'Hantera privata filer';
$string['proceed'] = 'Fortsätt';
$string['profile'] = 'Profil';
$string['profilenotshown'] = 'Den här profilbeskrivningen kommer inte att visas förrän denna person är inskriven i minst en kurs.';
$string['progress'] = 'Framsteg';
$string['publicprofile'] = 'Offentlig profil';
$string['publicsitefileswarning'] = 'Obs! de filer som är placerade här är tillgängliga för alla.';
$string['publicsitefileswarning2'] = 'Obs! Filer placerade här kan nås av vem som helst som känner (eller kan gissa) URL. Av säkerhetsskäl rekommenderas att alla säkerhetskopior raderas omedelbart efter att återställts.';
$string['publicsitefileswarning3'] = 'Obs! Filer placerade här kan nås av vem som helst som känner (eller kan gissa) URL. <br /> Av säkerhetsskäl bör säkerhetskopior sparas i den säkra mappen för säkerhetskopior.';
$string['question'] = 'Fråga';
$string['questionsinthequestionbank'] = 'Frågor i frågebanken';
$string['queued'] = 'Köad';
$string['quotausage'] = 'Du har använt {$a->used} av totalt {$a->total}';
$string['readinginfofrombackup'] = 'Läser från säkerhetskopia';
$string['readme'] = 'LAESMIG';
$string['recentactivity'] = 'Aktuell aktivitet';
$string['recentactivityreport'] = 'Fullständig rapport över senaste aktiviteter...';
$string['recipientslist'] = 'Förteckning över mottagare.';
$string['recommended'] = 'Rekommenderade';
$string['recreatedcategory'] = 'Kategorin {$a} har återskapats.';
$string['redirect'] = 'Koppla vidare';
$string['reducesections'] = 'Minska antalet sektioner';
$string['refresh'] = 'Uppdatera';
$string['refreshingevents'] = 'Uppdaterar händelser...';
$string['registration'] = 'Moodleregistrering';
$string['registrationcontact'] = 'Kontakt från användarna';
$string['registrationcontactno'] = 'Nej, jag vill inte bli kontaktad av någon annan';
$string['registrationcontactyes'] = 'Ja, erbjud ett formulär för andra Moodle-användare att kontakta mig';
$string['registrationemail'] = 'Notiser via e-post';
$string['registrationinfo'] = '<p>Den här sidan hjälper dig att registrera din Moodle-sajt hos moodle.org. Registreringen är gratis.</p> Den största fördelen med att registrera sajten är att du kommer med på en e-postlista (som skickar ut ett begränsat antal meddelanden) för utskick av viktig information om säkerhetsvarningar och nya versioner av Moodle.<p>Som standardval så kommer den information som du lämnar att vara privat och kommer inte att säljas eller överlåtas till någon annan. Den enda anledningen till att vi samlar in den här informationen är för att erbjuda support och för att kunna skapa en statistisk bild av Moodle-gemenskapen i dess helhet.</p>
<p>
Om du så väljer så kan du tillåta att namnet på din sajt, ditt land och din URL kommer med på listan över Moodle-sajter.</p>
<p>
Alla nya registreringar bekräftas manuellt innan de bifogas till listan med när du väl är med så kan du uppdatera din registrering (och ditt bidrag till den offentliga listan) när som helst bara genom att fylla i och skicka det här formuläret igen. </p>';
$string['registrationinfotitle'] = 'Registreringsinformation';
$string['registrationsend'] = 'Skicka information för registrering till moodle.org.';
$string['registrationyes'] = 'Ja, meddela mig om nya Moodleversioner, säkerhetsvarningar och andra viktiga nyheter';
$string['reject'] = 'Avslå';
$string['rejectdots'] = 'Avslå...';
$string['relativedatesmode'] = 'Läge för relativa datum';
$string['relativedatesmode_help'] = 'Visa kurs- eller aktivitetsdatum relativt i förhållande till användarens startdatum i kursen. Användarens startdatum kommer att vara samma datum som då de registrerade sig till kursen, förutsatt att de inte registrerade sig före kursens startdatum. I sådant fall kommer startdatum vara kursens startdatum

VARNING! Detta är en experimentell funktion och alla aktiviteter kanske inte stöder den. När kursen har skapats kan den här kursinställningen inte längre ändras.';
$string['relativedatesmode_warning'] = '<strong>Varning!</strong> Inställningarna för relativa datum kan inte ändras när kursen väl skapats.';
$string['reload'] = 'Uppdatera';
$string['remoteappuser'] = 'Fjärranvändare {$a}';
$string['remove'] = 'Ta bort';
$string['removeadmin'] = 'Ta bort administratör';
$string['removecreator'] = 'Ta bort kursutvecklare';
$string['removestudent'] = 'Ta bort studenter';
$string['removeteacher'] = 'Ta bort lärare';
$string['rename'] = 'Döp om';
$string['renamefileto'] = 'Byt namn på <b>{$a}</b> till';
$string['report'] = 'Rapport';
$string['reports'] = 'Rapporter';
$string['reporttype'] = 'Rapporttyp';
$string['repositories'] = 'Arkiv';
$string['requestcourse'] = 'Ansök om en kurs';
$string['requestedby'] = 'Ansökan gjord av';
$string['requestedcourses'] = 'Begärda kurser';
$string['requestreason'] = 'Skäl för att ansöka om kurs';
$string['requests'] = 'Förfrågningar';
$string['required'] = 'Obligatorisk';
$string['requirespayment'] = 'För att få tillgång till den här kursen måste du betala.';
$string['resendemail'] = 'Skicka bekräftelsemail igen';
$string['reset'] = 'Nollställ';
$string['resetcomponent'] = 'Komponent';
$string['resetcourse'] = 'Nollställ kurs';
$string['resetinfo'] = 'Den här sidan låter dig tömma en kurs på användardata samtidigt som aktiviteterna och andra inställningar bibehålls. Kom alltså ihåg att om du väljer de nedanstående komponenterna och bekräftar dina val på den här sidan så kommer du, från den här kursen, permanent att ta bort de användardata som du har valt.';
$string['resetnotimplemented'] = 'Nollställning har inte implementerats';
$string['resetrecordexpired'] = 'Länken för lösenordsåterställning du använde är mer än {$a} minuter gammal och har slutat gälla. Vänligen påbörja en ny lösenordsåterställning.';
$string['resetstartdate'] = 'Startdatum för nollställning';
$string['resetstatus'] = 'Status';
$string['resettable'] = 'Nollställ inställningar för tabell';
$string['resettask'] = 'Uppgift';
$string['resettodefaults'] = 'Nollställ till standardvärden';
$string['resortcourses'] = 'Sortera kurser';
$string['resortsubcategoriesby'] = 'Sortera underkategorier efter {$a} stigande';
$string['resortsubcategoriesbyreverse'] = 'Sortera underkategorier efter {$a} minskande';
$string['resource'] = 'Resurs';
$string['resourcedisplayauto'] = 'Automatiskt';
$string['resourcedisplaydownload'] = 'Tvinga nedladdning';
$string['resourcedisplayembed'] = 'Bädda in';
$string['resourcedisplayframe'] = 'I ram';
$string['resourcedisplaynew'] = 'Nytt fönster';
$string['resourcedisplayopen'] = 'Öppna';
$string['resourcedisplaypopup'] = 'I pop-up fönster';
$string['resources'] = 'Resurser';
$string['resources_help'] = 'Resurstyper möjliggör nästan alla typer av webbinnehåll som skall införas i kursen.';
$string['restore'] = 'Återställ från säkerhetskopia';
$string['restorecancelled'] = 'Återställning avbruten';
$string['restorecannotassignroles'] = 'Återställ behöver tilldela roller och du inte har behörighet att göra det';
$string['restorecannotcreateorassignroles'] = 'Återställ behöver skapa eller tilldela roller och du inte har behörighet att göra det';
$string['restorecannotcreateuser'] = 'Återställningprocessen behöver skapa användarens \'{$a}\' från säkerhetskopian och du saknar behörighet att göra det';
$string['restorecannotoverrideperms'] = 'Återställningsprocessen behöver åsidosätta behörigheter och du saknar behörighet att göra det';
$string['restorecoursenow'] = 'Återställ denna kurs nu!';
$string['restoredaccount'] = 'Återställt konto';
$string['restoredaccountinfo'] = 'Detta konto har importerats från en annan server och lösenordet har gått förlorad. För att sätta ett nytt lösenord via e-post, klicka på &quot;Fortsätt&quot;';
$string['restorefinished'] = 'Återställning framgångsrikt avslutad.';
$string['restoreinfo'] = 'Använd en säkerhetskopia för att återställa en tidigare version av en kurs, eller för att skapa en ny kurs.';
$string['restoremnethostidmismatch'] = 'MNet värd-id för användare \'{$a}\' stämmer ej med lokalt MNet värd-ID.';
$string['restoreto'] = 'Återställ till';
$string['restoretositeadding'] = '<strong>VARNING!</strong> Du håller på att återställa startsidan genom att lägga till information till den!';
$string['restoretositedeleting'] = '<strong>VARNING!</strong> Du håller på att återställa startsidan genom att ta bort information från den!';
$string['restoreuserconflict'] = 'Försök att återställa användarens {$a} &quot;från säkerhetskopian kommer att orsaka konflikter';
$string['restoreuserinfofailed'] = 'Återställningen har stoppats eftersom du inte har behörighet att återställa användardata.';
$string['restoreusersprecheck'] = 'Kontrollerar användardata';
$string['restoreusersprecheckerror'] = 'Några problem upptäcktes vid kontroll av användardata';
$string['restricted'] = 'Begränsad';
$string['resultsfound'] = '{$a} resultat hittades';
$string['retry'] = 'Försök igen';
$string['returningtosite'] = 'Återvänder du till den här webbplatsen?';
$string['returntooriginaluser'] = 'Återgå till {$a}';
$string['revert'] = 'Återgå';
$string['role'] = 'Roll';
$string['roleassignments'] = 'Rolltilldelningar';
$string['rolemappings'] = 'Kartläggning av roller';
$string['rolerenaming'] = 'Anpassa rollnamn';
$string['rolerenaming_help'] = 'Ändra vilka namn som visas för roller i den här kursen.';
$string['rolerenaming_success'] = 'Kursens rollnamn uppdaterade.';
$string['roles'] = 'Roller';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Antal aktuella RSS-artiklar';
$string['rsserror'] = 'Fel vid läsning av RSS-data';
$string['rsserrorauth'] = 'Din RSS-länk innehåller inte en giltig autentiseringstoken.';
$string['rsserrorguest'] = 'Detta flöde använder gäståtkomst för att få tillgång till data, men gäster har inte behörighet att läsa data. Besök den ursprungliga platsen (URL) för detta RSS-flöde som en giltig användare och få en ny RSS-länk därifrån.';
$string['rsskeyshelp'] = '<p>För att garantera säkerhet och sekretess innehåller URL:er för RSS-flöde ett speciellt token som identifierar den användare de är avsedda för. Detta förhindrar att andra användare kommer åt områden på webbplatsen där de inte är tillåtna.</p><p>Token skapas automatiskt första gången du besöker ett område som producerar ett RSS-flöde. Om du tror att di RSS-flödes-token har komprometterats kan du begära ett nytt genom att klicka på återställningslänken. Observera att dina aktuella webbadresser för RSS-flöden då blir ogiltiga.</p>';
$string['rsstype'] = 'RSS-flöde för denna aktivitet';
$string['save'] = 'Spara';
$string['saveandnext'] = 'Spara och visa nästa.';
$string['savechanges'] = 'Spara';
$string['savechangesanddisplay'] = 'Spara och visa';
$string['savechangesandreturn'] = 'Spara och återvänd';
$string['savechangesandreturntocourse'] = 'Spara och återgå till kurs';
$string['savecomment'] = 'Spara kommentar';
$string['savedat'] = 'Sparad:';
$string['savepreferences'] = 'Spara inställningar.';
$string['saveto'] = 'Spara till';
$string['scale'] = 'Skala';
$string['scale_help'] = 'En skala representerar ett sätt att utvärdera eller bedöma prestationen i en aktivitet. Den definieras av en ordnad lista av värden - allt från negativa till positiva, åtskilda av kommatecken; till exempel "Undermåligt, Acceptabelt, Mycket bra, Utmärkt", osv.';
$string['scale_link'] = 'grade/scale';
$string['scales'] = 'Skalor';
$string['scalescustom'] = 'Anpassade skalor';
$string['scalescustomcreate'] = 'Lägg till en ny skala';
$string['scalescustomno'] = 'Inga anpassade skalor har ännu lagts till.';
$string['scalesstandard'] = 'Standardskalor';
$string['scalestandard'] = 'Standardskala';
$string['scalestandard_help'] = '<p>En standardskala är tillgänglig på hela webbplatsen för alla kurser.</p>';
$string['scalestandard_link'] = 'grade/scale';
$string['scalestip'] = 'För att skapa anpassade skalor, gå till <em>Hantera webbplats Betyg Skalor</em>';
$string['scalestip2'] = 'Om du vill skapa anpassade skalor, klicka på betygslänken i kursadministrationen menyn och välj Redigera, Skalor.';
$string['schedule'] = 'Schema';
$string['screenshot'] = 'Skärmdump';
$string['search'] = 'Sök';
$string['search_help'] = 'För grundläggande sökning av ett eller flera ord var som helst i texten, skriv dem åtskilda av mellanslag. Alla ord längre än två tecken används.

För avancerad sökning, tryck på Gå-knappen utan att skriva något i sökrutan för att komma åt den avancerade sökfunktionen.';
$string['searchactivities'] = 'Sök efter aktiviteter via namn eller beskrivning';
$string['searchagain'] = 'Sök igen';
$string['searchbyemail'] = 'Sök via e-postadress';
$string['searchbyusername'] = 'Sök via användarnamn';
$string['searchcoursecategories'] = 'Sök kategorier';
$string['searchcourses'] = 'Sök kurser';
$string['searchgroups'] = 'Sök grupper';
$string['searchitems'] = 'Sök innehållsdelar';
$string['searchoptions'] = 'Sökalternativ';
$string['searchresults'] = 'Sökresultat';
$string['searchusers'] = 'Sök användare';
$string['sec'] = 's';
$string['seconds'] = 'sekunder';
$string['secondsleft'] = '{$a} sek.';
$string['secondstotime172800'] = '2 dagar';
$string['secondstotime259200'] = '3 dagar';
$string['secondstotime345600'] = '4 dagar';
$string['secondstotime432000'] = '5 dagar';
$string['secondstotime518400'] = '6 dagar';
$string['secondstotime604800'] = '1 vecka';
$string['secondstotime86400'] = '1 dag';
$string['secretalreadyused'] = 'Länken till bekräftelse av ändring av lösenord har redan använts, lösenordet har inte ändrats.';
$string['secs'] = 's';
$string['section'] = 'Sektion';
$string['sectionactionnotsupported'] = 'Åtgärden ”{$a}” för sektionen stöds inte här';
$string['sectionname'] = 'Namn på sektion';
$string['sectionoutline'] = 'Avsnittsöversikt';
$string['sections'] = 'Sektioner';
$string['seealsostats'] = 'Se också: stats';
$string['selctauser'] = 'Välj en användare';
$string['select'] = 'Välj';
$string['selectacategory'] = 'Vänligen välj en kategori';
$string['selectacountry'] = 'Välj ett land';
$string['selectacourse'] = 'Välj en kurs';
$string['selectacoursesite'] = 'Välj en kurs eller site';
$string['selectagroup'] = 'Välj en grupp';
$string['selectall'] = 'Välj alla';
$string['selectallusersonpage'] = 'Välj alla användare på denna sida';
$string['selectalluserswithcount'] = 'Välj all {$a} användare';
$string['selectamodule'] = 'Välj en aktivitetsmodul';
$string['selectanaction'] = 'Välj en åtgärd';
$string['selectanoptions'] = 'Välj ett alternativ';
$string['selectaregion'] = 'Välj en region';
$string['selectcategorysort'] = 'Vilka kategorier skulle du vilja att sortera?';
$string['selectcategorysortby'] = 'Välj hur du vill sortera kategorier';
$string['selectcoursesortby'] = 'Välj hur du vill sortera kurser';
$string['selectdefault'] = 'Välj standardinställning';
$string['selectedcategories'] = 'Valda kategorier';
$string['selectedfile'] = 'Vald fil';
$string['selectednowmove'] = '{$a} filer är markerade för att bli flyttade. Gå till destinationen och välj "Flytta valda filer hit".';
$string['selectfiles'] = 'Välj filer';
$string['selectfiltertype'] = 'Välj';
$string['selectgroupsseparate'] = 'Välj separata grupper';
$string['selectgroupsvisible'] = 'Välj synliga grupper';
$string['selectitem'] = 'Välj \'{$a}\'';
$string['selectmoduletoviewhelp'] = 'Välj en aktivitet eller resurs för att visa dess hjälp.

Dubbelklicka på namnet på en aktivitet eller resurs för att snabbt lägga till den.';
$string['selectnos'] = 'Markera alla \'nej\'';
$string['selectperiod'] = 'Välj period';
$string['selecttheme'] = 'Välj tema';
$string['selectthemename'] = 'Välj tema \'{$a}\'';
$string['senddetails'] = 'Sänd mina uppgifter för inloggning via e-post.';
$string['sent'] = 'Skickat';
$string['separate'] = 'Separat';
$string['separateandconnected'] = 'Enskild (rationell) och social(empatisk) inriktning ang vetande (kunskap)';
$string['separateandconnectedinfo'] = 'Skalan baserad på teorin om separat och anslutet lärande. Denna teori beskriver två olika sätt som vi kan utvärdera och lära oss om de saker vi ser och hör.<ul><li>
<strong>Separata lärande</strong> förblir så objektiva som möjligt utan att inkludera känslor och emotioner. I en diskussion med andra människor gillar de att försvara sina egna idéer, med hjälp av logik, för att hitta hål i motståndarens idéer. </li><li>
<strong>Anslutna lärande</strong> är mer sensitiva för andra människor. De är empatiska och tenderar att lyssna och ställa frågor tills det att de känner att de kan få kontakt och <em>"förstå saker ur deras synvinkel"</em>. De lär sig genom att försöka dela med sig av de erfarenheter som ledde till den kunskap de hittar hos andra människor.</li></ul>';
$string['servererror'] = 'Ett fel inträffade vid kommunikation med servern';
$string['serverlocaltime'] = 'Serverns lokala tid';
$string['sessionforceclean'] = 'Som en förebyggande säkerhetsåtgärd har användarskapade skript inaktiverats i denna session.';
$string['sessiontimeoutsoon'] = 'Tidsgränsen för din session är på väg att löpa ut. Vill du förlänga sessionen?';
$string['setcategorytheme'] = 'Ange tema för kategori';
$string['setmode'] = 'Ange läge';
$string['setpassword'] = 'Sätt lösenord';
$string['setpasswordinstructions'] = 'Vänligen ange ditt nya lösenord nedan och spara.';
$string['settings'] = 'Inställningar';
$string['share'] = 'Dela';
$string['shortname'] = 'Kortnamn';
$string['shortnamecollisionwarning'] = '[*] = det här kortnamnet används redan för en annan kurs så du måste byta det om kursen blir godkänd.';
$string['shortnamecourse'] = 'Kortnamn';
$string['shortnamecourse_help'] = 'Namnet visas i områden med begränsat utrymme. Det måste vara unikt.';
$string['shortnametaken'] = 'Kortnamnet används redan av för en annan kurs {$a}.';
$string['shortnameuser'] = 'Användare kortnamn';
$string['shortsitename'] = 'Kortnamn (t.ex. ett ord)';
$string['show'] = 'Visa';
$string['showactions'] = 'Visa åtgärder';
$string['showactivitydates'] = 'Visa aktivitetsdatum';
$string['showactivitydates_help'] = 'Visa aktivitetsdatum på kurssidan.';
$string['showadvancededitor'] = 'Avancerad';
$string['showadvancedsettings'] = 'Visa avancerade inställningar.';
$string['showall'] = 'Visa alla {$a}';
$string['showallcourses'] = 'Visa alla kurser';
$string['showallusers'] = 'Visa alla användare';
$string['showblockcourse'] = 'Visa en lista över kurser som innehåller block.';
$string['showcategory'] = 'Visa {$a}';
$string['showchartdata'] = 'Visa diagram';
$string['showcomments'] = 'Visa/dölj kommentarer';
$string['showcommentsnonjs'] = 'Visa kommentarer';
$string['showdescription'] = 'Visa beskrivning på kurssidan';
$string['showdescription_help'] = 'Om aktiverad så kommer beskrivningen ovanför att visas på kurssidan strax under länken till aktiviteten eller resursen.';
$string['showgrades'] = 'Visa betygbok för studenter';
$string['showgrades_help'] = 'Tillåt studenter att se en lista över alla deras betyg i kursen.';
$string['showingacourses'] = 'Visar alla {$a} kurser';
$string['showingxofycourses'] = 'Visar kurser {$a->start} till {$a->end} av {$a->total} kurser';
$string['showless'] = 'Visa mindre';
$string['showlistofcourses'] = 'Visa lista på kurser';
$string['showmodulecourse'] = 'Visa en lista över kurser som innehåller aktiviteter.';
$string['showmore'] = 'Visa mer';
$string['showoncoursepage'] = 'Visa på kurssidan';
$string['showonly'] = 'Visa bara';
$string['showperpage'] = 'Visa {$a} per sida';
$string['showpopoverwindow'] = 'Visa popover-fönster';
$string['showrecent'] = 'Visa senaste aktivitet';
$string['showreports'] = 'Visa aktivitetsrapporter';
$string['showreports_help'] = 'Tillåt studentetr att se sina egna aktivitetsrapporter via sin profilsida.';
$string['showsettings'] = 'Visa inställningar';
$string['showtheselogs'] = 'Visa dessa loggar';
$string['showthishelpinlanguage'] = 'Visa denna hjälp på språket: {$a}';
$string['sidepanel'] = 'Sidopanel';
$string['signoutofotherservices'] = 'Logga ut överallt';
$string['signoutofotherservices_help'] = 'Logga ut från alla enheter och system som använder webbtjänster, till exempel mobilappen. Webbläsarsessioner förblir aktiva.';
$string['since'] = 'Sedan';
$string['sincelast'] = 'sedan senaste login';
$string['site'] = 'Startsida';
$string['sitedefault'] = 'Förinställt värde för webbplatsen';
$string['sitedefaultspecified'] = 'Standardinställning för webbplatsen ({$a})';
$string['siteerrors'] = 'Webbplatsfel';
$string['sitefiles'] = 'Webbplatsfiler';
$string['sitefilesused'] = 'De filer på webbplatsen som används i den här kursen';
$string['sitehome'] = 'Startsida';
$string['sitelegacyfiles'] = 'Ärvda filer på webbplatsnivå';
$string['sitelogs'] = 'Webbplatsloggar';
$string['sitenews'] = 'Webbplatsmeddelanden';
$string['sitepages'] = 'Sidor på webbplatsen';
$string['sitepartlist'] = 'Du har inte behörighet att se förteckningen över deltagare.';
$string['sitepartlist0'] = 'Du måste vara registrerad som lärare på (global) webbplatsnivå för att få se förteckningen över samtliga deltagare på webbplatsen.';
$string['sitepartlist1'] = 'Du måste vara registrerad som lärare för att få se förteckningen över samtliga deltagare på webbplatsen.';
$string['sites'] = 'Webbplatser';
$string['sitesection'] = 'Lägg till anpassat innehåll';
$string['sitesettings'] = 'Inställningar för  webbplatsen.';
$string['siteteachers'] = 'Lärare på (global) webbplatsnivå';
$string['size'] = 'Storlek';
$string['sizeb'] = 'bytes';
$string['sizegb'] = 'Gb';
$string['sizekb'] = 'Kb';
$string['sizemb'] = 'Mb';
$string['sizepb'] = 'PB';
$string['sizetb'] = 'TB';
$string['skipped'] = 'Överhoppade';
$string['skiptocategorylisting'] = 'Gå vidare till kategorilistor';
$string['skiptocoursedetails'] = 'Gå vidare till den detaljerade kursinformationen';
$string['skiptocourselisting'] = 'Gå vidare till kurslistor';
$string['socialheadline'] = 'Gemenskapsforum - senaste tema';
$string['someallowguest'] = 'Några kurser kan tillåta gäster';
$string['someerrorswerefound'] = 'Några uppgifter saknades eller var felaktiga. Se nedan för detaljer.';
$string['sort'] = 'Sortera';
$string['sortby'] = 'Sortera efter';
$string['sortbyx'] = 'Sortera enligt {$a} stigande';
$string['sortbyxreverse'] = 'Sortera enligt {$a} fallande';
$string['sorting'] = 'Sortering';
$string['sourcerole'] = 'Källa för roll';
$string['specifyname'] = 'Du måste ange ett  namn.';
$string['standard'] = 'Standard';
$string['starpending'] = '([*]  = kurs i kö för att bli godkänd';
$string['startdate'] = 'Kursens startdatum';
$string['startdate_help'] = 'Detta datum bestämmer starten av den första veckan för en kurs i veckoformat. Det är också startdatum för loggar över kursaktiviteter.

Om du nollställer kursen och ändrar detta datum kommer alla datum i kursen att flyttas i förhållande till det nya startdatumet.';
$string['startdatewithtaskenabled'] = 'Kursens startdatum';
$string['startdatewithtaskenabled_help'] = 'Datumet då kursen blir synlig för studenter. Före detta datum kommer de inte att kunna komma åt kursen.

Detta datum bestämmer också starten av den första veckan för en kurs i veckoformat, och är startdatumet för loggar över kursaktiviteter. om du nollställer kursen och ändrar detta datum kommer alla datum i kursen att flyttas i förhållande till det nya startdatumet.';
$string['startingfrom'] = 'Med start från';
$string['startsignup'] = 'Skapa konto';
$string['state'] = 'Stat/region';
$string['statistics'] = 'Statistik';
$string['statisticsgraph'] = 'Graf över statistik';
$string['stats'] = 'Statistik';
$string['statslogins'] = 'Inloggningar';
$string['statsmodedetailed'] = 'Detaljerad vy (användare)';
$string['statsmodegeneral'] = 'Allmän vy';
$string['statsnodata'] = 'Det finns inga tillgängliga data för den angivna kombinationen av kurs och tidsperiod.';
$string['statsnodatauser'] = 'Det finns inga tillgängliga data för den kombinationen av kurs, användare och tidsperiod.';
$string['statsoff'] = 'Statistiken är f n inte aktiverad';
$string['statsreads'] = 'Visningar';
$string['statsreport1'] = 'Inloggningar';
$string['statsreport10'] = 'Aktivitet - användare';
$string['statsreport11'] = 'Mest aktiva kurser';
$string['statsreport12'] = 'Mest aktiva kurser (viktade)';
$string['statsreport13'] = 'Kurser med flest deltagare (registreringar)';
$string['statsreport14'] = 'Mest aktiva kurser (inlägg/visningar)';
$string['statsreport2'] = 'Visningar (lärare och lärande)';
$string['statsreport3'] = 'Inlägg (lärare och lärande)';
$string['statsreport4'] = 'Alla aktiviteter (lärare och lärande)';
$string['statsreport5'] = 'Alla aktiviteter av lärande (visningar och inlägg)';
$string['statsreport7'] = 'Aktiviteter av användare (visningar och inlägg)';
$string['statsreport8'] = 'All användaraktivitet';
$string['statsreport9'] = 'Inloggningar (webbplats kurs)';
$string['statsreportactivity'] = 'Alla aktiviteter (lärare och lärande)';
$string['statsreportactivitybyrole'] = 'All aktivitet (visningar och inlägg)';
$string['statsreportforuser'] = 'för';
$string['statsreportlogins'] = 'Inloggningar';
$string['statsreportreads'] = 'Visningar (lärare och lärande)';
$string['statsreporttype'] = 'Rapporttyp';
$string['statsreportwrites'] = 'Inlägg (lärare  och lärande)';
$string['statsstudentactivity'] = 'Aktiviteter - lärande';
$string['statsstudentreads'] = 'Vy - lärande';
$string['statsstudentwrites'] = 'Inlägg av studenter';
$string['statsteacheractivity'] = 'Aktiviteter - lärare';
$string['statsteacherreads'] = 'Vy lärare';
$string['statsteacherwrites'] = 'Inlägg av lärare';
$string['statstimeperiod'] = 'Tidsperiod - senaste:';
$string['statsuniquelogins'] = 'Unika inloggningar';
$string['statsuseractivity'] = 'Alla aktiviteter';
$string['statsuserlogins'] = 'Inloggningar';
$string['statsuserreads'] = 'Vyer';
$string['statsuserwrites'] = 'Inlägg';
$string['statswrites'] = 'Inlägg';
$string['status'] = 'Status';
$string['statuscritical'] = 'Kritiskt';
$string['statuserror'] = 'Fel';
$string['statusinfo'] = 'Info';
$string['statusna'] = 'Ej tillämpligt';
$string['statusok'] = 'OK';
$string['statusunknown'] = 'Okänd';
$string['statuswarning'] = 'Varning';
$string['stringsnotset'] = 'Följande strängar är inte definierade i {$a}';
$string['studentnotallowed'] = 'Tyvärr, men du kan inte registrera dig på denna kurs som \'{$a}\'.';
$string['students'] = 'studenter';
$string['studentsandteachers'] = 'Studenter och lärare';
$string['subcategories'] = 'Underkategorier';
$string['subcategory'] = 'Underkategori';
$string['subcategoryof'] = 'Underkategori till {$a}';
$string['subject'] = 'Ämne';
$string['submit'] = 'Skicka in';
$string['success'] = 'Lyckades';
$string['successduration'] = 'Lyckades ({$a} sekunder)';
$string['summary'] = 'Sammanfattning';
$string['summary_help'] = '<p>Tanken med en sammanfattning av ett ämne är att förbereda
de lärande på aktiviteterna i detta ämne (eller under denna vecka).</p>
<p>Varje sammanfattning bör vara mycket kort så att kurssidan
inte blir för lång.</p>
<p>Om du upptäcker att du vill informera med mer än en eller
två meningar så bör du överväga att lägga till
en \'Resurs\' till det här ämnet istället.
Den första aktiviteten skulle t.ex. kunna vara en sida som kallas:
<b>\'Om detta ämne\'</b>.</p>';
$string['summaryof'] = 'Översikt - {$a}';
$string['suspended'] = 'Spärrad';
$string['suspendedusers'] = 'Spärrade användare';
$string['switchdevicedefault'] = 'Växla till standardtemat';
$string['switchdevicerecommended'] = 'Växla till den rekommenderade temat för enheten';
$string['switchrolereturn'] = 'Återgå till min normala roll';
$string['switchroleto'] = 'Byt roll till...';
$string['switchroleto_help'] = 'Välj en roll för att få en uppfattning om hur någon med den rollen kommer att se den här kursen.

Observera att den här vyn kanske inte är helt rättvisande (<a href="https://docs.moodle.org/en/Switch_roles">Se detaljer och alternativ</a>).';
$string['tag'] = 'Etikett';
$string['tagalready'] = 'Den här etiketten finns redan';
$string['tagmanagement'] = 'Lägg till/ta bort etiketter...';
$string['tags'] = 'Etiketter';
$string['targetrole'] = 'Mål för roll';
$string['teacheronly'] = 'för {$a} endast';
$string['teacherroles'] = '{$a} roller';
$string['teachers'] = 'Lärare';
$string['textcopiedtoclipboard'] = 'Texten har kopierats till urklipp';
$string['textediting'] = 'Textredigerare';
$string['textediting_help'] = 'Om en HTML-redigerare som <em>Atto</em> eller <em>TinyMCE</em> är vald kommer textfält att ha ett verktygsfält med knappar för att enkelt lägga till innehåll.

Om <em>Oformaterad text</em> är valt kan textformateringsalternativ som <em>HTML</em> eller <em>Markdown</em> väljas.

Listan över tillgängliga textredigerare bestäms av webbplatsadministratören.';
$string['texteditor'] = 'Använd vanliga webbformulär.';
$string['textellipsis'] = '{$a}...';
$string['textformat'] = 'Vanligt textformat';
$string['thanks'] = 'Tack';
$string['theme'] = 'Layouttema';
$string['themes'] = 'Layoutteman';
$string['themesaved'] = 'Nytt layouttema sparat.';
$string['therearecourses'] = 'Det finns {$a} kurser';
$string['thereareno'] = 'Det finns inga {$a} i den här kursen';
$string['thiscategory'] = 'Denna kategori';
$string['thiscategorycontains'] = 'Den här kategorin innehåller';
$string['time'] = 'Tid';
$string['timecreated'] = 'Skapades';
$string['timecreatedcourse'] = 'Kurstid skapad';
$string['timesplitting:deciles'] = 'Sista tiondelar';
$string['timesplitting:deciles_help'] = 'Detta analysintervall delar kursen i tiondelar (10 lika delar) där varje förutsägelse baseras på data av endast den senaste föregående tiondelen.';
$string['timesplitting:decilesaccum'] = 'All föregående tiondelar';
$string['timesplitting:decilesaccum_help'] = 'Detta analysintervall delar kursen i tiondelar (10 lika delar) där varje förutsägelse baseras på ackumulerad data från alla tidigare tiondelar.';
$string['timesplitting:nosplitting'] = 'Inga tidsbegränsningar';
$string['timesplitting:nosplitting_help'] = 'Inget analysintervall definierat för denna modell';
$string['timesplitting:onemonthafterstart'] = 'En månad efter start';
$string['timesplitting:onemonthafterstart_help'] = 'Detta analysintervall genererar en förutsägelse 1 månad efter den analysbara starten.';
$string['timesplitting:oneweekafterstart'] = 'En vecka efter start';
$string['timesplitting:oneweekafterstart_help'] = 'Detta analysintervall genererar en förutsägelse 1 vecka efter den analysbara starten.';
$string['timesplitting:past3days'] = '3 senaste dagarna';
$string['timesplitting:past3days_help'] = 'Detta analysintervall genererar förutsägelser var 3:e dag. Beräkningen av indikatorerna kommer att baseras på de senaste 3 dagarna.';
$string['timesplitting:pastmonth'] = 'Senaste månaden';
$string['timesplitting:pastmonth_help'] = 'Detta analysintervall genererar förutsägelser varje månad. Beräkningen av indikatorerna kommer att baseras på den gångna månaden.';
$string['timesplitting:pastweek'] = 'Senaste veckan';
$string['timesplitting:pastweek_help'] = 'Detta analysintervall genererar förutsägelser varje vecka. Beräkningen av indikatorerna kommer att baseras på den gångna veckan.';
$string['timesplitting:quarters'] = 'Senaste kvartalet';
$string['timesplitting:quarters_help'] = 'Detta analysintervall delar kursen i kvartar (4 lika delar) där varje förutsägelse baseras på data från endast den senaste föregående kvarten.';
$string['timesplitting:quartersaccum'] = 'Alla föregående kvartal';
$string['timesplitting:quartersaccum_help'] = 'Detta analysintervall delar kursen i kvartar (4 lika delar) där varje förutsägelse baseras på data från alla föregående kvartar.';
$string['timesplitting:singlerange'] = 'Från början till slut';
$string['timesplitting:singlerange_help'] = 'Detta analysintervall betraktar hela kursen som ett intervall.';
$string['timesplitting:tenpercentafterstart'] = '10% efter start';
$string['timesplitting:tenpercentafterstart_help'] = 'Det här analysintervallet genererar en förutsägelse efter att 10% av kursen har slutförts.';
$string['timesplitting:upcoming3days'] = 'Kommande 3 dagarna';
$string['timesplitting:upcoming3days_help'] = 'Detta analysintervall genererar förutsägelser var 3:e dag. Beräkningen av indikatorerna kommer att baseras på de kommande 3 dagarna.';
$string['timesplitting:upcomingfortnight'] = 'Kommande två veckorna';
$string['timesplitting:upcomingfortnight_help'] = 'Detta analysintervall genererar förutsägelser var fjortonde dag. Beräkningen av indikatorerna kommer att baseras på de kommande fjorton dagarna.';
$string['timesplitting:upcomingweek'] = 'Kommande vecka';
$string['timesplitting:upcomingweek_help'] = 'Detta analysintervall genererar förutsägelser varje vecka. Beräkningen av indikatorerna kommer att baseras på den kommande veckan.';
$string['timezone'] = 'Tidszon';
$string['to'] = 'Till';
$string['tocontent'] = 'Till "{$a}"';
$string['tocreatenewaccount'] = 'Hoppa vidare för att skapa ett nytt konto. ';
$string['todate'] = 'Till';
$string['today'] = 'Idag';
$string['todaylogs'] = 'Dagens loggar';
$string['toeveryone'] = 'till alla';
$string['toggleemojipicker'] = 'Växla emoji-väljare';
$string['togglesearch'] = 'Växla sökinmatning';
$string['toomanybounces'] = 'Den här e-postadressen har returnerat för många meddelanden. Du <b>måste</b> ändra den för att kunna fortsätta.';
$string['toomanytags'] = 'Denna sökning innehöll för många etiketter. Några av dem har ignorerats.';
$string['toomanytoshow'] = 'Det finns för många användare att visa.';
$string['toomanyusersmatchsearch'] = 'Alltför många användare ({$a->count}) matchar \'{$a->search}\'';
$string['toomanyuserstoshow'] = 'Alltför många användare ({$a}) att visa';
$string['toonly'] = 'endast till {$a}';
$string['top'] = 'Överst';
$string['topic'] = 'Tema';
$string['topichide'] = 'Dölj detta ämne för {$a}';
$string['topicoutline'] = 'Ämnesdisposition';
$string['topicshow'] = 'Visa detta ämne för {$a}';
$string['toplevelcategory'] = 'Toppnivåkategori';
$string['torecipient'] = 'Till';
$string['total'] = 'Totalt';
$string['totopofsection'] = 'Till toppen av avsnittet "{$a}"';
$string['trackforums'] = 'Spårning av forum';
$string['trackforumsno'] = 'Nej: Markera inte nya inlägg';
$string['trackforumsyes'] = 'Ja: Markera nya inlägg åt mig.';
$string['trysearching'] = 'Prova med att söka istället.';
$string['turneditingoff'] = 'Avsluta redigering';
$string['turneditingon'] = 'Aktivera redigering';
$string['unabletocopytoclipboard'] = 'Kan inte kopiera text till urklipp';
$string['unauthorisedlogin'] = 'Användarkontot "{$a}"  är inte tillgängligt på denna sajt';
$string['undecided'] = 'Ej beslutad';
$string['unexistingcmid'] = 'Hittade inte ID för kursmodul';
$string['unexistingsectionid'] = 'Hittade inte ID för kurssektion';
$string['unfinished'] = 'Oavslutade';
$string['unknowncategory'] = 'Okänd kategori';
$string['unknownerror'] = 'Okänt fel';
$string['unknownuser'] = 'Okänd användare';
$string['unlimited'] = 'Obegränsad';
$string['unpacking'] = 'Packar upp {$a}';
$string['unsafepassword'] = 'Osäkert lösenord - försök med något annat.';
$string['untilcomplete'] = 'Tills det är klart';
$string['unusedaccounts'] = 'Konton som inte har använts på mer än {$a} dagar tas automatiskt bort.';
$string['unzip'] = 'Packa upp';
$string['unzippingbackup'] = 'Packar upp säkerhetskopia...';
$string['up'] = 'Upp';
$string['update'] = 'Uppdatera';
$string['updated'] = 'Uppdaterat {$a}';
$string['updatemymoodleoff'] = 'Sluta anpassa den här sidan';
$string['updatemymoodleon'] = 'Anpassa den här sidan';
$string['updatemyprofile'] = 'Uppdatera profil';
$string['updatesevery'] = 'Uppdatering varje {$a} sekund';
$string['updatethis'] = 'Uppdatera {$a}';
$string['updatethiscourse'] = 'Uppdatera denna kurs';
$string['updatinga'] = 'Uppdatering av {$a}';
$string['updatingain'] = 'Uppdaterar {$a->what} i {$a->in}';
$string['upload'] = 'Ladda upp';
$string['uploadafile'] = 'Ladda upp en fil';
$string['uploadcantwrite'] = 'Det gick inte att skriva filen till disk.';
$string['uploadedfile'] = 'Filen laddades upp framgångsrikt.';
$string['uploadedfileto'] = 'Laddade upp {$a->file} till {$a->directory}';
$string['uploadedfiletoobig'] = 'Den här filen är tyvärr för stor (begränsningen är {$a} bytes).';
$string['uploadextension'] = 'Filuppladdning stoppad av PHP';
$string['uploadfailednotrecovering'] = 'Det gick inte att ladda upp dina filer eftersom det uppstod ett problem med en av filerna, {$a->name}.<br/> Här är loggen  över problemen:<br />{$a->problem}<br /> återställer inte.';
$string['uploadfilelog'] = 'Logg för uppladdning av filen {$a}';
$string['uploadformlimit'] = 'Den uppladdade filen {$a} var större än vad som är tillåtet.';
$string['uploadlabel'] = 'Titel:';
$string['uploadlimitwithsize'] = 'Uppladdningsgräns {$a->contextname} ({$a->displaysize})';
$string['uploadnewfile'] = 'Ladda upp en ny fil';
$string['uploadnofilefound'] = 'Hittade ingen fil - är du säker på att du valde en att ladda upp?';
$string['uploadnotallowed'] = 'Det är inte tillåtet att ladda upp någonting.';
$string['uploadnotempdir'] = 'En temporär katalog saknas';
$string['uploadoldfilesdeleted'] = 'De gamla filerna i det område som laddar upp dem till har tagits bort.';
$string['uploadpartialfile'] = 'Filen laddades bara delvis upp.';
$string['uploadproblem'] = 'Ett okänt fel inträffade under uppladdning av filen \'{$a}\' (kanske var den för stor?)';
$string['uploadrenamedchars'] = 'Filen döptes om från {$a->oldname} till {$a->newname} eftersom den innehöll ogiltiga tecken.';
$string['uploadrenamedcollision'] = 'Filen döptes om från {$a->oldname} till {$a->newname} eftersom det uppstod en konflikt mellan filnamn.';
$string['uploadserverlimit'] = 'Den uppladdade filen var större än vad som är tillåtet.';
$string['uploadthisfile'] = 'Ladda upp denna fil';
$string['url'] = 'URL/webbadress';
$string['used'] = 'Använd';
$string['usedinnplaces'] = 'Använd på {$a} ställen';
$string['user'] = 'Användare';
$string['useraccount'] = 'Användarkonto';
$string['useractivity'] = 'Aktivitet';
$string['userconfirmed'] = 'Bekräftad {$a}';
$string['userdata'] = 'Användardata';
$string['userdeleted'] = 'Detta användarkonto har tagits bort.';
$string['userdescription'] = 'Beskrivning';
$string['userdescription_help'] = 'I denna ruta kan du skriva text om dig själv som sedan kommer att visas på din profilsida synlig för andra.';
$string['userdetails'] = 'Användardetaljer';
$string['userfiles'] = 'Användarfiler';
$string['userlist'] = 'Användarlista';
$string['usermenu'] = 'Användarmeny';
$string['usermenugoback'] = 'Tillbaka till användarmenyn';
$string['username'] = 'Användarnamn';
$string['usernameemail'] = 'Användarnamn eller e-postadress';
$string['usernameemailmatch'] = 'Användarnamnet och e-postadressen relaterar inte till samma användare.';
$string['usernameexists'] = 'Detta användarnamn finns redan, välj ett annat.';
$string['usernamelowercase'] = 'Endast små bokstäver är tillåtna';
$string['usernamenotfound'] = 'Det gick inte att hitta användarnamnet i databasen.';
$string['usernameoremail'] = 'Ange användarnamn eller e-postadress';
$string['usernotconfirmed'] = 'Det gick inte att bekräfta {$a}.';
$string['userpic'] = 'Profilbild';
$string['userpreferences'] = 'Användarinställningar';
$string['users'] = 'Användare';
$string['userselectorautoselectunique'] = 'Om endast en användare matchar sökningen - välj den automatiskt';
$string['userselectorpreserveselected'] = 'Behåll utvalda användare, även om de inte längre matchar sökningen';
$string['userselectorsearchanywhere'] = 'Matcha söktexten var som helst i de visade fälten';
$string['usersnew'] = 'Nya användare';
$string['usersnoaccesssince'] = 'Visa användare som har varit inaktiva i mer än';
$string['userswithfiles'] = 'Användare med filer';
$string['useruploadtype'] = 'Användaruppladdning typ: {$a}';
$string['userzones'] = 'Användarzoner';
$string['usetheme'] = 'Använd tema';
$string['usingexistingcourse'] = 'Använder befintlig kurs.';
$string['validatehtml'] = 'Validera HTML';
$string['valuealreadyused'] = 'Detta värde har redan använts.';
$string['version'] = 'Version';
$string['view'] = 'Visa';
$string['viewallcourses'] = 'Visa alla kurser';
$string['viewallcoursescategories'] = 'Visa alla kurser och kategorier';
$string['viewallresults'] = 'Visa alla resultat ({$a})';
$string['viewallsubcategories'] = 'Visa alla underkategorier';
$string['viewfileinpopup'] = 'Visa fil i ett popup-fönster';
$string['viewing'] = 'Tittar på:';
$string['viewmore'] = 'Visa mer';
$string['viewprofile'] = 'Visa profil';
$string['views'] = 'Vyer';
$string['viewsolution'] = 'visa lösning';
$string['visible'] = 'Synlig';
$string['visible_help'] = 'Den här inställningen avgör om kursen visas i listan över kurser. Bortsett från lärare och administratörer får ingen komma in på kursen.';
$string['visibletostudents'] = 'Synligt för {$a}';
$string['warning'] = 'Varning';
$string['warningdeleteresource'] = 'Varning: {$a} refereras i en resurs. Vill du uppdatera resursen?';
$string['wcagcheck'] = 'Kontroll av Web Content Accessibility Guidelines (WCAG)';
$string['webpage'] = 'Webbsida';
$string['week'] = 'Vecka';
$string['weekhide'] = 'Dölj denna vecka för {$a}';
$string['weeklyoutline'] = 'Veckodisposition';
$string['weeks'] = 'veckor';
$string['weekshow'] = 'Visa denna vecka för {$a}';
$string['welcomeback'] = 'Välkommen tillbaka, {$a->firstname}! 👋';
$string['welcometocourse'] = 'Välkommen till {$a}';
$string['welcometocoursetext'] = 'Välkommen till {$a->coursename}!

En av de första sakerna du bör göra är att uppdatera din profilsida så att vi kan lära känna dig bättre:

  {$a->profileurl}';
$string['welcometosite'] = 'Välkommen, {$a->firstname}! 👋';
$string['whatforlink'] = 'Vad vill du göra med länken?';
$string['whatforpage'] = 'Vad vill du göra med texten?';
$string['whatisyourage'] = 'Hur gammal är du?';
$string['whattocallzip'] = 'Vad vill du kalla ZIP-filen?';
$string['whattodo'] = 'Saker att göra';
$string['wheredoyoulive'] = 'Vilket land bor du i?';
$string['whyisthisrequired'] = 'Varför behövs detta?';
$string['windowclosing'] = 'Detta fönster bör stängas automatiskt. Om inte, stäng det nu.';
$string['withchosenfiles'] = 'Med valda filer';
$string['withdisablednote'] = '{$a} (inaktiverat)';
$string['withoutuserdata'] = 'utan användardata';
$string['withselectedusers'] = 'För valda användare…';
$string['withuserdata'] = 'med användardata';
$string['wontrunfuturescheduledtask'] = 'Kommer inte att köra uppgift som inte har misslyckats och som är planerad att köras i framtiden.';
$string['wordforstudent'] = 'Ditt ord i singular för kursdeltagare (om annat).';
$string['wordforstudenteg'] = 't.ex. elev, student, kursdeltagare mm.';
$string['wordforstudents'] = 'Ditt ord i plural för kursdeltagare (om annat).';
$string['wordforstudentseg'] = 't.ex. elever, studenter, kursdeltagare mm.';
$string['wordforteacher'] = 'Ditt ord för lärare';
$string['wordforteachereg'] = 't.ex. lärare, ledare, koordinator, utbildare, handledare, coach etc.';
$string['wordforteachers'] = 'Ditt ord för lärare (plural)';
$string['wordforteacherseg'] = 't.ex. lärare, ledare, koordinatorer, utbildare, handledare, coacher etc.';
$string['writingblogsinfo'] = 'Skriver blogginfo';
$string['writingcategoriesandquestions'] = 'Skriver kategorier och frågor...';
$string['writingcoursedata'] = 'Skriver kursdata...';
$string['writingeventsinfo'] = 'Skriver info om händelser...';
$string['writinggeneralinfo'] = 'Skriver allmän information';
$string['writinggradebookinfo'] = 'Skriver in info i betygs/omdömeskatalogen...';
$string['writinggroupingsgroupsinfo'] = 'Skriver information om gruppindelningar-grupper';
$string['writinggroupingsinfo'] = 'Skriver information om gruppindelningar';
$string['writinggroupsinfo'] = 'Skriver info om grupper...';
$string['writingheader'] = 'Skriver huvudrubrik...';
$string['writingloginfo'] = 'Skriver info om loggar...';
$string['writingmessagesinfo'] = 'Skriver meddelandeinformation';
$string['writingmoduleinfo'] = 'Skriver info om moduler...';
$string['writingscalesinfo'] = 'Skriver info om skalor...';
$string['writinguserinfo'] = 'Skriver info om användare...';
$string['wrongpassword'] = 'Fel lösenord för detta användarnamn.';
$string['year'] = 'år';
$string['years'] = 'år';
$string['yes'] = 'Ja';
$string['youareabouttocreatezip'] = 'Du håller på att skapa en ZIP-fil som innehåller';
$string['youaregoingtorestorefrom'] = 'Du håller på att starta återställningsprocessen för';
$string['youhaveupcomingactivitiesdue'] = 'Du har kommande aktiviteter som förfaller';
$string['youhaveupcomingactivitiesdueinfo'] = 'Hej {$a},

<br/><br/>Du har kommande aktiviteter som förfaller:';
$string['youneedtoenrol'] = 'För att genomföra den åtgärden måste du registrera dig på den här kursen.';
$string['yourlastlogin'] = 'Din senaste inloggning var';
$string['yourself'] = 'Du själv';
$string['yourteacher'] = 'din {$a}';
$string['yourwordforx'] = 'Ditt ord för \'{$a}\'';
$string['zippingbackup'] = 'Packar ihop säkerhetskopian...';
