<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'pt', version '4.4'.
 *
 * @package     moodle
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'prestes a ser instalado';
$string['accept'] = 'Aceitar';
$string['action'] = 'Ação';
$string['actionchoice'] = 'O que pretende fazer com o ficheiro \'{$a}\'?';
$string['actions'] = 'Ações';
$string['actionsfor'] = 'Ações para {$a}';
$string['actionsmenu'] = 'Menu de Ações';
$string['active'] = 'Ativo';
$string['activeusers'] = 'Utilizadores ativos';
$string['activities'] = 'Atividades';
$string['activities_help'] = 'Atividades, tais como fóruns, testes e wikis permitem que seja adicionado conteúdo interativo à disciplina.';
$string['activity'] = 'Atividade';
$string['activityclipboard'] = 'A mover a atividade \'{$a}\'';
$string['activityheader'] = 'Menu da atividade';
$string['activityicon'] = 'Ícone {$a}';
$string['activityiscurrentlyhidden'] = 'Esta atividade encontra-se oculta';
$string['activitymodule'] = 'Módulo de atividade';
$string['activitymodules'] = 'Módulo de atividades';
$string['activitynotready'] = 'A atividade ainda não está pronta';
$string['activityreport'] = 'Relatório de atividade';
$string['activityreports'] = 'Relatórios de atividade';
$string['activityselect'] = 'Selecione esta atividade para movê-la';
$string['activitysince'] = 'Atividade criada desde {$a}';
$string['activitytypetitle'] = '{$a->activity} - {$a->type}';
$string['activityweighted'] = 'Atividade por utilizador';
$string['add'] = 'Adicionar';
$string['addactivity'] = 'Adicionar uma atividade';
$string['addactivitytosection'] = 'Adicionar uma atividade à secção \'{$a}\'';
$string['addadmin'] = 'Adicionar administrador';
$string['addblock'] = 'Adicionar bloco';
$string['addcomment'] = 'Adicionar comentário…';
$string['addcondition'] = 'Adicionar condição';
$string['addcountertousername'] = 'Criar utilizador adicionando número ao nome de utilizador';
$string['addcreator'] = 'Adicionar criador da disciplina';
$string['adddots'] = 'Adicionar...';
$string['added'] = 'Adicionado {$a}';
$string['addedtogroup'] = 'Adicionado ao grupo {$a}';
$string['addedtogroupnot'] = 'Não adicionado ao grupo {$a}';
$string['addedtogroupnotenrolled'] = '{$a} não foi adicionado ao grupo porque não está inscrito na disciplina';
$string['addfilehere'] = 'Arraste para aqui os ficheiros para os adicionar no fim desta secção';
$string['addfilesdrop'] = 'Pode arrastar e largar ficheiros para os carregar ou clique para selecionar.';
$string['addinganew'] = 'Novo "{$a}"';
$string['addinganewto'] = 'Adicionar \'{$a->what}\' em "{$a->to}"';
$string['addingdatatoexisting'] = 'Adicionar dados à existente';
$string['additionalcustomnav'] = 'Navegação personalizada adicional';
$string['additionalnames'] = 'Nomes adicionais';
$string['addlinkhere'] = 'Adicionar uma hiperligação aqui';
$string['addnew'] = 'Adicionar novo {$a}';
$string['addnewcategory'] = 'Adicionar nova categoria';
$string['addnewcourse'] = 'Adicionar disciplina';
$string['addnewuser'] = 'Adicionar novo utilizador';
$string['addnousersrecip'] = 'Adicionar utilizadores que não tenham acedido este(a) {$a} à lista de destinatários';
$string['addpagehere'] = 'Adicionar texto aqui';
$string['addresource'] = 'Adicionar um recurso';
$string['addresourceoractivity'] = 'Adicionar uma atividade ou um recurso';
$string['addresourcetosection'] = 'Adicionar um recurso à secção \'{$a}\'';
$string['address'] = 'Morada';
$string['addsections'] = 'Adicionar secções';
$string['addstudent'] = 'Adicionar aluno';
$string['addsubcategory'] = 'Adicionar uma subcategoria';
$string['addteacher'] = 'Adicionar professor';
$string['admin'] = 'Administrador';
$string['adminhelpaddnewuser'] = 'Para criar manualmente uma nova conta de utilizador';
$string['adminhelpassignadmins'] = 'Os administradores poderão fazer qualquer coisa e entrar em qualquer parte do site';
$string['adminhelpassigncreators'] = 'Os criadores podem criar novas disciplinas e lecionar nelas';
$string['adminhelpassignsiteroles'] = 'Aplicar papéis atribuídos a utilizadores específicos';
$string['adminhelpassignstudents'] = 'Entre numa disciplina e inscreva alunos a partir do menu de administração';
$string['adminhelpauthentication'] = 'Pode usar contas internas ou de base de dados externas';
$string['adminhelpbackup'] = 'Configurar e programar as cópias de segurança automáticas';
$string['adminhelpconfiguration'] = 'Configurar a aparência e funcionalidades do site';
$string['adminhelpconfigvariables'] = 'Modificar as variáveis da configuração global do site';
$string['adminhelpcourses'] = 'Definir as disciplinas e categorias e atribuir-lhes pessoas; editar disciplinas pendentes';
$string['adminhelpeditorsettings'] = 'Definir configurações básicas do editor HTML';
$string['adminhelpedituser'] = 'Visualizar e/ou editar a lista de contas de utilizadores';
$string['adminhelpenvironment'] = 'Verificar se o servidor cumpre os requisitos para a versão atual do Moodle e posteriores.';
$string['adminhelpfailurelogs'] = 'Ver registo de tentativas de autenticação sem sucesso.';
$string['adminhelplanguage'] = 'Verificar e editar o pacote linguístico atualmente em uso';
$string['adminhelplogs'] = 'Ver todos os registos de atividade do site';
$string['adminhelpmanageblocks'] = 'Gerir blocos instalados e as suas configurações';
$string['adminhelpmanagedatabase'] = 'Aceda diretamente à base de dados (tenha cuidado!)';
$string['adminhelpmanagefilters'] = 'Escolher filtros de texto e configurações relacionadas';
$string['adminhelpmanagemodules'] = 'Configurar os módulos instalados e as suas opções';
$string['adminhelpmanageroles'] = 'Criar ou definir papéis que poderão ser atribuídos aos utilizadores';
$string['adminhelpmymoodle'] = 'Configurar o bloco Minha página principal para utilizadores';
$string['adminhelpreports'] = 'Relatórios a nível do site';
$string['adminhelpsitefiles'] = 'Para publicar ficheiros ou fazer o envio de cópias de segurança externas';
$string['adminhelpsitesettings'] = 'Definir a aparência da página principal do site';
$string['adminhelpstickyblocks'] = 'Configurar blocos persistentes do Moodle';
$string['adminhelpthemes'] = 'Escolher a aparência do site (cores, tipos de letra, etc.)';
$string['adminhelpuploadusers'] = 'Importar ficheiro de texto com novas contas de utilizadores';
$string['adminhelpusers'] = 'Definir os utilizadores e configurar o método de autenticação';
$string['adminhelpxmldbeditor'] = 'Interface para editar os ficheiros XMLDB. Apenas para programadores.';
$string['administration'] = 'Administração';
$string['administrationsite'] = 'Administração do Site';
$string['administrator'] = 'Administrador';
$string['administratordescription'] = 'Habitualmente, os administradores podem fazer qualquer coisa no site, em todas as disciplinas.';
$string['administrators'] = 'Administradores';
$string['administratorsall'] = 'Todos os administradores';
$string['administratorsandteachers'] = 'Administradores e professores';
$string['advanced'] = 'Avançado';
$string['advancedfilter'] = 'Filtro avançado';
$string['advancedsettings'] = 'Configurações avançadas';
$string['afterresource'] = 'A seguir ao recurso: "{$a}"';
$string['aftersection'] = 'A seguir à secção "{$a}"';
$string['again'] = 'novamente';
$string['agelocationverification'] = 'Verificação de idade e localização';
$string['ajaxuse'] = 'AJAX e JavaScript';
$string['all'] = 'Todos';
$string['allactions'] = 'Todas as ações';
$string['allactivities'] = 'Todas as atividades';
$string['allcategories'] = 'Todas as categorias';
$string['allchanges'] = 'Todas as alterações';
$string['alldays'] = 'Todos os dias';
$string['allfiles'] = 'Todos os ficheiros';
$string['allgroups'] = 'Todos os grupos';
$string['alllogs'] = 'Toda a atividade';
$string['allmods'] = 'Todos os {$a}';
$string['allow'] = 'Permitir';
$string['allowinternal'] = 'Permitir também métodos internos';
$string['allownone'] = 'Não permitir nenhum';
$string['allownot'] = 'Não permitir';
$string['allowstealthmodules'] = 'Permitir atividades escondidas';
$string['allowstealthmodules_help'] = 'Se ativar esta opção, as atividades estarão disponíveis, mas não serão apresentadas nas secções visíveis da página da disciplina. Deste modo, as hiperligações para atividades escondidas devem ser fornecidas de outro modo, como por exemplo, utilizando o recurso Página. As atividades escondidas aparecem na pauta e outros relatórios.';
$string['allparticipants'] = 'Todos';
$string['allteachers'] = 'Todos os professores';
$string['alphanumerical'] = 'Só pode conter caracteres alfabéticos ou numéricos';
$string['alreadyconfirmed'] = 'A inscrição já foi confirmada';
$string['alternatename'] = 'Nome alternativo';
$string['always'] = 'Sempre';
$string['and'] = '{$a->one} e {$a->two}';
$string['answer'] = 'Resposta';
$string['any'] = 'Qualquer';
$string['appearance'] = 'Aparência';
$string['apply'] = 'Aplicar';
$string['applyfilters'] = 'Aplicar filtros';
$string['approve'] = 'Aprovar';
$string['areyousure'] = 'Tem a certeza?';
$string['areyousuretorestorethis'] = 'Tem a certeza de que pretende restaurar?';
$string['areyousuretorestorethisinfo'] = 'Mais para a frente neste processo poderá optar por incluir esta cópia de segurança numa outra disciplina já existente, ou numa nova disciplina.';
$string['asc'] = 'Ascendente';
$string['assessment'] = 'Avaliação';
$string['assignadmins'] = 'Designar administradores';
$string['assigncreators'] = 'Designar criadores';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Atribuir papéis para todo o site';
$string['authenticateduser'] = 'Utilizador autenticado';
$string['authenticateduserdescription'] = 'Todos os utilizadores autenticados.';
$string['authentication'] = 'Autenticação';
$string['authenticationplugins'] = 'Módulos de Autenticação';
$string['autosubscribe'] = 'Subscrição de fóruns';
$string['autosubscribeno'] = 'Não: não quero subscrever tópicos dos fóruns automaticamente';
$string['autosubscribeyes'] = 'Sim: quero subscrever o tópico do fórum quando submeto uma mensagem';
$string['availability'] = 'Disponibilidade';
$string['availablecourses'] = 'Disciplinas disponíveis';
$string['back'] = 'Voltar';
$string['backto'] = 'Voltar para {$a}';
$string['backtocourselisting'] = 'Voltar à lista de disciplinas';
$string['backtohome'] = 'Voltar à página inicial';
$string['backtopageyouwereon'] = 'Voltar à página anterior';
$string['backup'] = 'Cópia de segurança';
$string['backupactivehelp'] = 'Decida se deverão ser feitas ou não cópias de segurança automáticas.';
$string['backupadhocpending'] = 'Tarefa ad hoc de cópia de segurança da disciplina pendente';
$string['backupcancelled'] = 'Cópia de segurança interrompida';
$string['backupcoursefileshelp'] = 'Se estiver selecionado, os ficheiros de uma disciplina serão incluídos nas cópias de segurança automáticas.';
$string['backupdate'] = 'Data da cópia de segurança';
$string['backupdatenew'] = '{$a->TAG} é agora {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} era {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Detalhes da cópia de segurança';
$string['backuperrorinvaliddestination'] = 'A pasta de destino da cópia de segurança não existe ou não pode ser modificada.';
$string['backupexecuteathelp'] = 'Escolha a hora em que inicia a execução das cópias de segurança automáticas.';
$string['backupfailed'] = 'Algumas das suas disciplinas não foram guardadas.';
$string['backupfilename'] = 'backup';
$string['backupfinished'] = 'Cópia de segurança concluída com sucesso';
$string['backupfromthissite'] = 'Cópia de segurança é feita na disciplina?';
$string['backupgradebookhistoryhelp'] = 'Se ativar esta opção, o historial da pauta será incluído nos backups automáticos. Tenha em atenção que para o historial da pauta ser guardado, não deve estar inativo nas configurações do Servidor (disablegradehistory)';
$string['backupincludemoduleshelp'] = 'Escolha se quer incluir módulos de uma disciplina, com ou sem dados de utilizadores, nas cópias de segurança automáticas.';
$string['backupincludemoduleuserdatahelp'] = 'Escolha se quer ou não incluir dados de utilizador dos módulos nas cópias de segurança automáticas.';
$string['backupinfo'] = 'Criar uma cópia desta disciplina, incluindo todo o conteúdo e atividades até à data. Pode usar o ficheiro de cópia de segurança para restaurar a disciplina.';
$string['backuplogdetailed'] = 'Estatísticas detalhadas de execução';
$string['backuploglaststatus'] = 'Relatório sobre cópias de segurança automáticas das disciplinas';
$string['backupmissinguserinfoperms'] = 'Nota: Esta cópia de segurança não contém dados dos utilizadores. As atividades Exercise e Workshop não serão incluídas porque não são compatíveis com este tipo de cópia de segurança.';
$string['backupnext'] = 'Próxima cópia de segurança';
$string['backupnonisowarning'] = 'Aviso: esta cópia de segurança é de uma versão do Moodle que não usa Unicode (anterior a 1.6). Se esta cópia contiver caracteres que não sejam ISO-8859-1, poderão ficar CORROMPIDOS se tentar restaurá-los para esta versão Unicode do Moodle. Consulte a página <a href="https://docs.moodle.org/en/Backup_FAQ">Backup FAQ</a> para mais informações sobre como recuperar corretamente esta cópia de segurança.';
$string['backupnotyetrun'] = 'Cópia de Segurança Automática pendente';
$string['backuporiginalname'] = 'Nome da cópia de segurança';
$string['backuproleassignments'] = 'Incluir atribuições para estes papéis na cópia de segurança';
$string['backupsavetohelp'] = 'Nome e caminho completo da pasta onde pretende guardar os ficheiros das cópias de segurança.';
$string['backupsitefileshelp'] = 'Se for ativado, os ficheiros do site usados em disciplinas serão incluídos nas cópias de segurança automáticas';
$string['backuptakealook'] = 'Por favor, leia os relatórios dos processos de criação de cópias de segurança em: {$a}';
$string['backupuserfileshelp'] = 'Escolha se os ficheiros de alunos (por exemplo, fotos de perfil) deverão ser incluídos nas cópias de segurança automáticas.';
$string['backupversion'] = 'Versão da cópia de segurança';
$string['badges'] = 'Medalhas';
$string['block'] = 'Bloco';
$string['blockconfiga'] = 'Configuração do bloco "{$a}"';
$string['blockconfigbad'] = 'Este bloco não tem uma interface de configuração, por não ter sido implementado corretamente.';
$string['blocks'] = 'Blocos';
$string['blocks_main'] = 'Blocos de conteúdo principal';
$string['blocks_supplementary'] = 'Blocos adicionais';
$string['blocksaddedit'] = 'Adicionar/Editar blocos';
$string['blockseditoff'] = 'Desativar edição de blocos';
$string['blocksediton'] = 'Ativar edição de blocos';
$string['blocksetup'] = 'A configurar tabelas de blocos';
$string['blocksuccess'] = 'As tabelas de {$a} foram configuradas corretamente';
$string['brief'] = 'Menos detalhes';
$string['bulkactions'] = 'Operações em massa';
$string['bulkactionselect'] = '{$a} seleção de operação em massa';
$string['bulkcancel'] = 'Fechar edição em massa';
$string['bulkmovecoursessuccess'] = 'Foram movidas com sucesso {$a->courses} disciplinas para \'{$a->category}\'';
$string['bulkselection'] = '{$a} selecionados';
$string['bycourseorder'] = 'Por ordem de disciplina';
$string['byname'] = 'por {$a}';
$string['bypassed'] = 'Ultrapassada';
$string['cachecontrols'] = 'Controlo da Cache';
$string['calltofeedback'] = 'Os programadores deste software gostavam de saber o seu feedback.';
$string['calltofeedback_give'] = 'Dar feedback acerca deste software';
$string['calltofeedback_remind'] = 'Lembrar-me mais tarde';
$string['cancel'] = 'Cancelar';
$string['cancelled'] = 'Cancelado';
$string['categories'] = 'Categorias de disciplinas';
$string['categoriesandcourses'] = 'Disciplinas e categorias de disciplinas';
$string['category'] = 'Categoria';
$string['categoryadded'] = 'A categoria \'{$a}\'  foi adicionada';
$string['categorybulkaction'] = 'Operações em massa para as categorias selecionadas';
$string['categorycontents'] = 'Subcategorias e disciplinas';
$string['categorycurrentcontents'] = 'Conteúdo de {$a}';
$string['categorydeleted'] = 'A categoria \'{$a}\' foi apagada';
$string['categoryduplicate'] = 'Já existe uma categoria com o nome \'{$a}\'!';
$string['categoryheader'] = 'Menu da categoria';
$string['categoryhidden'] = '(oculta)';
$string['categorymodifiedcancel'] = 'A Categoria foi modificada! Cancele e tente de novo.';
$string['categoryname'] = 'Nome da categoria';
$string['categorypath'] = 'Caminho da categoria';
$string['categorysubcategoryof'] = '{$a->category} - subcategoria de {$a->parentcategory}';
$string['categoryupdated'] = 'A categoria \'{$a}\' foi atualizada';
$string['changedpassword'] = 'Senha modificada';
$string['changepassword'] = 'Modificar senha';
$string['changesmade'] = 'Alterações efetuadas';
$string['changesmadereallygoaway'] = 'Fez alterações. Tem a certeza de que pretende sair e perder as alterações efetuadas?';
$string['changessaved'] = 'Alterações guardadas com sucesso';
$string['check'] = 'Verificar';
$string['checkactual'] = 'Atual';
$string['checkall'] = 'Verificar tudo';
$string['checkerror'] = 'Erro ao obter o resultado da verificação \'{$a}\'. Para mais informações, verifique a consola do navegador.';
$string['checkexpected'] = 'Esperado';
$string['checkingbackup'] = 'A verificar a cópia de segurança';
$string['checkingcourse'] = 'Verificando a disciplina';
$string['checkingforbbexport'] = 'Verificando exportação para BlackBoard';
$string['checkinginstances'] = 'Verificando instâncias';
$string['checkingsections'] = 'Verificando secções';
$string['checklanguage'] = 'Verificar o idioma';
$string['checkloading'] = 'A obter o resultado da verificação \'{$a}\'';
$string['checknone'] = 'Não verificar nada';
$string['checks'] = 'Verificações';
$string['checksok'] = 'Todas as verificações \'{$a}\' estão OK';
$string['childcoursenotfound'] = 'Disciplina de proveniência não encontrada';
$string['childcourses'] = 'Disciplinas descendentes';
$string['choose'] = 'Selecionar';
$string['choosecourse'] = 'Escolha uma disciplina';
$string['choosedots'] = 'Escolha…';
$string['chooselivelogs'] = 'Ou examine estatísticas de acesso atual';
$string['chooselogs'] = 'Escolha os registos de atividade que pretende consultar';
$string['choosereportfilter'] = 'Escolha um filtro para o relatório';
$string['choosetheme'] = 'Escolha um tema';
$string['chooseuser'] = 'Escolha um utilizador';
$string['city'] = 'Cidade/Estado';
$string['cleaningtempdata'] = 'A apagar dados temporários';
$string['clear'] = 'Apagar';
$string['clearfilterrow'] = 'Remover linha de filtro';
$string['clearfilters'] = 'Limpar filtros';
$string['clearsearch'] = 'Limpar entrada da pesquisa';
$string['clickhelpiconformoreinfo'] = '... continua ... Clique no ícone de ajuda para ler o artigo completo';
$string['clickhere'] = 'Clique aqui...';
$string['clicktochangeinbrackets'] = '{$a} (Clique para alterar)';
$string['clicktohideshow'] = 'Clique para expandir ou contrair';
$string['closeblockdrawer'] = 'Fechar painel dos blocos';
$string['closebuttontitle'] = 'Fechar';
$string['closecourseindex'] = 'Fechar índice da disciplina';
$string['closedrawer'] = 'Fechar painel';
$string['closewindow'] = 'Fechar esta janela';
$string['collapse'] = 'Contrair';
$string['collapseall'] = 'Contrair tudo';
$string['collapsecategory'] = 'Contrair {$a}';
$string['comebacklater'] = 'Por favor, volte mais tarde.';
$string['commentincontext'] = 'Encontrar este comentário no contexto';
$string['comments'] = 'Comentários';
$string['commentscount'] = 'Comentários ({$a})';
$string['commentsnotenabled'] = 'Os comentários não estão ativos';
$string['commentsrequirelogin'] = 'Necessita de estar autenticado para ver os comentários';
$string['comparelanguage'] = 'Comparar e editar o pacote linguístico em uso';
$string['complete'] = 'Concluído';
$string['completed'] = 'Concluído';
$string['completereport'] = 'Relatório completo';
$string['configuration'] = 'Configuração';
$string['confirm'] = 'Confirmação';
$string['confirmaccount'] = 'Confirmar conta';
$string['confirmcheckfull'] = 'Tem a certeza absoluta de que pretende confirmar {$a}?';
$string['confirmcoursemove'] = 'Tem a certeza de que pretende mover esta disciplina ({$a->course}) para esta categoria ({$a->category})?';
$string['confirmdeletesection'] = 'Tem a certeza absoluta de que pretende apagar completamente "{$a}" e todas as atividades que contém?';
$string['confirmed'] = 'O seu registo foi confirmado com sucesso,';
$string['confirmednot'] = 'O seu registo ainda não foi confirmado. Por favor, verifique a sua caixa de correio para um e-mail de confirmação.';
$string['considereddigitalminor'] = 'Ainda não tem idade para criar uma conta neste site';
$string['content'] = 'Conteúdo';
$string['contentbank'] = 'Banco de conteúdos';
$string['contentexport_aboutthiscourse'] = 'Descrição da disciplina';
$string['contentexport_coursesummary'] = 'Este ficheiro é parte do conteúdo descarregado de <a href="{$a->courselink}">{$a->coursename}</a>.';
$string['contentexport_footersummary'] = 'Este ficheiro é parte do conteúdo descarregado de <a href="{$a->courselink}">{$a->coursename}</a> por {$a->userfullname} {$a->date}.';
$string['contentexport_modulesummary'] = 'Esta página é parte do conteúdo descarregado de <a href="{$a->modulelink}">{$a->modulename}</a> {$a->date}. Tenha em atenção que parte do conteúdo e quaisquer ficheiros maiores que {$a->maxfilesize} não são descarregados.';
$string['contentexport_viewfilename'] = 'Visualizar o ficheiro "{$a}"';
$string['context'] = 'Contexto';
$string['contextlevel'] = 'Nível do contexto';
$string['contextname'] = 'Nome do contexto';
$string['contextparent'] = 'Ascendente';
$string['contexturl'] = 'URL do contexto';
$string['continue'] = 'Continuar';
$string['continuetocourse'] = 'Carregue aqui para entrar na sua disciplina';
$string['convertingwikitomarkdown'] = 'A converter Wiki para Markdown';
$string['cookiesenabled'] = 'Tem de ativar o suporte para cookies no seu navegador';
$string['cookiesenabled_help'] = 'Neste site são utilizados dois cookies:

O essencial é o cookie da sessão, normalmente chamado de MoodleSession. Deve permitir este cookie no seu navegador para manter a sua autenticação quando navega de página para página. Quando sair ou fechar o navegador este cookie é eliminado (no seu navegador e no servidor).

O outro cookie é puramente por conveniência, geralmente chamado de MOODLEID ou similar. Apenas guarda o seu nome de utilizador no navegador. Isto significa que quando voltar a este site o nome de utilizador na página de autenticação já estará preenchido. É seguro recusar este cookie - apenas terá que escrever o seu nome de utilizador cada vez que acede à plataforma.';
$string['cookiesenabled_help_html'] = 'Neste site são utilizados dois cookies:<br/><br/>

O essencial é o cookie da sessão, normalmente chamado de MoodleSession. Deve permitir este cookie no seu navegador para manter a sua autenticação quando navega de página para página. Quando sair ou fechar o navegador este cookie é eliminado (no seu navegador e no servidor).<br/><br/>

O outro cookie é puramente por conveniência, geralmente chamado de MOODLEID ou similar. Apenas guarda o seu nome de utilizador no navegador. Isto significa que quando voltar a este site o nome de utilizador na página de autenticação já estará preenchido. É seguro recusar este cookie - apenas terá que escrever o seu nome de utilizador cada vez que acede à plataforma.';
$string['cookiesenabledonlysession'] = 'Tem de ativar o suporte para cookies no seu navegador';
$string['cookiesenabledonlysession_help'] = 'Este site usa um cookie de sessão, geralmente chamado MoodleSession. Tem de permitir este cookie no seu navegador para permitir a continuidade e para que permaneça autenticado ao navegar pelo site. Quando sai ou fecha o navegador, o cookie é destruído (no seu navegador e no servidor).';
$string['cookiesnotenabled'] = 'Infelizmente o seu navegador tem os cookies desativados';
$string['cookiesnotice'] = 'Informação sobre cookies';
$string['copy'] = 'Duplicar';
$string['copyasnoun'] = 'Cópia';
$string['copycourse'] = 'Copiar disciplina';
$string['copyingcoursefiles'] = 'A copiar os ficheiros da disciplina';
$string['copyingsitefiles'] = 'A copiar ficheiros do site usados na disciplina';
$string['copyinguserfiles'] = 'A copiar os ficheiros de utilizador';
$string['copyingzipfile'] = 'A copiar os ficheiros Zip';
$string['copyrightnotice'] = 'Nota de direitos de autor';
$string['copytoclipboard'] = 'Copiar para a área de transferência';
$string['coresystem'] = 'Sistema';
$string['cost'] = 'Custo';
$string['costdefault'] = 'Custo predefinido';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'País';
$string['course'] = 'Disciplina';
$string['courseadministration'] = 'Administração da disciplina';
$string['courseapprovedemail'] = 'A disciplina que pediu foi aprovada, <a href="{$a->url}">{$a->name}</a> e está registado como {$a->teacher}.';
$string['courseapprovedemail2'] = 'A disciplina que pediu foi aprovada: <a href="{$a->url}">{$a->name}</a>.';
$string['courseapprovedfailed'] = 'Não foi possível guardar a disciplina como aprovada!';
$string['courseapprovedsubject'] = '.A sua disciplina foi aprovada';
$string['courseavailable'] = 'Esta disciplina está disponível para os alunos';
$string['courseavailablenot'] = 'Esta disciplina não está disponível para os alunos';
$string['coursebackup'] = 'Cópia de segurança da disciplina';
$string['coursebulkaction'] = 'Aplicar operação em massa para as disciplinas selecionadas';
$string['coursecategories'] = 'Categorias de disciplinas';
$string['coursecategory'] = 'Categoria da disciplina';
$string['coursecategory_help'] = 'Esta configuração determina a categoria em que a disciplina vai aparecer na lista de disciplinas.';
$string['coursecategorydeleted'] = 'A categoria {$a} foi apagada';
$string['coursecatmanagement'] = 'Gestão de disciplinas e categorias';
$string['coursecompletion'] = 'Conclusão da disciplina';
$string['coursecompletions'] = 'Conclusões da disciplina';
$string['coursecreators'] = 'Criador de disciplinas';
$string['coursecreatorsdescription'] = 'Os criadores de disciplinas podem criar novas disciplinas e lecionar nelas.';
$string['coursedeleted'] = 'A disciplina {$a} foi apagada';
$string['coursedetails'] = 'Informação sobre disciplinas';
$string['coursedisplay'] = 'Visualização';
$string['coursedisplay_help'] = 'As secções da disciplina podem ser exibidas numa única página ou divididas em várias páginas.';
$string['coursedisplay_multi'] = 'Mostrar uma secção por página';
$string['coursedisplay_single'] = 'Mostrar todas as secções na mesma página';
$string['courseduration'] = 'Duração da disciplina';
$string['courseduration_desc'] = 'A duração da disciplina serve para calcular a data de fim predefinida da disciplina. A data de fim da disciplina é usada para determinar se a disciplina deve estar incluída na lista de disciplinas do utilizador. A data de fim da disciplina também pode ser usada em relatórios personalizados. Os utilizadores continuarão a poder aceder à disciplina após a data de fim.';
$string['courseenddateenabled'] = 'Data de fim da disciplina ativada por predefinição';
$string['courseenddateenabled_desc'] = 'Esta configuração determina se a data de fim da disciplina será ativada, por predefinição, para novas disciplinas e ajustada para a data calculada a partir da duração da disciplina.';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Ficheiros da disciplina (compatibilidade com versões anteriores do Moodle)';
$string['coursefilesedit'] = 'Editar ficheiros antigos da disciplina (compatibilidade com versões anteriores do Moodle)';
$string['coursefileswarning'] = 'Os ficheiros da disciplina estão desatualizados';
$string['coursefileswarning_help'] = 'Os ficheiros da disciplina estão desatualizados desde o Moodle 2.0, use repositórios externos sempre que possível.';
$string['courseformatdata'] = 'Dados do formato da disciplina';
$string['courseformatoptions'] = 'Opção de formato para {$a}';
$string['courseformats'] = 'Formatos da disciplina';
$string['courseformatudpate'] = 'Atualizar formato';
$string['coursegrades'] = 'Notas da disciplina';
$string['courseheader'] = 'Menu da disciplina';
$string['coursehelpcategory'] = 'Insira a disciplina na lista de disciplinas, para tornar mais fácil os alunos encontrarem-na.';
$string['coursehelpforce'] = 'Forçar o modo de grupo para todas as atividades na disciplina.';
$string['coursehelpformat'] = 'A página principal da disciplina será mostrada neste formato.';
$string['coursehelphiddensections'] = 'Forma como as secções ocultas da disciplina são apresentadas aos alunos.';
$string['coursehelpmaximumupload'] = 'Tamanho máximo do ficheiro que é possível carregar na disciplina, limitado pelo tamanho máximo definido para todo o site.';
$string['coursehelpnewsitemsnumber'] = 'Número de itens recentes do fórum Anúncios que aparecem no bloco Últimos anúncios na página da disciplina. Se definir esta opção como zero (0), o bloco Últimos anúncios não será criado.';
$string['coursehelpnumberweeks'] = 'Número de secções da disciplina (só se aplica a certos formatos de disciplina).';
$string['coursehelpshowgrades'] = 'Permitir que a pauta esteja disponível para os alunos. Não impede que as notas sejam apresentadas em cada atividade.';
$string['coursehidden'] = 'De momento, esta disciplina não está disponível para os alunos';
$string['courseinfo'] = 'Informações sobre a disciplina';
$string['courselegacyfiles'] = 'Ficheiros da disciplina (compatibilidade com versões anteriores do Moodle)';
$string['courselegacyfiles_help'] = 'A área Ficheiros da disciplina fornece alguma retrocompatibilidade com a versão 1.9 do Moodle e anteriores. Tenha em atenção que todos os ficheiros nesta área estão sempre acessíveis a todos os participantes da disciplina (quer estabeleça, ou não, uma hiperligação para eles) e não existe forma de saber se, nem onde, estes ficheiros estão a ser usados no Moodle.

Se usar esta área para guardar ficheiros da disciplina, pode estar a correr riscos de violação de privacidade e segurança, assim como sujeito a falta de ficheiros nas cópias de segurança, importação de disciplinas e na partilha de conteúdos. Assim, não é aconselhável a utilização desta área a não ser que tenha de facto a certeza do que está a fazer.';
$string['courselegacyfiles_link'] = 'coursefiles2';
$string['courselegacyfilesofcourse'] = 'Ficheiros de retrocompatibilidade da disciplina: {$a}';
$string['coursenotaccessible'] = 'Esta disciplina não permite acesso público';
$string['courseoverview'] = 'Visão global da disciplina';
$string['courseoverviewfiles'] = 'Imagem da disciplina';
$string['courseoverviewfiles_help'] = 'A imagem da disciplina é exibida no bloco \'Minhas disciplinas\' e na lista de disciplinas disponíveis no Painel do utilizador. Os administradores do site podem ativar tipos de ficheiro adicionais e o uso de vários ficheiros. Se usar vários ficheiros, todos eles serão mostrados na lista de disciplinas disponíveis no Painel do utilizador.';
$string['courseoverviewfilesext'] = 'Extensões dos ficheiros de imagem da disciplina';
$string['courseoverviewfileslimit'] = 'Número máximo de ficheiros de imagem da disciplina';
$string['courseoverviewgraph'] = 'Gráfico sumário da disciplina';
$string['courseprofiles'] = 'Perfis da disciplina';
$string['coursereasonforrejecting'] = 'Razão para rejeitar este pedido';
$string['coursereasonforrejectingemail'] = 'Mensagem que será enviada a quem fez o pedido';
$string['coursereject'] = 'Rejeitar pedido de disciplina';
$string['courserejected'] = 'O pedido de disciplina foi rejeitado e o autor do pedido foi notificado.';
$string['courserejectemail'] = 'Lamentamos, mas a disciplina que pediu foi rejeitada. A causa é a seguinte:

{$a}';
$string['courserejectreason'] = 'Justifique a sua decisão de rejeitar a disciplina<br />(a sua justificação será enviada por e-mail para o autor do pedido)';
$string['courserejectsubject'] = 'A sua disciplina não foi aprovada';
$string['coursereport'] = 'Relatório da disciplina';
$string['coursereports'] = 'Relatórios da disciplina';
$string['courserequest'] = 'Pedido de disciplina';
$string['courserequestdetails'] = 'Detalhes da disciplina que está a pedir';
$string['courserequestfailed'] = 'Por alguma razão a disciplina que pediu não pode ser gravada';
$string['courserequestintro'] = 'Use este formulário para fazer um pedido de criação de disciplina.<br />Tente preencher o formulário quanto possível<br />para que os administradores possam compreender a sua razão para o pedido.';
$string['courserequestreason'] = 'Justificação do pedido de criação da disciplina';
$string['courserequestroleerror'] = 'O papel de criador de disciplina na configuração de novas disciplinas é inválido. Consulte a <a href="{$a}">Política de utilizadores</a>.';
$string['courserequestsuccess'] = 'Pedido de criação de disciplina submetido.';
$string['courserequestsupport'] = 'Informação de suporte para auxiliar o administrador a avaliar este pedido';
$string['courserequestwarning'] = 'O utilizador que efetuou o pedido da disciplina será inscrito automaticamente e ser-lhe-á atribuído o papel de {$a}.';
$string['courserestore'] = 'Restauro da disciplina';
$string['coursereuse'] = 'Reutilizar disciplina';
$string['coursereusenavigationmenu'] = 'Menu de navegação da reutilização da disciplina';
$string['courses'] = 'Disciplinas';
$string['coursesearch'] = 'Procurar disciplinas';
$string['coursesearch_help'] = 'Pode pesquisar várias palavras de uma só vez e especificar a pesquisa de várias formas:

palavra - encontrar qualquer correspondência da palavra no texto
+palavra - encontrar apenas as correspondências exatas da palavra
-palavra - não incluir resultados que contenham a palavra';
$string['coursesectionsummaries'] = 'Secção de sumários da disciplina';
$string['coursesectiontitle'] = '{$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitlebulkediting'] = 'Editar em massa {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitleediting'] = 'Editar {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesettings'] = 'Configuração predefinida das disciplinas';
$string['coursesmovedout'] = 'Disciplinas movidas de {$a}';
$string['coursespending'] = 'Disciplinas à espera de aprovação';
$string['coursestart'] = 'Início';
$string['coursesummary'] = 'Descrição da disciplina';
$string['coursesummary_help'] = 'Uma breve descrição da sua disciplina. A pesquisa de disciplinas também procura nesta informação.';
$string['coursetitle'] = 'Disciplina: {$a->course}';
$string['coursetitlebulkediting'] = 'Edição em massa da disciplina: {$a->course}';
$string['coursetitleediting'] = 'Editar disciplina: {$a->course}';
$string['courseupdates'] = 'Atualizações da disciplina';
$string['coursevisibility'] = 'Visibilidade da disciplina';
$string['coursevisibility_help'] = '* Mostrar: A disciplina aparece na lista de disciplinas e os alunos podem aceder.
* Ocultar: O acesso é restrito a professores e outros utilizadores com a permissão de visualizar disciplinas ocultas.';
$string['create'] = 'Criar';
$string['createaccount'] = 'Criar a minha conta';
$string['createcategory'] = 'Criar categoria';
$string['createfolder'] = 'Criar uma pasta em {$a}';
$string['createnew'] = 'Criar novo';
$string['createnewcategory'] = 'Criar nova categoria';
$string['createnewcourse'] = 'Criar nova disciplina';
$string['createnewsubcategory'] = 'Criar nova subcategoria';
$string['createsubcategoryof'] = 'Criar subcategoria de {$a}';
$string['createuser'] = 'Criar utilizador';
$string['createziparchive'] = 'Criar um ficheiro Zip';
$string['creatingblocks'] = 'A criar blocos';
$string['creatingblocksroles'] = 'A criar atribuições e redefinições de papéis ao nível de blocos.';
$string['creatingblogsinfo'] = 'A criar informação dos blogues';
$string['creatingcategoriesandquestions'] = 'A criar categorias e perguntas';
$string['creatingcoursemodules'] = 'A criar módulos da disciplina';
$string['creatingcourseroles'] = 'A criar atribuições e redefinições de papéis ao nível de disciplinas.';
$string['creatingevents'] = 'A criar eventos';
$string['creatinggradebook'] = 'A criar a pauta';
$string['creatinggroupings'] = 'A criar agrupamentos';
$string['creatinggroupingsgroups'] = 'A adicionar grupos ao agrupamento';
$string['creatinggroups'] = 'A criar grupos';
$string['creatinglogentries'] = 'A criar registo de entradas';
$string['creatingmessagesinfo'] = 'A criar informação sobre mensagens';
$string['creatingmodroles'] = 'A criar atribuições e redefinições de papéis ao nível de módulos.';
$string['creatingnewcourse'] = 'A criar nova disciplina';
$string['creatingrolesdefinitions'] = 'A definir os papéis a atribuir';
$string['creatingscales'] = 'A criar escalas';
$string['creatingsections'] = 'A criar secções';
$string['creatingtemporarystructures'] = 'A criar estruturas temporárias';
$string['creatinguserroles'] = 'A criar atribuições e redefinições de papéis ao nível de utilizadores.';
$string['creatingusers'] = 'A criar utilizadores';
$string['creatingxmlfile'] = 'A criar ficheiro XML';
$string['currency'] = 'Moeda';
$string['currentcourse'] = 'Disciplina atual';
$string['currentcourseadding'] = 'A inserir dados para a disciplina selecionada';
$string['currentcoursedeleting'] = 'A apagar a disciplina atual';
$string['currentlanguage'] = 'Idioma usado atualmente';
$string['currentlocaltime'] = 'a sua hora local';
$string['currentpicture'] = 'Foto atual';
$string['currentrelease'] = 'Informação da versão atual';
$string['currenttheme'] = 'Tema atual';
$string['currentversion'] = 'Versão atual';
$string['databasechecking'] = 'A atualizar a base de dados do Moodle da versão {$a->oldversion} para a versão {$a->newversion}...';
$string['databaseperformance'] = 'Desempenho da base de dados';
$string['databasesetup'] = 'A configurar a base de dados';
$string['databasesuccess'] = 'Base de dados atualizada com sucesso';
$string['databaseupgradebackups'] = 'A versão da cópia de segurança é {$a}';
$string['databaseupgradeblocks'] = 'A versão dos blocos é agora {$a}';
$string['databaseupgradegroups'] = 'A versão dos grupos é agora {$a}';
$string['databaseupgradelocal'] = 'A versão de personalização da base de dados local é agora {$a}';
$string['databaseupgrades'] = 'A atualizar a base de dados';
$string['dataformats'] = 'Formatos dos dados';
$string['date'] = 'Data';
$string['datechanged'] = 'Data alterada';
$string['datemostrecentfirst'] = 'Data - mais recente primeiro';
$string['datemostrecentlast'] = 'Data - mais recente no fim';
$string['day'] = 'dia';
$string['days'] = 'dias';
$string['decodinginternallinks'] = 'A descodificar apontadores internos';
$string['default'] = 'Predefinido';
$string['defaultcategoryname'] = 'Categoria 1';
$string['defaultcompetencescale'] = 'Escala de competência predefinida';
$string['defaultcompetencescaledesc'] = 'Uma escala de avaliação binária que apenas fornece informação acerca da demonstração, ou não, de proficiência.';
$string['defaultcompetencescalenotproficient'] = 'Ainda não adquiriu a competência';
$string['defaultcompetencescaleproficient'] = 'Adquiriu a competência';
$string['defaultcoursestudent'] = 'Aluno';
$string['defaultcoursestudentdescription'] = 'Os alunos são geralmente os que têm menos privilégios dentro da disciplina.';
$string['defaultcoursestudents'] = 'Alunos';
$string['defaultcoursesummary'] = 'Escreva aqui um parágrafo que explique de forma concisa e interessante o que esta disciplina é.';
$string['defaultcourseteacher'] = 'Professor';
$string['defaultcourseteacherdescription'] = 'Os professores podem realizar qualquer ação dentro da disciplina, incluindo alteração das atividades e avaliação dos alunos.';
$string['defaultcourseteachers'] = 'Professores';
$string['defaulteditor'] = 'Editor predefinido';
$string['defaulthomepageuser'] = 'Página inicial';
$string['defaulthomepageuser_help'] = 'Para qual página deve ser redirecionado após autenticar-se no site?';
$string['delete'] = 'Apagar';
$string['deleteablock'] = 'Apagar bloco';
$string['deleteall'] = 'Apague todos(as)';
$string['deleteallcannotundo'] = 'Apagar tudo - não pode ser recuperado';
$string['deleteallcomments'] = 'Apagar todos os comentários';
$string['deleteallratings'] = 'Apagar todas as avaliações';
$string['deletecategory'] = 'Apagar categoria: {$a}';
$string['deletecategorycheck'] = 'Tem a certeza absoluta de que pretende apagar completamente a categoria \'<b>{$a}</b>\'?<br />As disciplinas da categoria serão deslocadas para a categoria ascendente, se existir, ou para a categoria Diversos.';
$string['deletecategorycheck2'] = 'Se apagar esta categoria, deve decidir o que fazer às disciplinas e subcategorias nela contidas.';
$string['deletecategoryempty'] = 'Esta categoria está vazia.';
$string['deletecheck'] = 'Apagar {$a}?';
$string['deletecheckfiles'] = 'Tem a certeza de que pretende apagar estes ficheiros?';
$string['deletecheckfull'] = 'Tem a certeza absoluta de que pretende apagar completamente o utilizador <b>{$a}</b>, incluindo as inscrições, atividade e outras informações do utilizador?';
$string['deletechecktype'] = 'Tem a certeza de que pretende apagar \'<strong>{$a->type}</strong>\'?';
$string['deletechecktypename'] = 'Tem a certeza de que pretende apagar <strong>{$a->type}</strong> - "{$a->name}"?';
$string['deletecheckwarning'] = 'Está prestes a apagar estes ficheiros';
$string['deletecommentbyon'] = 'Apagar o comentário publicado {$a->time} por {$a->user}';
$string['deletecompletely'] = 'Apagar completamente';
$string['deletecourse'] = 'Apagar uma disciplina';
$string['deletecoursecheck'] = 'Tem a certeza absoluta de que pretende apagar completamente esta disciplina e todos os dados contidos nela?';
$string['deleted'] = 'Apagado(a)';
$string['deletedactivity'] = 'Apagado: {$a}';
$string['deletedcourse'] = 'A disciplina \'{$a}\' foi completamente apagada';
$string['deletednot'] = 'Não foi possível apagar {$a}.';
$string['deletepicture'] = 'Apagar';
$string['deletesection'] = 'Apagar';
$string['deleteselected'] = 'Apagar selecionados';
$string['deleteselectedkey'] = 'Apagar chave selecionada';
$string['deletingcourse'] = 'A apagar {$a}';
$string['deletingexistingcoursedata'] = 'A apagar dados da disciplina';
$string['deletingolddata'] = 'A apagar dados antigos';
$string['department'] = 'Departamento';
$string['deprecatedeventname'] = '{$a} (em desuso)';
$string['desc'] = 'Descendente';
$string['description'] = 'Descrição';
$string['deselectall'] = 'Desselecionar';
$string['deselectnos'] = 'Desmarcar todos \'Não\'';
$string['detailedless'] = 'Menos detalhes';
$string['detailedmore'] = 'Mais detalhes';
$string['details'] = 'Detalhes';
$string['digitalminor'] = 'Criança';
$string['digitalminor_desc'] = 'Peça aos seus pais/responsáveis para contactarem:';
$string['directory'] = 'Pasta';
$string['disable'] = 'Desativar';
$string['disabledcomments'] = 'Comentários desativados';
$string['dismissnotification'] = 'Ignorar esta notificação';
$string['displayingfirst'] = 'Apenas o(s) primeiro(s) {$a->count} {$a->things} são apresentados';
$string['displayingrecords'] = 'Total de registos: {$a}';
$string['displayingusers'] = 'Listagem dos utilizadores desde {$a->start} até {$a->end}';
$string['displayonpage'] = 'Mostrar na página';
$string['dndcourse'] = 'Pode arrastar e largar esta disciplina para alterar a sua posição ou para a mover para outra categoria.';
$string['dndenabled_inbox'] = 'arraste para aqui os ficheiros para os carregar';
$string['dndnotsupported'] = 'Carregar ficheiros através de arrastar e largar não é suportado';
$string['dndnotsupported_help'] = 'O seu navegador não suporta o carregamento de ficheiros através de arrastar e largar. Esta funcionalidade está disponível em todas as versões recentes do Chrome, Firefox e Safari, bem como no Internet Explorer 10 e posterior.';
$string['dndnotsupported_insentence'] = 'Arrastar e largar não é suportado';
$string['dnduploadwithoutcontent'] = 'Este carregamento não tem conteúdo nenhum';
$string['dndworkingfile'] = 'Para adicionar ficheiros aos tópicos, arraste-os do seu computador para o local pretendido';
$string['dndworkingfilelink'] = 'Para adicionar ficheiros ou hiperligações aos tópicos, arraste-os do seu computador para o local pretendido';
$string['dndworkingfiletext'] = 'Para adicionar ficheiros ou textos aos tópicos, arraste-os do seu computador para o local pretendido';
$string['dndworkingfiletextlink'] = 'Arraste do seu computador ficheiros, textos ou hiperligações para dentro dos tópicos';
$string['dndworkinglink'] = 'Para adicionar hiperligações nos tópicos, arraste-as do seu computador para o local pretendido';
$string['dndworkingtext'] = 'Para adicionar texto nos tópicos, arraste-o do seu computador para o local pretendido';
$string['dndworkingtextlink'] = 'Para adicionar textos ou hiperligações nos tópicos, arraste-os do seu computador para o local pretendido';
$string['documentation'] = 'Documentação do Moodle';
$string['dontsortcategories'] = 'Não ordenar categorias';
$string['dontsortcourses'] = 'Não ordenar disciplinas';
$string['down'] = 'Para baixo';
$string['download'] = 'Descarregar';
$string['downloadall'] = 'Descarregar tudo';
$string['downloadexcel'] = 'Descarregar em formato Excel';
$string['downloadfile'] = 'Descarregar ficheiro';
$string['downloadods'] = 'Descarregar em formato ODS';
$string['downloadtext'] = 'Descarregar em formato Texto';
$string['doyouagree'] = 'Leu e compreendeu as condições?';
$string['droptoupload'] = 'arraste para aqui os ficheiros para os carregar';
$string['duplicate'] = 'Duplicar';
$string['duplicatedmodule'] = '{$a} (cópia)';
$string['duplicatedsection'] = '{$a} (cópia)';
$string['edhelpaspellpath'] = 'A verificação ortográfica no editor só pode ser utilizada se no servidor estiver instalado o programa <strong>aspell 0.50</strong> (ou versões posteriores). Além disso, é necessário especificar o caminho correto para o ficheiro executável do programa.  Em sistemas Unix/Linux este caminho é normalmente algo como <strong>/usr/bin/aspell</strong>.';
$string['edhelpbgcolor'] = 'Definir a área de edição de cor de fundo.<br />Os valores válidos são, por exemplo, #FFFFFF ou branco';
$string['edhelpcleanword'] = 'Esta configuração ativa ou desativa o formato Word específico de filtragem.';
$string['edhelpenablespelling'] = 'Ativa ou desativa a verificação ortográfica no editor. Quando a opção está ativa, <strong>aspell</strong> deve ser instalado no servidor. O segundo valor é o <strong>dicionário predefinido</strong>. Tal será usado se o aspell não tiver o dicionário da linguagem do utilizador.';
$string['edhelpfontfamily'] = 'A família da fonte é uma lista de fontes de nomes e/ou nomes genéricos de famílias. Os nomes das famílias devem ser separados por vírgulas.';
$string['edhelpfontlist'] = 'Definir as fontes usadas em editores com lista pendente.';
$string['edhelpfontsize'] = 'O tamanho da fonte predefinido define o tamanho da fonte no editor. <br />São exemplos de valores válidos:médio, grande, menor, maior, 10pt, 11px.';
$string['edit'] = 'Editar';
$string['edita'] = 'Editar {$a}';
$string['editcategorysettings'] = 'Configuração da categoria';
$string['editcategorythis'] = 'Editar esta categoria';
$string['editcoursesettings'] = 'Configurações da disciplina';
$string['editfiles'] = 'Editar ficheiros';
$string['editgroupprofile'] = 'Editar descrição do grupo';
$string['editinga'] = 'A editar {$a}';
$string['editingteachershort'] = 'Editor';
$string['editlock'] = 'Este valor não pode ser editado!';
$string['editmode'] = 'Modo de edição';
$string['editmyprofile'] = 'Editar perfil';
$string['editorbgcolor'] = 'Cor de fundo';
$string['editorcleanonpaste'] = 'Limpar Word ao colar';
$string['editorcommonsettings'] = 'Configurações comuns';
$string['editordefaultfont'] = 'Fonte predefinida';
$string['editorenablespelling'] = 'Ativar verificação ortográfica';
$string['editorfontlist'] = 'Fontlist';
$string['editorfontsize'] = 'Tamanho da fonte predefinido';
$string['editorpreferences'] = 'Preferências do editor';
$string['editorresettodefaults'] = 'Repor os valores predefinidos';
$string['editorsettings'] = 'Configurações do Editor';
$string['editorshortcutkeys'] = 'Teclas de Atalho do Editor';
$string['editsection'] = 'Editar configurações';
$string['editsectionname'] = 'Editar nome da secção';
$string['editsectionsettings'] = 'Editar configurações da secção';
$string['editsectiontitle'] = 'Editar secção: {$a}';
$string['editsettings'] = 'Editar configurações';
$string['editsummary'] = 'Editar sumário';
$string['editthisactivity'] = 'Editar esta atividade';
$string['editthiscategory'] = 'Editar esta categoria';
$string['edittitle'] = 'Editar nome';
$string['edittitleinstructions'] = '\'Enter\' para terminar, \'Esc\' para cancelar';
$string['edituser'] = 'Editar contas de utilizadores';
$string['edulevel'] = 'Todos os eventos';
$string['edulevel_help'] = '* Ensino - ações realizadas por um professor, por exemplo, atualizar um recurso
* Participação - ações realizadas por um aluno, por exemplo, publicar uma mensagem num fórum
* Outra - ações realizadas por um utilizador com um papel que não seja professor ou aluno';
$string['edulevelother'] = 'Outro';
$string['edulevelparticipating'] = 'Participar';
$string['edulevelteacher'] = 'Ensinar';
$string['email'] = 'E-mail';
$string['emailactive'] = 'E-mail ativo';
$string['emailagain'] = 'E-mail (novamente)';
$string['emailalreadysent'] = 'Já foi enviado um e-mail de reposição de senha. Por favor, verifique o seu e-mail.';
$string['emailcharset'] = 'Charset do e-mail';
$string['emailconfirm'] = 'Confirme a sua conta';
$string['emailconfirmation'] = 'Caro(a),

Foi criada uma nova conta com este endereço de e-mail na plataforma de e-learning \'{$a->sitename}\'.

Para confirmar a sua nova conta, clique em:

{$a->link}

Se o endereço acima não for apresentado como uma hiperligação em que basta clicar, copie o endereço e cole na linha de endereço do seu navegador web.

Se necessitar de ajuda, contacte o administrador do site,
{$a->admin}';
$string['emailconfirmationresend'] = 'Reenviar e-mail de confirmação';
$string['emailconfirmationsubject'] = '{$a}: Confirmação da conta';
$string['emailconfirmsent'] = '<p>Foi enviada uma mensagem para o seu endereço de e-mail <strong>{$a}</strong>, com instruções fáceis para completar a sua inscrição.</p><p>Se tiver alguma dificuldade em completar o seu registo, contacte o administrador do site.</p>';
$string['emailconfirmsentfailure'] = 'Falhou o envio do e-mail de confirmação';
$string['emailconfirmsentsuccess'] = 'E-mail de confirmação enviado com sucesso';
$string['emaildigest'] = 'Tipo de resumo de fóruns';
$string['emaildigest_help'] = 'Esta é a configuração do resumo diário que os fóruns irão usar por predefinição.

*Sem sumário: irá receber um e-mail por cada mensagem publicada no fórum;

*Completo: irá receber um e-mail diário com o conteúdo completo de cada mensagem publicada no fórum;

*Assuntos: irá receber um e-mail diário com os assuntos de cada mensagem publicada no fórum.

Poderá escolher uma configuração específica para cada fórum, se assim pretender.';
$string['emaildigestcomplete'] = 'Completo (e-mail diário com mensagens completas)';
$string['emaildigestoff'] = 'Sem sumário (um e-mail por cada mensagem submetida)';
$string['emaildigestsubjects'] = 'Assuntos (e-mail diário com assuntos das mensagens)';
$string['emaildisable'] = 'Este e-mail está desativado';
$string['emaildisableclick'] = 'Clique aqui para impedir que seja enviado e-mail para este endereço';
$string['emaildisplay'] = 'Visibilidade do e-mail';
$string['emaildisplay_help'] = '* Oculto - Apenas utilizadores com permissões apropriadas, tais como professores, podem ver o seu endereço de e-mail.
* Visível para todos - Todos os utilizadores do site podem ver o seu endereço de e-mail.
* Visível para os participantes da disciplina - Apenas os participantes das disciplinas nos quais está inscrito podem ver o seu endereço de e-mail.';
$string['emaildisplaycourse'] = 'Visível para os participantes da disciplina';
$string['emaildisplaycoursemembersonly'] = '(Visível para outros participantes da disciplina)';
$string['emaildisplayeveryone'] = '(Visível para todos)';
$string['emaildisplayhide'] = '(Oculto para todos exceto utilizadores com permissão)';
$string['emaildisplayno'] = 'Oculto';
$string['emaildisplayyes'] = 'Visível para todos';
$string['emailenable'] = 'Este e-mail está ativado';
$string['emailenableclick'] = 'Clique aqui para que todo o correio do sistema seja enviado para este endereço de e-mail';
$string['emailexists'] = 'Este e-mail já foi registado.';
$string['emailexistshintlink'] = 'Recuperar nome de utilizador ou senha';
$string['emailexistssignuphint'] = 'Talvez já tenha criado uma conta no passado? {$a}';
$string['emailformat'] = 'Formato do e-mail';
$string['emailmustbereal'] = '<b>Atenção</b>: O seu e-mail tem de ser verdadeiro';
$string['emailnotallowed'] = 'Não são permitidos endereços de e-mail nestes domínios ({$a})';
$string['emailnotfound'] = 'O e-mail não foi encontrado na base de dados';
$string['emailonlyallowed'] = 'Este e-mail não pode ser usado. Os domínios de e-mail permitidos são: {$a}.';
$string['emailpasswordchangeinfo'] = 'Caro(a) {$a->firstname},

Foi pedida uma nova senha para a sua conta \'{$a->username}\' na plataforma de e-learning \'{$a->sitename}\'.

Para mudar a sua senha, aceda a este endereço:

{$a->link}

Se o endereço acima não for apresentado como uma hiperligação em que basta clicar, copie o endereço e cole na linha de endereço do seu navegador web.

Se precisar de ajuda, contacte o administrador do site,
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Caro(a) {$a->firstname},

Foi pedida uma nova senha para a sua conta na plataforma de e-learning \'{$a->sitename}\'.

Infelizmente, a sua conta neste site está desativada logo a senha não pode ser reposta. Por favor, contacte o administrador da plataforma, {$a->admin}.';
$string['emailpasswordchangeinfofail'] = 'Caro(a) {$a->firstname},

Foi pedida uma nova senha para a sua conta na plataforma de e-learning \'{$a->sitename}\'.

Infelizmente as senhas não podem ser redefinidas neste site.

Por favor, contacte o administrador da plataforma,
{$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: Informação para alteração de senha';
$string['emailpasswordconfirmation'] = 'Caro(a) {$a->firstname},

Foi pedida uma nova senha para a sua conta na plataforma de e-learning \'{$a->sitename}\'.

Para confirmar este pedido e receber uma nova senha por e-mail, aceda a este endereço:

{$a->link}

Se o endereço acima não for apresentado como uma hiperligação em que basta clicar, copie o endereço e cole na linha de endereço do seu navegador web.

Se precisar de ajuda, contacte o administrador do site,
{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}:  Confirmação de alteração da senha';
$string['emailpasswordconfirmmaybesent'] = '<p>Se indicou um nome de utilizador correto ou um endereço de e-mail exclusivo, deverá receber um e-mail.</p>
<p>O e-mail contém as instruções para confirmar e concluir o processo de alteração da senha. Se continuar a ter dificuldades, por favor, contacte o administrador do site.</p>';
$string['emailpasswordconfirmnoemail'] = '<p>A conta de utilizador que especificou não possui um endereço de e-mail guardado.</p>
<p>Por favor, contacte o administrador do site.</p>';
$string['emailpasswordconfirmnotsent'] = '<p>O detalhe de utilizador que forneceu não identifica nenhuma conta de utilizador existente.</p>
<p>Por favor, verifique a informação que inseriu e tente novamente. Se continuar a ter dificuldade, por favor, contacte o administrador do site.</p>';
$string['emailpasswordconfirmsent'] = 'Foi enviada uma mensagem para o seu endereço de e-mail <b>{$a}</b>.
<br />Esta contém instruções para confirmar e concluir a alteração da senha.
Se continuar a ter dificuldades, contacte o administrador do site.';
$string['emailpasswordsent'] = 'Obrigado por confirmar a alteração da sua senha.
A sua nova senha foi enviada por e-mail para <br /><b>{$a->email}</b>.<br />
A nova senha foi gerada automaticamente - poderá querer <a href="{$a->link}">alterar a sua senha</a> para algo que se recorde depois com mais facilidade (mas primeiro procure a nova senha na mensagem que acabou de ser enviada).';
$string['emailresetconfirmation'] = 'Caro(a) {$a->firstname},

Foi pedida uma reposição de senha para a sua conta \'{$a->username}\' em {$a->sitename}.

Para confirmar este pedido e definir uma nova senha para a sua conta, aceda ao seguinte endereço:
<a href="{$a->link}">{$a->link}</a>

(Esta hiperligação é válida por {$a->resetminutes} minutos a partir do momento em que a reposição de senha foi pedida).

Se não fez o pedido de reposição da senha, ignore esta mensagem.

Se precisar de ajuda, por favor, contacte o administrador do site, {$a->admin}.';
$string['emailresetconfirmationsubject'] = '{$a}: Pedido de reposição de senha';
$string['emailresetconfirmsent'] = 'Foi enviado um e-mail para o seu endereço em <b>{$a}</b>.<br />Este contém instruções para confirmar e concluir a alteração da sua senha. Se precisar de ajuda, por favor, contacte o administrador do site.';
$string['emailstop'] = 'Desativar as notificações';
$string['emailtoprivatefiles'] = 'Também pode enviar ficheiros como anexos de e-mail diretamente para a sua área de ficheiros privados. Basta anexar os seus ficheiros a um e-mail e enviá-lo para {$a}.';
$string['emailtoprivatefilesdenied'] = 'O administrador desativou a possibilidade de carregar ficheiros privados.';
$string['emailvia'] = '{$a->name} (via {$a->siteshortname})';
$string['emojicategoryactivities'] = 'Atividades';
$string['emojicategoryanimalsnature'] = 'Animais & natureza';
$string['emojicategoryflags'] = 'Bandeiras';
$string['emojicategoryfooddrink'] = 'Alimentos & bebidas';
$string['emojicategoryobjects'] = 'Objetos';
$string['emojicategorypeoplebody'] = 'Pessoas & Corpo';
$string['emojicategoryrecent'] = 'Recentes';
$string['emojicategorysmileysemotion'] = 'Caras & Emoções';
$string['emojicategorysymbols'] = 'Símbolos';
$string['emojicategorytravelplaces'] = 'Viagem & locais';
$string['emptycmids'] = 'IDs dos módulo vazios da disciplina';
$string['emptydragdropregion'] = 'região vazia';
$string['emptysectionids'] = 'ID das secções vazias';
$string['enable'] = 'Ativar';
$string['encryptedcode'] = 'Código encriptado';
$string['enddate'] = 'Data de fim';
$string['enddate_help'] = 'A data de fim não restringe o acesso do aluno à disciplina. Determina se a disciplina é, ou não, listada como \'Histórico\' em \'Minhas disciplinas\'.';
$string['enddatewithtaskenabled'] = 'Data de fim da disciplina';
$string['enddatewithtaskenabled_help'] = 'A data a partir da qual a disciplina fica oculta para os alunos e deixam de poder aceder.';
$string['english'] = 'Inglês';
$string['enrolmentmethods'] = 'Métodos de inscrição';
$string['entercourse'] = 'Clique para aceder à disciplina';
$string['enteremail'] = 'Insira o seu endereço de e-mail';
$string['enteremailaddress'] = 'Introduza o seu e-mail para criar uma nova senha que lhe será enviada para esse endereço.';
$string['enterusername'] = 'Insira o seu nome de utilizador';
$string['entries'] = 'Entradas';
$string['error'] = 'Erro';
$string['errorcreatingactivity'] = 'Não é possível criar a instância da atividade \'{$a}\'';
$string['errorfiletoobig'] = 'O tamanho do ficheiro é maior do que o limite permitido ({$a} bytes)';
$string['errornouploadrepo'] = 'Não existe repositório de carregamento para este site';
$string['errorwhenconfirming'] = 'A sua conta ainda não está confirmada porque ocorreu um erro. Se clicou numa hiperligação de uma mensagem para chegar aqui, assegure-se de que não havia um parágrafo ou retorno de linha na linha da mensagem. Tem de usar a opção cortar-colar para reconstruir o endereço completo.';
$string['eventcommentcreated'] = 'Comentário criado';
$string['eventcommentdeleted'] = 'Comentário apagado';
$string['eventcommentsviewed'] = 'Comentários visualizados';
$string['eventconfiglogcreated'] = 'Criado registo de configuração';
$string['eventcontentviewed'] = 'Conteúdo visualizado';
$string['eventcoursebackupcreated'] = 'Criada cópia de segurança da disciplina';
$string['eventcoursecategorycreated'] = 'Categoria criada';
$string['eventcoursecategorydeleted'] = 'Categoria apagada';
$string['eventcoursecategoryupdated'] = 'Categoria atualizada';
$string['eventcoursecategoryviewed'] = 'Categoria visualizada';
$string['eventcoursecontentdeleted'] = 'Conteúdo da disciplina apagado';
$string['eventcoursecreated'] = 'Disciplina criada';
$string['eventcoursedeleted'] = 'Disciplina apagada';
$string['eventcourseended'] = 'Disciplina terminada';
$string['eventcourseinformationviewed'] = 'Descrição da disciplina visualizada';
$string['eventcoursemodulecreated'] = 'Módulo de disciplina criado';
$string['eventcoursemoduledeleted'] = 'Módulo de disciplina apagado';
$string['eventcoursemoduleinstancelistviewed'] = 'Lista de instâncias do módulo de disciplina visualizada';
$string['eventcoursemoduleupdated'] = 'Módulo de disciplina atualizado';
$string['eventcoursemoduleviewed'] = 'Módulo de disciplina visualizado';
$string['eventcourseresetended'] = 'Reinicialização da disciplina concluída';
$string['eventcourseresetstarted'] = 'Reinicialização da disciplina iniciada';
$string['eventcourserestored'] = 'Disciplina restaurada';
$string['eventcoursesectioncreated'] = 'Criada secção da disciplina';
$string['eventcoursesectiondeleted'] = 'Secção da disciplina apagada';
$string['eventcoursesectionupdated'] = 'Secção de disciplina atualizada';
$string['eventcoursessearched'] = 'Disciplinas pesquisadas';
$string['eventcoursestarted'] = 'Disciplina iniciada';
$string['eventcourseupdated'] = 'Disciplina atualizada';
$string['eventcourseuserreportviewed'] = 'Relatório de utilizador da disciplina visualizado';
$string['eventcourseviewed'] = 'Disciplina visualizada';
$string['eventdashboardreset'] = 'Reiniciar Painel do utilizador';
$string['eventdashboardsreset'] = 'Reiniciar Painéis dos utilizadores';
$string['eventdashboardviewed'] = 'Painel do utilizador visualizado';
$string['eventdatabasetextfieldcontentreplaced'] = 'Pesquisa e substituição global na base de dados';
$string['eventemailfailed'] = 'Falha ao enviar e-mail';
$string['eventmycoursesviewed'] = 'Minhas disciplinas visualizadas';
$string['eventname'] = 'Nome do evento';
$string['eventrecentactivityviewed'] = 'Atividade recente visualizada';
$string['eventsearchindexed'] = 'Pesquisa de dados indexados';
$string['eventsearchresultsviewed'] = 'Resultados da pesquisa visualizados';
$string['eventsectionviewed'] = 'Secção visualizada';
$string['eventunknownlogged'] = 'Evento desconhecido';
$string['eventurlblocked'] = 'O URL foi bloqueado';
$string['eventusercreated'] = 'Utilizador criado';
$string['eventuserdeleted'] = 'Utilizador apagado';
$string['eventuserfeedbackgiven'] = 'Hiperligação de feedback foi clicada';
$string['eventuserfeedbackremind'] = 'Lembrar-me depois de clicar na hiperligação de feedback';
$string['eventuserinfocategorycreated'] = 'Criada categoria de campos de perfil do utilizador';
$string['eventuserinfocategorydeleted'] = 'Apagada categoria de campos de perfil do utilizador';
$string['eventuserinfocategoryupdated'] = 'Atualizada categoria de campos de perfil do utilizador';
$string['eventuserinfofieldcreated'] = 'Criado campo de perfil do utilizador';
$string['eventuserinfofielddeleted'] = 'Apagado campo de perfil do utilizador';
$string['eventuserinfofieldupdated'] = 'Atualizado campo de perfil do utilizador';
$string['eventuserlistviewed'] = 'Lista de utilizadores visualizada';
$string['eventuserloggedout'] = 'Utilizador saiu';
$string['eventuserpasswordpolicyfailed'] = 'A senha do utilizador não cumpre a política de senhas';
$string['eventuserpasswordupdated'] = 'Senha de utilizador atualizada';
$string['eventuserprofileviewed'] = 'Perfil do utilizador visualizado';
$string['eventuserupdated'] = 'Utilizador atualizado';
$string['everybody'] = 'Todos';
$string['executeat'] = 'Horário de execução';
$string['existing'] = 'Existente';
$string['existingadmins'] = 'Administradores existentes';
$string['existingcourse'] = 'Disciplina existente';
$string['existingcourseadding'] = 'Disciplina existente, adicionando-lhe dados';
$string['existingcoursedeleting'] = 'Disciplina existente, eliminando-a primeiro';
$string['existingcreators'] = 'Possíveis criadores de disciplinas';
$string['existingstudents'] = 'Alunos inscritos';
$string['existingteachers'] = 'Professores existentes';
$string['expand'] = 'Expandir';
$string['expandall'] = 'Expandir tudo';
$string['expandcategory'] = 'Expandir {$a}';
$string['explanation'] = 'Explicação';
$string['explanationdigitalminor'] = 'Esta informação é necessária para determinar se a sua idade excede a idade mínima de consentimento. Esta é a idade em que um indivíduo pode dar o seu consentimento aos termos e condições e ao armazenamento e tratamento dos seus dados pessoais.';
$string['extendperiod'] = 'Período de extensão';
$string['extendsession'] = 'Prolongar sessão';
$string['failedloginattempts'] = '{$a->attempts} tentativas de autenticação sem sucesso desde a sua última visita';
$string['failedtaskbody'] = '<p>Olá {$a->firstname},</p>
<p>A tarefa <b>{$a->taskname}</b> falhou várias vezes e requer atenção.</p>
<p><a href="{$a->link}">Ver tarefa</a></p>';
$string['failedtaskcontexturlname'] = 'Relatório de estado';
$string['failedtasksubject'] = 'Tarefa com falha: {$a}';
$string['favourites'] = 'Com estrela';
$string['feedback'] = 'Feedback';
$string['file'] = 'Ficheiro';
$string['fileexists'] = 'Já existe um ficheiro com nome {$a}';
$string['filemissing'] = '{$a} não existe';
$string['filereaderror'] = 'Não é possível ler o ficheiro \'{$a}\'. Por favor, verifique se é realmente um ficheiro e não uma pasta.';
$string['files'] = 'Ficheiros';
$string['filesanduploads'] = 'Ficheiros e carregamentos';
$string['filesfolders'] = 'Ficheiros/pastas';
$string['fileuploadwithcontent'] = 'O carregamento de ficheiros não deve incluir o parâmetro conteúdo';
$string['filloutallfields'] = 'Por favor, preencha todos os campos do formulário';
$string['filter'] = 'Filtro';
$string['filteroption'] = '{$a->criteria}: {$a->value}';
$string['filterrowlegend'] = 'Filtro {$a}';
$string['filters'] = 'Filtros';
$string['filtersetmatchdescription'] = 'Como devem ser combinados vários filtros';
$string['filtertype'] = 'Tipo de filtro';
$string['findmorecourses'] = 'Procurar mais disciplinas...';
$string['first'] = 'Primeiro';
$string['firstaccess'] = 'Primeiro acesso';
$string['firstname'] = 'Nome';
$string['firstnamephonetic'] = 'Nome - fonético';
$string['firstpage'] = 'Primeira página';
$string['firstsiteaccess'] = 'Primeiro acesso ao site';
$string['firsttime'] = 'É a sua primeira visita aqui?';
$string['folder'] = 'Pasta';
$string['folderclosed'] = 'Pasta fechada';
$string['folderopened'] = 'Pasta aberta';
$string['followingoptional'] = 'Os campos seguintes são opcionais';
$string['followingrequired'] = 'Os campos seguintes são obrigatórios';
$string['for'] = 'Para';
$string['force'] = 'Forçar';
$string['forcelanguage'] = 'Forçar idioma';
$string['forceno'] = 'Não forçar';
$string['forcepasswordchange'] = 'Forçar mudança de senha';
$string['forcepasswordchange_help'] = 'Se ativar esta opção, o utilizador terá de alterar a sua senha na próxima vez que se autenticar.';
$string['forcepasswordchangecheckfull'] = 'Tem a certeza de que pretende forçar a mudança de senha para {$a}?';
$string['forcepasswordchangenot'] = 'Não é possível forçar a mudança de senha para {$a}';
$string['forcepasswordchangenotice'] = 'Tem de alterar a sua senha para poder continuar.';
$string['forcepasswordresetfailurenotice'] = 'A sua senha atual já não cumpre a política de senhas definida. Contacte o administrador do Moodle para obter assistência.
   {$a}';
$string['forcepasswordresetnotice'] = 'A sua senha atual já não cumpre a política de senhas definida. Tem de repor a senha para entrar novamente.
   {$a}';
$string['forcetheme'] = 'Forçar tema';
$string['forgotaccount'] = 'Recuperar senha';
$string['forgotten'] = 'Esqueceu-se do seu nome de utilizador ou da senha?';
$string['forgottenduplicate'] = 'O endereço de e-mail é partilhado por várias contas. Introduza antes o nome de utilizador';
$string['forgotteninvalidurl'] = 'URL para recuperação de senhas esquecidas';
$string['format'] = 'Formato';
$string['format_help'] = 'O formato determina a estrutura da página principal da disciplina:

* Atividade Única - A disciplina contém apenas uma atividade ou recurso.
* Social - A disciplina é centrada num fórum principal na página da disciplina. Podem ser adicionadas atividades e recursos adicionais através do bloco Atividades sociais.
* Secções personalizadas - A página da disciplina é dividida em secções personalizadas.
* Secções semanais - A página da disciplina é organizada em secções semanais, em que a primeira semana começa na data de início da disciplina.';
$string['formathtml'] = 'Formato HTML';
$string['formatmarkdown'] = 'Formato Markdown';
$string['formatplain'] = 'Formato de texto simples';
$string['formattext'] = 'Autoformatação Moodle';
$string['forumpreferences'] = 'Preferências do fórum';
$string['framesetinfo'] = 'Este documento quadro contém:';
$string['from'] = 'De';
$string['fromdate'] = 'De';
$string['fromsender'] = 'De';
$string['frontpagecategorycombo'] = 'Mostrar lista de categorias e disciplinas';
$string['frontpagecategorynames'] = 'Mostrar lista de categorias';
$string['frontpagecourselist'] = 'Mostrar lista de disciplinas';
$string['frontpagecoursesearch'] = 'Caixa \'Pesquisar disciplinas\'';
$string['frontpagedescription'] = 'Resumo da página principal';
$string['frontpagedescriptionhelp'] = 'Este resumo pode ser exibido na página principal usando o bloco Descrição da disciplina/site.';
$string['frontpageenrolledcourselist'] = 'Mostrar lista \'Minhas disciplinas\'';
$string['frontpageformat'] = 'Formato da página principal';
$string['frontpageformatloggedin'] = 'Formato da página principal, quando autenticado';
$string['frontpagenews'] = 'Anúncios';
$string['frontpagesettings'] = 'Configurações da página principal';
$string['fulllistofcourses'] = 'Todas as disciplinas';
$string['fullname'] = 'Nome completo';
$string['fullnamecourse'] = 'Nome completo da disciplina';
$string['fullnamecourse_help'] = 'O nome exibido em \'Minhas disciplinas\' e na lista de disciplinas disponíveis no Painel do utilizador.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Nome completo do utilizador';
$string['fullprofile'] = 'Perfil completo';
$string['fullsitename'] = 'Nome completo do site';
$string['functiondisabled'] = 'Esta funcionalidade encontra-se atualmente desativada';
$string['general'] = 'Geral';
$string['geolocation'] = 'latitude - longitude';
$string['gettheselogs'] = 'Obter registos';
$string['go'] = 'Executar';
$string['gpl'] = 'Copyright (C) desde 1999, Martin Dougiamas (https://moodle.com)

Este programa é software livre: pode redistribuí-lo e/ou modificá-lo sob os termos da Licença Pública Geral GNU, conforme publicada pela Free Software Foundation, tanto a versão 2 da Licença como (a seu critério) qualquer versão mais recente.

Este programa é distribuído com a espetativa de que seja útil, mas SEM QUALQUER GARANTIA; nem mesmo a garantia implícita de COMERCIALIZAÇÃO ou de ADEQUAÇÃO A QUALQUER PROPÓSITO ESPECÍFICO.

Para mais informação, consulte a página da Licença do Moodle: https://moodledev.io/general/license';
$string['gpl3'] = 'Copyright (C) desde 1999, Martin Dougiamas (https://moodle.com)

Este programa é software livre: pode redistribuí-lo e/ou modificá-lo sob os termos da Licença Pública Geral GNU, conforme publicada pela Free Software Foundation, tanto a versão 3 da Licença como (a seu critério) qualquer versão mais recente.

Este programa é distribuído com a expectativa de que seja útil, mas SEM QUALQUER GARANTIA, nem mesmo a garantia implícita de COMERCIALIZAÇÃO ou de ADEQUAÇÃO A QUALQUER PROPÓSITO ESPECÍFICO.

Para mais informação, consulte a página da Licença do Moodle: https://moodledev.io/general/license';
$string['gpllicense'] = 'licença GPL';
$string['gradenoun'] = 'Avaliação';
$string['grades'] = 'Pauta';
$string['gradeverb'] = 'Avaliação';
$string['gravatarenabled'] = '<a href="https://www.gravatar.com/">Gravatar</a> está ativo neste site. Se não carregar nenhuma foto para o perfil, o Moodle irá tentar obter uma a partir do Gravatar.';
$string['group'] = 'Grupo';
$string['groupadd'] = 'Adicione novo grupo';
$string['groupaddusers'] = 'Adicione selecionados ao grupo';
$string['groupfor'] = 'para o grupo';
$string['groupinfo'] = 'Informação sobre grupo selecionado';
$string['groupinfoedit'] = 'Editar configurações de grupo';
$string['groupinfomembers'] = 'Informação sobre utilizadores selecionados';
$string['groupinfopeople'] = 'Informação sobre pessoas selecionadas';
$string['groupmembers'] = 'Membros do grupo';
$string['groupmemberssee'] = 'Mostrar membros do grupo';
$string['groupmembersselected'] = 'Membros do grupo selecionado';
$string['groupmode'] = 'Modo de grupo';
$string['groupmodeforce'] = 'Forçar modo de grupo';
$string['groupmy'] = 'O meu grupo';
$string['groupnonmembers'] = 'Pessoas em nenhum grupo';
$string['groupnotamember'] = 'Lamentamos mas não é membro deste grupo.';
$string['grouprandomassign'] = 'Distribuir aleatoriamente todos em grupos';
$string['groupremove'] = 'Apagar grupos selecionados';
$string['groupremovemembers'] = 'Apagar membros selecionados';
$string['groups'] = 'Grupos';
$string['groupsnone'] = 'Nenhum grupo';
$string['groupsseparate'] = 'Grupos separados';
$string['groupsvisible'] = 'Grupos visíveis';
$string['guest'] = 'Visitante';
$string['guestdescription'] = 'Os visitantes têm privilégios mínimos e geralmente não podem escrever em nenhuma parte.';
$string['guestskey'] = 'Permitir acesso a visitantes que saibam a senha';
$string['guestsno'] = 'Não admitir visitantes';
$string['guestsnotallowed'] = 'Lamentamos mas \'{$a}\' não permite acesso a visitantes.';
$string['guestsyes'] = 'Permitir acesso a visitantes sem senha';
$string['guestuser'] = 'Visitante';
$string['guestuserinfo'] = 'Este nome de utilizador é especial e só permite acesso a algumas disciplinas.';
$string['help'] = 'Ajuda';
$string['helpprefix2'] = 'Ajuda sobre {$a}';
$string['helpwiththis'] = 'Ajuda';
$string['hiddenassign'] = 'Atribuição oculta';
$string['hiddenfromstudents'] = 'Oculto para os alunos';
$string['hiddenoncoursepage'] = 'Disponível mas não mostrar na página da disciplina';
$string['hiddensections'] = 'Secções ocultas';
$string['hiddensections_help'] = 'As secções ocultas são mostradas aos alunos como \'não disponíveis\' na página da disciplina ou mantidas completamente ocultas.';
$string['hiddensectionscollapsed'] = 'Secções ocultas são apresentadas como não disponíveis';
$string['hiddensectionsinvisible'] = 'Secções ocultas estão completamente invisíveis';
$string['hiddenwithbrackets'] = '(oculto)';
$string['hide'] = 'Ocultar';
$string['hideadvancedsettings'] = 'Ocultar configurações avançadas';
$string['hidechartdata'] = 'Ocultar dados do gráfico';
$string['hidefromstudents'] = 'Oculto para os alunos';
$string['hideoncoursepage'] = 'Disponível mas oculto na página da disciplina';
$string['hidepopoverwindow'] = 'Ocultar a janela de informação após clicar';
$string['hidesection'] = 'Ocultar secção {$a}';
$string['hidesettings'] = 'Ocultar opções';
$string['hideshowblocks'] = 'Ocultar ou mostrar blocos';
$string['highlight'] = 'Destacar';
$string['highlighted'] = 'Destacado';
$string['highlightoff'] = 'Remover destaque';
$string['hits'] = 'Número de acessos';
$string['hitsoncourse'] = 'Número de acessos do utilizador {$a->username} a {$a->coursename}';
$string['hitsoncoursetoday'] = 'N.º de acessos de hoje do utilizador {$a->username} a {$a->coursename}';
$string['home'] = 'Página principal';
$string['homeheader'] = 'Menu inicial';
$string['hour'] = 'hora';
$string['hours'] = 'horas';
$string['howtomakethemes'] = 'Como criar temas novos';
$string['htmleditor'] = 'Usar o editor HTML';
$string['htmleditoravailable'] = 'O editor HTML está disponível';
$string['htmleditordisabled'] = 'O editor HTML foi desativado no seu perfil do utilizador';
$string['htmleditordisabledadmin'] = 'O administrador desativou o editor HTML neste site';
$string['htmleditordisabledbrowser'] = 'O editor HTML não está disponível por não ser compatível com o seu navegador web.';
$string['htmlfilesonly'] = 'Só ficheiros HTML';
$string['htmlformat'] = 'Formato HTML';
$string['icon'] = 'Ícone';
$string['idnumber'] = 'Número de identificação (ID)';
$string['idnumbercourse'] = 'Código da disciplina';
$string['idnumbercourse_help'] = 'Usado apenas para ligar a disciplina com sistemas externos. Deixe em branco se não tiver um ID da disciplina oficial.';
$string['idnumbercoursecategory'] = 'Número de identificação (ID) da categoria';
$string['idnumbercoursecategory_help'] = 'O número de identificação (ID) de uma categoria é usado apenas para comunicação com sistemas externos e não é exibido em nenhuma parte do site. Se a categoria tem um código do nome oficial, este pode ser inserido, caso contrário, o campo pode ficar em branco.';
$string['idnumbergroup'] = 'Número de identificação (ID) do grupo';
$string['idnumbergroup_help'] = 'O número de identificação (ID) de um grupo é usado apenas para comunicação com sistemas externos e não é exibido em nenhum lugar do site. Se o grupo tem um código do nome oficial, este pode ser inserido, caso contrário, o campo pode ficar em branco.';
$string['idnumbergrouping'] = 'Número de identificação (ID) do agrupamento';
$string['idnumbergrouping_help'] = 'O número de identificação (ID) de um agrupamento é usado apenas para comunicação com sistemas externos e não é exibido em nenhuma parte do site. Se o agrupamento tem um código do nome oficial, este pode ser inserido, caso contrário, o campo pode ficar em branco.';
$string['idnumbermod'] = 'Número de identificação (ID)';
$string['idnumbermod_help'] = 'Definir um número de identificação (ID) é uma forma de identificar a atividade ou o recurso para fins de cálculo de notas ou relatórios personalizados. Se não for o caso, o campo pode ficar em branco.

Para atividades a serem avaliadas, o número de identificação (ID) também pode ser definido ao configurar a pauta, no entanto, só pode ser editado na página de configurações da atividade.';
$string['idnumbertaken'] = 'Este número de identificação (ID) já está a ser usado';
$string['imagealt'] = 'Descrição da imagem';
$string['import'] = 'Importar';
$string['importdata'] = 'Importar dados de disciplina';
$string['importdataexported'] = 'Dados da disciplina de origem exportados com sucesso.<br /> Continuar a importação para a sua disciplina de destino.';
$string['importdatafinished'] = 'Importação concluída! Siga para a sua disciplina.';
$string['importdatafrom'] = 'Selecione a disciplina de onde pretende importar os dados:';
$string['importinfo'] = 'Importar itens de outras disciplinas, tais como: atividades, blocos ou eventos do calendário. Nenhum dado dos utilizadores será importado.';
$string['inactive'] = 'Inativo';
$string['include'] = 'Incluir';
$string['includeallusers'] = 'Incluir todos os utilizadores';
$string['includecoursefiles'] = 'Incluir ficheiros da disciplina';
$string['includecourseusers'] = 'Incluir utilizadores da disciplina';
$string['included'] = 'Incluídos';
$string['includelogentries'] = 'Incluir entradas de registo';
$string['includemodules'] = 'Incluir Módulos';
$string['includemoduleuserdata'] = 'Incluir dados de utilizador do módulo';
$string['includeneededusers'] = 'Incluir utilizadores necessários';
$string['includenoneusers'] = 'Não incluir utilizadores';
$string['includeroleassignments'] = 'Incluir papéis atribuídos';
$string['includesitefiles'] = 'Incluir ficheiros do site usados nesta disciplina';
$string['includesubcategories'] = 'Incluir subcategorias';
$string['includeuserfiles'] = 'Incluir ficheiros do utilizador';
$string['increasesections'] = 'Aumentar o número de secções';
$string['indicator:accessesafterend'] = 'Disciplina acedida após a data de fim';
$string['indicator:accessesafterend_help'] = 'Este indicador mostra se o aluno acedeu à disciplina depois da sua data de fim.';
$string['indicator:accessesbeforestart'] = 'Disciplina acedida antes da data de início';
$string['indicator:accessesbeforestart_help'] = 'Este indicador mostra se o aluno acedeu à disciplina antes da sua data de início.';
$string['indicator:activitiesdue'] = 'Atividades com data limite próxima';
$string['indicator:activitiesdue_help'] = 'O utilizador tem atividades com data limite próxima';
$string['indicator:anycourseaccess'] = 'Qualquer acesso';
$string['indicator:anycourseaccess_help'] = 'Este indicador reflete todos os acessos a qualquer disciplina em que o utilizador está inscrito.';
$string['indicator:anywrite'] = 'Qualquer ação de escrita';
$string['indicator:anywrite_help'] = 'Este indicador mostra qualquer ação de escrita (submissão) efetuada pelo aluno.';
$string['indicator:anywriteincourse'] = 'Qualquer ação de escrita na disciplina';
$string['indicator:anywriteincourse_help'] = 'Este indicador mostra qualquer ação de escrita (submissão) efetuada pelo aluno em qualquer atividade da disciplina.';
$string['indicator:completeduserprofile'] = 'O perfil do utilizador está completo';
$string['indicator:completeduserprofile_help'] = 'Este indicador mostra que o aluno completou seu perfil do utilizador.';
$string['indicator:completeduserprofiledef'] = 'O perfil do utilizador está completo';
$string['indicator:completeduserprofiledef_help'] = 'As políticas do site foram aceites e o utilizadoro preencheu os seguintes campos: Instituição, Departamento, Endereço, Cidade, País, URL.';
$string['indicator:completionenabled'] = 'Verificação da conclusão ativada';
$string['indicator:completionenabled_help'] = 'Este indicador mostra que a verificação da conclusão está ativa para esta disciplina.';
$string['indicator:nostudent'] = 'Inscrições de alunos';
$string['indicator:nostudent_help'] = 'Este indicador reflete a existência de alunos na disciplina.';
$string['indicator:noteacher'] = 'Disponibilidade de professor';
$string['indicator:noteacher_help'] = 'Este indicador reflete a existência de professor na disciplina.';
$string['indicator:potentialcognitive'] = 'Potencial da capacidade cognitiva da disciplina';
$string['indicator:potentialcognitive_help'] = 'Este indicador baseia-se na potencial capacidade cognitiva que pode ser alcançada por um aluno participando das atividades da disciplina.';
$string['indicator:potentialcognitivedef'] = 'Potencial da capacidade cognitiva da disciplina';
$string['indicator:potentialcognitivedef_help'] = 'O grau para o qual a disciplina oferece um envolvimento cognitivo "profundo". Por exemplo, envio de trabalho para feedback, a oportunidade de rever o trabalho de outras pessoas e a oportunidade de rever e reenviar o trabalho.';
$string['indicator:potentialcognitivedef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:potentialsocial'] = 'Potencial extensão social da disciplina';
$string['indicator:potentialsocial_help'] = 'Este indicador baseia-se na potencial extensão social que pode ser alcançada pelo aluno que participa nas atividades da disciplina.';
$string['indicator:potentialsocialdef'] = 'Potencial da extensão social da disciplina';
$string['indicator:potentialsocialdef_help'] = 'O grau para o qual a disciplina oferece um envolvimento social "amplo", interagindo com outros participantes e com a comunidade de prática fora da sala de aula.';
$string['indicator:potentialsocialdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indicator:readactions'] = 'Número de ações de leitura';
$string['indicator:readactions_help'] = 'Este indicador mostra o número de ações de leitura (visualização) feitas pelo aluno.';
$string['indicator:userforumstracking'] = 'O utilizador está subscrito em fóruns';
$string['indicator:userforumstracking_help'] = 'Este indicador mostra se o aluno tem ou não o rastreio ativo nos fóruns.';
$string['info'] = 'Informação';
$string['inprogress'] = 'A decorrer';
$string['insertresourceoractivitybefore'] = 'Inserir uma atividade ou recurso antes de \'{$a->activityname}\'';
$string['institution'] = 'Instituição';
$string['instudentview'] = 'em modo de visão do aluno';
$string['interests'] = 'Interesses';
$string['interestslist'] = 'Lista de interesses';
$string['interestslist_help'] = 'Insira os seus interesses, um por um, e que serão mostrados na página do seu perfil como palavras-chave.';
$string['invalidemail'] = 'Endereço de e-mail inválido';
$string['invalidlogin'] = 'Dados de acesso inválidos. Por favor, tente novamente.';
$string['invalidtaskclassname'] = 'Classe de tarefa inválida {$a}';
$string['invalidtaskid'] = 'ID de tarefa inválido';
$string['invalidusername'] = 'O nome de utilizador apenas pode conter caracteres alfanuméricos em minúsculas (letras e números), underscore (_), hífen (-), ponto final (.) ou o símbolo arroba (@).';
$string['invalidusernameupload'] = 'Nome de utilizador inválido';
$string['ip_address'] = 'Endereço IP';
$string['jump'] = 'Saltar';
$string['jumpto'] = 'Ir para...';
$string['keep'] = 'Manter';
$string['labelvalue'] = '{$a->label}: {$a->value}';
$string['langltr'] = 'Direção do texto do idioma da esquerda para a direita';
$string['langrtl'] = 'Direção do texto do idioma da direita para a esquerda';
$string['language'] = 'Idioma';
$string['languagegood'] = 'Este pacote linguístico está atualizado.';
$string['languageselector'] = 'Seletor de idioma';
$string['last'] = 'Último';
$string['lastaccess'] = 'Último acesso';
$string['lastcourseaccess'] = 'Último acesso';
$string['lastedited'] = 'Última edição';
$string['lastip'] = 'Último endereço IP';
$string['lastlogin'] = 'Última autenticação';
$string['lastmodified'] = 'Última alteração';
$string['lastname'] = 'Apelido';
$string['lastnamephonetic'] = 'Apelido - fonético';
$string['lastpage'] = 'Última página';
$string['lastsiteaccess'] = 'Último acesso ao site';
$string['lastyear'] = 'Ano passado';
$string['latestlanguagepack'] = 'Verificar o pacote linguístico mais recente em moodle.org';
$string['layouttable'] = 'Tabela de esquema';
$string['leavetokeep'] = 'Deixe em branco para manter a senha atual';
$string['legacylogginginuse'] = 'Atualmente o site está a utilizar o sistema de registos de retrocompatibilidade. Este sistema foi descontinuado. Deve utilizar um sistema de registo suportado, como por exemplo, "Registo de atividade padrão" ou "Base de dados externa para registos de atividade".';
$string['legacythemeinuse'] = 'Este site está a ser mostrado em modo de compatibilidade porque está a usar numa versão muito antiga do seu navegador.';
$string['license'] = 'Licença';
$string['licenses'] = 'Licenças';
$string['liketologin'] = 'Pretende aceder ao sistema com uma conta de utilizador?';
$string['list'] = 'Lista';
$string['listfiles'] = 'Lista de ficheiros em {$a}';
$string['listofallpeople'] = 'Lista de todas as pessoas';
$string['listofcourses'] = 'Lista de disciplinas';
$string['loading'] = 'A carregar';
$string['loadinghelp'] = 'A carregar…';
$string['local'] = 'Local';
$string['localplugins'] = 'Módulos locais';
$string['localpluginsmanage'] = 'Gerir módulos';
$string['location'] = 'Localização';
$string['locktimeout'] = 'A operação excedeu o tempo de execução enquanto aguardava por um bloqueio.';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = 'Nome de utilizador: {$a}';
$string['loggedinasguest'] = 'A aceder como visitante';
$string['loggedinnot'] = 'Utilizador não autenticado';
$string['login'] = 'Entrar';
$string['login_failure_logs'] = 'Relatórios de tentativas de autenticação sem sucesso';
$string['loginactivity'] = 'Atividade de autenticação';
$string['loginagain'] = 'Autenticar-se novamente';
$string['loginalready'] = 'Já está autenticado como';
$string['loginas'] = 'Entrar como';
$string['loginaspasswordexplain'] = '<p>Para poder utilizar esta opção terá que inserir a senha especial para "Entrar como".<br />Se não souber essa senha, contacte o  administrador do servidor.</p>';
$string['loginguest'] = 'Aceder como visitante';
$string['loginsite'] = 'Entrar no site';
$string['loginsteps'] = 'Para ter acesso completo a este site, primeiro tem de criar uma conta de utilizador.';
$string['loginstepsnone'] = '<p>Viva!</p>
<p>Para ter acesso total às disciplinas, tem de criar a sua própria conta de utilizador.</p>
<p>Só precisa de escolher um nome de utilizador e uma senha e usá-los no formulário desta página!</p>
<p>Se o nome de utilizador pretendido já foi escolhido por alguém, deverá tentar com um nome diferente.</p>';
$string['loginto'] = 'Entrar em {$a}';
$string['logoof'] = 'Logótipo de {$a}';
$string['logout'] = 'Sair';
$string['logoutconfirm'] = 'Tem a certeza de que pretende sair?';
$string['logs'] = 'Registos de atividade';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">mais</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">mais</a> ]';
$string['lookback'] = 'Desde há';
$string['mailadmins'] = 'Informar os administradores';
$string['mailstudents'] = 'Informar os alunos';
$string['mailteachers'] = 'Informar os professores';
$string['maincoursepage'] = 'Página principal da disciplina';
$string['makeafolder'] = 'Criar pasta';
$string['makeavailable'] = 'Tornar disponível';
$string['makeavailablecmtitle'] = 'Tornar atividade disponível';
$string['makeeditable'] = 'Se mudar as permissões de \'{$a}\' para que o servidor de http (por exemplo, Apache) possa modificá-lo, este ficheiro poderá ser editado diretamente nesta página';
$string['makethismyhome'] = 'Tornar na minha página principal';
$string['makeunavailable'] = 'Tornar indisponível';
$string['manageblocks'] = 'Blocos';
$string['managecategories'] = 'Gerir categorias de disciplinas';
$string['managecategorythis'] = 'Gerir esta categoria';
$string['managecombined'] = 'Gerir disciplinas e categorias de disciplinas';
$string['managecontentbanktypes'] = 'Gerir tipos de conteúdos';
$string['managecourses'] = 'Gerir disciplinas';
$string['managedatabase'] = 'Gestão da base de dados';
$string['managedataformats'] = 'Gerir formatos de dados';
$string['manageeditorfiles'] = 'Gerir ficheiros usados pelo editor';
$string['managefilters'] = 'Filtros';
$string['managemodules'] = 'Módulos';
$string['manageroles'] = 'Papéis e permissões';
$string['markallread'] = 'Marcar todas como lidas';
$string['markedthistopic'] = 'Esta secção está marcada como a secção atual';
$string['markthistopic'] = 'Marcar esta secção como a secção atual';
$string['match'] = 'Corresponde a';
$string['matchingsearchandrole'] = 'Corresponder \'{$a->search}\' e {$a->role}';
$string['matchofthefollowing'] = 'dos seguintes:';
$string['maxareabytesreached'] = 'A imagem (ou o tamanho total de vários ficheiros) é maior do que o espaço restante nesta área.';
$string['maxfilesize'] = 'Tamanho máximo para novos ficheiros: {$a}';
$string['maxfilesreached'] = 'Tem permissão para anexar um máximo de {$a} ficheiro (s) para este item';
$string['maximumchars'] = 'Máximo de {$a} caracteres';
$string['maximumgrade'] = 'Nota máxima';
$string['maximumgradex'] = 'Nota máxima: {$a}';
$string['maximumshort'] = 'Máx';
$string['maximumupload'] = 'Tamanho máximo dos ficheiros enviados';
$string['maximumupload_help'] = 'O tamanho máximo dos ficheiros que podem ser carregados para a disciplina. Além disso, pode depois restringir o tamanho máximo dos ficheiros em cada atividade.';
$string['maxnumberweeks'] = 'Número máximo de secções';
$string['maxnumberweeks_desc'] = 'Valor máximo disponível na lista pendente \'Número de Semanas/Tópicos\' nas configurações da disciplina (aplica-se apenas a certos formatos de disciplina).';
$string['maxnumcoursesincombo'] = 'Procurar <a href="{$a->link}">{$a->numberofcourses} disciplinas</a>.';
$string['maxsectionslimit'] = 'Não é possível criar uma nova secção, pois iria exceder o número máximo de secções permitidas para esta disciplina ({$a}).';
$string['maxsize'] = 'Tamanho máximo: {$a}';
$string['maxsizeandareasize'] = 'Tamanho máximo para novos ficheiros: {$a->size}, limite global: {$a->areasize}';
$string['maxsizeandattachments'] = 'Tamanho máximo do ficheiro: {$a->size}, número máximo de ficheiros: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Tamanho máximo do ficheiro: {$a->size}, número máximo de ficheiros: {$a->attachments}, tamanho máximo total: {$a->areasize}';
$string['memberincourse'] = 'Participantes na disciplina';
$string['menu'] = 'Menu';
$string['message'] = 'Mensagem';
$string['messagebody'] = 'Conteúdo da mensagem';
$string['messagedselectedusers'] = 'A mensagem foi enviada para os utilizadores selecionados e a lista de destinatários foi reiniciada.';
$string['messagedselectedusersfailed'] = 'Ocorreu um erro no envio da mensagem para os utilizadores selecionados. Alguns deles poderão ter recebido a mensagem.';
$string['messageprovider:asyncbackupnotification'] = 'Notificações da cópia de segurança/restauros assíncronos';
$string['messageprovider:availableupdate'] = 'Notificação de atualizações disponíveis';
$string['messageprovider:backup'] = 'Notificações da cópia de segurança';
$string['messageprovider:badgecreatornotice'] = 'Notificações do emissor da medalha';
$string['messageprovider:badgerecipientnotice'] = 'Notificações ao condecorado com a medalha';
$string['messageprovider:competencyplancomment'] = 'Comentário publicado num plano de aprendizagem';
$string['messageprovider:competencyusercompcomment'] = 'Comentário publicado numa competência';
$string['messageprovider:coursecompleted'] = 'Disciplina concluída';
$string['messageprovider:coursecontentupdated'] = 'Alterações no conteúdo da disciplina';
$string['messageprovider:courserequestapproved'] = 'Notificação de aprovação do pedido de disciplina';
$string['messageprovider:courserequested'] = 'Notificação do pedido de disciplina';
$string['messageprovider:courserequestrejected'] = 'Notificação de rejeição do pedido de disciplina';
$string['messageprovider:enrolcoursewelcomemessage'] = 'Mensagem de boas-vindas para novas inscrições nas disciplinas';
$string['messageprovider:errors'] = 'Erros importantes no site';
$string['messageprovider:errors_help'] = 'Estes são alguns erros importantes que o administrador deve conhecer';
$string['messageprovider:failedtaskmaxdelay'] = 'Atraso para a tarefa atingir o máximo de falha';
$string['messageprovider:gradenotifications'] = 'Notificações da avaliação';
$string['messageprovider:infected'] = 'Notificações de falha do antivírus';
$string['messageprovider:insights'] = 'Perceções geradas por modelos de previsão';
$string['messageprovider:instantmessage'] = 'Mensagens pessoais entre utilizadores';
$string['messageprovider:instantmessage_help'] = 'Esta secção define as mensagens enviadas diretamente de uns utilizadores para outros através do site';
$string['messageprovider:messagecontactrequests'] = 'Mensagem de notificação das solicitações de contacto';
$string['messageprovider:newlogin'] = 'Notificações de novas autenticações';
$string['messageprovider:notices'] = 'Avisos sobre problemas menores';
$string['messageprovider:notices_help'] = 'Estes são avisos que o administrador pode estar interessado em ver.';
$string['messageprovider:reportbuilderschedule'] = 'Agendamentos do criador de relatórios personalizados';
$string['messageselect'] = 'Selecionar este aluno como destinatário de uma mensagem';
$string['messageselectadd'] = 'Enviar mensagem';
$string['middlename'] = 'Nome do meio';
$string['migratinggrades'] = 'Migração de notas';
$string['min'] = 'minuto';
$string['mins'] = 'minutos';
$string['minute'] = 'minuto';
$string['minutes'] = 'minutos';
$string['miscellaneous'] = 'Diversos';
$string['missingcategory'] = 'Tem de escolher uma categoria';
$string['missingdescription'] = 'Falta a descrição';
$string['missingemail'] = 'Falta o endereço de e-mail';
$string['missingfirstname'] = 'Falta o nome';
$string['missingfromdisk'] = 'Em falta no disco';
$string['missingfullname'] = 'Falta o nome completo';
$string['missinglastname'] = 'Falta o apelido';
$string['missingname'] = 'Falta o nome completo';
$string['missingnewpassword'] = 'Falta a nova senha';
$string['missingpassword'] = 'Falta a senha';
$string['missingrecaptchachallengefield'] = 'Falha no reCAPTCHA. Tente novamente.';
$string['missingreqreason'] = 'Falta a justificação';
$string['missingshortname'] = 'Falta o nome curto';
$string['missingshortsitename'] = 'Falta o nome curto do site';
$string['missingsitedescription'] = 'Falta a descrição do site';
$string['missingsitename'] = 'Falta o nome do site';
$string['missingstrings'] = 'Detetar variáveis que faltam';
$string['missingstudent'] = 'Tem de escolher algo';
$string['missingsummary'] = 'Falta o sumário';
$string['missingteacher'] = 'Tem de escolher algo';
$string['missingurl'] = 'Falta o URL';
$string['missingusername'] = 'Falta o nome de utilizador';
$string['moddoesnotsupporttype'] = 'A atividade {$a->modname} não suporta carregamentos do tipo {$a->type}';
$string['modhide'] = 'Ocultar';
$string['modified'] = 'Modificado';
$string['modshow'] = 'Mostrar';
$string['modshowcmtitle'] = 'Mostrar atividade';
$string['moduleintro'] = 'Descrição';
$string['modulesetup'] = 'Ajustando as tabelas de módulos';
$string['modulesuccess'] = 'As tabelas de {$a} foram configuradas corretamente';
$string['modulesused'] = 'Módulos utilizados';
$string['modvisible'] = 'Disponibilidade';
$string['modvisible_help'] = '* Mostrar na página da disciplina: Disponível para os alunos (sujeito a restrições de acesso que possam ser definidas).
* Oculto para os alunos: Não disponível para os alunos.';
$string['modvisiblehiddensection'] = 'Disponibilidade';
$string['modvisiblehiddensection_help'] = '* Oculto para os alunos: Não disponível para os alunos.
* Disponível mas oculto na página da disciplina: Disponível para os alunos se for fornecida uma hiperligação. As atividades continuarão a aparecer na pauta e em outros relatórios.';
$string['modvisiblewithstealth'] = 'Disponibilidade';
$string['modvisiblewithstealth_help'] = '* Mostrar na página da disciplina: Disponível para os alunos (sujeito a restrições de acesso que possam ser definidas).
* Oculto para os alunos: Não disponível para os alunos.
* Disponível mas oculto na página da disciplina: Disponível para os alunos se for fornecida uma hiperligação. As atividades continuarão a aparecer na pauta e em outros relatórios.';
$string['month'] = 'Mês';
$string['months'] = 'Meses';
$string['moodledocs'] = 'Documentação do Moodle';
$string['moodledocslink'] = 'Documentação para esta página';
$string['moodlelogo'] = 'Logótipo Moodle';
$string['moodlenet:cannotconnecttoserver'] = 'Não é possível ligar ao servidor MoodleNet';
$string['moodlenet:columnname'] = 'Nome';
$string['moodlenet:columnsenddate'] = 'Data de envio';
$string['moodlenet:columnsendstatus'] = 'Estado';
$string['moodlenet:columntype'] = 'Tipo';
$string['moodlenet:configoauthservice'] = 'Selecione um serviço MoodleNet OAuth 2 para permitir a partilha no MoodleNet. Se o serviço ainda não existir, tem de <a href="{$a}">criá-lo</a>.';
$string['moodlenet:deletedactivity'] = 'Atividade apagada';
$string['moodlenet:deletedcourse'] = 'Disciplina apagada';
$string['moodlenet:eventresourceexported'] = 'Recurso exportado';
$string['moodlenet:gotomoodlenet'] = 'Ir para rascunhos do MoodleNet';
$string['moodlenet:issuerisnotauthorized'] = 'O emissor MoodleNet não está autorizado';
$string['moodlenet:issuerisnotenabled'] = 'O emissor do MoodleNet não está ativado';
$string['moodlenet:issuerisnotset'] = 'O emissor MoodleNet ainda não está definido na Administração do Site';
$string['moodlenet:nosharedresources'] = 'De momento, não existem recursos partilhados para exibir.';
$string['moodlenet:outboundsettings'] = 'Configurações da saída do MoodleNet';
$string['moodlenet:packagingandsending'] = 'A preparar o seu ficheiro e a enviar para o MoodleNet...';
$string['moodlenet:sharefailtext'] = 'Ocorreu um erro ao partilhar o seu conteúdo no MoodleNet.<br>Tente novamente mais tarde.';
$string['moodlenet:sharefailtextwithsitesupport'] = 'Ocorreu um erro ao partilhar o seu conteúdo no MoodleNet.<br>Tente novamente mais tarde ou <a href="{$a}">contacte o suporte do site</a>.';
$string['moodlenet:sharefailtitle'] = 'Ocorreu um erro';
$string['moodlenet:sharefilesizelimitexceeded'] = 'O tamanho do recurso que está a ser partilhado ({$a->file size} bytes) excede o limite de {$a->filesizelimitbytes.';
$string['moodlenet:sharenoticeactivity'] = 'Esta atividade está a ser partilhada no MoodleNet como recurso.';
$string['moodlenet:sharenoticecourse'] = 'Esta disciplina está a ser partilhada no MoodleNet como recurso.';
$string['moodlenet:sharenoticepartial'] = 'As atividades selecionadas estão a ser partilhadas no MoodleNet como recursos.';
$string['moodlenet:sharenoticepartialactivitynumber'] = '{$a} atividades serão incluídas na disciplina.';
$string['moodlenet:shareprogress'] = 'Progresso da partilha no MoodleNet';
$string['moodlenet:shareprogressinfo'] = 'A lista mostra disciplinas e atividades que partilhou no MoodleNet.<br>Clique no nome do recurso para visualizar no MoodleNet.';
$string['moodlenet:sharesuccesstext'] = 'Quase completo! Visite os seus rascunhos no MoodleNet para concluir a partilha do seu conteúdo.';
$string['moodlenet:sharesuccesstitle'] = 'Guardado rascunhos do MoodleNet';
$string['moodlenet:sharetomoodlenet'] = 'Partilhar no MoodleNet';
$string['moodlenet:sharetyperesource'] = 'recurso';
$string['moodlenet:sharinglargefile'] = 'Os ficheiros grandes podem demorar algum tempo.';
$string['moodlenet:sharingstatus'] = 'A partilhar no MoodleNet';
$string['moodlenet:sharingto'] = 'A partilhar em:';
$string['moodlerelease'] = 'Versão do Moodle';
$string['moodleservicesandsupport'] = 'Serviços e suporte';
$string['moodleversion'] = 'Versão do Moodle';
$string['more'] = 'mais';
$string['moreactions'] = 'Mais ações';
$string['morehelp'] = 'Mais ajuda';
$string['morehelpaboutmodule'] = 'Mais ajuda sobre a atividade {$a}';
$string['moreinfo'] = 'Mais informação';
$string['moreinformation'] = 'Mais informações sobre este erro';
$string['moremenu'] = 'Mais';
$string['morenavigationlinks'] = 'Mais...';
$string['moreprofileinfoneeded'] = 'Conte-nos mais coisas sobre si';
$string['mostrecently'] = 'mais recentemente';
$string['move'] = 'Mover';
$string['movecategoriessuccess'] = 'Foram movidas com sucesso {$a->count} categorias para a categoria \'{$a->to}\'';
$string['movecategoriestotopsuccess'] = 'Foram movidas com sucesso {$a->count} categorias para o nível de topo';
$string['movecategorycontentto'] = 'Mover para';
$string['movecategorysuccess'] = 'Foi movida com sucesso a categoria \'{$a->moved}\' para a categoria \'{$a->to}\'';
$string['movecategoryto'] = 'Mover a categoria para:';
$string['movecategorytotopsuccess'] = 'Foi movida com sucesso a categoria \'{$a->moved}\' para o nível de topo';
$string['movecontent'] = 'Mover \'{$a}\'';
$string['movecontentafter'] = 'Depois de "{$a}"';
$string['movecontentstoanothercategory'] = 'Mover conteúdo para outra categoria';
$string['movecontenttothetop'] = 'Para o topo da lista';
$string['movecoursemodule'] = 'Mover atividade';
$string['movecoursesection'] = 'Mover secção';
$string['movecourseto'] = 'Mover disciplina para:';
$string['movedown'] = 'Mover para baixo';
$string['movefilestohere'] = 'Mover os ficheiros para este local';
$string['movefull'] = 'Mover {$a} para este local';
$string['movehere'] = 'Mover para aqui';
$string['moveleft'] = 'Mover para a esquerda';
$string['moveright'] = 'Mover para a direita';
$string['movesection'] = 'Mover secção {$a}';
$string['moveselectedcategoriesto'] = 'Mover as categorias selecionadas para...';
$string['moveselectedcoursesto'] = 'Mover as disciplinas selecionadas para...';
$string['movetoanotherfolder'] = 'Mover para outra pasta';
$string['moveup'] = 'Mover para cima';
$string['mustchangepassword'] = 'A nova senha deverá ser diferente da atual';
$string['mustconfirm'] = 'Precisa confirmar a sua conta';
$string['mycourses'] = 'Minhas disciplinas';
$string['myfiles'] = 'Meus ficheiros privados';
$string['myfilesmanage'] = 'Gerir os meus ficheiros privados';
$string['myhome'] = 'Painel do utilizador';
$string['mymoodledashboard'] = 'Meu Painel do utilizador Moodle';
$string['myprofile'] = 'Meu perfil';
$string['name'] = 'Designação';
$string['namedfiletoolarge'] = 'O ficheiro \'{$a->filename}\' é muito grande e não pode ser carregado';
$string['nameforlink'] = 'Qual o nome que pretende dar a esta hiperligação?';
$string['nameforpage'] = 'Nome';
$string['navigation'] = 'Navegação';
$string['needed'] = 'Necessários';
$string['networkdropped'] = 'A sua ligação à Internet está instável ou foi interrompida.<br />
Por favor, tenha em atenção que as alterações podem não ser guardadas corretamente até que a sua ligação melhore.';
$string['never'] = 'Nunca';
$string['neverdeletelogs'] = 'Nunca apagar os registos de atividade';
$string['new'] = 'Novo';
$string['newaccount'] = 'Nova conta';
$string['newactivityname'] = 'Novo nome para a atividade {$a}';
$string['newcourse'] = 'Nova disciplina';
$string['newloginnotificationbodyfull'] = '<p>Olá {$a->userfullname},</p>
<p>A sua conta em {$a->sitename} acabou de ser utilizada para iniciar sessão a partir de um novo dispositivo.</p>
<ul>
<li>A sua conta: {$a->username} {$a->useremail}</li>
<li>{$a->logintime}</li>
<li>Dispositivo: {$a->logindevice}</li>
<li>IP: {$a->loginip}</li>
</ul>
<p>Se a sessão foi iniciada por si, não precisa de fazer nada.</p>
<p>Se não reconhece esta atividade, por favor <a href="{$a->changepasswordlink}">altere a sua senha</a>!</p>';
$string['newloginnotificationbodysmall'] = 'A sua conta \'{$a}\' acabou de ser utilizada para iniciar sessão através de um novo dispositivo.';
$string['newloginnotificationtitle'] = 'Novo início de sessão com a sua conta \'{$a}\'';
$string['newpassword'] = 'Nova senha';
$string['newpassword_help'] = 'Insira uma nova senha ou deixe em branco para manter a atual.';
$string['newpasswordfromlost'] = '<strong>Atenção</strong>: A sua <strong>senha atual</strong> deverá ter sido enviada para si na <strong>segunda</strong> de duas mensagens que lhe foram enviadas como parte do processo de recuperação de senha. Verifique que já recebeu a mensagem com a senha de substituição antes de continuar com esta página.';
$string['newpasswordtext'] = 'Caro(a) {$a->firstname},

A senha da sua conta na plataforma de e-learning \'{$a->sitename}\' foi substituída por uma nova senha provisória.

Os seus dados de acesso atuais são:
   Nome de utilizador: {$a->username}
   Senha: {$a->newpassword}

Por favor, visite esta página, para modificar a sua senha: {$a->link}

Se não conseguir seguir esta hiperligação, copie o URL e cole na barra de endereço do seu navegador web.

Cumprimentos do(a) administrador(a) da plataforma de e-learning  \'{$a->sitename}\',{$a->signoff}';
$string['newpicture'] = 'Nova foto';
$string['newpicture_help'] = 'Para adicionar uma nova foto, procure e selecione uma imagem (formato JPG ou PNG) e clique em "Atualizar perfil". A imagem será recortada na forma de um quadrado e redimensionada para 100x100 píxeis.';
$string['newpictureusernotsetup'] = 'A imagem de perfil só pode ser adicionada depois de guardar todas as informações de perfil obrigatórias.';
$string['newsectionname'] = 'Novo nome para a secção {$a}';
$string['newsitem'] = 'notícia';
$string['newsitems'] = 'anúncios';
$string['newsitemsnumber'] = 'Número de anúncios';
$string['newsitemsnumber_help'] = 'O fórum \'Anúncios\' impõe a subscrição por predefinição. Apenas os professores e outros utilizadores com permissões apropriadas podem publicar.

Se não for necessário um fórum \'Anúncios\' na disciplina, defina como 0 (zero).

Esta configuração determina quantos anúncios mais recentes aparecem no bloco \'Últimos anúncios\'.';
$string['newuser'] = 'Novo utilizador';
$string['newusernewpasswordsubj'] = 'Nova conta de utilizador';
$string['newusernewpasswordtext'] = 'Caro(a) {$a->firstname},

Foi criada uma conta de utilizador para si em \'{$a->sitename}\'.

     Nome de utilizador: {$a->username}
     Senha: {$a->newpassword}

(Ser-lhe-á solicitado que altere a sua palavra-passe quando entrar pela primeira vez.)

Para começar a usar \'{$a->sitename}\', autentique-se em
  {$a->link}.

Se precisar de ajuda, contacte o administrador do site,
{$a->signoff}';
$string['newusers'] = 'Novos utilizadores';
$string['newwindow'] = 'Nova janela';
$string['next'] = 'Seguinte';
$string['nextpage'] = 'Página seguinte';
$string['nextsection'] = 'Nova secção';
$string['no'] = 'Não';
$string['noblockstoaddhere'] = 'Não existem blocos que possa adicionar a esta página.';
$string['nobody'] = 'Ninguém';
$string['nochange'] = 'Sem alteração';
$string['nocomments'] = 'Sem comentários';
$string['nocourses'] = 'Nenhuma disciplina';
$string['nocoursesfound'] = 'Não foram encontradas disciplinas com as palavras \'{$a}\'';
$string['nocoursestarttime'] = 'A disciplina não tem uma data/hora de início.';
$string['nocoursesyet'] = 'Nenhuma disciplina nesta categoria';
$string['nodstpresets'] = 'O administrador do sistema não ativou o suporte para horário de verão.';
$string['nofilesselected'] = 'Não foram selecionados ficheiros para serem restaurados';
$string['nofilesyet'] = 'A sua disciplina ainda não tem nenhum ficheiro';
$string['nofiltersapplied'] = 'Nenhum filtro aplicado';
$string['nograde'] = 'Nenhuma nota';
$string['nohelpforactivityorresource'] = 'Não existe atualmente nenhuma ajuda associada a esse recurso ou atividade';
$string['noimagesyet'] = 'A sua disciplina ainda não tem nenhuma imagem';
$string['nologsfound'] = 'Não foram encontrados registos de atividade';
$string['nomatchingusers'] = 'Não existem utilizadores que correspondam a \'{$a}\'';
$string['nomorecourses'] = 'Não foram encontradas mais disciplinas';
$string['nomoreidnumber'] = 'Não usar um número de identificação, para evitar conflitos';
$string['none'] = 'Nenhum';
$string['noneditingteacher'] = 'Professor não editor';
$string['noneditingteacherdescription'] = 'Os professores não editores podem lecionar disciplinas e avaliar os alunos, mas não podem modificar as atividades.';
$string['nonstandard'] = 'Não predefinido';
$string['nopendingcourses'] = 'Não existem disciplinas à espera de aprovação';
$string['nopotentialadmins'] = 'Nenhum candidato a administrador';
$string['nopotentialcreators'] = 'Nenhum candidato a criador de disciplina';
$string['nopotentialstudents'] = 'Nenhum candidato a aluno';
$string['nopotentialteachers'] = 'Nenhum candidato a professor';
$string['norecentactivity'] = 'Sem atividade recente';
$string['noreplybouncemessage'] = 'Respondeu para um e-mail que não aceita respostas. Se estava a responder a uma mensagem num fórum, por favor, use o \'Responder\' na mensagem {$a}.

Conteúdo da sua mensagem de e-mail:';
$string['noreplybouncesubject'] = '{$a} - mensagens devolvidas';
$string['noreplyname'] = 'Não responda para este endereço';
$string['noresetrecord'] = 'Não existe nenhum registo desse pedido de reposição. Por favor, inicie um novo pedido de reposição de senha.';
$string['noresults'] = 'Sem resultados';
$string['noresultsfor'] = 'Nenhum resultado para "{$a}"';
$string['normal'] = 'Normal';
$string['normalfilter'] = 'Filtro normal';
$string['nosite'] = 'Não foi possível encontrar disciplina no nível site';
$string['nostudentsfound'] = 'Nenhum {$a} encontrado';
$string['nostudentsingroup'] = 'Ainda não existem alunos neste grupo';
$string['nostudentsyet'] = 'Ainda não existem alunos inscritos nesta disciplina.';
$string['nosuchemail'] = 'Este e-mail não existe';
$string['notavailable'] = 'Não disponível';
$string['notavailablecourse'] = '{$a} não está disponível';
$string['noteachersyet'] = 'Esta disciplina ainda não tem professor';
$string['noteachingupcomingcourses'] = 'As próximas disciplinas não têm professores nem alunos';
$string['notenrolled'] = '{$a} não está inscrito nesta disciplina.';
$string['notenrolledprofile'] = 'Este perfil não está ativo porque o utilizador não está inscrito nesta disciplina.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Nota:</strong> A capacidade de restaurar datas foi desativada uma vez que não tem permissões para tal.';
$string['noteuserschangednonetocourse'] = '<strong>Nota:</strong> É necessário restaurar os utilizadores da disciplina quando restaurar os dados dos utilizadores. Esta configuração foi alterada para si.';
$string['nothingnew'] = 'Sem atividade recente';
$string['nothingtodisplay'] = 'Não existe informação para apresentar';
$string['notice'] = 'Aviso';
$string['noticenewerbackup'] = 'Esta cópia de segurança foi criada com Moodle {$a->backuprelease} ({$a->backupversion}) que é mais recente do que a sua versão atual do Moodle {$a->serverrelease} ({$a->serverversion}). Isso poderá gerar algumas inconsistências por ser impossível garantir a compatibilidade entre cópias de versões diferentes.';
$string['notifications'] = 'Notificações';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Utilizador: {$a->info}, Nome completo do utilizador: {$a->name}';
$string['notifyloginfailuresmessageend'] = 'Pode consultar estes registos de atividade em {$a}';
$string['notifyloginfailuresmessagestart'] = 'Abaixo é apresentada a lista de tentativas de autenticação sem sucesso em {$a}, desde a última vez que foi notificado&nbsp;';
$string['notifyloginfailuressubject'] = '{$a} :: Tentativas de autenticação sem sucesso';
$string['notincluded'] = 'Não incluído';
$string['notingroup'] = 'Lamentamos, mas precisa de estar inscrito num grupo para ver esta página.';
$string['notpublic'] = 'Privado!';
$string['nousersfound'] = 'Nenhum utilizador encontrado';
$string['nousersmatching'] = 'Não foram encontrados utilizadores coincidentes com \'{$a}\'';
$string['nousersyet'] = 'Ainda não há utilizadores';
$string['novalidcourses'] = 'Não existem disciplinas válidas para exibir';
$string['now'] = 'agora';
$string['numattempts'] = '{$a} tentativa(s) de autenticação sem sucesso';
$string['numberofcourses'] = 'Número de disciplinas';
$string['numberweeks'] = 'Número de secções';
$string['numday'] = '{$a} dia';
$string['numdays'] = '{$a} dias';
$string['numhours'] = '{$a} horas';
$string['numletters'] = '{$a} letras';
$string['numminutes'] = '{$a} minutos';
$string['nummonth'] = '{$a} mês';
$string['nummonths'] = '{$a} meses';
$string['numseconds'] = '{$a} segundos';
$string['numviews'] = '{$a} acesso(s)';
$string['numweek'] = '{$a} semana';
$string['numweeks'] = '{$a} semanas';
$string['numwords'] = '{$a} palavras';
$string['numyear'] = '{$a} ano';
$string['numyears'] = '{$a} anos';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Senha atual';
$string['olduserdirectory'] = 'Esta é a ANTIGA pasta de utilizadores, que já não é necessário. Pode apagá-lo sem problemas. Os ficheiros nele contidos foram copiados para a NOVA pasta.';
$string['opendrawerblocks'] = 'Abrir painel dos blocos';
$string['opendrawerindex'] = 'Abrir índice da disciplina';
$string['opensinnewwindow'] = 'Abre numa nova janela';
$string['operator_and'] = 'e';
$string['operator_andnot'] = 'e';
$string['operator_or'] = 'ou';
$string['optional'] = 'opcional';
$string['options'] = 'opções';
$string['order'] = 'Ordem';
$string['originalpath'] = 'Caminho original';
$string['orphanedactivitiesinsectionno'] = 'Atividades órfãs (secção {$a})';
$string['other'] = 'Outro';
$string['outline'] = 'Esboço';
$string['outlinereport'] = 'Relatório geral';
$string['page'] = 'Página';
$string['pagea'] = 'Página {$a}';
$string['pagedcontentnavigation'] = 'Navegação na paginação';
$string['pagedcontentnavigationactiveitem'] = 'Página atual, página {$a}';
$string['pagedcontentnavigationitem'] = 'Ir para a página {$a}';
$string['pagedcontentpagingbaritemsperpage'] = 'Mostrar {$a} itens por página';
$string['pageheaderconfigablock'] = 'A configurar um bloco em {$a->fullname}';
$string['pagepath'] = 'Caminho da página';
$string['pageshouldredirect'] = 'Esta página deverá redirecionar automaticamente. Se tal não acontecer, use a hiperligação abaixo para continuar.';
$string['parentcategory'] = 'Categoria ascendente';
$string['parentcoursenotfound'] = 'Disciplina ascendente desconhecida';
$string['parentfolder'] = 'Pasta ascendente';
$string['participants'] = 'Participantes';
$string['participantslist'] = 'Rácio de participantes';
$string['participationratio'] = 'Taxa de participação';
$string['participationreport'] = 'Relatório de participação';
$string['password'] = 'Senha';
$string['passwordchanged'] = 'Senha modificada com sucesso';
$string['passwordconfirmchange'] = 'Confirme alteração de senha';
$string['passwordextlink'] = 'O seguinte apontador permite-lhe substituir a sua senha esquecida. Este apontador conduz para o site Moodle que está utilizar.';
$string['passwordforgotten'] = 'Senha esquecida';
$string['passwordforgotteninstructions'] = 'Primeiro teremos que identificar os seus dados na base de dados. Por favor, diga-nos <strong>um dos dois dados seguintes</strong> no campo respetivo: o seu nome de utilizador no site Moodle ou o e-mail com que está registado. Não tem de indicar as duas informações.';
$string['passwordforgotteninstructions2'] = 'Para redefinir a sua senha, indique o seu nome de utilizador ou o endereço de e-mail. Se qualquer um deles for encontrado na base de dados, será enviada uma mensagem para o seu endereço de e-mail com instruções para obter acesso novamente.';
$string['passwordnohelp'] = 'Não é possível ajudar a recuperar a sua senha. Por favor, contacte o administrador do site Moodle.';
$string['passwordpolicynomatch'] = 'A sua senha atual já não cumpre a política de senhas definida.
    {$a}';
$string['passwordrecovery'] = 'Sim, ajude-me a entrar';
$string['passwordsdiffer'] = 'As senhas não coincidem';
$string['passwordsent'] = 'Senha enviada com sucesso';
$string['passwordsenttext'] = '<p>Foi enviada uma mensagem para o seu endereço {$a->email}.</p>
<p><strong>Por favor, aceda à sua caixa de e-mail para visualizar a nova senha</strong>.</p>
<p>A nova senha foi gerada automaticamente, sendo assim conveniente <a href="{$a->link}">mudá-la para outra mais fácil de se lembrar</a>.</p>';
$string['passwordset'] = 'A sua senha foi definida';
$string['path'] = 'Caminho';
$string['pathnotexists'] = 'Esse caminho não existe no seu servidor!';
$string['pathslasherror'] = 'O caminho não pode terminar com /.';
$string['paymentinstant'] = 'Utilize o botão abaixo para pagar e inscrever-se em poucos minutos.';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> pendente</small>)';
$string['paymentrequired'] = 'Esta disciplina exige uma taxa de inscrição.';
$string['payments'] = 'Pagamentos';
$string['paymentsorry'] = 'Obrigado pelo seu pagamento. Quando for processado, poderá entrar na disciplina \'{$a->fullname\'}.  Aguarde e tente novamente. Se continuar a ter problemas, contacte o {$a->teacher} ou o administrador do site.';
$string['paymentthanks'] = 'Obrigado pelo seu pagamento. Já está inscrito na disciplina \'{$a}\'.';
$string['pendingrequests'] = 'Pedidos pendentes';
$string['percents'] = '{$a}%';
$string['periodending'] = 'Fim do período  ({$a})';
$string['perpage'] = 'Por página';
$string['perpagea'] = 'Por página: {$a}';
$string['personal'] = 'Pessoal';
$string['personalprofile'] = 'Perfil pessoal';
$string['phone'] = 'Telefone';
$string['phone1'] = 'Telefone';
$string['phone2'] = 'Telemóvel';
$string['phpinfo'] = 'Informação do PHP';
$string['picture'] = 'Imagem';
$string['pictureof'] = 'Foto de {$a}';
$string['pictureofuser'] = 'Foto do utilizador';
$string['placeholdertypeorselect'] = 'Digite ou selecione...';
$string['pleaseclose'] = 'Por favor, feche esta janela.';
$string['pleasesearchmore'] = 'Por favor, procure um pouco mais';
$string['pleaseusesearch'] = 'Por favor, use a pesquisa';
$string['plugin'] = 'Módulo';
$string['pluginarea'] = 'Área';
$string['plugincheck'] = 'Teste dos módulos';
$string['plugindeletefiles'] = 'Todos os dados associados ao módulo <strong>\'{$a->name}\'</strong> foram apagados da base de dados. Para prevenir a reinstalação do módulo, deve apagar esta pasta do seu servidor: {$a->directory}';
$string['pluginitemid'] = 'ID do item';
$string['pluginmissingfromdisk'] = '{$a->name} (Em falta no disco)';
$string['pluginsetup'] = 'A configurar tabelas de módulos';
$string['policyaccept'] = 'Compreendo e concordo';
$string['policyagree'] = 'Deverá aceitar este regulamento para poder proceder a utilizar este site. Aceita o regulamento?';
$string['policyagreement'] = 'Política do site';
$string['policyagreementclick'] = 'Acordo da política do site';
$string['popup'] = 'pop-up';
$string['popupwindow'] = 'Abra o ficheiro numa nova janela';
$string['popupwindowname'] = 'Janela pop-up';
$string['post'] = 'Submeter';
$string['posts'] = 'Submissões';
$string['potentialadmins'] = 'Possíveis administradores';
$string['potentialcreators'] = 'Possíveis criadores de disciplinas';
$string['potentialstudents'] = 'Possíveis alunos';
$string['potentialteachers'] = 'Possíveis professores';
$string['poweredbymoodle'] = 'Fornecido por <a href="https://moodle.com">Moodle</a>';
$string['preferences'] = 'Preferências';
$string['preferredlanguage'] = 'Idioma preferido';
$string['preferredtheme'] = 'Tema preferido';
$string['preprocessingbackupfile'] = 'Pré-processando cópia de segurança';
$string['prev'] = 'Anterior';
$string['preview'] = 'Pré-visualização';
$string['previeworchoose'] = 'Ver ou escolher um tema';
$string['previewthemename'] = 'Pré-visualizar tema \'{$a}\'';
$string['previous'] = 'Anterior';
$string['previouslyselectedusers'] = 'Os utilizadores selecionados não correspondem \'{$a}\'';
$string['previouspage'] = 'Página anterior';
$string['previoussection'] = 'Secção anterior';
$string['primaryadminsetup'] = 'Configurar conta de administrador';
$string['privacy:metadata:config_log'] = 'O registo da alteração das configurações.';
$string['privacy:metadata:config_log:name'] = 'O nome da alteração das configurações.';
$string['privacy:metadata:config_log:oldvalue'] = 'O valor anterior desta configuração.';
$string['privacy:metadata:config_log:plugin'] = 'O módulo modificado.';
$string['privacy:metadata:config_log:timemodified'] = 'A data e hora da alteração.';
$string['privacy:metadata:config_log:userid'] = 'O utilizador que fez a alteração.';
$string['privacy:metadata:config_log:value'] = 'O novo valor desta configuração.';
$string['privacy:metadata:events_queue'] = 'A fila de eventos de utilizador à aguardar para serem processados.';
$string['privacy:metadata:events_queue:eventdata'] = 'Os dados armazenados no evento.';
$string['privacy:metadata:events_queue:stackdump'] = 'Qualquer rastreamento associado a este evento.';
$string['privacy:metadata:events_queue:timecreated'] = 'Data e hora em que este evento foi criado';
$string['privacy:metadata:events_queue:userid'] = 'O ID do utilizador associado a este evento';
$string['privacy:metadata:log'] = 'A coleção de eventos passados';
$string['privacy:metadata:log:action'] = 'A descrição da ação';
$string['privacy:metadata:log:cmid'] = 'cmid';
$string['privacy:metadata:log:course'] = 'disciplina';
$string['privacy:metadata:log:info'] = 'Informaçãoa dicional';
$string['privacy:metadata:log:ip'] = 'O endereço IP utilizado na altura do evento';
$string['privacy:metadata:log:module'] = 'módulo';
$string['privacy:metadata:log:time'] = 'A data e hora em que a ação ocorreu';
$string['privacy:metadata:log:url'] = 'O URL relacionado com o evento';
$string['privacy:metadata:log:userid'] = 'O ID do utilizador que executou a ação';
$string['privacy:metadata:moodlenet_share_progress'] = 'MoodleNet partilha detalhes do progresso';
$string['privacy:metadata:moodlenet_share_progress:cmid'] = 'O ID do módulo da disciplina associada';
$string['privacy:metadata:moodlenet_share_progress:courseid'] = 'O ID da disciplina associada';
$string['privacy:metadata:moodlenet_share_progress:resourceurl'] = 'O URL devolvido pelo MoodleNet após uma partilha bem sucedida';
$string['privacy:metadata:moodlenet_share_progress:status'] = 'O estado resultante da partilha';
$string['privacy:metadata:moodlenet_share_progress:timecreated'] = 'A data/hora em que a partilha foi feita';
$string['privacy:metadata:moodlenet_share_progress:type'] = 'O tipo de partilha que foi realizado';
$string['privacy:metadata:moodlenet_share_progress:userid'] = 'O utilizador que fez a partilha';
$string['privacy:metadata:oauth2_refresh_token'] = 'Atualizar token usado na comunicação OAuth 2.0';
$string['privacy:metadata:oauth2_refresh_token:issuerid'] = 'O ID do emissor ao qual corresponde o token';
$string['privacy:metadata:oauth2_refresh_token:scopehash'] = 'O ID do utilizador a quem corresponde o token';
$string['privacy:metadata:oauth2_refresh_token:timecreated'] = 'Data e hora em que o token foi criado';
$string['privacy:metadata:oauth2_refresh_token:timemodified'] = 'A data e hora em que o token foi atualizado pela última vez';
$string['privacy:metadata:oauth2_refresh_token:token'] = 'O token de atualização para os respetivos âmbitos e utilizador';
$string['privacy:metadata:oauth2_refresh_token:userid'] = 'O ID do utilizador a quem corresponde o token';
$string['privacy:metadata:task_adhoc'] = 'O estado das tarefas ad hoc.';
$string['privacy:metadata:task_adhoc:component'] = 'A componente a que pertence a tarefa.';
$string['privacy:metadata:task_adhoc:nextruntime'] = 'O primeiro horário para executar esta tarefa.';
$string['privacy:metadata:task_adhoc:userid'] = 'O utilizador a executar a tarefa como.';
$string['privacy:metadata:task_log'] = 'Guardar resultados num registo';
$string['privacy:metadata:task_log:component'] = 'A componente a que pertence a tarefa.';
$string['privacy:metadata:task_log:userid'] = 'O utilizador ao qual a tarefa pertencia.';
$string['privacy:metadata:upgrade_log'] = 'O registo da atualização.';
$string['privacy:metadata:upgrade_log:backtrace'] = 'Algum retrocesso associado a esta etapa da atualização';
$string['privacy:metadata:upgrade_log:details'] = 'Informação extra relacionada com a atualização.';
$string['privacy:metadata:upgrade_log:info'] = 'A informação principal desta etapa da atualização..';
$string['privacy:metadata:upgrade_log:plugin'] = 'O módulo que foi atualizado.';
$string['privacy:metadata:upgrade_log:targetversion'] = 'A nova versão para atualizar.';
$string['privacy:metadata:upgrade_log:timemodified'] = 'A hora em que foi feita a atualização.';
$string['privacy:metadata:upgrade_log:type'] = 'O tipo de entrada de autenticação.';
$string['privacy:metadata:upgrade_log:userid'] = 'O utilizador que executou a atualização.';
$string['privacy:metadata:upgrade_log:version'] = 'A versão antiga deste módulo.';
$string['private_files_handler'] = 'Armazene os anexos de um e-mail na área de armazenamento de ficheiros privados do utilizador.';
$string['private_files_handler_name'] = 'Do e-mail para Ficheiros privados';
$string['privatefiles'] = 'Ficheiros privados';
$string['privatefilesmanage'] = 'Gerir ficheiros privados';
$string['proceed'] = 'Continuar';
$string['profile'] = 'Perfil';
$string['profilenotshown'] = 'Esta descrição do perfil não será mostrada até que este utilizador esteja inscrito em pelo menos uma disciplina.';
$string['progress'] = 'Progresso';
$string['publicprofile'] = 'Perfil público';
$string['publicsitefileswarning'] = 'Atenção: Os ficheiros aqui colocados poderão ser acedidos por todos';
$string['publicsitefileswarning2'] = 'Nota: Os ficheiros colocados aqui podem ser acedidos por todos os que saibam (ou adivinhem) o URL. Por razões de segurança, é recomendado que todos os ficheiros de cópias de segurança sejam apagados imediatamente após o restauro dos mesmos.';
$string['publicsitefileswarning3'] = 'Nota: Os ficheiros colocados aqui podem ser acedidos por todos os que saibam (ou adivinhem) o URL.<br />Por razões de segurança, os ficheiros das cópias de segurança devem ser guardados apenas numa pasta segura.';
$string['question'] = 'Pergunta';
$string['questionsinthequestionbank'] = 'Perguntas no banco de questões';
$string['queued'] = 'Em fila de espera';
$string['quotausage'] = 'Está atualmente a usar {$a->used} do máximo de {$a->total}.';
$string['readinginfofrombackup'] = 'A ler informação da cópia de segurança';
$string['readme'] = 'LEIA-ME';
$string['recentactivity'] = 'Atividade recente';
$string['recentactivityreport'] = 'Relatório completo da atividade recente';
$string['recipientslist'] = 'Lista de destinatários';
$string['recommended'] = 'Recomendados';
$string['recreatedcategory'] = 'Recriada a categoria {$a}';
$string['redirect'] = 'Redirecionar';
$string['reducesections'] = 'Diminuir o número de secções';
$string['refresh'] = 'Atualizar';
$string['refreshingevents'] = 'A atualizar eventos';
$string['registration'] = 'Registo do Moodle';
$string['registrationcontact'] = 'Contacto por parte do público';
$string['registrationcontactno'] = 'Não, eu não quero ser contactado por outras pessoas';
$string['registrationcontactyes'] = 'Sim, inclua um formulário para que outros utilizadores do Moodle possam contactar-me.';
$string['registrationemail'] = 'Notificações por e-mail';
$string['registrationinfo'] = '<p>Esta página permite-lhe registar-se no site do Moodle (moodle.org). O registo é gratuito.
O principal benefício de se registar é que será adicionado a uma lista de correio apenas para divulgação de alertas de segurança e de novas versões do Moodle.</p>
<p>Por predefinição, os seus dados serão mantidos confidenciais, e nunca serão vendidos ou facultados a mais ninguém. A única razão para a recolha desta informação é para efeitos de apoio, e para ajudar a criar estatísticas acerca da comunidade de utilizadores do Moodle.</p>
<p>Se assim o entender, poderá permitir que o nome do seu site, país e URL sejam adicionados à lista pública de sites que usam o Moodle.</p>
<p>Todos os novos registos serão verificados manualmente antes de serem adicionados à lista, mas uma vez adicionados, poderá atualizar os dados do seu registo em qualquer altura submetendo novamente este formulário.</p>';
$string['registrationinfotitle'] = 'Informação de registo';
$string['registrationsend'] = 'Enviar dados de registo para o moodle.org';
$string['registrationyes'] = 'Sim, notifique-me acerca de novas versões do Moodle, alertas de segurança e outros assuntos importantes';
$string['reject'] = 'Rejeitar';
$string['rejectdots'] = 'Rejeitar';
$string['relativedatesmode'] = 'Modo de datas relativas';
$string['relativedatesmode_help'] = 'Mostrar as datas da disciplina ou da atividade em relação à data de início do utilizador na disciplina.

A data de início na disciplina do utilizador será a data de início da inscrição, a menos que sejam inscritos antes do início da disciplina, caso em que a data de início do utilizador será a data de início da disciplina.

AVISO: Esta funcionalidade está em fase experimental e nem todas as atividades podem suportá-la. Após a criação da disciplina, esta configuração não poderá ser alterada.';
$string['relativedatesmode_warning'] = '<strong>AVISO:</strong> O modo de datas relativas não pode ser alterado após a criação da disciplina.';
$string['reload'] = 'Recarregar';
$string['remoteappuser'] = 'Utilizador remoto {$a}';
$string['remove'] = 'Remover';
$string['removeadmin'] = 'Remover administrador';
$string['removecreator'] = 'Remover criador da disciplina';
$string['removestudent'] = 'Remover aluno';
$string['removeteacher'] = 'Remover professor';
$string['rename'] = 'Renomear';
$string['renamefileto'] = 'Renomear <strong>{$a}</strong> para';
$string['report'] = 'Relatório';
$string['reports'] = 'Relatórios';
$string['reporttype'] = 'Tipo de relatório';
$string['repositories'] = 'Repositórios';
$string['requestcourse'] = 'Pedir disciplina';
$string['requestedby'] = 'Pedida por';
$string['requestedcourses'] = 'Disciplinas pedidas';
$string['requestreason'] = 'Justificação do pedido de disciplina';
$string['requests'] = 'Pedidos';
$string['required'] = 'Obrigatório';
$string['requirespayment'] = 'Esta disciplina exige uma taxa de inscrição.';
$string['resendemail'] = 'Reenviar e-mail de confirmação';
$string['reset'] = 'Limpar';
$string['resetcomponent'] = 'Componente';
$string['resetcourse'] = 'Limpar disciplina';
$string['resetinfo'] = 'Apagar todos os dados dos utilizadores e repor esta disciplina para o seu estado original, mantendo intactas as atividades e as configurações.';
$string['resetnotimplemented'] = 'Limpeza não implementada';
$string['resetrecordexpired'] = 'A hiperligação que usou para repor a senha foi gerada há mais de {$a} minutos e expirou. Por favor, inicie um novo pedido de reposição de senha.';
$string['resetstartdate'] = 'Reiniciar data de início';
$string['resetstatus'] = 'Estado';
$string['resettable'] = 'Repor as preferências da tabela';
$string['resettask'] = 'Tarefa';
$string['resettodefaults'] = 'Reiniciar com valores predefinidos';
$string['resortcourses'] = 'Ordenar disciplinas';
$string['resortsubcategoriesby'] = 'Ordenar subcategorias por {$a} ascendente';
$string['resortsubcategoriesbyreverse'] = 'Ordenar subcategorias por {$a} descendente';
$string['resource'] = 'Recurso';
$string['resourcedisplayauto'] = 'Automático';
$string['resourcedisplaydownload'] = 'Forçar descarga';
$string['resourcedisplayembed'] = 'Incorporar';
$string['resourcedisplayframe'] = 'Frame';
$string['resourcedisplaynew'] = 'Nova janela';
$string['resourcedisplayopen'] = 'Mesma janela';
$string['resourcedisplaypopup'] = 'Janela pop-up';
$string['resources'] = 'Recursos';
$string['resources_help'] = 'Os Recursos permitem inserir na disciplina quase todo o tipo de conteúdo.';
$string['restore'] = 'Restaurar';
$string['restorecancelled'] = 'Restauro cancelado';
$string['restorecannotassignroles'] = 'Para restaurar necessita de atribuir papéis e não possui permissão para fazê-lo.';
$string['restorecannotcreateorassignroles'] = 'Ao restaurar necessita de criar ou atribuir papéis na disciplina e não tem permissão para tal';
$string['restorecannotcreateuser'] = 'Ao restaurar necessita de criar o utilizador \'{$a}\' a partir do ficheiro da cópia de segurança e não tem permissões para tal';
$string['restorecannotoverrideperms'] = 'O restauro precisa de redefinir permissões e você não tem permissão para tal';
$string['restorecoursenow'] = 'Restaurar a disciplina';
$string['restoredaccount'] = 'Conta recuperada';
$string['restoredaccountinfo'] = 'Esta conta foi importada de outro servidor e perdeu a senha. Para configurar uma nova senha por e-mail, clique em "Continuar"';
$string['restorefinished'] = 'Restauro concluído com sucesso';
$string['restoreinfo'] = 'Usar um ficheiro de cópia de segurança para restaurar uma versão anterior de uma disciplina ou para criar uma nova disciplina.';
$string['restoremnethostidmismatch'] = 'O ID do servidor MNet local não coincide com o ID do utilizador \'{$a}\' no servidor MNet.';
$string['restoreto'] = 'Restaurar para';
$string['restoretositeadding'] = 'Aviso: Está prestes a restaurar a página principal do site, adicionando-lhe dados!';
$string['restoretositedeleting'] = 'Aviso: Está prestes a restaurar a página principal do site, excluindo-lhe dados!';
$string['restoreuserconflict'] = 'Tentar restaurar o utilizador \'{$a}\' do ficheiro da cópia de segurança irá causar conflitos';
$string['restoreuserinfofailed'] = 'O processo de restauro parou porque não tem permissão para restaurar dados dos utilizadores.';
$string['restoreusersprecheck'] = 'A verificar os dados dos utilizadores';
$string['restoreusersprecheckerror'] = 'Foram encontrados problemas ao verificar os dados dos utilizadores';
$string['restricted'] = 'Acesso vedado';
$string['resultsfound'] = '{$a} resultados encontrados';
$string['retry'] = 'Voltar a tentar';
$string['returningtosite'] = 'Voltar para este site?';
$string['returntooriginaluser'] = 'Voltar para {$a}';
$string['revert'] = 'Reverter';
$string['role'] = 'Papel ';
$string['roleassignments'] = 'Atribuição de papéis';
$string['rolemappings'] = 'Mapa de papéis atribuídos';
$string['rolerenaming'] = 'Alteração do nome do papel';
$string['rolerenaming_help'] = 'Alterar as designações dos papéis exibidos nesta disciplina.';
$string['rolerenaming_success'] = 'Atualizadas as designações dos papéis desta disciplina.';
$string['roles'] = 'Papéis atribuídos';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Número de artigos recentes na lista RSS';
$string['rsserror'] = 'Erro na leitura dos dados da lista RSS';
$string['rsserrorauth'] = 'A sua hiperligação para a lista RSS não contém um token de autenticação válido.';
$string['rsserrorguest'] = 'Esta lista usa o acesso de visitante para aceder à informação, mas o visitante não tem permissões de leitura dessa informação. Visite o URL de origem desta lista, autenticado com uma conta válida, para obter uma nova hiperligação da RSS.';
$string['rsskeyshelp'] = '<p>Para garantir a segurança e privacidade, os URLs das listas RSS possuem um token especial que identifica o utilizador a quem se destina. Desta forma, evita-se que outros utilizadores acedam a áreas do Moodle a que não têm acesso.</p><p>O token é criado automaticamente na primeira vez que aceder a uma área que produz uma lista RSS. Se achar que o token da sua lista RSS foi comprometido de alguma forma, pode solicitar um novo clicando na hiperligação de Recomeço. Tenha em atenção que, após isto, os seus URLs atuais das listas RSS ficarão inválidos. </p>';
$string['rsstype'] = 'Lista RSS para esta atividade';
$string['save'] = 'Guardar';
$string['saveandnext'] = 'Guardar e mostrar seguinte';
$string['savechanges'] = 'Guardar alterações';
$string['savechangesanddisplay'] = 'Guardar alterações e mostrar';
$string['savechangesandreturn'] = 'Guardar e voltar';
$string['savechangesandreturntocourse'] = 'Guardar alterações e voltar à disciplina';
$string['savecomment'] = 'Guardar comentário';
$string['savedat'] = 'Guardado em:';
$string['savepreferences'] = 'Guardar preferências';
$string['saveto'] = 'Guardar em';
$string['scale'] = 'Nota';
$string['scale_help'] = 'As notas qualitativas permitem avaliar atividades numa disciplina. A escala de notas qualitativas consiste numa lista ordenada de indicadores, que vão do negativo ao positivo, separados por vírgulas. Exemplo: Não satisfaz, Satisfaz pouco, Satisfaz bastante, Excelente';
$string['scale_link'] = 'grade/scale';
$string['scales'] = 'Escalas';
$string['scalescustom'] = 'Escalas personalizadas';
$string['scalescustomcreate'] = 'Adicionar uma nova escala';
$string['scalescustomno'] = 'Ainda não foram criadas escalas personalizadas';
$string['scalesstandard'] = 'Escalas padrão';
$string['scalestandard'] = 'Escala padrão';
$string['scalestandard_help'] = 'Uma escala padrão está disponível em todo o site para todas as disciplinas.';
$string['scalestandard_link'] = 'grade/scale';
$string['scalestip'] = 'Para criar escalas personalizadas, use a ligação \'Escalas...\' no menu de administração da sua disciplina.';
$string['scalestip2'] = 'Para criar escalas personalizadas, clique na secção Notas no menu de administração da disciplina e a seguir selecione Editar, Escalas.';
$string['schedule'] = 'Horário';
$string['screenshot'] = 'Captura de ecrã';
$string['search'] = 'Pesquisar';
$string['search_help'] = 'Para fazer uma pesquisa básica de uma ou mais palavras no texto, digite as palavras a pesquisar separadas por espaços. São consideradas para pesquisa todas as palavras com mais de dois caracteres.

Para fazer pesquisas avançadas, clique no botão de pesquisa, sem digitar nenhuma palavra na caixa de texto, para ter acesso ao formulário de pesquisa avançada.';
$string['searchactivities'] = 'Procurar atividades por nome ou por descrição';
$string['searchagain'] = 'Pesquisar novamente';
$string['searchbyemail'] = 'Pesquisar por endereço de e-mail';
$string['searchbyusername'] = 'Pesquisar por nome de utilizador';
$string['searchcoursecategories'] = 'Pesquisar categorias';
$string['searchcourses'] = 'Pesquisar disciplinas';
$string['searchgroups'] = 'Procurar grupos';
$string['searchitems'] = 'Procurar itens';
$string['searchoptions'] = 'Opções de pesquisa';
$string['searchresults'] = 'Resultado da procura';
$string['searchusers'] = 'Procurar utilizadores';
$string['sec'] = 'segundo';
$string['seconds'] = 'segundos';
$string['secondsleft'] = '{$a} segundos';
$string['secondstotime172800'] = '2 dias';
$string['secondstotime259200'] = '3 dias';
$string['secondstotime345600'] = '4 dias';
$string['secondstotime432000'] = '5 dias';
$string['secondstotime518400'] = '6 dias';
$string['secondstotime604800'] = '1 semana';
$string['secondstotime86400'] = '1 dia';
$string['secretalreadyused'] = 'A senha não foi alterada porque a ligação para confirmar a sua alteração já foi utilizada.';
$string['secs'] = 'segundos';
$string['section'] = 'Secção';
$string['sectionactionnotsupported'] = 'A ação de secção "{$a}" não é suportada aqui';
$string['sectionname'] = 'Nome da secção';
$string['sectionoutline'] = 'Lista de secções';
$string['sections'] = 'Secções';
$string['seealsostats'] = 'Ver também: estatísticas';
$string['selctauser'] = 'Selecione o utilizador';
$string['select'] = 'Selecionar';
$string['selectacategory'] = 'Por favor, selecione uma categoria';
$string['selectacountry'] = 'Selecione um país';
$string['selectacourse'] = 'Selecione uma disciplina';
$string['selectacoursesite'] = 'Selecione uma disciplina ou site';
$string['selectagroup'] = 'Selecione um grupo';
$string['selectall'] = 'Selecionar tudo';
$string['selectallusersonpage'] = 'Selecionar todos os utilizadores nesta página';
$string['selectalluserswithcount'] = 'Selecionar todos os {$a} utilizadores';
$string['selectamodule'] = 'Por favor, selecione um módulo de atividade';
$string['selectanaction'] = 'Selecione uma ação';
$string['selectanoptions'] = 'Selecione uma opção';
$string['selectaregion'] = 'Selecione uma região';
$string['selectcategorysort'] = 'Que categorias pretende ordenar?';
$string['selectcategorysortby'] = 'Selecione como pretende ordenar as categorias';
$string['selectcoursesortby'] = 'Selecione como pretende ordenar as disciplinas';
$string['selectdefault'] = 'Selecionar valor predefinido';
$string['selectedcategories'] = 'Categorias selecionadas';
$string['selectedfile'] = 'Selecione um ficheiro';
$string['selectednowmove'] = '{$a} ficheiros selecionados para serem movidos. Vá para a pasta de destino e pressione \'Mover os ficheiros para este local\'';
$string['selectfiles'] = 'Selecione os ficheiros';
$string['selectfiltertype'] = 'Selecione';
$string['selectgroupsseparate'] = 'Selecione grupos separados';
$string['selectgroupsvisible'] = 'Selecione grupos visíveis';
$string['selectitem'] = 'Selecionar \'{$a}\'';
$string['selectmoduletoviewhelp'] = 'Selecione uma atividade ou recurso para exibir a respetiva ajuda. Faça duplo clique no nome da atividade ou recurso para os adicionar rapidamente.';
$string['selectnos'] = 'Selecionar todos os \'Não\'';
$string['selectperiod'] = 'Selecione período';
$string['selecttheme'] = 'Selecionar';
$string['selectthemename'] = 'Selecionar tema \'{$a}\'';
$string['senddetails'] = 'Envie os meus dados por e-mail';
$string['sent'] = 'Enviado';
$string['separate'] = 'Separar';
$string['separateandconnected'] = 'Modos de aprendizagem Isolado e Conexo';
$string['separateandconnectedinfo'] = 'A escala baseada na teoria de aprendizagem isolada e conexa. Esta teoria descreve duas formas diferentes de avaliarmos e aprendermos sobre as coisas que vemos e ouvimos.<ul><li><strong>Aprendentes isolados</strong> são tão objetivos quanto possível, evitando sentimentos e emoções. Numa discussão com outras pessoas, gostam de defender as suas próprias ideias, usando a lógica de encontrar lacunas nas ideias dos adversários.</li><li><strong>Aprendentes conexos</strong> são mais sensíveis a outras pessoas. Criam facilmente empatia e preferem ouvir e questionar, até sentir que se podem ligar e "compreender as coisas do seu ponto de vista". Aprendem através da partilha das experiências que levaram ao conhecimento que encontram noutras pessoas.</li></ul>';
$string['servererror'] = 'Ocorreu um erro ao comunicar com o servidor';
$string['serverlocaltime'] = 'Hora local do servidor';
$string['sessionforceclean'] = 'Por questões de segurança, os scripts gerados pelo utilizador foram desativados nesta sessão.';
$string['sessiontimeoutsoon'] = 'Esta sessão está prestes a expirar. Pretende prolongar a sua sessão atual?';
$string['setcategorytheme'] = 'Definir tema da categoria';
$string['setmode'] = 'Modo de configuração';
$string['setpassword'] = 'Definir senha';
$string['setpasswordinstructions'] = 'Por favor, introduza abaixo a sua nova senha e depois guarde as alterações.';
$string['settings'] = 'Configurações';
$string['share'] = 'Partilhar';
$string['shortname'] = 'Nome curto';
$string['shortnamecollisionwarning'] = '[*] = Este nome curto já está a ser usado por uma disciplina e deverá ser modificado quando a disciplina for aprovada.';
$string['shortnamecourse'] = 'Nome curto';
$string['shortnamecourse_help'] = 'O nome mostrado em áreas com espaço limitado. Tem de ser único.';
$string['shortnametaken'] = 'O nome curto selecionado já está atribuído a outra disciplina ({$a})';
$string['shortnameuser'] = 'Nome curto do utilizador';
$string['shortsitename'] = 'Nome curto do site (uma única palavra)';
$string['show'] = 'Mostrar';
$string['showactions'] = 'Ações a mostrar';
$string['showactivitydates'] = 'Mostrar datas das atividades';
$string['showactivitydates_help'] = 'Mostrar as datas das atividades na página da disciplina.';
$string['showadvancededitor'] = 'Avançado';
$string['showadvancedsettings'] = 'Mostrar configurações avançadas';
$string['showall'] = 'Mostrar tudo {$a}';
$string['showallcourses'] = 'Mostrar todas as disciplinas';
$string['showallusers'] = 'Mostrar todos os utilizadores';
$string['showblockcourse'] = 'Mostrar a lista das disciplinas com este bloco';
$string['showcategory'] = 'Mostrar {$a}';
$string['showchartdata'] = 'Mostrar dados do gráfico';
$string['showcomments'] = 'Mostrar/Ocultar comentários';
$string['showcommentsnonjs'] = 'Mostrar comentários';
$string['showdescription'] = 'Mostrar descrição na página da disciplina';
$string['showdescription_help'] = 'Se ativar esta opção, a descrição acima será exibida na página da disciplina, logo abaixo da hiperligação para a atividade ou recurso.';
$string['showgrades'] = 'Mostrar a pauta aos alunos';
$string['showgrades_help'] = 'Permitir que os alunos visualizem a lista das suas notas na disciplina.';
$string['showingacourses'] = 'Mostrar todas as {$a} disciplinas';
$string['showingxofycourses'] = 'A mostrar as disciplinas {$a->start} a {$a->end} do total de  {$a->total} disciplinas';
$string['showless'] = 'Mostrar menos';
$string['showlistofcourses'] = 'Mostrar todas as disciplinas';
$string['showmodulecourse'] = 'Mostrar a lista de disciplinas com esta atividade';
$string['showmore'] = 'Mostrar mais';
$string['showoncoursepage'] = 'Mostrar na página da disciplina';
$string['showonly'] = 'Mostrar apenas';
$string['showperpage'] = 'Mostrar apenas {$a} por página';
$string['showpopoverwindow'] = 'Mostrar a janela de informação após clicar';
$string['showrecent'] = 'Mostrar atividade recente';
$string['showreports'] = 'Mostrar relatórios de atividade';
$string['showreports_help'] = 'Permitir que os alunos visualizem os seus próprios relatórios de atividades através da página do seu perfil.';
$string['showsettings'] = 'Mostrar configuração';
$string['showtheselogs'] = 'Mostrar estatísticas de acesso';
$string['showthishelpinlanguage'] = 'Mostrar esta ajuda no idioma: {$a}';
$string['sidepanel'] = 'Painel lateral';
$string['signoutofotherservices'] = 'Sair de todas aplicações web';
$string['signoutofotherservices_help'] = 'Sair de todos os dispositivos e sistemas que usam web services, tal como a Aplicação móvel. As sessões do navegador permanecerão ativas.';
$string['since'] = 'Desde';
$string['sincelast'] = 'desde a última autenticação';
$string['site'] = 'Site';
$string['sitedefault'] = 'Valor predefinido do site';
$string['sitedefaultspecified'] = 'Predefinição do site ({$a})';
$string['siteerrors'] = 'Erros no site';
$string['sitefiles'] = 'Ficheiros do site';
$string['sitefilesused'] = 'Ficheiros do site usados nesta disciplina';
$string['sitehome'] = 'Página inicial do site';
$string['sitelegacyfiles'] = 'Ficheiros da disciplina (retrocompatibilidade)';
$string['sitelogs'] = 'Estatísticas de acesso ao site';
$string['sitenews'] = 'Anúncios do site';
$string['sitepages'] = 'Páginas do site';
$string['sitepartlist'] = 'Não possui as permissões necessárias para ver a lista de participantes';
$string['sitepartlist0'] = 'A lista de participantes só pode ser consultada pelos professores da página principal do site';
$string['sitepartlist1'] = 'A lista de participantes só pode ser consultada pelos professores';
$string['sites'] = 'Sites';
$string['sitesection'] = 'Adicionar conteúdo personalizado';
$string['sitesettings'] = 'Configurações do site';
$string['siteteachers'] = 'Professores do site';
$string['size'] = 'Tamanho';
$string['sizeb'] = 'bytes';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['sizepb'] = 'PB';
$string['sizetb'] = 'TB';
$string['skipped'] = 'Ignorado';
$string['skiptocategorylisting'] = 'Ir para as listas de categorias';
$string['skiptocoursedetails'] = 'Ir para as informações detalhadas da disciplina';
$string['skiptocourselisting'] = 'Ir para as listas de disciplinas';
$string['socialheadline'] = 'Fórum social - últimos tópicos';
$string['someallowguest'] = 'Algumas disciplinas podem aceitar visitantes';
$string['someerrorswerefound'] = 'Alguma informação está incorreta ou em falta. Veja a informação detalhada abaixo.';
$string['sort'] = 'Ordenar';
$string['sortby'] = 'Ordenar por';
$string['sortbyx'] = 'Ordenar por \'{$a}\' ascendente';
$string['sortbyxreverse'] = 'Ordenar por \'{$a}\' descendente';
$string['sorting'] = 'Ordenar';
$string['sourcerole'] = 'Procurar papel';
$string['specifyname'] = 'Tem de atribuir um nome.';
$string['standard'] = 'Padrão';
$string['starpending'] = '([*] = disciplinas à espera de aprovação)';
$string['startdate'] = 'Data de início';
$string['startdate_help'] = 'Esta data determina o início da primeira semana de uma disciplina no formato semanal. É também a data de início dos registos de atividade da disciplina.

Se a disciplina for reiniciada e a data de início alterada, todas as datas da disciplina serão ajustadas relativamente à nova data de início.';
$string['startdatewithtaskenabled'] = 'Data de início da disciplina';
$string['startdatewithtaskenabled_help'] = 'A data a partir da qual a disciplina fica visível para os alunos. Antes desta data, os alunos não poderão aceder à disciplina.

Esta data também determina o início da primeira semana de uma disciplina no formato semanal e é a data de início dos registos das atividades da disciplina. Se redefinir a disciplina e alterar esta data, todas as datas da disciplina serão alteradas em relação à nova data de início.';
$string['startingfrom'] = 'Início';
$string['startsignup'] = 'Criar nova conta';
$string['state'] = 'Estado/Província';
$string['statistics'] = 'Estatísticas';
$string['statisticsgraph'] = 'Gráfico de estatísticas';
$string['stats'] = 'Estatísticas';
$string['statslogins'] = 'Autenticações';
$string['statsmodedetailed'] = 'Visão detalhada (utilizador)';
$string['statsmodegeneral'] = 'Visão geral';
$string['statsnodata'] = 'Não existem dados disponíveis para essa combinação de disciplina e período.';
$string['statsnodatauser'] = 'Não existem dados disponíveis para essa combinação de disciplina, utilizador e período.';
$string['statsoff'] = 'Estatísticas atualmente desativadas';
$string['statsreads'] = 'Visualizações';
$string['statsreport1'] = 'Autenticações';
$string['statsreport10'] = 'Atividade de utilizador';
$string['statsreport11'] = 'Disciplinas mais ativas';
$string['statsreport12'] = 'Disciplinas mais ativas (média)';
$string['statsreport13'] = 'Disciplinas com maior participação (inscrições)';
$string['statsreport14'] = 'Disciplinas com maior participação (submissões/visualizações)';
$string['statsreport2'] = 'Consultas (professores e alunos)';
$string['statsreport3'] = 'Contribuições (professores e alunos)';
$string['statsreport4'] = 'Toda a atividade (professores e alunos)';
$string['statsreport5'] = 'Atividade de alunos (consultas e contribuições)';
$string['statsreport7'] = 'Atividade de utilizadores (consultas e contribuições)';
$string['statsreport8'] = 'Toda a atividade de utilizadores';
$string['statsreport9'] = 'Autenticações (página principal)';
$string['statsreportactivity'] = 'Toda a atividade (professores e alunos)';
$string['statsreportactivitybyrole'] = 'Todas as atividades (Visualizações e submissões)';
$string['statsreportforuser'] = 'para';
$string['statsreportlogins'] = 'Autenticações';
$string['statsreportreads'] = 'Consultas (todos os papéis)';
$string['statsreporttype'] = 'Tipo de relatório';
$string['statsreportwrites'] = 'Contribuições (todos os papéis)';
$string['statsstudentactivity'] = 'Atividade de alunos';
$string['statsstudentreads'] = 'Consultas de alunos';
$string['statsstudentwrites'] = 'Contribuições de alunos';
$string['statsteacheractivity'] = 'Atividade de professores';
$string['statsteacherreads'] = 'Consultas de professores';
$string['statsteacherwrites'] = 'Contribuições de professores';
$string['statstimeperiod'] = 'Intervalo de tempo - N.º de registos:';
$string['statsuniquelogins'] = 'Autenticações únicas';
$string['statsuseractivity'] = 'Toda a atividade';
$string['statsuserlogins'] = 'Autenticações';
$string['statsuserreads'] = 'Visualizações';
$string['statsuserwrites'] = 'Submissões';
$string['statswrites'] = 'Submissões';
$string['status'] = 'Estado';
$string['statuschecks'] = 'Verificar estado';
$string['statuscritical'] = 'Crítico';
$string['statuserror'] = 'Erro';
$string['statusinfo'] = 'Informação';
$string['statusna'] = 'N/A';
$string['statusok'] = 'OK';
$string['statusunknown'] = 'Desconhecido';
$string['statuswarning'] = 'Aviso';
$string['stringsnotset'] = 'As variáveis seguintes não estão definidas em {$a}';
$string['studentnotallowed'] = 'Desculpe, mas não se pode inscrever nesta disciplina como \'{$a}\'';
$string['students'] = 'Alunos';
$string['studentsandteachers'] = 'Alunos e professores';
$string['subcategories'] = 'Subcategorias';
$string['subcategory'] = 'Subcategoria';
$string['subcategoryof'] = 'Subcategoria de {$a}';
$string['subject'] = 'Assunto';
$string['submit'] = 'Submeter';
$string['success'] = 'Operação realizada com sucesso';
$string['successduration'] = 'Operação realizada com sucesso ({$a} segundos)';
$string['summary'] = 'Sumário';
$string['summary_help'] = 'Um sumário é um texto curto cujo o objetivo é fornecer informação para preparar os alunos para as atividades dentro do tópico ou semana. O texto é mostrado na página da disciplina abaixo do nome da secção.';
$string['summaryof'] = 'Sumário de {$a}';
$string['suspended'] = 'Suspenso';
$string['suspendedusers'] = 'Utilizadores suspensos';
$string['switchdevicedefault'] = 'Mudar para o tema standard';
$string['switchdevicerecommended'] = 'Mudar para o tema recomendado';
$string['switchrolereturn'] = 'Retomar o meu papel habitual';
$string['switchroleto'] = 'Assumir o papel de...';
$string['switchroleto_help'] = 'Escolha um papel para ter uma ideia de como utilizadores com este papel visualizarão esta disciplina.

Tenha em atenção que poderá não ser uma visualização perfeita (<a href="https://docs.moodle.org/en/Switch_roles">Ver detalhes e alternativas</a>).';
$string['tag'] = 'Palavra-chave';
$string['tagalready'] = 'Esta palavra-chave já existe';
$string['tagmanagement'] = 'Adicionar/apagar palavras-chave...';
$string['tags'] = 'Palavras-chave';
$string['targetrole'] = 'Papel atribuído no destino';
$string['teacheronly'] = 'só para {$a}';
$string['teacherroles'] = '{$a} papéis';
$string['teachers'] = 'Professores';
$string['textcopiedtoclipboard'] = 'Texto copiado para a área de transferência';
$string['textediting'] = 'Editor de texto';
$string['textediting_help'] = 'Se selecionar um editor HTML, tal como Atto ou TinyMCE, os campos do tipo Área de texto terão uma barra de ferramentas com botões para facilmente adicionar e formatar o conteúdo.

Se selecionar \'Área de texto simples\', pode escolher um formato para áreas de texto tal como HTML ou Markdown.

A lista de editores de texto disponíveis é determinada pelo administrador do site.';
$string['texteditor'] = 'Usar formulários Web';
$string['textellipsis'] = '{$a}...';
$string['textformat'] = 'Formato de texto simples';
$string['thanks'] = 'Obrigado';
$string['theme'] = 'Tema';
$string['themepreviewdescription'] = 'Descrição do tema {$a}';
$string['themepreviewimage'] = 'Pré-visualização do tema {$a}';
$string['themes'] = 'Temas';
$string['themesaved'] = 'O novo tema foi guardado';
$string['therearecourses'] = 'Existem {$a} disciplinas';
$string['thereareno'] = 'Não existe nenhum {$a} nesta disciplina';
$string['thiscategory'] = 'Esta categoria';
$string['thiscategorycontains'] = 'Esta categoria contém';
$string['time'] = 'Data e hora';
$string['timecreated'] = 'Data e hora de criação';
$string['timecreatedcourse'] = 'Data e hora de criação da disciplina';
$string['timesplitting:deciles'] = 'Último décimo';
$string['timesplitting:deciles_help'] = 'Este intervalo de análise divide a disciplina em décimos (10 partes iguais), sendo cada previsão baseada apenas nos dados do décimo anterior mais recente.';
$string['timesplitting:decilesaccum'] = 'Todos os décimos anteriores';
$string['timesplitting:decilesaccum_help'] = 'Este intervalo de análise divide a disciplina em décimos (10 partes iguais), sendo cada previsão baseada nos dados de todos os décimos anteriores.';
$string['timesplitting:nosplitting'] = 'Sem limite de tempo';
$string['timesplitting:nosplitting_help'] = 'Nenhum intervalo de análise está definido para este modelo.';
$string['timesplitting:onemonthafterstart'] = 'Um mês após o início';
$string['timesplitting:onemonthafterstart_help'] = 'Este intervalo de análise gera uma previsão 1 mês após o início do intervalo de análise.';
$string['timesplitting:oneweekafterstart'] = 'Uma semana após o início';
$string['timesplitting:oneweekafterstart_help'] = 'Este intervalo de análise gera uma previsão 1 semana após o início do intervalo de análise.';
$string['timesplitting:past3days'] = 'Últimos 3 dias';
$string['timesplitting:past3days_help'] = 'Este intervalo de análise gera previsões a cada 3 dias. Os cálculos dos indicadores serão baseados nos últimos 3 dias.';
$string['timesplitting:pastmonth'] = 'Mês passado';
$string['timesplitting:pastmonth_help'] = 'Este intervalo de análise gera previsões a cada mês. Os cálculos dos indicadores serão baseados no mês passado.';
$string['timesplitting:pastweek'] = 'Semana passada';
$string['timesplitting:pastweek_help'] = 'Este intervalo de análise gera previsões a cada semana. Os cálculos dos indicadores serão baseados na semana passada.';
$string['timesplitting:quarters'] = 'Último trimestre';
$string['timesplitting:quarters_help'] = 'Este intervalo de análise divide a disciplina em trimestres (4 partes iguais), sendo cada previsão baseada apenas nos dados do trimestre anterior mais recente.';
$string['timesplitting:quartersaccum'] = 'Todos os trimestres anteriores';
$string['timesplitting:quartersaccum_help'] = 'Este intervalo de análise divide a disciplina em trimestres (4 partes iguais), sendo cada previsão baseada nos dados de todos os trimestres anteriores.';
$string['timesplitting:singlerange'] = 'Do início ao fim';
$string['timesplitting:singlerange_help'] = 'Este intervalo de análise considera toda a disciplina como um único período.';
$string['timesplitting:tenpercentafterstart'] = '10% após o início';
$string['timesplitting:tenpercentafterstart_help'] = 'Esse intervalo de análise gera uma previsão após a conclusão de 10% da disciplina.';
$string['timesplitting:upcoming3days'] = 'Nos próximos 3 dias';
$string['timesplitting:upcoming3days_help'] = 'Este intervalo de análise gera previsões a cada 3 dias. Os cálculos dos indicadores serão baseados nos próximos 3 dias.';
$string['timesplitting:upcomingfortnight'] = 'Próxima quinzena';
$string['timesplitting:upcomingfortnight_help'] = 'Este intervalo de análise gera previsões para cada quinzena. Os cálculos dos indicadores serão baseados na quinzena que vem.';
$string['timesplitting:upcomingweek'] = 'Próxima semana';
$string['timesplitting:upcomingweek_help'] = 'Este intervalo de análise gera previsões para cada semana. Os cálculos dos indicadores serão baseados na semana que vem.';
$string['timezone'] = 'Fuso horário';
$string['to'] = 'Para';
$string['tocontent'] = 'Para o item "{$a}"';
$string['tocreatenewaccount'] = 'Ir para criar nova conta';
$string['todate'] = 'Até';
$string['today'] = 'Hoje';
$string['todaylogs'] = 'Atividade de hoje';
$string['toeveryone'] = 'para todos';
$string['toggleemojipicker'] = 'Alternar seletor de emoji';
$string['togglesearch'] = 'Alternar a entrada da pesquisa';
$string['toomanybounces'] = 'Esse e-mail tem devolvido várias mensagens. <strong>Deverá modificá-lo</strong> para poder continuar.';
$string['toomanytags'] = 'Esta pesquisa inclui muitas palavras-chave. Algumas delas foram ignoradas.';
$string['toomanytoshow'] = 'Existem demasiados utilizadores para mostrar.';
$string['toomanyusersmatchsearch'] = 'Demasiados utilizadores ({$a->count}) correspondem a \'{$a->search}\'';
$string['toomanyuserstoshow'] = 'Demasiados utilizadores para mostrar ({$a})';
$string['toonly'] = 'apenas para {$a}';
$string['top'] = 'Topo';
$string['topic'] = 'Tópico';
$string['topichide'] = 'Esconda este tópico de {$a}';
$string['topicoutline'] = 'Lista de tópicos';
$string['topicshow'] = 'Mostre este tópico a {$a}';
$string['toplevelcategory'] = 'Categoria de nível superior';
$string['torecipient'] = 'Para';
$string['total'] = 'Total';
$string['totopofsection'] = 'Para o topo da secção: "{$a}"';
$string['trackforums'] = 'Assinalar mensagens não lidas nos fóruns';
$string['trackforumsno'] = 'Não: não assinalar mensagens já lidas';
$string['trackforumsyes'] = 'Sim: assinalar mensagens não lidas';
$string['trysearching'] = 'Tente antes fazer uma pesquisa.';
$string['turneditingoff'] = 'Desativar modo de edição';
$string['turneditingon'] = 'Ativar modo de edição';
$string['unabletocopytoclipboard'] = 'Não é possível copiar o texto para a área de transferência';
$string['unauthorisedlogin'] = 'A conta de utilizador "{$a}" não está disponível neste site';
$string['undecided'] = 'Indeciso';
$string['unexistingcmid'] = 'ID do módulo da disciplina não encontrado';
$string['unexistingsectionid'] = 'ID da secção da disciplina não encontrada';
$string['unfinished'] = 'Sem terminar';
$string['unknowncategory'] = 'Categoria desconhecida';
$string['unknownerror'] = 'Erro desconhecido';
$string['unknownuser'] = 'Utilizador desconhecido';
$string['unlimited'] = 'Ilimitado';
$string['unpacking'] = 'A desempacotar {$a}';
$string['unsafepassword'] = 'Senha pouco segura - tente outra melhor';
$string['untilcomplete'] = 'Até estar completo';
$string['unusedaccounts'] = 'Contas que não sejam utilizadas por mais do que {$a} dias são apagadas automaticamente';
$string['unzip'] = 'Descompactar';
$string['unzippingbackup'] = 'A descompactar a cópia de segurança';
$string['up'] = 'Para cima';
$string['update'] = 'Atualizar';
$string['updated'] = '{$a} foi atualizado(a)';
$string['updatemymoodleoff'] = 'Terminar personalização desta página';
$string['updatemymoodleon'] = 'Personalizar esta página';
$string['updatemyprofile'] = 'Atualizar perfil';
$string['updatesevery'] = 'Atualizações a cada {$a} segundos';
$string['updatethis'] = 'Atualizar {$a}';
$string['updatethiscourse'] = 'Atualizar esta disciplina';
$string['updatinga'] = 'A atualizar: {$a}';
$string['updatingain'] = 'A atualizar \'{$a->what}\' em "{$a->in}"';
$string['upload'] = 'Carregar';
$string['uploadafile'] = 'Carregar ficheiro';
$string['uploadcantwrite'] = 'Não foi possível escrever ficheiro no disco';
$string['uploadedfile'] = 'Ficheiro recebido com sucesso';
$string['uploadedfileto'] = 'Recebido {$a->file} em {$a->directory}';
$string['uploadedfiletoobig'] = 'Lamentamos, mas esse ficheiro é muito grande (o limite é {$a} bytes)';
$string['uploadextension'] = 'O envio de ficheiro parado pela extensão';
$string['uploadfailednotrecovering'] = 'A recepção do ficheiro que enviou falhou devido a um problema com um dos ficheiros, {$a->name}.<br />Os problemas encontrados foram:<br />{$a->problem}<br />Não foi possível resolver o problema.';
$string['uploadfilelog'] = 'Relatório de envio do ficheiro {$a}';
$string['uploadformlimit'] = 'O ficheiro enviado {$a} excedeu o limite máximo permitido no formulário';
$string['uploadlabel'] = 'Título:';
$string['uploadlimitwithsize'] = 'Limite de carregamento no contexto {$a->contextname} ({$a->displaysize})';
$string['uploadnewfile'] = 'Carregar novo ficheiro';
$string['uploadnofilefound'] = 'Nenhum ficheiro encontrado - tem a certeza de que selecionou algum ficheiro para enviar?';
$string['uploadnotallowed'] = 'Não é permitido anexar ficheiros';
$string['uploadnotempdir'] = 'Não existe pasta temporária';
$string['uploadoldfilesdeleted'] = 'O(s) ficheiro(s) antigo(s) na sua área de ficheiros enviados foi apagado';
$string['uploadpartialfile'] = 'Foi recebida apenas uma parte do ficheiro';
$string['uploadproblem'] = 'Ocorreu um erro desconhecido ao carregar o ficheiro \'{$a}\' (verifique se excedeu o tamanho permitido)';
$string['uploadrenamedchars'] = 'O ficheiro foi renomeado de {$a->oldname} para {$a->newname} para substituir caracteres não válidos.';
$string['uploadrenamedcollision'] = 'O ficheiro foi renomeado de  {$a->oldname} para {$a->newname} devido a um conflito no nome.';
$string['uploadserverlimit'] = 'O ficheiro enviado excedeu o limite de tamanho máximo imposto pelo servidor';
$string['uploadthisfile'] = 'Carregar este ficheiro';
$string['url'] = 'URL';
$string['used'] = 'Utilizado';
$string['usedinnplaces'] = 'Utilizado em {$a} locais';
$string['user'] = 'Utilizador';
$string['useraccount'] = 'Conta de utilizador';
$string['useractivity'] = 'Atividade';
$string['userconfirmed'] = '{$a} confirmado';
$string['userdata'] = 'Dados do utilizador';
$string['userdeleted'] = 'Este utilizador foi apagado';
$string['userdescription'] = 'Descrição';
$string['userdescription_help'] = 'Nesta caixa pode inserir algum texto sobre si que será mostrado no seu perfil quando outros utilizadores o consultarem.';
$string['userdetails'] = 'Mais detalhes';
$string['userfiles'] = 'Ficheiros do utilizador';
$string['userlist'] = 'Lista de utilizadores';
$string['usermatchedon'] = 'Este utilizador corresponde à pesquisa através do seguinte campo';
$string['usermenu'] = 'Menu do utilizador';
$string['usermenugoback'] = 'Voltar para o menu do utilizador';
$string['username'] = 'Nome de utilizador';
$string['usernameemail'] = 'Nome de utilizador ou e-mail';
$string['usernameemailmatch'] = 'O nome de utilizador e e-mail não correspondem ao mesmo utilizador';
$string['usernameexists'] = 'Este nome de utilizador já existe; escolha outro';
$string['usernamelowercase'] = 'Apenas são permitidas letras minúsculas';
$string['usernamenotfound'] = 'O nome de utilizador não foi encontrado na base de dados';
$string['usernameoremail'] = 'Introduza o nome de utilizador ou o e-mail';
$string['usernotconfirmed'] = 'Não foi possível confirmar {$a}';
$string['userpic'] = 'Foto do utilizador';
$string['userpreferences'] = 'Preferências do utilizador';
$string['users'] = 'Utilizadores';
$string['userselectorautoselectunique'] = 'Se for encontrado apenas um utilizador, selecionar automaticamente';
$string['userselectorpreserveselected'] = 'Manter os utilizadores selecionados, mesmo que já não correspondam à pesquisa';
$string['userselectorsearchanywhere'] = 'em qualquer parte';
$string['userselectorsearchexactmatchonly'] = 'apenas as exatas';
$string['userselectorsearchfromstart'] = 'desde o início';
$string['userselectorsearchmatching'] = 'Correspondência:';
$string['usersnew'] = 'Novos utilizadores';
$string['usersnoaccesssince'] = 'Utilizadores inativos há mais de';
$string['userswithfiles'] = 'Utilizadores com ficheiros';
$string['useruploadtype'] = 'Tipo de envio do utilizador: {$a}';
$string['userzones'] = 'Zonas de utilizador';
$string['usetheme'] = 'Usar tema';
$string['usingexistingcourse'] = 'Usando a disciplina existente';
$string['validatehtml'] = 'Validar HTML';
$string['valuealreadyused'] = 'Este valor já foi usado.';
$string['version'] = 'Versão';
$string['view'] = 'Ver';
$string['viewallcourses'] = 'Ver todas as disciplinas';
$string['viewallcoursescategories'] = 'Ver todas as disciplinas e categorias';
$string['viewallresults'] = 'Ver todos os resultados ({$a})';
$string['viewallsubcategories'] = 'Ver todas as subcategorias';
$string['viewfileinpopup'] = 'Ver ficheiro numa janela pop-up';
$string['viewing'] = 'Visualizar:';
$string['viewmore'] = 'Ver mais';
$string['viewprofile'] = 'Ver perfil';
$string['viewresults'] = 'Vera os resultados de {$a}';
$string['views'] = 'Visualizações';
$string['viewsolution'] = 'ver solução';
$string['visible'] = 'Visível';
$string['visible_help'] = 'Esta configuração determina se a disciplina aparece, ou não, na lista de disciplinas. Se a disciplina não estiver disponível para os alunos, apenas os utilizadores com o papel de "Professor" e/ou "Administrador" poderão aceder à disciplina.';
$string['visibletostudents'] = 'Visível para {$a}';
$string['warning'] = 'Aviso';
$string['warningdeleteresource'] = 'Advertência: {$a} é referido(a) num recurso. Quer atualizar o recurso?';
$string['wcagcheck'] = 'Verificação das Diretrizes de Acessibilidade do Conteúdo da Web (WCAG)';
$string['webpage'] = 'Página Web';
$string['week'] = 'Semana';
$string['weekhide'] = 'Ocultar esta semana a {$a}';
$string['weeklyoutline'] = 'Agenda semanal';
$string['weeks'] = 'semanas';
$string['weekshow'] = 'Mostrar esta semana a {$a}';
$string['welcomeback'] = 'Olá, {$a->firstname}! 👋';
$string['welcometocourse'] = 'Bem-vindo à página da disciplina {$a}';
$string['welcometocoursetext'] = 'Bem-vindo à disciplina {$a->coursename}!

Uma das primeiras coisas que deverá fazer é editar a sua página de perfil para que possamos conhecê-lo(a) melhor:

<a href="{$a->profileurl}">{$a->profileurl}</a>';
$string['welcometosite'] = 'Bem-vindo(a), {$a->firstname}! 👋';
$string['whatforlink'] = 'O que pretende fazer com a hiperligação?';
$string['whatforpage'] = 'O que pretende fazer com o texto?';
$string['whatisyourage'] = 'Qual é a sua idade?';
$string['whattocallzip'] = 'Qual o nome para o ficheiro Zip?';
$string['whattodo'] = 'O que fazer?';
$string['wheredoyoulive'] = 'Em que país vive?';
$string['whyisthisrequired'] = 'Porque é que isto é obrigatório?';
$string['windowclosing'] = 'Esta janela deve fechar automaticamente. Se não acontecer, por favor, feche-a manualmente.';
$string['withchosenfiles'] = 'Com os ficheiros escolhidos';
$string['withdisablednote'] = '{$a} (desativado)';
$string['withoutuserdata'] = 'sem dados de utilizador';
$string['withselectedusers'] = 'Com os utilizadores selecionados...&nbsp;';
$string['withuserdata'] = 'com os dados de utilizador';
$string['wontrunfuturescheduledtask'] = 'Não executará a tarefa que não falhou e está agendada para ser executada no futuro';
$string['wordforstudent'] = 'Aluno';
$string['wordforstudenteg'] = 'algo como Aluno, Participante, etc.';
$string['wordforstudents'] = 'Alunos';
$string['wordforstudentseg'] = 'algo como Alunos, Participantes, etc.';
$string['wordforteacher'] = 'Professor';
$string['wordforteachereg'] = 'algo como Professor, Tutor, Supervisor, etc.';
$string['wordforteachers'] = 'Professores';
$string['wordforteacherseg'] = 'algo como Professores, Tutores, Supervisores, etc.';
$string['writingblogsinfo'] = 'A escrever informação do blogue';
$string['writingcategoriesandquestions'] = 'A escrever categorias e questões';
$string['writingcoursedata'] = 'A escrever dados da disciplina';
$string['writingeventsinfo'] = 'A escrever informações de evento';
$string['writinggeneralinfo'] = 'A escrever dados gerais';
$string['writinggradebookinfo'] = 'A escrever informação da pauta';
$string['writinggroupingsgroupsinfo'] = 'A guardar informação de grupos do agrupamento';
$string['writinggroupingsinfo'] = 'A escrever informação de agrupamentos';
$string['writinggroupsinfo'] = 'A escrever informação de grupos';
$string['writingheader'] = 'A escrever o cabeçalho';
$string['writingloginfo'] = 'A escrever dados do registo';
$string['writingmessagesinfo'] = 'A escrever informação sobre mensagens';
$string['writingmoduleinfo'] = 'A escrever dados do módulo';
$string['writingscalesinfo'] = 'A escrever dados das escalas';
$string['writinguserinfo'] = 'A escrever dados dos utilizadores';
$string['wrongpassword'] = 'Senha errada para este utilizador';
$string['year'] = 'ano';
$string['years'] = 'anos';
$string['yes'] = 'Sim';
$string['youareabouttocreatezip'] = 'Está prestes a criar um ficheiro Zip contendo';
$string['youaregoingtorestorefrom'] = 'Irá restaurar de';
$string['youhaveupcomingactivitiesdue'] = 'Tem atividades com data limite próxima';
$string['youhaveupcomingactivitiesdueinfo'] = 'Olá {$a},

<br/><br/>Existem atividades com data limite para breve:';
$string['youneedtoenrol'] = 'Para poder realizar essa ação, precisa inscrever-se nesta disciplina.';
$string['yourlastlogin'] = 'A sua última autenticação foi';
$string['yourself'] = 'si próprio';
$string['yourteacher'] = 'seu {$a}';
$string['yourwordforx'] = 'Designação para "{$a}"';
$string['zippingbackup'] = 'A compactar a cópia de segurança (Zip)';
