<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lti', language 'uk', version '4.4'.
 *
 * @package     lti
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'Прийняти';
$string['accept_grades'] = 'Прийняти бали з засобу';
$string['accept_grades_admin'] = 'Прийняти бали з засобу';
$string['accept_grades_admin_help'] = 'Укажіть, чи може постачальник інструментів додавати, оновлювати, читати та видаляти оцінки, пов’язані з екземплярами цього інструмента.

Деякі постачальники інструментів підтримують звітування про оцінки в Moodle на основі дій, здійснених усередині інструменту, створюючи більш інтегрований досвід.';
$string['accept_grades_help'] = 'Вкажіть, чи може засіб постачальника додавати, оновлювати, читати та видаляти бали пов\'язані з екземплярами цього типу засобу.

Деякі постачальники засобів підтримують звітування своїх балів у Moodle, що базується на спеціальному інструментарії для тіснішої інтеграції.

Зверніть увагу, що цей параметр може бути перевизначеним в налаштуваннях засобу.';
$string['accepted'] = 'Погоджено';
$string['action'] = 'Дія';
$string['activate'] = 'Активувати';
$string['activatetoadddescription'] = 'Вам потрібно активувати цей засіб перед тим, як ви зможете додавати опис.';
$string['active'] = 'Активний';
$string['activity'] = 'Діяльність';
$string['add_ltiadv'] = 'Додайте розштрений LTI';
$string['add_ltilegacy'] = 'Додати старий LTI';
$string['addnewapp'] = 'Дозволити зовнішні програми';
$string['addserver'] = 'Додати новий довірений сервер';
$string['addtype'] = 'Додати попередньо налаштований інструмент';
$string['allow'] = 'Дозволяти';
$string['allowsetting'] = 'Дозволяти засобу зберігати 8К налаштувань в Moodle';
$string['always'] = 'Завжди';
$string['autoaddtype'] = 'Додати засіб';
$string['automatic'] = 'Автоматично, на основі URL-адреси інструменту';
$string['baseurl'] = 'Базовий URL/назва реєстрації засобу';
$string['basiclti'] = 'ЗНВ (Засіб Навчальної Взаємодії)';
$string['basiclti_base_string'] = 'Базовий рядок OAuth ЗНВ';
$string['basiclti_endpoint'] = 'Кінцевий пункт запуску ЗНВ';
$string['basiclti_in_new_window'] = 'Ваша діяльність відкрилася в новому вікні';
$string['basiclti_in_new_window_open'] = 'Відкрити в новому вікні';
$string['basiclti_parameters'] = 'Параметри запуску ЗНВ';
$string['basicltiactivities'] = 'Діяльності ЗНВ';
$string['basicltifieldset'] = 'Власний приклад налаштування';
$string['basicltiintro'] = 'Опис діяльності';
$string['basicltiname'] = 'Назва діяльності';
$string['basicltisettings'] = 'Основні налаштування Засобу Навчальної Взаємодії (ЗНВ)';
$string['cachedef_keyset'] = 'Кешує інформацію про набір ключів інструментів';
$string['cancel'] = 'Скасувати';
$string['cancelled'] = 'Скасовано';
$string['cannot_delete'] = 'Ви можете не вилучати налаштування цього засобу.';
$string['cannot_edit'] = 'Ви можете не редагувати налаштування цього засобу.';
$string['capabilities'] = 'Права';
$string['capabilities_help'] = 'Виберіть ті права, які ви хочете запропонувати для постачальника засобу. Можна вказувати кілька прав.';
$string['capabilitiesrequired'] = 'Для активації цього засобу необхідний доступ до таких даних:';
$string['cleanaccesstokens'] = 'Зовнішній інструмент видалення прострочених маркерів доступу';
$string['click_to_continue'] = '<a href="{$a->link}" target="_top">Клацніть для продовження</a>';
$string['clientidadmin'] = 'Ідентифікатор клієнта';
$string['clientidadmin_help'] = 'Ідентифікатор клієнта – це унікальне значення, яке використовується для ідентифікації інструмента. Він створюється автоматично для кожного інструмента, який використовує профіль безпеки JWT, представлений у LTI 1.3, і має бути частиною деталей, переданих постачальнику інструментів, щоб він міг налаштувати з’єднання на своєму кінці.';
$string['comment'] = 'Коментар';
$string['configpassword'] = 'Типовий пароль віддаленого засобу';
$string['configpreferheight'] = 'Типова бажана висота';
$string['configpreferwidget'] = 'Встановити віджет, як типовий запуск';
$string['configpreferwidth'] = 'Типова бажана ширина';
$string['configresourceurl'] = 'Типовий URL ресурсу';
$string['configtoolurl'] = 'Типовий URL віддаленого засобу';
$string['configtypes'] = 'Дозволити ЗНВ програми';
$string['configured'] = 'Налаштовано';
$string['confirmtoolactivation'] = 'Ви точно хочете активувати цей засіб?';
$string['contentitem_deeplinking'] = 'Підтримує глибоке посилання (повідомлення елемента вмісту)';
$string['contentitem_deeplinking_help'] = 'Якщо поставлено галочку, під час додавання зовнішнього інструмента буде доступна опція «Вибрати вміст».';
$string['contentitem_multiple_description'] = 'До вашого курсу будуть додані такі предмети:';
$string['contentitem_multiple_graded'] = 'Оцінена діяльність (максимальна оцінка: {$a})';
$string['course_tool_types'] = 'Інструменти курсу';
$string['courseactivitiesorresources'] = 'Діяльності  або ресурси курсу';
$string['courseid'] = 'Ідентифікатор курсу';
$string['courseinformation'] = 'Інформація курсу';
$string['courselink'] = 'Перейти до курсу';
$string['coursemisconf'] = 'Курс не налаштовано';
$string['createdon'] = 'Дата створення';
$string['curllibrarymissing'] = 'Для зовнішнього інструмента необхідне розширення PHP cURL.';
$string['custom'] = 'Власні параметри';
$string['custom_config'] = 'Використовується  власне налаштування засобу.';
$string['custom_help'] = 'Власні параметри установки, що використовуються засобом постачальника. Наприклад, користувацький параметр може бути використаний для відображення конкретного ресурсу від постачальника. Кожен параметр повинен бути введеним в окремому рядку використовуючи формат "name=value"; наприклад, "chapter=3".

Можна сміливо залишити це поле без змін, отримати налаштування засобу постачальником.';
$string['custominstr'] = 'Власні параметри';
$string['debuglaunch'] = 'Опція налагодження';
$string['debuglaunchoff'] = 'Нормальний запуск';
$string['debuglaunchon'] = 'Запуск налагодження';
$string['default'] = 'Типово';
$string['default_launch_container'] = 'Типовий контейнер запуску';
$string['default_launch_container_help'] = 'Ефект контейнерного запуску відображає засіб, коли запускається з курсу. Деякі контейнери запуску надають більшу площу під засіб, інші більше інтегровані з середовищем Moodle.

* **Типово** - Використовує контейнер запуску визначений в налаштуваннях засобу.
* **Вбудувати** - Засіб відображається в середині створеного вікна Moodle, аналогічно до типових діяльностей.
* **Вбудувати без блоків** - Засіб відображається в середині створеного вікна Moodle,  тільки з верхнім навігаційним меню.
* **Нове вікно** - Засіб відкривається в новому вікні, займаючи весь вільний простір. Залежно від браузера, він відкриється в новій вкладці або виринаючому вікні. Цілком можливо, що браузери будуть перешкоджати відкриттю нового вікна.';
$string['delegate'] = 'Делегувати інструктору';
$string['delegate_tool'] = 'Як зазначено у визначенні Deep Linking або Делегувати викладачу';
$string['delete'] = 'Вилучити';
$string['delete_confirmation'] = 'Ви впевнені, що хочете видалити цей попередньо налаштований інструмент?';
$string['deletetype'] = 'Видалити попередньо налаштований інструмент';
$string['display_description'] = 'Показувати опис діяльності при запуску';
$string['display_description_help'] = 'Якщо вибрано, то опис діяльності (визначений вище) буде показано над контентом засобу. Опис може бути використаний для надання додаткових інструкцій для запуску засобу, але це не обов’язково. Опис ніколи не відображається при запуску засобу в новому вікні.';
$string['display_name'] = 'Показувати назву діяльності при запуску';
$string['display_name_help'] = 'Якщо вибрано, то назву діяльності (визначену вище) буде показано над контентом засобу.

Цілком можливо, що засіб постачальника може також відображати назву. Ця опція може запобігти подвійному показу назви діяльності.

Опис ніколи не відображається при запуску засобу у новому вікні.';
$string['domain_mismatch'] = 'Домен URL-адреси інструмента не відповідає конфігурації інструмента.';
$string['donot'] = 'Не надсилати';
$string['donotaccept'] = 'Не приймати';
$string['donotallow'] = 'Не дозволяти';
$string['duplicateregurl'] = 'Такий URL реєстрації вже використовується';
$string['dynreg_update_btn_new'] = 'Зареєструйтеся як новий зовнішній інструмент';
$string['dynreg_update_btn_update'] = 'Оновлення';
$string['dynreg_update_name'] = 'Назва інструменту';
$string['dynreg_update_notools'] = 'Немає інструментів у контексті.';
$string['dynreg_update_text'] = 'Існують інструменти, приєднані до домену реєстрації. Ви хочете оновити вже встановлену зовнішній інструмент або створити новий зовнішній інструмент?';
$string['dynreg_update_url'] = 'Базовий URL';
$string['dynreg_update_version'] = 'Версія LTI';
$string['dynreg_update_warn_dupdomain'] = 'Не рекомендується мати кілька зовнішніх інструментів в одному домені.';
$string['editdescription'] = 'Клацніть тут, щоб додати запис цьому танцю';
$string['edittype'] = 'Редагувати попередньо налаштований інструмент';
$string['embed'] = 'Вбудувати';
$string['embed_no_blocks'] = 'Вбудувати без блоків';
$string['enableemailnotification'] = 'Надсилати повідомлення';
$string['enableemailnotification_help'] = 'Якщо включено, то студенти будуть отримувати на свою ел.пошту повідомлення про оцінення своєї роботи.';
$string['enterkeyandsecret'] = 'Введіть свій ключ клієнта та загальний секретний ключ';
$string['enterkeyandsecret_help'] = 'Якщо вам було надано ключ споживача та/або загальний секрет, введіть їх тут';
$string['errorbadurl'] = 'URL не є правильним URL засобу або картриджа.';
$string['errorincorrectconsumerkey'] = 'Ключ споживача неправильний.';
$string['errorinvaliddata'] = 'Недійсні дані: {$a}';
$string['errorinvalidmediatype'] = 'Недійсний тип медіа: {$a}';
$string['errorinvalidresponseformat'] = 'Недійсний формат відповіді Content-Item.';
$string['errormisconfig'] = 'Засіб не налаштовано. Будь ласка, зв’яжіться зі своїм Адміністратором, щоб він виправив помилку налаштування.';
$string['errortooltypenotfound'] = 'Тип інструменту LTI не знайдено.';
$string['existing_window'] = 'Існуюче вікно';
$string['extensions'] = 'ЗНВ Додаткові сервіси';
$string['external_tool_type'] = 'Попередньо налаштований інструмент';
$string['external_tool_type_help'] = '* **Автоматично, на основі URL-адреси інструмента** - найкраща конфігурація інструмента вибирається автоматично. Якщо URL-адреса інструменту не розпізнається, деталі конфігурації інструменту, можливо, доведеться ввести вручну. * **Спеціальний попередньо налаштований інструмент** — конфігурація інструмента для зазначеного інструмента буде використовуватися під час спілкування із зовнішнім постачальником інструментів. Якщо URL-адреса інструмента не належить постачальнику інструменту, буде показано попередження. Не завжди потрібно вводити URL-адресу інструменту. * **Спеціальна конфігурація** - ключ споживача та загальний секрет, можливо, потрібно буде ввести вручну. Ключ споживача та загальний секрет можна отримати від постачальника інструментів. Однак не всі інструменти вимагають ключа споживача та загального секрету, у цьому випадку поля можуть бути залишені пустими.

### Попередньо налаштований інструмент редагування

Після розкривного меню попередньо налаштованих інструментів доступні три значки:

* **Додати** — створити конфігурацію інструменту на рівні курсу. Усі зовнішні екземпляри інструментів у цьому курсі можуть використовувати конфігурацію інструменту. * **Редагувати** – виберіть інструмент рівня курсу зі спадного меню, а потім натисніть цю піктограму. Деталі конфігурації інструменту можна редагувати. * **Видалити** - видалити вибраний інструмент рівня курсу.';
$string['external_tool_types'] = 'Попередньо налаштовані інструменти';
$string['failedtoconnect'] = 'Moodle не дозволено спілкуватися з "{$a}"';
$string['failedtocreatetooltype'] = 'Не вдалося створити новий засіб. Будь ласка, перевірте URL та спробуйте ще раз.';
$string['failedtodeletetoolproxy'] = 'Не вдалося видалити реєстрацію засобу. Вам потрібно буде зайти до "Керування реєстраціями зовнішніх засобів" і видалити його вручну.';
$string['filter_basiclti_configlink'] = 'Налаштування бажаних сайтів та їх паролів';
$string['filter_basiclti_password'] = 'Пароль є обов\'язковим';
$string['filterconfig'] = 'Адміністрування ЗНВ';
$string['filtername'] = 'ЗНВ';
$string['fixexistingconf'] = 'Використати існуючу конфігурацію для не налаштованих варіантів';
$string['fixnew'] = 'Нове налаштування';
$string['fixnewconf'] = 'Визначити нову конфігурацію для не налаштованих варіантів';
$string['fixold'] = 'Використати існуюче';
$string['force_ssl'] = 'Примосовий SSL';
$string['force_ssl_help'] = 'Вибір цієї опції примушує при будь-якому запуску засобу провайдера використовувати SSL.

Крім того, всі веб-запити до засобу постачальника будуть використовувати протокол SSL.

Якщо ви використовуєте цю опцію, переконайтеся, що цей сайт та постачальник засобу використовують SSL.';
$string['forced_help'] = 'Цей параметр було примусово встановлено на рівні курсу або сайту. Ви не можете змінювати його через цей інтерфейс.';
$string['generaltool'] = 'Основний засіб';
$string['global_tool_types'] = 'Попередньо налаштовані інструменти';
$string['grading'] = 'Передача оцінки';
$string['icon_url'] = 'Значок URL';
$string['icon_url_help'] = 'Значок URL дозволяє спеціальне зображення в списку діяльностей курсу. Замість того, щоб використовувати стандартний значок ЗНВ, вкажіть інший, який буде найбільш відповідати вибраній діяльності.';
$string['id'] = 'Ідентифікатор';
$string['indicator:cognitivedepth'] = 'LTI: пізнавальний аспект';
$string['indicator:cognitivedepth_help'] = 'Цей показник базується на глибині пізнання, досягнутої студентом у діяльності LTI.';
$string['indicator:cognitivedepthdef'] = 'LTI когнітивний';
$string['indicator:cognitivedepthdef_help'] = 'Учасник досяг цього відсотка когнітивної активності, запропонованої діяльністю LTI протягом цього інтервалу аналізу (Рівні = Без перегляду, Перегляд, Надіслати, Переглянути відгук)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'LTI: соціальний аспект';
$string['indicator:socialbreadth_help'] = 'Цей показник базується на соціальному розширенні, досягнутому студентом у діяльності LTI.';
$string['indicator:socialbreadthdef'] = 'LTI соц';
$string['indicator:socialbreadthdef_help'] = 'Учасник досяг цього відсотка соціальної залученості, запропонованої заходами LTI протягом цього інтервалу аналізу (Рівні = Без участі, Учасник сам, Учасник з іншими)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['initiatelogin'] = 'Ініціювати URL-адресу входу';
$string['initiatelogin_help'] = 'URL-адреса інструменту, на яку мають надсилатися запити на вхід. Ця URL-адреса потрібна для того, щоб повідомлення можна було успішно надіслати інструменту.';
$string['invalidid'] = 'Неправильний ідентифікатор ЗНВ';
$string['jwtsecurity'] = 'LTI 1.3';
$string['keytype'] = 'Тип відкритого ключа';
$string['keytype_help'] = 'Метод автентифікації, який використовується для перевірки інструменту.';
$string['keytype_keyset'] = 'URL-адреса набору ключів';
$string['keytype_rsa'] = 'RSA key';
$string['launch_in_moodle'] = 'Інструмент запуску в Moodle';
$string['launch_in_popup'] = 'Запустити засіб у виринаючому вікні';
$string['launch_url'] = 'URL-адреса інструмента';
$string['launch_url_help'] = 'URL-адреса інструмента вказує веб-адресу зовнішнього інструмента та може містити додаткову інформацію, наприклад, ресурс для показу. Якщо ви не впевнені, що ввести для URL-адреси інструменту, зверніться до постачальника інструменту для отримання додаткової інформації.

Ви можете ввести URL-адресу картриджа, якщо вона у вас є, і решта деталей форми заповниться автоматично.

Якщо ви вибрали попередньо налаштований інструмент, вам може не знадобитися вводити URL-адресу інструмента. Якщо посилання на інструмент використовується лише для запуску в систему постачальника інструментів, а не перейти до певного ресурсу, ймовірно, це буде так.';
$string['launchinpopup'] = 'Запуск програми';
$string['launchinpopup_help'] = 'Ефект контейнерного запуску відображає засіб, коли запускається з курсу. Деякі контейнери запуску надають більшу площу під засіб, інші більше інтегровані з середовищем Moodle.

* **Типово** - Використовує контейнер запуску визначений в налаштуваннях засобу.
* **Вбудувати** - Засіб відображається в середині створеного вікна Moodle, аналогічно до типових діяльностей.
* **Вбудувати без блоків** - Засіб відображається в середині створеного вікна Moodle,  тільки з верхнім навігаційним меню.
* **Нове вікно** - Засіб відкривається в новому вікні, займаючи весь вільний простір. Залежно від браузера, він відкриється в новій вкладці або виринаючому вікні. Цілком можливо, що браузери будуть перешкоджати відкриттю нового вікна.';
$string['launchoptions'] = 'Параметри запуску';
$string['lti'] = 'ЗНВ';
$string['lti:addcoursetool'] = 'Додавати налаштування курсоорієнтованого засобу';
$string['lti:addinstance'] = 'Додайте новий зовнішній інструмент';
$string['lti:addmanualinstance'] = 'Додайте інструмент, налаштований вручну';
$string['lti:addpreconfiguredinstance'] = 'Додайте попередньо налаштований інструмент';
$string['lti:admin'] = 'Будьте адміністратором під час запуску інструмента';
$string['lti:grade'] = 'Бачити оцінки із зовнішніх засобів';
$string['lti:manage'] = 'Бути інструктором запущеного засобу';
$string['lti:requesttooladd'] = 'Надсилати засіб адміністратору для налаштування';
$string['lti:view'] = 'Запускати діяльності зовнішнього засобу';
$string['lti_administration'] = 'Редагувати попередньо налаштований інструмент';
$string['lti_errormsg'] = 'Засіб повернув таке повідомлення про помилку: "{$a}"';
$string['lti_launch_error'] = 'Виникла помилка в процесі запуску зовнішнього засобу:';
$string['lti_launch_error_tool_request'] = '<p> Щоб подати заявку адміністратору на налаштування засобу, натисніть <a href="{$a->admin_request_url}" target="_top">тут</a>. </p>';
$string['lti_launch_error_unsigned_help'] = '<p> Ця помилка може бути результатом відсутності ключа користувача та відкритого ключа для засобу постачальника. </p> <p>Якщо ви маєте ключ користувача та відкритий ключ, ви можете вказати їх при редагуванні зовнішнього засобу (це знаходиться в додаткових параметрах).<br />  Або ж ви можете створити на рівні курсу <a href="{$a->course_tool_editor}">налаштування засобу постачальника</a>. </p>';
$string['lti_tool_request_added'] = 'Запит на налаштування засобу прийнято. Можливо вам доведеться додатково зв’язатися з адміністратором для закінчення налаштування.';
$string['lti_tool_request_existing'] = 'Запит на налаштування такого засобу вже подано';
$string['ltisettings'] = 'Налаштування ЗНВ';
$string['ltiunknownserviceapicall'] = 'ЗНВ невідомий виклик сервісу АРІ';
$string['ltiversion'] = 'LTI version';
$string['ltiversion_help'] = 'Версія LTI, що використовується для підписання повідомлень і запитів на обслуговування: LTI 1.0/1.1 і LTI 2.0 використовують профіль безпеки OAuth 1.0A; LTI 1.3.0 використовує JWT.';
$string['main_admin'] = 'Загальна довідка';
$string['main_admin_help'] = 'Зовнішні інструменти дозволяють користувачам Moodle взаємодіяти з навчальними ресурсами, розміщеними віддалено. За допомогою спеціального протоколу запуску віддалений інструмент має доступ до загальної інформації про користувача, який запускає. Наприклад, назва навчального закладу, ідентифікатор курсу, ідентифікатор користувача та інша інформація, наприклад ім’я користувача або адреса електронної пошти.

Інструменти, перелічені на цій сторінці, розділені на три категорії:

* **Активний** – ці постачальники інструментів були схвалені та налаштовані адміністратором. Їх можна використовувати з будь-якого курсу на цьому сайті. Якщо введено ключ споживача та загальний секрет, між цим сайтом і віддаленим інструментом встановлюються довірчі відносини, що забезпечує безпечний канал зв’язку.
* **Очікує** — ці постачальники інструментів надійшли через імпорт пакетів, але не були налаштовані адміністратором. Вчителі все ще можуть використовувати інструменти від цих постачальників, якщо у них є ключ споживача та загальний секрет, або якщо вони не потрібні.
* **Відхилено** – ці постачальники інструментів позначені як такі, які адміністратор не має наміру робити доступними на сайті. Вчителі все ще можуть використовувати інструменти від цих постачальників, якщо у них є ключ споживача та загальний секрет, або якщо вони не потрібні.';
$string['manage_external_tools'] = 'Керування засобами';
$string['manage_tool_proxies'] = 'Керування реєстраціями зовнішнього засобу';
$string['manage_tools'] = 'Керуйте попередньо налаштованими інструментами';
$string['manuallyaddtype'] = 'Альтернативно в можете <a href="{$a}">налаштувати засіб вручну</a>.';
$string['miscellaneous'] = 'Різне';
$string['misconfiguredtools'] = 'Виявлено не налаштований засіб';
$string['missingparameterserror'] = 'Сторінка не налаштована: "{$a}"';
$string['module_class_type'] = 'Тип Moodle модуля';
$string['modulename'] = 'Зовнішній засіб';
$string['modulename_help'] = '<p>Діяльність <b>Зовнішній засіб</b> дозволяє інтегрувати зовнішні навчальні ресурси та діяльності з інших веб-сайтів в навчальний курс, таким чином забезпечуючи студентам просту взаємодію із матеріалами, які розміщені поза системи дистанційного навчання. Тобто, дана діяльність відкриває зовнішній ресурс безпосередньо в навчальному курсі. Постачальник таких зовнішніх засобів має підтримувати ЗНВ (Засіб Навчальної Взаємодії - Learning Tools Interoperability).</p>
<p>Відзначають ще такі особливості:</p>
<ul>
  <li>Зовнішні засоби мають доступ до інформації про користувача, який запустив цей засіб (установа, курс та ім\'я)</li>
  <li>Конфігурації зовнішніх засобів створюють довірчі відносини між вашою системою і провайдером, що забезпечує безпечний зв\'язок між ними</li>
</ul>';
$string['modulename_link'] = 'mod/lti/view';
$string['modulename_shortcut_link'] = 'mod/lti/view/custom';
$string['modulenameplural'] = 'Зовнішні засоби';
$string['modulenamepluralformatted'] = 'Зовнішні інструменти';
$string['name'] = 'Назва';
$string['never'] = 'Ніколи';
$string['new_window'] = 'Нове вікно';
$string['no_lti_configured'] = 'Немає замовлених зовнішніх засобів.';
$string['no_lti_pending'] = 'Немає відкладених зовнішніх засобів.';
$string['no_lti_rejected'] = 'Немає відхилених зовнішніх засобів';
$string['no_lti_tools'] = 'Немає налаштованих зовнішніх засобів.';
$string['no_tp_accepted'] = 'Немає погоджених реєстрацій зовнішніх засобів.';
$string['no_tp_cancelled'] = 'Немає скасованих реєстрацій зовнішніх засобів.';
$string['no_tp_configured'] = 'Немає налаштованих незареєстрованих реєстрацій зовнішніх засобів.';
$string['no_tp_pending'] = 'Немає відкладених реєстрацій зовнішніх засобів.';
$string['no_tp_rejected'] = 'Немає відхилених реєстрацій зовнішніх засобів.';
$string['noattempts'] = 'Немає активних налаштованих зовнішніх засобів.';
$string['noltis'] = 'Немає використання зовнішніх засобів';
$string['noprofileservice'] = 'Сервіс профайлу не знайдено';
$string['noservers'] = 'Не знайдено серверів';
$string['notypes'] = 'Наразі немає встановлених зовнішніх засобів у Moodle. Клацніть посилання встановлення для додавання.';
$string['noviewusers'] = 'Не знайдено користувачів з правами використання цього засобу';
$string['oauthsecurity'] = 'LTI 1.0/1.1';
$string['opensslconfiginvalid'] = 'LTI 1.3 вимагає, щоб дійсний файл openssl.cnf був налаштований і доступний для вашого веб-сервера. Зверніться до адміністратора сайту, щоб налаштувати та ввімкнути openssl для цього сайту.';
$string['optionalsettings'] = 'Додаткові налаштування';
$string['organization'] = 'Деталі організації';
$string['organizationdescr'] = 'Опис організації';
$string['organizationid_default'] = 'Ідентифікатор організації за замовчуванням';
$string['organizationid_default_help'] = 'Значення за замовчуванням для ідентифікатора організації. Ідентифікатор сайту ідентифікує цю інсталяцію Moodle.';
$string['organizationidguid'] = 'Ідентифікатор організації';
$string['organizationidguid_help'] = 'Унікальний ідентифікатор для цього екземпляра Moodle передається інструменту як GUID екземпляра платформи.

Якщо це поле залишити порожнім, буде використано значення за замовчуванням.';
$string['organizationurl'] = 'URL організації';
$string['organizationurl_help'] = 'Базовий URL цієї інсталяції Moodle.

Якщо це поле залишити порожнім, то як значення буде використано варіант з конфігурації сайту.';
$string['pagesize'] = 'Подання показано посторінково';
$string['parameter'] = 'Параметри засобу';
$string['parameter_help'] = 'Параметри засобу налаштовують запит для передачі постачальнику засобу через доступний проксі засобу.';
$string['password'] = 'Відкритий ключ';
$string['password_admin'] = 'Відкритий ключ';
$string['password_admin_help'] = 'Відкритий ключ можна розглядати як пароль для аутентифікації доступу до засобу. Він повинен бути наданим разом із ключем користувача від постачальника засобу.

Засоби, які не вимагають безпечного зв\'язку з Moodle і не передбачають додаткових послуг (наприклад, звіт оцінювання) можуть не вимагати відкритого ключа.';
$string['password_help'] = 'Для попередньо налаштованого засобу не потрібно вводити тут загальний секретний ключ. Він буде заданий в процесі налаштування.

Це поле повинно бути заповненим, якщо створюється посилання на засіб, який ще не налаштовано. Якщо засіб буде застосовуватися більше одного разу в цьому курсі, то є сенс додати в курс конфігурацію цього засобу.

Загальний ключ можна розглядати як пароль для доступу до засобу. Він повинен бути наданим постачальником засобу разом з абонентським ключем.

Застосунки, які не потребують безпечного зв’язку з Moodle та не надають додаткові послуги (такі як звіти про оцінки) можуть не потребувати загального ключа.';
$string['pending'] = 'В очікуванні';
$string['pluginadministration'] = 'Зовнішнє адміністрування інструментів';
$string['pluginname'] = 'Зовнішній інструмент';
$string['preferheight'] = 'Бажана висота';
$string['preferwidget'] = 'Бажаний віджет запуску';
$string['preferwidth'] = 'Бажана ширина';
$string['press_to_submit'] = 'Натисніть для запуску цієї діяльності';
$string['privacy'] = 'Секретність';
$string['privacy:metadata:coursefullname'] = 'Повна назва курсу, з якого користувач отримує доступ до споживача LTI';
$string['privacy:metadata:courseid'] = 'Ідентифікатор курсу, з якого користувач отримує доступ до споживача LTI';
$string['privacy:metadata:courseidnumber'] = 'Ідентифікаційний номер курсу, з якого користувач отримує доступ до споживача LTI';
$string['privacy:metadata:courseshortname'] = 'Коротка назва курсу, з якого користувач отримує доступ до LTI Consumer';
$string['privacy:metadata:createdby'] = 'Користувач, який створив запис';
$string['privacy:metadata:email'] = 'Адреса електронної пошти користувача, який отримує доступ до Споживача LTI';
$string['privacy:metadata:externalpurpose'] = 'Споживач LTI надає інформацію про користувача та контекст Постачальнику інструментів LTI.';
$string['privacy:metadata:firstname'] = 'Ім’я користувача, який отримує доступ до споживача LTI';
$string['privacy:metadata:fullname'] = 'Повне ім’я користувача, який отримує доступ до споживача LTI';
$string['privacy:metadata:lastname'] = 'Прізвище користувача, який отримує доступ до споживача LTI';
$string['privacy:metadata:lti_submission'] = 'Подання LTI';
$string['privacy:metadata:lti_submission:datesubmitted'] = 'Мітка часу, яка вказує, коли було зроблено подання';
$string['privacy:metadata:lti_submission:dateupdated'] = 'Позначка часу, яка вказує, коли подання було змінено';
$string['privacy:metadata:lti_submission:gradepercent'] = 'Оцінка для користувача у відсотках';
$string['privacy:metadata:lti_submission:originalgrade'] = 'Оригінальна оцінка для користувача';
$string['privacy:metadata:lti_submission:userid'] = 'Ідентифікатор користувача, який подав активність LTI';
$string['privacy:metadata:lti_tool_proxies'] = 'Проксі LTI';
$string['privacy:metadata:lti_tool_proxies:name'] = 'Ім’я проксі-сервера LTI';
$string['privacy:metadata:lti_types'] = 'Типи LTI';
$string['privacy:metadata:lti_types:name'] = 'Назва типу LTI';
$string['privacy:metadata:role'] = 'Роль у курсі для користувача, який отримує доступ до споживача LTI';
$string['privacy:metadata:timecreated'] = 'Час створення запису';
$string['privacy:metadata:timemodified'] = 'Час зміни запису';
$string['privacy:metadata:userid'] = 'Ідентифікатор користувача, який отримує доступ до споживача LTI';
$string['privacy:metadata:useridnumber'] = 'Ідентифікаційний номер користувача, який отримує доступ до споживача LTI';
$string['privacy:metadata:username'] = 'Ім’я користувача, який отримує доступ до споживача LTI';
$string['publickey'] = 'Відкритий ключ';
$string['publickey_help'] = 'Відкритий ключ (у форматі PEM), наданий інструментом, щоб дозволити перевіряти підписи вхідних повідомлень і запитів на обслуговування.';
$string['publickeyset'] = 'Відкритий набір ключів';
$string['publickeyset_help'] = 'Відкритий набір ключів, з якого цей сайт отримає відкритий ключ інструмента, щоб дозволити перевірку підписів вхідних повідомлень і запитів на обслуговування.';
$string['quickgrade'] = 'Дозволити швидке оцінювання';
$string['quickgrade_help'] = 'Якщо дозволено, то можна проводити оцінювання багатьох студентів на одній сторінці. Проставте бали та прокоментуйте їх, а потім натисніть кнопку "Зберегти", щоб всі зміни вступили в силу.';
$string['redirect'] = 'Ви будете перенаправлені за кілька секунд. Якщо цього не сталося, натисніть кнопку.';
$string['redirectionuris'] = 'URI переспрямування';
$string['redirectionuris_help'] = 'Список URI (по одному на рядок), які інструмент використовує під час надсилання запитів на авторизацію. Принаймні одне з них має бути зареєстровано, перш ніж повідомлення може бути успішно надіслано інструменту.';
$string['register'] = 'Реєстрація';
$string['register_warning'] = 'Сторінка реєстрації, здається, не відкривається. Якщо він не з’являється, переконайтеся, що ви ввели правильну URL-адресу в налаштуваннях конфігурації. Якщо Moodle використовує https, переконайтеся, що інструмент, який ви налаштовуєте, підтримує https і ви використовуєте https в URL-адресі.';
$string['registertype'] = 'Налаштувати нову реєстрацію зовнішнього засобу';
$string['registration_options'] = 'Опції реєстрації';
$string['registrationname'] = 'Назва постачальника засобу';
$string['registrationname_help'] = 'Введіть назву постачальника зареєстрованого засобу.';
$string['registrationurl'] = 'URL реєстрації';
$string['registrationurl_help'] = 'URL реєстрації повинен бути доступним від постачальника засобу  в якості місця, до якого надсилається запит реєстрації.';
$string['reject'] = 'Відхилити';
$string['rejected'] = 'Відхилено';
$string['resource'] = 'Ресурс';
$string['resourcekey'] = 'Ключ користувача';
$string['resourcekey_admin'] = 'Ключ користувача';
$string['resourcekey_admin_help'] = 'Абонентський ключ можна розглядати як ім’я користувача,яке використовується для ідентифікації доступу до засобу. Він може бути використаним постачальником засобу для однозначної ідентифікації сайту Moodle, з якого користувач запускає засіб.

Абонентський ключ повинен надаватися постачальником засобу. Спосіб отримання абонентського ключа залежить від постачальника засобу. Це може бути автоматизований процес, або він може потребувати діалогу з постачальником засобу.

Засоби, які не потребують безпечного зв’язку з Moodle та не надають додаткових послуг (такі як звіти про оцінки) можуть не потребувати ключа ресурсу.';
$string['resourcekey_help'] = 'Для попередньо налаштованих засобів не потрібно вводити тут ключ ресурсу. Його буде задано в процесі налаштування як абонентський ключ.

Це поле повинно бути заповнено, якщо створюється посилання на засіб, який ще не налаштовано. Якщо засіб буде застосовуватися більше одного разу в цьому курсі, то є сенс додати в курс конфігурацію цього засобу.

Ключ користувача можна розглядати як ім’я користувача, яке використовується для аутентифікації доступу до засобу. Він може бути використаним постачальником засобу для однозначної ідентифікації сайту Moodle, з якого користувач запускає засіб.

Ключ користувача надається постачальником засобу. Спосіб отримання абонентського ключа залежить від постачальника засобу. Це може бути автоматизованим процесом, або він може вимагати діалогу з постачальником засобу.

Засоби, які не потребують безпечного зв’язку з Moodle та не надають додаткові послуги (такі як звіти про оцінки) можуть не потребувати ключа ресурсу.';
$string['resourceurl'] = 'URL ресурсу';
$string['return_to_course'] = 'Для повернення до курсу <a href="{$a->link}" target="_top">клацніть тут</a>.';
$string['saveallfeedback'] = 'Зберегти';
$string['search:activity'] = 'Зовнішній засіб - інформація про діяльність';
$string['secure_icon_url'] = 'URL значка безпечного запуску';
$string['secure_icon_url_help'] = 'Подібна до URL-адреси значка, але використовується, коли доступ до сайту здійснюється безпечно через SSL. Це поле призначене для запобігання відображенню браузером попередження про незахищене зображення.';
$string['secure_launch_url'] = 'Захищена URL-адреса інструменту';
$string['secure_launch_url_help'] = 'Подібна до URL-адреси інструмента, але використовується замість URL-адреси інструмента, якщо потрібна висока безпека. Moodle використовуватиме захищену URL-адресу інструменту замість URL-адреси інструменту, якщо доступ до сайту Moodle здійснюється через SSL або якщо конфігурація інструменту налаштована на завжди запуск через SSL.

URL-адресу інструменту також можна встановити на адресу https, щоб примусово запускати через SSL, і це поле можна залишити порожнім.';
$string['selectcontent'] = 'Виберіть вміст';
$string['send'] = 'Надіслати';
$string['services'] = 'Сервіси';
$string['services_help'] = 'Виберіть ті сервіси, які ви хочете надати постачальнику засобу. Можна вибрати кілька сервісів.';
$string['setupoptions'] = 'Параметри установки';
$string['share_email'] = 'Показувати адресу ел.пошти користувача, який запускає засіб.';
$string['share_email_admin'] = 'Показувати адресу ел.пошти користувача, який запускає засіб.';
$string['share_email_admin_help'] = 'Чи показувати адресу ел.пошти користувача, який запускає засіб? Вона буде використовуватися постачальником засобу. Постачальнику засобу може знадобитися ел.пошта запускаючої адреси, щоб розрізняти користувачів з однаковими іменами, або відправляти користувачу на пошту інструкції по роботі з цим засобом.';
$string['share_email_help'] = 'Чи показувати адресу ел.пошти користувача, який запускає засіб? Вона буде використовуватися постачальником засобу. Постачальнику засобу може знадобитися ел.пошта запускаючої адреси, щоб розрізняти користувачів з однаковими іменами, або відправляти користувачу на пошту інструкції по роботі з цим засобом.

Зверніть увагу, що цей параметр може бути перевизначеним в налаштуваннях засобу.';
$string['share_name'] = 'Показувати ім’я користувача, який запускає засіб.';
$string['share_name_admin'] = 'Визначити повне ім’я користувача, який запускає засіб';
$string['share_name_admin_help'] = 'Чи визначати ім’я користувача, який запускає засіб? Воно буде використовуватися постачальником засобу. Постачальники можуть вимагати ім’я користувача, щоб відобразити додаткову інформацію при роботі засобу.';
$string['share_name_help'] = 'Чи визначати ім’я користувача, який запускає засіб? Воно буде використовуватися постачальником засобу. Постачальники можуть вимагати ім’я користувача, щоб відобразити додаткову інформацію при роботі засобу.

Зверніть увагу, що цей параметр може бути перевизначеним в налаштуваннях засобу.';
$string['share_roster'] = 'Дозволити засобу доступ до реєстру курсів';
$string['share_roster_admin'] = 'Засіб має доступ до реєстру курсу';
$string['share_roster_admin_help'] = 'Укажіть, чи може інструмент отримати доступ до списку користувачів, зареєстрованих на курсах, з яких запускається цей інструмент.';
$string['share_roster_help'] = 'Визначає, чи буде цей засіб мати доступ до списку зареєстрованих користувачів на курсі.

Зверніть увагу, що цей параметр може бути перевизначеним в налаштуваннях засобу.';
$string['show_in_course_activity_chooser'] = 'Показати у виборі діяльності та як попередньо налаштований засіб';
$string['show_in_course_lti1'] = 'Показати при створенні елементів';
$string['show_in_course_lti1_help'] = 'Цей інструмент може відображатися в засобі вибору діяльності, щоб учитель вибрав, щоб додати його до курсу. Крім того, він може відображатися у спадному меню попередньо налаштованих інструментів під час додавання зовнішнього інструменту до курсу. Ще один варіант — використовувати конфігурацію інструменту, лише якщо введено точну URL-адресу інструмента під час додавання зовнішнього інструмента до курсу.';
$string['show_in_course_lti2'] = 'Показати при створенні елементів';
$string['show_in_course_lti2_help'] = 'Цей інструмент можна відобразити в засобі вибору діяльності, який викладач може вибрати для додавання до курсу, або у спадному меню попередньо налаштованих інструментів під час додавання зовнішнього інструменту до курсу.';
$string['show_in_course_no'] = 'Не показуй; використовувати лише тоді, коли введено відповідну URL-адресу інструменту';
$string['show_in_course_preconfigured'] = 'Показати як попередньо налаштований засіб при додаванні зовнішнього засобу';
$string['sitehost'] = 'Ім\'я хоста сайту';
$string['siteid'] = 'Ідентифікатор сайту';
$string['size'] = 'Параметри розміру';
$string['submission'] = 'Подання';
$string['submissions'] = 'Подання';
$string['submissionsfor'] = 'Подання для  {$a}';
$string['subplugintype_ltiresource'] = 'Ресурс сервісу ЗНВ';
$string['subplugintype_ltiresource_plural'] = 'Ресурси сервісу ЗНВ';
$string['subplugintype_ltiservice'] = 'Сервіс ЗНВ';
$string['subplugintype_ltiservice_plural'] = 'Сервіси ЗНВ';
$string['subplugintype_ltisource'] = 'Джерело ЗНВ';
$string['subplugintype_ltisource_plural'] = 'Джерела ЗНВ';
$string['successfullycreatedtooltype'] = 'Новий засіб успішно створено!';
$string['successfullyfetchedtoolconfigurationfromcontent'] = 'Успішно отримано конфігурацію інструменту з вибраного вмісту.';
$string['toggle_debug_data'] = 'Перемикнути дані налагодження';
$string['tool_config_not_found'] = 'Налаштування засобу не знайдено за цим URL.';
$string['tool_settings'] = 'Налаштування засобу';
$string['tooldescription'] = 'Опис засобу';
$string['tooldescription_help'] = 'Опис засобу, який буде показуватися викладачам у списку діяльностей.

Він повинен описувати для чого призначено цей засіб, що він робить та мати додаткову інформацію, яку потрібно знати викладачу.';
$string['tooldetailsaccesstokenurl'] = 'URL маркера доступу';
$string['tooldetailsauthrequesturl'] = 'URL-адреса запиту на автентифікацію';
$string['tooldetailsclientid'] = 'Ідентифікатор клієнта';
$string['tooldetailsdeploymentid'] = 'Ідентифікатор розгортання';
$string['tooldetailsmailtosubject'] = 'Конфігурація інструменту LTI';
$string['tooldetailsmodalemail'] = 'Електронна пошта';
$string['tooldetailsmodallink'] = 'Переглянути деталі конфігурації';
$string['tooldetailsmodaltitle'] = 'Деталі конфігурації інструменту';
$string['tooldetailsplatformid'] = 'Ідентифікатор платформи';
$string['tooldetailspublickeyseturl'] = 'URL-адреса набору відкритих ключів';
$string['toolisbeingused'] = 'Цей засіб було використано {$a} раз';
$string['toolisnotbeingused'] = 'Цей засіб ще не використовувався';
$string['toolproxy'] = 'Реєстрації зовнішнього засобу';
$string['toolproxy_help'] = 'Реєстрація зовнішніх інструментів дозволяє адміністраторам сайту Moodle налаштовувати зовнішні інструменти з проксі-сервера, отриманого від постачальника інструментів, що підтримує LTI 2.0. URL-адреса реєстрації, надана постачальником інструментів, — це все, що потрібно для початку процесу. Можливості та послуги, які пропонуються постачальнику інструментів, вибираються під час налаштування нової реєстрації.

Реєстрації інструментів, перелічені на цій сторінці, розділені на чотири категорії:

* **Налаштовано** — Реєстрацію цих інструментів налаштовано, але процес реєстрації ще не розпочато.
* **Очікує на розгляд** – процес реєстрації для цих реєстрацій інструментів розпочато, але не завершено. Відкрийте та збережіть налаштування, щоб перемістити його повернутися до категорії «Налаштовані».
* **Прийнято** — ці реєстрації інструментів схвалено; ресурси, зазначені в проксі-сервері інструмента, з’являться на сторінці попередньо налаштованих інструментів з початковим статусом «Очікує на розгляд».
* **Відхилено** – це реєстрації інструментів, які були відхилені під час процесу реєстрації. Відкрийте та збережіть налаштування, щоб перемістити його повернутися до категорії «Налаштовані», щоб можна було перезапустити процес реєстрації.';
$string['toolproxyregistration'] = 'Реєстрація зовнішнього засобу';
$string['toolregistration'] = 'Реєстрація зовнішнього засобу';
$string['toolsetup'] = 'Конфігурація зовнішнього засобу';
$string['tooltypeadded'] = 'Додано попередньо налаштований засіб';
$string['tooltypedeleted'] = 'Вилучено попередньо налаштований засіб';
$string['tooltypenotdeleted'] = 'Не вдається вилучити попередньо налаштований засіб';
$string['tooltypes'] = 'Засоби';
$string['tooltypeupdated'] = 'Оновлено попередньо налаштований засіб';
$string['toolurl'] = 'URL-адреса інструмента';
$string['toolurl_contentitemselectionrequest'] = 'URL-адреса вибору вмісту';
$string['toolurl_contentitemselectionrequest_help'] = 'URL-адреса вибору вмісту використовуватиметься для запуску сторінки вибору вмісту від постачальника інструментів. Якщо він порожній, буде використана URL-адреса інструмента';
$string['toolurl_help'] = 'URL-адреса інструмента використовується для відповідності URL-адрес інструментів правильної конфігурації інструмента.

Додавання префіксу http(s) до URL-адреси необов’язкове. Крім того, базова URL-адреса використовується як URL-адреса інструмента, якщо URL-адреса інструменту не вказана в зовнішньому екземплярі інструмента.

Наприклад, базова URL-адреса *tool.com* відповідатиме такому:

* tool.com
* tool.com/quizzes
* tool.com/quizzes/quiz.php?id=10
* www.tool.com/quizzes

Базова URL-адреса *www.tool.com/quizzes* відповідатиме такому:
* www.tool.com/quizzes
* tool.com/quizzes
* tool.com/quizzes/take.php?id=10

Базова URL-адреса *quiz.tool.com* відповідатиме такому:

* quiz.tool.com
* quiz.tool.com/take.php?id=10

Якщо дві різні конфігурації інструментів призначені для одного домену, буде використано найбільш конкретне збіг.

Ви також можете вставити URL-адресу картриджа, якщо вона у вас є, і деталі інструменту будуть автоматично заповнені.';
$string['toolurlplaceholder'] = 'URL засобу...';
$string['typename'] = 'Назва засобу';
$string['typename_help'] = 'Ім’я інструменту використовується для ідентифікації постачальника інструментів у Moodle. Введене ім’я буде видно викладачам під час додавання зовнішніх інструментів у курси.';
$string['types'] = 'Типи';
$string['unabletocreatetooltype'] = 'Не вдається створити засіб';
$string['unabletofindtooltype'] = 'Не вдається створити засіб для {$a->id}';
$string['unknownstate'] = 'Невідомий стан';
$string['update'] = 'Оновити';
$string['useraccountinformation'] = 'Інформація обліковки користувача';
$string['userpersonalinformation'] = 'Персональна інформація користувача';
$string['using_tool_cartridge'] = 'Використання картриджа засобу';
$string['using_tool_configuration'] = 'Використовувати конфігурацію засобу:';
$string['validurl'] = 'Правильна адреса повинна починатися з http(s)://';
$string['viewsubmissions'] = 'Екран перегляду зданих завдань та оцінок';
