<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'backup', language 'tr', version '4.4'.
 *
 * @package     backup
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['asyncbackupcomplete'] = 'Yedekleme işlemi tamamlandı';
$string['asyncbackupcompletebutton'] = 'Devam et';
$string['asyncbackupcompletedetail'] = 'Yedekleme işlemi başarıyla tamamlandı. <br/> Yedeklemeye <a href="{$a}">geri yükleme sayfasından</a> erişebilirsiniz.';
$string['asyncbackuperror'] = 'Yedekleme işlemi başarısız oldu';
$string['asyncbackuperrordetail'] = 'Yedekleme işlemi başarısız oldu. Lütfen sistem yöneticinize başvurun.';
$string['asyncbackuppending'] = 'Yedekleme işlemi beklemede';
$string['asyncbackupprocessing'] = 'Yedekleme devam ediyor';
$string['asyncbadexecution'] = 'Hatalı yedekleme denetleyicisi yürütmesi. {$a} ve 2 olmalıdır.';
$string['asynccheckprogress'] = 'İlerlemeyi istediğiniz zaman <a href="{$a}">geri yükleme sayfasından</a> kontrol edebilirsiniz.';
$string['asyncemailenable'] = 'Bildirimleri etkinleştirin';
$string['asyncemailenabledetail'] = 'Etkinleştirilirse, eşzamansız yedekleme veya geri yükleme tamamlandığında kullanıcılar bir bildirim alır.';
$string['asyncgeneralsettings'] = 'Eşzamansız yedekleme / geri yükleme';
$string['asyncmessagebody'] = 'Bildirim';
$string['asyncmessagebodydefault'] = '{operation} (Kimlik: {backupid}) başarıyla tamamlandı. <br/> <br/> Buradan erişebilirsiniz<a href="{link}">{link}</a>.';
$string['asyncmessagebodydetail'] = 'Eşzamansız yedekleme veya geri yükleme tamamlandığında gönderilecek bildirim.';
$string['asyncmessagesubject'] = 'Konu';
$string['asyncmessagesubjectdefault'] = 'Moodle {operation} başarıyla tamamlandı';
$string['asyncmessagesubjectdetail'] = 'Bildirim Konusu';
$string['asyncnowait'] = 'İşlem arka planda devam edeceği için burada beklemenize gerek yok.';
$string['asyncprocesspending'] = 'İşlem beklemede';
$string['asyncrestorecomplete'] = 'Geri yükleme işlemi tamamlandı';
$string['asyncrestorecompletebutton'] = 'Devam et';
$string['asyncrestorecompletedetail'] = 'Geri yükleme işlemi başarıyla tamamlandı. Devam\'ı tıklamak sizi <a href="{$a}">geri yüklenen öğeye ilişkin derse</a> götürür.';
$string['asyncrestoreerror'] = 'Geri yükleme işlemi başarısız oldu';
$string['asyncrestoreerrordetail'] = 'Geri yükleme işlemi başarısız oldu. Lütfen sistem yöneticinize başvurun.';
$string['asyncrestoreinprogress'] = 'Devam eden geri yüklemeler';
$string['asyncrestoreinprogress_help'] = 'Devam etmekte olan asenkron kurs geri yüklemeleri burada gösterilmektedir.';
$string['asyncrestorepending'] = 'Geri yükleme işlemi beklemede';
$string['asyncrestoreprocessing'] = 'Geri yükleme devam ediyor';
$string['asyncreturn'] = 'Kursa dön';
$string['autoactivedescription'] = 'Otomatik yedeklemelerin yapılıp yapılmamasını seçin. El ile otomatik yedeklemeler otomatik yedekleme CLI komut dosyası ile mümkün olacak seçildiğinde. Bu komut satırında ya da cron aracılığıyla el ile olarak yapılabilir.';
$string['autoactivedisabled'] = 'Devre dışı';
$string['autoactiveenabled'] = 'Etkin';
$string['autoactivemanual'] = 'Manuel';
$string['automatedbackupschedule'] = 'Zamanlama';
$string['automatedbackupschedulehelp'] = 'Otomatik yedeklemelerin haftanın hangi günlerinde yapılacağını seçin.';
$string['automatedbackupsinactive'] = 'Zamanlanmış yedeklemeler site yöneticisi tarafından henüz etkinleştirilmemiş';
$string['automatedbackupstatus'] = 'Zamanlanmış yedekleme durumu';
$string['automateddeletedays'] = 'Bundan daha eski yedekleri sil';
$string['automatedmaxkept'] = 'Tutulan maksimum yedekleme sayısı';
$string['automatedmaxkepthelp'] = 'Bu, her bir kurs için tutulması gereken son otomatik yedeklemelerin maksimum sayısını belirtir. Eski yedekler otomatik olarak silinir.';
$string['automatedminkept'] = 'Tutulan minimum yedekleme sayısı';
$string['automatedminkepthelp'] = 'Belirli bir gün sayısından daha eski yedekler silinirse, etkin olmayan bir dersin yedekleme olmaksızın sona erdiği ortaya çıkabilir. Bunu önlemek için en az sayıda yedekleme belirtilmelidir.';
$string['automatedsettings'] = 'Zamanlanmış yedekleme ayarları';
$string['automatedsetup'] = 'Otomatik yedekleme kurulumu';
$string['automatedstorage'] = 'Otomatik yedekleme';
$string['automatedstoragehelp'] = 'Otomatik oluşturulan yedeklerin depolanacağı konumu seçiniz';
$string['backupactivity'] = 'Etkinliği yedekle :  {$a}';
$string['backupautoactivitiesdescription'] = 'Etkinlikleri bir yedeklemeye dahil etmek için varsayılanı ayarlar. Geri dönüşüm kutusunun çalışması için bu ayarın etkinleştirilmesi gerekir.';
$string['backupcourse'] = 'Kursu yedekle :  {$a}';
$string['backupcoursedetails'] = 'Kurs Ayrıntıları';
$string['backupcoursesection'] = 'Bölüm :  {$a}';
$string['backupcoursesections'] = 'Kurs bölümleri';
$string['backupdate'] = 'Alınan tarih';
$string['backupdetails'] = 'Yedekleme ayrıntıları';
$string['backupdetailsnonstandardinfo'] = 'Belirli bir gün sayısından daha eski yedekler silinirse, etkin olmayan bir kursun yedekleme olmaksızın sona erdiği ortaya çıkabilir. Bunu önlemek için en az sayıda yedekleme belirtilmelidir.';
$string['backupfile'] = 'Yedek dosyası';
$string['backupformat'] = 'Biçim';
$string['backupformatimscc1'] = 'IMS Ortak Kartuş 1.0';
$string['backupformatimscc11'] = 'IMS Ortak Kartuş 1.1';
$string['backupformatmoodle1'] = 'Moodle 1';
$string['backupformatmoodle2'] = 'Moodle 2';
$string['backupformatunknown'] = 'Bilinmeyen biçim';
$string['backuplog'] = 'Teknik bilgi ve uyarılar';
$string['backupmode'] = 'Kip';
$string['backupmode10'] = 'Genel';
$string['backupmode20'] = 'İçe aktar';
$string['backupmode30'] = 'Merkez';
$string['backupmode40'] = 'Aynı site';
$string['backupmode50'] = 'Otomatik';
$string['backupmode60'] = 'Dönüştürülmüş';
$string['backupmode70'] = 'Eşzamansız';
$string['backupsection'] = 'Kurs yedekleme bölümü : {$a}';
$string['backupsettings'] = 'Yedekleme ayarları';
$string['backupsitedetails'] = 'Site ayrıntıları';
$string['backupstage16action'] = 'Devam et';
$string['backupstage1action'] = 'Sonraki';
$string['backupstage2action'] = 'Sonraki';
$string['backupstage4action'] = 'Yedek al';
$string['backupstage8action'] = 'Devam et';
$string['backupthenrestore'] = 'Yedekleme tamamlandı.  Geri yüklemeye başlayın';
$string['backuptype'] = 'Tür';
$string['backuptypeactivity'] = 'Etkinllik';
$string['backuptypecourse'] = 'Kurs';
$string['backuptypesection'] = 'Bölüm';
$string['backupversion'] = 'Yedek sürümü';
$string['cannotfindassignablerole'] = 'Yedeklemede {$a} rolü, atamaya sahip olduğunuz hiç bir rol için oluşturulamıyor.';
$string['choosefilefromactivitybackup'] = 'Etkinlik yedekleme alanı';
$string['choosefilefromactivitybackup_help'] = 'Bu etkinlik için dosyaları yedekleyin.';
$string['choosefilefromautomatedbackup'] = 'Otomatik yedeklemeler';
$string['choosefilefromautomatedbackup_help'] = 'Yedekleme dosyaları otomatik olarak oluşturulur.';
$string['choosefilefromcoursebackup'] = 'Kurs yedekleme bölümü';
$string['choosefilefromcoursebackup_help'] = 'Bu kurs için yedekleme dosyaları.';
$string['choosefilefromuserbackup'] = 'Kullancı mahremiyeti temelli yedekleme alanı';
$string['choosefilefromuserbackup_help'] = 'Tüm kurslar için anonimleştirilmiş kullanıcı bilgileri içeren mahrem yedekleme dosyaları.';
$string['config_keep_groups_and_groupings'] = 'Varsayılan değer olarak grup ve gruplamaları dahil et.';
$string['config_keep_roles_and_enrolments'] = 'Varsayılan değer olarak geçerli rol ve kursa üyelik kayıtlarını dahil et.';
$string['config_overwrite_conf'] = 'Kullanıcının geçerli kurs ayarlarını değiştirmesine izin ver.';
$string['config_overwrite_course_fullname'] = 'Varsayılan değer olarak, kursun tam adı yerine yedekleme dosyasındaki adı yaz. Bu ayar \'Kurs ayarının üzerine yaz\' seçeneğinin devrede olmasını ve kullanıcının kursun tam adını değiştirme yetkisinin (moodle/course:changefullname) bulunmasını gerektirir.';
$string['config_overwrite_course_shortname'] = 'Varsayılan değer olarak, kursun kısa adı yerine yedekleme dosyasındaki adı yaz. Bu ayar \'Kurs ayarının üzerine yaz\' seçeneğinin devrede olmasını ve kullanıcının kursun kısa adını değiştirme yetkisinin (moodle/course:changeshortname) bulunmasını gerektirir.';
$string['config_overwrite_course_startdate'] = 'Varsayılan değer olarak, kursun başlama tarihi yerine yedekleme dosyasındaki tarihi yaz. Bu ayar \'Kurs ayarının üzerine yaz\' seçeneğinin devrede olmasını ve kullanıcının geri yükleme anında kursun tarihlerini değiştirme yetkisinin  (moodle/restore:rolldates) bulunmasını gerektirir.';
$string['configgeneralactivities'] = 'Etkinlikleri yedeklemeye dahil etmek için varsayılan ayarları oluşturur.';
$string['configgeneralanonymize'] = 'Etkinse kullanıcılara ait tüm bilgiler varsayılan olarak anonim olacaktır.';
$string['configgeneralbadges'] = 'Rozet yedeklemelerini varsayılan olarak ayarlar.';
$string['configgeneralblocks'] = 'Engelleme yedeklemelerini varsayılan olarak ayarlar.';
$string['configgeneralcalendarevents'] = 'Takvim etkinliklerini bir yedeklemeye dahil etmek için varsayılan değeri ayarlar.';
$string['configgeneralcomments'] = 'Yorum yedeklemelerini varsayılan olarak ayarlar.';
$string['configgeneralcompetencies'] = 'Bir yedeklemede yetkinliklerin eklenmesi için varsayılan değeri ayarlar.';
$string['configgeneralcontentbankcontent'] = 'İçerik bankası içeriğini bir yedeklemeye dahil etmek için varsayılanı ayarlar.';
$string['configgeneralcustomfield'] = 'Bir yedeklemeye özel alanları dahil etmek için varsayılanı ayarlar.';
$string['configgeneralfiles'] = 'Dosyaları yedeklemeye dahil etmek için varsayılanı ayarlar. Lütfen dikkat: Bu ayarın devre dışı bırakılması, yalnızca dosyalara referanslar içeren bir yedeklemeyle sonuçlanacaktır. Yedekleme aynı sitede geri yüklendiyse ve dosyalar \'Çöp havuzu dosyalarını temizle\' ayarına göre silinmediyse bu bir sorun oluşturmaz (dosya temizleme süresi).';
$string['configgeneralfilters'] = 'Filtreleri bir yedeklemeye dahil etmek için varsayılanı ayarlar.';
$string['configgeneralgroups'] = 'Yedeklemeye gruplar ve gruplar eklemek için varsayılan değeri ayarlar.';
$string['configgeneralhistories'] = 'Kullanıcı geçmişi yedeklemelerini varsayılan olarak ayarlar.';
$string['configgenerallogs'] = 'Etkinleştirilirse girişler varsayılan olarak yedeklenir.';
$string['configgeneralpermissions'] = 'Etkinleştirilirse, rol izinleri içe aktarılacaktır. Bu, kayıtlı kullanıcılar için mevcut izinleri geçersiz kılabilir.';
$string['configgeneralquestionbank'] = 'Etkinleştirildiğinde, soru bankası varsayılan olarak yedeklemelere dahil edilir. LÜTFEN DİKKAT: Bu ayarı devre dışı bırakmak, quiz gibi soru bankasını kullanan etkinliklerin yedeklenmesini devre dışı bırakır.';
$string['configgeneralroleassignments'] = 'Varsayılan olarak etkinleştirilirse, atamalar da yedeklenir.';
$string['configgeneralusers'] = 'Kullanıcıların yedeklemelere dahil edilip edilmeyeceğini belirler.';
$string['configgeneraluserscompletion'] = 'Etkinleştirilirse, kullanıcı tamamlama bilgileri varsayılan olarak yedeklemelere dahil edilir.';
$string['configgeneralxapistate'] = 'Kullanıcının durumunu bir yedeklemede H5P etkinlikleri gibi içeriğe dahil etmek için varsayılan değeri ayarlar.';
$string['configlegacyfiles'] = 'Eski kurs dosyalarını bir yedeklemeye dahil etmek için varsayılanı ayarlar. Eski kurs dosyaları, 2.0\'dan önceki Moodle sürümlerindendir.';
$string['configloglifetime'] = 'Bu, yedekleme günlükleri bilgilerini tutmak istediğiniz süreyi belirtir. Bu yaştan eski olan kayıtlar otomatik olarak silinir. Yedekleme kaydedilen bilgiler büyük olabileceğinden, bu değeri küçük tutmanız önerilir.';
$string['configrestoreactivities'] = 'Etkinlikleri geri yükleme için varsayılan değerleri belirler.';
$string['configrestorebadges'] = 'Rozetleri geri yükleme için varsayılan değerleri belirler.';
$string['configrestoreblocks'] = 'Blokları geri yükleme için varsayılan değerleri belirler.';
$string['configrestorecalendarevents'] = 'Takvim etkinliklerini geri yükleme için varsayılan değerleri belirler.';
$string['configrestorecomments'] = 'Yorumları geri yükleme için varsayılan değerleri belirler.';
$string['configrestorecompetencies'] = 'Yetkinlikleri geri yükleme için varsayılan değerleri belirler.';
$string['configrestorecontentbankcontent'] = 'İçerik bankası içeriğini geri yüklemek için varsayılanı ayarlar.';
$string['configrestorecustomfield'] = 'Özel alanları geri yüklemek için varsayılanı ayarlar.';
$string['configrestoreenrolments'] = 'Kayıt yöntemlerini geri yükleme için varsayılan değerleri belirler.';
$string['configrestorefilters'] = 'Filtreleri geri yükleme için varsayılan değerleri belirler.';
$string['configrestoregroups'] = 'Yedeklemeye dahil edildilerse gruplar ve gruplamaları  geri yükleme için varsayılan değerleri belirler.';
$string['configrestorehistories'] = 'Yedeklemeye dahil edildiyse kullanıcı geçmişini  geri yükleme için varsayılan değerleri belirler.';
$string['configrestorelogs'] = 'Yedeklemeye dahil edildilerse, tutulmuş kayıtlar varsayılan değer olarak geri yüklenir.';
$string['configrestorepermissions'] = 'Etkinleştirilirse, rol izinleri geri yüklenecektir. Bu, kayıtlı kullanıcılar için mevcut izinleri geçersiz kılabilir.';
$string['configrestoreroleassignments'] = 'Varsayılan değer olarak devreye sokulduysa, rol atamaları eğer yedeklemeye dahil edilmişlerse geri yüklenir.';
$string['configrestoreusers'] = 'Yedeklemeye dahil edildilerse, kullanıcıların geri yüklenip yüklenmeyeceği hakkında varsayılan değeri belirler.';
$string['configrestoreuserscompletion'] = 'Devreye sokulursa, yedeklemeye dahil edildiyse kullanıcı tamamlama bilgileri geri yüklenir.';
$string['configrestorexapistate'] = 'H5P etkinlikleri gibi içeriklerde kullanıcının durumunu geri yüklemek için varsayılanı ayarlar.';
$string['confirmcancel'] = 'Yedeklemeden çık';
$string['confirmcancelimport'] = 'İçe aktarmayı iptal et';
$string['confirmcancelno'] = 'İptal etme';
$string['confirmcancelquestion'] = 'Şimdi çıkarsanız girdiğiniz bilgiler silinecek. Çıkmak istediğinize emin misiniz?';
$string['confirmcancelrestore'] = 'Geri yüklemeyi iptal et';
$string['confirmcancelyes'] = 'Yedeklemeyi iptal et';
$string['confirmnewcoursecontinue'] = 'Yeni kurs uyarısı';
$string['confirmnewcoursecontinuequestion'] = 'Kurs yenileme işlemi tarafından geçici (gizli) bir kurs oluşturulacaktır. Restorasyonu durdurmak için iptal\'i tıklayın. Geri yüklerken tarayıcıyı kapatmayın.';
$string['copiesinprogress'] = 'Bu kursun devam eden kopyalama işlemi mevcut. <a href="{$a}"> Devam eden kopyaları görüntüleyin. </a>';
$string['copycoursedesc'] = 'Herhangi bir kurs kategorisinde bu kursun bir kopyasını oluşturun.';
$string['copycourseheading'] = 'Kursu kopyalayın';
$string['copycoursetitle'] = 'Kursu kopyala:  {$a}';
$string['copydest'] = 'Hedef';
$string['copyfieldnotfound'] = 'Alan(lar) için gerekli alan verileri bulunamadı: {$a}';
$string['copyformfail'] = 'Kurs kopya formunun AJAX gönderimi başarısız oldu.';
$string['copyingcourse'] = 'Kurs kopyalama devam ediyor';
$string['copyingcourseshortname'] = 'kopyalama';
$string['copyop'] = 'Şu anki işlem';
$string['copyprogressheading'] = 'Kurs kopyama süreci devam ediyor';
$string['copyprogressheading_help'] = 'Bu tablo, tamamlanmamış tüm kurs kopyalarınızın durumunu gösterir.';
$string['copyprogresstitle'] = 'Kurs kopyalama ilerlemesi';
$string['copyreturn'] = 'Kopyala ve iade et';
$string['copysource'] = 'Kaynak';
$string['copyview'] = 'Kopyala ve görüntüle';
$string['coursecategory'] = 'Kursun geri yükleneceği kategori';
$string['courseid'] = 'Orjinal ID';
$string['coursesettings'] = 'Kurs ayarları';
$string['coursetitle'] = 'Başlık';
$string['currentstage1'] = 'Başlangıç ayarları';
$string['currentstage16'] = 'Tam';
$string['currentstage2'] = 'Şema ayarları';
$string['currentstage4'] = 'Onaylama ve yeniden gözden geçirme';
$string['currentstage8'] = 'Yedek al';
$string['enableasyncbackup'] = 'Eşzamansız yedeklemeleri etkinleştirin';
$string['enableasyncbackup_help'] = 'Etkinleştirilirse, yedekleme ve geri yükleme işlemleri eşzamansız olarak yapılır. Bu, kullanıcıların bir yedekleme veya geri yükleme devam ederken başka işlemler yapmasına olanak tanıyan daha iyi bir kullanıcı deneyimi sağlar. Bu, içe ve dışa aktarmaları etkilemez.';
$string['enterasearch'] = 'Arama yap';
$string['error_block_for_module_not_found'] = 'Kurs modülü (kimlik: {$a->mid}) için yetersiz blok örneği (kimlik: {$a->bid}) bulundu. Bu blok yedeklenmeyecek';
$string['error_course_module_not_found'] = 'Yetim kurs modülü (id: {$a}) bulundu. Bu modül yedeklenmeyecektir.';
$string['errorcopyingbackupfile'] = 'Geri yüklemeden önce yedek dosyanın geçici klasöre kopyalanamadı.';
$string['errorfilenamemustbezip'] = 'Girdiğiniz dosya adı, .mbz uzantısına sahip bir ZIP dosyasına ait olmalıdır';
$string['errorfilenamerequired'] = 'Bu yedek için geçerli bir dosya adı girmelisiniz';
$string['errorfilenametoolong'] = 'Dosya adı 255 karakterden kısa olmalıdır.';
$string['errorinvalidformat'] = 'Bilinmeyen yedekleme biçimi';
$string['errorinvalidformatinfo'] = 'Seçilen dosya geçerli bir Moodle yedekleme dosyası değil, yeniden yüklenemez.';
$string['errorminbackup20version'] = 'Bu yedekleme dosyası Moodle yedeklemesinin bir geliştirme sürümüyle oluşturuldu ({$a->backup}). Gerekli minimum {$a-> min}. Geri yüklenemez.';
$string['errorrestorefrontpagebackup'] = 'Site ana sayfası yedeklerini yalnızca site ana sayfasında geri yükleyebilirsiniz';
$string['executionsuccess'] = 'Yedekleme dosyası başarı ile oluşturuldu';
$string['extractingbackupfileto'] = 'Yedekleme dosyası şuraya çıkarılıyor: {$a}';
$string['failed'] = 'Yedekleme başarısız oldu';
$string['filealiasesrestorefailures'] = 'Takma adları başarısızlıkları geri yükle';
$string['filealiasesrestorefailures_help'] = 'Takma adlar, harici depolarda saklananlar da dahil olmak üzere diğer dosyalara sembolik bağlantılardır. Bazı durumlarda, Moodle bunları geri yükleyemez - örneğin yedeklemeyi başka bir sitede geri yüklerken veya başvurulan dosya yok olduğunda.

Daha fazla bilgi ve hatanın gerçek nedeni geri yükleme günlük dosyasında bulunabilir.';
$string['filealiasesrestorefailures_link'] = 'restore/filealiases';
$string['filealiasesrestorefailuresinfo'] = 'Yedekleme dosyasına dahil edilen bazı takma adlar geri yüklenemedi. Aşağıdaki liste, beklenen konumunu ve orijinal sitede atıfta bulunduğu kaynak dosyayı içerir.';
$string['filename'] = 'Dosya adı';
$string['filereferencesincluded'] = 'Harici içeriklerle ilgili dosya referansları yedek dosyaya dahildir. Yedekleme farklı bir sitede geri yüklenirse bu işe yaramaz.';
$string['filereferencesnotsamesite'] = 'Yedekleme dosyası farklı bir siteden olduğu için dosya referansları geri yüklenemez.';
$string['filereferencessamesite'] = 'Yedek dosya bu sitedendir ve bu nedenle dosya referansları geri yüklenebilir.';
$string['generalactivities'] = 'Etkinlikleri ve kaynakları dahil et';
$string['generalanonymize'] = 'Bilgileri anonimleştir';
$string['generalbackdefaults'] = 'Genel yedekleme varsayılanları';
$string['generalbadges'] = 'Rozetleri içerir';
$string['generalblocks'] = 'Engellemeleri dahil et';
$string['generalcalendarevents'] = 'Takvim etkinliklerini dahil et';
$string['generalcomments'] = 'Yorumları dahil et';
$string['generalcompetencies'] = 'Yetkinlikleri dahil et';
$string['generalcontentbankcontent'] = 'İçerik bankası içeriğini dahil et';
$string['generalcustomfield'] = 'Özel alanları dahil edin';
$string['generalenrolments'] = 'Kayıt olma yöntemlerini dahil et';
$string['generalfiles'] = 'Dosyaları dahil et';
$string['generalfilters'] = 'Filtreleri dahil et';
$string['generalgradehistories'] = 'Geçmişi dahil et';
$string['generalgroups'] = 'grupları ve gruplaşmaları içerir';
$string['generalhistories'] = 'Geçmişi dahil et';
$string['generallegacyfiles'] = 'Eski kurs dosyalarını dahil et';
$string['generallogs'] = 'Kayıtları dahil et';
$string['generalpermissions'] = 'İzin geçersiz kılmalarını dahil et';
$string['generalquestionbank'] = 'Soru bankasını dahil et';
$string['generalrestoredefaults'] = 'Geri yükleme için varsayılan genel değerler';
$string['generalrestoresettings'] = 'Geri yükleme için genel ayarlar';
$string['generalroleassignments'] = 'Rol atamalarını dahil et';
$string['generalsettings'] = 'Genel yedekleme ayarları';
$string['generalusers'] = 'Kullanıcıları dahil et';
$string['generaluserscompletion'] = 'Kullanıcı tamamlama bilgilerini dahil et';
$string['generalxapistate'] = 'H5P etkinlikleri gibi içeriğe kullanıcının durumunu dahil edin';
$string['hidetypes'] = 'Tip seçeneklerini gizle';
$string['importbackupstage16action'] = 'Devam et';
$string['importbackupstage1action'] = 'Sonraki';
$string['importbackupstage2action'] = 'Sonraki';
$string['importbackupstage4action'] = 'İçe aktar';
$string['importbackupstage8action'] = 'Devam et';
$string['importcurrentstage0'] = 'Kurs seçimi';
$string['importcurrentstage1'] = 'Başlangıç ayarları';
$string['importcurrentstage16'] = 'Tam';
$string['importcurrentstage2'] = 'Şema ayarları';
$string['importcurrentstage4'] = 'Onaylama ve yeniden gözden geçirme';
$string['importcurrentstage8'] = 'İçe aktar';
$string['importfile'] = 'Bir yedekleme dosyasını yükle';
$string['importfromccmidtocourse'] = 'Cmid:{$a->srccmid}\'den kursa:{$a->dstcourseid} aktarın';
$string['importfromcoursetocourse'] = ':{$a->srccourseid} kursundan:{$a->dstcourseid} kursuna aktarın';
$string['importgeneralduplicateadminallowed'] = 'Yönetici çakışması çözümlemesine izin ver';
$string['importgeneralduplicateadminallowed_desc'] = 'Site, kullanıcı adı \'admin\' olan bir hesaba sahipse, kullanıcı adı \'admin\' olan bir hesabı içeren bir yedek dosyayı geri yüklemeye çalışmak çakışmaya neden olabilir. Bu ayar etkinleştirilirse, çakışma, yedek dosyadaki kullanıcı adını \'admin_xyz\' olarak değiştirerek çözülür.';
$string['importgeneralmaxresults'] = 'İçe aktarma için listelenebilecek maksimum kurs sayısı';
$string['importgeneralmaxresults_desc'] = 'Bu, içe aktarma işleminin ilk adımında listelenen kursların sayısını denetler';
$string['importgeneralsettings'] = 'Genel içeri aktarma varsayılanları';
$string['importrootsettings'] = 'Ayarları içe aktar';
$string['importsettings'] = 'Genel içe aktarma ayarları';
$string['importsuccess'] = 'İçe aktarma tamamlandı. Kursa dönmek için devam a tıklayınız.';
$string['includeactivities'] = 'Dahil et';
$string['includeditems'] = 'Dahile edilen öğeler:';
$string['includefilereferences'] = 'Harici içerikler için dosya referansları';
$string['includesection'] = 'Bölüm {$a}';
$string['includeuserinfo'] = 'Kullanıcı verisi';
$string['inprogress'] = 'Yedekleme devam ediyor';
$string['jumptofinalstep'] = 'son adıma git';
$string['keep'] = 'Dahil et';
$string['keptroles'] = 'Rol kayıtlarını dahil et';
$string['keptroles_help'] = 'Seçilen rollere sahip kullanıcılar yeni kursa kaydedilecektir. "Kullanıcı verilerini dahil et" etkinleştirilmediği sürece hiçbir kullanıcı verisi kopyalanmayacaktır.';
$string['locked'] = 'Kilitli';
$string['lockedbyconfig'] = 'Bu ayar varsayılan yedekleme ayarları tarafından kilitlendi';
$string['lockedbyhierarchy'] = 'Bağımlılıklar tarafından engellendi';
$string['lockedbypermission'] = 'Bu ayarı değiştirme yetkiniz bulunmuyor';
$string['loglifetime'] = 'için kayıtları tut';
$string['managefiles'] = 'Yedekleme dosyalarını yönet';
$string['managefiles_activity'] = 'Etkinlik yedeklerini yönetin';
$string['managefiles_automated'] = 'Otomatik yedeklemeleri yönetin';
$string['managefiles_backup'] = 'Mahrem yedeklemeleri yönet';
$string['managefiles_course'] = 'Kurs yedeklerini yönet';
$string['mergerestoredefaults'] = 'Başka bir kursa katıştırırken varsayılan değerleri geri yükle';
$string['missingfilesinpool'] = 'Bazı dosyalar yedekleme sırasında kaydedilemedi ve bu nedenle bunları geri yüklemek mümkün olmayacak.';
$string['module'] = 'Modül';
$string['moodleversion'] = 'Moodle sürümü';
$string['morecoursesearchresults'] = 'İlk {$a} sonuç gösteren {$a} kurs bulundu';
$string['moreresults'] = 'Çok fazla sonuç söz konusu, lütfen daha özel bir sorgu yapınız.';
$string['nomatchingcourses'] = 'Görüntülenecek kurs yok';
$string['norestoreoptions'] = 'Geriyüklenebilecek bir kategori ya da  kurs bulunmuyor.';
$string['originalwwwroot'] = 'Yedekleme adresi';
$string['overwrite'] = 'Üzerine yaz';
$string['pendingasyncdeletedetail'] = 'Bu kursun asenkron yedeklemesi beklemede. <br/> Bu yedekleme bitene kadar kurslar silinemez.';
$string['pendingasyncdetail'] = 'Eşzamansız yedeklemeler, bir kullanıcının aynı anda bir kaynak için yalnızca bir bekleyen yedeklemesine sahip olmasına izin verir. <br/> Aynı kaynağın birden çok eşzamansız yedeklemesi sıraya alınamaz, çünkü bu muhtemelen aynı içeriğe sahip birden çok yedeklemeyle sonuçlanır.';
$string['pendingasyncedit'] = 'Bu kurs için bekleyen bir yedekleme veya kopya talebi var. Lütfen bu işlem tamamlanana kadar kursu düzenlemeyin.';
$string['pendingasyncerror'] = 'Bu kaynak için yedekleme beklemede';
$string['preparingdata'] = 'Veri hazırlanıyor';
$string['preparingui'] = 'Görüntüleme sayfası hazırlanıyor';
$string['previousstage'] = 'Önceki';
$string['privacy:metadata:backup:detailsofarchive'] = 'Bu arşiv, notlar, kullanıcı kayıtları ve etkinlik verileri gibi bir kursla ilgili çeşitli kullanıcı verilerini içerebilir.';
$string['privacy:metadata:backup:externalpurpose'] = 'Bu arşivin amacı, ileride geri yüklenebilecek bir kursla ilgili bilgileri saklamaktır.';
$string['privacy:metadata:backup_controllers'] = 'Yedekleme işlemlerinin listesi';
$string['privacy:metadata:backup_controllers:itemid'] = 'Kurs kimliği';
$string['privacy:metadata:backup_controllers:operation'] = 'Gerçekleştirilen işlem, örn. onarmak.';
$string['privacy:metadata:backup_controllers:timecreated'] = 'Eylemin oluşturulduğu zaman';
$string['privacy:metadata:backup_controllers:timemodified'] = 'Eylemin değiştirildiği zaman';
$string['privacy:metadata:backup_controllers:type'] = 'Üzerinde çalışılan öğenin türü, ör. etkinlik.';
$string['qcategory2coursefallback'] = 'Başlangıçta yedekleme dosyasındaki sistem / kurs kategorisi içeriğindeki "{$a->name}" sorusu kategorisi, kurs içeriğinde geri yükleme ile oluşturulacaktır';
$string['qcategorycannotberestored'] = '"{$a->name}" sorusu kategorisi, geri yükleme tarafından oluşturulamaz';
$string['question2coursefallback'] = 'Başlangıçta yedekleme dosyasındaki sistem / kurs kategorisi içeriğindeki "{$a->name}" sorusu kategorisi, kurs içeriğinde geri yükleme ile oluşturulacaktır';
$string['questioncannotberestored'] = '"{$a->name}" soruları, geri yükleme tarafından oluşturulamaz';
$string['recyclebin_desc'] = 'Bu ayarların geri dönüşüm kutusu için de kullanılacağını unutmayın.';
$string['replacerestoredefaults'] = 'İçeriği silerek başka bir kursa geri yüklerken varsayılan değerleri geri yükle';
$string['restoreactivity'] = 'Etkinliği geri yükle';
$string['restorecourse'] = 'Kurs geri yükle';
$string['restorecoursesettings'] = 'Kurs ayarları';
$string['restoredcourseid'] = 'Kurs kimliği geri yüklendi: {$a}';
$string['restoreexecutionsuccess'] = 'Kursu başarıyla geri yüklendi.';
$string['restorefileweremissing'] = 'Yedekleme içindeki bazı dosyalar eksik oldukları için geri yüklenemedi.';
$string['restorenewcoursefullname'] = 'Yeni kurs adı';
$string['restorenewcourseshortname'] = 'Yeni kursun kısa adı';
$string['restorenewcoursestartdate'] = 'Yeni başlama tarihi';
$string['restorenofilesbackuparea'] = 'Henüz yedek dosya yok.';
$string['restorenofilesbackuparea_activity'] = 'Bu etkinlik için henüz yedek dosya yok.';
$string['restorenofilesbackuparea_automated'] = 'Henüz otomatik yedekleme dosyası yok.';
$string['restorenofilesbackuparea_backup'] = 'Henüz mahrem yedekleme dosyanız yok';
$string['restorenofilesbackuparea_course'] = 'Bu kurs için henüz yedek dosya yok.';
$string['restorerolemappings'] = 'Rol ayarlamalarını geri yükle';
$string['restorerootsettings'] = 'Ayarları eski haline getir';
$string['restoresection'] = 'Geri yükleme böümü';
$string['restorestage1'] = 'Onayla';
$string['restorestage16'] = 'Yeniden gözden geçir';
$string['restorestage16action'] = 'Geri yükle';
$string['restorestage1action'] = 'Sonraki';
$string['restorestage2'] = 'Hedef';
$string['restorestage2action'] = 'Sonraki';
$string['restorestage32'] = 'İşlem';
$string['restorestage32action'] = 'Devam et';
$string['restorestage4'] = 'Ayarlar';
$string['restorestage4action'] = 'Sonraki';
$string['restorestage64'] = 'Tamamlandı';
$string['restorestage64action'] = 'Devam et';
$string['restorestage8'] = 'Şema';
$string['restorestage8action'] = 'Sonraki';
$string['restoretarget'] = 'Geri yükleme hedefi';
$string['restoretocourse'] = 'Kursa geri yükle:';
$string['restoretocurrentcourse'] = 'Bu kursa yeniden yükleyin';
$string['restoretocurrentcourseadding'] = 'Yedek kursu bu kursla birleştirin';
$string['restoretocurrentcoursedeleting'] = 'Bu kursa ait verileri sil ve geri yüklemeyi yap';
$string['restoretoexistingcourse'] = 'Mevcut bir kursa geri yükle';
$string['restoretoexistingcourseadding'] = 'Yedek kursu mevcut kursla birleştir';
$string['restoretoexistingcoursedeleting'] = 'Mevcut kursun içeriğini sildikten sonra kursu geri yükle';
$string['restoretonewcourse'] = 'Yeni bir kurs olarak yeniden yükle';
$string['restoringcourse'] = 'Kurs geri yükleniyor';
$string['restoringcourseshortname'] = 'geri yükleniyor';
$string['rootenrolmanual'] = 'Elle atanmış rol atamalarını geri yükle';
$string['rootsettingactivities'] = 'Etkinlikleri ve kaynakları dahil et';
$string['rootsettinganonymize'] = 'Kullanıcı bilgileri anonimleştir';
$string['rootsettingbadges'] = 'Rozetleri dahil et';
$string['rootsettingblocks'] = 'Engellemeleri dahil et';
$string['rootsettingcalendarevents'] = 'Takvim etkinliklerini dahil et';
$string['rootsettingcomments'] = 'Yorumları dahil et';
$string['rootsettingcompetencies'] = 'Yetkinlikleri dahil et';
$string['rootsettingcontentbankcontent'] = 'İçerik bankası içeriğini dahil et';
$string['rootsettingcustomfield'] = 'Özel alanları dahil et';
$string['rootsettingenrolments'] = 'Kayıt olma yöntemlerini dahil et';
$string['rootsettingenrolments_always'] = 'Evet, her zaman';
$string['rootsettingenrolments_never'] = 'Hayır, kullnıcıları elle kayıt olarak geri yükle';
$string['rootsettingenrolments_withusers'] = 'Evet, ama yalnızca eğer kullanıcılar dahil edildiyse';
$string['rootsettingfiles'] = 'Dosyaları dahil et';
$string['rootsettingfilters'] = 'Filtreleri dahil et';
$string['rootsettinggradehistories'] = 'Not geçmişini dahil et';
$string['rootsettinggroups'] = 'Grupları ve gruplamaları dahil et';
$string['rootsettingimscc1'] = 'IMS Ortak Kartuş 1.0\'a dönüştürün';
$string['rootsettingimscc11'] = 'IMS Ortak Kartuş 1.1\'e dönüştürün';
$string['rootsettinglegacyfiles'] = 'Eski kurs dosyalarını dahil et';
$string['rootsettinglogs'] = 'Kurs günlüklerini dahil et';
$string['rootsettingpermissions'] = 'Geçersiz kılma izinlerini dahil et';
$string['rootsettingquestionbank'] = 'Soru bankasını dahil et';
$string['rootsettingroleassignments'] = 'Kullanıcı rol atamalarını dahil et';
$string['rootsettings'] = 'Yedekleme ayarları';
$string['rootsettingusers'] = 'Kayıtlı kullanıcıları dahil et';
$string['rootsettinguserscompletion'] = 'Kullanıcı tamamlama ayrıntılarını içersin';
$string['rootsettingxapistate'] = 'H5P etkinlikleri gibi içeriğe kullanıcının durumunu dahil edin';
$string['samesitenotification'] = 'Bu yedekleme, dosyaların kendisine değil, yalnızca dosyalara referansla oluşturuldu. Geri yükleme yalnızca bu sitede çalışacaktır.';
$string['sectionactivities'] = 'Etkinlikler';
$string['sectioninc'] = 'Yedeklemeye yapıldı (kullanıcı bilgisi yok)';
$string['sectionincanduser'] = 'Kullanıcı bilgileri ile yedekleme yapıldı';
$string['selectacategory'] = 'Bir kategori seçin';
$string['selectacourse'] = 'Bir kurs seçin';
$string['setting_course_fullname'] = 'Kurs adı';
$string['setting_course_shortname'] = 'Kurs kısa adı';
$string['setting_course_startdate'] = 'Kurs başlama tarihi';
$string['setting_keep_groups_and_groupings'] = 'Mevcut grup ve gruplanmaları sakla';
$string['setting_keep_roles_and_enrolments'] = 'Mevcut görev ve gruplanmaları sakla';
$string['setting_overwrite_conf'] = 'Kurs ayarlarının üzerine yaz';
$string['setting_overwrite_course_fullname'] = 'Kurs tam adının üzerine yaz';
$string['setting_overwrite_course_shortname'] = 'Kurs kısa adının üzerine yaz';
$string['setting_overwrite_course_startdate'] = 'Kurs başlangıç tarihinin üzerine yaz';
$string['showtypes'] = 'Tip seçeneklerini göster';
$string['sitecourseformatwarning'] = 'Bu bir anasayfa yedekidir, yalnızca anasayfada geri yükleyebildiğini unutmayın';
$string['skiphidden'] = 'Gizlenmiş kursları atla';
$string['skiphiddenhelp'] = 'Gizli kursları atlayıp atlamayacağınızı seçin';
$string['skipmodifdays'] = 'Şu tarihten beri değiştirilmemiş kursları atla :';
$string['skipmodifdayshelp'] = 'Birkaç günden beri değiştirilmemiş kursları atlamayı seçin';
$string['skipmodifprev'] = 'Önceki yedeklemeden bu yana değiştirilmemiş kursları atla';
$string['skipmodifprevhelp'] = 'Son otomatik yedeklemeden bu yana değiştirilmemiş kursların atlanıp atlanmayacağını seçin. Bunun için günlük kaydının etkinleştirilmesi gerekir.';
$string['status'] = 'Durum';
$string['storagecourseandexternal'] = 'Kurs yedekleme dosyası alanı ve belirtilen dizin';
$string['storagecourseonly'] = 'Kurs yedekleme alanı';
$string['storageexternalonly'] = 'Otomatik yedekleme için belirtilen dizin';
$string['successful'] = 'Yedekleme başarılı';
$string['successfulcopy'] = 'Kopyalama başarılı';
$string['successfulrestore'] = 'Geri yükleme başarılı';
$string['timetaken'] = 'Geçen süre';
$string['title'] = 'Başlık';
$string['totalcategorysearchresults'] = 'Toplam kategori : {$a}';
$string['totalcoursesearchresults'] = 'Toplam kurs: {$a}';
$string['undefinedrolemapping'] = 'Rol eşlemesi \'{$a}\' arketipi için tanımsız.';
$string['unnamedsection'] = 'İsimlendirilmemiş bölüm';
$string['userdata'] = 'Kullanıcı verilerini dahil et';
$string['userdata_help'] = 'Etkinleştirilirse, forum gönderileri, ödev gönderimleri vb. gibi veriler, \'Rol kayıtlarını dahil et\' bölümünde seçilen bir role sahip tüm kullanıcılar için yeni kursa kopyalanacaktır.';
$string['userinfo'] = 'Kullanıcı bilgisi';
