<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lti', language 'tr', version '4.4'.
 *
 * @package     lti
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'Kabul et';
$string['accept_grades'] = 'Araçtan notları kabul et';
$string['accept_grades_admin'] = 'Araçtan notları kabul et';
$string['accept_grades_admin_help'] = 'Araç sağlayıcının bu aracın örnekleriyle ilişkili notları ekleyip ekleyemeyeceğini, güncelleyip güncelleyemeyeceğini, okuyup okuyamayacağını ve silip silemeyeceğini belirleyin.

Bazı araç sağlayıcıları, araç içinde gerçekleştirilen eylemlere dayalı olarak notların Moodle\'a geri bildirilmesini destekleyerek daha bütünleşik bir
deneyim.';
$string['accept_grades_from_tool'] = 'Not defterine not eklemek için {$a} öğesine izin ver';
$string['accept_grades_help'] = 'Araç sağlayıcının yalnızca bu harici araç örneğiyle ilişkili notları ekleyip ekleyemeyeceğini, güncelleyip güncelleyemeyeceğini, okuyup okuyamayacağını ve silip silemeyeceğini belirtin.

Bazı araç sağlayıcıları, araç içerisinde gerçekleştirilen eylemlere dayalı olarak notların Moodle\'a geri bildirilmesini destekleyerek daha entegre bir deneyim oluşturur.

Bu ayarın araç yapılandırmasında geçersiz kılınabileceğini unutmayın.';
$string['accepted'] = 'Kabul edildi';
$string['action'] = 'Eylem';
$string['activate'] = 'Etkinleştir';
$string['activatetoadddescription'] = 'Bir açıklama ekleyebilmeniz için önce bu aracı etkinleştirmeniz gerekecek.';
$string['active'] = 'Etkin';
$string['activity'] = 'Etkinlik';
$string['add_ltiadv'] = 'LTI Avantajı Ekleyin';
$string['add_ltilegacy'] = 'Eski LTI Ekle';
$string['addnewapp'] = 'Harici uygulamayı etkinleştir';
$string['addserver'] = 'Yeni güvenilir sunucu ekle';
$string['addtool'] = 'Araç ekle';
$string['addtype'] = 'Önceden yapılandırılmış araç ekle';
$string['allow'] = 'Kabul';
$string['allowsetting'] = 'Aracın Moodle\'da 8K ayar saklamasına izin ver';
$string['always'] = 'Her zaman';
$string['autoaddtype'] = 'Araç ekle';
$string['automatic'] = 'Araç URL\'sine göre otomatik';
$string['baseurl'] = 'Temel URL/araç kayıt adı';
$string['basiclti'] = 'LTI';
$string['basiclti_base_string'] = 'LTI OAuth temel dizesi';
$string['basiclti_endpoint'] = 'LTI başlatma bitiş noktası';
$string['basiclti_in_new_window'] = 'Etkinliğiniz yeni bir pencerede açıldı';
$string['basiclti_in_new_window_open'] = 'Yeni pencerede aç';
$string['basiclti_parameters'] = 'LTI başlatma parametreleri';
$string['basicltiactivities'] = 'LTI faaliyetleri';
$string['basicltifieldset'] = 'Özel örnek alan kümesi';
$string['basicltiintro'] = 'Etkinlik açıklaması';
$string['basicltiname'] = 'Etkinlik adı';
$string['basicltisettings'] = 'Temel Öğrenme Aracı Birlikte Çalışabilirliği (LTI) ayarları';
$string['cachedef_keyset'] = 'Araçların tuş takımı bilgilerini önbelleğe alır';
$string['cancel'] = 'İptal';
$string['cancelled'] = 'Vazgeçildi';
$string['cannot_delete'] = 'Bu araç yapılandırmasını silemezsiniz.';
$string['cannot_edit'] = 'Bu araç yapılandırmasını düzenleyemezsiniz.';
$string['capabilities'] = 'Yetenekler';
$string['capabilities_help'] = 'Araç sağlayıcısına sunmak istediğiniz yetenekleri seçin. Birden fazla yetenek seçilebilir.';
$string['capabilitiesrequired'] = 'Bu araç, etkinleştirmek için aşağıdaki verilere erişim gerektirir:';
$string['cleanaccesstokens'] = 'Süresi dolmuş erişim belirteçlerinin harici araçla kaldırılması';
$string['click_to_continue'] = '<a href="{$a->link}" target="_top">Devam etmek için tıklayın</a>';
$string['clientidadmin'] = 'Müşteri Kimliği';
$string['clientidadmin_help'] = 'İstemci kimliği, bir aracı tanımlamak için kullanılan benzersiz bir değerdir.  LTI 1.3\'te tanıtılan JWT güvenlik profilini kullanan her araç için otomatik olarak oluşturulur ve sonunda bağlantıyı yapılandırabilmeleri için araç sağlayıcısına iletilen ayrıntıların bir parçası olmalıdır.';
$string['comment'] = 'Yorum';
$string['configpassword'] = 'Varsayılan uzak araç parolası';
$string['configpreferheight'] = 'Varsayılan tercih edilen yükseklik';
$string['configpreferwidget'] = 'Bileşeni varsayılan başlatma olarak ayarla';
$string['configpreferwidth'] = 'Varsayılan tercih edilen genişlik';
$string['configresourceurl'] = 'Varsayılan kaynak URL\'si';
$string['configtoolurl'] = 'Varsayılan uzak araç URL\'si';
$string['configtypes'] = 'LTI uygulamalarını etkinleştirin';
$string['configured'] = 'Yapılandırılmış';
$string['confirmtoolactivation'] = 'Bu aracı etkinleştirmek istediğinizden emin misiniz?';
$string['contentitem_deeplinking'] = 'Derin Bağlantıyı Destekler (İçerik Öğesi Mesajı)';
$string['contentitem_deeplinking_help'] = 'İşaretlenirse, harici bir araç eklerken \'İçerik seç\' seçeneği kullanılabilir olacaktır.';
$string['contentitem_multiple_description'] = 'Aşağıdaki öğeler kursunuza eklenecektir:';
$string['contentitem_multiple_graded'] = 'Not verilen etkinlik (Maksimum not: {$a})';
$string['contentselected'] = 'Seçilen içerik';
$string['course_tool_types'] = 'Kurs araçları';
$string['courseactivitiesorresources'] = 'Kurs etkinlikleri veya kaynakları';
$string['courseexternaltooladd'] = 'Yeni Harici LTI aracı ekleme';
$string['courseexternaltooladdsuccess'] = '{$a} eklendi.';
$string['courseexternaltooledit'] = 'Düzenle {$a}';
$string['courseexternaltooleditsuccess'] = 'Değişiklikler kaydedildi';
$string['courseexternaltooliconalt'] = '{$a} simgesi';
$string['courseexternaltools'] = 'LTI Harici araçlar';
$string['courseexternaltoolsinfo'] = 'Harici LTI araçları kursunuza entegre edebileceğiniz interaktif içerik veya değerlendirmeler gibi eklenti uygulamalardır. Öğrencileriniz kursunuzdan ayrılmadan bunlara erişebilir ve kullanabilir.';
$string['courseexternaltoolsnoeditpermissions'] = 'Bu aracı düzenlemek için izniniz yok';
$string['courseexternaltoolsnoviewpermissions'] = 'Kurs harici araçlarını görüntüle';
$string['courseid'] = 'Kurs kimlik numarası';
$string['courseinformation'] = 'Kurs bilgisi';
$string['courselink'] = 'Kursa git';
$string['coursemisconf'] = 'Kurs yanlış yapılandırılmış';
$string['coursetooldeleted'] = '{$a} silindi';
$string['createdon'] = 'Oluşturuldu';
$string['curllibrarymissing'] = 'Harici araç için gerekli PHP cURL uzantısı.';
$string['custom'] = 'Özel parametreler';
$string['custom_config'] = 'Özel araç yapılandırmasını kullanma.';
$string['custom_help'] = 'Özel parametreler, araç sağlayıcı tarafından kullanılan ayarlardır. Örneğin, özel bir parametre aşağıdakileri görüntülemek için kullanılabilir
sağlayıcıdan belirli bir kaynak.  Her parametre "name=value" formatı kullanılarak ayrı bir satıra girilmelidir; örneğin, "chapter=3".

Araç sağlayıcısı tarafından yönlendirilmedikçe bu alanı değiştirmeden bırakmak güvenlidir.';
$string['custominstr'] = 'Özel parametreler';
$string['debuglaunch'] = 'Hata ayıklama seçeneği';
$string['debuglaunchoff'] = 'Normal başlatma';
$string['debuglaunchon'] = 'Hata ayıklama başlatma';
$string['default'] = 'Geçer';
$string['default_launch_container'] = 'Varsayılan başlatma kabı';
$string['default_launch_container_help'] = 'Başlatma kapsayıcısı, kurstan başlatıldığında aracın görüntüsünü etkiler. Bazı başlatma kapsayıcıları daha fazla ekran sağlar
ve diğerleri Moodle ortamı ile daha entegre bir his sağlar.

* **Varsayılan** - Araç yapılandırması tarafından belirtilen başlatma kapsayıcısını kullanın.
* **Yerleştir** - Araç, diğer birçok Etkinlik türüne benzer bir şekilde mevcut Moodle penceresinde görüntülenir.
* **Bloksuz gömme** - Araç, yalnızca gezinme kontrolleriyle mevcut Moodle penceresinde görüntülenir
sayfanın üst kısmında
* **Yeni pencere** - Araç, mevcut tüm alanı kaplayan yeni bir pencerede açılır.
Tarayıcıya bağlı olarak, yeni bir sekmede veya bir açılır pencerede açılır.
Tarayıcıların yeni pencerenin açılmasını engellemesi mümkündür.';
$string['delegate'] = 'Öğretmene devredin';
$string['delegate_tool'] = 'Derin Bağlantı tanımında belirtilen şekilde veya Öğretmene devredin';
$string['delete'] = 'Sil';
$string['delete_confirmation'] = 'Bu önceden yapılandırılmış aracı silmek istediğinizden emin misiniz?';
$string['deletecoursetool'] = '{$a} \'yı silin';
$string['deletecoursetoolconfirm'] = 'Bu işlem {$a} öğesini kursunuzdaki mevcut LTI araçlarından silecektir.';
$string['deletecoursetoolwithusageconfirm'] = '{$a} şu anda kursunuzdaki en az bir etkinlikte kullanılmaktadır. Bu aracı silerseniz, onu kullanan etkinlikler artık çalışmaz. < br > < br > {$a}\'i silmek istediğinizden emin misiniz?';
$string['deletetype'] = 'Önceden yapılandırılmış aracı sil';
$string['display_description'] = 'Öğrenciler araca eriştiğinde etkinlik açıklamasını görüntüle';
$string['display_description_help'] = 'Bu araçtaki içerik, kurstaki bir sayfaya gömülü olarak görüntülenir. Bu ayar, etkinlik açıklamasının o sayfada gösterilip gösterilmeyeceğini belirler.';
$string['display_name'] = 'Öğrenciler araca eriştiğinde etkinlik adını görüntüle';
$string['display_name_help'] = 'Bu araçtaki içerik, kurstaki bir sayfaya gömülü olarak görüntülenir. Bu ayar, etkinlik adının o sayfada gösterilip gösterilmeyeceğini belirler.';
$string['domain_mismatch'] = 'Araç URL\'sinin alanı, araç yapılandırmasıyla eşleşmiyor.';
$string['donot'] = 'Gönderme';
$string['donotaccept'] = 'Kabul etme';
$string['donotallow'] = 'İzin verme';
$string['dontshowinactivitychooser'] = 'Etkinlik seçicide gösterme';
$string['duplicateregurl'] = 'Bu kayıt URL\'si zaten kullanımda';
$string['dynreg_update_btn_new'] = 'Yeni bir harici araç olarak kaydolun';
$string['dynreg_update_btn_update'] = 'Güncelleme';
$string['dynreg_update_name'] = 'Araç adı';
$string['dynreg_update_notools'] = 'Bağlamda araç yok.';
$string['dynreg_update_text'] = 'Kaydın etki alanına bağlı mevcut araçlar vardır. Önceden yüklenmiş bir aracı güncellemek mi istiyorsunuz? harici bir araç mı yoksa yeni bir harici araç mı oluşturmalısınız?';
$string['dynreg_update_url'] = 'Temel URL';
$string['dynreg_update_version'] = 'LTI versiyonu';
$string['dynreg_update_warn_dupdomain'] = 'Aynı etki alanı altında birden çok harici aracın olması önerilmez.';
$string['editdescription'] = 'Bu araca bir açıklama vermek için buraya tıklayın';
$string['editmanualinstancedeprecationwarning'] = 'Manuel olarak yapılandırılmış Harici araç etkinlikleri artık desteklenmemektedir.  Endişelenmeyin, bu etkinlik olduğu gibi çalışmaya devam edecek ancak artık burada araç yapılandırmasında değişiklik yapamazsınız.
<br><br>
Araçta herhangi bir değişiklik yapmak veya araçla yeni etkinlikler oluşturmak için aracın Kurs > Daha Fazla > LTI Harici araçlar bölümünde kursunuza eklenmesi gerekir.  Ardından, aracı doğrudan Etkinlik seçiciden seçerek yeni etkinlikler oluşturabileceksiniz.
<br><br>
LTI Harici araçlarını ekleme hakkında daha fazla bilgiyi <a href="{$a}" target="_blank">Harici araç</a> belgelerinde bulabilirsiniz.';
$string['edittype'] = 'Önceden yapılandırılmış aracı düzenleyin';
$string['embed'] = 'Göm';
$string['embed_no_blocks'] = 'Bloklar olmadan gömün';
$string['enableemailnotification'] = 'Bildirim e-postaları gönder';
$string['enableemailnotification_help'] = 'Etkinleştirilirse öğrenciler, araç gönderimlerine not verildiğinde e-posta bildirimi alacaklardır.';
$string['enterkeyandsecret'] = 'Tüketici anahtarınızı ve paylaşılan sırrınızı girin';
$string['enterkeyandsecret_help'] = 'Size bir tüketici anahtarı ve/veya paylaşılan sır verildiyse, bunları buraya girin';
$string['entitycourseexternaltools'] = 'Harici LTI  araçlar';
$string['errorbadurl'] = 'URL, geçerli bir araç URL\'si veya kartuşu değil.';
$string['errorincorrectconsumerkey'] = 'Tüketici anahtarı yanlış.';
$string['errorinvaliddata'] = 'Geçersiz veri: {$a}';
$string['errorinvalidmediatype'] = 'Geçersiz ortam türü: {$a}';
$string['errorinvalidresponseformat'] = 'Geçersiz İçerik Öğesi yanıt biçimi.';
$string['errormisconfig'] = 'Yanlış yapılandırılmış araç.  Lütfen Moodle yöneticinizden aracın yapılandırmasını düzeltmesini isteyin.';
$string['errortooltypenotfound'] = 'LTI araç türü bulunamadı.';
$string['existing_window'] = 'Mevcut pencere';
$string['extensions'] = 'LTI uzantı hizmetleri';
$string['external_tool_type'] = 'Önceden yapılandırılmış araç';
$string['external_tool_type_help'] = '* **Otomatik, araç URL\'sine göre** - En iyi takım yapılandırması otomatik olarak seçilir. Araç URL\'si tanınmazsa, araç yapılandırma ayrıntılarının manuel olarak girilmesi gerekebilir.
* **Önceden yapılandırılmış belirli bir araç** - Belirtilen takımın takım yapılandırması, harici takım sağlayıcısıyla iletişim kurarken kullanılacaktır. Araç URL\'si araç sağlayıcısına ait görünmüyorsa bir uyarı gösterilir. Bir araç URL\'si girmek her zaman gerekli değildir.
* **Özel yapılandırma** - Bir tüketici anahtarının ve paylaşılan gizli kod dizesinin el ile girilmesi gerekebilir. Tüketici anahtarı ve paylaşılan gizli kod dizesi araç sağlayıcısından alınabilir. Ancak, tüm araçlar bir tüketici anahtarı ve paylaşılan gizli kod dizesi gerektirmez, bu durumda alanlar boş bırakılabilir.
### Önceden yapılandırılmış araç düzenleme

Önceden yapılandırılmış araç açılır menüsünden sonra üç simge kullanılabilir:

* **Ekle** - Bir kurs düzeyi araç yapılandırması oluşturun. Bu kurstaki tüm Harici araç örnekleri, araç yapılandırmasını kullanabilir.
* **Düzenle** - Açılır menüden bir kurs düzeyi aracı seçin ve ardından bu simgeyi tıklayın. Araç yapılandırmasının ayrıntıları düzenlenebilir.
* **Sil** - Seçilen kurs düzeyi aracını kaldırın.';
$string['external_tool_types'] = 'Önceden yapılandırılmış araçlar';
$string['failedtoconnect'] = 'Moodle, "{$a}" sistemiyle iletişim kuramadı';
$string['failedtocreatetooltype'] = 'Yeni araç oluşturulamadı.  Lütfen URL\'yi kontrol edin ve tekrar deneyin.';
$string['failedtodeletetoolproxy'] = 'Araç kaydı silinemedi.  "Harici alet kayıtlarını yönet"i ziyaret etmeniz ve manuel olarak silmeniz gerekebilir.';
$string['filter_basiclti_configlink'] = 'Tercih ettiğiniz siteleri ve şifrelerini yapılandırın';
$string['filter_basiclti_password'] = 'Şifre zorunludur';
$string['filterconfig'] = 'LTI yönetimi';
$string['filtername'] = 'LTI';
$string['fixexistingconf'] = 'Yanlış yapılandırılmış örnek için mevcut bir yapılandırmayı kullanın';
$string['fixnew'] = 'Yeni konfigürasyon';
$string['fixnewconf'] = 'Yanlış yapılandırılmış örnek için yeni bir yapılandırma tanımlayın';
$string['fixold'] = 'Var olanı kullan';
$string['force_ssl'] = 'Ssl\'yi zorla';
$string['force_ssl_help'] = 'Bu seçenek belirlendiğinde, bu araç sağlayıcısına yapılan tüm girişler SSL kullanmaya zorlanır.

Ayrıca, araç sağlayıcısından gelen tüm web hizmeti istekleri SSL kullanacaktır.

Bu seçeneği kullanıyorsanız, bu Moodle sitesinin ve araç sağlayıcısının SSL\'yi desteklediğini doğrulayın.';
$string['forced_help'] = 'Bu ayar, kurs veya site düzeyinde bir araç yapılandırmasında zorlanmıştır. Bu arabirimden değiştiremeyebilirsiniz.';
$string['generaltool'] = 'Genel araç';
$string['global_tool_types'] = 'Önceden yapılandırılmış araçlar';
$string['grading'] = 'Not yönlendirme';
$string['icon_url'] = 'Simge URL\'si';
$string['icon_url_help'] = 'Simge URL\'si, bu etkinlik için kurs listesinde görünen simgenin değiştirilmesini sağlar. Varsayılan simgeyi kullanmak yerine
LTI simgesi, faaliyet türünü ifade eden bir simge belirtilebilir.';
$string['id'] = 'Kimlik';
$string['indicator:cognitivedepth'] = 'LTI bilişsel';
$string['indicator:cognitivedepth_help'] = 'Bu gösterge, öğrencinin bir LTI etkinliğinde ulaştığı bilişsel derinliğe dayanmaktadır.';
$string['indicator:cognitivedepthdef'] = 'LTI bilişsel';
$string['indicator:cognitivedepthdef_help'] = 'Katılımcı, bu analiz aralığı sırasında LTI etkinlikleri tarafından sunulan bilişsel katılımın bu yüzdesine ulaştı (Seviyeler = Görüntüleme Yok, Görüntüleme, Gönder, Geri Bildirimi Görüntüle)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'LTI sosyal';
$string['indicator:socialbreadth_help'] = 'Bu gösterge, bir LTI etkinliğinde öğrencinin ulaştığı sosyal genişliğe dayalıdır.';
$string['indicator:socialbreadthdef'] = 'LTI sosyal';
$string['indicator:socialbreadthdef_help'] = 'Katılımcı, bu analiz aralığında LTI etkinlikleri tarafından sunulan sosyal katılımın bu yüzdesine ulaştı (Seviyeler = Katılım yok, Yalnızca Katılımcı, Diğerleriyle Katılımcı)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['initiatelogin'] = 'Oturum açma URL\'sini başlat';
$string['initiatelogin_help'] = 'Oturum açma isteklerinin gönderileceği araç URL\'si.  Bir mesajın araca başarıyla gönderilebilmesi için bu URL gereklidir.';
$string['invalidid'] = 'LTI Kimliği yanlıştı';
$string['jwtsecurity'] = 'LTI 1.3';
$string['keytype'] = 'Ortak anahtar türü';
$string['keytype_help'] = 'Aracı doğrulamak için kullanılan kimlik doğrulama yöntemi.';
$string['keytype_keyset'] = 'Anahtar kümesi URL\'si';
$string['keytype_rsa'] = 'RSA anahtarı';
$string['launch_in_moodle'] = 'Moodle\'da aracı başlat';
$string['launch_in_popup'] = 'Aracı bir açılır pencerede başlat';
$string['launch_url'] = 'Araç URL\'si';
$string['launch_url_help'] = 'Araç URL\'si, Harici Aracın web adresini belirtir ve gösterilecek kaynak gibi ek bilgiler içerebilir.
Araç URL\'si için ne gireceğinizden emin değilseniz, lütfen daha fazla bilgi için araç sağlayıcısına danışın.

Varsa bir kartuş URL\'si girebilirsiniz ve form ayrıntılarının geri kalanı otomatik olarak doldurulur.

Önceden yapılandırılmış bir araç seçtiyseniz, bir araç URL\'si girmeniz gerekmeyebilir.  Araç bağlantısı yalnızca başlatmak için kullanılıyorsa
araç sağlayıcının sistemine girer ve belirli bir kaynağa gitmezse, muhtemelen durum bu olacaktır.';
$string['launchinpopup'] = 'Konteyneri başlat';
$string['launchinpopup_help'] = 'Başlatma kabı, kurstan başlatıldığında aracın görüntülenmesini etkiler.  Bazı başlatma kapları daha fazla ekran sağlar
araca emlak ve diğerleri Moodle ortamı ile daha entegre bir his sağlar.

* **Varsayılan** - Araç yapılandırması tarafından belirtilen başlatma kapsayıcısını kullanın.
* **Yerleştir** - Araç, diğer birçok Etkinlik türüne benzer bir şekilde mevcut Moodle penceresinde görüntülenir.
* **Bloksuz gömme** - Araç, yalnızca gezinme kontrolleriyle mevcut Moodle penceresinde görüntülenir
sayfanın üst kısmında
* **Yeni pencere** - Araç, mevcut tüm alanı kaplayan yeni bir pencerede açılır.
Tarayıcıya bağlı olarak, yeni bir sekmede veya bir açılır pencerede açılır.
Tarayıcıların yeni pencerenin açılmasını engellemesi mümkündür.';
$string['launchoptions'] = 'Başlatma ayarları';
$string['lti'] = 'LTI';
$string['lti:addcoursetool'] = 'Kursa özel araç yapılandırmaları ekleyin';
$string['lti:addinstance'] = 'Yeni bir harici araç ekle';
$string['lti:addmanualinstance'] = 'Manuel olarak yapılandırılmış bir araç ekleyin';
$string['lti:addmanualinstanceprohibitederror'] = 'Kurs aracı tanımı olmadan araçların manuel olarak oluşturulması artık desteklenmemektedir. Lütfen önce bir kurs aracı oluşturun ve ardından etkinlik örnekleri oluşturmak için bunu kullanın.';
$string['lti:addpreconfiguredinstance'] = 'Önceden yapılandırılmış bir araç ekleyin';
$string['lti:admin'] = 'Araç başlatıldığında yönetici olun';
$string['lti:grade'] = 'Harici araç tarafından döndürülen notları görüntüleme';
$string['lti:manage'] = 'Araç başlatıldığında Öğreten olun';
$string['lti:requesttooladd'] = 'Site çapında yapılandırılmış bir araç isteğinde bulunun';
$string['lti:view'] = 'Harici araç etkinliklerini başlat';
$string['lti_administration'] = 'Önceden yapılandırılmış aracı düzenleyin';
$string['lti_errormsg'] = 'Araç şu hata mesajını verdi: "{$a}"';
$string['lti_launch_error'] = 'Harici araç başlatılırken bir hata oluştu:';
$string['lti_launch_error_tool_request'] = '<p>
Bir yöneticinin araç yapılandırmasını tamamlaması için bir istek göndermek üzere <a href="{$a->admin_request_url}" target="_top"> Here </a> (buradan Kaydet) öğesine tıklayın.
</p>';
$string['lti_launch_error_unsigned_help'] = '<p>Bu hata, eksik bir tüketici anahtarının ve araç sağlayıcı için paylaşılan bir sırrın sonucu olabilir.</p>
<p>Tüketici anahtarınız ve paylaşılan sırrınız varsa, bunu harici araç örneğini düzenlerken girebilirsiniz (gelişmiş seçeneklerin görünür olduğundan emin olun).</p>
<p>Alternatif olarak, <a href="{$a->course_tool_editor}">kurs düzeyinde bir araç sağlayıcı yapılandırması oluşturabilirsiniz</a>.</p>';
$string['lti_tool_request_added'] = 'Araç yapılandırma isteği başarıyla gönderildi. Araç yapılandırmasını tamamlamak için bir yöneticiye başvurmanız gerekebilir.';
$string['lti_tool_request_existing'] = 'Araç etki alanı için bir araç yapılandırması zaten gönderildi.';
$string['ltisettings'] = 'LTI ayarları';
$string['ltiunknownserviceapicall'] = 'LTI bilinmeyen hizmet API çağrısı.';
$string['ltiversion'] = 'LTI versiyonu';
$string['ltiversion_help'] = 'Mesajları ve hizmet isteklerini imzalamak için kullanılan LTI sürümü: LTI 1.0/1.1 ve LTI 2.0, OAuth 1.0A güvenlik profilini kullanır;  LTI 1.3.0, JWT\'leri kullanır.';
$string['main_admin'] = 'Genel Yardım';
$string['main_admin_help'] = 'Harici araçlar, Moodle kullanıcılarının uzaktan barındırılan öğrenme kaynaklarıyla etkileşime girmesine olanak tanır.  Uzak araç, özel bir başlatma protokolü aracılığıyla, başlatan kullanıcı hakkında genel bilgilere erişebilir.  Örneğin, kurum adı, kurs kimliği, kullanıcı kimliği ve kullanıcının adı veya e-posta adresi gibi diğer bilgiler.

Bu sayfada listelenen araçlar üç kategoriye ayrılmıştır:

* **Aktif** - Bu araç sağlayıcılar, bir yönetici tarafından onaylandı ve yapılandırıldı.  Bu sitedeki herhangi bir kursun içinden kullanılabilirler.  Bir tüketici anahtarı ve paylaşılan sır girilirse, bu site ile uzak araç arasında güvenli bir iletişim kanalı sağlayan bir güven ilişkisi kurulur.
* **Beklemede** - Bu araç sağlayıcılar, bir paket içe aktarma yoluyla geldi, ancak bir yönetici tarafından yapılandırılmadı.  Öğretmenler, bir tüketici anahtarına ve paylaşılan bir sırra sahipse veya hiçbiri gerekmiyorsa, bu sağlayıcıların araçlarını kullanmaya devam edebilir.
* **Reddedildi** - Bu araç sağlayıcılar, bir yöneticinin sitede kullanıma sunmaya niyeti olmadığı araçlar olarak işaretlenir.  Öğretmenler, bir tüketici anahtarına ve paylaşılan bir sırra sahipse veya hiçbiri gerekmiyorsa, bu sağlayıcıların araçlarını kullanmaya devam edebilir.';
$string['manage_external_tools'] = 'Araçları yönet';
$string['manage_tool_proxies'] = 'Harici araç kayıtlarını yönetin';
$string['manage_tools'] = 'Önceden yapılandırılmış araçları yönetin';
$string['manuallyaddtype'] = 'Alternatif olarak, <a href="{$a}">bir aracı manuel olarak yapılandırabilirsiniz</a>.';
$string['miscellaneous'] = 'Çeşitli';
$string['misconfiguredtools'] = 'Yanlış yapılandırılmış araç örnekleri algılandı';
$string['missingparameterserror'] = 'Sayfa yanlış yapılandırılmış: "{$a}"';
$string['module_class_type'] = 'Moodle modül tipi';
$string['modulename'] = 'Harici araç';
$string['modulename_help'] = 'Harici araç etkinlik modülü, öğrencilerin diğer web sitelerindeki öğrenme kaynakları ve etkinliklerle etkileşim kurmasını sağlar.  Örneğin, harici bir araç, yeni bir aktivite türüne veya bir yayıncının öğrenme materyallerine erişim sağlayabilir.

Harici bir araç etkinliği oluşturmak için LTI\'yi (Öğrenim Araçları Birlikte Çalışabilirliği) destekleyen bir araç sağlayıcısı gereklidir.  Bir öğretmen, harici bir araç etkinliği oluşturabilir veya site yöneticisi tarafından yapılandırılan bir aracı kullanabilir.

Harici araç etkinlikleri, URL kaynaklarından birkaç şekilde farklılık gösterir:

* Harici araçlar içeriğe duyarlıdır, yani aracı başlatan kullanıcı hakkında kurum, kurs ve ad gibi bilgilere erişimleri vardır.
* Harici araçlar, etkinlik örneğiyle ilişkili notların okunmasını, güncellenmesini ve silinmesini destekler
* Harici araç yapılandırmaları, siteniz ile araç sağlayıcı arasında bir güven ilişkisi oluşturarak aralarında güvenli iletişim sağlar';
$string['modulename_link'] = 'mod/lti/view';
$string['modulename_shortcut_link'] = 'mod/lti/view/custom';
$string['modulenameplural'] = 'Harici araçlar';
$string['modulenamepluralformatted'] = 'Harici araçlar';
$string['name'] = 'İsim';
$string['never'] = 'Asla';
$string['new_window'] = 'Yeni Pencere';
$string['no_lti_configured'] = 'Yapılandırılmış aktif harici araç yok.';
$string['no_lti_pending'] = 'Bekleyen harici araç yok.';
$string['no_lti_rejected'] = 'Reddedilen harici araç yok.';
$string['no_lti_tools'] = 'Yapılandırılmış harici araç yok.';
$string['no_tp_accepted'] = 'Kabul edilen harici araç kaydı yok.';
$string['no_tp_cancelled'] = 'İptal edilen harici araç kaydı yok.';
$string['no_tp_configured'] = 'Yapılandırılmış kayıtlı olmayan harici araç kaydı yok.';
$string['no_tp_pending'] = 'Bekleyen harici araç kaydı yok.';
$string['no_tp_rejected'] = 'Reddedilen harici araç kaydı yok.';
$string['noattempts'] = 'Bu araç örneği üzerinde herhangi bir deneme yapılmamıştır';
$string['nocourseexternaltoolsnotice'] = 'Henüz LTI Harici araçları bulunmamaktadır.';
$string['noltis'] = 'Harici araç örneği yok';
$string['noprofileservice'] = 'Profil hizmeti bulunamadı';
$string['noservers'] = 'Sunucu bulunamadı';
$string['notypes'] = 'Şu anda Moodle\'da ayarlanmış bir LTI aracı yok.  Bazılarını eklemek için yukarıdaki Yükle bağlantısını tıklayın.';
$string['noviewusers'] = 'Bu aracı kullanma iznine sahip hiçbir kullanıcı bulunamadı';
$string['oauthsecurity'] = 'LTI 1.0/1.1';
$string['opensslconfiginvalid'] = 'LTI 1.3, geçerli bir openssl.cnf dosyasının yapılandırılmasını ve web sunucunuz tarafından kullanılabilir olmasını gerektirir.  Lütfen bu site için openssl\'yi yapılandırmak ve etkinleştirmek üzere site yöneticisiyle iletişime geçin.';
$string['optionalsettings'] = 'İsteğe bağlı ayarlar';
$string['organization'] = 'Organizasyon detayları';
$string['organizationdescr'] = 'Kuruluş açıklaması';
$string['organizationid_default'] = 'Varsayılan kuruluş kimliği';
$string['organizationid_default_help'] = 'Kuruluş Kimliği için kullanılacak varsayılan değer.  Site Kimliği, Moodle\'ın bu kurulumunu tanımlar.';
$string['organizationidguid'] = 'Kuruluş Kimliği';
$string['organizationidguid_help'] = 'Araca Platform Örneği GUID\'si olarak iletilen bu Moodle örneği için benzersiz bir tanımlayıcı.

Bu alan boş bırakılırsa varsayılan değer kullanılacaktır.';
$string['organizationurl'] = 'Kuruluş URL\'si';
$string['organizationurl_help'] = 'Bu Moodle örneğinin temel URL\'si.

Bu alan boş bırakılırsa, site yapılandırmasına bağlı olarak varsayılan bir değer kullanılır.';
$string['pagesize'] = 'Sayfa başına gösterilen gönderimler';
$string['parameter'] = 'Araç parametreleri';
$string['parameter_help'] = 'Araç parametreleri, araç sağlayıcısı tarafından kabul edilen araç proxy\'sinde iletilmesi istenen ayarlardır.';
$string['password'] = 'Paylaşılan şifre';
$string['password_admin'] = 'Paylaşılan şifre';
$string['password_admin_help'] = 'Paylaşılan şifre, araca erişimi doğrulamak için kullanılan bir parola olarak düşünülebilir. Araç sağlayıcısından alınan tüketici anahtarı ile birlikte sağlanmalıdır.

Moodle\'dan güvenli iletişim gerektirmeyen ve ek hizmetler (not raporlama gibi) sağlamayan araçlar paylaşılan bir sır gerektirmeyebilir.';
$string['password_help'] = 'Önceden yapılandırılmış araçlar için, burada paylaşılan bir parola girmek gerekli değildir, çünkü paylaşılan parola
yapılandırma sürecinin bir parçası olarak sağlanır.

Bu alan, halihazırda yapılandırılmamış bir araç sağlayıcısına bağlantı oluşturulurken girilmelidir.
Araç sağlayıcı bu kursta birden fazla kez kullanılacaksa bir kurs aracı yapılandırması eklemek iyi bir fikirdir.

Paylaşılan gizli bilgi, araca erişimi doğrulamak için kullanılan bir parola olarak düşünülebilir. Sağlanmalıdır
Araç sağlayıcısından alınan tüketici anahtarı ile birlikte.

Moodle\'dan güvenli iletişim gerektirmeyen ve ek hizmetler (not raporlama gibi) sağlamayan araçlar
paylaşılan bir sır gerektirmeyebilir.';
$string['pending'] = 'Askıda olan';
$string['pluginadministration'] = 'Harici araç yönetimi';
$string['pluginname'] = 'Harici araç';
$string['preferheight'] = 'Tercih edilen yükseklik';
$string['preferwidget'] = 'Bileşen başlatmayı tercih et';
$string['preferwidth'] = 'Tercih edilen genişlik';
$string['press_to_submit'] = 'Bu etkinliği başlatmak için basın';
$string['privacy'] = 'Gizlilik';
$string['privacy:metadata:coursefullname'] = 'Kullanıcının LTI Tüketicisine eriştiği kursun tam adı';
$string['privacy:metadata:courseid'] = 'Kullanıcının LTI Tüketicisine eriştiği kursun kimliği';
$string['privacy:metadata:courseidnumber'] = 'Kullanıcının LTI Tüketicisine eriştiği kursun kimlik numarası';
$string['privacy:metadata:courseshortname'] = 'Kullanıcının LTI Tüketicisine eriştiği kursun kısa adı';
$string['privacy:metadata:createdby'] = 'Kaydı oluşturan kullanıcı';
$string['privacy:metadata:email'] = 'LTI Tüketicisine erişen kullanıcının e-posta adresi';
$string['privacy:metadata:externalpurpose'] = 'LTI Tüketicisi, LTI Araç Sağlayıcısına kullanıcı bilgileri ve bağlam sağlar.';
$string['privacy:metadata:firstname'] = 'LTI Tüketicisine erişen kullanıcının adı';
$string['privacy:metadata:fullname'] = 'LTI Tüketicisine erişen kullanıcının tam adı';
$string['privacy:metadata:lastname'] = 'LTI Tüketicisine erişen kullanıcının soyadı';
$string['privacy:metadata:lti_submission'] = 'LTI gönderimi';
$string['privacy:metadata:lti_submission:datesubmitted'] = 'Gönderimin ne zaman yapıldığını gösteren zaman damgası';
$string['privacy:metadata:lti_submission:dateupdated'] = 'Gönderimin ne zaman değiştirildiğini gösteren zaman damgası';
$string['privacy:metadata:lti_submission:gradepercent'] = 'Yüzde olarak kullanıcının notu';
$string['privacy:metadata:lti_submission:originalgrade'] = 'Kullanıcı için orijinal not';
$string['privacy:metadata:lti_submission:userid'] = 'LTI etkinliği için başvuruda bulunan kullanıcının kimliği';
$string['privacy:metadata:lti_tool_proxies'] = 'LTI proxy\'leri';
$string['privacy:metadata:lti_tool_proxies:name'] = 'LTI proxy adı';
$string['privacy:metadata:lti_types'] = 'LTI türleri';
$string['privacy:metadata:lti_types:name'] = 'LTI tipi adı';
$string['privacy:metadata:role'] = 'LTI Tüketicisine erişen kullanıcının kurstaki rolü';
$string['privacy:metadata:timecreated'] = 'Kaydın oluşturulduğu saat';
$string['privacy:metadata:timemodified'] = 'Kaydın değiştirildiği zaman';
$string['privacy:metadata:userid'] = 'LTI Tüketicisine erişen kullanıcının kimliği';
$string['privacy:metadata:useridnumber'] = 'LTI Tüketicisine erişen kullanıcının kimlik numarası';
$string['privacy:metadata:username'] = 'LTI Tüketicisine erişen kullanıcının kullanıcı adı';
$string['publickey'] = 'Genel anahtar';
$string['publickey_help'] = 'Gelen mesajların ve hizmet isteklerinin imzalarının doğrulanmasına izin vermek için araç tarafından sağlanan açık anahtar (PEM biçiminde).';
$string['publickeyset'] = 'Genel anahtar seti';
$string['publickeyset_help'] = 'Bu sitenin, gelen mesajların ve hizmet isteklerinin imzalarının doğrulanmasını sağlamak için aracın ortak anahtarını alacağı ortak anahtar kümesi.';
$string['quickgrade'] = 'Hızlı puanlama izni ver';
$string['quickgrade_help'] = 'Etkinleştirilirse, bir sayfada birden fazla araca not verilebilir. Notları ve yorumları ekleyin, ardından o sayfadaki tüm değişiklikleri kaydetmek için "Tüm geri bildirimlerimi kaydet" düğmesine tıklayın.';
$string['redirect'] = 'Birkaç saniye içinde yeniden yönlendirileceksiniz. Eğer yönlendirilmediyseniz, düğmeye basın.';
$string['redirectionuris'] = 'Yönlendirme URI\'leri';
$string['redirectionuris_help'] = 'Aracın yetkilendirme istekleri yaparken kullandığı URI\'lerin listesi (her satıra bir tane).  Bir mesajın araca başarıyla gönderilebilmesi için en az birinin kaydedilmesi gerekir.';
$string['register'] = 'Kaydol';
$string['register_warning'] = 'Kayıt sayfasının açılması biraz zaman alıyor gibi görünüyor. Sayfa açılmazsa yapılandırma ayarlarına doğru URL\'yi girip girmediğinizi kontrol edin. Moodle https kullanıyorsa, yapılandırdığınız aracın https\'yi desteklediğinden ve URL\'de https kullandığınızdan emin olun.';
$string['registertype'] = 'Yeni bir harici araç kaydı yapılandırın';
$string['registration_options'] = 'Kayıt seçenekleri';
$string['registrationname'] = 'Araç sağlayıcı adı';
$string['registrationname_help'] = 'Kaydedilmekte olan araç sağlayıcının adını girin.';
$string['registrationurl'] = 'Kayıt URL\'si';
$string['registrationurl_help'] = 'Kayıt URL\'si, kayıt isteklerinin gönderileceği konum olarak araç sağlayıcısında mevcut olmalıdır.';
$string['reject'] = 'Reddet';
$string['rejected'] = 'Reddedildi';
$string['resource'] = 'Kaynak';
$string['resourcekey'] = 'Tüketici anahtarı';
$string['resourcekey_admin'] = 'Tüketici anahtarı';
$string['resourcekey_admin_help'] = 'Tüketici anahtarı, araca erişimi doğrulamak için kullanılan bir kullanıcı adı olarak düşünülebilir.
Araç sağlayıcısı tarafından, kullanıcıların araca girdiği Moodle sitesini benzersiz bir şekilde tanımlamak için kullanılabilir.

Tüketici anahtarı araç sağlayıcısı tarafından sağlanmalıdır. Tüketici anahtarı edinme yöntemi aşağıdakiler arasında değişir
araç sağlayıcıları. Bu otomatik bir süreç olabileceği gibi araç sağlayıcısıyla diyalog kurulmasını da gerektirebilir.

Moodle\'dan güvenli iletişim gerektirmeyen ve ek hizmetler (not raporlama gibi) sağlamayan araçlar
bir kaynak anahtarı gerektirmeyebilir.';
$string['resourcekey_help'] = 'Önceden yapılandırılmış araçlar için, tüketici anahtarı aşağıdaki gibi olacağından buraya bir kaynak anahtarı girmek gerekli değildir
yapılandırma sürecinin bir parçası olarak sağlanır.

Bu alan, halihazırda yapılandırılmamış bir araç sağlayıcısına bağlantı oluşturulurken girilmelidir.
Araç sağlayıcı bu kursta birden fazla kez kullanılacaksa bir kurs aracı yapılandırması eklemek iyi bir fikirdir.

Tüketici anahtarı, araca erişimi doğrulamak için kullanılan bir kullanıcı adı olarak düşünülebilir.
Araç sağlayıcı tarafından, kullanıcıların araca girdiği Moodle sitesini benzersiz bir şekilde tanımlamak için kullanılabilir.

Tüketici anahtarı araç sağlayıcısı tarafından sağlanmalıdır. Tüketici anahtarı edinme yöntemi aşağıdakiler arasında değişir
araç sağlayıcıları. Bu otomatik bir süreç olabileceği gibi araç sağlayıcısıyla diyalog kurulmasını da gerektirebilir.

Moodle\'dan güvenli iletişim gerektirmeyen ve ek hizmetler (not raporlama gibi) sağlamayan araçlar
bir kaynak anahtarı gerektirmeyebilir.';
$string['resourceurl'] = 'Kaynak URL';
$string['restricttocategory'] = 'Kategoriyle sınırla';
$string['restricttocategory_help'] = 'Bu aracın kullanımını bir kategorideki kurslarla sınırlamak için listeden kategoriyi veya kategorileri seçin.';
$string['return_to_course'] = 'Kursa geri dönmek için <a href="{$a->link}" target="_top">buraya</a> tıklayın.';
$string['saveallfeedback'] = 'Tüm geri bildirimlerimi kaydet';
$string['search:activity'] = 'Harici araç - faaliyet bilgileri';
$string['secure_icon_url'] = 'Güvenli simge URL\'si';
$string['secure_icon_url_help'] = 'Simge URL\'sine benzer, ancak siteye SSL aracılığıyla güvenli bir şekilde erişildiğinde kullanılır.  Bu alan, tarayıcının güvenli olmayan bir resim hakkında uyarı göstermesini engellemek içindir.';
$string['secure_launch_url'] = 'Güvenli araç URL\'si';
$string['secure_launch_url_help'] = 'Araç URL\'sine benzer, ancak yüksek güvenlik gerekiyorsa araç URL\'si yerine kullanılır. Moodle sitesine SSL üzerinden erişiliyorsa veya araç yapılandırması her zaman SSL üzerinden başlatılacak şekilde ayarlanmışsa Moodle, araç URL\'si yerine güvenli araç URL\'sini kullanacaktır.

Araç URL\'si, SSL üzerinden başlatmayı zorlamak için bir https adresine de ayarlanabilir ve bu alan boş bırakılabilir.';
$string['selectcontent'] = 'İçerik seç';
$string['selectcontentvalidationerror'] = 'Bu faaliyet için içerik seçmeniz gerekmektedir.';
$string['send'] = 'Gönder';
$string['services'] = 'Hizmetler';
$string['services_help'] = 'Araç sağlayıcısına sunmak istediğiniz hizmetleri seçin.  Birden fazla hizmet seçilebilir.';
$string['setupoptions'] = 'Kurulum seçenekleri';
$string['share_email'] = 'Başlatıcının e-postasını araçla paylaşın';
$string['share_email_admin'] = 'Başlatıcının e-postasını araçla paylaşma';
$string['share_email_admin_help'] = 'Aracı başlatan kullanıcının e-posta adresinin araç sağlayıcıyla paylaşılıp paylaşılmayacağını belirtin.
Araç sağlayıcı, kullanıcı arayüzünde aynı ada sahip kullanıcıları ayırt etmek veya e-posta göndermek için başlatıcının e-posta adreslerine ihtiyaç duyabilir.
araç içindeki eylemlere dayalı olarak kullanıcılara.';
$string['share_email_help'] = 'Aracı başlatan kullanıcının e-posta adresinin araç sağlayıcısıyla paylaşılıp paylaşılmayacağını belirtin.
Araç sağlayıcısı, kullanıcı arayüzünde aynı ada sahip kullanıcıları ayırt etmek veya araç içindeki eylemlere göre kullanıcılara e-posta göndermek için başlatıcının e-posta adreslerine ihtiyaç duyabilir.';
$string['share_name'] = 'Başlatıcının adını araçla paylaşma';
$string['share_name_admin'] = 'Başlatıcının adını araçla paylaş';
$string['share_name_admin_help'] = 'Aracı başlatan kullanıcının tam adının araç sağlayıcısıyla paylaşılıp paylaşılmayacağını belirtin.
Araç sağlayıcısı, araç içinde anlamlı bilgiler göstermek için başlatıcıların adlarına ihtiyaç duyabilir.';
$string['share_name_help'] = 'Aracı başlatan kullanıcının tam adının araç sağlayıcısıyla paylaşılıp paylaşılmayacağını belirtin.

Araç sağlayıcısı, araç içinde anlamlı bilgiler göstermek için başlatıcıların adlarına ihtiyaç duyabilir.

Bu ayarın araç yapılandırmasında geçersiz kılınabileceğini unutmayın.';
$string['share_roster'] = 'Aracın bu kursun öğrenci listesine erişmesine izin ver';
$string['share_roster_admin'] = 'Araç kurs listesine erişebilir';
$string['share_roster_admin_help'] = 'Aracın, bu aracın başlatıldığı kurslara kayıtlı kullanıcıların listesine erişip erişemeyeceğini belirtin.';
$string['share_roster_help'] = 'Aracın bu kursa kayıtlı kullanıcıların listesine erişip erişemeyeceğini belirtin.

Bu ayarın araç yapılandırmasında geçersiz kılınabileceğini unutmayın.';
$string['show_in_course_activity_chooser'] = 'Etkinlik seçicide ve önceden yapılandırılmış bir araç olarak göster';
$string['show_in_course_lti1'] = 'Araç yapılandırma kullanımı';
$string['show_in_course_lti1_help'] = 'Bu araç, öğretmenin bir kursa eklemek üzere seçmesi için etkinlik seçicide gösterilebilir. Alternatif olarak, bir kursa harici bir araç eklerken önceden yapılandırılmış araç açılır menüsünde gösterilebilir. Diğer bir seçenek de araç yapılandırmasının yalnızca bir kursa harici bir araç eklenirken tam araç URL\'si girilirse kullanılmasıdır.';
$string['show_in_course_lti2'] = 'Araç yapılandırma kullanımı';
$string['show_in_course_lti2_help'] = 'Bu araç, öğretmenin derse eklemeyi seçmesi için etkinlik seçicide veya bir kursa harici bir araç eklerken önceden yapılandırılmış araç açılır menüsünde gösterilebilir.';
$string['show_in_course_no'] = 'Gösterme;  yalnızca eşleşen bir araç URL\'si girildiğinde kullanın';
$string['show_in_course_preconfigured'] = 'Harici bir araç eklerken önceden yapılandırılmış araç olarak göster';
$string['showinactivitychooser'] = 'Etkinlik seçicide göster';
$string['sitehost'] = 'Site ana bilgisayar adı';
$string['siteid'] = 'Site Kimliği';
$string['size'] = 'Boyut parametreleri';
$string['submission'] = 'Gönderi';
$string['submissions'] = 'Gönderimler';
$string['submissionsfor'] = '{$a} için gönderimler';
$string['subplugintype_ltiresource'] = 'LTI hizmet kaynağı';
$string['subplugintype_ltiresource_plural'] = 'LTI hizmet kaynakları';
$string['subplugintype_ltiservice'] = 'LTI hizmeti';
$string['subplugintype_ltiservice_plural'] = 'LTI hizmetleri';
$string['subplugintype_ltisource'] = 'LTI kaynağı';
$string['subplugintype_ltisource_plural'] = 'LTI kaynakları';
$string['successfullycreatedtooltype'] = 'Yeni araç başarıyla oluşturuldu!';
$string['successfullyfetchedtoolconfigurationfromcontent'] = 'Seçilen içerikten araç konfigürasyonu başarıyla getirildi.';
$string['toggle_debug_data'] = 'Hata ayıklama verilerini değiştir';
$string['tool_config_not_found'] = 'Bu URL için araç yapılandırması bulunamadı.';
$string['tool_settings'] = 'Araç ayarları';
$string['tooldescription'] = 'Araç açıklaması';
$string['tooldescription_help'] = 'Etkinlik listesinde öğretmenlere gösterilecek aracın açıklaması.

Bu, aracın ne için olduğunu ve ne işe yaradığını ve öğretmenin bilmesi gerekebilecek ek bilgileri açıklamalıdır.';
$string['tooldetailsaccesstokenurl'] = 'Erişim belirteci URL\'si';
$string['tooldetailsauthrequesturl'] = 'Kimlik doğrulama isteği URL\'si';
$string['tooldetailsclientid'] = 'Müşteri Kimliği';
$string['tooldetailsdeploymentid'] = 'Dağıtım kimliği';
$string['tooldetailsmailtosubject'] = 'LTI aracı yapılandırması';
$string['tooldetailsmodalemail'] = 'E-posta';
$string['tooldetailsmodallink'] = 'Yapılandırma ayrıntılarını görüntüle';
$string['tooldetailsmodaltitle'] = 'Araç yapılandırma ayrıntıları';
$string['tooldetailsplatformid'] = 'Platform kimliği';
$string['tooldetailspublickeyseturl'] = 'Ortak anahtar kümesi URL\'si';
$string['toolisbeingused'] = 'Bu araç {$a} kez kullanılıyor';
$string['toolisnotbeingused'] = 'Bu araç henüz kullanılmadı';
$string['toolproxy'] = 'Harici takım kayıtları';
$string['toolproxy_help'] = 'Harici araç kayıtları, Moodle site yöneticilerinin, LTI 2.0\'ı destekleyen bir araç sağlayıcısından alınan bir araç proxy\'sinden harici araçları yapılandırmasına izin verir.  Süreci başlatmak için gereken tek şey, araç sağlayıcısı tarafından sağlanan bir kayıt URL\'sidir.  Araç sağlayıcıya sunulan yetenekler ve hizmetler, yeni bir kayıt yapılandırılırken seçilir.

 Bu sayfada listelenen araç kayıtları dört kategoriye ayrılmıştır:

 * **Yapılandırıldı** - Bu araç kayıtları ayarlandı ancak kayıt işlemi henüz başlamadı.
 * **Beklemede** - Bu araç kayıtları için kayıt işlemi başlatıldı ancak tamamlanmadı.  Taşımak için ayarları açın ve kaydedin
 \'Yapılandırılmış\' kategorisine geri dönün.
 * **Kabul edildi** - Bu araç kayıtları onaylandı;  araç proxy\'sinde belirtilen kaynaklar, önceden yapılandırılmış araçlar sayfasında görünecektir
 \'Beklemede\' başlangıç durumuyla.
 * **Reddedildi** - Bu araç kayıtları, kayıt işlemi sırasında reddedilenlerdir.  Taşımak için ayarları açın ve kaydedin
 kayıt işleminin yeniden başlatılabilmesi için \'Yapılandırılmış\' kategorisine geri dönün.';
$string['toolproxyregistration'] = 'Harici alet kaydı';
$string['toolregistration'] = 'Harici araç kaydı';
$string['toolsetup'] = 'Harici araç ayarları';
$string['tooltypeadded'] = 'Önceden yapılandırılmış araç eklendi';
$string['tooltypedeleted'] = 'Önceden yapılandırılmış araç silindi';
$string['tooltypenotdeleted'] = 'Önceden yapılandırılmış araç silinemedi';
$string['tooltypenotfounderror'] = 'Bu faaliyette kullanılan LTI aracı silinmiştir. Yardıma ihtiyacınız varsa öğretmeniniz veya site yöneticinizle iletişime geçin.';
$string['tooltypes'] = 'Araçlar';
$string['tooltypeupdated'] = 'Önceden yapılandırılmış araç güncellendi';
$string['toolurl'] = 'Araç URL\'si';
$string['toolurl_contentitemselectionrequest'] = 'İçerik Seçimi URL\'si';
$string['toolurl_contentitemselectionrequest_help'] = 'Araç sağlayıcıdan içerik seçimi sayfasını başlatmak için İçerik Seçimi URL\'si kullanılacaktır. Boşsa, Araç URL\'si kullanılacaktır';
$string['toolurl_help'] = 'Araç URL\'si, araç URL\'lerini doğru araç yapılandırmasıyla eşleştirmek için kullanılır. URL\'nin http(s) ile öneklenmesi isteğe bağlıdır.

Ayrıca, harici araç örneğinde bir araç URL\'si belirtilmemişse, temel URL araç URL\'si olarak kullanılır.

Örneğin, *tool.com* temel URL\'si aşağıdakiyle eşleşir:

* tool.com
* tool.com/quizzes
* tool.com/quizzes/quiz.php?id=10
* www.tool.com/quizzes

www.tool.com/quizzes* şeklindeki bir temel URL aşağıdakilerle eşleşir:

* www.tool.com/quizzes
* tool.com/quizzes
* tool.com/quizzes/take.php?id=10

quiz.tool.com* şeklindeki bir temel URL aşağıdakilerle eşleşir:

*quiz.tool.com
* quiz.tool.com/take.php?id=10

Aynı etki alanı için iki farklı araç konfigürasyonu varsa, en spesifik eşleşme kullanılacaktır.

Ayrıca varsa bir kartuş URL\'si de ekleyebilirsiniz ve aracın ayrıntıları otomatik olarak doldurulur.';
$string['toolurlplaceholder'] = 'Araç URL...';
$string['typename'] = 'Araç adı';
$string['typename_help'] = 'Araç adı, Moodle içindeki araç sağlayıcıyı tanımlamak için kullanılır. Girilen ad, karslaa harici araçlar eklerken öğretmenler tarafından görülebilir.';
$string['types'] = 'Türler';
$string['unabletocreatetooltype'] = 'Araç oluşturulamıyor';
$string['unabletofindtooltype'] = '{$a->id} için araç bulunamadı';
$string['unknownstate'] = 'Bilinmeyen durum';
$string['update'] = 'Güncelleme';
$string['usage'] = 'Kullanım sayısı';
$string['useraccountinformation'] = 'Kullanıcı hesabı bilgileri';
$string['userpersonalinformation'] = 'Kullanıcı kişisel bilgileri';
$string['using_tool_cartridge'] = 'Araç kartuşu kullanma';
$string['using_tool_configuration'] = 'Araç yapılandırmasını kullanarak:';
$string['validurl'] = 'Geçerli bir URL http (s) ile başlamalıdır: //';
$string['viewsubmissions'] = 'Gönderimleri ve not verme ekranını görüntüleyin';
