<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_coderunner', language 'ru', version '4.4'.
 *
 * @package     qtype_coderunner
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['HIDE'] = 'Скрыть';
$string['HIDE_IF_FAIL'] = 'Скрыть, если не получится';
$string['HIDE_IF_SUCCEED'] = 'Скрыть, если успешно';
$string['SHOW'] = 'Показать';
$string['aborted'] = 'Тестирование было прервано из-за ошибки.';
$string['ace-language'] = 'Язык Ace';
$string['ace_gapfillerui_ui_source_descr'] = '"globalextra", чтобы взять код для отображения из глобального дополнительного поля, или "test0", чтобы взять его из поля testcode первого теста';
$string['ace_ui_notready'] = 'Редактор Ace не готов. Может быть, перезагрузить страницу?';
$string['addingcoderunner'] = 'Добавление нового вопроса CodeRunner';
$string['advanced_customisation'] = 'Расширенная настройка';
$string['ajax_error'] = '*** ОШИБКА AJAX. НЕ СОХРАНЯЙТЕ ЭТО! ***';
$string['allok'] = 'Прошли все тесты!';
$string['allornone'] = 'Тестовый код должен быть предоставлен либо для всех тестовых примеров, либо ни для одного.';
$string['allornothing'] = 'Оценка "Все или ничего"';
$string['allornothing_help'] = 'При проверке вопроса с типом оценки "Все или ничего", все тестовые примеры должны быть выполнены, чтобы представленное решение получило какие-либо баллы. В противном случае оценка получается путем суммирования оценок за все пройденные тестовые примеры и выражения ее в виде доли от максимально возможной оценки.

Баллы для каждого тестового примера могут быть заданы только в том случае, если флажок "Все или ничего" снят.

При использовании шаблонного оценивания, который присуждает оценки деталям тестовых примеров, следует снять флажок "Всё или ничего".';
$string['allowattachments'] = 'Разрешить вложения';
$string['allowattachments_help'] = 'Следует ли разрешить студентам добавлять вложения к своим решениям, и если да, то сколько. Вложения копируются в рабочий каталог среды выполнения, и разделенный запятыми список имен вложений предоставляется шаблону в переменной Twig {{ ATTACHMENTS }}. Предупреждение: разрешение вложений может иметь последствия для производительности или дискового пространства серверов Moodle и заданий с большими классами и/или большими вложениями. Сервер Moodle и серверы Jobe до февраля 2019 года хранят все вложения на неопределенный срок.';
$string['allowedfilenames'] = 'Разрешенные имена файлов';
$string['allowedfilenames_help'] = 'Все загруженные имена файлов должны соответствовать заданному регулярному выражению PHP (Perl), если оно не пустое. Например, используйте \'.+\\\\.cpp\', чтобы разрешить любой файл C++ или \'(?!Prog)\\\\.java\' разрешить любой файл Java, кроме \'Prog.java". Кроме того, имена файлов должны содержать только буквенно-цифровые символы плюс подчеркивание, дефис и точку, не должны начинаться с двойного подчеркивания (\'\\_\\_\') и не должны конфликтовать ни с одним из поддерживаемых имен файлов. Описание представляет собой текстовое сообщение, показываемое студенту, чтобы объяснить, какие файлы ожидаются. Оставьте пустым, чтобы отобразить само регулярное выражение. Оставьте оба значения пустыми, чтобы обойти проверку регулярных выражений.';
$string['allowedfilenamesregex'] = 'Допустимые имена файлов (регулярное выражение)';
$string['allowmultiplestdins'] = 'Разрешить несколько исследований';
$string['answer'] = 'Ответ';
$string['answer_help'] = 'Образец ответа может быть введен здесь и использован для проверки автором вопроса и, возможно, показан студентам во время проверки. Он также используется скриптом bulk tester. Правильность непустого ответа проверяется при сохранении, если только не снят флажок "Проверить при сохранении".';
$string['answerbox_group'] = 'Поле ответа';
$string['answerbox_group_help'] = 'Установите количество строк, выделяемых для поля ответов. При этом устанавливается минимальная высота элемента пользовательского интерфейса (например, Ace), управляющего полем ответа. Ширина устанавливается в соответствии с размером окна. Если ответ переполнит поле по вертикали или горизонтали, появятся полосы прокрутки.';
$string['answerboxlines'] = 'Строки';
$string['answerpreload'] = 'Предварительная загрузка поля ответа';
$string['answerpreload_help'] = 'Текст, приведенный здесь, будет предварительно загружен в поле ответов студента.';
$string['answerprompt'] = 'Ответ:';
$string['answerrequired'] = 'Пожалуйста, дайте заполненный ответ';
$string['answertooshort'] = 'Ответ слишком короткий. Должно быть не менее {$a} символов.';
$string['asolutionis'] = 'Показать/скрыть авторское решение:';
$string['atleastonetest'] = 'Вы должны предоставить хотя бы один тестовый пример для этого вопроса.';
$string['attachmentoptions'] = 'Варианты вложения';
$string['attachmentsoptional'] = 'Вложения являются необязательными';
$string['attachmentsrequired'] = 'Требуются вложения';
$string['attachmentsrequired_help'] = 'Этот параметр указывает минимальное количество вложений, необходимых для оценки ответа.';
$string['autotagbycategoryindextitle'] = 'Авто-тег вопроса CodeRunner';
$string['autotagbycategorytitle'] = 'Авто-тег CodeRunner по категориям';
$string['bad_dotdotdot'] = 'Неправильное использование "...". Должно быть в конце, после двух увеличивающихся числовых штрафов';
$string['bad_empty_splitter'] = 'Тестовый разделитель не может быть пустым при использовании шаблона комбинатора';
$string['bad_new_prototype_name'] = 'Незаконное название нового прототипа: уже используется';
$string['badacelangstring'] = 'Плохая строка языка Ace';
$string['badcputime'] = 'Ограничение по времени процессора должно быть оставлено пустым или должно быть целым числом больше нуля';
$string['bademptyprecheck'] = 'Предварительная проверка завершилась неудачей со следующим неожиданным результатом.';
$string['badfilenamesregex'] = 'Недопустимое регулярное выражение';
$string['badfiles'] = 'Запрещенные имена файлов: {$a}';
$string['badjson'] = 'Плохой вывод JSON из комбинатора сортировки. Вывод был: {$a->output}';
$string['badjsonfunc'] = 'Неизвестная JSON встроенная функция ({$a->func})';
$string['badmemlimit'] = 'Ограничение памяти должно быть либо пустым, либо неотрицательным целым числом';
$string['badpenalties'] = 'Штрафной режим должен представлять собой разделенный запятыми список чисел в диапазоне [0, 100]';
$string['badquestion'] = 'Ошибка в вопросе';
$string['badrandomintarg'] = 'Плохой аргумент для функции JSON @randomint';
$string['badrandompickarg'] = 'Плохой аргумент для функции JSON @randompic';
$string['badsandboxparams'] = 'Поле "Другое" (параметры песочницы) должно быть либо пустым, либо допустимой записью JSON';
$string['badtemplateparams'] = 'Параметры шаблона должны быть либо пустыми, либо допустимой записью JSON. Получено: <pre class="templateparamserror">{$a}</pre>';
$string['baduiparams'] = 'Параметры пользовательского интерфейса должны быть пустыми или содержать допустимую запись JSON.';
$string['brokencombinator'] = 'Ожидалось результатов теста: {$a->numtests}, получено: {$a->numresults}. Возможно, речь идет о чрезмерной производительности или ошибке в вопросе?';
$string['brokentemplategrader'] = 'Плохой вывод из оценщика: {$a->output}. Выполнение программы могло быть прервано (например, превышены время ожидания или лимит памяти).';
$string['bulkquestiontester'] = 'Скрипт <a href="{$a->link}">bulk tester script</a> проверяет, что примеры ответов на все вопросы в текущем контексте помечены правильно. Полезно только после того, как были добавлены некоторые вопросы с образцами ответов; начальная установка не имеет их.';
$string['bulktestallincontext'] = 'Проверить все';
$string['bulktestcontinuefromhere'] = 'Запустить снова или возобновить, начиная с этого места';
$string['bulktestindextitle'] = 'Массовое тестирование CodeRunner';
$string['bulktestrun'] = 'Запустить все тесты вопросов для всех вопросов в системе (медленно, только для администратора)';
$string['bulktesttitle'] = 'Тестовые вопросы в {$a}';
$string['coderunner'] = 'Программный код';
$string['coderunner:sandboxwsaccess'] = 'Разрешить доступ к песочнице Jobe через веб-службы';
$string['coderunner:viewhiddentestcases'] = 'Видеть скрытые тестовые задания при просмотре вопросов';
$string['coderunner_help'] = 'В ответ на вопрос, который является спецификацией для фрагмента программы, функции или всей программы, отвечающий вводит исходный код на заданном компьютерном языке, который удовлетворяет спецификации.';
$string['coderunner_install_testsuite_failures'] = 'Тесты, которые не прошли';
$string['coderunner_install_testsuite_intro'] = 'Эта страница позволяет проверить правильность работы вопросов CodeRunner с примерами ответов.';
$string['coderunner_install_testsuite_noanswer'] = 'Вопросы без примера ответов';
$string['coderunner_install_testsuite_title'] = 'Набор тестов для примеров ответов CodeRunner';
$string['coderunner_install_testsuite_title_desc'] = '<a href="{$a->link}">Скрипт теста образцов ответов</a> проверяет правильность выполнения вопросов с образцами ответов.';
$string['coderunner_link'] = 'question/type/coderunner';
$string['coderunner_question_type'] = 'Тип вопроса CodeRunner:';
$string['coderunnercategories'] = 'Категории с вопросами CodeRunner';
$string['coderunnercontexts'] = 'Контексты с вопросами CodeRunner';
$string['coderunnersettings'] = 'Настройки CodeRunner';
$string['coderunnersummary'] = 'Ответ - это программный код, который выполняется в контексте набора тестовых примеров для определения его корректности.';
$string['coderunnertype'] = 'Тип вопроса';
$string['coderunnertype_help'] = 'Выберите язык программирования и тип вопроса. После выбора типа  ниже можно увидеть подробные сведения о типе вопроса.';
$string['coderunnerwssettings'] = 'Настройки веб-службы «песочница»';
$string['columncontrols'] = 'Таблица результатов';
$string['columncontrols_help'] = 'Флажки указывают, какие столбцы таблицы результатов будут показаны студенту после подачи ответа.';
$string['confirm_proceed'] = 'Если вы сохраните этот вопрос со снятым флажком «Настроить», все сделанные настройки будут потеряны. Продолжить?';
$string['confirmreset'] = 'Отказаться от всей вашей работы над этим вопросом и сбросить поле ответа на исходное предварительно загруженное значение?';
$string['corruptuiparams'] = 'Параметры пользовательского интерфейса для этого вопроса или его прототипа нарушены. Действуйте с осторожностью.';
$string['cputime'] = 'Ограничение по времени (сек)';
$string['customisation'] = 'Настройка';
$string['customisationcontrols'] = 'Настройка';
$string['customise'] = 'Настроить';
$string['datafiles'] = 'Поддерживаемые файлы';
$string['datafiles_help'] = 'Любые файлы, загруженные здесь, будут добавлены в рабочий каталог при выполнении расширенной шаблонной программы. Это позволяет удобно добавлять большие данные или вспомогательные файлы.';
$string['default_penalty_regime'] = 'Штрафной режим по умолчанию';
$string['default_penalty_regime_desc'] = 'Режим штрафов по умолчанию, применяемый к новым вопросам, состоит из списка штрафных процентов, разделенных запятыми, который может оканчиваться на «, ...» для обозначения текущей арифметической прогрессии.';
$string['display'] = 'Отображать';
$string['downloadquizattempts'] = 'Скачать попытки теста';
$string['downloadquizattemptshelp'] = 'Нажмите соответствующую кнопку скачивания для курса и/или теста, которые вы хотите скачать.
Цифры в скобках после курсов - количество тестов в курсе, имеющих не менее одного ответа.
Цифры в скобках после названия теста - это количество представленных ответов.';
$string['editingcoderunner'] = 'Редактирование вопроса CodeRunner';
$string['empty_new_prototype_name'] = 'Имя нового типа вопроса не может быть пустым';
$string['emptypenaltyregime'] = 'Должен быть определен штрафной режим (начиная с версии 3.1)';
$string['enable'] = 'Включить';
$string['enable_diff_check'] = 'Включить кнопку "Показать различия"';
$string['enable_diff_check_desc'] = 'Представьте студентам кнопку "Показать различия", если их ответ неверен и используется валидатор точного соответствия';
$string['enable_sandbox_desc'] = 'Разрешить использование указанной песочницы для запуска студенческих ответов';
$string['enable_sandbox_ws'] = 'Включить веб-службу «песочница»';
$string['enable_sandbox_ws_desc'] = 'Включите веб-службу, обеспечивающую прямой
доступ к серверу "песочницы" (обычно Jobe). ЭКСПЕРИМЕНТАЛЬНАЯ ФУНКЦИЯ.';
$string['enablecombinator'] = 'Включить комбинатор';
$string['equalitygrader'] = 'Точное совпадение';
$string['error_loading_prototype'] = 'Ошибка загрузки прототипа. Возможно, проблемы с сетью или неработающий сервер?';
$string['error_loading_ui_descr'] = 'Ошибка при загрузке описания пользовательского интерфейса. Возможно, проблемы с сетью или сбой сервера?';
$string['erroroninit'] = '**** ОШИБКА ПРИ ИНИЦИАЛИЗАЦИИ ВОПРОСА ****<br>{$a->error}<br>';
$string['errorstring-accessdenied'] = 'Доступ к песочнице запрещен';
$string['errorstring-autherror'] = 'Несанкционированное использование песочницы';
$string['errorstring-blocked-url'] = 'URL-адрес заблокирован. Проверьте URL-адрес Jobe и настройки безопасности HTTP в Moodle.';
$string['errorstring-jobe-failed'] = 'Не удалось выполнить запрос сервера Jobe.';
$string['errorstring-jobe400'] = 'Ошибка с песочницы сервера Jobe:';
$string['errorstring-ok'] = 'ОК';
$string['errorstring-overload'] = 'Задание не удалось запустить из-за перегрузки сервера. Может быть, попробуем еще раз в ближайшее время?';
$string['errorstring-pastenotfound'] = 'Запрос статуса несуществующей работы';
$string['errorstring-submissionfailed'] = 'Отправка в песочницу не удалась';
$string['errorstring-submissionlimitexceeded'] = 'Достигнут лимит отправки песочницы';
$string['errorstring-unknown'] = 'Непредвиденная ошибка при выполнении кода. Сервер песочницы может быть отключен или перегружен. Может быть, попробуем еще раз в ближайшее время?';
$string['errorstring-wronglangid'] = 'Запрошен несуществующий язык';
$string['event_sandboxwebserviceexec_desc'] = 'Задание было выполнено через веб-службу CodeRunner sandbox.';
$string['expand'] = 'Расширять';
$string['expandtitle'] = 'Показать категории вопросов';
$string['expected'] = 'Ожидаемый результат';
$string['expected_help'] = 'Ожидаемый результат теста. Рассматривается шаблоном как {{TEST.expected}}.';
$string['expectedcolhdr'] = 'Ожидаемый';
$string['exportthisquestion'] = 'Экспортировать этот вопрос';
$string['exportthisquestion_help'] = 'Это создаст файл экспорта Moodle XML, содержащий только этот вопрос. Один из примеров того, когда это полезно - если вы считаете, что этот вопрос демонстрирует ошибку в CodeRunner, о которой вы хотели бы сообщить разработчикам.';
$string['extra'] = 'Дополнительные данные шаблона';
$string['extra_help'] = 'Иногда полезное дополнительное текстовое поле для использования в шаблоне, доступное как {{TEST.extra}}';
$string['fail'] = 'Неудача';
$string['failedhidden'] = 'Ваш код не прошел один или несколько скрытых тестов.';
$string['failedntests'] = 'Неудачных тестов: {$a->numerrors}';
$string['failedtesting'] = 'Неудачное тестирование.';
$string['fails'] = 'неудачи';
$string['feedback'] = 'Отзыв';
$string['feedback_help'] = 'Выберите "Установить по тесту", чтобы разрешить параметры просмотра теста (в частности, параметр "Конкретная обратная связь") для управления отображением таблицы результатов, "Принудительное отображение" для отображения таблицы результатов и "Принудительное скрытие", чтобы скрыть ее';
$string['feedback_hide'] = 'Принудительно скрыть';
$string['feedback_quiz'] = 'Установить в тесте';
$string['feedback_show'] = 'Принудительно показать';
$string['fileheader'] = 'Поддерживаемые файлы';
$string['filenamesexplain'] = 'Описание';
$string['filenamesregex'] = 'Регулярное выражение';
$string['filloutoneanswer'] = 'Вы должны ввести исходный код, который удовлетворяет спецификации. Введенный вами код будет выполнен для определения его правильности и присвоения соответствующей оценки.';
$string['firstfailure'] = 'Первый неудачный тестовый пример: {$a}';
$string['forexample'] = 'Для примера';
$string['gapfillerui_delimiters_descr'] = '2-символьный массив строк, используемый для открытия и закрытия разрыва описания';
$string['gapfillerui_sync_interval_secs_descr'] = 'Интервал времени в секундах между вызовами для синхронизации содержимого пользовательского интерфейса с ответом на вопрос. 0 для отсутствия такой автоматической синхронизации.';
$string['gapfillerui_ui_source_descr'] = '"global extra", чтобы вывести HTML-код для отображения из глобального дополнительного поля, или "test 0", чтобы вывести его из поля тестового кода первого теста';
$string['giveup'] = 'Кнопка остановки';
$string['giveup_aftermaxmarks'] = 'Доступно один раз, отметка не может быть улучшена';
$string['giveup_always'] = 'Всегда доступен';
$string['giveup_help'] = 'Если эта опция включена, учащиеся увидят кнопку, чтобы прекратить взаимодействие с вопросом, и вместо этого отобразят общий отзыв.

Кнопка "Остановиться и прочитать окончательный отзыв" может быть показана с самого начала или только после того, как ученик больше не сможет улучшить свою оценку из-за режима штрафов.';
$string['giveup_never'] = 'Никогда не доступный';
$string['globalextra'] = 'Глобальный';
$string['globalextra_help'] = 'Поле текста для общего использования авторами шаблонов, как дополнительное поле каждого тестового случая, но глобальное для всех тестов. Доступно автору шаблона как {{ QUESTION.globalextra }}.';
$string['goodemptyprecheck'] = 'Пройдено';
$string['gotcolhdr'] = 'Получено';
$string['grader'] = 'Оценщик';
$string['grading'] = 'Оценка';
$string['gradingcontrols'] = 'Элементы управления оцениванием';
$string['gradingcontrols_help'] = 'Оценка  по умолчанию "точное соответствие" присваивается только в том случае, если результат выполнения точно соответствует ожидаемому значению, определенному в тестовом примере. Завершающие пробелы удаляются из всех строк, а все завершающие пустые строки удаляются до выполнения проверки на равенство.

Средство оценки "близко к равенству" аналогично, за исключением того, что оно также сворачивает несколько пробелов и табуляций в один пробел, удаляет все пустые строки и преобразует строки в нижний регистр.

Средство оценки "регулярное выражение" использует поле "ожидаемое" тестового примера в качестве регулярного выражения (без разделителей типа PERL) и проверяет выходные данные, чтобы увидеть, можно ли найти совпадение с ожидаемым результатом где-либо в выходных данных. Например, ожидаемое значение \'ab.*z\' будет соответствовать любому результату, который содержит символы \'ab\' в любом месте вывода и символ \'z\' где-нибудь позже. Чтобы принудительно сопоставить весь вывод, начните и завершите регулярное выражение с \'\\A\' и \'\\Z\' соответственно. При сопоставлении регулярных выражений используются МНОГОСТРОЧНЫЕ и ТОЧЕЧНЫЕ параметры.

Опция "шаблон оценки" предполагает, что выходные данные программы на самом деле являются результатом оценки, т.е. что шаблон проверяет * и оценивает * ответ учащегося. Единственным результатом такой шаблонной программы должна быть запись в формате JSON.

Если шаблон является шаблоном для каждого теста (т.е. не комбинаторным), строка JSON должна описывать строку таблицы результатов и должна содержать по крайней мере поле "доля", которое умножается на TEST.mark, чтобы определить, сколько оценок присуждается тестовому варианту. Обычно он также должен содержать поле "получено", которое представляет собой значение, отображаемое в столбце "Получено" таблицы результатов. Другие столбцы таблицы результатов (тестовый код, stdin, ожидаемые) также могут быть определены программой оценки шаблонов и будут использоваться вместо значений из тестового примера. Например, если выход из программы - строка <code>{"Доля":0.5, "получена": "Половина ответов верна!"}</code>, половина выходных данных может быть использована для этого конкретного теста, то будет \'получен\' столбец, который отображает текст "Половина ответов верна!". Другие столбцы можно добавить в таблицу результатов, добавив дополнительные атрибуты к записи JSON, а также к вопросу Поле Столбцов результатов.

Если шаблон-это комбинатор, то JSON строки вывода в шаблоне оценщик должны содержаться поле \'доля\' для полной оценки. И может включать ничего или больше: \'html-вступление\', \'результаты теста\', \'html-заключение\', \'формат столбцов\', \'отображение только выходных данных\', \'показать различия\' и \'состояние оценщика\'. Поля \'html-вступление\' и \'html-заключение\' представляют собой html, который отображается соответственно до и после (необязательной) таблицы результатов. Поле \'результаты теста\', если оно задано, представляет собой список списков, используемых для отображения какой-либо таблицы результатов. Первая строка - это строка заголовка столбца и все остальные строки определяют тело таблицы. Существуют два специальных значения заголовка столбца: \'правильный\' и \'скрытый\'. Столбец \'правильный\' используется для отображения крестиков или галочек для 0 и 1 соответственно. \'Скрытые\' столбцы не отображаются, но значения 0 или 1 в столбце можно использовать для включения и выключения видимости строк. Учащиеся не видят скрытых строк, но оценщики и другие сотрудники видят. Если предоставляется таблица \'результаты теста\', также может быть предоставлено необязательное поле \'формат столбцов\'. Это должен быть список строк, по одной на столбец, исключая \'правильные\' и \'скрытые\' столбцы. Строки определяют формат, который будет использоваться для отображения значений ячеек; в настоящее время единственными поддерживаемыми форматами являются \'%s\' для обычного отображения строки (которая очищается и упаковывается в тэг \'pre\') и \'%h\' для html-значения, которое не следует дополнительно обрабатывать перед отображением. Поле "показать различия" включает отображение кнопки "Показать различия" после таблицы результатов, если доля присужденной оценки не равна 1.0. Поле \'отображение только выходных данных\', если оно равно true, используется, когда вопрос должен использоваться только для отображения выходных данных и, возможно, изображений из прогона без пометки. Переменная \'состояние оценщика\' - это строковое значение, которое автор вопроса может использовать для передачи информации об оценке между попытками задать вопрос. Если он включен в ответ на оценку к отправке, он будет доступен при следующей отправке как переменная Twig \'QUESTION.stepinfo.graderstate\'.';
$string['graph_ui_invalidserialisation'] = 'Графический интерфейс: недопустимая сериализация';
$string['graphhelp'] = '- Дважды щелкните на пустом месте, чтобы создать новый узел/состояние.
- Дважды щелкните существующий узел, чтобы "пометить" его, например, как приемлемое состояние для конечных автоматов
(FSMs). Дважды щелкните еще раз, чтобы снять с него пометку.
- Щелкните и перетащите, чтобы переместить узел.
- Щелкните Alt (или Ctrl Alt) и перетащите, чтобы переместить (вспомогательный) график.
- Щелкните Shift внутри одного узла и перетащите на другой, чтобы создать связь.
- Щелкните Shift на пустом месте, перетащите на узел, чтобы создать стартовую ссылку (только для FSMs).
- Щелкните и перетащите связь, чтобы изменить ее кривую.
- Нажмите на связь/узел, чтобы отредактировать текст.
- Щелкните по тексту связи и перетащите, чтобы переместить ее.
- Ввод _, за которым следует цифра, превращает эту цифру в нижний индекс.
- Ввод \\epsilon создает символ epsilon (и аналогично для \\alpha, \\beta и т.д.).
- Нажмите на связь/узел, затем нажмите клавишу Delete, чтобы удалить его (или функцию-удалить на Mac).
- Ctrl + z для отмены и Ctrl + y или Ctrl+Shift + z для повтора.';
$string['graphui_fontsize_descr'] = 'Размер шрифта в точках, используемый для меток узлов и ребер.';
$string['graphui_helpmenutext_descr'] = 'Текст, который, если он непустой, заменяет стандартный текст меню справки, определенный в строках языка CodeRunner';
$string['graphui_isdirected_descr'] = 'Истина, если ребра направлены';
$string['graphui_isfsm_descr'] = 'Истина, если граф составляет ограниченную машину состояния, и в этом случае он может содержать входящее ребро из ниоткуда (начальное ребро) и может иметь "принимающие" узлы';
$string['graphui_lockedgelabels_descr'] = 'Истина, чтобы запретить пользователю редактировать метки краев. Это также предотвращает появление меток на любых новых ребрах.';
$string['graphui_lockedgepositions_descr'] = 'Значение истина запрещает пользователю перетаскивать края для изменения их кривизны. Возможно, это полезно, если в поле для ответов предварительно загружен график, который учащийся должен аннотировать, изменяя метки узлов или ребер или добавляя / удаляя ребра. Также гарантирует, что ребра, добавленные студентом, являются прямыми, например, для рисования многоугольника на наборе заданных точек. Обратите внимание, однако, что ребра все еще можно добавлять и удалять. Смотрите заблокированный набор.';
$string['graphui_lockedgeset_descr'] = 'Значение истина запрещает пользователю добавлять или удалять ребра.';
$string['graphui_locknodelabels_descr'] = 'Если значение истина, запретите пользователю редактировать метки узлов. Это также предотвратит появление любых новых узлов с непустыми метками';
$string['graphui_locknodepositions_descr'] = 'Если значение true, запрещает пользователю перемещать узлы. Полезно, когда в поле для ответов предварительно загружен график, который учащийся должен аннотировать, изменяя метки узлов или ребер или добавляя / удаляя ребра. Обратите внимание, однако, что узлы все еще можно добавлять и удалять. См. раздел Набор узлов блокировки.';
$string['graphui_locknodeset_descr'] = 'Значение истина, запрещает пользователю добавлять или удалять узлы или переключать типы узлов в / из акцепторов.';
$string['graphui_noderadius_descr'] = 'Радиус узла в пикселях';
$string['graphui_textoffset_descr'] = 'Смещение в пикселях метки ссылки от ее ссылки (устарело - вместо этого используйте перетаскивание).';
$string['hidden'] = 'Скрытый';
$string['hidecheck'] = 'Скрыть проверку';
$string['hidedetails'] = 'Скрыть детали';
$string['hidedifferences'] = 'Скрыть различия';
$string['hiderestiffail'] = 'Скрыть остальные в случае неудачи';
$string['hoisttemplateparams'] = 'Параметры шаблона подъемника';
$string['howtogetmore'] = 'Для получения более подробной информации сохраните вопрос с непроверенным параметром "Проверить при сохранении" и проверьте вручную';
$string['htmlui_enable_in_editor_descr'] = 'Если значение true, используйте пользовательский интерфейс для отображения образца ответа и предварительной загрузки ответа в форме редактирования вопроса, а не в сериализованной версии. Установите для этого значение false, если используете Twig в поле HTML src.';
$string['htmlui_html_src_descr'] = 'Задает исходный код для HTML-кода. Должно быть либо "global extra", либо "prototypeextra".';
$string['htmlui_sync_interval_secs_descr'] = 'Интервал времени в секундах между вызовами для синхронизации содержимого пользовательского интерфейса с ответом на вопрос. 0 для отсутствия такой автоматической синхронизации.';
$string['htmluiloadfail'] = 'Не удалось инициализировать плагин HTML UI. Вероятно, строка состояния JSON некорректна.';
$string['ideone_pass'] = 'Пароль сервера Ideone';
$string['ideone_pass_desc'] = 'Пароль, используемый при подключении к устаревшему серверу Ideone (если включена песочница ideone)';
$string['ideone_user'] = 'Пользователь сервера Ideone';
$string['ideone_user_desc'] = 'Имя входа, используемое при подключении к устаревшему серверу Ideone (если включена песочница ideone)';
$string['illegalformat'] = 'Недопустимый формат ({$a->format}) в форматах столбцов';
$string['illegaluiparamname'] = 'Следующие недопустимые параметры для пользовательского интерфейса {$a->uiname}';
$string['info_unavailable'] = 'Информация о типе вопроса недоступна для настраиваемых вопросов.';
$string['inputcolhdr'] = 'Ввод';
$string['insufficientattachments'] = 'Недостаточно вложений, требуется {$a}.';
$string['is_prototype'] = 'Использовать в качестве прототипа';
$string['iscombinatortemplate'] = 'Является комбинатором';
$string['jobe_apikey'] = 'API-ключ Jobe';
$string['jobe_apikey_desc'] = 'Ключ API, который должен быть включен во все запросы REST к серверу Jobe (если требуется). Максимум 40 символов. Оставьте пустым, чтобы исключить ключ API из запросов';
$string['jobe_canterbury_html'] = '<p style=\'color:gray; font-style:italic; font-size:smaller\'>Запуск на сервере Jobe Кентерберийского университета</p>.';
$string['jobe_host'] = 'Сервер Jobe';
$string['jobe_host_desc'] = 'Имя хоста сервера Jobe плюс номер порта, если он отличается от порта 80, например job.somewhere.edu:4010. URL-адрес запроса задания по умолчанию получается путем префикса строки http:// and appending /jobe/index.php/restapi/<REST_METHOD>. Вы можете либо указать протокол https:// перед именем хоста (например, https://jobe.somewhere.edu) если сервер Jobe установлен за обратным прокси-сервером, который действует как SSL-завершение. Для обработки более высоких нагрузок возможно несколько серверов jobe, разделенных точкой с запятой: выбирается один случайным образом.';
$string['jobe_host_ws'] = 'Сервер Jobe для использования в веб-службах';
$string['jobe_host_ws_desc'] = 'Веб-служба сервера «песочницы» будет использовать любую «песочницу», настроенную для указанного
языка. Это практически всегда сервер заданий, и конкретный используемый сервер заданий настраивается через интерфейс администратора (выше).
Однако, для обеспечения наилучшей безопасности веб-службе лучше использовать альтернативный
Jobe сервер, заданный в этом поле. Для обработки более высоких нагрузок возможно несколько серверов jobe, разделенных точкой с запятой: выбирается один случайным образом. Оставьте поле пустым, чтобы использовать значение по умолчанию.';
$string['jobe_warning_html'] = '<p style=\'background-color:yellow\'>Запуск с помощью сервера Jobe Кентерберийского университета. Это только для начального тестирования. Пожалуйста, настройте свой собственный сервер заданий как можно скорее. См. <a href=\'https://github.com/trampgeek/moodle-qtype_coderunner/blob/master/Readme.md#sandbox-configuration\' target=\'_blank\'>здесь</a>.</p>';
$string['language'] = 'Язык песочницы';
$string['languages'] = 'Языки';
$string['languages_help'] = 'Язык песочницы - это компьютерный язык, используемый для запуска отправки.
Он должен быть известен выбранной песочнице (если была выбрана конкретная песочница) или хотя бы одной из включенных песочниц (в противном случае). Обычно это не требует изменения значения в родительском шаблоне; настройте его на свой страх и риск.

Язык Ace - это язык, используемый редактором кода Ace (если он включен) для ответа учащегося.
По умолчанию это то же самое, что и язык песочницы. Введите здесь другое значение только в том случае, если язык шаблона отличается от языка песочницы, на котором студент будет писать (например, если препроцессор Python используется для проверки программы студента на языке Си перед ее запуском).

Многоязычные вопросы, то есть вопросы, на которые учащиеся могут ответить более чем на одном языке, включаются путем установки языка Ace в список языков, разделенных запятыми. Затем учащимся предлагается выпадающее меню для выбора языка, на котором написан их ответ.
Если один из языков помечен звездочкой (\'\\*\'), то этот язык выбирается в качестве языка по умолчанию, который выбирается в качестве начального состояния раскрывающегося меню.
Например, значение языка Ace типа "C,C++,Java\\*,Python3" позволит студенту представить C, C++, Java или Python3, но раскрывающееся меню изначально покажет Java, которая будет использоваться по умолчанию. Если значение по умолчанию не указано, то начальное состояние раскрывающегося списка пусто, и учащийся должен выбрать язык. Многоязычные вопросы требуют специального шаблона, который использует  переменную {{ANSWER\\_LANGUAGE}} шаблона для управления выполнением кода студента. См. встроенный пример многоязыкового типа вопроса. Переменная {{ANSWER\\_LANGUAGE}} определена <i>только</i> для многоязычных вопросов.

Если автор хочет предоставить образец ответа на многоязычный вопрос, он должен написать его на языке по умолчанию, если он указан, или на первом из разрешенных языков в другом случае.';
$string['languageselectlabel'] = 'Язык';
$string['legacyuiparams'] = 'Параметры пользовательского интерфейса больше не могут быть определены в поле параметров шаблона. Пожалуйста, вместо этого переместите следующее в поле параметров пользовательского интерфейса:';
$string['legacyuiparams2'] = 'Параметры пользовательского интерфейса больше не могут быть определены в поле параметров шаблона. Пожалуйста, вместо этого переместите следующее в поле параметров пользовательского интерфейса, удалив префикс \'{$a->uiname}_\':';
$string['mark'] = 'Оценка';
$string['marking'] = 'Распределение оценок';
$string['markinggroup'] = 'Оценивание';
$string['markinggroup_help'] = 'Если установлен флажок «Все или ничего», все тестовые примеры должны быть выполнены, чтобы получить какие-либо оценки за ответ.
В противном случае оценка получается путем суммирования оценок для всех выполненных тестовых случаев и выражения этого как доли максимально возможной оценки.
Отметки для каждого тестового случая могут быть указаны, только если флажок «Все или ничего» снят.
Если используется шаблонное оценивание, при котором оцениваются части тестовых случаев, то, как правило, следует снять флажок «Все или ничего».

Режим обязательных штрафов представляет собой разделенный запятыми список штрафов (каждый процент), применяемых к последующим ответам. Они абсолютны, а не совокупны. Как
особый случай, последний штраф может быть «...»,  что означает «продлить предыдущие два штрафа в арифметической прогрессии до 100». Например,
<tt>0,5,10,30,...</tt> эквивалентно <tt>0,5,10,30,50,70,90,100</tt>. Если ответов больше, чем заданных штрафов, используется последнее значение.
Вместо запятых в качестве разделителя можно использовать пробелы.

Режим штрафов по умолчанию может быть установлен администратором для всего сайта с помощью Администрирование сайта > Плагины > Типы вопросов > CodeRunner.

Установите режим штрафов на «0» для нулевых штрафов за все ответы.

Режим штрафов игнорируется, и никакие штрафы не применяются, если тест выполняется с использованием «адаптивного» поведения (без штрафов).';
$string['maxfilesize'] = 'Максимально допустимый размер файла (байт)';
$string['maxfilesize_help'] = 'Выберите максимальный размер загружаемого файла (байт). Разрешение загрузки больших файлов с большими классами может повлиять на производительность и дисковое пространство как на серверах Moodle, так и на серверах Jobe.';
$string['memorylimit'] = 'Лимит памяти (МБ)';
$string['missinganswers'] = 'недостающие ответы';
$string['missingorbadfraction'] = 'Неправильная или отсутствующая дробная часть в выводе из шаблона оценщика. Результат был: {$a->output}';
$string['missingoutput'] = 'Вы должны предоставить ожидаемый результат этого тестового примера.';
$string['missingprototype'] = 'Тип этого вопроса был определен как "{$a->crtype}", но прототипа не существует или он не является уникальным, или не доступен в этом контексте. Вы должны отменить и попытаться (пере)установить прототип.
Приступайте к редактированию только в том случае, если вы знаете, что делаете!';
$string['missingprototypes'] = 'Недостающие прототипы';
$string['missingprototypewhenrunning'] = 'Неработающий вопрос (пропущен или отсутствует прототип \'{$a->crtype}\'). Не может быть запущен.';
$string['missinguiparams'] = 'Следующие параметры пользовательского интерфейса являются обязательными, но не определены:';
$string['morehidden'] = 'Также есть неудачи в некоторых скрытых тестовых примерах.';
$string['multipledefaults'] = 'По умолчанию можно выбрать не более одного языка';
$string['multipleprototypes'] = 'Найдено несколько прототипов для \'{$a->crtype}\'';
$string['mustrequirefewer'] = 'Вы не можете требовать больше вложений, чем позволили.';
$string['nearequalitygrader'] = 'Почти точное совпадение';
$string['negativeorzeromark'] = 'Оценка должна быть больше нуля';
$string['nodetailsavailable'] = 'Выберите тип вопроса, чтобы просмотреть подробную справку.';
$string['noerrorsallowed'] = 'Ваш код должен пройти все тесты, чтобы заработать какие-либо оценки. Пробуйте снова.';
$string['nonnumericmark'] = 'Не числовая оценка';
$string['noqtype'] = 'Тип вопроса не выбран';
$string['nosampleanswer'] = 'Нет примера ответа';
$string['nouiparameters'] = 'Пользовательский интерфейс {$a->uiname} не принимает параметры.';
$string['options'] = 'Опции';
$string['ordering'] = 'Упорядочение';
$string['overloadoninit'] = 'Перегрузка сервера изолированной среды предотвратила инициализацию вопроса';
$string['pass'] = 'Пройти';
$string['passes'] = 'проходит';
$string['penaltyregime'] = '(штрафной режим: {$a} %)';
$string['penaltyregimelabel'] = 'Штрафной режим:';
$string['pluginname'] = 'CodeRunner';
$string['pluginname_help'] = 'Используйте поле со списком "Тип вопроса", чтобы выбрать компьютерный язык и тип вопроса, который будет использоваться при отправке ответа студентом.
Укажите задачу, для которой студент должен написать код, а затем определите набор проверок, которые будут выполняться для ответа студента.';
$string['pluginname_link'] = 'question/type/coderunner';
$string['pluginnameadding'] = 'Добавление вопроса CodeRunner';
$string['pluginnameediting'] = 'Редактирование вопроса CodeRunner';
$string['pluginnamesummary'] = 'CodeRunner: запускает представленный студентом код в песочнице';
$string['precheck'] = 'Предварительная проверка';
$string['precheck_all'] = 'Все';
$string['precheck_disabled'] = 'Отключенный';
$string['precheck_empty'] = 'Пусто';
$string['precheck_examples'] = 'Примеры';
$string['precheck_help'] = 'Если включена Предварительная проверка, то у студентов будет дополнительная кнопка слева от обычной кнопки проверки, чтобы дать им возможность без штрафных санкций проверить свой код на подмножестве вопросов тестовых примеров.

Если выбран параметр "Пустой", то будет выполнен один запуск с шаблоном для каждого теста с использованием тестового примера, в котором все поля (testcode, stdin, expected и т.д.) являются пустой строкой. Непустой вывод считается ошибкой предварительной проверки. Используйте с осторожностью: некоторые типы вопросов не справляются с этим правильно, например вопросы «написания программ», которые генерируют выходные данные.

Если выбран параметр "Примеры", то код будет проверяться на соответствие во всех тестах, для которых был выбор "использовать как пример".

Если используется вариант «Выбранный», в каждый тестовый пример добавляется дополнительный элемент пользовательского интерфейса, позволяющий автору выбрать определенное подмножество тестов.

Если выбрано "Все", то запускаются все тестовые примеры (хотя их поведение может отличаться от обычной проверки, если так выбрано в коде шаблона).

Шаблон может проверить, является ли запуск предварительной проверкой, используя Параметр Twig {{ IS_PRECHECK }}, который равен "1" во время при выполнении предварительной проверки и "0" в противном случае.';
$string['precheck_only'] = 'Только предварительная проверка';
$string['precheck_selected'] = 'Выбранный';
$string['precheckingemptyset'] = 'Предварительно проверяются примеры, но их нет!';
$string['privacy:metadata'] = 'Плагин типа вопросов CodeRunner не хранит никаких персональных данных.';
$string['proceed_at_own_risk'] = 'Редактирование встроенного прототипа вопроса?! Действуйте на свой страх и риск!';
$string['prototypeQ'] = 'Это прототип?';
$string['prototype_error'] = '*** СБОЙ ЗАГРУЗКИ ПРОТОТИПА. НЕ СОХРАНЯЙТЕ ЭТО! ***';
$string['prototype_load_failure'] = 'Ошибка загрузки прототипа:';
$string['prototypecontrols'] = 'Контроль прототипа';
$string['prototypecontrols_help'] = 'Если "Является прототипом" истинно, этот вопрос становится прототипом для других вопросов. После сохранения имя указанного типа вопроса появится в раскрывающемся списке типов вопросов. Новые вопросы, основанные на этом типе, по умолчанию наследуют все атрибуты настройки, указанные для этого вопроса. Последующие изменения в этом вопросе будут влиять на все производные вопросы, если они сами не будут настроены, чтобы разрывать связь.

Прототипное наследование является только одноуровневым, поэтому этот вопрос при сохранении в качестве прототипа теряет связь с исходным базовым типом, сам становясь новым базовым типом.
Имейте в виду, что при экспорте производных вопросов вы должны убедиться, что этот вопрос также включен в экспорт, иначе производный вопрос будет потерянным при импорте в другую систему. Кроме того, вы должны отследить, какие вопросы вы используете в качестве прототипов; настоятельно рекомендуется переименовать вопрос во что-то вроде "PROTOTYPE_for_my_new_question_type"
для облегчения последующего обслуживания.';
$string['prototypeextra'] = 'Прототип расширенный';
$string['prototypeextra_help'] = 'Поле текста для общего использования авторами типа вопросов, например global extra, но часть состояния прототипа. Доступно автору шаблона как {{ QUESTION.prototypeextra }}.';
$string['prototypeusage'] = 'Использование прототипа вопроса CodeRunner для курса {$a}';
$string['prototypeusageindex'] = 'Доступные курсы';
$string['qWrongBehaviour'] = 'Используйте Adaptive Behavior для всех вопросов CodeRunner, иначе производительность может сильно снизиться. Например, при повторном отображении страницы необходимо будет переоценить все вопросы на странице.';
$string['qtype_c_function'] = '<p> Тип вопроса для вопросов с написанием функции на языке Cи.
Предполагается, что ответ студента будет полной функцией языка Си, но ему могут опционально предшествовать другие автономные коды языка Си, такие как директивы препроцессора и вспомогательные функции.</p>
<p>Тестовый код для таких вопросов обычно вызывает функцию студента с некоторыми тестовыми аргументами и выводит результат, например <pre>printf("%d\\n", someIntFunction(blah1, blah2))</pre>
Поле <i>Expected</i> тестового примера - это ожидаемый результат теста.</p>
<p>
Если ни для одного из тестовых случаев не поставляется стандартный входной сигнал, то построена тестовая программа, состоящая из: </p>
<ol>
<li>Следующий стандарт #includes: stdlib.h, ctype.h, string.h, stdbool.h, math.h</li>
<li>Ответ студента.</li>
<li>Последовательность блоков, обрамленных фигурными скобками для каждого из заданных тестовых случаев. Каждый блок содержит только тестовый код тестового примера. Также есть
оператор <i> printf </i>, который добавляется между блоками кода для печати специального разделителя, используемого для разделения выходных данных на отдельные выходные данные тестового примера.</li>
</ol>
<p>Однако, если какой-либо из тестовых примеров имеет непустой стандартный ввод, то запускаются программы множественного теста, по одной на каждый тестовый пример.</p>
<p> Поле <i> extra </i> тестового примера игнорируется. </p>';
$string['qtype_c_program'] = '<p>Используется для вопросов по написанию программы на языке Cи, где нет кода для каждого теста, и разные тесты просто используют разные данные стандартного ввода (stdin).
Ожидается, что ответ студента будет полной запускаемой программой, которая запускается как есть, без изменений CodeRunner, один раз для каждого тестового примера. Значения тестового кода и дополнительных полей каждого тестового примера игнорируются.</p><p>Если вам нужно задать специальные аргументы компиляции или ссылки для вопроса, вы можете настроить его (установите флажок Настроить), затем открыть раздел <i>Расширенная настройка</i> и ввести подходящие параметры значения в поле <i>Sandbox &gt; Parameters</i>. Например <pre>{"{"link args":["-lm"]}</pre> для связи с математической библиотекой. </p>';
$string['qtype_cpp_function'] = '<p>Тип вопроса для вопросов написания функций C++.
Ответ студента, как ожидается, будет полной функцией C++, но ему могут (необязательно) предшествовать другие автономные коды C++, такие как директивы препроцессора и
вспомогательные функции.</p>
<p>В каждом тестовом примере тестовый код для таких вопросов обычно вызывает функцию студента с некоторыми тестовыми аргументами и выводит результат, например
<pre>cout << someIntFunction(blah1, blah2))</pre>
Поле <i>Expected</i> тестового примера - это ожидаемый результат теста.
<p>
Если ни для одного из тестовых примеров не предусмотрено стандартных входных данных, то создается единая тестовая программа, состоящая из:
<ol>
<li>Следующий стандарт #includes: iostream, fstream, string, math, vector и algorithm</li>
<li><code>использование пространства имен std;</code></li>
<li>Ответ студента</li>
<li>Последовательность блоков, обрамленных фигурными скобками для каждого из заданных тестовых примеров. Каждый блок состоит из дополнительного поля тестового примера <i>extra</i> (обычно пустого) далее следует тестовый код. Существует также оператор <i>printf</i>,  добавляемый между блоками кода для печати специального разделителя, который используется чтобы разделить выходные данные на отдельные выходы тестового примера.</li>
</ol>
<p>Однако, если какой-либо из тестовых примеров имеет непустые стандартные входные данные, выполняется несколько тестовых программ, по одной для каждого тестового примера.
</p>';
$string['qtype_cpp_program'] = '<p>Используется для вопросов написания программ C++, где нет кода для каждого тестового примера, а различные тесты просто используют разные стандартные входные данные (stdin). Ожидается, что ответ студента будет полной запускаемой программой, которая запускается как есть, без изменений CodeRunner, один раз для каждого тестового примера. Значения тестового кода и дополнительных полей каждого тестового примера игнорируются.</p>';
$string['qtype_directed_graph'] = '<p>Тип вопроса Python3, который просит студента нарисовать ориентированный граф, чтобы удовлетворить некоторую спецификацию. Автор вопроса должен написать код Python3 для проверки результирующего графика.</p>
<p>Обратите внимание, что на самом деле нет необходимости использовать этот тип вопроса для ориентированных графов, так как функциональность в основном обеспечивается плагином GraphUI. Если предварительная обработка графика, выполняемая
этим типом вопроса, не соответствует вашим потребностям, вы можете вместо этого просто использовать обычный вопрос Python3 (или любой другой язык). Установите пользовательский интерфейс на GraphUI и самостоятельно проанализируйте JSON-сериализованную версию графика (переменная Twig STUDENT_ANSWER). Однако этот тип вопроса действительно дает пример того, как использовать плагин GraphUI. Нажмите кнопку <i>Настроить</i>, чтобы просмотреть код шаблона.</p>
<p>Спецификация попросит студента нарисовать ориентированный граф, удовлетворяющий определенным требованиям. Это может быть, например, DFA (детерминированный конечный автомат) или токарный станок. Код тестового случая и/или дополнительный код затем проанализируют график и напечатают сообщение ученику, например "ОК", если график является правильным или, в противном случае, соответствующим информативным сообщением об ошибке.</p>
<p>Шаблон для этого вопроса анализирует JSON-сериализованный граф, извлекая
его топологию в виде графа словаря смежности; <i>graph</i>. Эта переменная доступна тестовому или дополнительному коду в тестовом случае. Ключами в
словаре являются имена узлов, если они заданы, или произвольные метки, идентифицирующие узлы вида #1, #2 и т.д. Значения в словаре представляют собой списки исходящих ребер, отсортированных по имени или идентификатору соседнего узла, причем каждое ребро является кортежем (Neighbourrid, edgeLabel).</p>
<p>Каждая запись в списке смежности имеет вид (nodeNameOrId, neighbours), где соседи (neighbours) - это список кортежей (neighbourNodeNameOrId, edgeLabel). Если узлам даны имена, то они используются в качестве идентификаторов узлов, в противном случае используются имена #1, #2 и т. Д. Список смежности и список соседей сортируются в порядке имени узла или идентификатора.</p>
<p>Шаблон является комбинаторным: тестовый код<i>testcode</i> и <i>extra</i>дополнительный код выполняется для каждого тестового случая.</p><p>Как простой например, если бы спецификация была просто "Нарисуйте ориентированный граф с двумя узлами, помеченными A и B, с ребром от A до B", подходящим тестовым случаем (хотя и с бесполезным выводом ошибок) могло бы быть:</p><pre>
if set(graph.keys()) == {\'A\', \'B\'} and len(graph[\'A\']) == 1 and len(graph[\'B\']) == 0 and graph[\'A\'][0][0] == \'B\':
    print(\'OK\')
else:
    print(\'Nope\')
</pre>
<p> В качестве альтернативы может быть набор тестовых случаев, каждый из которых проверяет один из аспектов спецификации. Например, первый тестовый случай может быть: "распечатайте отсортированные ключи", ожидая увидеть "А", "Б". Во втором тестовом примере могут быть напечатаны исходящие ребра из узла " А " и т.д.</p>
<p>Вопрос принимает следующие параметры шаблона, все из которых
распознаются плагином GraphUI и управляют его поведением.</p>
<p><ul>
<li>isfsm. Верно, если граф имеет конечный автомат. Если true, то график может содержать входящее ребро из ниоткуда (начальное ребро), а узлы могут быть помечены как принимающие состояния (показаны двойным кругом) двойным щелчком мыши. По умолчанию: true.</li>
<li>isdirected. Истинно, если ребра направлены. По умолчанию: true.</li>
<li>noderadius. Радиус узла в пикселях. По умолчанию: 26.</li>
<li>fontsize. Размер шрифта, используемый для меток узлов и ребер. По умолчанию: 20 пунктов.
<li>textoffset. Смещение в пикселях, используемое при позиционировании текста метки ссылки. По умолчанию 4.</li>
<li>helpmenutext. Строка, которая будет использоваться вместо справочной информации по умолчанию, если она указана.
Значения по умолчанию нет.</li>
<li>locknodepositions. True, чтобы предотвратить перемещение узлов пользователем. Полезно, когда в поле ответов предварительно загружается график, который учащийся должен аннотировать, изменяя метки узлов или ребер или добавляя/удаляя ребра. Заметьте, однако, что узлы по-прежнему можно добавлять и удалять.
<li>locknodeset. True, чтобы запретить пользователю добавлять или удалять узлы или переключать состояние принятия (из графиков fsm).
<li>locknodelabels. True, чтобы запретить пользователю редактировать метки узлов (включая вновь добавленные узлы).</li>
<li>lockedgepositions. True, чтобы запретить пользователю перетаскивать края для изменения их кривизны. Возможно, это полезно, если в поле ответов предварительно загружен график, который учащийся должен аннотировать, изменяя метки узлов или ребер или добавляя/удаляя ребра. Также гарантирует, что ребра, добавленные студентом, являются прямыми, например, для рисования многоугольника на множестве заданных точек. Обратите внимание, однако, что ребра все еще можно добавлять и удалять.</li>
<li>lockedgeset. True, чтобы предотвратить добавление или удаление ребер пользователем.</li>
<li>lockedgelabels. True для предотвращения редактирования пользователем краевых меток (включая недавно добавленные</li>
</ul></p>';
$string['qtype_java_class'] = '<p>Вопрос написания класса Java, где студент представляет полный класс в качестве своего ответа. Каждый тест обычно создает экземпляр объекта указанного класса и выполняет над ним одну или несколько проверок. Это некомбинаторный тип вопроса, означающий, что каждый тестовый пример выполняется как отдельная песочница.
</p><p>Программа, сгенерированная для каждого тестового примера, состоит из ответа студента, <i>публичный</i>&nbsp;атрибут снимается, если он присутствует. За этим (теперь локальным) определением класса следует публичный класс <i>__Tester__&nbsp;</i>, который имеет <i>главный</i>&nbsp;метод, который создает экземпляр класса Tester и вызывает его метод <i>runTests</i>. Метод <i>runTests</i> просто содержит код тестового примера. См. Шаблон для уточнения.</p><p>Следует отметить, что алгоритм, используемый для удаления публичного атрибута из предоставленного студентом класса, является упрощенным; он работает только в том случае, если слова <i>public class</i> существуют ровно один раз в студенческом коде, разделенные одним пробелом.</p>
<p>Дополнительное поле тестового примера игнорируется.</p>
<p>Этот тип вопроса неэффективен, если тестов много, так как для каждого тестового примера в песочницу отправляется отдельное задание компиляции и выполнения. Это можно было бы решить, написав комбинаторный тип вопроса. См. документацию coderunner (coderunner.org.nz) для получения дополнительной информации.</p>';
$string['qtype_java_method'] = '<p>Используется для вопросов, где студента просят  на Java написать метод, который по сути является отдельной функцией.
Предоставленный автором тест обычно представляет собой одну или две строки кода, которые (видимо) просто вызывают метод, предоставленный студентом, как в Cи.
Шаблон создает класс Main, содержащий предоставленный студентом метод (и любые другие поддерживаемые методы, если они захотят записать их) плюс метод \'runTests\', который обертывает тест(ы). Основная функция для класса конструирует экземпляр Main и вызывает его метод runTests. Подробнее см. Код шаблона.</p>';
$string['qtype_java_program'] = '<p>Вопрос Java write-a-program, в котором студент представляет полную программу в качестве своего ответа. Программа компилируется и выполняется для каждого тестового случая. Нет никакого тестового кода, только тестовые данные stdin, хотя на самом деле это не проверяется: caveat emptor. Дополнительные поля тестовых случаев также игнорируются.</p>
<p>Этот тип вопросов становится очень неэффективным, если существует много тестовых случаев, поскольку каждый из них требует полного цикла компиляции и выполнения на сервере заданий. Можно обернуть все тесты в одно задание Python, которое отправляется в песочницу сервер и компилирует программу только один раз, а затем запускает ее на каждом тестовом примере. Подробнее об этом подходе читайте на форуме авторов вопросов на сайте coderunner.org.nz.</p>';
$string['qtype_multilanguage'] = '<p>Стиль вопроса "напиши программу", в котором студент может представить ответ на любом из следующих языков: C, C++, Java, Python3. В поле ответа на вопрос ученика вверху есть выпадающее меню, с помощью которого ученик должен выбрать язык, на котором написан его ответ.</p>
<p>Дополнительные языки могут быть добавлены, если они поддерживаются на сервере заданий, путем добавления имени языка в <i>AceLang</i> поле формы редактирования вопроса, а затем расширение шаблона (q. v.) для обработки нового языка.</p>
<p>Представленный программный код выполняется как есть для каждого тестового случая. Тестовый код и дополнительные поля каждого тестового случая игнорируются.</p>';
$string['qtype_nodejs'] = '<p>Тип вопроса JavaScript, запускаемый с помощью node js. Тестовая программа, которая должна быть выполнена, начинается с ответа студента. За этим следует
каждый из кодов тестового случая по очереди, а между ними печатается строка-разделитель. Однако, если есть какие-либо стандартные входные данные для любого из тестовых случаев, для каждого тестового случая будет выполнен отдельный тестовый запуск.</p><p>
Если существует риск побочных эффектов от тестового случая, влияющих на более поздние тестовые случаи, вы можете добавить стандартные входные данные в любой из тестовых случаев, чтобы принудительно включить режим одного запуска для каждого тестового случая.</p>';
$string['qtype_octave_function'] = '<p>Тип вопроса, который задает Октавная функция, которую ученик должен представить во всей ее полноте. Каждый тестовый случай обычно вызывает функцию student с тестовыми аргументами и выводит результат или некоторое значение, полученное из него. Если ни в одном из вопросов нет стандартного ввода, программа состоит из ответа студента, утверждения <code>format free</code> и тестовый код из каждого тестового случая, плюс дополнительный <i>disp</i> инструкция для печати строки-разделителя между выходами тестового набора.</p><p>Если есть какие-либо стандартные входные данные, то каждый тестовый случай выполняется отдельно.</p>';
$string['qtype_pascal_function'] = '<p>Тип вопроса на языке Паскаль, в котором студента просят написать процедуру или функцию. Программа, которая будет запущена, состоит из ответа студента, за которым следует CodeRunner <i>testcode</i> находящийся в <code>begin ... end.</code>.<br> Это не комбинаторный тип вопроса, поэтому для каждого тестового примера будет выполняться отдельный запуск jobe.</p>';
$string['qtype_pascal_program'] = '<p>Тип вопроса на Паскале, где ответ студента представляет собой полную программу на Паскале. Программа компилируется и запускается один раз для каждого тестового примера, используя стандартные входные данные, предоставленные в тестовом примере, и игнорируя <i>тестовый код</i> и <i>дополнительные</i> поля.</p>';
$string['qtype_php'] = '<p>Вопрос PHP, в котором студент представляет свой php-код. В простейшем случае код студента будет начинаться с</p><pre>
&lt;?php</pre>, но <i>не закроет тег PHP</i>. Причину отсутствия закрытия можно увидеть, изучив шаблон: за ответом студента следует каждый из тестовых кодов тестового примера. Если вместо этого вы хотите, чтобы код студента заканчивался закрытием тега PHP, вам следует отредактировать шаблон, чтобы повторно открыть тег PHP перед последовательностью тестов.
</p>
<p> Выходные данные каждого тестового примера, которые должны соответствовать полю <i>expected</i> тестового примера, будут выходными данными PHP-кода студента (включая любое содержимое, выходящее за рамки тегов &lt;? php...?&gt;) плюс вывод тестового кода. </p> <p> Проверьте код шаблона (нажав <i>Настроить</i>), чтобы понять это. </p>';
$string['qtype_python2'] = '<p>Тип вопроса Python2, который может обрабатывать вопросы написания функций, написания класса или написания программ. Для каждого тестового примера выполняется код ответа студента, за которым следует тестовый код. Так, например, если студента попросят написать определение функции, то сначала будет выполнено его определение, а затем предоставленный автором тестовый код, который, как правило, вызовет функцию и выведет результат или некоторое значение, полученное из нее.</p>
<p>Если нет стандартных входных данных, определенных для всех тестовых примеров, вопрос фактически проводит все проверки в один запуск, печатая строку-разделитель между выходными данными каждого тестового примера. Пожалуйста, имейте в виду, что это не обязательно то же самое, что запускать каждый тестовый пример отдельно. Например, если существуют какие-либо глобальные переменные, определенные кодом студента, они будут сохранять свои значения в течение нескольких запусков. Если это может оказаться проблемой, то проще всего определить одно из стандартных полей ввода тестового примера как непустое значение - это принудительно переводит CodeRunner в резервный режим запуска каждого тестового примера отдельно.</p>';
$string['qtype_python3'] = '<p>Тип вопроса Python3, который может обрабатывать вопросы написания функций,написания класса или написания программ. Для каждого тестового примера выполняется код ответа студента, за которым следует тестовый код. Так, например, если студента попросят написать определение функции, то сначала будет выполнено его определение, а затем предоставленный автором тестовый код, который, как правило, вызовет функцию и выведет результат или некоторое значение, полученное из нее.</p>
<p>Если нет стандартных входных данных, определенных для всех тестовых примеров, вопрос фактически проводит все проверки в один запуск, печатая строку-разделитель между выходными данными каждого тестового примера. Пожалуйста, имейте в виду, что это не обязательно то же самое, что запускать каждый тестовый пример отдельно. Например, если существуют какие-либо глобальные переменные, определенные кодом студента, они будут сохранять свои значения в течение нескольких запусков. Если это может оказаться проблемой, то самый простой обходной путь - определить одно из стандартных полей ввода тестового примера как непустое значение. Это принудительно переводит CodeRunner в резервный режим запуска каждого тестового случая отдельно.</p>';
$string['qtype_python3_w_input'] = '<p>Тип вопроса Python3, который может обрабатывать вопросы написания функций, написания класса или написания программ. Он отличается от чуть более простого типа вопроса <i>python3</i> тем, что в обычном python3 функция <i>input</i> заменяется пользовательской версией, которая перекликается со стандартным вводом на стандартный вывод по мере его потребления. Это приводит к тому, что результат имитирует то, что видят студенты при тестировании с помощью ввода с клавиатуры. Рекомендуется вместо этого для типа вопроса <i>python3</i>  для любых
вопросов, связанных с вызовами <i>input</i> на вводных курсах программирования, где студенты, скорее всего, будут сбиты с толку отсутствием эха стандартных входных данных, взятых из файла.</p><p>Небольшой недостаток этого типа вопросов по сравнению с типом вопроса <i>python3</i>  заключается в том, что любые сообщения об ошибках в коде студента будут иметь запутанные номера строк, поскольку функция ввода замены вставляется перед кодом студента.</p>
<p>Для каждого тестового примера выполняется код ответа студента, за которым следует тестовый код. Так, например, если студента попросят написать определение функции , то сначала будет выполнено его определение, а затем предоставленный автором тестовый код, который, как правило, вызовет функцию и выведет результат или некоторое значение, полученное из нее.</p>
<p>Если нет стандартных входных данных, определенных для всех тестовых примеров, вопрос фактически проводит все проверки в один запуск, печатая строку-разделитель между выходными данными каждого тестового примера. Пожалуйста, имейте в виду, что это не обязательно то же самое, что запускать каждый тестовый пример отдельно. Например, если существуют какие-либо глобальные переменные, определенные кодом студента, они будут сохранять свои значения в течение нескольких запусков. Если это может оказаться проблемой, то самый простой обходной путь - определить одно из стандартных полей ввода тестового случая как непустое значение. Это принудительно переводит CodeRunner в резервный режим запуска каждого тестового случая отдельно.</p>';
$string['qtype_sql'] = '<p>Тип вопроса SQL, использующий sqlite3, запускается из Python3. sqlite3 должен быть установлен на сервере Jobe для этого типа вопросов.</p>
 <p>В рабочем каталоге выполняется поиск файлов с расширением ".db". Если существует только один такой файл, он используется в качестве базы данных sqlite3 для всех тестов. Несколько файлов .db в настоящее время выдают сообщение об ошибке; возможным развитием является использование различных файлов БД для каждого теста, например, в отсортированном порядке.</p>
 <p>Для каждого теста создается командный скрипт sqlite3 вида</p>
 <pre>.mode column<br>.headers on<br>&lt;code in extra&gt;<br>&lt;student answer&gt;<br>&lt;testcode&gt;</pre>

 <p>Запуск.</p>
 <p>Для каждого тестового примера используется свежая копия файла</p>
 <p>Параметр шаблона <i>columnwidths</i> может использоваться для задания ширины столбцов отчета. По умолчанию sqlite3 устанавливает максимальную ширину каждого столбца из трех чисел: 10, ширина заголовка и ширина первой строки данных.
Строка шаблона типа</p><pre><code>{"columnwidths": [10, 50, 10, 5]}
</code></pre>
<p>вместо этого будет использоваться ширина столбцов 10, 50, 10 и 5 для первых четырех столбцов.</p>';
$string['qtype_undirected_graph'] = '<p>Тип вопроса Python3, который просит студента нарисовать неориентированный граф, чтобы удовлетворить некоторую спецификацию. Автор вопроса должен написать код Python3 для проверки полученного графика.</p><p>Обратите внимание, что на самом деле нет необходимости использовать этот тип вопроса для неориентированных графиков, так как функциональность в основном обеспечивается графическим плагином. Если предварительная обработка графика, выполняемая этим типом вопроса, не соответствует вашим потребностям, вы можете вместо этого просто использовать обычный вопрос Python3 (или любой другой язык). Установите пользовательский интерфейс на GraphUI и самостоятельно проанализируйте JSON-сериализованную версию графика (the Twig STUDENT_ANSWER&nbsp; variable). Однако этот тип вопроса действительно дает пример того, как использовать графический плагин. Нажми <i>Настроить</i>, чтобы увидеть код шаблона.</p> <p>Спецификация попросит студента нарисовать неориентированный граф, удовлетворяющий определенным требованиям, например графическое представление набора городов, соединенных двусторонними дорогами. Код тестового случая и/или дополнительный код затем проанализируют график и напечатают сообщение для студента, например OK, если график правильный, или соответствующее информативное сообщение об ошибке в противном случае.</p>
<p>Шаблон для этого вопроса анализирует JSON-сериализованный граф, извлекая
его топологию из словаря смежности <i>graph</i>. Эта переменная доступна тестовому или дополнительному коду в тестовом случае. Ключами в словаре являются имена узлов, если они заданы, или произвольные метки, идентифицирующие узлы вида #1, #2 и т.д. Значения в словаре представляют собой списки ребер, отсортированных по имени соседнего узла или идентификатору, причем каждое ребро является кортежем (neighboring, edge Label).</p>
<p>Каждая запись в списке смежности имеет вид (nodeNameOrId, neighbours), где соседи (neighbours) - это список кортежей (neighbourNodeNameOrId, edgeLabel). Если узлам даны имена, то они используются в качестве идентификаторов узлов, в противном случае используются имена #1, #2 и т.д. Список смежности и список соседей сортируются в порядке имени узла или идентификатора.</p>
<p>Шаблон является комбинаторным: <i>testcode</i>&nbsp; и <i>extra</i>&nbsp; оба кода выполняются для каждого тестового случая.</p>
<p>В качестве простого примера, если бы спецификация была просто "Нарисуйте неориентированный граф с двумя узлами, помеченными A и B, с ребром между двумя узлами", подходящим тестовым случаем (хотя и с бесполезным выводом ошибок) мог бы быть:</p><pre>
if set(graph.keys()) == {\'A\', \'B\'} and len(graph[\'A\']) == 1 and len(graph[\'B\']) == 1 and graph[\'A\'][0][0] == \'B\':
    print(\'OK\')
else:
    print(\'Nope\')
</pre>
<p>В качестве альтернативы может быть набор тестовых случаев, каждый из которых проверяет один из аспектов спецификации. Например, первый тестовый пример может быть "напечатать сортированные ключи", ожидая увидеть "А", "Б". Во втором тестовом примере могут быть напечатаны ребра, связанные с узлом "А", и так далее.</p>
<p>Вопрос принимает следующие параметры шаблона, все из которых распознаются графическим плагином и управляют его поведением.</p>
<p><ul>
<li>isfsm. Верно, если граф имеет конечный автомат. Если true, то график может содержать входящее ребро из ниоткуда (начальное ребро), а узлы могут быть помечены как принимающие состояния (показаны двойным кругом) двойным щелчком мыши. По умолчанию: false.</li>
<li>isdirected. True, если ребра направлены. По умолчанию: false.</li>
<li>noderadius. Радиус узла в пикселях. По умолчанию: 26.</li>
<li>fontsize. Размер шрифта, используемый для меток узлов и ребер. По умолчанию: 20 пунктов.</li>
<li>textoffset. Смещение в пикселях, используемое при позиционировании текста метки ссылки. По умолчанию 4.</li>
<li>helpmenutext. Строка, которая будет использоваться вместо справочной информации по умолчанию, если она указана. Значения по умолчанию нет.</li>
<li>locknodes. True, чтобы предотвратить перемещение узлов пользователем. Полезно, когда в поле ответов предварительно загружается график, который учащийся должен аннотировать, изменяя метки узлов или ребер или добавляя/удаляя ребра. Обратите внимание, однако, что узлы все еще могут быть добавлены и удалены.</li>
<li>lockedges. True, чтобы запретить пользователю перетаскивать края для изменения
их кривизны. Возможно, это полезно, если в поле ответов предварительно загружен график, который учащийся должен аннотировать, изменяя метки узлов или ребер или добавляя/удаляя ребра. Также гарантирует, что ребра, добавленные студентом, являются прямыми, например, чтобы нарисовать многоугольник на множестве
заданных точек. Обратите внимание, однако, что ребра все еще можно добавлять и удалять.</li>
</ul></p>';
$string['qtypehelp'] = 'Справка по типам вопросов';
$string['question_type_changed'] = 'Изменение типа вопроса. Нажмите «ОК», чтобы перезагрузить поля настройки или «Отмена», чтобы оставить свои.';
$string['questioncheckboxes'] = 'Настройка';
$string['questioncheckboxes_help'] = 'Чтобы настроить тип вопроса, например, отредактировать шаблон вопроса, пользовательский интерфейс или параметры песочницы, установите флажок "Настроить" и ознакомьтесь со справкой, доступной на вновь отображаемых элементах формы для получения дополнительной информации.

Если установлен флажок шаблон-отладка, в выходных данных будет отображаться программа, сгенерированная для каждого запуска песочницы заданий.';
$string['questionloaderror'] = 'Не удалось загрузить вопрос';
$string['questionpreview'] = 'Предварительный просмотр вопроса';
$string['questiontype'] = 'Тип вопроса';
$string['questiontype_help'] = 'Выберите конкретный тип вопроса.

В поле со списком выбирается один из встроенных типов, каждый из которых указывает определенный язык и, иногда, песочницу, в которой будет выполняться программа. Каждый тип вопроса имеет шаблон, который определяет, как исполняемая программа строится из данных тестового примера и ответа студента.

Шаблон можно просмотреть и дополнительно настроить, нажав на флажок "Настроить".

Если установлен флажок "Шаблон-отладка", то в выходных данных будет отображаться программа, сгенерированная для каждого тестового примера.';
$string['questiontype_required'] = 'Вы должны выбрать тип вопроса';
$string['questiontypedetails'] = 'Детали типа вопроса';
$string['regexgrader'] = 'Регулярное выражение';
$string['replacedollarscount'] = 'Эта категория содержит вопросы CodeRunner: {$a}.';
$string['replaceexpectedwithgot'] = 'Нажмите на кнопку &lt;&lt;, чтобы заменить ожидаемый результат этого тестового примера фактическим.';
$string['reset'] = 'Сброс ответа';
$string['resethover'] = 'Отменить изменения и сбросить ответ на исходное предварительно загруженное значение';
$string['resultcolumnheader'] = 'Результат';
$string['resultcolumns'] = 'Столбцы результатов';
$string['resultcolumns_help'] = 'По умолчанию в таблице результатов отображаются столбцы testcode, stdin, expected и got, если они не пусты. Вы можете изменить значение по умолчанию и/или заголовки столбцов, введя значение для resultcolumns (оставьте пустым для поведения по умолчанию).

Если указано, поле resultcolumns должно быть закодированным в JSON списком спецификаторов столбцов. Каждый спецификатор столбца сам по себе является списком, обычно состоящим всего из двух или трех элементов. Первый элемент - это заголовок столбца, второй элемент - поле из объекта TestResult отображающееся в столбце, а необязательным третьим элементом является строка формата sprintf, используемая для отображения поля.

В стандартном объекте TestResult доступны следующие поля: testcode, stdin, expected, got, extra, awarded и mark. Testcode, stdin, expected и extra - это поля из testcase, в то время как got - это фактический сгенерированный результат, а awarded и mark - это фактическая присвоенная оценка и максимальная оценка соответственно за тестовый набор.

В каждый тестовый оценивающий шаблон могут быть добавлены свои собственные поля, которые также могут быть выбраны для отображения. Также можно объединить несколько полей в столбец, добавив дополнительные поля в спецификатор: они должны предшествовать спецификатору формата sprintf, который затем становится обязательным. Например, для отображения столбца Mark Fraction в виде 0.74/1.00 можно использовать спецификатор формата столбца ["Mark Fraction", "awarded", "mark", "%.2f/%.2f"].

В качестве еще одного частного случая формат %h означает, что поле результата теста должно быть взято как готовый к выводу HTML-код и не должно подвергаться дальнейшей обработке; это полезно только для пользовательских оценивающих шаблонов, которые генерируют HTML-вывод, например SVG-графику.

Значение resultcolumns по умолчанию равно [["Test", "testcode"],["Input", "stdin"], ["Expected", "expected"], ["Got", "got"]].

Настройка поля resultcolumns не имеет никакого эффекта, если используется комбинатор оценивающих шаблонов. Затем за форматирование таблицы результатов любым желаемым способом отвечает автор вопроса.';
$string['resultcolumnsnotjson'] = 'Поле Result columns не является допустимой строкой JSON';
$string['resultcolumnsnotlist'] = 'Поле Result columns должно содержать JSON-кодированный список спецификаторов столбцов';
$string['resultcolumnspecbad'] = 'Найден недопустимый спецификатор столбца: каждый из них должен быть списком из двух или более строк';
$string['resultstring-abnormaltermination'] = 'Ненормальное завершение';
$string['resultstring-compilationerror'] = 'Ошибка компиляции';
$string['resultstring-illegalsyscall'] = 'Незаконный вызов функции';
$string['resultstring-internalerror'] = 'Ошибка CodeRunner (IE): пожалуйста, сообщите об этом преподавателю';
$string['resultstring-memorylimit'] = 'Превышен лимит памяти';
$string['resultstring-norun'] = 'Не запускать';
$string['resultstring-outputlimit'] = 'Чрезмерный выходной результат';
$string['resultstring-runtimeerror'] = 'Ошибка запуска';
$string['resultstring-sandboxoverload'] = 'Перегрузка сервера песочницы. Может быть, попробуем еще раз в ближайшее время?';
$string['resultstring-sandboxpending'] = 'Ошибка CodeRunner (PD): пожалуйста, сообщите об этом преподавателю';
$string['resultstring-sandboxpolicy'] = 'Ошибка CodeRunner (BP): пожалуйста, сообщите об этом преподавателю';
$string['resultstring-success'] = 'ОК';
$string['resultstring-timelimit'] = 'Превышен лимит времени';
$string['run_failed'] = 'Не удалось выполнить тесты';
$string['sampleanswerattachments'] = 'Примеры вложений ответов';
$string['sampleanswerattachments_help'] = 'Если пример ответа нуждается в файлах вложений, загрузите их сюда';
$string['sandboxcontrols'] = 'Песочница';
$string['sandboxcontrols_help'] = 'Выберите, какую песочницу использовать для запуска студенческих ответов.
ПО УМОЛЧАНИЮ используется песочница с наивысшим приоритетом, доступная для выбранного языка. Поскольку Jobe заменил все типы песочницы, кроме устаревшего "ideonesandbox", значение "jobesandbox" рекомендуется для обычного использования и дает лучший результат при сообщениях об ошибках, если сервер Jobe не работает.

Вы также можете установить максимальное процессорное время в секундах, разрешенное для каждого запуска testcase, и максимальную память, которую может потреблять один запуск testcase (МБ). При пустой записи песочница использует значение по умолчанию (обычно 5 секунд для ограничения времени процессора - зависит от используемого языка программирования и объема памяти), но значения по умолчанию могут не подходить для ресурсоемких программ. Значение нуля для максимальной памяти приводит к тому, что ограничение не накладывается. Указанный здесь объем памяти - это общий объем, необходимый для запуска, включая все библиотеки, интерпретаторы, виртуальные машины и т.д.

Запись "Параметры" используется для передачи дальнейших специфичных для песочницы данных, таких как параметры компиляции и API-ключи. Как правило, он должен быть оставлен пустым, но если он не пуст, то должен быть действительным.
Запись JSON. В случае песочницы jobe доступные атрибуты включают disklimit, streamsize, numprocs, compileargs, linkargs и interpreterargs. Например <code>{"compileargs":["-std=c89"]}</code> ибо вопрос С заставит соблюдать С89, и никакие другие варианты С не будут использоваться. Подробные сведения см. в документации по jobe. Некоторые песочницы (например, устаревшая песочница Ideone) могут игнорировать любую или все эти настройки.

Если песочница настроена на "jobsandbox", то хост jobe, используемый для тестирования вопроса, обычно указывается администратором в настройках плагина CodeRunner. Однако можно выбрать другой сервер заданий, определив параметр "сервер jobe" , а также, опционально, параметр "ключ api jobe". Например, если в поле "Параметры" задано значение <code>{"jobeserver": "myspecialjobe.com"}</code>, вместо этого запуск будет отправлен на сервер "myspecialjobe.com".';
$string['sandboxerror'] = 'Ошибка из песочницы [{$a->sandbox}]: {$a->message}';
$string['sandboxparams'] = 'Параметры';
$string['seethisquestioninthequestionbank'] = 'См. этот вопрос в банке вопросов';
$string['showcolumns'] = 'Показать столбцы:';
$string['showcolumns_help'] = 'Выберите, какие столбцы таблицы результатов должны быть показаны учащимся. Пустые столбцы все равно будут скрыты.
Значения по умолчанию подходят в большинстве случаев.';
$string['showdetails'] = 'Показать детали';
$string['showdifferences'] = 'Показать различия';
$string['showsource'] = 'Отладка шаблонов';
$string['sourcecodeallruns'] = 'Отладка: исходный код из всех тестовых запусков';
$string['stdin'] = 'Стандартный ввод';
$string['stdin_help'] = 'Стандартный ввод для теста, рассматриваемый шаблоном как {{TEST.stdin}}';
$string['student_answer'] = 'Ответ студента';
$string['submitbuttons'] = 'Кнопки отправки';
$string['supportscripts'] = 'Скрипты поддержки';
$string['syntax_errors'] = 'Синтаксическая ошибка(и)';
$string['table_ui_invalidjson'] = 'Таблица UI: недопустимая сериализация JSON.';
$string['table_ui_invalidserialisation'] = 'Таблица UI: недопустимая сериализация.';
$string['table_ui_missingparams'] = 'Для табличного пользовательского интерфейса требуются параметры num_columns и
num_rows.';
$string['tableui_column_headers_descr'] = 'Список строк для заголовков столбцов.';
$string['tableui_column_width_percents_descr'] = 'Список чисел с плавающей запятой, дающих процент от доступной ширины таблицы для распределения по столбцам, включая столбец с меткой строки, если таковой имеется.';
$string['tableui_dynamic_rows_descr'] = 'Если истина, то предусмотрена кнопка "Добавить строку", позволяющая пользователям добавлять строки в таблицу.';
$string['tableui_lines_per_cell_descr'] = 'Количество текстовых строк в каждой текстовой области/ячейке';
$string['tableui_locked_cells_descr'] = 'Список из 2-элементных списков, дающих 0-начальные координаты ячеек, которые пользователь не может изменить. Координаты не включают возможную строку заголовка или столбец с меткой строки.';
$string['tableui_num_columns_descr'] = 'Количество столбцов в таблице, исключая крайний левый столбец с метками (если указаны метки). Требуемый.';
$string['tableui_num_rows_descr'] = '(Начальное) количество строк в таблице, исключая верхнюю строку заголовка (если заданы заголовки). Требуемый.';
$string['tableui_row_labels_descr'] = 'Список строк для меток строк, т.е. значений в столбце 0.';
$string['tableui_sync_interval_secs_descr'] = 'Интервал времени в секундах между вызовами для синхронизации содержимого пользовательского интерфейса с ответом на вопрос. 0 для отсутствия такой автоматической синхронизации.';
$string['template'] = 'Шаблон';
$string['template_changed'] = 'Изменен тестовый шаблон - отключить комбинатор? [«Отмена» оставляет его включенным.]';
$string['template_help'] = 'Шаблон определяет программу(ы), которые запускаются в песочнице для данного ответа студента и теста(ов). Существует два типа шаблонов:

* шаблон для каждого теста, который определяет программу, запускаемую для одного тестового примера и,
* шаблон "комбинатор", который определяет программу, объединяющую все разные примеры в одну программу.

Флажок "комбинатор" не установлен для шаблона теста и установлен для шаблона комбинатор. Остальная часть этой справки предполагает, что вы
используете шаблон для каждого теста.

По использованию шаблона комбинатор смотрите полную документацию.

Шаблон обрабатывается шаблоном Twig template engine (см. http://twig.sensiolabs.org) в контексте, в котором STUDENT_ANSWER - это ответ студента, а TEST.test - код для текущего тестового примера. Эти значения (и другие значения тестового примера, такие как TEST.expected, TEST.stdint, TEST.mark) можно вставить в шаблон, заключив их в двойные фигурные скобки, например <code>{{TEST.testcode}}</code>. Для использования в буквенных строках следует применить соответствующую экранирующую функцию, например<code>{{STUDENT_ANSWER | e(\'py\')}}</code> - это ответ студента, экранированный способом, подходящим для использования в строках Python с тройными двойными кавычками. Другие escape-функции: <code>e(\'c\')</code>, <code>e(\'java\')</code>, <code>e(\'matlab\')</code>. Программа, выводимая Twig, затем компилируется и выполняется с языком выбранного встроенного типа и с stdin, установленным в TEST.stdin. Выходные данные этой программы затем передаются выбранному оценщику. Подробнее об этом читайте в справке в разделе "Управление оцениванием".

Обратите внимание, что если используется настраиваемый шаблон для каждого теста, то для каждого тестового примера будет выполняться цикл компиляции и выполнения, в то время как большинство встроенных типов вопросов определяют вместо этого шаблон комбинатора, который объединяет все тестовые примеры в один запуск.

Если установлен флажок шаблон-отладка, то сгенерированная программа для каждого тестового примера будет отображать в выходных данных.';
$string['templatecontrols'] = 'Элементы управления шаблоном';
$string['templatecontrols_help'] = 'Установка флажка «Является комбинатором» означает, что шаблон является шаблоном комбинатора, который объединяет (или пытается объединить) ответ студента и все тестовые примеры в один прогон. Если этот флажок установлен, вам также нужно будет определить значение поля test_splitter_re, которое является регулярным выражением PHP, используемым для разделения выходных данных выполнения программы на набор отдельных тестовых запусков. Однако вам не нужно определять это, если вы также используете шаблонное оценивание, так как в этом случае код шаблона отвечает за разделение самого вывода и его оценку.

Шаблоны-комбинаторы не передают переменную TEST Twig. Вместо этого они получают переменную TESTCASES, которая представляет собой список всех тестов в вопросе. Обычно предполагается, что программа, созданная шаблоном, объединяет STUDENT_ANSWER и все TESTCASES в единую программу, которая при запуске выводит результаты тестирования из каждого тестового примера, разделенные уникальной строкой.
Строка разделителя определяется регулярным выражением, заданным ниже в поле формы test_splitter_re.

Однако, если в тестовых примерах определен стандартный ввод, шаблоны-комбинаторы становятся проблематичными. Если шаблон создает одну программу, каким должен быть стандартный ввод? Самое простое (и стандартное) решение - запускать тестовые примеры по одному, используя шаблон-комбинатор для построения каждой программы, передавая ему переменную TESTCASES, содержащую только один тест.
Этот «трюк» позволяет шаблону комбинатора выполнять двойную роль: он ведет себя как шаблон для каждого тестового примера (с массивом TESTCASES из 1 элемента), когда автор вопроса предоставляет стандартный ввод, но как правильный комбинатор (с массивом TESTCASES из n элементов) в противном случае. Для изменения такого поведения (чтобы комбинатор принимал все тестовые примеры) даже если присутствует стандартный ввод, установите флажок «Разрешить несколько стандартных вводов».

Если запуск программы combinator приводит к какому-либо выходу в stderr, это
интерпретируется как ошибка запуска. Чтобы гарантировать, что ученик получит зачет за как можно больше действительных тестов, система ведет себя так же, как и при наличии стандартных входных данных, возвращаясь к выполнению каждого теста отдельно. Однако это не относится к комбинаторным грейдерам, которые должны иметь дело со всеми сами ошибки времени выполнения и всегда должны возвращать допустимый результат JSON.

Если запуск программы комбинатора приводит к любому выводу в stderr, это интерпретируется как ошибка выполнения. Чтобы гарантировать, что студент получит баллы как за как можно больше пройденных тестов, система ведет себя так же, как и при наличии стандартных входных данных, возвращаясь к выполнению каждого теста отдельно. Однако это не относится к комбинаторным оценщикам, которые должны самостоятельно обрабатывать все ошибки времени выполнения и всегда должны возвращать допустимый результат JSON.';
$string['templateerror'] = 'ОШИБКА ШАБЛОНА';
$string['templategrader'] = 'Шаблон-оценщик';
$string['templateparams'] = 'Параметры шаблона';
$string['templateparams_help'] = 'Поле "Параметры шаблона" позволяет передавать строковые параметры в шаблон(ы) вопроса. Если он не пустой, то это должна быть запись в формате JSON. Затем поля записи можно использовать в шаблоне, где они отображаются в виде
QUESTION.parameters.&lt;&lt;param&gt;&gt;. Например, если параметры шаблона

        {"age": 23}

значение 23 будет подставлено в шаблон вместо переменной шаблона<code>{{ QUESTION.parameters.age }}</code>.

Набор параметров шаблона, передаваемых в шаблон, состоит из любых параметров шаблона, определенных в прототипе, с объединенными параметрами шаблона вопроса. Таким образом, параметры вопроса могут переопределять параметры прототипа, но не удалять их.

Параметры шаблона также могут быть использованы для обеспечения случайных вариантов внутри вопроса. При первом создании экземпляра вопроса параметры шаблона передаются через механизм шаблонов Twig для получения окончательной версии JSON. Функция Twigs "random" может быть использована для присвоения случайных значений параметрам шаблона. Если установлен флажок "Наблюдать все", что все остальные поля вопроса (текст вопроса, ответ, тестовые примеры и т.д.) также обрабатываются Twig, с параметрами шаблона в качестве среды. Это может привести к тому, что разные студенты увидят различные случайные варианты вопроса. Подробности см. в документации.';
$string['templateparamsevalpertry'] = 'Оценка для каждого студента';
$string['templateparamslang'] = 'Препроцессор';
$string['templateparamsusingsandbox'] = 'Препроцессоры, отличные от Twig, используют сервер изолированной среды. Если также задано значение "Оценка для каждого учащегося", то, когда учащийся начинает тест, все такие вопросы запускают песочницу еще до того, как вопрос может быть отображен. Во время теста или экзамена это может привести к перегрузке сервера изолированной среды. Будьте бдительны!';
$string['testallincategory'] = 'Проверить все вопросы в этой категории';
$string['testalltitle'] = 'Проверить все вопросы в этом контексте';
$string['testcase'] = 'Тестовый пример {$a}';
$string['testcasecontrols'] = 'Свойства теста:';
$string['testcasecontrols_help'] = 'Если установлен флажок "Использовать как пример", то этот тест будет автоматически включен в таблицу результатов вопроса "Для примера:".

Выпадающий список "Отобразить" определяет, когда этот тестовый пример будет показан студенту в таблице результатов.

Если установлен флажок "Скрыть остальные в случае неудачи" и этот тест не пройден, то все последующие тесты будут скрыты от ученика, независимо от настройки выпадающего списка "Отобразить".

"Оценка" задает значение этого тестового примера; имеет смысл только в том случае, если это не вопрос "Все или ничего".

"Упорядочение" может быть использовано для изменения порядка тестовых примеров при сохранении вопроса: тестовые примеры упорядочиваются по этому полю.';
$string['testcases'] = 'Тестовые примеры';
$string['testcode'] = 'Код теста';
$string['testcode_help'] = 'Код для теста, рассматриваемый шаблоном как {{TEST.testcode}}';
$string['testcolhdr'] = 'Тест';
$string['testingquestion'] = 'Тестовый вопрос {$a}';
$string['testsplitterre'] = 'Тестовый разделитель (регулярное выражение)';
$string['testtype'] = 'Тип теста предварительной проверки';
$string['testtype_both'] = 'Оба';
$string['testtype_help'] = 'Если включена предварительная проверка и установлено значение "Выбранный", то этот параметр определяет, будет ли тест использоваться только при обычном запуске, только при предварительном запуске или в обоих запусках. Если предварительная проверка установлена на что-либо другое, кроме "Выбранный", эта настройка игнорируется.';
$string['testtype_normal'] = 'Только проверка';
$string['testtype_precheck'] = 'Только предварительная проверка';
$string['tooshort'] = 'Ответ слишком короткий, чтобы быть осмысленным, и был проигнорирован без штрафа';
$string['twigall'] = 'Наблюдать все';
$string['twigcontrols'] = 'Элементы управления параметрами шаблона';
$string['twigcontrols_help'] = 'Параметры шаблона обычно упоминаются при  наблюдении в форме {{QUESTION.parameters.someparam}}. Однако если установлен флажок "Поднимать параметры шаблона", то параметры поднимаются в глобальное пространство имен Twig и могут быть указаны просто как {{someparam}}.

Макропроцессор Twig традиционно применялся только к шаблону. Теперь он также применяется к параметрам шаблона и, если установлен флажок "Наблюдать все" - к тексту вопроса, образцу ответа, предварительной загрузке ответа и всем полям тестового примера, используя расширенные параметры шаблона Twig в качестве среды. Обычно вам нужно включить "Наблюдать все" при использовании случайных значений в параметрах шаблона.';
$string['twigerror'] = 'Ошибка наблюдения {$a}';
$string['twigerrorintest'] = 'Ошибка наблюдения при обработке этого теста {$a}';
$string['type_header'] = 'Тип вопроса CodeRunner';
$string['typename'] = 'Тип вопроса';
$string['typerequired'] = 'Выберите тип вопроса (язык, формат и т.д.)';
$string['ui_fallback'] = 'Возврат к необработанной текстовой области.';
$string['uichanged'] = 'Изменился пользовательский интерфейс. Сохраните и перезагрузите страницу, чтобы просмотреть и отредактировать доступные параметры пользовательского интерфейса (если таковые имеются).';
$string['uicontrols'] = 'Пользовательские интерфейсы ввода';
$string['uicontrols_help'] = 'Выберите контроллеры пользовательского интерфейса для ответа студента и шаблон автора вопроса.

В раскрывающемся списке Ответов студентов отображается список доступных плагинов. Для кодирования вопросов обычно используется редактор Ace.

Значение "Нет" может быть использовано для предоставления необработанного текстового поля.

Значение "График" предоставляет пользователю простой пользовательский интерфейс для рисования графиков для использования с вопросами, в которых  студент должен нарисовать график в соответствии с некоторой спецификацией; такие вопросы обычно имеют один тестовый пример, оцениваемый с помощью шаблона, который анализирует сериализованное представление графика и выводит сообщение типа "ОК", если ответ правильный или соответствующее информативное сообщение об ошибке в противном случае.
Параметры шаблона могут быть заданы как в прототипе, так и в самом вопросе, чтобы изменить поведение графического плагина следующим образом: {"isdirected": false} для неориентированных графов; {"isfsm": true} разрешить входящие ребра без начального узла и разрешить двойной щелчок по узлу для определения его как состояния принятия; {"noderadius": 30}, скажем, установить другой радиус узла в пикселях; {"helpmenutext": "Line1\\nLine2\\nLine3"} чтобы заменить меню справки по умолчанию настраиваемой версией. Другие параметры шаблона задокументированы во встроенных типах вопросов directed\\_graph и undirected\\_graph. Параметры шаблона из фактического вопроса объединяются с параметрами прототипа и переопределяются ими (начиная с CodeRunner V3.2.2).

Элемент пользовательского интерфейса "Таблица" отображает таблицу текстовых областей для заполнения студентами. Он используется типом вопроса "python3_program_testing", который включен в примеры вопросов на github. Это принимает параметры шаблона table_num_rows и table_num_columns (оба обязательные) и необязательные table_column_headers (список строк, которыми помечаются столбцы), table_row_labels (список строк, которыми помечаются строки) и table_column_width_percents (список процентов ширины таблицы, выделяемых всем столбцам, включая столбец метки строки, если он указан) и table_locked_cells (список [строк, столбцов] пары ячеек, которые пользователь не может изменить - индексы строк и столбцов равны 0-origin, но не включают столбец метки строки или строку заголовка столбца).

Пользовательские интерфейсы "Gapfiller" и "HTML" задокументированы в основной документации CodeRunner по адресу https://github.com/trampgeek/moodle-qtype_coderunner#code-runner.

Студенты с плохим зрением или авторы, желающие проверить сериализацию (скажем, понять представление, используемое графическим интерфейсом), могут переключить использование всех плагинов пользовательского интерфейса на текущей странице, набрав Ctrl-Alt-M.

Какое бы значение ни было выбрано для ответа студента, оно также будет использоваться в форме редактора для полей Образец ответа и Предварительная загрузка ответа.

Если установлен флажок "Шаблон использует Ace", то, редактор кода Ace будет управлять как шаблоном, так и полями параметров шаблона. В противном случае будет использоваться необработанное текстовое поле.';
$string['uiparamdefault'] = 'По умолчанию';
$string['uiparamdesc'] = 'Описание';
$string['uiparametergroup'] = 'Параметры пользовательского интерфейса';
$string['uiparametergroup_help'] = 'Строка JSON, определяющая любые значения параметров пользовательского интерфейса, которые либо требуются плагину пользовательского интерфейса, либо переопределяют значения по умолчанию. Например, для рисования больших узлов при использовании графического интерфейса: \'{"радиус узла": 30}\'';
$string['uiparameters'] = 'Параметры пользовательского интерфейса (JSON)';
$string['uiparametertablehead'] = '{$a->uiname} Пользовательский интерфейс принимает следующие параметры:';
$string['uiparamname'] = 'Имя';
$string['unauthorisedbulktest'] = 'У вас нет соответствующего доступа к любым вопросам CodeRunner';
$string['unauthoriseddbaccess'] = 'Вы не имеете права использовать этот скрипт';
$string['unknowncombinatorgraderfield'] = 'Неизвестное имя поля ({$a->fieldname}) в выводе комбинатора оценивания';
$string['unknownerror'] = 'Произошла непредвиденная ошибка. Песочница может быть недоступна. Попробуйте еще раз.';
$string['unknownuiplugin'] = 'Была запрошена информация о неизвестном плагине ({$a->plugin name}).';
$string['unserializefailed'] = 'Сохраненные результаты теста не могут быть десериализованы. Может, попробуем пересчитать?';
$string['useace'] = 'Шаблон использует Ace';
$string['useasexample'] = 'Использовать как пример';
$string['validateonsave'] = 'Подтвердить при сохранении';
$string['wrongnumberofformats'] = 'Неверное количество форматов столбцов с результатами проверки. Ожидалось {$a->expected}, получено {$a->got}';
$string['wsdisabled'] = 'Веб-служба «песочницы» отключена. Обратитесь к администратору';
$string['wsloggingenable'] = 'Использовать журнал веб-службы песочницы';
$string['wsloggingenable_desc'] = 'Если этот параметр установлен, каждое выполнение кода через веб-службу «песочницы» будет регистрироваться. Эта опция должна быть включена, чтобы работало регулирование скорости пользователя.';
$string['wsmaxcputime'] = 'Максимальное процессорное время (секунды)';
$string['wsmaxcputime_desc'] = 'Ограничивает максимальное процессорное время, которое может использовать задание веб-службы, даже если в нем явно задан параметр процессорного времени «песочница».';
$string['wsmaxhourlyrate'] = 'Максимальная почасовая скорость отправки';
$string['wsmaxhourlyrate_desc'] = 'Если пользователь попытается превысить этот показатель отправки в любой данный час, его отправка будет отклонена. 0 для отсутствия контроля скорости. Требуется, чтобы было включено ведение журнала использования веб-службы.';
$string['wsnoaccess'] = 'Только зарегистрированные пользователи, не являющиеся гостями, могут получить доступ к этой функции';
$string['wssubmissionrateexceeded'] = 'Вы превысили максимальную почасовую скорость отправки «Попробуй это!». Запрос отклонен.';
$string['xmlcoderunnerformaterror'] = 'Ошибка формата XML в вопросе Сoderunner';
