<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'cs', version '4.4'.
 *
 * @package     badges
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Akce';
$string['activate'] = 'Povolit přístup';
$string['activatesuccess'] = 'Přístup k odznakům byl povolen';
$string['addalignment'] = 'Přidejte externí dovednost nebo standard';
$string['addbadge'] = 'Přidat odznaky';
$string['addbadge_help'] = 'Vyberte všechny odznaky, které by měly být přidány k tomuto požadavku na odznak. Podržením klávesy CTRL vyberte více položek.';
$string['addbadgecriteria'] = 'Přidat kritéria odznaku';
$string['addcohort'] = 'Přidat globální skupinu';
$string['addcohort_help'] = 'Vyberte všechny globální skupiny, které by měly být přidány k tomuto požadavku na odznak. Podržením klávesy CTRL vyberte více položek.';
$string['addcompetency'] = 'Přidat kompetenci';
$string['addcompetency_help'] = 'Vyberte všechny kompetence, které by měly být přidány k tomuto požadavku na odznak. Chcete-li vybrat více položek, podržte klávesu CTRL.';
$string['addcourse'] = 'Přidat kurzy';
$string['addcourse_help'] = 'Vyberte všechny kurzy, které by měly být přidány k tomuto požadavku na odznak. Podržením klávesy CTRL vyberete více položek.';
$string['addcriteria'] = 'Přidat kritéria';
$string['addcriteriatext'] = 'Chcete-li přidat kritéria, vyberte jednu z možností z rozbalovací nabídky.';
$string['addedtobackpack'] = 'Přidat odznak do sbírky';
$string['addrelated'] = 'Přidat související odznak';
$string['addtobackpack'] = 'Přidat do sbírky';
$string['adminonly'] = 'Tato stránka je přístupná pouze pro administrátory.';
$string['after'] = 'po datu udělení.';
$string['aggregationmethod'] = 'Agregační metoda';
$string['alignment'] = 'Kompetence';
$string['all'] = 'Vše';
$string['allmethod'] = 'Všechny vybrané podmínky jsou splněny';
$string['allmethodactivity'] = 'Všechny vybrané činnosti jsou ukončené';
$string['allmethodbadges'] = 'Byly uděleny všechny vybrané odznaky';
$string['allmethodcohort'] = 'Členství ve všech vybraných globálních skupinách';
$string['allmethodcompetencies'] = 'Všechny vybrané kompetence byly splněny';
$string['allmethodcourseset'] = 'Všechny vybrané kurzy jsou ukončené';
$string['allmethodmanual'] = 'Všechny vybrané role udělují odznak';
$string['allmethodprofile'] = 'Všechny vybrané pole profilu byly ukončeny';
$string['allowcoursebadges'] = 'Povolit odznaky kurzu';
$string['allowcoursebadges_desc'] = 'Povolit vytvoření odznaků a jejich udělování v rámci kurzu.';
$string['allowexternalbackpack'] = 'Připojení externí sbírky odznaků';
$string['allowexternalbackpack_desc'] = 'Pokud je povoleno, uživatelé se mohou připojit k externí sbírce a sdílet své odznaky z těchto stránek. Uživatelé se mohou také rozhodnout, že budou na svých profilech na těchto stránkách zobrazovat veřejné kolekce odznaků z externí sbírky. Doporučujeme ponechat tuto možnost vypnutou, pokud vaše stránky nejsou přístupné z Internetu.';
$string['any'] = 'Aspoň jedna';
$string['anymethod'] = 'Je splněna aspoň jedna z vybraných podmínek';
$string['anymethodactivity'] = 'Je ukončena aspoň jedna z vybraných činností';
$string['anymethodbadges'] = 'Byly uděleny některé vybrané odznaky';
$string['anymethodcohort'] = 'Členství v některé z vybraných globálních skupinách';
$string['anymethodcompetencies'] = 'Některé z vybraných kompetencí byly splněny';
$string['anymethodcourseset'] = 'Je ukončen aspoň jeden z vybraných kurzů';
$string['anymethodmanual'] = 'Odznak uděluje aspoň jedna z vybraných rolí';
$string['anymethodprofile'] = 'Je vyplněno aspoň jedno z vybraných polí profilu';
$string['apiversion'] = 'API verze je podporována';
$string['archivebadge'] = 'Chcete odstranit odznak "{$a}", ale zachovat stávající vydané odznaky?';
$string['archiveconfirm'] = 'Odstranit a zachovat stávající vydané odznaky';
$string['archivehelp'] = '<p>Tato volba znamená, že odznak bude označen jako "Prošlý" a nebude již objevovat v seznamu odznaků. Uživatelé již nebudou moci tento odznak získat, nicméně stávající příjemci odznaku budou moci tento odznak zobrazit na své profilové stránce a zaslat do svých externích seznamů.</p>
<p>Pokud byste chtěli svým uživatelům zachovat přístup k získaným odznakům, je důležité zvolit namísto úplného odstranění odznaku tuto možnost.</p>';
$string['attachment'] = 'Připojit odznak do zprávy';
$string['attachment_help'] = 'Při zaškrtnutí bude odznak přiložen k informačnímu e-mailu pro příjemce ke stažení. (Přílohy musí být povoleny ve Správa stránek / Server / Výstupy zprávy / Konfigurace odchozí pošty - nastavit "Povolit přílohy")';
$string['award'] = 'Udělený odznak';
$string['awardedto'] = 'Uděleno {$a}';
$string['awardedtoyou'] = 'Získal jsem';
$string['awardoncron'] = 'Byl úspěšně aktivován přístup k odznakům. Odznaky může okamžitě získat příliš mnoho uživatelů. Akce bude nějaký čas trvat, aby byl zachován výkon serveru.';
$string['awards'] = 'Příjemci';
$string['backpackapiurl'] = 'API URL sbírky';
$string['backpackavailability'] = 'Externí ověření odznaku';
$string['backpackavailability_help'] = 'Aby mohli příjemci odznaků prokázat, že je získali od vás, musí být umožněno službě externích úložišť přistupovat na váš portál a ověřovat odznaky, které tento portál přidělil. Váš portál se aktuálně nejeví jako dostupný, co znamená, že odznaky, které jste již vydal nebo vydáte v budoucnosti, nelze ověřit.

**Proč vidím tuto zprávu?**

Je možné, že váš firewall brání přístupu uživatelům mimo vaší sítě, váš portál je chráněn heslem nebo provozujete portál na počítači, který nemá přístup k internetu (například lokální vývojový počítač).

**Je toto problém?**

Tento problém byste měl vyřešit v případě, že se jedná o produkční portál a plánujete vydávat odznaky. V opačném případě příjemci odznaků nebudou moci prokázat, že je dostali od vás. Není-li váš portál zatím připojen, můžete vytvořit a vydat testovací odznaky, které budou k dispozici dočasně, dokud nebude portál připojený k internetu.

**Co když není možné, aby byl celý můj portál veřejně přístupný?**

K ověření je potřebná jediná URL adresa ve tvaru: [URL-vaší-stránky]/badges/assertion.php, takže když víte upravit svůj firewall, aby povoloval externí přístup k tomuto souboru, ověřování odznaků bude fungovat pořád.';
$string['backpackbadgessettings'] = 'Změnit nastavení sbírky';
$string['backpackbadgessummary'] = 'Máte {$a->totalbadges} odznak(ů) zobrazených z kolekce(í) {$a->totalcollections}.';
$string['backpackcannotsendverification'] = 'Nelze odeslat ověřovací e-mail';
$string['backpackconnected'] = 'Sbírka je připojena';
$string['backpackconnection'] = 'Připojit se ke sbírce';
$string['backpackconnection_connected'] = 'Vaše sbírka';
$string['backpackconnection_help'] = 'Ukládejte a sdílejte své odznaky z tohoto webu a zobrazujte veřejné odznaky z jiných webů ve svém uživatelském profilu.';
$string['backpackconnectioncancelattempt'] = 'Spojení pomocí jiné e-mailové adresy';
$string['backpackconnectionconnect'] = 'Připojení ke sbírce odznaků';
$string['backpackconnectionnottested'] = 'Připojení nelze pro tuto sbírku otestovat, protože podporují pouze sbírky Open Badges v2.0.';
$string['backpackconnectionok'] = 'Připojení sbírky bylo úspěšně navázáno';
$string['backpackconnectionresendemail'] = 'Opakované zaslání ověřovacího e-mailu';
$string['backpackconnectionunexpectedmessage'] = 'Sbírka vrátila chybu: "{$a}".';
$string['backpackconnectionunexpectedresult'] = 'Vyskytl se problém s připojením ke sbírce. Váš poskytovatel sbírky posílá tuto zprávu: "{$a}".';
$string['backpackdetails'] = 'Nastavení sbírky';
$string['backpackdisconnected'] = 'Sbírka je odpojena';
$string['backpackemail'] = 'E-mailová adresa';
$string['backpackemail_help'] = 'E-mailová adresa je spojená se sbírkou. Když jste připojeni, budou všechny odznaky získané na těchto stránkách spojeny s touto e-mailovou adresou.';
$string['backpackemail_required'] = 'E-mailová adresa nemůže být prázdná';
$string['backpackemailverificationpending'] = 'Čeká se na ověření';
$string['backpackemailverifyemailbody'] = 'Zdravím,

Téměř jste dokončili připojení ke sbírce s odznaky na "{$a->sitename}".

Chcete-li dokončit připojení ke sbírce, ověřte svou e-mailovou adresu pomocí následujícího tlačítka:

{$a->buttonlink}

Pokud tlačítko nefunguje, můžete zkopírovat a vložit následující adresu URL do prohlížeče:

{$a->link}

Pokud jste se nepokusili připojit ke sbírce s odznaky, můžete tento e-mail klidně ignorovat.

Pokud potřebujete pomoc, obraťte se na správce webu,

{$a->admin}';
$string['backpackemailverifyemailsubject'] = '{$a}: ověřovací e-mail sbírky odznaků Badges';
$string['backpackemailverifypending'] = 'Poslali jsme e-mail na adresu <strong>{$a}</strong>. Kliknutím na ověřovací odkaz v e-mailu aktivujete připojení na sbírku odznaků.';
$string['backpackemailverifysuccess'] = 'Nyní jste připojeni ke své sbírce odznaků.';
$string['backpackemailverifytokenmismatch'] = 'Token v odkazu, na který jste klikli, neodpovídá uloženému tokenu. Ujistěte se, že jste klikli na odkaz v posledním e-mailu, který jste obdrželi.';
$string['backpackexporterror'] = 'Odznak nelze do sbírky exportovat';
$string['backpackexporterrorwithinfo'] = 'Odznak „{$a->badgename}“ nelze exportovat do batohu. Chyba: {$a->error}';
$string['backpackimport'] = 'Nastavení importu odznaku';
$string['backpackimport_help'] = 'Po úspěšném připojení se do úložiště odznaků bude možné odznaky z vašeho úložiště zobrazit na stránce "Moje odznaky" a ve vaším profilu.

V této oblasti si můžete zvolit kolekce odznaků z vašeho úložiště, které byste si přál, aby byly zobrazeny ve vašem profilu.';
$string['backpackprovider'] = 'Poskytovatel Sbírky';
$string['backpacksettings'] = 'Nastavení sbírky';
$string['backpackweburl'] = 'URL sbírky';
$string['badgedetails'] = 'Detaily odznaku';
$string['badgeimage'] = 'Obrázek';
$string['badgeimage_help'] = 'Obrázek by měl mít velikost alespoň 300 x 300 pixelů. Na stránce odznaku se zobrazí jako 300 x 300 pixelů a na stránce profilu uživatele 100 x 100 pixelů.';
$string['badgeissued'] = 'Vydán odznak';
$string['badgeprivacysetting'] = 'Ochrana osobních údajů';
$string['badgeprivacysetting_help'] = 'Odznaky, které obdržíte, mohou být zobrazeny na vašem uživatelském profilu. Toto nastavení Vám umožňuje automaticky zveřejňovat získané odznaky na vaší profilové stránce.

Ve vaší stránce s odznaky však stále můžete nastavit viditelnost jednotlivých odznaků.';
$string['badgeprivacysetting_str'] = 'Automatické zobrazení získaných odznaků na mé profilové stránce';
$string['badges'] = 'Odznaky';
$string['badgesalt'] = 'Sůl pro hašování e-mailové adresy příjemce';
$string['badgesalt_desc'] = 'Použití haše dovoluje službám úložišť odznaků potvrdit dosažení odznaku uživatelem tak, že nemusí být zveřejněna jeho emailová adresa. Toto nastavení by mělo používat pouze čísla a písmena.

POZNÁMKA: Z důvodů ověření příjemce se prosím vyvarujte změn tohoto nastavení, jakmile jste začal vydávat odznaky.';
$string['badgesdisabled'] = 'Na těchto stránkách nejsou odznaky  povoleny.';
$string['badgesearned'] = 'Počet získaných odznaků: {$a}';
$string['badgesettings'] = 'Nastavení odznaků';
$string['badgestatus_0'] = 'Není dostupný';
$string['badgestatus_1'] = 'Dostupný';
$string['badgestatus_2'] = 'Není dostupný (kritéria uzamčena)';
$string['badgestatus_3'] = 'Dostupný (kritéria uzamčena)';
$string['badgestatus_4'] = 'Archivováno';
$string['badgestoearn'] = 'Počet dostupných odznaků: {$a}';
$string['badgesview'] = 'Odznaky kurzu';
$string['badgetags'] = 'Štítky odznaků';
$string['badgeurl'] = 'Vydán odkaz ne odznak';
$string['balignment'] = 'Kompetence ({$a})';
$string['bawards'] = 'Příjemci  {$a}';
$string['bcriteria'] = 'Kritéria';
$string['bdetails'] = 'Upravit podrobnosti';
$string['bendorsement'] = 'Schválení';
$string['bmessage'] = 'Zpráva';
$string['boverview'] = 'Přehled';
$string['brelated'] = 'Související odznaky ({$a})';
$string['bydate'] = 'dokončeno';
$string['claim'] = 'Prohlášení';
$string['claimcomment'] = 'Komentář ke schválení';
$string['claimid'] = 'URL prohlášení';
$string['clearsettings'] = 'Vymazat nastavení';
$string['completioninfo'] = 'Tento odznak byl vydán pro dokončení:';
$string['completionnotenabled'] = 'Tento kurz nemá povoleno dokončení, takže to nemůže být zařazen kritérií pro odznak . Ukončení kurzu může být povoleno v nastavení kurzu.';
$string['configenablebadges'] = 'Je-li povoleno, tato funkce umožňuje vytvářet odznaky a udělit je uživatelům.';
$string['configuremessage'] = 'Zpráva o odznaku';
$string['connect'] = 'Spojit';
$string['connected'] = 'Spojeno';
$string['connecting'] = 'Připojování ...';
$string['contact'] = 'Kontakt';
$string['contact_help'] = 'E-mailová adresa spojená s vydavatelem odznaku.';
$string['copy'] = 'Kopírovat';
$string['copyof'] = 'Kopie {$a}';
$string['course'] = 'Kurz: {$a}';
$string['coursebadges'] = 'Odznaky';
$string['coursebadgesdisabled'] = 'Na těchto stránkách nejsou povoleny odznaky kurzu.';
$string['coursebadgetitle'] = 'Odznak kurzu {$a}';
$string['coursecompletion'] = 'Studenti musí absolvovat tento kurz.';
$string['create'] = 'Nový odznak';
$string['createbutton'] = 'Vytvořit odznak';
$string['creatorbody'] = '<p>{$a->user} splnil všechny požadavky a byl mu udělen odznak. Zobrazit vydané odznaky na {$a->link} </p>';
$string['creatorsubject'] = '"{$a}" byl udělen!';
$string['criteria_0'] = 'Odznak je udělen, když ...';
$string['criteria_1'] = 'Splnění činnosti';
$string['criteria_1_help'] = 'Umožňuje udělení odznaku uživatelům na základě splnění souboru činností v rámci kurzu.';
$string['criteria_2'] = 'Ruční udělení odznaku rolí';
$string['criteria_2_help'] = 'Umožňuje ruční udělování odznaku uživatelem, který má vybranou roli v rámci systému nebo kurzu. Tady můžete nastavit, kdo (uživatel s jakou rolí) může v rámci kurzu ručně udělovat odznaky.';
$string['criteria_3'] = 'Sociální zapojení';
$string['criteria_3_help'] = 'Sociální';
$string['criteria_4'] = 'Absolvování kurzu';
$string['criteria_4_help'] = 'Umožňuje udělit odznak uživatelům, kteří absolvovali kurz. Kritérium může mít další parametry, jako je například minimální známka a datum dokončení kurzu.';
$string['criteria_5'] = 'Absolvování sady kurzů';
$string['criteria_5_help'] = 'Umožňuje udělit odznak uživatelům, kteří absolvovali sadu kurzů. Každý kurz může mít další parametry, jako je například minimální známka a datum dokončení kurzu.';
$string['criteria_6'] = 'Dokončení profilu';
$string['criteria_6_help'] = 'Umožňuje udělit uživatelům odznak vyplněním stanovených polí v jejich profilu. Vyberte z výchozích nebo vlastních polí profilu, která jsou uživateli dostupná.';
$string['criteria_7'] = 'Udělené odznaky';
$string['criteria_7_help'] = 'Umožňuje udělení odznaku uživatelům na základě ostatních odznaků, které získali.';
$string['criteria_8'] = 'Členství v globální skupině';
$string['criteria_8_help'] = 'Umožňuje uživateli udělit odznak  na základě členství v globální skupině.';
$string['criteria_9'] = 'Kompetence';
$string['criteria_9_help'] = 'Umožňuje uživateli udělit odznak na základě kompetencí, které byly splněny.';
$string['criteria_descr'] = 'Uživatelům je udělen tento odznak, když splní následující požadavky:';
$string['criteria_descr_0'] = 'Splnit  <strong>{$a}</strong> z následujících požadavků.';
$string['criteria_descr_1'] = '<strong>{$a}</strong> z těchto činností jsou dokončeny:';
$string['criteria_descr_2'] = 'Tento odznak musí být udělen uživateli s <strong>{$a}</strong> z následujících rolí:';
$string['criteria_descr_4'] = 'Uživatelům musí absolvovat kurz';
$string['criteria_descr_5'] = '<strong>{$a}</strong> z následujících kurzů je nutno dokončit:';
$string['criteria_descr_6'] = '<strong>{$a}</strong> z následujících uživatelských profilů je nutno dokončit:';
$string['criteria_descr_7'] = '<strong>{$a}</strong> z následujících odznaků je třeba získat:';
$string['criteria_descr_8'] = 'Je požadováno členství v <strong>{$a}</strong> následujících globálních skupinách:';
$string['criteria_descr_9'] = 'Musí být splněno <strong>{$a}</strong> následujících kompetencí:';
$string['criteria_descr_bydate'] = '&nbsp;do <em>{$a}</em>';
$string['criteria_descr_grade'] = '&nbsp;s minimálním hodnocením <em>{$a}</em>';
$string['criteria_descr_short0'] = 'Dokončeno <strong>{$a}</strong> z:';
$string['criteria_descr_short1'] = 'Dokončeno <strong>{$a}</strong> z:';
$string['criteria_descr_short2'] = 'Uděleno <strong>{$a}</strong> z:';
$string['criteria_descr_short4'] = 'Dokončit kurz';
$string['criteria_descr_short5'] = 'Dokončeno <strong>{$a}</strong> z:';
$string['criteria_descr_short6'] = 'Dokončeno <strong>{$a}</strong> z:';
$string['criteria_descr_short7'] = 'Splnit <strong>{$a}</strong> z:';
$string['criteria_descr_short8'] = 'Členství v globální skupině  <strong>{$a}</strong>  ze:';
$string['criteria_descr_short9'] = 'Splněno <strong>{$a}</strong> z:';
$string['criteria_descr_single_1'] = 'Následující činnost musí být dokončena:';
$string['criteria_descr_single_2'] = 'Tento odznak udělují uživatelé s některou z následujících rolí:';
$string['criteria_descr_single_4'] = 'Uživatelům musí absolvovat kurz';
$string['criteria_descr_single_5'] = 'Následující kurz musí být dokončen:';
$string['criteria_descr_single_6'] = 'Následující pole profilu je nutno vyplnit:';
$string['criteria_descr_single_7'] = 'Musí být získán následující odznak :';
$string['criteria_descr_single_8'] = 'Členství v následující globální skupině je povinné:';
$string['criteria_descr_single_9'] = 'Musí být splněny následující kompetence:';
$string['criteria_descr_single_short1'] = 'Ukončeno:';
$string['criteria_descr_single_short2'] = 'Uděleno:';
$string['criteria_descr_single_short4'] = 'Absolvovat kurz&nbsp;';
$string['criteria_descr_single_short5'] = 'Ukončeno:';
$string['criteria_descr_single_short6'] = 'Ukončeno:';
$string['criteria_descr_single_short7'] = 'Dokončete:';
$string['criteria_descr_single_short8'] = 'Členství v:';
$string['criteria_descr_single_short9'] = 'Splněné:';
$string['criteriacreated'] = 'Byla vytvořena kritéria odznaků';
$string['criteriadeleted'] = 'Kritéria odznaku byla úspěšně smazána';
$string['criteriasummary'] = 'Přehled kritérií';
$string['criteriaupdated'] = 'Kritéria odznaku byla úspěšně aktualizována';
$string['criterror'] = 'Aktuální parametry vydání';
$string['criterror_help'] = 'Tato sada polí zobrazuje všechny parametry, které byly původně přidány k tomuto požadavku na odznak, ale jsou již k dispozici. Doporučuje se, aby jste překontrolovali parametry, aby jste se ujistil, že uživatelé mohou získat tento odznak v budoucnu.';
$string['currentimage'] = 'Aktuální obrázek';
$string['currentstatus'] = 'Aktuální stav:';
$string['dateawarded'] = 'Datum udělení';
$string['dateearned'] = 'Datum: {$a}';
$string['day'] = 'Dnů';
$string['deactivate'] = 'Zakázat přístup';
$string['deactivatesuccess'] = 'Přístup k odznakům byl úspěšně zakázán.';
$string['defaultissuercontact'] = 'E-mailová adresa vydavatele odznaku';
$string['defaultissuercontact_desc'] = 'E-mailová adresa spojená s vydavatelem odznaku. Pro sbírky Open Badges v2.0 se používá pro ověřování při publikování odznaků do sbírky.';
$string['defaultissuername'] = 'Jméno vydavatele odznaku';
$string['defaultissuername_desc'] = 'Jméno vydávajícího zástupce nebo orgánu.';
$string['defaultissuerpassword'] = 'Heslo vydavatele odznaku';
$string['defaultissuerpassword_help'] = 'Na stránce sbírky je vyžadován účet s e-mailovou adresou, jak je uvedeno v nastavení e-mailové adresy vydavatele odznaku v nastavení Správa /  Odznaky /Nastavení odznaků. Zde by mělo být zadáno heslo pro účet.';
$string['delbadge'] = 'Odstranit odznak "{$a}" a zároveň všechny vydané odznaky?';
$string['delconfirm'] = 'Odstranit a odebrat stávající vydané odznaky';
$string['delcritconfirm'] = 'Skutečně chcete smazat toto kritérium?';
$string['deletehelp'] = '<p>Úplné odstranění odznaku znamená, že všechny informace o něm a záznamy kritérií budou trvale odstraněny. Uživatelé, kteří získali tento odznak, nebudou již moci k němu přistupovat a zobrazit jej ve svých profilech.</p>
<p>Uživatelé, kteří získali tento odznak a již jej umístili do svého externího úložiště odznaků, jej budou nadále mít zobrazen v tomto externím úložišti, ale nebudou moci přistupovat ke kritériím a evidenčním stránkám odkazujícím zpět na tento webový portál.</p>';
$string['delexternalbackpack'] = 'Odstranit sbírku na stránkách';
$string['delexternalbackpackconfirm'] = 'Odstranit sbírku webu  "{$a}"?';
$string['delparamconfirm'] = 'Skutečně chcete smazat tento parametr?';
$string['description'] = 'Popis';
$string['disconnect'] = 'Odpojit';
$string['donotaward'] = 'V současné době není tento odznak aktivní, tak  nemůže být udělen uživatelům. Pokud byste chtěli udělit tento odznak, nastavte jej do stavu aktivní.';
$string['enablebadges'] = 'Povolit odznaky';
$string['endorsement'] = 'Schválení';
$string['error:backpackdatainvalid'] = 'Data vrácená ze sbírky nejsou platná.';
$string['error:backpackemailnotfound'] = 'E-mail  "{$a}" není spojem se sbírkou odznaků. Musíte <a href="http://backpack.openbadges.org"> pro tento účet vytvořit sbírku</a> nebo se přihlaste s jinou e-mailovou adresou.';
$string['error:badgeawardnotfound'] = 'Tento odznak nelze ověřit. Tento odznak mohl být zrušen.';
$string['error:badgenotfound'] = 'Odznak nebyl nalezen';
$string['error:cannotact'] = 'Nelze aktivovat odznak.';
$string['error:cannotawardbadge'] = 'Uživateli nelze udělit odznak .';
$string['error:cannotdeletecriterion'] = 'Toto kritérium nemůže být odstraněno.';
$string['error:cannotrevokebadge'] = 'Nelze zrušit odznak uživatele.';
$string['error:clone'] = 'Odznak nelze naklonovat.';
$string['error:connectionunknownreason'] = 'Připojení nebylo úspěšné, ale nebyl uveden důvod.';
$string['error:duplicatename'] = 'Odznak s tímto názvem již v systému existuje .';
$string['error:externalbadgedoesntexist'] = 'Odznak nebyl nalezen';
$string['error:guestuseraccess'] = 'V současné době pracujete s právy hosta. Chcete-li zobrazit Odznaky potřebujete být přihlášen svým uživatelským účtem.';
$string['error:invalidcriteriatype'] = 'Neplatný typ kritéria.';
$string['error:invalidexpiredate'] = 'Datum vypršení platnosti musí být v budoucnosti.';
$string['error:invalidexpireperiod'] = 'Délka platnosti nemůže být záporná nebo mít nulovou hodnotu.';
$string['error:invalidparambadge'] = 'Odznak neexistuje.';
$string['error:invalidparamcohort'] = 'Globální skupina neexistuje';
$string['error:noactivities'] = 'V tomto kurzu nejsou žádné činnosti se sledováním plnění činností';
$string['error:nobadges'] = 'V současné době neexistují žádné odznaky s povoleným přístupem, které by bylo možné přidat jako kritéria. Odznak webu může mít jako kritéria pouze další odznaky webu. Odznak kurzu může mít jako kritéria další odznaky kurzu nebo odznaky webu.';
$string['error:nocohorts'] = 'Žádné globální skupiny';
$string['error:nocourses'] = 'Žádný kurz nemá povoleno absolvování kurzu, proto nelze žádný zobrazit. Absolvování kurzu musí být povoleno v nastavení kurzu.';
$string['error:nogroupslink'] = '<p>Zobrazí se pouze veřejné kolekce. <a href="{$a}" target="_blank" rel="nofollow">Navštivte svou sbírku</a>  a vytvořte nějakou veřejnou kolekci.</p>';
$string['error:nogroupssummary'] = '<p>Ve vaší sbírce nejsou žádné veřejné kolekce odznaků. </p>';
$string['error:nopermissiontoview'] = 'Nemáte oprávnění k zobrazení příjemců odznak';
$string['error:nosuchbadge'] = 'Odznak s identifikátorem {$a} neexistuje.';
$string['error:nosuchcohort'] = 'Upozornění: Tato globální skupina již není k dispozici.';
$string['error:nosuchcourse'] = 'Upozornění: Tento kurz již není k dispozici.';
$string['error:nosuchfield'] = 'Upozornění: Tento uživatelský profil již není k dispozici.';
$string['error:nosuchmod'] = 'Upozornění: Tato aktivita již není k dispozici.';
$string['error:nosuchrole'] = 'Upozornění: Tato role již není k dispozici';
$string['error:nosuchuser'] = 'Uživatel s touto e-mailovou adresou nemá účet u připojeného poskytovatele sbírky.';
$string['error:notifycoursedate'] = 'Upozornění: Odznaky spojené s kurzem a dokončenými aktivitami nebudou vydány před začátkem kurzu.';
$string['error:parameter'] = 'Upozornění: Pro hladký průběh vydávání odznaku by měl být vybrán aspoň jeden parametr.';
$string['error:relatedbadgedoesntexist'] = 'Neexistuje žádný veřejný odznak s tímto identifikátorem';
$string['error:requesterror'] = 'Žádost o připojení selhala (kód chyby {$a}).';
$string['error:requesttimeout'] = 'Žádost o připojení vypršel před dokončením.';
$string['error:save'] = 'Odznak nelze uložit.';
$string['error:userdeleted'] = '{$a->user} (Tento uživatel v {$a->site} již neexistuje)';
$string['eventbadgearchived'] = 'Odznak archivován';
$string['eventbadgeawarded'] = 'Udělen odznak';
$string['eventbadgecreated'] = 'Odznak vytvořen';
$string['eventbadgecriteriacreated'] = 'Vytvořena kritéria odznaku';
$string['eventbadgecriteriadeleted'] = 'Odstraněna kritéria odznaku';
$string['eventbadgecriteriaupdated'] = 'Aktualizována kritéria odznaku';
$string['eventbadgedeleted'] = 'Odznak odstraněn';
$string['eventbadgedisabled'] = 'Odznak zakázán';
$string['eventbadgeduplicated'] = 'Odznak zkopírován';
$string['eventbadgeenabled'] = 'Odznak  povolen';
$string['eventbadgelistingviewed'] = 'Zobrazen seznam odznaků';
$string['eventbadgerevoked'] = 'Odznak byl zrušen';
$string['eventbadgeupdated'] = 'Odznak  aktualizován';
$string['eventbadgeviewed'] = 'Odznak  zobrazen';
$string['existingrecipients'] = 'Stávající držitelé odznaku';
$string['existsinbackpack'] = 'Odznak již ve sbírce existuje';
$string['expired'] = 'Platnost vypršela';
$string['expiredate'] = 'Platnost odznaku vyprší {$a}.';
$string['expireddate'] = 'Platnost odznaku vypršela {$a}.';
$string['expiredin'] = 'Platnost vypršela {$a}';
$string['expireperiod'] = 'Platnost odznaku vyprší {$a} den (dnů) poté, co byl vydán.';
$string['expireperiodh'] = 'Platnost odznaku vyprší {$a} hodinu (hodin) poté, co byl vydán.';
$string['expireperiodm'] = 'Platnost odznaku vyprší {$a} minut poté, co byl vydán.';
$string['expireperiods'] = 'Platnost odznaku vyprší {$a} vteřin poté, co byl vydán.';
$string['expiresin'] = 'Platnost vyprší {$a}';
$string['expirydate'] = 'Datum vypršení platnosti';
$string['expirydate_help'] = 'Volitelně lze platnost odznaků ukončit k určitému datu, nebo lze datum platnosti vypočítat na základě data, kdy byl odznak uživateli vydán.';
$string['externalbackpack_required'] = 'Pole poskytovatele sbírky nemůže být prázdné';
$string['externalbadges'] = 'Moje odznaky z jiných webových stránek';
$string['externalbadges_help'] = 'Tato oblast obsahuje odznaky z externí sbírky.';
$string['externalbadgesp'] = 'Odznaky z jiných webových stránek:';
$string['externalconnectto'] = 'Chcete-li zobrazit externí odznaky, musíte se <a href="{$a}">připojit ke sbírce</a>.';
$string['fixed'] = 'Pevné datum';
$string['hidden'] = 'Skrytý';
$string['hiddenbadge'] = 'Bohužel, majitel odznaku nedal tyto informace k dispozici.';
$string['hostedurl'] = 'Externí URL';
$string['hostedurldescription'] = 'Externí adresa URL, na které je odznak hostován';
$string['imageauthoremail'] = 'E-mail autora obrázku';
$string['imageauthoremail_help'] = 'Pokud je uvedena, zobrazí se e-mailová adresa autora obrázku odznaku na stránce s odznakem.';
$string['imageauthorname'] = 'Jméno autora obrázku';
$string['imageauthorname_help'] = 'Pokud je uvedeno, zobrazí se jméno autora obrázku odznaku na stránce s odznakem.';
$string['imageauthorurl'] = 'Adresa URL autora obrázku';
$string['imageauthorurl_help'] = 'Je-li zadáno, zobrazí se na stránce s odznakem odkaz na webovou stránku autora obrázku odznaku. Adresa URL by měla mít předponu http:// nebo https://.';
$string['imagecaption'] = 'Titulek obrázku';
$string['imagecaption_help'] = 'Je-li zadáno, zobrazí se na stránce s odznakem popiska obrázku.';
$string['includeauthdetails'] = 'Uveďte podrobnosti o autentizaci se sbírkou';
$string['invalidurl'] = 'Neplatná URL adresa';
$string['issuancedetails'] = 'Vypršení platnosti odznaku';
$string['issuedbadge'] = 'Informace o vydaném odznaku';
$string['issuedby'] = 'Vydal {$a}';
$string['issuedon'] = 'Vydáno {$a}';
$string['issuerdetails'] = 'Podrobnosti o vydavateli';
$string['issueremail'] = 'E-mail';
$string['issueremail_help'] = 'Kontaktní e-mailová adresa organizace, která odznak schválila.';
$string['issuername'] = 'Jméno vydavatele';
$string['issuername_endorsement'] = 'Jméno schvalovatele';
$string['issuername_endorsement_help'] = 'Jméno schvalovatele.';
$string['issuername_help'] = 'Jméno vydavatele odznaku.';
$string['issuerurl'] = 'URL schvalovatele';
$string['issuerurl_help'] = 'Webová stránka organizace, která odznak schválila. Adresa URL by měla mít předponu http:// nebo https://.';
$string['language'] = 'Jazyk';
$string['language_help'] = 'Jazyk používaný na stránce s odznaky.';
$string['listbackpacks'] = 'Seznam sbírek';
$string['localbadges'] = 'Moje odznaky z webu {$a}';
$string['localbadgesh'] = 'Moje odznaky z tohoto webu';
$string['localbadgesh_help'] = 'Všechny odznaky udělené tímto webem za dokončení kurzů, činností či splněním jiných požadavků.

Zde si můžete nastavit, zda mají být vaše odznaky skryté či veřejně viditelné ve vašem uživatelském profilu.

Do svého počítače si můžete stáhnout získané odznaky najendou nebo jednotlivě. Mohou být pak nahrány například do jiné externí sbírky.';
$string['localbadgesp'] = 'Odznaky od  {$a}:';
$string['localconnectto'] = 'Chcete-li sdílet tyto Odznaky mimo tento web musíte se <a href="{$a}"> připojit ke sbírce</a>';
$string['loginbackpacktitle'] = '<strong>Přihlaste se ke sbírce</strong>';
$string['makeprivate'] = 'Nastavit jako soukromé';
$string['makepublic'] = 'Zveřejnit';
$string['managebackpacks'] = 'Správa sbírek';
$string['managebadges'] = 'Správa odznaků';
$string['message'] = 'Zpráva';
$string['messagebody'] = '<p>Obdrželi jste odznak „%badgename%“!</p>
<p>Další informace o tomto odznaku naleznete na stránce s informacemi  %badgelink%.</p>
<p>Odznak si také můžete stáhnout ze stránky {$a}.</p>';
$string['messagesubject'] = 'Blahopřejeme, získali jste odznak!';
$string['method'] = 'Kritérium je splněno, když…';
$string['mingrade'] = 'Požadována minimální známka';
$string['month'] = 'Měsíc(ů)';
$string['moredetails'] = 'Více informací';
$string['mybackpack'] = 'Nastavení mé sbírky';
$string['mybadges'] = 'Moje odznaky';
$string['namewithlink'] = 'Jméno s odkazem';
$string['never'] = 'Nikdy';
$string['newbackpack'] = 'Přidat novou sbírku';
$string['newbadge'] = 'Přidat odznak';
$string['newimage'] = 'Nový obrázek';
$string['noalignment'] = 'Tento odznak nemá uvedeny žádné externí dovednosti nebo normy.';
$string['noawards'] = 'Tento odznak nebyl ještě získán.';
$string['nobackpack'] = 'K tomuto účtu není připojena služba sbírka odznaků.<br/>';
$string['nobackpackbadgessummary'] = 'Ve vybraných kolekcích nejsou žádné odznaky.';
$string['nobackpackcollectionssummary'] = 'Nebyly vybrány žádné kolekce odznaků.';
$string['nobackpacks'] = 'Nejsou k dispozici žádné sbírky';
$string['nobadges'] = 'V současné době nejsou k dispozici žádné odznaky, které by uživatelé mohli získat.';
$string['nocompetencies'] = 'Nebyly vybrány žádné kompetence.';
$string['nocriteria'] = 'Kritéria pro tento odznak nejsou dosud stanovena.';
$string['noendorsement'] = 'Tento odznak nemá schválení.';
$string['noexpiry'] = 'Odznak nemá konec platnosti.';
$string['nomatchingawards'] = 'Zatím nejsou žádní odpovídající příjemci, kteří získali tento odznak.';
$string['nomatchingbadges'] = 'Uživatelé nemají k dispozici žádné odpovídající odznaky, které by mohli získat.';
$string['noparamstoadd'] = 'K tomuto požadavku na odznak nejsou dostupné žádné další parametry.';
$string['norelated'] = 'Tento odznak nemá žádné související odznaky.';
$string['notacceptedrole'] = 'Vaše současná role není mezi rolemi, která může ručně vydávat tento odznak. <br/> Pokud chcete vidět uživatele, kteří tento odznak již získali, navštivte stránku {$a} .';
$string['notconnected'] = 'Nepřipojeno';
$string['notealignment'] = 'Můžou být uvedeny externí dovednosti nebo normy, ke kterým se  odznak vztahuje. Všechny externí dovednosti nebo normy se zobrazují na stránce s odznaky.';
$string['noteendorsement'] = 'Ke zvýšení hodnoty odznaku může být použito potvrzení třetí strany. Například odznak vydaný učitelem může být schválen školou nebo odznak vydaný lokálním vydavatelem může být schválen národní autoritou.';
$string['noterelated'] = 'Odznaky s připojením mohou být označeny jako související. Například odznaky se stejnými kritérii, které jsou zobrazeny v různých jazycích, mohou být označeny jako související. Všechny příslušné odznaky se zobrazují na stránce s odznaky.';
$string['nothingtoadd'] = 'Neexistují žádná dostupná kritéria pro přidání.';
$string['notification'] = 'Upozornit tvůrce odznaku';
$string['notification_help'] = 'Upozornit zprávou tvůrce odznaku, je-li odznak udělen. Můžete si zvolit, jak často bude notifikace odeslána.

* Nikdy - Neposílat žádná upozornění.
* Pokaždé - Pokaždé, kdy je odznak udělen.
* Denně - Souhrnná zpráva jednou za den.
* Týdně - Souhrnná zpráva jednou za týden.
* Měsíčně - Souhrnná zpráva jednou za měsíc.';
$string['notifydaily'] = 'Denně';
$string['notifyevery'] = 'Pokaždé, když';
$string['notifymonthly'] = 'Měsíčně';
$string['notifyweekly'] = 'Týdně';
$string['numawards'] = 'Tento odznak byl vydán  <a href="{$a->link}">{$a->count}</a> uživatelům.';
$string['numawardstat'] = 'Tento odznak byl vydán {$a} uživatelům.';
$string['oauth2issuer'] = 'Služby OAuth 2';
$string['openbadgesv1'] = 'Open Badges v1.0';
$string['openbadgesv2'] = 'Open Badges v2.0';
$string['openbadgesv2p1'] = 'Open Badges v2.1';
$string['othernavigation'] = 'Jiná navigace...';
$string['overallcrit'] = 'z vybraných kriteriích jsou dokončeny.';
$string['password_required'] = 'Heslo nesmí být prázdné';
$string['potentialrecipients'] = 'Potenciální příjemci odznaku';
$string['preferences'] = 'Nastavení odznaků';
$string['privacy:metadata:backpack'] = 'Záznam sbírky odznaků uživatele';
$string['privacy:metadata:backpack:backpackuid'] = 'Jedinečný identifikátor sbírky odznaků';
$string['privacy:metadata:backpack:email'] = 'E-mail přidružený ke sbírce odznaků';
$string['privacy:metadata:backpack:externalbackpackid'] = 'ID sbírky';
$string['privacy:metadata:backpack:userid'] = 'ID uživatele, vlastníka sbírky odznaků';
$string['privacy:metadata:backpackoauth2'] = 'Informace OAuth 2, když se uživatel připojí k externí sbírce';
$string['privacy:metadata:backpackoauth2:issuerid'] = 'ID služby OAuth2';
$string['privacy:metadata:backpackoauth2:scope'] = 'Seznam rozsahu připojení sbírky';
$string['privacy:metadata:backpackoauth2:token'] = 'Token připojení sbírky';
$string['privacy:metadata:backpackoauth2:userid'] = 'ID připojení uživatele ke sbírce';
$string['privacy:metadata:backpackoauth2:usermodified'] = 'ID uživatele upravujícího připojení';
$string['privacy:metadata:badge'] = 'Sbírka odznaků';
$string['privacy:metadata:badge:timecreated'] = 'Čas vytvoření odznaku';
$string['privacy:metadata:badge:timemodified'] = 'Čas úpravy odznaku';
$string['privacy:metadata:badge:usercreated'] = 'ID uživatele, který odznak vytvořil';
$string['privacy:metadata:badge:usermodified'] = 'ID uživatele, který odznak upravil';
$string['privacy:metadata:criteriamet'] = 'Splněná sada kritérií';
$string['privacy:metadata:criteriamet:datemet'] = 'Datum splnění kritéria';
$string['privacy:metadata:criteriamet:userid'] = 'ID uživatele, který kritéria splnil';
$string['privacy:metadata:external:backpacks'] = 'Sdílené Informace, když uživatelé odesílají své odznaky do externí sbírky odznaků';
$string['privacy:metadata:external:backpacks:badge'] = 'Název odznaku';
$string['privacy:metadata:external:backpacks:description'] = 'Popis odznaku';
$string['privacy:metadata:external:backpacks:image'] = 'Obrázek odznaku';
$string['privacy:metadata:external:backpacks:issuer'] = 'Informace o vydavateli';
$string['privacy:metadata:external:backpacks:url'] = 'URL Moodle, kde lze zobrazena informace o vydaném odznaku';
$string['privacy:metadata:issued'] = 'Záznamy vydaných odznaků';
$string['privacy:metadata:issued:dateexpire'] = 'Datum ukončení platnosti vydaného odznaku';
$string['privacy:metadata:issued:dateissued'] = 'Datum udělení';
$string['privacy:metadata:issued:userid'] = 'ID uživatele, kterému byl odznak udělen';
$string['privacy:metadata:manualaward'] = 'Záznam ručního udělení odznaků';
$string['privacy:metadata:manualaward:datemet'] = 'Datum ručního udělení odznaku';
$string['privacy:metadata:manualaward:issuerid'] = 'ID uživatele, který odznak udělil';
$string['privacy:metadata:manualaward:issuerrole'] = 'Role uživatele udělující odznak';
$string['privacy:metadata:manualaward:recipientid'] = 'ID uživatele, kterému byl odznak ručně udělen';
$string['recipient'] = 'Příjemce odznaku';
$string['recipients'] = 'Příjemci odznaku';
$string['recipientvalidationproblem'] = 'Tento uživatel nemůže být ověřen jako příjemce tohoto odznaku.';
$string['relatedbages'] = 'Související odznaky';
$string['relative'] = 'Relativní datum';
$string['requiredbadge'] = 'Do kritéria odznaku by měl být přidán aspoň jeden odznak.';
$string['requiredcohort'] = 'Do kritéria globální skupiny by měla být přidána nejméně jedna globální skupina.';
$string['requiredcompetency'] = 'Ke kompetenci by měla být přidána alespoň jedno kriterium kompetence.';
$string['requiredcourse'] = 'Do kritéria sady kurzů musí být přidán aspoň jeden kurz.';
$string['reviewbadge'] = 'Změny v přístupu k odznaku';
$string['reviewconfirm'] = '<p> To umožní, aby vaše odznaky pro uživatele byly viditelné a umožní jim zahájit získávání. </p>
<p> Je možné, že někteří uživatelé již splňují kritéria získání odznaku a tento odznak bude udělen ihned poté, co jej povolíte. </p>
<p> Jakmile bude odznak udělen, bude <strong> zamčen</strong>. - některá nastavení včetně kritérií a nastavení platnosti již není možné změnit </p>
<p> Jste si jisti, že chcete odznak  "{$a}" zpřístupnit? </p>';
$string['revoke'] = 'Zrušit odznak';
$string['save'] = 'Uložit';
$string['searchname'] = 'Vyhledat dle jména';
$string['selectaward'] = 'Zvolte roli, která bude moci udělovat tento odznak:';
$string['selectgroup_end'] = 'Jsou zobrazeny pouze veřejné kolekce. <a href="{$a}">Navštivte vaši sbírku</a> a vytvořte další veřejné kolekce.';
$string['selectgroup_start'] = 'Které sbírky odznaků se mají zobrazit na těchto stránkách:';
$string['selecting'] = 'S vybranými odznaky…';
$string['setup'] = 'Nastavit připojení';
$string['sitebackpackdeleted'] = 'Sbírka na stránkách byla odstraněna.';
$string['sitebackpacknotdeleted'] = 'Tata sbírka nelze odstranit, protože je aktuálně na stránkách výchozí.';
$string['sitebackpackwarning'] = 'Nelze se připojit ke sbírce.<br/><br/>Zkontrolujte, zda je nastavena "E-mailová adresa vydavatele odznaku" s platným e-mailem pro účet na webové stránce sbírky. <br/><br/>Zkontrolujte, zda je "Heslo vydavatele odznaku" na stránce  <a href="{$a->url}"> nastaveno odznaku správné heslo účtu na webu vydavatele svírky. <br/><br/>Sbírka vrátila: "{$a->warning}"';
$string['sitebadges'] = 'Odznaky stránky';
$string['sitebadges_help'] = 'Odznaky webu mohou být udělena pouze uživatelům za činnosti souvisejících s webovými stránkami. Patří mezi ně dokončení kurzu nebo podle jejich uživatelských profilů. Odznaky mohou být také vydány ručně jedním uživatelem jinému.

Odznaky za činnosti kurzu musí být vytvořeny na úrovni kurzu. Odznaky kurzu lze nalézt v Správa kurzu > Odznaky.';
$string['sitebadgetitle'] = 'webu odznaku {$a}';
$string['status'] = 'Stav odznaku';
$string['status_help'] = 'Stav odznaku určuje jeho chování v systému:

**DOSTUPNÝ** - znamená, že tento odznak může být získán studentem. Pokud je odznak ve stavu Dostupný, nemohou být jeho vlastnosti měněny.

**NEDOSTUPNÝ**  znamená, že tento odznak není studentům dostupný a nemohou ho získat ani ručním přiřazením. Pokud tento odznak ještě nebyl v minulosti některým ze studentů získán, lze jeho vlastnosti měnit.

Pokud byl však odznak již v minulosti někomu udělen, automaticky se **ZAMKNE**. Zamčené odznaky stále mohou být získány či uděleny studentům, ale už se nedají vlastnosti odznaku měnit. Pokud tak chcete upravit vlastnosti u zamčeného odznaku, je třeba odznaku zduplikovat a provádět požadované změny na duplikátu.

*Proč odznaky zamykáme?*

Chceme se ujistit, že všichni studenti, kteří odznak získají, musejí splnit ty samé podmínky. Pokud bychom odznaky nezamykali, mohli by se neustále měnit jejich vlastnosti a podmínky pro získání. Nakonec bychom tu měli studenty, kteří sice mají stejný odznak, avšak pro jeho získání museli splnit naprosto odlišné podmínky.';
$string['statusmessage_0'] = 'Tento odznak není momentálně pro uživatele dostupný. Pokud chcete, aby jej mohli uživatelé získat, povolte přístup.';
$string['statusmessage_1'] = 'Tento odznak je pro uživatele dostupný. Pro provedení změn v nastavení je nutno nejprve zakázat přístup.';
$string['statusmessage_2'] = 'Tento odznak není momentálně pro uživatele dostupný a jeho kritéria jsou zamknutá. Pokud chcete, aby jej mohli uživatelé získat, povolte přístup.';
$string['statusmessage_3'] = 'Tento odznak je pro uživatele dostupný a jeho kritéria jsou zamknutá.';
$string['statusmessage_4'] = 'Tento odznak je archivován.';
$string['subject'] = 'Předmět zprávy';
$string['tagarea_badge'] = 'Odznaky';
$string['tags'] = 'Štítky';
$string['targetcode'] = 'Kód';
$string['targetcode_help'] = 'Jedinečný identifikátor řetězce pro odkaz na na externí dovednost nebo normu v jeho rámci.';
$string['targetdescription'] = 'Popis';
$string['targetdescription_help'] = 'Krátký popis externí dovednosti nebo normy.';
$string['targetframework'] = 'Rámec';
$string['targetframework_help'] = 'Název rámce externí dovednosti nebo normy.';
$string['targetname'] = 'Název';
$string['targetname_help'] = 'Odznak se vztahuje na dovednost nebo normu.';
$string['targeturl'] = 'URL';
$string['targeturl_help'] = 'Odkaz na stránku popisující dovednost nebo normu. Adresa URL by měla mít předponu http:// nebo https://.';
$string['testbackpack'] = 'Vyzkoušejte sbírku "{$a}"';
$string['testsettings'] = 'Test nastavení';
$string['type'] = 'Typ';
$string['userbadges'] = 'Uživatelské odznaky';
$string['variablesubstitution'] = 'Náhrada proměnných ve zprávách.';
$string['variablesubstitution_help'] = 'Ve zprávě odznaku, lze vložit do předmětu a/nebo těla zprávy některé proměnné tak, že budou nahrazeny skutečnými hodnotami v odeslané zprávě . Proměnné by měly být vloženy do textu, přesně tak, jak je uvedeno níže. Mohou být použity následující proměnné:

%badgename%
: tato proměnná bude nahrazena celým jménem odznaku.

%username%
: tato proměnná bude nahrazena celým jménem příjemce.

%badgelink%
: tato proměnná bude nahrazena veřejným URL s informacemi o vydaném odznaku.';
$string['verifyemail'] = 'Ověřovací e-mail';
$string['version'] = 'Verze';
$string['version_help'] = 'Pole verze může být použito ke sledování vývoje odznaku. Je-li uvedena, zobrazí se verze na stránce s odznaky.';
$string['viewbadge'] = 'Zobrazit vydaný odznak';
$string['visible'] = 'Viditelný';
$string['warnexpired'] = '(Platnost odznaku vypršela!)';
$string['year'] = 'Rok(y)';
