<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodleorg', language 'nl', version '4.4'.
 *
 * @package     local_moodleorg
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutstatistics'] = 'Moodle kan gratis gedownload worden en registratie is vrijwillig. We hebben daarom niet alle informatie van iedereen die Moodle gebruikt. Met wat we wel weten genereren we automatisch een aantal interessante statistieken en cijfers voor onze statistiekenpagina.';
$string['aboutstatisticsheading'] = 'Moodle in cijfers';
$string['aboutstatisticstitle'] = 'Moodle.org: Moodle statistieken';
$string['activeusers24hours'] = 'Geregistreerde gebruikers in de laatste 24 uur:';
$string['activeuserspastmonth'] = 'Geregistreerde bezoekers in de laatste maand:';
$string['browsegittitle'] = 'Blader in onze broncode';
$string['cachedef_frontpagecolumn'] = 'Kollomen startpagina';
$string['cachedef_usefulposts'] = 'Nuttige forumberichten';
$string['communities'] = 'Gemeenschappen';
$string['communitiesmy'] = 'Mijn gemeenschappen';
$string['community'] = 'Gemeenschap';
$string['communityadministration'] = 'Community-beheer';
$string['communitycurrent'] = 'Huidige gemeenschap';
$string['communityenrolme'] = 'Wordt lid van deze gemeenschap';
$string['communityenrolmentoptions'] = 'Lid worden van een gemeenschap';
$string['communityintro'] = 'Moodle heeft een grote en diverse gebruikersgemeenschap met meer dan <a href="http://moodle.org/userpics">{$a->usercount} geregistreerde gebruikers</a>  alleen al op deze site, die meer dan <a href="http://download.moodle.org/langpack/">{$a->langcount} talen spreke languages</a> en uit <a href="http://moodle.org/sites">{$a->countrycount} landen </a>komen  (we hebben <a href="http://moodle.org/stats">meer statistieken</a>).';
$string['communityjoinbyyourself'] = 'Voeg jezelf toe';
$string['communityjoinbyyourselfas'] = 'Voeg jezelf toe als {$a->rolename}';
$string['communitynoguestaccess'] = 'Gasten kunnen niet in deze zone. Meldt jezelf aan.';
$string['communitynotenrollable'] = 'Je kunt jezelf geen lid maken van deze gemeenschap. Neem contact op met de beheerder.';
$string['communitysomeallowguest'] = 'Sommige gemeenschappen laten gasten toe';
$string['communityunenrolme'] = 'Verlaat gemeenschap {$a}';
$string['conferencecenter'] = 'Moodle conferentiecentrum';
$string['connectedsites'] = 'Sommige Moodle-sites zijn verbonden met Moodle.org via Moodle netwerk.Je kunt daar onmiddellijk aanmelden als je hier aangemeld bent.';
$string['donations10over'] = 'Andere donaties van $10 of meer';
$string['donationsassociation'] = 'Wordt lid van de <a href="https://moodleassociation.org/">Moodle Association</a> - help mee om te beslissen aan welke Moodle-onderdelen de ledenbijdrage gespendeerd moet worden.';
$string['donationsdevelopment'] = 'De ontwikkeling van Moodle en het onderhoud van al onze community sites kost veel geld. Daarom kunnen we altijd extra steun gebruiken. Als je Moodle geweldig vindt of je vindt het nuttig voor jouw bedrijf, school of instituut, maak dan een donatie. Alle beetjes helpen.';
$string['donationsdonatenow'] = 'Doneer nu';
$string['donationsensure'] = 'Donaties aan Moodle zorgen er voor dat de radertjes van de Moodle machine (onze ontwikkelaars) blijven nieuwe functies ontwikkelen en problemen oplossen en hiermee Moodle beter maken voor iedereen.';
$string['donationsmoodle'] = 'Doneren aan Moodle';
$string['donationsopensource'] = 'Moodle is écht open bron en geeft geen financiële verplichtingen voor onze gebruikers - dat is hoe alle software zou moeten zijn!';
$string['donationsover1000'] = 'Vorige donaties boven $ 1000';
$string['donationsover200'] = 'Andere donaties boven $ 200';
$string['donationsover500'] = 'Andere donaties boven $500';
$string['donationspartner'] = 'Gebruik een <a href="https://moodle.com/partners/">certified Moodle Partner</a> voor diensten -10% van hun inkomen gaat naar het Moodle project.';
$string['donationsshop'] = 'Koop iets van onze <a href="http://www.zazzle.com/moodle_hq/">Moodle store</a> en gebruik het met trots!';
$string['donationsthankeveryone'] = 'Bedankt aan iedereen die heeft bijgedragen tot het Moodle project.';
$string['donationsthankyou'] = 'Bedankt';
$string['donationstitle'] = 'Donaties';
$string['donationsways'] = 'Andere manieren om financieel bij te dragen aan Moodle:';
$string['download_activities'] = 'Activiteiten';
$string['download_admintools'] = 'Beheer tools';
$string['download_appdocumentation'] = 'App documantatie';
$string['download_appreleasenotes'] = 'Release-notes';
$string['download_browseall'] = 'Alles doorbladeren';
$string['download_downloadosx'] = 'Download Moodle voor OS X (bevat Moodle, Apache, MySQL en PHP voor Mac OS)';
$string['download_downloadwindows'] = 'Download Moodle voor Windows (bevat Moodle, Apache, MySQL en PHP voor Windows OS)';
$string['download_forandroid'] = 'Voor Android';
$string['download_forios'] = 'Voor IOS';
$string['download_helpbox_description'] = 'Lees de documentatie en bezoek onze community forums of neem contact op met een Moodle Partner voor hosting, installatie en andere diensten.';
$string['download_helpbox_installing'] = 'Moodle installeren';
$string['download_helpbox_partners'] = 'Moodle partners';
$string['download_helpbox_support'] = 'Ondersteuningsforums';
$string['download_helpbox_title'] = 'Hulp nodig?';
$string['download_helpbox_upgrading'] = 'Moodle upgraden';
$string['download_hero_description'] = 'Het is onder de <a class="link" href="http://docs.moodle.org/dev/License">GPL-licentie</a>, wat betekend dat iedereen de software vrij mag gebruiken.<br><br>Bekijk de laatste Moodle-versie.';
$string['download_hero_headline'] = 'Moodle is open bron.';
$string['download_langpackinfo'] = 'Er worden automatisch taalpakketten gegenereerd uit het werk van onze vertalers op de <a href="http://lang.moodle.org/">vertaal-site</a>. Meer informatie op de  <a href="https://docs.moodle.org/dev/Translation">vertaaldocumentatie</a>.';
$string['download_langpackinstallinfo'] = 'Er kunnen bijkomende taalpakketten geïnstalleerd worden op je Moodle-site via <em>Beheer > Site beheer > Talen > Taalpakketten</em>, of manueel. Bekijk voor meer informatie de <a href="https://docs.moodle.org/en/Language_packs">taalpakket documentatie</a>.';
$string['download_langpackinstalltitle'] = 'Installatie van taalpakketten';
$string['download_langpacktitle'] = 'Taalpakketten voor Moodle {$a}';
$string['download_mobileapp'] = 'Mobiele app';
$string['download_themes'] = 'Thema\'s';
$string['download_viewallbuilds'] = 'Bekijk alle versies (vereist een werkende webserver, PHP en een databank)';
$string['downloadcore'] = 'Onze belangrijkste distributiemethode is via deze standaard pakketten. Er zitten een aantal modules in die door het hoofd ontwikkelingsteam onderhouden worden en zijn gemakkelijk te installeren op nagenoeg elk platvorm waarop PHP en een databank geïnstalleerd staan.';
$string['downloadcoretitle'] = 'Standaard Moodle-pakketten';
$string['downloadintro'] = 'Moodle is open bron onder de <a href="http://docs.moodle.org/dev/License">GPL licentie</a>. Alles wat we maken gratis  voor jou beschikbaar om te downloaden en te gebruiken.';
$string['downloadlang'] = 'In de huidige versies van Moodle is het toevoegen van taalondersteuning geautomatiseerd vanuit het beheermenu van je site. Voor sommige oudere versies van Moodle moeten taalpakketten handmatig gedownload worden.';
$string['downloadlangtitle'] = 'Taalpakketten';
$string['downloadmac'] = 'Als je nog geen webserver klaar hebt, kunnen deze alles-in-één-pakketten  het je  heel gemakkelijk maken om Moodle op gelijk welke Applecomputer met Mac OS X te installeren';
$string['downloadmactitle'] = 'Moodle voor Mac OS X';
$string['downloadmodules'] = 'Blader door onze databank met extra modules en plugins die aan je Moodlesite kunnen toegevoegd worden om extra functionalliteit buiten de standaardmodules toe te voegen.';
$string['downloadmodulestitle'] = 'Plugins';
$string['downloadthemes'] = 'Hoe Moodle er uit ziet kan heel sterk aangepast worden door een ander thema te gebruiken. We hebben een databank met thema\'s die ander Moodlegebruikers gemaakt en gedeeld hebben.';
$string['downloadthemestitle'] = 'Thema\'s';
$string['downloadviagitcvs'] = 'Andere manieren om Moodle te bekomen: <a href="http://docs.moodle.org/en/Git_for_Administrators">downloaden via Git</a> or <a href="http://docs.moodle.org/22/en/CVS_for_Administrators">downloaden via CVS</a>';
$string['downloadwin'] = 'Als je nog geen webserver klaar hebt, kunnen deze alles-in-één-pakketten  het je  heel gemakkelijk maken om Moodle op gelijk welke Windowscomputer te installeren.';
$string['downloadwintitle'] = 'Moodle voor Windows';
$string['erroradminonly'] = 'Enkel beheerders hebben toegang tot deze interface.';
$string['erroralreadyvoted'] = 'Je hebt al gestemd voor {$a}';
$string['errormaxmessages'] = 'Sorry, maar je mag niet meer dan 3 berichten verzenden';
$string['errornomainnews'] = 'Kon geen nieuwsforum vinden of maken voor deze site';
$string['errorsendingmail'] = 'Er is een fout opgetreden bij het versturen van het bericht. Probeer later opnieuw of contacteer de sitebeheerder';
$string['eventdonation_created'] = 'Lijst donatie gemaakt';
$string['eventdonation_submitted'] = 'Donatie ingestuurd';
$string['events'] = 'Hoewel we ons specialiseren in online leren, is het toch ook wel leuk om eens samen in één kamer te zitten! Neem een kijkje naar deze links voor meer informatie over onze conferentie (we noemen ze MoodleMoots) en andere evenementen';
$string['eventstitle'] = 'Evenementen';
$string['feed_events'] = 'Gebeurtenissen';
$string['feed_events_more'] = 'Meer kalenderitems';
$string['feed_news'] = 'Aankondigingen';
$string['feed_news_more'] = 'Bekijk alle aankondigingen';
$string['feed_resources'] = 'Bronnen';
$string['feed_useful'] = 'Nuttige berichten';
$string['feed_useful_more'] = 'Meer berichten';
$string['focusbox_community'] = 'Hulp en gemeenschapsdiscussies';
$string['focusbox_community_text'] = 'Krijg hulp en deel ideeën in je eigen taal.';
$string['focusbox_community_viewall'] = 'Alle gemeenschappen';
$string['focusbox_future'] = 'Bepaal mee de toekomst van Moodle';
$string['focusbox_future_crowdfund'] = 'Crowdfunding-projecten';
$string['focusbox_future_gdf'] = 'Ontwikkelaarsdiscussies';
$string['focusbox_future_research'] = 'Moodle research';
$string['focusbox_future_roadmap'] = 'Roadmap';
$string['focusbox_future_text'] = 'Zoek de volgende stap en maak mee het verschil.';
$string['focusbox_future_ux'] = 'Discussies over gebruikerservaringen (UX)';
$string['focusbox_settingup'] = 'Installatie';
$string['focusbox_settingup_community'] = 'Ondersteuning door de gemeenschap';
$string['focusbox_settingup_download'] = 'Gratis download';
$string['focusbox_settingup_hosting'] = 'Hosting';
$string['focusbox_settingup_install'] = 'Installatie';
$string['focusbox_settingup_own'] = 'Zelf doen';
$string['focusbox_settingup_partner'] = 'Via een Moodle Partner';
$string['focusbox_settingup_plugins'] = 'Plugins';
$string['focusbox_settingup_support'] = 'Commerciële ondersteuning';
$string['focusbox_teaching'] = 'Les geven met Moodle';
$string['focusbox_teaching_books'] = 'Boeken';
$string['focusbox_teaching_courses'] = 'Cursussen en inhoud';
$string['focusbox_teaching_docs'] = 'Documentatie';
$string['focusbox_teaching_text'] = 'Verken de mogelijkheden van Moodle en bekijk beschikbare informatiebronnen';
$string['focusbox_theproject'] = 'Het Moodleproject';
$string['focusbox_theproject_about'] = 'Over Moodle';
$string['focusbox_theproject_devs'] = 'Ontwikkelaars';
$string['focusbox_theproject_hq'] = 'Moodle HQ';
$string['focusbox_theproject_mua'] = 'Moodle Users Association';
$string['focusbox_theproject_partners'] = 'Moodle partners';
$string['focusbox_theproject_stats'] = 'Statistieken';
$string['focusbox_theproject_text'] = 'Meer weten over het Moodle-project en onze open samenwerkingsvenootschappen';
$string['focusbox_uptodate'] = 'Blijf up-to-date';
$string['focusbox_uptodate_buzz'] = 'Moodle buzz';
$string['focusbox_uptodate_news'] = 'Aankondigingen';
$string['focusbox_uptodate_planet'] = 'Planet Moodle';
$string['focusbox_uptodate_security'] = 'Beveiligingsaankondigingen';
$string['focusbox_uptodate_social'] = 'Sociale media';
$string['focusbox_uptodate_text'] = 'Laatste Moodle-nieuws, updates en inzichten wereldwijd.';
$string['generaldeveloperforum'] = 'Algemeen ontwikkelaarsforum';
$string['graphpopulation'] = 'Moodle populatiegrafiek';
$string['graphregistrationmap'] = 'Moodle registratiekaart';
$string['graphregistrationmapdesc'] = 'Top 10 van geregistreerde sites in {$a} landen';
$string['graphusersites'] = 'Moodlegebruikers vergeleken met sites';
$string['heroslide_community_description'] = 'Welkom bij de Moodle-gemeenschap. Ontdek de waarde van open samenwerken door één van de grootste open source teams ter wereld.';
$string['heroslide_community_headline'] = 'Gestuurd door de gemeenschap, wereldwijde ondersteuning.';
$string['heroslide_community_slidecontrol'] = 'Ondersteund door een wereldwijde gemeenschap.';
$string['heroslide_donate_headline'] = 'Help ons het verschil te maken met open en kwaliteitsvol onderwijs voor iedereen';
$string['heroslide_getstarted40_description'] = 'Moodle LMS heeft een vernieuwd look en een nieuwe gebruikerservaring voor beter online lesgeven en leren voor leraren, studenten en beheerders.';
$string['heroslide_getstarted40_headline'] = 'Moodle 4.0 - Nieuwe look, betere gebruikerservaring!';
$string['heroslide_getstarted40_slidecontrol'] = 'Moodle 4.0 is klaar!';
$string['heroslide_getstarted_description'] = 'Moodle is de populairste leeromgeving ter wereld. Je eigen online leeromgeving maak je in enkele minuten!';
$string['heroslide_getstarted_headline'] = 'Beginnen met Moodle is makkelijk';
$string['heroslide_getstarted_slidecontrol'] = 'Begin vandaag';
$string['heroslide_global_description'] = 'Moodle wordt gebruikt door organisaties en instituten, grote en kleine, met miljoenen gebruikers over heel de wereld en is beschikbaar in meer dan 100 talen.';
$string['heroslide_global_headline'] = 'De motor van leeromgevingen over heel de wereld';
$string['heroslide_global_slidecontrol'] = 'De motor van leeromgevingen over heel de wereld';
$string['heroslide_link_demo'] = 'Demo';
$string['heroslide_link_donate'] = 'Maak een donatie';
$string['heroslide_link_features'] = 'Mogelijkheden';
$string['heroslide_link_forums'] = 'Community forums';
$string['heroslide_link_getstarted'] = 'Begin vandaag';
$string['heroslide_link_getstarted40'] = 'Meer over Moodle 4.0';
$string['heroslide_link_sites'] = 'Geregistreerde sites';
$string['heroslide_link_stats'] = 'Statistieken';
$string['heroslide_link_stories'] = 'Lees meer';
$string['heroslide_power40_description'] = 'Gemakkelijk, snel en intuïtief! Verken de verbeterde gebruikerservaring en nieuwe functies van Moodle 4.0.';
$string['heroslide_power40_headline'] = 'Beleef Moodle 4.0';
$string['heroslide_power40_slidecontrol'] = 'Beleef Moodle 4.0';
$string['heroslide_power_description'] = 'Het gratis leerplatform dat effectief online lesgeven  en leerervaringen in een privaat samenwerkingsverband mogelijk maakt.';
$string['heroslide_power_headline'] = 'Krachtig. Veilig. Open Source';
$string['heroslide_power_slidecontrol'] = 'Robuust open source leerplatform';
$string['heroslide_story1_description'] = '“Leading in technology-enabled learning enables us to facilitate student discovery, creativity and opportunity.” - Professor Darrell Evans, Pro Vice-Chancellor (Learning and Teaching), Monash University';
$string['heroslide_story1_headline'] = 'Beter lesgeven en leren, overal';
$string['heroslide_story2_description'] = 'GAC, een globale provider voor scheepvaart, logistiek en mariene diensten levert educatie en ontwikkelingsinitiatieven aan meer dan 10000 werknemers in meer dan 70 landen met hun Corporate Academy';
$string['heroslide_story2_headline'] = 'Excellent bijscholen in bedrijven';
$string['heroslide_story3_description'] = 'Forth Valley College is een van Schotland\'s grootste colleges en biedt meer dan 750 cursussen aan voor hun 20000 actieve cursisten op hun sites.';
$string['heroslide_story3_headline'] = 'All-round flexibel educatiemateriaal';
$string['heroslide_story4_description'] = 'Voluntary Service Overseas (VSO) levert interactief leren en ondersteuning voor vrijwilligers wereldwijd om globale training mogelijk te maken.';
$string['heroslide_story4_headline'] = 'Vrijwilligers helpen met educatieprogramma\'s om armoede te bestrijden';
$string['heroslide_story_slidecontrol'] = 'Moodle-verhalen van over heel de wereld';
$string['jobs'] = 'Bezoek onze databank met jobs voor informatie over Moodle-gerelateerd werk over heel de wereld';
$string['logoinfo'] = 'De naam Moodle™ is een geregistreerd handelsmerk van de Moodle Trust.

Als je de naam en/of het logo wil gebruiken om Moodle diensten (vb Moodle hosting, Moodle ondersteuning, Moodle certifiering, Moodle training, Moodle consulting,  Moodle aanpassingen, Moodle cursusontwerp, Moodle thema-ontwerp, Moodle integraties, Moodle installatie enz) of als naam van een software-pakket, dan moet je toestemming vragen en krijgen van de Moodle Trust via de [moodle.com helpdesk](http://moodle.com/helpdesk/), in overeenstemming met normale handelsmerkbeperkingen.

Er zijn geen beperkingen over hoe je de naam in andere contexten gebruikt (bijvoorbeeld als je Moodle enkel gebruikt om cursussen aan te bieden, dan kun je de naam vrij gebruiken om er naar te verwijzen). Als je niet zeker weet of jouw gebruik van de naam legitiem is, leg je vraag dan voor via de [moodle.com helpdesk](http://moodle.com/helpdesk/). We zullen je helpen met een officiële toestemming of met het verbeteren van je verwoording.';
$string['logotitle'] = 'Moodle logo';
$string['manageads'] = 'Beheer partner advertenties';
$string['managedonations'] = 'Beheer donaties';
$string['moodleorg:manageads'] = 'Beheer partner advertenties';
$string['moodleorg:managedonations'] = 'Beheer het registreren van donaties';
$string['moodlepartner_corporate'] = 'Bedrijfstraining';
$string['moodlepartner_other'] = 'Andere sectoren';
$string['moodlepartner_school'] = 'School';
$string['moodlepartner_university'] = 'Universiteit';
$string['networkinfo'] = 'Volgende Moodle-sites zijn verbonden met moodle.org door gebruik te maken van Moodle networking, zodat je rechtstreeks van hieruit daar kunt aanmelden.';
$string['networktitle'] = 'Verbonden sites';
$string['newregistrations'] = 'Nieuwe registraties';
$string['newstitle'] = 'Aankondigingen';
$string['noenrolledcoursesyet'] = 'Je bent nog bij geen enkele cursus van deze site aangemeld';
$string['partnerslogan'] = 'Het Moodle-project wordt ondersteund door meer dan 90 gecertificeerde <a href="https://moodle.com/partners/">Moodle partners</a> wereldwijd.';
$string['permalink'] = 'Permanente link';
$string['pluginname'] = 'Moodle.org site';
$string['popularissues'] = 'Meest populaire items';
$string['privacy:metadata:db:registerdonations'] = 'Bevat records met Moodle donaties';
$string['privacy:metadata:db:registerdonations:amount'] = 'Gedoneerd bedrag';
$string['privacy:metadata:db:registerdonations:name'] = 'Naam donateur';
$string['privacy:metadata:db:registerdonations:org'] = 'Organisatie donateur';
$string['privacy:metadata:db:registerdonations:timedonated'] = 'Tijdstip van donatie';
$string['privacy:metadata:db:registerdonations:url'] = 'URL donateur';
$string['recentlyratedposts'] = 'Recent beoordeelde berichten';
$string['recentpart'] = 'Deze pagina toont enkele mensen die vandaag moodle.org gebruiken.';
$string['registeredsites'] = 'Het is niet nodig dat instituten iemand er van op de hoogte brengen dat ze Moodle gebruiken, omdat Moodle open bronsoftware is. Sommige Moodle sites hebben er voor gekozen zich bij ons te registreren en we houden daarvan een bij.';
$string['registeredsitestitle'] = 'Geregistreerde sites';
$string['registereduserslastday'] = 'Nieuwe gebruikers in de laatste 24 uur';
$string['registereduserstotal'] = 'Totaal aantal geregistreerde gebruikers';
$string['registrationgraphalt'] = 'Alle Moodleregistraties ooit';
$string['registrationgraphdesc'] = 'We doen regalmatig <a href="http://docs.moodle.org/en/Usage">bulk tests van sites</a> om na te gaan of ze nog bestaan. Je kunt dus af en toe zien dat het aantal sites vermindert.';
$string['registrationslast6months'] = 'Registraties in de afgelopen 6 maand';
$string['registrationslastmonths'] = 'Registraties in de voorbije {$a} maanden';
$string['registrationstotal'] = 'Alle huidige registraties';
$string['resources_buzz'] = 'Buzz';
$string['resources_courses'] = 'Cursussen';
$string['resources_jobs'] = 'Jobs';
$string['resources_plugins'] = 'Plugins';
$string['roadmap'] = 'Moodle roadmap';
$string['rssdescription'] = 'Recente of als nuttig beoordeelde forumberichten van moodle.org';
$string['rssmoodlecommore'] = 'Bekijk het laatste nieuws';
$string['rssmoodlecomtitle'] = 'Laatste nieuws';
$string['rsstitle'] = 'Moodle.org forumberichten';
$string['searchmoodleorg'] = 'Doorzoek moodle.org';
$string['securitytitle'] = 'Beveiligingsaankondigingen';
$string['shop'] = 'Zoek je een manier om duidelijk te maken dat je een deel bent van onze gemeenschap? Kijk dan eens in onze shop. We hebben T-shirts, mokken en allerlei andere hebbedingetjes.';
$string['social-facebook-moodle'] = 'Officiële Moodle-pagina op Facebook';
$string['social-googleplus-community'] = 'Officiële Moodle-gemeenschapspagina om Google+';
$string['social-googleplus-moodle'] = 'Officiële Moodle-pagina op Google+';
$string['social-linkedin-moodle'] = 'Officiële Moodle-pagina op LinkedIn';
$string['social-twitter-moodle'] = 'Officiële Moodle-aankondigingen, geaggregeerd Moodle-nieuws van Planet Moodle en Moodle buzz en nuttige forumberichten';
$string['social-twitter-moodledev'] = 'Moodle ontwikkelingsnieuws en updates';
$string['social-twitter-moodlehq'] = 'Tweets van Moodle HQ';
$string['social-twitter-moodlejobs'] = 'Moodle-gerelateerde werkaanbiedingen';
$string['social-twitter-moodlenet'] = 'Gedeelde Moodle-cursussen en inhoud';
$string['social-twitter-moodleplugins'] = 'Recente nieuwe Moodle add-ons';
$string['social-twitter-moodleresearch'] = 'Nieuws en updates van de jaarlijkse Moodle Research Conferentie en Moodle-gerelateerde research';
$string['social-twitter-moodlesecurity'] = 'Moodle beveiligingsaankondigingen';
$string['social-twitter-moodlesites'] = 'Statusupdates van de sites en services van het Moodle HQ netwerk';
$string['social-twitter-moodlethemes'] = 'Recente nieuwe Moodle thema\'s';
$string['social-youtube-moodle'] = 'Officiëel Moodle-kanaal op YouTube';
$string['socialinfo'] = 'We zijn op verschillende sociale mediapagina\'s vertegenwoordigd om te helpen Moodle bekend te maken en om het laatste nieuws en gebeurtenissen in de Moodle-wereld te verspreiden.
Volg ons om up-to-date te blijven en om anderen uit de gemeenschap te ontmoeten.';
$string['socialtitle'] = 'Sociale media';
$string['statscountries'] = 'Landen';
$string['statscourses'] = 'Cursussen';
$string['statsenrolments'] = 'Aanmeldingen';
$string['statsposts'] = 'Forumberichten';
$string['statsquestions'] = 'Testvragen';
$string['statsresources'] = 'Bronnen';
$string['statsteachers'] = 'Leraren';
$string['statsusers'] = 'Gebruikers';
$string['supportbooks'] = 'We houden een lijst bij van de vele Moodle boeken die er te koop zijn.';
$string['supportcommercial'] = 'Moodle Partners zijn Certified Service Providers die je zullen helpen met je Moodle-implementatie.';
$string['supportdocs1'] = 'Moodle Docs is een goede plaats om te beginnen, vooral onze pagina\'s met veel gestelde vragen.';
$string['supportdocs2'] = 'Een aangename manier om relevante documentatie te vinden is de link "Hulp uit Moodle Docs voor deze pagina" te volgen die onderaan elke pagina van je Moodle site staat.';
$string['supportdocsfaq'] = 'Veelgestelde vragen';
$string['supportdocslang'] = 'Moodle Docs in andere talen';
$string['supportforums'] = 'Onze gebruikersgemeenschap communiceert vooral via forums in "cursussen" op deze Moodlegebaseerde site. Je moet je "aanmelden" in een cursus om berichten te kunnen posten (aanmelden is volledig gratis).';
$string['supportforumsenglish'] = 'De belangrijkste ondersteunings- en ontwikkelingsdiscussies tussen gebruikers en ontwikkelaars zijn in het Engels en hier te vinden:';
$string['supportforumsenglishname'] = 'Moodle gebruiken';
$string['supportforumslang'] = 'Het belangrijkste forum om te kletsen in het Nederlands is hier:';
$string['supportforumslangname'] = 'Moodle lounge';
$string['supportforumslangurl'] = 'http://moodle.org/course/view.php?id=13';
$string['supportforumslist'] = 'We hebben nog vele ander forums, in vele talen:';
$string['supportforumslistname'] = 'Lijst met alle cursussen';
$string['supportintro'] = 'Je bent niet alleen! Er zijn vele manieren om hulp met Moodle te krijgen als je die nodig hebt.';
$string['syncregistrationstask'] = 'Sync 1.9 site registratie-updates naar moodle.net';
$string['top10countriesbyregistration'] = 'Top 10 landen volgens aantal registraties';
$string['top10sitesbycourses'] = 'Top 10 sites per aantal cursussen';
$string['top10sitesbyusers'] = 'Top 10 sites per aantal gebruikers';
$string['url-about'] = 'http://docs.moodle.org/en/About_Moodle';
$string['url-features'] = 'http://docs.moodle.org/en/Features';
$string['url-install'] = 'http://docs.moodle.org/en/Installation';
$string['url-standards'] = 'http://docs.moodle.org/en/Standards';
$string['url-userdocs'] = 'http://docs.moodle.org/en/';
$string['versionsused'] = 'Gebruikte versies';
