<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'ro', version '4.4'.
 *
 * @package     lesson
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Control acces';
$string['actionaftercorrectanswer'] = 'Acţiune după răspuns corect';
$string['actionaftercorrectanswer_help'] = 'După ce se răspunde la o întrebare în mod corect, există trei opţiuni pentru pagina următoare:

* Normal - Urmaţi calea lecţiei
* Arată-mi o pagină nouă - Paginile sunt prezentate într-o ordine aleatorie, nici o pagină nu va apărea de două ori
* Arată o pagină la care nu s-a raspuns - Paginile sunt prezentate într-o ordine aleatorie, fiind afișate doar cele care conţin întrebări care nu au fost abordate.';
$string['actions'] = 'Acţiuni';
$string['activitylink'] = 'Link la activitatea următoare';
$string['activitylink_help'] = 'Pentru a furniza un link la sfârșitul lecției către o altă activitate din curs, selectați activitatea din meniul derulant.';
$string['activitylinkname'] = 'Mergi la {$a}';
$string['activityoverview'] = 'Aveți lecții care au termenul de parcurgere depășit';
$string['addabranchtable'] = 'Adăugați o pagină de conținut';
$string['addanendofbranch'] = 'Adăugați un final de ramură';
$string['addanewpage'] = 'Adaugă o pagină nouă';
$string['addaquestionpage'] = 'Adaugă o pagină cu întrebări';
$string['addaquestionpagehere'] = 'Adaugă o pagină cu întrebări aici';
$string['addbranchtable'] = 'Adaugă o pagină cu conținut';
$string['addcluster'] = 'Adăugați un grup de pagini';
$string['addedabranchtable'] = 'S-a adăugat o pagină cu conținut';
$string['addedanendofbranch'] = 'Un final de ramură a fost adăugat';
$string['addedaquestionpage'] = 'A fost adăugată o pagină cu întrebări';
$string['addedcluster'] = 'A fost adăugat un grup de pagini';
$string['addedendofcluster'] = 'S-a adăugat un sfârșit de grup de pagini';
$string['addendofbranch'] = 'Adaugă un final de ramură';
$string['addendofcluster'] = 'Adaugă un final de grup de pagini';
$string['addessay'] = 'Creați o pagină cu întrebare de tip eseu';
$string['addmatching'] = 'Creați o pagină cu întrebare de tip potrivire';
$string['addmultichoice'] = 'Creați o pagină cu întrebare de tip alegere multiplă';
$string['addnewgroupoverride'] = 'Adaugă suprascrierea grupului';
$string['addnewuseroverride'] = 'Adaugă suprascrierea utilizatorului';
$string['addnumerical'] = 'Creați o pagină cu întrebare de tip numeric';
$string['addpage'] = 'Adaugă pagină';
$string['addshortanswer'] = 'Creați o pagină cu întrebare de tip răspuns scurt';
$string['addtruefalse'] = 'Creați o pagină cu întrebare de tip adevărat/fals';
$string['allotheranswers'] = 'Toate celelalte răspunsuri';
$string['allotheranswersjump'] = 'Toate celelalte răspunsuri, sari';
$string['allotheranswersscore'] = 'Punctele tuturor celorlalte răspunsuri';
$string['allowofflineattempts'] = 'Permiteți încercarea lecției offline folosind aplicația mobilă';
$string['allowofflineattempts_help'] = 'Dacă este activat, un utilizator de aplicație mobilă poate descărca lecția și o poate încerca offline.
Toate răspunsurile posibile și răspunsurile corecte vor fi descărcate, de asemenea.
Notă: Nu este posibil ca o lecție să fie încercată offline dacă are o limită de timp.';
$string['anchortitle'] = 'Începutul conţinutului principal';
$string['and'] = 'ŞI';
$string['answer'] = 'Răspuns';
$string['answeredcorrectly'] = 'aţi răspuns corect.';
$string['answersfornumerical'] = 'Răspunsurile pentru întrebările numerice trebuie să fie potrivite perechi de valori minime și maxime';
$string['arrangebuttonshorizontally'] = 'Aranjați butoanele de navigare conținut pe orizontală?';
$string['attempt'] = 'Încercarea cu numărul: {$a}';
$string['attemptheader'] = 'Încercare';
$string['attemptinfonograde'] = '{$a->timestart} ({$a->duration})';
$string['attemptinfowithgrade'] = '{$a->grade}% {$a->timestart} ({$a->duration})';
$string['attempts'] = 'Încercări';
$string['attemptsdeleted'] = 'Încercări şterse';
$string['attemptsremaining'] = 'Mai aveţi {$a} încercări disponibile';
$string['available'] = 'Disponibil de la';
$string['averagescore'] = 'Punctaj mediu obţinut';
$string['averagetime'] = 'Timp mediu';
$string['branch'] = 'Conținut';
$string['branchtable'] = 'Conținut';
$string['cachedef_overrides'] = 'Suprascrierea informațiilor pentru utilizator și grup';
$string['cancel'] = 'Anulează';
$string['cannotfindanswer'] = 'Eroare: nu s-a putut găsi răspunsul';
$string['cannotfindattempt'] = 'Eroare: nu s-a putut găsi încercarea';
$string['cannotfindessay'] = 'Eroare: nu s-a putut găsi eseul';
$string['cannotfindfirstgrade'] = 'Eroare: nu s-au putut găsi notele';
$string['cannotfindfirstpage'] = 'Nu s-a putut găsi prima pagină';
$string['cannotfindgrade'] = 'Eroare: nu s-au putut găsi notele';
$string['cannotfindnewestgrade'] = 'Eroare: nu s-a putut găsi cea mai nouă notă';
$string['cannotfindnextpage'] = 'Copie de rezervă a lecției: Pagina următoare nu a fost găsită!';
$string['cannotfindpagerecord'] = 'Adăugați sfârșit de ramură: înregistrarea paginii nu a fost găsită';
$string['cannotfindpages'] = 'Nu s-au putut găsi paginile lecției';
$string['cannotfindpagetitle'] = 'Confirmați ștergerea: titlul paginii nu a fost găsit';
$string['cannotfindpreattempt'] = 'Înregistrarea încercării anterioare nu a putut fi găsită!';
$string['cannotfindrecords'] = 'Eroare: nu am putut găsi înregistrările lecției';
$string['cannotfindtimer'] = 'Eroare: nu s-au putut găsi înregistrările lecției_timer';
$string['cannotfinduser'] = 'Eroare: nu s-au putut găsi utilizatorii';
$string['canretake'] = '{$a} poate să repete';
$string['casesensitive'] = 'Folosește expresii regulare';
$string['casesensitive_help'] = 'Bifaţi căsuța pentru a utiliza expresii regulate pentru analiza răspunsurilor.';
$string['checkbranchtable'] = 'Verificați conținutul paginii';
$string['checkedthisone'] = 'Am verificat.';
$string['checknavigation'] = 'Verifică navigare';
$string['checkquestion'] = 'Verifică întrebare';
$string['classstats'] = 'Statistici clasă';
$string['clicktodownload'] = 'Pentru a descărca fişierul executaţi clic pe link-ul următor.';
$string['closebeforeopen'] = 'Nu s-a putut actualiza lecția. Ați specificat o dată de încheiere de înainte de date începerii.';
$string['cluster'] = 'Cluster';
$string['clusterjump'] = 'Întrebare ascunsă în cadrul unui cluster';
$string['clustertitle'] = 'Cluster';
$string['collapsed'] = 'Compactat';
$string['comments'] = 'Comentariile dumneavoastră';
$string['completed'] = 'Finalizat';
$string['completederror'] = 'Finalizaţi lecţia';
$string['completethefollowingconditions'] = 'Pentru a putea trece mai departe trebuie să îndepliniţi urmăroarele condiţii din lecţia <b>{$a}</b>.';
$string['completiondetail:reachend'] = 'Parcuge activitatea până la sfârșit';
$string['completiondetail:timespent'] = 'Petrece cel puțin {$a} la această activitate';
$string['completionendreached'] = 'S-a atins finalul solicitat';
$string['completionendreached_desc'] = 'Cursantul trebuie să ajungă la sfârșitul paginii lecției pentru a finaliza această activitate';
$string['completiontimespent'] = 'Cursantul trebuie să facă această activitate cel puțin pentru';
$string['completiontimespentdesc'] = 'Cursantul trebuie să facă această activitate pentru cel puțin {$a} ori/dată';
$string['completiontimespentgroup'] = 'Necesită timp petrecut în activitate';
$string['conditionsfordependency'] = 'Condiție(i) pentru dependență';
$string['configintro'] = 'Valorile setate aici definesc valorile implicite care sunt utilizate în formularul de setări la crearea unei noi activități de tip lecție. Setările specificate ca avansate sunt afișate numai când se face clic pe linkul „Afișează mai multe ...”.';
$string['configmaxanswers'] = 'Numărul maxim implicit de răspunsuri pe pagină';
$string['configmediaclose'] = 'Afișează un buton de închidere ca parte a ferestrei pop-up generate pentru un fișier media conectat';
$string['configmediaheight'] = 'Setează înălțimea ferestrei pop-up afișate pentru un fișier media conectat';
$string['configmediawidth'] = 'Setează lățimea ferestrei pop-up afișate pentru un fișier media conectat';
$string['configpassword_desc'] = 'Dacă este necesară o parolă pentru a accesa lecția';
$string['configslideshowbgcolor'] = 'Culoarea de fundal pentru prezentarea de diapozitive, dacă este activată';
$string['configslideshowheight'] = 'Setează înălțimea prezentării dacă este activată';
$string['configslideshowwidth'] = 'Setează lățimea prezentării dacă este activată';
$string['configtimelimit_desc'] = 'Dacă este stabilită o limită de timp, se afișează un avertisment la începutul lecției și există un cronometru. Dacă este setat la zero, atunci nu există nicio limită de timp.';
$string['confirmdelete'] = 'Șterge pagina';
$string['confirmdeletionofthispage'] = 'Confirmaţi ştergerea acestei pagini';
$string['congratulations'] = 'Felicitări - aţi ajuns la finalul lecţiei';
$string['continue'] = 'Mai departe';
$string['continuetoanswer'] = 'Continuați să schimbați răspunsurile.';
$string['continuetonextpage'] = 'Continuați la pagina următoare';
$string['correctanswerjump'] = 'Trecere la răspuns corect';
$string['correctanswerscore'] = 'Punctaj răspuns corect';
$string['correctresponse'] = 'Răspuns corect';
$string['createaquestionpage'] = 'Creați o pagină de întrebări';
$string['credit'] = 'Credit';
$string['customscoring'] = 'Punctare personalizată';
$string['customscoring_help'] = 'Dacă opțiunea este activată, valoarea numărului întreg (pozitivă sau negativă) poate fi inserată pentru fiecare răspuns.';
$string['deadline'] = 'Dată limită';
$string['defaultessayresponse'] = 'Eseul dvs. va fi notat de profesorul dvs.';
$string['deleteallattempts'] = 'Şterge toate încercările de parcurgere a lecţiei';
$string['deletedefaults'] = 'S-au şters {$a} x param implicit lecţie';
$string['deletedpage'] = 'Pagină ştearsă';
$string['deletepagenamed'] = 'Ștergeți pagina: {$a}';
$string['deleting'] = 'În curs de ştergere';
$string['deletingpage'] = 'Se şterge pagina: {$a}';
$string['dependencyon'] = 'Depinde de';
$string['dependencyon_help'] = 'Setarea permite accesul la această lecţie să depindă de parcursul studenților într-o lecţie diferită din acelaşi curs. Orice combinaţie rezultată din: timpul petrecut, procentaj completat sau "notă mai mare decât" poate fi utilizată.';
$string['description'] = 'Descriere';
$string['deselectallattempts'] = 'Deselectați toate încercările';
$string['detailedstats'] = 'Date statistice detaliate';
$string['didnotanswerquestion'] = 'Nu a răspuns la această întrebare.';
$string['didnotreceivecredit'] = 'Nu a primit credit';
$string['disabled'] = 'Dezactivat';
$string['displaydefaultfeedback'] = 'Folosiți feedback implicit';
$string['displaydefaultfeedback_help'] = 'Dacă activați opțiunea, atunci când un răspuns nu este găsit pentru o întrebare anume, răspunsul implicit afișat va fi "Acesta este răspunsul corect" sau "Acesta este un răspuns greşit".';
$string['displayinleftmenu'] = 'Afișați în meniu?';
$string['displayleftif'] = 'Nota minimă pentru afișarea meniului';
$string['displayleftif_help'] = 'Această setare determină dacă un cursant trebuie să obțină o anumită notă înainte de a vizualiza meniul lecției. Acest lucru îl obligă pe cursant să parcurgă întreaga lecție la prima încercare, apoi după ce a obținut nota necesară, ei pot folosi meniul pentru revizuire.';
$string['displayleftmenu'] = 'Afișează meniu';
$string['displayleftmenu_help'] = 'Dacă este activat, este afișat un meniu care permite utilizatorilor să navigheze prin lista de pagini.';
$string['displaymode'] = 'Mod de afișare';
$string['displayofgrade'] = 'Afişarea notei (doar pentru cursanţi)';
$string['displayreview'] = 'Activați opțiunea de a încerca din nou o întrebare';
$string['displayreview_help'] = 'Dacă este activat, atunci când se răspunde incorect la o întrebare, cursantului i se oferă opțiunea de a încerca din nou fără notare sau de a continua cu lecția. Dacă cursantul face clic pentru a trece la o altă întrebare, atunci va fi urmat răspunsul selectat (greșit). În mod implicit, salturile de răspunsuri greșite sunt setate la „această pagină” și au un scor de 0, de aceea este recomandat să setați răspunsul greșit la o altă pagină pentru a evita confuzia cu cursanții dvs.';
$string['displayscorewithessays'] = '<p> Ați obținut {$a->score} din {$a->tempmaxgrade} pentru întrebările notate automat. </p>
<p> Întrebările dvs. {$a->essayquestions} eseu vor fi clasificate și adăugate în scorul final la o dată ulterioară. </p>
<p> Nota dvs. curentă fără întrebarea (e) eseului este {$a->score} din {$a->grade}. </p>';
$string['displayscorewithoutessays'] = 'Punctajul dumneavoastră este de {$a->score} (din nota {$a->grade}).';
$string['duplicatepagenamed'] = 'Pagină duplicată: {$a}';
$string['edit'] = 'Editare';
$string['editbranchtable'] = 'Editarea unei pagini de conținut';
$string['editcluster'] = 'Editarea unui grup de pagini';
$string['editendofbranch'] = 'Editarea paginii unui sfârșit de ramură';
$string['editendofcluster'] = 'Editarea paginii unui sfârșit de grup';
$string['editessay'] = 'Editarea unei pagini de întrebări de tip eseu';
$string['editinglesson'] = 'Se editează lecția';
$string['editingquestionpage'] = 'Se editează pagina cu întrebări';
$string['editlesson'] = 'Editați lecția';
$string['editlessonsettings'] = 'Editare setări lecţie';
$string['editmatching'] = 'Editarea unei pagini de întrebări de tip potrivite';
$string['editmultichoice'] = 'Editarea unei pagini de întrebări de tip răspunsuri multiple';
$string['editnumerical'] = 'Editarea unei pagini de întrebări de tip numeri';
$string['editoverride'] = 'Editează suprascrierea';
$string['editpage'] = 'Editați conținutul paginii';
$string['editpagecontent'] = 'Editare conţinut pagină';
$string['editquestion'] = 'Editarea unei pagini de întrebări';
$string['editshortanswer'] = 'Editarea unei pagini de întrebări de tip răspuns scurt';
$string['edittruefalse'] = 'Editarea unei pagini de întrebări de tip adevărat/fals';
$string['email'] = 'Email';
$string['emailallgradedessays'] = 'Trimite notificări despre eseurile notate.';
$string['emailgradedessays'] = 'Trimite notificări despre eseurile notate.';
$string['emailsuccess'] = 'Notificări trimise cu succes';
$string['emptypassword'] = 'Parola nu poate fi lăsată necompletată';
$string['enabled'] = 'Activat';
$string['endofbranch'] = 'Final de ramură';
$string['endofcluster'] = 'Final de grup de pagini';
$string['endofclustertitle'] = 'Final cluster';
$string['endoflesson'] = 'Finalul lecţiei';
$string['enteredthis'] = 'a completat asta.';
$string['enterpassword'] = 'Te rugăm să introduci parola:';
$string['eolstudentoutoftime'] = 'Atenţie!: timpul rezervat acestei lecţii a expirat înainte să răspundeţi la ultima întrebare. Este posibil ca acesta să nu fie luat în considerare la calcularea notei.';
$string['eolstudentoutoftimenoanswers'] = 'Nu ai răspuns la nicio întrebare. Ai primit 0 puncte la această lecţie.';
$string['essay'] = 'Eseu';
$string['essayemailmessage2'] = '<p>Eseul: {$a->question} </p> <p> Răspunsul dvs.: <em>{$a->response}</em></p> <p> Comentariile evaluatorului: <em> {$a->comment} </em> </p> <p> Ați primit {$a->earned} din {$a->outof} pentru această întrebare eseu. </p> <p> nota pentru lecția {$a->lesson} a fost schimbată în {$a->newgrade}%. </p>';
$string['essayemailmessagesmall'] = '<p> Ați primit {$a->earned} din {$a->outof} pentru această întrebare eseu. </p> <p> Nota dvs. pentru lecția {$a->lesson} a fost schimbată în {$a->newgrade}%. </p>';
$string['essayemailsubject'] = 'Nota disponibilă pentru întrebarea lecției';
$string['essaynotgradedyet'] = 'Acest eseu nu a fost încă notat';
$string['essayresponses'] = 'Răspunsuri la eseuri';
$string['essays'] = 'Eseuri';
$string['essayscore'] = 'Scor eseuri';
$string['eventcontentpageviewed'] = 'S-a vizualizat conținutul paginii';
$string['eventessayassessed'] = 'Eseu evaluat';
$string['eventessayattemptviewed'] = 'Eseu vizualizat';
$string['eventhighscoreadded'] = 'S-a adăugat cea mai mare notă la lecție';
$string['eventhighscoresviewed'] = 'S-au vizualizat cele mai mari note la lecție';
$string['eventlessonended'] = 'Lecție încheiată';
$string['eventlessonrestarted'] = 'Lecție reîncepută';
$string['eventlessonresumed'] = 'Lecția a fost reluată';
$string['eventlessonstarted'] = 'Lecție începută';
$string['eventoverridecreated'] = 'Înlocuirea lecției a fost creată';
$string['eventoverridedeleted'] = 'Înlocuirea lecției a fost ștearsă';
$string['eventoverrideupdated'] = 'Înlocuirea lecției a fost actualizată';
$string['eventpagecreated'] = 'Pagină creată';
$string['eventpagedeleted'] = 'Pagină ștearsă';
$string['eventpagemoved'] = 'Pagină mutată';
$string['eventpageupdated'] = 'Pagină actualizată';
$string['eventquestionanswered'] = 'S-a răspuns la întrebare';
$string['eventquestionviewed'] = 'S-a vizualizat întrebarea';
$string['false'] = 'Fals';
$string['fileformat'] = 'Format fișier';
$string['finalwrong'] = 'Nu chiar.';
$string['finish'] = 'Terminat';
$string['firstanswershould'] = 'Primul răspuns ar trebui să sară la pagina „Corect”';
$string['firstwrong'] = 'Ați răspuns greșit. Doriți să încercați din nou întrebarea? (Dacă acum răspundeți corect la întrebare, aceasta nu va conta pentru nota dvs. finală.)';
$string['flowcontrol'] = 'Controlul fluxului';
$string['fractionsaddwrong'] = 'Notele pozitive pe care le-ați ales nu însumează100%<br />În schimb, ele se adaugă până la un procent de {$a}%<br />Doriți să remediați această întrebare?';
$string['fractionsnomax'] = 'Unul dintre raspunsuri trebuie sa fie 100%, aşa încât să fie';
$string['full'] = 'Expandat';
$string['general'] = 'General';
$string['gotoendoflesson'] = 'Mergi la sfârșitul lecției';
$string['grade'] = 'Notă';
$string['gradebetterthan'] = 'Notă mai bună ca (&#37;)';
$string['gradebetterthanerror'] = 'Obţineţi o notă mai bună decât a {$a} din cursanţi';
$string['graded'] = 'Notat';
$string['gradeessay'] = 'Notarea întrebărilor eseu ({$a->notgradedcount} nu a fost efectuată și {$a->notsentcount} nu au fost trimise)';
$string['gradeis'] = 'Nota este {$a}';
$string['gradeoptions'] = 'Opţiuni note';
$string['groupoverrides'] = 'Suprascrieri de grup';
$string['groupoverridesdeleted'] = 'Suprascrieri de grup șterse';
$string['groupsnone'] = 'Nu puteți accesa niciun grup.';
$string['handlingofretakes'] = 'Gestionarea reluărilor';
$string['handlingofretakes_help'] = 'În cazul în care se permit mai multe încercări de răspuns această setare specifică dacă nota acordată va fi constituită din media sau maxima rezultată de pe urma tuturor încercărilor de răspuns.';
$string['havenotgradedyet'] = 'Nu a fost notat încă.';
$string['here'] = 'aici';
$string['highscore'] = 'Notă mare';
$string['hightime'] = 'Timp mare';
$string['importcount'] = 'Se importă {$a} întrebări';
$string['importquestions'] = 'Importă întrebări';
$string['importquestions_help'] = 'Această caracteristică permite importul de întrebări care au formate diferite prin intermediul unui fişier text.';
$string['inactiveoverridehelp'] = '* Această suprascriere este inactivă, deoarece accesul utilizatorului la activitate este restricționat. Acest lucru se poate datora atribuirilor de grup sau de rol, altor restricții de acces sau activității ascunse.';
$string['indicator:cognitivedepth'] = 'Informații cognitive despre activitatea lecție';
$string['indicator:cognitivedepth_help'] = 'Acest indicator se bazează pe profunzimea cognitivă atinsă de elev într-o activitate de lecție.';
$string['indicator:cognitivedepthdef'] = 'Informații cognitive despre activitatea lecție';
$string['indicator:cognitivedepthdef_help'] = 'Participantul a atins acest procent din implicarea cognitivă oferită de activitățile lecției în acest interval de analiză (niveluri = Fără vizualizare, Vizualizare, Trimitere, Vizualizare feedback, Comentariu la feedback, Retrimitere după vizualizare feedback)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Informații sociale despre activitatea lecție';
$string['indicator:socialbreadth_help'] = 'Acest indicator se bazează pe angajamentul social la care a ajuns cursantul într-o activitate de lecție.';
$string['indicator:socialbreadthdef'] = 'Informații sociale despre activitatea lecție';
$string['indicator:socialbreadthdef_help'] = 'Participantul a atins acest procent din angajamentul social oferit de activitățile lecției în timpul acestui interval de analiză (niveluri = Fără participare, participant singur, participant cu alții)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insertedpage'] = 'Pagină inserată';
$string['invalidfile'] = 'Fișier nevalid';
$string['invalidid'] = 'Nu a fost transmise niciun identificator sau identificator lecție';
$string['invalidlessonid'] = 'Identificatorul lecției a fost incorect';
$string['invalidoverrideid'] = 'Identificatorul de suprascriere nu este valid';
$string['invalidpageid'] = 'Identificatorul de pagină nu este valid';
$string['jump'] = 'Salt';
$string['jumps'] = 'Salturi';
$string['jumps_help'] = 'Fiecare răspuns (pentru întrebări) sau descriere (pentru pagini de conținut) are un salt corespunzător. Saltul poate fi relativ, cum ar fi această pagină sau pagina următoare, sau absolut, specificând oricare dintre paginile lecției.';
$string['jumpsto'] = 'Salturi la <em>{$a}</em>';
$string['leftduringtimed'] = 'Aţi abandonat o lecţie cronometrată.<br />Vă rugăm apăsaţi  Continuare pentru a începe lecţia de la început.';
$string['leftduringtimednoretake'] = 'Aţi abandonat o lecţie cronometrată.<br />nu aveţi permisiunea de a continua sau de a începe de la început.';
$string['leftduringtimedsession'] = 'Ai ieșit din lecție în timpul unei lecții cronometrate.';
$string['lesson:addinstance'] = 'Adaugă o nouă lecție';
$string['lesson:edit'] = 'Editează o activitate din cadrul unei lecţii';
$string['lesson:grade'] = 'Notează întrebări de tip eseu din lecție';
$string['lesson:manage'] = 'Administrare activitate din cadrul unei lecţii';
$string['lesson:manageoverrides'] = 'Gestionați suprascrierile lecției';
$string['lesson:view'] = 'Vedeți activitatea lecției';
$string['lesson:viewreports'] = 'Vizualizați rapoartele lecției';
$string['lessonbeingpreviewed'] = 'Lecția este acum în curs de previzualizare.';
$string['lessonclosed'] = 'Această lecţie s-a închis pe data {$a}.';
$string['lessoncloses'] = 'Lecţia se închide';
$string['lessoneventcloses'] = 'Obiectul {$a} se închide';
$string['lessoneventopens'] = '{$a} se deschide';
$string['lessonformating'] = 'Formatare lecţie';
$string['lessonmenu'] = 'Meniu lecţie';
$string['lessonnotready'] = 'Această lecţie nu poate fi parcursă încă. Contactaţi, vă rugăm {$a}.';
$string['lessonnotready2'] = 'Această lecție nu este pregătită să fie începută.';
$string['lessonopen'] = 'Această lecţie se va deschide pe data {$a}.';
$string['lessonopens'] = 'Lecţia se deschide';
$string['lessonpagelinkingbroken'] = 'Prima pagină nu a fost găsită. Este posibil ca link-urile dintre pagini să se fi deteriorat. Vă rugăm contactaţi un administrator.';
$string['lessonstats'] = 'Statistici lecţie';
$string['linkedmedia'] = 'Linked media';
$string['loginfail'] = 'Operaţiunea de logare nu a reuşit, vă rugăm mai încercaţi...';
$string['lowscore'] = 'Punctaj minim';
$string['lowtime'] = 'Timp minim';
$string['manageoverrides'] = 'Administrare suprascrieri';
$string['manualgrading'] = 'Notare eseuri';
$string['matchesanswer'] = 'Corespunde răspunsului';
$string['matching'] = 'Potrivire';
$string['matchingpair'] = 'Potrivire pereche {$a}';
$string['maxgrade'] = 'Notă maximă';
$string['maxgrade_help'] = 'Această setare specifică nota maximă pentru lecţie. Dacă este setată la 0, lecția nu va apărea în paginile cu note.';
$string['maximumnumberofanswersbranches'] = 'Numărul maxim de răspunsuri';
$string['maximumnumberofanswersbranches_help'] = 'Această setare specifică numărul maxim de răspunsuri care pot fi utilizate în lecție. Dacă se utilizează numai întrebări adevărate / false, aceasta poate fi setată la 2. Setarea poate fi modificată oricând, deoarece afectează doar ceea ce vede profesorul, nu datele.';
$string['maximumnumberofattempts'] = 'Număr maxim de încercări pe întrebare';
$string['maximumnumberofattempts_help'] = 'Această setare specifică numărul maxim de încercări permise pentru fiecare întrebare.  În cazul în care s-a răspuns în mod repetat în mod incorect iar maximul a fost atins, se va afișa automat pagina următoare a lecţiei.';
$string['maximumnumberofattemptsreached'] = 'Numărul maxim de încercări a fost epuizat - se trece la pagina următoare';
$string['mediaclose'] = 'Afișează buton de închidere';
$string['mediafile'] = 'Media conectată';
$string['mediafile_help'] = 'Un fișier media poate fi încărcat pentru utilizare în lecție. Apoi, un link „Faceți clic aici pentru a vizualiza” va fi afișat într-un bloc numit „Conținut media” pe fiecare pagină a lecției.';
$string['mediafilepopup'] = 'Clic aici pentru a vizualiza';
$string['mediaheight'] = 'Înălțimea ferestrei pop-up';
$string['mediawidth'] = 'Lăţimea ferestrei pop-up';
$string['messageprovider:graded_essay'] = 'Notificare de notare a unui eseu de lecție';
$string['minimumnumberofquestions'] = 'Număr minim de întrebări';
$string['minimumnumberofquestions_help'] = 'Această setare specifică numărul minim de întrebări care vor fi utilizate pentru a calcula nota pentru activitate.';
$string['missingname'] = 'Vă rugăm introduceţi o poreclă';
$string['modattempts'] = 'Permite verificare de către cursanţi';
$string['modattempts_help'] = 'Dacă activați opțiunea, cursanții vor putea parcurge lecţia din nou de la început.';
$string['modattemptsnoteacher'] = 'Revizualizarea din partea studenților funcționează numai pentru studenți.';
$string['modulename'] = 'Lecţie';
$string['modulename_help'] = 'Activitatea de tip lecție permite profesorului să livreze conținut și / sau să practice activități în moduri interesante și flexibile. Un profesor poate folosi lecția pentru a crea un set liniar de pagini de conținut sau activități de instruire care oferă o varietate de căi sau opțiuni pentru cursant. În ambele cazuri, profesorii pot alege să crească implicarea și să asigure înțelegerea prin includerea unei varietăți de întrebări, cum ar fi alegerea multiplă, potrivirea și răspunsul scurt. În funcție de alegerea de răspuns a elevului și de modul în care profesorul dezvoltă lecția, elevii pot trece la pagina următoare, pot fi luați înapoi la o pagină anterioară sau redirecționați pe o altă cale complet.

O lecție poate fi notată, cu nota înregistrată în carnetul de note.

Se pot folosi lecții

* Pentru învățarea auto-direcționată a unui subiect nou
* Pentru scenarii sau simulări / exerciții de luare a deciziilor
* Pentru revizuirea diferențiată, cu seturi diferite de întrebări de revizuire, în funcție de răspunsurile date la întrebările inițiale';
$string['modulename_link'] = 'mod/lesson/view';
$string['modulenameplural'] = 'Lecţii';
$string['move'] = 'Mută pagina';
$string['movedpage'] = 'Pagină mutată';
$string['movepagehere'] = 'Mută pagina aici';
$string['movepagenamed'] = 'Mută pagină: {$a}';
$string['moving'] = 'Se mută pagina {$a}';
$string['multianswer'] = 'Răspuns multiplu';
$string['multianswer_help'] = 'Bifaţi căsuța dacă există mai mult de un singur răspuns corect.';
$string['multichoice'] = 'Alegere multiplă';
$string['multipleanswer'] = 'Răspuns Multiplu';
$string['nameapproved'] = 'Nume aprobat';
$string['namereject'] = 'Ne pare rău, numele dumneavoastră a fost respins de filtru.<br />Vă rugăm încercaţi alt nume.';
$string['new'] = 'nou';
$string['nextpage'] = 'Pagina următoare';
$string['noanswer'] = 'Una sau mai multe întrebări nu au răspuns. Vă rugăm să vă întoarceți și să dați un răspuns.';
$string['noattemptrecordsfound'] = 'Nu a fost înregistrată nicio încercare de parcurgere: nu s-a dat nicio notă';
$string['nobranchtablefound'] = 'Nu s-a găsit conținutul paginii';
$string['noclose'] = 'Nu există dată de încheiere';
$string['nocommentyet'] = 'Încă nu a fost introdus niciun comentariu.';
$string['nocoursemods'] = 'Nu s-a găsit nicio activitate';
$string['nocredit'] = 'Fără credit';
$string['nodeadline'] = 'Fără dată limită';
$string['noessayquestionsfound'] = 'În această lecţie nu s-a găsit nicio întrebare care să aibă legătură cu eseul.';
$string['nohighscores'] = 'Nu se afişează punctaje maxime';
$string['nolessonattempts'] = 'Nu s-a înregistrat nicio încercare de parcurgere a acestei lecţii';
$string['nolessonattemptsgroup'] = 'Nu au fost făcute încercări de către membrii grupului {$a} la această lecție.';
$string['none'] = 'nici unul';
$string['nooneansweredcorrectly'] = 'Niciunul din cursanţi nu a răspuns corect.';
$string['nooneansweredthisquestion'] = 'Niciunul din cursanţi nu a răspuns corect la această întrebare.';
$string['noonecheckedthis'] = 'nu este verificat';
$string['nooneenteredthis'] = 'Nimeni nu a intrat în lecție.';
$string['noonehasanswered'] = 'Nimeni nu a răspuns încă la o întrebare de tip eseu.';
$string['noonehasansweredgroup'] = 'Nimeni din {$a} nu a răspuns încă la o întrebare de tip eseu.';
$string['noopen'] = 'Fără dată de deschidere';
$string['nooverridecreated'] = 'Nu au fost create suprascrieri.';
$string['nooverridedata'] = 'Trebuie să suprascrieți cel puțin una dintre setările lecției.';
$string['noretake'] = 'Nu ai voie să reiei această lecție.';
$string['normal'] = 'Normal - urmaţi calea din lecţie';
$string['notcompleted'] = 'Nu a fost completat.';
$string['notcompletedwithdate'] = 'Nefinalizat ({$a})';
$string['notdefined'] = 'Nu a fost definit.';
$string['notenoughsubquestions'] = 'Nu s-au definit suficiente sub-întrebări!';
$string['notenoughtimespent'] = 'Ați finalizat această lecție în {$a->timespent}, care este mai puțin decât timpul minim estimat de {$a->timerequired}. S-ar putea să fie nevoie să repetați lecția.';
$string['notgraded'] = 'Fără notă';
$string['notitle'] = 'Fără titlu';
$string['notyetcompleted'] = 'Lecția a fost începută, dar încă nu a fost finalizată';
$string['numberofcorrectanswers'] = 'Numărul de răspunsuri corecte: {$a}';
$string['numberofcorrectanswersheader'] = 'Numărul de răspunsuri corecte';
$string['numberofcorrectmatches'] = 'Numărul de potriviri corecte: {$a}';
$string['numberofpagestoshow'] = 'Numărul de pagini de afișat';
$string['numberofpagestoshow_help'] = 'Această setare specifică numărul de pagini care vor fi afişate într-o lecţie. Opțiunea se aplică doar pentru lecţiile care au pagini prezentate într-o ordine aleatorie (atunci când "Acţiune după răspuns corect" este setat pe "Arată o pagină nouă" sau "Arată o pagină ne-completată"). Dacă este setată la zero atunci toate paginile vor fi afişate.';
$string['numberofpagesviewed'] = 'Numărul de întrebări la care s-a răspuns: {$a}';
$string['numberofpagesviewedheader'] = 'Numărul de întrebări la care s-a răspuns';
$string['numberofpagesviewednotice'] = 'Numărul de întrebări la care ați răspuns: {$a->nquestions} (Ar trebui să răspundeți la cel puțin {$a->minquestions} întrebări)';
$string['numerical'] = 'Numeric';
$string['numericanswer'] = 'Răspuns numeric';
$string['numericanswer_help'] = 'Puteți specifica un singur număr sau un interval de numere utilizând două puncte. De exemplu 2: 5 înseamnă că orice răspuns între 2 și 5 și inclusiv 2 și 5 este corect.';
$string['offlinedatamessage'] = 'Ați lucrat la acest răspuns folosind un dispozitiv mobil. Datele au fost salvate ultima dată pe acest site în urmă cu {$a}. Vă rugăm să verificați dacă nu aveți nicio lucrare nesalvată.';
$string['ongoing'] = 'Afişează scor curent';
$string['ongoing_help'] = 'Dacă activați opțiunea, se va afișa pe fiecare pagină punctajul pe care cursantul l-a obținut din totalul posibil până la acel punct. ';
$string['ongoingcustom'] = 'Până în acest moment aţi obţinut {$a->score} point(s) puncte din {$a->currenthigh} point(s) posibile.';
$string['ongoingnormal'] = 'Ați răspuns corect la {$a->correct} din {$a->viewed} încercări.';
$string['onpostperpage'] = 'O singură postare pe nootă';
$string['openafterclose'] = 'Ați specificat o dată de deschidere după data de închidere';
$string['options'] = 'Opțiuni';
$string['or'] = 'SAU';
$string['ordered'] = 'Ordonat';
$string['other'] = 'Altele';
$string['outof'] = 'Din {$a}';
$string['override'] = 'Suprascrie';
$string['overridedeletegroupsure'] = 'Sigur doriți să ștergeți suprascrierea pentru grupul {$a}?';
$string['overridedeleteusersure'] = 'Sigur doriți să ștergeți suprascrierea pentru utilizatorul {$a}?';
$string['overridegroup'] = 'Suprascrie grupul';
$string['overridegroupeventname'] = '{$a->lesson} - {$a->group}';
$string['overrides'] = 'Suprascrieri';
$string['overrideuser'] = 'Suprascriere reguli pentru utilizatorul';
$string['overrideusereventname'] = '{$a->lesson} - Suprascrie';
$string['overview'] = 'Privire de ansamblu';
$string['overview_help'] = 'O lecție este alcătuită dintr-un număr de pagini și opțional pagini de conținut. O pagină conține un anumit conținut și de obicei se termină cu o întrebare. Asociat cu fiecare răspuns la întrebare este un salt la o altă pagină. Saltul poate fi relativ, cum ar fi această pagină sau pagina următoare, sau absolut, specificând oricare dintre paginile lecției. O pagină de conținut este o pagină care conține un set de legături către alte pagini din lecție, de exemplu un cuprins.';
$string['page'] = 'Pagina: {$a}';
$string['page-mod-lesson-edit'] = 'Pagina de editare a lecției';
$string['page-mod-lesson-view'] = 'Vizualizați sau previzualizați pagina lecției';
$string['page-mod-lesson-x'] = 'Orice pagină de lecție';
$string['pageanswers'] = 'Pagină cu răspunsuri';
$string['pagecontents'] = 'Conţinut pagină';
$string['pageresponses'] = 'Pagină cu răspunsuri date';
$string['pages'] = 'Pagini';
$string['pagetitle'] = 'Titlu pagină';
$string['password'] = 'Parolă';
$string['passwordprotectedlesson'] = 'Accesul la lecţia {$a} se face doar pe baza parolei.';
$string['pleasecheckoneanswer'] = 'Vă rugăm selectaţi un răspuns';
$string['pleasecheckoneormoreanswers'] = 'Vă rugăm selectaţi unul sau mai multe răspunsuri';
$string['pleaseenteryouranswerinthebox'] = 'Vă rugăm completaţi răspunsul în căsuţă';
$string['pleasematchtheabovepairs'] = 'Vă rugăm să potriviți perechile de mai sus';
$string['pluginadministration'] = 'Administrarea lecției';
$string['pluginname'] = 'Lecţie';
$string['pointsearned'] = 'Puncte obţinute';
$string['postprocesserror'] = 'A apărut o eroare în timpul procesării!';
$string['postsuccess'] = 'Ați postat cu succes';
$string['practice'] = 'Lecție de exersare';
$string['practice_help'] = 'O lecţie de probă nu va fi afișată în catalog.';
$string['preprocesserror'] = 'A apărut o eroare în timpul prelucrării prealabile!';
$string['prerequisiteisobsolete'] = 'Opțiunea de lecție prealabilă trebuie eliminată. Vă rugăm să utilizați în schimb restricții de acces.';
$string['prerequisitelesson'] = 'Lecție prealabilă';
$string['preview'] = 'Previzualizare';
$string['previewlesson'] = 'Previzualizare {$a}';
$string['previewpagenamed'] = 'Previzualizați pagina: {$a}';
$string['previouspage'] = 'Pagina anterioară';
$string['privacy:metadata:attempts'] = 'O înregistrare a încercărilor de pagină';
$string['privacy:metadata:attempts:answerid'] = 'ID-ul răspunsului';
$string['privacy:metadata:attempts:correct'] = 'Dacă încercarea a fost corectă';
$string['privacy:metadata:attempts:pageid'] = 'ID-ul paginii';
$string['privacy:metadata:attempts:retry'] = 'Numărul încercării';
$string['privacy:metadata:attempts:timeseen'] = 'Momentul în care s-a făcut încercarea';
$string['privacy:metadata:attempts:useranswer'] = 'Detalii despre răspunsul utilizatorului';
$string['privacy:metadata:attempts:userid'] = 'ID-ul utilizatorului';
$string['privacy:metadata:branch'] = 'O înregistrare a paginilor vizualizate';
$string['privacy:metadata:branch:flag'] = 'Dacă pagina următoare a fost calculată aleatoriu';
$string['privacy:metadata:branch:nextpageid'] = 'ID-ul paginii următoare';
$string['privacy:metadata:branch:pageid'] = 'ID-ul paginii';
$string['privacy:metadata:branch:retry'] = 'Numărul încercării';
$string['privacy:metadata:branch:timeseen'] = 'Ora când a fost vizualizată pagina';
$string['privacy:metadata:branch:userid'] = 'ID-ul utilizatorului';
$string['privacy:metadata:grades'] = 'O înregistrare a notelor pentru fiecare lecție';
$string['privacy:metadata:grades:completed'] = 'Data la care a fost acordată nota';
$string['privacy:metadata:grades:grade'] = 'Nota acordată';
$string['privacy:metadata:grades:userid'] = 'ID-ul utilizatorului';
$string['privacy:metadata:overrides'] = 'O înregistrare a suprascrierilor pe lecție';
$string['privacy:metadata:overrides:available'] = 'Ora în care se poate începe lecția';
$string['privacy:metadata:overrides:deadline'] = 'Termenul limită pentru finalizarea lecției.';
$string['privacy:metadata:overrides:maxattempts'] = 'Numărul maxim de încercări';
$string['privacy:metadata:overrides:password'] = 'Parola pentru a accesa lecția';
$string['privacy:metadata:overrides:retake'] = 'Dacă sunt permise reluările';
$string['privacy:metadata:overrides:review'] = 'Este permisă încercarea din nou a unei întrebări';
$string['privacy:metadata:overrides:timelimit'] = 'Limita de timp pentru finalizarea lecției, în secunde.';
$string['privacy:metadata:overrides:userid'] = 'ID-ul utilizatorului';
$string['privacy:metadata:timer'] = 'O înregistrare a unei încercări de lecție';
$string['privacy:metadata:timer:completed'] = 'Dacă încercarea este completă';
$string['privacy:metadata:timer:lessontime'] = 'Ultimul moment când am înregistrat activitate';
$string['privacy:metadata:timer:starttime'] = 'Data la care a început încercarea';
$string['privacy:metadata:timer:timemodifiedoffline'] = 'Ultimul moment când am înregistrat activitate din aplicația mobilă';
$string['privacy:metadata:timer:userid'] = 'ID-ul utilizatorului';
$string['privacy:metadata:userpref:lessonview'] = 'Modul de afișare preferat pentru editarea lecțiilor';
$string['privacy:path:essayanswers'] = 'Răspunsuri la eseuri';
$string['privacy:path:essayresponses'] = 'Răspunsuri trimise la eseuri';
$string['privacy:path:pages'] = 'Pagini';
$string['processerror'] = 'A apărut o eroare în timpul procesării!';
$string['progressbar'] = 'Bara de progres';
$string['progressbar_help'] = 'Dacă activați opțiunea, o bară de progres va fi afişată în partea de jos a paginilor lecţiei care va arăta procentul de progres.';
$string['progressbarteacherwarning'] = 'Bara de progres nu se afișează pentru {$a}';
$string['progressbarteacherwarning2'] = 'Nu veți vedea bara de progres deoarece puteți edita această lecție';
$string['progresscompleted'] = 'Ați completat {$a}% din lecție';
$string['qtype'] = 'Tip pagină';
$string['question'] = 'Întrebare';
$string['questionoption'] = 'Întrebare';
$string['questiontype'] = 'Tip întrebare';
$string['randombranch'] = 'Pagina de conținut aleatoriu';
$string['randompageinbranch'] = 'Întrebare afișată aleatoriu într-o pagină de conținut';
$string['rank'] = 'Rang';
$string['rawgrade'] = 'Nota brută';
$string['receivedcredit'] = 'Credit primit';
$string['redisplaypage'] = 'Reafișează pagina';
$string['removeallgroupoverrides'] = 'Ștergeți toate suprascrierile grupului';
$string['removealluseroverrides'] = 'Ștergeți toate suprascrierile pentru utilizatori';
$string['report'] = 'Raport';
$string['reports'] = 'Rapoarte';
$string['response'] = 'Răspuns';
$string['retakesallowed'] = 'Se permite reluarea încercării';
$string['retakesallowed_help'] = 'Dacă activați opțiunea, cursanții vor putea parcurge lecția de mai multe ori.';
$string['returnto'] = 'Revenire la {$a}';
$string['returntocourse'] = 'Revenire la curs';
$string['reverttodefaults'] = 'Reveniți la valorile implicite ale lecției';
$string['review'] = 'Revizuire';
$string['reviewlesson'] = 'Revizuire lecție';
$string['reviewquestionback'] = 'Da, doresc să mai încerc o dată';
$string['reviewquestioncontinue'] = 'Nu, vreau să trec la următoarea întrebare';
$string['sanitycheckfailed'] = 'Verificarea stusului a eșuat: această încercare a fost ștearsă';
$string['save'] = 'Salvează';
$string['savechanges'] = 'Salvează modificări';
$string['savechangesandeol'] = 'Salvează toate modificările şi mergi la finalul lecţiei.';
$string['saveoverrideandstay'] = 'Salvați și introduceți o altă suprascriere';
$string['savepage'] = 'Salvează pagina';
$string['score'] = 'Notă';
$string['score_help'] = 'Dacă scorul personalizat este activat în setările lecției, poate fi introdusă o valoare a numărului întreg (pozitiv sau negativ) pentru fiecare răspuns.';
$string['scores'] = 'Note';
$string['search:activity'] = 'Lecție - informații despre activitate';
$string['secondpluswrong'] = 'Nu este corect. Vrei să mai încerci o dată?';
$string['selectallattempts'] = 'Selectați toate încercările';
$string['selectaqtype'] = 'Selectați un tip de întrebare';
$string['selectreport'] = 'Selectează raport';
$string['sent'] = 'Trimis';
$string['shortanswer'] = 'Răspuns scurt';
$string['showanunansweredpage'] = 'Afişează o pagină la care nu s-a răspuns';
$string['showanunseenpage'] = 'Afișați o pagină nevăzută';
$string['singleanswer'] = 'Răspuns unic';
$string['skip'] = 'Treceți peste navigare';
$string['slideshow'] = 'Slideshow';
$string['slideshow_help'] = 'Dacă activați opțiunea, lecția va fi afișată ca un slideshow, cu o lăţime şi înălţime fixă.';
$string['slideshowbgcolor'] = 'Culoarea de fundal a prezentării de diapozitive';
$string['slideshowheight'] = 'Înălțimea slideshow-ului';
$string['slideshowwidth'] = 'Lățimea slideshow-ului';
$string['startlesson'] = 'Începe lecţie';
$string['studentattemptlesson'] = '{$a->lastname}, numărul de încercare al lui {$a->firstname} {$a->attempt}';
$string['studentname'] = 'Nume {$a}';
$string['studentoneminwarning'] = 'Atenţie!: mai aveţi mai puţin de un minut la dispoziţie pentru a termina parcurgerea acestei lecţii.';
$string['studentoutoftimeforreview'] = 'Atenție: Ați rămas fără timp pentru revizuirea acastei lecții';
$string['studentresponse'] = 'Răspunsul furnizat de {$a}';
$string['submit'] = 'Trimite';
$string['submitname'] = 'Trimite nume';
$string['teacherjumpwarning'] = 'Un salt {$a->cluster} sau un salt {$a->unseen} este utilizat în această lecție. Următorul salt de pagină va fi folosit în schimb. Conectați-vă cu rol de cursant pentru a testa aceste salturi.';
$string['teacherongoingwarning'] = 'Scorul în curs este afișat numai pentru cursant. Conectați-vă cu rol de cursant pentru a testa scorul continuu.';
$string['teachertimerwarning'] = 'Cronometrul funcționează numai pentru cursanți. Testați cronometrul conectându-vă cu rol de cursant.';
$string['thatsthecorrectanswer'] = 'Răspuns corect';
$string['thatsthewronganswer'] = 'Răspuns incorect';
$string['thefollowingpagesjumptothispage'] = 'Următoarele pagini duc la această pagină';
$string['thispage'] = 'Această pagină';
$string['timeisup'] = 'Timpul a expirat';
$string['timelimit'] = 'Limită de timp';
$string['timelimit_help'] = 'Dacă este activat, un avertisment cu privire la limita de timp este afișat la începutul lecției și este afișat un contor invers. Orice răspunsuri date după expirarea timpului nu sunt notate.';
$string['timelimitwarning'] = 'Aveți {$a} pentru a termina lecția.';
$string['timeremaining'] = 'Timp rămas';
$string['timespenterror'] = 'Petreceți cel puțin {$a} minute în lecție';
$string['timespentminutes'] = 'Timp petrecut (minute)';
$string['timetaken'] = 'Timp necesar';
$string['totalpagesviewedheader'] = 'Numărul de pagini vizualizate';
$string['true'] = 'Adevărat';
$string['truefalse'] = 'Adevărat/fals';
$string['unabledtosavefile'] = 'Fișierul pe care l-ați încărcat nu a putut fi salvat';
$string['unknownqtypesnotimported'] = '{$a} întrebări cu tipuri de întrebări neacceptate nu au fost importate';
$string['unseenpageinbranch'] = 'Întrebare nevăzută într-o pagină de conținut';
$string['unsupportedqtype'] = 'Tip de întrebare neacceptat ({$a})!';
$string['updatedpage'] = 'Pagină actualizată';
$string['updatefailed'] = 'Actualizarea a eşuat';
$string['updatepagenamed'] = 'Actualizează pagina: {$a}';
$string['usemaximum'] = 'Foloseşte maximum';
$string['usemean'] = 'Foloseşte media';
$string['usepassword'] = 'Lecţie cu acces pe bază de parolă';
$string['usepassword_help'] = 'Dacă activați opțiunea, va fi necesară o parolă pentru a accesa lecţia.';
$string['useroverrides'] = 'Suprascrieri utilizator';
$string['useroverridesdeleted'] = 'Suprascrieri utilizator a fost ștearsă';
$string['usersnone'] = 'Cursanții nu au acces la această lecție';
$string['viewessayanswers'] = 'Vizualizați răspunsurile eseului';
$string['viewgrades'] = 'Afişează note';
$string['viewreports'] = 'Vizualizați {$a->attempts} încercări {$a->student} finalizate';
$string['viewreports2'] = 'Vizualizați {$a} încercări finalizate';
$string['warning'] = 'Avertizare';
$string['welldone'] = 'Foarte bine!';
$string['whatdofirst'] = 'Ce doriţi să faceţi mai întâi?';
$string['withselectedattempts'] = 'Cu încercările selectate ...';
$string['wronganswerjump'] = 'Trecere la răspuns greşit';
$string['wronganswerscore'] = 'Punctaj răspuns greşit';
$string['wrongresponse'] = 'Răspuns greşit';
$string['youhaveseen'] = 'Aţi vizualizat deja mai mult de o pagină din această lecţie.<br />Doriţi să reveniţi la prima pagină pe care aţi văzut-o?';
$string['youranswer'] = 'Răspunsul tău';
$string['yourcurrentgradeis'] = 'Nota dumneavoastră în acest moment este {$a}';
$string['yourcurrentgradeisoutof'] = 'În prezent nota ta este {$a->grade}, din {$a->total}.';
$string['youshouldview'] = 'Trebuie să răspunzi la cel puţin {$a} întrebări.';
