<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_oauth2', language 'et', version '4.4'.
 *
 * @package     auth_oauth2
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accountexists'] = 'Selle kasutajanimega kasutaja on selles õpikeskkonnas juba olemas. Kui see on teie konto, logige oma kasutajanime ja parooli abil sisse ning lisage see eelistuste lehel seotud sisselogimisena.';
$string['alreadylinked'] = 'See väline konto on juba selle õpikeskkonna kontoga seotud';
$string['auth_oauth2description'] = 'Standardi OAuth 2 põhine autentimine';
$string['auth_oauth2settings'] = 'OAuth 2 autentimissätted.';
$string['confirmaccountemail'] = 'Tere, {$a->fullname}!

Õpikeskkonnas „{$a->sitename}“ on teie meiliaadressiga taotletud uut kontot.


Uue konto kinnitamiseks avage see veebiaadress:

{$a->link}

Enamikus meilirakendustes kuvatakse see sinise klõpsatava lingina.
 Kui see ei toimi,
ja kleepige aadress brauseriakna ülaservas olevale aadressiribale.


Kui vajate abi, võtke ühendust saidi administraatoriga
{$a->admin}';
$string['confirmaccountemailsubject'] = '{$a}: kasutajakonto kinnitamine';
$string['confirmationinvalid'] = 'Kinnituslink ei sobi või on aegunud. Uue kinnitusmeili genereerimiseks alustage sisselogimistoimingut uuesti.';
$string['confirmationpending'] = 'Konto on meili kaudu kinnitamise ootel.';
$string['confirmlinkedloginemail'] = 'Tere, {$a->fullname}!

Esitatud on taotlus, et teie meiliaadressi abil seotaks {$a->issuername} konto {$a->linkedemail} teie kontoga õpikeskkonnas „{$a->sitename}“.


Selle taotluse kinnitamiseks ja nende kontode sidumiseks avage see veebiaadress:

{$a->link}

Enamikus meilirakendustes kuvatakse see sinise klõpsatava lingina.
 Kui see ei toimi,
ja kleepige aadress brauseriakna ülaservas olevale aadressiribale.


Kui vajate abi, võtke ühendust saidi administraatoriga
{$a->admin}';
$string['confirmlinkedloginemailsubject'] = '{$a}: seotud sisselogimise kinnitus';
$string['createaccountswarning'] = 'See autentimislisandmoodul võimaldab kasutajatel teie õpikeskkonnas kontosid luua. Selle lisandmooduli kasutamise korral on soovitatav lubada säte „authpreventaccountcreation“.';
$string['createnewlinkedlogin'] = 'Seo uus konto ({$a})';
$string['emailconfirmlink'] = 'Oma kontode sidumine';
$string['emailconfirmlinksent'] = '<p>Selle meiliaadressiga leiti olemasolev konto, kuid see pole veel seotud.</p>
<p>Enne sisselogimist tuleb kontod siduda.</p>
<p>Teie meiliaadressile <b>{$a}</b> on saadetud meilisõnum.</p>
<p>See sisaldab lihtsaid kontode sidumise juhiseid.</p>
<p>Probleemide korral pöörduge õpikeskkonna administraatori poole.</p>';
$string['emailpasswordchangeinfo'] = 'Tere, {$a->firstname}

Keegi (tõenäoliselt sina) on taotlenud sinu konto jaoks uut parooli saidil \'{$a->sitename}\'.

Sinu parooli ei saa aga lähtestada, kuna kasutad sisselogimiseks oma kontot mõnel teisel saidil.

Logi sisse nagu varem, kasutades sisselogimislehel olevat linki.
{$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: Muuda parooli informatsiooni';
$string['info'] = 'Väline konto';
$string['issuer'] = 'OAuth 2 teenus';
$string['issuernologin'] = 'Seda väljaandjat ei saa sisselogimiseks kasutada.';
$string['linkedlogins'] = 'Seotud sisselogimised';
$string['linkedloginshelp'] = 'Seotud sisselogimiste spikker';
$string['loginerror_authenticationfailed'] = 'Autentimisprotsess nurjus';
$string['loginerror_cannotcreateaccounts'] = 'Teie meiliaadressiga kontot ei leitud.';
$string['loginerror_invaliddomain'] = 'See meiliaadress pole selles õpikeskkonnas lubatud.';
$string['loginerror_nouserinfo'] = 'Kasutajateavet ei tagastatud. Võimalik, et OAuth 2 teenus on valesti konfigureeritud.';
$string['loginerror_userincomplete'] = 'Tagastatud kasutajateabes pole kasutajanime ega meiliaadressi. Võimalik, et OAuth 2 teenus on valesti konfigureeritud.';
$string['noissuersavailable'] = 'Ükski konfigureeritud OAuth 2 teenustest ei luba sisselogimiskontosid siduda.';
$string['notenabled'] = 'OAuth 2 autentimislisandmoodul pole kahjuks lubatud.';
$string['notloggedindebug'] = 'Sisselogimiskatse nurjus. Põhjus: {$a}';
$string['notwhileloggedinas'] = 'Teise kasutajana sisselogituna ei saa seotud sisselogimisi hallata.';
$string['oauth2:managelinkedlogins'] = 'Oma seotud sisselogimiskontode haldamine';
$string['plugindescription'] = 'Selle autentimislisandmooduli sisselogimislehel on kuvatud konfigureeritud identiteedipakkujate loend. Identiteedipakkuja valimine võimaldab kasutajatel oma identimisteabega OAuth 2 pakkuja juurest sisse logida.';
$string['pluginname'] = 'OAuth 2';
$string['privacy:metadata:auth_oauth2'] = 'OAuth 2 autentimine';
$string['privacy:metadata:auth_oauth2:authsubsystem'] = 'See plugin on seotud autentimise alamsüsteemiga.';
$string['privacy:metadata:auth_oauth2:confirmtoken'] = 'Kinnituse turvamärk';
$string['privacy:metadata:auth_oauth2:confirmtokenexpires'] = 'Ajatempel turvamärgi kehtetuks muutumise ajaga.';
$string['privacy:metadata:auth_oauth2:email'] = 'Väline e-post mis on seotud selle kontoga.';
$string['privacy:metadata:auth_oauth2:issuerid'] = 'Selle OAuth 2 sisselogimise jaoks OAuth 2 väljaandja ID';
$string['privacy:metadata:auth_oauth2:tableexplanation'] = 'OAuth 2 kontod, mis on seotud kasutaja Moodle\'i kasutajakontoga.';
$string['privacy:metadata:auth_oauth2:timecreated'] = 'Ajatempel selle kohta, mil kasutajakonto seoti OAuth 2 logimisega.';
$string['privacy:metadata:auth_oauth2:timemodified'] = 'Ajatempel selle kohta, mil seda kaarti viimati muudeti.';
$string['privacy:metadata:auth_oauth2:userid'] = 'Kasutaja ID, kelle kasutajakonto on seotud OAuth 2 logimisega.';
$string['privacy:metadata:auth_oauth2:usermodified'] = 'Konto muutja kasutaja ID.';
$string['privacy:metadata:auth_oauth2:username'] = 'Selle kontoga seotud väline kasutajanimi.';
