<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'id', version '4.4'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.block_myoverview.browseallcourses'] = 'Telusuri semua kursus';
$string['addon.block_myoverview.nocoursesenrolled'] = 'Anda belum terdaftar dalam kursus apa pun.';
$string['addon.block_myoverview.nocoursesenrolleddescription'] = 'Jelajahi semua kursus yang tersedia di bawah ini dan mulailah belajar.';
$string['addon.block_myoverview.noresult'] = 'Penelusuran Anda tidak cocok dengan kursus mana pun.';
$string['addon.block_myoverview.noresultdescription'] = 'Coba sesuaikan filter Anda atau jelajahi semua kursus di bawah ini.';
$string['addon.blog.errorloadentries'] = 'Kesalahan memuat entri blog.';
$string['addon.blog.showonlyyourentries'] = 'Tampilkan hanya entri Anda';
$string['addon.calendar.calendarevent'] = 'Acara kalender';
$string['addon.calendar.calendarevents'] = 'Acara kalender';
$string['addon.calendar.calendarreminders'] = 'Pengingat kalender';
$string['addon.calendar.currentmonth'] = 'Bulan ini';
$string['addon.calendar.defaultnotificationtime'] = 'Pemberitahuan waktu bawaan';
$string['addon.calendar.errorloadevent'] = 'Galat saat memuat acara.';
$string['addon.calendar.errorloadevents'] = 'Galat memuat acara.';
$string['addon.calendar.monthlyview'] = 'Tampilan bulanan';
$string['addon.calendar.noevents'] = 'Tidak ada acara';
$string['addon.calendar.reminders'] = 'Pengingat';
$string['addon.calendar.setnewreminder'] = 'Setel pengingat baru';
$string['addon.competency.errornocompetenciesfound'] = 'Kompetensi tidak ditemukan';
$string['addon.competency.nocompetencies'] = 'Tidak ada kompetensi';
$string['addon.coursecompletion.complete'] = 'Selesai';
$string['addon.coursecompletion.couldnotloadreport'] = 'Tidak dapat memuat laporan penyelesaian kursus. Coba lagi nanti.';
$string['addon.enrol_self.confirmselfenrol'] = 'Apakah Anda yakin ingin mendaftarkan diri pada kursus ini?';
$string['addon.enrol_self.errorselfenrol'] = 'Terjadi kesalahan saat mendaftar mandiri.';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Konfigurasikan perangkat';
$string['addon.messageoutput_airnotifier.pushdisabledwarning'] = 'Pengguna Anda tidak menerima pemberitahuan apa pun dari situs ini di perangkat seluler mereka. Aktifkan notifikasi seluler di halaman setelan Notifikasi.';
$string['addon.messages.contactlistempty'] = 'Daftar kontak kosong.';
$string['addon.messages.contactname'] = 'Nama kontak';
$string['addon.messages.deletemessage'] = 'Hapus pesan';
$string['addon.messages.deletemessageconfirmation'] = 'Apakah Anda yakin ingin menghapus pesan ini? Pesan tersebut hanya akan dihapus dari riwayat perpesanan Anda dan masih dapat dilihat oleh pengguna yang mengirim atau menerima pesan tersebut.';
$string['addon.messages.errordeletemessage'] = 'Terjadi kesalahan saat menghapus pesan ini.';
$string['addon.messages.errorwhileretrievingcontacts'] = 'Terjadi kesalahan saat mengambil kontak dari server.';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'Terjadi kesalahan saat mengambil diskusi dari server.';
$string['addon.messages.errorwhileretrievingmessages'] = 'Terjadi kesalahan saat mengambil pesan dari server.';
$string['addon.messages.errorwhileretrievingusers'] = 'Kesalahan saat mengambil pengguna dari server.';
$string['addon.messages.messagenotsent'] = 'Pesan tidak terkirim. Silahkan coba lagi.';
$string['addon.messages.newmessages'] = 'Pesan baru';
$string['addon.messages.nousersfound'] = 'Pengguna tidak ditemukan';
$string['addon.messages.showdeletemessages'] = 'Tampilkan hapus pesan';
$string['addon.messages.type_blocked'] = 'Blokir';
$string['addon.messages.type_offline'] = 'Luring';
$string['addon.messages.type_online'] = 'Daring';
$string['addon.messages.type_search'] = 'Hasil pencarian';
$string['addon.messages.type_strangers'] = 'Lainnya';
$string['addon.messages.useentertosenddescdesktop'] = 'Jika dinonaktifkan, Anda dapat menggunakan Ctrl+Enter untuk mengirim pesan.';
$string['addon.messages.useentertosenddescmac'] = 'Jika dinonaktifkan, Anda dapat menggunakan Cmd+Enter untuk mengirim pesan.';
$string['addon.messages.warningconversationmessagenotsent'] = 'Tidak dapat mengirim pesan ke percakapan {{conversation}}. {{error}}';
$string['addon.messages.warningmessagenotsent'] = 'Tidak dapat mengirim pesan ke pengguna {{user}}. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'Mohon terima pernyataan ajuan.';
$string['addon.mod_assign.allowsubmissionsanddescriptionfromdatesummary'] = 'Detail tugas dan formulir penyerahan akan tersedia dari <strong>{{$a}}</strong>';
$string['addon.mod_assign.allowsubmissionsfromdatesummary'] = 'Tugas ini akan menerima kiriman dari <strong>{{$a}}</strong>';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'Anda tidak dapat menambahkan atau mengedit pengajuan di aplikasi karena kami tidak dapat mengambil pernyataan ajuan dari situs.';
$string['addon.mod_assign.cannotgradefromapp'] = 'Beberapa metode penilaian belum didukung oleh aplikasi dan tidak bisa dimodifikasi.';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'Anda tidak dapat mengajukan penilaian di aplikasi karena kami tidak dapat mengambil pernyataan ajuan dari situs.';
$string['addon.mod_assign.duedateno'] = 'Tidak ada batas waktu';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'Anda tidak dapat mengajukan penilaian di aplikasi karena beberapa pengaya tidak didukung untuk mengedit.';
$string['addon.mod_assign.errorshowinginformation'] = 'Informasi pengiriman tidak dapat ditampilkan.';
$string['addon.mod_assign.feedbacknotsupported'] = 'Umpan balik ini tidak didukung oleh aplikasi dan mungkin tidak menyimpan semua informasi.';
$string['addon.mod_assign.gradenotsynced'] = 'Nilai belum disinkronisasi.';
$string['addon.mod_assign.notallparticipantsareshown'] = 'Peserta yang tidak mengumpulkan tidak ditampilkan.';
$string['addon.mod_assign.numberofdraftsubmissionscountdescription'] = 'Terdapat {{count}} draf.';
$string['addon.mod_assign.numberofparticipantscountdescription'] = 'Terdapat {{count}} peserta.';
$string['addon.mod_assign.numberofsubmissionsneedgradingcountdescription'] = 'Terdapat {{count}} pengajuan yang perlu dinilai.';
$string['addon.mod_assign.numberofsubmittedassignmentscountdescription'] = 'Terdapat {{count}} tugas yang dikirimkan.';
$string['addon.mod_assign.numberofteamscountdescription'] = 'Terdapat {{count}} tim.';
$string['addon.mod_assign.submissionnotsupported'] = 'Pengajuan ini tidak didukung oleh aplikasi dan mungkin tidak berisi semua informasi.';
$string['addon.mod_assign.syncblockedusercomponent'] = 'nilai pengguna';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'Pengajuan nilai telah dimodifikasi dalam situs.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'Pengajuan pengguna telah dimodifikasi pada situs.';
$string['addon.mod_chat.confirmloss'] = 'Apakah anda yakin? Riwayat obrolan dapat hilang.';
$string['addon.mod_chat.errorwhileconnecting'] = 'Galat ketika terhubung ke obrolan.';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'Galat ketika mengumpulkan data obrolan.';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'Galat ketika mendapatkan pengguna obrolan.';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'Galat saat mengambil pesan dari server.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'Galat saat mengirim pesan.';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Anda harus daring untuk mengirim pesan.';
$string['addon.mod_chat.nosessionsfound'] = 'Sesi tidak ditemukan';
$string['addon.mod_chat.showincompletesessions'] = 'Tampilkan sesi yang tidak lengkap';
$string['addon.mod_choice.errorgetchoice'] = 'Galat saat mendapatkan data pilihan.';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% pengguna memilih opsi: {{teks}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'Tanggapan terakhir Anda harus disinkronkan sebelum disertakan dalam hasil.';
$string['addon.mod_data.edittagsnotsupported'] = 'Maaf, pengeditan tag tidak didukung oleh aplikasi.';
$string['addon.mod_data.errorapproving'] = 'Terjadi kesalahan saat menyetujui atau tidak menyetujui entri.';
$string['addon.mod_data.errordeleting'] = 'Galat saat menghapus entri.';
$string['addon.mod_data.gettinglocation'] = 'Mendapatkan lokasi';
$string['addon.mod_data.locationnotenabled'] = 'Lokasi tidak diaktifkan';
$string['addon.mod_data.locationpermissiondenied'] = 'Izin untuk mengakses lokasi Anda telah ditolak.';
$string['addon.mod_data.mylocation'] = 'Lokasi saya';
$string['addon.mod_data.searchbytagsnotsupported'] = 'Maaf, pencarian dengan label tidak didukung oleh aplikasi.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'Umpan balik dengan captcha tidak dapat diselesaikan secara luring, atau jika tidak dikonfigurasi, atau jika server tidak aktif.';
$string['addon.mod_feedback.completedfeedbackscountdescription'] = 'Terdapat {{count}} jawaban terkirim.';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'Umpan balik ini telah disimpan untuk diserahkan kemudian.';
$string['addon.mod_feedback.questionscountdescription'] = 'Terdapat {{count}} pertanyaan.';
$string['addon.mod_folder.emptyfilelist'] = 'Tidak ada berkas untuk ditampilkan.';
$string['addon.mod_forum.errorgetforum'] = 'Galat saat mendapatkan data forum.';
$string['addon.mod_forum.errorgetgroups'] = 'Galat saat mendapatkan pengaturan grup.';
$string['addon.mod_forum.errorloadingsortingorder'] = 'Forum tidak tersedia dalam urutan penyortiran ini';
$string['addon.mod_forum.errorloadingsortingorderdetails'] = 'Coba ubah urutan penyortiran atau online untuk melihat forum ini.';
$string['addon.mod_forum.errorposttoallgroups'] = 'Tidak dapat membuat diskusi baru di semua grup.';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'Belum ada topik diskusi di forum ini.';
$string['addon.mod_forum.group'] = 'Grup';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} diskusi';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} jawaban';
$string['addon.mod_forum.postingroup'] = 'Kiriman pada grup "{{groupname}}".';
$string['addon.mod_forum.refreshposts'] = 'Mulat ulang kiriman';
$string['addon.mod_glossary.browsemode'] = 'Jelajah entri';
$string['addon.mod_glossary.byalphabet'] = 'Urut abjad';
$string['addon.mod_glossary.byauthor'] = 'Grup berdasarkan penulis';
$string['addon.mod_glossary.bycategory'] = 'Grup berdasarkan kategori';
$string['addon.mod_glossary.bynewestfirst'] = 'Yang terbaru dulu';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Yang baru diperbarui';
$string['addon.mod_glossary.bysearch'] = 'Cari';
$string['addon.mod_glossary.cannoteditentry'] = 'Tidak dapat mengedit entri';
$string['addon.mod_glossary.entriestobesynced'] = 'Entri yang akan disinkronkan';
$string['addon.mod_glossary.entrypendingapproval'] = 'Entri ini menunggu persetujuan.';
$string['addon.mod_glossary.errordeleting'] = 'Terjadi kesalahan saat menghapus entri.';
$string['addon.mod_glossary.errorloadingentries'] = 'Galat saat memuat entri-entri.';
$string['addon.mod_glossary.errorloadingentry'] = 'Galat saat memuat entri.';
$string['addon.mod_glossary.errorloadingglossary'] = 'Galat saat memuat glosarium.';
$string['addon.mod_glossary.noentriesfound'] = 'Tidak ada entri ditemukan.';
$string['addon.mod_glossary.searchquery'] = 'Penelusuran queri.';
$string['addon.mod_h5pactivity.downloadh5pfile'] = 'Unduh berkas H5P';
$string['addon.mod_h5pactivity.errorgetactivity'] = 'Galat dalam mendapatkan data aktivitas H5P.';
$string['addon.mod_h5pactivity.filestatenotdownloaded'] = 'Paket H5P tidak diunduh. Anda harus mengunduhnya untuk dapat menggunakannya.';
$string['addon.mod_h5pactivity.filestateoutdated'] = 'Paket H5P telah dimodifikasi sejak unduhan terakhir. Anda perlu mengunduhnya lagi untuk dapat menggunakannya.';
$string['addon.mod_h5pactivity.numberofattempts'] = '{{$a}} percobaan';
$string['addon.mod_h5pactivity.offlinedisabledwarning'] = 'Anda harus daring untuk melihat paket H5P.';
$string['addon.mod_h5pactivity.viewattempt'] = 'Tampilkan upaya {{$a}}';
$string['addon.mod_imscp.showmoduledescription'] = 'Tampilkan deskripsi';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'Pelajaran ini berisi lompatan ke halaman konten acak. Itu tidak dapat dicoba di aplikasi sampai dimulai di browser web.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'Upaya ini tidak bisa lagi ditinjau ulang karena usaha lain telah selesai.';
$string['addon.mod_lesson.finishretakeoffline'] = 'Upaya ini telah selesai secara luring.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'Sebuah upaya luring telah disinkronisasi. Apakah Anda ingin meninjaunya?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'Upaya telah selesai di situs.';
$string['addon.mod_lti.errorgetlti'] = 'Galat saat mendapatkan modul data.';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'URL peluncuran tidak valid.';
$string['addon.mod_lti.launchactivity'] = 'Luncurkan aktivitas';
$string['addon.mod_page.errorwhileloadingthepage'] = 'Galat saat memuat halaman konten.';
$string['addon.mod_quiz.canattemptbutnotsubmit'] = 'Anda dapat mencoba kuis ini di aplikasi, tetapi Anda harus mengirimkannya di peramban karena alasan berikut:';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'Upaya kuis ini tidak dapat diajukan karena alasan berikut:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'Upaya ini belum disinkronkan sejak {{$a}}. Jika Anda terus melakukan upaya ini di perangkat lain sejak saat itu, Anda mungkin kehilangan data.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'Galat menyimpan jawabannya. Apakah Anda yakin ingin meninggalkan kuis?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'Kuis ini tidak dapat dicoba di aplikasi karena perilaku soal tidak didukung oleh aplikasi:';
$string['addon.mod_quiz.errordownloading'] = 'Galat saat mengunduh data yang diperlukan.';
$string['addon.mod_quiz.errorgetattempt'] = 'Galat mendapatkan data percobaan';
$string['addon.mod_quiz.errorgetquestions'] = 'Galat mendapatkan pertanyaan.';
$string['addon.mod_quiz.errorgetquiz'] = 'Galat saat mendapatkan data kuis.';
$string['addon.mod_quiz.errorparsequestions'] = 'Galat ketika membaca pertanyaan ini. Silahkan upayakan kuis ini di peramban web.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'Kuis ini tidak bisa dicoba di aplikasi karena berisi soal yang tidak didukung oleh aplikasi.';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'Kuis ini tidak dapat dicoba di aplikasi karena memiliki aturan akses yang tidak didukung oleh aplikasi:';
$string['addon.mod_quiz.errorsaveattempt'] = 'Galat saat menyimpan data pengerjaan.';
$string['addon.mod_quiz.finishedofflinenotice'] = 'Upaya Anda telah dikirimkan dan disimpan. Itu akan dikirim ke situs ketika Anda daring lagi.';
$string['addon.mod_quiz.finishnotsynced'] = 'Selesai tapi belum belum disinkronkan';
$string['addon.mod_quiz.opentoc'] = 'Buka navigasi popover.';
$string['addon.mod_quiz.warningattemptfinished'] = 'Upaya luring telah dibuang seperti telah selesai di situs atau tidak ditemukan.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'Beberapa jawaban luring telah dibuang karena soal telah dimodifikasi secara daring.';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'Pengerjaan tidak terselesaikan karena beberapa jawaban luring telah dibuang. Harap tinjau kembali jawaban Anda kemudian kirim ulang.';
$string['addon.mod_quiz.warningquestionsnotsupported'] = 'Kuis ini berisi soal yang tidak didukung oleh aplikasi:';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'Galat ketika memuat konten.';
$string['addon.mod_resource.openthefile'] = 'Buka';
$string['addon.mod_resource.resourcestatusoutdated'] = 'Berkas ini telah berubah sejak terakhir kali Anda membukanya.';
$string['addon.mod_resource.resourcestatusoutdatedconfirm'] = 'Ada versi yang lebih baru dari berkas ini. Untuk melihatnya, harap sambungkan perangkat Anda ke internet.';
$string['addon.mod_scorm.cannotcalculategrade'] = 'Nilai tidak bisa dihitung.';
$string['addon.mod_scorm.dataattemptshown'] = 'Data ini milik upaya nomor {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'Galat ketika mengerjakan luring. Silahkan coba lagi';
$string['addon.mod_scorm.errordownloadscorm'] = 'Galat saat mengunduh SCORM: "{{name}}".';
$string['addon.mod_scorm.errorgetscorm'] = 'Galat saat mendapatkan data SCORM.';
$string['addon.mod_scorm.errorinvalidversion'] = 'Maaf, aplikasi hanya mendukung SCORM 1.2.';
$string['addon.mod_scorm.errornotdownloadable'] = 'Unduhan paket SCORM dinonaktifkan di situs Moodle Anda. Silahkan hubungi administrator situs Moodle Anda.';
$string['addon.mod_scorm.errornovalidsco'] = 'SCORM ini tidak memiliki SCO yang terlihat untuk dimuat.';
$string['addon.mod_scorm.errorpackagefile'] = 'Maaf, aplikasi ini hanya mendukung paket ZIP.';
$string['addon.mod_scorm.errorsyncscorm'] = 'Galat saat sinkronisasi. Silahkan coba lagi.';
$string['addon.mod_scorm.offlineattemptnote'] = 'Pengerjaan ini memiliki data yang belum disinkronkan.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Pengerjaan ini tidak dapat dikirim karena Anda melampaui jumlah upaya maksimal.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'SCORM ini tidak diunduh Ini akan otomatis diunduh saat Anda membukanya.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'SCORM ini telah dimodifikasi sejak pengunduhan terakhir. Ini akan otomatis diunduh saat Anda membukanya.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'Beberapa upaya data luring {{number}} telah dihapus karena tidak dapat dihitung menjadi upaya baru.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Beberapa upaya tidak bisa sinkron dengan situs karena upaya daring terakhir tidak selesai. Silahkan selesaikan upaya daring terlebih dahulu.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'Maaf, terdapat masalah saat mengumpulkan survey Anda. Silahkan coba lagi.';
$string['addon.mod_survey.errorgetsurvey'] = 'Galat mendapatkan data survey.';
$string['addon.mod_survey.results'] = 'Hasil';
$string['addon.mod_url.accessurl'] = 'Akses URL';
$string['addon.mod_url.pointingtourl'] = 'URL rujukan sumber daya.';
$string['addon.mod_wiki.errorloadingpage'] = 'Galat saat memuat halaman.';
$string['addon.mod_wiki.errornowikiavailable'] = 'Wiki belum memiliki konten.';
$string['addon.mod_wiki.gowikihome'] = 'Ke Beranda Wiki';
$string['addon.mod_wiki.subwiki'] = 'Subwiki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'Judul tidak boleh kosong';
$string['addon.mod_wiki.viewpage'] = 'Lihat halaman';
$string['addon.mod_wiki.wikipage'] = 'Halaman Wiki';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'Strategi penilaian {{$a}} tidak didukung';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'Anda harus memasukkan judul.';
$string['addon.mod_workshop.warningassessmentmodified'] = 'Pengajuan telah dimodifikasi di situs.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'Penilaian diubah di situs.';
$string['addon.notes.warningnotenotsent'] = 'Tidak dapat menambah atau menghapus catatan. {{error}}';
$string['addon.notifications.allownotifications'] = 'Izinkan notifikasi';
$string['addon.notifications.errorgetnotifications'] = 'Galat saat mendapatkan pemberitahuan.';
$string['addon.notifications.notifications'] = 'Pemberitahuan';
$string['addon.notifications.playsound'] = 'Putar suara';
$string['addon.notifications.therearentnotificationsyet'] = 'Tidak ada pemberitahuan.';
$string['addon.notifications.typeofnotification'] = 'Jenis pemberitahuan';
$string['addon.privatefiles.couldnotloadfiles'] = 'Daftar berkas tidak dapat dimuat.';
$string['addon.privatefiles.emptyfilelist'] = 'Tidak ada berkas untuk ditampilkan.';
$string['addon.privatefiles.erroruploadnotworking'] = 'Sayangnya saat ini tidak mungkin mengunggah berkas ke situs Anda.';
$string['addon.storagemanager.confirmdeleteallsitedata'] = 'Hapus semua data unduhan situs?';
$string['addon.storagemanager.confirmdeletecourses'] = 'Hapus data yang diunduh dari semua kursus?';
$string['addon.storagemanager.confirmdeletedatafrom'] = 'Hapus semua data yang diunduh dari \'{{name}}\'?';
$string['addon.storagemanager.coursedownloads'] = 'Unduhan kursus';
$string['addon.storagemanager.courseinfo'] = 'Unduh konten kursus untuk bekerja luring. Aktivitas Anda akan disinkronkan secara otomatis saat perangkat Anda kembali daring.';
$string['addon.storagemanager.deleteallsitedata'] = 'Hapus semua data unduhan situs';
$string['addon.storagemanager.deleteallsitedatainfo'] = 'Ini akan menghapus semua data yang diunduh dari \'{{name}}\', termasuk semua kursus yang diunduh dan data yang memungkinkan Anda bekerja luring.';
$string['addon.storagemanager.deletecourses'] = 'Keluarkan semua data kursus';
$string['addon.storagemanager.deletedata'] = 'Hapus data yang diunduh';
$string['addon.storagemanager.deletedatafrom'] = 'Hapus semua data yang diunduh dari \'{{name}}\'';
$string['addon.storagemanager.downloaddatafrom'] = 'Unduh {{name}}';
$string['addon.storagemanager.downloadedcourses'] = 'Kursus yang diunduh';
$string['addon.storagemanager.downloads'] = 'Unduh';
$string['addon.storagemanager.errordeletedownloadeddata'] = 'Galat saat menghapus data terunduh.';
$string['addon.storagemanager.managedownloads'] = 'Kelola unduhan';
$string['addon.storagemanager.totaldownloads'] = 'Total unduhan';
$string['addon.storagemanager.totalspaceusage'] = 'Total penggunaan ruang';
$string['addon.tinymce.enabletinymceeditor'] = 'Gunakan penyunting teks TinyMCE';
$string['addon.tinymce.enabletinymceeditordescription'] = 'Penyunting teks tingkat lanjut dengan fitur pemformatan tambahan.';
$string['addon.tinymce.license'] = 'Moodle Pty Ltd diberi lisensi komersial TinyMCE yang kompatibel dengan lisensi Apache 2.0.';
$string['appstoredescription'] = 'CATATAN: Aplikasi Moodle Mobile resmi ini HANYA akan bekerja dengan situs Moodle yang telah disiapkan untuk menampilkannya. Silakan berbicara dengan administrator Moodle Anda jika Anda memiliki masalah dalam koneksi.

Jika situs Moodle Anda telah dikonfigurasi dengan benar, Anda dapat menggunakan aplikasi ini untuk:

- Jelajahi isi course Anda, bahkan saat offline
- menerima pemberitahuan instan dari pesan dan acara lainnya
- Menghubungi dengan cepat orang lain di course Anda
- Mengunggah gambar, audio, video dan file lainnya dari perangkat mobile Anda
- Melihat nilai course Anda
- dan banyak lagi!

Silakan lihat di http://docs.moodle.org/en/Mobile_app untuk semua informasi terbaru.

Kami akan sangat menghargai ulasan bagus tentang fungsionalitas sejauh ini, dan saran Anda tentang hal lain yang Anda inginkan agar dilakukan oleh aplikasi ini!

Aplikasi ini memerlukan izin berikut:
Rekam audio - Untuk merekam audio untuk diunggah ke Moodle
Baca dan ubah isi kartu SD Anda - Isi diunduh ke Kartu SD sehingga Anda dapat melihatnya secara offline
Akses jaringan - Untuk bisa terhubung dengan situs Moodle Anda dan periksa apakah Anda terhubung atau tidak untuk beralih ke mode offline
Jalankan saat startup - Jadi Anda menerima notifikasi lokal meskipun aplikasi berjalan di latar belakang
Cegah ponsel tertidur - Jadi Anda bisa menerima notifikasi kapan saja';
$string['assets.mimetypes.application/vnd.apple.keynote'] = 'Presentasi Apple Keynote';
$string['assets.mimetypes.application/vnd.apple.numbers'] = 'Spreadsheet Apple Numbers';
$string['assets.mimetypes.application/vnd.apple.pages'] = 'Dokumen Apple Pages';
$string['assets.mimetypes.application/vnd.google-apps.audio'] = 'Audio Google Drive';
$string['assets.mimetypes.application/vnd.google-apps.document'] = 'Google Dokumen';
$string['assets.mimetypes.application/vnd.google-apps.drawing'] = 'Google Drawing';
$string['assets.mimetypes.application/vnd.google-apps.file'] = 'Berkas Google Drive';
$string['assets.mimetypes.application/vnd.google-apps.folder'] = 'Folder Google Drive';
$string['assets.mimetypes.application/vnd.google-apps.form'] = 'Formulir Google';
$string['assets.mimetypes.application/vnd.google-apps.fusiontable'] = 'Tabel Google Fusion';
$string['assets.mimetypes.application/vnd.google-apps.presentation'] = 'Google Slide';
$string['assets.mimetypes.application/vnd.google-apps.script'] = 'Google Apps Scripts';
$string['assets.mimetypes.application/vnd.google-apps.site'] = 'Google Sites';
$string['assets.mimetypes.application/vnd.google-apps.spreadsheet'] = 'Google Sheets';
$string['assets.mimetypes.application/vnd.google-apps.video'] = 'Video Google Drive';
$string['core.ajaxendpointnotfound'] = 'Titik akhir AJAX tidak ditemukan. Ini bisa terjadi jika situs Moodle terlalu tua atau memblokir akses ke titik akhir ini. Aplikasi Moodle hanya mendukung sistem Moodle {{$a}} dan seterusnya.';
$string['core.browser'] = 'Peramban';
$string['core.calculating'] = 'Menghitung';
$string['core.cannotconnect'] = 'Tidak dapat terhubungTidak dapat terhubung';
$string['core.cannotdownloadfiles'] = 'Sekolah atau penyedia pembelajaran Anda telah menonaktifkan pengunduhan berkas.';
$string['core.cannotinstallapk'] = 'Tidak dapat menginstal berkas .apk';
$string['core.cannotinstallapkinfo'] = 'Untuk alasan keamanan, Anda tidak dapat memasang aplikasi yang tidak dikenal di perangkat Anda dari aplikasi ini. Jika Anda masih ingin melanjutkan penginstalan, Anda harus membukanya di peramban.';
$string['core.cannotlogoutpageblocks'] = 'Harap simpan atau buang perubahan Anda sebelum melanjutkan.';
$string['core.cannotopeninapp'] = 'Berkas mungkin tidak akan berfungsi seperti diharapkan pada perangkat ini. Apakah Anda tetap ingin membukanya?';
$string['core.cannotopeninappdownload'] = 'Berkas mungkin tidak akan berfungsi seperti diharapkan pada perangkat ini. Apakah Anda tetap ingin mengunduhnya?';
$string['core.captureaudio'] = 'Rekam audio';
$string['core.capturedimage'] = 'Gambar diambil.';
$string['core.captureimage'] = 'Ambil gambar';
$string['core.capturevideo'] = 'Rekam video';
$string['core.certificaterror'] = 'Sertifikat situs ini tidak dapat dipercaya oleh perangkat Anda: {{details}}';
$string['core.clearsearch'] = 'Hapus pencarian';
$string['core.clearstoreddata'] = 'Kosongkan penyimpanan {{$a}}';
$string['core.clicktoseefull'] = 'Klik untuk melihat konten lengkap';
$string['core.comments.commentsnotworking'] = 'Komentar tidak dapat diambil';
$string['core.comments.warningcommentsnotsent'] = 'Tidak dapat menyinkronkan komentar. {{error}}';
$string['core.confirmcanceledit'] = 'Apakah Anda yakin ingin meninggalkan halaman ini? Semua perubahan akan hilang.';
$string['core.confirmleavepagedescription'] = 'Perubahan yang belum disimpan akan hilang.';
$string['core.confirmleavepagetitle'] = 'Tinggalkan halaman?';
$string['core.confirmleaveunknownchanges'] = 'Apakah Anda yakin ingin meninggalkan laman ini? Jika Anda memiliki perubahan yang belum disimpan, perubahan tersebut akan hilang.';
$string['core.confirmloss'] = 'Apa Anda yakin? Semua perubahan akan hilang.';
$string['core.confirmopeninbrowser'] = 'Apakah Anda ingin membukanya di peramban web?';
$string['core.confirmremoveselectedfile'] = 'Ini akan menghapus \'{{filename}}\' secara permanen. Anda tidak dapat membatalkannya.';
$string['core.confirmremoveselectedfiles'] = 'Ini akan menghapus file yang dipilih secara permanen. Anda tidak dapat membatalkannya.';
$string['core.connectandtryagain'] = 'Harap sambungkan ke internet dan coba lagi.';
$string['core.connectionlost'] = 'Koneksi ke situs terputus';
$string['core.contactsupport'] = 'Hubungi bantuan';
$string['core.contactverb'] = 'Kontak';
$string['core.contenteditingsynced'] = 'Komentar yang Anda edit telah disinkronkan.';
$string['core.contentlinks.chooseaccount'] = 'Pilih akun';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Pilih akun untuk buka tautan.';
$string['core.contentlinks.confirmurlothersite'] = 'Tautan milik situs lain. Apakah Anda ingin membukanya?';
$string['core.contentlinks.errornoactions'] = 'Tidak dapat menemukan aksi yang dapat dilakukan dengan tautan ini.';
$string['core.contentlinks.errornosites'] = 'Tidak dapat menemukan situs apapun untuk menangani tautan ini.';
$string['core.contentlinks.errorredirectothersite'] = 'URL pengalihan tidak dapat mengarah ke situs lain.';
$string['core.copiedtoclipboard'] = 'Teks disalin ke papan klip';
$string['core.copytoclipboard'] = 'Salin ke papan klip';
$string['core.course.activitydisabled'] = 'Organisasi Anda telah menonaktifkan aktivitas ini di aplikasi seluler.';
$string['core.course.activitynotavailableoffline'] = 'Aktivitas ini tidak tersedia secara luring.';
$string['core.course.activitynotyetviewableremoteaddon'] = 'Organisasi Anda memasang pengaya yang belum didukung.';
$string['core.course.activityrequiresconnection'] = 'Aktivitas ini hanya dapat dilakukan dengan koneksi internet. Jika perangkat Anda sedang luring, Anda tidak akan dapat mengaksesnya.';
$string['core.course.allsections'] = 'Semua topik';
$string['core.course.aria:sectionprogress'] = 'Kemajuan topik:';
$string['core.course.availablespace'] = 'Saat ini Anda memiliki sekitar {{available}} ruang kosong.';
$string['core.course.cannotdeletewhiledownloading'] = 'Berkas tidak dapat dihapus saat aktivitas sedang diunduh. Tunggu hingga unduhan selesai.';
$string['core.course.changesofflinemaybelost'] = 'Segala perubahan yang Anda buat pada aktivitas ini saat luring mungkin tidak disimpan.<br><br>Hubungkan perangkat Anda ke internet untuk menghindari hilangnya kemajuan Anda.';
$string['core.course.confirmdownload'] = 'Anda akan mengunduh {{size}}.{{availableSpace}} Apakah Anda yakin ingin melanjutkan?';
$string['core.course.confirmdownloadunknownsize'] = 'Ukuran unduhan tidak diketahui.{{availableSpace}} Apakah Anda yakin ingin melanjutkan?';
$string['core.course.confirmdownloadzerosize'] = 'Anda akan mulai mengunduh. {{availableSpace}} Anda yakin ingin melanjutkan?';
$string['core.course.confirmlimiteddownload'] = 'Anda saat ini tidak terhubung ke Wi-Fi.';
$string['core.course.confirmpartialdownloadsize'] = 'Anda akan mengunduh <strong>setidaknya</strong> {{size}}.{{availableSpace}} Apakah Anda yakin ingin melanjutkan?';
$string['core.course.couldnotloadsectioncontent'] = 'Tidak dapat memuat topik konten. Silahkan Coba lagi nanti.';
$string['core.course.couldnotloadsections'] = 'Tidak dapat memuat topik. Silahkan Coba lagi nanti.';
$string['core.course.downloadcoursesprogressdescription'] = 'Mengunduh kursus: terunduh {{count}} dari {{total}}.';
$string['core.course.downloadsectionprogressdescription'] = 'Bagian pengunduhan: diunduh {{count}} dari {{total}}.';
$string['core.course.errordownloadingcourse'] = 'Galat saat mengunduh kursus.';
$string['core.course.errordownloadingsection'] = 'Galat saat mengunduh bagian.';
$string['core.course.errorgetmodule'] = 'Galat saat mendapatkan data modul.';
$string['core.course.insufficientavailablequota'] = 'Perangkat Anda tidak dapat mengalokasikan ruang untuk menyimpan unduhan ini. Mungkin memesan ruang untuk pembaruan aplikasi dan sistem. Harap hapus beberapa ruang penyimpanan terlebih dahulu.';
$string['core.course.insufficientavailablespace'] = 'Anda mencoba mengunduh {{size}}. Ini akan membuat perangkat Anda kekurangan ruang untuk beroperasi secara normal. Harap hapus beberapa ruang penyimpanan terlebih dahulu.';
$string['core.course.lastaccessedactivity'] = 'Aktivitas yang terakhir diakses';
$string['core.course.manualcompletionnotsynced'] = 'Penyelesaian manual tidak disinkronkan.';
$string['core.course.modulenotfound'] = 'Sumber atau aktivitas tidak ditemukan, pastikan Anda daring dan hal itu masih tersedia.';
$string['core.course.nextactivity'] = 'Aktivitas selanjutnya';
$string['core.course.nextactivitynotfound'] = 'Aktivitas berikutnya tidak ditemukan. Mungkin saja telah disembunyikan atau dihapus.';
$string['core.course.nocontentavailable'] = 'Tidak ada konten tersedia untuk saat ini.';
$string['core.course.previousactivity'] = 'Aktivitas sebelumnya';
$string['core.course.previousactivitynotfound'] = 'Aktivitas sebelumnya tidak ditemukan. Mungkin saja telah disembunyikan atau dihapus.';
$string['core.course.refreshcourse'] = 'Segarkan kursus';
$string['core.course.useactivityonbrowser'] = 'Anda masih dapat menggunakannya menggunakan peramban web perangkat Anda.';
$string['core.course.warningmanualcompletionmodified'] = 'Penyelesaian aktivitas manual telah dimodifikasi di situs.';
$string['core.course.warningofflinemanualcompletiondeleted'] = 'Beberapa penyelesaian manual kursus \'{{name}}\' telah dihapus. {{error}}';
$string['core.coursenogroups'] = 'Anda bukan anggota grup mana pun dalam kursus ini.';
$string['core.courses.browserenrolinstructions'] = 'Kami akan membawa Anda ke browser perangkat Anda. Setelah Anda menyelesaikan pendaftaran, silakan kembali ke aplikasi ini.';
$string['core.courses.cannotretrievemorecategories'] = 'Kategori yang lebih dalam dari level {{$a}} tidak dapat diambil.';
$string['core.courses.completeenrolmentbrowser'] = 'Selesaikan pendaftaran di browser';
$string['core.courses.downloadcourses'] = 'Unduh semua kursus';
$string['core.courses.enrolme'] = 'Daftarkan saya';
$string['core.courses.errorloadcategories'] = 'Galat saat memuat kategori.';
$string['core.courses.errorloadcourses'] = 'Galat saat memuat materi';
$string['core.courses.errorloadplugins'] = 'Pengaya yang diperlukan oleh kursus ini tidak dapat dimuat dengan benar. Harap muat ulang aplikasi untuk mencoba lagi.';
$string['core.courses.errorsearching'] = 'Galat saat melakukan pencarian.';
$string['core.courses.filtermycourses'] = 'Tapis kursus saya';
$string['core.courses.notenrollable'] = 'You cannot enrol yourself in this course.';
$string['core.courses.otherenrolments'] = 'Pendaftaran lainnya';
$string['core.courses.password'] = 'Kunci pendaftaran';
$string['core.courses.refreshcourses'] = 'Segarkan kursus';
$string['core.courses.searchcoursesadvice'] = 'Anda dapat menggunakan tombol cari kursus untuk menemukan kursus yang akan diakses sebagai tamu atau mendaftarkan diri Anda ke kursus yang mengizinkannya.';
$string['core.courses.showonlyenrolled'] = 'Tampilkan hanya kursus saya';
$string['core.courses.totalcoursesearchresults'] = 'Total kursus: {{$a}}';
$string['core.currentdevice'] = 'Perangkat saat ini';
$string['core.datastoredoffline'] = 'Data tersimpan di perangkat karena tidak dapat dikirim. Ini akan dikirim secara otomatis nanti.';
$string['core.deletedoffline'] = 'Dihapus luring';
$string['core.deleting'] = 'Menghapus';
$string['core.desktop'] = 'Destop';
$string['core.dfdaymonthyear'] = 'DD-MM-YYYY';
$string['core.dfdayweekmonth'] = 'ddd, D MMM';
$string['core.dffulldate'] = 'dddd, D MMMM YYYY h[:]mm A';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm A';
$string['core.discard'] = 'Dibuang';
$string['core.dismiss'] = 'Diabaikan';
$string['core.dontshowagain'] = 'Jangan tampilkan lagi.';
$string['core.downloaded'] = 'Diunduh';
$string['core.downloading'] = 'Mengunduh';
$string['core.editor.hidetoolbar'] = 'Sembunyikan bilah alat';
$string['core.editor.toggle'] = 'Alihkan editor';
$string['core.emptysplit'] = 'Halaman kosong akan muncul jika panel sebelah kiri kosong atau sedang memuat.';
$string['core.endingtime'] = 'Waktu berakhir: {{$a}}';
$string['core.errorchangecompletion'] = 'Galat saat mengubah status penyelesaian. Silahkan coba lagi.';
$string['core.errorcode'] = 'Kode kesalahan: {{errorCode}}';
$string['core.errordeletefile'] = 'Galat saat menghapus berkas. Silahkan coba lagi.';
$string['core.errordetailshide'] = 'Sembunyikan detail kesalahan';
$string['core.errordetailsshow'] = 'Tampilkan detail kesalahan';
$string['core.errordownloading'] = 'Galat saat mengunduh file';
$string['core.errordownloadingsomefiles'] = 'Galat saat mengunduh file modul. beberapa file mungkin hilang.';
$string['core.errorfileexistssamename'] = 'Sudah ada berkas dengan nama ini.';
$string['core.errorinvalidform'] = 'Harap periksa apakah semua kolom wajib diisi dan data yang Anda masukkan berada dalam format yang benar.';
$string['core.errorinvalidresponse'] = 'Respons tak terduga untuk layanan web {{method}}.';
$string['core.errorloadingcontent'] = 'Galat saat memuat konten.';
$string['core.errorofflinedisabled'] = 'Penjelajahan luring dinonaktifkan di situs Anda. Anda harus terhubung ke internet untuk menggunakan aplikasi ini.';
$string['core.erroropenfiledownloading'] = 'Galat membuka berkas: tunggu hingga usai mengunduh.';
$string['core.erroropenfilenoapp'] = 'Galat saat membuka file: tidak ditemukan aplikasi untuk membuka jenis file ini.';
$string['core.erroropenfilenoextension'] = 'Galat saat membuka file: file tidak memiliki ekstensi';
$string['core.erroropenpopup'] = 'Aktivitas ini mencoba membuka sembulan. Hai ini tidak didukung oleh aplikasi.';
$string['core.errorrenamefile'] = 'Galat saat mengubah nama file. silahkan coba lagi.';
$string['core.errorsitesupport'] = 'Jika masalah terus berlanjut, hubungi bantuan situs.';
$string['core.errorsomedatanotdownloaded'] = 'Jika Anda mengunduh aktivitas ini, harap perhatikan bahwa beberapa data tidak diunduh selama proses pengunduhan karena alasan kinerja dan penggunaan data.';
$string['core.errorsomethingwrong'] = 'Ada yang salah. Silakan coba lagi.';
$string['core.errorsync'] = 'Sebuah kesalahan terjadi melakukan sinkron. Coba lagi.';
$string['core.errorsyncblocked'] = '{{$a}} ini tidak dapat disinkronkan saat ini karena proses sedang berlangsung. Silakan coba lagi nanti. Jika masalah terus berlanjut, coba mulai ulang aplikasi.';
$string['core.errorurlschemeinvalidscheme'] = 'URL ini dimaksudkan untuk digunakan di aplikasi lain: {{$a}}.';
$string['core.errorurlschemeinvalidsite'] = 'URL situs ini tidak dapat dibuka di aplikasi ini.';
$string['core.exactalarmsturnedoff'] = 'Notifikasi waktu nyata dimatikan';
$string['core.exactalarmsturnedoffmessage'] = 'Untuk memastikan Anda tidak melewatkan peringatan penting apa pun, aktifkan \'Alarm dan pengingat\' di setelan perangkat Anda.';
$string['core.filedeletedsuccessfully'] = 'Anda telah berhasil menghapus \'{{filename}}\'';
$string['core.filenameexist'] = 'Nama berkas sudah ada: {{$a}}';
$string['core.fileuploader.audio'] = 'Audio';
$string['core.fileuploader.camera'] = 'Kamera';
$string['core.fileuploader.confirmuploadfile'] = 'Anda akan mengunggah berkas {{size}}. Apakah Anda yakin ingin melanjutkan?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'Kami tidak dapat menghitung ukuran unggahan. Apakah Anda yakin ingin melanjutkan?';
$string['core.fileuploader.discardrecording'] = 'Buang rekaman';
$string['core.fileuploader.errorcapturingaudio'] = 'Galat saat pengambilan audio.';
$string['core.fileuploader.errorcapturingimage'] = 'Galat saat pengambilan gambar.';
$string['core.fileuploader.errorcapturingvideo'] = 'Galat saat pengambilan video.';
$string['core.fileuploader.errorgettingimagealbum'] = 'Galat saat mendapatkan gambar dari album.';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Anda harus daring untuk mengunggah berkas.';
$string['core.fileuploader.errornoapp'] = 'Anda tidak memiliki aplikasi terinstal untuk menjalankannya.';
$string['core.fileuploader.errorreadingfile'] = 'Galat saat memuat berkas.';
$string['core.fileuploader.errorwhileuploading'] = 'Galat saat mengunggah berkas.';
$string['core.fileuploader.file'] = 'Berkas';
$string['core.fileuploader.fileuploaded'] = 'Berkas berhasil diunggah.';
$string['core.fileuploader.maxbytesfile'] = 'Berkas terlalu besar {{$a.file}}. Ukuran maksimal yang dapat diunggah adalah {{$a.size}}.';
$string['core.fileuploader.microphonepermissiondenied'] = 'Izin untuk mengakses mikrofon telah ditolak.';
$string['core.fileuploader.microphonepermissionrestricted'] = 'Akses mikrofon dibatasi.';
$string['core.fileuploader.pauserecording'] = 'Jeda rekaman';
$string['core.fileuploader.photoalbums'] = 'Album foto';
$string['core.fileuploader.readingfile'] = 'Membaca berkas';
$string['core.fileuploader.readingfileperc'] = 'Membaca berkas: {{$a}}%';
$string['core.fileuploader.resumerecording'] = 'Lanjutkan rekaman';
$string['core.fileuploader.selectafile'] = 'Memilih sebuah berkas';
$string['core.fileuploader.startrecordinginstructions'] = 'Ketuk untuk mulai merekam';
$string['core.fileuploader.uploadafile'] = 'Mengunggah berkas';
$string['core.fileuploader.uploading'] = 'Sedang mengunggah';
$string['core.fileuploader.uploadingperc'] = 'Mengunggah: {{$a}}%';
$string['core.fileuploader.video'] = 'Video';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.goto'] = 'Lanjut ke {{$a}}';
$string['core.h5p.errorgetemail'] = 'Galat dalam mendapatkan surel pengguna. Silakan periksa koneksi Anda dan coba lagi.';
$string['core.h5p.offlinedisabled'] = 'Situs tidak mengizinkan mengunduh paket H5P.';
$string['core.h5p.play'] = 'Mainkan H5P';
$string['core.hasdatatosync'] = '{{$a}} ini memiliki data luring yang akan disinkronkan.';
$string['core.howtoobtaincoordinates'] = 'Anda dapat memperoleh koordinat menggunakan aplikasi GPS atau <a href="{{url}}">aplikasi peta</a>.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.iframehelp'] = 'Apakah konten ini tidak berfungsi?';
$string['core.image'] = 'Gambar';
$string['core.imageviewer'] = 'Penampil gambar';
$string['core.ioscookieshelp'] = 'Konten yang disematkan mungkin memerlukan kuki agar berfungsi. Silakan buka setelan aplikasi iOS, aktifkan \'Izinkan Pelacakan Lintas Situs Web\' dan coba lagi.';
$string['core.lastdownloaded'] = 'Terakhir diunduh';
$string['core.lastsync'] = 'Terakhir disinkronisasi';
$string['core.leave'] = 'Tinggalkan';
$string['core.loadmore'] = 'Muat lebih banyak';
$string['core.locationnolongeravailable'] = 'Menemukan lokasi Anda tidak lagi tersedia. {{howToObtain}}';
$string['core.login.authenticating'] = 'Mengautentikasi';
$string['core.login.changepasswordbutton'] = 'Ubah kata sandi';
$string['core.login.changepasswordhelp'] = 'Jika Anda mengalami masalah saat mengubah kata sandi, coba lagi nanti atau hubungi sekolah atau penyedia pembelajaran Anda.';
$string['core.login.changepasswordreconnectinstructions'] = 'Jika Anda tidak mengubah kata sandi dengan benar, Anda akan diminta melakukannya lagi.';
$string['core.login.changepasswordsupportsubject'] = 'Butuh bantuan untuk mengubah kata sandi saya';
$string['core.login.confirmdeletesite'] = 'Apakah Anda yakin ingin menghapus akun pada situs {{sitename}}?';
$string['core.login.connect'] = 'Terhubung!';
$string['core.login.connecttomoodle'] = 'Terhubung ke Moodle';
$string['core.login.connecttomoodleapp'] = 'Anda mencoba terhubung ke situs Moodle biasa. Silakan unduh aplikasi resmi Moodle untuk mengakses situs ini.';
$string['core.login.connecttoworkplaceapp'] = 'Anda mencoba terhubung ke situs Moodle Workplace. Silakan unduh aplikasi Moodle Workplace untuk mengakses situs ini.';
$string['core.login.credentialsdescription'] = 'Silakan masukkan nama pengguna dan kata sandi untuk masuk log';
$string['core.login.credentialshelp'] = 'Jika Anda mengalami masalah saat masuk, coba lagi nanti atau hubungi sekolah atau penyedia pembelajaran Anda.';
$string['core.login.credentialssupportsubject'] = 'Butuh bantuan untuk masuk';
$string['core.login.emailconfirmsentnoemail'] = '<p>Surel seharusnya sudah dikirim ke alamat Anda.</p><p>Berisi petunjuk mudah untuk menyelesaikan pendaftaran Anda.</p>';
$string['core.login.emailnotmatch'] = 'Surel tidak sesuai';
$string['core.login.erroraccesscontrolalloworigin'] = 'Panggilan lintas asal yang Anda coba lakukan telah ditolak. Silakan periksa https://moodledev.io/general/app/development/setup/app-in-browser';
$string['core.login.errordeletesite'] = 'Galat saat menghapus situs. Silakan coba lagi.';
$string['core.login.errorexampleurl'] = 'URL https://campus.example.edu hanyalah URL contoh, bukan situs sebenarnya. <strong>Silakan gunakan URL situs sekolah atau organisasi Anda.</strong>';
$string['core.login.errorqrnoscheme'] = 'URL ini bukan URL log masuk yang valid.';
$string['core.login.errorupdatesite'] = 'Galat saat memperbaharui situs. Silahkan coba lagi.';
$string['core.login.exceededloginattempts'] = 'Butuh bantuan untuk masuk? Coba {{recoverPassword}} atau hubungi bantuan situs Anda.';
$string['core.login.exceededloginattemptsrecoverpassword'] = 'memulihkan kata sandi Anda';
$string['core.login.exceededloginattemptssupportsubject'] = 'Saya tidak bisa masuk';
$string['core.login.exceededloginattemptswithoutpassword'] = 'Butuh bantuan untuk masuk? Coba hubungi bantuan situs Anda.';
$string['core.login.exceededloginattemptswithoutsupport'] = 'Butuh bantuan untuk masuk? Coba {{recoverPassword}}.';
$string['core.login.exceededpasswordresetattempts'] = 'Tampaknya Anda mengalami kesulitan mengakses akun Anda. Anda dapat menghubungi sekolah atau penyedia pembelajaran Anda atau coba lagi nanti.';
$string['core.login.exceededpasswordresetattemptssupportsubject'] = 'Saya tidak dapat mengatur ulang kata sandi saya';
$string['core.login.faqcannotfindmysiteanswer'] = 'Jika Anda mencoba mencari berdasarkan alamat URL dan masih tidak dapat menemukan situs Moodle Anda, silakan menghubungi orang yang mengurus Moodle di sekolah atau organisasi pembelajaran Anda.';
$string['core.login.faqcannotfindmysitequestion'] = 'Saya tidak dapat menemukan situs saya berdasarkan alamat URL.';
$string['core.login.faqcantloginanswer'] = '<p>Setelah Anda terhubung ke situs Moodle, Anda seharusnya dapat masuk dengan nama pengguna dan kata sandi yang biasa Anda gunakan.</p><br><p>Jika Anda lupa nama pengguna atau kata sandi Anda, pilih opsi <strong >Kehilangan kata sandi?</strong>. Jika Anda masih mengalami kesulitan untuk masuk atau tidak melihat opsi untuk mengambil nama pengguna atau kata sandi Anda, silakan hubungi petugas yang mengurus Moodle di sekolah atau organisasi pembelajaran Anda.</p>';
$string['core.login.faqcantloginquestion'] = 'Saya tidak bisa masuk.';
$string['core.login.faqmore'] = 'Lihat <a href="https://docs.moodle.org/en/Moodle_app_FAQ#toc" target="_blank">FAQ kami</a> untuk jawaban lebih lanjut.';
$string['core.login.faqsetupsiteanswer'] = 'Kunjungi {{$link}} untuk melihat berbagai pilihan yang Anda miliki untuk membuat situs Moodle Anda sendiri.';
$string['core.login.faqsetupsitelinktitle'] = 'Memulai.';
$string['core.login.faqsetupsitequestion'] = 'Saya ingin membuat situs Moodle saya sendiri.';
$string['core.login.faqtestappanswer'] = 'Untuk menguji aplikasi di situs demo Moodle, ketik "pengajar" atau "siswa" di kolom <strong>Situs Anda</strong> dan ketuk <strong>Hubungkan ke situs Anda</strong>.';
$string['core.login.faqtestappquestion'] = 'Bisakah saya menguji aplikasi di situs demo?';
$string['core.login.faqwhatisurlanswer'] = '<p>Jika Anda tidak dapat menemukan situs Anda berdasarkan nama, coba cari berdasarkan alamat URL situs Moodle Anda (atau alamat web).</p><p>Untuk menemukan alamat situs Anda:</p><ol>< li>Buka peramban web dan buka halaman login situs Moodle Anda.</li><li>Di bagian atas halaman, pada bilah alamat, Anda akan melihat alamat URL situs Moodle Anda, misalnya. "campus.example.edu".<br>{{$image}}</li><li>Salin URL-nya (jangan salin /login atau yang berikutnya), tempelkan ke <strong>Situs Anda< /strong> di aplikasi, lalu ketuk <strong>Hubungkan ke situs Anda</strong></li><li>Sekarang Anda dapat masuk ke situs Anda dengan nama pengguna dan kata sandi Anda.</li></ol>< p>Jika Anda mencoba mencari berdasarkan alamat URL dan masih tidak dapat menemukan situs Moodle Anda, silakan menghubungi orang yang mengurus Moodle di sekolah atau organisasi pembelajaran Anda.</p>';
$string['core.login.faqwhatisurlquestion'] = 'Bagaimana saya bisa menemukan situs saya?';
$string['core.login.faqwhereisqrcode'] = 'Di mana saya dapat menemukan kode QR?';
$string['core.login.faqwhereisqrcodeanswer'] = '<p>Jika sekolah atau penyedia pembelajaran Anda telah mengaktifkannya, Anda akan menemukan kode QR di situs web di bagian bawah halaman profil pengguna Anda.</p>{{$image}}';
$string['core.login.findyoursite'] = 'Temukan situs Anda';
$string['core.login.invalidaccount'] = 'Silakan periksa detail masuk log Anda dan coba lagi.';
$string['core.login.invalidmoodleversion'] = 'Versi situs Moodle ini terlalu lama. Aplikasi Moodle dapat digunakan pada situs yang menggunakan {{$a}} atau yang lebih baru.';
$string['core.login.invalidsite'] = 'URL situs tidak valid.';
$string['core.login.invalidtime'] = 'Waktu tidak valid.';
$string['core.login.invalidvaluemax'] = 'Maksimum nilai adalah {{$a}}';
$string['core.login.invalidvaluemin'] = 'Minimum nilai adalah {{$a}}';
$string['core.login.loginbutton'] = 'Masuk log';
$string['core.login.mobileservicesnotenabled'] = 'Layanan seluler tidak diaktifkan di situs.';
$string['core.login.morewaystologin'] = 'Lebih banyak cara untuk masuk';
$string['core.login.notloggedin'] = 'Anda butuh masuk log.';
$string['core.login.onboardingcreatemanagecourses'] = 'Buat & kelola kursus Anda';
$string['core.login.onboardingenrolmanagestudents'] = 'Daftarkan & kelola siswa Anda';
$string['core.login.onboardinggetstarted'] = 'Mulai dengan Moodle';
$string['core.login.onboardingialreadyhaveasite'] = 'Saya sudah memiliki situs Moodle';
$string['core.login.onboardingimalearner'] = 'Saya seorang pelajar';
$string['core.login.onboardingimaneducator'] = 'Saya seorang pendidik';
$string['core.login.onboardingineedasite'] = 'Saya butuh situs Moodle';
$string['core.login.onboardingprovidefeedback'] = 'Berikan umpan balik tepat waktu';
$string['core.login.onboardingtoconnect'] = 'Untuk terhubung ke Aplikasi Moodle, Anda memerlukan situs Moodle';
$string['core.login.onboardingwelcome'] = 'Selamat datang di Aplikasi Moodle!';
$string['core.login.or'] = 'Atau';
$string['core.login.passwordrequired'] = 'Kata sandi dibutuhkan';
$string['core.login.policyacceptmandatory'] = 'Saya paham dan setuju dengan kebijakan situs wajib';
$string['core.login.recaptchachallengeimage'] = 'gambar tantangan reCAPTCHA';
$string['core.login.recaptchaexpired'] = 'Verifikasi sudah kedaluwarsa. Jawab pertanyaan keamanan lagi.';
$string['core.login.recaptchaincorrect'] = 'Jawaban pertanyaan keamanan salah.';
$string['core.login.reconnect'] = 'Sambungkan kembali';
$string['core.login.reconnecthelp'] = 'Jika Anda mengalami masalah saat menyambung kembali, coba lagi nanti atau hubungi sekolah atau penyedia pembelajaran Anda.';
$string['core.login.reconnectsupportsubject'] = 'Butuh bantuan untuk menyambung kembali';
$string['core.login.reconnecttosite'] = 'Hubungkan kembali ke situs';
$string['core.login.removeaccount'] = 'Menghapus akun';
$string['core.login.searchby'] = 'Cari berdasarkan:';
$string['core.login.selectsite'] = 'Silakan pilih akun Anda:';
$string['core.login.signupplugindisabled'] = '{{$a}} tidak diaktifkan.';
$string['core.login.signuprequiredfieldnotsupported'] = 'Formulir pendaftaran berisi bidang khusus wajib yang tidak didukung di aplikasi. Silakan buat akun Anda menggunakan browser web.';
$string['core.login.siteaddress'] = 'Situs anda';
$string['core.login.siteaddressplaceholder'] = 'https://campus.example.edu';
$string['core.login.sitebadgedescription'] = 'Ada {{count}} notifikasi yang belum dibaca.';
$string['core.login.sitehasredirect'] = 'Situs Anda berisi setidaknya satu pengalihan HTTP. Aplikasi tidak dapat mengikuti pengalihan, ini mungkin masalah yang mencegah aplikasi terhubung ke situs Anda.';
$string['core.login.siteinmaintenance'] = 'Situs Anda sedang dalam mode perbaikan';
$string['core.login.sitenotallowed'] = 'Situs ini tidak lagi tersedia.';
$string['core.login.sitepolicynotagreederror'] = 'Kebijakan situs tidak disetujui.';
$string['core.login.siteurl'] = 'URL situs';
$string['core.login.siteurlrequired'] = 'URL situs diperlukan, misalnya <i>https://campus.example.edu</i>';
$string['core.login.stillcantconnect'] = 'Masih belum dapat terhubung?';
$string['core.login.toggleremove'] = 'Edit daftar akun';
$string['core.login.unsupportedsite'] = 'Situs tidak dapat diakses melalui aplikasi';
$string['core.login.unsupportedsitemessage'] = '{{site}} tidak dapat diakses melalui aplikasi ini.<br><br>Anda masih dapat mengaksesnya menggunakan peramban web.';
$string['core.login.usernamerequired'] = 'Nama pengguna dibutuhkan';
$string['core.login.visitchangepassword'] = 'Apakah Anda ingin mengunjungi situs untuk mengganti kata sandi?';
$string['core.login.webservicesnotenabled'] = 'Layanan web tidak diaktifkan di situs.';
$string['core.login.youcanstillconnectwithcredentials'] = 'Anda masih dapat terhubung ke situs dengan memasukkan nama pengguna dan kata sandi Anda.';
$string['core.login.yourenteredsite'] = 'Hubungkan ke situs Anda';
$string['core.lostconnection'] = 'Sesi Anda telah berakhir. Silakan masuk lagi untuk melanjutkan.';
$string['core.mainmenu.switchaccount'] = 'Ganti akun';
$string['core.mainmenu.usermenutourdescription'] = 'Tempat untuk memeriksa nilai Anda, mengubah preferensi Anda atau berpindah akun.';
$string['core.mainmenu.usermenutourtitle'] = 'Jelajahi area pribadi Anda';
$string['core.needhelp'] = 'Butuh bantuan?';
$string['core.needinternettoaccessit'] = 'Anda perlu terhubung ke internet untuk mengaksesnya.';
$string['core.networkerroriframemsg'] = 'Konten ini tidak tersedia secara luring. Silakan sambungkan ke internet dan coba lagi.';
$string['core.networkerrormsg'] = 'Terdapat masalah untuk terhubung ke situs. Silahkan periksa koneksi Anda dan coba lagi.';
$string['core.nooptionavailable'] = 'Tidak ada opsi yang tersedia';
$string['core.nopasswordchangeforced'] = 'Anda tidak dapat memproses tanpa mengganti kata sandi.';
$string['core.nopermissionerror'] = 'Maaf, namun saat ini Anda tidak memiliki izin untuk melakukannya';
$string['core.notapplicable'] = 'n/a';
$string['core.notavailablecontentinapp'] = 'Konten ini tidak tersedia di aplikasi, tetapi Anda dapat membukanya di peramban web menggunakan tombol berikut.';
$string['core.notavailableoffline'] = 'Konten ini tidak tersedia secara luring. Harap sambungkan ke internet dan coba lagi.';
$string['core.notdownloadable'] = 'Tidak dapat diunduh';
$string['core.notnow'] = 'Tidak sekarang';
$string['core.notsent'] = 'Tidak terkirim';
$string['core.nummore'] = '{{$a}} lagi';
$string['core.openfile'] = 'Buka berkas';
$string['core.openfilewithextension'] = 'Buka berkas {{extension}}';
$string['core.openfullimage'] = 'Klik di sini untuk melihat gambar dengan ukuran penuh';
$string['core.openinbrowser'] = 'Buka di peramban';
$string['core.openinbrowserdescription'] = 'Anda akan dibawa ke browser web';
$string['core.openmodinbrowser'] = 'Buka {{$a}} di peramban';
$string['core.opensecurityquestion'] = 'Buka pertanyaan keamanan';
$string['core.opensettings'] = 'Buka Setelan';
$string['core.openwith'] = 'Buka dengan...';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.play'] = 'Mainkan';
$string['core.policy.havereadandagreepolicy'] = 'Saya telah membaca dan menyetujui {{policyname}}';
$string['core.policy.nopoliciesyet'] = 'Belum ada kebijakan dan kesepakatan.';
$string['core.policy.policyacceptmandatory'] = 'Saya memahami dan menyetujui kebijakan situs wajib';
$string['core.policy.sitepolicynotagreederror'] = 'Kebijakan situs tidak disetujui.';
$string['core.policy.viewpolicy'] = 'Lihat kebijakan {{policyname}}.';
$string['core.pulltorefresh'] = 'Tarik untuk muat ulang';
$string['core.qrscanner'] = 'Pemindai QR';
$string['core.question.cannotdeterminestatus'] = 'Tidak dapat menentukan status';
$string['core.question.errorattachmentsnotsupportedinsite'] = 'Situs Anda belum mendukung melampirkan berkas ke jawaban.';
$string['core.question.errorembeddedfilesnotsupportedinsite'] = 'Situs Anda belum mendukung pengeditan berkas tersemat.';
$string['core.question.errorquestionnotsupported'] = 'Tipe soal ini tidak didukung oleh aplikasi: {{$a}}.';
$string['core.question.howtodraganddrop'] = 'Ketuk untuk memilih lalu ketuk untuk melepas.';
$string['core.question.questionmessage'] = 'Soal {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'Anda akan diarahkan ke situs.';
$string['core.reminders.atthetime'] = 'Pada saat acara';
$string['core.reminders.custom'] = 'Kustom...';
$string['core.reminders.customreminder'] = 'Pengingat kustom';
$string['core.reminders.delete'] = 'Hapus pengingat';
$string['core.reminders.reminderset'] = 'Pengingat disetel untuk {{$a}}';
$string['core.reminders.reminderunset'] = 'Pengingat dihapus';
$string['core.reminders.setareminder'] = 'Setel pengingat';
$string['core.reminders.setareminderfor'] = 'Setel pengingat untuk "{{title}}" ({{label}})';
$string['core.reminders.setreminder'] = 'Setel pengingat';
$string['core.reminders.timebefore'] = '{{value}} {{units}} sebelumnya';
$string['core.reminders.value'] = 'Nilai';
$string['core.removedownloadeddata'] = 'Hapus data yang diunduh';
$string['core.removefiles'] = 'Hapus berkas {{$a}}';
$string['core.reportbuilder.filtersapplied'] = 'Mungkin ada filter yang diterapkan pada tampilan ini. Untuk mengedit filter atau mengubah urutan pengurutan, <a href="{{$a}}">buka laporan ini di browser Anda.</a>';
$string['core.reportbuilder.hidecolumns'] = 'Sembunyikan kolom';
$string['core.reportbuilder.showcolumns'] = 'Tampilkan kolom';
$string['core.requireduserdatamissing'] = 'Pengguna ini tidak memiliki beberapa data profil yang dibutuhkan. Harap masukkan data di situs Anda dan coba lagi.<br>{{$a}}';
$string['core.resume'] = 'Lanjutkan';
$string['core.retry'] = 'Coba lagi';
$string['core.scanqr'] = 'Pindai kode QR';
$string['core.scrollbackward'] = 'Gulir ke belakang';
$string['core.scrollforward'] = 'Gulir ke depan';
$string['core.search.allcategories'] = 'Semua Kategori';
$string['core.search.empty'] = 'Apa yang Anda cari?';
$string['core.search.filtercategories'] = 'Filter hasil berdasarkan';
$string['core.search.filtercourses'] = 'Cari di';
$string['core.search.noresults'] = 'Tidak ada hasil untuk "{{$a}}"';
$string['core.search.noresultshelp'] = 'Periksa kesalahan ketik atau coba gunakan kata kunci lain';
$string['core.search.resultby'] = 'Oleh {{$a}}';
$string['core.searching'] = 'Mencari';
$string['core.serverconnection'] = 'Kesalahan saat menyambung ke server: {{details}}';
$string['core.settings.about'] = 'Tentang';
$string['core.settings.appsettings'] = 'Setelan aplikasi';
$string['core.settings.appversion'] = 'Versi aplikasi';
$string['core.settings.cannotsyncloggedout'] = 'Situs ini tidak dapat disinkronkan karena Anda telah keluar. Silakan coba lagi saat Anda masuk kembali ke situs.';
$string['core.settings.cannotsyncoffline'] = 'Sinkronisasi situs gagal karena perangkat Anda tidak terhubung ke internet.';
$string['core.settings.cannotsyncwithoutwifi'] = 'Perangkat Anda tidak terhubung ke Wi-Fi. Hubungkan ke jaringan Wi-Fi atau matikan Penghemat Data di setelan aplikasi.';
$string['core.settings.changelanguage'] = 'Ubah menjadi {{$a}}';
$string['core.settings.changelanguagealert'] = 'Mengubah bahasa akan memulai ulang aplikasi.';
$string['core.settings.colorscheme'] = 'Skema warna';
$string['core.settings.colorscheme-dark'] = 'Gelap';
$string['core.settings.colorscheme-light'] = 'Terang';
$string['core.settings.colorscheme-system'] = 'Bawaan sistem';
$string['core.settings.colorscheme-system-notice'] = 'Mode bawaan sistem akan bergantung pada dukungan perangkat Anda.';
$string['core.settings.compilationinfo'] = 'Info kompilasi';
$string['core.settings.connecttosync'] = 'Perangkat Anda sedang luring. Hubungkan ke internet untuk menyinkronkan situs.';
$string['core.settings.connectwifitosync'] = 'Hubungkan ke jaringan Wi-Fi atau matikan Penghemat data untuk menyinkronkan situs.';
$string['core.settings.copyinfo'] = 'Salin info perangkat di papan klip';
$string['core.settings.cordovadevicemodel'] = 'Model perangkat Cordova';
$string['core.settings.cordovadeviceosversion'] = 'Versi OS perangkat Cordova';
$string['core.settings.cordovadeviceplatform'] = 'Platform perangkat Cordova';
$string['core.settings.cordovadeviceuuid'] = 'UUID perangkat Cordova';
$string['core.settings.cordovaversion'] = 'Versi Cordova';
$string['core.settings.debugdisplaydescription'] = 'Jika diaktifkan, modal kesalahan akan menampilkan lebih banyak data tentang kesalahan jika memungkinkan.';
$string['core.settings.developeroptions'] = 'Opsi pengembang';
$string['core.settings.deviceinfo'] = 'Info Perangkat';
$string['core.settings.deviceos'] = 'Sistem Operasi Perangkat';
$string['core.settings.displayformat'] = 'Tampilkan format';
$string['core.settings.enableanalytics'] = 'Aktifkan analitik';
$string['core.settings.enableanalyticsdescription'] = 'Jika diaktifkan, aplikasi akan mengumpulkan penggunaan data anonim.';
$string['core.settings.enabledownloadsection'] = 'Aktifkan unduh bagian';
$string['core.settings.enablepinchtozoom'] = 'Aktifkan cubit untuk memperbesar';
$string['core.settings.enablerichtexteditor'] = 'Aktifkan rich text editor';
$string['core.settings.enablerichtexteditordescription'] = 'Jika diaktifkan, rich text editor akan ditampilkan di tempat yang memungkinkan.';
$string['core.settings.encryptedpushsupported'] = 'Notifikasi push terenkripsi didukung';
$string['core.settings.entriesincache'] = '{{$a}} entri dalam singgahan';
$string['core.settings.estimatedfreespace'] = 'Perkiraan ruang kosong';
$string['core.settings.filesystemroot'] = 'Root sistem berkas';
$string['core.settings.fontsize'] = 'Ukuran teks';
$string['core.settings.forcedsetting'] = 'Setelan ini telah dipaksakan oleh konfigurasi situs Anda.';
$string['core.settings.helpusimprove'] = 'Bantu kami meningkatkan aplikasi ini';
$string['core.settings.ioscookies'] = 'Pelacakan Lintas Situs Web';
$string['core.settings.ioscookiesdescription'] = 'Konten yang tersemat dari situs mungkin memerlukan cookie lintas situs agar dapat berfungsi. Untuk mengaktifkannya, buka pengaturan iOS aplikasi dan aktifkan \'Izinkan Pelacakan Lintas Situs Web\'.';
$string['core.settings.legaldisclaimer'] = 'Penafian hukum';
$string['core.settings.localnotifavailable'] = 'Pemberitahuan lokal tersedia';
$string['core.settings.locationhref'] = 'URL Webview';
$string['core.settings.logintosync'] = 'Masuk untuk menyinkronkan';
$string['core.settings.navigatorlanguage'] = 'Bahasa navigasi';
$string['core.settings.navigatoruseragent'] = 'Agen pengguna navigasi';
$string['core.settings.networkstatus'] = 'Status koneksi internet';
$string['core.settings.opensourcelicenses'] = 'Lisensi Sumber Terbuka';
$string['core.settings.privacypolicy'] = 'Kebijakan privasi';
$string['core.settings.publisher'] = 'Penerbit';
$string['core.settings.pushid'] = 'ID pemberitahuan push';
$string['core.settings.reportinbackground'] = 'Laporkan kesalahan secara otomatis';
$string['core.settings.screen'] = 'Informasi layar';
$string['core.settings.showdownloadoptions'] = 'Tunjukkan opsi unduh';
$string['core.settings.siteinfo'] = 'Info situs';
$string['core.settings.sitesynccompleted'] = 'Sinkronisasi situs selesai.';
$string['core.settings.sitesyncfailed'] = 'Sinkronisasi situs gagal';
$string['core.settings.spaceusage'] = 'Penggunaan ruang';
$string['core.settings.syncdatasaver'] = 'Penghemat data: Sinkronisasi hanya saat menggunakan Wi-Fi';
$string['core.settings.synchronization'] = 'Sinkronisasi';
$string['core.settings.synchronizenow'] = 'Sinkronisasi sekarang';
$string['core.settings.synchronizenowhelp'] = 'Menyinkronkan sebuah situs akan mengirimkan perubahan yang tertunda dan semua aktivitas luring yang tersimpan di perangkat dan akan menyinkronkan beberapa data seperti pesan dan pemberitahuan.';
$string['core.settings.syncsettings'] = 'Setelan sinkronisasi';
$string['core.settings.wificonnection'] = 'Koneksi Wifi';
$string['core.settings.youradev'] = 'Anda sekarang adalah seorang pengembang';
$string['core.sharedfiles.chooseaccountstorefile'] = 'Pilih akun untuk menyimpan berkas di dalamnya';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'Berkas dengan nama ini sudah ada. Apakah Anda ingin mengganti berkas yang ada atau mengganti namanya menjadi "{{$a}}"?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'Tidak ada situs yang disimpan. Silakan tambahkan situs sebelum berbagi berkas dengan aplikasi.';
$string['core.sharedfiles.nosharedfiles'] = 'Tidak ada berkas bersama yang disimpan di situs ini.';
$string['core.sharedfiles.nosharedfilestoupload'] = 'Anda tidak memiliki berkas untuk diunggah di sini. Jika Anda ingin mengunggah berkas dari aplikasi lain, cari berkas tersebut dan klik tombol \'Buka di\'.';
$string['core.sharedfiles.rename'] = 'Ganti Nama';
$string['core.sharedfiles.replace'] = 'Ganti';
$string['core.sharedfiles.sharedfiles'] = 'Berkas bersama';
$string['core.sharedfiles.successstorefile'] = 'Berkas berhasil disimpan. Pilih berkas untuk diunggah ke berkas pribadi Anda atau digunakan dalam aktivitas.';
$string['core.sitenotfoundhelp'] = 'Kami tidak dapat menemukan situs yang Anda masukkan. Silakan periksa kesalahan ketik atau coba lagi nanti. Jika Anda terus melihat pesan ini, hubungi sekolah atau penyedia pembelajaran Anda.';
$string['core.siteunavailablehelp'] = 'Situs "{{site}}" tidak tersedia saat ini. Silakan coba lagi nanti atau hubungi sekolah atau penyedia pembelajaran Anda.';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = 'Maaf...';
$string['core.start'] = 'Mulai';
$string['core.startingtime'] = 'Waktu mulai: {{$a}}';
$string['core.storingfiles'] = 'Menyimpan berkas';
$string['core.submittedoffline'] = 'Dikirim (Luring)';
$string['core.swipenavigationtourdescription'] = 'Gesek ke kiri dan kanan untuk bernavigasi.';
$string['core.tablet'] = 'Tablet';
$string['core.tag.errorareanotsupported'] = 'Area tag ini tidak didukung aplikasi.';
$string['core.tag.tagareabadgedescription'] = 'Ada {{count}} item.';
$string['core.tag.warningareasnotsupported'] = 'Beberapa area tag tidak ditampilkan karena tidak didukung oleh aplikasi.';
$string['core.thereisdatatosync'] = 'Terdapat  {{$a}} luring yang akan disinkronkan.';
$string['core.toggledelete'] = 'Tuas tombol hapus';
$string['core.tryagain'] = 'Coba lagi';
$string['core.turnon'] = 'Nyalakan';
$string['core.turnonexactalarms'] = 'Aktifkan peringatan waktu nyata';
$string['core.turnonnotifications'] = 'Nyalakan notifikasi';
$string['core.turnonnotificationsmessage'] = 'Apakah Anda ingin menerima pemberitahuan tentang aktivitas dan tugas?';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'Uh oh!';
$string['core.unexpectederror'] = 'Terjadi kesalahan tak terduga. Harap tutup dan buka kembali aplikasi, lalu coba lagi.';
$string['core.unicodenotsupported'] = 'Beberapa emoji tidak didukung di situs ini. Karakter tersebut akan dihapus saat pesan dikirim.';
$string['core.unicodenotsupportedcleanerror'] = 'Teks kosong ditemukan saat membersihkan karakter Unicode.';
$string['core.unknown'] = 'Tidak diketahui';
$string['core.unzipping'] = 'Mengurai zip';
$string['core.updaterequired'] = 'Diperlukan pembaruan aplikasi';
$string['core.updaterequireddesc'] = 'Harap perbarui aplikasi Anda ke versi {{$a}}';
$string['core.user.completeprofile'] = 'Lengkapi profil';
$string['core.user.completeprofilehelp'] = 'Jika Anda mengalami masalah dalam melengkapi profil Anda, coba lagi nanti atau hubungi sekolah atau penyedia pembelajaran Anda.';
$string['core.user.completeprofilenotice'] = 'Sebelum Anda melanjutkan, harap isi kolom yang wajib diisi di profil pengguna Anda.';
$string['core.user.completeprofilereconnectinstructions'] = 'Jika Anda tidak melengkapi profil Anda dengan benar, Anda akan diminta untuk melakukannya lagi.';
$string['core.user.completeprofilesupportsubject'] = 'Butuh bantuan untuk melengkapi profil saya';
$string['core.user.completeyourprofile'] = 'Lengkapi profil Anda';
$string['core.user.contact'] = 'Kontak';
$string['core.user.detailsnotavailable'] = 'Rincian pengguna ini tidak tersedia untuk Anda.';
$string['core.user.errorloaduser'] = 'Galan saat memuat pengguna.';
$string['core.user.sendemail'] = 'Surel';
$string['core.user.support'] = 'Hubungi bantuan situs';
$string['core.user.supportsubject'] = '[App] {{subject}}';
$string['core.user.userwithid'] = 'Pengguna dengan ID {{id}}';
$string['core.usernologin'] = 'Otentikasi telah dicabut untuk akun ini';
$string['core.viewcode'] = 'Tampilkan kode';
$string['core.vieweditor'] = 'Tampilkan editor';
$string['core.viewembeddedcontent'] = 'Lihat konten yang disematkan';
$string['core.viewer.decreasetextsize'] = 'Susutkan ukuran teks';
$string['core.viewer.enterreadingmode'] = 'Masuk ke mode membaca';
$string['core.viewer.exitreadingmode'] = 'Keluar dari mode membaca';
$string['core.viewer.increasetextsize'] = 'Tingkatkan ukuran teks';
$string['core.viewer.openreadingmodesettings'] = 'Buka pengaturan mode membaca';
$string['core.viewer.readingthemeauto'] = 'Aplikasi cocok';
$string['core.viewer.readingthemedark'] = 'Gelap';
$string['core.viewer.readingthemehcm'] = 'Kontras tinggi';
$string['core.viewer.readingthemelight'] = 'Terang';
$string['core.viewer.readingthemesepia'] = 'Sepia';
$string['core.wanttochangesite'] = 'Ingin mengubah situs atau keluar?';
$string['core.warningofflinedatadeleted'] = 'Perubahan luring pada {{component}} \'{{name}}\' telah dibuang. {{kesalahan}}';
$string['core.warningofflinedatadeletedreason'] = 'Perubahan terbaru pada aktivitas ini telah dilakukan dari perangkat lain.';
$string['core.warnopeninbrowser'] = '<p>Anda akan keluar dari aplikasi untuk membuka URL berikut di peramban perangkat Anda. Apakah Anda ingin melanjutkan?</p>
<p><b>{{url}}</b></p>';
$string['core.whyisthishappening'] = 'Kenapa ini terjadi?';
$string['core.wsfunctionnotavailable'] = 'Fungsi layanan web ini tidak tersedia.';
$string['core.youreoffline'] = 'Perangkat Anda sedang luring';
$string['core.youreonline'] = 'Perangkat Anda kembali daring';
$string['core.zoomin'] = 'Perbesar';
$string['core.zoomout'] = 'Perkecil';
$string['freemium.biometriclogin'] = 'Masuk log biometrik';
$string['freemium.biometriclogindescription'] = 'Letakkan jari Anda di pembaca sidik jari.';
$string['freemium.biometricloginenablefaceid'] = 'Aktifkan FaceID';
$string['freemium.biometricloginenablefingerprint'] = 'Aktifkan Sidik jari';
$string['freemium.biometricloginenabletouchid'] = 'Aktifkan TouchID';
$string['freemium.biometricloginloginwithfaceid'] = 'Masuk log dengan FaceID';
$string['freemium.biometricloginloginwithfingerprint'] = 'Masuk log dengan Sidik jari';
$string['freemium.biometricloginloginwithtouchid'] = 'Masuk log dengan TouchID';
$string['freemium.biometricloginskip'] = 'Lewati untuk saat ini';
$string['freemium.biometricloginsuccessfullyenabled'] = '{{ biometricMethod }} diaktifkan.';
$string['freemium.biometricloginturnoff'] = 'Anda dapat mengaktifkan dan menonaktifkan fitur ini kapan saja melalui setelan.';
$string['freemium.biometriclogintypefaceid'] = 'ID Wajah';
$string['freemium.biometriclogintypefingerprint'] = 'Sidik jari';
$string['freemium.biometriclogintypetouchid'] = 'ID Sentuh';
$string['freemium.biometricloginwithfingerorface'] = 'Gunakan masuk log biometrik dengan sidik jari atau wajah Anda.';
$string['freemium.change'] = 'Ubah';
$string['freemium.coursesbatchdownloaddisabled'] = 'Mengunduh kursus secara masal tidak aktif untuk situs ini.';
$string['freemium.coursesdownloadlimitreached'] = 'Batas pengunduhan kursus telah tercapai! Anda hanya dapat mengunduh {{limit}} kursus, hubungi administrator Anda untuk meningkatkan batas ini atau menghapus beberapa kursus yang diunduh dari perangkat Anda.';
$string['freemium.downloadmainapplicationrequired'] = 'Anda hanya dapat terhubung ke situs ini menggunakan aplikasi khusus.';
$string['freemium.downloadmainapplicationsuggestion'] = 'Situs yang Anda coba sambungkan memiliki aplikasi khusus yang mungkin ingin Anda coba.';
$string['freemium.feature_biometriclogin'] = 'Masuk dengan biometrik';
$string['freemium.feature_coursesdownload'] = 'Kursus yang diunduh';
$string['freemium.feature_multimediapushnotifications'] = 'Pemberitahuan push multimedia';
$string['freemium.feature_pushnotificationsdevices'] = 'Pemberitahuan push perangkat';
$string['freemium.feature_qrlogin'] = 'Autentikasi menggunakan kode QR';
$string['freemium.feature_remotethemes'] = 'Tema jarak jauh';
$string['freemium.feature_sitelogo'] = 'Logo situs';
$string['freemium.notallowed'] = 'Tidak diperbolehkan';
$string['freemium.nottoday'] = 'Tidak hari ini';
$string['freemium.qrlogindisabled'] = 'Autentikasi dalam aplikasi menggunakan kode QR tidak diaktifkan untuk situs:<br><br>{{url}}';
$string['freemium.qrloginexpiredkey'] = 'Kode QR telah kedaluwarsa. Harap segarkan halaman dengan kode QR dan pindai lagi.';
$string['freemium.qrloginipmismatch'] = 'Perangkat yang Anda gunakan untuk menyambung tampaknya tidak berada dalam jaringan yang sama dengan perangkat yang menampilkan kode QR. Pastikan kedua perangkat terhubung ke jaringan yang sama (misalnya jaringan WiFi yang sama).<br><br>Jika kesalahan terus berlanjut, hubungi administrator situs Anda.';
$string['freemium.ratetheapp'] = 'Apakah Anda menikmati aplikasi kami?';
$string['freemium.ratetheapp_feedbackko'] = 'Beritahu kami apa yang salah';
$string['freemium.ratetheapp_feedbackmessage'] = 'Masukan Anda akan bersifat anonim';
$string['freemium.ratetheapp_feedbackok'] = 'Kirim masukan';
$string['freemium.ratetheapp_feedbackplaceholder'] = 'Tulis sesuatu di sini';
$string['freemium.ratetheapp_feedbacksent'] = 'Terima kasih! Tanggapan Anda berhasil dikirim.';
$string['freemium.ratetheapp_sendtostore'] = 'Bisakah Anda meluangkan waktu sejenak untuk menilai aplikasi kami? Ini akan membantu kami meningkatkan aplikasi.';
$string['freemium.remindmelater'] = 'Ingatkan saya nanti';
$string['freemium.settingsoptionsfacial'] = 'Aktifkan login wajah';
$string['freemium.settingsoptionsfingerprint'] = 'Aktifkan masuk log sidik jari';
$string['freemium.subscription'] = 'Berlangganan situs';
$string['freemium.subscriptiondetails'] = 'Detail langganan';
$string['freemium.subscriptionfeature_exceeded_customlanguagestrings'] = '{{ overflowCount }} string bahasa kustom diabaikan';
$string['freemium.subscriptionfeature_exceeded_custommenuitems'] = '{{ overflowCount }} item menu kustom diabaikan';
$string['freemium.subscriptionfeature_exceeded_disabledfeatures'] = '{{ overflowCount }} fitur yang dinonaktifkan yang dikonfigurasi masih diaktifkan';
$string['freemium.subscriptionfeature_exceeded_remotethemes'] = 'Tema kustom Anda tidak diterapkan';
$string['freemium.subscriptionfeature_exceeded_sitelogo'] = 'Logo situs Anda tidak diterapkan';
$string['freemium.subscriptionfeature_limited'] = 'Terbatas pada {{ limit }}';
$string['freemium.subscriptionfeature_unlimited'] = 'Tak terbatas';
$string['freemium.subscriptionplan'] = 'Paket berlangganan';
$string['freemium.subscriptionplan_expired'] = 'kedaluwarsa';
$string['freemium.subscriptionplan_free'] = 'Gratis';
$string['freemium.subscriptionplan_upgrade'] = 'Tingkatkan paket Anda';
$string['freemium.subscriptionplan_validuntil'] = 'berlaku sampai tanggal {{ date }}';
$string['freemium.subscriptionplandescription'] = 'Paket berlangganan menunjukkan batasan mana yang berlaku untuk situs ini.';
$string['freemium.subscriptionplanlearnmore'] = 'Pelajari lebih lanjut';
$string['freemium.upsell_renewexpired'] = 'Langganan Anda telah kedaluwarsa';
$string['freemium.upsell_renewexpiring'] = 'Langganan Anda akan berakhir dalam {{ days }} hari';
$string['freemium.upsell_renewtitle'] = 'Perbarui langganan Anda';
$string['freemium.upsell_upgradefreeaccept'] = 'Tingkatkan';
$string['freemium.upsell_upgradefreemessage'] = 'Saat ini Anda menggunakan paket gratis, tingkatkan untuk membuka lebih banyak fitur.';
$string['freemium.upsell_upgradefreepostpone'] = 'Nanti';
$string['freemium.upsell_upgradefreetitle'] = 'Tingkatkan paket Anda';
$string['pluginname'] = 'String bahasa Aplikasi Moodle';
$string['privacy_metadata'] = 'Pengaya ini tidak menyimpan data pengguna apa pun.';
$string['workplace.teams.isoverdue'] = 'Memiliki item yang telah lewat waktu atau kedaluwarsa';
