<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'h5plib_v124', language 'zh_cn', version '4.4'.
 *
 * @package     h5plib_v124
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['editor:add'] = '添加';
$string['editor:addauthor'] = '保存作者';
$string['editor:addentity'] = '添加:实体';
$string['editor:addfile'] = '添加文件';
$string['editor:addnewchange'] = '添加新变化';
$string['editor:addtitle'] = '添加标题';
$string['editor:addvideodescription'] = 'H5P支持mp4、webm或ogv格式的所有外部视频源，如Vimeo Pro，并支持YouTube链接。';
$string['editor:atoz'] = 'A 到 Z';
$string['editor:avtablistlabel'] = '插入使用';
$string['editor:belowmin'] = ':property值小于:min。';
$string['editor:cancel'] = '取消';
$string['editor:cancellabel'] = '取消';
$string['editor:changefile'] = '更改文件';
$string['editor:changelanguage'] = '将语言改为:language?';
$string['editor:changelibrary'] = '更改内容类型?';
$string['editor:changelogdescription'] = '一些许可证要求记录和显示对原始作品或衍生作品所做的更改。出于许可的原因，您可以在此记录您的更改，或者只是为了允许您自己和其他人跟踪对本内容的更改。';
$string['editor:close'] = '关闭';
$string['editor:commonfields'] = '文本覆盖和翻译';
$string['editor:commonfieldsdescription'] = '您可以在这里编辑设置或翻译此内容中使用的文本。';
$string['editor:confirmchangelibrary'] = '通过这样做，您将丢失使用当前内容类型完成的所有工作。您确定要更改内容类型吗?';
$string['editor:confirmdeletechangelog'] = '您确定要删除此更改日志条目吗?';
$string['editor:confirmimageremoval'] = '这将删除您的图像。您确定要继续吗?';
$string['editor:confirmpastebuttontext'] = '替换内容';
$string['editor:confirmpastecontent'] = '通过这样做，您将用剪贴板中的内容替换当前内容。当前内容将丢失。您确定要继续吗?';
$string['editor:confirmremoval'] = '您确定要删除这个:type吗?';
$string['editor:confirmremoveauthor'] = '您确定要删除该作者吗?';
$string['editor:contenttypebackbuttonlabel'] = '返回';
$string['editor:contenttypecacheoutdated'] = '过时的内容类型列表';
$string['editor:contenttypecacheoutdateddesc'] = '您的站点在连接到H5P.org检查内容类型更新时遇到困难。您可能无法更新或安装新的内容类型。';
$string['editor:contenttypedemobuttonlabel'] = '内容演示';
$string['editor:contenttypedetailbuttonlabel'] = '详情';
$string['editor:contenttypegetbuttonlabel'] = '获取';
$string['editor:contenttypeiconalttext'] = '图标';
$string['editor:contenttypeinstallbuttonlabel'] = '安装';
$string['editor:contenttypeinstallerror'] = '无法安装:contentType。请联系您的系统管理员。';
$string['editor:contenttypeinstallingbuttonlabel'] = '安装中';
$string['editor:contenttypeinstallsuccess'] = ':contentType 安装成功！';
$string['editor:contenttypelicensepaneltitle'] = '许可证';
$string['editor:contenttypenotinstalled'] = '内容类型未安装';
$string['editor:contenttypenotinstalleddesc'] = '您没有安装内容类型的权限。';
$string['editor:contenttypeowner'] = '由 :owner';
$string['editor:contenttyperestricted'] = '受限制的内容类型';
$string['editor:contenttyperestricteddesc'] = '此内容类型的使用已被管理员限制。';
$string['editor:contenttypesearchfieldplaceholder'] = '搜索内容类型';
$string['editor:contenttypesectionall'] = '所有内容类型';
$string['editor:contenttypeunsupportedapiversioncontent'] = '联系您的系统管理员，向您提供必要的更新';
$string['editor:contenttypeunsupportedapiversiontitle'] = '此内容类型需要更新的核心版本';
$string['editor:contenttypeupdateavailable'] = '可更新';
$string['editor:contenttypeupdatebuttonlabel'] = '更新';
$string['editor:contenttypeupdatesuccess'] = ':contentType更新成功！';
$string['editor:contenttypeupdatingbuttonlabel'] = '更新中';
$string['editor:contenttypeusebuttonlabel'] = '使用';
$string['editor:contributetranslations'] = '如果您想完成:language的翻译，请参见<a href=":url" target="_new"> 对H5P的翻译</a>。';
$string['editor:copiedbutton'] = '已复制';
$string['editor:copiedtoclipboard'] = '将内容复制到剪贴板';
$string['editor:copybutton'] = '复制';
$string['editor:copytoclipboard'] = '将H5P内容复制到剪贴板';
$string['editor:createcontenttablabel'] = '创建内容';
$string['editor:currentmenuselected'] = '当前选择';
$string['editor:editcopyright'] = '编辑版权';
$string['editor:editimage'] = '编辑图片';
$string['editor:editmode'] = '编辑模式';
$string['editor:enteraudiotitle'] = '粘贴链接或其他音频源URL';
$string['editor:enteraudiourl'] = '输入音频源URL';
$string['editor:enterfullscreenbuttonlabel'] = '进入全屏';
$string['editor:entervideotitle'] = '粘贴YouTube链接或其他视频源URL';
$string['editor:entervideourl'] = '输入视频源URL或YouTube链接';
$string['editor:errorcalculatingmaxscore'] = '无法计算此内容的最大得分。假设最大得分为0。如果不正确，请与管理员联系。';
$string['editor:errorcommunicatinghubcontent'] = '发生一个错误。请再试一次。';
$string['editor:errorcommunicatinghubtitle'] = '无法与集线器(hub)通信。';
$string['editor:errorheader'] = '发生一个错误';
$string['editor:errornotsupported'] = '参数包含不支持的%used。';
$string['editor:errorparamsbroken'] = '参数都损坏了。';
$string['editor:errortoohighversion'] = '参数包含%used，而只支持%supported或更早的。';
$string['editor:example'] = '例子';
$string['editor:exceedsmax'] = ':property值超过:max的最大值。';
$string['editor:exitfullscreenbuttonlabel'] = '退出全屏';
$string['editor:expandcollapse'] = '展开/折叠';
$string['editor:filetolarge'] = '您试图上传的文件可能太大。';
$string['editor:fillinthefieldsbelow'] = '填写下面的字段';
$string['editor:gethelp'] = '获取帮助';
$string['editor:h5pfileuploadservererrorcontent'] = '发生了意外错误。查看服务器错误日志以了解更多细节。';
$string['editor:h5pfileuploadservererrortitle'] = '无法上传H5P文件';
$string['editor:h5pfilevalidationfailedcontent'] = '确保上传的H5P包含有效的H5P内容。只包含库的H5P文件应该通过H5P库页面上传。';
$string['editor:h5pfilevalidationfailedtitle'] = '无法验证H5P文件。';
$string['editor:h5pfilewrongextensioncontent'] = '只允许扩展名为.h5p的文件。';
$string['editor:h5pfilewrongextensiontitle'] = '所选文件无法上传';
$string['editor:height'] = '高';
$string['editor:hide'] = '隐藏';
$string['editor:hideimportantinstructions'] = '隐藏重要说明';
$string['editor:hubpanellabel'] = '选择内容类型';
$string['editor:illegaldecimalnumber'] = ':property只能包含带有最大:decimals小数的数字。';
$string['editor:imagelightboxprogress'] = ':total 的:num';
$string['editor:imagelightboxtitle'] = '图片';
$string['editor:importantinstructions'] = '重要说明';
$string['editor:insert'] = '插入';
$string['editor:invalidformat'] = '字段值包含无效格式或被禁止的字符。';
$string['editor:language'] = '语言';
$string['editor:librarymissing'] = '缺少必需的库%lib。';
$string['editor:licensecandistribute'] = '可以分配';
$string['editor:licensecanholdliable'] = '能承担责任';
$string['editor:licensecanmodify'] = '可修改';
$string['editor:licensecannotholdliable'] = '不能承担责任';
$string['editor:licensecansublicense'] = '可以副许可证';
$string['editor:licensecanusecommercially'] = '可以商业使用';
$string['editor:licensedescription'] = '本许可证的部分特色如下。点击上面的信息图标阅读原始许可证文本。';
$string['editor:licensefetchdetailsfailed'] = '获取许可证详情失败';
$string['editor:licensemodalsubtitle'] = '选择许可证以查看有关正确使用的信息';
$string['editor:licensemodaltitle'] = '许可证详情';
$string['editor:licensemustincludecopyright'] = '必须包括版权';
$string['editor:licensemustincludelicense'] = '必须包括许可证';
$string['editor:licenseunspecified'] = '未指明的';
$string['editor:listbelowmin'] = '要使内容正常运行，列表至少需要:min项。';
$string['editor:listexceedsmax'] = '列表超过::max项的最大值。';
$string['editor:listlabel'] = '列表';
$string['editor:loading'] = '加载中,请稍候…';
$string['editor:loadingimageeditor'] = '正在加载图片编辑器，请等待…';
$string['editor:loggedchanges'] = '记录更改';
$string['editor:logthischange'] = '记录这种变化';
$string['editor:maxscoresemanticsmissing'] = '在内容中找不到预期的语义。';
$string['editor:metadata'] = '元数据';
$string['editor:metadatasharingandlicensinginfo'] = '元数据(共享和许可信息)';
$string['editor:missingproperty'] = '字段:index丢失了它的:property属性。';
$string['editor:missingtranslation'] = '[缺失的翻译 :key]';
$string['editor:newchangehasbeenlogged'] = '新的更改已被记录';
$string['editor:newestfirst'] = '最新的优先';
$string['editor:nextimage'] = '下一个图片';
$string['editor:nochangeshavebeenlogged'] = '没有记录任何更改';
$string['editor:nocontenttypesavailable'] = '没有可用的内容类型';
$string['editor:nocontenttypesavailabledesc'] = '您的站点在连接到H5P.org并列出可用内容类型时遇到困难。';
$string['editor:nofollow'] = '不能遵循字段":path"。';
$string['editor:nolanguagessupported'] = '没有语言支持';
$string['editor:noresultsfound'] = '没有找到结果';
$string['editor:noresultsfounddesc'] = '没有匹配您的搜索条件的内容类型。';
$string['editor:nosemantics'] = '错误，无法加载内容类型表单。';
$string['editor:notalltextschanged'] = '并不是所有的文本都改变了，因为只部分覆盖了 :language。';
$string['editor:notimagefield'] = '“:path”不是一个图像。';
$string['editor:notimageordimensionsfield'] = '":path" 不是一个图像或尺寸字段。';
$string['editor:numberfield'] = '数字字段';
$string['editor:numresults'] = ':num结果';
$string['editor:ok'] = '好的';
$string['editor:onlynumbers'] = ':property值只能包含数字。';
$string['editor:or'] = '或';
$string['editor:orderitemdown'] = '排序项下';
$string['editor:orderitemup'] = '排序项上';
$string['editor:outofstep'] = ':property值只能在:step中修改。';
$string['editor:pasteandreplacebutton'] = '粘贴和替换';
$string['editor:pasteandreplacefromclipboard'] = '使用剪贴板中的H5P内容替换现有内容';
$string['editor:pastebutton'] = '粘贴';
$string['editor:pastecontent'] = '替换内容';
$string['editor:pastecontentnotsupported'] = '在此场景中，不支持H5P剪贴板中的内容';
$string['editor:pastecontentrestricted'] = '剪贴板中的内容在此站点上已被限制';
$string['editor:pasteerror'] = '无法从剪贴板粘贴';
$string['editor:pastefromclipboard'] = '从剪贴板粘贴H5P内容';
$string['editor:pastenocontent'] = '剪贴板上没有H5P内容';
$string['editor:pastetoonew'] = 'H5P剪贴板中的内容的版本(:clip)高于此场景(:local)中所支持的版本。如果可能，请先尝试升级此内容，然后再尝试粘贴此内容。';
$string['editor:pastetooold'] = 'H5P剪贴板中的内容版本(:clip)比该场景(:local)中支持的版本低。如果可能，尝试升级要粘贴的内容，然后再次复制并尝试在这里粘贴。';
$string['editor:popularfirst'] = '受欢迎的优先';
$string['editor:previousimage'] = '上一张图片';
$string['editor:proceedbuttonlabel'] = '继续保存';
$string['editor:readless'] = '阅读更少';
$string['editor:readmore'] = '阅读更多';
$string['editor:recentlyusedfirst'] = '最近使用的优先';
$string['editor:reloadbuttonlabel'] = '重新载入';
$string['editor:removefile'] = '删除文件';
$string['editor:removeimage'] = '删除图片';
$string['editor:removeitem'] = '删除项目';
$string['editor:requiredproperty'] = ':property是必需的，并且必须有一个值。';
$string['editor:resettooriginallabel'] = '重新设置为最初的';
$string['editor:savelabel'] = '保存';
$string['editor:savemetadata'] = '保存元数据';
$string['editor:screenshots'] = '屏幕截图';
$string['editor:scriptmissing'] = '无法为%lib加载升级脚本。';
$string['editor:searchresults'] = '搜索结果';
$string['editor:selectfiletoupload'] = '选择上传文件';
$string['editor:selectlibrary'] = '选择要用于内容的库。';
$string['editor:semanticserror'] = '语义错误：:error';
$string['editor:show'] = '显示';
$string['editor:showimportantinstructions'] = '显示说明';
$string['editor:tabtitlebasicfileupload'] = '文件上传';
$string['editor:tabtitleinputlinkurl'] = '链接/网址';
$string['editor:textfield'] = '文本字段';
$string['editor:thecontenttype'] = '内容类型';
$string['editor:thiswillpotentially'] = '这可能会重置所有文本和翻译。您不能撤销，内容本身不会改变。您想继续吗?';
$string['editor:title'] = '标题';
$string['editor:toolong'] = '字段值太长，它应该包含:max或更少的字母。';
$string['editor:tryagain'] = '再试一次';
$string['editor:tutorial'] = '教程';
$string['editor:unabletointerpreterror'] = '无法解释回应。';
$string['editor:unabletointerpretsolution'] = '请检查您的错误日志。';
$string['editor:unknownfieldpath'] = '无法找到 ":path"。';
$string['editor:unknownfileuploaderror'] = '未知文件上传错误';
$string['editor:unknownlibrary'] = '不幸的是，所选内容类型“%lib”没有安装在这个系统上。';
$string['editor:untitled'] = '无标题的:libraryTitle';
$string['editor:uploadaudiotitle'] = '上传音频文件';
$string['editor:uploaderror'] = '文件上传错误';
$string['editor:uploadfilebuttonchangelabel'] = '更改文件';
$string['editor:uploadfilebuttonlabel'] = '上传文件';
$string['editor:uploading'] = '上传中,请稍等…';
$string['editor:uploadingthrobber'] = '现在上传…';
$string['editor:uploadinstructionscontent'] = '您可以从<a href="https://h5p.org/content-types-and-applications" target="blank">H5P.org</a>中的示例开始。';
$string['editor:uploadinstructionstitle'] = '上传一个H5P文件。';
$string['editor:uploadplaceholder'] = '没有选择文件';
$string['editor:uploadsuccess'] = ':title上传成功!';
$string['editor:uploadtablabel'] = '上传';
$string['editor:uploadvideotitle'] = '上传视频文件';
$string['editor:usedforsearchingreportsandcopyrightinformation'] = '用于搜索，报告和版权信息';
$string['editor:videoquality'] = '视频质量标签';
$string['editor:videoqualitydefaultlabel'] = '质量:index';
$string['editor:videoqualitydescription'] = '这个标签帮助用户识别视频的当前质量。例如1080p, 720p, HD或移动设备';
$string['editor:warningchangebrowsingtoseeresults'] = '单击<em>所有</em>以获得您可以安装的所有内容类型的列表。';
$string['editor:warningnocontenttypesinstalled'] = '您没有安装任何内容类型。';
$string['editor:warningupdateavailablebody'] = '更新到最新版本以改善体验。';
$string['editor:warningupdateavailabletitle'] = '新版本的:contentType可用。';
$string['editor:width'] = '宽';
$string['pluginname'] = 'H5P框架v1.24';
$string['pluginname_help'] = 'H5P框架版本1.24。';
$string['privacy:metadata'] = 'H5P框架v1.24不存储任何个人数据。';
