<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hvp', language 'da', version '4.4'.
 *
 * @package     hvp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Handling';
$string['addedandupdatedpp'] = 'Tilføjede {$a->%new} nye H5P-biblioteker og opdaterede {$a->%old} gamle.';
$string['addedandupdatedps'] = 'Tilføjede {$a->%new} nye H5P-biblioteker og opdaterede {$a->%old} gammelt.';
$string['addedandupdatedsp'] = 'Tilføjede {$a->%new} nyt H5P-bibliotek og opdaterede {$a->%old} gamle.';
$string['addedandupdatedss'] = 'Tilføjede {$a->%new} nyt H5P-bibliotek og opdaterede {$a->%old} gammelt.';
$string['addednewlibraries'] = 'Tilføjede {$a->%new} nye biblioteker';
$string['addednewlibrary'] = 'Tilføjede {$a->%new} nyt H5P-bibliotek';
$string['additionalinfo'] = 'Yderligere oplysninger';
$string['additionallicenseinfo'] = 'Yderligere oplysninger vedrørende licensen';
$string['addlibraries'] = 'Tilføj biblioteker';
$string['ajaxfailed'] = 'Kunne ikke indlæse data';
$string['anunexpectedsave'] = 'Der er indtruffet noget uventet. Indholdet blev ikke gemt.';
$string['attribution'] = '';
$string['attributionnc'] = '';
$string['attributionncnd'] = '';
$string['attributionncsa'] = '';
$string['attributionnd'] = '';
$string['attributionsa'] = '';
$string['author'] = 'Forfatter';
$string['authorcomments'] = 'Forfatterkommentarer';
$string['authorname'] = 'Forfatters navn';
$string['authorrole'] = 'Forfatters rolle';
$string['by'] = 'af';
$string['cancellabel'] = 'Annuller';
$string['changedby'] = 'Ændret af';
$string['changedescription'] = 'Beskrivelse af ændringen';
$string['changelog'] = 'Ændringslog';
$string['changeplaceholder'] = 'Foto beskåret, tekst ændret osv.';
$string['close'] = 'Luk';
$string['confirmdialogbody'] = 'Bekræft at du vil fortsætte. Handlingen kan ikke fortrydes.';
$string['confirmdialogheader'] = 'Bekræft handling';
$string['confirmlabel'] = 'Bekræft';
$string['contentchanged'] = 'Indholdet er ændret siden du benyttede det sidst.';
$string['contentstatefrequency'] = 'Frekvens for auto-gem';
$string['contentstatefrequency_help'] = 'Hvor ofte i sekunder skal brugerens arbejde gemmes automatisk? Forøg tallet hvis du har problemer med for mange ajax-forespørgsler';
$string['contenttype'] = 'Indholdstype';
$string['contenttypecacheheader'] = 'Cache af indholdstype';
$string['copyright'] = 'Brugsrettigheder';
$string['copyrightinfo'] = 'Copyright-information';
$string['copyrightstring'] = 'Copyright';
$string['copyrighttitle'] = 'Vis copyright-information om dette indhold.';
$string['couldnotcopy'] = 'Kunne ikke kopiere filen.';
$string['couldnotsave'] = 'Kunne ikke gemme filen';
$string['create'] = 'Opret';
$string['ctcachebuttonlabel'] = 'Opdater cache af indholdstype';
$string['ctcacheconnectionfailed'] = 'Kunne ikke kommunikere med H5P Hub\'en. Prøv igen senere.';
$string['ctcachedescription'] = 'Kontrol af om cache af indholdstypen er opdateret, sikrer, at du kan se, downloade og bruge de nyeste biblioteker. Dette er ikke det samme som at opdatere bibliotekerne selv.';
$string['ctcachelastupdatelabel'] = 'Seneste opdatering';
$string['ctcacheneverupdated'] = 'Aldrig';
$string['ctcachenolibraries'] = 'Der blev ikke modtaget indholdstyper fra H5P Hub. Prøv igen senere.';
$string['ctcachesuccess'] = 'Bibliotekets cache blev opdateret!';
$string['ctcachetaskname'] = 'Opdater indholdstype-cache';
$string['currentpage'] = 'Side $current af $total';
$string['dataviewreportlabel'] = 'Vis svar';
$string['date'] = 'Dato';
$string['disablefileextensioncheck'] = 'Deaktiver filtypekontrol';
$string['disablefileextensioncheckwarning'] = 'Advarsel! Deaktivering af filendelseskontrollen kan have sikkerhedsmæssige konsekvenser, da det tillader upload af php-filer. Dette kan gøre det muligt for hackere at skade dit websted. Sørg for, at du ved præcis hvad du uploader.';
$string['disablefullscreen'] = 'Deaktiver fuldskærm';
$string['disablehubconfirmationmsg'] = 'Vil du stadig aktivere hub\'en?';
$string['disablehubdescription'] = 'Det anbefales på det kraftigste at holde denne mulighed aktiveret. H5P Hub gør det nemt at få nye indholdstyper og at holde eksisterende indholdstyper opdaterede. I fremtiden vil det også gøre det nemmere at dele og genbruge indhold. Hvis denne indstilling er deaktiveret, skal du installere og opdatere indholdstyper via formularer til upload af filer.';
$string['displayoptionalwaysshow'] = 'Vis altid';
$string['displayoptionauthoroff'] = 'Kontrolleret af forfatter, standard er slået fra';
$string['displayoptionauthoron'] = 'Kontrolleret af forfatter, standard er sat til aktiv';
$string['displayoptiondownloadalways'] = 'Altid';
$string['displayoptiondownloadnever'] = 'Aldrig';
$string['displayoptiondownloadpermission'] = 'Kun hvis brugeren har tilladelse til at eksportere H5P';
$string['displayoptionnevershow'] = 'Vis aldrig';
$string['displayoptionpermissions'] = 'Vis kun hvis brugeren har tilladelse til at eksportere H5P';
$string['displayoptionpermissionsembed'] = 'Vis kun hvis brugeren har tilladelse til at indlejre H5P';
$string['displayoptions'] = 'Vis indstillinger';
$string['download'] = 'Download';
$string['downloadfailed'] = 'Download af det ønskede bibliotek mislykkedes.';
$string['downloadtitle'] = 'Download dette indhold som en H5P-fil.';
$string['editor'] = 'Editor';
$string['embed'] = 'Indlejr';
$string['embedloginfailed'] = 'Du har ikke adgang til dette indhold. Prøv at logge ind.';
$string['embedtitle'] = 'Vis indlejret kode for dette indhold.';
$string['empty'] = 'Der er ingen tilgængelige resultater';
$string['enableabout'] = 'Om H5P-knappen';
$string['enablecopyright'] = 'Copyright-knap';
$string['enabledlrscontenttypes'] = 'Aktiver LRS-afhængige indholdstyper';
$string['enabledlrscontenttypes_help'] = 'Gør det muligt at bruge indholdstyper der er afhængige af en "Learning Record Store" for at fungere tilfredsstillende ligesom indholdstypen spørgeskema.';
$string['enabledownload'] = 'Tillad download';
$string['enableembed'] = 'Indlejr-knap';
$string['enableframe'] = 'Vis handlingslinje og ramme';
$string['enablehublabel'] = 'Benyt H5P Hub';
$string['enablejavascript'] = 'Aktiver JavaScript.';
$string['enablesavecontentstate'] = 'Gem indholdstilstand';
$string['enablesavecontentstate_help'] = 'Gem automatisk tilstand på interaktivt indhold for hver bruger. Det betyder at brugeren kan fortsætte derfra hvor hun slap sidst.';
$string['failedtodownloadh5p'] = 'Kunne ikke downloade den ønskede H5P.';
$string['filenotfoundonserver'] = 'Kunne ikke finde filen på serveren. Tjek filens uploadindstillinger.';
$string['filenotimage'] = 'Filen er ikke et billede.';
$string['filetypenotallowed'] = 'Filtypen er ikke tilladt.';
$string['finished'] = 'Færdig';
$string['fullscreen'] = 'Fuldskærm';
$string['gpl'] = '';
$string['h5pfile'] = 'H5P-fil';
$string['h5ptitle'] = 'Besøg H5P.org for at se mere inspirerende indhold.';
$string['hide'] = 'Skjul';
$string['hideadvanced'] = 'Skjul avanceret';
$string['hubcommunicationdisabled'] = 'H5P hub-kommunikationen er blevet deaktiveret, et eller flere H5P-krav blev ikke opfyldt.';
$string['hubisdisabled'] = 'Denne hub er deaktiveret. Du kan aktivere den igen i H5P-indstillingerne.';
$string['hubisdisableduploadlibraries'] = 'H5P Hub er blevet deaktiveret indtil problemet kan løses. Du kan muligvis uploade biblioteker via siden "H5P Biblioteker".';
$string['hubsettingsheader'] = 'Indholdstyper';
$string['hvp:addinstance'] = 'Tilføj nye H5P-aktiviteter';
$string['hvp:getcachedassets'] = 'Kræves for at se H5P-aktiviteter';
$string['hvp:getembedcode'] = 'Se H5P-indlejret kode når muligheden "controlled by permission"  er aktiveret';
$string['hvp:getexport'] = 'Hent H5P-fil når muligheden "controlled by permission"  er aktiveret';
$string['hvp:installrecommendedh5plibraries'] = 'Installer nye sikre H5P-indholdstyper anbefalet af H5P.org';
$string['hvp:manage'] = 'Rediger eksisterende H5P-aktiviteter';
$string['hvp:restrictlibraries'] = 'Begræns adgangen til visse typer H5P-indhold';
$string['hvp:savecontentuserdata'] = 'Gem brugerens progression for H5P-aktiviteter.';
$string['hvp:saveresults'] = 'Gem resultater for fuldførte H5P-aktiviteter';
$string['hvp:updatelibraries'] = 'Installer nye H5P-indholdstyper eller opdater eksisterende';
$string['hvp:userestrictedlibraries'] = 'Benyt begrænsede H5P-indholdstyper';
$string['hvp:view'] = 'Se og interager med H5P-aktiviteter';
$string['hvp:viewallresults'] = 'Se alle resultater for afsluttede H5P-aktiviteter';
$string['hvp:viewresults'] = 'Vis resultater for fuldførte H5P-aktiviteter';
$string['installdenied'] = 'Du har ikke tilladelse til at installere indholdstyper. Kontakt administratoren for din installation.';
$string['installedlibraries'] = 'Installerede biblioteker';
$string['intro'] = 'Introduktion';
$string['invalidaudioformat'] = 'Ugyldigt format på lydfil. Benyt mp3 eller wav.';
$string['invalidcontentfolder'] = 'Ugyldig indholdsmappe';
$string['invalidcontenttype'] = 'Den valgte indholdstype er ugyldig.';
$string['invalidfieldtype'] = 'Ugyldig feltype.';
$string['invalidfile'] = 'Filen "{$a->%filename}" er ikke tilladt. Kun følgende filendelser tillades: {$a->%files-allowed}.';
$string['invalidh5ppost'] = 'Kunne ikke få vist H5P.';
$string['invalidimageformat'] = 'Ugyldigt billedfilformat. Brug jpg, png eller gif.';
$string['invalidlanguagefile'] = 'Ugyldig sprogfil {$a->%file} i biblioteket {$a->%library}';
$string['invalidlanguagefile2'] = 'Ugyldig sprogfil {$a->%languageFile} er inkluderet i biblioteket {$a->%name}';
$string['invalidlibrary'] = 'Ugyldigt bibliotek';
$string['invalidlibrarydata'] = 'Ugyldig data angivet til {$a->%property} i {$a->%library}';
$string['invalidlibrarydataboolean'] = 'Ugyldige data er angivet for {$a->%property} i {$a->%library}. Boolean forventes.';
$string['invalidlibraryname'] = 'Ugyldigt biblioteksnavn: {$a->%name}';
$string['invalidlibrarynamed'] = 'H5P-biblioteket {$a->%library} brugt i indholdet er ikke gyldigt';
$string['invalidlibraryoption'] = 'Ulovlig indstilling:  {$a->%option} i {$a->%library}';
$string['invalidlibraryproperty'] = 'Kan ikke læse egenskaberne  {$a->%property} i {$a->%library}';
$string['invalidmainjson'] = 'En gyldig primær h5p.json-fil mangler';
$string['invalidmultiselectoption'] = 'Ugyldig valgt indstilling i multi-select.';
$string['invalidparameters'] = 'Ugyldige Parametre';
$string['invalidselectoption'] = 'Ugyldig valgt indstilling i vælg.';
$string['invalidsemanticsjson'] = 'Ugyldig semantics.json-fil er inkluderet i biblioteket {$a->%name}';
$string['invalidsemanticstype'] = 'Intern H5P-fejl: ukendt indholdstype "{$a->@type}" i semantik. Fjerner indholdet!';
$string['invalidstring'] = 'Den leverede streng er ikke gyldig i henhold til regexp i semantik. (value: "{$a->%value}", regexp: "{$a->%regexp}")';
$string['invalidtoken'] = 'H5P har modtaget et ugyldigt token. Opdater siden, og prøv igen';
$string['invalidvideoformat'] = 'Ugyldigt format på videofil. Brug mp4 eller webm.';
$string['invalidxapiresult'] = 'Der blev ikke fundet nogen xAPI-resultater for kombinationen af det givne indhold og bruger-id';
$string['javascriptloading'] = 'Venter på JavaScript...';
$string['libraries'] = 'H5P-biblioteker';
$string['librarydirectoryerror'] = 'Bibliotekets mappenavn skal matche machineName eller machineName-majorVersion.minorVersion (fra library.json). (Mappe: {$a->%directoryName}, machineName: {$a->% machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->% minorVersion})';
$string['librarylistactions'] = 'Handlinger';
$string['librarylistinstancedependencies'] = 'Forekomstens afhængigheder';
$string['librarylistinstances'] = 'Forekomster';
$string['librarylistlibrarydependencies'] = 'Biblioteksafhængigheder';
$string['librarylistrestricted'] = 'Begrænset';
$string['librarylisttitle'] = 'Titel';
$string['librarynotselected'] = 'Du skal vælge en indholdstype';
$string['license'] = 'Licens';
$string['licenseCC010'] = '';
$string['licenseCC010U'] = '';
$string['licenseCC10'] = '';
$string['licenseCC20'] = '';
$string['licenseCC25'] = '';
$string['licenseCC30'] = '';
$string['licenseCC40'] = '';
$string['licenseGPL'] = 'General Public License';
$string['licenseV1'] = 'Version 1';
$string['licenseV2'] = 'Version 2';
$string['licenseV3'] = 'Version 3';
$string['licenseversion'] = 'Licensversion';
$string['loadingdata'] = 'Indlæser data.';
$string['lookforupdates'] = 'Søg efter H5P-opdateringer';
$string['maximumgrade'] = 'Højeste karakter';
$string['maximumgradeerror'] = 'Indtast et gyldigt positivt hel-tal som højest mulige point for denne aktivitet';
$string['maxpostsizetoosmall'] = 'Din "PHP max post size" er ret lille. Med dit nuværende setup kan du ikke uploade filer, der er større end {$a->%number} MB. Dette kan være et problem, når du forsøger at uploade H5P\'er, billeder og videoer. Overvej at øge den til mere end 5 MB';
$string['maxscore'] = 'Maksimum point';
$string['maxuploadsizetoosmall'] = 'Din "PHP max upload size" er ret lille. Med dit nuværende setup kan du ikke uploade filer, der er større end {$a->%number} MB. Dette kan være et problem, når du forsøger at uploade H5P\'er, billeder og videoer. Overvej at øge den til mere end 5 MB';
$string['missingcontentfolder'] = 'En gyldig indholdsmappe mangler';
$string['missingcontentuserdata'] = 'Fejl: Kunne ikke finde indholdsbrugerdata';
$string['missingcoreversion'] = 'Systemet kunne ikke installere komponenten <em>{$a->% komponent}</ em> fra pakken. Det kræver en nyere version af H5P. Dette websted kører i øjeblikket version {$a->%current}, mens den krævede version er {$a->%required} eller højere. Du bør overveje at opgradere og derefter prøve igen.';
$string['missingdependency'] = 'Manglende afhængighed {$a->@dep} krævet af {$a->@lib}.';
$string['missinglibrary'] = 'Mangler påkrævet bibliotek {$a->@bibliotek}';
$string['missinglibraryfile'] = 'Filen "{$a->%file}" mangler fra biblioteket: "{$a->%name}"';
$string['missinglibraryjson'] = 'Kunne ikke finde library.json-fil med gyldigt json-format til biblioteket {$a->%name}';
$string['missinglibraryproperty'] = 'Den krævede indstilling {$a->%property} mangler fra {$a->%library}';
$string['missingmbstring'] = 'PHP-udvidelsen mbstring er ikke indlæst, H5P har brug for den for at fungere tilfredsstillende';
$string['missingparameters'] = 'Mangler parametre';
$string['missinguploadpermissions'] = 'Bemærk at bibliotekerne kan være indeholdt i den fil du uploadede, men du har ikke tilladelse til at uploade nye biblioteker. Kontakt webstedets administrator herom.';
$string['modulename'] = 'Interaktivt indhold';
$string['modulename_help'] = 'H5P-aktivitetsmodulet giver dig mulighed for at skabe interaktivt indhold såsom interaktive videoer, spørgsmålssæt, træk og slip-spørgsmål, flervalgsspørgsmål, præsentationer og meget mere.

Ud over at være et forfatterværktøj til rigt indhold, giver H5P dig mulighed for at importere og eksportere H5P-filer til effektiv genbrug og deling af indhold.

Brugerinteraktioner og scores spores ved hjælp af xAPI og er tilgængelige via Moodle Gradebook. Bemærk, at det i øjeblikket er muligt for folk med programmeringsfærdigheder at snyde i H5P-interaktioner og opnå den fulde score uden at kende de korrekte svar. H5P\'ere må ikke bruges til eksamener eller lignende.

Du tilføjer interaktivt H5P-indhold ved at oprette indhold ved hjælp af det indbyggede forfatterværktøj eller uploade H5P-filer, der findes på andre H5P-aktiverede websteder.';
$string['modulename_link'] = 'https://h5p.org/moodle-more-help';
$string['modulenameplural'] = 'Interaktivt indhold';
$string['nextpage'] = 'Næste side';
$string['nocontent'] = 'Kunne ikke finde eller parse filen content.json';
$string['nocontenttype'] = 'Ingen indholdstype blev angivet.';
$string['nocopyright'] = 'Der er ingen copyright-oplysninger til rådighed for dette indhold.';
$string['nodata'] = 'Der er ingen tilgængelige data der matcher dine kriterier.';
$string['noextension'] = 'Filen du uploadede er ikke en gyldig HTML5-pakke (Den har ikke filendelsen .h5p)';
$string['noh5ps'] = 'Der er intet interaktivt indhold til rådighed på dette kursus.';
$string['nojson'] = 'h5p.jsons primære fil er ikke gyldig';
$string['noparameters'] = 'Ingen parametre';
$string['noparse'] = 'Kunne ikke parse h5p.jsons primære fil';
$string['nopermissiontorestrict'] = 'Du har ikke tilladelse til at sætte begrænsninger på biblioteker.';
$string['nopermissiontosavecontentuserdata'] = 'Du har ikke tilladelse til at gemme indholdsbrugerdata.';
$string['nopermissiontosaveresult'] = 'Du har ikke tilladelse til at gemme resultat for dette indhold.';
$string['nopermissiontoupgrade'] = 'Du har ikke tilladelse til at opgradere biblioteker.';
$string['nopermissiontouploadcontent'] = 'Du har ikke tilladelse til at uploade indhold her.';
$string['nopermissiontouploadfiles'] = 'Du har ikke tilladelse til at uploade filer her.';
$string['nopermissiontoviewcontenttypes'] = 'Du har ikke tilladelse til at se indholdstyperne.';
$string['nopermissiontoviewresult'] = 'Du har ikke tilladelse til at se resultater for dette indhold.';
$string['nosuchlibrary'] = 'Intet sådant bibliotek';
$string['notapplicable'] = 'Ikke tilgængelig';
$string['nounzip'] = 'Filen du uploadede er ikke en gyldig HTML5-pakke (vi kan ikke pakke den ud)';
$string['noversionattribution'] = '';
$string['noversionattributionnc'] = '';
$string['noversionattributionncnd'] = '';
$string['noversionattributionncsa'] = '';
$string['noversionattributionnd'] = '';
$string['noversionattributionsa'] = '';
$string['nowriteaccess'] = 'Der er et problem med serverens skriveadgang. Sørg for at din server kan skrive til din datamappe.';
$string['noziparchive'] = 'Din PHP-version understøtter ikke Zip-pakker';
$string['oldphpversion'] = 'Din PHP-version er forældet. H5P kræver version 5.2 for at køre tilfredsstillinde. Version 5.6 eller nyere anbefales.';
$string['olduploadoldcontent'] = 'Du forsøger at uploade indhold til en gammel version af H5P. Opgrader indholdet på den server det kom fra eller brug H5P Hub, som kan opgradere indholdet automatisk.';
$string['onlyupdate'] = 'Opdater kun eksisterende biblioteker';
$string['options'] = 'Indstillinger';
$string['pd'] = '';
$string['pddl'] = '';
$string['pdm'] = '';
$string['pluginadministration'] = 'H5P';
$string['pluginname'] = 'H5P';
$string['postmessagerequired'] = '';
$string['previouspage'] = 'Foregående side';
$string['question'] = 'Spørgsmål';
$string['removeoldlogentries'] = 'Fjern gamle H5P-logposter';
$string['removetmpfiles'] = 'Fjern gamle midlertidige filer';
$string['reportingquestionsremaininglabel'] = 'resterende spørgsmål der skal bedømmes';
$string['reportingscoredelimiter'] = 'ud af';
$string['reportnotsupported'] = 'Ikke understøttet';
$string['resizescript'] = 'Medtag dette script på din hjemmeside, hvis du vil have dynamisk dimensionering af det indlejrede indhold:';
$string['reuse'] = 'Genbrug';
$string['reveal'] = 'Vis';
$string['reviseserversetupandretry'] = 'Når du har revideret din serveropsætning, skal du muligvis aktivere H5P-hubs kommunikation igen i H5P-indstillingerne.';
$string['score'] = 'Point';
$string['search'] = 'Søg';
$string['sendusagestatistics'] = 'Rapportér statistik over anvendelsen';
$string['sendusagestatistics_help'] = 'Statistik over brugen vil automatisk blive rapporteret tilbage til H5P for at hjælpe udviklerne med at forstå hvordan H5P anvendes og til at kortlægge potentielle forbedringer. Læs mere om <a {$a}>hvilke data der indsamles på h5p.org</a>.';
$string['settings'] = 'H5P-indstillinger';
$string['showadvanced'] = 'Vis avanceret';
$string['showless'] = 'Vis mindre';
$string['showmore'] = 'Vis mere';
$string['sitecouldnotberegistered'] = 'Installationen kunne ikke registreres på hub\'en. Kontakt din administrator.';
$string['sitekey'] = 'Installationsnøgle';
$string['sitekeydescription'] = 'Installationsnøglen er unik og identificerer dette websted overfor hub\'en.';
$string['sitekeyregistered'] = 'Du har fået en unik nøgle som identificerer dig overfor hub\'en når der er nye opdateringer. Nøglen kan ses på siden "H5P-indstillinger".';
$string['size'] = 'Størrelse';
$string['source'] = 'Kilde';
$string['sslnotenabled'] = 'Din server har ikke SSL aktiveret. SSL er nødvendig for at du sikkert kan forbinde til H5P-hub\'en.';
$string['startingover'] = 'Du må begynde forfra.';
$string['sublevel'] = 'Undermappe';
$string['successfullyregisteredwithhub'] = 'Dit websted blev registreret på H5P-hub\'en.';
$string['thumbnail'] = 'Miniature';
$string['title'] = 'Titel';
$string['unabletocreatedir'] = 'Kunne ikke oprette mappe.';
$string['unabletogetfieldtype'] = 'Kunne ikke hente felttype.';
$string['undisclosed'] = 'Uoplyst';
$string['updatedlibraries'] = 'Opdaterede {$a->%old} H5P-bibllioteker.';
$string['updatedlibrary'] = 'Opdaterede {$a->%old} H5P-bibliotek.';
$string['updatelibraries'] = 'Opdater alle biblioteker';
$string['upgrade'] = 'Opgrader H5P';
$string['upgradebuttonlabel'] = 'Opgrader';
$string['upgradedone'] = '{$a} forekomst(er) af indhold opdateret.';
$string['upgradeerror'] = 'Der opstod en fejl under behandling af parametre:';
$string['upgradeerrorcontent'] = 'Kunne ikke opgradere indholdet, %id:';
$string['upgradeerrordata'] = 'Kunne ikke indlæse data til biblioteket %lib.';
$string['upgradeerrormissinglibrary'] = 'Mangler krævet bibliotek, %lib.';
$string['upgradeerrornotsupported'] = 'Parametre indeholder %used, som ikke understøttes.';
$string['upgradeerrorparamsbroken'] = 'Parametre er beskadigede';
$string['upgradeerrorscript'] = 'Kunne ikke indlæse opgraderingsscript til %lib';
$string['upgradeerrortoohighversion'] = 'Parametre indeholder %used, men kun %supported eller tidligere understøttes.';
$string['upgradeheading'] = 'Opgrader {$a} indhold';
$string['upgradeinprogress'] = 'Opgraderer til %ver...';
$string['upgradeinvalidtoken'] = 'Fejl: Ugyldig sikkerhedstoken!';
$string['upgradelibrarycontent'] = 'Opgrader biblioteks-indhold.';
$string['upgradelibrarymissing'] = 'Fejl: Dit bibliotek mangler!';
$string['upgrademessage'] = 'Du er i gang med at opgradere {$a} forekomst(er) af indhold. Vælg en opgraderingsversion.';
$string['upgradenoavailableupgrades'] = 'Der er ingen tilgængelige opgraderinger til dette bibliotek.';
$string['upgradenothingtodo'] = 'Der er intet indhold til opgradering.';
$string['upgradereturn'] = 'Tilbage';
$string['upload'] = 'Upload';
$string['uploadlibraries'] = 'Upload biblioteker';
$string['uploadsizelargerthanpostsize'] = 'Din "PHP max upload size" er større end din "PHP max post size". Erfaringen viser, at det kan give problemer i nogle installationer.';
$string['user'] = 'Bruger';
$string['validatingh5pfailed'] = 'Validering af h5p-pakken mislykkedes.';
$string['validationfailed'] = 'Den anmodede H5P var ikke gyldig';
$string['viewreportlabel'] = 'Rapport';
$string['welcomecommunity'] = 'Vi håber du bliver glad for at bruge H5P og at du vil engagere dig i vores voksende fællesskab gennem <a {$a-> fora}>vores fora</a>';
$string['welcomecontactus'] = 'Hvis du har feedback til os, tøv ikke med at <a {$a}>kontakte os </a>. Vi tager feedback meget seriøst og er parate til at gøre H5P bedre hver dag!';
$string['welcomegettingstarted'] = 'For at komme i gang med H5P og Moodle kan du kigge på vores <a {$a->moodle_tutorial}>vejledning til H5P</a> og tjekke <a {$a->example_content}>eksempler på indhold</a> på H5P.org til inspiration.';
$string['welcomeheader'] = 'Velkommen til H5P!';
$string['wrongversion'] = 'Versionen af H5P biblioteket {$a->%machineName} anvendt i dette indhold er ikke gyldigt.
Indholdet indeholder {$a->%contentLibrary}, men det skal være {$a->%semanticsLibrary}.';
$string['year'] = 'År';
$string['years'] = 'År';
