<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'board', language 'de', version '4.4'.
 *
 * @package     board
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['Cancel'] = 'Abbrechen';
$string['Ok'] = 'Ok';
$string['acceptedfiletypeforbackground'] = 'Dateitypen für Hintergründe';
$string['acceptedfiletypeforbackground_desc'] = 'Wählen Sie Dateitypen für Hintergrundbilder, die unterstützt werden sollen.';
$string['acceptedfiletypeforcontent'] = 'Dateitypen für Inhaltsbilder';
$string['acceptedfiletypeforcontent_desc'] = 'Wählen Sie Dateitypen für Inhaltsbilder, die unterstützt werden sollen.';
$string['addcomment'] = 'Kommentar hinzufügen';
$string['addrating'] = 'Beiträge bewerten';
$string['addrating_all'] = 'von allen';
$string['addrating_none'] = 'Deaktiviert';
$string['addrating_students'] = 'von Teilnehmer/innen';
$string['addrating_teachers'] = 'von Trainer/innen';
$string['allowed_singleuser_modes'] = 'Erlaubte Einzelnutzermodi';
$string['allowed_singleuser_modes_desc'] = 'Nutzung bestimmter Einzelnutzermodi erlauben bzw. verbieten. Dies hat keine Auswirkungen auf bereits bestehende Boards.';
$string['allowyoutube'] = 'YouTube erlauben';
$string['allowyoutube_desc'] = 'Wenn die Option aktiviert ist, wird eine Schaltfläche zum Hinzufügen eines eingebetteten YouTube-Videos angezeigt.';
$string['aria_addmedia'] = '{type} für Beitrag {post} aus Spalte {column} hinzufügen';
$string['aria_addmedianew'] = '{type} für neuen Beitrag aus Spalte {column} hinzufügen';
$string['aria_canceledit'] = 'Bearbeitung für Beitrag {post} aus Spalte {column} abbrechen';
$string['aria_cancelnew'] = 'Neuen Beitrag für Spalte {column} abbrechen';
$string['aria_choosefileedit'] = 'Datei für Beitrag {post} aus Spalte {column} auswählen';
$string['aria_choosefilenew'] = 'Datei für neuen Beitrag aus Spalte {column} auswählen';
$string['aria_column_locked'] = 'Spalte {$a} gesperrt';
$string['aria_column_unlocked'] = 'Spalte {$a} entsperrt';
$string['aria_deleteattachment'] = 'Anhang für Beitrag {post} aus Spalte {column} löschen';
$string['aria_deletecolumn'] = 'Spalte {column} löschen';
$string['aria_deletepost'] = 'Beitrag {post} aus Spalte {column} löschen';
$string['aria_editpost'] = 'Beitrag {post} bearbeiten';
$string['aria_movecolumn'] = 'Spalte {column} bewegen';
$string['aria_movepost'] = 'Beitrag {post} bewegen';
$string['aria_newcolumn'] = 'Neue Spalte hinzufügen';
$string['aria_newpost'] = 'Neuen Beitrag zu Spalte {column} hinzufügen';
$string['aria_postedit'] = 'Beitrag {post} aus Spalte {column} speichern';
$string['aria_postnew'] = 'Neuen Beitrag für Spalte {column} speichern';
$string['aria_ratepost'] = 'Beitrag {post} aus Spalte {column} bewerten';
$string['background_color'] = 'Hintergrundfarbe';
$string['background_color_help'] = 'Verwenden Sie eine gültige Hex-Farbe, z.B. #00cc99';
$string['background_image'] = 'Hintergrundbild';
$string['blanktargetenabled'] = 'Dieses Board wurde so konfiguriert, dass alle URLs in einem neuen Fenster oder Tab göffnet werden.';
$string['board:addinstance'] = 'Neues Board hinzufügen';
$string['board:deleteallcomments'] = 'Alle Kommentare zu Beiträgen anzeigen und löschen';
$string['board:manageboard'] = 'Spalten und alle Beiträge bearbeiten';
$string['board:post'] = 'Eigene Beiträge verwalten und andere Beiträge bewerten';
$string['board:postcomment'] = 'Kommentare zu Beiträgen erstellen und anzeigen';
$string['board:view'] = 'Board-Inhalt anzeigen';
$string['board_column_locked'] = 'Diese Spalte ist gesperrt und kann nicht bearbeitet werden.';
$string['boardhasnotes'] = 'Dieses Board hat bereits Beiträge. Das Ändern des Nutzermodus ist nicht erlaubt.';
$string['boardsettings'] = 'Board-Einstellungen';
$string['brickfieldlogo'] = 'Powered by Brickfield logo';
$string['cancel_button_text'] = 'Abbrechen';
$string['choose_file'] = 'Bilddatei auswählen';
$string['close_button_text'] = 'Schließen';
$string['column_colours'] = 'Spaltenfarben';
$string['column_colours_desc'] = 'Farben, die am oberen Spaltenrand verwendet werden. Sie können in jeder Zeile eine Hex-Farbe angeben, z.B. #00cc99. Wenn einer dieser Werte fehlerhaft ist, werden die Standardwerte verwendet.';
$string['comment'] = 'Kommentar';
$string['comments'] = '{$a} Kommentare';
$string['completiondetail:notes'] = 'Notizen hinzufügen: {$a}';
$string['completionnotes'] = 'Teilnehmer/in muss diese Anzahl von Notizen eintragen, um die Aktivität abzuschließen';
$string['completionnotesgroup'] = 'Notizen fordern';
$string['default_column_heading'] = 'Überschrift';
$string['delete'] = 'Löschen';
$string['deletecomment'] = 'Kommentar löschen';
$string['embed_allowed'] = '"Board einbetten" erlauben';
$string['embed_allowed_desc'] = 'Wenn die Option aktiviert ist, wird die Einbettungsfunktion des Boards in den Aktivitätseinstellungen verfügbar.';
$string['embed_height'] = 'Einbetthöhe';
$string['embed_height_desc'] = 'Höhe für den Iframe, wenn das Board in den Kurs eingebettet wird. Dies muss ein gültiger CSS-Wert sein, z.B. px, rem, % usw. ...';
$string['embed_width'] = 'Einbettbreite';
$string['embed_width_desc'] = 'Breite für den Iframe, wenn das Board in den Kurs eingebettet wird. Dies muss ein gültiger CSS-Wert sein, z.B. px, rem, % usw. ...';
$string['embedboard'] = 'Board in eine Kursseite einbetten';
$string['enableblanktarget'] = 'Links in neuem Fenster erlauben';
$string['enableblanktarget_help'] = 'Diese Option erlaubt es, alle Links in einem neuen Tab/Fenster zu öffnen.';
$string['event_add_column'] = 'Spalte hinzugefügt';
$string['event_add_column_desc'] = 'Nutzer/in \'{$a->userid}\' hat die Board-Spalte \'{$a->objectid}\' mit dem Namen \'{$a->name}\' erstellt.';
$string['event_add_comment'] = 'Kommentar hinzugefügt';
$string['event_add_comment_desc'] = 'Nutzer/in \'{$a->userid}\' hat einen Kommentar \'{$a->objectid}\' mit dem Inhalt \'{$a->content}\' zum Beitrag \'{$a->noteid}\' hinzugefügt.';
$string['event_add_note'] = 'Beitrag hinzugefügt';
$string['event_add_note_desc'] = 'Nutzer/in \'{$a->userid}\' hat im Board den Beitrag \'{$a->objectid}\' mit der Überschrift \'{$a->heading}\', dem Inhalt \'{$a->content}\' und den Medien \'{$a->media}\' erstellt, u.z. in der Spalte \'{$a->columnid}\' und der Gruppe \'{$a->groupid}\'.';
$string['event_delete_column'] = 'Spalte gelöscht';
$string['event_delete_column_desc'] = 'Nutzer/in \'{$a->userid}\' hat im Board die Spalte \'{$a->objectid}\' gelöscht.';
$string['event_delete_comment'] = 'Kommentar gelöscht';
$string['event_delete_comment_desc'] = 'Nutzer/in \'{$a->userid}\' hat den Kommentar \'{$a->objectid}\' aus dem Beitrag \'{$a->noteid}\' gelöscht.';
$string['event_delete_note'] = 'Beitrag gelöscht';
$string['event_delete_note_desc'] = 'Nutzer/in \'{$a->userid}\' hat im Board den Beitrag \'{$a->objectid}\' aus der Spalte \'{$a->columnid}\' gelöscht.';
$string['event_move_note'] = 'Beitrag verschoben';
$string['event_move_note_desc'] = 'Nutzer/in \'{$a->userid}\' hat im Board den Beitrag \'{$a->objectid}\' in die Spalte \'{$a->columnid}\' verschoben.';
$string['event_rate_note'] = 'Beitrag bewertet';
$string['event_rate_note_desc'] = 'Nutzer/in \'{$a->userid}\' hat im Board den Beitrag \'{$a->objectid}\' mit der Bewertung \'{$a->rating}\' bewertet.';
$string['event_update_column'] = 'Spalte aktualisiert';
$string['event_update_column_desc'] = 'Nutzer/in \'{$a->userid}\' hat im Board die Spalte \'{$a->objectid}\' zu \'{$a->name}\' aktualisiert.';
$string['event_update_note'] = 'Beitrag aktualisiert';
$string['event_update_note_desc'] = 'Nutzer/in \'{$a->userid}\' hat im Board den Beitrag \'{$a->objectid}\' mit der Überschrift \'{$a->heading}\', dem Inhalt \'{$a->content}\' und den Medien \'{$a->media}\' aktualisiert, u.z. in der Spalte \'{$a->columnid}\'.';
$string['export'] = 'Export';
$string['export_backtoboard'] = 'Zurück zum Board';
$string['export_board'] = 'Board exportieren';
$string['export_comment'] = 'Kommentar';
$string['export_comments'] = 'Kommentare exportieren';
$string['export_comments_description'] = 'Wählen Sie bitte, welche Kommentare Sie exportieren möchten.';
$string['export_comments_include_deleted'] = 'Sie können für den Export alle Kommentare wählen, einschließlich der bereits gelöschten.';
$string['export_comments_include_deleted_button'] = 'Kommentare exportieren (einschließlich gelöschte)';
$string['export_content'] = 'Text';
$string['export_deleted'] = 'Gelöscht';
$string['export_email'] = 'E-Mail';
$string['export_firstname'] = 'Vorname';
$string['export_heading'] = 'Beitragsüberschrift';
$string['export_info'] = 'Medientitel';
$string['export_lastname'] = 'Nachname';
$string['export_submissions'] = 'Beiträge exportieren';
$string['export_timecreated'] = 'Erstellungsdatum';
$string['export_url'] = 'Medien-URL';
$string['form_body'] = 'Inhalt';
$string['form_image_file'] = 'Bilddatei';
$string['form_mediatype'] = 'Medien';
$string['form_title'] = 'Beitragstitel';
$string['hideheaders'] = 'Spaltentitel vor Teilnehmer/innen verbergen';
$string['hidename'] = 'Namen des eingebetteten Boards verbergen (für einige Designs notwendig)';
$string['history'] = 'Board-Verlauf';
$string['history_refresh'] = 'Aktualisierungsintervall des Boards';
$string['history_refresh_desc'] = 'Intervall (in Sekunden) zwischen automatischen Aktualisierungen des Boards. Bei einem Wert von 0 oder leer wird das Board nur bei Aktionen (Hinzufügen/ Bearbeiten/ usw.) aktualisiert.';
$string['historyinfo'] = 'Der Board-Verlauf wird verwendet, um temporäre Daten zu speichern, die von Javascript-Prozessen zur Aktualisierung von Board-Ansichten verwendet und anschließend gelöscht werden.';
$string['include_deleted'] = 'Einschließlich gelöschte';
$string['invalid_file_extension'] = 'Die Dateierweiterung wird für das Hochladen nicht akzeptiert.';
$string['invalid_file_size_max'] = 'Die Datei ist zu groß, um akzeptiert zu werden.';
$string['invalid_file_size_min'] = 'Die Datei ist zu klein, um akzeptiert zu werden.';
$string['invalid_youtube_url'] = 'Ungültige YouTube-URL';
$string['media_selection'] = 'Medienauswahl';
$string['media_selection_buttons'] = 'Tasten';
$string['media_selection_desc'] = 'Legen Sie fest, wie die Medienauswahl für Beiträge angezeigt werden soll.';
$string['media_selection_dropdown'] = 'Dropdown';
$string['modal_title_edit'] = 'Beitrag für Spalte {column} bearbeiten';
$string['modal_title_new'] = 'Neuer Beitrag für Spalte {column}';
$string['modulename'] = 'Board';
$string['modulename_help'] = 'Diese Aktivität erlaubt es Teilnehmer/innen, zu diskutieren und mit Hilfe eines Post-it-Boards Beiträge zu erstellen, die Text, Bilder, URL-Links oder eingebettete Videos enthalten.

Trainer/innen können Boards unterschiedlich konfigurieren, beispielsweise als

* Posts zur Bewertung.
* Kommentare zu Beiträgen.
* Gruppen- oder Einzelbenutzermodus.
* Abschlussoptionen.
* Trainer-Download-Optionen.

Boards können verwendet werden als

* Einführung oder Eisbrecher.
* Crowdsourcing-Inhalt.
* Whiteboard für Diskussionen.
* Trainer-Feedback zu Sitzungen.';
$string['modulenameplural'] = 'Boards';
$string['move_column_to_aftercolumn'] = 'Spalte hinter Spalte {$a} bewegen';
$string['move_column_to_firstplace'] = 'Spalte auf Position 1 bewegen';
$string['move_to_afterpost'] = 'Hinter Beitrag {$a} bewegen';
$string['move_to_firstitemcolumn'] = 'In Spalte {$a} bewegen';
$string['new_column_icon'] = 'Icon für neue Spalte';
$string['new_column_icon_desc'] = 'Icon, das auf der Taste für neue Spalten angezeigt wird';
$string['new_note_icon'] = 'Icon für neuen Beitrag';
$string['new_note_icon_desc'] = 'Icon, das auf der Taste für neue Beitrag angezeigt wird';
$string['nopermission'] = 'Sie haben kein Recht, dieses Board anzuzeigen.';
$string['note_changed_text'] = 'Der Beitrag, den Sie gerade bearbeiten, wurde geändert.';
$string['note_changed_title'] = 'Bestätigen';
$string['note_deleted_text'] = 'Der Beitrag, den Sie gerade bearbeiten, wurde gelöscht.';
$string['nousers'] = 'Dieses Board hat keine eingeschriebenen Nutzer/innen';
$string['opensinnewwindow'] = 'Öffnet in neuem Fenster';
$string['option_empty'] = 'Keine';
$string['option_image'] = 'Bild';
$string['option_image_info'] = 'Bildtitel';
$string['option_image_url'] = 'Bild-URL';
$string['option_link'] = 'Link';
$string['option_link_info'] = 'Linktitel';
$string['option_link_url'] = 'Link-URL';
$string['option_youtube'] = 'Video (YouTube)';
$string['option_youtube_info'] = 'Videotitel';
$string['option_youtube_url'] = 'Video-URL';
$string['pluginadministration'] = 'Board-Administration';
$string['pluginname'] = 'Board';
$string['post_button_text'] = 'Speichern';
$string['post_max_length'] = 'Maximale Beitragslänge';
$string['post_max_length_desc'] = 'Die maximal zulässige Länge des Inhalts. Alles, was über diese Länge hinausgeht, wird abgeschnitten.';
$string['postbydate'] = 'Beiträge nach Datum';
$string['postbyenabled'] = 'Beiträge von Teilnehmer/innen nach Datum einschränken';
$string['posts'] = 'Beiträge';
$string['privacy:metadata:board_comments'] = 'Kommentare zu jedem Beitrag';
$string['privacy:metadata:board_comments:content'] = 'Inhalt des Kommentars zum Beitrag';
$string['privacy:metadata:board_comments:noteid'] = 'ID des zugehörigen Beitrags';
$string['privacy:metadata:board_comments:timecreated'] = 'Zeit, zu der der Kommentar angelegt wurde';
$string['privacy:metadata:board_comments:userid'] = 'ID der Person, die den Kommentar hinzugefügt hat';
$string['privacy:metadata:board_history'] = 'Der temporäre Board-Verlauf zeichnet Infos auf, die von Javascript-Prozessen zum Aktualisieren von Board-Ansichten verwendet und anschließend gelöscht werden.';
$string['privacy:metadata:board_history:action'] = 'Aktion ausgeführt';
$string['privacy:metadata:board_history:boardid'] = 'ID des Boards';
$string['privacy:metadata:board_history:content'] = 'JSON-Daten der ausgeführten Aktion';
$string['privacy:metadata:board_history:timecreated'] = 'Zeit, zu der die Aktion ausgeführt wurde';
$string['privacy:metadata:board_history:userid'] = 'ID der Person, die die Aktion ausgeführt hat';
$string['privacy:metadata:board_note_ratings'] = 'Infos zu den individuellen Bewertungen für jeden Board-Beitrag';
$string['privacy:metadata:board_note_ratings:noteid'] = 'ID des zugehörigen Beitrags';
$string['privacy:metadata:board_note_ratings:timecreated'] = 'Zeit, zu der die Bewertung des Beitrags erstellt wurde';
$string['privacy:metadata:board_note_ratings:userid'] = 'ID der Person, die die Bewertung des Beitrags erstellt hat';
$string['privacy:metadata:board_notes'] = 'Info zu den individuellen Beiträgen für jedes Board';
$string['privacy:metadata:board_notes:columnid'] = 'Spaltenposition des Beitrags';
$string['privacy:metadata:board_notes:content'] = 'Inhalt des Beitrags';
$string['privacy:metadata:board_notes:heading'] = 'Überschrift des Beitrags';
$string['privacy:metadata:board_notes:info'] = 'Medieninfo des Beitrags';
$string['privacy:metadata:board_notes:timecreated'] = 'Zeit, zu der der Beitrag erstellt wurde';
$string['privacy:metadata:board_notes:url'] = 'Medien-URL des Beitrags';
$string['privacy:metadata:board_notes:userid'] = 'ID der Person, die den Beitrag erstellt hat';
$string['privacystatement'] = '<strong>Datenschutzhinweis zum Board:</strong> Beachten Sie bitte, dass Trainer/innen und Personen mit geeigneten Rechten anzeigen können, welche Teilnehmer/innen die Board-Beiträge und Kommentare erstellt haben.';
$string['rate_note_text'] = 'Möchten Sie diesen Beitrag wirklich bewerten?';
$string['rate_note_title'] = 'Bestätigen';
$string['rate_remove_note_text'] = 'Möchten Sie die Bewertung von diesem Betrag wirklich entfernen?';
$string['ratings'] = 'Bewertungen';
$string['remove_column_text'] = 'Möchten Sie die Spalte \'{$a}\' und alle darin enthaltenen Beiträge wirklich löschen?';
$string['remove_column_title'] = 'Bestätigen';
$string['remove_note_text'] = 'Möchten Sie diesen Beitrag und alle darin enthaltenen Daten wirklich löschen? Dies wirkt sich auf alle Nutzer/innen aus.';
$string['remove_note_title'] = 'Bestätigen';
$string['selectuser'] = 'Nutzer/in auswählen';
$string['selectuserplease'] = 'Wählen Sie bitte Nutzer/in aus';
$string['settings:addattachmenttolog'] = 'Anhang zum Protokoll hinzufügen';
$string['settings:addcolumnnametolog'] = 'Spaltenname zum Protokoll hinzufügen';
$string['settings:addcommenttolog'] = 'Kommentar zum Protokoll hinzufügen';
$string['settings:addheadingtolog'] = 'Überschrift zum Protokoll hinzufügen';
$string['settings:addnotetolog'] = 'Notiz zum Protokoll hinzufügen';
$string['settings:addratingtolog'] = 'Bewertung zum Protokoll hinzufügen';
$string['settings:enableprivacystatement'] = 'Datenschutzhinweis aktivieren';
$string['settings:enableprivacystatement_desc'] = 'Der Datenschutzhinweis wird zur Board-Beschreibung hinzugefügt.';
$string['settings_heading_logging'] = 'Protokollierung';
$string['settings_heading_logging_info'] = 'Standardmäßig enthält die Protokollierung Inhalte, z.B. den Text einer Notiz, Kommentare, Spaltennamen usw. <br>Aus Datenschutzgründen kann die Protokollierung so konfiguriert werden, dass manche Informationen ausgeschlossen sind.';
$string['singleusermode'] = 'Einzelnutzermodus';
$string['singleusermode_desc'] = 'Im Einzelnutzermodus können Nutzer/innen nur Beiträge auf ihrem eigenen Board hinzufügen. Wenn die Option "privat" ist, können Nutzer/innen die Boards anderer Nutzer/innen nicht sehen. Wenn die Option "öffentlich" ist,  sind die Boards aller Nutzer/innen über ein Dropdown-Menü zugänglich.';
$string['singleusermodenone'] = 'Deaktiviert';
$string['singleusermodenotembed'] = 'Board lässt nicht zu, dass ein Board im Einzelnutzermodus eingebettet wird. Ändern Sie bitte Ihre Einstellungen.';
$string['singleusermodeprivate'] = 'Einzelnutzermodus (privat)';
$string['singleusermodepublic'] = 'Einzelnutzermodus (öffentlich)';
$string['sortby'] = 'Sortiert nach';
$string['sortbydate'] = 'Erstellungsdatum';
$string['sortbynone'] = 'Keine';
$string['sortbyrating'] = 'Bewertung';
$string['userscanedit'] = 'Teilnehmer/innen erlauben, die Platzierung ihrer eigenen Beiträge zu bearbeiten.';
$string['viewboard'] = 'Board-Aktivität anzeigen';
$string['warning'] = 'Benachrichtigung';
