<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'sr_cr', version '4.2'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.block_myoverview.browseallcourses'] = 'Прегледајте све курсеве';
$string['addon.block_myoverview.nocoursesenrolled'] = 'Још увек нисте уписани ни на један курс.';
$string['addon.block_myoverview.nocoursesenrolleddescription'] = 'Прегледајте све доступне курсеве и започните са учењем.';
$string['addon.block_myoverview.noresult'] = 'Ваша претрага се не подудара ни са једним курсом.';
$string['addon.block_myoverview.noresultdescription'] = 'Покушајте да прилагодите своје филтере или прегледајте све курсеве.';
$string['addon.blog.errorloadentries'] = 'Грешка приликом учитавања блог чланака.';
$string['addon.blog.showonlyyourentries'] = 'Прикажите само своје чланке';
$string['addon.calendar.calendarevent'] = 'Догађај у календару';
$string['addon.calendar.calendarevents'] = 'Догађаји у календару';
$string['addon.calendar.calendarreminders'] = 'Подсетници у календару';
$string['addon.calendar.currentmonth'] = 'Текући месец';
$string['addon.calendar.defaultnotificationtime'] = 'Подразумевано време за слање обавештења';
$string['addon.calendar.errorloadevent'] = 'Грешка приликом учитавања догађаја.';
$string['addon.calendar.errorloadevents'] = 'Грешка приликом учитавања догађаја.';
$string['addon.calendar.monthlyview'] = 'Месечни преглед';
$string['addon.calendar.noevents'] = 'Нема догађаја';
$string['addon.calendar.reminders'] = 'Подсетници';
$string['addon.calendar.setnewreminder'] = 'Подесите нови подсетник';
$string['addon.calendar.timebefore'] = '{{value}} {{units}} пре';
$string['addon.competency.errornocompetenciesfound'] = 'Није пронађена ниједна компетенција';
$string['addon.competency.nocompetencies'] = 'Нема компетенција';
$string['addon.coursecompletion.complete'] = 'Заврши';
$string['addon.coursecompletion.couldnotloadreport'] = 'Није могуће учитати извештај о завршетку курса. Молимо вас, покушајте поново касније.';
$string['addon.enrol_self.confirmselfenrol'] = 'Да ли сте сигурни да желите да се упишете на овај курс?';
$string['addon.enrol_self.errorselfenrol'] = 'Дошло је до грешке приликом самосталног уписа.';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Конфигуриши уређаје';
$string['addon.messageoutput_airnotifier.pushdisabledwarning'] = 'Вашим корисницима на њихове мобилне уређаје не стижу никаква обавештења са овог сајта. Укључите слање обавештења на мобилне уређаје на страници за подешавања обавештења.';
$string['addon.messages.contactlistempty'] = 'Списак особа за контакт је празан';
$string['addon.messages.contactname'] = 'Име особе за контакт';
$string['addon.messages.deletemessage'] = 'Обриши поруку';
$string['addon.messages.deletemessageconfirmation'] = 'Да ли сигурни да желите да обришете ову поруку? Она ће бити избрисан само из ваше историје порука али ће и даље бити видљива кориснику који је послао или примио поруку.';
$string['addon.messages.errordeletemessage'] = 'Грешка приликом брисања поруке.';
$string['addon.messages.errorwhileretrievingcontacts'] = 'Грешка приликом преузимања контаката са сервера.';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'Грешка приликом преузимања дискусија са сервера.';
$string['addon.messages.errorwhileretrievingmessages'] = 'Грешка приликом преузимања порука са сервера.';
$string['addon.messages.errorwhileretrievingusers'] = 'Грешка приликом преузимања корисника са сервера.';
$string['addon.messages.messagenotsent'] = 'Порука није послата. Молимо вас, покушајте поново касније.';
$string['addon.messages.newmessages'] = 'Нове поруке';
$string['addon.messages.nousersfound'] = 'Није пронађен ниједан корисник';
$string['addon.messages.showdeletemessages'] = 'Прикажи брисање порука';
$string['addon.messages.type_blocked'] = 'Блокиран';
$string['addon.messages.type_offline'] = 'Офлајн';
$string['addon.messages.type_online'] = 'Онлајн';
$string['addon.messages.type_search'] = 'Резултати претраге';
$string['addon.messages.type_strangers'] = 'Други';
$string['addon.messages.useentertosenddescdesktop'] = 'Ако је онемогућено, можете користити комбинацију тастера Ctrl+Enter да бисте послали поруку.';
$string['addon.messages.useentertosenddescmac'] = 'Ако је онемогућено, можете користити комбинацију тастера Cmd+Enter да бисте послали поруку.';
$string['addon.messages.warningconversationmessagenotsent'] = 'Није могуће послати поруку(е) у преписку {{conversation}}. {{error}}';
$string['addon.messages.warningmessagenotsent'] = 'Није могуће послати поруку(е) кориснику {{user}}. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'Молимо вас да прихватите изјаву о предаји рада.';
$string['addon.mod_assign.allowsubmissionsanddescriptionfromdatesummary'] = 'Детаљи о задатку и oбразац за предају рада ће бити доступни од <strong>{{$a}}</strong>';
$string['addon.mod_assign.allowsubmissionsfromdatesummary'] = 'Овај задатак ће прихватити предате радове од <strong>{{$a}}</strong>';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'Не можете да додате или мењате рад у апликацији јер изјава о предатом раду не може да се преузме са сајта.';
$string['addon.mod_assign.cannotgradefromapp'] = 'Апликације још увек не подржава одређене методе оцењивања и оне се не могу мењати.';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'Не можете да предате рад на оцењивање у апликацији јер ниjе било могуће преузети са сајта изјаву о предаји рада.';
$string['addon.mod_assign.duedateno'] = 'Без крајњег рока';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'Не можете да додате или мењате рад у апликацији јер неки додаци још увек немају подршку за уређивање.';
$string['addon.mod_assign.errorshowinginformation'] = 'Није могуће приказати информације о предатом раду.';
$string['addon.mod_assign.feedbacknotsupported'] = 'Апликација не подржава ове повратне информације. Могуће је да оне не садржи све информације.';
$string['addon.mod_assign.gradenotsynced'] = 'Оцена није синхронизована';
$string['addon.mod_assign.notallparticipantsareshown'] = 'Учесници који нису предали рад нису приказани.';
$string['addon.mod_assign.numberofdraftsubmissionscountdescription'] = 'Број радних верзија: {{count}}';
$string['addon.mod_assign.numberofparticipantscountdescription'] = 'Број учесника: {{count}}';
$string['addon.mod_assign.numberofsubmissionsneedgradingcountdescription'] = 'Број предатих радова које треба оценити: {{count}}';
$string['addon.mod_assign.numberofsubmittedassignmentscountdescription'] = 'Број предатих задатака (радова): {{count}}';
$string['addon.mod_assign.numberofteamscountdescription'] = 'Број тимова: {{count}}';
$string['addon.mod_assign.submissionnotsupported'] = 'Апликација не подржава овај предати рад. Могуће је да рад не садржи све информације.';
$string['addon.mod_assign.syncblockedusercomponent'] = 'оцена корисника';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'Оцена предатог рада је измењена на сајту.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'Предати рад корисника је измењен на сајту.';
$string['addon.mod_chat.confirmloss'] = 'Јесте ли сигурни? Историја сесије у \'Причаоница\' може бити изгубљена.';
$string['addon.mod_chat.errorwhileconnecting'] = 'Грешка приликом повезивања са причаоницом.';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'Грешка приликом преузимања података за \'Причаоницу\'.';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'Грешка приликом преузимања корисника причаонице.';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'Грешка приликом преузимања порука са сервера.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'Грешка приликом слања поруке.';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Морате бити онлајн како бисте слали поруке.';
$string['addon.mod_chat.nosessionsfound'] = 'Није пронађена ниједна сесија';
$string['addon.mod_chat.showincompletesessions'] = 'Прикажи непотпуне сесије';
$string['addon.mod_choice.errorgetchoice'] = 'Грешка приликом преузимања података за \'Избор\'';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% корисника је изабрало опцију: {{text}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'Ваш последњи одговор мора бити синхронизован пре него што буде укључен у резултате.';
$string['addon.mod_data.edittagsnotsupported'] = 'Жао нам је, апликација не подржава уређивање ознака.';
$string['addon.mod_data.errorapproving'] = 'Грешка приликом одобравања или одбијања уноса.';
$string['addon.mod_data.errordeleting'] = 'Грешка приликом брисања уноса.';
$string['addon.mod_data.gettinglocation'] = 'Добијање локације';
$string['addon.mod_data.locationnotenabled'] = 'Одређивање локације није омогућено';
$string['addon.mod_data.locationpermissiondenied'] = 'Дозвола за приступ вашој локацији је одбијена.';
$string['addon.mod_data.mylocation'] = 'Моја локација';
$string['addon.mod_data.searchbytagsnotsupported'] = 'Жао нам је, апликација не подржава претрагу по ознакама.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'Упитник са Captcha елементом не може да буде завршен ако није конфигурисан, ако сте у офлајн режиму или ако је сервер искључен.';
$string['addon.mod_feedback.completedfeedbackscountdescription'] = 'Број послатих одговора: {{count}}';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'Овај упитник је сачуван како би касније био предат.';
$string['addon.mod_feedback.questionscountdescription'] = 'Број питања: {{count}}';
$string['addon.mod_folder.emptyfilelist'] = 'Нема датотека за приказ.';
$string['addon.mod_forum.errorgetforum'] = 'Грешка при преузимању података форума.';
$string['addon.mod_forum.errorgetgroups'] = 'Грешка приликом преузимања подешавања група.';
$string['addon.mod_forum.errorloadingsortingorder'] = 'Форум није доступан у овом редоследу сортирања';
$string['addon.mod_forum.errorloadingsortingorderdetails'] = 'Покушајте да промените редослед сортирања или идите на сајт како бисте видели овај форум.';
$string['addon.mod_forum.errorposttoallgroups'] = 'Није могуће креирати нову дискусију у свим групама.';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'Још увек нема дискусија на овом форуму.';
$string['addon.mod_forum.group'] = 'Група';
$string['addon.mod_forum.numdiscussions'] = 'Број дискусија: {{numdiscussions}}';
$string['addon.mod_forum.numreplies'] = 'Број одговора: {{numreplies}}';
$string['addon.mod_forum.postingroup'] = 'Слање порука у групи "{{groupname}}".';
$string['addon.mod_forum.refreshposts'] = 'Освежи постове';
$string['addon.mod_glossary.browsemode'] = 'Прегледај појмове';
$string['addon.mod_glossary.byalphabet'] = 'Азбучним редом';
$string['addon.mod_glossary.byauthor'] = 'Групиши по аутору';
$string['addon.mod_glossary.bycategory'] = 'Групиши по категорији';
$string['addon.mod_glossary.bynewestfirst'] = 'Најновији прво';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Недавно ажурирани';
$string['addon.mod_glossary.bysearch'] = 'Претражи';
$string['addon.mod_glossary.cannoteditentry'] = 'Не можете да уређујете појам';
$string['addon.mod_glossary.entriestobesynced'] = 'Појмови за синхронизацију';
$string['addon.mod_glossary.entrypendingapproval'] = 'Овај појам чека одобрење.';
$string['addon.mod_glossary.errordeleting'] = 'Грешка приликом брисања појма.';
$string['addon.mod_glossary.errorloadingentries'] = 'Дошло је до грешке приликом учитавања појмова.';
$string['addon.mod_glossary.errorloadingentry'] = 'Дошло је до грешке приликом учитавања појма.';
$string['addon.mod_glossary.errorloadingglossary'] = 'Дошло је до грешке приликом учитавања речника.';
$string['addon.mod_glossary.noentriesfound'] = 'Није пронађен ниједан појам.';
$string['addon.mod_glossary.searchquery'] = 'Упит за претрагу';
$string['addon.mod_h5pactivity.downloadh5pfile'] = 'Преузмите H5P датотеку';
$string['addon.mod_h5pactivity.errorgetactivity'] = 'Грешка приликом преузимању података о H5P активности.';
$string['addon.mod_h5pactivity.filestatenotdownloaded'] = 'H5P пакет није преузет. Морате да га преузмете да бисте могли да га користите.';
$string['addon.mod_h5pactivity.filestateoutdated'] = 'H5P пакет је измењен од последњег преузимања. Морате га поново преузети како бисте могли да га користите.';
$string['addon.mod_h5pactivity.offlinedisabledwarning'] = 'Морате бити онлајн како бисте видели H5P пакет.';
$string['addon.mod_h5pactivity.viewattempt'] = 'Прегледајте покушај {{$a}}';
$string['addon.mod_imscp.showmoduledescription'] = 'Прикажи опис';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'Ова лекција садржи прелаз на наусимично одабрану страницу са садржајем, па је није могуће урадити у апликацији док се не покрене у веб читачу.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'Ова покушај не може више бити прегледан зато што је завршен други покушај.';
$string['addon.mod_lesson.finishretakeoffline'] = 'Овај покушај је завршен у офлајн режиму.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'Офлајн покушај је синхронизован. Да ли желите да га прегледате?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'Покушај је завршен на веб сајту.';
$string['addon.mod_lti.errorgetlti'] = 'Грешка приликом преузимања података модула.';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'Иницијална URL адреса није исправна.';
$string['addon.mod_lti.launchactivity'] = 'Покрени активност';
$string['addon.mod_page.errorwhileloadingthepage'] = 'Грешка приликом учитавања садржаја странице.';
$string['addon.mod_quiz.canattemptbutnotsubmit'] = 'Можете покушати да решите овај тест у апликацији, али ћете свој покушај решавања морати да пошаљете путем веб читача, због следећих разлога:';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'Овај покушај решавања теста не може да буде предат због следећих разлога:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'Овај покушај није синхронизован од {{$a}}. Ако сте у међувремену овај покушај наставили  на неком другом уређају, постоји могућност да сте изгубили податке.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'Дошло је до грешке приликом покушаја да се сачувају одговори. Да ли сте сигурни да желите да напустите тест?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'Овај тест не можете решавати у апликацији зато што она не подржава понашање питања:';
$string['addon.mod_quiz.errordownloading'] = 'Грешка приликом преузимања неопходних података.';
$string['addon.mod_quiz.errorgetattempt'] = 'Грешка приликом преузимања података о покушају решавања теста.';
$string['addon.mod_quiz.errorgetquestions'] = 'Грешка приликом преузимања питања.';
$string['addon.mod_quiz.errorgetquiz'] = 'Грешка приликом преузимања података теста.';
$string['addon.mod_quiz.errorparsequestions'] = 'Дошло је до грешке приликом учитавања питања. Молимо, покушајте да решите овај тест у веб читачу.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'Овај тест се не може решавати у апликацији зато што садржи питања које апликација не подржава:';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'Овај тест се не може решавати у апликацији зато што садржи правила за приступ које апликација не подржава:';
$string['addon.mod_quiz.errorsaveattempt'] = 'Дошло је до грешке приликом снимања података о покушају решавања теста.';
$string['addon.mod_quiz.finishedofflinenotice'] = 'Ваш покушај решавања теста је послат и сачуван. На сајт ће бити послат када поново будете онлајн.';
$string['addon.mod_quiz.finishnotsynced'] = 'Тест је завршен, али није синхронизован';
$string['addon.mod_quiz.opentoc'] = 'Отвори искачући прозор са навигацијом.';
$string['addon.mod_quiz.warningattemptfinished'] = 'Офлајн покушај је одбачен зато што је или завршен на сајту или није пронађен.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'Неки офлајн одговори су одбачени зато што су питања измењена онлајн.';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'Покушај решавања теста је није завршен зато што су неки офлајн одговори одбачени. Прегледајте своје одговоре, а затим поново пошаљите свој покушај.';
$string['addon.mod_quiz.warningquestionsnotsupported'] = 'Овај тест садржи питања која апликација не подржава:';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'Грешка приликом учитавања садржаја.';
$string['addon.mod_resource.openthefile'] = 'Отвори';
$string['addon.mod_resource.resourcestatusoutdated'] = 'Ова датотека се променила од када сте је последњи пут отворили.';
$string['addon.mod_resource.resourcestatusoutdatedconfirm'] = 'Постоји новија верзија ове датотеке. Да бисте је видели, повежите свој уређај на интернет.';
$string['addon.mod_scorm.cannotcalculategrade'] = 'Оцена не може да се израчуна.';
$string['addon.mod_scorm.dataattemptshown'] = 'Ови подаци припадају покушају број {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'Дошло је до грешке приликом покушаја креирања новог офлајн покушаја. Молимо, покушајте поново.';
$string['addon.mod_scorm.errordownloadscorm'] = 'Грешка приликом преузимања SCORM пакета: "{{name}}".';
$string['addon.mod_scorm.errorgetscorm'] = 'Грешка приликом преузимања података SCORM пакета.';
$string['addon.mod_scorm.errorinvalidversion'] = 'Жао нам је, апликација подржава само SCORM 1.2.';
$string['addon.mod_scorm.errornotdownloadable'] = 'Особа која је одговорна у вашој институцији (школи/организацији).
је онемогућила преузимање SCORM пакета.';
$string['addon.mod_scorm.errornovalidsco'] = 'Овај SCORM пакет нема видљив SCO који би био учитан.';
$string['addon.mod_scorm.errorpackagefile'] = 'Жао нам је, апликација подржава само ZIP архиве.';
$string['addon.mod_scorm.errorsyncscorm'] = 'Дошло је до грешке приликом синхронизације. Молимо, покушајте поново.';
$string['addon.mod_scorm.offlineattemptnote'] = 'Овај покушај има податке који нису синхронизован.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Овај покушај не може бити послат зато што сте премашили максималан број дозвољених покушаја.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'Овај SCORM пакет није преузет. Биће аутоматски преузет када га отворите.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'Овај SCORM пакет је мењан од последњег преузимања. Биће аутоматски преузет када га отворите.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'Неки офлајн подаци о покушају  {{number}} су одбачени зато што се не могу рачунати као нови покушај.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Неки покушаји нису могли бити синхронизовани са сајтом зато што последњи онлајн покушај није завршен. Молимо вас да прво завршите онлајн покушај.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'Жао нам је, било је проблема са предајом вашег упитника. Молим вас, покушајте поново.';
$string['addon.mod_survey.errorgetsurvey'] = 'Грешка приликом преузимања података за \'Упитник\' (Survey)';
$string['addon.mod_survey.results'] = 'Резултати';
$string['addon.mod_url.accessurl'] = 'Приступите URL адреси';
$string['addon.mod_url.pointingtourl'] = 'URL адреса са којом је овај ресурс повезан.';
$string['addon.mod_wiki.errorloadingpage'] = 'Дошло је до грешке приликом учитавања странице.';
$string['addon.mod_wiki.errornowikiavailable'] = 'Овај вики још увек нема никакав садржај.';
$string['addon.mod_wiki.gowikihome'] = 'Иди на почетну страницу викија';
$string['addon.mod_wiki.subwiki'] = 'Подвики';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'Наслов се мора унети';
$string['addon.mod_wiki.viewpage'] = 'Погледај страницу';
$string['addon.mod_wiki.wikipage'] = 'Вики страница';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'Стратегија процене {{$a}} није подржана';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'Морате да унесете наслов.';
$string['addon.mod_workshop.warningassessmentmodified'] = 'Предати рад је измењен на сајту.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'Процена је измењена на сајту.';
$string['addon.notes.warningnotenotsent'] = 'Није могуће додати или обрисати белешку/е курсу {{course}}. {{error}}';
$string['addon.notifications.allownotifications'] = 'Дозволи обавештења';
$string['addon.notifications.errorgetnotifications'] = 'Грешка приликом преузимања обавештења.';
$string['addon.notifications.notifications'] = 'Обавештења';
$string['addon.notifications.playsound'] = 'Репродукуј звук';
$string['addon.notifications.therearentnotificationsyet'] = 'Нема обавештења.';
$string['addon.notifications.typeofnotification'] = 'Врста обавештења';
$string['addon.privatefiles.couldnotloadfiles'] = 'Није могуће учитати списак датотека.';
$string['addon.privatefiles.emptyfilelist'] = 'Нема датотека за приказ.';
$string['addon.privatefiles.erroruploadnotworking'] = 'Нажалост, тренутно није могуће отпремити датотеке на ваш сајт.';
$string['addon.storagemanager.confirmdeleteallsitedata'] = 'Желите ли да обришете све податке преузете са сајта?';
$string['addon.storagemanager.confirmdeletecourses'] = 'Желите ли да обришете податке преузете са свих курсева?';
$string['addon.storagemanager.confirmdeletedatafrom'] = 'Желите ли да обришете све податке преузете са \'{{name}}\'?';
$string['addon.storagemanager.coursedownloads'] = 'Преузимања курсева';
$string['addon.storagemanager.courseinfo'] = 'Преузмите садржај курса како бисте могли да радите офлајн. Ваша активност ће се аутоматски синхронизовати када ваш уређај поново буде онлајн.';
$string['addon.storagemanager.deleteallsitedata'] = 'Обришете све податке преузете са сајта';
$string['addon.storagemanager.deleteallsitedatainfo'] = 'Ово ће обрисати све податке преузете са \'{{name}}\', укључујући све преузете курсеве и податке који вам омогућавају да радите офлајн.';
$string['addon.storagemanager.deletecourses'] = 'Обришете податке преузете са свих курсева';
$string['addon.storagemanager.deletedata'] = 'Обришите преузете податке';
$string['addon.storagemanager.deletedatafrom'] = 'Обришете све податке преузете са \'{{name}}\'';
$string['addon.storagemanager.downloadedcourses'] = 'Преузети курсеви';
$string['addon.storagemanager.downloads'] = 'Преузимања';
$string['addon.storagemanager.errordeletedownloadeddata'] = 'Грешка приликом брисања преузетих података.';
$string['addon.storagemanager.managedownloads'] = 'Управљање преузимањима';
$string['addon.storagemanager.totaldownloads'] = 'Укупан број преузимања';
$string['addon.storagemanager.totalspaceusage'] = 'Укупан искоришћен простор';
$string['appstoredescription'] = 'НАПОМЕНА: Ова званична Moodle Mobile ће радити САМО са оним Moodle сајтовима који су подешени тако да то омогућавају. Ако имате проблема са повезивањем, обратите се администратору вашег Moodle сајта.

Ако је ваш Moodle сајт исправно конфигурисан, ову апликацију можете користити како бисте:

- прегледали садржаје својих курсева, чак и када сте офлајн
- примали тренутна обавештења о порукама и другим догађајима
- брзо пронашли и контактирали друге полазнике на својим курсевима
- отпремали слике, аудио, видео и друге датотеке са свог мобилног уређаја
- видели своје оцене на курсу
- и још много тога!

За све најновије информације молимо вас, погледајте http://docs.moodle.org/en/Mobile_app

Заиста бисмо волели да чујемо ваше коментаре о постојећим функционалностима, као и сугестије о томе шта још желите да ова апликација ради!

Апликација захтева следећа овлашћење:
Снимање звука - за снимање звука и отпремање снимка на Moodle
Читање и модификовање садржаја ваше SD картице - садржаји се преузимају на SD картицу вашег телефона тако да можете да их видите и када се у офлајн режиму
Приступ мрежи - како бисте могли да се повежете са својим Moodle сајтом и проверите да ли сте повезани или не (и у том случају се пребаците у офлајн режим)
Извршавање при покретању - тако да можете да примате локална обавештења чак и када апликација ради у позадини
Спречавања да мобилни телефон уђе у режим мировања - тако да можете да примите обавештења у било ком тренутку';
$string['assets.mimetypes.application/vnd.apple.keynote'] = 'Apple Keynote презентација';
$string['assets.mimetypes.application/vnd.apple.numbers'] = 'Apple Numbers радна табела';
$string['assets.mimetypes.application/vnd.apple.pages'] = 'Apple Pages документ';
$string['assets.mimetypes.application/vnd.google-apps.audio'] = 'Google Drive аудио';
$string['assets.mimetypes.application/vnd.google-apps.document'] = 'Google Docs';
$string['assets.mimetypes.application/vnd.google-apps.drawing'] = 'Google Drawing';
$string['assets.mimetypes.application/vnd.google-apps.file'] = 'Google Drive датотека';
$string['assets.mimetypes.application/vnd.google-apps.folder'] = 'Google Drive директоријум';
$string['assets.mimetypes.application/vnd.google-apps.form'] = 'Google Forms';
$string['assets.mimetypes.application/vnd.google-apps.fusiontable'] = 'Google Fusion Tables';
$string['assets.mimetypes.application/vnd.google-apps.presentation'] = 'Google Slides';
$string['assets.mimetypes.application/vnd.google-apps.script'] = 'Google Apps Scripts';
$string['assets.mimetypes.application/vnd.google-apps.site'] = 'Google Sites';
$string['assets.mimetypes.application/vnd.google-apps.spreadsheet'] = 'Google Sheets';
$string['assets.mimetypes.application/vnd.google-apps.video'] = 'Google Drive видео';
$string['core.ajaxendpointnotfound'] = 'AJAX крајња тачка није пронађена. Ово се може догодити ако је Moodle сајт исувише стар или ако блокира приступ овој крајњој тачки. Moodle апликација подржава само Moodle системе {{$a}} и новије.';
$string['core.browser'] = 'Веб читач';
$string['core.calculating'] = 'Израчунавање';
$string['core.cannotconnect'] = 'Није могуће повезати се сајтом';
$string['core.cannotdownloadfiles'] = 'Особа која је одговорна у вашој институцији (школи/организацији).
је онемогућила преузимање датотека.';
$string['core.cannotinstallapk'] = 'Није могуће инсталирати .apk датотеке';
$string['core.cannotinstallapkinfo'] = 'Из безбедносних разлога, не можете да инсталирате непознате апликације на свој уређај из ове апликације. Ако и даље желите да наставите са инсталацијом, потребно је да отворите апликацију у претраживачу.';
$string['core.cannotlogoutpageblocks'] = 'Сачувајте или одбаците промене пре него што наставите.';
$string['core.cannotopeninapp'] = 'Ова датотека можда неће радити како се очекује на овом уређају. Да ли бисте ипак желели да је отворите?';
$string['core.cannotopeninappdownload'] = 'Ова датотека можда неће радити како се очекује на овом уређају. Да ли бисте ипак желели да је преузмете?';
$string['core.captureaudio'] = 'Сними аудио';
$string['core.capturedimage'] = 'Сликано.';
$string['core.captureimage'] = 'Усликај';
$string['core.capturevideo'] = 'Сними видео';
$string['core.certificaterror'] = 'Ваш уређај не може препозна сертификат овога сајта (сматра га  ризичним): {{details}}';
$string['core.clearsearch'] = 'Обриши претрагу';
$string['core.clearstoreddata'] = 'Очисти складиште {{$a}}';
$string['core.clicktoseefull'] = 'Кликните како бисте видели комплетан садржај.';
$string['core.comments.commentsnotworking'] = 'Коментари се не могу преузети';
$string['core.comments.warningcommentsnotsent'] = 'Није могуће синхронизовати коментаре. {{error}}';
$string['core.confirmcanceledit'] = 'Да ли сте сигурни да желите да напустите ову страницу? Све промене ће бити изгубљене.';
$string['core.confirmleaveunknownchanges'] = 'Да ли сте сигурни да желите да напустите ову страницу? Ако имате промене које нису сачуване, оне ће бити изгубљене.';
$string['core.confirmloss'] = 'Да ли сте сигурни? Све промене ће бити изгубљене.';
$string['core.confirmopeninbrowser'] = 'Да ли желите да отворите у веб читачу?';
$string['core.connectionlost'] = 'Веза са сајтом је изгубљена';
$string['core.contactsupport'] = 'Обратите се подршци';
$string['core.contactverb'] = 'Контакт';
$string['core.contenteditingsynced'] = 'Садржај који уређујете је синхронизован.';
$string['core.contentlinks.chooseaccount'] = 'Изабери налог';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Изаберите налог са којим треба отворити линк.';
$string['core.contentlinks.confirmurlothersite'] = 'Овај линк припада другом сајту. Да ли желите да га отворите?';
$string['core.contentlinks.errornoactions'] = 'Није могуће пронаћи акцију коју треба извести са овим линком.';
$string['core.contentlinks.errornosites'] = 'Није могуће пронаћи ниједан сајт за овај линк.';
$string['core.contentlinks.errorredirectothersite'] = 'URL адреса за преусмеравање не може да упућује на други сајт.';
$string['core.copiedtoclipboard'] = 'Текст копиран у клипборд';
$string['core.copytoclipboard'] = 'Копирај у клипборд';
$string['core.course.activitydisabled'] = 'Ваша институција је онемогућила ову активност у мобилној апликацији.';
$string['core.course.activitynotyetviewableremoteaddon'] = 'Ваша институција је инсталирала додатак који још увек није подржан.';
$string['core.course.allsections'] = 'Све секције';
$string['core.course.aria:sectionprogress'] = 'Напредак унутар секције:';
$string['core.course.availablespace'] = 'Тренутно имате око {{available}} слободног простора.';
$string['core.course.cannotdeletewhiledownloading'] = 'Датотеке се не могу обрисати док се активност преузима. Сачекајте да се преузимање заврши.';
$string['core.course.confirmdownload'] = 'Намеравате да преузмете {{size}}.{{availableSpace}} Да ли сте сигурни да желите да наставите?';
$string['core.course.confirmdownloadunknownsize'] = 'Нисмо могли да израчунамо величину преузимање. {{availableSpace}} Да ли сте сигурни да желите да наставите?';
$string['core.course.confirmdownloadzerosize'] = 'Намеравате да започнете преузимање.{{availableSpace}} Да ли сте сигурни да желите да наставите?';
$string['core.course.confirmlimiteddownload'] = 'Тренутно нисте повезани на Wi-Fi.';
$string['core.course.confirmpartialdownloadsize'] = 'Намеравате да преузмете <strong>најмање</strong> {{size}}. {{availableSpace}} Да ли сте сигурни да желите да наставите?';
$string['core.course.couldnotloadsectioncontent'] = 'Није могуће учитати садржај секције. Покушајте поново касније.';
$string['core.course.couldnotloadsections'] = 'Није могуће учитати секције. Покушајте поново касније.';
$string['core.course.downloadcoursesprogressdescription'] = 'Преузимање курсева: преузето {{count}} од  укупно {{total}}.';
$string['core.course.downloadsectionprogressdescription'] = 'Преузимање секција: преузето {{count}} од  укупно {{total}}.';
$string['core.course.errordownloadingcourse'] = 'Грешка приликом преузимању курса.';
$string['core.course.errordownloadingsection'] = 'Грешка приликом преузимања секције.';
$string['core.course.errorgetmodule'] = 'Грешка приликом преузимања података модула.';
$string['core.course.insufficientavailablequota'] = 'Ваш уређај није могао да додели простор за чување овог преузетог садржаја. Можда је уређај резервисао простор за ажурирања апликација и система. Прво очистите нешто простора за складиштење.';
$string['core.course.insufficientavailablespace'] = 'Покушавате да преузмете {{size}}. Ово ће оставити ваш уређај са недовољно великим простором за нормалан рад. Прво очистите нешто простора за складиштење.';
$string['core.course.lastaccessedactivity'] = 'Последња активност којој је приступљено';
$string['core.course.manualcompletionnotsynced'] = 'Ручни завршетак није синхронизован.';
$string['core.course.modulenotfound'] = 'Ресурс или активност нису пронађени. Проверите да ли сте онлајн и да ли су ресурс односно активност још увек доступни.';
$string['core.course.nextactivity'] = 'Следећа активност';
$string['core.course.nextactivitynotfound'] = 'Следећа активност није пронађена. Могуће је да је сакривена или обрисана.';
$string['core.course.nocontentavailable'] = 'Никакав садржај није доступан у овом тренутку.';
$string['core.course.previousactivity'] = 'Претходна активност';
$string['core.course.previousactivitynotfound'] = 'Претходна активност није пронађена. Могуће је да је сакривена или обрисана.';
$string['core.course.refreshcourse'] = 'Освежи курс';
$string['core.course.useactivityonbrowser'] = 'Још увек можете да користите активност (ресурс) помоћу веб читача вашег уређаја.';
$string['core.course.warningmanualcompletionmodified'] = 'Ручни завршетак активности је измењен на сајту.';
$string['core.course.warningofflinemanualcompletiondeleted'] = 'Неки офлајн ручни завршеци курса \'{{name}}\' су обрисани. {{error}}';
$string['core.coursenogroups'] = 'Нисте члан ниједне групе на овом курсу.';
$string['core.courses.browserenrolinstructions'] = 'Преусмерићемо вас на веб читач вашег уређаја. Када завршите свој упис, вратите се у ову апликацију.';
$string['core.courses.cannotretrievemorecategories'] = 'Категорије које су испод нивоа {{$a}} не могу се преузети.';
$string['core.courses.completeenrolmentbrowser'] = 'Завршите упис у веб читачу';
$string['core.courses.confirmselfenrol'] = 'Да ли сте сигурни да желите да се упишете на овај курс?';
$string['core.courses.downloadcourses'] = 'Преузмите све курсеве';
$string['core.courses.enrolme'] = 'Упиши ме';
$string['core.courses.errorloadcategories'] = 'Дошло је до грешке приликом учитавања категорија.';
$string['core.courses.errorloadcourses'] = 'Дошло је до грешке приликом учитавања курсева.';
$string['core.courses.errorloadplugins'] = 'Додаци потребни за овај курс нису могли правилно да се учитају. Поново покрените апликацију како бисте покушали поново да учитате додатке.';
$string['core.courses.errorsearching'] = 'Дошло је до грешке приликом претраживања.';
$string['core.courses.errorselfenrol'] = 'Дошло је до грешке приликом покушаја самосталног уписа.';
$string['core.courses.filtermycourses'] = 'Филтрирај моје курсеве';
$string['core.courses.notenrollable'] = 'Не можете сами да се упишете на овај курс.';
$string['core.courses.otherenrolments'] = 'Остали уписи';
$string['core.courses.password'] = 'Приступна лозинка курса';
$string['core.courses.refreshcourses'] = 'Освежите курсеве';
$string['core.courses.searchcoursesadvice'] = 'Можете користити дугме за претрагу курсева како бисте им приступили као гост или се сами уписали на оне који то допуштају.';
$string['core.courses.selfenrolment'] = 'Самостални упис';
$string['core.courses.showonlyenrolled'] = 'Прикажи само моје курсеве';
$string['core.courses.totalcoursesearchresults'] = 'Укупно курсева: {{$a}}';
$string['core.currentdevice'] = 'Тренутни уређај';
$string['core.datastoredoffline'] = 'Подаци су сачувани у мобилном уређају, зато што не могу да се пошаљу. Аутоматски ће бити послати касније.';
$string['core.deletedoffline'] = 'Обрисано офлајн';
$string['core.deleting'] = 'Брисање';
$string['core.desktop'] = 'Стони рачунар';
$string['core.dfdaymonthyear'] = 'MM-DD-YYYY';
$string['core.dfdayweekmonth'] = 'ddd, D MMM';
$string['core.dffulldate'] = 'dddd, D MMMM YYYY h[:]mm A';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm A';
$string['core.discard'] = 'Одбаци';
$string['core.dismiss'] = 'Обустави';
$string['core.dontshowagain'] = 'Не приказуј поново.';
$string['core.downloaded'] = 'Преузето';
$string['core.downloading'] = 'Преузимање';
$string['core.editor.hidetoolbar'] = 'Сакриј траку са алаткама';
$string['core.editor.toggle'] = 'Укључи/искључи едитор';
$string['core.emptysplit'] = 'Ова страница ће се појавити празна уколико је леви панел празан или се учитава.';
$string['core.endingtime'] = 'Време завршетка: {{$a}}';
$string['core.errorchangecompletion'] = 'Дошло је до грешке приликом промене статуса завршетка. Молимо, покушајте поново.';
$string['core.errorcode'] = 'Кôд грешке: {{errorCode}}';
$string['core.errordeletefile'] = 'Грешка приликом брисања датотеке. Молимо, покушајте поново.';
$string['core.errordetailshide'] = 'Сакриј податке о грешци';
$string['core.errordetailsshow'] = 'Прикажи податке о грешци';
$string['core.errordownloading'] = 'Грешка приликом преузимања датотеке.';
$string['core.errordownloadingsomefiles'] = 'Грешка приликом преузимања датотека модула. Могуће је да неке датотеке недостају.';
$string['core.errorfileexistssamename'] = 'Већ постоји датотека са овим називом.';
$string['core.errorinvalidform'] = 'Образац садржи неисправне податке. Проверите да ли сте попунили сва неопходна поља и да ли су подаци исправни.';
$string['core.errorinvalidresponse'] = 'Неочекивани одговор за {{method}} веб-сервис.';
$string['core.errorloadingcontent'] = 'Грешка приликом учитавању садржаја.';
$string['core.errorofflinedisabled'] = 'Офлајн прегледање је онемогућено на вашем сајту. Морате бити повезани на интернет да бисте користили апликацију.';
$string['core.erroropenfiledownloading'] = 'Грешка приликом отварања датотеке: потребно је да сачекате да се преузимање заврши.';
$string['core.erroropenfilenoapp'] = 'Грешка приликом отварања датотеке: није пронађена апликација која може да отвори овај тип датотеке.';
$string['core.erroropenfilenoextension'] = 'Грешка приликом отварања датотеке: датотека нема екстензију.';
$string['core.erroropenpopup'] = 'Ова активност покушава да отвори искачући прозор. Ова апликација то не подржава.';
$string['core.errorrenamefile'] = 'Грешка приликом покушаја промене назива датотеке. Молимо, покушајте поново.';
$string['core.errorsitesupport'] = 'Ако проблем и даље постоји, обратите се подршци сајта.';
$string['core.errorsomedatanotdownloaded'] = 'Ако сте преузели ову активност, имајте на уму да се неки подаци не преузимају (током процеса преузимања) из разлога перформанси и коришћења података.';
$string['core.errorsomethingwrong'] = 'Нешто није у реду. Молим вас, покушајте поново.';
$string['core.errorsync'] = 'Дошло је до грешке приликом синхронизацији. Молимо, покушајте поново.';
$string['core.errorsyncblocked'] = '{{$a}} тренутно не може да се синхронизује због текућег процеса. Молимо, покушајте поново касније. Ако се проблем и даље буде јављао, покушајте поново да покренете апликацију.';
$string['core.errorurlschemeinvalidscheme'] = 'Ова URL адреса би требало да се користи у другој апликацији: {{$a}}.';
$string['core.errorurlschemeinvalidsite'] = 'URL адреса овог сајта не може да се отвори у овој апликацији.';
$string['core.exactalarmsturnedoff'] = 'Обавештења у реалном времену су искључена';
$string['core.exactalarmsturnedoffmessage'] = 'Да не бисте пропустили ниједно важно обавештење, укључите \'Аларми и подсетници\' у подешавањима свог мобилног уређаја.';
$string['core.filenameexist'] = 'Назив датотеке већ постоји: {{$a}}';
$string['core.fileuploader.audio'] = 'Аудио';
$string['core.fileuploader.camera'] = 'Камера';
$string['core.fileuploader.confirmuploadfile'] = 'Намеравате да отпремите {{size}}. Да ли сте сигурни да желите да наставите?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'Нисмо могли да израчунамо величину датотека за отпремање. Да ли сте сигурни да желите да наставите?';
$string['core.fileuploader.discardrecording'] = 'Одбаците снимак';
$string['core.fileuploader.errorcapturingaudio'] = 'Грешка приликом снимања аудио записа.';
$string['core.fileuploader.errorcapturingimage'] = 'Грешка приликом снимања слике.';
$string['core.fileuploader.errorcapturingvideo'] = 'Грешка приликом снимања видео записа.';
$string['core.fileuploader.errorgettingimagealbum'] = 'Грешка приликом преузимања слике из албума.';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Морате бити онлајн како бисте отпремили датотеке.';
$string['core.fileuploader.errornoapp'] = 'Немате инсталирану апликацију која може да обави ову радњу.';
$string['core.fileuploader.errorreadingfile'] = 'Грешка приликом учитавања датотеке.';
$string['core.fileuploader.errorwhileuploading'] = 'Дошло је до грешке приликом отпремања датотеке.';
$string['core.fileuploader.file'] = 'Датотека';
$string['core.fileuploader.fileuploaded'] = 'Датотека је успешно отпремљена.';
$string['core.fileuploader.maxbytesfile'] = 'Датотека {{$a.file}} је превелика. Максимална величина коју можете да отпремите је {{$a.size}}.';
$string['core.fileuploader.microphonepermissiondenied'] = 'Дозвола за приступ микрофону је одбијена.';
$string['core.fileuploader.microphonepermissionrestricted'] = 'Приступ микрофону је ограничен.';
$string['core.fileuploader.pauserecording'] = 'Паузирај снимање';
$string['core.fileuploader.photoalbums'] = 'Фото албуми';
$string['core.fileuploader.readingfile'] = 'Учитавање датотеке';
$string['core.fileuploader.readingfileperc'] = 'Учитавање датотеке: {{$a}}%';
$string['core.fileuploader.resumerecording'] = 'Настави снимање';
$string['core.fileuploader.selectafile'] = 'Изабери датотеку';
$string['core.fileuploader.startrecordinginstructions'] = 'Додирните да бисте започели снимање';
$string['core.fileuploader.uploadafile'] = 'Отпреми датотеку';
$string['core.fileuploader.uploading'] = 'Отпремање';
$string['core.fileuploader.uploadingperc'] = 'Отпремање: {{$a}}%';
$string['core.fileuploader.video'] = 'Видео';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.goto'] = 'Иди на {{$a}}';
$string['core.h5p.errorgetemail'] = 'Грешка приликом добављања е-поште корисника. Проверите своју везу и покушајте поново.';
$string['core.h5p.offlinedisabled'] = 'Сајт не дозвољава преузимање H5P пакета.';
$string['core.h5p.play'] = 'Репродукуј H5P';
$string['core.hasdatatosync'] = '{{$a}} има офлајн податке које треба синхронизовати.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.iframehelp'] = 'Да ли овај садржај не функционише?';
$string['core.image'] = 'Слика';
$string['core.imageviewer'] = 'Приказивач слике';
$string['core.ioscookieshelp'] = 'Уграђени садржај може захтевати колачиће да би функционисао. Идите на iOS подешавања апликације, омогућите подешавање \'Дозволи праћење на више веб сајтова\' (Allow Cross-Website Tracking\') и покушајте поново.';
$string['core.lastdownloaded'] = 'Последњи пут преузето';
$string['core.lastsync'] = 'Последња синхронизација';
$string['core.loadmore'] = 'Учитај још';
$string['core.login.authenticating'] = 'Провера идентитета';
$string['core.login.changepasswordbutton'] = 'Промени лозинку';
$string['core.login.changepasswordhelp'] = 'Ако имате проблема са променом лозинке, покушајте поново касније или се обратите особи која је одговорна у вашој институцији (школи/организацији).';
$string['core.login.changepasswordinstructions'] = 'Не можете променити лозинку у апликацији. Кликните на следеће дугме како бисте отворили сајт у веб читачу и променили своју лозинку. Узмите у обзир да ћете морати да затворите веб читач након промене лозинке, јер нећете бити аутоматски преусмерени на апликацију.';
$string['core.login.changepasswordlogoutinstructions'] = 'Ако желите да промените сајт или да се одјавите, кликните на следеће дугме:';
$string['core.login.changepasswordreconnectinstructions'] = 'Ако нисте исправно променили лозинку, од вас ће се тражити да то урадите поново.';
$string['core.login.changepasswordsupportsubject'] = 'Потребна ми је помоћ да променим лозинку';
$string['core.login.confirmdeletesite'] = 'Да ли сте сигурни да желите да уклоните налог на сајту {{sitename}}?';
$string['core.login.connect'] = 'Повежите се!';
$string['core.login.connecttomoodle'] = 'Повежите се са Moodleom';
$string['core.login.connecttomoodleapp'] = 'Покушавате да се повежете са Moodle сајтом. Преузмите званичну Moodle апликацију како бисте приступили овом сајту.';
$string['core.login.connecttoworkplaceapp'] = 'Покушавате да се повежете на Moodle Workplace сајт. Преузмите апликацију Moodle Workplace како бисте приступили овом веб сајту.';
$string['core.login.contactyouradministrator'] = 'Обратите се администратору вашег сајта за даљу помоћ.';
$string['core.login.contactyouradministratorissue'] = 'Замолите администратора да провери следећи проблем: {{$a}}';
$string['core.login.credentialsdescription'] = 'За пријаву на систем унесите своје корисничко име и лозинку.';
$string['core.login.credentialshelp'] = 'Ако имате проблема са пријавом на сајт, покушајте поново касније или се обратите особи која је одговорна у вашој институцији (школи/организацији).';
$string['core.login.credentialssupportsubject'] = 'Потребна је помоћ приликом пријављивања';
$string['core.login.emailconfirmsentnoemail'] = '<p>Требало би да је послата е-порука на вашу адресу.</p><p><p>Порука садржи једноставна упутства о даљем поступку регистрације.</p>';
$string['core.login.emailnotmatch'] = 'Адресе е-поште се не поклапају';
$string['core.login.erroraccesscontrolalloworigin'] = 'Cross-Origin позив који покушавате да изведете је одбијен. Молимо, проверите https://moodledev.io/general/app/development/setup/app-in-browser';
$string['core.login.errordeletesite'] = 'Дошло је до грешке приликом брисања овог налога. Молим вас, покушајте поново.';
$string['core.login.errorexampleurl'] = 'URL адреса https://campus.example.edu је само пример URL адресе. То није прави сајт. <strong>Употребите URL адресу сајта ваше школе односно организације.</strong>';
$string['core.login.errorqrnoscheme'] = 'Ова URL адреса није исправна URL адреса за пријаву.';
$string['core.login.errorupdatesite'] = 'Дошло је до грешке приликом ажурирању токена сајта.';
$string['core.login.exceededloginattempts'] = 'Да ли вам је потребна помоћ приликом пријављивања? Покушајте {{recoverPassword}} или се обратите за помоћ подршци.';
$string['core.login.exceededloginattemptsrecoverpassword'] = 'обнављање ваше лозинке';
$string['core.login.exceededloginattemptssupportsubject'] = 'Не могу да се пријавим';
$string['core.login.exceededloginattemptswithoutpassword'] = 'Да ли вам је потребна помоћ приликом пријављивања? Покушајте да се обратите подршци вашег сајта.';
$string['core.login.exceededloginattemptswithoutsupport'] = 'Да ли вам је потребна помоћ приликом пријављивања? Покушајте {{recoverPassword}}.';
$string['core.login.exceededpasswordresetattempts'] = 'Чини се да имате проблема са приступом свом налогу. Можете се обратите особи која је одговорна у вашој институцији (школи/организацији) или покушајте поново касније.';
$string['core.login.exceededpasswordresetattemptssupportsubject'] = 'Не могу да ресетујем своју лозинку';
$string['core.login.faqcannotconnectanswer'] = 'Молимо вас, обратите се администратору вашег сајта.';
$string['core.login.faqcannotconnectquestion'] = 'Тачно сам унео адресу свог сајта, али још увек не могу да се повежем.';
$string['core.login.faqcannotfindmysiteanswer'] = 'Ако сте покушали да претражујете по URL адреси и још увек не можете да пронађете свој Моодле сајт, обратите се особи која се брине о Moodleu у вашој институцији (школи/организацији).';
$string['core.login.faqcannotfindmysitequestion'] = 'Не могу да пронађем свој сајт помоћу URL адресе.';
$string['core.login.faqcantloginanswer'] = '<p>Када се повежете на свој Moodle сајт, требало би да будете у могућности да се пријавите са својим уобичајеним корисничким именом и лозинком.</p><br><p>Ако сте заборавили корисничко име или лозинку, изаберите опцију <strong>Изгубљена лозинка?</strong>. Ако и даље имате проблема са пријављивањем или не видите ниједну опцију за преузимање корисничког имена или лозинке, обратите се особи која се брине о Moodleu у вашој институцији (школи/организацији).</p>';
$string['core.login.faqcantloginquestion'] = 'Не могу да се пријавим.';
$string['core.login.faqmore'] = 'Проверите <a href="https://docs.moodle.org/en/Moodle_app_FAQ#toc" target="_blank">Често постављана питања (FAQ)</a> за више одговора.';
$string['core.login.faqsetupsiteanswer'] = 'Посетите {{$link}} како бисте проверили различите опције које имате да направите сопствени Moodle сајт.';
$string['core.login.faqsetupsitelinktitle'] = 'Започните.';
$string['core.login.faqsetupsitequestion'] = 'Желим да покренем сопствени Moodle сајт.';
$string['core.login.faqtestappanswer'] = 'Да бисте тестирали апликацију на Moodle Demo сајту, у поље <strong>Ваш сајт</strong> унесите "teacher" или „student" и притисните дугме <strong>Повежи се са својим сајтом</strong>.';
$string['core.login.faqtestappquestion'] = 'Могу ли да тестирам апликацију на демо сајту?';
$string['core.login.faqwhatisurlanswer'] = '<p>Уколико не можете да пронађете свој сајт према имену, покушајте да га пронађете према његовој URL адреси (веб адреси).</p><p>Да бисте пронашли адресу свог сајта:</p>
<ol><li>Отворите веб читач и идите на страницу за пријаву вашег Moodle сајта.</li><li>На врху странице, у траци за адресу, видећете URL адресу свог Moodle сајта нпр. "mojaskola.edu.rs".<br>{{$image}}</li><li>Копирајте адресу (немојте копирати део адресе који почиње са /login), у Moodle апликацију а онда притисните дугме <strong>Повежи се са својим сајтом</strong></li><li>Сада се можете пријавити на сајт користећи своје корисничко име и лозинку.</li></ol><p>Ако сте покушали да претражујете према URL адреси и још увек не можете да пронађете свој Moodle сајт, обратите се особи која се брине о Moodleu у вашој институцији (школи/организацији).</p>';
$string['core.login.faqwhatisurlquestion'] = 'Како могу да пронађем свој сајт?';
$string['core.login.faqwhereisqrcode'] = 'Где могу да пронађем QR кôд?';
$string['core.login.faqwhereisqrcodeanswer'] = '<p>Ако је особа која је одговорна у вашој институцији (школи/организацији), то омогућила, наћи ћете QR кôд на веб сајту, на дну странице вашег корисничког профила.</p>{{$image}}';
$string['core.login.findyoursite'] = 'Пронађите свој сајт';
$string['core.login.helpmelogin'] = '<p>Постоји више хиљада Moodle сајтова широм света. Ова апликација може да се повеже само са Moodle сајтовима који су експлицитно омогућили приступ мобилној апликацији.</p><p>Ако не можете да се повежете са Moodle сајтом, обратите се администратору вашег сајта и затражите да прочита <a href="http://docs.moodle.org/en/Mobile_app" target="_blank">http://docs.moodle.org/en/Mobile_app</a></p><p>Да бисте тестирали апликацију на Moodle демо сајту упишите <i>teacher</i> или <i>student</i> у поље <i>Адреса сајта</i> и кликните дугме <b>Повежите се!</b>.</p>';
$string['core.login.invalidaccount'] = 'Проверите своје податке за пријаву и покушајте поново.';
$string['core.login.invalidmoodleversion'] = 'Верзија система је превише стара. Moodle App ради са верзијом {{$a}} и новијим.';
$string['core.login.invalidsite'] = 'URL адреса сајта није исправна.';
$string['core.login.invalidtime'] = 'Време није исправно';
$string['core.login.invalidvaluemax'] = 'Максимална вредност је {{$a}}';
$string['core.login.invalidvaluemin'] = 'Минимална вредност је {{$a}}';
$string['core.login.loggedoutssodescription'] = 'Морате поново да потврдите свој идентитет. Потребно је да се пријавите на сајт у прозору веб читача.';
$string['core.login.loginbutton'] = 'Пријава';
$string['core.login.logininsiterequired'] = 'Потребно је да се пријавите на сајт у прозору веб читача.';
$string['core.login.mobileservicesnotenabled'] = 'Мобилни сервиси нису омогућени на вашем сајту.';
$string['core.login.notloggedin'] = 'Морате бити пријављени.';
$string['core.login.onboardingcreatemanagecourses'] = 'Креирајте и управљајте својим курсевима';
$string['core.login.onboardingenrolmanagestudents'] = 'Упишите и управљајте својим полазницима';
$string['core.login.onboardinggetstarted'] = 'Почните да користите Moodle';
$string['core.login.onboardingialreadyhaveasite'] = 'Већ имам Moodle сајт';
$string['core.login.onboardingimalearner'] = 'Ја сам полазник';
$string['core.login.onboardingimaneducator'] = 'Ја сам предавач';
$string['core.login.onboardingineedasite'] = 'Потребан ми је Moodle сајт';
$string['core.login.onboardingprovidefeedback'] = 'Обезбедите правовремене повратне информације';
$string['core.login.onboardingtoconnect'] = 'Да бисте се повезали са Moodle апликацијом, биће вам потребан Moodle сајт';
$string['core.login.onboardingwelcome'] = 'Добродошли у Moodle апликацију!';
$string['core.login.or'] = 'или';
$string['core.login.passwordrequired'] = 'Неопходна је лозинка';
$string['core.login.policyacceptmandatory'] = 'Разумем и прихватам обавезна правила о коришћењу сајта';
$string['core.login.recaptchachallengeimage'] = 'reCAPTCHA слика';
$string['core.login.recaptchaexpired'] = 'Верификација је истекла. Поново одговорите на безбедносно питање.';
$string['core.login.recaptchaincorrect'] = 'Одговор на безбедносно питање је нетачан.';
$string['core.login.reconnect'] = 'Повежите се поново';
$string['core.login.reconnecthelp'] = 'Ако имате проблема са поновним повезивањем, покушајте поново касније или се обратите особи која је одговорна у вашој институцији (школи/организацији).';
$string['core.login.reconnectssodescription'] = 'Ваша сесија је истекла. Пријавите се поново у прозору веб читача како бисте наставили.';
$string['core.login.reconnectsupportsubject'] = 'Потребна ми је помоћ при поновном повезивању';
$string['core.login.reconnecttosite'] = 'Поново се повежите са сајтом';
$string['core.login.removeaccount'] = 'Уклони налог';
$string['core.login.searchby'] = 'Претрага по:';
$string['core.login.selectsite'] = 'Молимо изаберите свој налог:';
$string['core.login.signupplugindisabled'] = '{{$a}} није омогућен.';
$string['core.login.signuprequiredfieldnotsupported'] = 'Образац за регистрацију садржи обавезно прилагођено поље које апликацији не подржава. Креирајте налог користећи веб читач.';
$string['core.login.siteaddress'] = 'Ваш сајт';
$string['core.login.siteaddressplaceholder'] = 'https://campus.example.edu';
$string['core.login.sitebadgedescription'] = 'Број непрочитаних обавештења: {{count}}';
$string['core.login.sitehasredirect'] = 'Ваш сајт садржи најмање једну HTTP редирекцију. Апликација не може да прати редирекције. Ово би могао да буде проблем који спречава апликацију да се повеже са вашим сајтом.';
$string['core.login.siteinmaintenance'] = 'Ваш сајт је у режиму одржавања';
$string['core.login.sitenotallowed'] = 'Овај сајт више није доступан.';
$string['core.login.sitepolicynotagreederror'] = 'Сагласност са правилником о коришћењу сајта није потврђена.';
$string['core.login.siteurl'] = 'URL адреса сајта';
$string['core.login.siteurlrequired'] = 'Неопходна је URL адреса, нпр. <i>https://campus.example.edu</i>';
$string['core.login.stillcantconnect'] = 'Још увек не можете да се повежете?';
$string['core.login.toggleremove'] = 'Уредите списак налога';
$string['core.login.unsupportedsite'] = 'Сајт није доступан преко апликације';
$string['core.login.unsupportedsitemessage'] = 'Сајту {{site}} се не може приступити преко ове апликације.<br><br>И даље му можете приступити помоћу веб читача.';
$string['core.login.usernamerequired'] = 'Корисничко име је неопходно';
$string['core.login.visitchangepassword'] = 'Да ли желите да посетите сајт како бисте променили лозинку?';
$string['core.login.webservicesnotenabled'] = 'Веб сервиси нису омогућени на сајту.';
$string['core.login.youcanstillconnectwithcredentials'] = 'Још увек можете да се повежете са сајтом тако што ћете унети своје корисничко име и лозинку.';
$string['core.login.yourenteredsite'] = 'Повежите се са својим сајтом';
$string['core.lostconnection'] = 'Ваша сесија је истекла. Пријавите се поново како бисте наставили.';
$string['core.mainmenu.switchaccount'] = 'Промени налог';
$string['core.mainmenu.usermenutourdescription'] = 'Место где можете да проверите своје оцене, промените подешавања или промените налог.';
$string['core.mainmenu.usermenutourtitle'] = 'Истражите своје лично подручје';
$string['core.needhelp'] = 'Потребна вам је помоћ?';
$string['core.networkerroriframemsg'] = 'Овај садржај није доступан офлајн. Повежите се на интернет и покушајте поново.';
$string['core.networkerrormsg'] = 'Било је проблема са повезивањем на сајт. Проверите везу и покушајте поново.';
$string['core.nooptionavailable'] = 'Нема доступних опција';
$string['core.nopasswordchangeforced'] = 'Не можете наставити без промене своје лозинке.';
$string['core.nopermissionerror'] = 'Жао нам је, али тренутно немате овлашћења да то урадите';
$string['core.notapplicable'] = 'n/a';
$string['core.notdownloadable'] = 'Није могуће преузети';
$string['core.notnow'] = 'Не сада';
$string['core.notsent'] = 'Није послато';
$string['core.nummore'] = '{{$a}} још';
$string['core.openfile'] = 'Отвори датотеку';
$string['core.openfilewithextension'] = 'Отворите датотеку са екстензијом {{extension}}';
$string['core.openfullimage'] = 'Кликните овде да бисте приказали слику у пуној величини';
$string['core.openinbrowser'] = 'Отвори у веб читачу';
$string['core.openinbrowserdescription'] = 'Бићете преусмерени у веб читач';
$string['core.openmodinbrowser'] = 'Отворите {{$a}} у веб читачу';
$string['core.opensecurityquestion'] = 'Отворено сигурносно питање';
$string['core.opensettings'] = 'Отворите подешавања';
$string['core.openwith'] = 'Отвори са...';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.play'] = 'Репродукуј';
$string['core.policy.havereadandagreepolicy'] = 'Прочитао/ла сам и слажем се са {{policyname}}';
$string['core.policy.nopoliciesyet'] = 'Још нема правила и сагласности.';
$string['core.policy.policyacceptmandatory'] = 'Разумем и прихватам обавезна правила о коришћењу сајта';
$string['core.policy.sitepolicynotagreederror'] = 'Сагласност са правилником о коришћењу сајта није потврђена.';
$string['core.policy.viewpolicy'] = 'Погледајте правилник о коришћењу сајта {{policyname}}.';
$string['core.pulltorefresh'] = 'Повуците да бисте освежили';
$string['core.qrscanner'] = 'QR скенер';
$string['core.question.cannotdeterminestatus'] = 'Није могуће одредити статус';
$string['core.question.errorattachmentsnotsupportedinsite'] = 'Ваш сајт још увек не подржава да уз одговор буду приложенe датотекe.';
$string['core.question.errorembeddedfilesnotsupportedinsite'] = 'Ваш сајт још увек не подржава уређивање уграђених датотека.';
$string['core.question.errorquestionnotsupported'] = 'Апликација не подржава овај тип питања: {{$a}}.';
$string['core.question.howtodraganddrop'] = 'Додирните да бисте изабрали, а затим још једном да би сте спустили спуштање.';
$string['core.question.questionmessage'] = 'Питање {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'Бићете преусмерени на сајт.';
$string['core.reminders.atthetime'] = 'У време догађаја';
$string['core.reminders.custom'] = 'Прилагођено...';
$string['core.reminders.customreminder'] = 'Прилагођени подсетник';
$string['core.reminders.delete'] = 'Обриши подсетник';
$string['core.reminders.reminderset'] = 'Подсетник је подешен за {{$a}}';
$string['core.reminders.reminderunset'] = 'Подсетник је обрисан';
$string['core.reminders.setareminder'] = 'Подесите подсетник';
$string['core.reminders.setareminderfor'] = 'Подесите подсетник за "{{title}}" ({{label}})';
$string['core.reminders.setreminder'] = 'Подесите подсетник';
$string['core.reminders.timebefore'] = '{{value}} {{units}} раније';
$string['core.reminders.value'] = 'Вредност';
$string['core.removefiles'] = 'Уклоните датотеке {{$a}}';
$string['core.reportbuilder.filtersapplied'] = 'Можда су на овај приказ примењени филтери. Да бисте уредили филтере или променили редослед сортирања, <a href="{{$a}}">отворите овај извештај у свом веб читачу.</a>';
$string['core.reportbuilder.hidecolumns'] = 'Сакриј колоне';
$string['core.reportbuilder.showcolumns'] = 'Прикажи колоне';
$string['core.requireduserdatamissing'] = 'Овај корисник нема у свом профилу неке неопходне податке. Молимо вас, унесети податке на свој сајт и покушајте поново.<br>{{$a}}';
$string['core.resume'] = 'Настави';
$string['core.retry'] = 'Покушај поново';
$string['core.scanqr'] = 'Скенирајте QR кôд';
$string['core.scrollbackward'] = 'Померите се уназад';
$string['core.scrollforward'] = 'Померите се напред';
$string['core.search.allcategories'] = 'Све категорије';
$string['core.search.empty'] = 'Шта тражите?';
$string['core.search.filtercategories'] = 'Филтрирајте резултате према';
$string['core.search.filtercourses'] = 'Претражи у';
$string['core.search.noresults'] = 'Нема резултата за "{{$a}}"';
$string['core.search.noresultshelp'] = 'Проверите грешке у куцању или покушајте да користите друге кључне речи';
$string['core.search.resultby'] = 'Према {{$a}}';
$string['core.searching'] = 'Претраживање';
$string['core.serverconnection'] = 'Грешка приликом повезивања са сервером: {{details}}';
$string['core.settings.about'] = 'О апликацији';
$string['core.settings.appsettings'] = 'Подешавања апликације';
$string['core.settings.appversion'] = 'Верзија апликације';
$string['core.settings.cannotsyncloggedout'] = 'Овај сајт не може да се синхронизује јер сте се одјавили. Покушајте поново када се поново пријавите на сајт.';
$string['core.settings.cannotsyncoffline'] = 'Синхронизација сајта није успела јер ваш уређај није повезан на интернет.';
$string['core.settings.cannotsyncwithoutwifi'] = 'Ваш уређај није повезан на Wi-Fi мрежу. Повежите се на  Wi-Fi мрежу или искључите опцију за уштеду података у подешавањима апликације.';
$string['core.settings.changelanguage'] = 'Промените језик на {{$a}}';
$string['core.settings.changelanguagealert'] = 'Промена језика ће поново покренути апликацију.';
$string['core.settings.colorscheme'] = 'Шема боја';
$string['core.settings.colorscheme-dark'] = 'Тамна';
$string['core.settings.colorscheme-light'] = 'Светла';
$string['core.settings.colorscheme-system'] = 'Подразумевана за систем';
$string['core.settings.colorscheme-system-notice'] = 'Подразумевани режим система ће зависити од подршке вашег уређаја.';
$string['core.settings.compilationinfo'] = 'Информације о компилацији';
$string['core.settings.connecttosync'] = 'Ваш уређај је офлајн. Повежите се на интернет како бисте синхронизовали сајтове.';
$string['core.settings.connectwifitosync'] = 'Повежите се на  Wi-Fi мрежу или искључите опцију за уштеду података како бисте синхронизовали сајтове.';
$string['core.settings.copyinfo'] = 'Копирајте информације о уређају у клипборд';
$string['core.settings.cordovadevicemodel'] = 'Модел Cordova уређаја';
$string['core.settings.cordovadeviceosversion'] = 'Верзија оперативног система Cordova уређаја';
$string['core.settings.cordovadeviceplatform'] = 'Платформа Cordova уређаја';
$string['core.settings.cordovadeviceuuid'] = 'UUID Cordova уређаја';
$string['core.settings.cordovaversion'] = 'Cordova верзија';
$string['core.settings.debugdisplaydescription'] = 'Ако је омогућена ова опција, порука о грешци ће приказати више података о самој грешци ако је то могуће.';
$string['core.settings.developeroptions'] = 'Опције за програмере';
$string['core.settings.deviceinfo'] = 'Информације о уређају';
$string['core.settings.deviceos'] = 'Оперативни систем уређаја';
$string['core.settings.displayformat'] = 'Формат приказа';
$string['core.settings.enableanalytics'] = 'Омогући аналитику';
$string['core.settings.enableanalyticsdescription'] = 'Ако је ова опција омогућена, апликација ће прикупљати анонимно податаке о коришћењу.';
$string['core.settings.enabledownloadsection'] = 'Омогући преузимање секција.';
$string['core.settings.enablefirebaseanalytics'] = 'Омогућите Firebase аналитику';
$string['core.settings.enablefirebaseanalyticsdescription'] = 'Ако је ова опција омогућена, апликација ће прикупљати анонимно податаке о коришћењу.';
$string['core.settings.enablerichtexteditor'] = 'Омогућите обогаћени едитор текста';
$string['core.settings.enablerichtexteditordescription'] = 'Ако је ова опција укључена обогаћени едитор текста биће доступан на местима где треба унети неки садржај.';
$string['core.settings.enablesyncwifi'] = 'Дозволите синхронизацију само када сте повезани на Wi-Fi мрежу.';
$string['core.settings.encryptedpushsupported'] = 'Подржано је прослеђивање шифрованих обавештења';
$string['core.settings.entriesincache'] = 'Број уноса у кеш меморију: {{$a}}';
$string['core.settings.errorsyncsite'] = 'Грешка приликом синхронизације података сајта. Молимо, проверите вашу интернет везу и покушајте поново.';
$string['core.settings.estimatedfreespace'] = 'Процењени слободан простора';
$string['core.settings.filesystemroot'] = 'Основни директоријум система датотека';
$string['core.settings.fontsize'] = 'Величина текста';
$string['core.settings.forcedsetting'] = 'Ово подешавање је наметнуто конфигурацијом вашег сајта.';
$string['core.settings.helpusimprove'] = 'Помозите нам да побољшамо ову апликацију';
$string['core.settings.ioscookies'] = 'Унакрсно праћење веб сајтова (Cross-Website Tracking)';
$string['core.settings.ioscookiesdescription'] = 'Уграђени садржај са сајта може захтевати колачиће на више сајтова како би нормално функционисао. Да бисте то омогућили, идите на iOS подешавања апликације и укључите опцију \'Дозволи унакрсно праћење ваб сајтова\'';
$string['core.settings.legaldisclaimer'] = 'Правно ограда (од одговорности)';
$string['core.settings.localnotifavailable'] = 'Локална обавештења доступна';
$string['core.settings.locationhref'] = 'Webview URL адреса';
$string['core.settings.logintosync'] = 'Пријавите се да бисте синхронизовали';
$string['core.settings.navigatorlanguage'] = 'Језик навигатора';
$string['core.settings.navigatoruseragent'] = 'Navigator userAgent';
$string['core.settings.networkstatus'] = 'Статус инернет везе';
$string['core.settings.opensourcelicenses'] = 'Лиценце отвореног кôда';
$string['core.settings.privacypolicy'] = 'Политика приватности';
$string['core.settings.publisher'] = 'Издавач';
$string['core.settings.pushid'] = 'ID ознака прослеђених обавештења';
$string['core.settings.reportinbackground'] = 'Пријавите грешке аутоматски';
$string['core.settings.screen'] = 'Информације о екрану';
$string['core.settings.showdownloadoptions'] = 'Прикажи опције за преузимања';
$string['core.settings.siteinfo'] = 'Информације о сајту';
$string['core.settings.sitesynccompleted'] = 'Синхронизација сајта је завршена.';
$string['core.settings.sitesyncfailed'] = 'Синхронизација сајта није успела';
$string['core.settings.spaceusage'] = 'Искориштеност простора';
$string['core.settings.syncdatasaver'] = 'Уштеда података: синхронизујте само када сте повезани на Wi-Fi мрежу';
$string['core.settings.synchronization'] = 'Синхронизација';
$string['core.settings.synchronizenow'] = 'Синхронизуј сада';
$string['core.settings.synchronizenowhelp'] = 'Синхронизација сајта ће послати промене на чекању и све офлајн активности сачуване на уређају. Такође, биће синхронизовни и неки подаци као што су поруке и обавештења.';
$string['core.settings.syncsettings'] = 'Подешавања синхронизације';
$string['core.settings.wificonnection'] = 'WiFi веза';
$string['core.settings.youradev'] = 'Сада сте програмер';
$string['core.sharedfiles.chooseaccountstorefile'] = 'Изаберите налог за чување датотеке.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'Већ постоји датотека са овим називом. Да ли желите да замените постојећу датотеку или да јој назив промените у "{{$a}}"?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'Не постоје меморисани сајтови. Молимо, додајте сајт пре него што покушате да поделите датотеке са апликацијом.';
$string['core.sharedfiles.nosharedfiles'] = 'Не постоје дељене датотеке које се налазе на овом сајту.';
$string['core.sharedfiles.nosharedfilestoupload'] = 'Овде немате датотеке које можете да отпремите. Ако желите да отпремите датотеку из друге апликације, пронађите ту датотеку и кликните на дугме \'Отвори у\'.';
$string['core.sharedfiles.rename'] = 'Промени назив';
$string['core.sharedfiles.replace'] = 'Замени';
$string['core.sharedfiles.sharedfiles'] = 'Дељене датотеке';
$string['core.sharedfiles.successstorefile'] = 'Датотека је успешно сачувана. Изаберете датотеку како бисте је отпремили међу своје приватне датотеке или искористили у некој активности.';
$string['core.sitenotfound'] = 'Сајт није пронађен';
$string['core.sitenotfoundhelp'] = 'Не можемо да пронађемо сајт који сте унели. Проверите да ли постоје грешке у куцању или покушајте поново касније. Ако и даље видите ову поруку обратите особи која је одговорна у вашој институцији (школи/организацији).';
$string['core.siteunavailablehelp'] = 'Сајт "{{site}}" тренутно није доступан. Молимо вас, покушајте поново касније или се обратите особи која је одговорна у вашој институцији (школи/организацији).';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = 'Извините...';
$string['core.start'] = 'Почни';
$string['core.startingtime'] = 'Време почетка: {{$a}}';
$string['core.storingfiles'] = 'Чување датотека';
$string['core.submittedoffline'] = 'Предато (офлајн)';
$string['core.swipenavigationtourdescription'] = 'Превуците прстом налево и надесно';
$string['core.tablet'] = 'Таблет';
$string['core.tag.errorareanotsupported'] = 'Апликација не подржава ово подручје ознака';
$string['core.tag.tagareabadgedescription'] = 'Постоји {{count}} ставке/и.';
$string['core.tag.warningareasnotsupported'] = 'Нека подручја ознака нису приказана јер их апликација не подржава.';
$string['core.thereisdatatosync'] = 'Број офлајн податак које треба синхронизовати: {{$a}}';
$string['core.toggledelete'] = 'Укључите/искључите дугмад за брисање';
$string['core.tryagain'] = 'Покушај поново';
$string['core.turnon'] = 'Укључи';
$string['core.turnonexactalarms'] = 'Укључите упозорења у реалном времену';
$string['core.turnonnotifications'] = 'Укључите обавештења';
$string['core.turnonnotificationsmessage'] = 'Да ли желите да примате обавештења о активностима и задацима?';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'Ух!';
$string['core.unexpectederror'] = 'Неочекивана грешка. Затворите и поново отворите апликацију, а затим покушајте поново.';
$string['core.unicodenotsupported'] = 'Неки емотикони нису подржани на овом сајту. Такви знакови ће бити уклоњени приликом слања поруке.';
$string['core.unicodenotsupportedcleanerror'] = 'Приликом чишћења Unicode карактера пронађен је празан текст.';
$string['core.unknown'] = 'Непознато';
$string['core.unzipping'] = 'Распакивање';
$string['core.updaterequired'] = 'Потребно је ажурирање апликације';
$string['core.updaterequireddesc'] = 'Ажурирајте апликацију на верзију {{$a}}';
$string['core.user.completeprofile'] = 'Попуните профил';
$string['core.user.completeprofilehelp'] = 'Ако имате проблема са попуњавањем свог профила, покушајте поново касније или се обратите особи која је одговорна у вашој институцији (школи/организацији).';
$string['core.user.completeprofilenotice'] = 'Пре него што наставите, попуните обавезна поља у свом корисничком профилу.';
$string['core.user.completeprofilereconnectinstructions'] = 'Ако нисте исправно попунили свој профил, од вас ће се тражити да то урадите поново.';
$string['core.user.completeprofilesupportsubject'] = 'Потребна ми је помоћ да попуним профил';
$string['core.user.completeyourprofile'] = 'Попуните свој профил';
$string['core.user.contact'] = 'Контакт';
$string['core.user.detailsnotavailable'] = 'Подаци о овом кориснику вам нису доступни.';
$string['core.user.errorloaduser'] = 'Грешка приликом учитавања корисника.';
$string['core.user.sendemail'] = 'Е-пошта';
$string['core.user.support'] = 'Обратите се подршци сајта';
$string['core.user.supportsubject'] = '[App] {{subject}}';
$string['core.user.userwithid'] = 'Корисник са ID ознаком {{id}}';
$string['core.usernologin'] = 'Провера идентитета за овај налог је опозвана';
$string['core.viewcode'] = 'Прикажи кôд';
$string['core.vieweditor'] = 'Прикажи едитор';
$string['core.viewembeddedcontent'] = 'Прикажи уграђени садржај';
$string['core.wanttochangesite'] = 'Желите да промените сајт или да се одјавите?';
$string['core.warningofflinedatadeleted'] = 'Офлајн промене компоненте {{component}} \'{{name}}\' су одбачене. {{error}}';
$string['core.warningofflinedatadeletedreason'] = 'Новије промене ове активности су направљене са другог уређаја.';
$string['core.warnopeninbrowser'] = '<p>Намеравате да напустити апликацију како бисте отворили следећу URL адресу у веб читачу свог уређаја. Да ли желите да наставите?</p>
<p><b>{{url}}</b></p>';
$string['core.whoissiteadmin'] = '"Администратори сајта" су особе који управљају Moodleom у вашој школи (универзитету, компанији или образовној организацији). Ако не знате како да их контактирате, обратите се својим предавачима/тренерима.';
$string['core.whyisthishappening'] = 'Зашто се ово дешава?';
$string['core.wsfunctionnotavailable'] = 'Функција веб service није доступна.';
$string['core.youreoffline'] = 'Ваш уређај је офлајн';
$string['core.youreonline'] = 'Ваш уређај је поново онлајн';
$string['core.zoomin'] = 'Повећајте';
$string['core.zoomout'] = 'Смањите';
$string['freemium.autologoutclosingtheapp'] = 'Одмах након напуштања апликације';
$string['freemium.autologoutcustomtime'] = 'Прилагођено време након напуштања апликације';
$string['freemium.autologoutdefault'] = 'Подразумевано';
$string['freemium.autologouttitle'] = 'Аутоматски се одјавите са овог уређаја';
$string['freemium.biometriclogin'] = 'Биометријска пријава';
$string['freemium.biometriclogindescription'] = 'Ставите прст у читач отиска прста.';
$string['freemium.biometricloginenablefaceid'] = 'Укључите FaceID';
$string['freemium.biometricloginenablefingerprint'] = 'Укључите Fingerprint';
$string['freemium.biometricloginenabletouchid'] = 'Укључите TouchID';
$string['freemium.biometricloginloginwithfaceid'] = 'Пријавите се помоћу FaceID-а';
$string['freemium.biometricloginloginwithfingerprint'] = 'Пријавите се помоћу Fingerprinta';
$string['freemium.biometricloginloginwithtouchid'] = 'Пријавите се помоћу TouchID-а';
$string['freemium.biometricloginskip'] = 'Прескочи ово за сада';
$string['freemium.biometricloginsuccessfullyenabled'] = '{{ biometricMethod }} омогућен.';
$string['freemium.biometricloginturnoff'] = 'Ову функцију можете да укључите и искључите у било ком тренутку у подешавањима.';
$string['freemium.biometriclogintypefaceid'] = 'FaceID';
$string['freemium.biometriclogintypefingerprint'] = 'Fingerprint';
$string['freemium.biometriclogintypetouchid'] = 'TouchID';
$string['freemium.biometricloginwithfingerorface'] = 'Користите биометријско пријављивање помоћу отиска прста или препознавања лица.';
$string['freemium.change'] = 'Промени';
$string['freemium.coursesbatchdownloaddisabled'] = 'Преузимање курсева у пакету није омогућено за овај сајт.';
$string['freemium.coursesdownloadlimitreached'] = 'Ограничење у броју преузитих курсева је достигнуто! Можете да преузмете само {{limit}} курса/ева. Oбратите се администратору да повећа ово ограничење или уклоните неке преузете курсеве са свог уређаја.';
$string['freemium.downloadmainapplicationrequired'] = 'Можете се повезати са овим веб сајтом само помоћу наменски креиране апликације.';
$string['freemium.downloadmainapplicationsuggestion'] = 'Сајт са којим покушавате да се повежете има наменски креирану апликацију коју бисте можда желели да испробате.';
$string['freemium.feature_autologout'] = 'Аутоматска одјава';
$string['freemium.feature_biometriclogin'] = 'Биометријска пријава';
$string['freemium.feature_coursesdownload'] = 'Преузети курсеви';
$string['freemium.feature_multimediapushnotifications'] = 'Мултимедијална прослеђена обавештења';
$string['freemium.feature_pushnotificationsdevices'] = 'Уређаји на које се обавештења прослеђују';
$string['freemium.feature_qrlogin'] = 'Потврдите идентитет помоћу QR кôда';
$string['freemium.feature_remotethemes'] = 'Удаљене теме';
$string['freemium.feature_sitelogo'] = 'Лого сајта';
$string['freemium.notallowed'] = 'Није дозвољено';
$string['freemium.nottoday'] = 'Не данас';
$string['freemium.qrlogindisabled'] = 'Провера идентитета у апликацији помоћу QR кôда није омогућена за сајт:<br><br>{{url}}';
$string['freemium.qrloginexpiredkey'] = 'QR кôд је истекао. Освежите страницу са QR кôдом и поново је скенирајте.';
$string['freemium.qrloginipmismatch'] = 'Čini se da uređaj koji koristite za povezivanje nije u istoj mreži kao uređaj koji prikazuje QR kod. Proverite da li su oba uređaja povezana na istu mrežu (npr. istu WiFi mrežu).<br><br>Ako se greška i dalje javlja, obratite se administratoru svog sajta.';
$string['freemium.ratetheapp'] = 'Да ли уживате у нашој апликацији?';
$string['freemium.ratetheapp_feedbackko'] = 'Реците нам шта је пошло наопако';
$string['freemium.ratetheapp_feedbackmessage'] = 'Ваше повратне информације ће бити анонимне';
$string['freemium.ratetheapp_feedbackok'] = 'Пошаљите повратне информације';
$string['freemium.ratetheapp_feedbackplaceholder'] = 'Напишите нешто овде';
$string['freemium.ratetheapp_feedbacksent'] = 'Хвала! Ваше повратне информације су успешно послате.';
$string['freemium.ratetheapp_sendtostore'] = 'Можете ли издвојити тренутак да оцените нашу апликацију? То ће нам помоћи да је побољшамо.';
$string['freemium.remindmelater'] = 'Подсети ме касније';
$string['freemium.settingsoptions_autologout'] = 'Аутоматска одјава';
$string['freemium.settingsoptionsfacial'] = 'Омогућите пријаву препознавањем лица';
$string['freemium.settingsoptionsfingerprint'] = 'Омогућите пријаву отиском прста';
$string['freemium.subscription'] = 'Претплата на сајт';
$string['freemium.subscriptiondetails'] = 'Детаљни подаци о претплати';
$string['freemium.subscriptionfeature_exceeded_customlanguagestrings'] = 'Број прилагођених језичких стрингова који се игноришу: {{ overflowCount }}';
$string['freemium.subscriptionfeature_exceeded_custommenuitems'] = 'Број прилагођених језичких ставки у менију који се игноришу: {{ overflowCount }}';
$string['freemium.subscriptionfeature_exceeded_disabledfeatures'] = 'Број функција које су, иако конфигурисане као искључене, још увек укључене: {{ overflowCount }}';
$string['freemium.subscriptionfeature_exceeded_remotethemes'] = 'Ваша прилагођена тема се не примењује';
$string['freemium.subscriptionfeature_exceeded_sitelogo'] = 'Лого вашег сајта се не примењује';
$string['freemium.subscriptionfeature_limited'] = 'Ограничена на {{ limit }}';
$string['freemium.subscriptionfeature_unlimited'] = 'Неограничено';
$string['freemium.subscriptionplan'] = 'План претплате';
$string['freemium.subscriptionplan_bma'] = 'BMA';
$string['freemium.subscriptionplan_expired'] = 'истекао';
$string['freemium.subscriptionplan_free'] = 'Бесплатно';
$string['freemium.subscriptionplan_premium'] = 'Премијум';
$string['freemium.subscriptionplan_pro'] = 'Про';
$string['freemium.subscriptionplan_upgrade'] = 'Надоградите свој план';
$string['freemium.subscriptionplan_validuntil'] = 'важи до {{ date }}';
$string['freemium.subscriptionplandescription'] = 'Планови претплате показују која ограничења се примењују за овaј сајт.';
$string['freemium.subscriptionplanlearnmore'] = 'Сазнајте више';
$string['freemium.upsell_renewexpired'] = 'Ваша претплата је истекла';
$string['freemium.upsell_renewexpiring'] = 'Ваша претплата истиче за {{ days }} дан/а';
$string['freemium.upsell_renewtitle'] = 'Обновите претплату';
$string['freemium.upsell_upgradefreeaccept'] = 'Надоградите';
$string['freemium.upsell_upgradefreemessage'] = 'Тренутно користите бесплатни план, надоградите како бисте откључали додатне функције.';
$string['freemium.upsell_upgradefreepostpone'] = 'Касније';
$string['freemium.upsell_upgradefreetitle'] = 'Надоградите свој план';
$string['pluginname'] = 'Moodle App језички стрингови';
$string['privacy_metadata'] = 'Овај додатак не чува никакве корисничке податке.';
$string['workplace.teams.isoverdue'] = 'Има ставке које су закаснеле или истекле';
