<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'es_mx', version '4.2'.
 *
 * @package     badges
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Acciones';
$string['activate'] = 'Habilitar acceso';
$string['activatesuccess'] = 'El acceso a insignias fue habilitado exitosamente.';
$string['addalignment'] = 'Añadir habilidad externa o estándar';
$string['addbackpack'] = 'Añadir mochila';
$string['addbadge'] = 'Añadir insignias';
$string['addbadge_help'] = 'Seleccionar todas las insignias que deberían ser añadidas a este requisito para insignia. Presione la tecla CTRL para seleccionar múltiples elementos.';
$string['addbadgecriteria'] = 'Añadir criterio para insignia';
$string['addcohort'] = 'Añadir cohorte';
$string['addcohort_help'] = 'Seleccionar todas las cohortes que deberían ser añadidas a este requisito para insignia. Mantener presionada la tecla CTRL para seleccionar varios elementos.';
$string['addcompetency'] = 'Añadir competencia';
$string['addcompetency_help'] = 'Seleccionar todas las competencias que deberían de ser añadidas a este requisito para insignia. Mantenga presionada la tecla CTRL para seleccionar varios elementos.';
$string['addcourse'] = 'Añadir cursos';
$string['addcourse_help'] = 'Seleccionar todos los cursos que deberían ser añadidos a este requisito para insignia. Mantener presionada la tecla Ctrl para seleccionar varios elementos.';
$string['addcriteria'] = 'Añadir criterio';
$string['addcriteriatext'] = 'Para empezar a añadir criterios, por favor seleccione una de las opciones del menú desplegable.';
$string['addedtobackpack'] = 'Insignia añadida a mochila';
$string['addrelated'] = 'Añadir insignia relacionada';
$string['addtobackpack'] = 'Añadir a mochila';
$string['adminonly'] = 'Esta página está restringida a Administradores del Sitio exclusivamente';
$string['after'] = 'después de la fecha de emisión';
$string['aggregationmethod'] = 'Método de agregación';
$string['alignment'] = 'Alineación';
$string['all'] = 'Todas';
$string['allmethod'] = 'Todas las condiciones seleccionadas se cumplen';
$string['allmethodactivity'] = 'Todas las actividades seleccionadas están completas';
$string['allmethodbadges'] = 'Todas las insignias seleccionadas han sido ganadas';
$string['allmethodcohort'] = 'Membresía en todas las cohortes seleccionadas';
$string['allmethodcompetencies'] = 'Todas las competencias seleccionadas han sido completadas';
$string['allmethodcourseset'] = 'Todos los cursos selecionados están completos';
$string['allmethodmanual'] = 'Todos los roles seleccionados otorgan la insignia';
$string['allmethodprofile'] = 'Todos los campos de perfil seleccionados han sido completados';
$string['allowcoursebadges'] = 'Habilitar insignias de curso';
$string['allowcoursebadges_desc'] = 'Permitir la creación y otorgamiento de insignias en el contexto de curso.';
$string['allowexternalbackpack'] = 'Conexión hacia mochila externa';
$string['allowexternalbackpack_desc'] = 'Si se habilita, los usuarios se pueden conectar con una mochila externa y compartir sus insignias de este sitio. Los usuarios también pueden elegir mostrar cualquier colección pública de insignias desde  su mochila externa en su página del perfil en este sitio. Se recomienda dejar esta opción deshabilitada si el sitio web no es accesible desde el Internet.';
$string['any'] = 'Cualquiera';
$string['anymethod'] = 'Cualquiera de las condiciones seleccionadas se cumple';
$string['anymethodactivity'] = 'Cualquiera de las actividades seleccionadas está completa';
$string['anymethodbadges'] = 'Cualquiera de las insignias seleccionadas ha sido ganada';
$string['anymethodcohort'] = 'Membresía en culaquiera de las cohortes seleccionadas';
$string['anymethodcompetencies'] = 'Cualquiera de las competencias seleccionadas ha sido completada';
$string['anymethodcourseset'] = 'Cualquiera de los cursos seleccionados está completo';
$string['anymethodmanual'] = 'Cualquiera de los roles seleccionados otorga la insignia';
$string['anymethodprofile'] = 'Cualquiera de los campos de perfil seleccionados ha sido completado';
$string['apiversion'] = 'Versión API soportada';
$string['archivebadge'] = '¿Quisiera Usted eliminar la insignia  \'{$a}\', pero conservar las insignias emitidas existentes?';
$string['archiveconfirm'] = 'Eliminar y conservar insignias emitidas existentes';
$string['archivehelp'] = '<p>Esta opción significa que la insignia será marcada como "retirada" y ya no aparecerá en la lista de insignias. Los usuarios ya no podrán ganar esta insignia; sin embargo, quienes actualmente tengan esta insignia todavía podrán mostrarla en su página de perfil y podrán empujarla hacia mochilas externas.</p>
<p>Si Usted quisiera que los usuarios conserven el acceso a las insignias ganadas, es importante seleccionar esta opción, en lugar de borrar las insignias por completo.</p>';
$string['attachment'] = 'Anexar insignia al mensaje';
$string['attachment_help'] = 'Si se activa, una insignia otorgada se anexará al Email del destinatario para que sea descargada. (Deben habilitarse los anexos a Email en Administración del sitio / Servidor / Email / Configuración del correo saliente para usar esta opción.)';
$string['award'] = 'Otorgar insignia';
$string['awardedto'] = 'Otorgada a {$a}';
$string['awardedtoyou'] = 'Otorgada a mí';
$string['awardoncron'] = 'El acceso a insignias fue habilitado exitosamente. Demasiados usuarios podrían ganarse instantáneamente esta insignia. Para asegurar el desempeño del sitio, esta acción tomará un cierto tiempo para procesarse.';
$string['awards'] = 'Destinatarios';
$string['backpackapiurl'] = 'URL de API de mochila';
$string['backpackavailability'] = 'Verificación externa de insignia';
$string['backpackavailability_help'] = 'Para que aquellos que recibieron insignias puedan probar que se ganaron las insignias de Usted, debería de ser posible acceder a su sitio y verificar las insignias emitidas por su sitio. Su sitio actualmente al parecer no es accesible, lo que significa que las insignias que haya otorgado o que otorgue en el futuro no pueden ser verificadas.

##¿Porqué estoy viendo este mensaje?

Es posible que su cortafuegos (\'\'fireewall\'\') impida el acceso de usuarios desde fuera de su red del trabajo, que su sitio esté protegido por contraseña, o que estuviera corriendo el sitio desde una computadora que no está disponible desde Internet (como por ejemplo, una máquina experimental local).

##¿Es esto un problema?

Usted debería de arreglar este asunto en cualquier sitio en producción desde donde planee otorgar insignias; de lo contrario los destinatarios no podrán probar que se ganaron las insignias de Usted. Si su sitio aún no está activo, Usted puede crear y emitir insignias de prueba, siempre y que su sitio se vuelva accesible antes de que sea activo.

##¿Qué pasaría si no puedo hacer que mi sitio sea accesible publicamente?

La única URL requerida para la verificación es la de [URL-de-su-sitio]/badges/assertion.php por lo que si Usted pudiera modificar su cortafuegos (firewall) para que permita el acceso externo a este archivo, la verificación de insignias sí funcionaría.';
$string['backpackbadgessettings'] = 'Cambiar configuraciones de mochila';
$string['backpackbadgessummary'] = 'Usted tiene {$a->totalbadges} insignia(s) mostrada(s) de  {$a->totalcollections} colección(es).';
$string['backpackcannotsendverification'] = 'No puede enviarse Email de verificación';
$string['backpackconnected'] = 'La mochila está conectada';
$string['backpackconnection'] = 'Conexión de mochila';
$string['backpackconnection_help'] = 'El conectarse a una mochila le permite compartir sus insignias de este sitio y mostrar colecciones de insignias públicas desde su mochila en su página del perfil en este sitio.';
$string['backpackconnectioncancelattempt'] = 'Conectar usando una dirección Email diferente';
$string['backpackconnectionconnect'] = 'Conectar a mochila';
$string['backpackconnectionnottested'] = 'No se pudo probar la conexión para esta mochila porque solamente las mochilas Open Badges 2.0 la soportan.';
$string['backpackconnectionok'] = 'Conexión a mochila restablecida exitosamente';
$string['backpackconnectionresendemail'] = 'Re-enviar Email de verificación';
$string['backpackconnectionunexpectedmessage'] = 'La mochila regresó el error: "{$a}".';
$string['backpackconnectionunexpectedresult'] = 'Hubo un problema al conectar a su Mochila. Su proveedor de mochila está enviando este mensaje: \'{$a}\'.';
$string['backpackdetails'] = 'Configuraciones de mochila';
$string['backpackdisconnected'] = 'La mochila está desconectada';
$string['backpackemail'] = 'Dirección Email';
$string['backpackemail_help'] = 'La dirección Email asociada con su mochila. Mientras Usted esté conectado, cualquier insignia ganada en este sitio estará asociada con esta dirección de Email.';
$string['backpackemail_required'] = 'La dirección de Email no puede estar vacía';
$string['backpackemailverificationpending'] = 'Verificación pendiente';
$string['backpackemailverifyemailbody'] = 'Hola,

Se ha solicitado una nueva conexión a su mochila de insignias desde \'{$a->sitename}\' usando su dirección Email.

Para confirmarlo y activar la conexión a su mochila, por favor haga clic en el enlace inferior.

{$a->link}

En la mayoría de los programas de correo, esto debería de aparecer como un enlace de color azul al cual Usted puede simplemente hacerle clic. Si eso no funcionara, entonces copie y pegue la dirección a la línea para dirección de su navegador web.

Si Usted necesita ayuda, por favor póngase en contacto con el administrador del sitio,
{$a->admin}';
$string['backpackemailverifyemailsubject'] = '{$a}: Verificación de Email de Mochila de Insignias';
$string['backpackemailverifypending'] = 'Se ha enviado un Email de notificación a <strong>{$a}</strong>. Haga clic en el enlace para verificación en el Email para activar su conexión a Mochila.';
$string['backpackemailverifysuccess'] = 'Gracias por verificar su dirección Email. Usted está ahora conectado a su Mochila.';
$string['backpackemailverifytokenmismatch'] = 'La ficha (token) en el enlace al que Usted hizo clic no coincide con el token almacenado. Asegúrese de que Usted hizo clic en el Email más reciente que Usted recibió.';
$string['backpackexporterror'] = 'No se puede exportar la insignia a la mochila';
$string['backpackexporterrorwithinfo'] = 'No se puede exportar la insignia "{$a->badgename}" a la mochila. Error: {$a->error}';
$string['backpackimport'] = 'Configuraciones para importar insignia';
$string['backpackimport_help'] = 'Después de que se establezca la conexión exitosa a mochila, las insignias de su mochila podrán mostrarse en la página de "Mis Insignias" y su página de perfil.

En esta área, Usted puede seleccionar colecciones de insignias desde su mochila que a Usted le gustaría mostrar en su perfil.';
$string['backpackprovider'] = 'Proveedor de Mochila';
$string['backpacksettings'] = 'Configuraciones de mochila';
$string['backpackweburl'] = 'URL de Mochila';
$string['badgedetails'] = 'Detalles de insignia';
$string['badgeimage'] = 'Imagen';
$string['badgeimage_help'] = 'La imagen debería ser de por lo menos 300 x 300 pixeles de tamaño. Será mostrada como 300 x 300 pixeles en la página de la insignia y con 100 x 100 pixeles en la página del perfil del usuario.';
$string['badgeissued'] = 'Insignia emitida';
$string['badgeprivacysetting'] = 'Configuraciones de privacidad de insignia';
$string['badgeprivacysetting_help'] = 'Las insignias que Usted gane pueden mostrarse en su página del perfil de la cuenta. Esta configuración le permite configurar automáticamente la visibilidad de las insignias nuevas ganadas.

Usted todavía puede controlar las configuraciones de privacidad de insignias individuales en su página de insignias.';
$string['badgeprivacysetting_str'] = 'Mostrar automáticamente insignias que obtenga en la página de mi perfil';
$string['badges'] = 'Insignias';
$string['badgesalt'] = 'Sal para \'hashing\' de la dirección Email del destinatario';
$string['badgesalt_desc'] = 'Usar un \'hash\' permite que los servicios de mochila confirmen quién ganó la insignia sin tener que exponer su dirección de correo. Esta configuración solamente debería de usar números y letras.

Nota: Para propósitos de verificación del destinatario, por favor evite cambiar esta configuración una vez que haya empezado a otorgar insignias.';
$string['badgesdisabled'] = 'Las insignias no están habilitadas en este sitio.';
$string['badgesearned'] = 'Número de insignias ganadas: {$a}';
$string['badgesettings'] = 'Configuraciones de insignias';
$string['badgestatus_0'] = 'No disponible';
$string['badgestatus_1'] = 'Disponible';
$string['badgestatus_2'] = 'No disponible (criterio bloqueado)';
$string['badgestatus_3'] = 'Disponible (criterio bloqueado)';
$string['badgestatus_4'] = 'Archivada';
$string['badgestoearn'] = 'Número de insignias disponibles: {$a}';
$string['badgesview'] = 'Insignias de curso';
$string['badgeurl'] = 'Enlace a insignia emitida';
$string['balignment'] = 'Alineaciones ({$a})';
$string['bawards'] = 'Destinatarios ({$a})';
$string['bcriteria'] = 'Criterio';
$string['bdetails'] = 'Editar detalles';
$string['bendorsement'] = 'Aprobación (idoneidad)';
$string['bmessage'] = 'Mensaje';
$string['boverview'] = 'Vista general';
$string['brelated'] = 'Insignias relacionadas ({$a})';
$string['bydate'] = 'completada en';
$string['claim'] = 'Petición';
$string['claimcomment'] = 'Comentario a la Aprobación (Idoneidad)';
$string['claimid'] = 'URL de Pretensión';
$string['clearsettings'] = 'Borrar configuraciones';
$string['completioninfo'] = 'Esta insignia fue emitida por finalizar:';
$string['completionnotenabled'] = 'La finalización de curso no está habilitada para este curso, por lo que no puede incluirse en el criterio para la insignia. Usted puede habilitar la finalización de curso en las configuraciones del curso.';
$string['configenablebadges'] = 'Si se habilita, esta característica le permite crear insignias y otorgarlas a usuarios del sitio.';
$string['configuremessage'] = 'Mensaje de insignia';
$string['connect'] = 'Conectar';
$string['connected'] = 'Conectado';
$string['connecting'] = 'Conectando...';
$string['contact'] = 'Contacto';
$string['contact_help'] = 'Una dirección Email asociada con el emisor de la insignia.';
$string['copyof'] = 'Copia de {$a}';
$string['course'] = 'Curso: {$a}';
$string['coursebadges'] = 'Insignias';
$string['coursebadgesdisabled'] = 'Las insignias del curso no están habilitadas en este sitio.';
$string['coursebadgetitle'] = 'insignia de curso {$a}';
$string['coursecompletion'] = 'Los usuarios deben completar este curso.';
$string['create'] = 'Insignia nueva';
$string['createbutton'] = 'Crear insignia';
$string['creatorbody'] = '<p>{$a->user} ha completado todos los requisitos para la insignia y se le ha otorgado dicha insignia. Vea la insignia emitida en {$a->link} </p>';
$string['creatorsubject'] = '¡\'{$a}\' ha sido otorgada!';
$string['criteria_0'] = 'Esta insignia es otorgada cuando ...';
$string['criteria_1'] = 'Finalización de actividad';
$string['criteria_1_help'] = 'Permitir que una insignia le sea otorgada a usuarios basándose en la finalización de un conjunto de actividades dentro de un curso.';
$string['criteria_2'] = 'Emitida manualmente por un rol';
$string['criteria_2_help'] = 'Permitir que una insignia sea otorgada manualmente por usuarios que tienen un rol particular dentro del sitio o del curso.';
$string['criteria_3'] = 'Participación social';
$string['criteria_3_help'] = 'Social';
$string['criteria_4'] = 'Finalización del curso';
$string['criteria_4_help'] = 'Permitir que una insignia le sea otorgada a usuarios que hayan finalizado el curso. Este criterio puede tener parámetros adicionales, tales como calificación mínima y fecha de terminación del curso.';
$string['criteria_5'] = 'Completando un conjunto de cursos';
$string['criteria_5_help'] = 'Permitir que una insignia le sea otorgada a usuarios que hayan finalizado un conjunto de cursos. Cada curso puede tener parámetros adicionales, tales como calificación mínima y fecha de terminación del curso.';
$string['criteria_6'] = 'Finalización de perfil';
$string['criteria_6_help'] = 'Permitir que una insignia le sea otorgada a usuarios que hayan finalizado ciertos campos en su perfil. Usted puede seleccionar desde campos de perfil por defecto y campos personalizados que estén disponibles a los usuarios.';
$string['criteria_7'] = 'Insignias otorgadas';
$string['criteria_7_help'] = 'Permite que una insignia sea otorgada a usuarios basada en otras insignias que han ganado.';
$string['criteria_8'] = 'Membresía de cohorte';
$string['criteria_8_help'] = 'Permitir que sea entregada una insignia a usuarios basándose en membresía de cohorte.';
$string['criteria_9'] = 'Competencias';
$string['criteria_9_help'] = 'Permitir que una insignia sea otorgada a usuarios, basada en las competencias que ellos han completado.';
$string['criteria_descr'] = 'A los usuarios se les otorga esta insignia cuando completan el requisito siguiente:';
$string['criteria_descr_0'] = 'Completar <strong>{$a}</strong> de los requisitos enlistados.';
$string['criteria_descr_1'] = '<strong>{$a}</strong> de las siguientes actividades están completadas:';
$string['criteria_descr_2'] = 'Esta insignia tiene que ser otorgada por usuarios con  <strong>{$a}</strong> de los siguientes roles:';
$string['criteria_descr_4'] = 'Los usuarios deben finalizar el curso';
$string['criteria_descr_5'] = '<strong>{$a}</strong> de los siguientes cursos deben de ser finalizados:';
$string['criteria_descr_6'] = '<strong>{$a}</strong> de los siguientes campos de perfil deben de ser finalizados:';
$string['criteria_descr_7'] = '<strong>{$a}</strong> de las siguientes insignias tienen que haber sido ganadas:';
$string['criteria_descr_8'] = 'Se requiere pertenecer a las siguiente cohortes <strong>{$a}</strong> :';
$string['criteria_descr_9'] = '<strong>{$a}</strong> de las competencias siguientes tengan que ser completadas:';
$string['criteria_descr_bydate'] = 'para <em>{$a}</em>';
$string['criteria_descr_grade'] = 'con califícación mínima de <em>{$a}</em>';
$string['criteria_descr_short0'] = 'Finalizado <strong>{$a}</strong> de:';
$string['criteria_descr_short1'] = 'Finalizado <strong>{$a}</strong> de:';
$string['criteria_descr_short2'] = 'Otorgada por <strong>{$a}</strong> de:';
$string['criteria_descr_short4'] = 'Finalizar el curso';
$string['criteria_descr_short5'] = 'Finalizar <strong>{$a}</strong> de:';
$string['criteria_descr_short6'] = 'Finalizar <strong>{$a}</strong> de:';
$string['criteria_descr_short7'] = 'Completar <strong>{$a}</strong> de:';
$string['criteria_descr_short8'] = 'Membresía de cohorte en <strong>{$a}</strong> de:';
$string['criteria_descr_short9'] = 'Completar <strong>{$a}</strong> de:';
$string['criteria_descr_single_1'] = 'La siguiente actividad debe ser finalizada:';
$string['criteria_descr_single_2'] = 'Esta insignia tiene que ser otorgada por un usuario con el siguiente rol:';
$string['criteria_descr_single_4'] = 'Los usuarios deben finalizar el curso';
$string['criteria_descr_single_5'] = 'El curso siguiente debe ser finalizado:';
$string['criteria_descr_single_6'] = 'El siguiente campo de perfil de usuario debe de ser finalizado:';
$string['criteria_descr_single_7'] = 'La siguiente insignia tiene que ser ganada:';
$string['criteria_descr_single_8'] = 'Membresía en la siguiente cohorte es requerida:';
$string['criteria_descr_single_9'] = 'Las siguientes competencias tienen que ser completadas:';
$string['criteria_descr_single_short1'] = 'Finalizado:';
$string['criteria_descr_single_short2'] = 'Otorgada por:';
$string['criteria_descr_single_short4'] = 'Finalizar el curso';
$string['criteria_descr_single_short5'] = 'Finalizar:';
$string['criteria_descr_single_short6'] = 'Finalizar:';
$string['criteria_descr_single_short7'] = 'Completas:';
$string['criteria_descr_single_short8'] = 'Membresía en:';
$string['criteria_descr_single_short9'] = 'Completa:';
$string['criteriacreated'] = 'Criterio de insignia creado exitosamente';
$string['criteriadeleted'] = 'Criterio de insignia eliminado exitosamente';
$string['criteriasummary'] = 'Resumen de criterio';
$string['criteriaupdated'] = 'Criterio de insignia actualizado exitosamente';
$string['criterror'] = 'Parámetros actuales';
$string['criterror_help'] = 'Este conjunto de campo muestra todos los parámetros que fueron añadidos inicialmente a este requisito para insignia, pero que ya no están disponibles. Se recomienda que desactive dichos parámetros, para asegurarse de que los usuarios puedan ganarse esta insignia en el futuro.';
$string['currentimage'] = 'Imagen actual';
$string['currentstatus'] = 'Estatus actual:';
$string['dateawarded'] = 'Fecha de emisión';
$string['dateearned'] = 'Fecha: {$a}';
$string['day'] = 'Día(s)';
$string['deactivate'] = 'Deshabilitar acceso';
$string['deactivatesuccess'] = 'El acceso a las insignias fue deshabilitado exitosamente.';
$string['defaultissuercontact'] = 'Dirección Email del emisor de insignia';
$string['defaultissuercontact_desc'] = 'Una dirección Email asociada con el emisor de insignia. Para una mochila de Open Badges v2.0, esto es usado para autenticación cuando se publican insignias a una mochila.';
$string['defaultissuername'] = 'Nombre del emisor de insignia';
$string['defaultissuername_desc'] = 'Nombre del agente emisor o autoridad.';
$string['defaultissuerpassword'] = 'Contraseña del emisor de la insignia';
$string['defaultissuerpassword_help'] = 'Se necesita una cuenta en el sitio de mochila con dirección Email tal como está especificado en la configuración para dirección Email del emisor de insignia en la Administración del sitio / Insignias / Configuraciones de insignias. La contraseña para la cuenta debería ser ingresada aquí.';
$string['delbadge'] = '¿Quisiera Usted eliminar la insignia  \'{$a}\' y remover todas las insignias emitidas existentes?';
$string['delconfirm'] = 'Eliminar y remover insignias emitidas existentes';
$string['delcritconfirm'] = '¿Está Usted seguro de querer eliminar este criterio?';
$string['deletehelp'] = '<p>El borrar completamente una insignia significa que toda su información y registro de criterios serán removidos permanentemente. Los usuarios que hayan ganado esta insignia ya no podrán acceder a ella ni mostrarla en sus páginas de perfiles.</p>
<p>Nota: Los usuarios que hayan ganado esta insignia y que ya la hayan empujado a sus mochilas externas, todavía tendrán esta insignia en sus mochilas externas. Sin embargo, ellos ya no podrán acceder a criterios y páginas de evidencia que enlazan de vuelta hacia este sitio web.</p>';
$string['delexternalbackpack'] = 'Eliminar mochila del sitio';
$string['delexternalbackpackconfirm'] = '¿Eliminar mochila del sitio \'{$a}\'?';
$string['delparamconfirm'] = '¿Está Usted seguro de querer eliminar este parámetro?';
$string['description'] = 'Descripción';
$string['disconnect'] = 'Desconectar';
$string['donotaward'] = 'Actualmente, esta insignia no está activa, por lo que no puede ser otorgada a usuarios. Si Usted desea otorgar esta insignia, por favor configure su estatus a activo.';
$string['enablebadges'] = 'Habilitar insignias';
$string['endorsement'] = 'Aprobación (idoneidad)';
$string['error:backpackdatainvalid'] = 'Los datos regresados por la mochila eran inválidos.';
$string['error:backpackemailnotfound'] = 'El correo \'{$a}\' no está asociado con una mochila. Usted necesita <a href="http://backpack.openbadges.org">crear una mochila (createte a backpack)</a> para esa cuenta o ingresar con otra dirección de correo.';
$string['error:backpacknotavailable'] = 'Su sitio no está accesible desde Internet, por lo que las insignias emitidas desde este sitio no pueden ser verificadas por servicios de mochilas externas.';
$string['error:backpackproblem'] = 'Hubo un problema al conectar con su proveedor del servicio de mochila. Por favor inténtelo después.';
$string['error:badgeawardnotfound'] = 'No puede verificarse esta insignia otorgada. Esta insignia podría haberse revocado.';
$string['error:badgenotfound'] = 'Insignia no encontrada';
$string['error:cannotact'] = 'No se puede activar la insignia';
$string['error:cannotawardbadge'] = 'No se puede otorgar insignia a un usuario';
$string['error:cannotdeletecriterion'] = 'Este criterio no puede ser eliminado.';
$string['error:cannotrevokebadge'] = 'No puede revocarse insignia de un usuario.';
$string['error:clone'] = 'No se puede clonar la insignia';
$string['error:connectionunknownreason'] = 'La conexión fue exitosa, pero no se dió razón.';
$string['error:duplicatename'] = 'Ya existe una insignia con ese nombre en el sistema.';
$string['error:externalbadgedoesntexist'] = 'Insignia no encontrada';
$string['error:guestuseraccess'] = 'Usted actualmente está usando acceso de invitado. Para ver insignias Usted necesita iniciar sesión con su cuenta de usuario.';
$string['error:invalidcriteriatype'] = 'Tipo de criterio inválido.';
$string['error:invalidexpiredate'] = 'La fecha de caducidad debe estar en el futuro.';
$string['error:invalidexpireperiod'] = 'El período de caducidad no puede ser negativo ni igual a 0.';
$string['error:invalidparambadge'] = 'La insignia no existe.';
$string['error:invalidparamcohort'] = 'La cohorte no existe.';
$string['error:noactivities'] = 'No hay actividades con criterio de finalización habilitado en este curso.';
$string['error:nobadges'] = 'Actualmente no hay insignias con acceso habilitado para ser añadidas como criterio. Una insignia del sitio solamente puede tener como criterio a otras insignias del sitio. Una insignia del curso puede tener otras insignias del curso o insignias del sitio como criterios.';
$string['error:nocohorts'] = 'Sin cohortes';
$string['error:nocourses'] = 'La finalización del curso no está habilitada para ninguno de los cursos en este sitio, por lo que no puede mostrarse ninguno. Usted puede habilitar la finalización de cursos en las configuraciones del curso.';
$string['error:nogroupslink'] = '<p>Solamente son mostradas colecciones públicas, <a href="{$a}" target="_blank" rel="nofollow">Visite su mochila</a> para crear algunas colecciones públicas.</p>';
$string['error:nogroupssummary'] = '<p>No hay colecciones públicas de insignias disponibles en su mochila. </p>';
$string['error:nopermissiontoview'] = 'Usted no tiene permisos para ver destinatarios de insignia';
$string['error:nosuchbadge'] = 'La insignia con ID {$a} no existe.';
$string['error:nosuchcohort'] = 'Advertencia: Esta cohorte ya no está disponible.';
$string['error:nosuchcourse'] = 'Advertencia: Este curso ya no está disponible.';
$string['error:nosuchfield'] = 'Advertencia: Este campo de perfil de usuario ya no está disponible.';
$string['error:nosuchmod'] = 'Advertencia: Esta actividad ya no está disponible.';
$string['error:nosuchrole'] = 'Advertencia: Este rol ya no está disponible.';
$string['error:nosuchuser'] = 'El usuario con esta dirección Email no tiene una cuenta con el proveedor de mochila actual.';
$string['error:notifycoursedate'] = 'Advertencia: Las insignias asociadas con las finalizaciones de curso y actividad no serán re-emitidas hasta la fecha de inicio del curso.';
$string['error:parameter'] = 'Advertencia: Al menos un parámetro debería ser seleccionado para asegurar el flujo correcto en la emisión de insignias.';
$string['error:relatedbadgedoesntexist'] = 'No hay insignia pública con este identificador';
$string['error:requesterror'] = 'Falló la solicitud de conexión (código de error {$a}).';
$string['error:requesttimeout'] = 'La solicitud de conexión caducó antes de poder completarse.';
$string['error:save'] = 'No se puede guardar la insignia.';
$string['error:userdeleted'] = '{$a->user} (Este usuario ya no existe más en este sitio {$a->site})';
$string['eventbadgearchived'] = 'Insignia archivada';
$string['eventbadgeawarded'] = 'Insignia otorgada';
$string['eventbadgecreated'] = 'Insignia creada';
$string['eventbadgecriteriacreated'] = 'Criterio de insignia creado';
$string['eventbadgecriteriadeleted'] = 'Criterio de insignia eliminado';
$string['eventbadgecriteriaupdated'] = 'Criterio de insignia actualizado';
$string['eventbadgedeleted'] = 'Insignia eliminada';
$string['eventbadgedisabled'] = 'Insignia deshabilitada';
$string['eventbadgeduplicated'] = 'Insignia duplicada';
$string['eventbadgeenabled'] = 'Insignia habilitada';
$string['eventbadgelistingviewed'] = 'Listado de insignias visto';
$string['eventbadgerevoked'] = 'Insignia revocada';
$string['eventbadgeupdated'] = 'Insignia actualizada';
$string['eventbadgeviewed'] = 'Insignia vista';
$string['evidence'] = 'Evidencia';
$string['existingrecipients'] = 'Destinatarios de insignias existentes';
$string['existsinbackpack'] = 'La insignia ya existe en mochila';
$string['expired'] = 'Caducada';
$string['expiredate'] = 'Esta insignia caduca en {$a}.';
$string['expireddate'] = 'Esta insignia caducó en {$a}.';
$string['expiredin'] = 'Expirada {$a}';
$string['expireperiod'] = 'Esta insignia caduca a los {$a} días de haber sido emitida.';
$string['expireperiodh'] = 'Esta insignia caduca a las {$a} horas de haber sido emitida.';
$string['expireperiodm'] = 'Esta insignia caduca a los {$a} minutos de haber sido emitida.';
$string['expireperiods'] = 'Esta insignia caduca a los {$a} segundos de haber sido emitida.';
$string['expiresin'] = 'Expira {$a}';
$string['expirydate'] = 'Fecha de caducidad';
$string['expirydate_help'] = 'Opcionalmente, las insignias pueden caducar en una fecha específica, o la fecha puede calcularse con base en la fecha en que se emite una insignia.';
$string['externalbadges'] = 'Mis insignias de otros sitios web';
$string['externalbadges_help'] = 'Esta área muestra insignias desde su mochila externa.';
$string['externalbadgesp'] = 'Insignias de otros sitios web:';
$string['externalconnectto'] = 'Para mostrar insignias externas Usted necesita  <a href="{$a}">conectarse a una mochila</a>.';
$string['fixed'] = 'Fecha fija';
$string['hidden'] = 'Oculta';
$string['hiddenbadge'] = 'Desafortunadamente, el propietario de la insignia no ha hecho disponible esta información.';
$string['hostedurl'] = 'URL externa';
$string['hostedurldescription'] = 'URL externa donde está alojada la insignia';
$string['imageauthoremail'] = 'Email del autor de la imagen';
$string['imageauthoremail_help'] = 'Si se especifica, la dirección de email del autor de la imagen de la insignia se muestra en la página de la insignia.';
$string['imageauthorname'] = 'Nombre del autor de la imagen';
$string['imageauthorname_help'] = 'Si se especifica, el nombre del autor de la imagen de la insignia se muestra en la página de la insignia.';
$string['imageauthorurl'] = 'URL del autor de la imagen';
$string['imageauthorurl_help'] = 'Si se especifica, un enlace al sitio web del autor de la imagen de la insignia se muestra en la página de la insignia. La URL debería tener un prefijo http:// o https://.';
$string['imagecaption'] = 'Leyenda de la imagen';
$string['imagecaption_help'] = 'Si se especifica, una leyenda de la imagen es mostrada en la página de la insignia.';
$string['includeauthdetails'] = 'Incluir detalles de autenticación con la mochila';
$string['invalidurl'] = 'URL inválida';
$string['issuancedetails'] = 'Caducidad de insignia';
$string['issuedbadge'] = 'Información acerca de insignia emitida';
$string['issuedby'] = 'Emitida por {$a}';
$string['issuedon'] = 'Emitida {$a}';
$string['issuerdetails'] = 'Detalles del emisor';
$string['issueremail'] = 'Email';
$string['issueremail_help'] = 'Una dirección Email de contacto de la organización que emite la aprobación (idoneidad)';
$string['issuername'] = 'Nombre del emisor';
$string['issuername_endorsement'] = 'Nombre de quien aprueba (idoneidad)';
$string['issuername_endorsement_help'] = 'El nombre de quien aprueba (idoneidad)';
$string['issuername_help'] = 'Nombre del agente emisor o autoridad.';
$string['issuerurl'] = 'URL del emisor';
$string['issuerurl_help'] = 'El sitio web de la organización que emite la aprobación de idoneidad. La URL debería tener un prefijo http:// o https://.';
$string['language'] = 'Idioma';
$string['language_help'] = 'El idioma usado en la página de la insignia.';
$string['listbackpacks'] = 'Lista de mochilas';
$string['localbadges'] = 'Mis insignias de {$a} sitio web';
$string['localbadgesh'] = 'Mis insignias de este sitio web';
$string['localbadgesh_help'] = 'Todas las insignias ganadas dentro de este sitio web al completar cursos, acyividades de cursos, y otros requisitos. Usted puede gestionar aquí sus insignias al hacerlas públicas o privadas para su página de perfil. Usted puede descargar todas sus insignias, o cada insignia de forma separada, y guardarlas en su computadora. Las insignias descargadas pueden añadirse a su servicio de mochila externa.';
$string['localbadgesp'] = 'Insignias de {$a}:';
$string['localconnectto'] = 'Para compartir estas insignias afuera de este sitio web, Usted necesita  <a href="{$a}">conectarse a una mochila</a>.';
$string['makeprivate'] = 'Hacer privadas';
$string['makepublic'] = 'Hacer públicas';
$string['managebackpacks'] = 'Gestionar mochilas';
$string['managebadges'] = 'Gestionar insignias';
$string['message'] = 'Cuerpo del mensaje';
$string['messagebody'] = '<p>¡A Usted le han otorgado la insignia "%badgename%"!</p>
<p>Puede encontrar más información acerca de esta insignia en la página de información de la insignia  %badgelink% .</p>
<p>Usted puede descargar y gestionar la insignia desde su página de  {$a} .</p>';
$string['messagesubject'] = '¡Felicitaciones! ¡Acaba de ganarse una insignia!';
$string['method'] = 'El criterio está completo cuando ...';
$string['mingrade'] = 'Calificación mínima requerida';
$string['month'] = 'Mes(es)';
$string['moredetails'] = 'Más detalles';
$string['mybackpack'] = 'Mis configuraciones de mochila';
$string['mybadges'] = 'Mis insignias';
$string['never'] = 'Nunca';
$string['newbackpack'] = 'Añadir una nueva mochila';
$string['newbadge'] = 'Añadir una insignia nueva';
$string['newimage'] = 'Nueva imagen';
$string['noalignment'] = 'Esta insignia no tiene ninguna habilidad externa o estándar especificado.';
$string['noawards'] = 'Esta insignia aún no ha sido ganada.';
$string['nobackpack'] = 'No hay servicio de mochila conectado a esta cuenta.<br/>';
$string['nobackpackbadgessummary'] = 'No hay insignias en las colecciones que Usted ha seleccionado.';
$string['nobackpackcollectionssummary'] = 'No ha sido seleccionada ninguna colección de insignias.';
$string['nobackpacks'] = 'No hay mochilas disponibles';
$string['nobadges'] = 'Actualmente no hay insignias disponibles para que obtengan los usuarios.';
$string['nocompetencies'] = 'Sin competencias seleccionadas.';
$string['nocriteria'] = 'Los criterios para esta insignia todavía no han sido configurados.';
$string['noendorsement'] = 'La insignia no tiene quien soporte la idoneidad.';
$string['noexpiry'] = 'Esta insignia no tiene una fecha de expiración..';
$string['noparamstoadd'] = 'No hay parámetros adicionales disponibles para añadirle a este requisito de insignia.';
$string['norelated'] = 'La insignia no tiene ninguna insignia relacionada.';
$string['notacceptedrole'] = 'Su asignación de rol actual no está entre los roles que pueden emitir manualmente esta insignia.<br/> Si Usted quisiera ver a los usuarios que ya se han ganado esta insignia, puede visitar la página {$a}.';
$string['notconnected'] = 'No conectado';
$string['notealignment'] = 'Estándares o habilidades externas, con los que la insignia está alineada, deben ser especificados. Cualquier estándar o habilidad externa son mostrados en la página de la insignia.';
$string['noteendorsement'] = 'El apoyo (idoneidad) por un tercero puede ser usado para añadirle valor a la insignia. Por ejemplo, una insignia emitida por un profesor puede ser apoyada (idoneidad) por la escuela, o una insignia emitida por un cuerpo local de otorgamiento puede ser apoyada (idoneidad) por el cuerpo otorgante nacional.';
$string['noterelated'] = 'Las insignias con una conexión serán marcadas como relacionadas. Por ejemplo, las insignias con el mismo criterio que son mostradas en diferentes idiomas pueden ser marcadas como relacionadas. Cualquier insignia relacionada es mostrada en la página de insignias.';
$string['nothingtoadd'] = 'No hay criterios disponibles para añadir.';
$string['notification'] = 'Notificar al creador de la insignia';
$string['notification_help'] = 'Esta configuración gestiona las notificaciones enviadas a un creador de insignias para hacerles saber que la insignia ha sido emitida.

Las siguientes opciones están disponibles:

* **NUNCA** - No enviar notificaciones.

* **SIEMPRE** - Enviar una notificación cada vez que se concede esta insignia.

* **DIARIAMENTE** - Enviar notificaciones una vez al día.

* **SEMANALMENTE** - Enviar notificaciones una vez a la semana.

*** MENSUALMENTE** - Enviar notificaciones una vez al mes.';
$string['notifydaily'] = 'Diariamente';
$string['notifyevery'] = 'Cada vez';
$string['notifymonthly'] = 'Mensualmente';
$string['notifyweekly'] = 'Semanalmente';
$string['numawards'] = 'Esta insignia ha sido emitida para <a href="{$a->link}">{$a->count}</a> usuario(s).';
$string['numawardstat'] = 'Esta insignia ha sido emitida a {$a} usuario(s).';
$string['oauth2issuer'] = 'Servicios OAuth 2';
$string['openbadgesv1'] = 'Open Badges v1.0';
$string['openbadgesv2'] = 'Open Badges v2.0';
$string['openbadgesv2p1'] = 'Open Badges v2.1';
$string['othernavigation'] = 'Otra navegación ...';
$string['overallcrit'] = 'de los criterios seleccionados están completados.';
$string['password_required'] = 'La contraseña no puede estar vacía';
$string['potentialrecipients'] = 'Destinatarios potenciales de insignia';
$string['preferences'] = 'Preferencias de Insignia';
$string['privacy:metadata:backpack'] = 'Un registro de las mochilas del usuario';
$string['privacy:metadata:backpack:backpackuid'] = 'El identificador único de la mochila';
$string['privacy:metadata:backpack:email'] = 'El Email asociado con la mochila';
$string['privacy:metadata:backpack:externalbackpackid'] = 'La ID de la mochila';
$string['privacy:metadata:backpack:userid'] = 'La ID del usuario de la mochila';
$string['privacy:metadata:backpackoauth2'] = 'Información OAuth 2 cuando el usuario se conecta a una mochila externa';
$string['privacy:metadata:backpackoauth2:issuerid'] = 'ID del servicio Oauth 2';
$string['privacy:metadata:backpackoauth2:scope'] = 'Enlistar el alcance de conexión de mochila';
$string['privacy:metadata:backpackoauth2:token'] = 'El token (ficha) de conexión de mochila';
$string['privacy:metadata:backpackoauth2:userid'] = 'La ID del usuario con conexión de mochila';
$string['privacy:metadata:backpackoauth2:usermodified'] = 'La ID del usuario que modificó el contenido';
$string['privacy:metadata:badge'] = 'Una colección de insignias';
$string['privacy:metadata:badge:timecreated'] = 'La hora en la cual fue creada la insignia';
$string['privacy:metadata:badge:timemodified'] = 'La hora en la cual fue modificada por última vez la insignia';
$string['privacy:metadata:badge:usercreated'] = 'La ID del usuario que creó la insignia';
$string['privacy:metadata:badge:usermodified'] = 'La ID del usuario que modificó la insignia';
$string['privacy:metadata:criteriamet'] = 'Una colección de criterios que han sido cumplidos';
$string['privacy:metadata:criteriamet:datemet'] = 'La fecha en la cual se cumplieron los criterios';
$string['privacy:metadata:criteriamet:userid'] = 'La ID del usuario que ha cumplido con los criterios';
$string['privacy:metadata:external:backpacks'] = 'Información almacenada sobre cuando los usuarios enviaron sus insignias a una mochila externa';
$string['privacy:metadata:external:backpacks:badge'] = 'El nombre de la insignia';
$string['privacy:metadata:external:backpacks:description'] = 'La descripción de la insignia';
$string['privacy:metadata:external:backpacks:image'] = 'La imagen de la insignia';
$string['privacy:metadata:external:backpacks:issuer'] = 'Alguna información sobre el emisor';
$string['privacy:metadata:external:backpacks:url'] = 'La URL de Moodle en donde puede verse la información de la insignia emitida';
$string['privacy:metadata:issued'] = 'Un registro de insignias emitidas';
$string['privacy:metadata:issued:dateexpire'] = 'La fecha en la cual caduca la insignia';
$string['privacy:metadata:issued:dateissued'] = 'La fecha de la distinción';
$string['privacy:metadata:issued:userid'] = 'La ID del usuario a quien se le otorgó una insignia';
$string['privacy:metadata:manualaward'] = 'Un registro de otorgamientos manuales';
$string['privacy:metadata:manualaward:datemet'] = 'La fecha en la cual al usuario le fue otorgada la insignia';
$string['privacy:metadata:manualaward:issuerid'] = 'La ID del usuario que otorga la insignia';
$string['privacy:metadata:manualaward:issuerrole'] = 'El rol del usuario que otorga la insignia';
$string['privacy:metadata:manualaward:recipientid'] = 'La ID del usuario que está otorgando manualmente la insignia';
$string['recipient'] = 'Receptor de la insignia';
$string['recipientdetails'] = 'Detalles del destinatario';
$string['recipientidentificationproblem'] = 'No se puede encontrar un destinatario de esta insignia entre los usuarios existentes.';
$string['recipients'] = 'Destinatarios de insignia';
$string['recipientvalidationproblem'] = 'Este usuario actual no puede ser verificado como destinatario para esta insignia.';
$string['relatedbages'] = 'Insignias relacionadas';
$string['relative'] = 'Fecha relativa';
$string['requiredbadge'] = 'Al menos una insignia debería de ser añadida al criterio de insignia.';
$string['requiredcohort'] = 'Al menos una cohorte debería ser añadida al criterio de cohorte.';
$string['requiredcompetency'] = 'Al menos una competencia debería ser añadida al criterio de la competencia.';
$string['requiredcourse'] = 'Al menos debería de añadirse un curso al criterio del curso';
$string['reviewbadge'] = 'Cambios en acceso a insignia';
$string['reviewconfirm'] = '<p>Ésto hará a su insignia visible a los usuarios y les permitirá empezar a ganársela.</p>

<p>Es posible que algunos usuarios ya hayan cubierto los criterios de la insignia y esta insignia  les será otorgada inmediatamente después de que Usted la habilite.</p>

<p>Una vez que una insignia haya sido emitida, será <strong>bloqueada</strong> - algunas configuraciones, incluyendo los criterios y la fecha de caducidad ya no podrán ser cambiadas.</p>

<p>¿ Está Usted seguro de querer habilitar el acceso a la insignia \'{$a}\'?</p>';
$string['revoke'] = 'Revocar insignia';
$string['save'] = 'Guardar';
$string['searchname'] = 'Buscar por nombre';
$string['selectaward'] = 'Por favor seleccione el rol que le gustaría usar para otorgar esta insignia:';
$string['selectgroup_end'] = 'Solamente son mostradas colecciones públicas,  <a href="{$a}">visite su mochila</a> para crear más colecciones públicas.';
$string['selectgroup_start'] = 'Seleccione colecciones desde su mochila para mostrar en este sitio:';
$string['selecting'] = 'Con insignias seleccionadas ...';
$string['setup'] = 'Configurar conexión';
$string['sitebackpack'] = 'Mochila externa activa';
$string['sitebackpack_help'] = 'La mochila externa a la que pueden conectarse los usuarios desde este sitio. Tenga en cuenta que el cambiar esta configuración después de que los usuarios hayan conectado sus mochilas requerirá que cada usuario vaya a su página de configuraciones de la mochila y desconecte y re-conecte.';
$string['sitebackpackdeleted'] = 'La mochila del sitio ha sido eliminada.';
$string['sitebackpacknotdeleted'] = 'Esta mochila no pudo ser eliminada porque actualmente es la predeterminada del sitio.';
$string['sitebackpackwarning'] = 'No fue posible conectarse a mochila. <br/><br/>Revise que la configuración administrativa "Dirección Email del emisor de insignia" sea el Email válido para una cuenta en el sitio web de la mochila. <br/><br/>Revise que la "Contraseña del emisor de insignia" en la <a href="{$a->url}">página de configuraciones de mochila del sitio </a>, sea la contraseña correcta para la cuenta en el sitio web de la mochila. <br/><br/>La mochila regresó: "{$a->warning}"';
$string['sitebadges'] = 'Insignias del sitio';
$string['sitebadges_help'] = 'Las insignias del sitio solamente pueden ser otorgadas a usuarios por actividades relacionadas con el sitio. Estas incluyen el completar un conjunto de cursos o partes de perfiles de usuarios. Las insignias del sitio también pueden emitirse manualmente por un usuario a otro.

Las insignias para actividades relacionadas con curso deben crearse a nivel del curso. Las insignias de curso pueden encontrarse en Administración del Curso > Insignias.';
$string['sitebadgetitle'] = 'insignia {$a} del sitio';
$string['status'] = 'Estatus de insignias';
$string['status_help'] = 'El estatus de una insignia determina su comportamiento en el sistema: * **DISPONIBLE** – Significa que esta insignia puede ser ganada por los usuarios. Mientras una insignia esté disponible a los usuarios, su criterio no puede modificarse. * **NO DISPONIBLE** – Significa que esta insignia no está disponible para los usuarios y no puede ganarse ni otorgarse manualmente. Si una de estas insignias nunca ha sido emitida anteriormente, se puede cambiar su criterio. Una vez que una insignia haya sido emitida para al menos un usuario, automáticamente se cambia a  **BLOQUEADA**. Las insignias bloqueadas pueden ser ganadas por usuarios, pero sus criterios ya no pueden ser cambiados. Si Usted necesita modificar detalles o criterios de una insignia bloqueada, Usted puede duplicar esta insignia y hacerle todos los cambios necesarios. *¿Porqué bloqueamos insignias?* Queremos asegurarnos de que todos los usuarios completen los mismos requisitos para ganarse una insignia. Actualmente no es posible revocar insignias. Si nosotros permitiéramos que se modificaran los requisitos de la insignia a cada rato, lo más probable es que terminaríamos teniendo usuarios que hubieran conseguido la misma insignia por haber cumplido requisitos completamente diferentes.';
$string['statusmessage_0'] = 'Esta insignia actualmente no está disponible para los usuarios. Habilite el acceso si desea que los usuarios se ganen esta insignia.';
$string['statusmessage_1'] = 'Esta insignia actualmente sí está disponible para los usuarios. Deshabilite el acceso para realizar cambios.';
$string['statusmessage_2'] = 'Esta insignia actualmente no está disponible para los usuarios y su criterio está bloqueado. Habilite el acceso si desea que los usuarios se ganen esta insignia.';
$string['statusmessage_3'] = 'Esta insignia actualmente sí está disponible para los usuarios y su criterio está bloqueado';
$string['statusmessage_4'] = 'esta insignia actualmente está archivada';
$string['subject'] = 'Asunto del mensaje';
$string['targetcode'] = 'Código';
$string['targetcode_help'] = 'Un identificador de cadena de caracteres único para referenciar el estándar o habilidad externa dentro de su estructura.';
$string['targetdescription'] = 'Descripción';
$string['targetdescription_help'] = 'Descripción breve del estándar o habilidad externa.';
$string['targetframework'] = 'Estructura';
$string['targetframework_help'] = 'El nombre de la estructura estándar o habilidad externa.';
$string['targetname'] = 'Nombre';
$string['targetname_help'] = 'La habilidad externa o estándar con la cual está alineada la insignia.';
$string['targeturl'] = 'URL';
$string['targeturl_help'] = 'Un enlace hacia una página que describe la habilidad externa o estándar. La URL debería tener un prefijo http:// o https://.';
$string['testbackpack'] = 'Probar mochila \'{$a}\'';
$string['testsettings'] = 'Configuraciones de prueba';
$string['type'] = 'Tipo';
$string['userbadges'] = 'Insignias del usuario';
$string['variablesubstitution'] = 'Sustitución de variable en los mensajes.';
$string['variablesubstitution_help'] = 'En un mensaje de insignia, se pueden insertar ciertas variables en el asunto o en el cuerpo del mensaje, de forma que sean luego remplazadas con valores reales cuando se envíe el mensaje. Las variables deberían de ser insertadas en el texto exactamente como se muestra debajo. Se pueden usar las siguientes variables:

%badgename% : Esto será remplazado por el nombre completo de la insignia.

%username% : Esto será remplazado por el nombre completo del destinatario.

%badgelink% : Esto será remplazado por la URL pública con información acerca de la insignia emitida.';
$string['version'] = 'Versión';
$string['version_help'] = 'El campo de versión puede ser usado para llevar un registro del desarrollo de la insignia. Si se especifica, se muestra la versión en la página de la insignia.';
$string['viewbadge'] = 'Ver insignia emitida';
$string['visible'] = 'Visible';
$string['warnexpired'] = '(Esta insignia ha caducado)';
$string['year'] = 'Año(s)';
