<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_casattras', language 'cs', version '4.2'.
 *
 * @package     auth_casattras
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_casattras_auth_logo'] = 'Logo metody ověřování';
$string['auth_casattras_auth_logo_description'] = 'Poskytnout logo pro metodu ověřování CAS, které je vašim uživatelům známé.';
$string['auth_casattras_auth_name'] = 'Název metody autentizace';
$string['auth_casattras_auth_name_description'] = 'Zadejte název pro metodu ověřování CAS, který je vašim uživatelům známý.';
$string['auth_casattras_auth_service'] = 'CAS';
$string['auth_casattras_baseuri'] = 'URI serveru (nic, pokud není baseUri)<br />Pokud například server CAS odpoví na login.example.edu/cas/, pak<br />cas_baseuri = cas/';
$string['auth_casattras_baseuri_key'] = 'Základní URI';
$string['auth_casattras_casversion'] = 'Verze protokolu CAS';
$string['auth_casattras_certificate_check'] = 'Chcete-li ověřit certifikát serveru, vyberte „ano“.';
$string['auth_casattras_certificate_check_key'] = 'Ověření serveru';
$string['auth_casattras_certificate_path'] = 'Cesta k souboru řetězce CA (formát PEM) k ověření certifikátu serveru';
$string['auth_casattras_certificate_path_empty'] = 'Pokud zapnete ověřování serveru, musíte zadat cestu k certifikátu';
$string['auth_casattras_certificate_path_key'] = 'Cesta k certifikátu';
$string['auth_casattras_extrafields'] = 'Tato pole jsou volitelná. Můžete se rozhodnout předvyplnit některá uživatelská pole Moodle informacemi z autentizační odpovědi CAS, pokud to váš CAS server podporuje. <p>Pokud tato pole ponecháte prázdná, nebude použito nic kromě ID uživatele přidaného do uživatelského účtu a výchozího nastavení Moodle.</p><p>V obou případech bude uživatel moci upravovat všechna tato pole poté, co se přihlásí.</p>';
$string['auth_casattras_hostname'] = 'Název hostitele CAS serveru <br />např.: login.example.edu';
$string['auth_casattras_hostname_key'] = 'Název hostitele';
$string['auth_casattras_logout_return_url'] = 'Zadejte adresu URL, na kterou mají být uživatelé CAS přesměrováni po odhlášení.<br />Pokud pole ponecháte prázdné, uživatelé budou přesměrováni na místo, kam uživatele moodle přesměruje.';
$string['auth_casattras_logout_return_url_key'] = 'Alternativní návratová URL pro odhlášení';
$string['auth_casattras_logoutcas'] = 'Vyberte "ano", pokud se chcete odhlásit z CAS, když se odpojíte od Moodle';
$string['auth_casattras_logoutcas_key'] = 'Možnost odhlášení z CAS';
$string['auth_casattras_multiauth'] = 'Vyberte \'ano\', pokud chcete mít vícenásobnou autentizaci (CAS + jiné ověřování)';
$string['auth_casattras_multiauth_key'] = 'Vícenásobná autentizace';
$string['auth_casattras_port'] = 'Port serveru CAS';
$string['auth_casattras_port_key'] = 'Port';
$string['auth_casattras_proxycas'] = 'Pokud používáte CAS v režimu proxy, vyberte „ano“.';
$string['auth_casattras_proxycas_key'] = 'Režim proxy';
$string['auth_casattras_server_settings'] = 'Konfigurace CAS serveru';
$string['auth_casattras_version'] = 'Verze protokolu CAS k použití. Všimněte si, že pouze SAML 1.1 ve výchozím nastavení podporuje vydávání atributů. Odpověď CAS 2.0 je často přizpůsobena tak, aby vracela atributy.';
$string['auth_casattrasdescription'] = 'Tato metoda používá server CAS (Central Authentication Service) k ověřování uživatelů v prostředí jednotného přihlášení (SSO). Uživatelské atributy jsou vráceny v ověřovací odpovědi CAS, nikoli ze serveru LDAP. To umožňuje použití serverů CAS, které nejsou podporovány serverem LDAP nebo jsou podporovány více servery LDAP. Pokud jsou zadané uživatelské jméno a heslo platné podle CAS, Moodle vytvoří nový uživatelský záznam ve své databázi a převezme uživatelské atributy z autentizační odpovědi CAS, pokud je nakonfigurována.';
$string['cas_conflict_warning'] = 'Není kompatibilní s "CAS server (SSO)", nejprve vypněte tento plugin.';
$string['casattras_disabled_by_cas'] = '"Server CAS (SSO) s vydáním uživatelského atributu" byl zakázán, protože je povolen plugin "Server CAS (SSO)". Tyto ověřovací pluginy budou ve vzájemném konfliktu a současně může být povolen pouze jeden.';
$string['convert_authtype'] = 'Převést:';
$string['convert_authtype_cas_to_casattras'] = 'Převést {$a->cas} uživatele z „CAS server (SSO)“ na „CAS server (SSO) s vydáním uživatelského atributu“';
$string['convert_authtype_casattras_to_cas'] = 'Převést {$a->casattras} uživatelů ze „serveru CAS (SSO) s vydáním uživatelského atributu“ na „server CAS (SSO)“';
$string['convert_authtype_none'] = 'Žádná konverze';
$string['convert_user_auth_types'] = 'Převést typy ověřování uživatelů (volitelné)';
$string['pluginname'] = 'Server CAS (SSO) s vydáním uživatelských atributů';
$string['privacy:metadata'] = 'Plugin pro ověřování atributů CAS neukládá žádné osobní údaje.';
