<?php

/**
 * This file is part of an ADDON for use with LEPTON Core.
 * This ADDON is released under the GNU GPL.
 * Additional license terms can be seen in the info.php of this module.
 *
 *
 *	@module			captcha_control
 *	@version		see info.php of this module
 *	@authors		LEPTON Project, W. Studer
 *	@copyright		2010-2025 LEPTON Project
 *	@link			https://lepton-cms.org
 *	@license		https://gnu.org/licenses/gpl.html
 *	@license_terms	please see info.php of this module
 *	@platform		see info.php of this module
 *
 *
 */
 
// include secure.php to protect this file and the whole CMS!
if(!defined("SEC_FILE")){define("SEC_FILE",'/framework/secure.php' );}
if (defined('LEPTON_PATH')) {	
	include LEPTON_PATH.SEC_FILE;
} else {
	$oneback = "../";
	$root = $oneback;
	$level = 1;
	while (($level < 10) && (!file_exists($root.SEC_FILE))) {
		$root .= $oneback;
		$level += 1;
	}
	if (file_exists($root.SEC_FILE)) { 
		include $root.SEC_FILE;   
	} else {
		trigger_error(sprintf("[ <b>%s</b> ] Can't include secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
	}
}
// end include secure file


if ( false === isset($_SESSION['captcha_time']))
{
	header("Location: ../index.php");
	die();
}

// Captcha
$t = time();
$_SESSION['captcha_time'] = $t;

$reload = "<a title='reload'"
		. "href='" . str_replace( LEPTON_PATH, LEPTON_URL, __DIR__ ) . "/reload.php' >";
$reload .= "<img " . $_SESSION['CAPTCHA_IMAGE_ATTR'] . " id='captcha_image' src='" . $_SESSION['CAPTCHA_IMAGE_SRC'] . "' title='captcha' />";
$reload .= "</a>";

echo $reload;


