﻿/*
Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license/
*/
CKEDITOR.lang['pt']={"application":"Rich Text Editor","editor":"Editor de texto enriquecido","editorPanel":"Painel do editor de texto enriquecido","common":{"editorHelp":"Pressione ALT+0 para ajuda","browseServer":"Navegar no servidor","url":"URL","protocol":"Protocolo","upload":"Carregar","uploadSubmit":"Enviar para o servidor","image":"Imagem","form":"Formulário","checkbox":"Caixa de verificação","radio":"Botão","textField":"Campo de texto","textarea":"Área de texto","hiddenField":"Campo oculto","button":"Botão","select":"Campo de seleção","imageButton":"Botão da imagem","notSet":"<Não definido>","id":"ID","name":"Nome","langDir":"Direção do idioma","langDirLtr":"Esquerda para a Direita (EPD)","langDirRtl":"Direita para a Esquerda (DPE)","langCode":"Código do idioma","longDescr":"Descrição completa do URL","cssClass":"Classes de estilo das folhas","advisoryTitle":"Título consultivo","cssStyle":"Estilo","ok":"CONFIRMAR","cancel":"Cancelar","close":"Fechar","preview":"Pré-visualização","resize":"Redimensionar","generalTab":"Geral","advancedTab":"Avançado","validateNumberFailed":"Este valor não é um numero.","confirmNewPage":"Irão ser perdidas quaisquer alterações não guardadas. Tem a certeza que deseja carregar a nova página?","confirmCancel":"Foram alteradas algumas das opções. Tem a certeza que deseja fechar a janela?","options":"Opções","target":"Destino","targetNew":"Nova janela (_blank)","targetTop":"Janela superior (_top)","targetSelf":"Mesma janela (_self)","targetParent":"Janela dependente (_parent)","langDirLTR":"Esquerda para a Direita (EPD)","langDirRTL":"Direita para a Esquerda (DPE)","styles":"Estilo","cssClasses":"Classes de folhas de estilo","width":"Largura","height":"Altura","align":"Alinhamento","left":"Esquerda","right":"Direita","center":"Centrado","justify":"Justificado","alignLeft":"Alinhar à esquerda","alignRight":"Alinhar à direita","alignCenter":"Centrado","alignTop":"Topo","alignMiddle":"Meio","alignBottom":"Base","alignNone":"Nenhum","invalidValue":"Valor inválido.","invalidHeight":"A altura deve ser um número.","invalidWidth":"A largura deve ser um número. ","invalidLength":"Value specified for the \"%1\" field must be a positive number with or without a valid measurement unit (%2).","invalidCssLength":"O valor especificado para o campo \"1%\" deve ser um número positivo, com ou sem uma unidade de medida CSS válida (px, %, in, cm, mm, em, ex, pt, ou pc).","invalidHtmlLength":"O valor especificado para o campo \"1%\" deve ser um número positivo, com ou sem uma unidade de medida HTML válida (px ou %).","invalidInlineStyle":"O valor especificado para o estilo em linha deve constituir um ou mais conjuntos de valores com o formato de \"nome : valor\", separados por ponto e vírgula.","cssLengthTooltip":"Insira um número para um valor em píxeis ou um número com uma unidade CSS válida (px, %, in, cm, mm, em, ex, pt, ou pc).","unavailable":"%1<span class=\"cke_accessibility\">, indisponível</span>","keyboard":{"8":"Backspace","13":"Enter","16":"Shift","17":"Ctrl","18":"Alt","32":"Espaço","35":"Fim","36":"Entrada","46":"Eliminar","112":"F1","113":"F2","114":"F3","115":"F4","116":"F5","117":"F6","118":"F7","119":"F8","120":"F9","121":"F10","122":"F11","123":"F12","124":"F13","125":"F14","126":"F15","127":"F16","128":"F17","129":"F18","130":"F19","131":"F20","132":"F21","133":"F22","134":"F23","135":"F24","224":"Comando"},"keyboardShortcut":"Atalho de teclado","optionDefault":"Padrão"},"versionCheck":{"notificationMessage":"This CKEditor %current version is not secure. Consider <a target=\"_blank\" href=\"%link\">upgrading to the latest one</a>, %latest.","consoleMessage":"This CKEditor %current version is not secure. Consider upgrading to the latest one, %latest: %link","aboutDialogInsecureMessage":"This CKEditor %current version is not secure.<br>Consider upgrading to the latest one, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>","aboutDialogUpgradeMessage":"Consider upgrading to the latest editor version, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>"},"about":{"copy":"Direitos de Autor &copy; $1. Todos os direitos reservados.","dlgTitle":"Sobre o CKEditor 4","moreInfo":"Para informação sobre licenciamento visite o nosso sítio web:"},"basicstyles":{"bold":"Negrito","italic":"Itálico","strike":"Rasurado","subscript":"Superior à linha","superscript":"Superior à linha","underline":"Sublinhado"},"bidi":{"ltr":"Direção do texto da esquerda para a direita","rtl":"Direção do texto da direita para a esquerda"},"blockquote":{"toolbar":"Bloco de citação"},"notification":{"closed":"Notificação encerrada."},"toolbar":{"toolbarCollapse":"Ocultar barra de ferramentas","toolbarExpand":"Expandir barra de ferramentas","toolbarGroups":{"document":"Documento","clipboard":"Área de transferência/Anular","editing":"Edição","forms":"Formulários","basicstyles":"Estilos básicos","paragraph":"Parágrafo","links":"Hiperligações","insert":"Inserir","styles":"Estilos","colors":"Cores","tools":"Ferramentas"},"toolbars":"Editor de barras de ferramentas"},"clipboard":{"copy":"Copiar","copyError":"A configuração de segurança do navegador não permite a execução automática de operações de copiar. Por favor use o teclado (Ctrl/Cmd+C).","cut":"Cortar","cutError":"A configuração de segurança do navegador não permite a execução automática de operações de cortar. Por favor use o teclado (Ctrl/Cmd+X).","paste":"Colar","pasteNotification":"Press %1 to paste. Your browser doesn‘t support pasting with the toolbar button or context menu option.","pasteArea":"Área de colagem","pasteMsg":"Paste your content inside the area below and press OK.","fileFormatNotSupportedNotification":"The ${formats} file format(s) are not supported.","fileWithoutFormatNotSupportedNotification":"The file format is not supported."},"colorbutton":{"auto":"Automático","bgColorTitle":"Cor de fundo","colors":{"000":"Black","800000":"Castanho","8B4513":"Saddle Brown","2F4F4F":"Cinza lousa escuro","008080":"Teal","000080":"Azul naval","4B0082":"Indigo","696969":"Cinza escuro","B22222":"Vermelho tijolo","A52A2A":"Castanho","DAA520":"Dourado (daa520)","006400":"Verde escuro (006400)","40E0D0":"Turquesa","0000CD":"Azul médio (0000cd)","800080":"Purple","808080":"Cinza","F00":"Vermelho","FF8C00":"Laranja escuro","FFD700":"Dourado","008000":"Verde","0FF":"Ciano","00F":"Azul","EE82EE":"Violeta","A9A9A9":"Cinza fosco","FFA07A":"Salmão claro","FFA500":"Laranja","FFFF00":"Amarelo","00FF00":"Limão (Verde espectro)","AFEEEE":"Turquesa pálida (afeeee)","ADD8E6":"Light Blue","DDA0DD":"Ameixa","D3D3D3":"Cinza claro","FFF0F5":"Lavanda avermelhada","FAEBD7":"Branco velho","FFFFE0":"Amarelo claro","F0FFF0":"Maná (f0fff0)","F0FFFF":"Azul celeste","F0F8FF":"Azul Alice (f0f8ff)","E6E6FA":"Lavanda","FFF":"Branco","1ABC9C":"Ciano forte","2ECC71":"Esmeralda","3498DB":"Azul brilhante","9B59B6":"Amethyst","4E5F70":"Azul acinzentado","F1C40F":"Amarelo vívido","16A085":"Ciano escuro","27AE60":"Esmeralda escuro","2980B9":"Azul forte","8E44AD":"Violeta escuro","2C3E50":"Desaturated Blue","F39C12":"Laranja","E67E22":"Cenoura","E74C3C":"Vermelho claro","ECF0F1":"Prateado brilhante","95A5A6":"Ciano acinzentado claro","DDD":"Cinza claro","D35400":"Abóbora","C0392B":"Strong Red","BDC3C7":"Prateado","7F8C8D":"Ciano acinzentado","999":"Cinza escuro"},"more":"Mais cores...","panelTitle":"Cores","textColorTitle":"Cor do texto"},"colordialog":{"clear":"Limpar","highlight":"Realçar","options":"Opções de cor","selected":"Cor selecionada","title":"Selecionar cor"},"templates":{"button":"Temas","emptyListMsg":"(Sem temas definidos)","insertOption":"Substituir conteúdos atuais","options":"Opções do modelo","selectPromptMsg":"Por favor, selecione o modelo a abrir no editor","title":"Conteúdo dos modelos"},"contextmenu":{"options":"Menu de opções de contexto"},"copyformatting":{"label":"Copiar formatação","notification":{"copied":"Formatação copiada","applied":"Formatação aplicada","canceled":"Formatação cancelada","failed":"Formatting failed. You cannot apply styles without copying them first."}},"div":{"IdInputLabel":"ID","advisoryTitleInputLabel":"Título","cssClassInputLabel":"Classes de folhas de estilo","edit":"Editar Div","inlineStyleInputLabel":"Estilo na etiqueta","langDirLTRLabel":"Esquerda para a direita (EPD)","langDirLabel":"Orientação de idioma","langDirRTLLabel":"Direita para a Esquerda (DPE)","languageCodeInputLabel":"Código do idioma","remove":"Remover Div","styleSelectLabel":"Estilo","title":"Criar Div","toolbar":"Criar Div"},"elementspath":{"eleLabel":"Caminho dos elementos","eleTitle":"Elemento %1"},"exportpdf":{"documentReady":"Document is ready!","error":"Error occurred.","processingDocument":"Processing PDF document...","toolbar":"Export to PDF"},"filetools":{"loadError":"Ocorreu um erro ao ler o ficheiro","networkError":"Ocorreu um erro de rede ao carregar o ficheiro.","httpError404":"HTTP error occurred during file upload (404: File not found).","httpError403":"HTTP error occurred during file upload (403: Forbidden).","httpError":"HTTP error occurred during file upload (error status: %1).","noUrlError":"Upload URL is not defined.","responseError":"Incorrect server response."},"find":{"find":"Pesquisar","findOptions":"Opções de pesquisa","findWhat":"Texto a procurar:","matchCase":"Maiúsculas/Minúsculas","matchCyclic":"Match cyclic","matchWord":"Coincidir com toda a palavra","notFoundMsg":"O texto especificado não foi encontrado.","replace":"Substituir","replaceAll":"Substituir tudo","replaceSuccessMsg":"%1 ocurrências(s) substituídas.","replaceWith":"Substituir por:","title":"Pesquisar e substituir"},"font":{"fontSize":{"label":"Tamanho","voiceLabel":"Tamanho da letra","panelTitle":"Tamanho da letra"},"label":"Fonte","panelTitle":"Nome do tipo de letra","voiceLabel":"Tipo de letra"},"fakeobjects":{"anchor":" Inserir/Editar âncora","hiddenfield":"Campo oculto","iframe":"IFrame","unknown":"Objeto desconhecido"},"forms":{"button":{"title":"Propriedades do botão","text":"Texto (valor)","type":"Tipo","typeBtn":"Botão","typeSbm":"Enviar","typeRst":"Repor"},"checkboxAndRadio":{"checkboxTitle":"Propriedades da caixa de verificação","radioTitle":"Propriedades do botão de rádio","value":"Valor","selected":"Selecionado","required":"Obrigatório"},"form":{"title":"Propriedades do formulário","menu":"Propriedades do formulário","action":"Ação","method":"Método","encoding":"Codificação"},"hidden":{"title":"Propriedades do campo oculto","name":"Nome","value":"Valor"},"select":{"title":"Propriedades da caixa de seleção","selectInfo":"Informação","opAvail":"Opções disponíveis","value":"Valor","size":"Tamanho","lines":"linhas","chkMulti":"Permitir seleções múltiplas","required":"Obrigatório","opText":"Texto","opValue":"Valor","btnAdd":"Adicionar","btnModify":"Modificar","btnUp":"Subir","btnDown":"Descer","btnSetValue":"Definir como valor selecionado","btnDelete":"Apagar"},"textarea":{"title":"Propriedades da área de texto","cols":"Colunas","rows":"Linhas"},"textfield":{"title":"Propriedades do campo de texto","name":"Nome","value":"Valor","charWidth":"Tamanho do caracter","maxChars":"Máximo de caracteres","required":"Obrigatório","type":"Tipo","typeText":"Texto","typePass":"Senha","typeEmail":"Email","typeSearch":"Pesquisar","typeTel":"Telefone","typeUrl":"URL"}},"format":{"label":"Formatar","panelTitle":"Formatar Parágrafo","tag_address":"Endereço","tag_div":"Normal (DIV)","tag_h1":"Título 1","tag_h2":"Título 2","tag_h3":"Título 3","tag_h4":"Título 4","tag_h5":"Título 5","tag_h6":"Título 6","tag_p":"Normal","tag_pre":"Formatado"},"horizontalrule":{"toolbar":"Inserir linha horizontal"},"iframe":{"border":"Mostrar a borda da Frame","noUrl":"Por favor, digite o URL da iframe","scrolling":"Ativar barras de rolamento","title":"Propriedades da IFrame","toolbar":"IFrame","tabindex":"Remove from tabindex"},"image":{"alt":"Texto alternativo","border":"Limite","btnUpload":"Enviar para o servidor","button2Img":"Deseja transformar o botão com imagem selecionado numa imagem simples?","hSpace":"Esp. Horiz","img2Button":"Deseja transformar a imagem selecionada num botão com imagem?","infoTab":"Informação da imagem","linkTab":"Hiperligação","lockRatio":"Proporcional","menu":"Propriedades da Imagem","resetSize":"Tamanho original","title":"Propriedades da imagem","titleButton":"Propriedades do botão de imagem","upload":"Carregar","urlMissing":"O URL de origem da imagem está em falta.","vSpace":"Esp. Vert","validateBorder":"A borda tem de ser um número inteiro.","validateHSpace":"HSpace tem de ser um numero.","validateVSpace":"VSpace tem de ser um numero."},"indent":{"indent":"Aumentar avanço","outdent":"Diminuir avanço"},"smiley":{"options":"Opções de Emoticons","title":"Inserir um Emoticon","toolbar":"Emoticons"},"language":{"button":"Definir Idioma","remove":"Remover idioma"},"link":{"acccessKey":"Chave de acesso","advanced":"Avançado","advisoryContentType":"Tipo de conteúdo","advisoryTitle":"Título","anchor":{"toolbar":" Inserir/Editar âncora","menu":"Propriedades da âncora","title":"Propriedades da âncora","name":"Nome da âncora","errorName":"Por favor, introduza o nome da âncora","errorWhitespace":"Anchor name cannot contain space characters","remove":"Remover âncora"},"anchorId":"Por ID do elemento","anchorName":"Por Nome de Referência","charset":"Fonte de caracteres vinculado","cssClasses":"Classes de Estilo","download":"Force Download","displayText":"Mostrar texto","emailAddress":"Endereço de email","emailBody":"Corpo da mensagem","emailSubject":"Título de mensagem","id":"ID","info":"Informação da hiperligação","langCode":"Código de idioma","langDir":"Orientação de idioma","langDirLTR":"Esquerda para a Direita (EPD)","langDirRTL":"Direita para a Esquerda (DPE)","menu":"Editar hiperligação","name":"Nome","noAnchors":"(Não existem âncoras no documento)","noEmail":"Por favor, escreva o endereço de email","noUrl":"Por favor, introduza o endereço URL","noTel":"Por favor, escreva o número de telefone","other":"<outro>","phoneNumber":"Número de telefone","popupDependent":"Dependente (Netscape)","popupFeatures":"Características de janela flutuante","popupFullScreen":"Janela completa (IE)","popupLeft":"Posição esquerda","popupLocationBar":"Barra de localização","popupMenuBar":"Barra de menu","popupResizable":"Redimensionável","popupScrollBars":"Barras de deslocamento","popupStatusBar":"Barra de estado","popupToolbar":"Barra de ferramentas","popupTop":"Posição topo","rel":"Relação","selectAnchor":"Selecionar âncora","styles":"Estilo","tabIndex":"Índice de tabulação","target":"Alvo","targetFrame":"<frame>","targetFrameName":"Nome da janela de destino","targetPopup":"<janela de popup>","targetPopupName":"Nome da janela flutuante","title":"Hiperligação","toAnchor":"Ligar a âncora no texto","toEmail":"Email","toUrl":"URL","toPhone":"Telefone","toolbar":"Hiperligação","type":"Tipo de hiperligação","unlink":"Eliminar hiperligação","upload":"Carregar"},"list":{"bulletedlist":"Marcas","numberedlist":"Numeração"},"liststyle":{"bulletedTitle":"Propriedades da lista não numerada","circle":"Círculo","decimal":"Decimal (1, 2, 3, etc.)","disc":"Disco","lowerAlpha":"Minúsculas (a, b, c, d, e, etc.)","lowerRoman":"Romano em minúsculas (i, ii, iii, iv, v, etc.)","none":"Nenhum","notset":"<not set>","numberedTitle":"Numbered List Properties","square":"Quadrado","start":"Iniciar","type":"Tipo","upperAlpha":"Maiúsculas (A, B, C, D, E, etc.)","upperRoman":"Romanos em maiúscula (I, II, III, IV, V, etc.)","validateStartNumber":"A lista tem iniciar por um número inteiro"},"magicline":{"title":"Inserir parágrafo aqui"},"maximize":{"maximize":"Maximizar","minimize":"Minimizar"},"newpage":{"toolbar":"Nova página"},"pagebreak":{"alt":"Quebra de página","toolbar":"Inserir quebra de página"},"pastetext":{"button":"Colar como texto simples","pasteNotification":"Press %1 to paste. Your browser doesn‘t support pasting with the toolbar button or context menu option.","title":"Colar como texto simples"},"pastefromword":{"confirmCleanup":"O texto que pretende colar parece ter sido copiado do Word. Deseja limpar o código antes de o colar?","error":"Não foi possível limpar a informação colada devido a um erro interno.","title":"Colar do Word","toolbar":"Colar do Word"},"preview":{"preview":"Pré-visualizar"},"print":{"toolbar":"Imprimir"},"removeformat":{"toolbar":"Limpar formatação"},"save":{"toolbar":"Guardar"},"selectall":{"toolbar":"Selecionar tudo"},"showblocks":{"toolbar":"Exibir blocos"},"sourcearea":{"toolbar":"Fonte"},"specialchar":{"options":"Opções de caracteres especiais","title":"Selecione um caracter especial","toolbar":"Inserir carácter especial"},"scayt":{"btn_about":"About SCAYT","btn_dictionaries":"Dictionaries","btn_disable":"Disable SCAYT","btn_enable":"Enable SCAYT","btn_langs":"Languages","btn_options":"Options","text_title":"Spell Check As You Type"},"stylescombo":{"label":"Estilos","panelTitle":"Estilos de formatação","panelTitle1":"Estilos de bloco","panelTitle2":"Estilos nas etiquetas","panelTitle3":"Estilos em objeto"},"table":{"border":"Tamanho do contorno","caption":"Legenda","cell":{"menu":"Célula","insertBefore":"Inserir célula antes","insertAfter":"Inserir célula depois","deleteCell":"Apagar células","merge":"Unir células","mergeRight":"Unir à direita","mergeDown":"Fundir abaixo","splitHorizontal":"Dividir célula horizontalmente","splitVertical":"Dividir célula verticalmente","title":"Propriedades da célula","cellType":"Tipo de célula","rowSpan":"Linhas na célula","colSpan":"Colunas na célula","wordWrap":"Moldar texto","hAlign":"Alinhamento horizontal","vAlign":"Alinhamento vertical","alignBaseline":"Linha base","bgColor":"Cor de fundo","borderColor":"Cor da margem","data":"Dados","header":"Cabeçalho","columnHeader":"Column Header","rowHeader":"Row Header","yes":"Sim","no":"Não","invalidWidth":"A largura da célula deve ser um número.","invalidHeight":"A altura da célula deve ser um número.","invalidRowSpan":"As linhas da célula devem ser um número inteiro.","invalidColSpan":"As colunas da célula devem ter um número inteiro.","chooseColor":"Escolher"},"cellPad":"Espaço interior","cellSpace":"Espaçamento de célula","column":{"menu":"Coluna","insertBefore":"Inserir coluna antes","insertAfter":"Inserir coluna depois","deleteColumn":"Apagar colunas"},"columns":"Colunas","deleteTable":"Apagar tabela","headers":"Cabeçalhos","headersBoth":"Ambos","headersColumn":"Primeira coluna","headersNone":"Nenhum","headersRow":"Primeira linha","heightUnit":"height unit","invalidBorder":"O tamanho da margem tem de ser um número.","invalidCellPadding":"A criação do espaço na célula deve ser um número positivo.","invalidCellSpacing":"O espaçamento da célula deve ser um número positivo.","invalidCols":"O número de colunas tem de ser um número maior que 0.","invalidHeight":"A altura da tabela tem de ser um número.","invalidRows":"O número de linhas tem de ser maior que 0.","invalidWidth":"A largura da tabela tem de ser um número.","menu":"Propriedades da tabela","row":{"menu":"Linha","insertBefore":"Inserir linha antes","insertAfter":"Inserir linha depois","deleteRow":"Apagar linhas"},"rows":"Linhas","summary":"Resumo","title":"Propriedades da tabela","toolbar":"Tabela","widthPc":"percentagem","widthPx":"píxeis","widthUnit":"unidade da largura"},"undo":{"redo":"Refazer","undo":"Anular"},"widget":{"move":"Clique e arraste para mover","label":"%1 widget"},"uploadwidget":{"abort":"Carregamento cancelado pelo utilizador.","doneOne":"Ficheiro carregado com sucesso.","doneMany":"Successfully uploaded %1 files.","uploadOne":"Uploading file ({percentage}%)...","uploadMany":"Uploading files, {current} of {max} done ({percentage}%)..."},"a11yfirsthelp":{"label":"A11yFirst Help","panelTitle":"Learn about A11yFirst features","keyboardShortcutsLabel":"Keyboard Shortcuts","versionLabel":"Version","a11yFirstHelpLabel":"A11yFirst Help: Content Accessibility","a11yFirstHelpTitle":"Information to help authors understand how the A11yFirst features help them make content more accessible to people with disabilites","headingHelp":{"menu":"Heading / Paragraph","label":"Heading / Paragraph","title":"Heading / Paragraph Help","content":"## Heading / Paragraph\n\n### Menu items\n* **H1 – Document title** — Typically should be the first heading in the\n  document and used only once.\n* **H2 – Section title** — Describes a main or top-level section in the\n  document.\n* **H3 to H6 – Subsection title** — Describes a subsection within a top-level\n  section or other subsection of the document.\n* **Normal** — The default paragraph format, typically with significant top\n  and bottom margins.\n* **Preformatted text** — Use this for computer code blocks to maintain spacing\n  and indentation.\n* **Address line** — Use this to type a series of address lines styled in\n  italics and with minimal top and bottom margins. When you press enter at the\n  end of a line, the next line is also an address line.\n\n### About headings\n* The Heading / Paragraph menu only enables the **allowed** heading levels.\n\n* The cursor position relative to other headings in the document determines\nwhich heading levels are allowed.\n\n### About paragraph formats\n* Visual styling for paragraph formats is predetermined by your organization,\nthus freeing up your time and energy for concentrating on the structure and\nmeaning of the content within your document.\n\n### Why headings and paragraph formats are important\n* The purpose of a heading is to label the content that follows it.\n\n* The proper nesting of heading levels improves the ability of all users to\nfind and comprehend information on a page.\n\n* Headings used consistently and in meaningful ways improve Search Engine\nOptimization (SEO).\n\n* Properly nested headings enable people using assistive technologies to easily\nnavigate to each section of a document.\n\n* When paragraph formats are used properly (e.g. *Preformatted* or *Address*),\nthey help users of assistive technologies understand the intended role of the\ncontent.\n\n* Thinking in terms of blocks such as headings and paragraph formats within\nyour document is a higher-level approach to providing structure and semantics\nthat are important for all users.\n\n### More information\n* Documents are easier to read and understand when headings identify the topics\nthey contain.\n\n* Headings make it easier to scan and find topics of interest within a document.\n\n* Heading levels identify the structural relationships between sections of\ncontent in a document.\n\n* Higher-level headings (Levels 1 and 2) identify the main topics of a document\nand lower-level headings (Levels 3, 4, 5 and 6) identify subsections of the\ndocument.\n\n* A subsection is identified by using the next lower-level heading. For\nexample, subsections of Level 2 headings use Level 3 headings, subsections of\nLevel 3 headings use Level 4 headings, and so on to Level 6 headings.\n\n* Break content into subsections when there are two or more ideas or concepts\nthat correspond to the topics covered in the section. Use headings of the same\nlevel to label each subsection.\n\n* Heading levels should **never** be used for inline visual styling of content\n(e.g. larger or smaller font size, bold or italic). Instead, use the `Inline\nStyle` options.\n"},"listHelp":{"menu":"List","label":"List","title":"List Help","content":"## List\n\n### Working with lists\n\n<img style=\"padding: 8px 0 3px 5px\" alt=\"list toolbar buttons\"\nsrc=\"basePath/plugins/a11yfirsthelp/images/list-buttons.png\"/>\n\nUse the toolbar buttons shown above to:\n\n* Insert/Remove Numbered List\n* Insert/Remove Bulleted List\n* Increase Indent\n* Decrease Indent\n\n### List properties via context menu\n\nThe context menu allows further configuration of list properties such as\nnumbering and bullet types by selecting:\n\n* Numbered List Properties\n* Bulleted List Properties\n\nThe context menu can be invoked by positioning the cursor in a list item and:\n\n* right-clicking, using the mouse, or\n* using Mouse Keys on Windows or Mac.\n\n### About lists\n\n* Use a numbered list when the order or sequence of the items is significant.\n* Use a bulleted list when the order of the items is not significant.\n\n### Why lists are important\n\n* Lists convey grouping semantics for related items.\n* Lists may also convey hierarchical structure.\n* When related items are grouped as a list, information about the list is\n  conveyed to screen reader users, including the type of list, the number of\n  items it contains and the sequence number of the current list item.\n"},"imageHelp":{"menu":"Image","label":"Image","title":"Image Help","content":"## Image\n\n### Accessible image descriptions\n\n* People with visual impairments or visual processing disorders need\n  accessible text descriptions of informative images.\n\n* There are two types of accessible descriptions for images: *alternative\n  text* and *long descriptions*.\n\n### Alternative text\n\n* Succinctly describes the content and function of the image for people\n  with visual impairments, in no more than 100 characters\n\n* Is required for informative images (but not for images that are purely\n  decorative)\n\n* Is not visible in the document; it is communicated to screen reader users\n  via the *img* element's *alt* attribute\n\n* For a purely decorative image, select the **‘Image does not require\n  alternative text’** checkbox and leave the alternative text field blank.\n\n### Long descriptions for complex images\n\n* A complex image has informational content that cannot be described adequately\n  by alternative text of 100 characters or less.\n\n* Examples of complex images include charts, graphs, diagrams, scientific\n  photographs and works of art.\n\n* A complex image needs both a concise alternative text description and a\n  longer, more detailed description.\n\n* Accessibility requirements mandate that the long description of a complex\n  image be placed in the document adjacent to the image.\n\n### Adding a long description in the document\n\nFollow these steps when adding a long description of a complex image:\n\n1. Add an adequately detailed description of the image within the document,\n   either just before or after the image (or both).\n\n1. In answer to the question **‘Is a long description needed, and if so,\n   where will it be located’**, select one of the following:\n       * Yes; in the document before the image\n       * Yes; in the document after the image\n       * Yes; in the document before and after the image\n\nBy specifying the location of the long description relative to the image,\nscreen reader users will be informed of its existence and location in the\ndocument. (This information is appended to the alternative text.)\n\n### Insert a caption text box below the image\n\n* A **caption** is an optional visual label supported by CKEditor for an image.\n  It provides an additional way to describe an image that is immediately below\n  and proximate to the image.\n\n* The caption content is specified and is editable in the text box just below\n  the image, once it has been inserted in the document.\n\n* From an accessibility perspective the *caption* and the *alternative text*\n  should not be the same, but instead should complement each other.\n\n* Using the caption creates a *figcaption* element contained in a *figure*\n  element. The *figure* element also contains the *img* element.\n\n### Writing effective alternative text\n\nThe following are based on <a href=\"https://webaim.org\" target=\"_resource\">\nWebAIM</a>'s guidelines for alternative text:\n\n* **Be accurate and equivalent** in presenting the same *content* and\n  *function* of the image.\n\n* When **images are used as links**, the alternative text should describe the\n  target of the link.\n\n* **Be succinct.** This means the correct content and function of the image\n  should be presented as succinctly as is appropriate. Typically no more than\n  a few words are necessary, though rarely a short sentence or two may be\n  appropriate. The length should not exceed 100 characters.\n\n* **Do NOT be redundant** or provide the same information as text that is\n  already part of the document.\n\n* **Do NOT use the phrases “image of ...” or “graphic of ...”** to describe\n  the image. Assistive technologies notify the user of the image.  It is your\n  job to describe the purpose or the content of the image.  If the image is a\n  photograph or illustration, etc. of important content, it may be useful to\n  include this in the alternative text.\n\n* **Do NOT include file names or sizes** as part of the alternative text.\n\n### Why image descriptions are important\n\nAdding text descriptions of images is an important part of making documents\naccessible to the visually impaired who use assistive devices such as screen\nreaders and magnifiers, and to people with visual processing disorders, which\nmake especially complex images more difficult to understand.\n\nWhen the user cannot see all or part of an image, assistive technologies will\nread or display its alternative text description. This is especially important\nwhen the image conveys information that is required for the user to fully\nunderstand the information in the document.\n\nFor people with visual processing disorders, a detailed description of a\ncomplex image helps them to more quickly or completely understand the\ninformation being conveyed by the image.\n\n### More information\n\n* <a href=\"https://accessibility.psu.edu/images/alttext/\"\ntarget=\"_resource\">Penn State: Image ALT Text</a>\n\n* <a href=\"https://webaim.org/techniques/alttext/\"\ntarget=\"_resource\">WebAIM: Alternative Text</a>\n\n* <a href=\"https://www.w3.org/WAI/tutorials/images/\"\ntarget=\"_resource\">W3C Web Accessibility Image Tutorial</a>\n\n* <a href=\"http://diagramcenter.org/\" target=\"_resource\">Diagram Center</a>\n"},"inlineStyleHelp":{"menu":"Character Style","label":"Character Style","title":"Character Style Help","content":"## Character Style\n\n### Working with character styles\n\n* To apply a character style to existing text, select a range of text and then\nchoose an option from the menu.\n\n* To apply a character style to text you are about to type, choose an option\nfrom the menu and begin typing. The style will continue to be applied until\nyou choose another option or move the cursor to a different point in the\ndocument.\n\n* Multiple character styles can be applied to selected text.\n\n### About character styles\n\n* Character styles have a different purpose than paragraph formats. They are\nused at a lower level to highlight words or phrases within blocks of text.\n\n* Character styles, when used properly, help screen reader users better\nunderstand the types and meanings of lower-level stylistic changes within\nblocks of text.\n\n### Character styles vs. headings, lists and paragraph formats\n\n* Thinking in terms of headings, lists and paragraph formats first, and then\nusing character styles to emphasize key words or phrases within text blocks,\nresults in documents that are easier to read and understand.\n\n* When headings, lists and paragraph formats are considered as primary, and\ncharacter styles secondary, many visual styling decisions can be avoided, as\nthey are already made by default.\n\n* When character styles are used to change the styling of blocks of text\nwithout regard to whether the block is a heading, list item or other type of\nparagraph format, it makes the document more difficult to read and understand\nwithin the context of the website.\n\n* Using headings, lists, paragraph formats and character styles properly will\nmake it easier for you to maintain stylistic consistency.\n"},"linkHelp":{"menu":"Link","label":"Link","title":"Link Help","content":"## Link\n\n### Display Text\n\nProviding accessible *Display Text* is straightforward if you keep the\nfollowing guidelines in mind:\n\n1. The *Display Text* for a link should describe the target of the link.\n\n1. Do not use ambiguous text, such as “Click Here” or “More”.\n\n1. Do not begin the *Display Text* with redundant words or phrases such as\n   “Link” or “Link to”.\n\n1. Be consistent: Links to the same URL or e-mail address should have the same\n   *Display Text*.\n\n1. In most cases, it is best not to use the link URL or e-mail address as the\n   *Display Text*.\n\n### About links\n\n* Screen reader users often use the “List of Links” feature to identify and\n  navigate to links on a page. When links are presented as a list,  using\n  descriptive *Display Text* becomes even more important since understanding\n  the target of each link no longer benefits from its original context within\n  the document.\n\n* Screen reader users often use the “Search” feature to find links on a page\n  based on keywords they would expect to find in the *Display Text* of the\n  links. Thus the more descriptive the link *Display Text*, the more effective\n  the search feature will be in finding relevant links.\n\n* Usable and accessible *Display Text* should be descriptive, unique and start\n  with keywords (NNG).\n\n* The *Display Text* for links is like a sign post. It should tell you what\n  you’ll find when you follow it (NOMENSA).\n\n### Why links are important\n\n* Descriptive link text makes it easier for everyone to find and follow links\n  on a page that are of interest to them.\n\n* Descriptive link text is especially important for people using screen\n  readers, who typically only hear the display text spoken to them through\n  speech synthesis and do not \"see\" the link in the context of other content\n  on the page.\n\n* When URLs, e-mail addresses or other ambiguous text are used as the display\n  text for a link, it is impossible in many cases, and much more difficult in\n  the remaining cases, for screen reader users to find and follow links of\n  interest to them.\n\n### More information\n\n* <a href=\"https://www.nngroup.com/articles/writing-links/\"\ntarget=\"_resource\">NNG: Writing Hyperlinks: Salient, Descriptive, Start with\nKeyword</a>\n\n* <a href=\"https://www.nomensa.com/blog/2011/writing-good-link-text\"\ntarget=\"_resource\">Nomensa: How to write good link text</a>\n\n* <a href=\"https://accessibility.umn.edu/core-skills/hyperlinks\"\ntarget=\"_resource\">Accessible U: Hyperlinks (Good and Bad Examples)</a>\n"},"gettingStarted":{"menu":"Getting Started","label":"Getting Started","title":"Getting Started with A11yFirst","content":"## Getting Started with A11yFirst\n\n### What is A11yFirst?\n\nBefore you begin using the A11yFirst editor, it is important to know what\nmakes it different from other editors. The name *A11yFirst* hints at some\nof these differences.\n\n*A11y* is shorthand for *accessibility* (*a* + 11 letters + *y*), and\naccessibility in the context of document authoring is about making the\ninformation that documents contain perceivable and understandable by everyone,\nincluding people with disabilities.</p>\n\n### Commitment to accessibility\n\nYour organization, by hosting the A11yFirst editor within its content\nmanagement system, has made a commitment to accessibility because (1) it\nremoves barriers that people with visual, auditory, learning and other\ndisabilities may experience in their use of web information and communication\ntechnologies and (2) it is required by law.\n\nBy following accessibility guidelines when creating public-facing documents,\nyou are fulfilling your role in this commitment.\n\n### Document accessibility\n\nSome of the main components within a document that are important for\naccessibility are:\n\n* **Headings** — These provide titles for the sections and subsections of\ncontent within your document, as well as a title for the document itself.\n\n* **Lists** — By using the list feature, the items in a list are grouped\ntogether and information about the grouping can be conveyed to users of\nassistive technologies.\n\n* **Links** — The text component of a link should describe its target, i.e.,\nthe web site, page or section that will be displayed if you activate the link.\n\n* **Images** — When an image with informational content is included within a\ndocument, a short text description (also known as ‘alt text’) allows screen\nreader users to obtain a concise description of the image.\n\n* **Tables** — By using the table feature to organize tabular data and provide row\nand column headers, users of assistive technologies gain the ability to easily\nnavigate and understand structural relationships within the data.\n\n### A different way of thinking\n\nThe way you think about the process or workflow of creating and editing\ndocuments can make a significant difference in whether the end result, your\nfinished document, is accessible.\n\nFor example, rather than thinking about stylistic considerations such as font\nsizes and colors first, if you make the structure of your document a primary\nconsideration, by breaking it down into sections and subsections and giving\neach of these a meaningful title, you will end up with a document that will\nbe easier for all users to navigate and understand, including people with\ndisabilities.\n"},"aboutA11yFirst":{"menu":"About A11yFirst","label":"About A11yFirst","title":"Description of A11yFirst Project","content":"## About A11yFirst\n\n### Project Description & Goals\n\nThe A11yFirst Project is a collection of modifications to CKEditor, an\nHTML-embedded WYSIWYG editor typically used within content management\nsystems. Its goal is to make the process of creating and editing web documents\none that proactively results in accessible content.\n\nIn the past, authors have had to rely upon remediation tools used at the end\nof the authoring process that ‘fix’ accessibility problems without offering\nmuch guidance on how to prevent them. The A11yFirst editor takes a different\napproach.\n\nFor example, by prompting the author to provide information regarding links\nand images as they are added to the document, accessibility problems are not\nonly avoided, but authors learn on a feature-by-feature basis some of the\nimportant requirements for accessible content.\n\nOther design features in A11yFirst promote the use of blocks such as headings\nand lists that carry with them semantics that are communicated to screen\nreader users and that result in documents that are more easily navigated and\nunderstood by all readers.\n\n### Project Information\n\n* Version: %version\n\n* GitHub Repositories: <a href=\"https://github.com/a11yfirst\"\ntarget=\"_resource\">https://github.com/a11yfirst</a>\n\n### Contributors\n\n* Lucy Chang     (UX, Usability Testing)\n* Jon Gunderson  (Requirements, Development, Usability Testing,\n  Project Management)\n* Nicholas Hoyt  (UX, UI Design, Development, Usability Testing,\n  Project Management)\n* JaEun Jemma Ku (Requirements, Usability Testing, UI Design,\n  Project Management)\n* Eileen Lopez   (UX, Usability Testing)\n* Mark McCarthy  (UX, Usability Testing)\n* Robert Slater  (Requirements)\n* Dena Strong    (UX, Usability Testing)\n\n### Sponsors\n\n* Disability Resources and Educational Services (DRES), College of Applied\n  Health Sciences (AHS), University of Illinois at Urbana-Champaign\n* Illinois Extension, College of Agricultural, Consumer and Environmental\n  Sciences (ACES), University of Illinois at Urbana-Champaign\n* The University Library, Innovation Fund (Jemma Ku, P.I.), University of\n  Illinois at Urbana-Champaign\n* Administrative Information Technology Services (AITS), University of\n  Illinois at Urbana-Champaign\n* School of Information Sciences (iSchool), University of Illinois at\n  Urbana-Champaign\n\n### Acknowledgements\n\nMany of the ideas and motivations for the A11yFirst Project were the result\nof work done previously by a group of software developers at the Illinois\nDepartment of Human Services (DHS), led by Mike Scott, who created the OneNet\ncontent management system, which includes as its centerpiece an accessible\nWYSIWYG editor.\n\nThe OneNet CMS has been in use by the Illinois DHS since 2006 to promote\naccessible authoring for their intranet and main website.\n\nMr. Scott also participated in the requirements gathering phase of the\nA11yFirst Project.\n"}},"codemirror":{"copyright":"Copyright CodeMirror © Marijn Haverbeke. All rights reserved.","dlgTitle":"About CodeMirror Source Plugin","moreInfoShortcuts":"Available Shortcuts","moreInfoShortcuts1":"<strong>CTRL + K</strong> to comment the currently selected text","moreInfoShortcuts2":"<strong>CTRL + SHIFT + K</strong> to uncomment currently selected text","moreInfoShortcuts3":"<strong>CTRL + ALT + K</strong> to auto format currently selected text","moreInfoShortcuts4":"<strong>CTRL + Q</strong> Expand / Collapse Code Block","moreInfoShortcuts5":"<strong>CTRL + F</strong> to perform a search","moreInfoShortcuts6":"<strong>CTRL + G</strong> to find next","moreInfoShortcuts7":"<strong>CTRL + SHIFT + G</strong> to find previous","moreInfoShortcuts8":"<strong>CTRL + SHIFT</strong> to find and replace","moreInfoShortcuts9":"<strong>CTRL + SHIFT + R</strong> to find and replace all","toolbar":"Fonte","searchCode":"Search Source (CTRL + F)","replaceCode":"Replace Code (CTRL + SHIFT + F)","autoFormat":"Format Selection (CTRL + ALT + K)","commentSelectedRange":"Comment Selection (CTRL + K)","uncommentSelectedRange":"Uncomment Selection (CTRL + SHIFT + K)","autoCompleteToggle":"Enable/Disable HTML Tag Autocomplete"},"emoji":{"searchPlaceholder":"Search emoji…","searchLabel":"Input field responsible for searching and filtering emoji inside panel.","navigationLabel":"Groups navigation for emoji sections.","title":"Emoji List","groups":{"people":"People","nature":"Nature and animals","food":"Food and drinks","travel":"Travel and places","activities":"Activities","objects":"Objects","symbols":"Symbols","flags":"Flags"}},"html5video":{"button":"Inserir vídeo HTML5","title":"HTML5 video","infoLabel":"Informações do Vídeo","allowed":"Extensões permitidas: MP4, WebM, Ogv","urlMissing":"O URL do vídeo está faltando.","videoProperties":"Propriedades do vídeo","upload":"Upload","btnUpload":"Enviar para o servidor","advanced":"Avançado","autoplay":"Autoplay?","allowdownload":"Allow download?","advisorytitle":"Advisory title","yes":"Sim","no":"Não","responsive":"Largura responsiva","controls":"Exibir controles","loop":"Loop?","poster":"Thumbnail"},"sourcedialog":{"toolbar":"Fonte","title":"Fonte"}};