
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `luxcal534new`
--

-- --------------------------------------------------------

--
-- Table structure for table `mycal_categories`
--

CREATE TABLE `mycal_categories` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(48) COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `symbol` varchar(8) COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `sequence` tinyint(4) NOT NULL DEFAULT '1',
  `repeat` tinyint(4) NOT NULL DEFAULT '0',
  `noverlap` tinyint(4) NOT NULL DEFAULT '0',
  `olapGap` tinyint(4) NOT NULL DEFAULT '0',
  `olErrMsg` varchar(56) COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `defSlot` smallint(6) NOT NULL DEFAULT '0',
  `fixSlot` tinyint(4) NOT NULL DEFAULT '0',
  `approve` tinyint(4) NOT NULL DEFAULT '0',
  `dayColor` tinyint(4) NOT NULL DEFAULT '0',
  `color` varchar(8) COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `bgColor` varchar(8) COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `checkBx` tinyint(4) NOT NULL DEFAULT '0',
  `checkLb` varchar(16) COLLATE utf8mb4_bin NOT NULL DEFAULT 'approved',
  `checkMk` varchar(8) COLLATE utf8mb4_bin NOT NULL DEFAULT '&#x2713;',
  `subCats` text COLLATE utf8mb4_bin,
  `notList` varchar(255) COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `urlLink` varchar(120) COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin AUTO_INCREMENT=2 ;

--
-- Dumping data for table `mycal_categories`
--

INSERT INTO `mycal_categories` VALUES
(1, 'no cat', '', 1, 0, 0, 0, '', 0, 0, 0, 0, '', '', 0, 'approved', '&#x2713;', '[]', '', '', 0);

-- --------------------------------------------------------

--
-- Table structure for table `mycal_events`
--

CREATE TABLE `mycal_events` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `type` tinyint(4) NOT NULL DEFAULT '0',
  `private` tinyint(4) NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `venue` varchar(128) COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `text1` text COLLATE utf8mb4_bin,
  `text2` varchar(255) COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `text3` varchar(255) COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `attach` text COLLATE utf8mb4_bin,
  `catID` mediumint(9) NOT NULL DEFAULT '1',
  `scatID` tinyint(4) NOT NULL DEFAULT '0',
  `userID` mediumint(9) NOT NULL DEFAULT '0',
  `editor` varchar(48) COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `approved` tinyint(4) NOT NULL DEFAULT '0',
  `checked` text COLLATE utf8mb4_bin,
  `notify` tinyint(4) NOT NULL DEFAULT '-1',
  `notRecip` varchar(255) COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `sDate` varchar(10) COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `eDate` varchar(10) COLLATE utf8mb4_bin NOT NULL DEFAULT '9999-00-00',
  `xDates` text COLLATE utf8mb4_bin,
  `sTime` varchar(5) COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `eTime` varchar(5) COLLATE utf8mb4_bin NOT NULL DEFAULT '99:00',
  `rType` tinyint(4) NOT NULL DEFAULT '0',
  `rInterval` tinyint(4) NOT NULL DEFAULT '0',
  `rPeriod` tinyint(4) NOT NULL DEFAULT '0',
  `rMonth` tinyint(4) NOT NULL DEFAULT '0',
  `rUntil` varchar(10) COLLATE utf8mb4_bin NOT NULL DEFAULT '9999-00-00',
  `aDateTime` varchar(16) COLLATE utf8mb4_bin NOT NULL DEFAULT '9999-00-00 00:00',
  `mDateTime` varchar(16) COLLATE utf8mb4_bin NOT NULL DEFAULT '9999-00-00 00:00',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `mycal_groups`
--

CREATE TABLE `mycal_groups` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `privs` tinyint(4) NOT NULL DEFAULT '0',
  `vCatIDs` varchar(128) COLLATE utf8mb4_bin NOT NULL DEFAULT '0',
  `eCatIDs` varchar(128) COLLATE utf8mb4_bin NOT NULL DEFAULT '0',
  `rEvents` tinyint(4) NOT NULL DEFAULT '1',
  `mEvents` tinyint(4) NOT NULL DEFAULT '1',
  `pEvents` tinyint(4) NOT NULL DEFAULT '1',
  `upload` tinyint(4) NOT NULL DEFAULT '0',
  `tnPrivs` varchar(2) COLLATE utf8mb4_bin NOT NULL DEFAULT '00',
  `color` varchar(8) COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin AUTO_INCREMENT=7 ;

--
-- Dumping data for table `mycal_groups`
--

INSERT INTO `mycal_groups` VALUES
(1, 'No access', 0, '0', '0', 1, 1, 1, 0, '00', '', 0),
(2, 'Admin', 9, '0', '0', 1, 1, 1, 1, '22', '', 0),
(3, 'Read access', 1, '0', '0', 1, 1, 1, 0, '00', '', 0),
(4, 'Post Own', 2, '0', '0', 1, 1, 1, 0, '20', '', 0),
(5, 'Post All', 3, '0', '0', 1, 1, 1, 0, '21', '', 0),
(6, 'Manager', 4, '0', '0', 1, 1, 1, 1, '22', '', 0);

-- --------------------------------------------------------

--
-- Table structure for table `mycal_settings`
--

CREATE TABLE `mycal_settings` (
  `name` varchar(16) COLLATE utf8mb4_bin NOT NULL,
  `value` varchar(255) COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `outline` varchar(128) COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;

--
-- Dumping data for table `mycal_settings`
--

INSERT INTO `mycal_settings` VALUES
('DMdFormat', 'WD d M', 'Date format: weekday dd month (WD:weekday d:dd, M:month)'),
('DMdyFormat', 'WD d M y', 'Date format: weekday dd month yyyy (WD:weekday d:dd, M:month, y:yyyy)'),
('GvWeeksToShow', '8', 'Number of weeks to show in gantt view'),
('MdFormat', 'd M', 'Date format: dd month (d:dd, M:month)'),
('MdyFormat', 'd M y', 'Date format: dd month yyyy (d:dd, M:month, y:yyyy)'),
('MvWeeksToShow', '10', 'Number of weeks to show in month view'),
('MyFormat', 'M y', 'Date format: month yyyy (M:month, y:yyyy)'),
('XvWeeksToShow', '8', 'Number of weeks to show in matrix view'),
('YvColsToShow', '3', 'Number of months to show per row in year view'),
('YvRowsToShow', '4', 'Number of rows to show in year view'),
('adminCronSum', '1', 'Send cron job summary to admin (0:no, 1:yes)'),
('attTypes', '.pdf,.jpg,.gif,.png,.mp4,.avi', 'Valid types of uploaded attachments'),
('backLinkUrl', '', 'Nav bar back link URL (blank: no link, url: link)'),
('birthdayCal', '0', 'Display option PDF File - Birthdays in side menu (0:no, 1:yes)'),
('cCodePrefix', '1', 'Country code starts with prefix + or 00 (0:no, 1:yes)'),
('calMenu', '1', 'Display calendar menu in options panel (0:no, 1:yes)'),
('calendarEmail', '[[admin_email]]', 'Sender of email notifications'),
('calendarPhone', '', 'Sender of SMS notifications'),
('calendarTitle', '[[site_name]]', 'Calendar title displayed in the top bar'),
('calendarUrl', '[[softurl]]/?cal=mycal', 'Calendar link (URL)'),
('catMenu', '1', 'Display category filter menu in options panel(0:no, 1:yes)'),
('chgRecipList', '', 'List of notification email/SMS addresses'),
('contButton', '1', 'Display Contact button in side menu (0:no, 1:yes)'),
('cookieExp', '30', 'Number of days before a Remember Me cookie expires'),
('dateFormat', 'd.m.y', 'Date format: yyyy-mm-dd (y:yyyy, m:mm, d:dd)'),
('defRecips', '', 'Default recipients list for email and SMS notifications'),
('defVenue', '', 'Default venue in the venue field of the event form'),
('defViewLogL', '2', 'View large display at start-up (1:year, ... 8:changes) - logged in user'),
('defViewLogS', '7', 'View small display at start-up (1:year, ... 8:changes) - logged in user'),
('defViewPubL', '2', 'View large display at start-up (1:year, ... 8:changes) - public user'),
('defViewPubS', '7', 'View small display at start-up (1:year, ... 8:changes) - public user'),
('dwEndHour', '18', 'Day/week view end hour'),
('dwStartHour', '6', 'Day/week view start hour'),
('dwTimeSlot', '30', 'Day/week time slot in minutes'),
('dwTsHeight', '20', 'Day/week time slot height in pixels'),
('emlFootnote', '', 'Footnote text added to email reminders'),
('emlService', '1', 'Email service (0:no, 1:yes)'),
('emojiPicker', '1', 'Show emoji picker in Event Add/Edit window (0:no, 1:yes)'),
('eventColor', '1', 'Event colors (0:no color, 1:cat color, 2:user group color)'),
('eventExp', '0', 'Number of days after due when an event expires / can be deleted (0:never)'),
('evtDelButton', '1', 'Display Delete button in Event window (0:no, 1:yes, 2:manager)'),
('evtDrAndDr', '0', 'Event drag and drop (0:disabled, 1:enabled, 2:manager)'),
('evtHeadM', '#ts #e', 'Event fields / layout template for month view'),
('evtHeadW', '#ts #e', 'Event fields / layout template for week and day views'),
('evtSorting', '0', 'Sort events on times or cat. seq. nr (0:times, 1:cat seq nr)'),
('evtTemplGen', '12345678', 'Public user: Event fields and order in general views'),
('evtTemplGen2', '12345678', 'Logged-in user: Event fields and order in general views'),
('evtTemplPop', '123458', 'Public user: Event fields and order in hover box'),
('evtTemplPop2', '123458', 'Logged-in user: Event fields and order in hover box'),
('evtTemplUpc', '123458', 'Public user: Event fields and order in upcoming events view'),
('evtTemplUpc2', '123458', 'Logged-in user: Event fields and order in upcoming events view'),
('evtWinSmall', '0', 'Show reduced Event window (0:no, 1:yes)'),
('groupMenu', '1', 'Display group filter menu in options panel (0:no, 1:yes)'),
('icsExport', '0', 'Daily export of events in iCal format (0:no 1:yes)'),
('langMenu', '0', 'Display ui-language selection menu in options panel (0:no, 1:yes)'),
('language', 'English', 'Default user interface language'),
('logNotices', '0', 'Log calendar notice messages (0:no, 1:yes)'),
('logVisitors', '0', 'Log calendar visitors data (0:no, 1:yes)'),
('logWarnings', '1', 'Log calendar warning messages (0:no, 1:yes)'),
('logoHeight', '', 'Height of the login page logo image'),
('logoPath', '', 'Path/name of optional left upper corner logo image'),
('logoXlPath', '', 'Path/name of optional login page logo image'),
('lookaheadDays', '14', 'Days to look ahead in upcoming view, todo list and RSS feeds'),
('lookbackDays', '30', 'Days to look back in the todo list'),
('mailServer', '1', 'Mail server (1:PHP mail, 2:SMTP mail)'),
('maintMode', '0', 'Run calendar in maintenance mode (0:no, 1:yes)'),
('mapViewer', 'https://maps.google.com/maps?q=', 'map viewer for the event address button'),
('maxEmlCc', '10', 'Default max. number of recipients in email Cc field'),
('maxLenSms', '70', 'Maximum length of SMS messages (bytes)'),
('maxNoLogin', '0', 'Number of days not logged in, before deleting user account (0:never delete)'),
('maxUplSize', '2', 'Max. size of uploaded attachment and thumbnail files in MBs'),
('maxXsWidth', '800', 'Upper limit responsive calendar mode'),
('monthInDCell', '0', 'Show in month view month for each day (0:no, 1:yes)'),
('msgLogWeeks', '2', 'Default max. number of weeks to keep message logs'),
('msgLogging', '0', 'Notification message logging'),
('notSenderEml', '0', 'Sender of notification emails (0:calendar, 1:user)'),
('notSenderSms', '0', 'Sender of notification SMSes (0:calendar, 1:user)'),
('ownerTitle', '0', 'Prepend owner to event title (0:disabled 1:enabled)'),
('popFieldsSbar', '12345', 'Event fields in sidebar hover box (none: no box)'),
('privEvents', '1', 'Private events (0:disabled 1:enabled, 2:default, 3:always)'),
('restLastSel', '1', 'Restore last session when user revisits calendar'),
('rssFeed', '1', 'Display RSS feed links in footer and HTML head (0:no, 1:yes)'),
('scrollDCell', '0', 'Vertical scrollbar in month view day cells (0:no, 1:yes)'),
('searchAheadDays', '365', 'Defalt days to look ahead on Search page'),
('searchBackDays', '365', 'Default days to look back on Search page'),
('selfReg', '0', 'Self-registration (0:no, 1:yes)'),
('selfRegA', '', 'Self-registration answer to selfregQ'),
('selfRegGrp', '4', 'Self-registration user group ID'),
('selfRegNot', '0', 'User self-reg notification to admin (0:no, 1:yes)'),
('selfRegQ', '', 'Self-registration question to answer'),
('showImgInMV', '0', 'Show images in month view (0:no, 1:yes)'),
('showLinkInSB', '1', 'Show URL-links in sidebar (0:no, 1:yes)'),
('sideBarDays', '14', 'Days to look ahead in sidebar'),
('smsAddLink', '0', 'Add event report link to SMS (0:no, 1:yes)'),
('smsCarrier', '', 'SMS carrier template (# = mob. phone number)'),
('smsCountry', '', 'SMS country code'),
('smsService', '0', 'SMS service (0:no, 1:yes)'),
('smsSubject', '', 'Subject field template for SMS emails to the carrier'),
('smtpAuth', '1', 'Use SMTP authentication (0:no, 1:yes)'),
('smtpPass', '', 'SMTP password'),
('smtpPort', '465', 'SMTP port number'),
('smtpServer', '', 'SMTP mail server name'),
('smtpSsl', '1', 'Use SSL (Secure Sockets Layer) (0:no, 1:yes)'),
('smtpUser', '', 'SMTP username'),
('spDateFixed', '0', 'Side panel date fixed (0:cD is taken, 1:date of today)'),
('spImages', '', 'Show images in side panel (csv-list with views)'),
('spInfoArea', '', 'Show info area in side panel (csv-list with views)'),
('spMiniCal', '', 'Show mini calendar in side panel (csv-list with views)'),
('timeDefault', '0', 'Time default for new events (0:time fields 1:all day 2: no time)'),
('timeFormat', 'h:m', 'Time format (H:hh, h:h, m:mm, a:am|pm, A:AM|PM)'),
('timeZone', 'Europe/Amsterdam', 'Calendar time zone'),
('tlgService', '0', 'Telegram service (0:no, 1:yes)'),
('tlgToken', '', 'Telegram token'),
('tnlDelDays', '20', 'thumbnails used since last 20 days cannot be deleted'),
('tnlMaxH', '120', 'Max. height of uploaded thumbnails image in pixels'),
('tnlMaxW', '160', 'Max. width of uploaded thumbnails image in pixels'),
('tnlTypes', '.jpg,.jpeg,.gif,.png', 'Valid types of uploaded thumbnails'),
('toapList', '1', 'Display option Approve in side menu (0:no, 1:yes)'),
('todoList', '1', 'Display option Todo in side menu (0:no, 1:yes)'),
('topBarDate', '1', 'Show current date on top bar in calendar views (0:no, 1:yes)'),
('upcoList', '1', 'Display option Upcoming in side menu (0:no, 1:yes)'),
('userMenu', '1', 'Display user filter menu in options panel (0:no, 1:yes)'),
('venueInput', '0', 'Venue input (0:free text 1:drop-down list, 2:both)'),
('viewButsLogL', '1,2,4,7', 'View buttons on the navbar (1:year, ... 11:gantt) - logged in user, large display'),
('viewButsLogS', '2,7', 'View buttons on the navbar (1:year, ... 11:gantt) - logged in user, small display'),
('viewButsPubL', '2,7', 'View buttons on the navbar (1:year, ... 11:gantt) - public user, large display'),
('viewButsPubS', '', 'View buttons on the navbar (1:year, ... 11:gantt) - public user, small display'),
('viewMenu', '1', 'Display view menu in options panel (0:no, 1:yes)'),
('viewsLogged', '1,2,3,4,5,6,7,8,9,10,11', 'Calendar views available to the logged-in users'),
('viewsPublic', '1,2,3,4,5,6,7,8,9,10,11', 'Calendar views available to the public users'),
('weekNumber', '1', 'Week numbers on(1) or off(0)'),
('weekStart', '1', 'First day of the week (0: su - 6: sa)'),
('workWeekDays', '12345', 'Working days (0: su - 6: sa)'),
('xField1Label', '', 'Label optional extra event field 1'),
('xField1Rights', '1', 'Extra event field 1 minimum required rights to see'),
('xField2Label', '', 'Label optional extra event field 2'),
('xField2Rights', '1', 'Extra event field 2 minimum required rights to see'),
('yearStart', '0', 'Start month in year view (1-12 or 0, 0:current month)');

-- --------------------------------------------------------

--
-- Table structure for table `mycal_styles`
--

CREATE TABLE `mycal_styles` (
  `name` varchar(8) COLLATE utf8mb4_bin NOT NULL,
  `value` varchar(255) COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;

--
-- Dumping data for table `mycal_styles`
--

INSERT INTO `mycal_styles` VALUES
('BBHAR', '#96B4FF'),
('BBUTS', '#FFFFFF'),
('BCHBX', '#FFFFDD'),
('BCONF', '#A0D070'),
('BDROP', '#FFFFFF'),
('BERRO', '#F0A070'),
('BFFLD', '#FFFFFF'),
('BGCTH', '#F2F2F2'),
('BGOUT', '#FEFEFE'),
('BGSEL', '#FFEEEE'),
('BGTFD', '#96B4FF'),
('BGTOD', '#EEEEFF'),
('BGWD1', '#FFFFEE'),
('BGWD2', '#FFFFDD'),
('BGWE1', '#FFFFCC'),
('BGWE2', '#FFFFBB'),
('BGWTC', '#FFFFBB'),
('BHLIT', '#FF2222'),
('BHNOR', '#FFFFE0'),
('BHPRI', '#CCFFCC'),
('BHREP', '#FFFFE0'),
('BINBX', '#FFFFEE'),
('BLINK', '#FFFFFF'),
('BOVBX', '#FEFEFE'),
('BTBAR', '#FDFDFD'),
('BWARN', '#FFF0A0'),
('BXWIN', '#FFFFEE'),
('BXXXX', '#E0E0E0'),
('CBHAR', '#2B3856'),
('CBUTS', '#2B3856'),
('CCHBX', '#FF0000'),
('CCONF', '#2B3856'),
('CDROP', '#2B3856'),
('CERRO', '#2B3856'),
('CFFLD', '#2B3856'),
('CGOUT', '#2B3856'),
('CGSEL', '#2B3856'),
('CGTFD', '#2B3856'),
('CGTOD', '#2B3856'),
('CGWD1', '#2B3856'),
('CGWD2', '#2B3856'),
('CGWE1', '#2B3856'),
('CGWE2', '#2B3856'),
('CGWTC', '#666666'),
('CHLIT', '#2B3856'),
('CHNOR', '#2B3856'),
('CHPRI', '#2B3856'),
('CHREP', '#2B3856'),
('CINBX', '#2B3856'),
('CLINK', '#C02020'),
('COVBX', '#2B3856'),
('CTBAR', '#2B3856'),
('CWARN', '#2B3856'),
('CXWIN', '#2B3856'),
('CXXXX', '#2B3856'),
('EBUTS', '#0080FE'),
('EGSEL', '#FF0000'),
('EGTOD', '#0000FF'),
('EHNOR', '#808080'),
('EHPRI', '#808080'),
('EHREP', '#E00060'),
('EOVBX', '#96B4FF'),
('EXXXX', '#808080'),
('FFXXX', 'arial,sans-serif'),
('MBUTS', '0.9'),
('MDTHD', '1.0'),
('MEVTI', '1.0'),
('MFFLD', '1.0'),
('MOVBX', '1.0'),
('MPOPU', '1.0'),
('MPWIN', '1.1'),
('MSMAL', '0.8'),
('MSNHD', '1.0'),
('MTHDM', '1.0'),
('PPGTL', '14'),
('PSXXX', '12'),
('PTBAR', '13'),
('PTHDL', '13'),
('THEME', 'mycal'),
('sCtOf', '0'),
('sTbSw', '1');

-- --------------------------------------------------------

--
-- Table structure for table `mycal_users`
--

CREATE TABLE `mycal_users` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(165) COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `name` varchar(48) COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `password` varchar(32) COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `tPassword` varchar(32) COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `email` varchar(255) COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `phone` varchar(32) COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `msingID` varchar(16) COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `notSrvs` varchar(8) COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `groupID` mediumint(9) NOT NULL DEFAULT '3',
  `language` varchar(24) COLLATE utf8mb4_bin DEFAULT '',
  `expDate` varchar(10) COLLATE utf8mb4_bin NOT NULL DEFAULT '9999-00-00',
  `login0` varchar(10) COLLATE utf8mb4_bin NOT NULL DEFAULT '9999-00-00',
  `login1` varchar(10) COLLATE utf8mb4_bin NOT NULL DEFAULT '9999-00-00',
  `loginCnt` mediumint(9) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin AUTO_INCREMENT=3 ;

--
-- Dumping data for table `mycal_users`
--

INSERT INTO `mycal_users` VALUES
(1, '', 'Public Access', '', '', '', '', '', '', 3, '', '9999-00-00', '[[date]]', '[[date]]', 1, 0),
(2, '', '[[admin_username]]', '[[admin_pass]]', '', '[[admin_email]]', '', '', '', 2, 'english', '9999-00-00', '9999-00-00', '9999-00-00', 0, 0);

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
