
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `lychee681`
--
-- --------------------------------------------------------

--
-- Table structure for table `access_permissions`
--

CREATE TABLE `access_permissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `user_group_id` int(10) unsigned DEFAULT NULL,
  `base_album_id` char(24) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_link_required` tinyint(1) NOT NULL DEFAULT '0',
  `password` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `grants_full_photo_access` tinyint(1) NOT NULL DEFAULT '0',
  `grants_download` tinyint(1) NOT NULL DEFAULT '0',
  `grants_upload` tinyint(1) NOT NULL DEFAULT '0',
  `grants_edit` tinyint(1) NOT NULL DEFAULT '0',
  `grants_delete` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `access_permissions_base_album_id_user_id_unique` (`base_album_id`,`user_id`),
  KEY `access_permissions_user_id_index` (`user_id`),
  KEY `access_permissions_base_album_id_index` (`base_album_id`),
  KEY `access_permissions_is_link_required_index` (`is_link_required`),
  KEY `access_permissions_is_link_required_password_index` (`is_link_required`,`password`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `albums`
--

CREATE TABLE `albums` (
  `id` char(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` char(24) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `license` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'none',
  `album_thumb_aspect_ratio` varchar(6) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `album_timeline` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `album_sorting_col` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `album_sorting_order` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cover_id` char(24) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `header_id` char(24) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `track_short_path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `_lft` bigint(20) unsigned NOT NULL DEFAULT '0',
  `_rgt` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `albums__lft__rgt__index` (`_lft`,`_rgt`),
  KEY `albums_parent_id_foreign` (`parent_id`),
  KEY `albums_cover_id_foreign` (`cover_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `base_albums`
--

CREATE TABLE `base_albums` (
  `id` char(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(6) NOT NULL,
  `updated_at` datetime(6) NOT NULL,
  `published_at` datetime DEFAULT NULL,
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `owner_id` int(10) unsigned NOT NULL DEFAULT '0',
  `is_nsfw` tinyint(1) NOT NULL DEFAULT '0',
  `is_pinned` tinyint(1) NOT NULL DEFAULT '0',
  `sorting_col` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sorting_order` varchar(4) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `copyright` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `photo_layout` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `photo_timeline` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `base_albums_owner_id_index` (`owner_id`),
  KEY `base_albums_published_at_index` (`published_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `colours`
--

CREATE TABLE `colours` (
  `id` mediumint(8) unsigned NOT NULL,
  `R` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `G` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `B` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `colours_r_g_b_unique` (`R`,`G`,`B`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `configs`
--

CREATE TABLE `configs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cat` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Config',
  `type_range` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0|1',
  `is_secret` tinyint(1) NOT NULL DEFAULT '0',
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `details` text COLLATE utf8mb4_unicode_ci COMMENT 'Details for the config, can be used to store extra informations for the users.',
  `level` int(11) NOT NULL DEFAULT '0',
  `not_on_docker` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Defines that this setting is not used/displayed in docker installations',
  `is_expert` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Defines that this setting is only visible in expert view',
  `order` smallint(5) unsigned NOT NULL DEFAULT '32767',
  PRIMARY KEY (`id`),
  UNIQUE KEY `configs_key_unique` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=279 ;

--
-- Dumping data for table `configs`
--

INSERT INTO `configs` VALUES
(1, 'version', '060801', 'Admin', 'int', 0, 'Current version of Lychee', '', 0, 0, 1, 9),
(4, 'check_for_updates', '0', 'Admin', '0|1', 0, 'Automatically check for new updates', '', 0, 0, 0, 1),
(5, 'sorting_photos_col', 'taken_at', 'Gallery', 'created_at|taken_at|title|description|is_starred|type', 0, 'Default column used for sorting photos', '', 0, 0, 0, 4),
(6, 'sorting_photos_order', 'ASC', 'Gallery', 'ASC|DESC', 0, 'Default order used for sorting photos', '', 0, 0, 0, 5),
(7, 'sorting_albums_col', 'max_taken_at', 'Gallery', 'created_at|title|description|max_taken_at|min_taken_at', 0, 'Default column used for sorting albums', '', 0, 0, 0, 2),
(8, 'sorting_albums_order', 'ASC', 'Gallery', 'ASC|DESC', 0, 'Default order used for sorting albums', '', 0, 0, 0, 3),
(9, 'imagick', '1', 'Image Processing', '0|1', 0, 'Enable imagick processing', '', 0, 0, 1, 32767),
(10, 'dropbox_key', 'disabled', 'Admin', 'string', 1, 'Dropbox API key', 'Use value "disabled" to mark this setting as such.', 0, 0, 0, 0),
(11, 'skip_duplicates', '0', 'Image Processing', '0|1', 0, 'Skip duplicate if found on import', '', 0, 0, 0, 22),
(12, 'small_max_width', '0', 'Image Processing', 'int', 0, 'Maximum width for small thumbs (album view)', '', 0, 0, 0, 2),
(13, 'small_max_height', '360', 'Image Processing', 'int', 0, 'Maximum height for small thumbs (album view)', '', 0, 0, 0, 1),
(14, 'medium_max_width', '1920', 'Image Processing', 'int', 0, 'Maximum width for medium image (photo view)', '', 0, 0, 0, 5),
(15, 'medium_max_height', '1080', 'Image Processing', 'int', 0, 'Maximum height for medium image (photo view)', '', 0, 0, 0, 4),
(16, 'lang', 'en', 'config', '', 0, 'Language used by Lychee', '', 0, 0, 0, 3),
(19, 'image_overlay_type', 'desc', 'Gallery', 'exif|desc|date|none', 0, 'Default image overlay information', '', 0, 0, 0, 9),
(20, 'default_license', 'none', 'Gallery', 'license', 0, 'Default license used for albums', '', 0, 0, 0, 18),
(21, 'compression_quality', '90', 'Image Processing', 'positive', 0, 'Compression percent when generating thumbs', '', 0, 0, 0, 10),
(22, 'grants_full_photo_access', '1', 'access_permissions', '0|1', 0, 'Allows access to full resolution by default', '', 0, 0, 0, 4),
(23, 'delete_imported', '0', 'Image Processing', '0|1', 0, 'When importing from server, delete originals', '', 0, 0, 0, 20),
(24, 'mod_frame_enabled', '1', 'Mod Frame', '0|1', 0, 'Enable Mod Frame', 'Note that access to the chosen album is required to view the frame.<br><i class="pi pi-exclamation-triangle text-orange-500"></i> The button will be visible only if the condition is satisfied.', 0, 0, 0, 0),
(25, 'mod_frame_refresh', '30', 'Mod Frame', 'int', 0, 'Refresh rate of the Frame', '', 0, 0, 0, 2),
(26, 'thumb_2x', '1', 'Image Processing', '0|1', 0, 'Enable 2x size of square thumbs', '', 0, 0, 0, 0),
(27, 'small_2x', '1', 'Image Processing', '0|1', 0, 'Enable 2x size of small thumbs', '', 0, 0, 0, 3),
(28, 'medium_2x', '1', 'Image Processing', '0|1', 0, 'Enable 2x size of medium pictures', '', 0, 0, 0, 6),
(29, 'landing_page_enable', '0', 'Mod Welcome', '0|1', 0, 'Display the landing page', '', 0, 0, 0, 0),
(30, 'site_owner', 'John Smith', 'config', 'string', 1, 'Website Owner', '', 0, 0, 0, 1),
(31, 'landing_title', 'John Smith', 'Mod Welcome', 'string', 1, 'Title on the landing page', '', 0, 0, 0, 1),
(32, 'landing_subtitle', 'Cats, Dogs & Humans Photography', 'Mod Welcome', 'string', 1, 'Subtitle on the landing page', '', 0, 0, 0, 2),
(33, 'sm_facebook_url', 'https://www.facebook.com/JohnSmith', 'Footer', 'string', 1, 'Url of facebook profile', '', 0, 0, 0, 32767),
(34, 'sm_flickr_url', 'https://www.flickr.com/JohnSmith', 'Footer', 'string', 1, 'Url of flickr profile', '', 0, 0, 0, 32767),
(35, 'sm_twitter_url', 'https://www.twitter.com/JohnSmith', 'Footer', 'string', 1, 'Url of X profile (formerly Twitter)', '', 0, 0, 0, 32767),
(36, 'sm_instagram_url', 'https://instagram.com/JohnSmith', 'Footer', 'string', 1, 'Url of instagram profile', '', 0, 0, 0, 32767),
(37, 'sm_youtube_url', 'https://www.youtube.com/JohnSmith', 'Footer', 'string', 1, 'Url of youtube profile', '', 0, 0, 0, 32767),
(39, 'site_title', 'Lychee v6', 'config', 'string', 1, 'Website title', '', 0, 0, 0, 2),
(40, 'footer_show_copyright', '1', 'Footer', '0|1', 1, 'Display copyright in footer.', '', 0, 0, 0, 0),
(41, 'site_copyright_begin', '2019', 'Footer', 'positive', 1, 'Initial year of copyright', '', 0, 0, 0, 1),
(42, 'site_copyright_end', '2019', 'Footer', 'positive', 1, 'Last year of copyright', '', 0, 0, 0, 2),
(44, 'allow_online_git_pull', '1', 'Admin', '0|1', 1, 'Allow git pull via web interface', '', 0, 1, 1, 2),
(46, 'footer_additional_text', '', 'Footer', 'string', 1, 'Additional text of the footer.', '<span class="pi pi-exclamation-triangle text-orange-500"></span> Unsanitized html field.', 0, 0, 1, 3),
(47, 'footer_show_social_media', '0', 'Footer', '0|1', 1, 'Show social media links in footer.', '', 0, 0, 0, 4),
(48, 'search_public', '0', 'Mod Search', '0|1', 0, 'Allows anonymous user to use the Search bar', '', 0, 0, 0, 0),
(50, 'hide_version_number', '0', 'Admin', '0|1', 0, 'Hide current version number', '', 0, 0, 1, 10),
(55, 'recent_age', '1', 'Smart Albums', 'positive', 0, 'Maximum age of pictures in Recent in days', '', 0, 0, 0, 32767),
(57, 'grants_download', '0', 'access_permissions', '0|1', 0, 'Grants download by default.', '', 0, 0, 0, 3),
(58, 'photos_wraparound', '1', 'Gallery', '0|1', 0, 'Once reaching last picture of an album, loop back to the start', '', 0, 0, 0, 16),
(59, 'raw_formats', '.tex', 'Image Processing', '', 1, 'Allowed extra formats, will not be processed', '', 0, 0, 0, 32767),
(60, 'map_display', '0', 'Mod Map', '0|1', 0, 'Display the map given GPS coordinates', '', 0, 0, 0, 0),
(61, 'zip64', '1', 'Admin', '0|1', 0, 'Use Zip 64bits instead of 32 bits', '', 0, 0, 1, 32767),
(62, 'map_display_public', '0', 'Mod Map', '0|1', 0, 'Allow anonymous users to access the map', '', 0, 0, 0, 1),
(63, 'map_provider', 'Wikimedia', 'Mod Map', 'map_provider', 0, 'Defines the map provider', '', 0, 0, 0, 4),
(65, 'map_include_subalbums', '0', 'Mod Map', '0|1', 0, 'Includes pictures of the sub albums on the map', '', 0, 0, 0, 3),
(66, 'update_check_every_days', '3', 'Admin', 'positive', 0, 'Frequency of Lychee update checks', '', 0, 0, 0, 32767),
(67, 'has_exiftool', '0', 'Image Processing', '0|1|2', 0, 'Defines whether exiftool processing is available', '', 0, 0, 1, 32767),
(68, 'share_button_visible', '0', 'access_permissions', '0|1', 0, 'Share button visibility in the header', '', 0, 0, 0, 5),
(69, 'import_via_symlink', '0', 'Image Processing', '0|1', 0, 'Use symbolic links instead of copying the original on import from server', '', 0, 0, 0, 21),
(70, 'has_ffmpeg', '0', 'Image Processing', '0|1|2', 0, 'Defines whether ffmpeg processing is available', '', 0, 0, 1, 32767),
(71, 'apply_composer_update', '0', 'Admin', '0|1', 1, 'Apply composer update on lychee update via web interface', '', 0, 1, 1, 3),
(72, 'location_decoding', '0', 'Mod Map', '0|1', 0, 'Use GPS location decoding', '', 0, 0, 0, 5),
(73, 'location_decoding_timeout', '30', 'Mod Map', 'int', 0, 'Timeout for the GPS decoding queries', '', 0, 0, 1, 6),
(74, 'location_show', '1', 'Mod Map', '0|1', 0, 'Show location extracted from GPS coordinates', '', 0, 0, 0, 7),
(75, 'location_show_public', '0', 'Mod Map', '0|1', 0, 'Anonymous users can acess the extracted location from GPS coordinates', '', 0, 0, 0, 8),
(76, 'rss_enable', '0', 'Mod RSS', '0|1', 0, 'Enable RSS feed', '', 0, 0, 0, 0),
(77, 'rss_recent_days', '7', 'Mod RSS', 'positive', 0, 'Display the last X days in the RSS feed', '', 0, 0, 0, 32767),
(78, 'rss_max_items', '100', 'Mod RSS', 'positive', 0, 'Max number of items in the RSS feed', '', 0, 0, 0, 32767),
(79, 'prefer_available_xmp_metadata', '0', 'Image Processing', '0|1', 0, 'Use sidecar if provided instead of exif metadata', '', 0, 0, 1, 32767),
(80, 'editor_enabled', '1', 'Image Processing', '0|1', 0, 'Enable manual rotation of images', '', 0, 0, 0, 14),
(81, 'lossless_optimization', '0', 'Image Processing', '0|1', 0, 'Apply additional compression on images', '', 0, 0, 1, 32767),
(84, 'local_takestamp_video_formats', '.avi|.mov', 'Image Processing', '', 0, 'Use local takestamp for the following video formats', '', 0, 0, 0, 32767),
(85, 'log_max_num_line', '1000', 'Admin', 'positive', 0, 'Display the last X most recent lines in Logs', '', 0, 0, 1, 32767),
(86, 'unlock_password_photos_with_url_param', '0', 'access_permissions', '0|1', 0, 'Allow password to be passed as a URL parameter to unlock albums', '', 0, 0, 1, 6),
(87, 'nsfw_visible', '1', 'Mod NSFW', '0|1', 0, 'Make sensitive albums visible by default', '', 0, 0, 0, 0),
(88, 'nsfw_blur', '0', 'Mod NSFW', '0|1', 0, 'Blur sensitive albums', 'Blur the album cover.', 0, 0, 0, 2),
(89, 'nsfw_warning', '0', 'Mod NSFW', '0|1', 0, 'Enable sensitive albums warning', 'Display a warning when the album is opened the first time.', 0, 0, 0, 1),
(90, 'nsfw_warning_admin', '0', 'Mod NSFW', '0|1', 0, 'Enable sensitive albums warning when logged in', '', 0, 0, 0, 5),
(91, 'nsfw_banner_override', '', 'Mod NSFW', 'string', 0, 'Custom warning text instead of default.', '<span class="pi pi-exclamation-triangle text-orange-500"></span> Unsanitized html field.', 0, 0, 1, 4),
(92, 'map_display_direction', '1', 'Mod Map', '0|1', 0, 'Display the direction of the picture on the map if available', '', 0, 0, 0, 2),
(93, 'album_subtitle_type', 'oldstyle', 'Gallery', 'description|takedate|creation|oldstyle', 0, 'Defines the subtitle of album in albums view', '', 0, 0, 0, 8),
(94, 'upload_processing_limit', '4', 'Image Processing', 'int', 0, 'Maximum number of images processed in parallel', '', 0, 0, 1, 16),
(96, 'new_photos_notification', '0', 'config', '0|1', 0, 'Enable notifications when new photos are added', '', 0, 0, 1, 32767),
(98, 'zip_deflate_level', '6', 'Admin', '-1|0|1|2|3|4|5|6|7|8|9', 0, 'Zip compression level.', '-1 = disable compression (use STORE method), 0 = no compression (use DEFLATE method), 1 = minimal compression (fast), ... 9 = maximum compression (slow)', 0, 0, 1, 32767),
(100, 'default_album_protection', '1', 'Gallery', '1|2|3', 0, 'Default protection for newly created albums', '', 0, 0, 0, 19),
(101, 'album_decoration', 'layers', 'Gallery', 'none|layers|album|photo|all', 0, 'Show decorations on album cover (sub-album and/or photo count)', '', 0, 0, 0, 6),
(102, 'album_decoration_orientation', 'row', 'Gallery', 'column|column-reverse|row|row-reverse', 0, 'Align album decorations horizontally or vertically', '', 0, 0, 0, 7),
(103, 'allow_username_change', '1', 'Users Management', '0|1', 0, 'Allow users to change their username.', '', 0, 0, 0, 0),
(105, 'auto_fix_orientation', '1', 'Image Processing', '0|1', 0, 'Automatically rotate imported images', '<span class="pi pi-exclamation-triangle text-orange-500"></span> Original images will be overwritten and compressed.', 0, 0, 0, 9),
(106, 'use_job_queues', '0', 'Image Processing', '0|1', 0, 'Use job queues instead of directly live connection.', '', 0, 0, 1, 17),
(107, 'random_album_id', 'starred', 'Mod Frame', 'string', 0, 'Album id to be used by for random function.', 'Default album displayed, if left empty then all searchable photos will be used.', 0, 0, 0, 1),
(108, 'use_last_modified_date_when_no_exif_date', '0', 'Image Processing', '0|1', 0, 'Use the file''s last modified time when Exif data has no creation date', '', 0, 0, 1, 32767),
(109, 'ffmpeg_path', '', 'Image Processing', 'string', 1, 'Path to the binary of ffmpeg', '', 0, 0, 1, 32767),
(110, 'ffprobe_path', '', 'Image Processing', 'string', 1, 'Path to the binary of ffprobe', '', 0, 0, 1, 32767),
(111, 'layout', 'justified', 'Gallery', 'square|justified|masonry|grid', 0, 'Layout for pictures', '', 0, 0, 0, 0),
(112, 'date_format_photo_thumb', 'M j, Y, g:i:s A e', 'Gallery', 'string_required', 0, 'Format the date for the photo thumbs.', 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>', 0, 0, 1, 32767),
(113, 'date_format_photo_overlay', 'M j, Y, g:i:s A e', 'Gallery', 'string_required', 0, 'Format the date for the photo overlay.', 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>', 0, 0, 1, 32767),
(114, 'date_format_sidebar_uploaded', 'M j, Y, g:i:s A e', 'Gallery', 'string_required', 0, 'Format the upload date for the photo sidebar.', 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>', 0, 0, 1, 32767),
(115, 'date_format_sidebar_taken_at', 'M j, Y, g:i:s A e', 'Gallery', 'string_required', 0, 'Format the capture date for the photo sidebar.', 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>', 0, 0, 1, 32767),
(116, 'date_format_hero_min_max', 'F Y', 'Gallery', 'string_required', 0, 'Format the date for the album hero.', 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>', 0, 0, 1, 32767),
(117, 'date_format_hero_created_at', 'M j, Y, g:i:s A T', 'Gallery', 'string_required', 0, 'Format the created date for the album details.', 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>', 0, 0, 1, 32767),
(118, 'date_format_album_thumb', 'M Y', 'Gallery', 'string_required', 0, 'Format the date for the album thumbs.', 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>', 0, 0, 1, 32767),
(119, 'upload_chunk_size', '0', 'Image Processing', 'int', 0, 'Size of chunks when uploading in bytes: 0 is auto', '', 0, 0, 1, 15),
(120, 'nsfw_banner_blur_backdrop', '0', 'Mod NSFW', '0|1', 0, 'Blur background instead of dark red opaque.', 'Blur the backdrop of the warning.', 0, 0, 0, 3),
(121, 'search_pagination_limit', '300', 'Mod Search', 'positive', 0, 'Number of results to display per page.', '', 0, 0, 0, 2),
(122, 'search_minimum_length_required', '4', 'Mod Search', 'positive', 0, 'Number of characters required to trigger search (default: 4).', '', 0, 0, 0, 1),
(123, 'photo_layout_justified_row_height', '320', 'Gallery', 'positive', 0, 'Heights of rows in Justified photo layout', '', 0, 0, 1, 32),
(124, 'photo_layout_masonry_column_width', '300', 'Gallery', 'positive', 0, 'Minimum column width in Masonry photo layout.', '', 0, 0, 1, 33),
(125, 'photo_layout_grid_column_width', '250', 'Gallery', 'positive', 0, 'Minimum column width in Grid photo layout.', '', 0, 0, 1, 31),
(126, 'photo_layout_square_column_width', '200', 'Gallery', 'positive', 0, 'Minimum column width in Square photo layout.', '', 0, 0, 1, 34),
(127, 'photo_layout_gap', '12', 'Gallery', 'positive', 0, 'Gap between columns in Square/Masonry/Grid photo layout.', '', 0, 0, 1, 30),
(128, 'display_thumb_album_overlay', 'always', 'Gallery', 'always|hover|never', 0, 'Display the title and metadata on album thumbs', '', 0, 0, 0, 10),
(129, 'display_thumb_photo_overlay', 'hover', 'Gallery', 'always|hover|never', 0, 'Display the title and metadata on photo thumbs', '', 0, 0, 0, 11),
(130, 'default_album_thumb_aspect_ratio', '1/1', 'Gallery', '1/1|2/3|3/2|4/5|5/4|16/9', 0, 'Default aspect ratio for album thumbs', '', 0, 0, 0, 1),
(131, 'use_album_compact_header', '0', 'Gallery', '0|1', 0, 'Disable the header image in albums', '', 0, 0, 0, 14),
(133, 'back_button_enabled', '0', 'Mod Back Button', '0|1', 0, 'Enable/disable back button on gallery', '', 0, 0, 0, 0),
(134, 'back_button_text', 'Return to Home', 'Mod Back Button', 'string', 0, 'Text of the back button (will be positioned opposite to Login)', '', 0, 0, 0, 32767),
(135, 'back_button_url', '/', 'Mod Back Button', 'string', 1, 'Link of the back button', '', 0, 0, 0, 32767),
(137, 'SA_random_thumbs', '0', 'Smart Albums', '0|1', 0, 'Use random thumbs instead of stared/sorting order.', '', 0, 0, 1, 32767),
(139, 'login_required', '0', 'access_permissions', '0|1', 0, 'Require user to login to access gallery.', '', 0, 0, 0, 1),
(140, 'enable_unsorted', '1', 'Smart Albums', '0|1', 0, 'Enable Unsorted smart album.', '<span class="pi pi-exclamation-triangle text-orange-500"></span> Disabling this smart album will make pictures without an album invisible.', 0, 0, 0, 0),
(141, 'enable_starred', '1', 'Smart Albums', '0|1', 0, 'Enable Starred smart album.', '', 0, 0, 0, 1),
(142, 'enable_recent', '1', 'Smart Albums', '0|1', 0, 'Enable Recent uploads smart album.', '', 0, 0, 0, 2),
(143, 'enable_on_this_day', '1', 'Smart Albums', '0|1', 0, 'Enable On this day smart album.', '', 0, 0, 0, 3),
(144, 'oauth_create_user_on_first_attempt', '0', 'Users Management', '0|1', 1, 'Allow user creation when oauth id does not exist.', '', 0, 0, 0, 32767),
(145, 'grant_new_user_upload_rights', '0', 'Users Management', '0|1', 1, 'Newly created user are allowed to upload content.', '', 0, 0, 0, 32767),
(146, 'grant_new_user_modification_rights', '0', 'Users Management', '0|1', 1, 'Newly created user are allowed to edit their profile.', '', 0, 0, 0, 32767),
(147, 'login_required_root_only', '1', 'access_permissions', '0|1', 0, 'Require user to login only on root. A user with a direct link to an album can still access it.', '', 0, 0, 0, 2),
(148, 'exiftool_path', '', 'Image Processing', 'string', 1, 'Path to the binary of exiftool.', '', 0, 0, 1, 32767),
(149, 'thumb_min_max_order', 'younger_older', 'Gallery', 'older_younger|younger_older', 1, 'Set which date to display first in thumb.', '', 0, 0, 0, 12),
(150, 'header_min_max_order', 'older_younger', 'Gallery', 'older_younger|younger_older', 1, 'Set which date to display first in header.', '', 0, 0, 0, 13),
(151, 'autoplay_enabled', '1', 'Gallery', '0|1', 1, 'Set autoplay attribute on videos.', '', 0, 0, 0, 15),
(152, 'dark_mode_enabled', '1', 'config', '0|1', 0, 'Use dark mode for Lychee', '', 0, 0, 0, 0),
(153, 'low_quality_image_placeholder', '1', 'Image Processing', '0|1', 0, 'Enable low quality image placeholders', '', 0, 0, 0, 7),
(154, 'show_keybinding_help_popup', '1', 'Admin', '0|1', 0, 'Display keybinding help pop-up on login.', '', 0, 0, 0, 8),
(155, 'show_keybinding_help_button', '1', 'Admin', '0|1', 0, 'Show keybinding help button in header.', '', 0, 0, 0, 7),
(156, 'email', '', 'lychee SE', 'string', 1, 'Email used when requesting the license.', '', 0, 0, 0, 32767),
(157, 'license_key', '', 'lychee SE', 'string', 1, 'Lychee License key', 'Get Supporter Edition here: <a class="underline" href="https://lycheeorg.dev/get-supporter-edition">https://lycheeorg.dev/get-supporter-edition</a>', 0, 0, 0, 2),
(158, 'disable_se_call_for_actions', '0', 'lychee SE', '0|1', 0, 'Disable Lychee SE hint', 'Hides Lychee SE call for actions.', 0, 0, 0, 0),
(159, 'enable_se_preview', '0', 'lychee SE', '0|1', 0, 'Enable preview of Lychee SE features', '', 0, 0, 0, 1),
(160, 'slideshow_timeout', '5', 'Gallery', 'positive', 0, 'Refresh rate of the slideshow in seconds.', 'Show next picture after x seconds.', 0, 0, 0, 17),
(161, 'keep_original_untouched', '1', 'Image Processing', '0|1', 0, 'Keep Original image untouched.', 'In case of auto rotation, the original image will be kept untouched.', 0, 0, 0, 8),
(162, 'default_user_quota', '0', 'Users Management', 'int', 1, 'Default space quota for new users.', 'Value in KB, keep at 0 to disable quota.', 1, 0, 0, 2),
(164, 'timeline_photos_enabled', '1', 'Mod Timeline', '0|1', 0, 'Enable timeline for photos', 'Globally enable photo timelines in each albums. This can also be disabled/enabled per album.', 0, 0, 0, 32767),
(165, 'timeline_photos_public', '0', 'Mod Timeline', '0|1', 0, 'Allow anonymous users to access the photo timeline', '', 0, 0, 0, 32767),
(166, 'timeline_photos_granularity', 'day', 'Mod Timeline', 'year|month|day|hour', 0, 'Timeline granularity for photos', '', 1, 0, 0, 32767),
(167, 'timeline_photos_order', 'taken_at', 'Mod Timeline', 'taken_at|created_at', 0, 'Order photos on', 'This determines whether the captured date or the upload date will be used to order the photos.', 0, 0, 0, 32767),
(168, 'timeline_photos_layout', 'square', 'Mod Timeline', 'square|justified|masonry|grid', 0, 'Photo layout for timeline page', '<span class=''italic''>Not available yet.</span>', 0, 0, 0, 32767),
(169, 'timeline_photos_pagination_limit', '200', 'Mod Timeline', 'positive', 0, 'Number of photos to display per page in timeline', '<span class=''italic''>Not available yet.</span>', 0, 0, 0, 32767),
(170, 'timeline_albums_enabled', '1', 'Mod Timeline', '0|1', 0, 'Enable timeline for albums', 'Globally enable albums timelines in each albums (and root). This can also be disabled/enabled per album.', 0, 0, 0, 32767),
(171, 'timeline_albums_public', '0', 'Mod Timeline', '0|1', 0, 'Display the albums timeline for anonymous users', '', 0, 0, 0, 32767),
(172, 'timeline_albums_granularity', 'year', 'Mod Timeline', 'year|month|day', 0, 'Timeline granularity for albums', '', 1, 0, 0, 32767),
(173, 'timeline_left_border_enabled', '1', 'Mod Timeline', '0|1', 0, 'Enable the left border line on timelines', '', 1, 0, 0, 32767),
(174, 'timeline_photo_date_format_year', 'Y', 'Mod Timeline', 'string_required', 0, 'Format the date at year granularity for photos', 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>', 1, 0, 1, 32767),
(175, 'timeline_photo_date_format_month', 'M Y', 'Mod Timeline', 'string_required', 0, 'Format the date at month granularity for photos', 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>', 1, 0, 1, 32767),
(176, 'timeline_photo_date_format_day', 'j M Y', 'Mod Timeline', 'string_required', 0, 'Format the date at day granularity for photos', 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>', 1, 0, 1, 32767),
(177, 'timeline_photo_date_format_hour', 'g:i', 'Mod Timeline', 'string_required', 0, 'Format the date at hour granularity for photos', 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>', 1, 0, 1, 32767),
(178, 'timeline_album_date_format_year', 'Y', 'Mod Timeline', 'string_required', 0, 'Format the date at year granularity for albums', 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>', 1, 0, 1, 32767),
(179, 'timeline_album_date_format_month', 'M Y', 'Mod Timeline', 'string_required', 0, 'Format the date at month granularity for albums', 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>', 1, 0, 1, 32767),
(180, 'timeline_album_date_format_day', 'j M', 'Mod Timeline', 'string_required', 0, 'Format the date at day granularity for albums', 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>', 1, 0, 1, 32767),
(181, 'hide_nsfw_in_smart_albums', '1', 'Mod NSFW', '0|1', 0, 'Do not show sensitive photos in Smart Albums', 'Pictures placed in sensive albums will not be shown in Smart Albums.', 0, 0, 0, 32767),
(182, 'hide_nsfw_in_frame', '1', 'Mod NSFW', '0|1', 0, 'Do not show sensitive photos in Frame', 'Pictures placed in sensive albums will not be shown on the Frame.', 0, 0, 0, 32767),
(183, 'hide_nsfw_in_map', '1', 'Mod NSFW', '0|1', 0, 'Do not show sensitive photos in Map', 'Pictures placed in sensive albums will not be shown on the Map.', 0, 0, 0, 32767),
(184, 'hide_nsfw_in_search', '1', 'Mod NSFW', '0|1', 0, 'Do not show sensitive photos in Search', 'Pictures placed in sensive albums will not be shown in Search.', 0, 0, 0, 32767),
(185, 'search_photos_layout', 'square', 'Mod Search', 'square|justified|masonry|grid', 0, 'Photo layout for search page', '', 0, 0, 0, 32767),
(186, 'hide_nsfw_in_rss', '1', 'Mod NSFW', '0|1', 0, 'Do not show sensitive photos in RSS', 'Pictures placed in sensive albums will not be shown in the RSS feed.', 0, 0, 0, 32767),
(187, 'hide_nsfw_in_timeline', '1', 'Mod Timeline', '0|1', 0, 'Do not show sensitive photos in Timeline', 'Pictures placed in sensive albums will not be shown in the timeline page.', 0, 0, 0, 32767),
(188, 'number_albums_per_row_mobile', '3', 'Gallery', '1|2|3', 0, 'Number of albums per row on mobile view', '', 1, 0, 0, 26),
(189, 'cache_enabled', '0', 'Mod Cache', '0|1', 0, 'Enable caching of responses given requests.', 'This will significantly speed up the response time of Lychee. <span class="pi pi-exclamation-triangle text-orange-500"></span> If you are using password protected albums, you should not enable this.', 0, 0, 0, 0),
(190, 'cache_event_logging', '0', 'Mod Cache', '0|1', 1, 'Add log lines for events related to caching.', 'This may result in large amount of logs', 0, 0, 1, 32767),
(191, 'cache_ttl', '86400', 'Mod Cache', 'positive', 0, 'Number of seconds responses should be cached.', 'Longer TTL will save more resources but may result in outdated responses.', 1, 0, 0, 1),
(192, 'low_number_of_shoots_per_day', '10', 'Gallery', 'positive', 0, 'Number of shoots per day to be considered as low.', 'This is used to determine the color in the punch card statistics.', 1, 0, 1, 27),
(193, 'medium_number_of_shoots_per_day', '50', 'Gallery', 'positive', 0, 'Number of shoots per day to be considered as medium.', 'This is used to determine the color in the punch card statistics.', 1, 0, 1, 28),
(194, 'high_number_of_shoots_per_day', '100', 'Gallery', 'positive', 0, 'Number of shoots per day to be considered as high.', 'This is used to determine the color in the punch card statistics.', 1, 0, 1, 29),
(195, 'maintenance_processing_limit', '5000', 'Admin', 'positive', 0, 'Number of maintenance operations to execute.', 'Larger number will process more items in one go, but may cause timeouts.', 0, 0, 0, 32767),
(196, 'disable_recursive_permission_check', '1', 'Admin', '0|1', 0, 'Disable recursive permission check.', 'Diagnostic page can be slow when there are many albums and photos. This option disables the recursive permission check for speed.', 0, 0, 0, 32767),
(197, 'exif_disabled_for_all', '0', 'Mod Privacy', '0|1', 0, 'Disable details and overlay panels in front-end.', '<span class="pi pi-exclamation-triangle text-orange-500"></span> This will not remove the data from the API end-point.', 1, 0, 0, 32767),
(198, 'file_name_hidden', '0', 'Mod Privacy', '0|1', 0, 'Do not show the photo title to anonymous users.', 'Logged in user will still have access to the title.', 1, 0, 0, 32767),
(199, 'default_old_settings', '0', 'Admin', '0|1', 0, 'Settings view as text input by default.', '', 0, 0, 0, 32767),
(200, 'default_expert_settings', '0', 'Admin', '0|1', 0, 'Expert settings view enabled by default.', '', 0, 0, 0, 32767),
(201, 'default_all_settings', '0', 'Admin', '0|1', 0, 'Show all settings in one page.', '', 0, 0, 0, 32767),
(202, 'client_side_favourite_enabled', '0', 'Mod Pro', '0|1', 0, 'Allow visitors to mark pictures as their favourite.', 'The favourites are persisted in the browser local storage.', 1, 0, 0, 1),
(203, 'disable_thumb_download', '1', 'access_permissions', '0|1', 0, 'Disable the download of squared thumbs', '', 0, 0, 1, 7),
(204, 'disable_thumb2x_download', '1', 'access_permissions', '0|1', 0, 'Disable the download of HiDPI squared thumbs', '', 0, 0, 1, 8),
(205, 'disable_small_download', '0', 'access_permissions', '0|1', 0, 'Disable the download of thumbs', '', 1, 0, 1, 9),
(206, 'disable_small2x_download', '0', 'access_permissions', '0|1', 0, 'Disable the download of HiDPI thumbs', '', 1, 0, 1, 10),
(207, 'disable_medium_download', '0', 'access_permissions', '0|1', 0, 'Disable the download of Medium', '', 1, 0, 1, 11),
(208, 'disable_medium2x_download', '0', 'access_permissions', '0|1', 0, 'Disable the download of HiDPI Medium', '', 1, 0, 1, 12),
(209, 'temporary_image_link_enabled', '0', 'Mod Privacy', '0|1', 0, 'Enable temporary image links', 'All images will be served with a signed URL. This is a security feature to prevent hotlinking and unauthorized access to images.', 0, 0, 0, 1),
(210, 'temporary_image_link_when_logged_in', '0', 'Mod Privacy', '0|1', 0, 'Enable temporary image links for logged in users', '', 0, 0, 0, 2),
(211, 'temporary_image_link_when_admin', '0', 'Mod Privacy', '0|1', 0, 'Enable temporary image links for admins', '', 0, 0, 0, 3),
(212, 'temporary_image_link_life_in_seconds', '86400', 'Mod Privacy', 'positive', 0, 'Maximum life time for temporary links in seconds (default is 86400s = 24 hours)', '<i class="pi pi-exclamation-triangle text-orange-500"></i> If you are using request caching, set this value to a higher value than the cache expiration time.', 0, 0, 1, 4),
(213, 'secure_image_link_enabled', '0', 'Mod Privacy', '0|1', 0, 'Encrypt image links to protect them ', 'This ensures that the image links are not guessable.', 1, 0, 1, 5),
(214, 'landing_background_landscape', 'dist/cat.webp', 'Mod Welcome', 'string', 1, 'URL of background image for landscape orientation', 'This image is also used when sharing the gallery link directly.', 0, 0, 0, 3),
(215, 'landing_background_portrait', 'dist/cat.webp', 'Mod Welcome', 'string', 1, 'URL of background image for portrait orientation', '', 0, 0, 0, 4),
(216, 'metrics_enabled', '0', 'Mod Pro', '0|1', 1, 'Enable statistics on photos & albums', 'If enabled, anonymours users will be measured.', 1, 0, 0, 2),
(217, 'metrics_logged_in_users_enabed', '0', 'Mod Pro', '0|1', 1, 'Enable statistics for logged-in users', 'If enabled, logged-in users will be measured as well (admin users are not measured).', 1, 0, 0, 3),
(218, 'metrics_access', 'admin', 'Mod Pro', 'admin|owner|logged-in users|public', 1, 'Access level for statistics of the album/photo', '', 1, 0, 1, 4),
(219, 'live_metrics_enabled', '0', 'Mod Pro', '0|1', 1, 'Enable live statistics', 'Live metrics provides you an activity history of your gallery.', 1, 0, 0, 5),
(220, 'live_metrics_access', 'admin', 'Mod Pro', 'admin|logged-in users', 1, 'Access level for live metrics', 'If set to "admin", only admins can see the live metrics.', 1, 0, 0, 6),
(221, 'live_metrics_max_time', '30', 'Mod Pro', 'positive', 1, 'Max age for live metrics in days', 'After this time, the live metrics will be deleted.', 1, 0, 0, 7),
(222, 'photo_thumb_info', 'title', 'Gallery', 'title|description', 1, 'Select the info shown in photo thumbnail', 'If description is selected, the date will not be shown either.', 0, 0, 1, 35),
(223, 'photo_previous_next_size', 'small', 'Gallery', 'small|large', 1, 'Select the size of the previous/next buttons in photo view.', 'Those buttons are hidden by default and only visible when the mouse get close to the left/right side of the screen.', 0, 0, 1, 36),
(224, 'SA_override_visibility', '0', 'Smart Albums', '0|1', 0, 'Smart album visibility overrides the photo visibility.', '<span class="pi pi-exclamation-triangle text-orange-500"></span> This will make any photos matching the smart album condition visible.', 0, 0, 1, 10),
(225, 'TA_override_visibility', '0', 'Smart Albums', '0|1', 0, 'Tag album visibility overrides the photo visibility.', '<span class="pi pi-exclamation-triangle text-orange-500"></span> This will make any photos matching the tag album condition visible.', 0, 0, 1, 11),
(226, 'slideshow_enabled', '1', 'Gallery', '0|1', 1, 'Enable the slideshow functionality.', '', 0, 0, 1, 37),
(227, 'user_registration_enabled', '0', 'Users Management', '0|1', 1, 'Enable user registration.', 'If disabled, new users cannot register themselves.', 0, 0, 0, 1),
(228, 'enable_colour_extractions', '0', 'Image Processing', '0|1', 0, 'Extract the 5 most used colours from the image.', '', 1, 0, 0, 15),
(229, 'colour_extraction_driver', 'farzai', 'Image Processing', 'league|farzai', 0, 'Driver for colour extraction.', 'Slower: league does a full sampling and use ciede2000DeltaE for colour distance calculation.<br>Faster: farzai uses spot sampling and k-mean distance.', 1, 0, 1, 16),
(230, 'user_invitation_ttl', '7', 'Users Management', 'positive', 1, 'Maximum life time for invitation links in days.', '<span class="pi pi-exclamation-triangle text-orange-500"></span> Invitation links cannot be revoked.', 0, 0, 1, 3),
(231, 'home_page_default', 'gallery', 'config', 'gallery|flow', 0, 'Default home page after landing', '', 0, 0, 0, 4),
(232, 'flow_enabled', '1', 'Mod Flow', '0|1', 0, 'Enable Flow display', '', 0, 0, 0, 1),
(233, 'flow_public', '0', 'Mod Flow', '0|1', 0, 'Allows anonymous user to access the Flow', '', 0, 0, 0, 2),
(234, 'flow_base', '', 'Mod Flow', 'string', 0, 'Base album id for the flow', 'All albums within this album will be included in the flow (leave empty for root).', 0, 0, 1, 3),
(235, 'flow_min_max_order', 'older_younger', 'Mod Flow', 'older_younger|younger_older', 1, 'Set which min-max date to display first.', 'If set to "older_younger", the older date will be displayed first, otherwise the younger date will be displayed first.', 0, 0, 1, 4),
(236, 'flow_max_items', '10', 'Mod Flow', 'positive', 0, 'Maximum number of items in the flow', 'A lower number will require more requests, a higher number will consume more memory.', 0, 0, 1, 5),
(237, 'flow_strategy', 'auto', 'Mod Flow', 'auto|opt-in', 0, 'Flow strategy', 'Choose how the flow is generated. "auto" will include all albums, "opt-in" will only include albums that have the flow enabled.', 1, 0, 0, 6),
(238, 'flow_include_sub_albums', '0', 'Mod Flow', '0|1', 0, 'Include sub-albums in the flow', 'All the descendants of the base album will be included in the flow. If disabled, only the direct children of the base album will be included.', 1, 0, 0, 7),
(239, 'flow_include_photos_from_children', '0', 'Mod Flow', '0|1', 0, 'Include photos from children albums', 'If an album has no photos, but has children, the photos from the children will be displayed.<br>\n				<span class="pi pi-exclamation-triangle text-orange-500"></span> This is NOT recommended. Consequences includes memory exhaution, slower loading time, crashes...', 1, 0, 1, 8),
(240, 'flow_open_album_on_click', '0', 'Mod Flow', '0|1', 0, 'Open album on click', 'Go to the album when clicked. If disabled, the photos will be displayed directly.', 1, 0, 0, 9),
(241, 'flow_display_open_album_button', '0', 'Mod Flow', '0|1', 0, 'Display open album button', 'A button to open the album will be displayed in the card.', 1, 0, 0, 10),
(242, 'flow_highlight_first_picture', '1', 'Mod Flow', '0|1', 0, 'Highlight first picture in the album instead of the album cover', 'The main picture displayed is the first picture in the album.', 1, 0, 1, 11),
(243, 'flow_min_max_enabled', '1', 'Mod Flow', '0|1', 0, 'Enable min-max date in the flow', 'Display the min-max date from the photos of the album in the flow.', 1, 0, 0, 12),
(244, 'flow_display_statistics', '1', 'Mod Flow', '0|1', 0, 'Display album statistics in the flow', 'The number of views, shares, and downloads of the album will be displayed.', 1, 0, 0, 13),
(245, 'flow_compact_mode_enabled', '1', 'Mod Flow', '0|1', 0, 'Enable flow compact mode', 'Clamp the description to 3 lines and hides exttra information like the number of photos and children.<br>Also adds a "Show more" button to expand.', 1, 0, 0, 14),
(246, 'flow_image_header_enabled', '1', 'Mod Flow', '0|1', 0, 'Enable image header in the flow', 'The top of the card will highlight the cover of the album.', 1, 0, 0, 15),
(247, 'flow_image_header_cover', 'cover', 'Mod Flow', 'cover|fit', 0, 'Image header display', 'The image header can be displayed as a cover or fit. Cover will crop the image to fit the header, while fit will scale the image to fit the header.', 1, 0, 0, 16),
(248, 'flow_image_header_height', '24', 'Mod Flow', 'positive', 0, 'Image header height', 'Heights of the image header in rem.', 1, 0, 1, 17),
(249, 'flow_carousel_enabled', '1', 'Mod Flow', '0|1', 0, 'Enable image carousel in the flow', 'Display a preview of the images in a carousel under the image header. This only applied if the image header is enabled.', 1, 0, 0, 18),
(250, 'flow_carousel_height', '6', 'Mod Flow', 'positive', 0, 'Carousel height', 'Heights of the image carousel in rem.', 1, 0, 1, 19),
(251, 'date_format_flow_published', 'M j, Y, g:i:s A e', 'Mod Flow', 'string_required', 0, 'Format the date displayed in the flow', 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>', 1, 0, 1, 20),
(252, 'date_format_flow_min_max', 'F Y', 'Mod Flow', 'string_required', 0, 'Format the min-max date.', 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>', 1, 0, 1, 21),
(253, 'flow_blur_nsfw_enabled', '1', 'Mod NSFW', '0|1', 0, 'Blur sensitive albums in Flow', 'Photos form albums marked as sensitive will be blurred in the flow. Users can unblur them by clicking on the album.', 0, 0, 0, 32766),
(254, 'hide_nsfw_in_flow', '1', 'Mod NSFW', '0|1', 0, 'Do not show sensitive albums in Flow', 'Albums marked as sensitive will not be shown in the flow.', 0, 0, 0, 32767),
(255, 'skip_duplicates_early', '1', 'Image Processing', '0|1', 0, 'Skip duplicate early if found on import via the sync command.', 'Use the photo title to check for duplicate in the target album.', 0, 0, 0, 23),
(256, 'sync_delete_missing_photos', '0', 'Image Processing', '0|1', 0, 'Photos in Lychee not present in the synced directory will be deleted from their target album.', 'This option is only enabled if dry_run is disabled.', 0, 0, 1, 24),
(257, 'sync_delete_missing_albums', '0', 'Image Processing', '0|1', 0, 'Albums in Lychee not present in the synced directory will be deleted from the tree.', 'This option is only enabled if dry_run is disabled.', 0, 0, 1, 25),
(258, 'sync_dry_run', '1', 'Image Processing', '0|1', 0, 'Run the destructive part of the sync command in dry-run mode.', '<span class="pi pi-exclamation-triangle text-orange-500"></span> If disabled this will allow the sync command to delete albums/photos from your Lychee instance.', 0, 0, 1, 26),
(259, 'gallery_header_enabled', '0', 'Mod Welcome', '0|1', 0, 'Enable header image in the gallery view', '', 0, 0, 0, 5),
(260, 'gallery_header_logged_in_enabled', '0', 'Mod Welcome', '0|1', 0, 'Enable header image in the gallery view when logged in', '', 0, 0, 0, 6),
(261, 'gallery_header', '', 'Mod Welcome', 'string', 0, 'URL of header image in the gallery view', '', 0, 0, 0, 7),
(262, 'gallery_header_bar_transparent', '1', 'Mod Welcome', '0|1', 0, 'Make the header bar transparent.', 'If enabled, the header bar will be transparent and the header image will be visible behind it.', 0, 0, 1, 8),
(263, 'gallery_header_bar_gradient', '1', 'Mod Welcome', '0|1', 0, 'Add a gradient background to the header bar.', 'If enabled the header bar will have a gradient background aiming to improve the readability of the text, otherwise it will be transparent.', 0, 0, 1, 9),
(264, 'import_via_url_forbidden_localhost', '1', 'Admin', '0|1', 0, 'Import via URL must not use localhost', '<span class="pi pi-exclamation-triangle text-orange-500"></span> Disabling this expose your localhost to the Import via URL functionality and lead to Server-Side Request Forgery (SSRF).', 0, 0, 1, 20),
(265, 'import_via_url_forbidden_local_ip', '1', 'Admin', '0|1', 0, 'Import via URL must not use local IPs', '<span class="pi pi-exclamation-triangle text-orange-500"></span> Disabling this expose your internal network to the Import via URL functionality and lead to Server-Side Request Forgery (SSRF).', 0, 0, 1, 21),
(266, 'import_via_url_require_https', '1', 'Admin', '0|1', 0, 'Import via URL must use https', '<span class="pi pi-exclamation-triangle text-orange-500"></span> Disabling this will lower the security of the Import via URL functionality.', 0, 0, 1, 22),
(267, 'import_via_url_forbidden_ports', '1', 'Admin', '0|1', 0, 'Import via URL must use port 80 or 443', '<span class="pi pi-exclamation-triangle text-orange-500"></span> Disabling this will allow the Import via URL to use any ports which may lead to Server-Side Request Forgery (SSRF).', 0, 0, 1, 23),
(268, 'owner_id', '1', 'Admin', 'admin_user', 1, 'Owner of the installation', '<span class="pi pi-exclamation-triangle text-orange-500"></span> Changing this value will allow another admin to take over the server.', 0, 0, 1, 11),
(269, 'details_links_enabled', '0', 'Gallery', '0|1', 0, 'Enable image links in photo details', 'Add a small module to allow easy copying of the photo urls in the details panel.', 0, 0, 0, 20),
(270, 'details_links_public', '0', 'Gallery', '0|1', 0, 'Allow anonymous users to acces image links in photo details', '', 0, 0, 0, 21),
(271, 'is_scroll_to_navigate_photos_enabled', '1', 'gestures', '0|1', 0, 'Enable scrolling with mouse wheel to navigate between photos', '', 0, 0, 0, 1),
(272, 'is_swipe_vertically_to_go_back_enabled', '1', 'gestures', '0|1', 0, 'Enable vertical swipe gesture on photos to return to album', '', 0, 0, 0, 2),
(273, 'photo_thumb_tags_enabled', '0', 'Gallery', '0|1', 0, 'Display the tags on the photo thumbnail in the album view', 'If description is enabled on the photo thumbnail, the tags will not be displayed.', 1, 0, 1, 35),
(274, 'hide_nsfw_in_tag_albums', '1', 'Mod NSFW', '0|1', 0, 'Do not show sensitive photos in Tag Albums', 'Pictures placed in sensive albums will not be shown in Tag Albums.', 0, 0, 0, 32767),
(275, 'hide_nsfw_in_tag_listing', '1', 'Mod NSFW', '0|1', 0, 'Do not show sensitive photos in tag listings', 'Pictures placed in sensive albums will not be shown on the phto listing of a given tag.', 0, 0, 0, 32767),
(276, 'sorting_pinned_albums_col', 'created_at', 'Smart Albums', 'created_at|title|description|max_taken_at|min_taken_at', 0, 'Default column used for sorting featured albums', '', 0, 0, 0, 20),
(277, 'sorting_pinned_albums_order', 'DESC', 'Smart Albums', 'ASC|DESC', 0, 'Default order used for sorting featured albums', '', 0, 0, 0, 21),
(278, 'copyright_text', '', 'Footer', 'string', 0, 'Copyright text (replaces default copyright notice)', '', 0, 0, 0, 5);

-- --------------------------------------------------------

--
-- Table structure for table `config_categories`
--

CREATE TABLE `config_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cat` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` tinyint(3) unsigned NOT NULL DEFAULT '255',
  PRIMARY KEY (`id`),
  UNIQUE KEY `config_categories_name_unique` (`name`),
  KEY `config_categories_cat_index` (`cat`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=24 ;

--
-- Dumping data for table `config_categories`
--

INSERT INTO `config_categories` VALUES
(1, 'config', 'Basics', '', 0),
(2, 'lychee SE', 'Lychee SE', 'Unlock the full capabilities of Lychee with the <a href="https://lycheeorg.dev/get-supporter-edition/" class="text-primary-500 font-bold underline">Supporter Edition</a>.\nGet exclusive features and support the development of Lychee. Sponsor LycheeOrg on GitHub and get your License key <a href="https://github.com/sponsors/LycheeOrg" class="text-primary-500 font-bold underline">here</a>.', 1),
(3, 'Gallery', 'Gallery', '', 2),
(4, 'Mod Welcome', 'Landing page', 'This module enables a landing page. Instead of arriving directly to the gallery view, it adds a bit of grandiose to the website entrance. Provide the url of the picture to be displayed and set the title.', 3),
(5, 'Footer', 'Footer', '', 4),
(6, 'Smart Albums', 'Smart & Featured Albums', '', 5),
(7, 'Image Processing', 'Image Processing', '', 6),
(8, 'Mod Search', 'Search', '', 10),
(9, 'Mod Timeline', 'Timeline', '', 11),
(10, 'Mod Frame', 'Frame', '', 12),
(11, 'Mod Map', 'Map/GPS', '', 13),
(12, 'Mod RSS', 'RSS', '', 14),
(13, 'Mod NSFW', 'Sensitive', '', 15),
(14, 'Mod Back Button', 'Back Home', '', 16),
(15, 'Mod Cache', 'Cache', '', 17),
(16, 'Mod Pro', 'Pro', '', 18),
(18, 'Mod Privacy', 'Privacy Options', '', 20),
(19, 'Users Management', 'Users Management', '', 100),
(20, 'Admin', 'Admin', '', 200),
(21, 'access_permissions', 'Permissions', '', 7),
(22, 'Mod Flow', 'Flow', 'This module enables the displays of albums in a feed-like manner. Only albums with photos will be displayed, albums with only children are not included in the Flow. Being a pure display, the Flow page does not allow users to upload, move, <i>etc.</i>', 21),
(23, 'gestures', 'Gestures', 'Configure gesture controls for photo navigation.', 50);

-- --------------------------------------------------------

--
-- Table structure for table `failed_jobs`
--

CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jobs`
--

CREATE TABLE `jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint(3) unsigned NOT NULL,
  `reserved_at` int(10) unsigned DEFAULT NULL,
  `available_at` int(10) unsigned NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jobs_history`
--

CREATE TABLE `jobs_history` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `owner_id` int(10) unsigned NOT NULL,
  `job` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_history_owner_id_status_index` (`owner_id`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `live_metrics`
--

CREATE TABLE `live_metrics` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `visitor_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `album_id` char(24) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `photo_id` char(24) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `live_metrics_visitor_id_index` (`visitor_id`),
  KEY `live_metrics_action_index` (`action`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `logs`
--

CREATE TABLE `logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) NOT NULL,
  `updated_at` datetime(6) NOT NULL,
  `type` varchar(11) COLLATE utf8mb4_unicode_ci NOT NULL,
  `function` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `line` int(11) NOT NULL,
  `text` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `migrations`
--

CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=342 ;

--
-- Dumping data for table `migrations`
--

INSERT INTO `migrations` VALUES
(1, '2014_10_12_000000_create_users_table', 1),
(2, '2018_08_03_110935_create_albums_table', 1),
(3, '2018_08_03_110936_create_photos_table', 1),
(4, '2018_08_03_110942_create_configs_table', 1),
(5, '2018_08_03_111324_create_logs_table', 1),
(6, '2018_08_10_134924_move_settings', 1),
(7, '2018_08_15_102039_move_albums', 1),
(8, '2018_08_15_103716_move_photos', 1),
(9, '2018_10_30_135411_sharing', 1),
(10, '2019_02_21_114356_create_pages_table', 1),
(11, '2019_02_21_114408_create_page_contents_table', 1),
(12, '2019_06_21_180451_create_sym_links_table', 1),
(13, '2019_09_28_171753_config_fix', 1),
(14, '2019_09_28_190822_photos_fix', 1),
(15, '2019_10_01_add_livephoto_cols', 1),
(16, '2019_10_02_1400_config_map_display_public', 1),
(17, '2019_10_03_214750_frame_refresh_in_sec', 1),
(18, '2019_10_06_1400_config_map_providers', 1),
(19, '2019_10_06_152017_add_force_32bit_ids', 1),
(20, '2019_10_07_0900_config_map_include_sub_albums', 1),
(21, '2019_10_09_233402_config_map_mod', 1),
(22, '2019_10_11_093442_config_check_update_every', 1),
(23, '2019_12_02_2100_config_exiftool', 1),
(24, '2019_12_15_0700_add_share_button_visible_option', 1),
(25, '2019_12_15_1000_config_check_update_every_cat_fix', 1),
(26, '2019_12_25_0600_config_exiftool_ternary', 1),
(27, '2020_01_018_2300_config_import_via_symlink', 1),
(28, '2020_01_04_1200_config_has_ffmpeg', 1),
(29, '2020_01_26_1200_config_public_sorting', 1),
(30, '2020_01_28_133201_composer_update', 1),
(31, '2020_02_14_0600_location_decoding', 1),
(32, '2020_03_11_124417_increase_length_photo_type', 1),
(33, '2020_03_17_200000_unhide_configs', 1),
(34, '2020_04_19_122905_bump_version', 1),
(35, '2020_04_22_155712_bump_version040002', 1),
(36, '2020_04_29_000250_bump_version040003', 1),
(37, '2020_05_12_114228_rss', 1),
(38, '2020_05_12_161427_bump_version040005', 1),
(39, '2020_05_19_174233_config_prefer_available_xmp_metadata', 1),
(40, '2020_05_26_135052_bump_version040006', 1),
(41, '2020_06_04_104605_config_editor_enabled', 1),
(42, '2020_07_11_104605_config_lossless_optimization', 1),
(43, '2020_07_11_184605_update_licences', 1),
(44, '2020_07_26_085322_config_swipe_tolerance', 1),
(45, '2020_07_29_132731_config_local_takestamp', 1),
(46, '2020_08_21_123622_add_smart_tag_album_cols', 1),
(47, '2020_10_09_130043_bump_version040007', 1),
(48, '2020_10_15_104504_add_log_max_num_line', 1),
(49, '2020_10_15_161346_sort_image_per_album', 1),
(50, '2020_11_12_183345_config_password_url_param_for_smart_album', 1),
(51, '2020_11_19_231553_bump_version040008', 1),
(52, '2020_12_12_203153_migrate_admin_user', 1),
(53, '2020_12_12_203831_create_web_authn_tables', 1),
(54, '2020_12_18_162100_bump_version040009', 1),
(55, '2020_12_18_162155_add_nsfw_album', 1),
(56, '2020_12_18_163800_bump_version040010', 1),
(57, '2020_12_24_022307_bump_version040100', 1),
(58, '2020_12_26_153220_nested_set_for_albums', 1),
(59, '2021_01_09_163715_remove_max_min_takestamps', 1),
(60, '2021_01_12_122546_bump_version040200', 1),
(61, '2021_01_18_103729_add_album_cover', 1),
(62, '2021_01_20_113912_bump_version040201', 1),
(63, '2021_01_24_231904_fix-rotation', 1),
(64, '2021_01_27_085903_config_map_display_direction', 1),
(65, '2021_01_30_111736_display_takedate', 1),
(66, '2021_02_12_222948_config_upload_processing_limit', 1),
(67, '2021_02_13_132245_bump_version040202', 1),
(68, '2021_02_18_232639_config_public_photos_hidden', 1),
(69, '2021_03_03_175555_config_remove_image_overlay', 1),
(70, '2021_04_17_135924_bump_version040300', 1),
(71, '2021_05_02_174300_add_filesize_raw_col', 1),
(72, '2021_05_12_185726_bump_version040301', 1),
(73, '2021_05_13_140700_refactor_size_variants', 1),
(74, '2021_05_16_171615_bump_version040302', 1),
(75, '2021_05_25_160600_post_revert_fixes', 1),
(76, '2021_05_31_201000_convert_filesize_to_bigint', 1),
(77, '2021_06_01_181900_refactor_timestamps_anew', 1),
(78, '2021_06_01_182000_bump_version040304', 1),
(79, '2021_06_06_151613_fix-takedate', 1),
(80, '2021_06_23_105939_create_notifications_table', 1),
(81, '2021_06_30_121651_add_email_to_users_table', 1),
(82, '2021_06_30_122229_config_new_photos_notification', 1),
(83, '2021_07_19_134617_bump_version040305', 1),
(84, '2021_10_27_133121_fix_confidentiality', 1),
(85, '2021_11_16_162058_bump_version040306', 1),
(86, '2021_12_03_201242_bump_version040400', 1),
(87, '2021_12_04_181200_refactor_models', 1),
(88, '2022_01_13_183131_bump_version040500', 1),
(89, '2022_01_16_181337_optimize_tables', 1),
(90, '2022_02_02_203008_filesize_size_variants', 1),
(91, '2022_02_22_194700_fix_sorting_config', 1),
(92, '2022_04_06_091900_drop_objectionable_indices', 1),
(93, '2022_04_13_094611_add_track_short_path_to_album_table', 1),
(94, '2022_04_16_170724_add_missing_indices', 1),
(95, '2022_04_16_174503_bump_version040501', 1),
(96, '2022_04_18_150400_add_index_for_delete', 1),
(97, '2022_04_18_174417_fix_live_photo_short_path', 1),
(98, '2022_06_12_075709_add_token_to_user_table', 1),
(99, '2022_07_09_130303_create_webauthn_credentials', 1),
(100, '2022_07_13_174800_permission_test', 1),
(101, '2022_07_24_102214_bump_version040502', 1),
(102, '2022_08_03_184746_add_zip_options', 1),
(103, '2022_08_06_205701_bump_version040503', 1),
(104, '2022_08_06_210757_bump_version040600', 1),
(105, '2022_08_27_103010_drop_page_support', 1),
(106, '2022_08_27_110209_drop_admin_user_config', 1),
(107, '2022_09_27_103710_bump_version040601', 1),
(108, '2022_10_23_143201_make_wui_settings_public', 1),
(109, '2022_10_28_232159_bump_version040602', 1),
(110, '2022_11_07_171403_add_config_descriptions', 1),
(111, '2022_11_27_143608_bump_version040603', 1),
(112, '2022_12_05_195600_enable_disable_smart_albums', 1),
(113, '2022_12_07_141854_rename_capabilities', 1),
(114, '2022_12_07_143755_add_default_protection_option', 1),
(115, '2022_12_07_164417_config_uniformize_rights', 1),
(116, '2022_12_07_175257_rename_attributes_grants', 1),
(117, '2022_12_10_183251_increment_user_i_ds', 1),
(118, '2022_12_12_100000_enable_disable_album_photo_counters', 1),
(119, '2022_12_21_212143_use_webp_for_example', 1),
(120, '2022_12_25_103052_bump_version040604', 1),
(121, '2022_12_26_101639_allow_username_change', 1),
(122, '2022_12_26_111139_bump_version040605', 1),
(123, '2022_12_28_164844_remove-demo', 1),
(124, '2022_12_31_103416_bump_version040700', 1),
(125, '2023_01_09_133603_public_on_this_day', 1),
(126, '2023_01_25_140614_change-locale', 1),
(127, '2023_02_05_155552_bump_version040701', 1),
(128, '2023_02_23_192505_add_auto_fix_orientation_setting', 1),
(129, '2023_03_08_103109_bump_version040702', 1),
(130, '2023_04_05_150337_create_jobs_table', 1),
(131, '2023_04_05_150625_queue-processing', 1),
(132, '2023_04_05_220214_create_failed_jobs_table', 1),
(133, '2023_04_09_142907_create_job_history_table', 1),
(134, '2023_04_18_065457_bump_version040703', 1),
(135, '2023_05_01_165730_add_random_photo_settings', 1),
(136, '2023_05_04_070132_bump_version040704', 1),
(137, '2023_05_04_193000_add_use_last_modified_date_when_no_exit_date_setting', 1),
(138, '2023_05_05_052254_create_access_permissions', 1),
(139, '2023_05_05_052255_simplify_user_base_album', 1),
(140, '2023_05_05_052256_simplify_base_album', 1),
(141, '2023_05_05_052257_create_access_permissions_for_smart_albums', 1),
(142, '2023_05_05_123230_bump_version040800', 1),
(143, '2023_05_15_081406_bump_version040801', 1),
(144, '2023_05_15_211448_remove_is_public_album_sorting', 1),
(145, '2023_05_18_103903_bump_version040900', 1),
(146, '2023_05_19_131139_bump_version040901', 1),
(147, '2023_05_21_225616_bump_version040902', 1),
(148, '2023_06_20_174639_bump_version040903', 1),
(149, '2023_06_24_161541_add_indexes', 1),
(150, '2023_06_28_144440_bump_version040904', 1),
(151, '2023_07_07_143908_add_ratio_size_variants', 1),
(152, '2023_07_16_110146_bump_version041000', 1),
(153, '2023_08_07_182802_add_config_ffmpeg_path', 1),
(154, '2023_08_11_134652_bump_version041100', 1),
(155, '2023_09_03_124836_bump_version041101', 1),
(156, '2023_09_16_070405_refactor_type_layout', 1),
(157, '2023_09_16_074731_bump_version041200', 1),
(158, '2023_09_16_234050_require_single_key_in_config', 1),
(159, '2023_09_23_204910_bump_version041300', 1),
(160, '2023_09_24_110932_add_date_display_configurations', 1),
(161, '2023_09_24_223901_add_config_livewire_chunk_size', 1),
(162, '2023_09_24_233717_refactor_type_layout_livewire', 1),
(163, '2023_09_25_123925_config_blur_nsfw', 1),
(164, '2023_10_01_143159_config_map_provider', 1),
(165, '2023_12_18_191723_config_public_search', 1),
(166, '2023_12_18_232500_config_pagination_search_limit', 1),
(167, '2023_12_19_115547_search_characters_limit', 1),
(168, '2023_12_19_122408_add_positive_requirements', 1),
(169, '2023_12_20_180854_add_setting_height_width_gallery', 1),
(170, '2023_12_23_160356_bump_version050000', 1),
(171, '2023_12_25_115454_add_setting_display_thumb_overlay', 1),
(172, '2023_12_27_163004_bump_version050001', 1),
(173, '2023_12_28_144906_bump_version050002', 1),
(174, '2023_12_28_165358_add_subalbum_sorting_per_album', 1),
(175, '2023_12_30_220515_add_thumbs_albums_aspect_ratio', 1),
(176, '2023_12_30_221215_add_thumbs_albums_aspect_ratio_per_album', 1),
(177, '2024_01_03_154055_add_album_no_header_setting', 1),
(178, '2024_01_08_155917_bump_version050003', 1),
(179, '2024_01_08_163328_left_right_login_and_back', 1),
(180, '2024_01_13_124937_create_oauth_credentials_table', 1),
(181, '2024_01_17_101240_bump_version050100', 1),
(182, '2024_01_22_121406_bump_version050101', 1),
(183, '2024_01_23_190637_bump_version050102', 1),
(184, '2024_01_23_192800_remove_is_public_photo_sorting', 1),
(185, '2024_01_23_192814_remove_keys_and_column', 1),
(186, '2024_01_23_232103_remove_album_id_from_jobhistory', 1),
(187, '2024_01_24_063519_job_feedback_options', 1),
(188, '2024_02_28_004535_add_header_id_col', 1),
(189, '2024_04_06_165355_bump_version050200', 1),
(190, '2024_04_09_121410_decrease_noise_diagnostics', 1),
(191, '2024_04_14_103639_bump_version050201', 1),
(192, '2024_04_19_141432_fix_license', 1),
(193, '2024_04_20_132955_bump_version050202', 1),
(194, '2024_04_26_201931_add_storate_disk_to_size_variants', 1),
(195, '2024_04_28_135546_fix_license_again', 1),
(196, '2024_04_28_172241_add_album_copyright', 1),
(197, '2024_04_28_191004_bump_version050300', 1),
(198, '2024_05_13_175529_config_random_thumb_smart_album', 1),
(199, '2024_06_08_093403_primary_key_job_history', 1),
(200, '2024_06_08_103842_add_config_display_processing_queue', 1),
(201, '2024_06_08_183427_bump_version050301', 1),
(202, '2024_06_10_103843_add_login_required_option', 1),
(203, '2024_06_11_204410_bump_version050400', 1),
(204, '2024_06_17_171051_disable_per_smart_album_config', 1),
(205, '2024_06_17_172448_remove_global_disable_smart_albums', 1),
(206, '2024_06_21_154247_create_user_if_not_exists_on_oauth', 1),
(207, '2024_06_23_201042_enforce_login_on_gallery_only', 1),
(208, '2024_06_25_153527_bump_version050500', 1),
(209, '2024_07_01_231053_path_for_exiftool', 1),
(210, '2024_07_03_170506_bump_version050501', 1),
(211, '2024_07_06_214241_thumb_min_max_take_date_order', 1),
(212, '2024_07_12_183751_add_auto_play_config', 1),
(213, '2024_07_26_120007_simplify_config', 1),
(214, '2024_07_29_172018_fix_settings', 1),
(215, '2024_08_09_205532_white_theme', 1),
(216, '2024_08_15_163203_config_low_quality_image_placeholder', 1),
(217, '2024_08_31_090626_config_help_popup', 1),
(218, '2024_08_31_090740_fix_description_always_hover_hidden_photo', 1),
(219, '2024_09_14_143949_add_settings_level', 1),
(220, '2024_09_14_153948_fix_more_descriptions', 1),
(221, '2024_09_27_144741_add_supporter_fields', 1),
(222, '2024_10_05_125328_add_slideshow_timeout', 1),
(223, '2024_10_05_125833_lang_is_admin_setting', 1),
(224, '2024_10_05_184315_bump_version060000', 1),
(225, '2024_10_09_191528_image_processing_backup', 1),
(226, '2024_10_09_194010_image_processing_details_and_others', 1),
(227, '2024_10_10_101333_set_dropbox_disabled', 1),
(228, '2024_10_11_173054_add_space_quota_per_user', 1),
(229, '2024_10_11_173106_add_space_quota_configuration', 1),
(230, '2024_10_13_134419_oath_group_to_users', 1),
(231, '2024_10_14_104644_show_nsfw_in_smart_albums', 1),
(232, '2024_10_14_104823_refine_text_enable_unsorted_smart_album', 1),
(233, '2024_10_20_125449_move-socials-to-footer', 1),
(234, '2024_10_20_173904_add_photo_layout_per_album', 1),
(235, '2024_10_23_222857_change_header', 1),
(236, '2024_10_23_225332_warning_html_content', 1),
(237, '2024_10_29_184020_bump_version060001', 1),
(238, '2024_10_30_064336_timeline_options', 1),
(239, '2024_11_10_171126_timeline_in_albums', 1),
(240, '2024_11_11_141241_remove_config_hide_nsfw_in_smart_albums_and_search', 1),
(241, '2024_11_11_141334_add_hide_nsfw_smart_search_config', 1),
(242, '2024_11_25_211912_bump_version060100', 1),
(243, '2024_11_26_125145_improve_info_timeline', 1),
(244, '2024_11_26_131136_bump_version060101', 1),
(245, '2024_11_27_085119_bump_version060102', 1),
(246, '2024_12_03_221445_set_number_icons_mobile', 1),
(247, '2024_12_16_132422_bump_version060200', 1),
(248, '2024_12_28_190150_caching_config', 1),
(249, '2025_01_24_200235_add_initial_taken_at', 1),
(250, '2025_01_25_210255_update_access_permissions_with_groups', 1),
(251, '2025_02_02_220404_config_punch_card', 1),
(252, '2025_02_06_181434_bump_version060300', 1),
(253, '2025_02_15_090409_bump_version060301', 1),
(254, '2025_02_16_214804_bump_version060302', 1),
(255, '2025_02_17_073346_add_config_generation_bounds', 1),
(256, '2025_02_17_075553_add_disable_recursive_permission_check', 1),
(257, '2025_02_17_080713_more_privacy_options', 1),
(258, '2025_02_21_105541_bump_version060303', 1),
(259, '2025_02_27_172817_bump_version060304', 1),
(260, '2025_03_01_154728_search_pagination_limit_reduction', 1),
(261, '2025_03_16_100923_add-note-mod-frame', 1),
(262, '2025_03_19_122649_bump_version060305', 1),
(263, '2025_03_20_173343_create_config_categories_table', 1),
(264, '2025_03_20_194811_set_expert_option', 1),
(265, '2025_03_20_200832_expert_all_settings_options', 1),
(266, '2025_03_20_214811_move_configs', 1),
(267, '2025_03_23_105010_config_favourite', 1),
(268, '2025_03_23_154340_bump_version060400', 1),
(269, '2025_03_23_185517_bump_version060401', 1),
(270, '2025_03_31_151648_create_new_category', 1),
(271, '2025_03_31_160547_limit_download_options', 1),
(272, '2025_04_04_075837_bump_version060402', 1),
(273, '2025_04_05_121647_drop-symbolic-links', 1),
(274, '2025_04_05_153533_add_secure_link_options', 1),
(275, '2025_04_06_200147_portrait_landscape_landing_background', 1),
(276, '2025_04_06_200737_remove_landing_background', 1),
(277, '2025_04_07_211142_create_live_metrics_table', 1),
(278, '2025_04_07_211144_add_stats_columns', 1),
(279, '2025_04_07_211147_metrics_config', 1),
(280, '2025_04_20_143503_bump_version060500', 1),
(281, '2025_04_21_150310_bump_version060501', 1),
(282, '2025_04_21_185527_config_description_thumbs', 1),
(283, '2025_04_24_082940_bump_version060502', 1),
(284, '2025_04_27_153213_fix-stats-missing', 1),
(285, '2025_04_27_154319_bump_version060503', 1),
(286, '2025_04_30_211901_bump_version060600', 1),
(287, '2025_05_12_092724_bump_version060601', 1),
(288, '2025_05_15_090030_bump_version060602', 1),
(289, '2025_05_15_205936_bump_version060603', 1),
(290, '2025_05_17_075632_optional-bigger-left-right-icons', 1),
(291, '2025_05_25_100158_bump_version060604', 1),
(292, '2025_05_26_221704_bump_version060605', 1),
(293, '2025_05_27_081037_drop_legacy_id', 1),
(294, '2025_05_27_081505_drop_unjustified_from_config', 1),
(295, '2025_05_28_174009_add_visibility_override_smart_album', 1),
(296, '2025_05_28_194147_fix_livemetrics_album_id', 1),
(297, '2025_05_28_201707_create_photo_album_pivot', 1),
(298, '2025_05_29_174832_add_slideshow_enabled', 1),
(299, '2025_05_29_231404_user_registration_enabled', 1),
(300, '2025_05_29_231905_rename_oauth_user_create_settings', 1),
(301, '2025_05_30_205853_create_user_groups_table', 1),
(302, '2025_05_30_210236_create_users_user_groups', 1),
(303, '2025_06_03_201052_create_colours_table', 1),
(304, '2025_06_03_201058_create_palettes_table', 1),
(305, '2025_06_04_193132_optional_color_extraction', 1),
(306, '2025_06_07_142046_create_tags_table', 1),
(307, '2025_06_07_144157_photo_tags_to_table', 1),
(308, '2025_06_07_150253_remove_tag_column_from_photos', 1),
(309, '2025_06_10_220804_user_invitation_ttl', 1),
(310, '2025_06_11_122155_bump_version060606', 1),
(311, '2025_06_12_115312_remove_unused_config', 1),
(312, '2025_06_12_223205_bump_version060607', 1),
(313, '2025_06_13_102340_home_page', 1),
(314, '2025_06_13_162123_bump_version060608', 1),
(315, '2025_06_14_101958_config_details_column_type', 1),
(316, '2025_06_14_121958_add_flow_config', 1),
(317, '2025_06_16_234348_bump_version060609', 1),
(318, '2025_06_17_204426_bump_version060610', 1),
(319, '2025_06_21_213119_update_sync_duplicates', 1),
(320, '2025_06_23_054050_bump_version060611', 1),
(321, '2025_06_24_180548_gallery_header', 1),
(322, '2025_06_26_070132_bump_version060612', 1),
(323, '2025_06_26_102340_parse_url_options', 1),
(324, '2025_06_26_115949_bump_version060613', 1),
(325, '2025_06_27_085029_bump_version060614', 1),
(326, '2025_06_29_080951_create_owner', 1),
(327, '2025_07_01_105450_bump_version060700', 1),
(328, '2025_07_02_221616_remove_prod_check', 1),
(329, '2025_07_04_054244_links_config', 1),
(330, '2025_07_21_004233_add_gestures_settings', 1),
(331, '2025_07_24_200417_bump_version060701', 1),
(332, '2025_08_03_141744_add_option_display_tag_on_album_view', 1),
(333, '2025_08_06_115051_bump_version060702', 1),
(334, '2025_08_07_224208_add_config_sensitive_tags', 1),
(335, '2025_08_08_000000_add_is_pinned_to_base_albums_table', 1),
(336, '2025_08_08_100833_add_pinned_albums_config', 1),
(337, '2025_08_12_114738_add_copyright_text_setting', 1),
(338, '2025_08_14_135253_refactor_tag_album', 1),
(339, '2025_08_15_135705_bump_version060800', 1),
(340, '2025_08_17_214223_and_or_tag_album', 1),
(341, '2025_08_18_102609_bump_version060801', 1);

-- --------------------------------------------------------

--
-- Table structure for table `notifications`
--

CREATE TABLE `notifications` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_id` bigint(20) unsigned NOT NULL,
  `data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `oauth_credentials`
--

CREATE TABLE `oauth_credentials` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `provider` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `oauth_credentials_token_id_unique` (`token_id`),
  UNIQUE KEY `oauth_credentials_provider_user_id_unique` (`provider`,`user_id`),
  KEY `oauth_credentials_user_id_index` (`user_id`),
  KEY `oauth_credentials_token_id_index` (`token_id`),
  KEY `oauth_credentials_token_id_provider_index` (`token_id`,`provider`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `palettes`
--

CREATE TABLE `palettes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `photo_id` char(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `colour_1` mediumint(8) unsigned NOT NULL,
  `colour_2` mediumint(8) unsigned NOT NULL,
  `colour_3` mediumint(8) unsigned NOT NULL,
  `colour_4` mediumint(8) unsigned NOT NULL,
  `colour_5` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `palettes_id_index` (`id`),
  KEY `palettes_photo_id_index` (`photo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `photos`
--

CREATE TABLE `photos` (
  `id` char(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(6) NOT NULL,
  `updated_at` datetime(6) NOT NULL,
  `owner_id` int(10) unsigned NOT NULL DEFAULT '0',
  `old_album_id` char(24) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `license` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'none',
  `is_starred` tinyint(1) NOT NULL DEFAULT '0',
  `iso` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `make` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `model` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lens` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `aperture` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shutter` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `focal` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `latitude` decimal(10,8) DEFAULT NULL,
  `longitude` decimal(11,8) DEFAULT NULL,
  `altitude` decimal(10,4) DEFAULT NULL,
  `img_direction` decimal(10,4) DEFAULT NULL,
  `location` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `taken_at` datetime(6) DEFAULT NULL COMMENT 'relative to UTC',
  `taken_at_orig_tz` varchar(31) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'the timezone at which the photo has originally been taken',
  `initial_taken_at` datetime DEFAULT NULL COMMENT 'backup of the original taken_at value',
  `initial_taken_at_orig_tz` varchar(31) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'backup of the timezone at which the photo has originally been taken',
  `type` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL,
  `filesize` bigint(20) unsigned NOT NULL DEFAULT '0',
  `checksum` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `original_checksum` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `live_photo_short_path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `live_photo_content_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `live_photo_checksum` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `photos_owner_id_foreign` (`owner_id`),
  KEY `photos_checksum_index` (`checksum`),
  KEY `photos_original_checksum_index` (`original_checksum`),
  KEY `photos_live_photo_content_id_index` (`live_photo_content_id`),
  KEY `photos_live_photo_checksum_index` (`live_photo_checksum`),
  KEY `photos_album_id_taken_at_index` (`old_album_id`,`taken_at`),
  KEY `photos_album_id_created_at_index` (`old_album_id`,`created_at`),
  KEY `photos_album_id_is_starred_index` (`old_album_id`,`is_starred`),
  KEY `photos_album_id_type_index` (`old_album_id`,`type`),
  KEY `photos_album_id_is_starred_created_at_index` (`old_album_id`,`is_starred`,`created_at`),
  KEY `photos_album_id_is_starred_taken_at_index` (`old_album_id`,`is_starred`,`taken_at`),
  KEY `photos_album_id_is_starred_type_index` (`old_album_id`,`is_starred`,`type`),
  KEY `photos_album_id_is_starred_title_index` (`old_album_id`,`is_starred`,`title`),
  KEY `photos_album_id_is_starred_description(128)_index` (`old_album_id`,`is_starred`,`description`(128))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `photos_tags`
--

CREATE TABLE `photos_tags` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tag_id` bigint(20) unsigned NOT NULL,
  `photo_id` char(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `photos_tags_tag_id_photo_id_unique` (`tag_id`,`photo_id`),
  KEY `photos_tags_tag_id_index` (`tag_id`),
  KEY `photos_tags_photo_id_index` (`photo_id`),
  KEY `photos_tags_tag_id_photo_id_index` (`tag_id`,`photo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `photo_album`
--

CREATE TABLE `photo_album` (
  `album_id` char(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `photo_id` char(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`photo_id`,`album_id`),
  KEY `photo_album_album_id_photo_id_index` (`album_id`,`photo_id`),
  KEY `photo_album_album_id_index` (`album_id`),
  KEY `photo_album_photo_id_index` (`photo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `size_variants`
--

CREATE TABLE `size_variants` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `photo_id` char(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '0: original, ..., 6: thumb',
  `short_path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `width` int(11) NOT NULL,
  `height` int(11) NOT NULL,
  `ratio` double NOT NULL DEFAULT '1',
  `filesize` bigint(20) unsigned NOT NULL DEFAULT '0',
  `storage_disk` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'images',
  PRIMARY KEY (`id`),
  UNIQUE KEY `size_variants_photo_id_type_unique` (`photo_id`,`type`),
  KEY `size_variants_short_path_index` (`short_path`),
  KEY `size_variants_photo_id_type_ratio_index` (`photo_id`,`type`,`ratio`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `statistics`
--

CREATE TABLE `statistics` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `album_id` char(24) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `photo_id` char(24) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visit_count` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT 'Number of times this photo/album has been viewed',
  `download_count` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT 'Number of times this photo/album has been downloaded (excluding albums)',
  `favourite_count` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT 'Number of times this photo has been favourite',
  `shared_count` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT 'Number of times this photo/album has been shared',
  PRIMARY KEY (`id`),
  UNIQUE KEY `statistics_album_id_unique` (`album_id`),
  UNIQUE KEY `statistics_photo_id_unique` (`photo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tags`
--

CREATE TABLE `tags` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `tags_name_unique` (`name`),
  KEY `tags_name_index` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tag_albums`
--

CREATE TABLE `tag_albums` (
  `id` char(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_and` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tag_albums_tags`
--

CREATE TABLE `tag_albums_tags` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tag_id` bigint(20) unsigned NOT NULL,
  `album_id` char(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `tag_albums_tags_tag_id_album_id_unique` (`tag_id`,`album_id`),
  KEY `tag_albums_tags_tag_id_index` (`tag_id`),
  KEY `tag_albums_tags_album_id_index` (`album_id`),
  KEY `tag_albums_tags_tag_id_album_id_index` (`tag_id`,`album_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) NOT NULL,
  `updated_at` datetime(6) NOT NULL,
  `username` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `may_administrate` tinyint(1) NOT NULL DEFAULT '0',
  `token` char(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `may_upload` tinyint(1) NOT NULL DEFAULT '0',
  `may_edit_own_settings` tinyint(1) NOT NULL DEFAULT '0',
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quota_kb` bigint(20) DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `note` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_username_unique` (`username`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_token_unique` (`token`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=2 ;

--
-- Dumping data for table `users`
--

INSERT INTO `users` VALUES
(1, '[[regtime_]]', '[[regtime_]]', '[[admin_username]]', '[[admin_pass]]', NULL, 1, NULL, 1, 1, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `users_user_groups`
--

CREATE TABLE `users_user_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `user_group_id` int(10) unsigned NOT NULL,
  `role` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'member',
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_user_groups_user_id_user_group_id_unique` (`user_id`,`user_group_id`),
  KEY `users_user_groups_user_id_index` (`user_id`),
  KEY `users_user_groups_user_group_id_index` (`user_group_id`),
  KEY `users_user_groups_user_id_user_group_id_index` (`user_id`,`user_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_groups`
--

CREATE TABLE `user_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_groups_name_unique` (`name`),
  KEY `user_groups_id_index` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `webauthn_credentials`
--

CREATE TABLE `webauthn_credentials` (
  `id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `authenticatable_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `authenticatable_id` bigint(20) unsigned NOT NULL,
  `user_id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `counter` bigint(20) unsigned DEFAULT NULL,
  `rp_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `origin` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `transports` json DEFAULT NULL,
  `aaguid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `public_key` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `attestation_format` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'none',
  `certificates` json DEFAULT NULL,
  `disabled_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `webauthn_user_index` (`authenticatable_type`,`authenticatable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `access_permissions`
--
ALTER TABLE `access_permissions`
  ADD CONSTRAINT `access_permissions_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `albums`
--
ALTER TABLE `albums`
  ADD CONSTRAINT `albums_cover_id_foreign` FOREIGN KEY (`cover_id`) REFERENCES `photos` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `albums_id_foreign` FOREIGN KEY (`id`) REFERENCES `base_albums` (`id`),
  ADD CONSTRAINT `albums_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `albums` (`id`);

--
-- Constraints for table `base_albums`
--
ALTER TABLE `base_albums`
  ADD CONSTRAINT `base_albums_owner_id_foreign` FOREIGN KEY (`owner_id`) REFERENCES `users` (`id`);

--
-- Constraints for table `jobs_history`
--
ALTER TABLE `jobs_history`
  ADD CONSTRAINT `jobs_history_owner_id_foreign` FOREIGN KEY (`owner_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `oauth_credentials`
--
ALTER TABLE `oauth_credentials`
  ADD CONSTRAINT `oauth_credentials_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `photos`
--
ALTER TABLE `photos`
  ADD CONSTRAINT `photos_owner_id_foreign` FOREIGN KEY (`owner_id`) REFERENCES `users` (`id`);

--
-- Constraints for table `photos_tags`
--
ALTER TABLE `photos_tags`
  ADD CONSTRAINT `photos_tags_photo_id_foreign` FOREIGN KEY (`photo_id`) REFERENCES `photos` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `photos_tags_tag_id_foreign` FOREIGN KEY (`tag_id`) REFERENCES `tags` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `photo_album`
--
ALTER TABLE `photo_album`
  ADD CONSTRAINT `photo_album_album_id_foreign` FOREIGN KEY (`album_id`) REFERENCES `albums` (`id`),
  ADD CONSTRAINT `photo_album_photo_id_foreign` FOREIGN KEY (`photo_id`) REFERENCES `photos` (`id`);

--
-- Constraints for table `size_variants`
--
ALTER TABLE `size_variants`
  ADD CONSTRAINT `size_variants_photo_id_foreign` FOREIGN KEY (`photo_id`) REFERENCES `photos` (`id`);

--
-- Constraints for table `tag_albums`
--
ALTER TABLE `tag_albums`
  ADD CONSTRAINT `tag_albums_id_foreign` FOREIGN KEY (`id`) REFERENCES `base_albums` (`id`);

--
-- Constraints for table `tag_albums_tags`
--
ALTER TABLE `tag_albums_tags`
  ADD CONSTRAINT `tag_albums_tags_album_id_foreign` FOREIGN KEY (`album_id`) REFERENCES `tag_albums` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tag_albums_tags_tag_id_foreign` FOREIGN KEY (`tag_id`) REFERENCES `tags` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `users_user_groups`
--
ALTER TABLE `users_user_groups`
  ADD CONSTRAINT `users_user_groups_user_group_id_foreign` FOREIGN KEY (`user_group_id`) REFERENCES `user_groups` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `users_user_groups_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
