-- MySQL dump 10.13  Distrib 8.0.42, for Linux (x86_64)
--
-- Host: localhost    Database: mage248p2sd
-- ------------------------------------------------------
-- Server version	8.0.37

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `[[dbprefix]]admin_adobe_ims_webapi`
--

DROP TABLE IF EXISTS `[[dbprefix]]admin_adobe_ims_webapi`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]admin_adobe_ims_webapi` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `admin_user_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Admin User Id',
  `access_token_hash` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'Access Token Hash',
  `access_token` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci COMMENT 'Access Token',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated At',
  `last_check_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'Last check time',
  `access_token_expires_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'Access Token Expires At',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[DBPREFIX]]ADMIN_ADOBE_IMS_WEBAPI_ACCESS_TOKEN_HASH` (`access_token_hash`),
  KEY `[[DBPREFIX]]ADMIN_ADOBE_IMS_WEBAPI_ADMIN_USER_ID` (`admin_user_id`),
  CONSTRAINT `[[DBPREFIX]]ADM_ADOBE_IMS_WEBAPI_ADM_USR_ID_[[DBPREFIX]]ADM_USR_USR_ID` FOREIGN KEY (`admin_user_id`) REFERENCES `[[dbprefix]]admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Admin Adobe IMS Webapi';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]admin_adobe_ims_webapi`
--

LOCK TABLES `[[dbprefix]]admin_adobe_ims_webapi` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]admin_adobe_ims_webapi` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]admin_adobe_ims_webapi` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]admin_analytics_usage_version_log`
--

DROP TABLE IF EXISTS `[[dbprefix]]admin_analytics_usage_version_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]admin_analytics_usage_version_log` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Log ID',
  `last_viewed_in_version` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'Viewer last viewed on product version',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[DBPREFIX]]ADMIN_ANALYTICS_USAGE_VERSION_LOG_LAST_VIEWED_IN_VERSION` (`last_viewed_in_version`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Admin Notification Viewer Log Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]admin_analytics_usage_version_log`
--

LOCK TABLES `[[dbprefix]]admin_analytics_usage_version_log` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]admin_analytics_usage_version_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]admin_analytics_usage_version_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]admin_passwords`
--

DROP TABLE IF EXISTS `[[dbprefix]]admin_passwords`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]admin_passwords` (
  `password_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Password ID',
  `user_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'User ID',
  `password_hash` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'Password Hash',
  `expires` int unsigned NOT NULL DEFAULT '0' COMMENT 'Deprecated',
  `last_updated` int unsigned NOT NULL DEFAULT '0' COMMENT 'Last Updated',
  PRIMARY KEY (`password_id`),
  KEY `[[DBPREFIX]]ADMIN_PASSWORDS_USER_ID` (`user_id`),
  CONSTRAINT `[[DBPREFIX]]ADMIN_PASSWORDS_USER_ID_[[DBPREFIX]]ADMIN_USER_USER_ID` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COMMENT='Admin Passwords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]admin_passwords`
--

LOCK TABLES `[[dbprefix]]admin_passwords` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]admin_passwords` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]admin_passwords` VALUES (1,1,'[[admin_pass]]',0,[[timestamp]]);
/*!40000 ALTER TABLE `[[dbprefix]]admin_passwords` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]admin_system_messages`
--

DROP TABLE IF EXISTS `[[dbprefix]]admin_system_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]admin_system_messages` (
  `identity` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'Message ID',
  `severity` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Problem type',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Create date',
  PRIMARY KEY (`identity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Admin System Messages';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]admin_system_messages`
--

LOCK TABLES `[[dbprefix]]admin_system_messages` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]admin_system_messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]admin_system_messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]admin_user`
--

DROP TABLE IF EXISTS `[[dbprefix]]admin_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]admin_user` (
  `user_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'User ID',
  `firstname` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'User First Name',
  `lastname` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'User Last Name',
  `email` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'User Email',
  `username` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'User Login',
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'User Password',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'User Created Time',
  `modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'User Modified Time',
  `logdate` timestamp NULL DEFAULT NULL COMMENT 'User Last Login Time',
  `lognum` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'User Login Number',
  `reload_acl_flag` smallint NOT NULL DEFAULT '0' COMMENT 'Reload ACL',
  `is_active` smallint NOT NULL DEFAULT '1' COMMENT 'User Is Active',
  `extra` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci COMMENT 'User Extra Data',
  `rp_token` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci COMMENT 'Reset Password Link Token',
  `rp_token_created_at` timestamp NULL DEFAULT NULL COMMENT 'Reset Password Link Token Creation Date',
  `interface_locale` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'en_US' COMMENT 'Backend interface locale',
  `failures_num` smallint DEFAULT '0' COMMENT 'Failure Number',
  `first_failure` timestamp NULL DEFAULT NULL COMMENT 'First Failure',
  `lock_expires` timestamp NULL DEFAULT NULL COMMENT 'Expiration Lock Dates',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `[[DBPREFIX]]ADMIN_USER_USERNAME` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COMMENT='Admin User Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]admin_user`
--

LOCK TABLES `[[dbprefix]]admin_user` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]admin_user` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]admin_user` VALUES (1,'[[admin_fname]]','[[admin_lname]]','[[admin_email]]','[[admin_username]]','[[admin_pass]]','[[regtime]]','[[regtime]]',NULL,0,0,1,NULL,NULL,NULL,'en_US',0,NULL,NULL);
/*!40000 ALTER TABLE `[[dbprefix]]admin_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]admin_user_expiration`
--

DROP TABLE IF EXISTS `[[dbprefix]]admin_user_expiration`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]admin_user_expiration` (
  `user_id` int unsigned NOT NULL COMMENT 'User ID',
  `expires_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'User Expiration Date',
  PRIMARY KEY (`user_id`),
  CONSTRAINT `[[DBPREFIX]]ADMIN_USER_EXPIRATION_USER_ID_[[DBPREFIX]]ADMIN_USER_USER_ID` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Admin User expiration dates table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]admin_user_expiration`
--

LOCK TABLES `[[dbprefix]]admin_user_expiration` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]admin_user_expiration` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]admin_user_expiration` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]admin_user_session`
--

DROP TABLE IF EXISTS `[[dbprefix]]admin_user_session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]admin_user_session` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `session_id` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'Deprecated: Session ID value no longer used',
  `user_id` int unsigned DEFAULT NULL COMMENT 'Admin User ID',
  `status` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Current Session status',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  `ip` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'Remote user IP',
  PRIMARY KEY (`id`),
  KEY `[[DBPREFIX]]ADMIN_USER_SESSION_SESSION_ID` (`session_id`),
  KEY `[[DBPREFIX]]ADMIN_USER_SESSION_USER_ID` (`user_id`),
  CONSTRAINT `[[DBPREFIX]]ADMIN_USER_SESSION_USER_ID_[[DBPREFIX]]ADMIN_USER_USER_ID` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Admin User sessions table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]admin_user_session`
--

LOCK TABLES `[[dbprefix]]admin_user_session` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]admin_user_session` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]admin_user_session` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]adminnotification_inbox`
--

DROP TABLE IF EXISTS `[[dbprefix]]adminnotification_inbox`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]adminnotification_inbox` (
  `notification_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Notification ID',
  `severity` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Problem type',
  `date_added` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Create date',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'Title',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci COMMENT 'Description',
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'Url',
  `is_read` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Flag if notification read',
  `is_remove` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Flag if notification might be removed',
  PRIMARY KEY (`notification_id`),
  KEY `[[DBPREFIX]]ADMINNOTIFICATION_INBOX_SEVERITY` (`severity`),
  KEY `[[DBPREFIX]]ADMINNOTIFICATION_INBOX_IS_READ` (`is_read`),
  KEY `[[DBPREFIX]]ADMINNOTIFICATION_INBOX_IS_REMOVE` (`is_remove`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COMMENT='Adminnotification Inbox';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]adminnotification_inbox`
--

LOCK TABLES `[[dbprefix]]adminnotification_inbox` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]adminnotification_inbox` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]adminnotification_inbox` VALUES (1,4,'[[regtime]]','Disable Notice','To improve performance, collecting statistics for the Magento Report module is disabled by default. \nYou can enable it in System Config.','',0,0);
/*!40000 ALTER TABLE `[[dbprefix]]adminnotification_inbox` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]adobe_stock_asset`
--

DROP TABLE IF EXISTS `[[dbprefix]]adobe_stock_asset`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]adobe_stock_asset` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `media_gallery_id` int unsigned DEFAULT NULL COMMENT 'Media gallery ID',
  `category_id` int unsigned DEFAULT NULL COMMENT 'Category ID',
  `creator_id` int unsigned DEFAULT NULL COMMENT 'Creator ID',
  `is_licensed` int unsigned NOT NULL DEFAULT '0' COMMENT 'Is Licensed',
  `creation_date` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'Creation Date',
  PRIMARY KEY (`id`),
  KEY `[[DBPREFIX]]ADOBE_STOCK_ASSET_MDA_GLR_ID_[[DBPREFIX]]MDA_GLR_ASSET_ID` (`media_gallery_id`),
  KEY `[[DBPREFIX]]ADOBE_STOCK_ASSET_ID` (`id`),
  KEY `[[DBPREFIX]]ADOBE_STOCK_ASSET_CATEGORY_ID` (`category_id`),
  KEY `[[DBPREFIX]]ADOBE_STOCK_ASSET_CREATOR_ID` (`creator_id`),
  CONSTRAINT `[[DBPREFIX]]ADOBE_STOCK_ASSET_CATEGORY_ID_[[DBPREFIX]]ADOBE_STOCK_CATEGORY_ID` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]adobe_stock_category` (`id`) ON DELETE SET NULL,
  CONSTRAINT `[[DBPREFIX]]ADOBE_STOCK_ASSET_CREATOR_ID_[[DBPREFIX]]ADOBE_STOCK_CREATOR_ID` FOREIGN KEY (`creator_id`) REFERENCES `[[dbprefix]]adobe_stock_creator` (`id`) ON DELETE SET NULL,
  CONSTRAINT `[[DBPREFIX]]ADOBE_STOCK_ASSET_MDA_GLR_ID_[[DBPREFIX]]MDA_GLR_ASSET_ID` FOREIGN KEY (`media_gallery_id`) REFERENCES `[[dbprefix]]media_gallery_asset` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Adobe Stock Asset';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]adobe_stock_asset`
--

LOCK TABLES `[[dbprefix]]adobe_stock_asset` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]adobe_stock_asset` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]adobe_stock_asset` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]adobe_stock_category`
--

DROP TABLE IF EXISTS `[[dbprefix]]adobe_stock_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]adobe_stock_category` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'Name',
  PRIMARY KEY (`id`),
  KEY `[[DBPREFIX]]ADOBE_STOCK_CATEGORY_ID` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Adobe Stock Category';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]adobe_stock_category`
--

LOCK TABLES `[[dbprefix]]adobe_stock_category` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]adobe_stock_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]adobe_stock_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]adobe_stock_creator`
--

DROP TABLE IF EXISTS `[[dbprefix]]adobe_stock_creator`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]adobe_stock_creator` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'Asset creator''s name',
  PRIMARY KEY (`id`),
  KEY `[[DBPREFIX]]ADOBE_STOCK_CREATOR_ID` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Adobe Stock Creator';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]adobe_stock_creator`
--

LOCK TABLES `[[dbprefix]]adobe_stock_creator` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]adobe_stock_creator` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]adobe_stock_creator` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]adobe_user_profile`
--

DROP TABLE IF EXISTS `[[dbprefix]]adobe_user_profile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]adobe_user_profile` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `admin_user_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Admin User Id',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'Display Name',
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'user profile email',
  `image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'user profile avatar',
  `account_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'Account Type',
  `access_token` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci COMMENT 'Access Token',
  `refresh_token` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci COMMENT 'Refresh Token',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated At',
  `access_token_expires_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'Access Token Expires At',
  PRIMARY KEY (`id`),
  KEY `[[DBPREFIX]]ADOBE_USER_PROFILE_ADMIN_USER_ID` (`admin_user_id`),
  CONSTRAINT `[[DBPREFIX]]ADOBE_USER_PROFILE_ADMIN_USER_ID_[[DBPREFIX]]ADMIN_USER_USER_ID` FOREIGN KEY (`admin_user_id`) REFERENCES `[[dbprefix]]admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Adobe IMS User Profile';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]adobe_user_profile`
--

LOCK TABLES `[[dbprefix]]adobe_user_profile` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]adobe_user_profile` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]adobe_user_profile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]authorization_role`
--

DROP TABLE IF EXISTS `[[dbprefix]]authorization_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]authorization_role` (
  `role_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Role ID',
  `parent_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Parent Role ID',
  `tree_level` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Role Tree Level',
  `sort_order` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Role Sort Order',
  `role_type` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '0' COMMENT 'Role Type',
  `user_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'User ID',
  `user_type` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'User Type',
  `role_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'Role Name',
  PRIMARY KEY (`role_id`),
  KEY `[[DBPREFIX]]AUTHORIZATION_ROLE_PARENT_ID_SORT_ORDER` (`parent_id`,`sort_order`),
  KEY `[[DBPREFIX]]AUTHORIZATION_ROLE_TREE_LEVEL` (`tree_level`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COMMENT='Admin Role Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]authorization_role`
--

LOCK TABLES `[[dbprefix]]authorization_role` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]authorization_role` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]authorization_role` VALUES (1,0,1,1,'G',0,'2','Administrators'),(2,1,2,0,'U',1,'2','[[admin_username]]');
/*!40000 ALTER TABLE `[[dbprefix]]authorization_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]authorization_rule`
--

DROP TABLE IF EXISTS `[[dbprefix]]authorization_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]authorization_rule` (
  `rule_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule ID',
  `role_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Role ID',
  `resource_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'Resource ID',
  `privileges` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'Privileges',
  `permission` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'Permission',
  PRIMARY KEY (`rule_id`),
  KEY `[[DBPREFIX]]AUTHORIZATION_RULE_RESOURCE_ID_ROLE_ID` (`resource_id`,`role_id`),
  KEY `[[DBPREFIX]]AUTHORIZATION_RULE_ROLE_ID_RESOURCE_ID` (`role_id`,`resource_id`),
  CONSTRAINT `[[DBPREFIX]]AUTHORIZATION_RULE_ROLE_ID_[[DBPREFIX]]AUTHORIZATION_ROLE_ROLE_ID` FOREIGN KEY (`role_id`) REFERENCES `[[dbprefix]]authorization_role` (`role_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COMMENT='Admin Rule Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]authorization_rule`
--

LOCK TABLES `[[dbprefix]]authorization_rule` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]authorization_rule` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]authorization_rule` VALUES (1,1,'Magento_Backend::all',NULL,'allow');
/*!40000 ALTER TABLE `[[dbprefix]]authorization_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]braintree_credit_prices`
--

DROP TABLE IF EXISTS `[[dbprefix]]braintree_credit_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]braintree_credit_prices` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Row ID',
  `product_id` int unsigned NOT NULL COMMENT 'Product Id',
  `term` int NOT NULL COMMENT 'Credit Term',
  `monthly_payment` decimal(12,2) NOT NULL COMMENT 'Monthly Payment',
  `instalment_rate` decimal(12,2) NOT NULL COMMENT 'Instalment Rate',
  `cost_of_purchase` decimal(12,2) NOT NULL COMMENT 'Cost of purchase',
  `total_inc_interest` decimal(12,2) NOT NULL COMMENT 'Total Inc Interest',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[DBPREFIX]]BRAINTREE_CREDIT_PRICES_PRODUCT_ID_TERM` (`product_id`,`term`),
  KEY `[[DBPREFIX]]BRAINTREE_CREDIT_PRICES_PRODUCT_ID` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Braintree credit rates';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]braintree_credit_prices`
--

LOCK TABLES `[[dbprefix]]braintree_credit_prices` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]braintree_credit_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]braintree_credit_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]braintree_transaction_details`
--

DROP TABLE IF EXISTS `[[dbprefix]]braintree_transaction_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]braintree_transaction_details` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `order_id` int unsigned NOT NULL COMMENT 'Order Id',
  `transaction_source` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci COMMENT 'Transaction Source',
  PRIMARY KEY (`entity_id`),
  KEY `[[DBPREFIX]]BRAINTREE_TRANSACTION_DETAILS_ORDER_ID` (`order_id`),
  CONSTRAINT `FK_3EDCAC75D4D61EFAAE195F7E540F3B3F` FOREIGN KEY (`order_id`) REFERENCES `[[dbprefix]]sales_order` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Braintree transaction details table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]braintree_transaction_details`
--

LOCK TABLES `[[dbprefix]]braintree_transaction_details` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]braintree_transaction_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]braintree_transaction_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]cache`
--

DROP TABLE IF EXISTS `[[dbprefix]]cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]cache` (
  `id` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'Cache Id',
  `data` mediumblob COMMENT 'Cache Data',
  `create_time` int DEFAULT NULL COMMENT 'Cache Creation Time',
  `update_time` int DEFAULT NULL COMMENT 'Time of Cache Updating',
  `expire_time` int DEFAULT NULL COMMENT 'Cache Expiration Time',
  PRIMARY KEY (`id`),
  KEY `[[DBPREFIX]]CACHE_EXPIRE_TIME` (`expire_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Caches';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]cache`
--

LOCK TABLES `[[dbprefix]]cache` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]cache_tag`
--

DROP TABLE IF EXISTS `[[dbprefix]]cache_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]cache_tag` (
  `tag` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'Tag',
  `cache_id` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'Cache Id',
  PRIMARY KEY (`tag`,`cache_id`),
  KEY `[[DBPREFIX]]CACHE_TAG_CACHE_ID` (`cache_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Tag Caches';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]cache_tag`
--

LOCK TABLES `[[dbprefix]]cache_tag` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]cache_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]cache_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]captcha_log`
--

DROP TABLE IF EXISTS `[[dbprefix]]captcha_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]captcha_log` (
  `type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'Type',
  `value` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'Value',
  `count` int unsigned NOT NULL DEFAULT '0' COMMENT 'Count',
  `updated_at` timestamp NULL DEFAULT NULL COMMENT 'Update Time',
  PRIMARY KEY (`type`,`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Count Login Attempts';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]captcha_log`
--

LOCK TABLES `[[dbprefix]]captcha_log` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]captcha_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]captcha_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_entity`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_entity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_category_entity` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `attribute_set_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute Set ID',
  `parent_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Parent Category ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  `path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'Tree Path',
  `position` int NOT NULL COMMENT 'Position',
  `level` int NOT NULL DEFAULT '0' COMMENT 'Tree Level',
  `children_count` int NOT NULL COMMENT 'Child Count',
  PRIMARY KEY (`entity_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_LEVEL` (`level`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_PATH` (`path`)
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb4 COMMENT='Catalog Category Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_entity`
--

LOCK TABLES `[[dbprefix]]catalog_category_entity` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_category_entity` VALUES (1,3,0,'[[regtime]]','[[regtime]]','1',0,0,39),(2,3,1,'[[regtime]]','[[regtime]]','1/2',1,1,38),(3,3,2,'[[regtime]]','[[regtime]]','1/2/3',4,2,3),(4,3,3,'[[regtime]]','[[regtime]]','1/2/3/4',1,3,0),(5,3,3,'[[regtime]]','[[regtime]]','1/2/3/5',2,3,0),(6,3,3,'[[regtime]]','[[regtime]]','1/2/3/6',3,3,0),(7,3,2,'[[regtime]]','[[regtime]]','1/2/7',5,2,6),(8,3,7,'[[regtime]]','[[regtime]]','1/2/7/8',1,3,0),(9,3,2,'[[regtime]]','[[regtime]]','1/2/9',5,2,1),(10,3,9,'[[regtime]]','[[regtime]]','1/2/9/10',1,3,0),(11,3,2,'[[regtime]]','[[regtime]]','1/2/11',3,2,8),(12,3,11,'[[regtime]]','[[regtime]]','1/2/11/12',1,3,4),(13,3,11,'[[regtime]]','[[regtime]]','1/2/11/13',2,3,2),(14,3,12,'[[regtime]]','[[regtime]]','1/2/11/12/14',1,4,0),(15,3,12,'[[regtime]]','[[regtime]]','1/2/11/12/15',2,4,0),(16,3,12,'[[regtime]]','[[regtime]]','1/2/11/12/16',3,4,0),(17,3,12,'[[regtime]]','[[regtime]]','1/2/11/12/17',4,4,0),(18,3,13,'[[regtime]]','[[regtime]]','1/2/11/13/18',1,4,0),(19,3,13,'[[regtime]]','[[regtime]]','1/2/11/13/19',2,4,0),(20,3,2,'[[regtime]]','[[regtime]]','1/2/20',2,2,8),(21,3,20,'[[regtime]]','[[regtime]]','1/2/20/21',1,3,4),(22,3,20,'[[regtime]]','[[regtime]]','1/2/20/22',2,3,2),(23,3,21,'[[regtime]]','[[regtime]]','1/2/20/21/23',1,4,0),(24,3,21,'[[regtime]]','[[regtime]]','1/2/20/21/24',2,4,0),(25,3,21,'[[regtime]]','[[regtime]]','1/2/20/21/25',3,4,0),(26,3,21,'[[regtime]]','[[regtime]]','1/2/20/21/26',4,4,0),(27,3,22,'[[regtime]]','[[regtime]]','1/2/20/22/27',1,4,0),(28,3,22,'[[regtime]]','[[regtime]]','1/2/20/22/28',2,4,0),(29,3,2,'[[regtime]]','[[regtime]]','1/2/29',6,2,4),(30,3,29,'[[regtime]]','[[regtime]]','1/2/29/30',1,3,0),(31,3,29,'[[regtime]]','[[regtime]]','1/2/29/31',2,3,0),(32,3,29,'[[regtime]]','[[regtime]]','1/2/29/32',3,3,0),(33,3,29,'[[regtime]]','[[regtime]]','1/2/29/33',4,3,0),(34,3,7,'[[regtime]]','[[regtime]]','1/2/7/34',2,3,0),(35,3,7,'[[regtime]]','[[regtime]]','1/2/7/35',3,3,0),(36,3,7,'[[regtime]]','[[regtime]]','1/2/7/36',4,3,0),(37,3,2,'[[regtime]]','[[regtime]]','1/2/37',6,2,0),(38,3,2,'[[regtime]]','[[regtime]]','1/2/38',1,2,0),(39,3,7,'[[regtime]]','[[regtime]]','1/2/7/39',5,3,0),(40,3,7,'[[regtime]]','[[regtime]]','1/2/7/40',6,3,0);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_entity_datetime`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_entity_datetime`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_category_entity_datetime` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` datetime DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `[[DBPREFIX]]CAT_CTGR_ENTT_DTIME_ENTT_ID_ATTR_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_DATETIME_ENTITY_ID` (`entity_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_DATETIME_ATTRIBUTE_ID` (`attribute_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_DATETIME_STORE_ID` (`store_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_DTIME_ATTR_ID_[[DBPREFIX]]EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_DTIME_ENTT_ID_[[DBPREFIX]]CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `[[dbprefix]]catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_DTIME_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `[[dbprefix]]store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Catalog Category Datetime Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_entity_datetime`
--

LOCK TABLES `[[dbprefix]]catalog_category_entity_datetime` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity_datetime` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity_datetime` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_entity_decimal`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_entity_decimal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_category_entity_decimal` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` decimal(20,6) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `[[DBPREFIX]]CAT_CTGR_ENTT_DEC_ENTT_ID_ATTR_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_DECIMAL_ENTITY_ID` (`entity_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_DECIMAL_ATTRIBUTE_ID` (`attribute_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_DECIMAL_STORE_ID` (`store_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_DEC_ATTR_ID_[[DBPREFIX]]EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_DEC_ENTT_ID_[[DBPREFIX]]CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `[[dbprefix]]catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_DEC_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `[[dbprefix]]store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Catalog Category Decimal Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_entity_decimal`
--

LOCK TABLES `[[dbprefix]]catalog_category_entity_decimal` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity_decimal` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity_decimal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_entity_int`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_entity_int`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_category_entity_int` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` int DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_INT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_INT_ENTITY_ID` (`entity_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_INT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_INT_STORE_ID` (`store_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_INT_ATTR_ID_[[DBPREFIX]]EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_INT_ENTT_ID_[[DBPREFIX]]CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `[[dbprefix]]catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_INT_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `[[dbprefix]]store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=118 DEFAULT CHARSET=utf8mb4 COMMENT='Catalog Category Integer Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_entity_int`
--

LOCK TABLES `[[dbprefix]]catalog_category_entity_int` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity_int` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_category_entity_int` VALUES (1,69,0,1,1),(2,69,0,2,1),(3,46,0,2,1),(4,69,0,3,1),(5,46,0,3,1),(6,54,0,3,0),(7,69,0,4,1),(8,46,0,4,1),(9,54,0,4,1),(10,69,0,5,1),(11,46,0,5,1),(12,54,0,5,1),(13,69,0,6,1),(14,46,0,6,1),(15,54,0,6,1),(16,69,0,7,0),(17,46,0,7,0),(18,54,0,7,0),(19,69,0,8,0),(20,46,0,8,1),(21,54,0,8,1),(22,69,0,9,1),(23,46,0,9,1),(24,54,0,9,0),(25,69,0,10,1),(26,46,0,10,1),(27,54,0,10,1),(28,69,0,11,1),(29,46,0,11,1),(30,54,0,11,0),(31,69,0,12,1),(32,46,0,12,1),(33,54,0,12,1),(34,69,0,13,1),(35,46,0,13,1),(36,54,0,13,1),(37,69,0,14,1),(38,46,0,14,1),(39,54,0,14,1),(40,69,0,15,1),(41,46,0,15,1),(42,54,0,15,1),(43,69,0,16,1),(44,46,0,16,1),(45,54,0,16,1),(46,69,0,17,1),(47,46,0,17,1),(48,54,0,17,1),(49,69,0,18,1),(50,46,0,18,1),(51,54,0,18,1),(52,69,0,19,1),(53,46,0,19,1),(54,54,0,19,1),(55,69,0,20,1),(56,46,0,20,1),(57,54,0,20,0),(58,69,0,21,1),(59,46,0,21,1),(60,54,0,21,1),(61,69,0,22,1),(62,46,0,22,1),(63,54,0,22,1),(64,69,0,23,1),(65,46,0,23,1),(66,54,0,23,1),(67,69,0,24,1),(68,46,0,24,1),(69,54,0,24,1),(70,69,0,25,1),(71,46,0,25,1),(72,54,0,25,1),(73,69,0,26,1),(74,46,0,26,1),(75,54,0,26,1),(76,69,0,27,1),(77,46,0,27,1),(78,54,0,27,1),(79,69,0,28,1),(80,46,0,28,1),(81,54,0,28,1),(82,69,0,29,0),(83,46,0,29,0),(84,54,0,29,0),(85,69,0,30,0),(86,46,0,30,1),(87,54,0,30,1),(88,69,0,31,0),(89,46,0,31,1),(90,54,0,31,1),(91,69,0,32,0),(92,46,0,32,1),(93,54,0,32,1),(94,69,0,33,0),(95,46,0,33,1),(96,54,0,33,1),(97,69,0,34,0),(98,46,0,34,1),(99,54,0,34,1),(100,69,0,35,0),(101,46,0,35,1),(102,54,0,35,1),(103,69,0,36,0),(104,46,0,36,1),(105,54,0,36,1),(106,69,0,37,1),(107,46,0,37,1),(108,54,0,37,0),(109,69,0,38,1),(110,46,0,38,1),(111,54,0,38,0),(112,69,0,39,0),(113,46,0,39,1),(114,54,0,39,0),(115,69,0,40,0),(116,46,0,40,1),(117,54,0,40,0);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity_int` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_entity_text`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_entity_text`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_category_entity_text` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `[[DBPREFIX]]CAT_CTGR_ENTT_TEXT_ENTT_ID_ATTR_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_TEXT_ENTITY_ID` (`entity_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_TEXT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_TEXT_STORE_ID` (`store_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_TEXT_ATTR_ID_[[DBPREFIX]]EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_TEXT_ENTT_ID_[[DBPREFIX]]CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `[[dbprefix]]catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_TEXT_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `[[dbprefix]]store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Catalog Category Text Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_entity_text`
--

LOCK TABLES `[[dbprefix]]catalog_category_entity_text` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity_text` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity_text` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_entity_varchar`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_entity_varchar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_category_entity_varchar` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `[[DBPREFIX]]CAT_CTGR_ENTT_VCHR_ENTT_ID_ATTR_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_VARCHAR_ENTITY_ID` (`entity_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_VARCHAR_ATTRIBUTE_ID` (`attribute_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_VARCHAR_STORE_ID` (`store_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_VCHR_ATTR_ID_[[DBPREFIX]]EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_VCHR_ENTT_ID_[[DBPREFIX]]CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `[[dbprefix]]catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_VCHR_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `[[dbprefix]]store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=130 DEFAULT CHARSET=utf8mb4 COMMENT='Catalog Category Varchar Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_entity_varchar`
--

LOCK TABLES `[[dbprefix]]catalog_category_entity_varchar` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity_varchar` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_category_entity_varchar` VALUES (1,45,0,1,'Root Catalog'),(2,52,0,2,'PRODUCTS'),(3,45,0,2,'Default Category'),(4,52,0,3,'PAGE'),(5,45,0,3,'Gear'),(6,119,0,3,'gear'),(7,120,0,3,'gear'),(8,45,0,4,'Bags'),(9,119,0,4,'bags'),(10,120,0,4,'gear/bags'),(11,45,0,5,'Fitness Equipment'),(12,119,0,5,'fitness-equipment'),(13,120,0,5,'gear/fitness-equipment'),(14,45,0,6,'Watches'),(15,119,0,6,'watches'),(16,120,0,6,'gear/watches'),(17,52,0,7,'PAGE'),(18,45,0,7,'Collections'),(19,119,0,7,'collections'),(20,120,0,7,'collections'),(21,45,0,8,'New Luma Yoga Collection'),(22,119,0,8,'yoga-new'),(23,120,0,8,'collections/yoga-new'),(24,52,0,9,'PAGE'),(25,45,0,9,'Training'),(26,119,0,9,'training'),(27,120,0,9,'training'),(28,45,0,10,'Video Download'),(29,119,0,10,'training-video'),(30,120,0,10,'training/training-video'),(31,52,0,11,'PAGE'),(32,45,0,11,'Men'),(33,119,0,11,'men'),(34,120,0,11,'men'),(35,45,0,12,'Tops'),(36,119,0,12,'tops-men'),(37,120,0,12,'men/tops-men'),(38,45,0,13,'Bottoms'),(39,119,0,13,'bottoms-men'),(40,120,0,13,'men/bottoms-men'),(41,45,0,14,'Jackets'),(42,119,0,14,'jackets-men'),(43,120,0,14,'men/tops-men/jackets-men'),(44,45,0,15,'Hoodies & Sweatshirts'),(45,119,0,15,'hoodies-and-sweatshirts-men'),(46,120,0,15,'men/tops-men/hoodies-and-sweatshirts-men'),(47,45,0,16,'Tees'),(48,119,0,16,'tees-men'),(49,120,0,16,'men/tops-men/tees-men'),(50,45,0,17,'Tanks'),(51,119,0,17,'tanks-men'),(52,120,0,17,'men/tops-men/tanks-men'),(53,45,0,18,'Pants'),(54,119,0,18,'pants-men'),(55,120,0,18,'men/bottoms-men/pants-men'),(56,45,0,19,'Shorts'),(57,119,0,19,'shorts-men'),(58,120,0,19,'men/bottoms-men/shorts-men'),(59,52,0,20,'PAGE'),(60,45,0,20,'Women'),(61,119,0,20,'women'),(62,120,0,20,'women'),(63,45,0,21,'Tops'),(64,119,0,21,'tops-women'),(65,120,0,21,'women/tops-women'),(66,45,0,22,'Bottoms'),(67,119,0,22,'bottoms-women'),(68,120,0,22,'women/bottoms-women'),(69,45,0,23,'Jackets'),(70,119,0,23,'jackets-women'),(71,120,0,23,'women/tops-women/jackets-women'),(72,45,0,24,'Hoodies & Sweatshirts'),(73,119,0,24,'hoodies-and-sweatshirts-women'),(74,120,0,24,'women/tops-women/hoodies-and-sweatshirts-women'),(75,45,0,25,'Tees'),(76,119,0,25,'tees-women'),(77,120,0,25,'women/tops-women/tees-women'),(78,45,0,26,'Bras & Tanks'),(79,119,0,26,'tanks-women'),(80,120,0,26,'women/tops-women/tanks-women'),(81,45,0,27,'Pants'),(82,119,0,27,'pants-women'),(83,120,0,27,'women/bottoms-women/pants-women'),(84,45,0,28,'Shorts'),(85,119,0,28,'shorts-women'),(86,120,0,28,'women/bottoms-women/shorts-women'),(87,52,0,29,'PAGE'),(88,45,0,29,'Promotions'),(89,119,0,29,'promotions'),(90,120,0,29,'promotions'),(91,45,0,30,'Women Sale'),(92,119,0,30,'women-sale'),(93,120,0,30,'promotions/women-sale'),(94,45,0,31,'Men Sale'),(95,119,0,31,'men-sale'),(96,120,0,31,'promotions/men-sale'),(97,45,0,32,'Pants'),(98,119,0,32,'pants-all'),(99,120,0,32,'promotions/pants-all'),(100,45,0,33,'Tees'),(101,119,0,33,'tees-all'),(102,120,0,33,'promotions/tees-all'),(103,45,0,34,'Erin Recommends'),(104,119,0,34,'erin-recommends'),(105,120,0,34,'collections/erin-recommends'),(106,45,0,35,'Performance Fabrics'),(107,119,0,35,'performance-fabrics'),(108,120,0,35,'collections/performance-fabrics'),(109,45,0,36,'Eco Friendly'),(110,119,0,36,'eco-friendly'),(111,120,0,36,'collections/eco-friendly'),(112,52,0,37,'PAGE'),(113,45,0,37,'Sale'),(114,119,0,37,'sale'),(115,120,0,37,'sale'),(116,52,0,38,'PAGE'),(117,45,0,38,'What\'s New'),(118,119,0,38,'what-is-new'),(119,120,0,38,'what-is-new'),(120,52,0,39,'PAGE'),(121,45,0,39,'Performance Sportswear New'),(122,63,0,39,'1column'),(123,119,0,39,'performance-new'),(124,120,0,39,'collections/performance-new'),(125,52,0,40,'PAGE'),(126,45,0,40,'Eco Collection New'),(127,63,0,40,'1column'),(128,119,0,40,'eco-new'),(129,120,0,40,'collections/eco-new');
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity_varchar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_product`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_category_product` (
  `entity_id` int NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int NOT NULL DEFAULT '0' COMMENT 'Position',
  PRIMARY KEY (`entity_id`,`category_id`,`product_id`),
  UNIQUE KEY `[[DBPREFIX]]CATALOG_CATEGORY_PRODUCT_CATEGORY_ID_PRODUCT_ID` (`category_id`,`product_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_PRODUCT_PRODUCT_ID` (`product_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_PRD_CTGR_ID_[[DBPREFIX]]CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_PRD_PRD_ID_[[DBPREFIX]]CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `[[dbprefix]]catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5166 DEFAULT CHARSET=utf8mb4 COMMENT='Catalog Product To Category Linkage Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_product`
--

LOCK TABLES `[[dbprefix]]catalog_category_product` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_category_product` VALUES (1,3,1,0),(2,4,1,0),(3,3,2,0),(4,7,2,0),(5,4,2,0),(6,3,3,0),(7,4,3,0),(8,3,4,0),(9,7,4,0),(10,4,4,0),(11,8,4,0),(12,3,5,0),(13,7,5,0),(14,4,5,0),(15,8,5,0),(16,3,6,0),(17,4,6,0),(18,3,7,0),(19,4,7,0),(20,3,8,0),(21,4,8,0),(22,3,9,0),(23,4,9,0),(24,3,10,0),(25,7,10,0),(26,4,10,0),(27,3,11,0),(28,7,11,0),(29,4,11,0),(30,3,12,0),(31,4,12,0),(32,3,13,0),(33,7,13,0),(34,4,13,0),(35,8,13,0),(36,3,14,0),(37,7,14,0),(38,4,14,0),(39,3,15,0),(40,5,15,0),(41,3,16,0),(42,7,16,0),(43,5,16,0),(44,3,17,0),(45,5,17,0),(46,3,18,0),(47,5,18,0),(48,3,19,0),(49,7,19,0),(50,5,19,0),(51,8,19,0),(52,3,20,0),(53,5,20,0),(54,3,21,0),(55,5,21,0),(56,3,22,0),(57,5,22,0),(58,3,23,0),(59,5,23,0),(60,3,24,0),(61,5,24,0),(62,3,25,0),(63,5,25,0),(64,3,26,0),(65,5,26,0),(66,3,27,0),(67,5,27,0),(68,3,28,0),(69,5,28,0),(70,3,29,0),(71,5,29,0),(72,3,30,0),(73,5,30,0),(74,3,31,0),(75,5,31,0),(76,3,32,0),(77,5,32,0),(78,3,33,0),(79,5,33,0),(80,3,34,0),(81,5,34,0),(82,3,35,0),(83,5,35,0),(84,3,36,0),(85,6,36,0),(86,3,37,0),(87,6,37,0),(88,3,38,0),(89,7,38,0),(90,6,38,0),(91,8,38,0),(92,3,39,0),(93,7,39,0),(94,6,39,0),(95,8,39,0),(96,3,40,0),(97,7,40,0),(98,6,40,0),(99,8,40,0),(100,3,41,0),(101,6,41,0),(102,3,42,0),(103,6,42,0),(104,3,43,0),(105,6,43,0),(106,3,44,0),(107,7,44,0),(108,6,44,0),(109,8,44,0),(110,3,45,0),(111,5,45,0),(112,3,46,0),(113,5,46,0),(114,15,47,-1),(115,36,47,-1),(116,2,47,-1),(117,15,48,-2),(118,36,48,-2),(119,2,48,-2),(120,15,49,-3),(121,36,49,-3),(122,2,49,-3),(123,15,50,-4),(124,36,50,-4),(125,2,50,-4),(126,15,51,-5),(127,36,51,-5),(128,2,51,-5),(129,15,52,-6),(130,36,52,-6),(131,2,52,-6),(132,15,53,-7),(133,36,53,-7),(134,2,53,-7),(135,15,54,-8),(136,36,54,-8),(137,2,54,-8),(138,15,55,-9),(139,36,55,-9),(140,2,55,-9),(141,15,56,-10),(142,36,56,-10),(143,2,56,-10),(144,15,57,-11),(145,36,57,-11),(146,2,57,-11),(147,15,58,-12),(148,36,58,-12),(149,2,58,-12),(150,15,59,-13),(151,36,59,-13),(152,2,59,-13),(153,15,60,-14),(154,36,60,-14),(155,2,60,-14),(156,15,61,-15),(157,36,61,-15),(158,2,61,-15),(159,15,62,-16),(160,36,62,-16),(161,2,62,-16),(162,15,63,-17),(163,15,64,-18),(164,15,65,-19),(165,15,66,-20),(166,15,67,-21),(167,15,68,-22),(168,15,69,-23),(169,15,70,-24),(170,15,71,-25),(171,15,72,-26),(172,15,73,-27),(173,15,74,-28),(174,15,75,-29),(175,15,76,-30),(176,15,77,-31),(177,15,78,-32),(178,15,79,-33),(179,36,79,-17),(180,2,79,-17),(181,15,80,-34),(182,36,80,-18),(183,2,80,-18),(184,15,81,-35),(185,36,81,-19),(186,2,81,-19),(187,15,82,-36),(188,36,82,-20),(189,2,82,-20),(190,15,83,-37),(191,36,83,-21),(192,2,83,-21),(193,15,84,-38),(194,36,84,-22),(195,2,84,-22),(196,15,85,-39),(197,36,85,-23),(198,2,85,-23),(199,15,86,-40),(200,36,86,-24),(201,2,86,-24),(202,15,87,-41),(203,36,87,-25),(204,2,87,-25),(205,15,88,-42),(206,36,88,-26),(207,2,88,-26),(208,15,89,-43),(209,36,89,-27),(210,2,89,-27),(211,15,90,-44),(212,36,90,-28),(213,2,90,-28),(214,15,91,-45),(215,36,91,-29),(216,2,91,-29),(217,15,92,-46),(218,36,92,-30),(219,2,92,-30),(220,15,93,-47),(221,36,93,-31),(222,2,93,-31),(223,15,94,-48),(224,36,94,-32),(225,2,94,-32),(226,15,95,-49),(227,36,95,-33),(228,2,95,-33),(229,15,96,-50),(230,36,96,-34),(231,2,96,-34),(232,15,97,-51),(233,36,97,-35),(234,2,97,-35),(235,15,98,-52),(236,36,98,-36),(237,2,98,-36),(238,15,99,-53),(239,36,99,-37),(240,2,99,-37),(241,15,100,-54),(242,36,100,-38),(243,2,100,-38),(244,15,101,-55),(245,36,101,-39),(246,2,101,-39),(247,15,102,-56),(248,36,102,-40),(249,2,102,-40),(250,15,103,-57),(251,36,103,-41),(252,2,103,-41),(253,15,104,-58),(254,36,104,-42),(255,2,104,-42),(256,15,105,-59),(257,36,105,-43),(258,2,105,-43),(259,15,106,-60),(260,36,106,-44),(261,2,106,-44),(262,15,107,-61),(263,36,107,-45),(264,2,107,-45),(265,15,108,-62),(266,36,108,-46),(267,2,108,-46),(268,15,109,-63),(269,36,109,-47),(270,2,109,-47),(271,15,110,-64),(272,36,110,-48),(273,2,110,-48),(274,15,111,-65),(275,15,112,-66),(276,15,113,-67),(277,15,114,-68),(278,15,115,-69),(279,15,116,-70),(280,15,117,-71),(281,15,118,-72),(282,15,119,-73),(283,15,120,-74),(284,15,121,-75),(285,15,122,-76),(286,15,123,-77),(287,15,124,-78),(288,15,125,-79),(289,15,126,-80),(290,15,127,-81),(291,15,128,-82),(292,15,129,-83),(293,15,130,-84),(294,15,131,-85),(295,15,132,-86),(296,15,133,-87),(297,15,134,-88),(298,15,135,-89),(299,15,136,-90),(300,15,137,-91),(301,15,138,-92),(302,15,139,-93),(303,15,140,-94),(304,15,141,-95),(305,15,142,-96),(306,15,143,-97),(307,15,144,-98),(308,15,145,-99),(309,15,146,-100),(310,15,147,-101),(311,15,148,-102),(312,15,149,-103),(313,15,150,-104),(314,15,151,-105),(315,15,152,-106),(316,15,153,-107),(317,15,154,-108),(318,15,155,-109),(319,15,156,-110),(320,15,157,-111),(321,15,158,-112),(322,15,159,-113),(323,15,160,-114),(324,15,161,-115),(325,15,162,-116),(326,15,163,-117),(327,15,164,-118),(328,15,165,-119),(329,15,166,-120),(330,15,167,-121),(331,15,168,-122),(332,15,169,-123),(333,15,170,-124),(334,15,171,-125),(335,15,172,-126),(336,15,173,-127),(337,15,174,-128),(338,15,175,-129),(339,15,176,-130),(340,15,177,-131),(341,15,178,-132),(342,15,179,-133),(343,15,180,-134),(344,15,181,-135),(345,15,182,-136),(346,15,183,-137),(347,15,184,-138),(348,15,185,-139),(349,15,186,-140),(350,15,187,-141),(351,15,188,-142),(352,15,189,-143),(353,15,190,-144),(354,15,191,-145),(355,15,192,-146),(356,15,193,-147),(357,15,194,-148),(358,15,195,-149),(359,15,196,-150),(360,15,197,-151),(361,15,198,-152),(362,15,199,-153),(363,15,200,-154),(364,15,201,-155),(365,15,202,-156),(366,15,203,-157),(367,15,204,-158),(368,15,205,-159),(369,15,206,-160),(370,15,207,-161),(371,15,208,-162),(372,15,209,-163),(373,15,210,-164),(374,15,211,-165),(375,15,212,-166),(376,15,213,-167),(377,15,214,-168),(378,15,215,-169),(379,15,216,-170),(380,15,217,-171),(381,15,218,-172),(382,15,219,-173),(383,15,220,-174),(384,15,221,-175),(385,15,222,-176),(386,15,223,-177),(387,15,224,-178),(388,15,225,-179),(389,15,226,-180),(390,15,227,-181),(391,15,228,-182),(392,15,229,-183),(393,15,230,-184),(394,15,231,-185),(395,15,232,-186),(396,15,233,-187),(397,15,234,-188),(398,15,235,-189),(399,15,236,-190),(400,15,237,-191),(401,15,238,-192),(402,15,239,-193),(403,15,240,-194),(404,15,241,-195),(405,15,242,-196),(406,15,243,-197),(407,15,244,-198),(408,15,245,-199),(409,15,246,-200),(410,15,247,-201),(411,15,248,-202),(412,15,249,-203),(413,15,250,-204),(414,15,251,-205),(415,15,252,-206),(416,15,253,-207),(417,15,254,-208),(418,14,255,-1),(419,14,256,-2),(420,14,257,-3),(421,14,258,-4),(422,14,259,-5),(423,14,260,-6),(424,14,261,-7),(425,14,262,-8),(426,14,263,-9),(427,14,264,-10),(428,14,265,-11),(429,14,266,-12),(430,14,267,-13),(431,14,268,-14),(432,14,269,-15),(433,14,270,-16),(434,14,271,-17),(435,14,272,-18),(436,14,273,-19),(437,14,274,-20),(438,14,275,-21),(439,14,276,-22),(440,14,277,-23),(441,14,278,-24),(442,14,279,-25),(443,14,280,-26),(444,14,281,-27),(445,14,282,-28),(446,14,283,-29),(447,14,284,-30),(448,14,285,-31),(449,14,286,-32),(450,14,287,-33),(451,36,287,-49),(452,2,287,-49),(453,14,288,-34),(454,36,288,-50),(455,2,288,-50),(456,14,289,-35),(457,36,289,-51),(458,2,289,-51),(459,14,290,-36),(460,36,290,-52),(461,2,290,-52),(462,14,291,-37),(463,36,291,-53),(464,2,291,-53),(465,14,292,-38),(466,36,292,-54),(467,2,292,-54),(468,14,293,-39),(469,36,293,-55),(470,2,293,-55),(471,14,294,-40),(472,36,294,-56),(473,2,294,-56),(474,14,295,-41),(475,36,295,-57),(476,2,295,-57),(477,14,296,-42),(478,36,296,-58),(479,2,296,-58),(480,14,297,-43),(481,36,297,-59),(482,2,297,-59),(483,14,298,-44),(484,36,298,-60),(485,2,298,-60),(486,14,299,-45),(487,36,299,-61),(488,2,299,-61),(489,14,300,-46),(490,36,300,-62),(491,2,300,-62),(492,14,301,-47),(493,36,301,-63),(494,2,301,-63),(495,14,302,-48),(496,36,302,-64),(497,2,302,-64),(498,14,303,-49),(499,14,304,-50),(500,14,305,-51),(501,14,306,-52),(502,14,307,-53),(503,14,308,-54),(504,14,309,-55),(505,14,310,-56),(506,14,311,-57),(507,14,312,-58),(508,14,313,-59),(509,14,314,-60),(510,14,315,-61),(511,14,316,-62),(512,14,317,-63),(513,14,318,-64),(514,14,319,-65),(515,14,320,-66),(516,14,321,-67),(517,14,322,-68),(518,14,323,-69),(519,14,324,-70),(520,14,325,-71),(521,14,326,-72),(522,14,327,-73),(523,14,328,-74),(524,14,329,-75),(525,14,330,-76),(526,14,331,-77),(527,14,332,-78),(528,14,333,-79),(529,14,334,-80),(530,14,335,-81),(531,14,336,-82),(532,14,337,-83),(533,14,338,-84),(534,14,339,-85),(535,14,340,-86),(536,14,341,-87),(537,14,342,-88),(538,14,343,-89),(539,14,344,-90),(540,14,345,-91),(541,14,346,-92),(542,14,347,-93),(543,14,348,-94),(544,14,349,-95),(545,14,350,-96),(546,14,351,-97),(547,14,352,-98),(548,14,353,-99),(549,14,354,-100),(550,14,355,-101),(551,14,356,-102),(552,14,357,-103),(553,14,358,-104),(554,14,359,-105),(555,14,360,-106),(556,14,361,-107),(557,14,362,-108),(558,14,363,-109),(559,14,364,-110),(560,14,365,-111),(561,14,366,-112),(562,14,367,-113),(563,14,368,-114),(564,14,369,-115),(565,14,370,-116),(566,14,371,-117),(567,14,372,-118),(568,14,373,-119),(569,14,374,-120),(570,14,375,-121),(571,14,376,-122),(572,14,377,-123),(573,14,378,-124),(574,14,379,-125),(575,14,380,-126),(576,14,381,-127),(577,14,382,-128),(578,14,383,-129),(579,36,383,-65),(580,2,383,-65),(581,14,384,-130),(582,36,384,-66),(583,2,384,-66),(584,14,385,-131),(585,36,385,-67),(586,2,385,-67),(587,14,386,-132),(588,36,386,-68),(589,2,386,-68),(590,14,387,-133),(591,36,387,-69),(592,2,387,-69),(593,14,388,-134),(594,36,388,-70),(595,2,388,-70),(596,14,389,-135),(597,36,389,-71),(598,2,389,-71),(599,14,390,-136),(600,36,390,-72),(601,2,390,-72),(602,14,391,-137),(603,36,391,-73),(604,2,391,-73),(605,14,392,-138),(606,36,392,-74),(607,2,392,-74),(608,14,393,-139),(609,36,393,-75),(610,2,393,-75),(611,14,394,-140),(612,36,394,-76),(613,2,394,-76),(614,14,395,-141),(615,36,395,-77),(616,2,395,-77),(617,14,396,-142),(618,36,396,-78),(619,2,396,-78),(620,14,397,-143),(621,36,397,-79),(622,2,397,-79),(623,14,398,-144),(624,36,398,-80),(625,2,398,-80),(626,14,399,-145),(627,14,400,-146),(628,14,401,-147),(629,14,402,-148),(630,14,403,-149),(631,14,404,-150),(632,14,405,-151),(633,14,406,-152),(634,14,407,-153),(635,14,408,-154),(636,14,409,-155),(637,14,410,-156),(638,14,411,-157),(639,14,412,-158),(640,14,413,-159),(641,14,414,-160),(642,14,415,-161),(643,14,416,-162),(644,14,417,-163),(645,14,418,-164),(646,14,419,-165),(647,14,420,-166),(648,14,421,-167),(649,14,422,-168),(650,14,423,-169),(651,14,424,-170),(652,14,425,-171),(653,14,426,-172),(654,14,427,-173),(655,14,428,-174),(656,14,429,-175),(657,14,430,-176),(658,16,431,-1),(659,16,432,-2),(660,16,433,-3),(661,16,434,-4),(662,16,435,-5),(663,16,436,-6),(664,16,437,-7),(665,16,438,-8),(666,16,439,-9),(667,16,440,-10),(668,16,441,-11),(669,16,442,-12),(670,16,443,-13),(671,16,444,-14),(672,16,445,-15),(673,16,446,-16),(674,16,447,-17),(675,36,447,-81),(676,2,447,-81),(677,16,448,-18),(678,36,448,-82),(679,2,448,-82),(680,16,449,-19),(681,36,449,-83),(682,2,449,-83),(683,16,450,-20),(684,36,450,-84),(685,2,450,-84),(686,16,451,-21),(687,36,451,-85),(688,2,451,-85),(689,16,452,-22),(690,36,452,-86),(691,2,452,-86),(692,16,453,-23),(693,36,453,-87),(694,2,453,-87),(695,16,454,-24),(696,36,454,-88),(697,2,454,-88),(698,16,455,-25),(699,36,455,-89),(700,2,455,-89),(701,16,456,-26),(702,36,456,-90),(703,2,456,-90),(704,16,457,-27),(705,36,457,-91),(706,2,457,-91),(707,16,458,-28),(708,36,458,-92),(709,2,458,-92),(710,16,459,-29),(711,36,459,-93),(712,2,459,-93),(713,16,460,-30),(714,36,460,-94),(715,2,460,-94),(716,16,461,-31),(717,36,461,-95),(718,2,461,-95),(719,16,462,-32),(720,36,462,-96),(721,2,462,-96),(722,16,463,-33),(723,16,464,-34),(724,16,465,-35),(725,16,466,-36),(726,16,467,-37),(727,16,468,-38),(728,16,469,-39),(729,16,470,-40),(730,16,471,-41),(731,16,472,-42),(732,16,473,-43),(733,16,474,-44),(734,16,475,-45),(735,16,476,-46),(736,16,477,-47),(737,16,478,-48),(738,16,479,-49),(739,16,480,-50),(740,16,481,-51),(741,16,482,-52),(742,16,483,-53),(743,16,484,-54),(744,16,485,-55),(745,16,486,-56),(746,16,487,-57),(747,16,488,-58),(748,16,489,-59),(749,16,490,-60),(750,16,491,-61),(751,16,492,-62),(752,16,493,-63),(753,16,494,-64),(754,16,495,-65),(755,16,496,-66),(756,16,497,-67),(757,16,498,-68),(758,16,499,-69),(759,16,500,-70),(760,16,501,-71),(761,16,502,-72),(762,16,503,-73),(763,16,504,-74),(764,16,505,-75),(765,16,506,-76),(766,16,507,-77),(767,16,508,-78),(768,16,509,-79),(769,16,510,-80),(770,16,511,-81),(771,16,512,-82),(772,16,513,-83),(773,16,514,-84),(774,16,515,-85),(775,16,516,-86),(776,16,517,-87),(777,16,518,-88),(778,16,519,-89),(779,16,520,-90),(780,16,521,-91),(781,16,522,-92),(782,16,523,-93),(783,16,524,-94),(784,16,525,-95),(785,16,526,-96),(786,16,527,-97),(787,16,528,-98),(788,16,529,-99),(789,16,530,-100),(790,16,531,-101),(791,16,532,-102),(792,16,533,-103),(793,16,534,-104),(794,16,535,-105),(795,16,536,-106),(796,16,537,-107),(797,16,538,-108),(798,16,539,-109),(799,16,540,-110),(800,16,541,-111),(801,16,542,-112),(802,16,543,-113),(803,16,544,-114),(804,16,545,-115),(805,16,546,-116),(806,16,547,-117),(807,16,548,-118),(808,16,549,-119),(809,16,550,-120),(810,16,551,-121),(811,16,552,-122),(812,16,553,-123),(813,16,554,-124),(814,16,555,-125),(815,16,556,-126),(816,16,557,-127),(817,16,558,-128),(818,16,559,-129),(819,16,560,-130),(820,16,561,-131),(821,16,562,-132),(822,16,563,-133),(823,16,564,-134),(824,16,565,-135),(825,16,566,-136),(826,16,567,-137),(827,16,568,-138),(828,16,569,-139),(829,16,570,-140),(830,16,571,-141),(831,16,572,-142),(832,16,573,-143),(833,16,574,-144),(834,16,575,-145),(835,16,576,-146),(836,16,577,-147),(837,16,578,-148),(838,16,579,-149),(839,16,580,-150),(840,16,581,-151),(841,16,582,-152),(842,16,583,-153),(843,16,584,-154),(844,16,585,-155),(845,16,586,-156),(846,16,587,-157),(847,16,588,-158),(848,16,589,-159),(849,16,590,-160),(850,16,591,-161),(851,16,592,-162),(852,16,593,-163),(853,16,594,-164),(854,16,595,-165),(855,16,596,-166),(856,16,597,-167),(857,16,598,-168),(858,16,599,-169),(859,16,600,-170),(860,16,601,-171),(861,16,602,-172),(862,16,603,-173),(863,16,604,-174),(864,16,605,-175),(865,16,606,-176),(866,16,607,-177),(867,16,608,-178),(868,16,609,-179),(869,16,610,-180),(870,16,611,-181),(871,16,612,-182),(872,16,613,-183),(873,16,614,-184),(874,16,615,-185),(875,16,616,-186),(876,16,617,-187),(877,16,618,-188),(878,16,619,-189),(879,16,620,-190),(880,16,621,-191),(881,16,622,-192),(882,17,623,-1),(883,17,624,-2),(884,17,625,-3),(885,17,626,-4),(886,17,627,-5),(887,17,628,-6),(888,17,629,-7),(889,17,630,-8),(890,17,631,-9),(891,17,632,-10),(892,17,633,-11),(893,17,634,-12),(894,17,635,-13),(895,17,636,-14),(896,17,637,-15),(897,17,638,-16),(898,17,639,-17),(899,17,640,-18),(900,17,641,-19),(901,17,642,-20),(902,17,643,-21),(903,17,644,-22),(904,17,645,-23),(905,17,646,-24),(906,17,647,-25),(907,17,648,-26),(908,17,649,-27),(909,17,650,-28),(910,17,651,-29),(911,17,652,-30),(912,17,653,-31),(913,17,654,-32),(914,17,655,-33),(915,17,656,-34),(916,17,657,-35),(917,17,658,-36),(918,17,659,-37),(919,17,660,-38),(920,17,661,-39),(921,17,662,-40),(922,17,663,-41),(923,17,664,-42),(924,17,665,-43),(925,17,666,-44),(926,17,667,-45),(927,17,668,-46),(928,17,669,-47),(929,17,670,-48),(930,17,671,-49),(931,17,672,-50),(932,17,673,-51),(933,17,674,-52),(934,17,675,-53),(935,17,676,-54),(936,17,677,-55),(937,17,678,-56),(938,17,679,-57),(939,17,680,-58),(940,17,681,-59),(941,17,682,-60),(942,17,683,-61),(943,17,684,-62),(944,17,685,-63),(945,17,686,-64),(946,17,687,-65),(947,17,688,-66),(948,17,689,-67),(949,36,689,-97),(950,2,689,-97),(951,17,690,-68),(952,36,690,-98),(953,2,690,-98),(954,17,691,-69),(955,36,691,-99),(956,2,691,-99),(957,17,692,-70),(958,36,692,-100),(959,2,692,-100),(960,17,693,-71),(961,36,693,-101),(962,2,693,-101),(963,17,694,-72),(964,36,694,-102),(965,2,694,-102),(966,17,695,-73),(967,17,696,-74),(968,17,697,-75),(969,17,698,-76),(970,17,699,-77),(971,17,700,-78),(972,17,701,-79),(973,17,702,-80),(974,17,703,-81),(975,17,704,-82),(976,17,705,-83),(977,17,706,-84),(978,17,707,-85),(979,17,708,-86),(980,17,709,-87),(981,17,710,-88),(982,17,711,-89),(983,17,712,-90),(984,17,713,-91),(985,36,713,-103),(986,2,713,-103),(987,17,714,-92),(988,36,714,-104),(989,2,714,-104),(990,17,715,-93),(991,36,715,-105),(992,2,715,-105),(993,17,716,-94),(994,36,716,-106),(995,2,716,-106),(996,17,717,-95),(997,36,717,-107),(998,2,717,-107),(999,17,718,-96),(1000,36,718,-108),(1001,2,718,-108),(1002,17,719,-97),(1003,17,720,-98),(1004,17,721,-99),(1005,17,722,-100),(1006,17,723,-101),(1007,17,724,-102),(1008,18,725,-1),(1009,32,725,-1),(1010,2,725,-109),(1011,18,726,-2),(1012,32,726,-2),(1013,2,726,-110),(1014,18,727,-3),(1015,32,727,-3),(1016,2,727,-111),(1017,18,728,-4),(1018,32,728,-4),(1019,2,728,-112),(1020,18,729,-5),(1021,32,729,-5),(1022,2,729,-113),(1023,18,730,-6),(1024,32,730,-6),(1025,2,730,-114),(1026,18,731,-7),(1027,32,731,-7),(1028,2,731,-115),(1029,18,732,-8),(1030,32,732,-8),(1031,2,732,-116),(1032,18,733,-9),(1033,32,733,-9),(1034,2,733,-117),(1035,18,734,-10),(1036,32,734,-10),(1037,2,734,-118),(1038,18,735,-11),(1039,32,735,-11),(1040,2,735,-119),(1041,18,736,-12),(1042,32,736,-12),(1043,2,736,-120),(1044,18,737,-13),(1045,32,737,-13),(1046,2,737,-121),(1047,18,738,-14),(1048,32,738,-14),(1049,35,738,-1),(1050,2,738,-122),(1051,18,739,-15),(1052,32,739,-15),(1053,35,739,-2),(1054,2,739,-123),(1055,18,740,-16),(1056,32,740,-16),(1057,35,740,-3),(1058,2,740,-124),(1059,18,741,-17),(1060,32,741,-17),(1061,35,741,-4),(1062,2,741,-125),(1063,18,742,-18),(1064,32,742,-18),(1065,35,742,-5),(1066,2,742,-126),(1067,18,743,-19),(1068,32,743,-19),(1069,35,743,-6),(1070,2,743,-127),(1071,18,744,-20),(1072,32,744,-20),(1073,35,744,-7),(1074,2,744,-128),(1075,18,745,-21),(1076,32,745,-21),(1077,35,745,-8),(1078,2,745,-129),(1079,18,746,-22),(1080,32,746,-22),(1081,35,746,-9),(1082,2,746,-130),(1083,18,747,-23),(1084,32,747,-23),(1085,35,747,-10),(1086,2,747,-131),(1087,18,748,-24),(1088,32,748,-24),(1089,35,748,-11),(1090,2,748,-132),(1091,18,749,-25),(1092,32,749,-25),(1093,35,749,-12),(1094,2,749,-133),(1095,18,750,-26),(1096,32,750,-26),(1097,35,750,-13),(1098,2,750,-134),(1099,18,751,-27),(1100,32,751,-27),(1101,8,751,-1),(1102,2,751,-135),(1103,18,752,-28),(1104,32,752,-28),(1105,8,752,-2),(1106,2,752,-136),(1107,18,753,-29),(1108,32,753,-29),(1109,8,753,-3),(1110,2,753,-137),(1111,18,754,-30),(1112,32,754,-30),(1113,8,754,-4),(1114,2,754,-138),(1115,18,755,-31),(1116,32,755,-31),(1117,8,755,-5),(1118,2,755,-139),(1119,18,756,-32),(1120,32,756,-32),(1121,8,756,-6),(1122,2,756,-140),(1123,18,757,-33),(1124,32,757,-33),(1125,8,757,-7),(1126,2,757,-141),(1127,18,758,-34),(1128,32,758,-34),(1129,8,758,-8),(1130,2,758,-142),(1131,18,759,-35),(1132,32,759,-35),(1133,8,759,-9),(1134,2,759,-143),(1135,18,760,-36),(1136,32,760,-36),(1137,8,760,-10),(1138,2,760,-144),(1139,18,761,-37),(1140,32,761,-37),(1141,8,761,-11),(1142,2,761,-145),(1143,18,762,-38),(1144,32,762,-38),(1145,8,762,-12),(1146,2,762,-146),(1147,18,763,-39),(1148,32,763,-39),(1149,8,763,-13),(1150,2,763,-147),(1151,18,764,-40),(1152,32,764,-40),(1153,2,764,-148),(1154,18,765,-41),(1155,32,765,-41),(1156,2,765,-149),(1157,18,766,-42),(1158,32,766,-42),(1159,2,766,-150),(1160,18,767,-43),(1161,32,767,-43),(1162,2,767,-151),(1163,18,768,-44),(1164,32,768,-44),(1165,2,768,-152),(1166,18,769,-45),(1167,32,769,-45),(1168,2,769,-153),(1169,18,770,-46),(1170,32,770,-46),(1171,2,770,-154),(1172,18,771,-47),(1173,32,771,-47),(1174,2,771,-155),(1175,18,772,-48),(1176,32,772,-48),(1177,2,772,-156),(1178,18,773,-49),(1179,32,773,-49),(1180,2,773,-157),(1181,18,774,-50),(1182,32,774,-50),(1183,2,774,-158),(1184,18,775,-51),(1185,32,775,-51),(1186,2,775,-159),(1187,18,776,-52),(1188,32,776,-52),(1189,2,776,-160),(1190,18,777,-53),(1191,32,777,-53),(1192,8,777,-14),(1193,2,777,-161),(1194,18,778,-54),(1195,32,778,-54),(1196,8,778,-15),(1197,2,778,-162),(1198,18,779,-55),(1199,32,779,-55),(1200,8,779,-16),(1201,2,779,-163),(1202,18,780,-56),(1203,32,780,-56),(1204,8,780,-17),(1205,2,780,-164),(1206,18,781,-57),(1207,32,781,-57),(1208,8,781,-18),(1209,2,781,-165),(1210,18,782,-58),(1211,32,782,-58),(1212,8,782,-19),(1213,2,782,-166),(1214,18,783,-59),(1215,32,783,-59),(1216,8,783,-20),(1217,2,783,-167),(1218,18,784,-60),(1219,32,784,-60),(1220,8,784,-21),(1221,2,784,-168),(1222,18,785,-61),(1223,32,785,-61),(1224,8,785,-22),(1225,2,785,-169),(1226,18,786,-62),(1227,32,786,-62),(1228,8,786,-23),(1229,2,786,-170),(1230,18,787,-63),(1231,32,787,-63),(1232,8,787,-24),(1233,2,787,-171),(1234,18,788,-64),(1235,32,788,-64),(1236,8,788,-25),(1237,2,788,-172),(1238,18,789,-65),(1239,32,789,-65),(1240,8,789,-26),(1241,2,789,-173),(1242,18,790,-66),(1243,32,790,-66),(1244,36,790,-109),(1245,2,790,-174),(1246,18,791,-67),(1247,32,791,-67),(1248,36,791,-110),(1249,2,791,-175),(1250,18,792,-68),(1251,32,792,-68),(1252,36,792,-111),(1253,2,792,-176),(1254,18,793,-69),(1255,32,793,-69),(1256,36,793,-112),(1257,2,793,-177),(1258,18,794,-70),(1259,32,794,-70),(1260,36,794,-113),(1261,2,794,-178),(1262,18,795,-71),(1263,32,795,-71),(1264,36,795,-114),(1265,2,795,-179),(1266,18,796,-72),(1267,32,796,-72),(1268,36,796,-115),(1269,2,796,-180),(1270,18,797,-73),(1271,32,797,-73),(1272,36,797,-116),(1273,2,797,-181),(1274,18,798,-74),(1275,32,798,-74),(1276,36,798,-117),(1277,2,798,-182),(1278,18,799,-75),(1279,32,799,-75),(1280,36,799,-118),(1281,2,799,-183),(1282,18,800,-76),(1283,32,800,-76),(1284,36,800,-119),(1285,2,800,-184),(1286,18,801,-77),(1287,32,801,-77),(1288,36,801,-120),(1289,2,801,-185),(1290,18,802,-78),(1291,32,802,-78),(1292,36,802,-121),(1293,2,802,-186),(1294,18,803,-79),(1295,32,803,-79),(1296,8,803,-27),(1297,2,803,-187),(1298,18,804,-80),(1299,32,804,-80),(1300,8,804,-28),(1301,2,804,-188),(1302,18,805,-81),(1303,32,805,-81),(1304,8,805,-29),(1305,2,805,-189),(1306,18,806,-82),(1307,32,806,-82),(1308,8,806,-30),(1309,2,806,-190),(1310,18,807,-83),(1311,32,807,-83),(1312,8,807,-31),(1313,2,807,-191),(1314,18,808,-84),(1315,32,808,-84),(1316,8,808,-32),(1317,2,808,-192),(1318,18,809,-85),(1319,32,809,-85),(1320,8,809,-33),(1321,2,809,-193),(1322,18,810,-86),(1323,32,810,-86),(1324,8,810,-34),(1325,2,810,-194),(1326,18,811,-87),(1327,32,811,-87),(1328,8,811,-35),(1329,2,811,-195),(1330,18,812,-88),(1331,32,812,-88),(1332,8,812,-36),(1333,2,812,-196),(1334,18,813,-89),(1335,32,813,-89),(1336,8,813,-37),(1337,2,813,-197),(1338,18,814,-90),(1339,32,814,-90),(1340,8,814,-38),(1341,2,814,-198),(1342,18,815,-91),(1343,32,815,-91),(1344,8,815,-39),(1345,2,815,-199),(1346,18,816,-92),(1347,32,816,-92),(1348,8,816,-40),(1349,2,816,-200),(1350,18,817,-93),(1351,32,817,-93),(1352,8,817,-41),(1353,2,817,-201),(1354,18,818,-94),(1355,32,818,-94),(1356,8,818,-42),(1357,2,818,-202),(1358,18,819,-95),(1359,32,819,-95),(1360,8,819,-43),(1361,2,819,-203),(1362,18,820,-96),(1363,32,820,-96),(1364,8,820,-44),(1365,2,820,-204),(1366,18,821,-97),(1367,32,821,-97),(1368,8,821,-45),(1369,2,821,-205),(1370,18,822,-98),(1371,32,822,-98),(1372,8,822,-46),(1373,2,822,-206),(1374,18,823,-99),(1375,32,823,-99),(1376,8,823,-47),(1377,2,823,-207),(1378,18,824,-100),(1379,32,824,-100),(1380,8,824,-48),(1381,2,824,-208),(1382,18,825,-101),(1383,32,825,-101),(1384,8,825,-49),(1385,2,825,-209),(1386,18,826,-102),(1387,32,826,-102),(1388,8,826,-50),(1389,2,826,-210),(1390,18,827,-103),(1391,32,827,-103),(1392,8,827,-51),(1393,2,827,-211),(1394,18,828,-104),(1395,32,828,-104),(1396,8,828,-52),(1397,2,828,-212),(1398,18,829,-105),(1399,32,829,-105),(1400,8,829,-53),(1401,34,829,-1),(1402,2,829,-213),(1403,18,830,-106),(1404,32,830,-106),(1405,8,830,-54),(1406,34,830,-2),(1407,2,830,-214),(1408,18,831,-107),(1409,32,831,-107),(1410,8,831,-55),(1411,34,831,-3),(1412,2,831,-215),(1413,18,832,-108),(1414,32,832,-108),(1415,8,832,-56),(1416,34,832,-4),(1417,2,832,-216),(1418,18,833,-109),(1419,32,833,-109),(1420,8,833,-57),(1421,34,833,-5),(1422,2,833,-217),(1423,18,834,-110),(1424,32,834,-110),(1425,8,834,-58),(1426,34,834,-6),(1427,2,834,-218),(1428,18,835,-111),(1429,32,835,-111),(1430,8,835,-59),(1431,34,835,-7),(1432,2,835,-219),(1433,18,836,-112),(1434,32,836,-112),(1435,8,836,-60),(1436,34,836,-8),(1437,2,836,-220),(1438,18,837,-113),(1439,32,837,-113),(1440,8,837,-61),(1441,34,837,-9),(1442,2,837,-221),(1443,18,838,-114),(1444,32,838,-114),(1445,8,838,-62),(1446,34,838,-10),(1447,2,838,-222),(1448,18,839,-115),(1449,32,839,-115),(1450,8,839,-63),(1451,34,839,-11),(1452,2,839,-223),(1453,18,840,-116),(1454,32,840,-116),(1455,8,840,-64),(1456,34,840,-12),(1457,2,840,-224),(1458,18,841,-117),(1459,32,841,-117),(1460,8,841,-65),(1461,34,841,-13),(1462,2,841,-225),(1463,18,842,-118),(1464,32,842,-118),(1465,34,842,-14),(1466,2,842,-226),(1467,18,843,-119),(1468,32,843,-119),(1469,34,843,-15),(1470,2,843,-227),(1471,18,844,-120),(1472,32,844,-120),(1473,34,844,-16),(1474,2,844,-228),(1475,18,845,-121),(1476,32,845,-121),(1477,34,845,-17),(1478,2,845,-229),(1479,18,846,-122),(1480,32,846,-122),(1481,34,846,-18),(1482,2,846,-230),(1483,18,847,-123),(1484,32,847,-123),(1485,34,847,-19),(1486,2,847,-231),(1487,18,848,-124),(1488,32,848,-124),(1489,34,848,-20),(1490,2,848,-232),(1491,18,849,-125),(1492,32,849,-125),(1493,34,849,-21),(1494,2,849,-233),(1495,18,850,-126),(1496,32,850,-126),(1497,34,850,-22),(1498,2,850,-234),(1499,18,851,-127),(1500,32,851,-127),(1501,34,851,-23),(1502,2,851,-235),(1503,18,852,-128),(1504,32,852,-128),(1505,34,852,-24),(1506,2,852,-236),(1507,18,853,-129),(1508,32,853,-129),(1509,34,853,-25),(1510,2,853,-237),(1511,18,854,-130),(1512,32,854,-130),(1513,34,854,-26),(1514,2,854,-238),(1515,18,855,-131),(1516,32,855,-131),(1517,34,855,-27),(1518,2,855,-239),(1519,18,856,-132),(1520,32,856,-132),(1521,34,856,-28),(1522,2,856,-240),(1523,18,857,-133),(1524,32,857,-133),(1525,34,857,-29),(1526,2,857,-241),(1527,18,858,-134),(1528,32,858,-134),(1529,34,858,-30),(1530,2,858,-242),(1531,18,859,-135),(1532,32,859,-135),(1533,34,859,-31),(1534,2,859,-243),(1535,18,860,-136),(1536,32,860,-136),(1537,34,860,-32),(1538,2,860,-244),(1539,18,861,-137),(1540,32,861,-137),(1541,34,861,-33),(1542,2,861,-245),(1543,18,862,-138),(1544,32,862,-138),(1545,34,862,-34),(1546,2,862,-246),(1547,18,863,-139),(1548,32,863,-139),(1549,34,863,-35),(1550,2,863,-247),(1551,18,864,-140),(1552,32,864,-140),(1553,34,864,-36),(1554,2,864,-248),(1555,18,865,-141),(1556,32,865,-141),(1557,34,865,-37),(1558,2,865,-249),(1559,18,866,-142),(1560,32,866,-142),(1561,34,866,-38),(1562,2,866,-250),(1563,18,867,-143),(1564,32,867,-143),(1565,34,867,-39),(1566,2,867,-251),(1567,18,868,-144),(1568,32,868,-144),(1569,2,868,-252),(1570,18,869,-145),(1571,32,869,-145),(1572,2,869,-253),(1573,18,870,-146),(1574,32,870,-146),(1575,2,870,-254),(1576,18,871,-147),(1577,32,871,-147),(1578,2,871,-255),(1579,18,872,-148),(1580,32,872,-148),(1581,2,872,-256),(1582,18,873,-149),(1583,32,873,-149),(1584,2,873,-257),(1585,18,874,-150),(1586,32,874,-150),(1587,2,874,-258),(1588,18,875,-151),(1589,32,875,-151),(1590,2,875,-259),(1591,18,876,-152),(1592,32,876,-152),(1593,2,876,-260),(1594,18,877,-153),(1595,32,877,-153),(1596,2,877,-261),(1597,18,878,-154),(1598,32,878,-154),(1599,2,878,-262),(1600,18,879,-155),(1601,32,879,-155),(1602,2,879,-263),(1603,18,880,-156),(1604,32,880,-156),(1605,2,880,-264),(1606,19,881,-1),(1607,34,881,-40),(1608,2,881,-265),(1609,19,882,-2),(1610,34,882,-41),(1611,2,882,-266),(1612,19,883,-3),(1613,34,883,-42),(1614,2,883,-267),(1615,19,884,-4),(1616,34,884,-43),(1617,2,884,-268),(1618,19,885,-5),(1619,34,885,-44),(1620,2,885,-269),(1621,19,886,-6),(1622,34,886,-45),(1623,2,886,-270),(1624,19,887,-7),(1625,34,887,-46),(1626,2,887,-271),(1627,19,888,-8),(1628,34,888,-47),(1629,2,888,-272),(1630,19,889,-9),(1631,34,889,-48),(1632,2,889,-273),(1633,19,890,-10),(1634,34,890,-49),(1635,2,890,-274),(1636,19,891,-11),(1637,34,891,-50),(1638,2,891,-275),(1639,19,892,-12),(1640,34,892,-51),(1641,2,892,-276),(1642,19,893,-13),(1643,34,893,-52),(1644,2,893,-277),(1645,19,894,-14),(1646,19,895,-15),(1647,19,896,-16),(1648,19,897,-17),(1649,19,898,-18),(1650,19,899,-19),(1651,35,899,-14),(1652,2,899,-278),(1653,19,900,-20),(1654,35,900,-15),(1655,2,900,-279),(1656,19,901,-21),(1657,35,901,-16),(1658,2,901,-280),(1659,19,902,-22),(1660,35,902,-17),(1661,2,902,-281),(1662,19,903,-23),(1663,35,903,-18),(1664,2,903,-282),(1665,19,904,-24),(1666,35,904,-19),(1667,2,904,-283),(1668,19,905,-25),(1669,35,905,-20),(1670,2,905,-284),(1671,19,906,-26),(1672,35,906,-21),(1673,2,906,-285),(1674,19,907,-27),(1675,35,907,-22),(1676,2,907,-286),(1677,19,908,-28),(1678,35,908,-23),(1679,2,908,-287),(1680,19,909,-29),(1681,35,909,-24),(1682,2,909,-288),(1683,19,910,-30),(1684,35,910,-25),(1685,2,910,-289),(1686,19,911,-31),(1687,35,911,-26),(1688,2,911,-290),(1689,19,912,-32),(1690,19,913,-33),(1691,19,914,-34),(1692,19,915,-35),(1693,19,916,-36),(1694,19,917,-37),(1695,19,918,-38),(1696,19,919,-39),(1697,19,920,-40),(1698,19,921,-41),(1699,19,922,-42),(1700,19,923,-43),(1701,19,924,-44),(1702,19,925,-45),(1703,35,925,-27),(1704,2,925,-291),(1705,19,926,-46),(1706,35,926,-28),(1707,2,926,-292),(1708,19,927,-47),(1709,35,927,-29),(1710,2,927,-293),(1711,19,928,-48),(1712,35,928,-30),(1713,2,928,-294),(1714,19,929,-49),(1715,35,929,-31),(1716,2,929,-295),(1717,19,930,-50),(1718,35,930,-32),(1719,2,930,-296),(1720,19,931,-51),(1721,35,931,-33),(1722,2,931,-297),(1723,19,932,-52),(1724,35,932,-34),(1725,2,932,-298),(1726,19,933,-53),(1727,35,933,-35),(1728,2,933,-299),(1729,19,934,-54),(1730,35,934,-36),(1731,2,934,-300),(1732,19,935,-55),(1733,35,935,-37),(1734,2,935,-301),(1735,19,936,-56),(1736,35,936,-38),(1737,2,936,-302),(1738,19,937,-57),(1739,35,937,-39),(1740,2,937,-303),(1741,19,938,-58),(1742,8,938,-66),(1743,2,938,-304),(1744,19,939,-59),(1745,8,939,-67),(1746,2,939,-305),(1747,19,940,-60),(1748,8,940,-68),(1749,2,940,-306),(1750,19,941,-61),(1751,8,941,-69),(1752,2,941,-307),(1753,19,942,-62),(1754,8,942,-70),(1755,2,942,-308),(1756,19,943,-63),(1757,8,943,-71),(1758,2,943,-309),(1759,19,944,-64),(1760,8,944,-72),(1761,2,944,-310),(1762,19,945,-65),(1763,8,945,-73),(1764,2,945,-311),(1765,19,946,-66),(1766,8,946,-74),(1767,2,946,-312),(1768,19,947,-67),(1769,8,947,-75),(1770,2,947,-313),(1771,19,948,-68),(1772,8,948,-76),(1773,2,948,-314),(1774,19,949,-69),(1775,8,949,-77),(1776,2,949,-315),(1777,19,950,-70),(1778,8,950,-78),(1779,2,950,-316),(1780,19,951,-71),(1781,31,951,-1),(1782,34,951,-53),(1783,2,951,-317),(1784,19,952,-72),(1785,31,952,-2),(1786,34,952,-54),(1787,2,952,-318),(1788,19,953,-73),(1789,31,953,-3),(1790,34,953,-55),(1791,2,953,-319),(1792,19,954,-74),(1793,31,954,-4),(1794,34,954,-56),(1795,2,954,-320),(1796,19,955,-75),(1797,31,955,-5),(1798,34,955,-57),(1799,2,955,-321),(1800,19,956,-76),(1801,31,956,-6),(1802,34,956,-58),(1803,2,956,-322),(1804,19,957,-77),(1805,31,957,-7),(1806,34,957,-59),(1807,2,957,-323),(1808,19,958,-78),(1809,31,958,-8),(1810,34,958,-60),(1811,2,958,-324),(1812,19,959,-79),(1813,31,959,-9),(1814,34,959,-61),(1815,2,959,-325),(1816,19,960,-80),(1817,31,960,-10),(1818,34,960,-62),(1819,2,960,-326),(1820,19,961,-81),(1821,31,961,-11),(1822,34,961,-63),(1823,2,961,-327),(1824,19,962,-82),(1825,31,962,-12),(1826,34,962,-64),(1827,2,962,-328),(1828,19,963,-83),(1829,31,963,-13),(1830,34,963,-65),(1831,2,963,-329),(1832,19,964,-84),(1833,31,964,-14),(1834,2,964,-330),(1835,19,965,-85),(1836,31,965,-15),(1837,2,965,-331),(1838,19,966,-86),(1839,31,966,-16),(1840,2,966,-332),(1841,19,967,-87),(1842,31,967,-17),(1843,2,967,-333),(1844,19,968,-88),(1845,31,968,-18),(1846,2,968,-334),(1847,19,969,-89),(1848,31,969,-19),(1849,2,969,-335),(1850,19,970,-90),(1851,31,970,-20),(1852,2,970,-336),(1853,19,971,-91),(1854,31,971,-21),(1855,2,971,-337),(1856,19,972,-92),(1857,31,972,-22),(1858,2,972,-338),(1859,19,973,-93),(1860,31,973,-23),(1861,2,973,-339),(1862,19,974,-94),(1863,31,974,-24),(1864,2,974,-340),(1865,19,975,-95),(1866,31,975,-25),(1867,2,975,-341),(1868,19,976,-96),(1869,31,976,-26),(1870,2,976,-342),(1871,19,977,-97),(1872,35,977,-40),(1873,2,977,-343),(1874,19,978,-98),(1875,35,978,-41),(1876,2,978,-344),(1877,19,979,-99),(1878,35,979,-42),(1879,2,979,-345),(1880,19,980,-100),(1881,35,980,-43),(1882,2,980,-346),(1883,19,981,-101),(1884,35,981,-44),(1885,2,981,-347),(1886,19,982,-102),(1887,35,982,-45),(1888,2,982,-348),(1889,19,983,-103),(1890,35,983,-46),(1891,2,983,-349),(1892,19,984,-104),(1893,35,984,-47),(1894,2,984,-350),(1895,19,985,-105),(1896,35,985,-48),(1897,2,985,-351),(1898,19,986,-106),(1899,35,986,-49),(1900,2,986,-352),(1901,19,987,-107),(1902,35,987,-50),(1903,2,987,-353),(1904,19,988,-108),(1905,35,988,-51),(1906,2,988,-354),(1907,19,989,-109),(1908,35,989,-52),(1909,2,989,-355),(1910,19,990,-110),(1911,8,990,-79),(1912,2,990,-356),(1913,19,991,-111),(1914,8,991,-80),(1915,2,991,-357),(1916,19,992,-112),(1917,8,992,-81),(1918,2,992,-358),(1919,19,993,-113),(1920,8,993,-82),(1921,2,993,-359),(1922,19,994,-114),(1923,8,994,-83),(1924,2,994,-360),(1925,19,995,-115),(1926,8,995,-84),(1927,2,995,-361),(1928,19,996,-116),(1929,8,996,-85),(1930,2,996,-362),(1931,19,997,-117),(1932,8,997,-86),(1933,2,997,-363),(1934,19,998,-118),(1935,8,998,-87),(1936,2,998,-364),(1937,19,999,-119),(1938,8,999,-88),(1939,2,999,-365),(1940,19,1000,-120),(1941,8,1000,-89),(1942,2,1000,-366),(1943,19,1001,-121),(1944,8,1001,-90),(1945,2,1001,-367),(1946,19,1002,-122),(1947,8,1002,-91),(1948,2,1002,-368),(1949,19,1003,-123),(1950,19,1004,-124),(1951,19,1005,-125),(1952,19,1006,-126),(1953,19,1007,-127),(1954,19,1008,-128),(1955,19,1009,-129),(1956,19,1010,-130),(1957,19,1011,-131),(1958,19,1012,-132),(1959,19,1013,-133),(1960,19,1014,-134),(1961,19,1015,-135),(1962,19,1016,-136),(1963,31,1016,-27),(1964,2,1016,-369),(1965,19,1017,-137),(1966,31,1017,-28),(1967,2,1017,-370),(1968,19,1018,-138),(1969,31,1018,-29),(1970,2,1018,-371),(1971,19,1019,-139),(1972,31,1019,-30),(1973,2,1019,-372),(1974,19,1020,-140),(1975,31,1020,-31),(1976,2,1020,-373),(1977,19,1021,-141),(1978,31,1021,-32),(1979,2,1021,-374),(1980,19,1022,-142),(1981,31,1022,-33),(1982,2,1022,-375),(1983,19,1023,-143),(1984,31,1023,-34),(1985,2,1023,-376),(1986,19,1024,-144),(1987,31,1024,-35),(1988,2,1024,-377),(1989,19,1025,-145),(1990,31,1025,-36),(1991,2,1025,-378),(1992,19,1026,-146),(1993,31,1026,-37),(1994,2,1026,-379),(1995,19,1027,-147),(1996,31,1027,-38),(1997,2,1027,-380),(1998,19,1028,-148),(1999,31,1028,-39),(2000,2,1028,-381),(2001,24,1029,-1),(2002,8,1029,-92),(2003,34,1029,-66),(2004,2,1029,-382),(2005,24,1030,-2),(2006,8,1030,-93),(2007,34,1030,-67),(2008,2,1030,-383),(2009,24,1031,-3),(2010,8,1031,-94),(2011,34,1031,-68),(2012,2,1031,-384),(2013,24,1032,-4),(2014,8,1032,-95),(2015,34,1032,-69),(2016,2,1032,-385),(2017,24,1033,-5),(2018,8,1033,-96),(2019,34,1033,-70),(2020,2,1033,-386),(2021,24,1034,-6),(2022,8,1034,-97),(2023,34,1034,-71),(2024,2,1034,-387),(2025,24,1035,-7),(2026,8,1035,-98),(2027,34,1035,-72),(2028,2,1035,-388),(2029,24,1036,-8),(2030,8,1036,-99),(2031,34,1036,-73),(2032,2,1036,-389),(2033,24,1037,-9),(2034,8,1037,-100),(2035,34,1037,-74),(2036,2,1037,-390),(2037,24,1038,-10),(2038,8,1038,-101),(2039,34,1038,-75),(2040,2,1038,-391),(2041,24,1039,-11),(2042,8,1039,-102),(2043,34,1039,-76),(2044,2,1039,-392),(2045,24,1040,-12),(2046,8,1040,-103),(2047,34,1040,-77),(2048,2,1040,-393),(2049,24,1041,-13),(2050,8,1041,-104),(2051,34,1041,-78),(2052,2,1041,-394),(2053,24,1042,-14),(2054,8,1042,-105),(2055,34,1042,-79),(2056,2,1042,-395),(2057,24,1043,-15),(2058,8,1043,-106),(2059,34,1043,-80),(2060,2,1043,-396),(2061,24,1044,-16),(2062,8,1044,-107),(2063,34,1044,-81),(2064,2,1044,-397),(2065,24,1045,-17),(2066,30,1045,-1),(2067,2,1045,-398),(2068,24,1046,-18),(2069,30,1046,-2),(2070,2,1046,-399),(2071,24,1047,-19),(2072,30,1047,-3),(2073,2,1047,-400),(2074,24,1048,-20),(2075,30,1048,-4),(2076,2,1048,-401),(2077,24,1049,-21),(2078,30,1049,-5),(2079,2,1049,-402),(2080,24,1050,-22),(2081,30,1050,-6),(2082,2,1050,-403),(2083,24,1051,-23),(2084,30,1051,-7),(2085,2,1051,-404),(2086,24,1052,-24),(2087,30,1052,-8),(2088,2,1052,-405),(2089,24,1053,-25),(2090,30,1053,-9),(2091,2,1053,-406),(2092,24,1054,-26),(2093,30,1054,-10),(2094,2,1054,-407),(2095,24,1055,-27),(2096,30,1055,-11),(2097,2,1055,-408),(2098,24,1056,-28),(2099,30,1056,-12),(2100,2,1056,-409),(2101,24,1057,-29),(2102,30,1057,-13),(2103,2,1057,-410),(2104,24,1058,-30),(2105,30,1058,-14),(2106,2,1058,-411),(2107,24,1059,-31),(2108,30,1059,-15),(2109,2,1059,-412),(2110,24,1060,-32),(2111,30,1060,-16),(2112,2,1060,-413),(2113,24,1061,-33),(2114,24,1062,-34),(2115,24,1063,-35),(2116,24,1064,-36),(2117,24,1065,-37),(2118,24,1066,-38),(2119,24,1067,-39),(2120,24,1068,-40),(2121,24,1069,-41),(2122,24,1070,-42),(2123,24,1071,-43),(2124,24,1072,-44),(2125,24,1073,-45),(2126,24,1074,-46),(2127,24,1075,-47),(2128,24,1076,-48),(2129,24,1077,-49),(2130,24,1078,-50),(2131,24,1079,-51),(2132,24,1080,-52),(2133,24,1081,-53),(2134,24,1082,-54),(2135,24,1083,-55),(2136,24,1084,-56),(2137,24,1085,-57),(2138,24,1086,-58),(2139,24,1087,-59),(2140,24,1088,-60),(2141,24,1089,-61),(2142,24,1090,-62),(2143,24,1091,-63),(2144,24,1092,-64),(2145,24,1093,-65),(2146,24,1094,-66),(2147,24,1095,-67),(2148,24,1096,-68),(2149,24,1097,-69),(2150,24,1098,-70),(2151,24,1099,-71),(2152,24,1100,-72),(2153,24,1101,-73),(2154,24,1102,-74),(2155,24,1103,-75),(2156,24,1104,-76),(2157,24,1105,-77),(2158,24,1106,-78),(2159,24,1107,-79),(2160,24,1108,-80),(2161,24,1109,-81),(2162,24,1110,-82),(2163,24,1111,-83),(2164,24,1112,-84),(2165,24,1113,-85),(2166,24,1114,-86),(2167,24,1115,-87),(2168,8,1115,-108),(2169,34,1115,-82),(2170,2,1115,-414),(2171,24,1116,-88),(2172,8,1116,-109),(2173,34,1116,-83),(2174,2,1116,-415),(2175,24,1117,-89),(2176,8,1117,-110),(2177,34,1117,-84),(2178,2,1117,-416),(2179,24,1118,-90),(2180,8,1118,-111),(2181,34,1118,-85),(2182,2,1118,-417),(2183,24,1119,-91),(2184,8,1119,-112),(2185,34,1119,-86),(2186,2,1119,-418),(2187,24,1120,-92),(2188,8,1120,-113),(2189,34,1120,-87),(2190,2,1120,-419),(2191,24,1121,-93),(2192,8,1121,-114),(2193,34,1121,-88),(2194,2,1121,-420),(2195,24,1122,-94),(2196,8,1122,-115),(2197,34,1122,-89),(2198,2,1122,-421),(2199,24,1123,-95),(2200,8,1123,-116),(2201,34,1123,-90),(2202,2,1123,-422),(2203,24,1124,-96),(2204,8,1124,-117),(2205,34,1124,-91),(2206,2,1124,-423),(2207,24,1125,-97),(2208,8,1125,-118),(2209,34,1125,-92),(2210,2,1125,-424),(2211,24,1126,-98),(2212,8,1126,-119),(2213,34,1126,-93),(2214,2,1126,-425),(2215,24,1127,-99),(2216,8,1127,-120),(2217,34,1127,-94),(2218,2,1127,-426),(2219,24,1128,-100),(2220,8,1128,-121),(2221,34,1128,-95),(2222,2,1128,-427),(2223,24,1129,-101),(2224,8,1129,-122),(2225,34,1129,-96),(2226,2,1129,-428),(2227,24,1130,-102),(2228,8,1130,-123),(2229,34,1130,-97),(2230,2,1130,-429),(2231,24,1131,-103),(2232,30,1131,-17),(2233,35,1131,-53),(2234,2,1131,-430),(2235,24,1132,-104),(2236,30,1132,-18),(2237,35,1132,-54),(2238,2,1132,-431),(2239,24,1133,-105),(2240,30,1133,-19),(2241,35,1133,-55),(2242,2,1133,-432),(2243,24,1134,-106),(2244,30,1134,-20),(2245,35,1134,-56),(2246,2,1134,-433),(2247,24,1135,-107),(2248,30,1135,-21),(2249,35,1135,-57),(2250,2,1135,-434),(2251,24,1136,-108),(2252,30,1136,-22),(2253,35,1136,-58),(2254,2,1136,-435),(2255,24,1137,-109),(2256,30,1137,-23),(2257,35,1137,-59),(2258,2,1137,-436),(2259,24,1138,-110),(2260,30,1138,-24),(2261,35,1138,-60),(2262,2,1138,-437),(2263,24,1139,-111),(2264,30,1139,-25),(2265,35,1139,-61),(2266,2,1139,-438),(2267,24,1140,-112),(2268,30,1140,-26),(2269,35,1140,-62),(2270,2,1140,-439),(2271,24,1141,-113),(2272,30,1141,-27),(2273,35,1141,-63),(2274,2,1141,-440),(2275,24,1142,-114),(2276,30,1142,-28),(2277,35,1142,-64),(2278,2,1142,-441),(2279,24,1143,-115),(2280,30,1143,-29),(2281,35,1143,-65),(2282,2,1143,-442),(2283,24,1144,-116),(2284,30,1144,-30),(2285,35,1144,-66),(2286,2,1144,-443),(2287,24,1145,-117),(2288,30,1145,-31),(2289,35,1145,-67),(2290,2,1145,-444),(2291,24,1146,-118),(2292,30,1146,-32),(2293,35,1146,-68),(2294,2,1146,-445),(2295,24,1147,-119),(2296,36,1147,-122),(2297,2,1147,-446),(2298,24,1148,-120),(2299,36,1148,-123),(2300,2,1148,-447),(2301,24,1149,-121),(2302,36,1149,-124),(2303,2,1149,-448),(2304,24,1150,-122),(2305,36,1150,-125),(2306,2,1150,-449),(2307,24,1151,-123),(2308,36,1151,-126),(2309,2,1151,-450),(2310,24,1152,-124),(2311,36,1152,-127),(2312,2,1152,-451),(2313,24,1153,-125),(2314,36,1153,-128),(2315,2,1153,-452),(2316,24,1154,-126),(2317,36,1154,-129),(2318,2,1154,-453),(2319,24,1155,-127),(2320,36,1155,-130),(2321,2,1155,-454),(2322,24,1156,-128),(2323,36,1156,-131),(2324,2,1156,-455),(2325,24,1157,-129),(2326,36,1157,-132),(2327,2,1157,-456),(2328,24,1158,-130),(2329,36,1158,-133),(2330,2,1158,-457),(2331,24,1159,-131),(2332,36,1159,-134),(2333,2,1159,-458),(2334,24,1160,-132),(2335,36,1160,-135),(2336,2,1160,-459),(2337,24,1161,-133),(2338,36,1161,-136),(2339,2,1161,-460),(2340,24,1162,-134),(2341,36,1162,-137),(2342,2,1162,-461),(2343,24,1163,-135),(2344,8,1163,-124),(2345,2,1163,-462),(2346,24,1164,-136),(2347,8,1164,-125),(2348,2,1164,-463),(2349,24,1165,-137),(2350,8,1165,-126),(2351,2,1165,-464),(2352,24,1166,-138),(2353,8,1166,-127),(2354,2,1166,-465),(2355,24,1167,-139),(2356,8,1167,-128),(2357,2,1167,-466),(2358,24,1168,-140),(2359,8,1168,-129),(2360,2,1168,-467),(2361,24,1169,-141),(2362,8,1169,-130),(2363,2,1169,-468),(2364,24,1170,-142),(2365,8,1170,-131),(2366,2,1170,-469),(2367,24,1171,-143),(2368,8,1171,-132),(2369,2,1171,-470),(2370,24,1172,-144),(2371,8,1172,-133),(2372,2,1172,-471),(2373,24,1173,-145),(2374,8,1173,-134),(2375,2,1173,-472),(2376,24,1174,-146),(2377,8,1174,-135),(2378,2,1174,-473),(2379,24,1175,-147),(2380,8,1175,-136),(2381,2,1175,-474),(2382,24,1176,-148),(2383,8,1176,-137),(2384,2,1176,-475),(2385,24,1177,-149),(2386,8,1177,-138),(2387,2,1177,-476),(2388,24,1178,-150),(2389,8,1178,-139),(2390,2,1178,-477),(2391,24,1179,-151),(2392,34,1179,-98),(2393,2,1179,-478),(2394,24,1180,-152),(2395,34,1180,-99),(2396,2,1180,-479),(2397,24,1181,-153),(2398,34,1181,-100),(2399,2,1181,-480),(2400,24,1182,-154),(2401,34,1182,-101),(2402,2,1182,-481),(2403,24,1183,-155),(2404,34,1183,-102),(2405,2,1183,-482),(2406,24,1184,-156),(2407,34,1184,-103),(2408,2,1184,-483),(2409,24,1185,-157),(2410,34,1185,-104),(2411,2,1185,-484),(2412,24,1186,-158),(2413,34,1186,-105),(2414,2,1186,-485),(2415,24,1187,-159),(2416,34,1187,-106),(2417,2,1187,-486),(2418,24,1188,-160),(2419,34,1188,-107),(2420,2,1188,-487),(2421,24,1189,-161),(2422,34,1189,-108),(2423,2,1189,-488),(2424,24,1190,-162),(2425,34,1190,-109),(2426,2,1190,-489),(2427,24,1191,-163),(2428,34,1191,-110),(2429,2,1191,-490),(2430,24,1192,-164),(2431,34,1192,-111),(2432,2,1192,-491),(2433,24,1193,-165),(2434,34,1193,-112),(2435,2,1193,-492),(2436,24,1194,-166),(2437,34,1194,-113),(2438,2,1194,-493),(2439,24,1195,-167),(2440,35,1195,-69),(2441,2,1195,-494),(2442,24,1196,-168),(2443,35,1196,-70),(2444,2,1196,-495),(2445,24,1197,-169),(2446,35,1197,-71),(2447,2,1197,-496),(2448,24,1198,-170),(2449,35,1198,-72),(2450,2,1198,-497),(2451,24,1199,-171),(2452,35,1199,-73),(2453,2,1199,-498),(2454,24,1200,-172),(2455,35,1200,-74),(2456,2,1200,-499),(2457,24,1201,-173),(2458,35,1201,-75),(2459,2,1201,-500),(2460,24,1202,-174),(2461,35,1202,-76),(2462,2,1202,-501),(2463,24,1203,-175),(2464,35,1203,-77),(2465,2,1203,-502),(2466,24,1204,-176),(2467,35,1204,-78),(2468,2,1204,-503),(2469,24,1205,-177),(2470,35,1205,-79),(2471,2,1205,-504),(2472,24,1206,-178),(2473,35,1206,-80),(2474,2,1206,-505),(2475,24,1207,-179),(2476,35,1207,-81),(2477,2,1207,-506),(2478,24,1208,-180),(2479,35,1208,-82),(2480,2,1208,-507),(2481,24,1209,-181),(2482,35,1209,-83),(2483,2,1209,-508),(2484,24,1210,-182),(2485,35,1210,-84),(2486,2,1210,-509),(2487,23,1211,-1),(2488,8,1211,-140),(2489,34,1211,-114),(2490,2,1211,-510),(2491,23,1212,-2),(2492,8,1212,-141),(2493,34,1212,-115),(2494,2,1212,-511),(2495,23,1213,-3),(2496,8,1213,-142),(2497,34,1213,-116),(2498,2,1213,-512),(2499,23,1214,-4),(2500,8,1214,-143),(2501,34,1214,-117),(2502,2,1214,-513),(2503,23,1215,-5),(2504,8,1215,-144),(2505,34,1215,-118),(2506,2,1215,-514),(2507,23,1216,-6),(2508,8,1216,-145),(2509,34,1216,-119),(2510,2,1216,-515),(2511,23,1217,-7),(2512,8,1217,-146),(2513,34,1217,-120),(2514,2,1217,-516),(2515,23,1218,-8),(2516,8,1218,-147),(2517,34,1218,-121),(2518,2,1218,-517),(2519,23,1219,-9),(2520,8,1219,-148),(2521,34,1219,-122),(2522,2,1219,-518),(2523,23,1220,-10),(2524,8,1220,-149),(2525,34,1220,-123),(2526,2,1220,-519),(2527,23,1221,-11),(2528,30,1221,-33),(2529,2,1221,-520),(2530,23,1222,-12),(2531,30,1222,-34),(2532,2,1222,-521),(2533,23,1223,-13),(2534,30,1223,-35),(2535,2,1223,-522),(2536,23,1224,-14),(2537,30,1224,-36),(2538,2,1224,-523),(2539,23,1225,-15),(2540,30,1225,-37),(2541,2,1225,-524),(2542,23,1226,-16),(2543,30,1226,-38),(2544,2,1226,-525),(2545,23,1227,-17),(2546,30,1227,-39),(2547,2,1227,-526),(2548,23,1228,-18),(2549,30,1228,-40),(2550,2,1228,-527),(2551,23,1229,-19),(2552,30,1229,-41),(2553,2,1229,-528),(2554,23,1230,-20),(2555,30,1230,-42),(2556,2,1230,-529),(2557,23,1231,-21),(2558,30,1231,-43),(2559,2,1231,-530),(2560,23,1232,-22),(2561,30,1232,-44),(2562,2,1232,-531),(2563,23,1233,-23),(2564,30,1233,-45),(2565,2,1233,-532),(2566,23,1234,-24),(2567,30,1234,-46),(2568,2,1234,-533),(2569,23,1235,-25),(2570,30,1235,-47),(2571,2,1235,-534),(2572,23,1236,-26),(2573,30,1236,-48),(2574,2,1236,-535),(2575,23,1237,-27),(2576,23,1238,-28),(2577,23,1239,-29),(2578,23,1240,-30),(2579,23,1241,-31),(2580,23,1242,-32),(2581,23,1243,-33),(2582,23,1244,-34),(2583,23,1245,-35),(2584,23,1246,-36),(2585,23,1247,-37),(2586,23,1248,-38),(2587,23,1249,-39),(2588,23,1250,-40),(2589,23,1251,-41),(2590,23,1252,-42),(2591,23,1253,-43),(2592,8,1253,-150),(2593,35,1253,-85),(2594,2,1253,-536),(2595,23,1254,-44),(2596,8,1254,-151),(2597,35,1254,-86),(2598,2,1254,-537),(2599,23,1255,-45),(2600,8,1255,-152),(2601,35,1255,-87),(2602,2,1255,-538),(2603,23,1256,-46),(2604,8,1256,-153),(2605,35,1256,-88),(2606,2,1256,-539),(2607,23,1257,-47),(2608,8,1257,-154),(2609,35,1257,-89),(2610,2,1257,-540),(2611,23,1258,-48),(2612,8,1258,-155),(2613,35,1258,-90),(2614,2,1258,-541),(2615,23,1259,-49),(2616,8,1259,-156),(2617,35,1259,-91),(2618,2,1259,-542),(2619,23,1260,-50),(2620,8,1260,-157),(2621,35,1260,-92),(2622,2,1260,-543),(2623,23,1261,-51),(2624,8,1261,-158),(2625,35,1261,-93),(2626,2,1261,-544),(2627,23,1262,-52),(2628,8,1262,-159),(2629,35,1262,-94),(2630,2,1262,-545),(2631,23,1263,-53),(2632,8,1263,-160),(2633,35,1263,-95),(2634,2,1263,-546),(2635,23,1264,-54),(2636,8,1264,-161),(2637,35,1264,-96),(2638,2,1264,-547),(2639,23,1265,-55),(2640,8,1265,-162),(2641,35,1265,-97),(2642,2,1265,-548),(2643,23,1266,-56),(2644,8,1266,-163),(2645,35,1266,-98),(2646,2,1266,-549),(2647,23,1267,-57),(2648,8,1267,-164),(2649,35,1267,-99),(2650,2,1267,-550),(2651,23,1268,-58),(2652,8,1268,-165),(2653,35,1268,-100),(2654,2,1268,-551),(2655,23,1269,-59),(2656,23,1270,-60),(2657,23,1271,-61),(2658,23,1272,-62),(2659,23,1273,-63),(2660,23,1274,-64),(2661,23,1275,-65),(2662,23,1276,-66),(2663,23,1277,-67),(2664,23,1278,-68),(2665,23,1279,-69),(2666,23,1280,-70),(2667,23,1281,-71),(2668,23,1282,-72),(2669,23,1283,-73),(2670,23,1284,-74),(2671,23,1285,-75),(2672,23,1286,-76),(2673,23,1287,-77),(2674,23,1288,-78),(2675,23,1289,-79),(2676,23,1290,-80),(2677,23,1291,-81),(2678,23,1292,-82),(2679,23,1293,-83),(2680,23,1294,-84),(2681,23,1295,-85),(2682,23,1296,-86),(2683,23,1297,-87),(2684,23,1298,-88),(2685,23,1299,-89),(2686,23,1300,-90),(2687,23,1301,-91),(2688,30,1301,-49),(2689,34,1301,-124),(2690,2,1301,-552),(2691,23,1302,-92),(2692,30,1302,-50),(2693,34,1302,-125),(2694,2,1302,-553),(2695,23,1303,-93),(2696,30,1303,-51),(2697,34,1303,-126),(2698,2,1303,-554),(2699,23,1304,-94),(2700,30,1304,-52),(2701,34,1304,-127),(2702,2,1304,-555),(2703,23,1305,-95),(2704,30,1305,-53),(2705,34,1305,-128),(2706,2,1305,-556),(2707,23,1306,-96),(2708,30,1306,-54),(2709,34,1306,-129),(2710,2,1306,-557),(2711,23,1307,-97),(2712,30,1307,-55),(2713,34,1307,-130),(2714,2,1307,-558),(2715,23,1308,-98),(2716,30,1308,-56),(2717,34,1308,-131),(2718,2,1308,-559),(2719,23,1309,-99),(2720,30,1309,-57),(2721,34,1309,-132),(2722,2,1309,-560),(2723,23,1310,-100),(2724,30,1310,-58),(2725,34,1310,-133),(2726,2,1310,-561),(2727,23,1311,-101),(2728,30,1311,-59),(2729,34,1311,-134),(2730,2,1311,-562),(2731,23,1312,-102),(2732,30,1312,-60),(2733,34,1312,-135),(2734,2,1312,-563),(2735,23,1313,-103),(2736,30,1313,-61),(2737,34,1313,-136),(2738,2,1313,-564),(2739,23,1314,-104),(2740,30,1314,-62),(2741,34,1314,-137),(2742,2,1314,-565),(2743,23,1315,-105),(2744,30,1315,-63),(2745,34,1315,-138),(2746,2,1315,-566),(2747,23,1316,-106),(2748,30,1316,-64),(2749,34,1316,-139),(2750,2,1316,-567),(2751,23,1317,-107),(2752,34,1317,-140),(2753,2,1317,-568),(2754,23,1318,-108),(2755,34,1318,-141),(2756,2,1318,-569),(2757,23,1319,-109),(2758,34,1319,-142),(2759,2,1319,-570),(2760,23,1320,-110),(2761,34,1320,-143),(2762,2,1320,-571),(2763,23,1321,-111),(2764,34,1321,-144),(2765,2,1321,-572),(2766,23,1322,-112),(2767,34,1322,-145),(2768,2,1322,-573),(2769,23,1323,-113),(2770,34,1323,-146),(2771,2,1323,-574),(2772,23,1324,-114),(2773,34,1324,-147),(2774,2,1324,-575),(2775,23,1325,-115),(2776,34,1325,-148),(2777,2,1325,-576),(2778,23,1326,-116),(2779,34,1326,-149),(2780,2,1326,-577),(2781,23,1327,-117),(2782,34,1327,-150),(2783,2,1327,-578),(2784,23,1328,-118),(2785,34,1328,-151),(2786,2,1328,-579),(2787,23,1329,-119),(2788,34,1329,-152),(2789,2,1329,-580),(2790,23,1330,-120),(2791,34,1330,-153),(2792,2,1330,-581),(2793,23,1331,-121),(2794,34,1331,-154),(2795,2,1331,-582),(2796,23,1332,-122),(2797,34,1332,-155),(2798,2,1332,-583),(2799,23,1333,-123),(2800,8,1333,-166),(2801,35,1333,-101),(2802,2,1333,-584),(2803,23,1334,-124),(2804,8,1334,-167),(2805,35,1334,-102),(2806,2,1334,-585),(2807,23,1335,-125),(2808,8,1335,-168),(2809,35,1335,-103),(2810,2,1335,-586),(2811,23,1336,-126),(2812,8,1336,-169),(2813,35,1336,-104),(2814,2,1336,-587),(2815,23,1337,-127),(2816,8,1337,-170),(2817,35,1337,-105),(2818,2,1337,-588),(2819,23,1338,-128),(2820,8,1338,-171),(2821,35,1338,-106),(2822,2,1338,-589),(2823,23,1339,-129),(2824,8,1339,-172),(2825,35,1339,-107),(2826,2,1339,-590),(2827,23,1340,-130),(2828,8,1340,-173),(2829,35,1340,-108),(2830,2,1340,-591),(2831,23,1341,-131),(2832,8,1341,-174),(2833,35,1341,-109),(2834,2,1341,-592),(2835,23,1342,-132),(2836,8,1342,-175),(2837,35,1342,-110),(2838,2,1342,-593),(2839,23,1343,-133),(2840,8,1343,-176),(2841,35,1343,-111),(2842,2,1343,-594),(2843,23,1344,-134),(2844,8,1344,-177),(2845,35,1344,-112),(2846,2,1344,-595),(2847,23,1345,-135),(2848,8,1345,-178),(2849,35,1345,-113),(2850,2,1345,-596),(2851,23,1346,-136),(2852,8,1346,-179),(2853,35,1346,-114),(2854,2,1346,-597),(2855,23,1347,-137),(2856,8,1347,-180),(2857,35,1347,-115),(2858,2,1347,-598),(2859,23,1348,-138),(2860,8,1348,-181),(2861,35,1348,-116),(2862,2,1348,-599),(2863,23,1349,-139),(2864,8,1349,-182),(2865,2,1349,-600),(2866,23,1350,-140),(2867,8,1350,-183),(2868,2,1350,-601),(2869,23,1351,-141),(2870,8,1351,-184),(2871,2,1351,-602),(2872,23,1352,-142),(2873,8,1352,-185),(2874,2,1352,-603),(2875,23,1353,-143),(2876,8,1353,-186),(2877,2,1353,-604),(2878,23,1354,-144),(2879,8,1354,-187),(2880,2,1354,-605),(2881,23,1355,-145),(2882,8,1355,-188),(2883,2,1355,-606),(2884,23,1356,-146),(2885,8,1356,-189),(2886,2,1356,-607),(2887,23,1357,-147),(2888,8,1357,-190),(2889,2,1357,-608),(2890,23,1358,-148),(2891,8,1358,-191),(2892,2,1358,-609),(2893,23,1359,-149),(2894,8,1359,-192),(2895,2,1359,-610),(2896,23,1360,-150),(2897,8,1360,-193),(2898,2,1360,-611),(2899,23,1361,-151),(2900,8,1361,-194),(2901,2,1361,-612),(2902,23,1362,-152),(2903,8,1362,-195),(2904,2,1362,-613),(2905,23,1363,-153),(2906,8,1363,-196),(2907,2,1363,-614),(2908,23,1364,-154),(2909,8,1364,-197),(2910,2,1364,-615),(2911,23,1365,-155),(2912,30,1365,-65),(2913,35,1365,-117),(2914,2,1365,-616),(2915,23,1366,-156),(2916,30,1366,-66),(2917,35,1366,-118),(2918,2,1366,-617),(2919,23,1367,-157),(2920,30,1367,-67),(2921,35,1367,-119),(2922,2,1367,-618),(2923,23,1368,-158),(2924,30,1368,-68),(2925,35,1368,-120),(2926,2,1368,-619),(2927,23,1369,-159),(2928,30,1369,-69),(2929,35,1369,-121),(2930,2,1369,-620),(2931,23,1370,-160),(2932,30,1370,-70),(2933,35,1370,-122),(2934,2,1370,-621),(2935,23,1371,-161),(2936,30,1371,-71),(2937,35,1371,-123),(2938,2,1371,-622),(2939,23,1372,-162),(2940,30,1372,-72),(2941,35,1372,-124),(2942,2,1372,-623),(2943,23,1373,-163),(2944,30,1373,-73),(2945,35,1373,-125),(2946,2,1373,-624),(2947,23,1374,-164),(2948,30,1374,-74),(2949,35,1374,-126),(2950,2,1374,-625),(2951,23,1375,-165),(2952,30,1375,-75),(2953,35,1375,-127),(2954,2,1375,-626),(2955,23,1376,-166),(2956,30,1376,-76),(2957,35,1376,-128),(2958,2,1376,-627),(2959,23,1377,-167),(2960,30,1377,-77),(2961,35,1377,-129),(2962,2,1377,-628),(2963,23,1378,-168),(2964,30,1378,-78),(2965,35,1378,-130),(2966,2,1378,-629),(2967,23,1379,-169),(2968,30,1379,-79),(2969,35,1379,-131),(2970,2,1379,-630),(2971,23,1380,-170),(2972,30,1380,-80),(2973,35,1380,-132),(2974,2,1380,-631),(2975,23,1381,-171),(2976,30,1381,-81),(2977,35,1381,-133),(2978,2,1381,-632),(2979,23,1382,-172),(2980,30,1382,-82),(2981,35,1382,-134),(2982,2,1382,-633),(2983,23,1383,-173),(2984,30,1383,-83),(2985,35,1383,-135),(2986,2,1383,-634),(2987,23,1384,-174),(2988,30,1384,-84),(2989,35,1384,-136),(2990,2,1384,-635),(2991,23,1385,-175),(2992,30,1385,-85),(2993,35,1385,-137),(2994,2,1385,-636),(2995,23,1386,-176),(2996,30,1386,-86),(2997,35,1386,-138),(2998,2,1386,-637),(2999,23,1387,-177),(3000,30,1387,-87),(3001,35,1387,-139),(3002,2,1387,-638),(3003,23,1388,-178),(3004,30,1388,-88),(3005,35,1388,-140),(3006,2,1388,-639),(3007,23,1389,-179),(3008,30,1389,-89),(3009,35,1389,-141),(3010,2,1389,-640),(3011,23,1390,-180),(3012,30,1390,-90),(3013,35,1390,-142),(3014,2,1390,-641),(3015,23,1391,-181),(3016,30,1391,-91),(3017,35,1391,-143),(3018,2,1391,-642),(3019,23,1392,-182),(3020,30,1392,-92),(3021,35,1392,-144),(3022,2,1392,-643),(3023,23,1393,-183),(3024,30,1393,-93),(3025,35,1393,-145),(3026,2,1393,-644),(3027,23,1394,-184),(3028,30,1394,-94),(3029,35,1394,-146),(3030,2,1394,-645),(3031,23,1395,-185),(3032,30,1395,-95),(3033,35,1395,-147),(3034,2,1395,-646),(3035,23,1396,-186),(3036,30,1396,-96),(3037,35,1396,-148),(3038,2,1396,-647),(3039,25,1397,-1),(3040,33,1397,-1),(3041,8,1397,-198),(3042,2,1397,-648),(3043,25,1398,-2),(3044,33,1398,-2),(3045,8,1398,-199),(3046,2,1398,-649),(3047,25,1399,-3),(3048,33,1399,-3),(3049,8,1399,-200),(3050,2,1399,-650),(3051,25,1400,-4),(3052,33,1400,-4),(3053,8,1400,-201),(3054,2,1400,-651),(3055,25,1401,-5),(3056,33,1401,-5),(3057,8,1401,-202),(3058,2,1401,-652),(3059,25,1402,-6),(3060,33,1402,-6),(3061,8,1402,-203),(3062,2,1402,-653),(3063,25,1403,-7),(3064,33,1403,-7),(3065,8,1403,-204),(3066,2,1403,-654),(3067,25,1404,-8),(3068,33,1404,-8),(3069,8,1404,-205),(3070,2,1404,-655),(3071,25,1405,-9),(3072,33,1405,-9),(3073,8,1405,-206),(3074,2,1405,-656),(3075,25,1406,-10),(3076,33,1406,-10),(3077,8,1406,-207),(3078,2,1406,-657),(3079,25,1407,-11),(3080,33,1407,-11),(3081,8,1407,-208),(3082,2,1407,-658),(3083,25,1408,-12),(3084,33,1408,-12),(3085,8,1408,-209),(3086,2,1408,-659),(3087,25,1409,-13),(3088,33,1409,-13),(3089,8,1409,-210),(3090,2,1409,-660),(3091,25,1410,-14),(3092,33,1410,-14),(3093,8,1410,-211),(3094,2,1410,-661),(3095,25,1411,-15),(3096,33,1411,-15),(3097,8,1411,-212),(3098,2,1411,-662),(3099,25,1412,-16),(3100,33,1412,-16),(3101,8,1412,-213),(3102,2,1412,-663),(3103,25,1413,-17),(3104,33,1413,-17),(3105,35,1413,-149),(3106,2,1413,-664),(3107,25,1414,-18),(3108,33,1414,-18),(3109,35,1414,-150),(3110,2,1414,-665),(3111,25,1415,-19),(3112,33,1415,-19),(3113,35,1415,-151),(3114,2,1415,-666),(3115,25,1416,-20),(3116,33,1416,-20),(3117,35,1416,-152),(3118,2,1416,-667),(3119,25,1417,-21),(3120,33,1417,-21),(3121,35,1417,-153),(3122,2,1417,-668),(3123,25,1418,-22),(3124,33,1418,-22),(3125,35,1418,-154),(3126,2,1418,-669),(3127,25,1419,-23),(3128,33,1419,-23),(3129,35,1419,-155),(3130,2,1419,-670),(3131,25,1420,-24),(3132,33,1420,-24),(3133,35,1420,-156),(3134,2,1420,-671),(3135,25,1421,-25),(3136,33,1421,-25),(3137,35,1421,-157),(3138,2,1421,-672),(3139,25,1422,-26),(3140,33,1422,-26),(3141,35,1422,-158),(3142,2,1422,-673),(3143,25,1423,-27),(3144,33,1423,-27),(3145,35,1423,-159),(3146,2,1423,-674),(3147,25,1424,-28),(3148,33,1424,-28),(3149,35,1424,-160),(3150,2,1424,-675),(3151,25,1425,-29),(3152,33,1425,-29),(3153,35,1425,-161),(3154,2,1425,-676),(3155,25,1426,-30),(3156,33,1426,-30),(3157,35,1426,-162),(3158,2,1426,-677),(3159,25,1427,-31),(3160,33,1427,-31),(3161,35,1427,-163),(3162,2,1427,-678),(3163,25,1428,-32),(3164,33,1428,-32),(3165,35,1428,-164),(3166,2,1428,-679),(3167,25,1429,-33),(3168,33,1429,-33),(3169,8,1429,-214),(3170,36,1429,-138),(3171,2,1429,-680),(3172,25,1430,-34),(3173,33,1430,-34),(3174,8,1430,-215),(3175,36,1430,-139),(3176,2,1430,-681),(3177,25,1431,-35),(3178,33,1431,-35),(3179,8,1431,-216),(3180,36,1431,-140),(3181,2,1431,-682),(3182,25,1432,-36),(3183,33,1432,-36),(3184,8,1432,-217),(3185,36,1432,-141),(3186,2,1432,-683),(3187,25,1433,-37),(3188,33,1433,-37),(3189,8,1433,-218),(3190,36,1433,-142),(3191,2,1433,-684),(3192,25,1434,-38),(3193,33,1434,-38),(3194,8,1434,-219),(3195,36,1434,-143),(3196,2,1434,-685),(3197,25,1435,-39),(3198,33,1435,-39),(3199,8,1435,-220),(3200,36,1435,-144),(3201,2,1435,-686),(3202,25,1436,-40),(3203,33,1436,-40),(3204,8,1436,-221),(3205,36,1436,-145),(3206,2,1436,-687),(3207,25,1437,-41),(3208,33,1437,-41),(3209,8,1437,-222),(3210,36,1437,-146),(3211,2,1437,-688),(3212,25,1438,-42),(3213,33,1438,-42),(3214,8,1438,-223),(3215,36,1438,-147),(3216,2,1438,-689),(3217,25,1439,-43),(3218,33,1439,-43),(3219,8,1439,-224),(3220,36,1439,-148),(3221,2,1439,-690),(3222,25,1440,-44),(3223,33,1440,-44),(3224,8,1440,-225),(3225,36,1440,-149),(3226,2,1440,-691),(3227,25,1441,-45),(3228,33,1441,-45),(3229,8,1441,-226),(3230,36,1441,-150),(3231,2,1441,-692),(3232,25,1442,-46),(3233,33,1442,-46),(3234,8,1442,-227),(3235,36,1442,-151),(3236,2,1442,-693),(3237,25,1443,-47),(3238,33,1443,-47),(3239,8,1443,-228),(3240,36,1443,-152),(3241,2,1443,-694),(3242,25,1444,-48),(3243,33,1444,-48),(3244,8,1444,-229),(3245,36,1444,-153),(3246,2,1444,-695),(3247,25,1445,-49),(3248,33,1445,-49),(3249,8,1445,-230),(3250,36,1445,-154),(3251,2,1445,-696),(3252,25,1446,-50),(3253,33,1446,-50),(3254,8,1446,-231),(3255,36,1446,-155),(3256,2,1446,-697),(3257,25,1447,-51),(3258,33,1447,-51),(3259,8,1447,-232),(3260,36,1447,-156),(3261,2,1447,-698),(3262,25,1448,-52),(3263,33,1448,-52),(3264,8,1448,-233),(3265,36,1448,-157),(3266,2,1448,-699),(3267,25,1449,-53),(3268,33,1449,-53),(3269,8,1449,-234),(3270,36,1449,-158),(3271,2,1449,-700),(3272,25,1450,-54),(3273,33,1450,-54),(3274,8,1450,-235),(3275,36,1450,-159),(3276,2,1450,-701),(3277,25,1451,-55),(3278,33,1451,-55),(3279,8,1451,-236),(3280,36,1451,-160),(3281,2,1451,-702),(3282,25,1452,-56),(3283,33,1452,-56),(3284,8,1452,-237),(3285,36,1452,-161),(3286,2,1452,-703),(3287,25,1453,-57),(3288,33,1453,-57),(3289,8,1453,-238),(3290,36,1453,-162),(3291,2,1453,-704),(3292,25,1454,-58),(3293,33,1454,-58),(3294,8,1454,-239),(3295,36,1454,-163),(3296,2,1454,-705),(3297,25,1455,-59),(3298,33,1455,-59),(3299,8,1455,-240),(3300,36,1455,-164),(3301,2,1455,-706),(3302,25,1456,-60),(3303,33,1456,-60),(3304,8,1456,-241),(3305,36,1456,-165),(3306,2,1456,-707),(3307,25,1457,-61),(3308,33,1457,-61),(3309,8,1457,-242),(3310,36,1457,-166),(3311,2,1457,-708),(3312,25,1458,-62),(3313,33,1458,-62),(3314,8,1458,-243),(3315,36,1458,-167),(3316,2,1458,-709),(3317,25,1459,-63),(3318,33,1459,-63),(3319,8,1459,-244),(3320,36,1459,-168),(3321,2,1459,-710),(3322,25,1460,-64),(3323,33,1460,-64),(3324,8,1460,-245),(3325,36,1460,-169),(3326,2,1460,-711),(3327,25,1461,-65),(3328,33,1461,-65),(3329,8,1461,-246),(3330,34,1461,-156),(3331,2,1461,-712),(3332,25,1462,-66),(3333,33,1462,-66),(3334,8,1462,-247),(3335,34,1462,-157),(3336,2,1462,-713),(3337,25,1463,-67),(3338,33,1463,-67),(3339,8,1463,-248),(3340,34,1463,-158),(3341,2,1463,-714),(3342,25,1464,-68),(3343,33,1464,-68),(3344,8,1464,-249),(3345,34,1464,-159),(3346,2,1464,-715),(3347,25,1465,-69),(3348,33,1465,-69),(3349,8,1465,-250),(3350,34,1465,-160),(3351,2,1465,-716),(3352,25,1466,-70),(3353,33,1466,-70),(3354,8,1466,-251),(3355,34,1466,-161),(3356,2,1466,-717),(3357,25,1467,-71),(3358,33,1467,-71),(3359,8,1467,-252),(3360,34,1467,-162),(3361,2,1467,-718),(3362,25,1468,-72),(3363,33,1468,-72),(3364,8,1468,-253),(3365,34,1468,-163),(3366,2,1468,-719),(3367,25,1469,-73),(3368,33,1469,-73),(3369,8,1469,-254),(3370,34,1469,-164),(3371,2,1469,-720),(3372,25,1470,-74),(3373,33,1470,-74),(3374,8,1470,-255),(3375,34,1470,-165),(3376,2,1470,-721),(3377,25,1471,-75),(3378,33,1471,-75),(3379,8,1471,-256),(3380,34,1471,-166),(3381,2,1471,-722),(3382,25,1472,-76),(3383,33,1472,-76),(3384,8,1472,-257),(3385,34,1472,-167),(3386,2,1472,-723),(3387,25,1473,-77),(3388,33,1473,-77),(3389,8,1473,-258),(3390,34,1473,-168),(3391,2,1473,-724),(3392,25,1474,-78),(3393,33,1474,-78),(3394,8,1474,-259),(3395,34,1474,-169),(3396,2,1474,-725),(3397,25,1475,-79),(3398,33,1475,-79),(3399,8,1475,-260),(3400,34,1475,-170),(3401,2,1475,-726),(3402,25,1476,-80),(3403,33,1476,-80),(3404,8,1476,-261),(3405,34,1476,-171),(3406,2,1476,-727),(3407,25,1477,-81),(3408,33,1477,-81),(3409,30,1477,-97),(3410,2,1477,-728),(3411,25,1478,-82),(3412,33,1478,-82),(3413,30,1478,-98),(3414,2,1478,-729),(3415,25,1479,-83),(3416,33,1479,-83),(3417,30,1479,-99),(3418,2,1479,-730),(3419,25,1480,-84),(3420,33,1480,-84),(3421,30,1480,-100),(3422,2,1480,-731),(3423,25,1481,-85),(3424,33,1481,-85),(3425,30,1481,-101),(3426,2,1481,-732),(3427,25,1482,-86),(3428,33,1482,-86),(3429,30,1482,-102),(3430,2,1482,-733),(3431,25,1483,-87),(3432,33,1483,-87),(3433,30,1483,-103),(3434,2,1483,-734),(3435,25,1484,-88),(3436,33,1484,-88),(3437,30,1484,-104),(3438,2,1484,-735),(3439,25,1485,-89),(3440,33,1485,-89),(3441,30,1485,-105),(3442,2,1485,-736),(3443,25,1486,-90),(3444,33,1486,-90),(3445,30,1486,-106),(3446,2,1486,-737),(3447,25,1487,-91),(3448,33,1487,-91),(3449,30,1487,-107),(3450,2,1487,-738),(3451,25,1488,-92),(3452,33,1488,-92),(3453,30,1488,-108),(3454,2,1488,-739),(3455,25,1489,-93),(3456,33,1489,-93),(3457,30,1489,-109),(3458,2,1489,-740),(3459,25,1490,-94),(3460,33,1490,-94),(3461,30,1490,-110),(3462,2,1490,-741),(3463,25,1491,-95),(3464,33,1491,-95),(3465,30,1491,-111),(3466,2,1491,-742),(3467,25,1492,-96),(3468,33,1492,-96),(3469,30,1492,-112),(3470,2,1492,-743),(3471,25,1493,-97),(3472,33,1493,-97),(3473,30,1493,-113),(3474,36,1493,-170),(3475,2,1493,-744),(3476,25,1494,-98),(3477,33,1494,-98),(3478,30,1494,-114),(3479,36,1494,-171),(3480,2,1494,-745),(3481,25,1495,-99),(3482,33,1495,-99),(3483,30,1495,-115),(3484,36,1495,-172),(3485,2,1495,-746),(3486,25,1496,-100),(3487,33,1496,-100),(3488,30,1496,-116),(3489,36,1496,-173),(3490,2,1496,-747),(3491,25,1497,-101),(3492,33,1497,-101),(3493,30,1497,-117),(3494,36,1497,-174),(3495,2,1497,-748),(3496,25,1498,-102),(3497,33,1498,-102),(3498,30,1498,-118),(3499,36,1498,-175),(3500,2,1498,-749),(3501,25,1499,-103),(3502,33,1499,-103),(3503,30,1499,-119),(3504,36,1499,-176),(3505,2,1499,-750),(3506,25,1500,-104),(3507,33,1500,-104),(3508,30,1500,-120),(3509,36,1500,-177),(3510,2,1500,-751),(3511,25,1501,-105),(3512,33,1501,-105),(3513,30,1501,-121),(3514,36,1501,-178),(3515,2,1501,-752),(3516,25,1502,-106),(3517,33,1502,-106),(3518,30,1502,-122),(3519,36,1502,-179),(3520,2,1502,-753),(3521,25,1503,-107),(3522,33,1503,-107),(3523,30,1503,-123),(3524,36,1503,-180),(3525,2,1503,-754),(3526,25,1504,-108),(3527,33,1504,-108),(3528,30,1504,-124),(3529,36,1504,-181),(3530,2,1504,-755),(3531,25,1505,-109),(3532,33,1505,-109),(3533,30,1505,-125),(3534,36,1505,-182),(3535,2,1505,-756),(3536,25,1506,-110),(3537,33,1506,-110),(3538,30,1506,-126),(3539,36,1506,-183),(3540,2,1506,-757),(3541,25,1507,-111),(3542,33,1507,-111),(3543,30,1507,-127),(3544,36,1507,-184),(3545,2,1507,-758),(3546,25,1508,-112),(3547,33,1508,-112),(3548,30,1508,-128),(3549,36,1508,-185),(3550,2,1508,-759),(3551,25,1509,-113),(3552,33,1509,-113),(3553,35,1509,-165),(3554,2,1509,-760),(3555,25,1510,-114),(3556,33,1510,-114),(3557,35,1510,-166),(3558,2,1510,-761),(3559,25,1511,-115),(3560,33,1511,-115),(3561,35,1511,-167),(3562,2,1511,-762),(3563,25,1512,-116),(3564,33,1512,-116),(3565,35,1512,-168),(3566,2,1512,-763),(3567,25,1513,-117),(3568,33,1513,-117),(3569,35,1513,-169),(3570,2,1513,-764),(3571,25,1514,-118),(3572,33,1514,-118),(3573,35,1514,-170),(3574,2,1514,-765),(3575,25,1515,-119),(3576,33,1515,-119),(3577,35,1515,-171),(3578,2,1515,-766),(3579,25,1516,-120),(3580,33,1516,-120),(3581,35,1516,-172),(3582,2,1516,-767),(3583,25,1517,-121),(3584,33,1517,-121),(3585,35,1517,-173),(3586,2,1517,-768),(3587,25,1518,-122),(3588,33,1518,-122),(3589,35,1518,-174),(3590,2,1518,-769),(3591,25,1519,-123),(3592,33,1519,-123),(3593,35,1519,-175),(3594,2,1519,-770),(3595,25,1520,-124),(3596,33,1520,-124),(3597,35,1520,-176),(3598,2,1520,-771),(3599,25,1521,-125),(3600,33,1521,-125),(3601,35,1521,-177),(3602,2,1521,-772),(3603,25,1522,-126),(3604,33,1522,-126),(3605,35,1522,-178),(3606,2,1522,-773),(3607,25,1523,-127),(3608,33,1523,-127),(3609,35,1523,-179),(3610,2,1523,-774),(3611,25,1524,-128),(3612,33,1524,-128),(3613,35,1524,-180),(3614,2,1524,-775),(3615,25,1525,-129),(3616,33,1525,-129),(3617,30,1525,-129),(3618,34,1525,-172),(3619,2,1525,-776),(3620,25,1526,-130),(3621,33,1526,-130),(3622,30,1526,-130),(3623,34,1526,-173),(3624,2,1526,-777),(3625,25,1527,-131),(3626,33,1527,-131),(3627,30,1527,-131),(3628,34,1527,-174),(3629,2,1527,-778),(3630,25,1528,-132),(3631,33,1528,-132),(3632,30,1528,-132),(3633,34,1528,-175),(3634,2,1528,-779),(3635,25,1529,-133),(3636,33,1529,-133),(3637,30,1529,-133),(3638,34,1529,-176),(3639,2,1529,-780),(3640,25,1530,-134),(3641,33,1530,-134),(3642,30,1530,-134),(3643,34,1530,-177),(3644,2,1530,-781),(3645,25,1531,-135),(3646,33,1531,-135),(3647,30,1531,-135),(3648,34,1531,-178),(3649,2,1531,-782),(3650,25,1532,-136),(3651,33,1532,-136),(3652,30,1532,-136),(3653,34,1532,-179),(3654,2,1532,-783),(3655,25,1533,-137),(3656,33,1533,-137),(3657,30,1533,-137),(3658,34,1533,-180),(3659,2,1533,-784),(3660,25,1534,-138),(3661,33,1534,-138),(3662,30,1534,-138),(3663,34,1534,-181),(3664,2,1534,-785),(3665,25,1535,-139),(3666,33,1535,-139),(3667,30,1535,-139),(3668,34,1535,-182),(3669,2,1535,-786),(3670,25,1536,-140),(3671,33,1536,-140),(3672,30,1536,-140),(3673,34,1536,-183),(3674,2,1536,-787),(3675,25,1537,-141),(3676,33,1537,-141),(3677,30,1537,-141),(3678,34,1537,-184),(3679,2,1537,-788),(3680,25,1538,-142),(3681,33,1538,-142),(3682,30,1538,-142),(3683,34,1538,-185),(3684,2,1538,-789),(3685,25,1539,-143),(3686,33,1539,-143),(3687,30,1539,-143),(3688,34,1539,-186),(3689,2,1539,-790),(3690,25,1540,-144),(3691,33,1540,-144),(3692,30,1540,-144),(3693,34,1540,-187),(3694,2,1540,-791),(3695,25,1541,-145),(3696,33,1541,-145),(3697,35,1541,-181),(3698,2,1541,-792),(3699,25,1542,-146),(3700,33,1542,-146),(3701,35,1542,-182),(3702,2,1542,-793),(3703,25,1543,-147),(3704,33,1543,-147),(3705,35,1543,-183),(3706,2,1543,-794),(3707,25,1544,-148),(3708,33,1544,-148),(3709,35,1544,-184),(3710,2,1544,-795),(3711,25,1545,-149),(3712,33,1545,-149),(3713,35,1545,-185),(3714,2,1545,-796),(3715,25,1546,-150),(3716,33,1546,-150),(3717,35,1546,-186),(3718,2,1546,-797),(3719,25,1547,-151),(3720,33,1547,-151),(3721,35,1547,-187),(3722,2,1547,-798),(3723,25,1548,-152),(3724,33,1548,-152),(3725,35,1548,-188),(3726,2,1548,-799),(3727,25,1549,-153),(3728,33,1549,-153),(3729,35,1549,-189),(3730,2,1549,-800),(3731,25,1550,-154),(3732,33,1550,-154),(3733,35,1550,-190),(3734,2,1550,-801),(3735,25,1551,-155),(3736,33,1551,-155),(3737,35,1551,-191),(3738,2,1551,-802),(3739,25,1552,-156),(3740,33,1552,-156),(3741,35,1552,-192),(3742,2,1552,-803),(3743,25,1553,-157),(3744,33,1553,-157),(3745,35,1553,-193),(3746,2,1553,-804),(3747,25,1554,-158),(3748,33,1554,-158),(3749,35,1554,-194),(3750,2,1554,-805),(3751,25,1555,-159),(3752,33,1555,-159),(3753,35,1555,-195),(3754,2,1555,-806),(3755,25,1556,-160),(3756,33,1556,-160),(3757,35,1556,-196),(3758,2,1556,-807),(3759,25,1557,-161),(3760,33,1557,-161),(3761,2,1557,-808),(3762,25,1558,-162),(3763,33,1558,-162),(3764,2,1558,-809),(3765,25,1559,-163),(3766,33,1559,-163),(3767,2,1559,-810),(3768,25,1560,-164),(3769,33,1560,-164),(3770,2,1560,-811),(3771,25,1561,-165),(3772,33,1561,-165),(3773,2,1561,-812),(3774,25,1562,-166),(3775,33,1562,-166),(3776,2,1562,-813),(3777,25,1563,-167),(3778,33,1563,-167),(3779,2,1563,-814),(3780,25,1564,-168),(3781,33,1564,-168),(3782,2,1564,-815),(3783,25,1565,-169),(3784,33,1565,-169),(3785,2,1565,-816),(3786,25,1566,-170),(3787,33,1566,-170),(3788,2,1566,-817),(3789,25,1567,-171),(3790,33,1567,-171),(3791,2,1567,-818),(3792,25,1568,-172),(3793,33,1568,-172),(3794,2,1568,-819),(3795,25,1569,-173),(3796,33,1569,-173),(3797,2,1569,-820),(3798,25,1570,-174),(3799,33,1570,-174),(3800,2,1570,-821),(3801,25,1571,-175),(3802,33,1571,-175),(3803,2,1571,-822),(3804,25,1572,-176),(3805,33,1572,-176),(3806,2,1572,-823),(3807,25,1573,-177),(3808,33,1573,-177),(3809,2,1573,-824),(3810,25,1574,-178),(3811,33,1574,-178),(3812,2,1574,-825),(3813,25,1575,-179),(3814,33,1575,-179),(3815,2,1575,-826),(3816,25,1576,-180),(3817,33,1576,-180),(3818,2,1576,-827),(3819,25,1577,-181),(3820,33,1577,-181),(3821,2,1577,-828),(3822,25,1578,-182),(3823,33,1578,-182),(3824,2,1578,-829),(3825,25,1579,-183),(3826,33,1579,-183),(3827,2,1579,-830),(3828,25,1580,-184),(3829,33,1580,-184),(3830,2,1580,-831),(3831,25,1581,-185),(3832,33,1581,-185),(3833,2,1581,-832),(3834,25,1582,-186),(3835,33,1582,-186),(3836,2,1582,-833),(3837,25,1583,-187),(3838,33,1583,-187),(3839,2,1583,-834),(3840,25,1584,-188),(3841,33,1584,-188),(3842,2,1584,-835),(3843,25,1585,-189),(3844,33,1585,-189),(3845,2,1585,-836),(3846,25,1586,-190),(3847,33,1586,-190),(3848,2,1586,-837),(3849,25,1587,-191),(3850,33,1587,-191),(3851,2,1587,-838),(3852,25,1588,-192),(3853,33,1588,-192),(3854,2,1588,-839),(3855,26,1589,-1),(3856,30,1589,-145),(3857,36,1589,-186),(3858,2,1589,-840),(3859,26,1590,-2),(3860,30,1590,-146),(3861,36,1590,-187),(3862,2,1590,-841),(3863,26,1591,-3),(3864,30,1591,-147),(3865,36,1591,-188),(3866,2,1591,-842),(3867,26,1592,-4),(3868,30,1592,-148),(3869,36,1592,-189),(3870,2,1592,-843),(3871,26,1593,-5),(3872,30,1593,-149),(3873,36,1593,-190),(3874,2,1593,-844),(3875,26,1594,-6),(3876,30,1594,-150),(3877,36,1594,-191),(3878,2,1594,-845),(3879,26,1595,-7),(3880,30,1595,-151),(3881,36,1595,-192),(3882,2,1595,-846),(3883,26,1596,-8),(3884,30,1596,-152),(3885,36,1596,-193),(3886,2,1596,-847),(3887,26,1597,-9),(3888,30,1597,-153),(3889,36,1597,-194),(3890,2,1597,-848),(3891,26,1598,-10),(3892,30,1598,-154),(3893,36,1598,-195),(3894,2,1598,-849),(3895,26,1599,-11),(3896,30,1599,-155),(3897,36,1599,-196),(3898,2,1599,-850),(3899,26,1600,-12),(3900,30,1600,-156),(3901,36,1600,-197),(3902,2,1600,-851),(3903,26,1601,-13),(3904,30,1601,-157),(3905,36,1601,-198),(3906,2,1601,-852),(3907,26,1602,-14),(3908,30,1602,-158),(3909,36,1602,-199),(3910,2,1602,-853),(3911,26,1603,-15),(3912,30,1603,-159),(3913,36,1603,-200),(3914,2,1603,-854),(3915,26,1604,-16),(3916,30,1604,-160),(3917,36,1604,-201),(3918,2,1604,-855),(3919,26,1605,-17),(3920,26,1606,-18),(3921,26,1607,-19),(3922,26,1608,-20),(3923,26,1609,-21),(3924,26,1610,-22),(3925,26,1611,-23),(3926,26,1612,-24),(3927,26,1613,-25),(3928,26,1614,-26),(3929,26,1615,-27),(3930,26,1616,-28),(3931,26,1617,-29),(3932,26,1618,-30),(3933,26,1619,-31),(3934,26,1620,-32),(3935,26,1621,-33),(3936,8,1621,-262),(3937,35,1621,-197),(3938,2,1621,-856),(3939,26,1622,-34),(3940,8,1622,-263),(3941,35,1622,-198),(3942,2,1622,-857),(3943,26,1623,-35),(3944,8,1623,-264),(3945,35,1623,-199),(3946,2,1623,-858),(3947,26,1624,-36),(3948,8,1624,-265),(3949,35,1624,-200),(3950,2,1624,-859),(3951,26,1625,-37),(3952,8,1625,-266),(3953,35,1625,-201),(3954,2,1625,-860),(3955,26,1626,-38),(3956,8,1626,-267),(3957,35,1626,-202),(3958,2,1626,-861),(3959,26,1627,-39),(3960,8,1627,-268),(3961,35,1627,-203),(3962,2,1627,-862),(3963,26,1628,-40),(3964,8,1628,-269),(3965,35,1628,-204),(3966,2,1628,-863),(3967,26,1629,-41),(3968,8,1629,-270),(3969,35,1629,-205),(3970,2,1629,-864),(3971,26,1630,-42),(3972,8,1630,-271),(3973,35,1630,-206),(3974,2,1630,-865),(3975,26,1631,-43),(3976,8,1631,-272),(3977,35,1631,-207),(3978,2,1631,-866),(3979,26,1632,-44),(3980,8,1632,-273),(3981,35,1632,-208),(3982,2,1632,-867),(3983,26,1633,-45),(3984,8,1633,-274),(3985,35,1633,-209),(3986,2,1633,-868),(3987,26,1634,-46),(3988,8,1634,-275),(3989,35,1634,-210),(3990,2,1634,-869),(3991,26,1635,-47),(3992,8,1635,-276),(3993,35,1635,-211),(3994,2,1635,-870),(3995,26,1636,-48),(3996,8,1636,-277),(3997,35,1636,-212),(3998,2,1636,-871),(3999,26,1637,-49),(4000,26,1638,-50),(4001,26,1639,-51),(4002,26,1640,-52),(4003,26,1641,-53),(4004,26,1642,-54),(4005,26,1643,-55),(4006,26,1644,-56),(4007,26,1645,-57),(4008,26,1646,-58),(4009,26,1647,-59),(4010,26,1648,-60),(4011,26,1649,-61),(4012,26,1650,-62),(4013,26,1651,-63),(4014,26,1652,-64),(4015,26,1653,-65),(4016,26,1654,-66),(4017,26,1655,-67),(4018,26,1656,-68),(4019,26,1657,-69),(4020,26,1658,-70),(4021,26,1659,-71),(4022,26,1660,-72),(4023,26,1661,-73),(4024,26,1662,-74),(4025,26,1663,-75),(4026,26,1664,-76),(4027,26,1665,-77),(4028,26,1666,-78),(4029,26,1667,-79),(4030,26,1668,-80),(4031,26,1669,-81),(4032,36,1669,-202),(4033,2,1669,-872),(4034,26,1670,-82),(4035,36,1670,-203),(4036,2,1670,-873),(4037,26,1671,-83),(4038,36,1671,-204),(4039,2,1671,-874),(4040,26,1672,-84),(4041,36,1672,-205),(4042,2,1672,-875),(4043,26,1673,-85),(4044,36,1673,-206),(4045,2,1673,-876),(4046,26,1674,-86),(4047,36,1674,-207),(4048,2,1674,-877),(4049,26,1675,-87),(4050,36,1675,-208),(4051,2,1675,-878),(4052,26,1676,-88),(4053,36,1676,-209),(4054,2,1676,-879),(4055,26,1677,-89),(4056,36,1677,-210),(4057,2,1677,-880),(4058,26,1678,-90),(4059,36,1678,-211),(4060,2,1678,-881),(4061,26,1679,-91),(4062,36,1679,-212),(4063,2,1679,-882),(4064,26,1680,-92),(4065,36,1680,-213),(4066,2,1680,-883),(4067,26,1681,-93),(4068,36,1681,-214),(4069,2,1681,-884),(4070,26,1682,-94),(4071,36,1682,-215),(4072,2,1682,-885),(4073,26,1683,-95),(4074,36,1683,-216),(4075,2,1683,-886),(4076,26,1684,-96),(4077,36,1684,-217),(4078,2,1684,-887),(4079,26,1685,-97),(4080,26,1686,-98),(4081,26,1687,-99),(4082,26,1688,-100),(4083,26,1689,-101),(4084,26,1690,-102),(4085,26,1691,-103),(4086,26,1692,-104),(4087,26,1693,-105),(4088,26,1694,-106),(4089,26,1695,-107),(4090,26,1696,-108),(4091,26,1697,-109),(4092,26,1698,-110),(4093,26,1699,-111),(4094,26,1700,-112),(4095,26,1701,-113),(4096,8,1701,-278),(4097,34,1701,-188),(4098,2,1701,-888),(4099,26,1702,-114),(4100,8,1702,-279),(4101,34,1702,-189),(4102,2,1702,-889),(4103,26,1703,-115),(4104,8,1703,-280),(4105,34,1703,-190),(4106,2,1703,-890),(4107,26,1704,-116),(4108,8,1704,-281),(4109,34,1704,-191),(4110,2,1704,-891),(4111,26,1705,-117),(4112,8,1705,-282),(4113,34,1705,-192),(4114,2,1705,-892),(4115,26,1706,-118),(4116,8,1706,-283),(4117,34,1706,-193),(4118,2,1706,-893),(4119,26,1707,-119),(4120,8,1707,-284),(4121,34,1707,-194),(4122,2,1707,-894),(4123,26,1708,-120),(4124,8,1708,-285),(4125,34,1708,-195),(4126,2,1708,-895),(4127,26,1709,-121),(4128,8,1709,-286),(4129,34,1709,-196),(4130,2,1709,-896),(4131,26,1710,-122),(4132,8,1710,-287),(4133,34,1710,-197),(4134,2,1710,-897),(4135,26,1711,-123),(4136,8,1711,-288),(4137,34,1711,-198),(4138,2,1711,-898),(4139,26,1712,-124),(4140,8,1712,-289),(4141,34,1712,-199),(4142,2,1712,-899),(4143,26,1713,-125),(4144,8,1713,-290),(4145,34,1713,-200),(4146,2,1713,-900),(4147,26,1714,-126),(4148,8,1714,-291),(4149,34,1714,-201),(4150,2,1714,-901),(4151,26,1715,-127),(4152,8,1715,-292),(4153,34,1715,-202),(4154,2,1715,-902),(4155,26,1716,-128),(4156,8,1716,-293),(4157,34,1716,-203),(4158,2,1716,-903),(4159,26,1717,-129),(4160,35,1717,-213),(4161,2,1717,-904),(4162,26,1718,-130),(4163,35,1718,-214),(4164,2,1718,-905),(4165,26,1719,-131),(4166,35,1719,-215),(4167,2,1719,-906),(4168,26,1720,-132),(4169,35,1720,-216),(4170,2,1720,-907),(4171,26,1721,-133),(4172,35,1721,-217),(4173,2,1721,-908),(4174,26,1722,-134),(4175,35,1722,-218),(4176,2,1722,-909),(4177,26,1723,-135),(4178,35,1723,-219),(4179,2,1723,-910),(4180,26,1724,-136),(4181,35,1724,-220),(4182,2,1724,-911),(4183,26,1725,-137),(4184,35,1725,-221),(4185,2,1725,-912),(4186,26,1726,-138),(4187,35,1726,-222),(4188,2,1726,-913),(4189,26,1727,-139),(4190,35,1727,-223),(4191,2,1727,-914),(4192,26,1728,-140),(4193,35,1728,-224),(4194,2,1728,-915),(4195,26,1729,-141),(4196,35,1729,-225),(4197,2,1729,-916),(4198,26,1730,-142),(4199,35,1730,-226),(4200,2,1730,-917),(4201,26,1731,-143),(4202,35,1731,-227),(4203,2,1731,-918),(4204,26,1732,-144),(4205,35,1732,-228),(4206,2,1732,-919),(4207,26,1733,-145),(4208,34,1733,-204),(4209,2,1733,-920),(4210,26,1734,-146),(4211,34,1734,-205),(4212,2,1734,-921),(4213,26,1735,-147),(4214,34,1735,-206),(4215,2,1735,-922),(4216,26,1736,-148),(4217,34,1736,-207),(4218,2,1736,-923),(4219,26,1737,-149),(4220,34,1737,-208),(4221,2,1737,-924),(4222,26,1738,-150),(4223,34,1738,-209),(4224,2,1738,-925),(4225,26,1739,-151),(4226,34,1739,-210),(4227,2,1739,-926),(4228,26,1740,-152),(4229,34,1740,-211),(4230,2,1740,-927),(4231,26,1741,-153),(4232,34,1741,-212),(4233,2,1741,-928),(4234,26,1742,-154),(4235,34,1742,-213),(4236,2,1742,-929),(4237,26,1743,-155),(4238,34,1743,-214),(4239,2,1743,-930),(4240,26,1744,-156),(4241,34,1744,-215),(4242,2,1744,-931),(4243,26,1745,-157),(4244,34,1745,-216),(4245,2,1745,-932),(4246,26,1746,-158),(4247,34,1746,-217),(4248,2,1746,-933),(4249,26,1747,-159),(4250,34,1747,-218),(4251,2,1747,-934),(4252,26,1748,-160),(4253,34,1748,-219),(4254,2,1748,-935),(4255,26,1749,-161),(4256,26,1750,-162),(4257,26,1751,-163),(4258,26,1752,-164),(4259,26,1753,-165),(4260,26,1754,-166),(4261,26,1755,-167),(4262,26,1756,-168),(4263,26,1757,-169),(4264,26,1758,-170),(4265,26,1759,-171),(4266,26,1760,-172),(4267,26,1761,-173),(4268,26,1762,-174),(4269,26,1763,-175),(4270,26,1764,-176),(4271,26,1765,-177),(4272,35,1765,-229),(4273,2,1765,-936),(4274,26,1766,-178),(4275,35,1766,-230),(4276,2,1766,-937),(4277,26,1767,-179),(4278,35,1767,-231),(4279,2,1767,-938),(4280,26,1768,-180),(4281,35,1768,-232),(4282,2,1768,-939),(4283,26,1769,-181),(4284,35,1769,-233),(4285,2,1769,-940),(4286,26,1770,-182),(4287,35,1770,-234),(4288,2,1770,-941),(4289,26,1771,-183),(4290,35,1771,-235),(4291,2,1771,-942),(4292,26,1772,-184),(4293,35,1772,-236),(4294,2,1772,-943),(4295,26,1773,-185),(4296,35,1773,-237),(4297,2,1773,-944),(4298,26,1774,-186),(4299,35,1774,-238),(4300,2,1774,-945),(4301,26,1775,-187),(4302,35,1775,-239),(4303,2,1775,-946),(4304,26,1776,-188),(4305,35,1776,-240),(4306,2,1776,-947),(4307,26,1777,-189),(4308,35,1777,-241),(4309,2,1777,-948),(4310,26,1778,-190),(4311,35,1778,-242),(4312,2,1778,-949),(4313,26,1779,-191),(4314,35,1779,-243),(4315,2,1779,-950),(4316,26,1780,-192),(4317,35,1780,-244),(4318,2,1780,-951),(4319,26,1781,-193),(4320,30,1781,-161),(4321,35,1781,-245),(4322,2,1781,-952),(4323,26,1782,-194),(4324,30,1782,-162),(4325,35,1782,-246),(4326,2,1782,-953),(4327,26,1783,-195),(4328,30,1783,-163),(4329,35,1783,-247),(4330,2,1783,-954),(4331,26,1784,-196),(4332,30,1784,-164),(4333,35,1784,-248),(4334,2,1784,-955),(4335,26,1785,-197),(4336,30,1785,-165),(4337,35,1785,-249),(4338,2,1785,-956),(4339,26,1786,-198),(4340,30,1786,-166),(4341,35,1786,-250),(4342,2,1786,-957),(4343,26,1787,-199),(4344,30,1787,-167),(4345,35,1787,-251),(4346,2,1787,-958),(4347,26,1788,-200),(4348,30,1788,-168),(4349,35,1788,-252),(4350,2,1788,-959),(4351,26,1789,-201),(4352,30,1789,-169),(4353,35,1789,-253),(4354,2,1789,-960),(4355,26,1790,-202),(4356,30,1790,-170),(4357,35,1790,-254),(4358,2,1790,-961),(4359,26,1791,-203),(4360,30,1791,-171),(4361,35,1791,-255),(4362,2,1791,-962),(4363,26,1792,-204),(4364,30,1792,-172),(4365,35,1792,-256),(4366,2,1792,-963),(4367,26,1793,-205),(4368,30,1793,-173),(4369,35,1793,-257),(4370,2,1793,-964),(4371,26,1794,-206),(4372,30,1794,-174),(4373,35,1794,-258),(4374,2,1794,-965),(4375,26,1795,-207),(4376,30,1795,-175),(4377,35,1795,-259),(4378,2,1795,-966),(4379,26,1796,-208),(4380,30,1796,-176),(4381,35,1796,-260),(4382,2,1796,-967),(4383,26,1797,-209),(4384,30,1797,-177),(4385,34,1797,-220),(4386,2,1797,-968),(4387,26,1798,-210),(4388,30,1798,-178),(4389,34,1798,-221),(4390,2,1798,-969),(4391,26,1799,-211),(4392,30,1799,-179),(4393,34,1799,-222),(4394,2,1799,-970),(4395,26,1800,-212),(4396,30,1800,-180),(4397,34,1800,-223),(4398,2,1800,-971),(4399,26,1801,-213),(4400,30,1801,-181),(4401,34,1801,-224),(4402,2,1801,-972),(4403,26,1802,-214),(4404,30,1802,-182),(4405,34,1802,-225),(4406,2,1802,-973),(4407,26,1803,-215),(4408,30,1803,-183),(4409,34,1803,-226),(4410,2,1803,-974),(4411,26,1804,-216),(4412,30,1804,-184),(4413,34,1804,-227),(4414,2,1804,-975),(4415,26,1805,-217),(4416,30,1805,-185),(4417,34,1805,-228),(4418,2,1805,-976),(4419,26,1806,-218),(4420,30,1806,-186),(4421,34,1806,-229),(4422,2,1806,-977),(4423,26,1807,-219),(4424,30,1807,-187),(4425,34,1807,-230),(4426,2,1807,-978),(4427,26,1808,-220),(4428,30,1808,-188),(4429,34,1808,-231),(4430,2,1808,-979),(4431,26,1809,-221),(4432,30,1809,-189),(4433,34,1809,-232),(4434,2,1809,-980),(4435,26,1810,-222),(4436,30,1810,-190),(4437,34,1810,-233),(4438,2,1810,-981),(4439,26,1811,-223),(4440,30,1811,-191),(4441,34,1811,-234),(4442,2,1811,-982),(4443,26,1812,-224),(4444,30,1812,-192),(4445,34,1812,-235),(4446,2,1812,-983),(4447,27,1813,-1),(4448,32,1813,-157),(4449,35,1813,-261),(4450,2,1813,-984),(4451,27,1814,-2),(4452,32,1814,-158),(4453,35,1814,-262),(4454,2,1814,-985),(4455,27,1815,-3),(4456,32,1815,-159),(4457,35,1815,-263),(4458,2,1815,-986),(4459,27,1816,-4),(4460,32,1816,-160),(4461,35,1816,-264),(4462,2,1816,-987),(4463,27,1817,-5),(4464,32,1817,-161),(4465,35,1817,-265),(4466,2,1817,-988),(4467,27,1818,-6),(4468,32,1818,-162),(4469,35,1818,-266),(4470,2,1818,-989),(4471,27,1819,-7),(4472,32,1819,-163),(4473,35,1819,-267),(4474,2,1819,-990),(4475,27,1820,-8),(4476,32,1820,-164),(4477,35,1820,-268),(4478,2,1820,-991),(4479,27,1821,-9),(4480,32,1821,-165),(4481,35,1821,-269),(4482,2,1821,-992),(4483,27,1822,-10),(4484,32,1822,-166),(4485,35,1822,-270),(4486,2,1822,-993),(4487,27,1823,-11),(4488,32,1823,-167),(4489,35,1823,-271),(4490,2,1823,-994),(4491,27,1824,-12),(4492,32,1824,-168),(4493,35,1824,-272),(4494,2,1824,-995),(4495,27,1825,-13),(4496,32,1825,-169),(4497,35,1825,-273),(4498,2,1825,-996),(4499,27,1826,-14),(4500,32,1826,-170),(4501,35,1826,-274),(4502,2,1826,-997),(4503,27,1827,-15),(4504,32,1827,-171),(4505,8,1827,-294),(4506,2,1827,-998),(4507,27,1828,-16),(4508,32,1828,-172),(4509,8,1828,-295),(4510,2,1828,-999),(4511,27,1829,-17),(4512,32,1829,-173),(4513,8,1829,-296),(4514,2,1829,-1000),(4515,27,1830,-18),(4516,32,1830,-174),(4517,8,1830,-297),(4518,2,1830,-1001),(4519,27,1831,-19),(4520,32,1831,-175),(4521,8,1831,-298),(4522,2,1831,-1002),(4523,27,1832,-20),(4524,32,1832,-176),(4525,8,1832,-299),(4526,2,1832,-1003),(4527,27,1833,-21),(4528,32,1833,-177),(4529,8,1833,-300),(4530,2,1833,-1004),(4531,27,1834,-22),(4532,32,1834,-178),(4533,2,1834,-1005),(4534,27,1835,-23),(4535,32,1835,-179),(4536,2,1835,-1006),(4537,27,1836,-24),(4538,32,1836,-180),(4539,2,1836,-1007),(4540,27,1837,-25),(4541,32,1837,-181),(4542,2,1837,-1008),(4543,27,1838,-26),(4544,32,1838,-182),(4545,2,1838,-1009),(4546,27,1839,-27),(4547,32,1839,-183),(4548,2,1839,-1010),(4549,27,1840,-28),(4550,32,1840,-184),(4551,2,1840,-1011),(4552,27,1841,-29),(4553,32,1841,-185),(4554,34,1841,-236),(4555,2,1841,-1012),(4556,27,1842,-30),(4557,32,1842,-186),(4558,34,1842,-237),(4559,2,1842,-1013),(4560,27,1843,-31),(4561,32,1843,-187),(4562,34,1843,-238),(4563,2,1843,-1014),(4564,27,1844,-32),(4565,32,1844,-188),(4566,34,1844,-239),(4567,2,1844,-1015),(4568,27,1845,-33),(4569,32,1845,-189),(4570,34,1845,-240),(4571,2,1845,-1016),(4572,27,1846,-34),(4573,32,1846,-190),(4574,34,1846,-241),(4575,2,1846,-1017),(4576,27,1847,-35),(4577,32,1847,-191),(4578,34,1847,-242),(4579,2,1847,-1018),(4580,27,1848,-36),(4581,32,1848,-192),(4582,34,1848,-243),(4583,2,1848,-1019),(4584,27,1849,-37),(4585,32,1849,-193),(4586,34,1849,-244),(4587,2,1849,-1020),(4588,27,1850,-38),(4589,32,1850,-194),(4590,34,1850,-245),(4591,2,1850,-1021),(4592,27,1851,-39),(4593,32,1851,-195),(4594,34,1851,-246),(4595,2,1851,-1022),(4596,27,1852,-40),(4597,32,1852,-196),(4598,34,1852,-247),(4599,2,1852,-1023),(4600,27,1853,-41),(4601,32,1853,-197),(4602,34,1853,-248),(4603,2,1853,-1024),(4604,27,1854,-42),(4605,32,1854,-198),(4606,34,1854,-249),(4607,2,1854,-1025),(4608,27,1855,-43),(4609,32,1855,-199),(4610,35,1855,-275),(4611,2,1855,-1026),(4612,27,1856,-44),(4613,32,1856,-200),(4614,35,1856,-276),(4615,2,1856,-1027),(4616,27,1857,-45),(4617,32,1857,-201),(4618,35,1857,-277),(4619,2,1857,-1028),(4620,27,1858,-46),(4621,32,1858,-202),(4622,35,1858,-278),(4623,2,1858,-1029),(4624,27,1859,-47),(4625,32,1859,-203),(4626,35,1859,-279),(4627,2,1859,-1030),(4628,27,1860,-48),(4629,32,1860,-204),(4630,35,1860,-280),(4631,2,1860,-1031),(4632,27,1861,-49),(4633,32,1861,-205),(4634,35,1861,-281),(4635,2,1861,-1032),(4636,27,1862,-50),(4637,32,1862,-206),(4638,2,1862,-1033),(4639,27,1863,-51),(4640,32,1863,-207),(4641,2,1863,-1034),(4642,27,1864,-52),(4643,32,1864,-208),(4644,2,1864,-1035),(4645,27,1865,-53),(4646,32,1865,-209),(4647,2,1865,-1036),(4648,27,1866,-54),(4649,32,1866,-210),(4650,2,1866,-1037),(4651,27,1867,-55),(4652,32,1867,-211),(4653,2,1867,-1038),(4654,27,1868,-56),(4655,32,1868,-212),(4656,2,1868,-1039),(4657,27,1869,-57),(4658,32,1869,-213),(4659,2,1869,-1040),(4660,27,1870,-58),(4661,32,1870,-214),(4662,2,1870,-1041),(4663,27,1871,-59),(4664,32,1871,-215),(4665,2,1871,-1042),(4666,27,1872,-60),(4667,32,1872,-216),(4668,2,1872,-1043),(4669,27,1873,-61),(4670,32,1873,-217),(4671,2,1873,-1044),(4672,27,1874,-62),(4673,32,1874,-218),(4674,2,1874,-1045),(4675,27,1875,-63),(4676,32,1875,-219),(4677,2,1875,-1046),(4678,27,1876,-64),(4679,32,1876,-220),(4680,36,1876,-218),(4681,2,1876,-1047),(4682,27,1877,-65),(4683,32,1877,-221),(4684,36,1877,-219),(4685,2,1877,-1048),(4686,27,1878,-66),(4687,32,1878,-222),(4688,36,1878,-220),(4689,2,1878,-1049),(4690,27,1879,-67),(4691,32,1879,-223),(4692,36,1879,-221),(4693,2,1879,-1050),(4694,27,1880,-68),(4695,32,1880,-224),(4696,36,1880,-222),(4697,2,1880,-1051),(4698,27,1881,-69),(4699,32,1881,-225),(4700,36,1881,-223),(4701,2,1881,-1052),(4702,27,1882,-70),(4703,32,1882,-226),(4704,36,1882,-224),(4705,2,1882,-1053),(4706,27,1883,-71),(4707,32,1883,-227),(4708,2,1883,-1054),(4709,27,1884,-72),(4710,32,1884,-228),(4711,2,1884,-1055),(4712,27,1885,-73),(4713,32,1885,-229),(4714,2,1885,-1056),(4715,27,1886,-74),(4716,32,1886,-230),(4717,2,1886,-1057),(4718,27,1887,-75),(4719,32,1887,-231),(4720,2,1887,-1058),(4721,27,1888,-76),(4722,32,1888,-232),(4723,2,1888,-1059),(4724,27,1889,-77),(4725,32,1889,-233),(4726,2,1889,-1060),(4727,27,1890,-78),(4728,32,1890,-234),(4729,35,1890,-282),(4730,2,1890,-1061),(4731,27,1891,-79),(4732,32,1891,-235),(4733,35,1891,-283),(4734,2,1891,-1062),(4735,27,1892,-80),(4736,32,1892,-236),(4737,35,1892,-284),(4738,2,1892,-1063),(4739,27,1893,-81),(4740,32,1893,-237),(4741,35,1893,-285),(4742,2,1893,-1064),(4743,27,1894,-82),(4744,32,1894,-238),(4745,35,1894,-286),(4746,2,1894,-1065),(4747,27,1895,-83),(4748,32,1895,-239),(4749,35,1895,-287),(4750,2,1895,-1066),(4751,27,1896,-84),(4752,32,1896,-240),(4753,35,1896,-288),(4754,2,1896,-1067),(4755,27,1897,-85),(4756,32,1897,-241),(4757,34,1897,-250),(4758,2,1897,-1068),(4759,27,1898,-86),(4760,32,1898,-242),(4761,34,1898,-251),(4762,2,1898,-1069),(4763,27,1899,-87),(4764,32,1899,-243),(4765,34,1899,-252),(4766,2,1899,-1070),(4767,27,1900,-88),(4768,32,1900,-244),(4769,34,1900,-253),(4770,2,1900,-1071),(4771,27,1901,-89),(4772,32,1901,-245),(4773,34,1901,-254),(4774,2,1901,-1072),(4775,27,1902,-90),(4776,32,1902,-246),(4777,34,1902,-255),(4778,2,1902,-1073),(4779,27,1903,-91),(4780,32,1903,-247),(4781,34,1903,-256),(4782,2,1903,-1074),(4783,28,1904,-1),(4784,8,1904,-301),(4785,36,1904,-225),(4786,2,1904,-1075),(4787,28,1905,-2),(4788,8,1905,-302),(4789,36,1905,-226),(4790,2,1905,-1076),(4791,28,1906,-3),(4792,8,1906,-303),(4793,36,1906,-227),(4794,2,1906,-1077),(4795,28,1907,-4),(4796,8,1907,-304),(4797,36,1907,-228),(4798,2,1907,-1078),(4799,28,1908,-5),(4800,8,1908,-305),(4801,36,1908,-229),(4802,2,1908,-1079),(4803,28,1909,-6),(4804,8,1909,-306),(4805,36,1909,-230),(4806,2,1909,-1080),(4807,28,1910,-7),(4808,8,1910,-307),(4809,36,1910,-231),(4810,2,1910,-1081),(4811,28,1911,-8),(4812,8,1911,-308),(4813,36,1911,-232),(4814,2,1911,-1082),(4815,28,1912,-9),(4816,8,1912,-309),(4817,36,1912,-233),(4818,2,1912,-1083),(4819,28,1913,-10),(4820,8,1913,-310),(4821,36,1913,-234),(4822,2,1913,-1084),(4823,28,1914,-11),(4824,8,1914,-311),(4825,36,1914,-235),(4826,2,1914,-1085),(4827,28,1915,-12),(4828,8,1915,-312),(4829,36,1915,-236),(4830,2,1915,-1086),(4831,28,1916,-13),(4832,8,1916,-313),(4833,36,1916,-237),(4834,2,1916,-1087),(4835,28,1917,-14),(4836,8,1917,-314),(4837,36,1917,-238),(4838,2,1917,-1088),(4839,28,1918,-15),(4840,8,1918,-315),(4841,36,1918,-239),(4842,2,1918,-1089),(4843,28,1919,-16),(4844,8,1919,-316),(4845,36,1919,-240),(4846,2,1919,-1090),(4847,28,1920,-17),(4848,30,1920,-193),(4849,2,1920,-1091),(4850,28,1921,-18),(4851,30,1921,-194),(4852,2,1921,-1092),(4853,28,1922,-19),(4854,30,1922,-195),(4855,2,1922,-1093),(4856,28,1923,-20),(4857,30,1923,-196),(4858,2,1923,-1094),(4859,28,1924,-21),(4860,30,1924,-197),(4861,2,1924,-1095),(4862,28,1925,-22),(4863,30,1925,-198),(4864,2,1925,-1096),(4865,28,1926,-23),(4866,30,1926,-199),(4867,2,1926,-1097),(4868,28,1927,-24),(4869,30,1927,-200),(4870,2,1927,-1098),(4871,28,1928,-25),(4872,30,1928,-201),(4873,2,1928,-1099),(4874,28,1929,-26),(4875,30,1929,-202),(4876,2,1929,-1100),(4877,28,1930,-27),(4878,30,1930,-203),(4879,2,1930,-1101),(4880,28,1931,-28),(4881,30,1931,-204),(4882,2,1931,-1102),(4883,28,1932,-29),(4884,30,1932,-205),(4885,2,1932,-1103),(4886,28,1933,-30),(4887,30,1933,-206),(4888,2,1933,-1104),(4889,28,1934,-31),(4890,30,1934,-207),(4891,2,1934,-1105),(4892,28,1935,-32),(4893,30,1935,-208),(4894,2,1935,-1106),(4895,28,1936,-33),(4896,8,1936,-317),(4897,35,1936,-289),(4898,2,1936,-1107),(4899,28,1937,-34),(4900,8,1937,-318),(4901,35,1937,-290),(4902,2,1937,-1108),(4903,28,1938,-35),(4904,8,1938,-319),(4905,35,1938,-291),(4906,2,1938,-1109),(4907,28,1939,-36),(4908,8,1939,-320),(4909,35,1939,-292),(4910,2,1939,-1110),(4911,28,1940,-37),(4912,8,1940,-321),(4913,35,1940,-293),(4914,2,1940,-1111),(4915,28,1941,-38),(4916,8,1941,-322),(4917,35,1941,-294),(4918,2,1941,-1112),(4919,28,1942,-39),(4920,8,1942,-323),(4921,35,1942,-295),(4922,2,1942,-1113),(4923,28,1943,-40),(4924,8,1943,-324),(4925,35,1943,-296),(4926,2,1943,-1114),(4927,28,1944,-41),(4928,8,1944,-325),(4929,35,1944,-297),(4930,2,1944,-1115),(4931,28,1945,-42),(4932,8,1945,-326),(4933,35,1945,-298),(4934,2,1945,-1116),(4935,28,1946,-43),(4936,8,1946,-327),(4937,35,1946,-299),(4938,2,1946,-1117),(4939,28,1947,-44),(4940,8,1947,-328),(4941,35,1947,-300),(4942,2,1947,-1118),(4943,28,1948,-45),(4944,8,1948,-329),(4945,35,1948,-301),(4946,2,1948,-1119),(4947,28,1949,-46),(4948,8,1949,-330),(4949,35,1949,-302),(4950,2,1949,-1120),(4951,28,1950,-47),(4952,8,1950,-331),(4953,35,1950,-303),(4954,2,1950,-1121),(4955,28,1951,-48),(4956,8,1951,-332),(4957,35,1951,-304),(4958,2,1951,-1122),(4959,28,1952,-49),(4960,28,1953,-50),(4961,28,1954,-51),(4962,28,1955,-52),(4963,28,1956,-53),(4964,28,1957,-54),(4965,28,1958,-55),(4966,28,1959,-56),(4967,28,1960,-57),(4968,28,1961,-58),(4969,28,1962,-59),(4970,28,1963,-60),(4971,28,1964,-61),(4972,28,1965,-62),(4973,28,1966,-63),(4974,28,1967,-64),(4975,28,1968,-65),(4976,30,1968,-209),(4977,2,1968,-1123),(4978,28,1969,-66),(4979,30,1969,-210),(4980,2,1969,-1124),(4981,28,1970,-67),(4982,30,1970,-211),(4983,2,1970,-1125),(4984,28,1971,-68),(4985,30,1971,-212),(4986,2,1971,-1126),(4987,28,1972,-69),(4988,30,1972,-213),(4989,2,1972,-1127),(4990,28,1973,-70),(4991,30,1973,-214),(4992,2,1973,-1128),(4993,28,1974,-71),(4994,30,1974,-215),(4995,2,1974,-1129),(4996,28,1975,-72),(4997,30,1975,-216),(4998,2,1975,-1130),(4999,28,1976,-73),(5000,30,1976,-217),(5001,2,1976,-1131),(5002,28,1977,-74),(5003,30,1977,-218),(5004,2,1977,-1132),(5005,28,1978,-75),(5006,30,1978,-219),(5007,2,1978,-1133),(5008,28,1979,-76),(5009,30,1979,-220),(5010,2,1979,-1134),(5011,28,1980,-77),(5012,30,1980,-221),(5013,2,1980,-1135),(5014,28,1981,-78),(5015,30,1981,-222),(5016,2,1981,-1136),(5017,28,1982,-79),(5018,30,1982,-223),(5019,2,1982,-1137),(5020,28,1983,-80),(5021,30,1983,-224),(5022,2,1983,-1138),(5023,28,1984,-81),(5024,28,1985,-82),(5025,28,1986,-83),(5026,28,1987,-84),(5027,28,1988,-85),(5028,28,1989,-86),(5029,28,1990,-87),(5030,28,1991,-88),(5031,8,1991,-333),(5032,2,1991,-1139),(5033,28,1992,-89),(5034,8,1992,-334),(5035,2,1992,-1140),(5036,28,1993,-90),(5037,8,1993,-335),(5038,2,1993,-1141),(5039,28,1994,-91),(5040,8,1994,-336),(5041,2,1994,-1142),(5042,28,1995,-92),(5043,8,1995,-337),(5044,2,1995,-1143),(5045,28,1996,-93),(5046,8,1996,-338),(5047,2,1996,-1144),(5048,28,1997,-94),(5049,8,1997,-339),(5050,2,1997,-1145),(5051,28,1998,-95),(5052,35,1998,-305),(5053,2,1998,-1146),(5054,28,1999,-96),(5055,35,1999,-306),(5056,2,1999,-1147),(5057,28,2000,-97),(5058,35,2000,-307),(5059,2,2000,-1148),(5060,28,2001,-98),(5061,35,2001,-308),(5062,2,2001,-1149),(5063,28,2002,-99),(5064,35,2002,-309),(5065,2,2002,-1150),(5066,28,2003,-100),(5067,35,2003,-310),(5068,2,2003,-1151),(5069,28,2004,-101),(5070,28,2005,-102),(5071,28,2006,-103),(5072,28,2007,-104),(5073,28,2008,-105),(5074,28,2009,-106),(5075,28,2010,-107),(5076,28,2011,-108),(5077,36,2011,-241),(5078,2,2011,-1152),(5079,28,2012,-109),(5080,36,2012,-242),(5081,2,2012,-1153),(5082,28,2013,-110),(5083,36,2013,-243),(5084,2,2013,-1154),(5085,28,2014,-111),(5086,36,2014,-244),(5087,2,2014,-1155),(5088,28,2015,-112),(5089,36,2015,-245),(5090,2,2015,-1156),(5091,28,2016,-113),(5092,36,2016,-246),(5093,2,2016,-1157),(5094,28,2017,-114),(5095,36,2017,-247),(5096,2,2017,-1158),(5097,28,2018,-115),(5098,34,2018,-257),(5099,2,2018,-1159),(5100,28,2019,-116),(5101,34,2019,-258),(5102,2,2019,-1160),(5103,28,2020,-117),(5104,34,2020,-259),(5105,2,2020,-1161),(5106,28,2021,-118),(5107,34,2021,-260),(5108,2,2021,-1162),(5109,28,2022,-119),(5110,34,2022,-261),(5111,2,2022,-1163),(5112,28,2023,-120),(5113,34,2023,-262),(5114,2,2023,-1164),(5115,28,2024,-121),(5116,34,2024,-263),(5117,2,2024,-1165),(5118,28,2025,-122),(5119,34,2025,-264),(5120,2,2025,-1166),(5121,28,2026,-123),(5122,34,2026,-265),(5123,2,2026,-1167),(5124,28,2027,-124),(5125,34,2027,-266),(5126,2,2027,-1168),(5127,28,2028,-125),(5128,34,2028,-267),(5129,2,2028,-1169),(5130,28,2029,-126),(5131,34,2029,-268),(5132,2,2029,-1170),(5133,28,2030,-127),(5134,34,2030,-269),(5135,2,2030,-1171),(5136,28,2031,-128),(5137,34,2031,-270),(5138,2,2031,-1172),(5139,28,2032,-129),(5140,34,2032,-271),(5141,2,2032,-1173),(5142,28,2033,-130),(5143,34,2033,-272),(5144,2,2033,-1174),(5145,28,2034,-131),(5146,34,2034,-273),(5147,2,2034,-1175),(5148,28,2035,-132),(5149,34,2035,-274),(5150,2,2035,-1176),(5151,28,2036,-133),(5152,34,2036,-275),(5153,2,2036,-1177),(5154,28,2037,-134),(5155,34,2037,-276),(5156,2,2037,-1178),(5157,28,2038,-135),(5158,34,2038,-277),(5159,2,2038,-1179),(5160,28,2039,-136),(5161,34,2039,-278),(5162,2,2039,-1180),(5163,28,2040,-137),(5164,34,2040,-279),(5165,2,2040,-1181);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_product_cl`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_product_cl`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_category_product_cl` (
  `version_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Version ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  PRIMARY KEY (`version_id`)
) ENGINE=InnoDB AUTO_INCREMENT=315 DEFAULT CHARSET=utf8mb4 COMMENT='[[dbprefix]]catalog_category_product_cl';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_product_cl`
--

LOCK TABLES `[[dbprefix]]catalog_category_product_cl` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product_cl` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_category_product_cl` VALUES (1,1),(2,1),(3,1),(4,2),(5,2),(6,2),(7,1),(8,2),(9,3),(10,3),(11,3),(12,3),(13,3),(14,1),(15,2),(16,3),(17,4),(18,4),(19,4),(20,4),(21,4),(22,1),(23,2),(24,3),(25,5),(26,5),(27,5),(28,5),(29,5),(30,1),(31,2),(32,3),(33,6),(34,6),(35,6),(36,6),(37,6),(38,1),(39,2),(40,7),(41,7),(42,7),(43,7),(44,7),(45,1),(46,2),(47,7),(48,8),(49,8),(50,8),(51,8),(52,8),(53,1),(54,2),(55,9),(56,9),(57,9),(58,9),(59,9),(60,1),(61,2),(62,9),(63,10),(64,10),(65,10),(66,10),(67,10),(68,1),(69,2),(70,11),(71,11),(72,11),(73,11),(74,11),(75,1),(76,2),(77,11),(78,12),(79,12),(80,12),(81,12),(82,12),(83,1),(84,2),(85,11),(86,13),(87,13),(88,13),(89,13),(90,13),(91,1),(92,2),(93,11),(94,12),(95,14),(96,14),(97,14),(98,14),(99,14),(100,1),(101,2),(102,11),(103,12),(104,15),(105,15),(106,15),(107,15),(108,15),(109,1),(110,2),(111,11),(112,12),(113,16),(114,16),(115,16),(116,16),(117,16),(118,1),(119,2),(120,11),(121,12),(122,17),(123,17),(124,17),(125,17),(126,17),(127,1),(128,2),(129,11),(130,13),(131,18),(132,18),(133,18),(134,18),(135,18),(136,1),(137,2),(138,11),(139,13),(140,19),(141,19),(142,19),(143,19),(144,19),(145,1),(146,2),(147,20),(148,20),(149,20),(150,20),(151,20),(152,1),(153,2),(154,20),(155,21),(156,21),(157,21),(158,21),(159,21),(160,1),(161,2),(162,20),(163,22),(164,22),(165,22),(166,22),(167,22),(168,1),(169,2),(170,20),(171,21),(172,23),(173,23),(174,23),(175,23),(176,23),(177,1),(178,2),(179,20),(180,21),(181,24),(182,24),(183,24),(184,24),(185,24),(186,1),(187,2),(188,20),(189,21),(190,25),(191,25),(192,25),(193,25),(194,25),(195,1),(196,2),(197,20),(198,21),(199,26),(200,26),(201,26),(202,26),(203,26),(204,1),(205,2),(206,20),(207,22),(208,27),(209,27),(210,27),(211,27),(212,27),(213,1),(214,2),(215,20),(216,22),(217,28),(218,28),(219,28),(220,28),(221,28),(222,1),(223,2),(224,29),(225,29),(226,29),(227,29),(228,29),(229,1),(230,2),(231,29),(232,30),(233,30),(234,30),(235,30),(236,30),(237,1),(238,2),(239,29),(240,31),(241,31),(242,31),(243,31),(244,31),(245,1),(246,2),(247,29),(248,32),(249,32),(250,32),(251,32),(252,32),(253,1),(254,2),(255,29),(256,33),(257,33),(258,33),(259,33),(260,33),(261,1),(262,2),(263,7),(264,34),(265,34),(266,34),(267,34),(268,34),(269,1),(270,2),(271,7),(272,35),(273,35),(274,35),(275,35),(276,35),(277,1),(278,2),(279,7),(280,36),(281,36),(282,36),(283,36),(284,36),(285,1),(286,2),(287,37),(288,37),(289,37),(290,37),(291,37),(292,1),(293,2),(294,38),(295,38),(296,38),(297,38),(298,38),(299,1),(300,2),(301,7),(302,39),(303,39),(304,39),(305,39),(306,39),(307,1),(308,2),(309,7),(310,40),(311,40),(312,40),(313,40),(314,40);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product_cl` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_product_index`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_product_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_category_product_index` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `[[DBPREFIX]]CAT_CTGR_PRD_IDX_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_BB4A590114301ED9D94C8239D3EF6DA8` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Catalog Category Product Index';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_product_index`
--

LOCK TABLES `[[dbprefix]]catalog_category_product_index` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product_index` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product_index` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_product_index_replica`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_product_index_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_category_product_index_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `[[DBPREFIX]]CAT_CTGR_PRD_IDX_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_BB4A590114301ED9D94C8239D3EF6DA8` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Catalog Category Product Index';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_product_index_replica`
--

LOCK TABLES `[[dbprefix]]catalog_category_product_index_replica` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product_index_replica` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product_index_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_product_index_store1`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_product_index_store1`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_category_product_index_store1` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `[[DBPREFIX]]CAT_CTGR_PRD_IDX_STORE1_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_EAA97D781ECAB4B7D46CE05989FB5FCE` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Prmg Catalog Category Product Index Store1';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_product_index_store1`
--

LOCK TABLES `[[dbprefix]]catalog_category_product_index_store1` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product_index_store1` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_category_product_index_store1` VALUES (2,2040,-1181,1,1,4),(2,2024,-1165,1,1,4),(2,2017,-1158,1,1,4),(2,2003,-1151,1,1,4),(2,1997,-1145,1,1,4),(2,1983,-1138,1,1,4),(2,1951,-1122,1,1,4),(2,1935,-1106,1,1,4),(2,1919,-1090,1,1,4),(2,1903,-1074,1,1,4),(2,1896,-1067,1,1,4),(2,1889,-1060,1,1,4),(2,1882,-1053,1,1,4),(2,1875,-1046,1,1,4),(2,1868,-1039,1,1,4),(2,1861,-1032,1,1,4),(2,1854,-1025,1,1,4),(2,1847,-1018,1,1,4),(2,1840,-1011,1,1,4),(2,1833,-1004,1,1,4),(2,1826,-997,1,1,4),(2,1819,-990,1,1,4),(2,1812,-983,1,1,4),(2,1796,-967,1,1,4),(2,1780,-951,1,1,4),(2,1748,-935,1,1,4),(2,1732,-919,1,1,4),(2,1716,-903,1,1,4),(2,1684,-887,1,1,4),(2,1636,-871,1,1,4),(2,1604,-855,1,1,4),(2,1588,-839,1,1,4),(2,1572,-823,1,1,4),(2,1556,-807,1,1,4),(2,1540,-791,1,1,4),(2,1524,-775,1,1,4),(2,1508,-759,1,1,4),(2,1492,-743,1,1,4),(2,1476,-727,1,1,4),(2,1460,-711,1,1,4),(2,1444,-695,1,1,4),(2,1428,-679,1,1,4),(2,1412,-663,1,1,4),(2,1396,-647,1,1,4),(2,1380,-631,1,1,4),(2,1364,-615,1,1,4),(2,1348,-599,1,1,4),(2,1332,-583,1,1,4),(2,1316,-567,1,1,4),(2,1268,-551,1,1,4),(2,1236,-535,1,1,4),(2,1220,-519,1,1,4),(2,1210,-509,1,1,4),(2,1194,-493,1,1,4),(2,1178,-477,1,1,4),(2,1162,-461,1,1,4),(2,1146,-445,1,1,4),(2,1130,-429,1,1,4),(2,1060,-413,1,1,4),(2,1044,-397,1,1,4),(2,1028,-381,1,1,4),(2,1002,-368,1,1,4),(2,989,-355,1,1,4),(2,976,-342,1,1,4),(2,963,-329,1,1,4),(2,950,-316,1,1,4),(2,937,-303,1,1,4),(2,911,-290,1,1,4),(2,893,-277,1,1,4),(2,880,-264,1,1,4),(2,867,-251,1,1,4),(2,854,-238,1,1,4),(2,841,-225,1,1,4),(2,828,-212,1,1,4),(2,254,-208,1,1,4),(2,815,-199,1,1,4),(2,238,-192,1,1,4),(2,622,-192,1,1,4),(2,802,-186,1,1,4),(2,222,-176,1,1,4),(2,430,-176,1,1,4),(2,606,-176,1,1,4),(2,1764,-176,1,1,4),(2,789,-173,1,1,4),(2,206,-160,1,1,4),(2,414,-160,1,1,4),(2,590,-160,1,1,4),(2,776,-160,1,1,4),(2,763,-147,1,1,4),(2,190,-144,1,1,4),(2,398,-144,1,1,4),(2,574,-144,1,1,4),(2,1015,-135,1,1,4),(2,750,-134,1,1,4),(2,174,-128,1,1,4),(2,382,-128,1,1,4),(2,558,-128,1,1,4),(2,737,-121,1,1,4),(2,158,-112,1,1,4),(2,366,-112,1,1,4),(2,542,-112,1,1,4),(2,1700,-112,1,1,4),(2,718,-108,1,1,4),(2,2010,-107,1,1,4),(2,694,-102,1,1,4),(2,724,-102,1,1,4),(2,142,-96,1,1,4),(2,350,-96,1,1,4),(2,462,-96,1,1,4),(2,526,-96,1,1,4),(2,712,-90,1,1,4),(2,1300,-90,1,1,4),(2,1990,-87,1,1,4),(2,1114,-86,1,1,4),(2,706,-84,1,1,4),(2,126,-80,1,1,4),(2,334,-80,1,1,4),(2,510,-80,1,1,4),(2,1108,-80,1,1,4),(2,1668,-80,1,1,4),(2,700,-78,1,1,4),(2,1284,-74,1,1,4),(2,688,-66,1,1,4),(2,110,-64,1,1,4),(2,302,-64,1,1,4),(2,318,-64,1,1,4),(2,494,-64,1,1,4),(2,1092,-64,1,1,4),(2,1652,-64,1,1,4),(2,1967,-64,1,1,4),(2,682,-60,1,1,4),(2,676,-54,1,1,4),(2,94,-48,1,1,4),(2,478,-48,1,1,4),(2,670,-48,1,1,4),(2,1076,-48,1,1,4),(2,924,-44,1,1,4),(2,1252,-42,1,1,4),(2,78,-32,1,1,4),(2,286,-32,1,1,4),(2,654,-32,1,1,4),(2,1620,-32,1,1,4),(2,898,-18,1,1,4),(2,62,-16,1,1,4),(2,270,-16,1,1,4),(2,446,-16,1,1,4),(2,638,-16,1,1,4),(2,1,0,1,1,4),(2,2,0,1,1,4),(2,3,0,1,1,4),(2,4,0,1,1,4),(2,5,0,1,1,4),(2,6,0,1,1,4),(2,7,0,1,1,4),(2,8,0,1,1,4),(2,9,0,1,1,4),(2,10,0,1,1,4),(2,11,0,1,1,4),(2,12,0,1,1,4),(2,13,0,1,1,4),(2,14,0,1,1,4),(2,15,0,1,1,4),(2,16,0,1,1,4),(2,17,0,1,1,4),(2,18,0,1,1,4),(2,19,0,1,1,4),(2,20,0,1,1,4),(2,21,0,1,1,4),(2,22,0,1,1,4),(2,23,0,1,1,4),(2,36,0,1,1,4),(2,37,0,1,1,4),(2,38,0,1,1,4),(2,39,0,1,1,4),(2,40,0,1,1,4),(2,41,0,1,1,4),(2,42,0,1,1,4),(2,43,0,1,1,4),(2,44,0,1,1,4),(2,45,0,1,1,4),(2,46,0,1,1,4),(3,1,0,1,1,4),(3,2,0,1,1,4),(3,3,0,1,1,4),(3,4,0,1,1,4),(3,5,0,1,1,4),(3,6,0,1,1,4),(3,7,0,1,1,4),(3,8,0,1,1,4),(3,9,0,1,1,4),(3,10,0,1,1,4),(3,11,0,1,1,4),(3,12,0,1,1,4),(3,13,0,1,1,4),(3,14,0,1,1,4),(3,15,0,1,1,4),(3,16,0,1,1,4),(3,17,0,1,1,4),(3,18,0,1,1,4),(3,19,0,1,1,4),(3,20,0,1,1,4),(3,21,0,1,1,4),(3,22,0,1,1,4),(3,23,0,1,1,4),(3,36,0,1,1,4),(3,37,0,1,1,4),(3,38,0,1,1,4),(3,39,0,1,1,4),(3,40,0,1,1,4),(3,41,0,1,1,4),(3,42,0,1,1,4),(3,43,0,1,1,4),(3,44,0,1,1,4),(3,45,0,1,1,4),(3,46,0,1,1,4),(4,1,0,1,1,4),(4,2,0,1,1,4),(4,3,0,1,1,4),(4,4,0,1,1,4),(4,5,0,1,1,4),(4,6,0,1,1,4),(4,7,0,1,1,4),(4,8,0,1,1,4),(4,9,0,1,1,4),(4,10,0,1,1,4),(4,11,0,1,1,4),(4,12,0,1,1,4),(4,13,0,1,1,4),(4,14,0,1,1,4),(5,15,0,1,1,4),(5,16,0,1,1,4),(5,17,0,1,1,4),(5,18,0,1,1,4),(5,19,0,1,1,4),(5,20,0,1,1,4),(5,21,0,1,1,4),(5,22,0,1,1,4),(5,23,0,1,1,4),(5,45,0,1,1,4),(5,46,0,1,1,4),(6,36,0,1,1,4),(6,37,0,1,1,4),(6,38,0,1,1,4),(6,39,0,1,1,4),(6,40,0,1,1,4),(6,41,0,1,1,4),(6,42,0,1,1,4),(6,43,0,1,1,4),(6,44,0,1,1,4),(8,1997,-339,1,1,4),(8,1951,-332,1,1,4),(8,1919,-316,1,1,4),(8,1833,-300,1,1,4),(8,1716,-293,1,1,4),(8,1636,-277,1,1,4),(8,1476,-261,1,1,4),(8,1460,-245,1,1,4),(8,1444,-229,1,1,4),(8,1412,-213,1,1,4),(8,1364,-197,1,1,4),(8,1348,-181,1,1,4),(8,1268,-165,1,1,4),(8,1220,-149,1,1,4),(8,1178,-139,1,1,4),(8,1130,-123,1,1,4),(8,1044,-107,1,1,4),(8,1002,-91,1,1,4),(8,950,-78,1,1,4),(8,841,-65,1,1,4),(8,828,-52,1,1,4),(8,815,-39,1,1,4),(8,789,-26,1,1,4),(8,763,-13,1,1,4),(8,4,0,1,1,4),(8,5,0,1,1,4),(8,13,0,1,1,4),(8,19,0,1,1,4),(8,38,0,1,1,4),(8,39,0,1,1,4),(8,40,0,1,1,4),(8,44,0,1,1,4),(12,254,9792,0,1,4),(12,238,9808,0,1,4),(12,622,9808,0,1,4),(12,222,9824,0,1,4),(12,430,9824,0,1,4),(12,606,9824,0,1,4),(12,206,9840,0,1,4),(12,414,9840,0,1,4),(12,590,9840,0,1,4),(12,190,9856,0,1,4),(12,398,9856,0,1,4),(12,574,9856,0,1,4),(12,174,9872,0,1,4),(12,382,9872,0,1,4),(12,558,9872,0,1,4),(12,158,9888,0,1,4),(12,366,9888,0,1,4),(12,542,9888,0,1,4),(12,724,9898,0,1,4),(12,142,9904,0,1,4),(12,350,9904,0,1,4),(12,526,9904,0,1,4),(12,718,9904,0,1,4),(12,712,9910,0,1,4),(12,706,9916,0,1,4),(12,126,9920,0,1,4),(12,334,9920,0,1,4),(12,510,9920,0,1,4),(12,700,9922,0,1,4),(12,694,9928,0,1,4),(12,688,9934,0,1,4),(12,110,9936,0,1,4),(12,318,9936,0,1,4),(12,494,9936,0,1,4),(12,682,9940,0,1,4),(12,676,9946,0,1,4),(12,94,9952,0,1,4),(12,302,9952,0,1,4),(12,478,9952,0,1,4),(12,670,9952,0,1,4),(12,78,9968,0,1,4),(12,286,9968,0,1,4),(12,462,9968,0,1,4),(12,654,9968,0,1,4),(12,62,9984,0,1,4),(12,270,9984,0,1,4),(12,446,9984,0,1,4),(12,638,9984,0,1,4),(13,880,9844,0,1,4),(13,1028,9852,0,1,4),(13,867,9857,0,1,4),(13,1015,9865,0,1,4),(13,854,9870,0,1,4),(13,1002,9878,0,1,4),(13,841,9883,0,1,4),(13,989,9891,0,1,4),(13,828,9896,0,1,4),(13,976,9904,0,1,4),(13,815,9909,0,1,4),(13,963,9917,0,1,4),(13,802,9922,0,1,4),(13,950,9930,0,1,4),(13,789,9935,0,1,4),(13,937,9943,0,1,4),(13,776,9948,0,1,4),(13,924,9956,0,1,4),(13,763,9961,0,1,4),(13,911,9969,0,1,4),(13,750,9974,0,1,4),(13,898,9982,0,1,4),(13,737,9987,0,1,4),(13,893,9987,0,1,4),(14,430,-176,1,1,4),(14,414,-160,1,1,4),(14,398,-144,1,1,4),(14,382,-128,1,1,4),(14,366,-112,1,1,4),(14,350,-96,1,1,4),(14,334,-80,1,1,4),(14,318,-64,1,1,4),(14,302,-48,1,1,4),(14,286,-32,1,1,4),(14,270,-16,1,1,4),(15,254,-208,1,1,4),(15,238,-192,1,1,4),(15,222,-176,1,1,4),(15,206,-160,1,1,4),(15,190,-144,1,1,4),(15,174,-128,1,1,4),(15,158,-112,1,1,4),(15,142,-96,1,1,4),(15,126,-80,1,1,4),(15,110,-64,1,1,4),(15,94,-48,1,1,4),(15,78,-32,1,1,4),(15,62,-16,1,1,4),(16,622,-192,1,1,4),(16,606,-176,1,1,4),(16,590,-160,1,1,4),(16,574,-144,1,1,4),(16,558,-128,1,1,4),(16,542,-112,1,1,4),(16,526,-96,1,1,4),(16,510,-80,1,1,4),(16,494,-64,1,1,4),(16,478,-48,1,1,4),(16,462,-32,1,1,4),(16,446,-16,1,1,4),(17,724,-102,1,1,4),(17,718,-96,1,1,4),(17,712,-90,1,1,4),(17,706,-84,1,1,4),(17,700,-78,1,1,4),(17,694,-72,1,1,4),(17,688,-66,1,1,4),(17,682,-60,1,1,4),(17,676,-54,1,1,4),(17,670,-48,1,1,4),(17,654,-32,1,1,4),(17,638,-16,1,1,4),(18,880,-156,1,1,4),(18,867,-143,1,1,4),(18,854,-130,1,1,4),(18,841,-117,1,1,4),(18,828,-104,1,1,4),(18,815,-91,1,1,4),(18,802,-78,1,1,4),(18,789,-65,1,1,4),(18,776,-52,1,1,4),(18,763,-39,1,1,4),(18,750,-26,1,1,4),(18,737,-13,1,1,4),(19,1028,-148,1,1,4),(19,1015,-135,1,1,4),(19,1002,-122,1,1,4),(19,989,-109,1,1,4),(19,976,-96,1,1,4),(19,963,-83,1,1,4),(19,950,-70,1,1,4),(19,937,-57,1,1,4),(19,924,-44,1,1,4),(19,911,-31,1,1,4),(19,898,-18,1,1,4),(19,893,-13,1,1,4),(21,1812,9776,0,1,4),(21,1796,9792,0,1,4),(21,1588,9808,0,1,4),(21,1780,9808,0,1,4),(21,1396,9814,0,1,4),(21,1210,9818,0,1,4),(21,1572,9824,0,1,4),(21,1764,9824,0,1,4),(21,1380,9830,0,1,4),(21,1194,9834,0,1,4),(21,1556,9840,0,1,4),(21,1748,9840,0,1,4),(21,1364,9846,0,1,4),(21,1178,9850,0,1,4),(21,1540,9856,0,1,4),(21,1732,9856,0,1,4),(21,1348,9862,0,1,4),(21,1162,9866,0,1,4),(21,1524,9872,0,1,4),(21,1716,9872,0,1,4),(21,1332,9878,0,1,4),(21,1146,9882,0,1,4),(21,1508,9888,0,1,4),(21,1700,9888,0,1,4),(21,1316,9894,0,1,4),(21,1130,9898,0,1,4),(21,1492,9904,0,1,4),(21,1684,9904,0,1,4),(21,1300,9910,0,1,4),(21,1114,9914,0,1,4),(21,1108,9920,0,1,4),(21,1476,9920,0,1,4),(21,1668,9920,0,1,4),(21,1284,9926,0,1,4),(21,1092,9936,0,1,4),(21,1460,9936,0,1,4),(21,1652,9936,0,1,4),(21,1268,9942,0,1,4),(21,1076,9952,0,1,4),(21,1444,9952,0,1,4),(21,1636,9952,0,1,4),(21,1252,9958,0,1,4),(21,1060,9968,0,1,4),(21,1428,9968,0,1,4),(21,1620,9968,0,1,4),(21,1236,9974,0,1,4),(21,1044,9984,0,1,4),(21,1412,9984,0,1,4),(21,1604,9984,0,1,4),(21,1220,9990,0,1,4),(22,2040,9863,0,1,4),(22,2024,9879,0,1,4),(22,2017,9886,0,1,4),(22,2010,9893,0,1,4),(22,2003,9900,0,1,4),(22,1997,9906,0,1,4),(22,1903,9909,0,1,4),(22,1990,9913,0,1,4),(22,1896,9916,0,1,4),(22,1983,9920,0,1,4),(22,1889,9923,0,1,4),(22,1882,9930,0,1,4),(22,1967,9936,0,1,4),(22,1875,9937,0,1,4),(22,1868,9944,0,1,4),(22,1861,9951,0,1,4),(22,1951,9952,0,1,4),(22,1854,9958,0,1,4),(22,1847,9965,0,1,4),(22,1935,9968,0,1,4),(22,1840,9972,0,1,4),(22,1833,9979,0,1,4),(22,1919,9984,0,1,4),(22,1826,9986,0,1,4),(22,1819,9993,0,1,4),(23,1396,-186,1,1,4),(23,1380,-170,1,1,4),(23,1364,-154,1,1,4),(23,1348,-138,1,1,4),(23,1332,-122,1,1,4),(23,1316,-106,1,1,4),(23,1300,-90,1,1,4),(23,1284,-74,1,1,4),(23,1268,-58,1,1,4),(23,1252,-42,1,1,4),(23,1236,-26,1,1,4),(23,1220,-10,1,1,4),(24,1210,-182,1,1,4),(24,1194,-166,1,1,4),(24,1178,-150,1,1,4),(24,1162,-134,1,1,4),(24,1146,-118,1,1,4),(24,1130,-102,1,1,4),(24,1114,-86,1,1,4),(24,1108,-80,1,1,4),(24,1092,-64,1,1,4),(24,1076,-48,1,1,4),(24,1060,-32,1,1,4),(24,1044,-16,1,1,4),(25,1588,-192,1,1,4),(25,1572,-176,1,1,4),(25,1556,-160,1,1,4),(25,1540,-144,1,1,4),(25,1524,-128,1,1,4),(25,1508,-112,1,1,4),(25,1492,-96,1,1,4),(25,1476,-80,1,1,4),(25,1460,-64,1,1,4),(25,1444,-48,1,1,4),(25,1428,-32,1,1,4),(25,1412,-16,1,1,4),(26,1812,-224,1,1,4),(26,1796,-208,1,1,4),(26,1780,-192,1,1,4),(26,1764,-176,1,1,4),(26,1748,-160,1,1,4),(26,1732,-144,1,1,4),(26,1716,-128,1,1,4),(26,1700,-112,1,1,4),(26,1684,-96,1,1,4),(26,1668,-80,1,1,4),(26,1652,-64,1,1,4),(26,1636,-48,1,1,4),(26,1620,-32,1,1,4),(26,1604,-16,1,1,4),(27,1903,-91,1,1,4),(27,1896,-84,1,1,4),(27,1889,-77,1,1,4),(27,1882,-70,1,1,4),(27,1875,-63,1,1,4),(27,1868,-56,1,1,4),(27,1861,-49,1,1,4),(27,1854,-42,1,1,4),(27,1847,-35,1,1,4),(27,1840,-28,1,1,4),(27,1833,-21,1,1,4),(27,1826,-14,1,1,4),(27,1819,-7,1,1,4),(28,2040,-137,1,1,4),(28,2024,-121,1,1,4),(28,2017,-114,1,1,4),(28,2010,-107,1,1,4),(28,2003,-100,1,1,4),(28,1997,-94,1,1,4),(28,1990,-87,1,1,4),(28,1983,-80,1,1,4),(28,1967,-64,1,1,4),(28,1951,-48,1,1,4),(28,1935,-32,1,1,4),(28,1919,-16,1,1,4),(30,1983,-224,1,1,4),(30,1935,-208,1,1,4),(30,1812,-192,1,1,4),(30,1796,-176,1,1,4),(30,1604,-160,1,1,4),(30,1540,-144,1,1,4),(30,1508,-128,1,1,4),(30,1492,-112,1,1,4),(30,1396,-96,1,1,4),(30,1380,-80,1,1,4),(30,1316,-64,1,1,4),(30,1236,-48,1,1,4),(30,1146,-32,1,1,4),(30,1060,-16,1,1,4),(31,1028,-39,1,1,4),(31,976,-26,1,1,4),(31,963,-13,1,1,4),(32,1903,-247,1,1,4),(32,1896,-240,1,1,4),(32,1889,-233,1,1,4),(32,1882,-226,1,1,4),(32,1875,-219,1,1,4),(32,1868,-212,1,1,4),(32,1861,-205,1,1,4),(32,1854,-198,1,1,4),(32,1847,-191,1,1,4),(32,1840,-184,1,1,4),(32,1833,-177,1,1,4),(32,1826,-170,1,1,4),(32,1819,-163,1,1,4),(32,880,-156,1,1,4),(32,867,-143,1,1,4),(32,854,-130,1,1,4),(32,841,-117,1,1,4),(32,828,-104,1,1,4),(32,815,-91,1,1,4),(32,802,-78,1,1,4),(32,789,-65,1,1,4),(32,776,-52,1,1,4),(32,763,-39,1,1,4),(32,750,-26,1,1,4),(32,737,-13,1,1,4),(33,1588,-192,1,1,4),(33,1572,-176,1,1,4),(33,1556,-160,1,1,4),(33,1540,-144,1,1,4),(33,1524,-128,1,1,4),(33,1508,-112,1,1,4),(33,1492,-96,1,1,4),(33,1476,-80,1,1,4),(33,1460,-64,1,1,4),(33,1444,-48,1,1,4),(33,1428,-32,1,1,4),(33,1412,-16,1,1,4),(34,2040,-279,1,1,4),(34,2024,-263,1,1,4),(34,1903,-256,1,1,4),(34,1854,-249,1,1,4),(34,1847,-242,1,1,4),(34,1812,-235,1,1,4),(34,1748,-219,1,1,4),(34,1716,-203,1,1,4),(34,1540,-187,1,1,4),(34,1476,-171,1,1,4),(34,1332,-155,1,1,4),(34,1316,-139,1,1,4),(34,1220,-123,1,1,4),(34,1194,-113,1,1,4),(34,1130,-97,1,1,4),(34,1044,-81,1,1,4),(34,963,-65,1,1,4),(34,893,-52,1,1,4),(34,867,-39,1,1,4),(34,854,-26,1,1,4),(34,841,-13,1,1,4),(35,2003,-310,1,1,4),(35,1951,-304,1,1,4),(35,1896,-288,1,1,4),(35,1861,-281,1,1,4),(35,1826,-274,1,1,4),(35,1819,-267,1,1,4),(35,1796,-260,1,1,4),(35,1780,-244,1,1,4),(35,1732,-228,1,1,4),(35,1636,-212,1,1,4),(35,1556,-196,1,1,4),(35,1524,-180,1,1,4),(35,1428,-164,1,1,4),(35,1396,-148,1,1,4),(35,1380,-132,1,1,4),(35,1348,-116,1,1,4),(35,1268,-100,1,1,4),(35,1210,-84,1,1,4),(35,1146,-68,1,1,4),(35,989,-52,1,1,4),(35,937,-39,1,1,4),(35,911,-26,1,1,4),(35,750,-13,1,1,4),(36,2017,-247,1,1,4),(36,1919,-240,1,1,4),(36,1882,-224,1,1,4),(36,1684,-217,1,1,4),(36,1604,-201,1,1,4),(36,1508,-185,1,1,4),(36,1460,-169,1,1,4),(36,1444,-153,1,1,4),(36,1162,-137,1,1,4),(36,802,-121,1,1,4),(36,718,-108,1,1,4),(36,694,-102,1,1,4),(36,462,-96,1,1,4),(36,398,-80,1,1,4),(36,302,-64,1,1,4),(36,110,-48,1,1,4),(36,94,-32,1,1,4),(36,62,-16,1,1,4);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product_index_store1` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_product_index_store1_replica`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_product_index_store1_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_category_product_index_store1_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_6FBAC0A8825789D69AB86505B4914089` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_8F15547F72AF00C7861A223EC6C69052` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Prmg Catalog Category Product Index Store1 Replica';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_product_index_store1_replica`
--

LOCK TABLES `[[dbprefix]]catalog_category_product_index_store1_replica` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product_index_store1_replica` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_category_product_index_store1_replica` VALUES (2,2040,-1181,1,1,4),(2,2024,-1165,1,1,4),(2,2017,-1158,1,1,4),(2,2003,-1151,1,1,4),(2,1997,-1145,1,1,4),(2,1983,-1138,1,1,4),(2,1951,-1122,1,1,4),(2,1935,-1106,1,1,4),(2,1919,-1090,1,1,4),(2,1903,-1074,1,1,4),(2,1896,-1067,1,1,4),(2,1889,-1060,1,1,4),(2,1882,-1053,1,1,4),(2,1875,-1046,1,1,4),(2,1868,-1039,1,1,4),(2,1861,-1032,1,1,4),(2,1854,-1025,1,1,4),(2,1847,-1018,1,1,4),(2,1840,-1011,1,1,4),(2,1833,-1004,1,1,4),(2,1826,-997,1,1,4),(2,1819,-990,1,1,4),(2,1812,-983,1,1,4),(2,1796,-967,1,1,4),(2,1780,-951,1,1,4),(2,1748,-935,1,1,4),(2,1732,-919,1,1,4),(2,1716,-903,1,1,4),(2,1684,-887,1,1,4),(2,1636,-871,1,1,4),(2,1604,-855,1,1,4),(2,1588,-839,1,1,4),(2,1572,-823,1,1,4),(2,1556,-807,1,1,4),(2,1540,-791,1,1,4),(2,1524,-775,1,1,4),(2,1508,-759,1,1,4),(2,1492,-743,1,1,4),(2,1476,-727,1,1,4),(2,1460,-711,1,1,4),(2,1444,-695,1,1,4),(2,1428,-679,1,1,4),(2,1412,-663,1,1,4),(2,1396,-647,1,1,4),(2,1380,-631,1,1,4),(2,1364,-615,1,1,4),(2,1348,-599,1,1,4),(2,1332,-583,1,1,4),(2,1316,-567,1,1,4),(2,1268,-551,1,1,4),(2,1236,-535,1,1,4),(2,1220,-519,1,1,4),(2,1210,-509,1,1,4),(2,1194,-493,1,1,4),(2,1178,-477,1,1,4),(2,1162,-461,1,1,4),(2,1146,-445,1,1,4),(2,1130,-429,1,1,4),(2,1060,-413,1,1,4),(2,1044,-397,1,1,4),(2,1028,-381,1,1,4),(2,1002,-368,1,1,4),(2,989,-355,1,1,4),(2,976,-342,1,1,4),(2,963,-329,1,1,4),(2,950,-316,1,1,4),(2,937,-303,1,1,4),(2,911,-290,1,1,4),(2,893,-277,1,1,4),(2,880,-264,1,1,4),(2,867,-251,1,1,4),(2,854,-238,1,1,4),(2,841,-225,1,1,4),(2,828,-212,1,1,4),(2,254,-208,1,1,4),(2,815,-199,1,1,4),(2,238,-192,1,1,4),(2,622,-192,1,1,4),(2,802,-186,1,1,4),(2,222,-176,1,1,4),(2,430,-176,1,1,4),(2,606,-176,1,1,4),(2,1764,-176,1,1,4),(2,789,-173,1,1,4),(2,206,-160,1,1,4),(2,414,-160,1,1,4),(2,590,-160,1,1,4),(2,776,-160,1,1,4),(2,763,-147,1,1,4),(2,190,-144,1,1,4),(2,398,-144,1,1,4),(2,574,-144,1,1,4),(2,1015,-135,1,1,4),(2,750,-134,1,1,4),(2,174,-128,1,1,4),(2,382,-128,1,1,4),(2,558,-128,1,1,4),(2,737,-121,1,1,4),(2,158,-112,1,1,4),(2,366,-112,1,1,4),(2,542,-112,1,1,4),(2,1700,-112,1,1,4),(2,718,-108,1,1,4),(2,2010,-107,1,1,4),(2,694,-102,1,1,4),(2,724,-102,1,1,4),(2,142,-96,1,1,4),(2,350,-96,1,1,4),(2,462,-96,1,1,4),(2,526,-96,1,1,4),(2,712,-90,1,1,4),(2,1300,-90,1,1,4),(2,1990,-87,1,1,4),(2,1114,-86,1,1,4),(2,706,-84,1,1,4),(2,126,-80,1,1,4),(2,334,-80,1,1,4),(2,510,-80,1,1,4),(2,1108,-80,1,1,4),(2,1668,-80,1,1,4),(2,700,-78,1,1,4),(2,1284,-74,1,1,4),(2,688,-66,1,1,4),(2,110,-64,1,1,4),(2,302,-64,1,1,4),(2,318,-64,1,1,4),(2,494,-64,1,1,4),(2,1092,-64,1,1,4),(2,1652,-64,1,1,4),(2,1967,-64,1,1,4),(2,682,-60,1,1,4),(2,676,-54,1,1,4),(2,94,-48,1,1,4),(2,478,-48,1,1,4),(2,670,-48,1,1,4),(2,1076,-48,1,1,4),(2,924,-44,1,1,4),(2,1252,-42,1,1,4),(2,78,-32,1,1,4),(2,286,-32,1,1,4),(2,654,-32,1,1,4),(2,1620,-32,1,1,4),(2,898,-18,1,1,4),(2,62,-16,1,1,4),(2,270,-16,1,1,4),(2,446,-16,1,1,4),(2,638,-16,1,1,4),(2,1,0,1,1,4),(2,2,0,1,1,4),(2,3,0,1,1,4),(2,4,0,1,1,4),(2,5,0,1,1,4),(2,6,0,1,1,4),(2,7,0,1,1,4),(2,8,0,1,1,4),(2,9,0,1,1,4),(2,10,0,1,1,4),(2,11,0,1,1,4),(2,12,0,1,1,4),(2,13,0,1,1,4),(2,14,0,1,1,4),(2,15,0,1,1,4),(2,16,0,1,1,4),(2,17,0,1,1,4),(2,18,0,1,1,4),(2,19,0,1,1,4),(2,20,0,1,1,4),(2,21,0,1,1,4),(2,22,0,1,1,4),(2,23,0,1,1,4),(2,36,0,1,1,4),(2,37,0,1,1,4),(2,38,0,1,1,4),(2,39,0,1,1,4),(2,40,0,1,1,4),(2,41,0,1,1,4),(2,42,0,1,1,4),(2,43,0,1,1,4),(2,44,0,1,1,4),(2,45,0,1,1,4),(2,46,0,1,1,4),(3,1,0,1,1,4),(3,2,0,1,1,4),(3,3,0,1,1,4),(3,4,0,1,1,4),(3,5,0,1,1,4),(3,6,0,1,1,4),(3,7,0,1,1,4),(3,8,0,1,1,4),(3,9,0,1,1,4),(3,10,0,1,1,4),(3,11,0,1,1,4),(3,12,0,1,1,4),(3,13,0,1,1,4),(3,14,0,1,1,4),(3,15,0,1,1,4),(3,16,0,1,1,4),(3,17,0,1,1,4),(3,18,0,1,1,4),(3,19,0,1,1,4),(3,20,0,1,1,4),(3,21,0,1,1,4),(3,22,0,1,1,4),(3,23,0,1,1,4),(3,36,0,1,1,4),(3,37,0,1,1,4),(3,38,0,1,1,4),(3,39,0,1,1,4),(3,40,0,1,1,4),(3,41,0,1,1,4),(3,42,0,1,1,4),(3,43,0,1,1,4),(3,44,0,1,1,4),(3,45,0,1,1,4),(3,46,0,1,1,4),(4,1,0,1,1,4),(4,2,0,1,1,4),(4,3,0,1,1,4),(4,4,0,1,1,4),(4,5,0,1,1,4),(4,6,0,1,1,4),(4,7,0,1,1,4),(4,8,0,1,1,4),(4,9,0,1,1,4),(4,10,0,1,1,4),(4,11,0,1,1,4),(4,12,0,1,1,4),(4,13,0,1,1,4),(4,14,0,1,1,4),(5,15,0,1,1,4),(5,16,0,1,1,4),(5,17,0,1,1,4),(5,18,0,1,1,4),(5,19,0,1,1,4),(5,20,0,1,1,4),(5,21,0,1,1,4),(5,22,0,1,1,4),(5,23,0,1,1,4),(5,45,0,1,1,4),(5,46,0,1,1,4),(6,36,0,1,1,4),(6,37,0,1,1,4),(6,38,0,1,1,4),(6,39,0,1,1,4),(6,40,0,1,1,4),(6,41,0,1,1,4),(6,42,0,1,1,4),(6,43,0,1,1,4),(6,44,0,1,1,4),(8,1997,-339,1,1,4),(8,1951,-332,1,1,4),(8,1919,-316,1,1,4),(8,1833,-300,1,1,4),(8,1716,-293,1,1,4),(8,1636,-277,1,1,4),(8,1476,-261,1,1,4),(8,1460,-245,1,1,4),(8,1444,-229,1,1,4),(8,1412,-213,1,1,4),(8,1364,-197,1,1,4),(8,1348,-181,1,1,4),(8,1268,-165,1,1,4),(8,1220,-149,1,1,4),(8,1178,-139,1,1,4),(8,1130,-123,1,1,4),(8,1044,-107,1,1,4),(8,1002,-91,1,1,4),(8,950,-78,1,1,4),(8,841,-65,1,1,4),(8,828,-52,1,1,4),(8,815,-39,1,1,4),(8,789,-26,1,1,4),(8,763,-13,1,1,4),(8,4,0,1,1,4),(8,5,0,1,1,4),(8,13,0,1,1,4),(8,19,0,1,1,4),(8,38,0,1,1,4),(8,39,0,1,1,4),(8,40,0,1,1,4),(8,44,0,1,1,4),(12,254,9792,0,1,4),(12,238,9808,0,1,4),(12,622,9808,0,1,4),(12,222,9824,0,1,4),(12,430,9824,0,1,4),(12,606,9824,0,1,4),(12,206,9840,0,1,4),(12,414,9840,0,1,4),(12,590,9840,0,1,4),(12,190,9856,0,1,4),(12,398,9856,0,1,4),(12,574,9856,0,1,4),(12,174,9872,0,1,4),(12,382,9872,0,1,4),(12,558,9872,0,1,4),(12,158,9888,0,1,4),(12,366,9888,0,1,4),(12,542,9888,0,1,4),(12,724,9898,0,1,4),(12,142,9904,0,1,4),(12,350,9904,0,1,4),(12,526,9904,0,1,4),(12,718,9904,0,1,4),(12,712,9910,0,1,4),(12,706,9916,0,1,4),(12,126,9920,0,1,4),(12,334,9920,0,1,4),(12,510,9920,0,1,4),(12,700,9922,0,1,4),(12,694,9928,0,1,4),(12,688,9934,0,1,4),(12,110,9936,0,1,4),(12,318,9936,0,1,4),(12,494,9936,0,1,4),(12,682,9940,0,1,4),(12,676,9946,0,1,4),(12,94,9952,0,1,4),(12,302,9952,0,1,4),(12,478,9952,0,1,4),(12,670,9952,0,1,4),(12,78,9968,0,1,4),(12,286,9968,0,1,4),(12,462,9968,0,1,4),(12,654,9968,0,1,4),(12,62,9984,0,1,4),(12,270,9984,0,1,4),(12,446,9984,0,1,4),(12,638,9984,0,1,4),(13,880,9844,0,1,4),(13,1028,9852,0,1,4),(13,867,9857,0,1,4),(13,1015,9865,0,1,4),(13,854,9870,0,1,4),(13,1002,9878,0,1,4),(13,841,9883,0,1,4),(13,989,9891,0,1,4),(13,828,9896,0,1,4),(13,976,9904,0,1,4),(13,815,9909,0,1,4),(13,963,9917,0,1,4),(13,802,9922,0,1,4),(13,950,9930,0,1,4),(13,789,9935,0,1,4),(13,937,9943,0,1,4),(13,776,9948,0,1,4),(13,924,9956,0,1,4),(13,763,9961,0,1,4),(13,911,9969,0,1,4),(13,750,9974,0,1,4),(13,898,9982,0,1,4),(13,737,9987,0,1,4),(13,893,9987,0,1,4),(14,430,-176,1,1,4),(14,414,-160,1,1,4),(14,398,-144,1,1,4),(14,382,-128,1,1,4),(14,366,-112,1,1,4),(14,350,-96,1,1,4),(14,334,-80,1,1,4),(14,318,-64,1,1,4),(14,302,-48,1,1,4),(14,286,-32,1,1,4),(14,270,-16,1,1,4),(15,254,-208,1,1,4),(15,238,-192,1,1,4),(15,222,-176,1,1,4),(15,206,-160,1,1,4),(15,190,-144,1,1,4),(15,174,-128,1,1,4),(15,158,-112,1,1,4),(15,142,-96,1,1,4),(15,126,-80,1,1,4),(15,110,-64,1,1,4),(15,94,-48,1,1,4),(15,78,-32,1,1,4),(15,62,-16,1,1,4),(16,622,-192,1,1,4),(16,606,-176,1,1,4),(16,590,-160,1,1,4),(16,574,-144,1,1,4),(16,558,-128,1,1,4),(16,542,-112,1,1,4),(16,526,-96,1,1,4),(16,510,-80,1,1,4),(16,494,-64,1,1,4),(16,478,-48,1,1,4),(16,462,-32,1,1,4),(16,446,-16,1,1,4),(17,724,-102,1,1,4),(17,718,-96,1,1,4),(17,712,-90,1,1,4),(17,706,-84,1,1,4),(17,700,-78,1,1,4),(17,694,-72,1,1,4),(17,688,-66,1,1,4),(17,682,-60,1,1,4),(17,676,-54,1,1,4),(17,670,-48,1,1,4),(17,654,-32,1,1,4),(17,638,-16,1,1,4),(18,880,-156,1,1,4),(18,867,-143,1,1,4),(18,854,-130,1,1,4),(18,841,-117,1,1,4),(18,828,-104,1,1,4),(18,815,-91,1,1,4),(18,802,-78,1,1,4),(18,789,-65,1,1,4),(18,776,-52,1,1,4),(18,763,-39,1,1,4),(18,750,-26,1,1,4),(18,737,-13,1,1,4),(19,1028,-148,1,1,4),(19,1015,-135,1,1,4),(19,1002,-122,1,1,4),(19,989,-109,1,1,4),(19,976,-96,1,1,4),(19,963,-83,1,1,4),(19,950,-70,1,1,4),(19,937,-57,1,1,4),(19,924,-44,1,1,4),(19,911,-31,1,1,4),(19,898,-18,1,1,4),(19,893,-13,1,1,4),(21,1812,9776,0,1,4),(21,1796,9792,0,1,4),(21,1588,9808,0,1,4),(21,1780,9808,0,1,4),(21,1396,9814,0,1,4),(21,1210,9818,0,1,4),(21,1572,9824,0,1,4),(21,1764,9824,0,1,4),(21,1380,9830,0,1,4),(21,1194,9834,0,1,4),(21,1556,9840,0,1,4),(21,1748,9840,0,1,4),(21,1364,9846,0,1,4),(21,1178,9850,0,1,4),(21,1540,9856,0,1,4),(21,1732,9856,0,1,4),(21,1348,9862,0,1,4),(21,1162,9866,0,1,4),(21,1524,9872,0,1,4),(21,1716,9872,0,1,4),(21,1332,9878,0,1,4),(21,1146,9882,0,1,4),(21,1508,9888,0,1,4),(21,1700,9888,0,1,4),(21,1316,9894,0,1,4),(21,1130,9898,0,1,4),(21,1492,9904,0,1,4),(21,1684,9904,0,1,4),(21,1300,9910,0,1,4),(21,1114,9914,0,1,4),(21,1108,9920,0,1,4),(21,1476,9920,0,1,4),(21,1668,9920,0,1,4),(21,1284,9926,0,1,4),(21,1092,9936,0,1,4),(21,1460,9936,0,1,4),(21,1652,9936,0,1,4),(21,1268,9942,0,1,4),(21,1076,9952,0,1,4),(21,1444,9952,0,1,4),(21,1636,9952,0,1,4),(21,1252,9958,0,1,4),(21,1060,9968,0,1,4),(21,1428,9968,0,1,4),(21,1620,9968,0,1,4),(21,1236,9974,0,1,4),(21,1044,9984,0,1,4),(21,1412,9984,0,1,4),(21,1604,9984,0,1,4),(21,1220,9990,0,1,4),(22,2040,9863,0,1,4),(22,2024,9879,0,1,4),(22,2017,9886,0,1,4),(22,2010,9893,0,1,4),(22,2003,9900,0,1,4),(22,1997,9906,0,1,4),(22,1903,9909,0,1,4),(22,1990,9913,0,1,4),(22,1896,9916,0,1,4),(22,1983,9920,0,1,4),(22,1889,9923,0,1,4),(22,1882,9930,0,1,4),(22,1967,9936,0,1,4),(22,1875,9937,0,1,4),(22,1868,9944,0,1,4),(22,1861,9951,0,1,4),(22,1951,9952,0,1,4),(22,1854,9958,0,1,4),(22,1847,9965,0,1,4),(22,1935,9968,0,1,4),(22,1840,9972,0,1,4),(22,1833,9979,0,1,4),(22,1919,9984,0,1,4),(22,1826,9986,0,1,4),(22,1819,9993,0,1,4),(23,1396,-186,1,1,4),(23,1380,-170,1,1,4),(23,1364,-154,1,1,4),(23,1348,-138,1,1,4),(23,1332,-122,1,1,4),(23,1316,-106,1,1,4),(23,1300,-90,1,1,4),(23,1284,-74,1,1,4),(23,1268,-58,1,1,4),(23,1252,-42,1,1,4),(23,1236,-26,1,1,4),(23,1220,-10,1,1,4),(24,1210,-182,1,1,4),(24,1194,-166,1,1,4),(24,1178,-150,1,1,4),(24,1162,-134,1,1,4),(24,1146,-118,1,1,4),(24,1130,-102,1,1,4),(24,1114,-86,1,1,4),(24,1108,-80,1,1,4),(24,1092,-64,1,1,4),(24,1076,-48,1,1,4),(24,1060,-32,1,1,4),(24,1044,-16,1,1,4),(25,1588,-192,1,1,4),(25,1572,-176,1,1,4),(25,1556,-160,1,1,4),(25,1540,-144,1,1,4),(25,1524,-128,1,1,4),(25,1508,-112,1,1,4),(25,1492,-96,1,1,4),(25,1476,-80,1,1,4),(25,1460,-64,1,1,4),(25,1444,-48,1,1,4),(25,1428,-32,1,1,4),(25,1412,-16,1,1,4),(26,1812,-224,1,1,4),(26,1796,-208,1,1,4),(26,1780,-192,1,1,4),(26,1764,-176,1,1,4),(26,1748,-160,1,1,4),(26,1732,-144,1,1,4),(26,1716,-128,1,1,4),(26,1700,-112,1,1,4),(26,1684,-96,1,1,4),(26,1668,-80,1,1,4),(26,1652,-64,1,1,4),(26,1636,-48,1,1,4),(26,1620,-32,1,1,4),(26,1604,-16,1,1,4),(27,1903,-91,1,1,4),(27,1896,-84,1,1,4),(27,1889,-77,1,1,4),(27,1882,-70,1,1,4),(27,1875,-63,1,1,4),(27,1868,-56,1,1,4),(27,1861,-49,1,1,4),(27,1854,-42,1,1,4),(27,1847,-35,1,1,4),(27,1840,-28,1,1,4),(27,1833,-21,1,1,4),(27,1826,-14,1,1,4),(27,1819,-7,1,1,4),(28,2040,-137,1,1,4),(28,2024,-121,1,1,4),(28,2017,-114,1,1,4),(28,2010,-107,1,1,4),(28,2003,-100,1,1,4),(28,1997,-94,1,1,4),(28,1990,-87,1,1,4),(28,1983,-80,1,1,4),(28,1967,-64,1,1,4),(28,1951,-48,1,1,4),(28,1935,-32,1,1,4),(28,1919,-16,1,1,4),(30,1983,-224,1,1,4),(30,1935,-208,1,1,4),(30,1812,-192,1,1,4),(30,1796,-176,1,1,4),(30,1604,-160,1,1,4),(30,1540,-144,1,1,4),(30,1508,-128,1,1,4),(30,1492,-112,1,1,4),(30,1396,-96,1,1,4),(30,1380,-80,1,1,4),(30,1316,-64,1,1,4),(30,1236,-48,1,1,4),(30,1146,-32,1,1,4),(30,1060,-16,1,1,4),(31,1028,-39,1,1,4),(31,976,-26,1,1,4),(31,963,-13,1,1,4),(32,1903,-247,1,1,4),(32,1896,-240,1,1,4),(32,1889,-233,1,1,4),(32,1882,-226,1,1,4),(32,1875,-219,1,1,4),(32,1868,-212,1,1,4),(32,1861,-205,1,1,4),(32,1854,-198,1,1,4),(32,1847,-191,1,1,4),(32,1840,-184,1,1,4),(32,1833,-177,1,1,4),(32,1826,-170,1,1,4),(32,1819,-163,1,1,4),(32,880,-156,1,1,4),(32,867,-143,1,1,4),(32,854,-130,1,1,4),(32,841,-117,1,1,4),(32,828,-104,1,1,4),(32,815,-91,1,1,4),(32,802,-78,1,1,4),(32,789,-65,1,1,4),(32,776,-52,1,1,4),(32,763,-39,1,1,4),(32,750,-26,1,1,4),(32,737,-13,1,1,4),(33,1588,-192,1,1,4),(33,1572,-176,1,1,4),(33,1556,-160,1,1,4),(33,1540,-144,1,1,4),(33,1524,-128,1,1,4),(33,1508,-112,1,1,4),(33,1492,-96,1,1,4),(33,1476,-80,1,1,4),(33,1460,-64,1,1,4),(33,1444,-48,1,1,4),(33,1428,-32,1,1,4),(33,1412,-16,1,1,4),(34,2040,-279,1,1,4),(34,2024,-263,1,1,4),(34,1903,-256,1,1,4),(34,1854,-249,1,1,4),(34,1847,-242,1,1,4),(34,1812,-235,1,1,4),(34,1748,-219,1,1,4),(34,1716,-203,1,1,4),(34,1540,-187,1,1,4),(34,1476,-171,1,1,4),(34,1332,-155,1,1,4),(34,1316,-139,1,1,4),(34,1220,-123,1,1,4),(34,1194,-113,1,1,4),(34,1130,-97,1,1,4),(34,1044,-81,1,1,4),(34,963,-65,1,1,4),(34,893,-52,1,1,4),(34,867,-39,1,1,4),(34,854,-26,1,1,4),(34,841,-13,1,1,4),(35,2003,-310,1,1,4),(35,1951,-304,1,1,4),(35,1896,-288,1,1,4),(35,1861,-281,1,1,4),(35,1826,-274,1,1,4),(35,1819,-267,1,1,4),(35,1796,-260,1,1,4),(35,1780,-244,1,1,4),(35,1732,-228,1,1,4),(35,1636,-212,1,1,4),(35,1556,-196,1,1,4),(35,1524,-180,1,1,4),(35,1428,-164,1,1,4),(35,1396,-148,1,1,4),(35,1380,-132,1,1,4),(35,1348,-116,1,1,4),(35,1268,-100,1,1,4),(35,1210,-84,1,1,4),(35,1146,-68,1,1,4),(35,989,-52,1,1,4),(35,937,-39,1,1,4),(35,911,-26,1,1,4),(35,750,-13,1,1,4),(36,2017,-247,1,1,4),(36,1919,-240,1,1,4),(36,1882,-224,1,1,4),(36,1684,-217,1,1,4),(36,1604,-201,1,1,4),(36,1508,-185,1,1,4),(36,1460,-169,1,1,4),(36,1444,-153,1,1,4),(36,1162,-137,1,1,4),(36,802,-121,1,1,4),(36,718,-108,1,1,4),(36,694,-102,1,1,4),(36,462,-96,1,1,4),(36,398,-80,1,1,4),(36,302,-64,1,1,4),(36,110,-48,1,1,4),(36,94,-32,1,1,4),(36,62,-16,1,1,4);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product_index_store1_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_product_index_tmp`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_product_index_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_category_product_index_tmp` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int NOT NULL DEFAULT '0' COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `[[DBPREFIX]]CAT_CTGR_PRD_IDX_TMP_PRD_ID_CTGR_ID_STORE_ID` (`product_id`,`category_id`,`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Catalog Category Product Indexer temporary table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_product_index_tmp`
--

LOCK TABLES `[[dbprefix]]catalog_category_product_index_tmp` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product_index_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product_index_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_compare_item`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_compare_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_compare_item` (
  `catalog_compare_item_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Compare Item ID',
  `visitor_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Visitor ID',
  `customer_id` int unsigned DEFAULT NULL COMMENT 'Customer ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `list_id` int unsigned DEFAULT NULL COMMENT 'List ID',
  PRIMARY KEY (`catalog_compare_item_id`),
  KEY `[[DBPREFIX]]CAT_CMP_ITEM_LIST_ID_[[DBPREFIX]]CAT_CMP_LIST_LIST_ID` (`list_id`),
  KEY `[[DBPREFIX]]CATALOG_COMPARE_ITEM_PRODUCT_ID` (`product_id`),
  KEY `[[DBPREFIX]]CATALOG_COMPARE_ITEM_VISITOR_ID_PRODUCT_ID` (`visitor_id`,`product_id`),
  KEY `[[DBPREFIX]]CATALOG_COMPARE_ITEM_CUSTOMER_ID_PRODUCT_ID` (`customer_id`,`product_id`),
  KEY `[[DBPREFIX]]CATALOG_COMPARE_ITEM_STORE_ID` (`store_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_CMP_ITEM_CSTR_ID_[[DBPREFIX]]CSTR_ENTT_ENTT_ID` FOREIGN KEY (`customer_id`) REFERENCES `[[dbprefix]]customer_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_CMP_ITEM_LIST_ID_[[DBPREFIX]]CAT_CMP_LIST_LIST_ID` FOREIGN KEY (`list_id`) REFERENCES `[[dbprefix]]catalog_compare_list` (`list_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_CMP_ITEM_PRD_ID_[[DBPREFIX]]CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `[[dbprefix]]catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CATALOG_COMPARE_ITEM_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `[[dbprefix]]store` (`store_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Catalog Compare Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_compare_item`
--

LOCK TABLES `[[dbprefix]]catalog_compare_item` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_compare_item` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_compare_item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_compare_list`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_compare_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_compare_list` (
  `list_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Compare List ID',
  `list_id_mask` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'Masked ID',
  `customer_id` int unsigned DEFAULT NULL COMMENT 'Customer ID',
  PRIMARY KEY (`list_id`),
  UNIQUE KEY `[[DBPREFIX]]CATALOG_COMPARE_LIST_CUSTOMER_ID` (`customer_id`),
  KEY `[[DBPREFIX]]CATALOG_COMPARE_LIST_LIST_ID_MASK` (`list_id_mask`),
  CONSTRAINT `[[DBPREFIX]]CAT_CMP_LIST_CSTR_ID_[[DBPREFIX]]CSTR_ENTT_ENTT_ID` FOREIGN KEY (`customer_id`) REFERENCES `[[dbprefix]]customer_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Catalog Compare List with hash Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_compare_list`
--

LOCK TABLES `[[dbprefix]]catalog_compare_list` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_compare_list` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_compare_list` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_eav_attribute`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_eav_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_eav_attribute` (
  `attribute_id` smallint unsigned NOT NULL COMMENT 'Attribute ID',
  `frontend_input_renderer` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'Frontend Input Renderer',
  `is_global` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Is Global',
  `is_visible` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Is Visible',
  `is_searchable` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Searchable',
  `is_filterable` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Filterable',
  `is_comparable` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Comparable',
  `is_visible_on_front` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Visible On Front',
  `is_html_allowed_on_front` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is HTML Allowed On Front',
  `is_used_for_price_rules` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used For Price Rules',
  `is_filterable_in_search` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Filterable In Search',
  `used_in_product_listing` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used In Product Listing',
  `used_for_sort_by` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used For Sorting',
  `apply_to` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'Apply To',
  `is_visible_in_advanced_search` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Visible In Advanced Search',
  `position` int NOT NULL DEFAULT '0' COMMENT 'Position',
  `is_wysiwyg_enabled` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is WYSIWYG Enabled',
  `is_used_for_promo_rules` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used For Promo Rules',
  `is_required_in_admin_store` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Required In Admin Store',
  `is_used_in_grid` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used in Grid',
  `is_visible_in_grid` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Visible in Grid',
  `is_filterable_in_grid` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Filterable in Grid',
  `search_weight` float NOT NULL DEFAULT '1' COMMENT 'Search Weight',
  `is_pagebuilder_enabled` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Is PageBuilder Enabled',
  `additional_data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci COMMENT 'Additional swatch attributes data',
  PRIMARY KEY (`attribute_id`),
  KEY `[[DBPREFIX]]CATALOG_EAV_ATTRIBUTE_USED_FOR_SORT_BY` (`used_for_sort_by`),
  KEY `[[DBPREFIX]]CATALOG_EAV_ATTRIBUTE_USED_IN_PRODUCT_LISTING` (`used_in_product_listing`),
  CONSTRAINT `[[DBPREFIX]]CAT_EAV_ATTR_ATTR_ID_[[DBPREFIX]]EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]eav_attribute` (`attribute_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Catalog EAV Attribute Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_eav_attribute`
--

LOCK TABLES `[[dbprefix]]catalog_eav_attribute` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_eav_attribute` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_eav_attribute` VALUES (45,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(46,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(47,NULL,0,1,0,0,0,0,1,0,0,0,0,NULL,0,0,1,0,0,0,0,0,1,0,NULL),(48,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(49,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(50,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(51,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(52,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(53,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(54,NULL,1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(55,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(56,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(57,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(58,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(59,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(60,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(61,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(62,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(63,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(64,NULL,0,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(65,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(66,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(67,'Magento\\Catalog\\Block\\Adminhtml\\Category\\Helper\\Sortby\\Available',0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(68,'Magento\\Catalog\\Block\\Adminhtml\\Category\\Helper\\Sortby\\DefaultSortby',0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(69,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(70,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(71,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(72,'Magento\\Catalog\\Block\\Adminhtml\\Category\\Helper\\Pricestep',0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(73,NULL,0,1,1,0,0,0,0,0,0,1,1,NULL,1,0,0,0,0,0,0,0,5,0,NULL),(74,NULL,1,1,1,0,1,0,0,0,0,0,0,NULL,1,0,0,1,0,0,0,0,6,0,NULL),(75,NULL,0,1,1,0,1,0,1,0,0,0,0,NULL,1,0,1,0,0,0,0,0,1,1,NULL),(76,NULL,0,1,1,0,1,0,1,0,0,1,0,NULL,1,0,1,0,0,1,0,0,1,0,NULL),(77,NULL,1,1,1,1,0,0,0,0,0,1,1,'simple,virtual,bundle,downloadable,configurable',1,0,0,0,0,0,0,0,1,0,NULL),(78,NULL,1,1,0,0,0,0,0,0,0,1,0,'simple,virtual,bundle,downloadable,configurable',0,0,0,0,0,1,0,1,1,0,NULL),(79,NULL,2,1,0,0,0,0,0,0,0,1,0,'simple,virtual,bundle,downloadable,configurable',0,0,0,0,0,1,0,0,1,0,NULL),(80,NULL,2,1,0,0,0,0,0,0,0,1,0,'simple,virtual,bundle,downloadable,configurable',0,0,0,0,0,1,0,0,1,0,NULL),(81,NULL,1,1,0,0,0,0,0,0,0,0,0,'simple,virtual,downloadable',0,0,0,0,0,1,0,1,1,0,NULL),(82,'Magento\\Catalog\\Block\\Adminhtml\\Product\\Helper\\Form\\Weight',1,1,0,0,0,0,0,0,0,0,0,'simple,virtual,bundle,downloadable,configurable',0,0,0,0,0,1,0,1,1,0,NULL),(83,NULL,1,1,1,1,1,0,0,0,0,0,0,'simple,configurable',1,0,0,0,0,1,0,1,1,0,NULL),(84,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,1,1,0,NULL),(85,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,1,1,0,NULL),(86,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,1,1,0,NULL),(87,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(88,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(89,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(90,NULL,1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(91,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(92,NULL,2,1,0,0,0,0,0,0,0,0,0,'simple,virtual,bundle,downloadable',0,0,0,0,0,0,0,0,1,0,NULL),(93,NULL,1,1,0,1,0,0,1,0,0,1,0,'simple,virtual,configurable',0,0,0,1,0,1,0,1,1,0,'{\"swatch_input_type\":\"visual\",\"update_product_preview_image\":1,\"use_product_image_for_swatch\":0}'),(94,NULL,2,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,1,0,0,1,0,NULL),(95,NULL,2,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,1,0,0,1,0,NULL),(96,NULL,1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(97,'Magento\\Framework\\Data\\Form\\Element\\Hidden',2,1,1,0,0,0,0,0,0,1,0,NULL,0,0,0,0,1,0,0,0,1,0,NULL),(98,NULL,0,0,0,0,0,0,0,0,0,0,0,'simple,virtual,bundle,downloadable,configurable',0,0,0,0,0,0,0,0,1,0,NULL),(99,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,1,0,0,0,1,0,NULL),(100,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,1,1,0,NULL),(101,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,0,1,0,NULL),(102,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,0,1,0,NULL),(103,NULL,0,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(104,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,0,1,0,NULL),(105,'Magento\\Catalog\\Block\\Adminhtml\\Product\\Helper\\Form\\Category',1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(106,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(107,NULL,1,0,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(108,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(109,NULL,0,0,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(110,NULL,0,0,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(111,NULL,0,0,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(112,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(113,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(114,NULL,2,1,0,0,0,0,0,0,0,0,0,'simple,bundle,configurable,grouped',0,0,0,0,0,1,0,1,1,0,NULL),(115,'Magento\\CatalogInventory\\Block\\Adminhtml\\Form\\Field\\Stock',1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(116,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,0,1,0,NULL),(117,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(118,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(119,NULL,0,1,1,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(120,NULL,0,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(121,NULL,0,1,1,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,1,0,1,1,0,NULL),(122,NULL,0,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(123,'Magento\\Msrp\\Block\\Adminhtml\\Product\\Helper\\Form\\Type',1,1,0,0,0,0,0,0,0,1,0,'simple,virtual,downloadable,bundle,configurable',0,0,0,0,0,1,0,1,1,0,NULL),(124,'Magento\\Msrp\\Block\\Adminhtml\\Product\\Helper\\Form\\Type\\Price',2,1,0,0,0,0,0,0,0,1,0,'simple,virtual,downloadable,bundle,configurable',0,0,0,0,0,0,0,0,1,0,NULL),(125,NULL,1,1,0,0,0,0,0,0,0,1,0,'bundle',0,0,0,0,0,0,0,0,1,0,NULL),(126,NULL,1,1,0,0,0,0,0,0,0,0,0,'bundle',0,0,0,0,0,0,0,0,1,0,NULL),(127,NULL,1,1,0,0,0,0,0,0,0,1,0,'bundle',0,0,0,0,0,0,0,0,1,0,NULL),(128,NULL,1,1,0,0,0,0,0,0,0,1,0,'bundle',0,0,0,0,0,0,0,0,1,0,NULL),(129,NULL,1,1,0,0,0,0,0,0,0,1,0,'bundle',0,0,0,0,0,0,0,0,1,0,NULL),(130,NULL,1,0,0,0,0,0,0,0,0,1,0,'downloadable',0,0,0,0,0,0,0,0,1,0,NULL),(131,NULL,0,0,0,0,0,0,0,0,0,0,0,'downloadable',0,0,0,0,0,0,0,0,1,0,NULL),(132,NULL,0,0,0,0,0,0,0,0,0,0,0,'downloadable',0,0,0,0,0,0,0,0,1,0,NULL),(133,NULL,1,0,0,0,0,0,0,0,0,1,0,'downloadable',0,0,0,0,0,0,0,0,1,0,NULL),(134,NULL,2,1,1,0,0,0,0,0,0,1,0,'simple,virtual,bundle,downloadable,configurable',0,0,0,0,0,1,0,1,1,0,NULL),(135,NULL,1,1,0,1,1,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(136,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(137,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(138,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(139,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(140,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(141,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(142,NULL,1,1,0,1,0,0,1,0,0,1,0,NULL,0,0,0,1,0,0,0,0,1,0,'{\"swatch_input_type\":\"text\",\"update_product_preview_image\":1,\"use_product_image_for_swatch\":0}'),(143,NULL,1,1,0,1,0,0,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(144,NULL,1,1,0,1,0,0,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(145,NULL,1,1,0,1,0,0,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(146,NULL,1,1,0,1,0,0,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(147,NULL,1,1,0,1,0,0,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(148,'Magento\\GiftMessage\\Block\\Adminhtml\\Product\\Helper\\Form\\Config',1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,0,1,0,NULL),(149,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(150,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(151,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(152,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(153,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(154,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(155,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(156,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_eav_attribute` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_attribute_cl`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_attribute_cl`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_product_attribute_cl` (
  `version_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Version ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  PRIMARY KEY (`version_id`)
) ENGINE=InnoDB AUTO_INCREMENT=34054 DEFAULT CHARSET=utf8mb4 COMMENT='[[dbprefix]]catalog_product_attribute_cl';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_attribute_cl`
--

LOCK TABLES `[[dbprefix]]catalog_product_attribute_cl` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_attribute_cl` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_product_attribute_cl` VALUES (1,1),(2,1),(3,1),(4,1),(5,1),(6,1),(7,1),(8,1),(9,2),(10,2),(11,2),(12,2),(13,2),(14,2),(15,2),(16,2),(17,2),(18,2),(19,2),(20,2),(21,2),(22,2),(23,3),(24,3),(25,3),(26,3),(27,3),(28,3),(29,3),(30,3),(31,3),(32,3),(33,3),(34,4),(35,4),(36,4),(37,4),(38,4),(39,4),(40,4),(41,4),(42,4),(43,4),(44,4),(45,4),(46,5),(47,5),(48,5),(49,5),(50,5),(51,5),(52,5),(53,5),(54,5),(55,5),(56,5),(57,5),(58,6),(59,6),(60,6),(61,6),(62,6),(63,6),(64,6),(65,6),(66,6),(67,6),(68,6),(69,7),(70,7),(71,7),(72,7),(73,7),(74,7),(75,7),(76,7),(77,7),(78,7),(79,7),(80,8),(81,8),(82,8),(83,8),(84,8),(85,8),(86,8),(87,8),(88,8),(89,8),(90,8),(91,9),(92,9),(93,9),(94,9),(95,9),(96,9),(97,9),(98,9),(99,9),(100,9),(101,9),(102,10),(103,10),(104,10),(105,10),(106,10),(107,10),(108,10),(109,10),(110,10),(111,10),(112,10),(113,10),(114,10),(115,10),(116,11),(117,11),(118,11),(119,11),(120,11),(121,11),(122,11),(123,11),(124,11),(125,11),(126,11),(127,11),(128,11),(129,11),(130,12),(131,12),(132,12),(133,12),(134,12),(135,12),(136,12),(137,12),(138,12),(139,12),(140,12),(141,13),(142,13),(143,13),(144,13),(145,13),(146,13),(147,13),(148,13),(149,13),(150,13),(151,13),(152,13),(153,14),(154,14),(155,14),(156,14),(157,14),(158,14),(159,14),(160,14),(161,14),(162,14),(163,14),(164,14),(165,15),(166,15),(167,15),(168,15),(169,15),(170,15),(171,15),(172,15),(173,16),(174,16),(175,16),(176,16),(177,16),(178,16),(179,16),(180,16),(181,16),(182,16),(183,16),(184,16),(185,16),(186,16),(187,17),(188,17),(189,17),(190,17),(191,17),(192,17),(193,17),(194,17),(195,17),(196,17),(197,17),(198,18),(199,18),(200,18),(201,18),(202,18),(203,18),(204,18),(205,18),(206,18),(207,18),(208,18),(209,19),(210,19),(211,19),(212,19),(213,19),(214,19),(215,19),(216,19),(217,19),(218,19),(219,19),(220,19),(221,19),(222,20),(223,20),(224,20),(225,20),(226,20),(227,20),(228,20),(229,20),(230,20),(231,20),(232,20),(233,21),(234,21),(235,21),(236,21),(237,21),(238,21),(239,21),(240,21),(241,21),(242,21),(243,21),(244,22),(245,22),(246,22),(247,22),(248,22),(249,22),(250,22),(251,22),(252,22),(253,22),(254,22),(255,23),(256,23),(257,23),(258,23),(259,23),(260,23),(261,23),(262,23),(263,23),(264,23),(265,23),(266,24),(267,24),(268,24),(269,24),(270,24),(271,24),(272,24),(273,24),(274,24),(275,24),(276,25),(277,25),(278,25),(279,25),(280,25),(281,25),(282,25),(283,25),(284,25),(285,25),(286,25),(287,25),(288,25),(289,26),(290,26),(291,26),(292,26),(293,26),(294,26),(295,26),(296,26),(297,26),(298,26),(299,26),(300,26),(301,26),(302,27),(303,27),(304,27),(305,27),(306,27),(307,27),(308,27),(309,27),(310,27),(311,27),(312,27),(313,27),(314,27),(315,28),(316,28),(317,28),(318,28),(319,28),(320,28),(321,28),(322,28),(323,28),(324,28),(325,28),(326,28),(327,28),(328,29),(329,29),(330,29),(331,29),(332,29),(333,29),(334,29),(335,29),(336,29),(337,29),(338,29),(339,29),(340,29),(341,30),(342,30),(343,30),(344,30),(345,30),(346,30),(347,30),(348,30),(349,30),(350,30),(351,30),(352,30),(353,30),(354,31),(355,31),(356,31),(357,31),(358,31),(359,31),(360,31),(361,31),(362,31),(363,31),(364,31),(365,31),(366,31),(367,32),(368,32),(369,32),(370,32),(371,32),(372,32),(373,32),(374,32),(375,32),(376,32),(377,32),(378,32),(379,32),(380,33),(381,33),(382,33),(383,33),(384,33),(385,33),(386,33),(387,33),(388,33),(389,34),(390,34),(391,34),(392,34),(393,34),(394,34),(395,34),(396,34),(397,34),(398,34),(399,34),(400,34),(401,35),(402,35),(403,35),(404,35),(405,35),(406,35),(407,35),(408,35),(409,35),(410,35),(411,35),(412,35),(413,36),(414,36),(415,36),(416,36),(417,36),(418,36),(419,36),(420,36),(421,36),(422,36),(423,36),(424,37),(425,37),(426,37),(427,37),(428,37),(429,37),(430,37),(431,37),(432,37),(433,37),(434,37),(435,38),(436,38),(437,38),(438,38),(439,38),(440,38),(441,38),(442,38),(443,38),(444,38),(445,38),(446,38),(447,39),(448,39),(449,39),(450,39),(451,39),(452,39),(453,39),(454,39),(455,39),(456,39),(457,39),(458,39),(459,40),(460,40),(461,40),(462,40),(463,40),(464,40),(465,40),(466,40),(467,40),(468,40),(469,40),(470,40),(471,41),(472,41),(473,41),(474,41),(475,41),(476,41),(477,41),(478,41),(479,41),(480,41),(481,41),(482,41),(483,41),(484,42),(485,42),(486,42),(487,42),(488,42),(489,42),(490,42),(491,42),(492,42),(493,42),(494,42),(495,42),(496,42),(497,43),(498,43),(499,43),(500,43),(501,43),(502,43),(503,43),(504,43),(505,43),(506,43),(507,43),(508,44),(509,44),(510,44),(511,44),(512,44),(513,44),(514,44),(515,44),(516,44),(517,44),(518,44),(519,44),(520,45),(521,45),(522,45),(523,45),(524,45),(525,45),(526,45),(527,45),(528,45),(529,45),(530,45),(531,45),(532,45),(533,45),(534,45),(535,46),(536,46),(537,46),(538,46),(539,46),(540,46),(541,46),(542,46),(543,46),(544,46),(545,46),(546,47),(547,47),(548,47),(549,47),(550,47),(551,47),(552,47),(553,48),(554,48),(555,48),(556,48),(557,48),(558,48),(559,48),(560,49),(561,49),(562,49),(563,49),(564,49),(565,49),(566,49),(567,50),(568,50),(569,50),(570,50),(571,50),(572,50),(573,50),(574,51),(575,51),(576,51),(577,51),(578,51),(579,51),(580,51),(581,52),(582,52),(583,52),(584,52),(585,52),(586,52),(587,52),(588,53),(589,53),(590,53),(591,53),(592,53),(593,53),(594,53),(595,54),(596,54),(597,54),(598,54),(599,54),(600,54),(601,54),(602,55),(603,55),(604,55),(605,55),(606,55),(607,55),(608,55),(609,56),(610,56),(611,56),(612,56),(613,56),(614,56),(615,56),(616,57),(617,57),(618,57),(619,57),(620,57),(621,57),(622,57),(623,58),(624,58),(625,58),(626,58),(627,58),(628,58),(629,58),(630,59),(631,59),(632,59),(633,59),(634,59),(635,59),(636,59),(637,60),(638,60),(639,60),(640,60),(641,60),(642,60),(643,60),(644,61),(645,61),(646,61),(647,61),(648,61),(649,61),(650,61),(651,62),(652,62),(653,62),(654,62),(655,62),(656,62),(657,62),(658,63),(659,63),(660,63),(661,63),(662,63),(663,63),(664,63),(665,64),(666,64),(667,64),(668,64),(669,64),(670,64),(671,64),(672,65),(673,65),(674,65),(675,65),(676,65),(677,65),(678,65),(679,66),(680,66),(681,66),(682,66),(683,66),(684,66),(685,66),(686,67),(687,67),(688,67),(689,67),(690,67),(691,67),(692,67),(693,68),(694,68),(695,68),(696,68),(697,68),(698,68),(699,68),(700,69),(701,69),(702,69),(703,69),(704,69),(705,69),(706,69),(707,70),(708,70),(709,70),(710,70),(711,70),(712,70),(713,70),(714,71),(715,71),(716,71),(717,71),(718,71),(719,71),(720,71),(721,72),(722,72),(723,72),(724,72),(725,72),(726,72),(727,72),(728,73),(729,73),(730,73),(731,73),(732,73),(733,73),(734,73),(735,74),(736,74),(737,74),(738,74),(739,74),(740,74),(741,74),(742,75),(743,75),(744,75),(745,75),(746,75),(747,75),(748,75),(749,76),(750,76),(751,76),(752,76),(753,76),(754,76),(755,76),(756,77),(757,77),(758,77),(759,77),(760,77),(761,77),(762,77),(763,78),(764,78),(765,78),(766,78),(767,78),(768,78),(769,78),(770,79),(771,79),(772,79),(773,79),(774,79),(775,79),(776,79),(777,80),(778,80),(779,80),(780,80),(781,80),(782,80),(783,80),(784,81),(785,81),(786,81),(787,81),(788,81),(789,81),(790,81),(791,82),(792,82),(793,82),(794,82),(795,82),(796,82),(797,82),(798,83),(799,83),(800,83),(801,83),(802,83),(803,83),(804,83),(805,84),(806,84),(807,84),(808,84),(809,84),(810,84),(811,84),(812,85),(813,85),(814,85),(815,85),(816,85),(817,85),(818,85),(819,86),(820,86),(821,86),(822,86),(823,86),(824,86),(825,86),(826,87),(827,87),(828,87),(829,87),(830,87),(831,87),(832,87),(833,88),(834,88),(835,88),(836,88),(837,88),(838,88),(839,88),(840,89),(841,89),(842,89),(843,89),(844,89),(845,89),(846,89),(847,90),(848,90),(849,90),(850,90),(851,90),(852,90),(853,90),(854,91),(855,91),(856,91),(857,91),(858,91),(859,91),(860,91),(861,92),(862,92),(863,92),(864,92),(865,92),(866,92),(867,92),(868,93),(869,93),(870,93),(871,93),(872,93),(873,93),(874,93),(875,94),(876,94),(877,94),(878,94),(879,94),(880,94),(881,94),(882,95),(883,95),(884,95),(885,95),(886,95),(887,95),(888,95),(889,96),(890,96),(891,96),(892,96),(893,96),(894,96),(895,96),(896,97),(897,97),(898,97),(899,97),(900,97),(901,97),(902,97),(903,98),(904,98),(905,98),(906,98),(907,98),(908,98),(909,98),(910,99),(911,99),(912,99),(913,99),(914,99),(915,99),(916,99),(917,100),(918,100),(919,100),(920,100),(921,100),(922,100),(923,100),(924,101),(925,101),(926,101),(927,101),(928,101),(929,101),(930,101),(931,102),(932,102),(933,102),(934,102),(935,102),(936,102),(937,102),(938,103),(939,103),(940,103),(941,103),(942,103),(943,103),(944,103),(945,104),(946,104),(947,104),(948,104),(949,104),(950,104),(951,104),(952,105),(953,105),(954,105),(955,105),(956,105),(957,105),(958,105),(959,106),(960,106),(961,106),(962,106),(963,106),(964,106),(965,106),(966,107),(967,107),(968,107),(969,107),(970,107),(971,107),(972,107),(973,108),(974,108),(975,108),(976,108),(977,108),(978,108),(979,108),(980,109),(981,109),(982,109),(983,109),(984,109),(985,109),(986,109),(987,110),(988,110),(989,110),(990,110),(991,110),(992,110),(993,110),(994,111),(995,111),(996,111),(997,111),(998,111),(999,111),(1000,111),(1001,112),(1002,112),(1003,112),(1004,112),(1005,112),(1006,112),(1007,112),(1008,113),(1009,113),(1010,113),(1011,113),(1012,113),(1013,113),(1014,113),(1015,114),(1016,114),(1017,114),(1018,114),(1019,114),(1020,114),(1021,114),(1022,115),(1023,115),(1024,115),(1025,115),(1026,115),(1027,115),(1028,115),(1029,116),(1030,116),(1031,116),(1032,116),(1033,116),(1034,116),(1035,116),(1036,117),(1037,117),(1038,117),(1039,117),(1040,117),(1041,117),(1042,117),(1043,118),(1044,118),(1045,118),(1046,118),(1047,118),(1048,118),(1049,118),(1050,119),(1051,119),(1052,119),(1053,119),(1054,119),(1055,119),(1056,119),(1057,120),(1058,120),(1059,120),(1060,120),(1061,120),(1062,120),(1063,120),(1064,121),(1065,121),(1066,121),(1067,121),(1068,121),(1069,121),(1070,121),(1071,122),(1072,122),(1073,122),(1074,122),(1075,122),(1076,122),(1077,122),(1078,123),(1079,123),(1080,123),(1081,123),(1082,123),(1083,123),(1084,123),(1085,124),(1086,124),(1087,124),(1088,124),(1089,124),(1090,124),(1091,124),(1092,125),(1093,125),(1094,125),(1095,125),(1096,125),(1097,125),(1098,125),(1099,126),(1100,126),(1101,126),(1102,126),(1103,126),(1104,126),(1105,126),(1106,127),(1107,127),(1108,127),(1109,127),(1110,127),(1111,127),(1112,127),(1113,128),(1114,128),(1115,128),(1116,128),(1117,128),(1118,128),(1119,128),(1120,129),(1121,129),(1122,129),(1123,129),(1124,129),(1125,129),(1126,129),(1127,130),(1128,130),(1129,130),(1130,130),(1131,130),(1132,130),(1133,130),(1134,131),(1135,131),(1136,131),(1137,131),(1138,131),(1139,131),(1140,131),(1141,132),(1142,132),(1143,132),(1144,132),(1145,132),(1146,132),(1147,132),(1148,133),(1149,133),(1150,133),(1151,133),(1152,133),(1153,133),(1154,133),(1155,134),(1156,134),(1157,134),(1158,134),(1159,134),(1160,134),(1161,134),(1162,135),(1163,135),(1164,135),(1165,135),(1166,135),(1167,135),(1168,135),(1169,136),(1170,136),(1171,136),(1172,136),(1173,136),(1174,136),(1175,136),(1176,137),(1177,137),(1178,137),(1179,137),(1180,137),(1181,137),(1182,137),(1183,138),(1184,138),(1185,138),(1186,138),(1187,138),(1188,138),(1189,138),(1190,139),(1191,139),(1192,139),(1193,139),(1194,139),(1195,139),(1196,139),(1197,140),(1198,140),(1199,140),(1200,140),(1201,140),(1202,140),(1203,140),(1204,141),(1205,141),(1206,141),(1207,141),(1208,141),(1209,141),(1210,141),(1211,142),(1212,142),(1213,142),(1214,142),(1215,142),(1216,142),(1217,142),(1218,143),(1219,143),(1220,143),(1221,143),(1222,143),(1223,143),(1224,143),(1225,144),(1226,144),(1227,144),(1228,144),(1229,144),(1230,144),(1231,144),(1232,145),(1233,145),(1234,145),(1235,145),(1236,145),(1237,145),(1238,145),(1239,146),(1240,146),(1241,146),(1242,146),(1243,146),(1244,146),(1245,146),(1246,47),(1247,47),(1248,47),(1249,47),(1250,47),(1251,47),(1252,48),(1253,48),(1254,48),(1255,48),(1256,48),(1257,48),(1258,49),(1259,49),(1260,49),(1261,49),(1262,49),(1263,49),(1264,50),(1265,50),(1266,50),(1267,50),(1268,50),(1269,50),(1270,51),(1271,51),(1272,51),(1273,51),(1274,51),(1275,51),(1276,52),(1277,52),(1278,52),(1279,52),(1280,52),(1281,52),(1282,53),(1283,53),(1284,53),(1285,53),(1286,53),(1287,53),(1288,54),(1289,54),(1290,54),(1291,54),(1292,54),(1293,54),(1294,55),(1295,55),(1296,55),(1297,55),(1298,55),(1299,55),(1300,56),(1301,56),(1302,56),(1303,56),(1304,56),(1305,56),(1306,57),(1307,57),(1308,57),(1309,57),(1310,57),(1311,57),(1312,58),(1313,58),(1314,58),(1315,58),(1316,58),(1317,58),(1318,59),(1319,59),(1320,59),(1321,59),(1322,59),(1323,59),(1324,60),(1325,60),(1326,60),(1327,60),(1328,60),(1329,60),(1330,61),(1331,61),(1332,61),(1333,61),(1334,61),(1335,61),(1336,62),(1337,62),(1338,62),(1339,62),(1340,62),(1341,62),(1342,62),(1343,62),(1344,62),(1345,63),(1346,63),(1347,63),(1348,63),(1349,63),(1350,63),(1351,64),(1352,64),(1353,64),(1354,64),(1355,64),(1356,64),(1357,65),(1358,65),(1359,65),(1360,65),(1361,65),(1362,65),(1363,66),(1364,66),(1365,66),(1366,66),(1367,66),(1368,66),(1369,67),(1370,67),(1371,67),(1372,67),(1373,67),(1374,67),(1375,68),(1376,68),(1377,68),(1378,68),(1379,68),(1380,68),(1381,69),(1382,69),(1383,69),(1384,69),(1385,69),(1386,69),(1387,70),(1388,70),(1389,70),(1390,70),(1391,70),(1392,70),(1393,71),(1394,71),(1395,71),(1396,71),(1397,71),(1398,71),(1399,72),(1400,72),(1401,72),(1402,72),(1403,72),(1404,72),(1405,73),(1406,73),(1407,73),(1408,73),(1409,73),(1410,73),(1411,74),(1412,74),(1413,74),(1414,74),(1415,74),(1416,74),(1417,75),(1418,75),(1419,75),(1420,75),(1421,75),(1422,75),(1423,76),(1424,76),(1425,76),(1426,76),(1427,76),(1428,76),(1429,77),(1430,77),(1431,77),(1432,77),(1433,77),(1434,77),(1435,78),(1436,78),(1437,78),(1438,78),(1439,78),(1440,78),(1441,78),(1442,78),(1443,78),(1444,79),(1445,79),(1446,79),(1447,79),(1448,79),(1449,79),(1450,80),(1451,80),(1452,80),(1453,80),(1454,80),(1455,80),(1456,81),(1457,81),(1458,81),(1459,81),(1460,81),(1461,81),(1462,82),(1463,82),(1464,82),(1465,82),(1466,82),(1467,82),(1468,83),(1469,83),(1470,83),(1471,83),(1472,83),(1473,83),(1474,84),(1475,84),(1476,84),(1477,84),(1478,84),(1479,84),(1480,85),(1481,85),(1482,85),(1483,85),(1484,85),(1485,85),(1486,86),(1487,86),(1488,86),(1489,86),(1490,86),(1491,86),(1492,87),(1493,87),(1494,87),(1495,87),(1496,87),(1497,87),(1498,88),(1499,88),(1500,88),(1501,88),(1502,88),(1503,88),(1504,89),(1505,89),(1506,89),(1507,89),(1508,89),(1509,89),(1510,90),(1511,90),(1512,90),(1513,90),(1514,90),(1515,90),(1516,91),(1517,91),(1518,91),(1519,91),(1520,91),(1521,91),(1522,92),(1523,92),(1524,92),(1525,92),(1526,92),(1527,92),(1528,93),(1529,93),(1530,93),(1531,93),(1532,93),(1533,93),(1534,94),(1535,94),(1536,94),(1537,94),(1538,94),(1539,94),(1540,94),(1541,94),(1542,94),(1543,95),(1544,95),(1545,95),(1546,95),(1547,95),(1548,95),(1549,96),(1550,96),(1551,96),(1552,96),(1553,96),(1554,96),(1555,97),(1556,97),(1557,97),(1558,97),(1559,97),(1560,97),(1561,98),(1562,98),(1563,98),(1564,98),(1565,98),(1566,98),(1567,99),(1568,99),(1569,99),(1570,99),(1571,99),(1572,99),(1573,100),(1574,100),(1575,100),(1576,100),(1577,100),(1578,100),(1579,101),(1580,101),(1581,101),(1582,101),(1583,101),(1584,101),(1585,102),(1586,102),(1587,102),(1588,102),(1589,102),(1590,102),(1591,103),(1592,103),(1593,103),(1594,103),(1595,103),(1596,103),(1597,104),(1598,104),(1599,104),(1600,104),(1601,104),(1602,104),(1603,105),(1604,105),(1605,105),(1606,105),(1607,105),(1608,105),(1609,106),(1610,106),(1611,106),(1612,106),(1613,106),(1614,106),(1615,107),(1616,107),(1617,107),(1618,107),(1619,107),(1620,107),(1621,108),(1622,108),(1623,108),(1624,108),(1625,108),(1626,108),(1627,109),(1628,109),(1629,109),(1630,109),(1631,109),(1632,109),(1633,110),(1634,110),(1635,110),(1636,110),(1637,110),(1638,110),(1639,110),(1640,110),(1641,110),(1642,111),(1643,111),(1644,111),(1645,111),(1646,111),(1647,111),(1648,112),(1649,112),(1650,112),(1651,112),(1652,112),(1653,112),(1654,113),(1655,113),(1656,113),(1657,113),(1658,113),(1659,113),(1660,114),(1661,114),(1662,114),(1663,114),(1664,114),(1665,114),(1666,115),(1667,115),(1668,115),(1669,115),(1670,115),(1671,115),(1672,116),(1673,116),(1674,116),(1675,116),(1676,116),(1677,116),(1678,117),(1679,117),(1680,117),(1681,117),(1682,117),(1683,117),(1684,118),(1685,118),(1686,118),(1687,118),(1688,118),(1689,118),(1690,119),(1691,119),(1692,119),(1693,119),(1694,119),(1695,119),(1696,120),(1697,120),(1698,120),(1699,120),(1700,120),(1701,120),(1702,121),(1703,121),(1704,121),(1705,121),(1706,121),(1707,121),(1708,122),(1709,122),(1710,122),(1711,122),(1712,122),(1713,122),(1714,123),(1715,123),(1716,123),(1717,123),(1718,123),(1719,123),(1720,124),(1721,124),(1722,124),(1723,124),(1724,124),(1725,124),(1726,125),(1727,125),(1728,125),(1729,125),(1730,125),(1731,125),(1732,126),(1733,126),(1734,126),(1735,126),(1736,126),(1737,126),(1738,126),(1739,126),(1740,126),(1741,127),(1742,127),(1743,127),(1744,127),(1745,127),(1746,127),(1747,128),(1748,128),(1749,128),(1750,128),(1751,128),(1752,128),(1753,129),(1754,129),(1755,129),(1756,129),(1757,129),(1758,129),(1759,130),(1760,130),(1761,130),(1762,130),(1763,130),(1764,130),(1765,131),(1766,131),(1767,131),(1768,131),(1769,131),(1770,131),(1771,132),(1772,132),(1773,132),(1774,132),(1775,132),(1776,132),(1777,133),(1778,133),(1779,133),(1780,133),(1781,133),(1782,133),(1783,134),(1784,134),(1785,134),(1786,134),(1787,134),(1788,134),(1789,135),(1790,135),(1791,135),(1792,135),(1793,135),(1794,135),(1795,136),(1796,136),(1797,136),(1798,136),(1799,136),(1800,136),(1801,137),(1802,137),(1803,137),(1804,137),(1805,137),(1806,137),(1807,138),(1808,138),(1809,138),(1810,138),(1811,138),(1812,138),(1813,139),(1814,139),(1815,139),(1816,139),(1817,139),(1818,139),(1819,140),(1820,140),(1821,140),(1822,140),(1823,140),(1824,140),(1825,141),(1826,141),(1827,141),(1828,141),(1829,141),(1830,141),(1831,142),(1832,142),(1833,142),(1834,142),(1835,142),(1836,142),(1837,142),(1838,142),(1839,142),(1840,143),(1841,143),(1842,143),(1843,143),(1844,143),(1845,143),(1846,144),(1847,144),(1848,144),(1849,144),(1850,144),(1851,144),(1852,145),(1853,145),(1854,145),(1855,145),(1856,145),(1857,145),(1858,146),(1859,146),(1860,146),(1861,146),(1862,146),(1863,146),(1864,47),(1865,47),(1866,48),(1867,48),(1868,49),(1869,49),(1870,50),(1871,50),(1872,51),(1873,51),(1874,52),(1875,52),(1876,53),(1877,53),(1878,54),(1879,54),(1880,55),(1881,55),(1882,56),(1883,56),(1884,57),(1885,57),(1886,58),(1887,58),(1888,59),(1889,59),(1890,60),(1891,60),(1892,61),(1893,61),(1894,62),(1895,63),(1896,63),(1897,64),(1898,64),(1899,65),(1900,65),(1901,66),(1902,66),(1903,67),(1904,67),(1905,68),(1906,68),(1907,69),(1908,69),(1909,70),(1910,70),(1911,71),(1912,71),(1913,72),(1914,72),(1915,73),(1916,73),(1917,74),(1918,74),(1919,75),(1920,75),(1921,76),(1922,76),(1923,77),(1924,77),(1925,78),(1926,79),(1927,79),(1928,80),(1929,80),(1930,81),(1931,81),(1932,82),(1933,82),(1934,83),(1935,83),(1936,84),(1937,84),(1938,85),(1939,85),(1940,86),(1941,86),(1942,87),(1943,87),(1944,88),(1945,88),(1946,89),(1947,89),(1948,90),(1949,90),(1950,91),(1951,91),(1952,92),(1953,92),(1954,93),(1955,93),(1956,94),(1957,95),(1958,95),(1959,96),(1960,96),(1961,97),(1962,97),(1963,98),(1964,98),(1965,99),(1966,99),(1967,100),(1968,100),(1969,101),(1970,101),(1971,102),(1972,102),(1973,103),(1974,103),(1975,104),(1976,104),(1977,105),(1978,105),(1979,106),(1980,106),(1981,107),(1982,107),(1983,108),(1984,108),(1985,109),(1986,109),(1987,110),(1988,111),(1989,111),(1990,112),(1991,112),(1992,113),(1993,113),(1994,114),(1995,114),(1996,115),(1997,115),(1998,116),(1999,116),(2000,117),(2001,117),(2002,118),(2003,118),(2004,119),(2005,119),(2006,120),(2007,120),(2008,121),(2009,121),(2010,122),(2011,122),(2012,123),(2013,123),(2014,124),(2015,124),(2016,125),(2017,125),(2018,126),(2019,127),(2020,127),(2021,128),(2022,128),(2023,129),(2024,129),(2025,130),(2026,130),(2027,131),(2028,131),(2029,132),(2030,132),(2031,133),(2032,133),(2033,134),(2034,134),(2035,135),(2036,135),(2037,136),(2038,136),(2039,137),(2040,137),(2041,138),(2042,138),(2043,139),(2044,139),(2045,140),(2046,140),(2047,141),(2048,141),(2049,142),(2050,143),(2051,143),(2052,144),(2053,144),(2054,145),(2055,145),(2056,146),(2057,146),(2058,147),(2059,147),(2060,147),(2061,147),(2062,147),(2063,147),(2064,147),(2065,148),(2066,148),(2067,148),(2068,148),(2069,148),(2070,148),(2071,148),(2072,149),(2073,149),(2074,149),(2075,149),(2076,149),(2077,149),(2078,149),(2079,150),(2080,150),(2081,150),(2082,150),(2083,150),(2084,150),(2085,150),(2086,151),(2087,151),(2088,151),(2089,151),(2090,151),(2091,151),(2092,151),(2093,152),(2094,152),(2095,152),(2096,152),(2097,152),(2098,152),(2099,152),(2100,153),(2101,153),(2102,153),(2103,153),(2104,153),(2105,153),(2106,153),(2107,154),(2108,154),(2109,154),(2110,154),(2111,154),(2112,154),(2113,154),(2114,155),(2115,155),(2116,155),(2117,155),(2118,155),(2119,155),(2120,155),(2121,156),(2122,156),(2123,156),(2124,156),(2125,156),(2126,156),(2127,156),(2128,157),(2129,157),(2130,157),(2131,157),(2132,157),(2133,157),(2134,157),(2135,158),(2136,158),(2137,158),(2138,158),(2139,158),(2140,158),(2141,158),(2142,159),(2143,159),(2144,159),(2145,159),(2146,159),(2147,159),(2148,159),(2149,160),(2150,160),(2151,160),(2152,160),(2153,160),(2154,160),(2155,160),(2156,161),(2157,161),(2158,161),(2159,161),(2160,161),(2161,161),(2162,161),(2163,162),(2164,162),(2165,162),(2166,162),(2167,162),(2168,162),(2169,162),(2170,163),(2171,163),(2172,163),(2173,163),(2174,163),(2175,163),(2176,163),(2177,164),(2178,164),(2179,164),(2180,164),(2181,164),(2182,164),(2183,164),(2184,165),(2185,165),(2186,165),(2187,165),(2188,165),(2189,165),(2190,165),(2191,166),(2192,166),(2193,166),(2194,166),(2195,166),(2196,166),(2197,166),(2198,167),(2199,167),(2200,167),(2201,167),(2202,167),(2203,167),(2204,167),(2205,168),(2206,168),(2207,168),(2208,168),(2209,168),(2210,168),(2211,168),(2212,169),(2213,169),(2214,169),(2215,169),(2216,169),(2217,169),(2218,169),(2219,170),(2220,170),(2221,170),(2222,170),(2223,170),(2224,170),(2225,170),(2226,171),(2227,171),(2228,171),(2229,171),(2230,171),(2231,171),(2232,171),(2233,172),(2234,172),(2235,172),(2236,172),(2237,172),(2238,172),(2239,172),(2240,173),(2241,173),(2242,173),(2243,173),(2244,173),(2245,173),(2246,173),(2247,174),(2248,174),(2249,174),(2250,174),(2251,174),(2252,174),(2253,174),(2254,175),(2255,175),(2256,175),(2257,175),(2258,175),(2259,175),(2260,175),(2261,176),(2262,176),(2263,176),(2264,176),(2265,176),(2266,176),(2267,176),(2268,177),(2269,177),(2270,177),(2271,177),(2272,177),(2273,177),(2274,177),(2275,178),(2276,178),(2277,178),(2278,178),(2279,178),(2280,178),(2281,178),(2282,179),(2283,179),(2284,179),(2285,179),(2286,179),(2287,179),(2288,179),(2289,180),(2290,180),(2291,180),(2292,180),(2293,180),(2294,180),(2295,180),(2296,181),(2297,181),(2298,181),(2299,181),(2300,181),(2301,181),(2302,181),(2303,182),(2304,182),(2305,182),(2306,182),(2307,182),(2308,182),(2309,182),(2310,183),(2311,183),(2312,183),(2313,183),(2314,183),(2315,183),(2316,183),(2317,184),(2318,184),(2319,184),(2320,184),(2321,184),(2322,184),(2323,184),(2324,185),(2325,185),(2326,185),(2327,185),(2328,185),(2329,185),(2330,185),(2331,186),(2332,186),(2333,186),(2334,186),(2335,186),(2336,186),(2337,186),(2338,187),(2339,187),(2340,187),(2341,187),(2342,187),(2343,187),(2344,187),(2345,188),(2346,188),(2347,188),(2348,188),(2349,188),(2350,188),(2351,188),(2352,189),(2353,189),(2354,189),(2355,189),(2356,189),(2357,189),(2358,189),(2359,190),(2360,190),(2361,190),(2362,190),(2363,190),(2364,190),(2365,190),(2366,191),(2367,191),(2368,191),(2369,191),(2370,191),(2371,191),(2372,191),(2373,192),(2374,192),(2375,192),(2376,192),(2377,192),(2378,192),(2379,192),(2380,193),(2381,193),(2382,193),(2383,193),(2384,193),(2385,193),(2386,193),(2387,194),(2388,194),(2389,194),(2390,194),(2391,194),(2392,194),(2393,194),(2394,195),(2395,195),(2396,195),(2397,195),(2398,195),(2399,195),(2400,195),(2401,196),(2402,196),(2403,196),(2404,196),(2405,196),(2406,196),(2407,196),(2408,197),(2409,197),(2410,197),(2411,197),(2412,197),(2413,197),(2414,197),(2415,198),(2416,198),(2417,198),(2418,198),(2419,198),(2420,198),(2421,198),(2422,199),(2423,199),(2424,199),(2425,199),(2426,199),(2427,199),(2428,199),(2429,200),(2430,200),(2431,200),(2432,200),(2433,200),(2434,200),(2435,200),(2436,201),(2437,201),(2438,201),(2439,201),(2440,201),(2441,201),(2442,201),(2443,202),(2444,202),(2445,202),(2446,202),(2447,202),(2448,202),(2449,202),(2450,203),(2451,203),(2452,203),(2453,203),(2454,203),(2455,203),(2456,203),(2457,204),(2458,204),(2459,204),(2460,204),(2461,204),(2462,204),(2463,204),(2464,205),(2465,205),(2466,205),(2467,205),(2468,205),(2469,205),(2470,205),(2471,206),(2472,206),(2473,206),(2474,206),(2475,206),(2476,206),(2477,206),(2478,207),(2479,207),(2480,207),(2481,207),(2482,207),(2483,207),(2484,207),(2485,208),(2486,208),(2487,208),(2488,208),(2489,208),(2490,208),(2491,208),(2492,209),(2493,209),(2494,209),(2495,209),(2496,209),(2497,209),(2498,209),(2499,210),(2500,210),(2501,210),(2502,210),(2503,210),(2504,210),(2505,210),(2506,211),(2507,211),(2508,211),(2509,211),(2510,211),(2511,211),(2512,211),(2513,212),(2514,212),(2515,212),(2516,212),(2517,212),(2518,212),(2519,212),(2520,213),(2521,213),(2522,213),(2523,213),(2524,213),(2525,213),(2526,213),(2527,214),(2528,214),(2529,214),(2530,214),(2531,214),(2532,214),(2533,214),(2534,215),(2535,215),(2536,215),(2537,215),(2538,215),(2539,215),(2540,215),(2541,216),(2542,216),(2543,216),(2544,216),(2545,216),(2546,216),(2547,216),(2548,217),(2549,217),(2550,217),(2551,217),(2552,217),(2553,217),(2554,217),(2555,218),(2556,218),(2557,218),(2558,218),(2559,218),(2560,218),(2561,218),(2562,219),(2563,219),(2564,219),(2565,219),(2566,219),(2567,219),(2568,219),(2569,220),(2570,220),(2571,220),(2572,220),(2573,220),(2574,220),(2575,220),(2576,221),(2577,221),(2578,221),(2579,221),(2580,221),(2581,221),(2582,221),(2583,222),(2584,222),(2585,222),(2586,222),(2587,222),(2588,222),(2589,222),(2590,223),(2591,223),(2592,223),(2593,223),(2594,223),(2595,223),(2596,223),(2597,224),(2598,224),(2599,224),(2600,224),(2601,224),(2602,224),(2603,224),(2604,225),(2605,225),(2606,225),(2607,225),(2608,225),(2609,225),(2610,225),(2611,226),(2612,226),(2613,226),(2614,226),(2615,226),(2616,226),(2617,226),(2618,227),(2619,227),(2620,227),(2621,227),(2622,227),(2623,227),(2624,227),(2625,228),(2626,228),(2627,228),(2628,228),(2629,228),(2630,228),(2631,228),(2632,229),(2633,229),(2634,229),(2635,229),(2636,229),(2637,229),(2638,229),(2639,230),(2640,230),(2641,230),(2642,230),(2643,230),(2644,230),(2645,230),(2646,231),(2647,231),(2648,231),(2649,231),(2650,231),(2651,231),(2652,231),(2653,232),(2654,232),(2655,232),(2656,232),(2657,232),(2658,232),(2659,232),(2660,233),(2661,233),(2662,233),(2663,233),(2664,233),(2665,233),(2666,233),(2667,234),(2668,234),(2669,234),(2670,234),(2671,234),(2672,234),(2673,234),(2674,235),(2675,235),(2676,235),(2677,235),(2678,235),(2679,235),(2680,235),(2681,236),(2682,236),(2683,236),(2684,236),(2685,236),(2686,236),(2687,236),(2688,237),(2689,237),(2690,237),(2691,237),(2692,237),(2693,237),(2694,237),(2695,238),(2696,238),(2697,238),(2698,238),(2699,238),(2700,238),(2701,238),(2702,239),(2703,239),(2704,239),(2705,239),(2706,239),(2707,239),(2708,239),(2709,240),(2710,240),(2711,240),(2712,240),(2713,240),(2714,240),(2715,240),(2716,241),(2717,241),(2718,241),(2719,241),(2720,241),(2721,241),(2722,241),(2723,242),(2724,242),(2725,242),(2726,242),(2727,242),(2728,242),(2729,242),(2730,243),(2731,243),(2732,243),(2733,243),(2734,243),(2735,243),(2736,243),(2737,244),(2738,244),(2739,244),(2740,244),(2741,244),(2742,244),(2743,244),(2744,245),(2745,245),(2746,245),(2747,245),(2748,245),(2749,245),(2750,245),(2751,246),(2752,246),(2753,246),(2754,246),(2755,246),(2756,246),(2757,246),(2758,147),(2759,147),(2760,147),(2761,147),(2762,147),(2763,147),(2764,148),(2765,148),(2766,148),(2767,148),(2768,148),(2769,148),(2770,149),(2771,149),(2772,149),(2773,149),(2774,149),(2775,149),(2776,150),(2777,150),(2778,150),(2779,150),(2780,150),(2781,150),(2782,151),(2783,151),(2784,151),(2785,151),(2786,151),(2787,151),(2788,152),(2789,152),(2790,152),(2791,152),(2792,152),(2793,152),(2794,153),(2795,153),(2796,153),(2797,153),(2798,153),(2799,153),(2800,154),(2801,154),(2802,154),(2803,154),(2804,154),(2805,154),(2806,155),(2807,155),(2808,155),(2809,155),(2810,155),(2811,155),(2812,156),(2813,156),(2814,156),(2815,156),(2816,156),(2817,156),(2818,157),(2819,157),(2820,157),(2821,157),(2822,157),(2823,157),(2824,158),(2825,158),(2826,158),(2827,158),(2828,158),(2829,158),(2830,158),(2831,158),(2832,158),(2833,159),(2834,159),(2835,159),(2836,159),(2837,159),(2838,159),(2839,160),(2840,160),(2841,160),(2842,160),(2843,160),(2844,160),(2845,161),(2846,161),(2847,161),(2848,161),(2849,161),(2850,161),(2851,162),(2852,162),(2853,162),(2854,162),(2855,162),(2856,162),(2857,163),(2858,163),(2859,163),(2860,163),(2861,163),(2862,163),(2863,164),(2864,164),(2865,164),(2866,164),(2867,164),(2868,164),(2869,165),(2870,165),(2871,165),(2872,165),(2873,165),(2874,165),(2875,166),(2876,166),(2877,166),(2878,166),(2879,166),(2880,166),(2881,167),(2882,167),(2883,167),(2884,167),(2885,167),(2886,167),(2887,168),(2888,168),(2889,168),(2890,168),(2891,168),(2892,168),(2893,169),(2894,169),(2895,169),(2896,169),(2897,169),(2898,169),(2899,170),(2900,170),(2901,170),(2902,170),(2903,170),(2904,170),(2905,171),(2906,171),(2907,171),(2908,171),(2909,171),(2910,171),(2911,172),(2912,172),(2913,172),(2914,172),(2915,172),(2916,172),(2917,173),(2918,173),(2919,173),(2920,173),(2921,173),(2922,173),(2923,174),(2924,174),(2925,174),(2926,174),(2927,174),(2928,174),(2929,174),(2930,174),(2931,174),(2932,175),(2933,175),(2934,175),(2935,175),(2936,175),(2937,175),(2938,176),(2939,176),(2940,176),(2941,176),(2942,176),(2943,176),(2944,177),(2945,177),(2946,177),(2947,177),(2948,177),(2949,177),(2950,178),(2951,178),(2952,178),(2953,178),(2954,178),(2955,178),(2956,179),(2957,179),(2958,179),(2959,179),(2960,179),(2961,179),(2962,180),(2963,180),(2964,180),(2965,180),(2966,180),(2967,180),(2968,181),(2969,181),(2970,181),(2971,181),(2972,181),(2973,181),(2974,182),(2975,182),(2976,182),(2977,182),(2978,182),(2979,182),(2980,183),(2981,183),(2982,183),(2983,183),(2984,183),(2985,183),(2986,184),(2987,184),(2988,184),(2989,184),(2990,184),(2991,184),(2992,185),(2993,185),(2994,185),(2995,185),(2996,185),(2997,185),(2998,186),(2999,186),(3000,186),(3001,186),(3002,186),(3003,186),(3004,187),(3005,187),(3006,187),(3007,187),(3008,187),(3009,187),(3010,188),(3011,188),(3012,188),(3013,188),(3014,188),(3015,188),(3016,189),(3017,189),(3018,189),(3019,189),(3020,189),(3021,189),(3022,190),(3023,190),(3024,190),(3025,190),(3026,190),(3027,190),(3028,190),(3029,190),(3030,190),(3031,191),(3032,191),(3033,191),(3034,191),(3035,191),(3036,191),(3037,192),(3038,192),(3039,192),(3040,192),(3041,192),(3042,192),(3043,193),(3044,193),(3045,193),(3046,193),(3047,193),(3048,193),(3049,194),(3050,194),(3051,194),(3052,194),(3053,194),(3054,194),(3055,195),(3056,195),(3057,195),(3058,195),(3059,195),(3060,195),(3061,196),(3062,196),(3063,196),(3064,196),(3065,196),(3066,196),(3067,197),(3068,197),(3069,197),(3070,197),(3071,197),(3072,197),(3073,198),(3074,198),(3075,198),(3076,198),(3077,198),(3078,198),(3079,199),(3080,199),(3081,199),(3082,199),(3083,199),(3084,199),(3085,200),(3086,200),(3087,200),(3088,200),(3089,200),(3090,200),(3091,201),(3092,201),(3093,201),(3094,201),(3095,201),(3096,201),(3097,202),(3098,202),(3099,202),(3100,202),(3101,202),(3102,202),(3103,203),(3104,203),(3105,203),(3106,203),(3107,203),(3108,203),(3109,204),(3110,204),(3111,204),(3112,204),(3113,204),(3114,204),(3115,205),(3116,205),(3117,205),(3118,205),(3119,205),(3120,205),(3121,206),(3122,206),(3123,206),(3124,206),(3125,206),(3126,206),(3127,206),(3128,206),(3129,206),(3130,207),(3131,207),(3132,207),(3133,207),(3134,207),(3135,207),(3136,208),(3137,208),(3138,208),(3139,208),(3140,208),(3141,208),(3142,209),(3143,209),(3144,209),(3145,209),(3146,209),(3147,209),(3148,210),(3149,210),(3150,210),(3151,210),(3152,210),(3153,210),(3154,211),(3155,211),(3156,211),(3157,211),(3158,211),(3159,211),(3160,212),(3161,212),(3162,212),(3163,212),(3164,212),(3165,212),(3166,213),(3167,213),(3168,213),(3169,213),(3170,213),(3171,213),(3172,214),(3173,214),(3174,214),(3175,214),(3176,214),(3177,214),(3178,215),(3179,215),(3180,215),(3181,215),(3182,215),(3183,215),(3184,216),(3185,216),(3186,216),(3187,216),(3188,216),(3189,216),(3190,217),(3191,217),(3192,217),(3193,217),(3194,217),(3195,217),(3196,218),(3197,218),(3198,218),(3199,218),(3200,218),(3201,218),(3202,219),(3203,219),(3204,219),(3205,219),(3206,219),(3207,219),(3208,220),(3209,220),(3210,220),(3211,220),(3212,220),(3213,220),(3214,221),(3215,221),(3216,221),(3217,221),(3218,221),(3219,221),(3220,222),(3221,222),(3222,222),(3223,222),(3224,222),(3225,222),(3226,222),(3227,222),(3228,222),(3229,223),(3230,223),(3231,223),(3232,223),(3233,223),(3234,223),(3235,224),(3236,224),(3237,224),(3238,224),(3239,224),(3240,224),(3241,225),(3242,225),(3243,225),(3244,225),(3245,225),(3246,225),(3247,226),(3248,226),(3249,226),(3250,226),(3251,226),(3252,226),(3253,227),(3254,227),(3255,227),(3256,227),(3257,227),(3258,227),(3259,228),(3260,228),(3261,228),(3262,228),(3263,228),(3264,228),(3265,229),(3266,229),(3267,229),(3268,229),(3269,229),(3270,229),(3271,230),(3272,230),(3273,230),(3274,230),(3275,230),(3276,230),(3277,231),(3278,231),(3279,231),(3280,231),(3281,231),(3282,231),(3283,232),(3284,232),(3285,232),(3286,232),(3287,232),(3288,232),(3289,233),(3290,233),(3291,233),(3292,233),(3293,233),(3294,233),(3295,234),(3296,234),(3297,234),(3298,234),(3299,234),(3300,234),(3301,235),(3302,235),(3303,235),(3304,235),(3305,235),(3306,235),(3307,236),(3308,236),(3309,236),(3310,236),(3311,236),(3312,236),(3313,237),(3314,237),(3315,237),(3316,237),(3317,237),(3318,237),(3319,238),(3320,238),(3321,238),(3322,238),(3323,238),(3324,238),(3325,238),(3326,238),(3327,238),(3328,239),(3329,239),(3330,239),(3331,239),(3332,239),(3333,239),(3334,240),(3335,240),(3336,240),(3337,240),(3338,240),(3339,240),(3340,241),(3341,241),(3342,241),(3343,241),(3344,241),(3345,241),(3346,242),(3347,242),(3348,242),(3349,242),(3350,242),(3351,242),(3352,243),(3353,243),(3354,243),(3355,243),(3356,243),(3357,243),(3358,244),(3359,244),(3360,244),(3361,244),(3362,244),(3363,244),(3364,245),(3365,245),(3366,245),(3367,245),(3368,245),(3369,245),(3370,246),(3371,246),(3372,246),(3373,246),(3374,246),(3375,246),(3376,147),(3377,147),(3378,148),(3379,148),(3380,149),(3381,149),(3382,150),(3383,150),(3384,151),(3385,151),(3386,152),(3387,152),(3388,153),(3389,153),(3390,154),(3391,154),(3392,155),(3393,155),(3394,156),(3395,156),(3396,157),(3397,157),(3398,158),(3399,159),(3400,159),(3401,160),(3402,160),(3403,161),(3404,161),(3405,162),(3406,162),(3407,163),(3408,163),(3409,164),(3410,164),(3411,165),(3412,165),(3413,166),(3414,166),(3415,167),(3416,167),(3417,168),(3418,168),(3419,169),(3420,169),(3421,170),(3422,170),(3423,171),(3424,171),(3425,172),(3426,172),(3427,173),(3428,173),(3429,174),(3430,175),(3431,175),(3432,176),(3433,176),(3434,177),(3435,177),(3436,178),(3437,178),(3438,179),(3439,179),(3440,180),(3441,180),(3442,181),(3443,181),(3444,182),(3445,182),(3446,183),(3447,183),(3448,184),(3449,184),(3450,185),(3451,185),(3452,186),(3453,186),(3454,187),(3455,187),(3456,188),(3457,188),(3458,189),(3459,189),(3460,190),(3461,191),(3462,191),(3463,192),(3464,192),(3465,193),(3466,193),(3467,194),(3468,194),(3469,195),(3470,195),(3471,196),(3472,196),(3473,197),(3474,197),(3475,198),(3476,198),(3477,199),(3478,199),(3479,200),(3480,200),(3481,201),(3482,201),(3483,202),(3484,202),(3485,203),(3486,203),(3487,204),(3488,204),(3489,205),(3490,205),(3491,206),(3492,207),(3493,207),(3494,208),(3495,208),(3496,209),(3497,209),(3498,210),(3499,210),(3500,211),(3501,211),(3502,212),(3503,212),(3504,213),(3505,213),(3506,214),(3507,214),(3508,215),(3509,215),(3510,216),(3511,216),(3512,217),(3513,217),(3514,218),(3515,218),(3516,219),(3517,219),(3518,220),(3519,220),(3520,221),(3521,221),(3522,222),(3523,223),(3524,223),(3525,224),(3526,224),(3527,225),(3528,225),(3529,226),(3530,226),(3531,227),(3532,227),(3533,228),(3534,228),(3535,229),(3536,229),(3537,230),(3538,230),(3539,231),(3540,231),(3541,232),(3542,232),(3543,233),(3544,233),(3545,234),(3546,234),(3547,235),(3548,235),(3549,236),(3550,236),(3551,237),(3552,237),(3553,238),(3554,239),(3555,239),(3556,240),(3557,240),(3558,241),(3559,241),(3560,242),(3561,242),(3562,243),(3563,243),(3564,244),(3565,244),(3566,245),(3567,245),(3568,246),(3569,246),(3570,247),(3571,247),(3572,247),(3573,247),(3574,247),(3575,247),(3576,247),(3577,248),(3578,248),(3579,248),(3580,248),(3581,248),(3582,248),(3583,248),(3584,249),(3585,249),(3586,249),(3587,249),(3588,249),(3589,249),(3590,249),(3591,250),(3592,250),(3593,250),(3594,250),(3595,250),(3596,250),(3597,250),(3598,251),(3599,251),(3600,251),(3601,251),(3602,251),(3603,251),(3604,251),(3605,252),(3606,252),(3607,252),(3608,252),(3609,252),(3610,252),(3611,252),(3612,253),(3613,253),(3614,253),(3615,253),(3616,253),(3617,253),(3618,253),(3619,254),(3620,254),(3621,254),(3622,254),(3623,254),(3624,254),(3625,254),(3626,255),(3627,255),(3628,255),(3629,255),(3630,255),(3631,255),(3632,255),(3633,256),(3634,256),(3635,256),(3636,256),(3637,256),(3638,256),(3639,256),(3640,257),(3641,257),(3642,257),(3643,257),(3644,257),(3645,257),(3646,257),(3647,258),(3648,258),(3649,258),(3650,258),(3651,258),(3652,258),(3653,258),(3654,259),(3655,259),(3656,259),(3657,259),(3658,259),(3659,259),(3660,259),(3661,260),(3662,260),(3663,260),(3664,260),(3665,260),(3666,260),(3667,260),(3668,261),(3669,261),(3670,261),(3671,261),(3672,261),(3673,261),(3674,261),(3675,262),(3676,262),(3677,262),(3678,262),(3679,262),(3680,262),(3681,262),(3682,263),(3683,263),(3684,263),(3685,263),(3686,263),(3687,263),(3688,263),(3689,264),(3690,264),(3691,264),(3692,264),(3693,264),(3694,264),(3695,264),(3696,265),(3697,265),(3698,265),(3699,265),(3700,265),(3701,265),(3702,265),(3703,266),(3704,266),(3705,266),(3706,266),(3707,266),(3708,266),(3709,266),(3710,267),(3711,267),(3712,267),(3713,267),(3714,267),(3715,267),(3716,267),(3717,268),(3718,268),(3719,268),(3720,268),(3721,268),(3722,268),(3723,268),(3724,269),(3725,269),(3726,269),(3727,269),(3728,269),(3729,269),(3730,269),(3731,270),(3732,270),(3733,270),(3734,270),(3735,270),(3736,270),(3737,270),(3738,271),(3739,271),(3740,271),(3741,271),(3742,271),(3743,271),(3744,271),(3745,272),(3746,272),(3747,272),(3748,272),(3749,272),(3750,272),(3751,272),(3752,273),(3753,273),(3754,273),(3755,273),(3756,273),(3757,273),(3758,273),(3759,274),(3760,274),(3761,274),(3762,274),(3763,274),(3764,274),(3765,274),(3766,275),(3767,275),(3768,275),(3769,275),(3770,275),(3771,275),(3772,275),(3773,276),(3774,276),(3775,276),(3776,276),(3777,276),(3778,276),(3779,276),(3780,277),(3781,277),(3782,277),(3783,277),(3784,277),(3785,277),(3786,277),(3787,278),(3788,278),(3789,278),(3790,278),(3791,278),(3792,278),(3793,278),(3794,279),(3795,279),(3796,279),(3797,279),(3798,279),(3799,279),(3800,279),(3801,280),(3802,280),(3803,280),(3804,280),(3805,280),(3806,280),(3807,280),(3808,281),(3809,281),(3810,281),(3811,281),(3812,281),(3813,281),(3814,281),(3815,282),(3816,282),(3817,282),(3818,282),(3819,282),(3820,282),(3821,282),(3822,283),(3823,283),(3824,283),(3825,283),(3826,283),(3827,283),(3828,283),(3829,284),(3830,284),(3831,284),(3832,284),(3833,284),(3834,284),(3835,284),(3836,285),(3837,285),(3838,285),(3839,285),(3840,285),(3841,285),(3842,285),(3843,286),(3844,286),(3845,286),(3846,286),(3847,286),(3848,286),(3849,286),(3850,287),(3851,287),(3852,287),(3853,287),(3854,287),(3855,287),(3856,287),(3857,288),(3858,288),(3859,288),(3860,288),(3861,288),(3862,288),(3863,288),(3864,289),(3865,289),(3866,289),(3867,289),(3868,289),(3869,289),(3870,289),(3871,290),(3872,290),(3873,290),(3874,290),(3875,290),(3876,290),(3877,290),(3878,291),(3879,291),(3880,291),(3881,291),(3882,291),(3883,291),(3884,291),(3885,292),(3886,292),(3887,292),(3888,292),(3889,292),(3890,292),(3891,292),(3892,293),(3893,293),(3894,293),(3895,293),(3896,293),(3897,293),(3898,293),(3899,294),(3900,294),(3901,294),(3902,294),(3903,294),(3904,294),(3905,294),(3906,295),(3907,295),(3908,295),(3909,295),(3910,295),(3911,295),(3912,295),(3913,296),(3914,296),(3915,296),(3916,296),(3917,296),(3918,296),(3919,296),(3920,297),(3921,297),(3922,297),(3923,297),(3924,297),(3925,297),(3926,297),(3927,298),(3928,298),(3929,298),(3930,298),(3931,298),(3932,298),(3933,298),(3934,299),(3935,299),(3936,299),(3937,299),(3938,299),(3939,299),(3940,299),(3941,300),(3942,300),(3943,300),(3944,300),(3945,300),(3946,300),(3947,300),(3948,301),(3949,301),(3950,301),(3951,301),(3952,301),(3953,301),(3954,301),(3955,302),(3956,302),(3957,302),(3958,302),(3959,302),(3960,302),(3961,302),(3962,303),(3963,303),(3964,303),(3965,303),(3966,303),(3967,303),(3968,303),(3969,304),(3970,304),(3971,304),(3972,304),(3973,304),(3974,304),(3975,304),(3976,305),(3977,305),(3978,305),(3979,305),(3980,305),(3981,305),(3982,305),(3983,306),(3984,306),(3985,306),(3986,306),(3987,306),(3988,306),(3989,306),(3990,307),(3991,307),(3992,307),(3993,307),(3994,307),(3995,307),(3996,307),(3997,308),(3998,308),(3999,308),(4000,308),(4001,308),(4002,308),(4003,308),(4004,309),(4005,309),(4006,309),(4007,309),(4008,309),(4009,309),(4010,309),(4011,310),(4012,310),(4013,310),(4014,310),(4015,310),(4016,310),(4017,310),(4018,311),(4019,311),(4020,311),(4021,311),(4022,311),(4023,311),(4024,311),(4025,312),(4026,312),(4027,312),(4028,312),(4029,312),(4030,312),(4031,312),(4032,313),(4033,313),(4034,313),(4035,313),(4036,313),(4037,313),(4038,313),(4039,314),(4040,314),(4041,314),(4042,314),(4043,314),(4044,314),(4045,314),(4046,315),(4047,315),(4048,315),(4049,315),(4050,315),(4051,315),(4052,315),(4053,316),(4054,316),(4055,316),(4056,316),(4057,316),(4058,316),(4059,316),(4060,317),(4061,317),(4062,317),(4063,317),(4064,317),(4065,317),(4066,317),(4067,318),(4068,318),(4069,318),(4070,318),(4071,318),(4072,318),(4073,318),(4074,319),(4075,319),(4076,319),(4077,319),(4078,319),(4079,319),(4080,319),(4081,320),(4082,320),(4083,320),(4084,320),(4085,320),(4086,320),(4087,320),(4088,321),(4089,321),(4090,321),(4091,321),(4092,321),(4093,321),(4094,321),(4095,322),(4096,322),(4097,322),(4098,322),(4099,322),(4100,322),(4101,322),(4102,323),(4103,323),(4104,323),(4105,323),(4106,323),(4107,323),(4108,323),(4109,324),(4110,324),(4111,324),(4112,324),(4113,324),(4114,324),(4115,324),(4116,325),(4117,325),(4118,325),(4119,325),(4120,325),(4121,325),(4122,325),(4123,326),(4124,326),(4125,326),(4126,326),(4127,326),(4128,326),(4129,326),(4130,327),(4131,327),(4132,327),(4133,327),(4134,327),(4135,327),(4136,327),(4137,328),(4138,328),(4139,328),(4140,328),(4141,328),(4142,328),(4143,328),(4144,329),(4145,329),(4146,329),(4147,329),(4148,329),(4149,329),(4150,329),(4151,330),(4152,330),(4153,330),(4154,330),(4155,330),(4156,330),(4157,330),(4158,331),(4159,331),(4160,331),(4161,331),(4162,331),(4163,331),(4164,331),(4165,332),(4166,332),(4167,332),(4168,332),(4169,332),(4170,332),(4171,332),(4172,333),(4173,333),(4174,333),(4175,333),(4176,333),(4177,333),(4178,333),(4179,334),(4180,334),(4181,334),(4182,334),(4183,334),(4184,334),(4185,334),(4186,335),(4187,335),(4188,335),(4189,335),(4190,335),(4191,335),(4192,335),(4193,336),(4194,336),(4195,336),(4196,336),(4197,336),(4198,336),(4199,336),(4200,337),(4201,337),(4202,337),(4203,337),(4204,337),(4205,337),(4206,337),(4207,338),(4208,338),(4209,338),(4210,338),(4211,338),(4212,338),(4213,338),(4214,339),(4215,339),(4216,339),(4217,339),(4218,339),(4219,339),(4220,339),(4221,340),(4222,340),(4223,340),(4224,340),(4225,340),(4226,340),(4227,340),(4228,341),(4229,341),(4230,341),(4231,341),(4232,341),(4233,341),(4234,341),(4235,342),(4236,342),(4237,342),(4238,342),(4239,342),(4240,342),(4241,342),(4242,343),(4243,343),(4244,343),(4245,343),(4246,343),(4247,343),(4248,343),(4249,344),(4250,344),(4251,344),(4252,344),(4253,344),(4254,344),(4255,344),(4256,345),(4257,345),(4258,345),(4259,345),(4260,345),(4261,345),(4262,345),(4263,346),(4264,346),(4265,346),(4266,346),(4267,346),(4268,346),(4269,346),(4270,247),(4271,247),(4272,247),(4273,247),(4274,247),(4275,247),(4276,248),(4277,248),(4278,248),(4279,248),(4280,248),(4281,248),(4282,249),(4283,249),(4284,249),(4285,249),(4286,249),(4287,249),(4288,250),(4289,250),(4290,250),(4291,250),(4292,250),(4293,250),(4294,251),(4295,251),(4296,251),(4297,251),(4298,251),(4299,251),(4300,252),(4301,252),(4302,252),(4303,252),(4304,252),(4305,252),(4306,253),(4307,253),(4308,253),(4309,253),(4310,253),(4311,253),(4312,254),(4313,254),(4314,254),(4315,254),(4316,254),(4317,254),(4318,254),(4319,254),(4320,254),(4321,255),(4322,255),(4323,255),(4324,255),(4325,255),(4326,255),(4327,256),(4328,256),(4329,256),(4330,256),(4331,256),(4332,256),(4333,257),(4334,257),(4335,257),(4336,257),(4337,257),(4338,257),(4339,258),(4340,258),(4341,258),(4342,258),(4343,258),(4344,258),(4345,259),(4346,259),(4347,259),(4348,259),(4349,259),(4350,259),(4351,260),(4352,260),(4353,260),(4354,260),(4355,260),(4356,260),(4357,261),(4358,261),(4359,261),(4360,261),(4361,261),(4362,261),(4363,262),(4364,262),(4365,262),(4366,262),(4367,262),(4368,262),(4369,263),(4370,263),(4371,263),(4372,263),(4373,263),(4374,263),(4375,264),(4376,264),(4377,264),(4378,264),(4379,264),(4380,264),(4381,265),(4382,265),(4383,265),(4384,265),(4385,265),(4386,265),(4387,266),(4388,266),(4389,266),(4390,266),(4391,266),(4392,266),(4393,267),(4394,267),(4395,267),(4396,267),(4397,267),(4398,267),(4399,268),(4400,268),(4401,268),(4402,268),(4403,268),(4404,268),(4405,269),(4406,269),(4407,269),(4408,269),(4409,269),(4410,269),(4411,270),(4412,270),(4413,270),(4414,270),(4415,270),(4416,270),(4417,270),(4418,270),(4419,270),(4420,271),(4421,271),(4422,271),(4423,271),(4424,271),(4425,271),(4426,272),(4427,272),(4428,272),(4429,272),(4430,272),(4431,272),(4432,273),(4433,273),(4434,273),(4435,273),(4436,273),(4437,273),(4438,274),(4439,274),(4440,274),(4441,274),(4442,274),(4443,274),(4444,275),(4445,275),(4446,275),(4447,275),(4448,275),(4449,275),(4450,276),(4451,276),(4452,276),(4453,276),(4454,276),(4455,276),(4456,277),(4457,277),(4458,277),(4459,277),(4460,277),(4461,277),(4462,278),(4463,278),(4464,278),(4465,278),(4466,278),(4467,278),(4468,279),(4469,279),(4470,279),(4471,279),(4472,279),(4473,279),(4474,280),(4475,280),(4476,280),(4477,280),(4478,280),(4479,280),(4480,281),(4481,281),(4482,281),(4483,281),(4484,281),(4485,281),(4486,282),(4487,282),(4488,282),(4489,282),(4490,282),(4491,282),(4492,283),(4493,283),(4494,283),(4495,283),(4496,283),(4497,283),(4498,284),(4499,284),(4500,284),(4501,284),(4502,284),(4503,284),(4504,285),(4505,285),(4506,285),(4507,285),(4508,285),(4509,285),(4510,286),(4511,286),(4512,286),(4513,286),(4514,286),(4515,286),(4516,286),(4517,286),(4518,286),(4519,287),(4520,287),(4521,287),(4522,287),(4523,287),(4524,287),(4525,288),(4526,288),(4527,288),(4528,288),(4529,288),(4530,288),(4531,289),(4532,289),(4533,289),(4534,289),(4535,289),(4536,289),(4537,290),(4538,290),(4539,290),(4540,290),(4541,290),(4542,290),(4543,291),(4544,291),(4545,291),(4546,291),(4547,291),(4548,291),(4549,292),(4550,292),(4551,292),(4552,292),(4553,292),(4554,292),(4555,293),(4556,293),(4557,293),(4558,293),(4559,293),(4560,293),(4561,294),(4562,294),(4563,294),(4564,294),(4565,294),(4566,294),(4567,295),(4568,295),(4569,295),(4570,295),(4571,295),(4572,295),(4573,296),(4574,296),(4575,296),(4576,296),(4577,296),(4578,296),(4579,297),(4580,297),(4581,297),(4582,297),(4583,297),(4584,297),(4585,298),(4586,298),(4587,298),(4588,298),(4589,298),(4590,298),(4591,299),(4592,299),(4593,299),(4594,299),(4595,299),(4596,299),(4597,300),(4598,300),(4599,300),(4600,300),(4601,300),(4602,300),(4603,301),(4604,301),(4605,301),(4606,301),(4607,301),(4608,301),(4609,302),(4610,302),(4611,302),(4612,302),(4613,302),(4614,302),(4615,302),(4616,302),(4617,302),(4618,303),(4619,303),(4620,303),(4621,303),(4622,303),(4623,303),(4624,304),(4625,304),(4626,304),(4627,304),(4628,304),(4629,304),(4630,305),(4631,305),(4632,305),(4633,305),(4634,305),(4635,305),(4636,306),(4637,306),(4638,306),(4639,306),(4640,306),(4641,306),(4642,307),(4643,307),(4644,307),(4645,307),(4646,307),(4647,307),(4648,308),(4649,308),(4650,308),(4651,308),(4652,308),(4653,308),(4654,309),(4655,309),(4656,309),(4657,309),(4658,309),(4659,309),(4660,310),(4661,310),(4662,310),(4663,310),(4664,310),(4665,310),(4666,311),(4667,311),(4668,311),(4669,311),(4670,311),(4671,311),(4672,312),(4673,312),(4674,312),(4675,312),(4676,312),(4677,312),(4678,313),(4679,313),(4680,313),(4681,313),(4682,313),(4683,313),(4684,314),(4685,314),(4686,314),(4687,314),(4688,314),(4689,314),(4690,315),(4691,315),(4692,315),(4693,315),(4694,315),(4695,315),(4696,316),(4697,316),(4698,316),(4699,316),(4700,316),(4701,316),(4702,317),(4703,317),(4704,317),(4705,317),(4706,317),(4707,317),(4708,318),(4709,318),(4710,318),(4711,318),(4712,318),(4713,318),(4714,318),(4715,318),(4716,318),(4717,319),(4718,319),(4719,319),(4720,319),(4721,319),(4722,319),(4723,320),(4724,320),(4725,320),(4726,320),(4727,320),(4728,320),(4729,321),(4730,321),(4731,321),(4732,321),(4733,321),(4734,321),(4735,322),(4736,322),(4737,322),(4738,322),(4739,322),(4740,322),(4741,323),(4742,323),(4743,323),(4744,323),(4745,323),(4746,323),(4747,324),(4748,324),(4749,324),(4750,324),(4751,324),(4752,324),(4753,325),(4754,325),(4755,325),(4756,325),(4757,325),(4758,325),(4759,326),(4760,326),(4761,326),(4762,326),(4763,326),(4764,326),(4765,327),(4766,327),(4767,327),(4768,327),(4769,327),(4770,327),(4771,328),(4772,328),(4773,328),(4774,328),(4775,328),(4776,328),(4777,329),(4778,329),(4779,329),(4780,329),(4781,329),(4782,329),(4783,330),(4784,330),(4785,330),(4786,330),(4787,330),(4788,330),(4789,331),(4790,331),(4791,331),(4792,331),(4793,331),(4794,331),(4795,332),(4796,332),(4797,332),(4798,332),(4799,332),(4800,332),(4801,333),(4802,333),(4803,333),(4804,333),(4805,333),(4806,333),(4807,334),(4808,334),(4809,334),(4810,334),(4811,334),(4812,334),(4813,334),(4814,334),(4815,334),(4816,335),(4817,335),(4818,335),(4819,335),(4820,335),(4821,335),(4822,336),(4823,336),(4824,336),(4825,336),(4826,336),(4827,336),(4828,337),(4829,337),(4830,337),(4831,337),(4832,337),(4833,337),(4834,338),(4835,338),(4836,338),(4837,338),(4838,338),(4839,338),(4840,339),(4841,339),(4842,339),(4843,339),(4844,339),(4845,339),(4846,340),(4847,340),(4848,340),(4849,340),(4850,340),(4851,340),(4852,341),(4853,341),(4854,341),(4855,341),(4856,341),(4857,341),(4858,342),(4859,342),(4860,342),(4861,342),(4862,342),(4863,342),(4864,343),(4865,343),(4866,343),(4867,343),(4868,343),(4869,343),(4870,344),(4871,344),(4872,344),(4873,344),(4874,344),(4875,344),(4876,345),(4877,345),(4878,345),(4879,345),(4880,345),(4881,345),(4882,346),(4883,346),(4884,346),(4885,346),(4886,346),(4887,346),(4888,247),(4889,247),(4890,248),(4891,248),(4892,249),(4893,249),(4894,250),(4895,250),(4896,251),(4897,251),(4898,252),(4899,252),(4900,253),(4901,253),(4902,254),(4903,255),(4904,255),(4905,256),(4906,256),(4907,257),(4908,257),(4909,258),(4910,258),(4911,259),(4912,259),(4913,260),(4914,260),(4915,261),(4916,261),(4917,262),(4918,262),(4919,263),(4920,263),(4921,264),(4922,264),(4923,265),(4924,265),(4925,266),(4926,266),(4927,267),(4928,267),(4929,268),(4930,268),(4931,269),(4932,269),(4933,270),(4934,271),(4935,271),(4936,272),(4937,272),(4938,273),(4939,273),(4940,274),(4941,274),(4942,275),(4943,275),(4944,276),(4945,276),(4946,277),(4947,277),(4948,278),(4949,278),(4950,279),(4951,279),(4952,280),(4953,280),(4954,281),(4955,281),(4956,282),(4957,282),(4958,283),(4959,283),(4960,284),(4961,284),(4962,285),(4963,285),(4964,286),(4965,287),(4966,287),(4967,288),(4968,288),(4969,289),(4970,289),(4971,290),(4972,290),(4973,291),(4974,291),(4975,292),(4976,292),(4977,293),(4978,293),(4979,294),(4980,294),(4981,295),(4982,295),(4983,296),(4984,296),(4985,297),(4986,297),(4987,298),(4988,298),(4989,299),(4990,299),(4991,300),(4992,300),(4993,301),(4994,301),(4995,302),(4996,303),(4997,303),(4998,304),(4999,304),(5000,305),(5001,305),(5002,306),(5003,306),(5004,307),(5005,307),(5006,308),(5007,308),(5008,309),(5009,309),(5010,310),(5011,310),(5012,311),(5013,311),(5014,312),(5015,312),(5016,313),(5017,313),(5018,314),(5019,314),(5020,315),(5021,315),(5022,316),(5023,316),(5024,317),(5025,317),(5026,318),(5027,319),(5028,319),(5029,320),(5030,320),(5031,321),(5032,321),(5033,322),(5034,322),(5035,323),(5036,323),(5037,324),(5038,324),(5039,325),(5040,325),(5041,326),(5042,326),(5043,327),(5044,327),(5045,328),(5046,328),(5047,329),(5048,329),(5049,330),(5050,330),(5051,331),(5052,331),(5053,332),(5054,332),(5055,333),(5056,333),(5057,334),(5058,335),(5059,335),(5060,336),(5061,336),(5062,337),(5063,337),(5064,338),(5065,338),(5066,339),(5067,339),(5068,340),(5069,340),(5070,341),(5071,341),(5072,342),(5073,342),(5074,343),(5075,343),(5076,344),(5077,344),(5078,345),(5079,345),(5080,346),(5081,346),(5082,347),(5083,347),(5084,347),(5085,347),(5086,347),(5087,347),(5088,347),(5089,348),(5090,348),(5091,348),(5092,348),(5093,348),(5094,348),(5095,348),(5096,349),(5097,349),(5098,349),(5099,349),(5100,349),(5101,349),(5102,349),(5103,350),(5104,350),(5105,350),(5106,350),(5107,350),(5108,350),(5109,350),(5110,351),(5111,351),(5112,351),(5113,351),(5114,351),(5115,351),(5116,351),(5117,352),(5118,352),(5119,352),(5120,352),(5121,352),(5122,352),(5123,352),(5124,353),(5125,353),(5126,353),(5127,353),(5128,353),(5129,353),(5130,353),(5131,354),(5132,354),(5133,354),(5134,354),(5135,354),(5136,354),(5137,354),(5138,355),(5139,355),(5140,355),(5141,355),(5142,355),(5143,355),(5144,355),(5145,356),(5146,356),(5147,356),(5148,356),(5149,356),(5150,356),(5151,356),(5152,357),(5153,357),(5154,357),(5155,357),(5156,357),(5157,357),(5158,357),(5159,358),(5160,358),(5161,358),(5162,358),(5163,358),(5164,358),(5165,358),(5166,359),(5167,359),(5168,359),(5169,359),(5170,359),(5171,359),(5172,359),(5173,360),(5174,360),(5175,360),(5176,360),(5177,360),(5178,360),(5179,360),(5180,361),(5181,361),(5182,361),(5183,361),(5184,361),(5185,361),(5186,361),(5187,362),(5188,362),(5189,362),(5190,362),(5191,362),(5192,362),(5193,362),(5194,363),(5195,363),(5196,363),(5197,363),(5198,363),(5199,363),(5200,363),(5201,364),(5202,364),(5203,364),(5204,364),(5205,364),(5206,364),(5207,364),(5208,365),(5209,365),(5210,365),(5211,365),(5212,365),(5213,365),(5214,365),(5215,366),(5216,366),(5217,366),(5218,366),(5219,366),(5220,366),(5221,366),(5222,367),(5223,367),(5224,367),(5225,367),(5226,367),(5227,367),(5228,367),(5229,368),(5230,368),(5231,368),(5232,368),(5233,368),(5234,368),(5235,368),(5236,369),(5237,369),(5238,369),(5239,369),(5240,369),(5241,369),(5242,369),(5243,370),(5244,370),(5245,370),(5246,370),(5247,370),(5248,370),(5249,370),(5250,371),(5251,371),(5252,371),(5253,371),(5254,371),(5255,371),(5256,371),(5257,372),(5258,372),(5259,372),(5260,372),(5261,372),(5262,372),(5263,372),(5264,373),(5265,373),(5266,373),(5267,373),(5268,373),(5269,373),(5270,373),(5271,374),(5272,374),(5273,374),(5274,374),(5275,374),(5276,374),(5277,374),(5278,375),(5279,375),(5280,375),(5281,375),(5282,375),(5283,375),(5284,375),(5285,376),(5286,376),(5287,376),(5288,376),(5289,376),(5290,376),(5291,376),(5292,377),(5293,377),(5294,377),(5295,377),(5296,377),(5297,377),(5298,377),(5299,378),(5300,378),(5301,378),(5302,378),(5303,378),(5304,378),(5305,378),(5306,379),(5307,379),(5308,379),(5309,379),(5310,379),(5311,379),(5312,379),(5313,380),(5314,380),(5315,380),(5316,380),(5317,380),(5318,380),(5319,380),(5320,381),(5321,381),(5322,381),(5323,381),(5324,381),(5325,381),(5326,381),(5327,382),(5328,382),(5329,382),(5330,382),(5331,382),(5332,382),(5333,382),(5334,383),(5335,383),(5336,383),(5337,383),(5338,383),(5339,383),(5340,383),(5341,384),(5342,384),(5343,384),(5344,384),(5345,384),(5346,384),(5347,384),(5348,385),(5349,385),(5350,385),(5351,385),(5352,385),(5353,385),(5354,385),(5355,386),(5356,386),(5357,386),(5358,386),(5359,386),(5360,386),(5361,386),(5362,387),(5363,387),(5364,387),(5365,387),(5366,387),(5367,387),(5368,387),(5369,388),(5370,388),(5371,388),(5372,388),(5373,388),(5374,388),(5375,388),(5376,389),(5377,389),(5378,389),(5379,389),(5380,389),(5381,389),(5382,389),(5383,390),(5384,390),(5385,390),(5386,390),(5387,390),(5388,390),(5389,390),(5390,391),(5391,391),(5392,391),(5393,391),(5394,391),(5395,391),(5396,391),(5397,392),(5398,392),(5399,392),(5400,392),(5401,392),(5402,392),(5403,392),(5404,393),(5405,393),(5406,393),(5407,393),(5408,393),(5409,393),(5410,393),(5411,394),(5412,394),(5413,394),(5414,394),(5415,394),(5416,394),(5417,394),(5418,395),(5419,395),(5420,395),(5421,395),(5422,395),(5423,395),(5424,395),(5425,396),(5426,396),(5427,396),(5428,396),(5429,396),(5430,396),(5431,396),(5432,397),(5433,397),(5434,397),(5435,397),(5436,397),(5437,397),(5438,397),(5439,398),(5440,398),(5441,398),(5442,398),(5443,398),(5444,398),(5445,398),(5446,399),(5447,399),(5448,399),(5449,399),(5450,399),(5451,399),(5452,399),(5453,400),(5454,400),(5455,400),(5456,400),(5457,400),(5458,400),(5459,400),(5460,401),(5461,401),(5462,401),(5463,401),(5464,401),(5465,401),(5466,401),(5467,402),(5468,402),(5469,402),(5470,402),(5471,402),(5472,402),(5473,402),(5474,403),(5475,403),(5476,403),(5477,403),(5478,403),(5479,403),(5480,403),(5481,404),(5482,404),(5483,404),(5484,404),(5485,404),(5486,404),(5487,404),(5488,405),(5489,405),(5490,405),(5491,405),(5492,405),(5493,405),(5494,405),(5495,406),(5496,406),(5497,406),(5498,406),(5499,406),(5500,406),(5501,406),(5502,407),(5503,407),(5504,407),(5505,407),(5506,407),(5507,407),(5508,407),(5509,408),(5510,408),(5511,408),(5512,408),(5513,408),(5514,408),(5515,408),(5516,409),(5517,409),(5518,409),(5519,409),(5520,409),(5521,409),(5522,409),(5523,410),(5524,410),(5525,410),(5526,410),(5527,410),(5528,410),(5529,410),(5530,411),(5531,411),(5532,411),(5533,411),(5534,411),(5535,411),(5536,411),(5537,412),(5538,412),(5539,412),(5540,412),(5541,412),(5542,412),(5543,412),(5544,413),(5545,413),(5546,413),(5547,413),(5548,413),(5549,413),(5550,413),(5551,414),(5552,414),(5553,414),(5554,414),(5555,414),(5556,414),(5557,414),(5558,415),(5559,415),(5560,415),(5561,415),(5562,415),(5563,415),(5564,415),(5565,416),(5566,416),(5567,416),(5568,416),(5569,416),(5570,416),(5571,416),(5572,417),(5573,417),(5574,417),(5575,417),(5576,417),(5577,417),(5578,417),(5579,418),(5580,418),(5581,418),(5582,418),(5583,418),(5584,418),(5585,418),(5586,419),(5587,419),(5588,419),(5589,419),(5590,419),(5591,419),(5592,419),(5593,420),(5594,420),(5595,420),(5596,420),(5597,420),(5598,420),(5599,420),(5600,421),(5601,421),(5602,421),(5603,421),(5604,421),(5605,421),(5606,421),(5607,422),(5608,422),(5609,422),(5610,422),(5611,422),(5612,422),(5613,422),(5614,423),(5615,423),(5616,423),(5617,423),(5618,423),(5619,423),(5620,423),(5621,424),(5622,424),(5623,424),(5624,424),(5625,424),(5626,424),(5627,424),(5628,425),(5629,425),(5630,425),(5631,425),(5632,425),(5633,425),(5634,425),(5635,426),(5636,426),(5637,426),(5638,426),(5639,426),(5640,426),(5641,426),(5642,427),(5643,427),(5644,427),(5645,427),(5646,427),(5647,427),(5648,427),(5649,428),(5650,428),(5651,428),(5652,428),(5653,428),(5654,428),(5655,428),(5656,429),(5657,429),(5658,429),(5659,429),(5660,429),(5661,429),(5662,429),(5663,430),(5664,430),(5665,430),(5666,430),(5667,430),(5668,430),(5669,430),(5670,431),(5671,431),(5672,431),(5673,431),(5674,431),(5675,431),(5676,431),(5677,432),(5678,432),(5679,432),(5680,432),(5681,432),(5682,432),(5683,432),(5684,433),(5685,433),(5686,433),(5687,433),(5688,433),(5689,433),(5690,433),(5691,434),(5692,434),(5693,434),(5694,434),(5695,434),(5696,434),(5697,434),(5698,435),(5699,435),(5700,435),(5701,435),(5702,435),(5703,435),(5704,435),(5705,436),(5706,436),(5707,436),(5708,436),(5709,436),(5710,436),(5711,436),(5712,437),(5713,437),(5714,437),(5715,437),(5716,437),(5717,437),(5718,437),(5719,438),(5720,438),(5721,438),(5722,438),(5723,438),(5724,438),(5725,438),(5726,439),(5727,439),(5728,439),(5729,439),(5730,439),(5731,439),(5732,439),(5733,440),(5734,440),(5735,440),(5736,440),(5737,440),(5738,440),(5739,440),(5740,441),(5741,441),(5742,441),(5743,441),(5744,441),(5745,441),(5746,441),(5747,442),(5748,442),(5749,442),(5750,442),(5751,442),(5752,442),(5753,442),(5754,443),(5755,443),(5756,443),(5757,443),(5758,443),(5759,443),(5760,443),(5761,444),(5762,444),(5763,444),(5764,444),(5765,444),(5766,444),(5767,444),(5768,445),(5769,445),(5770,445),(5771,445),(5772,445),(5773,445),(5774,445),(5775,446),(5776,446),(5777,446),(5778,446),(5779,446),(5780,446),(5781,446),(5782,347),(5783,347),(5784,347),(5785,347),(5786,347),(5787,347),(5788,348),(5789,348),(5790,348),(5791,348),(5792,348),(5793,348),(5794,349),(5795,349),(5796,349),(5797,349),(5798,349),(5799,349),(5800,350),(5801,350),(5802,350),(5803,350),(5804,350),(5805,350),(5806,350),(5807,350),(5808,350),(5809,351),(5810,351),(5811,351),(5812,351),(5813,351),(5814,351),(5815,352),(5816,352),(5817,352),(5818,352),(5819,352),(5820,352),(5821,353),(5822,353),(5823,353),(5824,353),(5825,353),(5826,353),(5827,354),(5828,354),(5829,354),(5830,354),(5831,354),(5832,354),(5833,355),(5834,355),(5835,355),(5836,355),(5837,355),(5838,355),(5839,356),(5840,356),(5841,356),(5842,356),(5843,356),(5844,356),(5845,357),(5846,357),(5847,357),(5848,357),(5849,357),(5850,357),(5851,358),(5852,358),(5853,358),(5854,358),(5855,358),(5856,358),(5857,359),(5858,359),(5859,359),(5860,359),(5861,359),(5862,359),(5863,360),(5864,360),(5865,360),(5866,360),(5867,360),(5868,360),(5869,361),(5870,361),(5871,361),(5872,361),(5873,361),(5874,361),(5875,362),(5876,362),(5877,362),(5878,362),(5879,362),(5880,362),(5881,363),(5882,363),(5883,363),(5884,363),(5885,363),(5886,363),(5887,364),(5888,364),(5889,364),(5890,364),(5891,364),(5892,364),(5893,365),(5894,365),(5895,365),(5896,365),(5897,365),(5898,365),(5899,366),(5900,366),(5901,366),(5902,366),(5903,366),(5904,366),(5905,366),(5906,366),(5907,366),(5908,367),(5909,367),(5910,367),(5911,367),(5912,367),(5913,367),(5914,368),(5915,368),(5916,368),(5917,368),(5918,368),(5919,368),(5920,369),(5921,369),(5922,369),(5923,369),(5924,369),(5925,369),(5926,370),(5927,370),(5928,370),(5929,370),(5930,370),(5931,370),(5932,371),(5933,371),(5934,371),(5935,371),(5936,371),(5937,371),(5938,372),(5939,372),(5940,372),(5941,372),(5942,372),(5943,372),(5944,373),(5945,373),(5946,373),(5947,373),(5948,373),(5949,373),(5950,374),(5951,374),(5952,374),(5953,374),(5954,374),(5955,374),(5956,375),(5957,375),(5958,375),(5959,375),(5960,375),(5961,375),(5962,376),(5963,376),(5964,376),(5965,376),(5966,376),(5967,376),(5968,377),(5969,377),(5970,377),(5971,377),(5972,377),(5973,377),(5974,378),(5975,378),(5976,378),(5977,378),(5978,378),(5979,378),(5980,379),(5981,379),(5982,379),(5983,379),(5984,379),(5985,379),(5986,380),(5987,380),(5988,380),(5989,380),(5990,380),(5991,380),(5992,381),(5993,381),(5994,381),(5995,381),(5996,381),(5997,381),(5998,382),(5999,382),(6000,382),(6001,382),(6002,382),(6003,382),(6004,382),(6005,382),(6006,382),(6007,383),(6008,383),(6009,383),(6010,383),(6011,383),(6012,383),(6013,384),(6014,384),(6015,384),(6016,384),(6017,384),(6018,384),(6019,385),(6020,385),(6021,385),(6022,385),(6023,385),(6024,385),(6025,386),(6026,386),(6027,386),(6028,386),(6029,386),(6030,386),(6031,387),(6032,387),(6033,387),(6034,387),(6035,387),(6036,387),(6037,388),(6038,388),(6039,388),(6040,388),(6041,388),(6042,388),(6043,389),(6044,389),(6045,389),(6046,389),(6047,389),(6048,389),(6049,390),(6050,390),(6051,390),(6052,390),(6053,390),(6054,390),(6055,391),(6056,391),(6057,391),(6058,391),(6059,391),(6060,391),(6061,392),(6062,392),(6063,392),(6064,392),(6065,392),(6066,392),(6067,393),(6068,393),(6069,393),(6070,393),(6071,393),(6072,393),(6073,394),(6074,394),(6075,394),(6076,394),(6077,394),(6078,394),(6079,395),(6080,395),(6081,395),(6082,395),(6083,395),(6084,395),(6085,396),(6086,396),(6087,396),(6088,396),(6089,396),(6090,396),(6091,397),(6092,397),(6093,397),(6094,397),(6095,397),(6096,397),(6097,398),(6098,398),(6099,398),(6100,398),(6101,398),(6102,398),(6103,398),(6104,398),(6105,398),(6106,399),(6107,399),(6108,399),(6109,399),(6110,399),(6111,399),(6112,400),(6113,400),(6114,400),(6115,400),(6116,400),(6117,400),(6118,401),(6119,401),(6120,401),(6121,401),(6122,401),(6123,401),(6124,402),(6125,402),(6126,402),(6127,402),(6128,402),(6129,402),(6130,403),(6131,403),(6132,403),(6133,403),(6134,403),(6135,403),(6136,404),(6137,404),(6138,404),(6139,404),(6140,404),(6141,404),(6142,405),(6143,405),(6144,405),(6145,405),(6146,405),(6147,405),(6148,406),(6149,406),(6150,406),(6151,406),(6152,406),(6153,406),(6154,407),(6155,407),(6156,407),(6157,407),(6158,407),(6159,407),(6160,408),(6161,408),(6162,408),(6163,408),(6164,408),(6165,408),(6166,409),(6167,409),(6168,409),(6169,409),(6170,409),(6171,409),(6172,410),(6173,410),(6174,410),(6175,410),(6176,410),(6177,410),(6178,411),(6179,411),(6180,411),(6181,411),(6182,411),(6183,411),(6184,412),(6185,412),(6186,412),(6187,412),(6188,412),(6189,412),(6190,413),(6191,413),(6192,413),(6193,413),(6194,413),(6195,413),(6196,414),(6197,414),(6198,414),(6199,414),(6200,414),(6201,414),(6202,414),(6203,414),(6204,414),(6205,415),(6206,415),(6207,415),(6208,415),(6209,415),(6210,415),(6211,416),(6212,416),(6213,416),(6214,416),(6215,416),(6216,416),(6217,417),(6218,417),(6219,417),(6220,417),(6221,417),(6222,417),(6223,418),(6224,418),(6225,418),(6226,418),(6227,418),(6228,418),(6229,419),(6230,419),(6231,419),(6232,419),(6233,419),(6234,419),(6235,420),(6236,420),(6237,420),(6238,420),(6239,420),(6240,420),(6241,421),(6242,421),(6243,421),(6244,421),(6245,421),(6246,421),(6247,422),(6248,422),(6249,422),(6250,422),(6251,422),(6252,422),(6253,423),(6254,423),(6255,423),(6256,423),(6257,423),(6258,423),(6259,424),(6260,424),(6261,424),(6262,424),(6263,424),(6264,424),(6265,425),(6266,425),(6267,425),(6268,425),(6269,425),(6270,425),(6271,426),(6272,426),(6273,426),(6274,426),(6275,426),(6276,426),(6277,427),(6278,427),(6279,427),(6280,427),(6281,427),(6282,427),(6283,428),(6284,428),(6285,428),(6286,428),(6287,428),(6288,428),(6289,429),(6290,429),(6291,429),(6292,429),(6293,429),(6294,429),(6295,430),(6296,430),(6297,430),(6298,430),(6299,430),(6300,430),(6301,430),(6302,430),(6303,430),(6304,431),(6305,431),(6306,431),(6307,431),(6308,431),(6309,431),(6310,432),(6311,432),(6312,432),(6313,432),(6314,432),(6315,432),(6316,433),(6317,433),(6318,433),(6319,433),(6320,433),(6321,433),(6322,434),(6323,434),(6324,434),(6325,434),(6326,434),(6327,434),(6328,435),(6329,435),(6330,435),(6331,435),(6332,435),(6333,435),(6334,436),(6335,436),(6336,436),(6337,436),(6338,436),(6339,436),(6340,437),(6341,437),(6342,437),(6343,437),(6344,437),(6345,437),(6346,438),(6347,438),(6348,438),(6349,438),(6350,438),(6351,438),(6352,439),(6353,439),(6354,439),(6355,439),(6356,439),(6357,439),(6358,440),(6359,440),(6360,440),(6361,440),(6362,440),(6363,440),(6364,441),(6365,441),(6366,441),(6367,441),(6368,441),(6369,441),(6370,442),(6371,442),(6372,442),(6373,442),(6374,442),(6375,442),(6376,443),(6377,443),(6378,443),(6379,443),(6380,443),(6381,443),(6382,444),(6383,444),(6384,444),(6385,444),(6386,444),(6387,444),(6388,445),(6389,445),(6390,445),(6391,445),(6392,445),(6393,445),(6394,446),(6395,446),(6396,446),(6397,446),(6398,446),(6399,446),(6400,446),(6401,446),(6402,446),(6403,347),(6404,347),(6405,348),(6406,348),(6407,349),(6408,349),(6409,350),(6410,351),(6411,351),(6412,352),(6413,352),(6414,353),(6415,353),(6416,354),(6417,354),(6418,355),(6419,355),(6420,356),(6421,356),(6422,357),(6423,357),(6424,358),(6425,358),(6426,359),(6427,359),(6428,360),(6429,360),(6430,361),(6431,361),(6432,362),(6433,362),(6434,363),(6435,363),(6436,364),(6437,364),(6438,365),(6439,365),(6440,366),(6441,367),(6442,367),(6443,368),(6444,368),(6445,369),(6446,369),(6447,370),(6448,370),(6449,371),(6450,371),(6451,372),(6452,372),(6453,373),(6454,373),(6455,374),(6456,374),(6457,375),(6458,375),(6459,376),(6460,376),(6461,377),(6462,377),(6463,378),(6464,378),(6465,379),(6466,379),(6467,380),(6468,380),(6469,381),(6470,381),(6471,382),(6472,383),(6473,383),(6474,384),(6475,384),(6476,385),(6477,385),(6478,386),(6479,386),(6480,387),(6481,387),(6482,388),(6483,388),(6484,389),(6485,389),(6486,390),(6487,390),(6488,391),(6489,391),(6490,392),(6491,392),(6492,393),(6493,393),(6494,394),(6495,394),(6496,395),(6497,395),(6498,396),(6499,396),(6500,397),(6501,397),(6502,398),(6503,399),(6504,399),(6505,400),(6506,400),(6507,401),(6508,401),(6509,402),(6510,402),(6511,403),(6512,403),(6513,404),(6514,404),(6515,405),(6516,405),(6517,406),(6518,406),(6519,407),(6520,407),(6521,408),(6522,408),(6523,409),(6524,409),(6525,410),(6526,410),(6527,411),(6528,411),(6529,412),(6530,412),(6531,413),(6532,413),(6533,414),(6534,415),(6535,415),(6536,416),(6537,416),(6538,417),(6539,417),(6540,418),(6541,418),(6542,419),(6543,419),(6544,420),(6545,420),(6546,421),(6547,421),(6548,422),(6549,422),(6550,423),(6551,423),(6552,424),(6553,424),(6554,425),(6555,425),(6556,426),(6557,426),(6558,427),(6559,427),(6560,428),(6561,428),(6562,429),(6563,429),(6564,430),(6565,431),(6566,431),(6567,432),(6568,432),(6569,433),(6570,433),(6571,434),(6572,434),(6573,435),(6574,435),(6575,436),(6576,436),(6577,437),(6578,437),(6579,438),(6580,438),(6581,439),(6582,439),(6583,440),(6584,440),(6585,441),(6586,441),(6587,442),(6588,442),(6589,443),(6590,443),(6591,444),(6592,444),(6593,445),(6594,445),(6595,446),(6596,447),(6597,447),(6598,447),(6599,447),(6600,447),(6601,447),(6602,447),(6603,448),(6604,448),(6605,448),(6606,448),(6607,448),(6608,448),(6609,448),(6610,449),(6611,449),(6612,449),(6613,449),(6614,449),(6615,449),(6616,449),(6617,450),(6618,450),(6619,450),(6620,450),(6621,450),(6622,450),(6623,450),(6624,451),(6625,451),(6626,451),(6627,451),(6628,451),(6629,451),(6630,451),(6631,452),(6632,452),(6633,452),(6634,452),(6635,452),(6636,452),(6637,452),(6638,453),(6639,453),(6640,453),(6641,453),(6642,453),(6643,453),(6644,453),(6645,454),(6646,454),(6647,454),(6648,454),(6649,454),(6650,454),(6651,454),(6652,455),(6653,455),(6654,455),(6655,455),(6656,455),(6657,455),(6658,455),(6659,456),(6660,456),(6661,456),(6662,456),(6663,456),(6664,456),(6665,456),(6666,457),(6667,457),(6668,457),(6669,457),(6670,457),(6671,457),(6672,457),(6673,458),(6674,458),(6675,458),(6676,458),(6677,458),(6678,458),(6679,458),(6680,459),(6681,459),(6682,459),(6683,459),(6684,459),(6685,459),(6686,459),(6687,460),(6688,460),(6689,460),(6690,460),(6691,460),(6692,460),(6693,460),(6694,461),(6695,461),(6696,461),(6697,461),(6698,461),(6699,461),(6700,461),(6701,462),(6702,462),(6703,462),(6704,462),(6705,462),(6706,462),(6707,462),(6708,463),(6709,463),(6710,463),(6711,463),(6712,463),(6713,463),(6714,463),(6715,464),(6716,464),(6717,464),(6718,464),(6719,464),(6720,464),(6721,464),(6722,465),(6723,465),(6724,465),(6725,465),(6726,465),(6727,465),(6728,465),(6729,466),(6730,466),(6731,466),(6732,466),(6733,466),(6734,466),(6735,466),(6736,467),(6737,467),(6738,467),(6739,467),(6740,467),(6741,467),(6742,467),(6743,468),(6744,468),(6745,468),(6746,468),(6747,468),(6748,468),(6749,468),(6750,469),(6751,469),(6752,469),(6753,469),(6754,469),(6755,469),(6756,469),(6757,470),(6758,470),(6759,470),(6760,470),(6761,470),(6762,470),(6763,470),(6764,471),(6765,471),(6766,471),(6767,471),(6768,471),(6769,471),(6770,471),(6771,472),(6772,472),(6773,472),(6774,472),(6775,472),(6776,472),(6777,472),(6778,473),(6779,473),(6780,473),(6781,473),(6782,473),(6783,473),(6784,473),(6785,474),(6786,474),(6787,474),(6788,474),(6789,474),(6790,474),(6791,474),(6792,475),(6793,475),(6794,475),(6795,475),(6796,475),(6797,475),(6798,475),(6799,476),(6800,476),(6801,476),(6802,476),(6803,476),(6804,476),(6805,476),(6806,477),(6807,477),(6808,477),(6809,477),(6810,477),(6811,477),(6812,477),(6813,478),(6814,478),(6815,478),(6816,478),(6817,478),(6818,478),(6819,478),(6820,479),(6821,479),(6822,479),(6823,479),(6824,479),(6825,479),(6826,479),(6827,480),(6828,480),(6829,480),(6830,480),(6831,480),(6832,480),(6833,480),(6834,481),(6835,481),(6836,481),(6837,481),(6838,481),(6839,481),(6840,481),(6841,482),(6842,482),(6843,482),(6844,482),(6845,482),(6846,482),(6847,482),(6848,483),(6849,483),(6850,483),(6851,483),(6852,483),(6853,483),(6854,483),(6855,484),(6856,484),(6857,484),(6858,484),(6859,484),(6860,484),(6861,484),(6862,485),(6863,485),(6864,485),(6865,485),(6866,485),(6867,485),(6868,485),(6869,486),(6870,486),(6871,486),(6872,486),(6873,486),(6874,486),(6875,486),(6876,487),(6877,487),(6878,487),(6879,487),(6880,487),(6881,487),(6882,487),(6883,488),(6884,488),(6885,488),(6886,488),(6887,488),(6888,488),(6889,488),(6890,489),(6891,489),(6892,489),(6893,489),(6894,489),(6895,489),(6896,489),(6897,490),(6898,490),(6899,490),(6900,490),(6901,490),(6902,490),(6903,490),(6904,491),(6905,491),(6906,491),(6907,491),(6908,491),(6909,491),(6910,491),(6911,492),(6912,492),(6913,492),(6914,492),(6915,492),(6916,492),(6917,492),(6918,493),(6919,493),(6920,493),(6921,493),(6922,493),(6923,493),(6924,493),(6925,494),(6926,494),(6927,494),(6928,494),(6929,494),(6930,494),(6931,494),(6932,495),(6933,495),(6934,495),(6935,495),(6936,495),(6937,495),(6938,495),(6939,496),(6940,496),(6941,496),(6942,496),(6943,496),(6944,496),(6945,496),(6946,497),(6947,497),(6948,497),(6949,497),(6950,497),(6951,497),(6952,497),(6953,498),(6954,498),(6955,498),(6956,498),(6957,498),(6958,498),(6959,498),(6960,499),(6961,499),(6962,499),(6963,499),(6964,499),(6965,499),(6966,499),(6967,500),(6968,500),(6969,500),(6970,500),(6971,500),(6972,500),(6973,500),(6974,501),(6975,501),(6976,501),(6977,501),(6978,501),(6979,501),(6980,501),(6981,502),(6982,502),(6983,502),(6984,502),(6985,502),(6986,502),(6987,502),(6988,503),(6989,503),(6990,503),(6991,503),(6992,503),(6993,503),(6994,503),(6995,504),(6996,504),(6997,504),(6998,504),(6999,504),(7000,504),(7001,504),(7002,505),(7003,505),(7004,505),(7005,505),(7006,505),(7007,505),(7008,505),(7009,506),(7010,506),(7011,506),(7012,506),(7013,506),(7014,506),(7015,506),(7016,507),(7017,507),(7018,507),(7019,507),(7020,507),(7021,507),(7022,507),(7023,508),(7024,508),(7025,508),(7026,508),(7027,508),(7028,508),(7029,508),(7030,509),(7031,509),(7032,509),(7033,509),(7034,509),(7035,509),(7036,509),(7037,510),(7038,510),(7039,510),(7040,510),(7041,510),(7042,510),(7043,510),(7044,511),(7045,511),(7046,511),(7047,511),(7048,511),(7049,511),(7050,511),(7051,512),(7052,512),(7053,512),(7054,512),(7055,512),(7056,512),(7057,512),(7058,513),(7059,513),(7060,513),(7061,513),(7062,513),(7063,513),(7064,513),(7065,514),(7066,514),(7067,514),(7068,514),(7069,514),(7070,514),(7071,514),(7072,515),(7073,515),(7074,515),(7075,515),(7076,515),(7077,515),(7078,515),(7079,516),(7080,516),(7081,516),(7082,516),(7083,516),(7084,516),(7085,516),(7086,517),(7087,517),(7088,517),(7089,517),(7090,517),(7091,517),(7092,517),(7093,518),(7094,518),(7095,518),(7096,518),(7097,518),(7098,518),(7099,518),(7100,519),(7101,519),(7102,519),(7103,519),(7104,519),(7105,519),(7106,519),(7107,520),(7108,520),(7109,520),(7110,520),(7111,520),(7112,520),(7113,520),(7114,521),(7115,521),(7116,521),(7117,521),(7118,521),(7119,521),(7120,521),(7121,522),(7122,522),(7123,522),(7124,522),(7125,522),(7126,522),(7127,522),(7128,523),(7129,523),(7130,523),(7131,523),(7132,523),(7133,523),(7134,523),(7135,524),(7136,524),(7137,524),(7138,524),(7139,524),(7140,524),(7141,524),(7142,525),(7143,525),(7144,525),(7145,525),(7146,525),(7147,525),(7148,525),(7149,526),(7150,526),(7151,526),(7152,526),(7153,526),(7154,526),(7155,526),(7156,527),(7157,527),(7158,527),(7159,527),(7160,527),(7161,527),(7162,527),(7163,528),(7164,528),(7165,528),(7166,528),(7167,528),(7168,528),(7169,528),(7170,529),(7171,529),(7172,529),(7173,529),(7174,529),(7175,529),(7176,529),(7177,530),(7178,530),(7179,530),(7180,530),(7181,530),(7182,530),(7183,530),(7184,531),(7185,531),(7186,531),(7187,531),(7188,531),(7189,531),(7190,531),(7191,532),(7192,532),(7193,532),(7194,532),(7195,532),(7196,532),(7197,532),(7198,533),(7199,533),(7200,533),(7201,533),(7202,533),(7203,533),(7204,533),(7205,534),(7206,534),(7207,534),(7208,534),(7209,534),(7210,534),(7211,534),(7212,535),(7213,535),(7214,535),(7215,535),(7216,535),(7217,535),(7218,535),(7219,536),(7220,536),(7221,536),(7222,536),(7223,536),(7224,536),(7225,536),(7226,537),(7227,537),(7228,537),(7229,537),(7230,537),(7231,537),(7232,537),(7233,538),(7234,538),(7235,538),(7236,538),(7237,538),(7238,538),(7239,538),(7240,539),(7241,539),(7242,539),(7243,539),(7244,539),(7245,539),(7246,539),(7247,540),(7248,540),(7249,540),(7250,540),(7251,540),(7252,540),(7253,540),(7254,541),(7255,541),(7256,541),(7257,541),(7258,541),(7259,541),(7260,541),(7261,542),(7262,542),(7263,542),(7264,542),(7265,542),(7266,542),(7267,542),(7268,543),(7269,543),(7270,543),(7271,543),(7272,543),(7273,543),(7274,543),(7275,544),(7276,544),(7277,544),(7278,544),(7279,544),(7280,544),(7281,544),(7282,545),(7283,545),(7284,545),(7285,545),(7286,545),(7287,545),(7288,545),(7289,546),(7290,546),(7291,546),(7292,546),(7293,546),(7294,546),(7295,546),(7296,447),(7297,447),(7298,447),(7299,447),(7300,447),(7301,447),(7302,448),(7303,448),(7304,448),(7305,448),(7306,448),(7307,448),(7308,449),(7309,449),(7310,449),(7311,449),(7312,449),(7313,449),(7314,450),(7315,450),(7316,450),(7317,450),(7318,450),(7319,450),(7320,451),(7321,451),(7322,451),(7323,451),(7324,451),(7325,451),(7326,452),(7327,452),(7328,452),(7329,452),(7330,452),(7331,452),(7332,453),(7333,453),(7334,453),(7335,453),(7336,453),(7337,453),(7338,454),(7339,454),(7340,454),(7341,454),(7342,454),(7343,454),(7344,455),(7345,455),(7346,455),(7347,455),(7348,455),(7349,455),(7350,456),(7351,456),(7352,456),(7353,456),(7354,456),(7355,456),(7356,457),(7357,457),(7358,457),(7359,457),(7360,457),(7361,457),(7362,458),(7363,458),(7364,458),(7365,458),(7366,458),(7367,458),(7368,459),(7369,459),(7370,459),(7371,459),(7372,459),(7373,459),(7374,460),(7375,460),(7376,460),(7377,460),(7378,460),(7379,460),(7380,461),(7381,461),(7382,461),(7383,461),(7384,461),(7385,461),(7386,462),(7387,462),(7388,462),(7389,462),(7390,462),(7391,462),(7392,462),(7393,462),(7394,462),(7395,463),(7396,463),(7397,463),(7398,463),(7399,463),(7400,463),(7401,464),(7402,464),(7403,464),(7404,464),(7405,464),(7406,464),(7407,465),(7408,465),(7409,465),(7410,465),(7411,465),(7412,465),(7413,466),(7414,466),(7415,466),(7416,466),(7417,466),(7418,466),(7419,467),(7420,467),(7421,467),(7422,467),(7423,467),(7424,467),(7425,468),(7426,468),(7427,468),(7428,468),(7429,468),(7430,468),(7431,469),(7432,469),(7433,469),(7434,469),(7435,469),(7436,469),(7437,470),(7438,470),(7439,470),(7440,470),(7441,470),(7442,470),(7443,471),(7444,471),(7445,471),(7446,471),(7447,471),(7448,471),(7449,472),(7450,472),(7451,472),(7452,472),(7453,472),(7454,472),(7455,473),(7456,473),(7457,473),(7458,473),(7459,473),(7460,473),(7461,474),(7462,474),(7463,474),(7464,474),(7465,474),(7466,474),(7467,475),(7468,475),(7469,475),(7470,475),(7471,475),(7472,475),(7473,476),(7474,476),(7475,476),(7476,476),(7477,476),(7478,476),(7479,477),(7480,477),(7481,477),(7482,477),(7483,477),(7484,477),(7485,478),(7486,478),(7487,478),(7488,478),(7489,478),(7490,478),(7491,478),(7492,478),(7493,478),(7494,479),(7495,479),(7496,479),(7497,479),(7498,479),(7499,479),(7500,480),(7501,480),(7502,480),(7503,480),(7504,480),(7505,480),(7506,481),(7507,481),(7508,481),(7509,481),(7510,481),(7511,481),(7512,482),(7513,482),(7514,482),(7515,482),(7516,482),(7517,482),(7518,483),(7519,483),(7520,483),(7521,483),(7522,483),(7523,483),(7524,484),(7525,484),(7526,484),(7527,484),(7528,484),(7529,484),(7530,485),(7531,485),(7532,485),(7533,485),(7534,485),(7535,485),(7536,486),(7537,486),(7538,486),(7539,486),(7540,486),(7541,486),(7542,487),(7543,487),(7544,487),(7545,487),(7546,487),(7547,487),(7548,488),(7549,488),(7550,488),(7551,488),(7552,488),(7553,488),(7554,489),(7555,489),(7556,489),(7557,489),(7558,489),(7559,489),(7560,490),(7561,490),(7562,490),(7563,490),(7564,490),(7565,490),(7566,491),(7567,491),(7568,491),(7569,491),(7570,491),(7571,491),(7572,492),(7573,492),(7574,492),(7575,492),(7576,492),(7577,492),(7578,493),(7579,493),(7580,493),(7581,493),(7582,493),(7583,493),(7584,494),(7585,494),(7586,494),(7587,494),(7588,494),(7589,494),(7590,494),(7591,494),(7592,494),(7593,495),(7594,495),(7595,495),(7596,495),(7597,495),(7598,495),(7599,496),(7600,496),(7601,496),(7602,496),(7603,496),(7604,496),(7605,497),(7606,497),(7607,497),(7608,497),(7609,497),(7610,497),(7611,498),(7612,498),(7613,498),(7614,498),(7615,498),(7616,498),(7617,499),(7618,499),(7619,499),(7620,499),(7621,499),(7622,499),(7623,500),(7624,500),(7625,500),(7626,500),(7627,500),(7628,500),(7629,501),(7630,501),(7631,501),(7632,501),(7633,501),(7634,501),(7635,502),(7636,502),(7637,502),(7638,502),(7639,502),(7640,502),(7641,503),(7642,503),(7643,503),(7644,503),(7645,503),(7646,503),(7647,504),(7648,504),(7649,504),(7650,504),(7651,504),(7652,504),(7653,505),(7654,505),(7655,505),(7656,505),(7657,505),(7658,505),(7659,506),(7660,506),(7661,506),(7662,506),(7663,506),(7664,506),(7665,507),(7666,507),(7667,507),(7668,507),(7669,507),(7670,507),(7671,508),(7672,508),(7673,508),(7674,508),(7675,508),(7676,508),(7677,509),(7678,509),(7679,509),(7680,509),(7681,509),(7682,509),(7683,510),(7684,510),(7685,510),(7686,510),(7687,510),(7688,510),(7689,510),(7690,510),(7691,510),(7692,511),(7693,511),(7694,511),(7695,511),(7696,511),(7697,511),(7698,512),(7699,512),(7700,512),(7701,512),(7702,512),(7703,512),(7704,513),(7705,513),(7706,513),(7707,513),(7708,513),(7709,513),(7710,514),(7711,514),(7712,514),(7713,514),(7714,514),(7715,514),(7716,515),(7717,515),(7718,515),(7719,515),(7720,515),(7721,515),(7722,516),(7723,516),(7724,516),(7725,516),(7726,516),(7727,516),(7728,517),(7729,517),(7730,517),(7731,517),(7732,517),(7733,517),(7734,518),(7735,518),(7736,518),(7737,518),(7738,518),(7739,518),(7740,519),(7741,519),(7742,519),(7743,519),(7744,519),(7745,519),(7746,520),(7747,520),(7748,520),(7749,520),(7750,520),(7751,520),(7752,521),(7753,521),(7754,521),(7755,521),(7756,521),(7757,521),(7758,522),(7759,522),(7760,522),(7761,522),(7762,522),(7763,522),(7764,523),(7765,523),(7766,523),(7767,523),(7768,523),(7769,523),(7770,524),(7771,524),(7772,524),(7773,524),(7774,524),(7775,524),(7776,525),(7777,525),(7778,525),(7779,525),(7780,525),(7781,525),(7782,526),(7783,526),(7784,526),(7785,526),(7786,526),(7787,526),(7788,526),(7789,526),(7790,526),(7791,527),(7792,527),(7793,527),(7794,527),(7795,527),(7796,527),(7797,528),(7798,528),(7799,528),(7800,528),(7801,528),(7802,528),(7803,529),(7804,529),(7805,529),(7806,529),(7807,529),(7808,529),(7809,530),(7810,530),(7811,530),(7812,530),(7813,530),(7814,530),(7815,531),(7816,531),(7817,531),(7818,531),(7819,531),(7820,531),(7821,532),(7822,532),(7823,532),(7824,532),(7825,532),(7826,532),(7827,533),(7828,533),(7829,533),(7830,533),(7831,533),(7832,533),(7833,534),(7834,534),(7835,534),(7836,534),(7837,534),(7838,534),(7839,535),(7840,535),(7841,535),(7842,535),(7843,535),(7844,535),(7845,536),(7846,536),(7847,536),(7848,536),(7849,536),(7850,536),(7851,537),(7852,537),(7853,537),(7854,537),(7855,537),(7856,537),(7857,538),(7858,538),(7859,538),(7860,538),(7861,538),(7862,538),(7863,539),(7864,539),(7865,539),(7866,539),(7867,539),(7868,539),(7869,540),(7870,540),(7871,540),(7872,540),(7873,540),(7874,540),(7875,541),(7876,541),(7877,541),(7878,541),(7879,541),(7880,541),(7881,542),(7882,542),(7883,542),(7884,542),(7885,542),(7886,542),(7887,542),(7888,542),(7889,542),(7890,543),(7891,543),(7892,543),(7893,543),(7894,543),(7895,543),(7896,544),(7897,544),(7898,544),(7899,544),(7900,544),(7901,544),(7902,545),(7903,545),(7904,545),(7905,545),(7906,545),(7907,545),(7908,546),(7909,546),(7910,546),(7911,546),(7912,546),(7913,546),(7914,447),(7915,447),(7916,448),(7917,448),(7918,449),(7919,449),(7920,450),(7921,450),(7922,451),(7923,451),(7924,452),(7925,452),(7926,453),(7927,453),(7928,454),(7929,454),(7930,455),(7931,455),(7932,456),(7933,456),(7934,457),(7935,457),(7936,458),(7937,458),(7938,459),(7939,459),(7940,460),(7941,460),(7942,461),(7943,461),(7944,462),(7945,463),(7946,463),(7947,464),(7948,464),(7949,465),(7950,465),(7951,466),(7952,466),(7953,467),(7954,467),(7955,468),(7956,468),(7957,469),(7958,469),(7959,470),(7960,470),(7961,471),(7962,471),(7963,472),(7964,472),(7965,473),(7966,473),(7967,474),(7968,474),(7969,475),(7970,475),(7971,476),(7972,476),(7973,477),(7974,477),(7975,478),(7976,479),(7977,479),(7978,480),(7979,480),(7980,481),(7981,481),(7982,482),(7983,482),(7984,483),(7985,483),(7986,484),(7987,484),(7988,485),(7989,485),(7990,486),(7991,486),(7992,487),(7993,487),(7994,488),(7995,488),(7996,489),(7997,489),(7998,490),(7999,490),(8000,491),(8001,491),(8002,492),(8003,492),(8004,493),(8005,493),(8006,494),(8007,495),(8008,495),(8009,496),(8010,496),(8011,497),(8012,497),(8013,498),(8014,498),(8015,499),(8016,499),(8017,500),(8018,500),(8019,501),(8020,501),(8021,502),(8022,502),(8023,503),(8024,503),(8025,504),(8026,504),(8027,505),(8028,505),(8029,506),(8030,506),(8031,507),(8032,507),(8033,508),(8034,508),(8035,509),(8036,509),(8037,510),(8038,511),(8039,511),(8040,512),(8041,512),(8042,513),(8043,513),(8044,514),(8045,514),(8046,515),(8047,515),(8048,516),(8049,516),(8050,517),(8051,517),(8052,518),(8053,518),(8054,519),(8055,519),(8056,520),(8057,520),(8058,521),(8059,521),(8060,522),(8061,522),(8062,523),(8063,523),(8064,524),(8065,524),(8066,525),(8067,525),(8068,526),(8069,527),(8070,527),(8071,528),(8072,528),(8073,529),(8074,529),(8075,530),(8076,530),(8077,531),(8078,531),(8079,532),(8080,532),(8081,533),(8082,533),(8083,534),(8084,534),(8085,535),(8086,535),(8087,536),(8088,536),(8089,537),(8090,537),(8091,538),(8092,538),(8093,539),(8094,539),(8095,540),(8096,540),(8097,541),(8098,541),(8099,542),(8100,543),(8101,543),(8102,544),(8103,544),(8104,545),(8105,545),(8106,546),(8107,546),(8108,547),(8109,547),(8110,547),(8111,547),(8112,547),(8113,547),(8114,547),(8115,548),(8116,548),(8117,548),(8118,548),(8119,548),(8120,548),(8121,548),(8122,549),(8123,549),(8124,549),(8125,549),(8126,549),(8127,549),(8128,549),(8129,550),(8130,550),(8131,550),(8132,550),(8133,550),(8134,550),(8135,550),(8136,551),(8137,551),(8138,551),(8139,551),(8140,551),(8141,551),(8142,551),(8143,552),(8144,552),(8145,552),(8146,552),(8147,552),(8148,552),(8149,552),(8150,553),(8151,553),(8152,553),(8153,553),(8154,553),(8155,553),(8156,553),(8157,554),(8158,554),(8159,554),(8160,554),(8161,554),(8162,554),(8163,554),(8164,555),(8165,555),(8166,555),(8167,555),(8168,555),(8169,555),(8170,555),(8171,556),(8172,556),(8173,556),(8174,556),(8175,556),(8176,556),(8177,556),(8178,557),(8179,557),(8180,557),(8181,557),(8182,557),(8183,557),(8184,557),(8185,558),(8186,558),(8187,558),(8188,558),(8189,558),(8190,558),(8191,558),(8192,559),(8193,559),(8194,559),(8195,559),(8196,559),(8197,559),(8198,559),(8199,560),(8200,560),(8201,560),(8202,560),(8203,560),(8204,560),(8205,560),(8206,561),(8207,561),(8208,561),(8209,561),(8210,561),(8211,561),(8212,561),(8213,562),(8214,562),(8215,562),(8216,562),(8217,562),(8218,562),(8219,562),(8220,563),(8221,563),(8222,563),(8223,563),(8224,563),(8225,563),(8226,563),(8227,564),(8228,564),(8229,564),(8230,564),(8231,564),(8232,564),(8233,564),(8234,565),(8235,565),(8236,565),(8237,565),(8238,565),(8239,565),(8240,565),(8241,566),(8242,566),(8243,566),(8244,566),(8245,566),(8246,566),(8247,566),(8248,567),(8249,567),(8250,567),(8251,567),(8252,567),(8253,567),(8254,567),(8255,568),(8256,568),(8257,568),(8258,568),(8259,568),(8260,568),(8261,568),(8262,569),(8263,569),(8264,569),(8265,569),(8266,569),(8267,569),(8268,569),(8269,570),(8270,570),(8271,570),(8272,570),(8273,570),(8274,570),(8275,570),(8276,571),(8277,571),(8278,571),(8279,571),(8280,571),(8281,571),(8282,571),(8283,572),(8284,572),(8285,572),(8286,572),(8287,572),(8288,572),(8289,572),(8290,573),(8291,573),(8292,573),(8293,573),(8294,573),(8295,573),(8296,573),(8297,574),(8298,574),(8299,574),(8300,574),(8301,574),(8302,574),(8303,574),(8304,575),(8305,575),(8306,575),(8307,575),(8308,575),(8309,575),(8310,575),(8311,576),(8312,576),(8313,576),(8314,576),(8315,576),(8316,576),(8317,576),(8318,577),(8319,577),(8320,577),(8321,577),(8322,577),(8323,577),(8324,577),(8325,578),(8326,578),(8327,578),(8328,578),(8329,578),(8330,578),(8331,578),(8332,579),(8333,579),(8334,579),(8335,579),(8336,579),(8337,579),(8338,579),(8339,580),(8340,580),(8341,580),(8342,580),(8343,580),(8344,580),(8345,580),(8346,581),(8347,581),(8348,581),(8349,581),(8350,581),(8351,581),(8352,581),(8353,582),(8354,582),(8355,582),(8356,582),(8357,582),(8358,582),(8359,582),(8360,583),(8361,583),(8362,583),(8363,583),(8364,583),(8365,583),(8366,583),(8367,584),(8368,584),(8369,584),(8370,584),(8371,584),(8372,584),(8373,584),(8374,585),(8375,585),(8376,585),(8377,585),(8378,585),(8379,585),(8380,585),(8381,586),(8382,586),(8383,586),(8384,586),(8385,586),(8386,586),(8387,586),(8388,587),(8389,587),(8390,587),(8391,587),(8392,587),(8393,587),(8394,587),(8395,588),(8396,588),(8397,588),(8398,588),(8399,588),(8400,588),(8401,588),(8402,589),(8403,589),(8404,589),(8405,589),(8406,589),(8407,589),(8408,589),(8409,590),(8410,590),(8411,590),(8412,590),(8413,590),(8414,590),(8415,590),(8416,591),(8417,591),(8418,591),(8419,591),(8420,591),(8421,591),(8422,591),(8423,592),(8424,592),(8425,592),(8426,592),(8427,592),(8428,592),(8429,592),(8430,593),(8431,593),(8432,593),(8433,593),(8434,593),(8435,593),(8436,593),(8437,594),(8438,594),(8439,594),(8440,594),(8441,594),(8442,594),(8443,594),(8444,595),(8445,595),(8446,595),(8447,595),(8448,595),(8449,595),(8450,595),(8451,596),(8452,596),(8453,596),(8454,596),(8455,596),(8456,596),(8457,596),(8458,597),(8459,597),(8460,597),(8461,597),(8462,597),(8463,597),(8464,597),(8465,598),(8466,598),(8467,598),(8468,598),(8469,598),(8470,598),(8471,598),(8472,599),(8473,599),(8474,599),(8475,599),(8476,599),(8477,599),(8478,599),(8479,600),(8480,600),(8481,600),(8482,600),(8483,600),(8484,600),(8485,600),(8486,601),(8487,601),(8488,601),(8489,601),(8490,601),(8491,601),(8492,601),(8493,602),(8494,602),(8495,602),(8496,602),(8497,602),(8498,602),(8499,602),(8500,603),(8501,603),(8502,603),(8503,603),(8504,603),(8505,603),(8506,603),(8507,604),(8508,604),(8509,604),(8510,604),(8511,604),(8512,604),(8513,604),(8514,605),(8515,605),(8516,605),(8517,605),(8518,605),(8519,605),(8520,605),(8521,606),(8522,606),(8523,606),(8524,606),(8525,606),(8526,606),(8527,606),(8528,607),(8529,607),(8530,607),(8531,607),(8532,607),(8533,607),(8534,607),(8535,608),(8536,608),(8537,608),(8538,608),(8539,608),(8540,608),(8541,608),(8542,609),(8543,609),(8544,609),(8545,609),(8546,609),(8547,609),(8548,609),(8549,610),(8550,610),(8551,610),(8552,610),(8553,610),(8554,610),(8555,610),(8556,611),(8557,611),(8558,611),(8559,611),(8560,611),(8561,611),(8562,611),(8563,612),(8564,612),(8565,612),(8566,612),(8567,612),(8568,612),(8569,612),(8570,613),(8571,613),(8572,613),(8573,613),(8574,613),(8575,613),(8576,613),(8577,614),(8578,614),(8579,614),(8580,614),(8581,614),(8582,614),(8583,614),(8584,615),(8585,615),(8586,615),(8587,615),(8588,615),(8589,615),(8590,615),(8591,616),(8592,616),(8593,616),(8594,616),(8595,616),(8596,616),(8597,616),(8598,617),(8599,617),(8600,617),(8601,617),(8602,617),(8603,617),(8604,617),(8605,618),(8606,618),(8607,618),(8608,618),(8609,618),(8610,618),(8611,618),(8612,619),(8613,619),(8614,619),(8615,619),(8616,619),(8617,619),(8618,619),(8619,620),(8620,620),(8621,620),(8622,620),(8623,620),(8624,620),(8625,620),(8626,621),(8627,621),(8628,621),(8629,621),(8630,621),(8631,621),(8632,621),(8633,622),(8634,622),(8635,622),(8636,622),(8637,622),(8638,622),(8639,622),(8640,623),(8641,623),(8642,623),(8643,623),(8644,623),(8645,623),(8646,623),(8647,624),(8648,624),(8649,624),(8650,624),(8651,624),(8652,624),(8653,624),(8654,625),(8655,625),(8656,625),(8657,625),(8658,625),(8659,625),(8660,625),(8661,626),(8662,626),(8663,626),(8664,626),(8665,626),(8666,626),(8667,626),(8668,627),(8669,627),(8670,627),(8671,627),(8672,627),(8673,627),(8674,627),(8675,628),(8676,628),(8677,628),(8678,628),(8679,628),(8680,628),(8681,628),(8682,629),(8683,629),(8684,629),(8685,629),(8686,629),(8687,629),(8688,629),(8689,630),(8690,630),(8691,630),(8692,630),(8693,630),(8694,630),(8695,630),(8696,631),(8697,631),(8698,631),(8699,631),(8700,631),(8701,631),(8702,631),(8703,632),(8704,632),(8705,632),(8706,632),(8707,632),(8708,632),(8709,632),(8710,633),(8711,633),(8712,633),(8713,633),(8714,633),(8715,633),(8716,633),(8717,634),(8718,634),(8719,634),(8720,634),(8721,634),(8722,634),(8723,634),(8724,635),(8725,635),(8726,635),(8727,635),(8728,635),(8729,635),(8730,635),(8731,636),(8732,636),(8733,636),(8734,636),(8735,636),(8736,636),(8737,636),(8738,637),(8739,637),(8740,637),(8741,637),(8742,637),(8743,637),(8744,637),(8745,638),(8746,638),(8747,638),(8748,638),(8749,638),(8750,638),(8751,638),(8752,639),(8753,639),(8754,639),(8755,639),(8756,639),(8757,639),(8758,639),(8759,640),(8760,640),(8761,640),(8762,640),(8763,640),(8764,640),(8765,640),(8766,641),(8767,641),(8768,641),(8769,641),(8770,641),(8771,641),(8772,641),(8773,642),(8774,642),(8775,642),(8776,642),(8777,642),(8778,642),(8779,642),(8780,643),(8781,643),(8782,643),(8783,643),(8784,643),(8785,643),(8786,643),(8787,644),(8788,644),(8789,644),(8790,644),(8791,644),(8792,644),(8793,644),(8794,645),(8795,645),(8796,645),(8797,645),(8798,645),(8799,645),(8800,645),(8801,646),(8802,646),(8803,646),(8804,646),(8805,646),(8806,646),(8807,646),(8808,547),(8809,547),(8810,547),(8811,547),(8812,547),(8813,547),(8814,548),(8815,548),(8816,548),(8817,548),(8818,548),(8819,548),(8820,549),(8821,549),(8822,549),(8823,549),(8824,549),(8825,549),(8826,550),(8827,550),(8828,550),(8829,550),(8830,550),(8831,550),(8832,551),(8833,551),(8834,551),(8835,551),(8836,551),(8837,551),(8838,552),(8839,552),(8840,552),(8841,552),(8842,552),(8843,552),(8844,553),(8845,553),(8846,553),(8847,553),(8848,553),(8849,553),(8850,554),(8851,554),(8852,554),(8853,554),(8854,554),(8855,554),(8856,555),(8857,555),(8858,555),(8859,555),(8860,555),(8861,555),(8862,556),(8863,556),(8864,556),(8865,556),(8866,556),(8867,556),(8868,557),(8869,557),(8870,557),(8871,557),(8872,557),(8873,557),(8874,558),(8875,558),(8876,558),(8877,558),(8878,558),(8879,558),(8880,558),(8881,558),(8882,558),(8883,559),(8884,559),(8885,559),(8886,559),(8887,559),(8888,559),(8889,560),(8890,560),(8891,560),(8892,560),(8893,560),(8894,560),(8895,561),(8896,561),(8897,561),(8898,561),(8899,561),(8900,561),(8901,562),(8902,562),(8903,562),(8904,562),(8905,562),(8906,562),(8907,563),(8908,563),(8909,563),(8910,563),(8911,563),(8912,563),(8913,564),(8914,564),(8915,564),(8916,564),(8917,564),(8918,564),(8919,565),(8920,565),(8921,565),(8922,565),(8923,565),(8924,565),(8925,566),(8926,566),(8927,566),(8928,566),(8929,566),(8930,566),(8931,567),(8932,567),(8933,567),(8934,567),(8935,567),(8936,567),(8937,568),(8938,568),(8939,568),(8940,568),(8941,568),(8942,568),(8943,569),(8944,569),(8945,569),(8946,569),(8947,569),(8948,569),(8949,570),(8950,570),(8951,570),(8952,570),(8953,570),(8954,570),(8955,571),(8956,571),(8957,571),(8958,571),(8959,571),(8960,571),(8961,572),(8962,572),(8963,572),(8964,572),(8965,572),(8966,572),(8967,573),(8968,573),(8969,573),(8970,573),(8971,573),(8972,573),(8973,574),(8974,574),(8975,574),(8976,574),(8977,574),(8978,574),(8979,574),(8980,574),(8981,574),(8982,575),(8983,575),(8984,575),(8985,575),(8986,575),(8987,575),(8988,576),(8989,576),(8990,576),(8991,576),(8992,576),(8993,576),(8994,577),(8995,577),(8996,577),(8997,577),(8998,577),(8999,577),(9000,578),(9001,578),(9002,578),(9003,578),(9004,578),(9005,578),(9006,579),(9007,579),(9008,579),(9009,579),(9010,579),(9011,579),(9012,580),(9013,580),(9014,580),(9015,580),(9016,580),(9017,580),(9018,581),(9019,581),(9020,581),(9021,581),(9022,581),(9023,581),(9024,582),(9025,582),(9026,582),(9027,582),(9028,582),(9029,582),(9030,583),(9031,583),(9032,583),(9033,583),(9034,583),(9035,583),(9036,584),(9037,584),(9038,584),(9039,584),(9040,584),(9041,584),(9042,585),(9043,585),(9044,585),(9045,585),(9046,585),(9047,585),(9048,586),(9049,586),(9050,586),(9051,586),(9052,586),(9053,586),(9054,587),(9055,587),(9056,587),(9057,587),(9058,587),(9059,587),(9060,588),(9061,588),(9062,588),(9063,588),(9064,588),(9065,588),(9066,589),(9067,589),(9068,589),(9069,589),(9070,589),(9071,589),(9072,590),(9073,590),(9074,590),(9075,590),(9076,590),(9077,590),(9078,590),(9079,590),(9080,590),(9081,591),(9082,591),(9083,591),(9084,591),(9085,591),(9086,591),(9087,592),(9088,592),(9089,592),(9090,592),(9091,592),(9092,592),(9093,593),(9094,593),(9095,593),(9096,593),(9097,593),(9098,593),(9099,594),(9100,594),(9101,594),(9102,594),(9103,594),(9104,594),(9105,595),(9106,595),(9107,595),(9108,595),(9109,595),(9110,595),(9111,596),(9112,596),(9113,596),(9114,596),(9115,596),(9116,596),(9117,597),(9118,597),(9119,597),(9120,597),(9121,597),(9122,597),(9123,598),(9124,598),(9125,598),(9126,598),(9127,598),(9128,598),(9129,599),(9130,599),(9131,599),(9132,599),(9133,599),(9134,599),(9135,600),(9136,600),(9137,600),(9138,600),(9139,600),(9140,600),(9141,601),(9142,601),(9143,601),(9144,601),(9145,601),(9146,601),(9147,602),(9148,602),(9149,602),(9150,602),(9151,602),(9152,602),(9153,603),(9154,603),(9155,603),(9156,603),(9157,603),(9158,603),(9159,604),(9160,604),(9161,604),(9162,604),(9163,604),(9164,604),(9165,605),(9166,605),(9167,605),(9168,605),(9169,605),(9170,605),(9171,606),(9172,606),(9173,606),(9174,606),(9175,606),(9176,606),(9177,606),(9178,606),(9179,606),(9180,607),(9181,607),(9182,607),(9183,607),(9184,607),(9185,607),(9186,608),(9187,608),(9188,608),(9189,608),(9190,608),(9191,608),(9192,609),(9193,609),(9194,609),(9195,609),(9196,609),(9197,609),(9198,610),(9199,610),(9200,610),(9201,610),(9202,610),(9203,610),(9204,611),(9205,611),(9206,611),(9207,611),(9208,611),(9209,611),(9210,612),(9211,612),(9212,612),(9213,612),(9214,612),(9215,612),(9216,613),(9217,613),(9218,613),(9219,613),(9220,613),(9221,613),(9222,614),(9223,614),(9224,614),(9225,614),(9226,614),(9227,614),(9228,615),(9229,615),(9230,615),(9231,615),(9232,615),(9233,615),(9234,616),(9235,616),(9236,616),(9237,616),(9238,616),(9239,616),(9240,617),(9241,617),(9242,617),(9243,617),(9244,617),(9245,617),(9246,618),(9247,618),(9248,618),(9249,618),(9250,618),(9251,618),(9252,619),(9253,619),(9254,619),(9255,619),(9256,619),(9257,619),(9258,620),(9259,620),(9260,620),(9261,620),(9262,620),(9263,620),(9264,621),(9265,621),(9266,621),(9267,621),(9268,621),(9269,621),(9270,622),(9271,622),(9272,622),(9273,622),(9274,622),(9275,622),(9276,622),(9277,622),(9278,622),(9279,623),(9280,623),(9281,623),(9282,623),(9283,623),(9284,623),(9285,624),(9286,624),(9287,624),(9288,624),(9289,624),(9290,624),(9291,625),(9292,625),(9293,625),(9294,625),(9295,625),(9296,625),(9297,626),(9298,626),(9299,626),(9300,626),(9301,626),(9302,626),(9303,627),(9304,627),(9305,627),(9306,627),(9307,627),(9308,627),(9309,628),(9310,628),(9311,628),(9312,628),(9313,628),(9314,628),(9315,629),(9316,629),(9317,629),(9318,629),(9319,629),(9320,629),(9321,630),(9322,630),(9323,630),(9324,630),(9325,630),(9326,630),(9327,631),(9328,631),(9329,631),(9330,631),(9331,631),(9332,631),(9333,632),(9334,632),(9335,632),(9336,632),(9337,632),(9338,632),(9339,633),(9340,633),(9341,633),(9342,633),(9343,633),(9344,633),(9345,634),(9346,634),(9347,634),(9348,634),(9349,634),(9350,634),(9351,635),(9352,635),(9353,635),(9354,635),(9355,635),(9356,635),(9357,636),(9358,636),(9359,636),(9360,636),(9361,636),(9362,636),(9363,637),(9364,637),(9365,637),(9366,637),(9367,637),(9368,637),(9369,638),(9370,638),(9371,638),(9372,638),(9373,638),(9374,638),(9375,638),(9376,638),(9377,638),(9378,639),(9379,639),(9380,639),(9381,639),(9382,639),(9383,639),(9384,640),(9385,640),(9386,640),(9387,640),(9388,640),(9389,640),(9390,641),(9391,641),(9392,641),(9393,641),(9394,641),(9395,641),(9396,642),(9397,642),(9398,642),(9399,642),(9400,642),(9401,642),(9402,643),(9403,643),(9404,643),(9405,643),(9406,643),(9407,643),(9408,644),(9409,644),(9410,644),(9411,644),(9412,644),(9413,644),(9414,645),(9415,645),(9416,645),(9417,645),(9418,645),(9419,645),(9420,646),(9421,646),(9422,646),(9423,646),(9424,646),(9425,646),(9426,547),(9427,547),(9428,548),(9429,548),(9430,549),(9431,549),(9432,550),(9433,550),(9434,551),(9435,551),(9436,552),(9437,552),(9438,553),(9439,553),(9440,554),(9441,554),(9442,555),(9443,555),(9444,556),(9445,556),(9446,557),(9447,557),(9448,558),(9449,559),(9450,559),(9451,560),(9452,560),(9453,561),(9454,561),(9455,562),(9456,562),(9457,563),(9458,563),(9459,564),(9460,564),(9461,565),(9462,565),(9463,566),(9464,566),(9465,567),(9466,567),(9467,568),(9468,568),(9469,569),(9470,569),(9471,570),(9472,570),(9473,571),(9474,571),(9475,572),(9476,572),(9477,573),(9478,573),(9479,574),(9480,575),(9481,575),(9482,576),(9483,576),(9484,577),(9485,577),(9486,578),(9487,578),(9488,579),(9489,579),(9490,580),(9491,580),(9492,581),(9493,581),(9494,582),(9495,582),(9496,583),(9497,583),(9498,584),(9499,584),(9500,585),(9501,585),(9502,586),(9503,586),(9504,587),(9505,587),(9506,588),(9507,588),(9508,589),(9509,589),(9510,590),(9511,591),(9512,591),(9513,592),(9514,592),(9515,593),(9516,593),(9517,594),(9518,594),(9519,595),(9520,595),(9521,596),(9522,596),(9523,597),(9524,597),(9525,598),(9526,598),(9527,599),(9528,599),(9529,600),(9530,600),(9531,601),(9532,601),(9533,602),(9534,602),(9535,603),(9536,603),(9537,604),(9538,604),(9539,605),(9540,605),(9541,606),(9542,607),(9543,607),(9544,608),(9545,608),(9546,609),(9547,609),(9548,610),(9549,610),(9550,611),(9551,611),(9552,612),(9553,612),(9554,613),(9555,613),(9556,614),(9557,614),(9558,615),(9559,615),(9560,616),(9561,616),(9562,617),(9563,617),(9564,618),(9565,618),(9566,619),(9567,619),(9568,620),(9569,620),(9570,621),(9571,621),(9572,622),(9573,623),(9574,623),(9575,624),(9576,624),(9577,625),(9578,625),(9579,626),(9580,626),(9581,627),(9582,627),(9583,628),(9584,628),(9585,629),(9586,629),(9587,630),(9588,630),(9589,631),(9590,631),(9591,632),(9592,632),(9593,633),(9594,633),(9595,634),(9596,634),(9597,635),(9598,635),(9599,636),(9600,636),(9601,637),(9602,637),(9603,638),(9604,639),(9605,639),(9606,640),(9607,640),(9608,641),(9609,641),(9610,642),(9611,642),(9612,643),(9613,643),(9614,644),(9615,644),(9616,645),(9617,645),(9618,646),(9619,646),(9620,647),(9621,647),(9622,647),(9623,647),(9624,647),(9625,647),(9626,647),(9627,648),(9628,648),(9629,648),(9630,648),(9631,648),(9632,648),(9633,648),(9634,649),(9635,649),(9636,649),(9637,649),(9638,649),(9639,649),(9640,649),(9641,650),(9642,650),(9643,650),(9644,650),(9645,650),(9646,650),(9647,650),(9648,651),(9649,651),(9650,651),(9651,651),(9652,651),(9653,651),(9654,651),(9655,652),(9656,652),(9657,652),(9658,652),(9659,652),(9660,652),(9661,652),(9662,653),(9663,653),(9664,653),(9665,653),(9666,653),(9667,653),(9668,653),(9669,654),(9670,654),(9671,654),(9672,654),(9673,654),(9674,654),(9675,654),(9676,655),(9677,655),(9678,655),(9679,655),(9680,655),(9681,655),(9682,655),(9683,656),(9684,656),(9685,656),(9686,656),(9687,656),(9688,656),(9689,656),(9690,657),(9691,657),(9692,657),(9693,657),(9694,657),(9695,657),(9696,657),(9697,658),(9698,658),(9699,658),(9700,658),(9701,658),(9702,658),(9703,658),(9704,659),(9705,659),(9706,659),(9707,659),(9708,659),(9709,659),(9710,659),(9711,660),(9712,660),(9713,660),(9714,660),(9715,660),(9716,660),(9717,660),(9718,661),(9719,661),(9720,661),(9721,661),(9722,661),(9723,661),(9724,661),(9725,662),(9726,662),(9727,662),(9728,662),(9729,662),(9730,662),(9731,662),(9732,663),(9733,663),(9734,663),(9735,663),(9736,663),(9737,663),(9738,663),(9739,664),(9740,664),(9741,664),(9742,664),(9743,664),(9744,664),(9745,664),(9746,665),(9747,665),(9748,665),(9749,665),(9750,665),(9751,665),(9752,665),(9753,666),(9754,666),(9755,666),(9756,666),(9757,666),(9758,666),(9759,666),(9760,667),(9761,667),(9762,667),(9763,667),(9764,667),(9765,667),(9766,667),(9767,668),(9768,668),(9769,668),(9770,668),(9771,668),(9772,668),(9773,668),(9774,669),(9775,669),(9776,669),(9777,669),(9778,669),(9779,669),(9780,669),(9781,670),(9782,670),(9783,670),(9784,670),(9785,670),(9786,670),(9787,670),(9788,671),(9789,671),(9790,671),(9791,671),(9792,671),(9793,671),(9794,671),(9795,672),(9796,672),(9797,672),(9798,672),(9799,672),(9800,672),(9801,672),(9802,673),(9803,673),(9804,673),(9805,673),(9806,673),(9807,673),(9808,673),(9809,674),(9810,674),(9811,674),(9812,674),(9813,674),(9814,674),(9815,674),(9816,675),(9817,675),(9818,675),(9819,675),(9820,675),(9821,675),(9822,675),(9823,676),(9824,676),(9825,676),(9826,676),(9827,676),(9828,676),(9829,676),(9830,677),(9831,677),(9832,677),(9833,677),(9834,677),(9835,677),(9836,677),(9837,678),(9838,678),(9839,678),(9840,678),(9841,678),(9842,678),(9843,678),(9844,679),(9845,679),(9846,679),(9847,679),(9848,679),(9849,679),(9850,679),(9851,680),(9852,680),(9853,680),(9854,680),(9855,680),(9856,680),(9857,680),(9858,681),(9859,681),(9860,681),(9861,681),(9862,681),(9863,681),(9864,681),(9865,682),(9866,682),(9867,682),(9868,682),(9869,682),(9870,682),(9871,682),(9872,683),(9873,683),(9874,683),(9875,683),(9876,683),(9877,683),(9878,683),(9879,684),(9880,684),(9881,684),(9882,684),(9883,684),(9884,684),(9885,684),(9886,685),(9887,685),(9888,685),(9889,685),(9890,685),(9891,685),(9892,685),(9893,686),(9894,686),(9895,686),(9896,686),(9897,686),(9898,686),(9899,686),(9900,687),(9901,687),(9902,687),(9903,687),(9904,687),(9905,687),(9906,687),(9907,688),(9908,688),(9909,688),(9910,688),(9911,688),(9912,688),(9913,688),(9914,689),(9915,689),(9916,689),(9917,689),(9918,689),(9919,689),(9920,689),(9921,690),(9922,690),(9923,690),(9924,690),(9925,690),(9926,690),(9927,690),(9928,691),(9929,691),(9930,691),(9931,691),(9932,691),(9933,691),(9934,691),(9935,692),(9936,692),(9937,692),(9938,692),(9939,692),(9940,692),(9941,692),(9942,693),(9943,693),(9944,693),(9945,693),(9946,693),(9947,693),(9948,693),(9949,694),(9950,694),(9951,694),(9952,694),(9953,694),(9954,694),(9955,694),(9956,695),(9957,695),(9958,695),(9959,695),(9960,695),(9961,695),(9962,695),(9963,696),(9964,696),(9965,696),(9966,696),(9967,696),(9968,696),(9969,696),(9970,697),(9971,697),(9972,697),(9973,697),(9974,697),(9975,697),(9976,697),(9977,698),(9978,698),(9979,698),(9980,698),(9981,698),(9982,698),(9983,698),(9984,699),(9985,699),(9986,699),(9987,699),(9988,699),(9989,699),(9990,699),(9991,700),(9992,700),(9993,700),(9994,700),(9995,700),(9996,700),(9997,700),(9998,701),(9999,701),(10000,701),(10001,701),(10002,701),(10003,701),(10004,701),(10005,702),(10006,702),(10007,702),(10008,702),(10009,702),(10010,702),(10011,702),(10012,703),(10013,703),(10014,703),(10015,703),(10016,703),(10017,703),(10018,703),(10019,704),(10020,704),(10021,704),(10022,704),(10023,704),(10024,704),(10025,704),(10026,705),(10027,705),(10028,705),(10029,705),(10030,705),(10031,705),(10032,705),(10033,706),(10034,706),(10035,706),(10036,706),(10037,706),(10038,706),(10039,706),(10040,707),(10041,707),(10042,707),(10043,707),(10044,707),(10045,707),(10046,707),(10047,708),(10048,708),(10049,708),(10050,708),(10051,708),(10052,708),(10053,708),(10054,709),(10055,709),(10056,709),(10057,709),(10058,709),(10059,709),(10060,709),(10061,710),(10062,710),(10063,710),(10064,710),(10065,710),(10066,710),(10067,710),(10068,711),(10069,711),(10070,711),(10071,711),(10072,711),(10073,711),(10074,711),(10075,712),(10076,712),(10077,712),(10078,712),(10079,712),(10080,712),(10081,712),(10082,713),(10083,713),(10084,713),(10085,713),(10086,713),(10087,713),(10088,713),(10089,714),(10090,714),(10091,714),(10092,714),(10093,714),(10094,714),(10095,714),(10096,715),(10097,715),(10098,715),(10099,715),(10100,715),(10101,715),(10102,715),(10103,716),(10104,716),(10105,716),(10106,716),(10107,716),(10108,716),(10109,716),(10110,717),(10111,717),(10112,717),(10113,717),(10114,717),(10115,717),(10116,717),(10117,718),(10118,718),(10119,718),(10120,718),(10121,718),(10122,718),(10123,718),(10124,719),(10125,719),(10126,719),(10127,719),(10128,719),(10129,719),(10130,719),(10131,720),(10132,720),(10133,720),(10134,720),(10135,720),(10136,720),(10137,720),(10138,721),(10139,721),(10140,721),(10141,721),(10142,721),(10143,721),(10144,721),(10145,722),(10146,722),(10147,722),(10148,722),(10149,722),(10150,722),(10151,722),(10152,723),(10153,723),(10154,723),(10155,723),(10156,723),(10157,723),(10158,723),(10159,724),(10160,724),(10161,724),(10162,724),(10163,724),(10164,724),(10165,724),(10166,725),(10167,725),(10168,725),(10169,725),(10170,725),(10171,725),(10172,725),(10173,726),(10174,726),(10175,726),(10176,726),(10177,726),(10178,726),(10179,726),(10180,727),(10181,727),(10182,727),(10183,727),(10184,727),(10185,727),(10186,727),(10187,728),(10188,728),(10189,728),(10190,728),(10191,728),(10192,728),(10193,728),(10194,729),(10195,729),(10196,729),(10197,729),(10198,729),(10199,729),(10200,729),(10201,730),(10202,730),(10203,730),(10204,730),(10205,730),(10206,730),(10207,730),(10208,731),(10209,731),(10210,731),(10211,731),(10212,731),(10213,731),(10214,731),(10215,732),(10216,732),(10217,732),(10218,732),(10219,732),(10220,732),(10221,732),(10222,733),(10223,733),(10224,733),(10225,733),(10226,733),(10227,733),(10228,733),(10229,734),(10230,734),(10231,734),(10232,734),(10233,734),(10234,734),(10235,734),(10236,735),(10237,735),(10238,735),(10239,735),(10240,735),(10241,735),(10242,735),(10243,736),(10244,736),(10245,736),(10246,736),(10247,736),(10248,736),(10249,736),(10250,737),(10251,737),(10252,737),(10253,737),(10254,737),(10255,737),(10256,737),(10257,738),(10258,738),(10259,738),(10260,738),(10261,738),(10262,738),(10263,738),(10264,739),(10265,739),(10266,739),(10267,739),(10268,739),(10269,739),(10270,739),(10271,740),(10272,740),(10273,740),(10274,740),(10275,740),(10276,740),(10277,740),(10278,741),(10279,741),(10280,741),(10281,741),(10282,741),(10283,741),(10284,741),(10285,742),(10286,742),(10287,742),(10288,742),(10289,742),(10290,742),(10291,742),(10292,743),(10293,743),(10294,743),(10295,743),(10296,743),(10297,743),(10298,743),(10299,744),(10300,744),(10301,744),(10302,744),(10303,744),(10304,744),(10305,744),(10306,745),(10307,745),(10308,745),(10309,745),(10310,745),(10311,745),(10312,745),(10313,746),(10314,746),(10315,746),(10316,746),(10317,746),(10318,746),(10319,746),(10320,647),(10321,647),(10322,647),(10323,647),(10324,647),(10325,647),(10326,648),(10327,648),(10328,648),(10329,648),(10330,648),(10331,648),(10332,649),(10333,649),(10334,649),(10335,649),(10336,649),(10337,649),(10338,650),(10339,650),(10340,650),(10341,650),(10342,650),(10343,650),(10344,651),(10345,651),(10346,651),(10347,651),(10348,651),(10349,651),(10350,652),(10351,652),(10352,652),(10353,652),(10354,652),(10355,652),(10356,653),(10357,653),(10358,653),(10359,653),(10360,653),(10361,653),(10362,654),(10363,654),(10364,654),(10365,654),(10366,654),(10367,654),(10368,654),(10369,654),(10370,654),(10371,655),(10372,655),(10373,655),(10374,655),(10375,655),(10376,655),(10377,656),(10378,656),(10379,656),(10380,656),(10381,656),(10382,656),(10383,657),(10384,657),(10385,657),(10386,657),(10387,657),(10388,657),(10389,658),(10390,658),(10391,658),(10392,658),(10393,658),(10394,658),(10395,659),(10396,659),(10397,659),(10398,659),(10399,659),(10400,659),(10401,660),(10402,660),(10403,660),(10404,660),(10405,660),(10406,660),(10407,661),(10408,661),(10409,661),(10410,661),(10411,661),(10412,661),(10413,662),(10414,662),(10415,662),(10416,662),(10417,662),(10418,662),(10419,663),(10420,663),(10421,663),(10422,663),(10423,663),(10424,663),(10425,664),(10426,664),(10427,664),(10428,664),(10429,664),(10430,664),(10431,665),(10432,665),(10433,665),(10434,665),(10435,665),(10436,665),(10437,666),(10438,666),(10439,666),(10440,666),(10441,666),(10442,666),(10443,667),(10444,667),(10445,667),(10446,667),(10447,667),(10448,667),(10449,668),(10450,668),(10451,668),(10452,668),(10453,668),(10454,668),(10455,669),(10456,669),(10457,669),(10458,669),(10459,669),(10460,669),(10461,670),(10462,670),(10463,670),(10464,670),(10465,670),(10466,670),(10467,670),(10468,670),(10469,670),(10470,671),(10471,671),(10472,671),(10473,671),(10474,671),(10475,671),(10476,672),(10477,672),(10478,672),(10479,672),(10480,672),(10481,672),(10482,673),(10483,673),(10484,673),(10485,673),(10486,673),(10487,673),(10488,674),(10489,674),(10490,674),(10491,674),(10492,674),(10493,674),(10494,675),(10495,675),(10496,675),(10497,675),(10498,675),(10499,675),(10500,676),(10501,676),(10502,676),(10503,676),(10504,676),(10505,676),(10506,676),(10507,676),(10508,676),(10509,677),(10510,677),(10511,677),(10512,677),(10513,677),(10514,677),(10515,678),(10516,678),(10517,678),(10518,678),(10519,678),(10520,678),(10521,679),(10522,679),(10523,679),(10524,679),(10525,679),(10526,679),(10527,680),(10528,680),(10529,680),(10530,680),(10531,680),(10532,680),(10533,681),(10534,681),(10535,681),(10536,681),(10537,681),(10538,681),(10539,682),(10540,682),(10541,682),(10542,682),(10543,682),(10544,682),(10545,682),(10546,682),(10547,682),(10548,683),(10549,683),(10550,683),(10551,683),(10552,683),(10553,683),(10554,684),(10555,684),(10556,684),(10557,684),(10558,684),(10559,684),(10560,685),(10561,685),(10562,685),(10563,685),(10564,685),(10565,685),(10566,686),(10567,686),(10568,686),(10569,686),(10570,686),(10571,686),(10572,687),(10573,687),(10574,687),(10575,687),(10576,687),(10577,687),(10578,688),(10579,688),(10580,688),(10581,688),(10582,688),(10583,688),(10584,688),(10585,688),(10586,688),(10587,689),(10588,689),(10589,689),(10590,689),(10591,689),(10592,689),(10593,690),(10594,690),(10595,690),(10596,690),(10597,690),(10598,690),(10599,691),(10600,691),(10601,691),(10602,691),(10603,691),(10604,691),(10605,692),(10606,692),(10607,692),(10608,692),(10609,692),(10610,692),(10611,693),(10612,693),(10613,693),(10614,693),(10615,693),(10616,693),(10617,694),(10618,694),(10619,694),(10620,694),(10621,694),(10622,694),(10623,694),(10624,694),(10625,694),(10626,695),(10627,695),(10628,695),(10629,695),(10630,695),(10631,695),(10632,696),(10633,696),(10634,696),(10635,696),(10636,696),(10637,696),(10638,697),(10639,697),(10640,697),(10641,697),(10642,697),(10643,697),(10644,698),(10645,698),(10646,698),(10647,698),(10648,698),(10649,698),(10650,699),(10651,699),(10652,699),(10653,699),(10654,699),(10655,699),(10656,700),(10657,700),(10658,700),(10659,700),(10660,700),(10661,700),(10662,700),(10663,700),(10664,700),(10665,701),(10666,701),(10667,701),(10668,701),(10669,701),(10670,701),(10671,702),(10672,702),(10673,702),(10674,702),(10675,702),(10676,702),(10677,703),(10678,703),(10679,703),(10680,703),(10681,703),(10682,703),(10683,704),(10684,704),(10685,704),(10686,704),(10687,704),(10688,704),(10689,705),(10690,705),(10691,705),(10692,705),(10693,705),(10694,705),(10695,706),(10696,706),(10697,706),(10698,706),(10699,706),(10700,706),(10701,706),(10702,706),(10703,706),(10704,707),(10705,707),(10706,707),(10707,707),(10708,707),(10709,707),(10710,708),(10711,708),(10712,708),(10713,708),(10714,708),(10715,708),(10716,709),(10717,709),(10718,709),(10719,709),(10720,709),(10721,709),(10722,710),(10723,710),(10724,710),(10725,710),(10726,710),(10727,710),(10728,711),(10729,711),(10730,711),(10731,711),(10732,711),(10733,711),(10734,712),(10735,712),(10736,712),(10737,712),(10738,712),(10739,712),(10740,712),(10741,712),(10742,712),(10743,713),(10744,713),(10745,713),(10746,713),(10747,713),(10748,713),(10749,714),(10750,714),(10751,714),(10752,714),(10753,714),(10754,714),(10755,715),(10756,715),(10757,715),(10758,715),(10759,715),(10760,715),(10761,716),(10762,716),(10763,716),(10764,716),(10765,716),(10766,716),(10767,717),(10768,717),(10769,717),(10770,717),(10771,717),(10772,717),(10773,718),(10774,718),(10775,718),(10776,718),(10777,718),(10778,718),(10779,718),(10780,718),(10781,718),(10782,719),(10783,719),(10784,719),(10785,719),(10786,719),(10787,719),(10788,720),(10789,720),(10790,720),(10791,720),(10792,720),(10793,720),(10794,721),(10795,721),(10796,721),(10797,721),(10798,721),(10799,721),(10800,722),(10801,722),(10802,722),(10803,722),(10804,722),(10805,722),(10806,723),(10807,723),(10808,723),(10809,723),(10810,723),(10811,723),(10812,724),(10813,724),(10814,724),(10815,724),(10816,724),(10817,724),(10818,724),(10819,724),(10820,724),(10821,725),(10822,725),(10823,725),(10824,725),(10825,725),(10826,725),(10827,726),(10828,726),(10829,726),(10830,726),(10831,726),(10832,726),(10833,727),(10834,727),(10835,727),(10836,727),(10837,727),(10838,727),(10839,728),(10840,728),(10841,728),(10842,728),(10843,728),(10844,728),(10845,729),(10846,729),(10847,729),(10848,729),(10849,729),(10850,729),(10851,730),(10852,730),(10853,730),(10854,730),(10855,730),(10856,730),(10857,731),(10858,731),(10859,731),(10860,731),(10861,731),(10862,731),(10863,732),(10864,732),(10865,732),(10866,732),(10867,732),(10868,732),(10869,733),(10870,733),(10871,733),(10872,733),(10873,733),(10874,733),(10875,734),(10876,734),(10877,734),(10878,734),(10879,734),(10880,734),(10881,735),(10882,735),(10883,735),(10884,735),(10885,735),(10886,735),(10887,736),(10888,736),(10889,736),(10890,736),(10891,736),(10892,736),(10893,737),(10894,737),(10895,737),(10896,737),(10897,737),(10898,737),(10899,737),(10900,737),(10901,737),(10902,738),(10903,738),(10904,738),(10905,738),(10906,738),(10907,738),(10908,739),(10909,739),(10910,739),(10911,739),(10912,739),(10913,739),(10914,740),(10915,740),(10916,740),(10917,740),(10918,740),(10919,740),(10920,741),(10921,741),(10922,741),(10923,741),(10924,741),(10925,741),(10926,742),(10927,742),(10928,742),(10929,742),(10930,742),(10931,742),(10932,743),(10933,743),(10934,743),(10935,743),(10936,743),(10937,743),(10938,744),(10939,744),(10940,744),(10941,744),(10942,744),(10943,744),(10944,745),(10945,745),(10946,745),(10947,745),(10948,745),(10949,745),(10950,746),(10951,746),(10952,746),(10953,746),(10954,746),(10955,746),(10956,647),(10957,647),(10958,648),(10959,648),(10960,649),(10961,649),(10962,650),(10963,650),(10964,651),(10965,651),(10966,652),(10967,652),(10968,653),(10969,653),(10970,654),(10971,655),(10972,655),(10973,656),(10974,656),(10975,657),(10976,657),(10977,658),(10978,658),(10979,659),(10980,659),(10981,660),(10982,660),(10983,661),(10984,661),(10985,662),(10986,662),(10987,663),(10988,663),(10989,664),(10990,664),(10991,665),(10992,665),(10993,666),(10994,666),(10995,667),(10996,667),(10997,668),(10998,668),(10999,669),(11000,669),(11001,670),(11002,671),(11003,671),(11004,672),(11005,672),(11006,673),(11007,673),(11008,674),(11009,674),(11010,675),(11011,675),(11012,676),(11013,677),(11014,677),(11015,678),(11016,678),(11017,679),(11018,679),(11019,680),(11020,680),(11021,681),(11022,681),(11023,682),(11024,683),(11025,683),(11026,684),(11027,684),(11028,685),(11029,685),(11030,686),(11031,686),(11032,687),(11033,687),(11034,688),(11035,689),(11036,689),(11037,690),(11038,690),(11039,691),(11040,691),(11041,692),(11042,692),(11043,693),(11044,693),(11045,694),(11046,695),(11047,695),(11048,696),(11049,696),(11050,697),(11051,697),(11052,698),(11053,698),(11054,699),(11055,699),(11056,700),(11057,701),(11058,701),(11059,702),(11060,702),(11061,703),(11062,703),(11063,704),(11064,704),(11065,705),(11066,705),(11067,706),(11068,707),(11069,707),(11070,708),(11071,708),(11072,709),(11073,709),(11074,710),(11075,710),(11076,711),(11077,711),(11078,712),(11079,713),(11080,713),(11081,714),(11082,714),(11083,715),(11084,715),(11085,716),(11086,716),(11087,717),(11088,717),(11089,718),(11090,719),(11091,719),(11092,720),(11093,720),(11094,721),(11095,721),(11096,722),(11097,722),(11098,723),(11099,723),(11100,724),(11101,725),(11102,725),(11103,726),(11104,726),(11105,727),(11106,727),(11107,728),(11108,728),(11109,729),(11110,729),(11111,730),(11112,730),(11113,731),(11114,731),(11115,732),(11116,732),(11117,733),(11118,733),(11119,734),(11120,734),(11121,735),(11122,735),(11123,736),(11124,736),(11125,737),(11126,738),(11127,738),(11128,739),(11129,739),(11130,740),(11131,740),(11132,741),(11133,741),(11134,742),(11135,742),(11136,743),(11137,743),(11138,744),(11139,744),(11140,745),(11141,745),(11142,746),(11143,746),(11144,747),(11145,747),(11146,747),(11147,747),(11148,747),(11149,747),(11150,747),(11151,748),(11152,748),(11153,748),(11154,748),(11155,748),(11156,748),(11157,748),(11158,749),(11159,749),(11160,749),(11161,749),(11162,749),(11163,749),(11164,749),(11165,750),(11166,750),(11167,750),(11168,750),(11169,750),(11170,750),(11171,750),(11172,751),(11173,751),(11174,751),(11175,751),(11176,751),(11177,751),(11178,751),(11179,752),(11180,752),(11181,752),(11182,752),(11183,752),(11184,752),(11185,752),(11186,753),(11187,753),(11188,753),(11189,753),(11190,753),(11191,753),(11192,753),(11193,754),(11194,754),(11195,754),(11196,754),(11197,754),(11198,754),(11199,754),(11200,755),(11201,755),(11202,755),(11203,755),(11204,755),(11205,755),(11206,755),(11207,756),(11208,756),(11209,756),(11210,756),(11211,756),(11212,756),(11213,756),(11214,757),(11215,757),(11216,757),(11217,757),(11218,757),(11219,757),(11220,757),(11221,758),(11222,758),(11223,758),(11224,758),(11225,758),(11226,758),(11227,758),(11228,759),(11229,759),(11230,759),(11231,759),(11232,759),(11233,759),(11234,759),(11235,760),(11236,760),(11237,760),(11238,760),(11239,760),(11240,760),(11241,760),(11242,761),(11243,761),(11244,761),(11245,761),(11246,761),(11247,761),(11248,761),(11249,762),(11250,762),(11251,762),(11252,762),(11253,762),(11254,762),(11255,762),(11256,763),(11257,763),(11258,763),(11259,763),(11260,763),(11261,763),(11262,763),(11263,764),(11264,764),(11265,764),(11266,764),(11267,764),(11268,764),(11269,764),(11270,765),(11271,765),(11272,765),(11273,765),(11274,765),(11275,765),(11276,765),(11277,766),(11278,766),(11279,766),(11280,766),(11281,766),(11282,766),(11283,766),(11284,767),(11285,767),(11286,767),(11287,767),(11288,767),(11289,767),(11290,767),(11291,768),(11292,768),(11293,768),(11294,768),(11295,768),(11296,768),(11297,768),(11298,769),(11299,769),(11300,769),(11301,769),(11302,769),(11303,769),(11304,769),(11305,770),(11306,770),(11307,770),(11308,770),(11309,770),(11310,770),(11311,770),(11312,771),(11313,771),(11314,771),(11315,771),(11316,771),(11317,771),(11318,771),(11319,772),(11320,772),(11321,772),(11322,772),(11323,772),(11324,772),(11325,772),(11326,773),(11327,773),(11328,773),(11329,773),(11330,773),(11331,773),(11332,773),(11333,774),(11334,774),(11335,774),(11336,774),(11337,774),(11338,774),(11339,774),(11340,775),(11341,775),(11342,775),(11343,775),(11344,775),(11345,775),(11346,775),(11347,776),(11348,776),(11349,776),(11350,776),(11351,776),(11352,776),(11353,776),(11354,777),(11355,777),(11356,777),(11357,777),(11358,777),(11359,777),(11360,777),(11361,778),(11362,778),(11363,778),(11364,778),(11365,778),(11366,778),(11367,778),(11368,779),(11369,779),(11370,779),(11371,779),(11372,779),(11373,779),(11374,779),(11375,780),(11376,780),(11377,780),(11378,780),(11379,780),(11380,780),(11381,780),(11382,781),(11383,781),(11384,781),(11385,781),(11386,781),(11387,781),(11388,781),(11389,782),(11390,782),(11391,782),(11392,782),(11393,782),(11394,782),(11395,782),(11396,783),(11397,783),(11398,783),(11399,783),(11400,783),(11401,783),(11402,783),(11403,784),(11404,784),(11405,784),(11406,784),(11407,784),(11408,784),(11409,784),(11410,785),(11411,785),(11412,785),(11413,785),(11414,785),(11415,785),(11416,785),(11417,786),(11418,786),(11419,786),(11420,786),(11421,786),(11422,786),(11423,786),(11424,787),(11425,787),(11426,787),(11427,787),(11428,787),(11429,787),(11430,787),(11431,788),(11432,788),(11433,788),(11434,788),(11435,788),(11436,788),(11437,788),(11438,789),(11439,789),(11440,789),(11441,789),(11442,789),(11443,789),(11444,789),(11445,790),(11446,790),(11447,790),(11448,790),(11449,790),(11450,790),(11451,790),(11452,791),(11453,791),(11454,791),(11455,791),(11456,791),(11457,791),(11458,791),(11459,792),(11460,792),(11461,792),(11462,792),(11463,792),(11464,792),(11465,792),(11466,793),(11467,793),(11468,793),(11469,793),(11470,793),(11471,793),(11472,793),(11473,794),(11474,794),(11475,794),(11476,794),(11477,794),(11478,794),(11479,794),(11480,795),(11481,795),(11482,795),(11483,795),(11484,795),(11485,795),(11486,795),(11487,796),(11488,796),(11489,796),(11490,796),(11491,796),(11492,796),(11493,796),(11494,797),(11495,797),(11496,797),(11497,797),(11498,797),(11499,797),(11500,797),(11501,798),(11502,798),(11503,798),(11504,798),(11505,798),(11506,798),(11507,798),(11508,799),(11509,799),(11510,799),(11511,799),(11512,799),(11513,799),(11514,799),(11515,800),(11516,800),(11517,800),(11518,800),(11519,800),(11520,800),(11521,800),(11522,801),(11523,801),(11524,801),(11525,801),(11526,801),(11527,801),(11528,801),(11529,802),(11530,802),(11531,802),(11532,802),(11533,802),(11534,802),(11535,802),(11536,803),(11537,803),(11538,803),(11539,803),(11540,803),(11541,803),(11542,803),(11543,804),(11544,804),(11545,804),(11546,804),(11547,804),(11548,804),(11549,804),(11550,805),(11551,805),(11552,805),(11553,805),(11554,805),(11555,805),(11556,805),(11557,806),(11558,806),(11559,806),(11560,806),(11561,806),(11562,806),(11563,806),(11564,807),(11565,807),(11566,807),(11567,807),(11568,807),(11569,807),(11570,807),(11571,808),(11572,808),(11573,808),(11574,808),(11575,808),(11576,808),(11577,808),(11578,809),(11579,809),(11580,809),(11581,809),(11582,809),(11583,809),(11584,809),(11585,810),(11586,810),(11587,810),(11588,810),(11589,810),(11590,810),(11591,810),(11592,811),(11593,811),(11594,811),(11595,811),(11596,811),(11597,811),(11598,811),(11599,812),(11600,812),(11601,812),(11602,812),(11603,812),(11604,812),(11605,812),(11606,813),(11607,813),(11608,813),(11609,813),(11610,813),(11611,813),(11612,813),(11613,814),(11614,814),(11615,814),(11616,814),(11617,814),(11618,814),(11619,814),(11620,815),(11621,815),(11622,815),(11623,815),(11624,815),(11625,815),(11626,815),(11627,816),(11628,816),(11629,816),(11630,816),(11631,816),(11632,816),(11633,816),(11634,817),(11635,817),(11636,817),(11637,817),(11638,817),(11639,817),(11640,817),(11641,818),(11642,818),(11643,818),(11644,818),(11645,818),(11646,818),(11647,818),(11648,819),(11649,819),(11650,819),(11651,819),(11652,819),(11653,819),(11654,819),(11655,820),(11656,820),(11657,820),(11658,820),(11659,820),(11660,820),(11661,820),(11662,821),(11663,821),(11664,821),(11665,821),(11666,821),(11667,821),(11668,821),(11669,822),(11670,822),(11671,822),(11672,822),(11673,822),(11674,822),(11675,822),(11676,823),(11677,823),(11678,823),(11679,823),(11680,823),(11681,823),(11682,823),(11683,824),(11684,824),(11685,824),(11686,824),(11687,824),(11688,824),(11689,824),(11690,825),(11691,825),(11692,825),(11693,825),(11694,825),(11695,825),(11696,825),(11697,826),(11698,826),(11699,826),(11700,826),(11701,826),(11702,826),(11703,826),(11704,827),(11705,827),(11706,827),(11707,827),(11708,827),(11709,827),(11710,827),(11711,828),(11712,828),(11713,828),(11714,828),(11715,828),(11716,828),(11717,828),(11718,829),(11719,829),(11720,829),(11721,829),(11722,829),(11723,829),(11724,829),(11725,830),(11726,830),(11727,830),(11728,830),(11729,830),(11730,830),(11731,830),(11732,831),(11733,831),(11734,831),(11735,831),(11736,831),(11737,831),(11738,831),(11739,832),(11740,832),(11741,832),(11742,832),(11743,832),(11744,832),(11745,832),(11746,833),(11747,833),(11748,833),(11749,833),(11750,833),(11751,833),(11752,833),(11753,834),(11754,834),(11755,834),(11756,834),(11757,834),(11758,834),(11759,834),(11760,835),(11761,835),(11762,835),(11763,835),(11764,835),(11765,835),(11766,835),(11767,836),(11768,836),(11769,836),(11770,836),(11771,836),(11772,836),(11773,836),(11774,837),(11775,837),(11776,837),(11777,837),(11778,837),(11779,837),(11780,837),(11781,838),(11782,838),(11783,838),(11784,838),(11785,838),(11786,838),(11787,838),(11788,839),(11789,839),(11790,839),(11791,839),(11792,839),(11793,839),(11794,839),(11795,840),(11796,840),(11797,840),(11798,840),(11799,840),(11800,840),(11801,840),(11802,841),(11803,841),(11804,841),(11805,841),(11806,841),(11807,841),(11808,841),(11809,842),(11810,842),(11811,842),(11812,842),(11813,842),(11814,842),(11815,842),(11816,843),(11817,843),(11818,843),(11819,843),(11820,843),(11821,843),(11822,843),(11823,844),(11824,844),(11825,844),(11826,844),(11827,844),(11828,844),(11829,844),(11830,845),(11831,845),(11832,845),(11833,845),(11834,845),(11835,845),(11836,845),(11837,846),(11838,846),(11839,846),(11840,846),(11841,846),(11842,846),(11843,846),(11844,747),(11845,747),(11846,747),(11847,747),(11848,747),(11849,747),(11850,748),(11851,748),(11852,748),(11853,748),(11854,748),(11855,748),(11856,749),(11857,749),(11858,749),(11859,749),(11860,749),(11861,749),(11862,750),(11863,750),(11864,750),(11865,750),(11866,750),(11867,750),(11868,750),(11869,750),(11870,750),(11871,751),(11872,751),(11873,751),(11874,751),(11875,751),(11876,751),(11877,752),(11878,752),(11879,752),(11880,752),(11881,752),(11882,752),(11883,753),(11884,753),(11885,753),(11886,753),(11887,753),(11888,753),(11889,754),(11890,754),(11891,754),(11892,754),(11893,754),(11894,754),(11895,755),(11896,755),(11897,755),(11898,755),(11899,755),(11900,755),(11901,756),(11902,756),(11903,756),(11904,756),(11905,756),(11906,756),(11907,757),(11908,757),(11909,757),(11910,757),(11911,757),(11912,757),(11913,758),(11914,758),(11915,758),(11916,758),(11917,758),(11918,758),(11919,759),(11920,759),(11921,759),(11922,759),(11923,759),(11924,759),(11925,760),(11926,760),(11927,760),(11928,760),(11929,760),(11930,760),(11931,761),(11932,761),(11933,761),(11934,761),(11935,761),(11936,761),(11937,762),(11938,762),(11939,762),(11940,762),(11941,762),(11942,762),(11943,763),(11944,763),(11945,763),(11946,763),(11947,763),(11948,763),(11949,763),(11950,763),(11951,763),(11952,764),(11953,764),(11954,764),(11955,764),(11956,764),(11957,764),(11958,765),(11959,765),(11960,765),(11961,765),(11962,765),(11963,765),(11964,766),(11965,766),(11966,766),(11967,766),(11968,766),(11969,766),(11970,767),(11971,767),(11972,767),(11973,767),(11974,767),(11975,767),(11976,768),(11977,768),(11978,768),(11979,768),(11980,768),(11981,768),(11982,769),(11983,769),(11984,769),(11985,769),(11986,769),(11987,769),(11988,770),(11989,770),(11990,770),(11991,770),(11992,770),(11993,770),(11994,771),(11995,771),(11996,771),(11997,771),(11998,771),(11999,771),(12000,772),(12001,772),(12002,772),(12003,772),(12004,772),(12005,772),(12006,773),(12007,773),(12008,773),(12009,773),(12010,773),(12011,773),(12012,774),(12013,774),(12014,774),(12015,774),(12016,774),(12017,774),(12018,775),(12019,775),(12020,775),(12021,775),(12022,775),(12023,775),(12024,776),(12025,776),(12026,776),(12027,776),(12028,776),(12029,776),(12030,776),(12031,776),(12032,776),(12033,777),(12034,777),(12035,777),(12036,777),(12037,777),(12038,777),(12039,778),(12040,778),(12041,778),(12042,778),(12043,778),(12044,778),(12045,779),(12046,779),(12047,779),(12048,779),(12049,779),(12050,779),(12051,780),(12052,780),(12053,780),(12054,780),(12055,780),(12056,780),(12057,781),(12058,781),(12059,781),(12060,781),(12061,781),(12062,781),(12063,782),(12064,782),(12065,782),(12066,782),(12067,782),(12068,782),(12069,783),(12070,783),(12071,783),(12072,783),(12073,783),(12074,783),(12075,784),(12076,784),(12077,784),(12078,784),(12079,784),(12080,784),(12081,785),(12082,785),(12083,785),(12084,785),(12085,785),(12086,785),(12087,786),(12088,786),(12089,786),(12090,786),(12091,786),(12092,786),(12093,787),(12094,787),(12095,787),(12096,787),(12097,787),(12098,787),(12099,788),(12100,788),(12101,788),(12102,788),(12103,788),(12104,788),(12105,789),(12106,789),(12107,789),(12108,789),(12109,789),(12110,789),(12111,789),(12112,789),(12113,789),(12114,790),(12115,790),(12116,790),(12117,790),(12118,790),(12119,790),(12120,791),(12121,791),(12122,791),(12123,791),(12124,791),(12125,791),(12126,792),(12127,792),(12128,792),(12129,792),(12130,792),(12131,792),(12132,793),(12133,793),(12134,793),(12135,793),(12136,793),(12137,793),(12138,794),(12139,794),(12140,794),(12141,794),(12142,794),(12143,794),(12144,795),(12145,795),(12146,795),(12147,795),(12148,795),(12149,795),(12150,796),(12151,796),(12152,796),(12153,796),(12154,796),(12155,796),(12156,797),(12157,797),(12158,797),(12159,797),(12160,797),(12161,797),(12162,798),(12163,798),(12164,798),(12165,798),(12166,798),(12167,798),(12168,799),(12169,799),(12170,799),(12171,799),(12172,799),(12173,799),(12174,800),(12175,800),(12176,800),(12177,800),(12178,800),(12179,800),(12180,801),(12181,801),(12182,801),(12183,801),(12184,801),(12185,801),(12186,802),(12187,802),(12188,802),(12189,802),(12190,802),(12191,802),(12192,802),(12193,802),(12194,802),(12195,803),(12196,803),(12197,803),(12198,803),(12199,803),(12200,803),(12201,804),(12202,804),(12203,804),(12204,804),(12205,804),(12206,804),(12207,805),(12208,805),(12209,805),(12210,805),(12211,805),(12212,805),(12213,806),(12214,806),(12215,806),(12216,806),(12217,806),(12218,806),(12219,807),(12220,807),(12221,807),(12222,807),(12223,807),(12224,807),(12225,808),(12226,808),(12227,808),(12228,808),(12229,808),(12230,808),(12231,809),(12232,809),(12233,809),(12234,809),(12235,809),(12236,809),(12237,810),(12238,810),(12239,810),(12240,810),(12241,810),(12242,810),(12243,811),(12244,811),(12245,811),(12246,811),(12247,811),(12248,811),(12249,812),(12250,812),(12251,812),(12252,812),(12253,812),(12254,812),(12255,813),(12256,813),(12257,813),(12258,813),(12259,813),(12260,813),(12261,814),(12262,814),(12263,814),(12264,814),(12265,814),(12266,814),(12267,815),(12268,815),(12269,815),(12270,815),(12271,815),(12272,815),(12273,815),(12274,815),(12275,815),(12276,816),(12277,816),(12278,816),(12279,816),(12280,816),(12281,816),(12282,817),(12283,817),(12284,817),(12285,817),(12286,817),(12287,817),(12288,818),(12289,818),(12290,818),(12291,818),(12292,818),(12293,818),(12294,819),(12295,819),(12296,819),(12297,819),(12298,819),(12299,819),(12300,820),(12301,820),(12302,820),(12303,820),(12304,820),(12305,820),(12306,821),(12307,821),(12308,821),(12309,821),(12310,821),(12311,821),(12312,822),(12313,822),(12314,822),(12315,822),(12316,822),(12317,822),(12318,823),(12319,823),(12320,823),(12321,823),(12322,823),(12323,823),(12324,824),(12325,824),(12326,824),(12327,824),(12328,824),(12329,824),(12330,825),(12331,825),(12332,825),(12333,825),(12334,825),(12335,825),(12336,826),(12337,826),(12338,826),(12339,826),(12340,826),(12341,826),(12342,827),(12343,827),(12344,827),(12345,827),(12346,827),(12347,827),(12348,828),(12349,828),(12350,828),(12351,828),(12352,828),(12353,828),(12354,828),(12355,828),(12356,828),(12357,829),(12358,829),(12359,829),(12360,829),(12361,829),(12362,829),(12363,830),(12364,830),(12365,830),(12366,830),(12367,830),(12368,830),(12369,831),(12370,831),(12371,831),(12372,831),(12373,831),(12374,831),(12375,832),(12376,832),(12377,832),(12378,832),(12379,832),(12380,832),(12381,833),(12382,833),(12383,833),(12384,833),(12385,833),(12386,833),(12387,834),(12388,834),(12389,834),(12390,834),(12391,834),(12392,834),(12393,835),(12394,835),(12395,835),(12396,835),(12397,835),(12398,835),(12399,836),(12400,836),(12401,836),(12402,836),(12403,836),(12404,836),(12405,837),(12406,837),(12407,837),(12408,837),(12409,837),(12410,837),(12411,838),(12412,838),(12413,838),(12414,838),(12415,838),(12416,838),(12417,839),(12418,839),(12419,839),(12420,839),(12421,839),(12422,839),(12423,840),(12424,840),(12425,840),(12426,840),(12427,840),(12428,840),(12429,841),(12430,841),(12431,841),(12432,841),(12433,841),(12434,841),(12435,841),(12436,841),(12437,841),(12438,842),(12439,842),(12440,842),(12441,842),(12442,842),(12443,842),(12444,843),(12445,843),(12446,843),(12447,843),(12448,843),(12449,843),(12450,844),(12451,844),(12452,844),(12453,844),(12454,844),(12455,844),(12456,845),(12457,845),(12458,845),(12459,845),(12460,845),(12461,845),(12462,846),(12463,846),(12464,846),(12465,846),(12466,846),(12467,846),(12468,747),(12469,747),(12470,748),(12471,748),(12472,749),(12473,749),(12474,750),(12475,751),(12476,751),(12477,752),(12478,752),(12479,753),(12480,753),(12481,754),(12482,754),(12483,755),(12484,755),(12485,756),(12486,756),(12487,757),(12488,757),(12489,758),(12490,758),(12491,759),(12492,759),(12493,760),(12494,760),(12495,761),(12496,761),(12497,762),(12498,762),(12499,763),(12500,764),(12501,764),(12502,765),(12503,765),(12504,766),(12505,766),(12506,767),(12507,767),(12508,768),(12509,768),(12510,769),(12511,769),(12512,770),(12513,770),(12514,771),(12515,771),(12516,772),(12517,772),(12518,773),(12519,773),(12520,774),(12521,774),(12522,775),(12523,775),(12524,776),(12525,777),(12526,777),(12527,778),(12528,778),(12529,779),(12530,779),(12531,780),(12532,780),(12533,781),(12534,781),(12535,782),(12536,782),(12537,783),(12538,783),(12539,784),(12540,784),(12541,785),(12542,785),(12543,786),(12544,786),(12545,787),(12546,787),(12547,788),(12548,788),(12549,789),(12550,790),(12551,790),(12552,791),(12553,791),(12554,792),(12555,792),(12556,793),(12557,793),(12558,794),(12559,794),(12560,795),(12561,795),(12562,796),(12563,796),(12564,797),(12565,797),(12566,798),(12567,798),(12568,799),(12569,799),(12570,800),(12571,800),(12572,801),(12573,801),(12574,802),(12575,803),(12576,803),(12577,804),(12578,804),(12579,805),(12580,805),(12581,806),(12582,806),(12583,807),(12584,807),(12585,808),(12586,808),(12587,809),(12588,809),(12589,810),(12590,810),(12591,811),(12592,811),(12593,812),(12594,812),(12595,813),(12596,813),(12597,814),(12598,814),(12599,815),(12600,816),(12601,816),(12602,817),(12603,817),(12604,818),(12605,818),(12606,819),(12607,819),(12608,820),(12609,820),(12610,821),(12611,821),(12612,822),(12613,822),(12614,823),(12615,823),(12616,824),(12617,824),(12618,825),(12619,825),(12620,826),(12621,826),(12622,827),(12623,827),(12624,828),(12625,829),(12626,829),(12627,830),(12628,830),(12629,831),(12630,831),(12631,832),(12632,832),(12633,833),(12634,833),(12635,834),(12636,834),(12637,835),(12638,835),(12639,836),(12640,836),(12641,837),(12642,837),(12643,838),(12644,838),(12645,839),(12646,839),(12647,840),(12648,840),(12649,841),(12650,842),(12651,842),(12652,843),(12653,843),(12654,844),(12655,844),(12656,845),(12657,845),(12658,846),(12659,846),(12660,847),(12661,847),(12662,847),(12663,847),(12664,847),(12665,847),(12666,847),(12667,848),(12668,848),(12669,848),(12670,848),(12671,848),(12672,848),(12673,848),(12674,849),(12675,849),(12676,849),(12677,849),(12678,849),(12679,849),(12680,849),(12681,850),(12682,850),(12683,850),(12684,850),(12685,850),(12686,850),(12687,850),(12688,851),(12689,851),(12690,851),(12691,851),(12692,851),(12693,851),(12694,851),(12695,852),(12696,852),(12697,852),(12698,852),(12699,852),(12700,852),(12701,852),(12702,853),(12703,853),(12704,853),(12705,853),(12706,853),(12707,853),(12708,853),(12709,854),(12710,854),(12711,854),(12712,854),(12713,854),(12714,854),(12715,854),(12716,855),(12717,855),(12718,855),(12719,855),(12720,855),(12721,855),(12722,855),(12723,856),(12724,856),(12725,856),(12726,856),(12727,856),(12728,856),(12729,856),(12730,857),(12731,857),(12732,857),(12733,857),(12734,857),(12735,857),(12736,857),(12737,858),(12738,858),(12739,858),(12740,858),(12741,858),(12742,858),(12743,858),(12744,859),(12745,859),(12746,859),(12747,859),(12748,859),(12749,859),(12750,859),(12751,860),(12752,860),(12753,860),(12754,860),(12755,860),(12756,860),(12757,860),(12758,861),(12759,861),(12760,861),(12761,861),(12762,861),(12763,861),(12764,861),(12765,862),(12766,862),(12767,862),(12768,862),(12769,862),(12770,862),(12771,862),(12772,863),(12773,863),(12774,863),(12775,863),(12776,863),(12777,863),(12778,863),(12779,864),(12780,864),(12781,864),(12782,864),(12783,864),(12784,864),(12785,864),(12786,865),(12787,865),(12788,865),(12789,865),(12790,865),(12791,865),(12792,865),(12793,866),(12794,866),(12795,866),(12796,866),(12797,866),(12798,866),(12799,866),(12800,867),(12801,867),(12802,867),(12803,867),(12804,867),(12805,867),(12806,867),(12807,868),(12808,868),(12809,868),(12810,868),(12811,868),(12812,868),(12813,868),(12814,869),(12815,869),(12816,869),(12817,869),(12818,869),(12819,869),(12820,869),(12821,870),(12822,870),(12823,870),(12824,870),(12825,870),(12826,870),(12827,870),(12828,871),(12829,871),(12830,871),(12831,871),(12832,871),(12833,871),(12834,871),(12835,872),(12836,872),(12837,872),(12838,872),(12839,872),(12840,872),(12841,872),(12842,873),(12843,873),(12844,873),(12845,873),(12846,873),(12847,873),(12848,873),(12849,874),(12850,874),(12851,874),(12852,874),(12853,874),(12854,874),(12855,874),(12856,875),(12857,875),(12858,875),(12859,875),(12860,875),(12861,875),(12862,875),(12863,876),(12864,876),(12865,876),(12866,876),(12867,876),(12868,876),(12869,876),(12870,877),(12871,877),(12872,877),(12873,877),(12874,877),(12875,877),(12876,877),(12877,878),(12878,878),(12879,878),(12880,878),(12881,878),(12882,878),(12883,878),(12884,879),(12885,879),(12886,879),(12887,879),(12888,879),(12889,879),(12890,879),(12891,880),(12892,880),(12893,880),(12894,880),(12895,880),(12896,880),(12897,880),(12898,881),(12899,881),(12900,881),(12901,881),(12902,881),(12903,881),(12904,881),(12905,882),(12906,882),(12907,882),(12908,882),(12909,882),(12910,882),(12911,882),(12912,883),(12913,883),(12914,883),(12915,883),(12916,883),(12917,883),(12918,883),(12919,884),(12920,884),(12921,884),(12922,884),(12923,884),(12924,884),(12925,884),(12926,885),(12927,885),(12928,885),(12929,885),(12930,885),(12931,885),(12932,885),(12933,886),(12934,886),(12935,886),(12936,886),(12937,886),(12938,886),(12939,886),(12940,887),(12941,887),(12942,887),(12943,887),(12944,887),(12945,887),(12946,887),(12947,888),(12948,888),(12949,888),(12950,888),(12951,888),(12952,888),(12953,888),(12954,889),(12955,889),(12956,889),(12957,889),(12958,889),(12959,889),(12960,889),(12961,890),(12962,890),(12963,890),(12964,890),(12965,890),(12966,890),(12967,890),(12968,891),(12969,891),(12970,891),(12971,891),(12972,891),(12973,891),(12974,891),(12975,892),(12976,892),(12977,892),(12978,892),(12979,892),(12980,892),(12981,892),(12982,893),(12983,893),(12984,893),(12985,893),(12986,893),(12987,893),(12988,893),(12989,894),(12990,894),(12991,894),(12992,894),(12993,894),(12994,894),(12995,894),(12996,895),(12997,895),(12998,895),(12999,895),(13000,895),(13001,895),(13002,895),(13003,896),(13004,896),(13005,896),(13006,896),(13007,896),(13008,896),(13009,896),(13010,897),(13011,897),(13012,897),(13013,897),(13014,897),(13015,897),(13016,897),(13017,898),(13018,898),(13019,898),(13020,898),(13021,898),(13022,898),(13023,898),(13024,899),(13025,899),(13026,899),(13027,899),(13028,899),(13029,899),(13030,899),(13031,900),(13032,900),(13033,900),(13034,900),(13035,900),(13036,900),(13037,900),(13038,901),(13039,901),(13040,901),(13041,901),(13042,901),(13043,901),(13044,901),(13045,902),(13046,902),(13047,902),(13048,902),(13049,902),(13050,902),(13051,902),(13052,903),(13053,903),(13054,903),(13055,903),(13056,903),(13057,903),(13058,903),(13059,904),(13060,904),(13061,904),(13062,904),(13063,904),(13064,904),(13065,904),(13066,905),(13067,905),(13068,905),(13069,905),(13070,905),(13071,905),(13072,905),(13073,906),(13074,906),(13075,906),(13076,906),(13077,906),(13078,906),(13079,906),(13080,907),(13081,907),(13082,907),(13083,907),(13084,907),(13085,907),(13086,907),(13087,908),(13088,908),(13089,908),(13090,908),(13091,908),(13092,908),(13093,908),(13094,909),(13095,909),(13096,909),(13097,909),(13098,909),(13099,909),(13100,909),(13101,910),(13102,910),(13103,910),(13104,910),(13105,910),(13106,910),(13107,910),(13108,911),(13109,911),(13110,911),(13111,911),(13112,911),(13113,911),(13114,911),(13115,912),(13116,912),(13117,912),(13118,912),(13119,912),(13120,912),(13121,912),(13122,913),(13123,913),(13124,913),(13125,913),(13126,913),(13127,913),(13128,913),(13129,914),(13130,914),(13131,914),(13132,914),(13133,914),(13134,914),(13135,914),(13136,915),(13137,915),(13138,915),(13139,915),(13140,915),(13141,915),(13142,915),(13143,916),(13144,916),(13145,916),(13146,916),(13147,916),(13148,916),(13149,916),(13150,917),(13151,917),(13152,917),(13153,917),(13154,917),(13155,917),(13156,917),(13157,918),(13158,918),(13159,918),(13160,918),(13161,918),(13162,918),(13163,918),(13164,919),(13165,919),(13166,919),(13167,919),(13168,919),(13169,919),(13170,919),(13171,920),(13172,920),(13173,920),(13174,920),(13175,920),(13176,920),(13177,920),(13178,921),(13179,921),(13180,921),(13181,921),(13182,921),(13183,921),(13184,921),(13185,922),(13186,922),(13187,922),(13188,922),(13189,922),(13190,922),(13191,922),(13192,923),(13193,923),(13194,923),(13195,923),(13196,923),(13197,923),(13198,923),(13199,924),(13200,924),(13201,924),(13202,924),(13203,924),(13204,924),(13205,924),(13206,925),(13207,925),(13208,925),(13209,925),(13210,925),(13211,925),(13212,925),(13213,926),(13214,926),(13215,926),(13216,926),(13217,926),(13218,926),(13219,926),(13220,927),(13221,927),(13222,927),(13223,927),(13224,927),(13225,927),(13226,927),(13227,928),(13228,928),(13229,928),(13230,928),(13231,928),(13232,928),(13233,928),(13234,929),(13235,929),(13236,929),(13237,929),(13238,929),(13239,929),(13240,929),(13241,930),(13242,930),(13243,930),(13244,930),(13245,930),(13246,930),(13247,930),(13248,931),(13249,931),(13250,931),(13251,931),(13252,931),(13253,931),(13254,931),(13255,932),(13256,932),(13257,932),(13258,932),(13259,932),(13260,932),(13261,932),(13262,933),(13263,933),(13264,933),(13265,933),(13266,933),(13267,933),(13268,933),(13269,934),(13270,934),(13271,934),(13272,934),(13273,934),(13274,934),(13275,934),(13276,935),(13277,935),(13278,935),(13279,935),(13280,935),(13281,935),(13282,935),(13283,936),(13284,936),(13285,936),(13286,936),(13287,936),(13288,936),(13289,936),(13290,937),(13291,937),(13292,937),(13293,937),(13294,937),(13295,937),(13296,937),(13297,938),(13298,938),(13299,938),(13300,938),(13301,938),(13302,938),(13303,938),(13304,939),(13305,939),(13306,939),(13307,939),(13308,939),(13309,939),(13310,939),(13311,940),(13312,940),(13313,940),(13314,940),(13315,940),(13316,940),(13317,940),(13318,941),(13319,941),(13320,941),(13321,941),(13322,941),(13323,941),(13324,941),(13325,942),(13326,942),(13327,942),(13328,942),(13329,942),(13330,942),(13331,942),(13332,943),(13333,943),(13334,943),(13335,943),(13336,943),(13337,943),(13338,943),(13339,944),(13340,944),(13341,944),(13342,944),(13343,944),(13344,944),(13345,944),(13346,945),(13347,945),(13348,945),(13349,945),(13350,945),(13351,945),(13352,945),(13353,946),(13354,946),(13355,946),(13356,946),(13357,946),(13358,946),(13359,946),(13360,847),(13361,847),(13362,847),(13363,847),(13364,847),(13365,847),(13366,848),(13367,848),(13368,848),(13369,848),(13370,848),(13371,848),(13372,849),(13373,849),(13374,849),(13375,849),(13376,849),(13377,849),(13378,850),(13379,850),(13380,850),(13381,850),(13382,850),(13383,850),(13384,851),(13385,851),(13386,851),(13387,851),(13388,851),(13389,851),(13390,852),(13391,852),(13392,852),(13393,852),(13394,852),(13395,852),(13396,853),(13397,853),(13398,853),(13399,853),(13400,853),(13401,853),(13402,854),(13403,854),(13404,854),(13405,854),(13406,854),(13407,854),(13408,854),(13409,854),(13410,854),(13411,855),(13412,855),(13413,855),(13414,855),(13415,855),(13416,855),(13417,856),(13418,856),(13419,856),(13420,856),(13421,856),(13422,856),(13423,857),(13424,857),(13425,857),(13426,857),(13427,857),(13428,857),(13429,858),(13430,858),(13431,858),(13432,858),(13433,858),(13434,858),(13435,859),(13436,859),(13437,859),(13438,859),(13439,859),(13440,859),(13441,860),(13442,860),(13443,860),(13444,860),(13445,860),(13446,860),(13447,861),(13448,861),(13449,861),(13450,861),(13451,861),(13452,861),(13453,862),(13454,862),(13455,862),(13456,862),(13457,862),(13458,862),(13459,863),(13460,863),(13461,863),(13462,863),(13463,863),(13464,863),(13465,864),(13466,864),(13467,864),(13468,864),(13469,864),(13470,864),(13471,865),(13472,865),(13473,865),(13474,865),(13475,865),(13476,865),(13477,866),(13478,866),(13479,866),(13480,866),(13481,866),(13482,866),(13483,867),(13484,867),(13485,867),(13486,867),(13487,867),(13488,867),(13489,867),(13490,867),(13491,867),(13492,868),(13493,868),(13494,868),(13495,868),(13496,868),(13497,868),(13498,869),(13499,869),(13500,869),(13501,869),(13502,869),(13503,869),(13504,870),(13505,870),(13506,870),(13507,870),(13508,870),(13509,870),(13510,871),(13511,871),(13512,871),(13513,871),(13514,871),(13515,871),(13516,872),(13517,872),(13518,872),(13519,872),(13520,872),(13521,872),(13522,873),(13523,873),(13524,873),(13525,873),(13526,873),(13527,873),(13528,874),(13529,874),(13530,874),(13531,874),(13532,874),(13533,874),(13534,875),(13535,875),(13536,875),(13537,875),(13538,875),(13539,875),(13540,876),(13541,876),(13542,876),(13543,876),(13544,876),(13545,876),(13546,877),(13547,877),(13548,877),(13549,877),(13550,877),(13551,877),(13552,878),(13553,878),(13554,878),(13555,878),(13556,878),(13557,878),(13558,879),(13559,879),(13560,879),(13561,879),(13562,879),(13563,879),(13564,880),(13565,880),(13566,880),(13567,880),(13568,880),(13569,880),(13570,880),(13571,880),(13572,880),(13573,881),(13574,881),(13575,881),(13576,881),(13577,881),(13578,881),(13579,882),(13580,882),(13581,882),(13582,882),(13583,882),(13584,882),(13585,883),(13586,883),(13587,883),(13588,883),(13589,883),(13590,883),(13591,884),(13592,884),(13593,884),(13594,884),(13595,884),(13596,884),(13597,885),(13598,885),(13599,885),(13600,885),(13601,885),(13602,885),(13603,886),(13604,886),(13605,886),(13606,886),(13607,886),(13608,886),(13609,887),(13610,887),(13611,887),(13612,887),(13613,887),(13614,887),(13615,888),(13616,888),(13617,888),(13618,888),(13619,888),(13620,888),(13621,889),(13622,889),(13623,889),(13624,889),(13625,889),(13626,889),(13627,890),(13628,890),(13629,890),(13630,890),(13631,890),(13632,890),(13633,891),(13634,891),(13635,891),(13636,891),(13637,891),(13638,891),(13639,892),(13640,892),(13641,892),(13642,892),(13643,892),(13644,892),(13645,893),(13646,893),(13647,893),(13648,893),(13649,893),(13650,893),(13651,893),(13652,893),(13653,893),(13654,894),(13655,894),(13656,894),(13657,894),(13658,894),(13659,894),(13660,895),(13661,895),(13662,895),(13663,895),(13664,895),(13665,895),(13666,896),(13667,896),(13668,896),(13669,896),(13670,896),(13671,896),(13672,897),(13673,897),(13674,897),(13675,897),(13676,897),(13677,897),(13678,898),(13679,898),(13680,898),(13681,898),(13682,898),(13683,898),(13684,898),(13685,898),(13686,898),(13687,899),(13688,899),(13689,899),(13690,899),(13691,899),(13692,899),(13693,900),(13694,900),(13695,900),(13696,900),(13697,900),(13698,900),(13699,901),(13700,901),(13701,901),(13702,901),(13703,901),(13704,901),(13705,902),(13706,902),(13707,902),(13708,902),(13709,902),(13710,902),(13711,903),(13712,903),(13713,903),(13714,903),(13715,903),(13716,903),(13717,904),(13718,904),(13719,904),(13720,904),(13721,904),(13722,904),(13723,905),(13724,905),(13725,905),(13726,905),(13727,905),(13728,905),(13729,906),(13730,906),(13731,906),(13732,906),(13733,906),(13734,906),(13735,907),(13736,907),(13737,907),(13738,907),(13739,907),(13740,907),(13741,908),(13742,908),(13743,908),(13744,908),(13745,908),(13746,908),(13747,909),(13748,909),(13749,909),(13750,909),(13751,909),(13752,909),(13753,910),(13754,910),(13755,910),(13756,910),(13757,910),(13758,910),(13759,911),(13760,911),(13761,911),(13762,911),(13763,911),(13764,911),(13765,911),(13766,911),(13767,911),(13768,912),(13769,912),(13770,912),(13771,912),(13772,912),(13773,912),(13774,913),(13775,913),(13776,913),(13777,913),(13778,913),(13779,913),(13780,914),(13781,914),(13782,914),(13783,914),(13784,914),(13785,914),(13786,915),(13787,915),(13788,915),(13789,915),(13790,915),(13791,915),(13792,916),(13793,916),(13794,916),(13795,916),(13796,916),(13797,916),(13798,917),(13799,917),(13800,917),(13801,917),(13802,917),(13803,917),(13804,918),(13805,918),(13806,918),(13807,918),(13808,918),(13809,918),(13810,919),(13811,919),(13812,919),(13813,919),(13814,919),(13815,919),(13816,920),(13817,920),(13818,920),(13819,920),(13820,920),(13821,920),(13822,921),(13823,921),(13824,921),(13825,921),(13826,921),(13827,921),(13828,922),(13829,922),(13830,922),(13831,922),(13832,922),(13833,922),(13834,923),(13835,923),(13836,923),(13837,923),(13838,923),(13839,923),(13840,924),(13841,924),(13842,924),(13843,924),(13844,924),(13845,924),(13846,924),(13847,924),(13848,924),(13849,925),(13850,925),(13851,925),(13852,925),(13853,925),(13854,925),(13855,926),(13856,926),(13857,926),(13858,926),(13859,926),(13860,926),(13861,927),(13862,927),(13863,927),(13864,927),(13865,927),(13866,927),(13867,928),(13868,928),(13869,928),(13870,928),(13871,928),(13872,928),(13873,929),(13874,929),(13875,929),(13876,929),(13877,929),(13878,929),(13879,930),(13880,930),(13881,930),(13882,930),(13883,930),(13884,930),(13885,931),(13886,931),(13887,931),(13888,931),(13889,931),(13890,931),(13891,932),(13892,932),(13893,932),(13894,932),(13895,932),(13896,932),(13897,933),(13898,933),(13899,933),(13900,933),(13901,933),(13902,933),(13903,934),(13904,934),(13905,934),(13906,934),(13907,934),(13908,934),(13909,935),(13910,935),(13911,935),(13912,935),(13913,935),(13914,935),(13915,936),(13916,936),(13917,936),(13918,936),(13919,936),(13920,936),(13921,937),(13922,937),(13923,937),(13924,937),(13925,937),(13926,937),(13927,937),(13928,937),(13929,937),(13930,938),(13931,938),(13932,938),(13933,938),(13934,938),(13935,938),(13936,939),(13937,939),(13938,939),(13939,939),(13940,939),(13941,939),(13942,940),(13943,940),(13944,940),(13945,940),(13946,940),(13947,940),(13948,941),(13949,941),(13950,941),(13951,941),(13952,941),(13953,941),(13954,942),(13955,942),(13956,942),(13957,942),(13958,942),(13959,942),(13960,943),(13961,943),(13962,943),(13963,943),(13964,943),(13965,943),(13966,944),(13967,944),(13968,944),(13969,944),(13970,944),(13971,944),(13972,945),(13973,945),(13974,945),(13975,945),(13976,945),(13977,945),(13978,946),(13979,946),(13980,946),(13981,946),(13982,946),(13983,946),(13984,847),(13985,847),(13986,848),(13987,848),(13988,849),(13989,849),(13990,850),(13991,850),(13992,851),(13993,851),(13994,852),(13995,852),(13996,853),(13997,853),(13998,854),(13999,855),(14000,855),(14001,856),(14002,856),(14003,857),(14004,857),(14005,858),(14006,858),(14007,859),(14008,859),(14009,860),(14010,860),(14011,861),(14012,861),(14013,862),(14014,862),(14015,863),(14016,863),(14017,864),(14018,864),(14019,865),(14020,865),(14021,866),(14022,866),(14023,867),(14024,868),(14025,868),(14026,869),(14027,869),(14028,870),(14029,870),(14030,871),(14031,871),(14032,872),(14033,872),(14034,873),(14035,873),(14036,874),(14037,874),(14038,875),(14039,875),(14040,876),(14041,876),(14042,877),(14043,877),(14044,878),(14045,878),(14046,879),(14047,879),(14048,880),(14049,881),(14050,881),(14051,882),(14052,882),(14053,883),(14054,883),(14055,884),(14056,884),(14057,885),(14058,885),(14059,886),(14060,886),(14061,887),(14062,887),(14063,888),(14064,888),(14065,889),(14066,889),(14067,890),(14068,890),(14069,891),(14070,891),(14071,892),(14072,892),(14073,893),(14074,894),(14075,894),(14076,895),(14077,895),(14078,896),(14079,896),(14080,897),(14081,897),(14082,898),(14083,899),(14084,899),(14085,900),(14086,900),(14087,901),(14088,901),(14089,902),(14090,902),(14091,903),(14092,903),(14093,904),(14094,904),(14095,905),(14096,905),(14097,906),(14098,906),(14099,907),(14100,907),(14101,908),(14102,908),(14103,909),(14104,909),(14105,910),(14106,910),(14107,911),(14108,912),(14109,912),(14110,913),(14111,913),(14112,914),(14113,914),(14114,915),(14115,915),(14116,916),(14117,916),(14118,917),(14119,917),(14120,918),(14121,918),(14122,919),(14123,919),(14124,920),(14125,920),(14126,921),(14127,921),(14128,922),(14129,922),(14130,923),(14131,923),(14132,924),(14133,925),(14134,925),(14135,926),(14136,926),(14137,927),(14138,927),(14139,928),(14140,928),(14141,929),(14142,929),(14143,930),(14144,930),(14145,931),(14146,931),(14147,932),(14148,932),(14149,933),(14150,933),(14151,934),(14152,934),(14153,935),(14154,935),(14155,936),(14156,936),(14157,937),(14158,938),(14159,938),(14160,939),(14161,939),(14162,940),(14163,940),(14164,941),(14165,941),(14166,942),(14167,942),(14168,943),(14169,943),(14170,944),(14171,944),(14172,945),(14173,945),(14174,946),(14175,946),(14176,947),(14177,947),(14178,947),(14179,947),(14180,947),(14181,947),(14182,947),(14183,948),(14184,948),(14185,948),(14186,948),(14187,948),(14188,948),(14189,948),(14190,949),(14191,949),(14192,949),(14193,949),(14194,949),(14195,949),(14196,949),(14197,950),(14198,950),(14199,950),(14200,950),(14201,950),(14202,950),(14203,950),(14204,951),(14205,951),(14206,951),(14207,951),(14208,951),(14209,951),(14210,951),(14211,952),(14212,952),(14213,952),(14214,952),(14215,952),(14216,952),(14217,952),(14218,953),(14219,953),(14220,953),(14221,953),(14222,953),(14223,953),(14224,953),(14225,954),(14226,954),(14227,954),(14228,954),(14229,954),(14230,954),(14231,954),(14232,955),(14233,955),(14234,955),(14235,955),(14236,955),(14237,955),(14238,955),(14239,956),(14240,956),(14241,956),(14242,956),(14243,956),(14244,956),(14245,956),(14246,957),(14247,957),(14248,957),(14249,957),(14250,957),(14251,957),(14252,957),(14253,958),(14254,958),(14255,958),(14256,958),(14257,958),(14258,958),(14259,958),(14260,959),(14261,959),(14262,959),(14263,959),(14264,959),(14265,959),(14266,959),(14267,960),(14268,960),(14269,960),(14270,960),(14271,960),(14272,960),(14273,960),(14274,961),(14275,961),(14276,961),(14277,961),(14278,961),(14279,961),(14280,961),(14281,962),(14282,962),(14283,962),(14284,962),(14285,962),(14286,962),(14287,962),(14288,963),(14289,963),(14290,963),(14291,963),(14292,963),(14293,963),(14294,963),(14295,964),(14296,964),(14297,964),(14298,964),(14299,964),(14300,964),(14301,964),(14302,965),(14303,965),(14304,965),(14305,965),(14306,965),(14307,965),(14308,965),(14309,966),(14310,966),(14311,966),(14312,966),(14313,966),(14314,966),(14315,966),(14316,967),(14317,967),(14318,967),(14319,967),(14320,967),(14321,967),(14322,967),(14323,968),(14324,968),(14325,968),(14326,968),(14327,968),(14328,968),(14329,968),(14330,969),(14331,969),(14332,969),(14333,969),(14334,969),(14335,969),(14336,969),(14337,970),(14338,970),(14339,970),(14340,970),(14341,970),(14342,970),(14343,970),(14344,971),(14345,971),(14346,971),(14347,971),(14348,971),(14349,971),(14350,971),(14351,972),(14352,972),(14353,972),(14354,972),(14355,972),(14356,972),(14357,972),(14358,973),(14359,973),(14360,973),(14361,973),(14362,973),(14363,973),(14364,973),(14365,974),(14366,974),(14367,974),(14368,974),(14369,974),(14370,974),(14371,974),(14372,975),(14373,975),(14374,975),(14375,975),(14376,975),(14377,975),(14378,975),(14379,976),(14380,976),(14381,976),(14382,976),(14383,976),(14384,976),(14385,976),(14386,977),(14387,977),(14388,977),(14389,977),(14390,977),(14391,977),(14392,977),(14393,978),(14394,978),(14395,978),(14396,978),(14397,978),(14398,978),(14399,978),(14400,979),(14401,979),(14402,979),(14403,979),(14404,979),(14405,979),(14406,979),(14407,980),(14408,980),(14409,980),(14410,980),(14411,980),(14412,980),(14413,980),(14414,981),(14415,981),(14416,981),(14417,981),(14418,981),(14419,981),(14420,981),(14421,982),(14422,982),(14423,982),(14424,982),(14425,982),(14426,982),(14427,982),(14428,983),(14429,983),(14430,983),(14431,983),(14432,983),(14433,983),(14434,983),(14435,984),(14436,984),(14437,984),(14438,984),(14439,984),(14440,984),(14441,984),(14442,985),(14443,985),(14444,985),(14445,985),(14446,985),(14447,985),(14448,985),(14449,986),(14450,986),(14451,986),(14452,986),(14453,986),(14454,986),(14455,986),(14456,987),(14457,987),(14458,987),(14459,987),(14460,987),(14461,987),(14462,987),(14463,988),(14464,988),(14465,988),(14466,988),(14467,988),(14468,988),(14469,988),(14470,989),(14471,989),(14472,989),(14473,989),(14474,989),(14475,989),(14476,989),(14477,990),(14478,990),(14479,990),(14480,990),(14481,990),(14482,990),(14483,990),(14484,991),(14485,991),(14486,991),(14487,991),(14488,991),(14489,991),(14490,991),(14491,992),(14492,992),(14493,992),(14494,992),(14495,992),(14496,992),(14497,992),(14498,993),(14499,993),(14500,993),(14501,993),(14502,993),(14503,993),(14504,993),(14505,994),(14506,994),(14507,994),(14508,994),(14509,994),(14510,994),(14511,994),(14512,995),(14513,995),(14514,995),(14515,995),(14516,995),(14517,995),(14518,995),(14519,996),(14520,996),(14521,996),(14522,996),(14523,996),(14524,996),(14525,996),(14526,997),(14527,997),(14528,997),(14529,997),(14530,997),(14531,997),(14532,997),(14533,998),(14534,998),(14535,998),(14536,998),(14537,998),(14538,998),(14539,998),(14540,999),(14541,999),(14542,999),(14543,999),(14544,999),(14545,999),(14546,999),(14547,1000),(14548,1000),(14549,1000),(14550,1000),(14551,1000),(14552,1000),(14553,1000),(14554,1001),(14555,1001),(14556,1001),(14557,1001),(14558,1001),(14559,1001),(14560,1001),(14561,1002),(14562,1002),(14563,1002),(14564,1002),(14565,1002),(14566,1002),(14567,1002),(14568,1003),(14569,1003),(14570,1003),(14571,1003),(14572,1003),(14573,1003),(14574,1003),(14575,1004),(14576,1004),(14577,1004),(14578,1004),(14579,1004),(14580,1004),(14581,1004),(14582,1005),(14583,1005),(14584,1005),(14585,1005),(14586,1005),(14587,1005),(14588,1005),(14589,1006),(14590,1006),(14591,1006),(14592,1006),(14593,1006),(14594,1006),(14595,1006),(14596,1007),(14597,1007),(14598,1007),(14599,1007),(14600,1007),(14601,1007),(14602,1007),(14603,1008),(14604,1008),(14605,1008),(14606,1008),(14607,1008),(14608,1008),(14609,1008),(14610,1009),(14611,1009),(14612,1009),(14613,1009),(14614,1009),(14615,1009),(14616,1009),(14617,1010),(14618,1010),(14619,1010),(14620,1010),(14621,1010),(14622,1010),(14623,1010),(14624,1011),(14625,1011),(14626,1011),(14627,1011),(14628,1011),(14629,1011),(14630,1011),(14631,1012),(14632,1012),(14633,1012),(14634,1012),(14635,1012),(14636,1012),(14637,1012),(14638,1013),(14639,1013),(14640,1013),(14641,1013),(14642,1013),(14643,1013),(14644,1013),(14645,1014),(14646,1014),(14647,1014),(14648,1014),(14649,1014),(14650,1014),(14651,1014),(14652,1015),(14653,1015),(14654,1015),(14655,1015),(14656,1015),(14657,1015),(14658,1015),(14659,1016),(14660,1016),(14661,1016),(14662,1016),(14663,1016),(14664,1016),(14665,1016),(14666,1017),(14667,1017),(14668,1017),(14669,1017),(14670,1017),(14671,1017),(14672,1017),(14673,1018),(14674,1018),(14675,1018),(14676,1018),(14677,1018),(14678,1018),(14679,1018),(14680,1019),(14681,1019),(14682,1019),(14683,1019),(14684,1019),(14685,1019),(14686,1019),(14687,1020),(14688,1020),(14689,1020),(14690,1020),(14691,1020),(14692,1020),(14693,1020),(14694,1021),(14695,1021),(14696,1021),(14697,1021),(14698,1021),(14699,1021),(14700,1021),(14701,1022),(14702,1022),(14703,1022),(14704,1022),(14705,1022),(14706,1022),(14707,1022),(14708,1023),(14709,1023),(14710,1023),(14711,1023),(14712,1023),(14713,1023),(14714,1023),(14715,1024),(14716,1024),(14717,1024),(14718,1024),(14719,1024),(14720,1024),(14721,1024),(14722,1025),(14723,1025),(14724,1025),(14725,1025),(14726,1025),(14727,1025),(14728,1025),(14729,1026),(14730,1026),(14731,1026),(14732,1026),(14733,1026),(14734,1026),(14735,1026),(14736,1027),(14737,1027),(14738,1027),(14739,1027),(14740,1027),(14741,1027),(14742,1027),(14743,1028),(14744,1028),(14745,1028),(14746,1028),(14747,1028),(14748,1028),(14749,1028),(14750,1029),(14751,1029),(14752,1029),(14753,1029),(14754,1029),(14755,1029),(14756,1029),(14757,1030),(14758,1030),(14759,1030),(14760,1030),(14761,1030),(14762,1030),(14763,1030),(14764,1031),(14765,1031),(14766,1031),(14767,1031),(14768,1031),(14769,1031),(14770,1031),(14771,1032),(14772,1032),(14773,1032),(14774,1032),(14775,1032),(14776,1032),(14777,1032),(14778,1033),(14779,1033),(14780,1033),(14781,1033),(14782,1033),(14783,1033),(14784,1033),(14785,1034),(14786,1034),(14787,1034),(14788,1034),(14789,1034),(14790,1034),(14791,1034),(14792,1035),(14793,1035),(14794,1035),(14795,1035),(14796,1035),(14797,1035),(14798,1035),(14799,1036),(14800,1036),(14801,1036),(14802,1036),(14803,1036),(14804,1036),(14805,1036),(14806,1037),(14807,1037),(14808,1037),(14809,1037),(14810,1037),(14811,1037),(14812,1037),(14813,1038),(14814,1038),(14815,1038),(14816,1038),(14817,1038),(14818,1038),(14819,1038),(14820,1039),(14821,1039),(14822,1039),(14823,1039),(14824,1039),(14825,1039),(14826,1039),(14827,1040),(14828,1040),(14829,1040),(14830,1040),(14831,1040),(14832,1040),(14833,1040),(14834,1041),(14835,1041),(14836,1041),(14837,1041),(14838,1041),(14839,1041),(14840,1041),(14841,1042),(14842,1042),(14843,1042),(14844,1042),(14845,1042),(14846,1042),(14847,1042),(14848,1043),(14849,1043),(14850,1043),(14851,1043),(14852,1043),(14853,1043),(14854,1043),(14855,1044),(14856,1044),(14857,1044),(14858,1044),(14859,1044),(14860,1044),(14861,1044),(14862,1045),(14863,1045),(14864,1045),(14865,1045),(14866,1045),(14867,1045),(14868,1045),(14869,1046),(14870,1046),(14871,1046),(14872,1046),(14873,1046),(14874,1046),(14875,1046),(14876,947),(14877,947),(14878,947),(14879,947),(14880,947),(14881,947),(14882,948),(14883,948),(14884,948),(14885,948),(14886,948),(14887,948),(14888,949),(14889,949),(14890,949),(14891,949),(14892,949),(14893,949),(14894,950),(14895,950),(14896,950),(14897,950),(14898,950),(14899,950),(14900,950),(14901,950),(14902,950),(14903,951),(14904,951),(14905,951),(14906,951),(14907,951),(14908,951),(14909,952),(14910,952),(14911,952),(14912,952),(14913,952),(14914,952),(14915,953),(14916,953),(14917,953),(14918,953),(14919,953),(14920,953),(14921,954),(14922,954),(14923,954),(14924,954),(14925,954),(14926,954),(14927,955),(14928,955),(14929,955),(14930,955),(14931,955),(14932,955),(14933,956),(14934,956),(14935,956),(14936,956),(14937,956),(14938,956),(14939,957),(14940,957),(14941,957),(14942,957),(14943,957),(14944,957),(14945,958),(14946,958),(14947,958),(14948,958),(14949,958),(14950,958),(14951,959),(14952,959),(14953,959),(14954,959),(14955,959),(14956,959),(14957,960),(14958,960),(14959,960),(14960,960),(14961,960),(14962,960),(14963,961),(14964,961),(14965,961),(14966,961),(14967,961),(14968,961),(14969,962),(14970,962),(14971,962),(14972,962),(14973,962),(14974,962),(14975,963),(14976,963),(14977,963),(14978,963),(14979,963),(14980,963),(14981,963),(14982,963),(14983,963),(14984,964),(14985,964),(14986,964),(14987,964),(14988,964),(14989,964),(14990,965),(14991,965),(14992,965),(14993,965),(14994,965),(14995,965),(14996,966),(14997,966),(14998,966),(14999,966),(15000,966),(15001,966),(15002,967),(15003,967),(15004,967),(15005,967),(15006,967),(15007,967),(15008,968),(15009,968),(15010,968),(15011,968),(15012,968),(15013,968),(15014,969),(15015,969),(15016,969),(15017,969),(15018,969),(15019,969),(15020,970),(15021,970),(15022,970),(15023,970),(15024,970),(15025,970),(15026,971),(15027,971),(15028,971),(15029,971),(15030,971),(15031,971),(15032,972),(15033,972),(15034,972),(15035,972),(15036,972),(15037,972),(15038,973),(15039,973),(15040,973),(15041,973),(15042,973),(15043,973),(15044,974),(15045,974),(15046,974),(15047,974),(15048,974),(15049,974),(15050,975),(15051,975),(15052,975),(15053,975),(15054,975),(15055,975),(15056,976),(15057,976),(15058,976),(15059,976),(15060,976),(15061,976),(15062,976),(15063,976),(15064,976),(15065,977),(15066,977),(15067,977),(15068,977),(15069,977),(15070,977),(15071,978),(15072,978),(15073,978),(15074,978),(15075,978),(15076,978),(15077,979),(15078,979),(15079,979),(15080,979),(15081,979),(15082,979),(15083,980),(15084,980),(15085,980),(15086,980),(15087,980),(15088,980),(15089,981),(15090,981),(15091,981),(15092,981),(15093,981),(15094,981),(15095,982),(15096,982),(15097,982),(15098,982),(15099,982),(15100,982),(15101,983),(15102,983),(15103,983),(15104,983),(15105,983),(15106,983),(15107,984),(15108,984),(15109,984),(15110,984),(15111,984),(15112,984),(15113,985),(15114,985),(15115,985),(15116,985),(15117,985),(15118,985),(15119,986),(15120,986),(15121,986),(15122,986),(15123,986),(15124,986),(15125,987),(15126,987),(15127,987),(15128,987),(15129,987),(15130,987),(15131,988),(15132,988),(15133,988),(15134,988),(15135,988),(15136,988),(15137,989),(15138,989),(15139,989),(15140,989),(15141,989),(15142,989),(15143,989),(15144,989),(15145,989),(15146,990),(15147,990),(15148,990),(15149,990),(15150,990),(15151,990),(15152,991),(15153,991),(15154,991),(15155,991),(15156,991),(15157,991),(15158,992),(15159,992),(15160,992),(15161,992),(15162,992),(15163,992),(15164,993),(15165,993),(15166,993),(15167,993),(15168,993),(15169,993),(15170,994),(15171,994),(15172,994),(15173,994),(15174,994),(15175,994),(15176,995),(15177,995),(15178,995),(15179,995),(15180,995),(15181,995),(15182,996),(15183,996),(15184,996),(15185,996),(15186,996),(15187,996),(15188,997),(15189,997),(15190,997),(15191,997),(15192,997),(15193,997),(15194,998),(15195,998),(15196,998),(15197,998),(15198,998),(15199,998),(15200,999),(15201,999),(15202,999),(15203,999),(15204,999),(15205,999),(15206,1000),(15207,1000),(15208,1000),(15209,1000),(15210,1000),(15211,1000),(15212,1001),(15213,1001),(15214,1001),(15215,1001),(15216,1001),(15217,1001),(15218,1002),(15219,1002),(15220,1002),(15221,1002),(15222,1002),(15223,1002),(15224,1002),(15225,1002),(15226,1002),(15227,1003),(15228,1003),(15229,1003),(15230,1003),(15231,1003),(15232,1003),(15233,1004),(15234,1004),(15235,1004),(15236,1004),(15237,1004),(15238,1004),(15239,1005),(15240,1005),(15241,1005),(15242,1005),(15243,1005),(15244,1005),(15245,1006),(15246,1006),(15247,1006),(15248,1006),(15249,1006),(15250,1006),(15251,1007),(15252,1007),(15253,1007),(15254,1007),(15255,1007),(15256,1007),(15257,1008),(15258,1008),(15259,1008),(15260,1008),(15261,1008),(15262,1008),(15263,1009),(15264,1009),(15265,1009),(15266,1009),(15267,1009),(15268,1009),(15269,1010),(15270,1010),(15271,1010),(15272,1010),(15273,1010),(15274,1010),(15275,1011),(15276,1011),(15277,1011),(15278,1011),(15279,1011),(15280,1011),(15281,1012),(15282,1012),(15283,1012),(15284,1012),(15285,1012),(15286,1012),(15287,1013),(15288,1013),(15289,1013),(15290,1013),(15291,1013),(15292,1013),(15293,1014),(15294,1014),(15295,1014),(15296,1014),(15297,1014),(15298,1014),(15299,1015),(15300,1015),(15301,1015),(15302,1015),(15303,1015),(15304,1015),(15305,1015),(15306,1015),(15307,1015),(15308,1016),(15309,1016),(15310,1016),(15311,1016),(15312,1016),(15313,1016),(15314,1017),(15315,1017),(15316,1017),(15317,1017),(15318,1017),(15319,1017),(15320,1018),(15321,1018),(15322,1018),(15323,1018),(15324,1018),(15325,1018),(15326,1019),(15327,1019),(15328,1019),(15329,1019),(15330,1019),(15331,1019),(15332,1020),(15333,1020),(15334,1020),(15335,1020),(15336,1020),(15337,1020),(15338,1021),(15339,1021),(15340,1021),(15341,1021),(15342,1021),(15343,1021),(15344,1022),(15345,1022),(15346,1022),(15347,1022),(15348,1022),(15349,1022),(15350,1023),(15351,1023),(15352,1023),(15353,1023),(15354,1023),(15355,1023),(15356,1024),(15357,1024),(15358,1024),(15359,1024),(15360,1024),(15361,1024),(15362,1025),(15363,1025),(15364,1025),(15365,1025),(15366,1025),(15367,1025),(15368,1026),(15369,1026),(15370,1026),(15371,1026),(15372,1026),(15373,1026),(15374,1027),(15375,1027),(15376,1027),(15377,1027),(15378,1027),(15379,1027),(15380,1028),(15381,1028),(15382,1028),(15383,1028),(15384,1028),(15385,1028),(15386,1028),(15387,1028),(15388,1028),(15389,1029),(15390,1029),(15391,1029),(15392,1029),(15393,1029),(15394,1029),(15395,1030),(15396,1030),(15397,1030),(15398,1030),(15399,1030),(15400,1030),(15401,1031),(15402,1031),(15403,1031),(15404,1031),(15405,1031),(15406,1031),(15407,1032),(15408,1032),(15409,1032),(15410,1032),(15411,1032),(15412,1032),(15413,1033),(15414,1033),(15415,1033),(15416,1033),(15417,1033),(15418,1033),(15419,1034),(15420,1034),(15421,1034),(15422,1034),(15423,1034),(15424,1034),(15425,1035),(15426,1035),(15427,1035),(15428,1035),(15429,1035),(15430,1035),(15431,1036),(15432,1036),(15433,1036),(15434,1036),(15435,1036),(15436,1036),(15437,1037),(15438,1037),(15439,1037),(15440,1037),(15441,1037),(15442,1037),(15443,1038),(15444,1038),(15445,1038),(15446,1038),(15447,1038),(15448,1038),(15449,1039),(15450,1039),(15451,1039),(15452,1039),(15453,1039),(15454,1039),(15455,1040),(15456,1040),(15457,1040),(15458,1040),(15459,1040),(15460,1040),(15461,1041),(15462,1041),(15463,1041),(15464,1041),(15465,1041),(15466,1041),(15467,1042),(15468,1042),(15469,1042),(15470,1042),(15471,1042),(15472,1042),(15473,1043),(15474,1043),(15475,1043),(15476,1043),(15477,1043),(15478,1043),(15479,1044),(15480,1044),(15481,1044),(15482,1044),(15483,1044),(15484,1044),(15485,1044),(15486,1044),(15487,1044),(15488,1045),(15489,1045),(15490,1045),(15491,1045),(15492,1045),(15493,1045),(15494,1046),(15495,1046),(15496,1046),(15497,1046),(15498,1046),(15499,1046),(15500,947),(15501,947),(15502,948),(15503,948),(15504,949),(15505,949),(15506,950),(15507,951),(15508,951),(15509,952),(15510,952),(15511,953),(15512,953),(15513,954),(15514,954),(15515,955),(15516,955),(15517,956),(15518,956),(15519,957),(15520,957),(15521,958),(15522,958),(15523,959),(15524,959),(15525,960),(15526,960),(15527,961),(15528,961),(15529,962),(15530,962),(15531,963),(15532,964),(15533,964),(15534,965),(15535,965),(15536,966),(15537,966),(15538,967),(15539,967),(15540,968),(15541,968),(15542,969),(15543,969),(15544,970),(15545,970),(15546,971),(15547,971),(15548,972),(15549,972),(15550,973),(15551,973),(15552,974),(15553,974),(15554,975),(15555,975),(15556,976),(15557,977),(15558,977),(15559,978),(15560,978),(15561,979),(15562,979),(15563,980),(15564,980),(15565,981),(15566,981),(15567,982),(15568,982),(15569,983),(15570,983),(15571,984),(15572,984),(15573,985),(15574,985),(15575,986),(15576,986),(15577,987),(15578,987),(15579,988),(15580,988),(15581,989),(15582,990),(15583,990),(15584,991),(15585,991),(15586,992),(15587,992),(15588,993),(15589,993),(15590,994),(15591,994),(15592,995),(15593,995),(15594,996),(15595,996),(15596,997),(15597,997),(15598,998),(15599,998),(15600,999),(15601,999),(15602,1000),(15603,1000),(15604,1001),(15605,1001),(15606,1002),(15607,1003),(15608,1003),(15609,1004),(15610,1004),(15611,1005),(15612,1005),(15613,1006),(15614,1006),(15615,1007),(15616,1007),(15617,1008),(15618,1008),(15619,1009),(15620,1009),(15621,1010),(15622,1010),(15623,1011),(15624,1011),(15625,1012),(15626,1012),(15627,1013),(15628,1013),(15629,1014),(15630,1014),(15631,1015),(15632,1016),(15633,1016),(15634,1017),(15635,1017),(15636,1018),(15637,1018),(15638,1019),(15639,1019),(15640,1020),(15641,1020),(15642,1021),(15643,1021),(15644,1022),(15645,1022),(15646,1023),(15647,1023),(15648,1024),(15649,1024),(15650,1025),(15651,1025),(15652,1026),(15653,1026),(15654,1027),(15655,1027),(15656,1028),(15657,1029),(15658,1029),(15659,1030),(15660,1030),(15661,1031),(15662,1031),(15663,1032),(15664,1032),(15665,1033),(15666,1033),(15667,1034),(15668,1034),(15669,1035),(15670,1035),(15671,1036),(15672,1036),(15673,1037),(15674,1037),(15675,1038),(15676,1038),(15677,1039),(15678,1039),(15679,1040),(15680,1040),(15681,1041),(15682,1041),(15683,1042),(15684,1042),(15685,1043),(15686,1043),(15687,1044),(15688,1045),(15689,1045),(15690,1046),(15691,1046),(15692,1047),(15693,1047),(15694,1047),(15695,1047),(15696,1047),(15697,1047),(15698,1047),(15699,1048),(15700,1048),(15701,1048),(15702,1048),(15703,1048),(15704,1048),(15705,1048),(15706,1049),(15707,1049),(15708,1049),(15709,1049),(15710,1049),(15711,1049),(15712,1049),(15713,1050),(15714,1050),(15715,1050),(15716,1050),(15717,1050),(15718,1050),(15719,1050),(15720,1051),(15721,1051),(15722,1051),(15723,1051),(15724,1051),(15725,1051),(15726,1051),(15727,1052),(15728,1052),(15729,1052),(15730,1052),(15731,1052),(15732,1052),(15733,1052),(15734,1053),(15735,1053),(15736,1053),(15737,1053),(15738,1053),(15739,1053),(15740,1053),(15741,1054),(15742,1054),(15743,1054),(15744,1054),(15745,1054),(15746,1054),(15747,1054),(15748,1055),(15749,1055),(15750,1055),(15751,1055),(15752,1055),(15753,1055),(15754,1055),(15755,1056),(15756,1056),(15757,1056),(15758,1056),(15759,1056),(15760,1056),(15761,1056),(15762,1057),(15763,1057),(15764,1057),(15765,1057),(15766,1057),(15767,1057),(15768,1057),(15769,1058),(15770,1058),(15771,1058),(15772,1058),(15773,1058),(15774,1058),(15775,1058),(15776,1059),(15777,1059),(15778,1059),(15779,1059),(15780,1059),(15781,1059),(15782,1059),(15783,1060),(15784,1060),(15785,1060),(15786,1060),(15787,1060),(15788,1060),(15789,1060),(15790,1061),(15791,1061),(15792,1061),(15793,1061),(15794,1061),(15795,1061),(15796,1061),(15797,1062),(15798,1062),(15799,1062),(15800,1062),(15801,1062),(15802,1062),(15803,1062),(15804,1063),(15805,1063),(15806,1063),(15807,1063),(15808,1063),(15809,1063),(15810,1063),(15811,1064),(15812,1064),(15813,1064),(15814,1064),(15815,1064),(15816,1064),(15817,1064),(15818,1065),(15819,1065),(15820,1065),(15821,1065),(15822,1065),(15823,1065),(15824,1065),(15825,1066),(15826,1066),(15827,1066),(15828,1066),(15829,1066),(15830,1066),(15831,1066),(15832,1067),(15833,1067),(15834,1067),(15835,1067),(15836,1067),(15837,1067),(15838,1067),(15839,1068),(15840,1068),(15841,1068),(15842,1068),(15843,1068),(15844,1068),(15845,1068),(15846,1069),(15847,1069),(15848,1069),(15849,1069),(15850,1069),(15851,1069),(15852,1069),(15853,1070),(15854,1070),(15855,1070),(15856,1070),(15857,1070),(15858,1070),(15859,1070),(15860,1071),(15861,1071),(15862,1071),(15863,1071),(15864,1071),(15865,1071),(15866,1071),(15867,1072),(15868,1072),(15869,1072),(15870,1072),(15871,1072),(15872,1072),(15873,1072),(15874,1073),(15875,1073),(15876,1073),(15877,1073),(15878,1073),(15879,1073),(15880,1073),(15881,1074),(15882,1074),(15883,1074),(15884,1074),(15885,1074),(15886,1074),(15887,1074),(15888,1075),(15889,1075),(15890,1075),(15891,1075),(15892,1075),(15893,1075),(15894,1075),(15895,1076),(15896,1076),(15897,1076),(15898,1076),(15899,1076),(15900,1076),(15901,1076),(15902,1077),(15903,1077),(15904,1077),(15905,1077),(15906,1077),(15907,1077),(15908,1077),(15909,1078),(15910,1078),(15911,1078),(15912,1078),(15913,1078),(15914,1078),(15915,1078),(15916,1079),(15917,1079),(15918,1079),(15919,1079),(15920,1079),(15921,1079),(15922,1079),(15923,1080),(15924,1080),(15925,1080),(15926,1080),(15927,1080),(15928,1080),(15929,1080),(15930,1081),(15931,1081),(15932,1081),(15933,1081),(15934,1081),(15935,1081),(15936,1081),(15937,1082),(15938,1082),(15939,1082),(15940,1082),(15941,1082),(15942,1082),(15943,1082),(15944,1083),(15945,1083),(15946,1083),(15947,1083),(15948,1083),(15949,1083),(15950,1083),(15951,1084),(15952,1084),(15953,1084),(15954,1084),(15955,1084),(15956,1084),(15957,1084),(15958,1085),(15959,1085),(15960,1085),(15961,1085),(15962,1085),(15963,1085),(15964,1085),(15965,1086),(15966,1086),(15967,1086),(15968,1086),(15969,1086),(15970,1086),(15971,1086),(15972,1087),(15973,1087),(15974,1087),(15975,1087),(15976,1087),(15977,1087),(15978,1087),(15979,1088),(15980,1088),(15981,1088),(15982,1088),(15983,1088),(15984,1088),(15985,1088),(15986,1089),(15987,1089),(15988,1089),(15989,1089),(15990,1089),(15991,1089),(15992,1089),(15993,1090),(15994,1090),(15995,1090),(15996,1090),(15997,1090),(15998,1090),(15999,1090),(16000,1091),(16001,1091),(16002,1091),(16003,1091),(16004,1091),(16005,1091),(16006,1091),(16007,1092),(16008,1092),(16009,1092),(16010,1092),(16011,1092),(16012,1092),(16013,1092),(16014,1093),(16015,1093),(16016,1093),(16017,1093),(16018,1093),(16019,1093),(16020,1093),(16021,1094),(16022,1094),(16023,1094),(16024,1094),(16025,1094),(16026,1094),(16027,1094),(16028,1095),(16029,1095),(16030,1095),(16031,1095),(16032,1095),(16033,1095),(16034,1095),(16035,1096),(16036,1096),(16037,1096),(16038,1096),(16039,1096),(16040,1096),(16041,1096),(16042,1097),(16043,1097),(16044,1097),(16045,1097),(16046,1097),(16047,1097),(16048,1097),(16049,1098),(16050,1098),(16051,1098),(16052,1098),(16053,1098),(16054,1098),(16055,1098),(16056,1099),(16057,1099),(16058,1099),(16059,1099),(16060,1099),(16061,1099),(16062,1099),(16063,1100),(16064,1100),(16065,1100),(16066,1100),(16067,1100),(16068,1100),(16069,1100),(16070,1101),(16071,1101),(16072,1101),(16073,1101),(16074,1101),(16075,1101),(16076,1101),(16077,1102),(16078,1102),(16079,1102),(16080,1102),(16081,1102),(16082,1102),(16083,1102),(16084,1103),(16085,1103),(16086,1103),(16087,1103),(16088,1103),(16089,1103),(16090,1103),(16091,1104),(16092,1104),(16093,1104),(16094,1104),(16095,1104),(16096,1104),(16097,1104),(16098,1105),(16099,1105),(16100,1105),(16101,1105),(16102,1105),(16103,1105),(16104,1105),(16105,1106),(16106,1106),(16107,1106),(16108,1106),(16109,1106),(16110,1106),(16111,1106),(16112,1107),(16113,1107),(16114,1107),(16115,1107),(16116,1107),(16117,1107),(16118,1107),(16119,1108),(16120,1108),(16121,1108),(16122,1108),(16123,1108),(16124,1108),(16125,1108),(16126,1109),(16127,1109),(16128,1109),(16129,1109),(16130,1109),(16131,1109),(16132,1109),(16133,1110),(16134,1110),(16135,1110),(16136,1110),(16137,1110),(16138,1110),(16139,1110),(16140,1111),(16141,1111),(16142,1111),(16143,1111),(16144,1111),(16145,1111),(16146,1111),(16147,1112),(16148,1112),(16149,1112),(16150,1112),(16151,1112),(16152,1112),(16153,1112),(16154,1113),(16155,1113),(16156,1113),(16157,1113),(16158,1113),(16159,1113),(16160,1113),(16161,1114),(16162,1114),(16163,1114),(16164,1114),(16165,1114),(16166,1114),(16167,1114),(16168,1115),(16169,1115),(16170,1115),(16171,1115),(16172,1115),(16173,1115),(16174,1115),(16175,1116),(16176,1116),(16177,1116),(16178,1116),(16179,1116),(16180,1116),(16181,1116),(16182,1117),(16183,1117),(16184,1117),(16185,1117),(16186,1117),(16187,1117),(16188,1117),(16189,1118),(16190,1118),(16191,1118),(16192,1118),(16193,1118),(16194,1118),(16195,1118),(16196,1119),(16197,1119),(16198,1119),(16199,1119),(16200,1119),(16201,1119),(16202,1119),(16203,1120),(16204,1120),(16205,1120),(16206,1120),(16207,1120),(16208,1120),(16209,1120),(16210,1121),(16211,1121),(16212,1121),(16213,1121),(16214,1121),(16215,1121),(16216,1121),(16217,1122),(16218,1122),(16219,1122),(16220,1122),(16221,1122),(16222,1122),(16223,1122),(16224,1123),(16225,1123),(16226,1123),(16227,1123),(16228,1123),(16229,1123),(16230,1123),(16231,1124),(16232,1124),(16233,1124),(16234,1124),(16235,1124),(16236,1124),(16237,1124),(16238,1125),(16239,1125),(16240,1125),(16241,1125),(16242,1125),(16243,1125),(16244,1125),(16245,1126),(16246,1126),(16247,1126),(16248,1126),(16249,1126),(16250,1126),(16251,1126),(16252,1127),(16253,1127),(16254,1127),(16255,1127),(16256,1127),(16257,1127),(16258,1127),(16259,1128),(16260,1128),(16261,1128),(16262,1128),(16263,1128),(16264,1128),(16265,1128),(16266,1129),(16267,1129),(16268,1129),(16269,1129),(16270,1129),(16271,1129),(16272,1129),(16273,1130),(16274,1130),(16275,1130),(16276,1130),(16277,1130),(16278,1130),(16279,1130),(16280,1131),(16281,1131),(16282,1131),(16283,1131),(16284,1131),(16285,1131),(16286,1131),(16287,1132),(16288,1132),(16289,1132),(16290,1132),(16291,1132),(16292,1132),(16293,1132),(16294,1133),(16295,1133),(16296,1133),(16297,1133),(16298,1133),(16299,1133),(16300,1133),(16301,1134),(16302,1134),(16303,1134),(16304,1134),(16305,1134),(16306,1134),(16307,1134),(16308,1135),(16309,1135),(16310,1135),(16311,1135),(16312,1135),(16313,1135),(16314,1135),(16315,1136),(16316,1136),(16317,1136),(16318,1136),(16319,1136),(16320,1136),(16321,1136),(16322,1137),(16323,1137),(16324,1137),(16325,1137),(16326,1137),(16327,1137),(16328,1137),(16329,1138),(16330,1138),(16331,1138),(16332,1138),(16333,1138),(16334,1138),(16335,1138),(16336,1139),(16337,1139),(16338,1139),(16339,1139),(16340,1139),(16341,1139),(16342,1139),(16343,1140),(16344,1140),(16345,1140),(16346,1140),(16347,1140),(16348,1140),(16349,1140),(16350,1141),(16351,1141),(16352,1141),(16353,1141),(16354,1141),(16355,1141),(16356,1141),(16357,1142),(16358,1142),(16359,1142),(16360,1142),(16361,1142),(16362,1142),(16363,1142),(16364,1143),(16365,1143),(16366,1143),(16367,1143),(16368,1143),(16369,1143),(16370,1143),(16371,1144),(16372,1144),(16373,1144),(16374,1144),(16375,1144),(16376,1144),(16377,1144),(16378,1145),(16379,1145),(16380,1145),(16381,1145),(16382,1145),(16383,1145),(16384,1145),(16385,1146),(16386,1146),(16387,1146),(16388,1146),(16389,1146),(16390,1146),(16391,1146),(16392,1047),(16393,1047),(16394,1047),(16395,1047),(16396,1047),(16397,1047),(16398,1048),(16399,1048),(16400,1048),(16401,1048),(16402,1048),(16403,1048),(16404,1049),(16405,1049),(16406,1049),(16407,1049),(16408,1049),(16409,1049),(16410,1050),(16411,1050),(16412,1050),(16413,1050),(16414,1050),(16415,1050),(16416,1051),(16417,1051),(16418,1051),(16419,1051),(16420,1051),(16421,1051),(16422,1052),(16423,1052),(16424,1052),(16425,1052),(16426,1052),(16427,1052),(16428,1053),(16429,1053),(16430,1053),(16431,1053),(16432,1053),(16433,1053),(16434,1054),(16435,1054),(16436,1054),(16437,1054),(16438,1054),(16439,1054),(16440,1055),(16441,1055),(16442,1055),(16443,1055),(16444,1055),(16445,1055),(16446,1056),(16447,1056),(16448,1056),(16449,1056),(16450,1056),(16451,1056),(16452,1057),(16453,1057),(16454,1057),(16455,1057),(16456,1057),(16457,1057),(16458,1058),(16459,1058),(16460,1058),(16461,1058),(16462,1058),(16463,1058),(16464,1059),(16465,1059),(16466,1059),(16467,1059),(16468,1059),(16469,1059),(16470,1060),(16471,1060),(16472,1060),(16473,1060),(16474,1060),(16475,1060),(16476,1060),(16477,1060),(16478,1060),(16479,1061),(16480,1061),(16481,1061),(16482,1061),(16483,1061),(16484,1061),(16485,1062),(16486,1062),(16487,1062),(16488,1062),(16489,1062),(16490,1062),(16491,1063),(16492,1063),(16493,1063),(16494,1063),(16495,1063),(16496,1063),(16497,1064),(16498,1064),(16499,1064),(16500,1064),(16501,1064),(16502,1064),(16503,1065),(16504,1065),(16505,1065),(16506,1065),(16507,1065),(16508,1065),(16509,1066),(16510,1066),(16511,1066),(16512,1066),(16513,1066),(16514,1066),(16515,1067),(16516,1067),(16517,1067),(16518,1067),(16519,1067),(16520,1067),(16521,1068),(16522,1068),(16523,1068),(16524,1068),(16525,1068),(16526,1068),(16527,1069),(16528,1069),(16529,1069),(16530,1069),(16531,1069),(16532,1069),(16533,1070),(16534,1070),(16535,1070),(16536,1070),(16537,1070),(16538,1070),(16539,1071),(16540,1071),(16541,1071),(16542,1071),(16543,1071),(16544,1071),(16545,1072),(16546,1072),(16547,1072),(16548,1072),(16549,1072),(16550,1072),(16551,1073),(16552,1073),(16553,1073),(16554,1073),(16555,1073),(16556,1073),(16557,1074),(16558,1074),(16559,1074),(16560,1074),(16561,1074),(16562,1074),(16563,1075),(16564,1075),(16565,1075),(16566,1075),(16567,1075),(16568,1075),(16569,1076),(16570,1076),(16571,1076),(16572,1076),(16573,1076),(16574,1076),(16575,1076),(16576,1076),(16577,1076),(16578,1077),(16579,1077),(16580,1077),(16581,1077),(16582,1077),(16583,1077),(16584,1078),(16585,1078),(16586,1078),(16587,1078),(16588,1078),(16589,1078),(16590,1079),(16591,1079),(16592,1079),(16593,1079),(16594,1079),(16595,1079),(16596,1080),(16597,1080),(16598,1080),(16599,1080),(16600,1080),(16601,1080),(16602,1081),(16603,1081),(16604,1081),(16605,1081),(16606,1081),(16607,1081),(16608,1082),(16609,1082),(16610,1082),(16611,1082),(16612,1082),(16613,1082),(16614,1083),(16615,1083),(16616,1083),(16617,1083),(16618,1083),(16619,1083),(16620,1084),(16621,1084),(16622,1084),(16623,1084),(16624,1084),(16625,1084),(16626,1085),(16627,1085),(16628,1085),(16629,1085),(16630,1085),(16631,1085),(16632,1086),(16633,1086),(16634,1086),(16635,1086),(16636,1086),(16637,1086),(16638,1087),(16639,1087),(16640,1087),(16641,1087),(16642,1087),(16643,1087),(16644,1088),(16645,1088),(16646,1088),(16647,1088),(16648,1088),(16649,1088),(16650,1089),(16651,1089),(16652,1089),(16653,1089),(16654,1089),(16655,1089),(16656,1090),(16657,1090),(16658,1090),(16659,1090),(16660,1090),(16661,1090),(16662,1091),(16663,1091),(16664,1091),(16665,1091),(16666,1091),(16667,1091),(16668,1092),(16669,1092),(16670,1092),(16671,1092),(16672,1092),(16673,1092),(16674,1092),(16675,1092),(16676,1092),(16677,1093),(16678,1093),(16679,1093),(16680,1093),(16681,1093),(16682,1093),(16683,1094),(16684,1094),(16685,1094),(16686,1094),(16687,1094),(16688,1094),(16689,1095),(16690,1095),(16691,1095),(16692,1095),(16693,1095),(16694,1095),(16695,1096),(16696,1096),(16697,1096),(16698,1096),(16699,1096),(16700,1096),(16701,1097),(16702,1097),(16703,1097),(16704,1097),(16705,1097),(16706,1097),(16707,1098),(16708,1098),(16709,1098),(16710,1098),(16711,1098),(16712,1098),(16713,1099),(16714,1099),(16715,1099),(16716,1099),(16717,1099),(16718,1099),(16719,1100),(16720,1100),(16721,1100),(16722,1100),(16723,1100),(16724,1100),(16725,1101),(16726,1101),(16727,1101),(16728,1101),(16729,1101),(16730,1101),(16731,1102),(16732,1102),(16733,1102),(16734,1102),(16735,1102),(16736,1102),(16737,1103),(16738,1103),(16739,1103),(16740,1103),(16741,1103),(16742,1103),(16743,1104),(16744,1104),(16745,1104),(16746,1104),(16747,1104),(16748,1104),(16749,1105),(16750,1105),(16751,1105),(16752,1105),(16753,1105),(16754,1105),(16755,1106),(16756,1106),(16757,1106),(16758,1106),(16759,1106),(16760,1106),(16761,1107),(16762,1107),(16763,1107),(16764,1107),(16765,1107),(16766,1107),(16767,1108),(16768,1108),(16769,1108),(16770,1108),(16771,1108),(16772,1108),(16773,1108),(16774,1108),(16775,1108),(16776,1109),(16777,1109),(16778,1109),(16779,1109),(16780,1109),(16781,1109),(16782,1110),(16783,1110),(16784,1110),(16785,1110),(16786,1110),(16787,1110),(16788,1111),(16789,1111),(16790,1111),(16791,1111),(16792,1111),(16793,1111),(16794,1112),(16795,1112),(16796,1112),(16797,1112),(16798,1112),(16799,1112),(16800,1113),(16801,1113),(16802,1113),(16803,1113),(16804,1113),(16805,1113),(16806,1114),(16807,1114),(16808,1114),(16809,1114),(16810,1114),(16811,1114),(16812,1114),(16813,1114),(16814,1114),(16815,1115),(16816,1115),(16817,1115),(16818,1115),(16819,1115),(16820,1115),(16821,1116),(16822,1116),(16823,1116),(16824,1116),(16825,1116),(16826,1116),(16827,1117),(16828,1117),(16829,1117),(16830,1117),(16831,1117),(16832,1117),(16833,1118),(16834,1118),(16835,1118),(16836,1118),(16837,1118),(16838,1118),(16839,1119),(16840,1119),(16841,1119),(16842,1119),(16843,1119),(16844,1119),(16845,1120),(16846,1120),(16847,1120),(16848,1120),(16849,1120),(16850,1120),(16851,1121),(16852,1121),(16853,1121),(16854,1121),(16855,1121),(16856,1121),(16857,1122),(16858,1122),(16859,1122),(16860,1122),(16861,1122),(16862,1122),(16863,1123),(16864,1123),(16865,1123),(16866,1123),(16867,1123),(16868,1123),(16869,1124),(16870,1124),(16871,1124),(16872,1124),(16873,1124),(16874,1124),(16875,1125),(16876,1125),(16877,1125),(16878,1125),(16879,1125),(16880,1125),(16881,1126),(16882,1126),(16883,1126),(16884,1126),(16885,1126),(16886,1126),(16887,1127),(16888,1127),(16889,1127),(16890,1127),(16891,1127),(16892,1127),(16893,1128),(16894,1128),(16895,1128),(16896,1128),(16897,1128),(16898,1128),(16899,1129),(16900,1129),(16901,1129),(16902,1129),(16903,1129),(16904,1129),(16905,1130),(16906,1130),(16907,1130),(16908,1130),(16909,1130),(16910,1130),(16911,1130),(16912,1130),(16913,1130),(16914,1131),(16915,1131),(16916,1131),(16917,1131),(16918,1131),(16919,1131),(16920,1132),(16921,1132),(16922,1132),(16923,1132),(16924,1132),(16925,1132),(16926,1133),(16927,1133),(16928,1133),(16929,1133),(16930,1133),(16931,1133),(16932,1134),(16933,1134),(16934,1134),(16935,1134),(16936,1134),(16937,1134),(16938,1135),(16939,1135),(16940,1135),(16941,1135),(16942,1135),(16943,1135),(16944,1136),(16945,1136),(16946,1136),(16947,1136),(16948,1136),(16949,1136),(16950,1137),(16951,1137),(16952,1137),(16953,1137),(16954,1137),(16955,1137),(16956,1138),(16957,1138),(16958,1138),(16959,1138),(16960,1138),(16961,1138),(16962,1139),(16963,1139),(16964,1139),(16965,1139),(16966,1139),(16967,1139),(16968,1140),(16969,1140),(16970,1140),(16971,1140),(16972,1140),(16973,1140),(16974,1141),(16975,1141),(16976,1141),(16977,1141),(16978,1141),(16979,1141),(16980,1142),(16981,1142),(16982,1142),(16983,1142),(16984,1142),(16985,1142),(16986,1143),(16987,1143),(16988,1143),(16989,1143),(16990,1143),(16991,1143),(16992,1144),(16993,1144),(16994,1144),(16995,1144),(16996,1144),(16997,1144),(16998,1145),(16999,1145),(17000,1145),(17001,1145),(17002,1145),(17003,1145),(17004,1146),(17005,1146),(17006,1146),(17007,1146),(17008,1146),(17009,1146),(17010,1146),(17011,1146),(17012,1146),(17013,1047),(17014,1047),(17015,1048),(17016,1048),(17017,1049),(17018,1049),(17019,1050),(17020,1050),(17021,1051),(17022,1051),(17023,1052),(17024,1052),(17025,1053),(17026,1053),(17027,1054),(17028,1054),(17029,1055),(17030,1055),(17031,1056),(17032,1056),(17033,1057),(17034,1057),(17035,1058),(17036,1058),(17037,1059),(17038,1059),(17039,1060),(17040,1061),(17041,1061),(17042,1062),(17043,1062),(17044,1063),(17045,1063),(17046,1064),(17047,1064),(17048,1065),(17049,1065),(17050,1066),(17051,1066),(17052,1067),(17053,1067),(17054,1068),(17055,1068),(17056,1069),(17057,1069),(17058,1070),(17059,1070),(17060,1071),(17061,1071),(17062,1072),(17063,1072),(17064,1073),(17065,1073),(17066,1074),(17067,1074),(17068,1075),(17069,1075),(17070,1076),(17071,1077),(17072,1077),(17073,1078),(17074,1078),(17075,1079),(17076,1079),(17077,1080),(17078,1080),(17079,1081),(17080,1081),(17081,1082),(17082,1082),(17083,1083),(17084,1083),(17085,1084),(17086,1084),(17087,1085),(17088,1085),(17089,1086),(17090,1086),(17091,1087),(17092,1087),(17093,1088),(17094,1088),(17095,1089),(17096,1089),(17097,1090),(17098,1090),(17099,1091),(17100,1091),(17101,1092),(17102,1093),(17103,1093),(17104,1094),(17105,1094),(17106,1095),(17107,1095),(17108,1096),(17109,1096),(17110,1097),(17111,1097),(17112,1098),(17113,1098),(17114,1099),(17115,1099),(17116,1100),(17117,1100),(17118,1101),(17119,1101),(17120,1102),(17121,1102),(17122,1103),(17123,1103),(17124,1104),(17125,1104),(17126,1105),(17127,1105),(17128,1106),(17129,1106),(17130,1107),(17131,1107),(17132,1108),(17133,1109),(17134,1109),(17135,1110),(17136,1110),(17137,1111),(17138,1111),(17139,1112),(17140,1112),(17141,1113),(17142,1113),(17143,1114),(17144,1115),(17145,1115),(17146,1116),(17147,1116),(17148,1117),(17149,1117),(17150,1118),(17151,1118),(17152,1119),(17153,1119),(17154,1120),(17155,1120),(17156,1121),(17157,1121),(17158,1122),(17159,1122),(17160,1123),(17161,1123),(17162,1124),(17163,1124),(17164,1125),(17165,1125),(17166,1126),(17167,1126),(17168,1127),(17169,1127),(17170,1128),(17171,1128),(17172,1129),(17173,1129),(17174,1130),(17175,1131),(17176,1131),(17177,1132),(17178,1132),(17179,1133),(17180,1133),(17181,1134),(17182,1134),(17183,1135),(17184,1135),(17185,1136),(17186,1136),(17187,1137),(17188,1137),(17189,1138),(17190,1138),(17191,1139),(17192,1139),(17193,1140),(17194,1140),(17195,1141),(17196,1141),(17197,1142),(17198,1142),(17199,1143),(17200,1143),(17201,1144),(17202,1144),(17203,1145),(17204,1145),(17205,1146),(17206,1147),(17207,1147),(17208,1147),(17209,1147),(17210,1147),(17211,1147),(17212,1147),(17213,1148),(17214,1148),(17215,1148),(17216,1148),(17217,1148),(17218,1148),(17219,1148),(17220,1149),(17221,1149),(17222,1149),(17223,1149),(17224,1149),(17225,1149),(17226,1149),(17227,1150),(17228,1150),(17229,1150),(17230,1150),(17231,1150),(17232,1150),(17233,1150),(17234,1151),(17235,1151),(17236,1151),(17237,1151),(17238,1151),(17239,1151),(17240,1151),(17241,1152),(17242,1152),(17243,1152),(17244,1152),(17245,1152),(17246,1152),(17247,1152),(17248,1153),(17249,1153),(17250,1153),(17251,1153),(17252,1153),(17253,1153),(17254,1153),(17255,1154),(17256,1154),(17257,1154),(17258,1154),(17259,1154),(17260,1154),(17261,1154),(17262,1155),(17263,1155),(17264,1155),(17265,1155),(17266,1155),(17267,1155),(17268,1155),(17269,1156),(17270,1156),(17271,1156),(17272,1156),(17273,1156),(17274,1156),(17275,1156),(17276,1157),(17277,1157),(17278,1157),(17279,1157),(17280,1157),(17281,1157),(17282,1157),(17283,1158),(17284,1158),(17285,1158),(17286,1158),(17287,1158),(17288,1158),(17289,1158),(17290,1159),(17291,1159),(17292,1159),(17293,1159),(17294,1159),(17295,1159),(17296,1159),(17297,1160),(17298,1160),(17299,1160),(17300,1160),(17301,1160),(17302,1160),(17303,1160),(17304,1161),(17305,1161),(17306,1161),(17307,1161),(17308,1161),(17309,1161),(17310,1161),(17311,1162),(17312,1162),(17313,1162),(17314,1162),(17315,1162),(17316,1162),(17317,1162),(17318,1163),(17319,1163),(17320,1163),(17321,1163),(17322,1163),(17323,1163),(17324,1163),(17325,1164),(17326,1164),(17327,1164),(17328,1164),(17329,1164),(17330,1164),(17331,1164),(17332,1165),(17333,1165),(17334,1165),(17335,1165),(17336,1165),(17337,1165),(17338,1165),(17339,1166),(17340,1166),(17341,1166),(17342,1166),(17343,1166),(17344,1166),(17345,1166),(17346,1167),(17347,1167),(17348,1167),(17349,1167),(17350,1167),(17351,1167),(17352,1167),(17353,1168),(17354,1168),(17355,1168),(17356,1168),(17357,1168),(17358,1168),(17359,1168),(17360,1169),(17361,1169),(17362,1169),(17363,1169),(17364,1169),(17365,1169),(17366,1169),(17367,1170),(17368,1170),(17369,1170),(17370,1170),(17371,1170),(17372,1170),(17373,1170),(17374,1171),(17375,1171),(17376,1171),(17377,1171),(17378,1171),(17379,1171),(17380,1171),(17381,1172),(17382,1172),(17383,1172),(17384,1172),(17385,1172),(17386,1172),(17387,1172),(17388,1173),(17389,1173),(17390,1173),(17391,1173),(17392,1173),(17393,1173),(17394,1173),(17395,1174),(17396,1174),(17397,1174),(17398,1174),(17399,1174),(17400,1174),(17401,1174),(17402,1175),(17403,1175),(17404,1175),(17405,1175),(17406,1175),(17407,1175),(17408,1175),(17409,1176),(17410,1176),(17411,1176),(17412,1176),(17413,1176),(17414,1176),(17415,1176),(17416,1177),(17417,1177),(17418,1177),(17419,1177),(17420,1177),(17421,1177),(17422,1177),(17423,1178),(17424,1178),(17425,1178),(17426,1178),(17427,1178),(17428,1178),(17429,1178),(17430,1179),(17431,1179),(17432,1179),(17433,1179),(17434,1179),(17435,1179),(17436,1179),(17437,1180),(17438,1180),(17439,1180),(17440,1180),(17441,1180),(17442,1180),(17443,1180),(17444,1181),(17445,1181),(17446,1181),(17447,1181),(17448,1181),(17449,1181),(17450,1181),(17451,1182),(17452,1182),(17453,1182),(17454,1182),(17455,1182),(17456,1182),(17457,1182),(17458,1183),(17459,1183),(17460,1183),(17461,1183),(17462,1183),(17463,1183),(17464,1183),(17465,1184),(17466,1184),(17467,1184),(17468,1184),(17469,1184),(17470,1184),(17471,1184),(17472,1185),(17473,1185),(17474,1185),(17475,1185),(17476,1185),(17477,1185),(17478,1185),(17479,1186),(17480,1186),(17481,1186),(17482,1186),(17483,1186),(17484,1186),(17485,1186),(17486,1187),(17487,1187),(17488,1187),(17489,1187),(17490,1187),(17491,1187),(17492,1187),(17493,1188),(17494,1188),(17495,1188),(17496,1188),(17497,1188),(17498,1188),(17499,1188),(17500,1189),(17501,1189),(17502,1189),(17503,1189),(17504,1189),(17505,1189),(17506,1189),(17507,1190),(17508,1190),(17509,1190),(17510,1190),(17511,1190),(17512,1190),(17513,1190),(17514,1191),(17515,1191),(17516,1191),(17517,1191),(17518,1191),(17519,1191),(17520,1191),(17521,1192),(17522,1192),(17523,1192),(17524,1192),(17525,1192),(17526,1192),(17527,1192),(17528,1193),(17529,1193),(17530,1193),(17531,1193),(17532,1193),(17533,1193),(17534,1193),(17535,1194),(17536,1194),(17537,1194),(17538,1194),(17539,1194),(17540,1194),(17541,1194),(17542,1195),(17543,1195),(17544,1195),(17545,1195),(17546,1195),(17547,1195),(17548,1195),(17549,1196),(17550,1196),(17551,1196),(17552,1196),(17553,1196),(17554,1196),(17555,1196),(17556,1197),(17557,1197),(17558,1197),(17559,1197),(17560,1197),(17561,1197),(17562,1197),(17563,1198),(17564,1198),(17565,1198),(17566,1198),(17567,1198),(17568,1198),(17569,1198),(17570,1199),(17571,1199),(17572,1199),(17573,1199),(17574,1199),(17575,1199),(17576,1199),(17577,1200),(17578,1200),(17579,1200),(17580,1200),(17581,1200),(17582,1200),(17583,1200),(17584,1201),(17585,1201),(17586,1201),(17587,1201),(17588,1201),(17589,1201),(17590,1201),(17591,1202),(17592,1202),(17593,1202),(17594,1202),(17595,1202),(17596,1202),(17597,1202),(17598,1203),(17599,1203),(17600,1203),(17601,1203),(17602,1203),(17603,1203),(17604,1203),(17605,1204),(17606,1204),(17607,1204),(17608,1204),(17609,1204),(17610,1204),(17611,1204),(17612,1205),(17613,1205),(17614,1205),(17615,1205),(17616,1205),(17617,1205),(17618,1205),(17619,1206),(17620,1206),(17621,1206),(17622,1206),(17623,1206),(17624,1206),(17625,1206),(17626,1207),(17627,1207),(17628,1207),(17629,1207),(17630,1207),(17631,1207),(17632,1207),(17633,1208),(17634,1208),(17635,1208),(17636,1208),(17637,1208),(17638,1208),(17639,1208),(17640,1209),(17641,1209),(17642,1209),(17643,1209),(17644,1209),(17645,1209),(17646,1209),(17647,1210),(17648,1210),(17649,1210),(17650,1210),(17651,1210),(17652,1210),(17653,1210),(17654,1211),(17655,1211),(17656,1211),(17657,1211),(17658,1211),(17659,1211),(17660,1211),(17661,1212),(17662,1212),(17663,1212),(17664,1212),(17665,1212),(17666,1212),(17667,1212),(17668,1213),(17669,1213),(17670,1213),(17671,1213),(17672,1213),(17673,1213),(17674,1213),(17675,1214),(17676,1214),(17677,1214),(17678,1214),(17679,1214),(17680,1214),(17681,1214),(17682,1215),(17683,1215),(17684,1215),(17685,1215),(17686,1215),(17687,1215),(17688,1215),(17689,1216),(17690,1216),(17691,1216),(17692,1216),(17693,1216),(17694,1216),(17695,1216),(17696,1217),(17697,1217),(17698,1217),(17699,1217),(17700,1217),(17701,1217),(17702,1217),(17703,1218),(17704,1218),(17705,1218),(17706,1218),(17707,1218),(17708,1218),(17709,1218),(17710,1219),(17711,1219),(17712,1219),(17713,1219),(17714,1219),(17715,1219),(17716,1219),(17717,1220),(17718,1220),(17719,1220),(17720,1220),(17721,1220),(17722,1220),(17723,1220),(17724,1221),(17725,1221),(17726,1221),(17727,1221),(17728,1221),(17729,1221),(17730,1221),(17731,1222),(17732,1222),(17733,1222),(17734,1222),(17735,1222),(17736,1222),(17737,1222),(17738,1223),(17739,1223),(17740,1223),(17741,1223),(17742,1223),(17743,1223),(17744,1223),(17745,1224),(17746,1224),(17747,1224),(17748,1224),(17749,1224),(17750,1224),(17751,1224),(17752,1225),(17753,1225),(17754,1225),(17755,1225),(17756,1225),(17757,1225),(17758,1225),(17759,1226),(17760,1226),(17761,1226),(17762,1226),(17763,1226),(17764,1226),(17765,1226),(17766,1227),(17767,1227),(17768,1227),(17769,1227),(17770,1227),(17771,1227),(17772,1227),(17773,1228),(17774,1228),(17775,1228),(17776,1228),(17777,1228),(17778,1228),(17779,1228),(17780,1229),(17781,1229),(17782,1229),(17783,1229),(17784,1229),(17785,1229),(17786,1229),(17787,1230),(17788,1230),(17789,1230),(17790,1230),(17791,1230),(17792,1230),(17793,1230),(17794,1231),(17795,1231),(17796,1231),(17797,1231),(17798,1231),(17799,1231),(17800,1231),(17801,1232),(17802,1232),(17803,1232),(17804,1232),(17805,1232),(17806,1232),(17807,1232),(17808,1233),(17809,1233),(17810,1233),(17811,1233),(17812,1233),(17813,1233),(17814,1233),(17815,1234),(17816,1234),(17817,1234),(17818,1234),(17819,1234),(17820,1234),(17821,1234),(17822,1235),(17823,1235),(17824,1235),(17825,1235),(17826,1235),(17827,1235),(17828,1235),(17829,1236),(17830,1236),(17831,1236),(17832,1236),(17833,1236),(17834,1236),(17835,1236),(17836,1237),(17837,1237),(17838,1237),(17839,1237),(17840,1237),(17841,1237),(17842,1237),(17843,1238),(17844,1238),(17845,1238),(17846,1238),(17847,1238),(17848,1238),(17849,1238),(17850,1239),(17851,1239),(17852,1239),(17853,1239),(17854,1239),(17855,1239),(17856,1239),(17857,1240),(17858,1240),(17859,1240),(17860,1240),(17861,1240),(17862,1240),(17863,1240),(17864,1241),(17865,1241),(17866,1241),(17867,1241),(17868,1241),(17869,1241),(17870,1241),(17871,1242),(17872,1242),(17873,1242),(17874,1242),(17875,1242),(17876,1242),(17877,1242),(17878,1243),(17879,1243),(17880,1243),(17881,1243),(17882,1243),(17883,1243),(17884,1243),(17885,1244),(17886,1244),(17887,1244),(17888,1244),(17889,1244),(17890,1244),(17891,1244),(17892,1245),(17893,1245),(17894,1245),(17895,1245),(17896,1245),(17897,1245),(17898,1245),(17899,1246),(17900,1246),(17901,1246),(17902,1246),(17903,1246),(17904,1246),(17905,1246),(17906,1147),(17907,1147),(17908,1147),(17909,1147),(17910,1147),(17911,1147),(17912,1148),(17913,1148),(17914,1148),(17915,1148),(17916,1148),(17917,1148),(17918,1149),(17919,1149),(17920,1149),(17921,1149),(17922,1149),(17923,1149),(17924,1150),(17925,1150),(17926,1150),(17927,1150),(17928,1150),(17929,1150),(17930,1151),(17931,1151),(17932,1151),(17933,1151),(17934,1151),(17935,1151),(17936,1152),(17937,1152),(17938,1152),(17939,1152),(17940,1152),(17941,1152),(17942,1153),(17943,1153),(17944,1153),(17945,1153),(17946,1153),(17947,1153),(17948,1154),(17949,1154),(17950,1154),(17951,1154),(17952,1154),(17953,1154),(17954,1155),(17955,1155),(17956,1155),(17957,1155),(17958,1155),(17959,1155),(17960,1156),(17961,1156),(17962,1156),(17963,1156),(17964,1156),(17965,1156),(17966,1157),(17967,1157),(17968,1157),(17969,1157),(17970,1157),(17971,1157),(17972,1158),(17973,1158),(17974,1158),(17975,1158),(17976,1158),(17977,1158),(17978,1159),(17979,1159),(17980,1159),(17981,1159),(17982,1159),(17983,1159),(17984,1160),(17985,1160),(17986,1160),(17987,1160),(17988,1160),(17989,1160),(17990,1161),(17991,1161),(17992,1161),(17993,1161),(17994,1161),(17995,1161),(17996,1162),(17997,1162),(17998,1162),(17999,1162),(18000,1162),(18001,1162),(18002,1162),(18003,1162),(18004,1162),(18005,1163),(18006,1163),(18007,1163),(18008,1163),(18009,1163),(18010,1163),(18011,1164),(18012,1164),(18013,1164),(18014,1164),(18015,1164),(18016,1164),(18017,1165),(18018,1165),(18019,1165),(18020,1165),(18021,1165),(18022,1165),(18023,1166),(18024,1166),(18025,1166),(18026,1166),(18027,1166),(18028,1166),(18029,1167),(18030,1167),(18031,1167),(18032,1167),(18033,1167),(18034,1167),(18035,1168),(18036,1168),(18037,1168),(18038,1168),(18039,1168),(18040,1168),(18041,1169),(18042,1169),(18043,1169),(18044,1169),(18045,1169),(18046,1169),(18047,1170),(18048,1170),(18049,1170),(18050,1170),(18051,1170),(18052,1170),(18053,1171),(18054,1171),(18055,1171),(18056,1171),(18057,1171),(18058,1171),(18059,1172),(18060,1172),(18061,1172),(18062,1172),(18063,1172),(18064,1172),(18065,1173),(18066,1173),(18067,1173),(18068,1173),(18069,1173),(18070,1173),(18071,1174),(18072,1174),(18073,1174),(18074,1174),(18075,1174),(18076,1174),(18077,1175),(18078,1175),(18079,1175),(18080,1175),(18081,1175),(18082,1175),(18083,1176),(18084,1176),(18085,1176),(18086,1176),(18087,1176),(18088,1176),(18089,1177),(18090,1177),(18091,1177),(18092,1177),(18093,1177),(18094,1177),(18095,1178),(18096,1178),(18097,1178),(18098,1178),(18099,1178),(18100,1178),(18101,1178),(18102,1178),(18103,1178),(18104,1179),(18105,1179),(18106,1179),(18107,1179),(18108,1179),(18109,1179),(18110,1180),(18111,1180),(18112,1180),(18113,1180),(18114,1180),(18115,1180),(18116,1181),(18117,1181),(18118,1181),(18119,1181),(18120,1181),(18121,1181),(18122,1182),(18123,1182),(18124,1182),(18125,1182),(18126,1182),(18127,1182),(18128,1183),(18129,1183),(18130,1183),(18131,1183),(18132,1183),(18133,1183),(18134,1184),(18135,1184),(18136,1184),(18137,1184),(18138,1184),(18139,1184),(18140,1185),(18141,1185),(18142,1185),(18143,1185),(18144,1185),(18145,1185),(18146,1186),(18147,1186),(18148,1186),(18149,1186),(18150,1186),(18151,1186),(18152,1187),(18153,1187),(18154,1187),(18155,1187),(18156,1187),(18157,1187),(18158,1188),(18159,1188),(18160,1188),(18161,1188),(18162,1188),(18163,1188),(18164,1189),(18165,1189),(18166,1189),(18167,1189),(18168,1189),(18169,1189),(18170,1190),(18171,1190),(18172,1190),(18173,1190),(18174,1190),(18175,1190),(18176,1191),(18177,1191),(18178,1191),(18179,1191),(18180,1191),(18181,1191),(18182,1192),(18183,1192),(18184,1192),(18185,1192),(18186,1192),(18187,1192),(18188,1193),(18189,1193),(18190,1193),(18191,1193),(18192,1193),(18193,1193),(18194,1194),(18195,1194),(18196,1194),(18197,1194),(18198,1194),(18199,1194),(18200,1194),(18201,1194),(18202,1194),(18203,1195),(18204,1195),(18205,1195),(18206,1195),(18207,1195),(18208,1195),(18209,1196),(18210,1196),(18211,1196),(18212,1196),(18213,1196),(18214,1196),(18215,1197),(18216,1197),(18217,1197),(18218,1197),(18219,1197),(18220,1197),(18221,1198),(18222,1198),(18223,1198),(18224,1198),(18225,1198),(18226,1198),(18227,1199),(18228,1199),(18229,1199),(18230,1199),(18231,1199),(18232,1199),(18233,1200),(18234,1200),(18235,1200),(18236,1200),(18237,1200),(18238,1200),(18239,1201),(18240,1201),(18241,1201),(18242,1201),(18243,1201),(18244,1201),(18245,1202),(18246,1202),(18247,1202),(18248,1202),(18249,1202),(18250,1202),(18251,1203),(18252,1203),(18253,1203),(18254,1203),(18255,1203),(18256,1203),(18257,1204),(18258,1204),(18259,1204),(18260,1204),(18261,1204),(18262,1204),(18263,1205),(18264,1205),(18265,1205),(18266,1205),(18267,1205),(18268,1205),(18269,1206),(18270,1206),(18271,1206),(18272,1206),(18273,1206),(18274,1206),(18275,1207),(18276,1207),(18277,1207),(18278,1207),(18279,1207),(18280,1207),(18281,1208),(18282,1208),(18283,1208),(18284,1208),(18285,1208),(18286,1208),(18287,1209),(18288,1209),(18289,1209),(18290,1209),(18291,1209),(18292,1209),(18293,1210),(18294,1210),(18295,1210),(18296,1210),(18297,1210),(18298,1210),(18299,1210),(18300,1210),(18301,1210),(18302,1211),(18303,1211),(18304,1211),(18305,1211),(18306,1211),(18307,1211),(18308,1212),(18309,1212),(18310,1212),(18311,1212),(18312,1212),(18313,1212),(18314,1213),(18315,1213),(18316,1213),(18317,1213),(18318,1213),(18319,1213),(18320,1214),(18321,1214),(18322,1214),(18323,1214),(18324,1214),(18325,1214),(18326,1215),(18327,1215),(18328,1215),(18329,1215),(18330,1215),(18331,1215),(18332,1216),(18333,1216),(18334,1216),(18335,1216),(18336,1216),(18337,1216),(18338,1217),(18339,1217),(18340,1217),(18341,1217),(18342,1217),(18343,1217),(18344,1218),(18345,1218),(18346,1218),(18347,1218),(18348,1218),(18349,1218),(18350,1219),(18351,1219),(18352,1219),(18353,1219),(18354,1219),(18355,1219),(18356,1220),(18357,1220),(18358,1220),(18359,1220),(18360,1220),(18361,1220),(18362,1220),(18363,1220),(18364,1220),(18365,1221),(18366,1221),(18367,1221),(18368,1221),(18369,1221),(18370,1221),(18371,1222),(18372,1222),(18373,1222),(18374,1222),(18375,1222),(18376,1222),(18377,1223),(18378,1223),(18379,1223),(18380,1223),(18381,1223),(18382,1223),(18383,1224),(18384,1224),(18385,1224),(18386,1224),(18387,1224),(18388,1224),(18389,1225),(18390,1225),(18391,1225),(18392,1225),(18393,1225),(18394,1225),(18395,1226),(18396,1226),(18397,1226),(18398,1226),(18399,1226),(18400,1226),(18401,1227),(18402,1227),(18403,1227),(18404,1227),(18405,1227),(18406,1227),(18407,1228),(18408,1228),(18409,1228),(18410,1228),(18411,1228),(18412,1228),(18413,1229),(18414,1229),(18415,1229),(18416,1229),(18417,1229),(18418,1229),(18419,1230),(18420,1230),(18421,1230),(18422,1230),(18423,1230),(18424,1230),(18425,1231),(18426,1231),(18427,1231),(18428,1231),(18429,1231),(18430,1231),(18431,1232),(18432,1232),(18433,1232),(18434,1232),(18435,1232),(18436,1232),(18437,1233),(18438,1233),(18439,1233),(18440,1233),(18441,1233),(18442,1233),(18443,1234),(18444,1234),(18445,1234),(18446,1234),(18447,1234),(18448,1234),(18449,1235),(18450,1235),(18451,1235),(18452,1235),(18453,1235),(18454,1235),(18455,1236),(18456,1236),(18457,1236),(18458,1236),(18459,1236),(18460,1236),(18461,1236),(18462,1236),(18463,1236),(18464,1237),(18465,1237),(18466,1237),(18467,1237),(18468,1237),(18469,1237),(18470,1238),(18471,1238),(18472,1238),(18473,1238),(18474,1238),(18475,1238),(18476,1239),(18477,1239),(18478,1239),(18479,1239),(18480,1239),(18481,1239),(18482,1240),(18483,1240),(18484,1240),(18485,1240),(18486,1240),(18487,1240),(18488,1241),(18489,1241),(18490,1241),(18491,1241),(18492,1241),(18493,1241),(18494,1242),(18495,1242),(18496,1242),(18497,1242),(18498,1242),(18499,1242),(18500,1243),(18501,1243),(18502,1243),(18503,1243),(18504,1243),(18505,1243),(18506,1244),(18507,1244),(18508,1244),(18509,1244),(18510,1244),(18511,1244),(18512,1245),(18513,1245),(18514,1245),(18515,1245),(18516,1245),(18517,1245),(18518,1246),(18519,1246),(18520,1246),(18521,1246),(18522,1246),(18523,1246),(18524,1147),(18525,1147),(18526,1148),(18527,1148),(18528,1149),(18529,1149),(18530,1150),(18531,1150),(18532,1151),(18533,1151),(18534,1152),(18535,1152),(18536,1153),(18537,1153),(18538,1154),(18539,1154),(18540,1155),(18541,1155),(18542,1156),(18543,1156),(18544,1157),(18545,1157),(18546,1158),(18547,1158),(18548,1159),(18549,1159),(18550,1160),(18551,1160),(18552,1161),(18553,1161),(18554,1162),(18555,1163),(18556,1163),(18557,1164),(18558,1164),(18559,1165),(18560,1165),(18561,1166),(18562,1166),(18563,1167),(18564,1167),(18565,1168),(18566,1168),(18567,1169),(18568,1169),(18569,1170),(18570,1170),(18571,1171),(18572,1171),(18573,1172),(18574,1172),(18575,1173),(18576,1173),(18577,1174),(18578,1174),(18579,1175),(18580,1175),(18581,1176),(18582,1176),(18583,1177),(18584,1177),(18585,1178),(18586,1179),(18587,1179),(18588,1180),(18589,1180),(18590,1181),(18591,1181),(18592,1182),(18593,1182),(18594,1183),(18595,1183),(18596,1184),(18597,1184),(18598,1185),(18599,1185),(18600,1186),(18601,1186),(18602,1187),(18603,1187),(18604,1188),(18605,1188),(18606,1189),(18607,1189),(18608,1190),(18609,1190),(18610,1191),(18611,1191),(18612,1192),(18613,1192),(18614,1193),(18615,1193),(18616,1194),(18617,1195),(18618,1195),(18619,1196),(18620,1196),(18621,1197),(18622,1197),(18623,1198),(18624,1198),(18625,1199),(18626,1199),(18627,1200),(18628,1200),(18629,1201),(18630,1201),(18631,1202),(18632,1202),(18633,1203),(18634,1203),(18635,1204),(18636,1204),(18637,1205),(18638,1205),(18639,1206),(18640,1206),(18641,1207),(18642,1207),(18643,1208),(18644,1208),(18645,1209),(18646,1209),(18647,1210),(18648,1211),(18649,1211),(18650,1212),(18651,1212),(18652,1213),(18653,1213),(18654,1214),(18655,1214),(18656,1215),(18657,1215),(18658,1216),(18659,1216),(18660,1217),(18661,1217),(18662,1218),(18663,1218),(18664,1219),(18665,1219),(18666,1220),(18667,1221),(18668,1221),(18669,1222),(18670,1222),(18671,1223),(18672,1223),(18673,1224),(18674,1224),(18675,1225),(18676,1225),(18677,1226),(18678,1226),(18679,1227),(18680,1227),(18681,1228),(18682,1228),(18683,1229),(18684,1229),(18685,1230),(18686,1230),(18687,1231),(18688,1231),(18689,1232),(18690,1232),(18691,1233),(18692,1233),(18693,1234),(18694,1234),(18695,1235),(18696,1235),(18697,1236),(18698,1237),(18699,1237),(18700,1238),(18701,1238),(18702,1239),(18703,1239),(18704,1240),(18705,1240),(18706,1241),(18707,1241),(18708,1242),(18709,1242),(18710,1243),(18711,1243),(18712,1244),(18713,1244),(18714,1245),(18715,1245),(18716,1246),(18717,1246),(18718,1247),(18719,1247),(18720,1247),(18721,1247),(18722,1247),(18723,1247),(18724,1247),(18725,1248),(18726,1248),(18727,1248),(18728,1248),(18729,1248),(18730,1248),(18731,1248),(18732,1249),(18733,1249),(18734,1249),(18735,1249),(18736,1249),(18737,1249),(18738,1249),(18739,1250),(18740,1250),(18741,1250),(18742,1250),(18743,1250),(18744,1250),(18745,1250),(18746,1251),(18747,1251),(18748,1251),(18749,1251),(18750,1251),(18751,1251),(18752,1251),(18753,1252),(18754,1252),(18755,1252),(18756,1252),(18757,1252),(18758,1252),(18759,1252),(18760,1253),(18761,1253),(18762,1253),(18763,1253),(18764,1253),(18765,1253),(18766,1253),(18767,1254),(18768,1254),(18769,1254),(18770,1254),(18771,1254),(18772,1254),(18773,1254),(18774,1255),(18775,1255),(18776,1255),(18777,1255),(18778,1255),(18779,1255),(18780,1255),(18781,1256),(18782,1256),(18783,1256),(18784,1256),(18785,1256),(18786,1256),(18787,1256),(18788,1257),(18789,1257),(18790,1257),(18791,1257),(18792,1257),(18793,1257),(18794,1257),(18795,1258),(18796,1258),(18797,1258),(18798,1258),(18799,1258),(18800,1258),(18801,1258),(18802,1259),(18803,1259),(18804,1259),(18805,1259),(18806,1259),(18807,1259),(18808,1259),(18809,1260),(18810,1260),(18811,1260),(18812,1260),(18813,1260),(18814,1260),(18815,1260),(18816,1261),(18817,1261),(18818,1261),(18819,1261),(18820,1261),(18821,1261),(18822,1261),(18823,1262),(18824,1262),(18825,1262),(18826,1262),(18827,1262),(18828,1262),(18829,1262),(18830,1263),(18831,1263),(18832,1263),(18833,1263),(18834,1263),(18835,1263),(18836,1263),(18837,1264),(18838,1264),(18839,1264),(18840,1264),(18841,1264),(18842,1264),(18843,1264),(18844,1265),(18845,1265),(18846,1265),(18847,1265),(18848,1265),(18849,1265),(18850,1265),(18851,1266),(18852,1266),(18853,1266),(18854,1266),(18855,1266),(18856,1266),(18857,1266),(18858,1267),(18859,1267),(18860,1267),(18861,1267),(18862,1267),(18863,1267),(18864,1267),(18865,1268),(18866,1268),(18867,1268),(18868,1268),(18869,1268),(18870,1268),(18871,1268),(18872,1269),(18873,1269),(18874,1269),(18875,1269),(18876,1269),(18877,1269),(18878,1269),(18879,1270),(18880,1270),(18881,1270),(18882,1270),(18883,1270),(18884,1270),(18885,1270),(18886,1271),(18887,1271),(18888,1271),(18889,1271),(18890,1271),(18891,1271),(18892,1271),(18893,1272),(18894,1272),(18895,1272),(18896,1272),(18897,1272),(18898,1272),(18899,1272),(18900,1273),(18901,1273),(18902,1273),(18903,1273),(18904,1273),(18905,1273),(18906,1273),(18907,1274),(18908,1274),(18909,1274),(18910,1274),(18911,1274),(18912,1274),(18913,1274),(18914,1275),(18915,1275),(18916,1275),(18917,1275),(18918,1275),(18919,1275),(18920,1275),(18921,1276),(18922,1276),(18923,1276),(18924,1276),(18925,1276),(18926,1276),(18927,1276),(18928,1277),(18929,1277),(18930,1277),(18931,1277),(18932,1277),(18933,1277),(18934,1277),(18935,1278),(18936,1278),(18937,1278),(18938,1278),(18939,1278),(18940,1278),(18941,1278),(18942,1279),(18943,1279),(18944,1279),(18945,1279),(18946,1279),(18947,1279),(18948,1279),(18949,1280),(18950,1280),(18951,1280),(18952,1280),(18953,1280),(18954,1280),(18955,1280),(18956,1281),(18957,1281),(18958,1281),(18959,1281),(18960,1281),(18961,1281),(18962,1281),(18963,1282),(18964,1282),(18965,1282),(18966,1282),(18967,1282),(18968,1282),(18969,1282),(18970,1283),(18971,1283),(18972,1283),(18973,1283),(18974,1283),(18975,1283),(18976,1283),(18977,1284),(18978,1284),(18979,1284),(18980,1284),(18981,1284),(18982,1284),(18983,1284),(18984,1285),(18985,1285),(18986,1285),(18987,1285),(18988,1285),(18989,1285),(18990,1285),(18991,1286),(18992,1286),(18993,1286),(18994,1286),(18995,1286),(18996,1286),(18997,1286),(18998,1287),(18999,1287),(19000,1287),(19001,1287),(19002,1287),(19003,1287),(19004,1287),(19005,1288),(19006,1288),(19007,1288),(19008,1288),(19009,1288),(19010,1288),(19011,1288),(19012,1289),(19013,1289),(19014,1289),(19015,1289),(19016,1289),(19017,1289),(19018,1289),(19019,1290),(19020,1290),(19021,1290),(19022,1290),(19023,1290),(19024,1290),(19025,1290),(19026,1291),(19027,1291),(19028,1291),(19029,1291),(19030,1291),(19031,1291),(19032,1291),(19033,1292),(19034,1292),(19035,1292),(19036,1292),(19037,1292),(19038,1292),(19039,1292),(19040,1293),(19041,1293),(19042,1293),(19043,1293),(19044,1293),(19045,1293),(19046,1293),(19047,1294),(19048,1294),(19049,1294),(19050,1294),(19051,1294),(19052,1294),(19053,1294),(19054,1295),(19055,1295),(19056,1295),(19057,1295),(19058,1295),(19059,1295),(19060,1295),(19061,1296),(19062,1296),(19063,1296),(19064,1296),(19065,1296),(19066,1296),(19067,1296),(19068,1297),(19069,1297),(19070,1297),(19071,1297),(19072,1297),(19073,1297),(19074,1297),(19075,1298),(19076,1298),(19077,1298),(19078,1298),(19079,1298),(19080,1298),(19081,1298),(19082,1299),(19083,1299),(19084,1299),(19085,1299),(19086,1299),(19087,1299),(19088,1299),(19089,1300),(19090,1300),(19091,1300),(19092,1300),(19093,1300),(19094,1300),(19095,1300),(19096,1301),(19097,1301),(19098,1301),(19099,1301),(19100,1301),(19101,1301),(19102,1301),(19103,1302),(19104,1302),(19105,1302),(19106,1302),(19107,1302),(19108,1302),(19109,1302),(19110,1303),(19111,1303),(19112,1303),(19113,1303),(19114,1303),(19115,1303),(19116,1303),(19117,1304),(19118,1304),(19119,1304),(19120,1304),(19121,1304),(19122,1304),(19123,1304),(19124,1305),(19125,1305),(19126,1305),(19127,1305),(19128,1305),(19129,1305),(19130,1305),(19131,1306),(19132,1306),(19133,1306),(19134,1306),(19135,1306),(19136,1306),(19137,1306),(19138,1307),(19139,1307),(19140,1307),(19141,1307),(19142,1307),(19143,1307),(19144,1307),(19145,1308),(19146,1308),(19147,1308),(19148,1308),(19149,1308),(19150,1308),(19151,1308),(19152,1309),(19153,1309),(19154,1309),(19155,1309),(19156,1309),(19157,1309),(19158,1309),(19159,1310),(19160,1310),(19161,1310),(19162,1310),(19163,1310),(19164,1310),(19165,1310),(19166,1311),(19167,1311),(19168,1311),(19169,1311),(19170,1311),(19171,1311),(19172,1311),(19173,1312),(19174,1312),(19175,1312),(19176,1312),(19177,1312),(19178,1312),(19179,1312),(19180,1313),(19181,1313),(19182,1313),(19183,1313),(19184,1313),(19185,1313),(19186,1313),(19187,1314),(19188,1314),(19189,1314),(19190,1314),(19191,1314),(19192,1314),(19193,1314),(19194,1315),(19195,1315),(19196,1315),(19197,1315),(19198,1315),(19199,1315),(19200,1315),(19201,1316),(19202,1316),(19203,1316),(19204,1316),(19205,1316),(19206,1316),(19207,1316),(19208,1317),(19209,1317),(19210,1317),(19211,1317),(19212,1317),(19213,1317),(19214,1317),(19215,1318),(19216,1318),(19217,1318),(19218,1318),(19219,1318),(19220,1318),(19221,1318),(19222,1319),(19223,1319),(19224,1319),(19225,1319),(19226,1319),(19227,1319),(19228,1319),(19229,1320),(19230,1320),(19231,1320),(19232,1320),(19233,1320),(19234,1320),(19235,1320),(19236,1321),(19237,1321),(19238,1321),(19239,1321),(19240,1321),(19241,1321),(19242,1321),(19243,1322),(19244,1322),(19245,1322),(19246,1322),(19247,1322),(19248,1322),(19249,1322),(19250,1323),(19251,1323),(19252,1323),(19253,1323),(19254,1323),(19255,1323),(19256,1323),(19257,1324),(19258,1324),(19259,1324),(19260,1324),(19261,1324),(19262,1324),(19263,1324),(19264,1325),(19265,1325),(19266,1325),(19267,1325),(19268,1325),(19269,1325),(19270,1325),(19271,1326),(19272,1326),(19273,1326),(19274,1326),(19275,1326),(19276,1326),(19277,1326),(19278,1327),(19279,1327),(19280,1327),(19281,1327),(19282,1327),(19283,1327),(19284,1327),(19285,1328),(19286,1328),(19287,1328),(19288,1328),(19289,1328),(19290,1328),(19291,1328),(19292,1329),(19293,1329),(19294,1329),(19295,1329),(19296,1329),(19297,1329),(19298,1329),(19299,1330),(19300,1330),(19301,1330),(19302,1330),(19303,1330),(19304,1330),(19305,1330),(19306,1331),(19307,1331),(19308,1331),(19309,1331),(19310,1331),(19311,1331),(19312,1331),(19313,1332),(19314,1332),(19315,1332),(19316,1332),(19317,1332),(19318,1332),(19319,1332),(19320,1333),(19321,1333),(19322,1333),(19323,1333),(19324,1333),(19325,1333),(19326,1333),(19327,1334),(19328,1334),(19329,1334),(19330,1334),(19331,1334),(19332,1334),(19333,1334),(19334,1335),(19335,1335),(19336,1335),(19337,1335),(19338,1335),(19339,1335),(19340,1335),(19341,1336),(19342,1336),(19343,1336),(19344,1336),(19345,1336),(19346,1336),(19347,1336),(19348,1337),(19349,1337),(19350,1337),(19351,1337),(19352,1337),(19353,1337),(19354,1337),(19355,1338),(19356,1338),(19357,1338),(19358,1338),(19359,1338),(19360,1338),(19361,1338),(19362,1339),(19363,1339),(19364,1339),(19365,1339),(19366,1339),(19367,1339),(19368,1339),(19369,1340),(19370,1340),(19371,1340),(19372,1340),(19373,1340),(19374,1340),(19375,1340),(19376,1341),(19377,1341),(19378,1341),(19379,1341),(19380,1341),(19381,1341),(19382,1341),(19383,1342),(19384,1342),(19385,1342),(19386,1342),(19387,1342),(19388,1342),(19389,1342),(19390,1343),(19391,1343),(19392,1343),(19393,1343),(19394,1343),(19395,1343),(19396,1343),(19397,1344),(19398,1344),(19399,1344),(19400,1344),(19401,1344),(19402,1344),(19403,1344),(19404,1345),(19405,1345),(19406,1345),(19407,1345),(19408,1345),(19409,1345),(19410,1345),(19411,1346),(19412,1346),(19413,1346),(19414,1346),(19415,1346),(19416,1346),(19417,1346),(19418,1247),(19419,1247),(19420,1247),(19421,1247),(19422,1247),(19423,1247),(19424,1248),(19425,1248),(19426,1248),(19427,1248),(19428,1248),(19429,1248),(19430,1249),(19431,1249),(19432,1249),(19433,1249),(19434,1249),(19435,1249),(19436,1250),(19437,1250),(19438,1250),(19439,1250),(19440,1250),(19441,1250),(19442,1251),(19443,1251),(19444,1251),(19445,1251),(19446,1251),(19447,1251),(19448,1252),(19449,1252),(19450,1252),(19451,1252),(19452,1252),(19453,1252),(19454,1252),(19455,1252),(19456,1252),(19457,1253),(19458,1253),(19459,1253),(19460,1253),(19461,1253),(19462,1253),(19463,1254),(19464,1254),(19465,1254),(19466,1254),(19467,1254),(19468,1254),(19469,1255),(19470,1255),(19471,1255),(19472,1255),(19473,1255),(19474,1255),(19475,1256),(19476,1256),(19477,1256),(19478,1256),(19479,1256),(19480,1256),(19481,1257),(19482,1257),(19483,1257),(19484,1257),(19485,1257),(19486,1257),(19487,1258),(19488,1258),(19489,1258),(19490,1258),(19491,1258),(19492,1258),(19493,1259),(19494,1259),(19495,1259),(19496,1259),(19497,1259),(19498,1259),(19499,1260),(19500,1260),(19501,1260),(19502,1260),(19503,1260),(19504,1260),(19505,1261),(19506,1261),(19507,1261),(19508,1261),(19509,1261),(19510,1261),(19511,1262),(19512,1262),(19513,1262),(19514,1262),(19515,1262),(19516,1262),(19517,1263),(19518,1263),(19519,1263),(19520,1263),(19521,1263),(19522,1263),(19523,1264),(19524,1264),(19525,1264),(19526,1264),(19527,1264),(19528,1264),(19529,1265),(19530,1265),(19531,1265),(19532,1265),(19533,1265),(19534,1265),(19535,1266),(19536,1266),(19537,1266),(19538,1266),(19539,1266),(19540,1266),(19541,1267),(19542,1267),(19543,1267),(19544,1267),(19545,1267),(19546,1267),(19547,1268),(19548,1268),(19549,1268),(19550,1268),(19551,1268),(19552,1268),(19553,1268),(19554,1268),(19555,1268),(19556,1269),(19557,1269),(19558,1269),(19559,1269),(19560,1269),(19561,1269),(19562,1270),(19563,1270),(19564,1270),(19565,1270),(19566,1270),(19567,1270),(19568,1271),(19569,1271),(19570,1271),(19571,1271),(19572,1271),(19573,1271),(19574,1272),(19575,1272),(19576,1272),(19577,1272),(19578,1272),(19579,1272),(19580,1273),(19581,1273),(19582,1273),(19583,1273),(19584,1273),(19585,1273),(19586,1274),(19587,1274),(19588,1274),(19589,1274),(19590,1274),(19591,1274),(19592,1275),(19593,1275),(19594,1275),(19595,1275),(19596,1275),(19597,1275),(19598,1276),(19599,1276),(19600,1276),(19601,1276),(19602,1276),(19603,1276),(19604,1277),(19605,1277),(19606,1277),(19607,1277),(19608,1277),(19609,1277),(19610,1278),(19611,1278),(19612,1278),(19613,1278),(19614,1278),(19615,1278),(19616,1279),(19617,1279),(19618,1279),(19619,1279),(19620,1279),(19621,1279),(19622,1280),(19623,1280),(19624,1280),(19625,1280),(19626,1280),(19627,1280),(19628,1281),(19629,1281),(19630,1281),(19631,1281),(19632,1281),(19633,1281),(19634,1282),(19635,1282),(19636,1282),(19637,1282),(19638,1282),(19639,1282),(19640,1283),(19641,1283),(19642,1283),(19643,1283),(19644,1283),(19645,1283),(19646,1284),(19647,1284),(19648,1284),(19649,1284),(19650,1284),(19651,1284),(19652,1284),(19653,1284),(19654,1284),(19655,1285),(19656,1285),(19657,1285),(19658,1285),(19659,1285),(19660,1285),(19661,1286),(19662,1286),(19663,1286),(19664,1286),(19665,1286),(19666,1286),(19667,1287),(19668,1287),(19669,1287),(19670,1287),(19671,1287),(19672,1287),(19673,1288),(19674,1288),(19675,1288),(19676,1288),(19677,1288),(19678,1288),(19679,1289),(19680,1289),(19681,1289),(19682,1289),(19683,1289),(19684,1289),(19685,1290),(19686,1290),(19687,1290),(19688,1290),(19689,1290),(19690,1290),(19691,1291),(19692,1291),(19693,1291),(19694,1291),(19695,1291),(19696,1291),(19697,1292),(19698,1292),(19699,1292),(19700,1292),(19701,1292),(19702,1292),(19703,1293),(19704,1293),(19705,1293),(19706,1293),(19707,1293),(19708,1293),(19709,1294),(19710,1294),(19711,1294),(19712,1294),(19713,1294),(19714,1294),(19715,1295),(19716,1295),(19717,1295),(19718,1295),(19719,1295),(19720,1295),(19721,1296),(19722,1296),(19723,1296),(19724,1296),(19725,1296),(19726,1296),(19727,1297),(19728,1297),(19729,1297),(19730,1297),(19731,1297),(19732,1297),(19733,1298),(19734,1298),(19735,1298),(19736,1298),(19737,1298),(19738,1298),(19739,1299),(19740,1299),(19741,1299),(19742,1299),(19743,1299),(19744,1299),(19745,1300),(19746,1300),(19747,1300),(19748,1300),(19749,1300),(19750,1300),(19751,1300),(19752,1300),(19753,1300),(19754,1301),(19755,1301),(19756,1301),(19757,1301),(19758,1301),(19759,1301),(19760,1302),(19761,1302),(19762,1302),(19763,1302),(19764,1302),(19765,1302),(19766,1303),(19767,1303),(19768,1303),(19769,1303),(19770,1303),(19771,1303),(19772,1304),(19773,1304),(19774,1304),(19775,1304),(19776,1304),(19777,1304),(19778,1305),(19779,1305),(19780,1305),(19781,1305),(19782,1305),(19783,1305),(19784,1306),(19785,1306),(19786,1306),(19787,1306),(19788,1306),(19789,1306),(19790,1307),(19791,1307),(19792,1307),(19793,1307),(19794,1307),(19795,1307),(19796,1308),(19797,1308),(19798,1308),(19799,1308),(19800,1308),(19801,1308),(19802,1309),(19803,1309),(19804,1309),(19805,1309),(19806,1309),(19807,1309),(19808,1310),(19809,1310),(19810,1310),(19811,1310),(19812,1310),(19813,1310),(19814,1311),(19815,1311),(19816,1311),(19817,1311),(19818,1311),(19819,1311),(19820,1312),(19821,1312),(19822,1312),(19823,1312),(19824,1312),(19825,1312),(19826,1313),(19827,1313),(19828,1313),(19829,1313),(19830,1313),(19831,1313),(19832,1314),(19833,1314),(19834,1314),(19835,1314),(19836,1314),(19837,1314),(19838,1315),(19839,1315),(19840,1315),(19841,1315),(19842,1315),(19843,1315),(19844,1316),(19845,1316),(19846,1316),(19847,1316),(19848,1316),(19849,1316),(19850,1316),(19851,1316),(19852,1316),(19853,1317),(19854,1317),(19855,1317),(19856,1317),(19857,1317),(19858,1317),(19859,1318),(19860,1318),(19861,1318),(19862,1318),(19863,1318),(19864,1318),(19865,1319),(19866,1319),(19867,1319),(19868,1319),(19869,1319),(19870,1319),(19871,1320),(19872,1320),(19873,1320),(19874,1320),(19875,1320),(19876,1320),(19877,1321),(19878,1321),(19879,1321),(19880,1321),(19881,1321),(19882,1321),(19883,1322),(19884,1322),(19885,1322),(19886,1322),(19887,1322),(19888,1322),(19889,1323),(19890,1323),(19891,1323),(19892,1323),(19893,1323),(19894,1323),(19895,1324),(19896,1324),(19897,1324),(19898,1324),(19899,1324),(19900,1324),(19901,1325),(19902,1325),(19903,1325),(19904,1325),(19905,1325),(19906,1325),(19907,1326),(19908,1326),(19909,1326),(19910,1326),(19911,1326),(19912,1326),(19913,1327),(19914,1327),(19915,1327),(19916,1327),(19917,1327),(19918,1327),(19919,1328),(19920,1328),(19921,1328),(19922,1328),(19923,1328),(19924,1328),(19925,1329),(19926,1329),(19927,1329),(19928,1329),(19929,1329),(19930,1329),(19931,1330),(19932,1330),(19933,1330),(19934,1330),(19935,1330),(19936,1330),(19937,1331),(19938,1331),(19939,1331),(19940,1331),(19941,1331),(19942,1331),(19943,1332),(19944,1332),(19945,1332),(19946,1332),(19947,1332),(19948,1332),(19949,1332),(19950,1332),(19951,1332),(19952,1333),(19953,1333),(19954,1333),(19955,1333),(19956,1333),(19957,1333),(19958,1334),(19959,1334),(19960,1334),(19961,1334),(19962,1334),(19963,1334),(19964,1335),(19965,1335),(19966,1335),(19967,1335),(19968,1335),(19969,1335),(19970,1336),(19971,1336),(19972,1336),(19973,1336),(19974,1336),(19975,1336),(19976,1337),(19977,1337),(19978,1337),(19979,1337),(19980,1337),(19981,1337),(19982,1338),(19983,1338),(19984,1338),(19985,1338),(19986,1338),(19987,1338),(19988,1339),(19989,1339),(19990,1339),(19991,1339),(19992,1339),(19993,1339),(19994,1340),(19995,1340),(19996,1340),(19997,1340),(19998,1340),(19999,1340),(20000,1341),(20001,1341),(20002,1341),(20003,1341),(20004,1341),(20005,1341),(20006,1342),(20007,1342),(20008,1342),(20009,1342),(20010,1342),(20011,1342),(20012,1343),(20013,1343),(20014,1343),(20015,1343),(20016,1343),(20017,1343),(20018,1344),(20019,1344),(20020,1344),(20021,1344),(20022,1344),(20023,1344),(20024,1345),(20025,1345),(20026,1345),(20027,1345),(20028,1345),(20029,1345),(20030,1346),(20031,1346),(20032,1346),(20033,1346),(20034,1346),(20035,1346),(20036,1247),(20037,1247),(20038,1248),(20039,1248),(20040,1249),(20041,1249),(20042,1250),(20043,1250),(20044,1251),(20045,1251),(20046,1252),(20047,1253),(20048,1253),(20049,1254),(20050,1254),(20051,1255),(20052,1255),(20053,1256),(20054,1256),(20055,1257),(20056,1257),(20057,1258),(20058,1258),(20059,1259),(20060,1259),(20061,1260),(20062,1260),(20063,1261),(20064,1261),(20065,1262),(20066,1262),(20067,1263),(20068,1263),(20069,1264),(20070,1264),(20071,1265),(20072,1265),(20073,1266),(20074,1266),(20075,1267),(20076,1267),(20077,1268),(20078,1269),(20079,1269),(20080,1270),(20081,1270),(20082,1271),(20083,1271),(20084,1272),(20085,1272),(20086,1273),(20087,1273),(20088,1274),(20089,1274),(20090,1275),(20091,1275),(20092,1276),(20093,1276),(20094,1277),(20095,1277),(20096,1278),(20097,1278),(20098,1279),(20099,1279),(20100,1280),(20101,1280),(20102,1281),(20103,1281),(20104,1282),(20105,1282),(20106,1283),(20107,1283),(20108,1284),(20109,1285),(20110,1285),(20111,1286),(20112,1286),(20113,1287),(20114,1287),(20115,1288),(20116,1288),(20117,1289),(20118,1289),(20119,1290),(20120,1290),(20121,1291),(20122,1291),(20123,1292),(20124,1292),(20125,1293),(20126,1293),(20127,1294),(20128,1294),(20129,1295),(20130,1295),(20131,1296),(20132,1296),(20133,1297),(20134,1297),(20135,1298),(20136,1298),(20137,1299),(20138,1299),(20139,1300),(20140,1301),(20141,1301),(20142,1302),(20143,1302),(20144,1303),(20145,1303),(20146,1304),(20147,1304),(20148,1305),(20149,1305),(20150,1306),(20151,1306),(20152,1307),(20153,1307),(20154,1308),(20155,1308),(20156,1309),(20157,1309),(20158,1310),(20159,1310),(20160,1311),(20161,1311),(20162,1312),(20163,1312),(20164,1313),(20165,1313),(20166,1314),(20167,1314),(20168,1315),(20169,1315),(20170,1316),(20171,1317),(20172,1317),(20173,1318),(20174,1318),(20175,1319),(20176,1319),(20177,1320),(20178,1320),(20179,1321),(20180,1321),(20181,1322),(20182,1322),(20183,1323),(20184,1323),(20185,1324),(20186,1324),(20187,1325),(20188,1325),(20189,1326),(20190,1326),(20191,1327),(20192,1327),(20193,1328),(20194,1328),(20195,1329),(20196,1329),(20197,1330),(20198,1330),(20199,1331),(20200,1331),(20201,1332),(20202,1333),(20203,1333),(20204,1334),(20205,1334),(20206,1335),(20207,1335),(20208,1336),(20209,1336),(20210,1337),(20211,1337),(20212,1338),(20213,1338),(20214,1339),(20215,1339),(20216,1340),(20217,1340),(20218,1341),(20219,1341),(20220,1342),(20221,1342),(20222,1343),(20223,1343),(20224,1344),(20225,1344),(20226,1345),(20227,1345),(20228,1346),(20229,1346),(20230,1347),(20231,1347),(20232,1347),(20233,1347),(20234,1347),(20235,1347),(20236,1347),(20237,1348),(20238,1348),(20239,1348),(20240,1348),(20241,1348),(20242,1348),(20243,1348),(20244,1349),(20245,1349),(20246,1349),(20247,1349),(20248,1349),(20249,1349),(20250,1349),(20251,1350),(20252,1350),(20253,1350),(20254,1350),(20255,1350),(20256,1350),(20257,1350),(20258,1351),(20259,1351),(20260,1351),(20261,1351),(20262,1351),(20263,1351),(20264,1351),(20265,1352),(20266,1352),(20267,1352),(20268,1352),(20269,1352),(20270,1352),(20271,1352),(20272,1353),(20273,1353),(20274,1353),(20275,1353),(20276,1353),(20277,1353),(20278,1353),(20279,1354),(20280,1354),(20281,1354),(20282,1354),(20283,1354),(20284,1354),(20285,1354),(20286,1355),(20287,1355),(20288,1355),(20289,1355),(20290,1355),(20291,1355),(20292,1355),(20293,1356),(20294,1356),(20295,1356),(20296,1356),(20297,1356),(20298,1356),(20299,1356),(20300,1357),(20301,1357),(20302,1357),(20303,1357),(20304,1357),(20305,1357),(20306,1357),(20307,1358),(20308,1358),(20309,1358),(20310,1358),(20311,1358),(20312,1358),(20313,1358),(20314,1359),(20315,1359),(20316,1359),(20317,1359),(20318,1359),(20319,1359),(20320,1359),(20321,1360),(20322,1360),(20323,1360),(20324,1360),(20325,1360),(20326,1360),(20327,1360),(20328,1361),(20329,1361),(20330,1361),(20331,1361),(20332,1361),(20333,1361),(20334,1361),(20335,1362),(20336,1362),(20337,1362),(20338,1362),(20339,1362),(20340,1362),(20341,1362),(20342,1363),(20343,1363),(20344,1363),(20345,1363),(20346,1363),(20347,1363),(20348,1363),(20349,1364),(20350,1364),(20351,1364),(20352,1364),(20353,1364),(20354,1364),(20355,1364),(20356,1365),(20357,1365),(20358,1365),(20359,1365),(20360,1365),(20361,1365),(20362,1365),(20363,1366),(20364,1366),(20365,1366),(20366,1366),(20367,1366),(20368,1366),(20369,1366),(20370,1367),(20371,1367),(20372,1367),(20373,1367),(20374,1367),(20375,1367),(20376,1367),(20377,1368),(20378,1368),(20379,1368),(20380,1368),(20381,1368),(20382,1368),(20383,1368),(20384,1369),(20385,1369),(20386,1369),(20387,1369),(20388,1369),(20389,1369),(20390,1369),(20391,1370),(20392,1370),(20393,1370),(20394,1370),(20395,1370),(20396,1370),(20397,1370),(20398,1371),(20399,1371),(20400,1371),(20401,1371),(20402,1371),(20403,1371),(20404,1371),(20405,1372),(20406,1372),(20407,1372),(20408,1372),(20409,1372),(20410,1372),(20411,1372),(20412,1373),(20413,1373),(20414,1373),(20415,1373),(20416,1373),(20417,1373),(20418,1373),(20419,1374),(20420,1374),(20421,1374),(20422,1374),(20423,1374),(20424,1374),(20425,1374),(20426,1375),(20427,1375),(20428,1375),(20429,1375),(20430,1375),(20431,1375),(20432,1375),(20433,1376),(20434,1376),(20435,1376),(20436,1376),(20437,1376),(20438,1376),(20439,1376),(20440,1377),(20441,1377),(20442,1377),(20443,1377),(20444,1377),(20445,1377),(20446,1377),(20447,1378),(20448,1378),(20449,1378),(20450,1378),(20451,1378),(20452,1378),(20453,1378),(20454,1379),(20455,1379),(20456,1379),(20457,1379),(20458,1379),(20459,1379),(20460,1379),(20461,1380),(20462,1380),(20463,1380),(20464,1380),(20465,1380),(20466,1380),(20467,1380),(20468,1381),(20469,1381),(20470,1381),(20471,1381),(20472,1381),(20473,1381),(20474,1381),(20475,1382),(20476,1382),(20477,1382),(20478,1382),(20479,1382),(20480,1382),(20481,1382),(20482,1383),(20483,1383),(20484,1383),(20485,1383),(20486,1383),(20487,1383),(20488,1383),(20489,1384),(20490,1384),(20491,1384),(20492,1384),(20493,1384),(20494,1384),(20495,1384),(20496,1385),(20497,1385),(20498,1385),(20499,1385),(20500,1385),(20501,1385),(20502,1385),(20503,1386),(20504,1386),(20505,1386),(20506,1386),(20507,1386),(20508,1386),(20509,1386),(20510,1387),(20511,1387),(20512,1387),(20513,1387),(20514,1387),(20515,1387),(20516,1387),(20517,1388),(20518,1388),(20519,1388),(20520,1388),(20521,1388),(20522,1388),(20523,1388),(20524,1389),(20525,1389),(20526,1389),(20527,1389),(20528,1389),(20529,1389),(20530,1389),(20531,1390),(20532,1390),(20533,1390),(20534,1390),(20535,1390),(20536,1390),(20537,1390),(20538,1391),(20539,1391),(20540,1391),(20541,1391),(20542,1391),(20543,1391),(20544,1391),(20545,1392),(20546,1392),(20547,1392),(20548,1392),(20549,1392),(20550,1392),(20551,1392),(20552,1393),(20553,1393),(20554,1393),(20555,1393),(20556,1393),(20557,1393),(20558,1393),(20559,1394),(20560,1394),(20561,1394),(20562,1394),(20563,1394),(20564,1394),(20565,1394),(20566,1395),(20567,1395),(20568,1395),(20569,1395),(20570,1395),(20571,1395),(20572,1395),(20573,1396),(20574,1396),(20575,1396),(20576,1396),(20577,1396),(20578,1396),(20579,1396),(20580,1397),(20581,1397),(20582,1397),(20583,1397),(20584,1397),(20585,1397),(20586,1397),(20587,1398),(20588,1398),(20589,1398),(20590,1398),(20591,1398),(20592,1398),(20593,1398),(20594,1399),(20595,1399),(20596,1399),(20597,1399),(20598,1399),(20599,1399),(20600,1399),(20601,1400),(20602,1400),(20603,1400),(20604,1400),(20605,1400),(20606,1400),(20607,1400),(20608,1401),(20609,1401),(20610,1401),(20611,1401),(20612,1401),(20613,1401),(20614,1401),(20615,1402),(20616,1402),(20617,1402),(20618,1402),(20619,1402),(20620,1402),(20621,1402),(20622,1403),(20623,1403),(20624,1403),(20625,1403),(20626,1403),(20627,1403),(20628,1403),(20629,1404),(20630,1404),(20631,1404),(20632,1404),(20633,1404),(20634,1404),(20635,1404),(20636,1405),(20637,1405),(20638,1405),(20639,1405),(20640,1405),(20641,1405),(20642,1405),(20643,1406),(20644,1406),(20645,1406),(20646,1406),(20647,1406),(20648,1406),(20649,1406),(20650,1407),(20651,1407),(20652,1407),(20653,1407),(20654,1407),(20655,1407),(20656,1407),(20657,1408),(20658,1408),(20659,1408),(20660,1408),(20661,1408),(20662,1408),(20663,1408),(20664,1409),(20665,1409),(20666,1409),(20667,1409),(20668,1409),(20669,1409),(20670,1409),(20671,1410),(20672,1410),(20673,1410),(20674,1410),(20675,1410),(20676,1410),(20677,1410),(20678,1411),(20679,1411),(20680,1411),(20681,1411),(20682,1411),(20683,1411),(20684,1411),(20685,1412),(20686,1412),(20687,1412),(20688,1412),(20689,1412),(20690,1412),(20691,1412),(20692,1413),(20693,1413),(20694,1413),(20695,1413),(20696,1413),(20697,1413),(20698,1413),(20699,1414),(20700,1414),(20701,1414),(20702,1414),(20703,1414),(20704,1414),(20705,1414),(20706,1415),(20707,1415),(20708,1415),(20709,1415),(20710,1415),(20711,1415),(20712,1415),(20713,1416),(20714,1416),(20715,1416),(20716,1416),(20717,1416),(20718,1416),(20719,1416),(20720,1417),(20721,1417),(20722,1417),(20723,1417),(20724,1417),(20725,1417),(20726,1417),(20727,1418),(20728,1418),(20729,1418),(20730,1418),(20731,1418),(20732,1418),(20733,1418),(20734,1419),(20735,1419),(20736,1419),(20737,1419),(20738,1419),(20739,1419),(20740,1419),(20741,1420),(20742,1420),(20743,1420),(20744,1420),(20745,1420),(20746,1420),(20747,1420),(20748,1421),(20749,1421),(20750,1421),(20751,1421),(20752,1421),(20753,1421),(20754,1421),(20755,1422),(20756,1422),(20757,1422),(20758,1422),(20759,1422),(20760,1422),(20761,1422),(20762,1423),(20763,1423),(20764,1423),(20765,1423),(20766,1423),(20767,1423),(20768,1423),(20769,1424),(20770,1424),(20771,1424),(20772,1424),(20773,1424),(20774,1424),(20775,1424),(20776,1425),(20777,1425),(20778,1425),(20779,1425),(20780,1425),(20781,1425),(20782,1425),(20783,1426),(20784,1426),(20785,1426),(20786,1426),(20787,1426),(20788,1426),(20789,1426),(20790,1427),(20791,1427),(20792,1427),(20793,1427),(20794,1427),(20795,1427),(20796,1427),(20797,1428),(20798,1428),(20799,1428),(20800,1428),(20801,1428),(20802,1428),(20803,1428),(20804,1429),(20805,1429),(20806,1429),(20807,1429),(20808,1429),(20809,1429),(20810,1429),(20811,1430),(20812,1430),(20813,1430),(20814,1430),(20815,1430),(20816,1430),(20817,1430),(20818,1431),(20819,1431),(20820,1431),(20821,1431),(20822,1431),(20823,1431),(20824,1431),(20825,1432),(20826,1432),(20827,1432),(20828,1432),(20829,1432),(20830,1432),(20831,1432),(20832,1433),(20833,1433),(20834,1433),(20835,1433),(20836,1433),(20837,1433),(20838,1433),(20839,1434),(20840,1434),(20841,1434),(20842,1434),(20843,1434),(20844,1434),(20845,1434),(20846,1435),(20847,1435),(20848,1435),(20849,1435),(20850,1435),(20851,1435),(20852,1435),(20853,1436),(20854,1436),(20855,1436),(20856,1436),(20857,1436),(20858,1436),(20859,1436),(20860,1437),(20861,1437),(20862,1437),(20863,1437),(20864,1437),(20865,1437),(20866,1437),(20867,1438),(20868,1438),(20869,1438),(20870,1438),(20871,1438),(20872,1438),(20873,1438),(20874,1439),(20875,1439),(20876,1439),(20877,1439),(20878,1439),(20879,1439),(20880,1439),(20881,1440),(20882,1440),(20883,1440),(20884,1440),(20885,1440),(20886,1440),(20887,1440),(20888,1441),(20889,1441),(20890,1441),(20891,1441),(20892,1441),(20893,1441),(20894,1441),(20895,1442),(20896,1442),(20897,1442),(20898,1442),(20899,1442),(20900,1442),(20901,1442),(20902,1443),(20903,1443),(20904,1443),(20905,1443),(20906,1443),(20907,1443),(20908,1443),(20909,1444),(20910,1444),(20911,1444),(20912,1444),(20913,1444),(20914,1444),(20915,1444),(20916,1445),(20917,1445),(20918,1445),(20919,1445),(20920,1445),(20921,1445),(20922,1445),(20923,1446),(20924,1446),(20925,1446),(20926,1446),(20927,1446),(20928,1446),(20929,1446),(20930,1347),(20931,1347),(20932,1347),(20933,1347),(20934,1347),(20935,1347),(20936,1348),(20937,1348),(20938,1348),(20939,1348),(20940,1348),(20941,1348),(20942,1348),(20943,1348),(20944,1348),(20945,1349),(20946,1349),(20947,1349),(20948,1349),(20949,1349),(20950,1349),(20951,1350),(20952,1350),(20953,1350),(20954,1350),(20955,1350),(20956,1350),(20957,1351),(20958,1351),(20959,1351),(20960,1351),(20961,1351),(20962,1351),(20963,1352),(20964,1352),(20965,1352),(20966,1352),(20967,1352),(20968,1352),(20969,1353),(20970,1353),(20971,1353),(20972,1353),(20973,1353),(20974,1353),(20975,1354),(20976,1354),(20977,1354),(20978,1354),(20979,1354),(20980,1354),(20981,1355),(20982,1355),(20983,1355),(20984,1355),(20985,1355),(20986,1355),(20987,1356),(20988,1356),(20989,1356),(20990,1356),(20991,1356),(20992,1356),(20993,1357),(20994,1357),(20995,1357),(20996,1357),(20997,1357),(20998,1357),(20999,1358),(21000,1358),(21001,1358),(21002,1358),(21003,1358),(21004,1358),(21005,1359),(21006,1359),(21007,1359),(21008,1359),(21009,1359),(21010,1359),(21011,1360),(21012,1360),(21013,1360),(21014,1360),(21015,1360),(21016,1360),(21017,1361),(21018,1361),(21019,1361),(21020,1361),(21021,1361),(21022,1361),(21023,1362),(21024,1362),(21025,1362),(21026,1362),(21027,1362),(21028,1362),(21029,1363),(21030,1363),(21031,1363),(21032,1363),(21033,1363),(21034,1363),(21035,1364),(21036,1364),(21037,1364),(21038,1364),(21039,1364),(21040,1364),(21041,1364),(21042,1364),(21043,1364),(21044,1365),(21045,1365),(21046,1365),(21047,1365),(21048,1365),(21049,1365),(21050,1366),(21051,1366),(21052,1366),(21053,1366),(21054,1366),(21055,1366),(21056,1367),(21057,1367),(21058,1367),(21059,1367),(21060,1367),(21061,1367),(21062,1368),(21063,1368),(21064,1368),(21065,1368),(21066,1368),(21067,1368),(21068,1369),(21069,1369),(21070,1369),(21071,1369),(21072,1369),(21073,1369),(21074,1370),(21075,1370),(21076,1370),(21077,1370),(21078,1370),(21079,1370),(21080,1371),(21081,1371),(21082,1371),(21083,1371),(21084,1371),(21085,1371),(21086,1372),(21087,1372),(21088,1372),(21089,1372),(21090,1372),(21091,1372),(21092,1373),(21093,1373),(21094,1373),(21095,1373),(21096,1373),(21097,1373),(21098,1374),(21099,1374),(21100,1374),(21101,1374),(21102,1374),(21103,1374),(21104,1375),(21105,1375),(21106,1375),(21107,1375),(21108,1375),(21109,1375),(21110,1376),(21111,1376),(21112,1376),(21113,1376),(21114,1376),(21115,1376),(21116,1377),(21117,1377),(21118,1377),(21119,1377),(21120,1377),(21121,1377),(21122,1378),(21123,1378),(21124,1378),(21125,1378),(21126,1378),(21127,1378),(21128,1379),(21129,1379),(21130,1379),(21131,1379),(21132,1379),(21133,1379),(21134,1380),(21135,1380),(21136,1380),(21137,1380),(21138,1380),(21139,1380),(21140,1380),(21141,1380),(21142,1380),(21143,1381),(21144,1381),(21145,1381),(21146,1381),(21147,1381),(21148,1381),(21149,1382),(21150,1382),(21151,1382),(21152,1382),(21153,1382),(21154,1382),(21155,1383),(21156,1383),(21157,1383),(21158,1383),(21159,1383),(21160,1383),(21161,1384),(21162,1384),(21163,1384),(21164,1384),(21165,1384),(21166,1384),(21167,1385),(21168,1385),(21169,1385),(21170,1385),(21171,1385),(21172,1385),(21173,1386),(21174,1386),(21175,1386),(21176,1386),(21177,1386),(21178,1386),(21179,1387),(21180,1387),(21181,1387),(21182,1387),(21183,1387),(21184,1387),(21185,1388),(21186,1388),(21187,1388),(21188,1388),(21189,1388),(21190,1388),(21191,1389),(21192,1389),(21193,1389),(21194,1389),(21195,1389),(21196,1389),(21197,1390),(21198,1390),(21199,1390),(21200,1390),(21201,1390),(21202,1390),(21203,1391),(21204,1391),(21205,1391),(21206,1391),(21207,1391),(21208,1391),(21209,1392),(21210,1392),(21211,1392),(21212,1392),(21213,1392),(21214,1392),(21215,1393),(21216,1393),(21217,1393),(21218,1393),(21219,1393),(21220,1393),(21221,1394),(21222,1394),(21223,1394),(21224,1394),(21225,1394),(21226,1394),(21227,1395),(21228,1395),(21229,1395),(21230,1395),(21231,1395),(21232,1395),(21233,1396),(21234,1396),(21235,1396),(21236,1396),(21237,1396),(21238,1396),(21239,1396),(21240,1396),(21241,1396),(21242,1397),(21243,1397),(21244,1397),(21245,1397),(21246,1397),(21247,1397),(21248,1398),(21249,1398),(21250,1398),(21251,1398),(21252,1398),(21253,1398),(21254,1399),(21255,1399),(21256,1399),(21257,1399),(21258,1399),(21259,1399),(21260,1400),(21261,1400),(21262,1400),(21263,1400),(21264,1400),(21265,1400),(21266,1401),(21267,1401),(21268,1401),(21269,1401),(21270,1401),(21271,1401),(21272,1402),(21273,1402),(21274,1402),(21275,1402),(21276,1402),(21277,1402),(21278,1403),(21279,1403),(21280,1403),(21281,1403),(21282,1403),(21283,1403),(21284,1404),(21285,1404),(21286,1404),(21287,1404),(21288,1404),(21289,1404),(21290,1405),(21291,1405),(21292,1405),(21293,1405),(21294,1405),(21295,1405),(21296,1406),(21297,1406),(21298,1406),(21299,1406),(21300,1406),(21301,1406),(21302,1407),(21303,1407),(21304,1407),(21305,1407),(21306,1407),(21307,1407),(21308,1408),(21309,1408),(21310,1408),(21311,1408),(21312,1408),(21313,1408),(21314,1409),(21315,1409),(21316,1409),(21317,1409),(21318,1409),(21319,1409),(21320,1410),(21321,1410),(21322,1410),(21323,1410),(21324,1410),(21325,1410),(21326,1411),(21327,1411),(21328,1411),(21329,1411),(21330,1411),(21331,1411),(21332,1412),(21333,1412),(21334,1412),(21335,1412),(21336,1412),(21337,1412),(21338,1412),(21339,1412),(21340,1412),(21341,1413),(21342,1413),(21343,1413),(21344,1413),(21345,1413),(21346,1413),(21347,1414),(21348,1414),(21349,1414),(21350,1414),(21351,1414),(21352,1414),(21353,1415),(21354,1415),(21355,1415),(21356,1415),(21357,1415),(21358,1415),(21359,1416),(21360,1416),(21361,1416),(21362,1416),(21363,1416),(21364,1416),(21365,1417),(21366,1417),(21367,1417),(21368,1417),(21369,1417),(21370,1417),(21371,1418),(21372,1418),(21373,1418),(21374,1418),(21375,1418),(21376,1418),(21377,1419),(21378,1419),(21379,1419),(21380,1419),(21381,1419),(21382,1419),(21383,1420),(21384,1420),(21385,1420),(21386,1420),(21387,1420),(21388,1420),(21389,1421),(21390,1421),(21391,1421),(21392,1421),(21393,1421),(21394,1421),(21395,1422),(21396,1422),(21397,1422),(21398,1422),(21399,1422),(21400,1422),(21401,1423),(21402,1423),(21403,1423),(21404,1423),(21405,1423),(21406,1423),(21407,1424),(21408,1424),(21409,1424),(21410,1424),(21411,1424),(21412,1424),(21413,1425),(21414,1425),(21415,1425),(21416,1425),(21417,1425),(21418,1425),(21419,1426),(21420,1426),(21421,1426),(21422,1426),(21423,1426),(21424,1426),(21425,1427),(21426,1427),(21427,1427),(21428,1427),(21429,1427),(21430,1427),(21431,1428),(21432,1428),(21433,1428),(21434,1428),(21435,1428),(21436,1428),(21437,1428),(21438,1428),(21439,1428),(21440,1429),(21441,1429),(21442,1429),(21443,1429),(21444,1429),(21445,1429),(21446,1430),(21447,1430),(21448,1430),(21449,1430),(21450,1430),(21451,1430),(21452,1431),(21453,1431),(21454,1431),(21455,1431),(21456,1431),(21457,1431),(21458,1432),(21459,1432),(21460,1432),(21461,1432),(21462,1432),(21463,1432),(21464,1433),(21465,1433),(21466,1433),(21467,1433),(21468,1433),(21469,1433),(21470,1434),(21471,1434),(21472,1434),(21473,1434),(21474,1434),(21475,1434),(21476,1435),(21477,1435),(21478,1435),(21479,1435),(21480,1435),(21481,1435),(21482,1436),(21483,1436),(21484,1436),(21485,1436),(21486,1436),(21487,1436),(21488,1437),(21489,1437),(21490,1437),(21491,1437),(21492,1437),(21493,1437),(21494,1438),(21495,1438),(21496,1438),(21497,1438),(21498,1438),(21499,1438),(21500,1439),(21501,1439),(21502,1439),(21503,1439),(21504,1439),(21505,1439),(21506,1440),(21507,1440),(21508,1440),(21509,1440),(21510,1440),(21511,1440),(21512,1441),(21513,1441),(21514,1441),(21515,1441),(21516,1441),(21517,1441),(21518,1442),(21519,1442),(21520,1442),(21521,1442),(21522,1442),(21523,1442),(21524,1443),(21525,1443),(21526,1443),(21527,1443),(21528,1443),(21529,1443),(21530,1444),(21531,1444),(21532,1444),(21533,1444),(21534,1444),(21535,1444),(21536,1444),(21537,1444),(21538,1444),(21539,1445),(21540,1445),(21541,1445),(21542,1445),(21543,1445),(21544,1445),(21545,1446),(21546,1446),(21547,1446),(21548,1446),(21549,1446),(21550,1446),(21551,1347),(21552,1347),(21553,1348),(21554,1349),(21555,1349),(21556,1350),(21557,1350),(21558,1351),(21559,1351),(21560,1352),(21561,1352),(21562,1353),(21563,1353),(21564,1354),(21565,1354),(21566,1355),(21567,1355),(21568,1356),(21569,1356),(21570,1357),(21571,1357),(21572,1358),(21573,1358),(21574,1359),(21575,1359),(21576,1360),(21577,1360),(21578,1361),(21579,1361),(21580,1362),(21581,1362),(21582,1363),(21583,1363),(21584,1364),(21585,1365),(21586,1365),(21587,1366),(21588,1366),(21589,1367),(21590,1367),(21591,1368),(21592,1368),(21593,1369),(21594,1369),(21595,1370),(21596,1370),(21597,1371),(21598,1371),(21599,1372),(21600,1372),(21601,1373),(21602,1373),(21603,1374),(21604,1374),(21605,1375),(21606,1375),(21607,1376),(21608,1376),(21609,1377),(21610,1377),(21611,1378),(21612,1378),(21613,1379),(21614,1379),(21615,1380),(21616,1381),(21617,1381),(21618,1382),(21619,1382),(21620,1383),(21621,1383),(21622,1384),(21623,1384),(21624,1385),(21625,1385),(21626,1386),(21627,1386),(21628,1387),(21629,1387),(21630,1388),(21631,1388),(21632,1389),(21633,1389),(21634,1390),(21635,1390),(21636,1391),(21637,1391),(21638,1392),(21639,1392),(21640,1393),(21641,1393),(21642,1394),(21643,1394),(21644,1395),(21645,1395),(21646,1396),(21647,1397),(21648,1397),(21649,1398),(21650,1398),(21651,1399),(21652,1399),(21653,1400),(21654,1400),(21655,1401),(21656,1401),(21657,1402),(21658,1402),(21659,1403),(21660,1403),(21661,1404),(21662,1404),(21663,1405),(21664,1405),(21665,1406),(21666,1406),(21667,1407),(21668,1407),(21669,1408),(21670,1408),(21671,1409),(21672,1409),(21673,1410),(21674,1410),(21675,1411),(21676,1411),(21677,1412),(21678,1413),(21679,1413),(21680,1414),(21681,1414),(21682,1415),(21683,1415),(21684,1416),(21685,1416),(21686,1417),(21687,1417),(21688,1418),(21689,1418),(21690,1419),(21691,1419),(21692,1420),(21693,1420),(21694,1421),(21695,1421),(21696,1422),(21697,1422),(21698,1423),(21699,1423),(21700,1424),(21701,1424),(21702,1425),(21703,1425),(21704,1426),(21705,1426),(21706,1427),(21707,1427),(21708,1428),(21709,1429),(21710,1429),(21711,1430),(21712,1430),(21713,1431),(21714,1431),(21715,1432),(21716,1432),(21717,1433),(21718,1433),(21719,1434),(21720,1434),(21721,1435),(21722,1435),(21723,1436),(21724,1436),(21725,1437),(21726,1437),(21727,1438),(21728,1438),(21729,1439),(21730,1439),(21731,1440),(21732,1440),(21733,1441),(21734,1441),(21735,1442),(21736,1442),(21737,1443),(21738,1443),(21739,1444),(21740,1445),(21741,1445),(21742,1446),(21743,1446),(21744,1447),(21745,1447),(21746,1447),(21747,1447),(21748,1447),(21749,1447),(21750,1447),(21751,1448),(21752,1448),(21753,1448),(21754,1448),(21755,1448),(21756,1448),(21757,1448),(21758,1449),(21759,1449),(21760,1449),(21761,1449),(21762,1449),(21763,1449),(21764,1449),(21765,1450),(21766,1450),(21767,1450),(21768,1450),(21769,1450),(21770,1450),(21771,1450),(21772,1451),(21773,1451),(21774,1451),(21775,1451),(21776,1451),(21777,1451),(21778,1451),(21779,1452),(21780,1452),(21781,1452),(21782,1452),(21783,1452),(21784,1452),(21785,1452),(21786,1453),(21787,1453),(21788,1453),(21789,1453),(21790,1453),(21791,1453),(21792,1453),(21793,1454),(21794,1454),(21795,1454),(21796,1454),(21797,1454),(21798,1454),(21799,1454),(21800,1455),(21801,1455),(21802,1455),(21803,1455),(21804,1455),(21805,1455),(21806,1455),(21807,1456),(21808,1456),(21809,1456),(21810,1456),(21811,1456),(21812,1456),(21813,1456),(21814,1457),(21815,1457),(21816,1457),(21817,1457),(21818,1457),(21819,1457),(21820,1457),(21821,1458),(21822,1458),(21823,1458),(21824,1458),(21825,1458),(21826,1458),(21827,1458),(21828,1459),(21829,1459),(21830,1459),(21831,1459),(21832,1459),(21833,1459),(21834,1459),(21835,1460),(21836,1460),(21837,1460),(21838,1460),(21839,1460),(21840,1460),(21841,1460),(21842,1461),(21843,1461),(21844,1461),(21845,1461),(21846,1461),(21847,1461),(21848,1461),(21849,1462),(21850,1462),(21851,1462),(21852,1462),(21853,1462),(21854,1462),(21855,1462),(21856,1463),(21857,1463),(21858,1463),(21859,1463),(21860,1463),(21861,1463),(21862,1463),(21863,1464),(21864,1464),(21865,1464),(21866,1464),(21867,1464),(21868,1464),(21869,1464),(21870,1465),(21871,1465),(21872,1465),(21873,1465),(21874,1465),(21875,1465),(21876,1465),(21877,1466),(21878,1466),(21879,1466),(21880,1466),(21881,1466),(21882,1466),(21883,1466),(21884,1467),(21885,1467),(21886,1467),(21887,1467),(21888,1467),(21889,1467),(21890,1467),(21891,1468),(21892,1468),(21893,1468),(21894,1468),(21895,1468),(21896,1468),(21897,1468),(21898,1469),(21899,1469),(21900,1469),(21901,1469),(21902,1469),(21903,1469),(21904,1469),(21905,1470),(21906,1470),(21907,1470),(21908,1470),(21909,1470),(21910,1470),(21911,1470),(21912,1471),(21913,1471),(21914,1471),(21915,1471),(21916,1471),(21917,1471),(21918,1471),(21919,1472),(21920,1472),(21921,1472),(21922,1472),(21923,1472),(21924,1472),(21925,1472),(21926,1473),(21927,1473),(21928,1473),(21929,1473),(21930,1473),(21931,1473),(21932,1473),(21933,1474),(21934,1474),(21935,1474),(21936,1474),(21937,1474),(21938,1474),(21939,1474),(21940,1475),(21941,1475),(21942,1475),(21943,1475),(21944,1475),(21945,1475),(21946,1475),(21947,1476),(21948,1476),(21949,1476),(21950,1476),(21951,1476),(21952,1476),(21953,1476),(21954,1477),(21955,1477),(21956,1477),(21957,1477),(21958,1477),(21959,1477),(21960,1477),(21961,1478),(21962,1478),(21963,1478),(21964,1478),(21965,1478),(21966,1478),(21967,1478),(21968,1479),(21969,1479),(21970,1479),(21971,1479),(21972,1479),(21973,1479),(21974,1479),(21975,1480),(21976,1480),(21977,1480),(21978,1480),(21979,1480),(21980,1480),(21981,1480),(21982,1481),(21983,1481),(21984,1481),(21985,1481),(21986,1481),(21987,1481),(21988,1481),(21989,1482),(21990,1482),(21991,1482),(21992,1482),(21993,1482),(21994,1482),(21995,1482),(21996,1483),(21997,1483),(21998,1483),(21999,1483),(22000,1483),(22001,1483),(22002,1483),(22003,1484),(22004,1484),(22005,1484),(22006,1484),(22007,1484),(22008,1484),(22009,1484),(22010,1485),(22011,1485),(22012,1485),(22013,1485),(22014,1485),(22015,1485),(22016,1485),(22017,1486),(22018,1486),(22019,1486),(22020,1486),(22021,1486),(22022,1486),(22023,1486),(22024,1487),(22025,1487),(22026,1487),(22027,1487),(22028,1487),(22029,1487),(22030,1487),(22031,1488),(22032,1488),(22033,1488),(22034,1488),(22035,1488),(22036,1488),(22037,1488),(22038,1489),(22039,1489),(22040,1489),(22041,1489),(22042,1489),(22043,1489),(22044,1489),(22045,1490),(22046,1490),(22047,1490),(22048,1490),(22049,1490),(22050,1490),(22051,1490),(22052,1491),(22053,1491),(22054,1491),(22055,1491),(22056,1491),(22057,1491),(22058,1491),(22059,1492),(22060,1492),(22061,1492),(22062,1492),(22063,1492),(22064,1492),(22065,1492),(22066,1493),(22067,1493),(22068,1493),(22069,1493),(22070,1493),(22071,1493),(22072,1493),(22073,1494),(22074,1494),(22075,1494),(22076,1494),(22077,1494),(22078,1494),(22079,1494),(22080,1495),(22081,1495),(22082,1495),(22083,1495),(22084,1495),(22085,1495),(22086,1495),(22087,1496),(22088,1496),(22089,1496),(22090,1496),(22091,1496),(22092,1496),(22093,1496),(22094,1497),(22095,1497),(22096,1497),(22097,1497),(22098,1497),(22099,1497),(22100,1497),(22101,1498),(22102,1498),(22103,1498),(22104,1498),(22105,1498),(22106,1498),(22107,1498),(22108,1499),(22109,1499),(22110,1499),(22111,1499),(22112,1499),(22113,1499),(22114,1499),(22115,1500),(22116,1500),(22117,1500),(22118,1500),(22119,1500),(22120,1500),(22121,1500),(22122,1501),(22123,1501),(22124,1501),(22125,1501),(22126,1501),(22127,1501),(22128,1501),(22129,1502),(22130,1502),(22131,1502),(22132,1502),(22133,1502),(22134,1502),(22135,1502),(22136,1503),(22137,1503),(22138,1503),(22139,1503),(22140,1503),(22141,1503),(22142,1503),(22143,1504),(22144,1504),(22145,1504),(22146,1504),(22147,1504),(22148,1504),(22149,1504),(22150,1505),(22151,1505),(22152,1505),(22153,1505),(22154,1505),(22155,1505),(22156,1505),(22157,1506),(22158,1506),(22159,1506),(22160,1506),(22161,1506),(22162,1506),(22163,1506),(22164,1507),(22165,1507),(22166,1507),(22167,1507),(22168,1507),(22169,1507),(22170,1507),(22171,1508),(22172,1508),(22173,1508),(22174,1508),(22175,1508),(22176,1508),(22177,1508),(22178,1509),(22179,1509),(22180,1509),(22181,1509),(22182,1509),(22183,1509),(22184,1509),(22185,1510),(22186,1510),(22187,1510),(22188,1510),(22189,1510),(22190,1510),(22191,1510),(22192,1511),(22193,1511),(22194,1511),(22195,1511),(22196,1511),(22197,1511),(22198,1511),(22199,1512),(22200,1512),(22201,1512),(22202,1512),(22203,1512),(22204,1512),(22205,1512),(22206,1513),(22207,1513),(22208,1513),(22209,1513),(22210,1513),(22211,1513),(22212,1513),(22213,1514),(22214,1514),(22215,1514),(22216,1514),(22217,1514),(22218,1514),(22219,1514),(22220,1515),(22221,1515),(22222,1515),(22223,1515),(22224,1515),(22225,1515),(22226,1515),(22227,1516),(22228,1516),(22229,1516),(22230,1516),(22231,1516),(22232,1516),(22233,1516),(22234,1517),(22235,1517),(22236,1517),(22237,1517),(22238,1517),(22239,1517),(22240,1517),(22241,1518),(22242,1518),(22243,1518),(22244,1518),(22245,1518),(22246,1518),(22247,1518),(22248,1519),(22249,1519),(22250,1519),(22251,1519),(22252,1519),(22253,1519),(22254,1519),(22255,1520),(22256,1520),(22257,1520),(22258,1520),(22259,1520),(22260,1520),(22261,1520),(22262,1521),(22263,1521),(22264,1521),(22265,1521),(22266,1521),(22267,1521),(22268,1521),(22269,1522),(22270,1522),(22271,1522),(22272,1522),(22273,1522),(22274,1522),(22275,1522),(22276,1523),(22277,1523),(22278,1523),(22279,1523),(22280,1523),(22281,1523),(22282,1523),(22283,1524),(22284,1524),(22285,1524),(22286,1524),(22287,1524),(22288,1524),(22289,1524),(22290,1525),(22291,1525),(22292,1525),(22293,1525),(22294,1525),(22295,1525),(22296,1525),(22297,1526),(22298,1526),(22299,1526),(22300,1526),(22301,1526),(22302,1526),(22303,1526),(22304,1527),(22305,1527),(22306,1527),(22307,1527),(22308,1527),(22309,1527),(22310,1527),(22311,1528),(22312,1528),(22313,1528),(22314,1528),(22315,1528),(22316,1528),(22317,1528),(22318,1529),(22319,1529),(22320,1529),(22321,1529),(22322,1529),(22323,1529),(22324,1529),(22325,1530),(22326,1530),(22327,1530),(22328,1530),(22329,1530),(22330,1530),(22331,1530),(22332,1531),(22333,1531),(22334,1531),(22335,1531),(22336,1531),(22337,1531),(22338,1531),(22339,1532),(22340,1532),(22341,1532),(22342,1532),(22343,1532),(22344,1532),(22345,1532),(22346,1533),(22347,1533),(22348,1533),(22349,1533),(22350,1533),(22351,1533),(22352,1533),(22353,1534),(22354,1534),(22355,1534),(22356,1534),(22357,1534),(22358,1534),(22359,1534),(22360,1535),(22361,1535),(22362,1535),(22363,1535),(22364,1535),(22365,1535),(22366,1535),(22367,1536),(22368,1536),(22369,1536),(22370,1536),(22371,1536),(22372,1536),(22373,1536),(22374,1537),(22375,1537),(22376,1537),(22377,1537),(22378,1537),(22379,1537),(22380,1537),(22381,1538),(22382,1538),(22383,1538),(22384,1538),(22385,1538),(22386,1538),(22387,1538),(22388,1539),(22389,1539),(22390,1539),(22391,1539),(22392,1539),(22393,1539),(22394,1539),(22395,1540),(22396,1540),(22397,1540),(22398,1540),(22399,1540),(22400,1540),(22401,1540),(22402,1541),(22403,1541),(22404,1541),(22405,1541),(22406,1541),(22407,1541),(22408,1541),(22409,1542),(22410,1542),(22411,1542),(22412,1542),(22413,1542),(22414,1542),(22415,1542),(22416,1543),(22417,1543),(22418,1543),(22419,1543),(22420,1543),(22421,1543),(22422,1543),(22423,1544),(22424,1544),(22425,1544),(22426,1544),(22427,1544),(22428,1544),(22429,1544),(22430,1545),(22431,1545),(22432,1545),(22433,1545),(22434,1545),(22435,1545),(22436,1545),(22437,1546),(22438,1546),(22439,1546),(22440,1546),(22441,1546),(22442,1546),(22443,1546),(22444,1447),(22445,1447),(22446,1447),(22447,1447),(22448,1447),(22449,1447),(22450,1448),(22451,1448),(22452,1448),(22453,1448),(22454,1448),(22455,1448),(22456,1449),(22457,1449),(22458,1449),(22459,1449),(22460,1449),(22461,1449),(22462,1450),(22463,1450),(22464,1450),(22465,1450),(22466,1450),(22467,1450),(22468,1451),(22469,1451),(22470,1451),(22471,1451),(22472,1451),(22473,1451),(22474,1452),(22475,1452),(22476,1452),(22477,1452),(22478,1452),(22479,1452),(22480,1453),(22481,1453),(22482,1453),(22483,1453),(22484,1453),(22485,1453),(22486,1454),(22487,1454),(22488,1454),(22489,1454),(22490,1454),(22491,1454),(22492,1455),(22493,1455),(22494,1455),(22495,1455),(22496,1455),(22497,1455),(22498,1456),(22499,1456),(22500,1456),(22501,1456),(22502,1456),(22503,1456),(22504,1457),(22505,1457),(22506,1457),(22507,1457),(22508,1457),(22509,1457),(22510,1458),(22511,1458),(22512,1458),(22513,1458),(22514,1458),(22515,1458),(22516,1459),(22517,1459),(22518,1459),(22519,1459),(22520,1459),(22521,1459),(22522,1460),(22523,1460),(22524,1460),(22525,1460),(22526,1460),(22527,1460),(22528,1460),(22529,1460),(22530,1460),(22531,1461),(22532,1461),(22533,1461),(22534,1461),(22535,1461),(22536,1461),(22537,1462),(22538,1462),(22539,1462),(22540,1462),(22541,1462),(22542,1462),(22543,1463),(22544,1463),(22545,1463),(22546,1463),(22547,1463),(22548,1463),(22549,1464),(22550,1464),(22551,1464),(22552,1464),(22553,1464),(22554,1464),(22555,1465),(22556,1465),(22557,1465),(22558,1465),(22559,1465),(22560,1465),(22561,1466),(22562,1466),(22563,1466),(22564,1466),(22565,1466),(22566,1466),(22567,1467),(22568,1467),(22569,1467),(22570,1467),(22571,1467),(22572,1467),(22573,1468),(22574,1468),(22575,1468),(22576,1468),(22577,1468),(22578,1468),(22579,1469),(22580,1469),(22581,1469),(22582,1469),(22583,1469),(22584,1469),(22585,1470),(22586,1470),(22587,1470),(22588,1470),(22589,1470),(22590,1470),(22591,1471),(22592,1471),(22593,1471),(22594,1471),(22595,1471),(22596,1471),(22597,1472),(22598,1472),(22599,1472),(22600,1472),(22601,1472),(22602,1472),(22603,1473),(22604,1473),(22605,1473),(22606,1473),(22607,1473),(22608,1473),(22609,1474),(22610,1474),(22611,1474),(22612,1474),(22613,1474),(22614,1474),(22615,1475),(22616,1475),(22617,1475),(22618,1475),(22619,1475),(22620,1475),(22621,1476),(22622,1476),(22623,1476),(22624,1476),(22625,1476),(22626,1476),(22627,1476),(22628,1476),(22629,1476),(22630,1477),(22631,1477),(22632,1477),(22633,1477),(22634,1477),(22635,1477),(22636,1478),(22637,1478),(22638,1478),(22639,1478),(22640,1478),(22641,1478),(22642,1479),(22643,1479),(22644,1479),(22645,1479),(22646,1479),(22647,1479),(22648,1480),(22649,1480),(22650,1480),(22651,1480),(22652,1480),(22653,1480),(22654,1481),(22655,1481),(22656,1481),(22657,1481),(22658,1481),(22659,1481),(22660,1482),(22661,1482),(22662,1482),(22663,1482),(22664,1482),(22665,1482),(22666,1483),(22667,1483),(22668,1483),(22669,1483),(22670,1483),(22671,1483),(22672,1484),(22673,1484),(22674,1484),(22675,1484),(22676,1484),(22677,1484),(22678,1485),(22679,1485),(22680,1485),(22681,1485),(22682,1485),(22683,1485),(22684,1486),(22685,1486),(22686,1486),(22687,1486),(22688,1486),(22689,1486),(22690,1487),(22691,1487),(22692,1487),(22693,1487),(22694,1487),(22695,1487),(22696,1488),(22697,1488),(22698,1488),(22699,1488),(22700,1488),(22701,1488),(22702,1489),(22703,1489),(22704,1489),(22705,1489),(22706,1489),(22707,1489),(22708,1490),(22709,1490),(22710,1490),(22711,1490),(22712,1490),(22713,1490),(22714,1491),(22715,1491),(22716,1491),(22717,1491),(22718,1491),(22719,1491),(22720,1492),(22721,1492),(22722,1492),(22723,1492),(22724,1492),(22725,1492),(22726,1492),(22727,1492),(22728,1492),(22729,1493),(22730,1493),(22731,1493),(22732,1493),(22733,1493),(22734,1493),(22735,1494),(22736,1494),(22737,1494),(22738,1494),(22739,1494),(22740,1494),(22741,1495),(22742,1495),(22743,1495),(22744,1495),(22745,1495),(22746,1495),(22747,1496),(22748,1496),(22749,1496),(22750,1496),(22751,1496),(22752,1496),(22753,1497),(22754,1497),(22755,1497),(22756,1497),(22757,1497),(22758,1497),(22759,1498),(22760,1498),(22761,1498),(22762,1498),(22763,1498),(22764,1498),(22765,1499),(22766,1499),(22767,1499),(22768,1499),(22769,1499),(22770,1499),(22771,1500),(22772,1500),(22773,1500),(22774,1500),(22775,1500),(22776,1500),(22777,1501),(22778,1501),(22779,1501),(22780,1501),(22781,1501),(22782,1501),(22783,1502),(22784,1502),(22785,1502),(22786,1502),(22787,1502),(22788,1502),(22789,1503),(22790,1503),(22791,1503),(22792,1503),(22793,1503),(22794,1503),(22795,1504),(22796,1504),(22797,1504),(22798,1504),(22799,1504),(22800,1504),(22801,1505),(22802,1505),(22803,1505),(22804,1505),(22805,1505),(22806,1505),(22807,1506),(22808,1506),(22809,1506),(22810,1506),(22811,1506),(22812,1506),(22813,1507),(22814,1507),(22815,1507),(22816,1507),(22817,1507),(22818,1507),(22819,1508),(22820,1508),(22821,1508),(22822,1508),(22823,1508),(22824,1508),(22825,1508),(22826,1508),(22827,1508),(22828,1509),(22829,1509),(22830,1509),(22831,1509),(22832,1509),(22833,1509),(22834,1510),(22835,1510),(22836,1510),(22837,1510),(22838,1510),(22839,1510),(22840,1511),(22841,1511),(22842,1511),(22843,1511),(22844,1511),(22845,1511),(22846,1512),(22847,1512),(22848,1512),(22849,1512),(22850,1512),(22851,1512),(22852,1513),(22853,1513),(22854,1513),(22855,1513),(22856,1513),(22857,1513),(22858,1514),(22859,1514),(22860,1514),(22861,1514),(22862,1514),(22863,1514),(22864,1515),(22865,1515),(22866,1515),(22867,1515),(22868,1515),(22869,1515),(22870,1516),(22871,1516),(22872,1516),(22873,1516),(22874,1516),(22875,1516),(22876,1517),(22877,1517),(22878,1517),(22879,1517),(22880,1517),(22881,1517),(22882,1518),(22883,1518),(22884,1518),(22885,1518),(22886,1518),(22887,1518),(22888,1519),(22889,1519),(22890,1519),(22891,1519),(22892,1519),(22893,1519),(22894,1520),(22895,1520),(22896,1520),(22897,1520),(22898,1520),(22899,1520),(22900,1521),(22901,1521),(22902,1521),(22903,1521),(22904,1521),(22905,1521),(22906,1522),(22907,1522),(22908,1522),(22909,1522),(22910,1522),(22911,1522),(22912,1523),(22913,1523),(22914,1523),(22915,1523),(22916,1523),(22917,1523),(22918,1524),(22919,1524),(22920,1524),(22921,1524),(22922,1524),(22923,1524),(22924,1524),(22925,1524),(22926,1524),(22927,1525),(22928,1525),(22929,1525),(22930,1525),(22931,1525),(22932,1525),(22933,1526),(22934,1526),(22935,1526),(22936,1526),(22937,1526),(22938,1526),(22939,1527),(22940,1527),(22941,1527),(22942,1527),(22943,1527),(22944,1527),(22945,1528),(22946,1528),(22947,1528),(22948,1528),(22949,1528),(22950,1528),(22951,1529),(22952,1529),(22953,1529),(22954,1529),(22955,1529),(22956,1529),(22957,1530),(22958,1530),(22959,1530),(22960,1530),(22961,1530),(22962,1530),(22963,1531),(22964,1531),(22965,1531),(22966,1531),(22967,1531),(22968,1531),(22969,1532),(22970,1532),(22971,1532),(22972,1532),(22973,1532),(22974,1532),(22975,1533),(22976,1533),(22977,1533),(22978,1533),(22979,1533),(22980,1533),(22981,1534),(22982,1534),(22983,1534),(22984,1534),(22985,1534),(22986,1534),(22987,1535),(22988,1535),(22989,1535),(22990,1535),(22991,1535),(22992,1535),(22993,1536),(22994,1536),(22995,1536),(22996,1536),(22997,1536),(22998,1536),(22999,1537),(23000,1537),(23001,1537),(23002,1537),(23003,1537),(23004,1537),(23005,1538),(23006,1538),(23007,1538),(23008,1538),(23009,1538),(23010,1538),(23011,1539),(23012,1539),(23013,1539),(23014,1539),(23015,1539),(23016,1539),(23017,1540),(23018,1540),(23019,1540),(23020,1540),(23021,1540),(23022,1540),(23023,1540),(23024,1540),(23025,1540),(23026,1541),(23027,1541),(23028,1541),(23029,1541),(23030,1541),(23031,1541),(23032,1542),(23033,1542),(23034,1542),(23035,1542),(23036,1542),(23037,1542),(23038,1543),(23039,1543),(23040,1543),(23041,1543),(23042,1543),(23043,1543),(23044,1544),(23045,1544),(23046,1544),(23047,1544),(23048,1544),(23049,1544),(23050,1545),(23051,1545),(23052,1545),(23053,1545),(23054,1545),(23055,1545),(23056,1546),(23057,1546),(23058,1546),(23059,1546),(23060,1546),(23061,1546),(23062,1447),(23063,1447),(23064,1448),(23065,1448),(23066,1449),(23067,1449),(23068,1450),(23069,1450),(23070,1451),(23071,1451),(23072,1452),(23073,1452),(23074,1453),(23075,1453),(23076,1454),(23077,1454),(23078,1455),(23079,1455),(23080,1456),(23081,1456),(23082,1457),(23083,1457),(23084,1458),(23085,1458),(23086,1459),(23087,1459),(23088,1460),(23089,1461),(23090,1461),(23091,1462),(23092,1462),(23093,1463),(23094,1463),(23095,1464),(23096,1464),(23097,1465),(23098,1465),(23099,1466),(23100,1466),(23101,1467),(23102,1467),(23103,1468),(23104,1468),(23105,1469),(23106,1469),(23107,1470),(23108,1470),(23109,1471),(23110,1471),(23111,1472),(23112,1472),(23113,1473),(23114,1473),(23115,1474),(23116,1474),(23117,1475),(23118,1475),(23119,1476),(23120,1477),(23121,1477),(23122,1478),(23123,1478),(23124,1479),(23125,1479),(23126,1480),(23127,1480),(23128,1481),(23129,1481),(23130,1482),(23131,1482),(23132,1483),(23133,1483),(23134,1484),(23135,1484),(23136,1485),(23137,1485),(23138,1486),(23139,1486),(23140,1487),(23141,1487),(23142,1488),(23143,1488),(23144,1489),(23145,1489),(23146,1490),(23147,1490),(23148,1491),(23149,1491),(23150,1492),(23151,1493),(23152,1493),(23153,1494),(23154,1494),(23155,1495),(23156,1495),(23157,1496),(23158,1496),(23159,1497),(23160,1497),(23161,1498),(23162,1498),(23163,1499),(23164,1499),(23165,1500),(23166,1500),(23167,1501),(23168,1501),(23169,1502),(23170,1502),(23171,1503),(23172,1503),(23173,1504),(23174,1504),(23175,1505),(23176,1505),(23177,1506),(23178,1506),(23179,1507),(23180,1507),(23181,1508),(23182,1509),(23183,1509),(23184,1510),(23185,1510),(23186,1511),(23187,1511),(23188,1512),(23189,1512),(23190,1513),(23191,1513),(23192,1514),(23193,1514),(23194,1515),(23195,1515),(23196,1516),(23197,1516),(23198,1517),(23199,1517),(23200,1518),(23201,1518),(23202,1519),(23203,1519),(23204,1520),(23205,1520),(23206,1521),(23207,1521),(23208,1522),(23209,1522),(23210,1523),(23211,1523),(23212,1524),(23213,1525),(23214,1525),(23215,1526),(23216,1526),(23217,1527),(23218,1527),(23219,1528),(23220,1528),(23221,1529),(23222,1529),(23223,1530),(23224,1530),(23225,1531),(23226,1531),(23227,1532),(23228,1532),(23229,1533),(23230,1533),(23231,1534),(23232,1534),(23233,1535),(23234,1535),(23235,1536),(23236,1536),(23237,1537),(23238,1537),(23239,1538),(23240,1538),(23241,1539),(23242,1539),(23243,1540),(23244,1541),(23245,1541),(23246,1542),(23247,1542),(23248,1543),(23249,1543),(23250,1544),(23251,1544),(23252,1545),(23253,1545),(23254,1546),(23255,1546),(23256,1547),(23257,1547),(23258,1547),(23259,1547),(23260,1547),(23261,1547),(23262,1547),(23263,1548),(23264,1548),(23265,1548),(23266,1548),(23267,1548),(23268,1548),(23269,1548),(23270,1549),(23271,1549),(23272,1549),(23273,1549),(23274,1549),(23275,1549),(23276,1549),(23277,1550),(23278,1550),(23279,1550),(23280,1550),(23281,1550),(23282,1550),(23283,1550),(23284,1551),(23285,1551),(23286,1551),(23287,1551),(23288,1551),(23289,1551),(23290,1551),(23291,1552),(23292,1552),(23293,1552),(23294,1552),(23295,1552),(23296,1552),(23297,1552),(23298,1553),(23299,1553),(23300,1553),(23301,1553),(23302,1553),(23303,1553),(23304,1553),(23305,1554),(23306,1554),(23307,1554),(23308,1554),(23309,1554),(23310,1554),(23311,1554),(23312,1555),(23313,1555),(23314,1555),(23315,1555),(23316,1555),(23317,1555),(23318,1555),(23319,1556),(23320,1556),(23321,1556),(23322,1556),(23323,1556),(23324,1556),(23325,1556),(23326,1557),(23327,1557),(23328,1557),(23329,1557),(23330,1557),(23331,1557),(23332,1557),(23333,1558),(23334,1558),(23335,1558),(23336,1558),(23337,1558),(23338,1558),(23339,1558),(23340,1559),(23341,1559),(23342,1559),(23343,1559),(23344,1559),(23345,1559),(23346,1559),(23347,1560),(23348,1560),(23349,1560),(23350,1560),(23351,1560),(23352,1560),(23353,1560),(23354,1561),(23355,1561),(23356,1561),(23357,1561),(23358,1561),(23359,1561),(23360,1561),(23361,1562),(23362,1562),(23363,1562),(23364,1562),(23365,1562),(23366,1562),(23367,1562),(23368,1563),(23369,1563),(23370,1563),(23371,1563),(23372,1563),(23373,1563),(23374,1563),(23375,1564),(23376,1564),(23377,1564),(23378,1564),(23379,1564),(23380,1564),(23381,1564),(23382,1565),(23383,1565),(23384,1565),(23385,1565),(23386,1565),(23387,1565),(23388,1565),(23389,1566),(23390,1566),(23391,1566),(23392,1566),(23393,1566),(23394,1566),(23395,1566),(23396,1567),(23397,1567),(23398,1567),(23399,1567),(23400,1567),(23401,1567),(23402,1567),(23403,1568),(23404,1568),(23405,1568),(23406,1568),(23407,1568),(23408,1568),(23409,1568),(23410,1569),(23411,1569),(23412,1569),(23413,1569),(23414,1569),(23415,1569),(23416,1569),(23417,1570),(23418,1570),(23419,1570),(23420,1570),(23421,1570),(23422,1570),(23423,1570),(23424,1571),(23425,1571),(23426,1571),(23427,1571),(23428,1571),(23429,1571),(23430,1571),(23431,1572),(23432,1572),(23433,1572),(23434,1572),(23435,1572),(23436,1572),(23437,1572),(23438,1573),(23439,1573),(23440,1573),(23441,1573),(23442,1573),(23443,1573),(23444,1573),(23445,1574),(23446,1574),(23447,1574),(23448,1574),(23449,1574),(23450,1574),(23451,1574),(23452,1575),(23453,1575),(23454,1575),(23455,1575),(23456,1575),(23457,1575),(23458,1575),(23459,1576),(23460,1576),(23461,1576),(23462,1576),(23463,1576),(23464,1576),(23465,1576),(23466,1577),(23467,1577),(23468,1577),(23469,1577),(23470,1577),(23471,1577),(23472,1577),(23473,1578),(23474,1578),(23475,1578),(23476,1578),(23477,1578),(23478,1578),(23479,1578),(23480,1579),(23481,1579),(23482,1579),(23483,1579),(23484,1579),(23485,1579),(23486,1579),(23487,1580),(23488,1580),(23489,1580),(23490,1580),(23491,1580),(23492,1580),(23493,1580),(23494,1581),(23495,1581),(23496,1581),(23497,1581),(23498,1581),(23499,1581),(23500,1581),(23501,1582),(23502,1582),(23503,1582),(23504,1582),(23505,1582),(23506,1582),(23507,1582),(23508,1583),(23509,1583),(23510,1583),(23511,1583),(23512,1583),(23513,1583),(23514,1583),(23515,1584),(23516,1584),(23517,1584),(23518,1584),(23519,1584),(23520,1584),(23521,1584),(23522,1585),(23523,1585),(23524,1585),(23525,1585),(23526,1585),(23527,1585),(23528,1585),(23529,1586),(23530,1586),(23531,1586),(23532,1586),(23533,1586),(23534,1586),(23535,1586),(23536,1587),(23537,1587),(23538,1587),(23539,1587),(23540,1587),(23541,1587),(23542,1587),(23543,1588),(23544,1588),(23545,1588),(23546,1588),(23547,1588),(23548,1588),(23549,1588),(23550,1589),(23551,1589),(23552,1589),(23553,1589),(23554,1589),(23555,1589),(23556,1589),(23557,1590),(23558,1590),(23559,1590),(23560,1590),(23561,1590),(23562,1590),(23563,1590),(23564,1591),(23565,1591),(23566,1591),(23567,1591),(23568,1591),(23569,1591),(23570,1591),(23571,1592),(23572,1592),(23573,1592),(23574,1592),(23575,1592),(23576,1592),(23577,1592),(23578,1593),(23579,1593),(23580,1593),(23581,1593),(23582,1593),(23583,1593),(23584,1593),(23585,1594),(23586,1594),(23587,1594),(23588,1594),(23589,1594),(23590,1594),(23591,1594),(23592,1595),(23593,1595),(23594,1595),(23595,1595),(23596,1595),(23597,1595),(23598,1595),(23599,1596),(23600,1596),(23601,1596),(23602,1596),(23603,1596),(23604,1596),(23605,1596),(23606,1597),(23607,1597),(23608,1597),(23609,1597),(23610,1597),(23611,1597),(23612,1597),(23613,1598),(23614,1598),(23615,1598),(23616,1598),(23617,1598),(23618,1598),(23619,1598),(23620,1599),(23621,1599),(23622,1599),(23623,1599),(23624,1599),(23625,1599),(23626,1599),(23627,1600),(23628,1600),(23629,1600),(23630,1600),(23631,1600),(23632,1600),(23633,1600),(23634,1601),(23635,1601),(23636,1601),(23637,1601),(23638,1601),(23639,1601),(23640,1601),(23641,1602),(23642,1602),(23643,1602),(23644,1602),(23645,1602),(23646,1602),(23647,1602),(23648,1603),(23649,1603),(23650,1603),(23651,1603),(23652,1603),(23653,1603),(23654,1603),(23655,1604),(23656,1604),(23657,1604),(23658,1604),(23659,1604),(23660,1604),(23661,1604),(23662,1605),(23663,1605),(23664,1605),(23665,1605),(23666,1605),(23667,1605),(23668,1605),(23669,1606),(23670,1606),(23671,1606),(23672,1606),(23673,1606),(23674,1606),(23675,1606),(23676,1607),(23677,1607),(23678,1607),(23679,1607),(23680,1607),(23681,1607),(23682,1607),(23683,1608),(23684,1608),(23685,1608),(23686,1608),(23687,1608),(23688,1608),(23689,1608),(23690,1609),(23691,1609),(23692,1609),(23693,1609),(23694,1609),(23695,1609),(23696,1609),(23697,1610),(23698,1610),(23699,1610),(23700,1610),(23701,1610),(23702,1610),(23703,1610),(23704,1611),(23705,1611),(23706,1611),(23707,1611),(23708,1611),(23709,1611),(23710,1611),(23711,1612),(23712,1612),(23713,1612),(23714,1612),(23715,1612),(23716,1612),(23717,1612),(23718,1613),(23719,1613),(23720,1613),(23721,1613),(23722,1613),(23723,1613),(23724,1613),(23725,1614),(23726,1614),(23727,1614),(23728,1614),(23729,1614),(23730,1614),(23731,1614),(23732,1615),(23733,1615),(23734,1615),(23735,1615),(23736,1615),(23737,1615),(23738,1615),(23739,1616),(23740,1616),(23741,1616),(23742,1616),(23743,1616),(23744,1616),(23745,1616),(23746,1617),(23747,1617),(23748,1617),(23749,1617),(23750,1617),(23751,1617),(23752,1617),(23753,1618),(23754,1618),(23755,1618),(23756,1618),(23757,1618),(23758,1618),(23759,1618),(23760,1619),(23761,1619),(23762,1619),(23763,1619),(23764,1619),(23765,1619),(23766,1619),(23767,1620),(23768,1620),(23769,1620),(23770,1620),(23771,1620),(23772,1620),(23773,1620),(23774,1621),(23775,1621),(23776,1621),(23777,1621),(23778,1621),(23779,1621),(23780,1621),(23781,1622),(23782,1622),(23783,1622),(23784,1622),(23785,1622),(23786,1622),(23787,1622),(23788,1623),(23789,1623),(23790,1623),(23791,1623),(23792,1623),(23793,1623),(23794,1623),(23795,1624),(23796,1624),(23797,1624),(23798,1624),(23799,1624),(23800,1624),(23801,1624),(23802,1625),(23803,1625),(23804,1625),(23805,1625),(23806,1625),(23807,1625),(23808,1625),(23809,1626),(23810,1626),(23811,1626),(23812,1626),(23813,1626),(23814,1626),(23815,1626),(23816,1627),(23817,1627),(23818,1627),(23819,1627),(23820,1627),(23821,1627),(23822,1627),(23823,1628),(23824,1628),(23825,1628),(23826,1628),(23827,1628),(23828,1628),(23829,1628),(23830,1629),(23831,1629),(23832,1629),(23833,1629),(23834,1629),(23835,1629),(23836,1629),(23837,1630),(23838,1630),(23839,1630),(23840,1630),(23841,1630),(23842,1630),(23843,1630),(23844,1631),(23845,1631),(23846,1631),(23847,1631),(23848,1631),(23849,1631),(23850,1631),(23851,1632),(23852,1632),(23853,1632),(23854,1632),(23855,1632),(23856,1632),(23857,1632),(23858,1633),(23859,1633),(23860,1633),(23861,1633),(23862,1633),(23863,1633),(23864,1633),(23865,1634),(23866,1634),(23867,1634),(23868,1634),(23869,1634),(23870,1634),(23871,1634),(23872,1635),(23873,1635),(23874,1635),(23875,1635),(23876,1635),(23877,1635),(23878,1635),(23879,1636),(23880,1636),(23881,1636),(23882,1636),(23883,1636),(23884,1636),(23885,1636),(23886,1637),(23887,1637),(23888,1637),(23889,1637),(23890,1637),(23891,1637),(23892,1637),(23893,1638),(23894,1638),(23895,1638),(23896,1638),(23897,1638),(23898,1638),(23899,1638),(23900,1639),(23901,1639),(23902,1639),(23903,1639),(23904,1639),(23905,1639),(23906,1639),(23907,1640),(23908,1640),(23909,1640),(23910,1640),(23911,1640),(23912,1640),(23913,1640),(23914,1641),(23915,1641),(23916,1641),(23917,1641),(23918,1641),(23919,1641),(23920,1641),(23921,1642),(23922,1642),(23923,1642),(23924,1642),(23925,1642),(23926,1642),(23927,1642),(23928,1643),(23929,1643),(23930,1643),(23931,1643),(23932,1643),(23933,1643),(23934,1643),(23935,1644),(23936,1644),(23937,1644),(23938,1644),(23939,1644),(23940,1644),(23941,1644),(23942,1645),(23943,1645),(23944,1645),(23945,1645),(23946,1645),(23947,1645),(23948,1645),(23949,1646),(23950,1646),(23951,1646),(23952,1646),(23953,1646),(23954,1646),(23955,1646),(23956,1547),(23957,1547),(23958,1547),(23959,1547),(23960,1547),(23961,1547),(23962,1548),(23963,1548),(23964,1548),(23965,1548),(23966,1548),(23967,1548),(23968,1549),(23969,1549),(23970,1549),(23971,1549),(23972,1549),(23973,1549),(23974,1550),(23975,1550),(23976,1550),(23977,1550),(23978,1550),(23979,1550),(23980,1551),(23981,1551),(23982,1551),(23983,1551),(23984,1551),(23985,1551),(23986,1552),(23987,1552),(23988,1552),(23989,1552),(23990,1552),(23991,1552),(23992,1553),(23993,1553),(23994,1553),(23995,1553),(23996,1553),(23997,1553),(23998,1554),(23999,1554),(24000,1554),(24001,1554),(24002,1554),(24003,1554),(24004,1555),(24005,1555),(24006,1555),(24007,1555),(24008,1555),(24009,1555),(24010,1556),(24011,1556),(24012,1556),(24013,1556),(24014,1556),(24015,1556),(24016,1556),(24017,1556),(24018,1556),(24019,1557),(24020,1557),(24021,1557),(24022,1557),(24023,1557),(24024,1557),(24025,1558),(24026,1558),(24027,1558),(24028,1558),(24029,1558),(24030,1558),(24031,1559),(24032,1559),(24033,1559),(24034,1559),(24035,1559),(24036,1559),(24037,1560),(24038,1560),(24039,1560),(24040,1560),(24041,1560),(24042,1560),(24043,1561),(24044,1561),(24045,1561),(24046,1561),(24047,1561),(24048,1561),(24049,1562),(24050,1562),(24051,1562),(24052,1562),(24053,1562),(24054,1562),(24055,1563),(24056,1563),(24057,1563),(24058,1563),(24059,1563),(24060,1563),(24061,1564),(24062,1564),(24063,1564),(24064,1564),(24065,1564),(24066,1564),(24067,1565),(24068,1565),(24069,1565),(24070,1565),(24071,1565),(24072,1565),(24073,1566),(24074,1566),(24075,1566),(24076,1566),(24077,1566),(24078,1566),(24079,1567),(24080,1567),(24081,1567),(24082,1567),(24083,1567),(24084,1567),(24085,1568),(24086,1568),(24087,1568),(24088,1568),(24089,1568),(24090,1568),(24091,1569),(24092,1569),(24093,1569),(24094,1569),(24095,1569),(24096,1569),(24097,1570),(24098,1570),(24099,1570),(24100,1570),(24101,1570),(24102,1570),(24103,1571),(24104,1571),(24105,1571),(24106,1571),(24107,1571),(24108,1571),(24109,1572),(24110,1572),(24111,1572),(24112,1572),(24113,1572),(24114,1572),(24115,1572),(24116,1572),(24117,1572),(24118,1573),(24119,1573),(24120,1573),(24121,1573),(24122,1573),(24123,1573),(24124,1574),(24125,1574),(24126,1574),(24127,1574),(24128,1574),(24129,1574),(24130,1575),(24131,1575),(24132,1575),(24133,1575),(24134,1575),(24135,1575),(24136,1576),(24137,1576),(24138,1576),(24139,1576),(24140,1576),(24141,1576),(24142,1577),(24143,1577),(24144,1577),(24145,1577),(24146,1577),(24147,1577),(24148,1578),(24149,1578),(24150,1578),(24151,1578),(24152,1578),(24153,1578),(24154,1579),(24155,1579),(24156,1579),(24157,1579),(24158,1579),(24159,1579),(24160,1580),(24161,1580),(24162,1580),(24163,1580),(24164,1580),(24165,1580),(24166,1581),(24167,1581),(24168,1581),(24169,1581),(24170,1581),(24171,1581),(24172,1582),(24173,1582),(24174,1582),(24175,1582),(24176,1582),(24177,1582),(24178,1583),(24179,1583),(24180,1583),(24181,1583),(24182,1583),(24183,1583),(24184,1584),(24185,1584),(24186,1584),(24187,1584),(24188,1584),(24189,1584),(24190,1585),(24191,1585),(24192,1585),(24193,1585),(24194,1585),(24195,1585),(24196,1586),(24197,1586),(24198,1586),(24199,1586),(24200,1586),(24201,1586),(24202,1587),(24203,1587),(24204,1587),(24205,1587),(24206,1587),(24207,1587),(24208,1588),(24209,1588),(24210,1588),(24211,1588),(24212,1588),(24213,1588),(24214,1588),(24215,1588),(24216,1588),(24217,1589),(24218,1589),(24219,1589),(24220,1589),(24221,1589),(24222,1589),(24223,1590),(24224,1590),(24225,1590),(24226,1590),(24227,1590),(24228,1590),(24229,1591),(24230,1591),(24231,1591),(24232,1591),(24233,1591),(24234,1591),(24235,1592),(24236,1592),(24237,1592),(24238,1592),(24239,1592),(24240,1592),(24241,1593),(24242,1593),(24243,1593),(24244,1593),(24245,1593),(24246,1593),(24247,1594),(24248,1594),(24249,1594),(24250,1594),(24251,1594),(24252,1594),(24253,1595),(24254,1595),(24255,1595),(24256,1595),(24257,1595),(24258,1595),(24259,1596),(24260,1596),(24261,1596),(24262,1596),(24263,1596),(24264,1596),(24265,1597),(24266,1597),(24267,1597),(24268,1597),(24269,1597),(24270,1597),(24271,1598),(24272,1598),(24273,1598),(24274,1598),(24275,1598),(24276,1598),(24277,1599),(24278,1599),(24279,1599),(24280,1599),(24281,1599),(24282,1599),(24283,1600),(24284,1600),(24285,1600),(24286,1600),(24287,1600),(24288,1600),(24289,1601),(24290,1601),(24291,1601),(24292,1601),(24293,1601),(24294,1601),(24295,1602),(24296,1602),(24297,1602),(24298,1602),(24299,1602),(24300,1602),(24301,1603),(24302,1603),(24303,1603),(24304,1603),(24305,1603),(24306,1603),(24307,1604),(24308,1604),(24309,1604),(24310,1604),(24311,1604),(24312,1604),(24313,1604),(24314,1604),(24315,1604),(24316,1605),(24317,1605),(24318,1605),(24319,1605),(24320,1605),(24321,1605),(24322,1606),(24323,1606),(24324,1606),(24325,1606),(24326,1606),(24327,1606),(24328,1607),(24329,1607),(24330,1607),(24331,1607),(24332,1607),(24333,1607),(24334,1608),(24335,1608),(24336,1608),(24337,1608),(24338,1608),(24339,1608),(24340,1609),(24341,1609),(24342,1609),(24343,1609),(24344,1609),(24345,1609),(24346,1610),(24347,1610),(24348,1610),(24349,1610),(24350,1610),(24351,1610),(24352,1611),(24353,1611),(24354,1611),(24355,1611),(24356,1611),(24357,1611),(24358,1612),(24359,1612),(24360,1612),(24361,1612),(24362,1612),(24363,1612),(24364,1613),(24365,1613),(24366,1613),(24367,1613),(24368,1613),(24369,1613),(24370,1614),(24371,1614),(24372,1614),(24373,1614),(24374,1614),(24375,1614),(24376,1615),(24377,1615),(24378,1615),(24379,1615),(24380,1615),(24381,1615),(24382,1616),(24383,1616),(24384,1616),(24385,1616),(24386,1616),(24387,1616),(24388,1617),(24389,1617),(24390,1617),(24391,1617),(24392,1617),(24393,1617),(24394,1618),(24395,1618),(24396,1618),(24397,1618),(24398,1618),(24399,1618),(24400,1619),(24401,1619),(24402,1619),(24403,1619),(24404,1619),(24405,1619),(24406,1620),(24407,1620),(24408,1620),(24409,1620),(24410,1620),(24411,1620),(24412,1620),(24413,1620),(24414,1620),(24415,1621),(24416,1621),(24417,1621),(24418,1621),(24419,1621),(24420,1621),(24421,1622),(24422,1622),(24423,1622),(24424,1622),(24425,1622),(24426,1622),(24427,1623),(24428,1623),(24429,1623),(24430,1623),(24431,1623),(24432,1623),(24433,1624),(24434,1624),(24435,1624),(24436,1624),(24437,1624),(24438,1624),(24439,1625),(24440,1625),(24441,1625),(24442,1625),(24443,1625),(24444,1625),(24445,1626),(24446,1626),(24447,1626),(24448,1626),(24449,1626),(24450,1626),(24451,1627),(24452,1627),(24453,1627),(24454,1627),(24455,1627),(24456,1627),(24457,1628),(24458,1628),(24459,1628),(24460,1628),(24461,1628),(24462,1628),(24463,1629),(24464,1629),(24465,1629),(24466,1629),(24467,1629),(24468,1629),(24469,1630),(24470,1630),(24471,1630),(24472,1630),(24473,1630),(24474,1630),(24475,1631),(24476,1631),(24477,1631),(24478,1631),(24479,1631),(24480,1631),(24481,1632),(24482,1632),(24483,1632),(24484,1632),(24485,1632),(24486,1632),(24487,1633),(24488,1633),(24489,1633),(24490,1633),(24491,1633),(24492,1633),(24493,1634),(24494,1634),(24495,1634),(24496,1634),(24497,1634),(24498,1634),(24499,1635),(24500,1635),(24501,1635),(24502,1635),(24503,1635),(24504,1635),(24505,1636),(24506,1636),(24507,1636),(24508,1636),(24509,1636),(24510,1636),(24511,1636),(24512,1636),(24513,1636),(24514,1637),(24515,1637),(24516,1637),(24517,1637),(24518,1637),(24519,1637),(24520,1638),(24521,1638),(24522,1638),(24523,1638),(24524,1638),(24525,1638),(24526,1639),(24527,1639),(24528,1639),(24529,1639),(24530,1639),(24531,1639),(24532,1640),(24533,1640),(24534,1640),(24535,1640),(24536,1640),(24537,1640),(24538,1641),(24539,1641),(24540,1641),(24541,1641),(24542,1641),(24543,1641),(24544,1642),(24545,1642),(24546,1642),(24547,1642),(24548,1642),(24549,1642),(24550,1643),(24551,1643),(24552,1643),(24553,1643),(24554,1643),(24555,1643),(24556,1644),(24557,1644),(24558,1644),(24559,1644),(24560,1644),(24561,1644),(24562,1645),(24563,1645),(24564,1645),(24565,1645),(24566,1645),(24567,1645),(24568,1646),(24569,1646),(24570,1646),(24571,1646),(24572,1646),(24573,1646),(24574,1547),(24575,1547),(24576,1548),(24577,1548),(24578,1549),(24579,1549),(24580,1550),(24581,1550),(24582,1551),(24583,1551),(24584,1552),(24585,1552),(24586,1553),(24587,1553),(24588,1554),(24589,1554),(24590,1555),(24591,1555),(24592,1556),(24593,1557),(24594,1557),(24595,1558),(24596,1558),(24597,1559),(24598,1559),(24599,1560),(24600,1560),(24601,1561),(24602,1561),(24603,1562),(24604,1562),(24605,1563),(24606,1563),(24607,1564),(24608,1564),(24609,1565),(24610,1565),(24611,1566),(24612,1566),(24613,1567),(24614,1567),(24615,1568),(24616,1568),(24617,1569),(24618,1569),(24619,1570),(24620,1570),(24621,1571),(24622,1571),(24623,1572),(24624,1573),(24625,1573),(24626,1574),(24627,1574),(24628,1575),(24629,1575),(24630,1576),(24631,1576),(24632,1577),(24633,1577),(24634,1578),(24635,1578),(24636,1579),(24637,1579),(24638,1580),(24639,1580),(24640,1581),(24641,1581),(24642,1582),(24643,1582),(24644,1583),(24645,1583),(24646,1584),(24647,1584),(24648,1585),(24649,1585),(24650,1586),(24651,1586),(24652,1587),(24653,1587),(24654,1588),(24655,1589),(24656,1589),(24657,1590),(24658,1590),(24659,1591),(24660,1591),(24661,1592),(24662,1592),(24663,1593),(24664,1593),(24665,1594),(24666,1594),(24667,1595),(24668,1595),(24669,1596),(24670,1596),(24671,1597),(24672,1597),(24673,1598),(24674,1598),(24675,1599),(24676,1599),(24677,1600),(24678,1600),(24679,1601),(24680,1601),(24681,1602),(24682,1602),(24683,1603),(24684,1603),(24685,1604),(24686,1605),(24687,1605),(24688,1606),(24689,1606),(24690,1607),(24691,1607),(24692,1608),(24693,1608),(24694,1609),(24695,1609),(24696,1610),(24697,1610),(24698,1611),(24699,1611),(24700,1612),(24701,1612),(24702,1613),(24703,1613),(24704,1614),(24705,1614),(24706,1615),(24707,1615),(24708,1616),(24709,1616),(24710,1617),(24711,1617),(24712,1618),(24713,1618),(24714,1619),(24715,1619),(24716,1620),(24717,1621),(24718,1621),(24719,1622),(24720,1622),(24721,1623),(24722,1623),(24723,1624),(24724,1624),(24725,1625),(24726,1625),(24727,1626),(24728,1626),(24729,1627),(24730,1627),(24731,1628),(24732,1628),(24733,1629),(24734,1629),(24735,1630),(24736,1630),(24737,1631),(24738,1631),(24739,1632),(24740,1632),(24741,1633),(24742,1633),(24743,1634),(24744,1634),(24745,1635),(24746,1635),(24747,1636),(24748,1637),(24749,1637),(24750,1638),(24751,1638),(24752,1639),(24753,1639),(24754,1640),(24755,1640),(24756,1641),(24757,1641),(24758,1642),(24759,1642),(24760,1643),(24761,1643),(24762,1644),(24763,1644),(24764,1645),(24765,1645),(24766,1646),(24767,1646),(24768,1647),(24769,1647),(24770,1647),(24771,1647),(24772,1647),(24773,1647),(24774,1647),(24775,1648),(24776,1648),(24777,1648),(24778,1648),(24779,1648),(24780,1648),(24781,1648),(24782,1649),(24783,1649),(24784,1649),(24785,1649),(24786,1649),(24787,1649),(24788,1649),(24789,1650),(24790,1650),(24791,1650),(24792,1650),(24793,1650),(24794,1650),(24795,1650),(24796,1651),(24797,1651),(24798,1651),(24799,1651),(24800,1651),(24801,1651),(24802,1651),(24803,1652),(24804,1652),(24805,1652),(24806,1652),(24807,1652),(24808,1652),(24809,1652),(24810,1653),(24811,1653),(24812,1653),(24813,1653),(24814,1653),(24815,1653),(24816,1653),(24817,1654),(24818,1654),(24819,1654),(24820,1654),(24821,1654),(24822,1654),(24823,1654),(24824,1655),(24825,1655),(24826,1655),(24827,1655),(24828,1655),(24829,1655),(24830,1655),(24831,1656),(24832,1656),(24833,1656),(24834,1656),(24835,1656),(24836,1656),(24837,1656),(24838,1657),(24839,1657),(24840,1657),(24841,1657),(24842,1657),(24843,1657),(24844,1657),(24845,1658),(24846,1658),(24847,1658),(24848,1658),(24849,1658),(24850,1658),(24851,1658),(24852,1659),(24853,1659),(24854,1659),(24855,1659),(24856,1659),(24857,1659),(24858,1659),(24859,1660),(24860,1660),(24861,1660),(24862,1660),(24863,1660),(24864,1660),(24865,1660),(24866,1661),(24867,1661),(24868,1661),(24869,1661),(24870,1661),(24871,1661),(24872,1661),(24873,1662),(24874,1662),(24875,1662),(24876,1662),(24877,1662),(24878,1662),(24879,1662),(24880,1663),(24881,1663),(24882,1663),(24883,1663),(24884,1663),(24885,1663),(24886,1663),(24887,1664),(24888,1664),(24889,1664),(24890,1664),(24891,1664),(24892,1664),(24893,1664),(24894,1665),(24895,1665),(24896,1665),(24897,1665),(24898,1665),(24899,1665),(24900,1665),(24901,1666),(24902,1666),(24903,1666),(24904,1666),(24905,1666),(24906,1666),(24907,1666),(24908,1667),(24909,1667),(24910,1667),(24911,1667),(24912,1667),(24913,1667),(24914,1667),(24915,1668),(24916,1668),(24917,1668),(24918,1668),(24919,1668),(24920,1668),(24921,1668),(24922,1669),(24923,1669),(24924,1669),(24925,1669),(24926,1669),(24927,1669),(24928,1669),(24929,1670),(24930,1670),(24931,1670),(24932,1670),(24933,1670),(24934,1670),(24935,1670),(24936,1671),(24937,1671),(24938,1671),(24939,1671),(24940,1671),(24941,1671),(24942,1671),(24943,1672),(24944,1672),(24945,1672),(24946,1672),(24947,1672),(24948,1672),(24949,1672),(24950,1673),(24951,1673),(24952,1673),(24953,1673),(24954,1673),(24955,1673),(24956,1673),(24957,1674),(24958,1674),(24959,1674),(24960,1674),(24961,1674),(24962,1674),(24963,1674),(24964,1675),(24965,1675),(24966,1675),(24967,1675),(24968,1675),(24969,1675),(24970,1675),(24971,1676),(24972,1676),(24973,1676),(24974,1676),(24975,1676),(24976,1676),(24977,1676),(24978,1677),(24979,1677),(24980,1677),(24981,1677),(24982,1677),(24983,1677),(24984,1677),(24985,1678),(24986,1678),(24987,1678),(24988,1678),(24989,1678),(24990,1678),(24991,1678),(24992,1679),(24993,1679),(24994,1679),(24995,1679),(24996,1679),(24997,1679),(24998,1679),(24999,1680),(25000,1680),(25001,1680),(25002,1680),(25003,1680),(25004,1680),(25005,1680),(25006,1681),(25007,1681),(25008,1681),(25009,1681),(25010,1681),(25011,1681),(25012,1681),(25013,1682),(25014,1682),(25015,1682),(25016,1682),(25017,1682),(25018,1682),(25019,1682),(25020,1683),(25021,1683),(25022,1683),(25023,1683),(25024,1683),(25025,1683),(25026,1683),(25027,1684),(25028,1684),(25029,1684),(25030,1684),(25031,1684),(25032,1684),(25033,1684),(25034,1685),(25035,1685),(25036,1685),(25037,1685),(25038,1685),(25039,1685),(25040,1685),(25041,1686),(25042,1686),(25043,1686),(25044,1686),(25045,1686),(25046,1686),(25047,1686),(25048,1687),(25049,1687),(25050,1687),(25051,1687),(25052,1687),(25053,1687),(25054,1687),(25055,1688),(25056,1688),(25057,1688),(25058,1688),(25059,1688),(25060,1688),(25061,1688),(25062,1689),(25063,1689),(25064,1689),(25065,1689),(25066,1689),(25067,1689),(25068,1689),(25069,1690),(25070,1690),(25071,1690),(25072,1690),(25073,1690),(25074,1690),(25075,1690),(25076,1691),(25077,1691),(25078,1691),(25079,1691),(25080,1691),(25081,1691),(25082,1691),(25083,1692),(25084,1692),(25085,1692),(25086,1692),(25087,1692),(25088,1692),(25089,1692),(25090,1693),(25091,1693),(25092,1693),(25093,1693),(25094,1693),(25095,1693),(25096,1693),(25097,1694),(25098,1694),(25099,1694),(25100,1694),(25101,1694),(25102,1694),(25103,1694),(25104,1695),(25105,1695),(25106,1695),(25107,1695),(25108,1695),(25109,1695),(25110,1695),(25111,1696),(25112,1696),(25113,1696),(25114,1696),(25115,1696),(25116,1696),(25117,1696),(25118,1697),(25119,1697),(25120,1697),(25121,1697),(25122,1697),(25123,1697),(25124,1697),(25125,1698),(25126,1698),(25127,1698),(25128,1698),(25129,1698),(25130,1698),(25131,1698),(25132,1699),(25133,1699),(25134,1699),(25135,1699),(25136,1699),(25137,1699),(25138,1699),(25139,1700),(25140,1700),(25141,1700),(25142,1700),(25143,1700),(25144,1700),(25145,1700),(25146,1701),(25147,1701),(25148,1701),(25149,1701),(25150,1701),(25151,1701),(25152,1701),(25153,1702),(25154,1702),(25155,1702),(25156,1702),(25157,1702),(25158,1702),(25159,1702),(25160,1703),(25161,1703),(25162,1703),(25163,1703),(25164,1703),(25165,1703),(25166,1703),(25167,1704),(25168,1704),(25169,1704),(25170,1704),(25171,1704),(25172,1704),(25173,1704),(25174,1705),(25175,1705),(25176,1705),(25177,1705),(25178,1705),(25179,1705),(25180,1705),(25181,1706),(25182,1706),(25183,1706),(25184,1706),(25185,1706),(25186,1706),(25187,1706),(25188,1707),(25189,1707),(25190,1707),(25191,1707),(25192,1707),(25193,1707),(25194,1707),(25195,1708),(25196,1708),(25197,1708),(25198,1708),(25199,1708),(25200,1708),(25201,1708),(25202,1709),(25203,1709),(25204,1709),(25205,1709),(25206,1709),(25207,1709),(25208,1709),(25209,1710),(25210,1710),(25211,1710),(25212,1710),(25213,1710),(25214,1710),(25215,1710),(25216,1711),(25217,1711),(25218,1711),(25219,1711),(25220,1711),(25221,1711),(25222,1711),(25223,1712),(25224,1712),(25225,1712),(25226,1712),(25227,1712),(25228,1712),(25229,1712),(25230,1713),(25231,1713),(25232,1713),(25233,1713),(25234,1713),(25235,1713),(25236,1713),(25237,1714),(25238,1714),(25239,1714),(25240,1714),(25241,1714),(25242,1714),(25243,1714),(25244,1715),(25245,1715),(25246,1715),(25247,1715),(25248,1715),(25249,1715),(25250,1715),(25251,1716),(25252,1716),(25253,1716),(25254,1716),(25255,1716),(25256,1716),(25257,1716),(25258,1717),(25259,1717),(25260,1717),(25261,1717),(25262,1717),(25263,1717),(25264,1717),(25265,1718),(25266,1718),(25267,1718),(25268,1718),(25269,1718),(25270,1718),(25271,1718),(25272,1719),(25273,1719),(25274,1719),(25275,1719),(25276,1719),(25277,1719),(25278,1719),(25279,1720),(25280,1720),(25281,1720),(25282,1720),(25283,1720),(25284,1720),(25285,1720),(25286,1721),(25287,1721),(25288,1721),(25289,1721),(25290,1721),(25291,1721),(25292,1721),(25293,1722),(25294,1722),(25295,1722),(25296,1722),(25297,1722),(25298,1722),(25299,1722),(25300,1723),(25301,1723),(25302,1723),(25303,1723),(25304,1723),(25305,1723),(25306,1723),(25307,1724),(25308,1724),(25309,1724),(25310,1724),(25311,1724),(25312,1724),(25313,1724),(25314,1725),(25315,1725),(25316,1725),(25317,1725),(25318,1725),(25319,1725),(25320,1725),(25321,1726),(25322,1726),(25323,1726),(25324,1726),(25325,1726),(25326,1726),(25327,1726),(25328,1727),(25329,1727),(25330,1727),(25331,1727),(25332,1727),(25333,1727),(25334,1727),(25335,1728),(25336,1728),(25337,1728),(25338,1728),(25339,1728),(25340,1728),(25341,1728),(25342,1729),(25343,1729),(25344,1729),(25345,1729),(25346,1729),(25347,1729),(25348,1729),(25349,1730),(25350,1730),(25351,1730),(25352,1730),(25353,1730),(25354,1730),(25355,1730),(25356,1731),(25357,1731),(25358,1731),(25359,1731),(25360,1731),(25361,1731),(25362,1731),(25363,1732),(25364,1732),(25365,1732),(25366,1732),(25367,1732),(25368,1732),(25369,1732),(25370,1733),(25371,1733),(25372,1733),(25373,1733),(25374,1733),(25375,1733),(25376,1733),(25377,1734),(25378,1734),(25379,1734),(25380,1734),(25381,1734),(25382,1734),(25383,1734),(25384,1735),(25385,1735),(25386,1735),(25387,1735),(25388,1735),(25389,1735),(25390,1735),(25391,1736),(25392,1736),(25393,1736),(25394,1736),(25395,1736),(25396,1736),(25397,1736),(25398,1737),(25399,1737),(25400,1737),(25401,1737),(25402,1737),(25403,1737),(25404,1737),(25405,1738),(25406,1738),(25407,1738),(25408,1738),(25409,1738),(25410,1738),(25411,1738),(25412,1739),(25413,1739),(25414,1739),(25415,1739),(25416,1739),(25417,1739),(25418,1739),(25419,1740),(25420,1740),(25421,1740),(25422,1740),(25423,1740),(25424,1740),(25425,1740),(25426,1741),(25427,1741),(25428,1741),(25429,1741),(25430,1741),(25431,1741),(25432,1741),(25433,1742),(25434,1742),(25435,1742),(25436,1742),(25437,1742),(25438,1742),(25439,1742),(25440,1743),(25441,1743),(25442,1743),(25443,1743),(25444,1743),(25445,1743),(25446,1743),(25447,1744),(25448,1744),(25449,1744),(25450,1744),(25451,1744),(25452,1744),(25453,1744),(25454,1745),(25455,1745),(25456,1745),(25457,1745),(25458,1745),(25459,1745),(25460,1745),(25461,1746),(25462,1746),(25463,1746),(25464,1746),(25465,1746),(25466,1746),(25467,1746),(25468,1647),(25469,1647),(25470,1647),(25471,1647),(25472,1647),(25473,1647),(25474,1648),(25475,1648),(25476,1648),(25477,1648),(25478,1648),(25479,1648),(25480,1649),(25481,1649),(25482,1649),(25483,1649),(25484,1649),(25485,1649),(25486,1650),(25487,1650),(25488,1650),(25489,1650),(25490,1650),(25491,1650),(25492,1651),(25493,1651),(25494,1651),(25495,1651),(25496,1651),(25497,1651),(25498,1652),(25499,1652),(25500,1652),(25501,1652),(25502,1652),(25503,1652),(25504,1652),(25505,1652),(25506,1652),(25507,1653),(25508,1653),(25509,1653),(25510,1653),(25511,1653),(25512,1653),(25513,1654),(25514,1654),(25515,1654),(25516,1654),(25517,1654),(25518,1654),(25519,1655),(25520,1655),(25521,1655),(25522,1655),(25523,1655),(25524,1655),(25525,1656),(25526,1656),(25527,1656),(25528,1656),(25529,1656),(25530,1656),(25531,1657),(25532,1657),(25533,1657),(25534,1657),(25535,1657),(25536,1657),(25537,1658),(25538,1658),(25539,1658),(25540,1658),(25541,1658),(25542,1658),(25543,1659),(25544,1659),(25545,1659),(25546,1659),(25547,1659),(25548,1659),(25549,1660),(25550,1660),(25551,1660),(25552,1660),(25553,1660),(25554,1660),(25555,1661),(25556,1661),(25557,1661),(25558,1661),(25559,1661),(25560,1661),(25561,1662),(25562,1662),(25563,1662),(25564,1662),(25565,1662),(25566,1662),(25567,1663),(25568,1663),(25569,1663),(25570,1663),(25571,1663),(25572,1663),(25573,1664),(25574,1664),(25575,1664),(25576,1664),(25577,1664),(25578,1664),(25579,1665),(25580,1665),(25581,1665),(25582,1665),(25583,1665),(25584,1665),(25585,1666),(25586,1666),(25587,1666),(25588,1666),(25589,1666),(25590,1666),(25591,1667),(25592,1667),(25593,1667),(25594,1667),(25595,1667),(25596,1667),(25597,1668),(25598,1668),(25599,1668),(25600,1668),(25601,1668),(25602,1668),(25603,1668),(25604,1668),(25605,1668),(25606,1669),(25607,1669),(25608,1669),(25609,1669),(25610,1669),(25611,1669),(25612,1670),(25613,1670),(25614,1670),(25615,1670),(25616,1670),(25617,1670),(25618,1671),(25619,1671),(25620,1671),(25621,1671),(25622,1671),(25623,1671),(25624,1672),(25625,1672),(25626,1672),(25627,1672),(25628,1672),(25629,1672),(25630,1673),(25631,1673),(25632,1673),(25633,1673),(25634,1673),(25635,1673),(25636,1674),(25637,1674),(25638,1674),(25639,1674),(25640,1674),(25641,1674),(25642,1675),(25643,1675),(25644,1675),(25645,1675),(25646,1675),(25647,1675),(25648,1676),(25649,1676),(25650,1676),(25651,1676),(25652,1676),(25653,1676),(25654,1677),(25655,1677),(25656,1677),(25657,1677),(25658,1677),(25659,1677),(25660,1678),(25661,1678),(25662,1678),(25663,1678),(25664,1678),(25665,1678),(25666,1679),(25667,1679),(25668,1679),(25669,1679),(25670,1679),(25671,1679),(25672,1680),(25673,1680),(25674,1680),(25675,1680),(25676,1680),(25677,1680),(25678,1681),(25679,1681),(25680,1681),(25681,1681),(25682,1681),(25683,1681),(25684,1682),(25685,1682),(25686,1682),(25687,1682),(25688,1682),(25689,1682),(25690,1683),(25691,1683),(25692,1683),(25693,1683),(25694,1683),(25695,1683),(25696,1684),(25697,1684),(25698,1684),(25699,1684),(25700,1684),(25701,1684),(25702,1684),(25703,1684),(25704,1684),(25705,1685),(25706,1685),(25707,1685),(25708,1685),(25709,1685),(25710,1685),(25711,1686),(25712,1686),(25713,1686),(25714,1686),(25715,1686),(25716,1686),(25717,1687),(25718,1687),(25719,1687),(25720,1687),(25721,1687),(25722,1687),(25723,1688),(25724,1688),(25725,1688),(25726,1688),(25727,1688),(25728,1688),(25729,1689),(25730,1689),(25731,1689),(25732,1689),(25733,1689),(25734,1689),(25735,1690),(25736,1690),(25737,1690),(25738,1690),(25739,1690),(25740,1690),(25741,1691),(25742,1691),(25743,1691),(25744,1691),(25745,1691),(25746,1691),(25747,1692),(25748,1692),(25749,1692),(25750,1692),(25751,1692),(25752,1692),(25753,1693),(25754,1693),(25755,1693),(25756,1693),(25757,1693),(25758,1693),(25759,1694),(25760,1694),(25761,1694),(25762,1694),(25763,1694),(25764,1694),(25765,1695),(25766,1695),(25767,1695),(25768,1695),(25769,1695),(25770,1695),(25771,1696),(25772,1696),(25773,1696),(25774,1696),(25775,1696),(25776,1696),(25777,1697),(25778,1697),(25779,1697),(25780,1697),(25781,1697),(25782,1697),(25783,1698),(25784,1698),(25785,1698),(25786,1698),(25787,1698),(25788,1698),(25789,1699),(25790,1699),(25791,1699),(25792,1699),(25793,1699),(25794,1699),(25795,1700),(25796,1700),(25797,1700),(25798,1700),(25799,1700),(25800,1700),(25801,1700),(25802,1700),(25803,1700),(25804,1701),(25805,1701),(25806,1701),(25807,1701),(25808,1701),(25809,1701),(25810,1702),(25811,1702),(25812,1702),(25813,1702),(25814,1702),(25815,1702),(25816,1703),(25817,1703),(25818,1703),(25819,1703),(25820,1703),(25821,1703),(25822,1704),(25823,1704),(25824,1704),(25825,1704),(25826,1704),(25827,1704),(25828,1705),(25829,1705),(25830,1705),(25831,1705),(25832,1705),(25833,1705),(25834,1706),(25835,1706),(25836,1706),(25837,1706),(25838,1706),(25839,1706),(25840,1707),(25841,1707),(25842,1707),(25843,1707),(25844,1707),(25845,1707),(25846,1708),(25847,1708),(25848,1708),(25849,1708),(25850,1708),(25851,1708),(25852,1709),(25853,1709),(25854,1709),(25855,1709),(25856,1709),(25857,1709),(25858,1710),(25859,1710),(25860,1710),(25861,1710),(25862,1710),(25863,1710),(25864,1711),(25865,1711),(25866,1711),(25867,1711),(25868,1711),(25869,1711),(25870,1712),(25871,1712),(25872,1712),(25873,1712),(25874,1712),(25875,1712),(25876,1713),(25877,1713),(25878,1713),(25879,1713),(25880,1713),(25881,1713),(25882,1714),(25883,1714),(25884,1714),(25885,1714),(25886,1714),(25887,1714),(25888,1715),(25889,1715),(25890,1715),(25891,1715),(25892,1715),(25893,1715),(25894,1716),(25895,1716),(25896,1716),(25897,1716),(25898,1716),(25899,1716),(25900,1716),(25901,1716),(25902,1716),(25903,1717),(25904,1717),(25905,1717),(25906,1717),(25907,1717),(25908,1717),(25909,1718),(25910,1718),(25911,1718),(25912,1718),(25913,1718),(25914,1718),(25915,1719),(25916,1719),(25917,1719),(25918,1719),(25919,1719),(25920,1719),(25921,1720),(25922,1720),(25923,1720),(25924,1720),(25925,1720),(25926,1720),(25927,1721),(25928,1721),(25929,1721),(25930,1721),(25931,1721),(25932,1721),(25933,1722),(25934,1722),(25935,1722),(25936,1722),(25937,1722),(25938,1722),(25939,1723),(25940,1723),(25941,1723),(25942,1723),(25943,1723),(25944,1723),(25945,1724),(25946,1724),(25947,1724),(25948,1724),(25949,1724),(25950,1724),(25951,1725),(25952,1725),(25953,1725),(25954,1725),(25955,1725),(25956,1725),(25957,1726),(25958,1726),(25959,1726),(25960,1726),(25961,1726),(25962,1726),(25963,1727),(25964,1727),(25965,1727),(25966,1727),(25967,1727),(25968,1727),(25969,1728),(25970,1728),(25971,1728),(25972,1728),(25973,1728),(25974,1728),(25975,1729),(25976,1729),(25977,1729),(25978,1729),(25979,1729),(25980,1729),(25981,1730),(25982,1730),(25983,1730),(25984,1730),(25985,1730),(25986,1730),(25987,1731),(25988,1731),(25989,1731),(25990,1731),(25991,1731),(25992,1731),(25993,1732),(25994,1732),(25995,1732),(25996,1732),(25997,1732),(25998,1732),(25999,1732),(26000,1732),(26001,1732),(26002,1733),(26003,1733),(26004,1733),(26005,1733),(26006,1733),(26007,1733),(26008,1734),(26009,1734),(26010,1734),(26011,1734),(26012,1734),(26013,1734),(26014,1735),(26015,1735),(26016,1735),(26017,1735),(26018,1735),(26019,1735),(26020,1736),(26021,1736),(26022,1736),(26023,1736),(26024,1736),(26025,1736),(26026,1737),(26027,1737),(26028,1737),(26029,1737),(26030,1737),(26031,1737),(26032,1738),(26033,1738),(26034,1738),(26035,1738),(26036,1738),(26037,1738),(26038,1739),(26039,1739),(26040,1739),(26041,1739),(26042,1739),(26043,1739),(26044,1740),(26045,1740),(26046,1740),(26047,1740),(26048,1740),(26049,1740),(26050,1741),(26051,1741),(26052,1741),(26053,1741),(26054,1741),(26055,1741),(26056,1742),(26057,1742),(26058,1742),(26059,1742),(26060,1742),(26061,1742),(26062,1743),(26063,1743),(26064,1743),(26065,1743),(26066,1743),(26067,1743),(26068,1744),(26069,1744),(26070,1744),(26071,1744),(26072,1744),(26073,1744),(26074,1745),(26075,1745),(26076,1745),(26077,1745),(26078,1745),(26079,1745),(26080,1746),(26081,1746),(26082,1746),(26083,1746),(26084,1746),(26085,1746),(26086,1647),(26087,1647),(26088,1648),(26089,1648),(26090,1649),(26091,1649),(26092,1650),(26093,1650),(26094,1651),(26095,1651),(26096,1652),(26097,1653),(26098,1653),(26099,1654),(26100,1654),(26101,1655),(26102,1655),(26103,1656),(26104,1656),(26105,1657),(26106,1657),(26107,1658),(26108,1658),(26109,1659),(26110,1659),(26111,1660),(26112,1660),(26113,1661),(26114,1661),(26115,1662),(26116,1662),(26117,1663),(26118,1663),(26119,1664),(26120,1664),(26121,1665),(26122,1665),(26123,1666),(26124,1666),(26125,1667),(26126,1667),(26127,1668),(26128,1669),(26129,1669),(26130,1670),(26131,1670),(26132,1671),(26133,1671),(26134,1672),(26135,1672),(26136,1673),(26137,1673),(26138,1674),(26139,1674),(26140,1675),(26141,1675),(26142,1676),(26143,1676),(26144,1677),(26145,1677),(26146,1678),(26147,1678),(26148,1679),(26149,1679),(26150,1680),(26151,1680),(26152,1681),(26153,1681),(26154,1682),(26155,1682),(26156,1683),(26157,1683),(26158,1684),(26159,1685),(26160,1685),(26161,1686),(26162,1686),(26163,1687),(26164,1687),(26165,1688),(26166,1688),(26167,1689),(26168,1689),(26169,1690),(26170,1690),(26171,1691),(26172,1691),(26173,1692),(26174,1692),(26175,1693),(26176,1693),(26177,1694),(26178,1694),(26179,1695),(26180,1695),(26181,1696),(26182,1696),(26183,1697),(26184,1697),(26185,1698),(26186,1698),(26187,1699),(26188,1699),(26189,1700),(26190,1701),(26191,1701),(26192,1702),(26193,1702),(26194,1703),(26195,1703),(26196,1704),(26197,1704),(26198,1705),(26199,1705),(26200,1706),(26201,1706),(26202,1707),(26203,1707),(26204,1708),(26205,1708),(26206,1709),(26207,1709),(26208,1710),(26209,1710),(26210,1711),(26211,1711),(26212,1712),(26213,1712),(26214,1713),(26215,1713),(26216,1714),(26217,1714),(26218,1715),(26219,1715),(26220,1716),(26221,1717),(26222,1717),(26223,1718),(26224,1718),(26225,1719),(26226,1719),(26227,1720),(26228,1720),(26229,1721),(26230,1721),(26231,1722),(26232,1722),(26233,1723),(26234,1723),(26235,1724),(26236,1724),(26237,1725),(26238,1725),(26239,1726),(26240,1726),(26241,1727),(26242,1727),(26243,1728),(26244,1728),(26245,1729),(26246,1729),(26247,1730),(26248,1730),(26249,1731),(26250,1731),(26251,1732),(26252,1733),(26253,1733),(26254,1734),(26255,1734),(26256,1735),(26257,1735),(26258,1736),(26259,1736),(26260,1737),(26261,1737),(26262,1738),(26263,1738),(26264,1739),(26265,1739),(26266,1740),(26267,1740),(26268,1741),(26269,1741),(26270,1742),(26271,1742),(26272,1743),(26273,1743),(26274,1744),(26275,1744),(26276,1745),(26277,1745),(26278,1746),(26279,1746),(26280,1747),(26281,1747),(26282,1747),(26283,1747),(26284,1747),(26285,1747),(26286,1747),(26287,1748),(26288,1748),(26289,1748),(26290,1748),(26291,1748),(26292,1748),(26293,1748),(26294,1749),(26295,1749),(26296,1749),(26297,1749),(26298,1749),(26299,1749),(26300,1749),(26301,1750),(26302,1750),(26303,1750),(26304,1750),(26305,1750),(26306,1750),(26307,1750),(26308,1751),(26309,1751),(26310,1751),(26311,1751),(26312,1751),(26313,1751),(26314,1751),(26315,1752),(26316,1752),(26317,1752),(26318,1752),(26319,1752),(26320,1752),(26321,1752),(26322,1753),(26323,1753),(26324,1753),(26325,1753),(26326,1753),(26327,1753),(26328,1753),(26329,1754),(26330,1754),(26331,1754),(26332,1754),(26333,1754),(26334,1754),(26335,1754),(26336,1755),(26337,1755),(26338,1755),(26339,1755),(26340,1755),(26341,1755),(26342,1755),(26343,1756),(26344,1756),(26345,1756),(26346,1756),(26347,1756),(26348,1756),(26349,1756),(26350,1757),(26351,1757),(26352,1757),(26353,1757),(26354,1757),(26355,1757),(26356,1757),(26357,1758),(26358,1758),(26359,1758),(26360,1758),(26361,1758),(26362,1758),(26363,1758),(26364,1759),(26365,1759),(26366,1759),(26367,1759),(26368,1759),(26369,1759),(26370,1759),(26371,1760),(26372,1760),(26373,1760),(26374,1760),(26375,1760),(26376,1760),(26377,1760),(26378,1761),(26379,1761),(26380,1761),(26381,1761),(26382,1761),(26383,1761),(26384,1761),(26385,1762),(26386,1762),(26387,1762),(26388,1762),(26389,1762),(26390,1762),(26391,1762),(26392,1763),(26393,1763),(26394,1763),(26395,1763),(26396,1763),(26397,1763),(26398,1763),(26399,1764),(26400,1764),(26401,1764),(26402,1764),(26403,1764),(26404,1764),(26405,1764),(26406,1765),(26407,1765),(26408,1765),(26409,1765),(26410,1765),(26411,1765),(26412,1765),(26413,1766),(26414,1766),(26415,1766),(26416,1766),(26417,1766),(26418,1766),(26419,1766),(26420,1767),(26421,1767),(26422,1767),(26423,1767),(26424,1767),(26425,1767),(26426,1767),(26427,1768),(26428,1768),(26429,1768),(26430,1768),(26431,1768),(26432,1768),(26433,1768),(26434,1769),(26435,1769),(26436,1769),(26437,1769),(26438,1769),(26439,1769),(26440,1769),(26441,1770),(26442,1770),(26443,1770),(26444,1770),(26445,1770),(26446,1770),(26447,1770),(26448,1771),(26449,1771),(26450,1771),(26451,1771),(26452,1771),(26453,1771),(26454,1771),(26455,1772),(26456,1772),(26457,1772),(26458,1772),(26459,1772),(26460,1772),(26461,1772),(26462,1773),(26463,1773),(26464,1773),(26465,1773),(26466,1773),(26467,1773),(26468,1773),(26469,1774),(26470,1774),(26471,1774),(26472,1774),(26473,1774),(26474,1774),(26475,1774),(26476,1775),(26477,1775),(26478,1775),(26479,1775),(26480,1775),(26481,1775),(26482,1775),(26483,1776),(26484,1776),(26485,1776),(26486,1776),(26487,1776),(26488,1776),(26489,1776),(26490,1777),(26491,1777),(26492,1777),(26493,1777),(26494,1777),(26495,1777),(26496,1777),(26497,1778),(26498,1778),(26499,1778),(26500,1778),(26501,1778),(26502,1778),(26503,1778),(26504,1779),(26505,1779),(26506,1779),(26507,1779),(26508,1779),(26509,1779),(26510,1779),(26511,1780),(26512,1780),(26513,1780),(26514,1780),(26515,1780),(26516,1780),(26517,1780),(26518,1781),(26519,1781),(26520,1781),(26521,1781),(26522,1781),(26523,1781),(26524,1781),(26525,1782),(26526,1782),(26527,1782),(26528,1782),(26529,1782),(26530,1782),(26531,1782),(26532,1783),(26533,1783),(26534,1783),(26535,1783),(26536,1783),(26537,1783),(26538,1783),(26539,1784),(26540,1784),(26541,1784),(26542,1784),(26543,1784),(26544,1784),(26545,1784),(26546,1785),(26547,1785),(26548,1785),(26549,1785),(26550,1785),(26551,1785),(26552,1785),(26553,1786),(26554,1786),(26555,1786),(26556,1786),(26557,1786),(26558,1786),(26559,1786),(26560,1787),(26561,1787),(26562,1787),(26563,1787),(26564,1787),(26565,1787),(26566,1787),(26567,1788),(26568,1788),(26569,1788),(26570,1788),(26571,1788),(26572,1788),(26573,1788),(26574,1789),(26575,1789),(26576,1789),(26577,1789),(26578,1789),(26579,1789),(26580,1789),(26581,1790),(26582,1790),(26583,1790),(26584,1790),(26585,1790),(26586,1790),(26587,1790),(26588,1791),(26589,1791),(26590,1791),(26591,1791),(26592,1791),(26593,1791),(26594,1791),(26595,1792),(26596,1792),(26597,1792),(26598,1792),(26599,1792),(26600,1792),(26601,1792),(26602,1793),(26603,1793),(26604,1793),(26605,1793),(26606,1793),(26607,1793),(26608,1793),(26609,1794),(26610,1794),(26611,1794),(26612,1794),(26613,1794),(26614,1794),(26615,1794),(26616,1795),(26617,1795),(26618,1795),(26619,1795),(26620,1795),(26621,1795),(26622,1795),(26623,1796),(26624,1796),(26625,1796),(26626,1796),(26627,1796),(26628,1796),(26629,1796),(26630,1797),(26631,1797),(26632,1797),(26633,1797),(26634,1797),(26635,1797),(26636,1797),(26637,1798),(26638,1798),(26639,1798),(26640,1798),(26641,1798),(26642,1798),(26643,1798),(26644,1799),(26645,1799),(26646,1799),(26647,1799),(26648,1799),(26649,1799),(26650,1799),(26651,1800),(26652,1800),(26653,1800),(26654,1800),(26655,1800),(26656,1800),(26657,1800),(26658,1801),(26659,1801),(26660,1801),(26661,1801),(26662,1801),(26663,1801),(26664,1801),(26665,1802),(26666,1802),(26667,1802),(26668,1802),(26669,1802),(26670,1802),(26671,1802),(26672,1803),(26673,1803),(26674,1803),(26675,1803),(26676,1803),(26677,1803),(26678,1803),(26679,1804),(26680,1804),(26681,1804),(26682,1804),(26683,1804),(26684,1804),(26685,1804),(26686,1805),(26687,1805),(26688,1805),(26689,1805),(26690,1805),(26691,1805),(26692,1805),(26693,1806),(26694,1806),(26695,1806),(26696,1806),(26697,1806),(26698,1806),(26699,1806),(26700,1807),(26701,1807),(26702,1807),(26703,1807),(26704,1807),(26705,1807),(26706,1807),(26707,1808),(26708,1808),(26709,1808),(26710,1808),(26711,1808),(26712,1808),(26713,1808),(26714,1809),(26715,1809),(26716,1809),(26717,1809),(26718,1809),(26719,1809),(26720,1809),(26721,1810),(26722,1810),(26723,1810),(26724,1810),(26725,1810),(26726,1810),(26727,1810),(26728,1811),(26729,1811),(26730,1811),(26731,1811),(26732,1811),(26733,1811),(26734,1811),(26735,1812),(26736,1812),(26737,1812),(26738,1812),(26739,1812),(26740,1812),(26741,1812),(26742,1813),(26743,1813),(26744,1813),(26745,1813),(26746,1813),(26747,1813),(26748,1813),(26749,1814),(26750,1814),(26751,1814),(26752,1814),(26753,1814),(26754,1814),(26755,1814),(26756,1815),(26757,1815),(26758,1815),(26759,1815),(26760,1815),(26761,1815),(26762,1815),(26763,1816),(26764,1816),(26765,1816),(26766,1816),(26767,1816),(26768,1816),(26769,1816),(26770,1817),(26771,1817),(26772,1817),(26773,1817),(26774,1817),(26775,1817),(26776,1817),(26777,1818),(26778,1818),(26779,1818),(26780,1818),(26781,1818),(26782,1818),(26783,1818),(26784,1819),(26785,1819),(26786,1819),(26787,1819),(26788,1819),(26789,1819),(26790,1819),(26791,1820),(26792,1820),(26793,1820),(26794,1820),(26795,1820),(26796,1820),(26797,1820),(26798,1821),(26799,1821),(26800,1821),(26801,1821),(26802,1821),(26803,1821),(26804,1821),(26805,1822),(26806,1822),(26807,1822),(26808,1822),(26809,1822),(26810,1822),(26811,1822),(26812,1823),(26813,1823),(26814,1823),(26815,1823),(26816,1823),(26817,1823),(26818,1823),(26819,1824),(26820,1824),(26821,1824),(26822,1824),(26823,1824),(26824,1824),(26825,1824),(26826,1825),(26827,1825),(26828,1825),(26829,1825),(26830,1825),(26831,1825),(26832,1825),(26833,1826),(26834,1826),(26835,1826),(26836,1826),(26837,1826),(26838,1826),(26839,1826),(26840,1827),(26841,1827),(26842,1827),(26843,1827),(26844,1827),(26845,1827),(26846,1827),(26847,1828),(26848,1828),(26849,1828),(26850,1828),(26851,1828),(26852,1828),(26853,1828),(26854,1829),(26855,1829),(26856,1829),(26857,1829),(26858,1829),(26859,1829),(26860,1829),(26861,1830),(26862,1830),(26863,1830),(26864,1830),(26865,1830),(26866,1830),(26867,1830),(26868,1831),(26869,1831),(26870,1831),(26871,1831),(26872,1831),(26873,1831),(26874,1831),(26875,1832),(26876,1832),(26877,1832),(26878,1832),(26879,1832),(26880,1832),(26881,1832),(26882,1833),(26883,1833),(26884,1833),(26885,1833),(26886,1833),(26887,1833),(26888,1833),(26889,1834),(26890,1834),(26891,1834),(26892,1834),(26893,1834),(26894,1834),(26895,1834),(26896,1835),(26897,1835),(26898,1835),(26899,1835),(26900,1835),(26901,1835),(26902,1835),(26903,1836),(26904,1836),(26905,1836),(26906,1836),(26907,1836),(26908,1836),(26909,1836),(26910,1837),(26911,1837),(26912,1837),(26913,1837),(26914,1837),(26915,1837),(26916,1837),(26917,1838),(26918,1838),(26919,1838),(26920,1838),(26921,1838),(26922,1838),(26923,1838),(26924,1839),(26925,1839),(26926,1839),(26927,1839),(26928,1839),(26929,1839),(26930,1839),(26931,1840),(26932,1840),(26933,1840),(26934,1840),(26935,1840),(26936,1840),(26937,1840),(26938,1841),(26939,1841),(26940,1841),(26941,1841),(26942,1841),(26943,1841),(26944,1841),(26945,1842),(26946,1842),(26947,1842),(26948,1842),(26949,1842),(26950,1842),(26951,1842),(26952,1843),(26953,1843),(26954,1843),(26955,1843),(26956,1843),(26957,1843),(26958,1843),(26959,1844),(26960,1844),(26961,1844),(26962,1844),(26963,1844),(26964,1844),(26965,1844),(26966,1845),(26967,1845),(26968,1845),(26969,1845),(26970,1845),(26971,1845),(26972,1845),(26973,1846),(26974,1846),(26975,1846),(26976,1846),(26977,1846),(26978,1846),(26979,1846),(26980,1747),(26981,1747),(26982,1747),(26983,1747),(26984,1747),(26985,1747),(26986,1748),(26987,1748),(26988,1748),(26989,1748),(26990,1748),(26991,1748),(26992,1748),(26993,1748),(26994,1748),(26995,1749),(26996,1749),(26997,1749),(26998,1749),(26999,1749),(27000,1749),(27001,1750),(27002,1750),(27003,1750),(27004,1750),(27005,1750),(27006,1750),(27007,1751),(27008,1751),(27009,1751),(27010,1751),(27011,1751),(27012,1751),(27013,1752),(27014,1752),(27015,1752),(27016,1752),(27017,1752),(27018,1752),(27019,1753),(27020,1753),(27021,1753),(27022,1753),(27023,1753),(27024,1753),(27025,1754),(27026,1754),(27027,1754),(27028,1754),(27029,1754),(27030,1754),(27031,1755),(27032,1755),(27033,1755),(27034,1755),(27035,1755),(27036,1755),(27037,1756),(27038,1756),(27039,1756),(27040,1756),(27041,1756),(27042,1756),(27043,1757),(27044,1757),(27045,1757),(27046,1757),(27047,1757),(27048,1757),(27049,1758),(27050,1758),(27051,1758),(27052,1758),(27053,1758),(27054,1758),(27055,1759),(27056,1759),(27057,1759),(27058,1759),(27059,1759),(27060,1759),(27061,1760),(27062,1760),(27063,1760),(27064,1760),(27065,1760),(27066,1760),(27067,1761),(27068,1761),(27069,1761),(27070,1761),(27071,1761),(27072,1761),(27073,1762),(27074,1762),(27075,1762),(27076,1762),(27077,1762),(27078,1762),(27079,1763),(27080,1763),(27081,1763),(27082,1763),(27083,1763),(27084,1763),(27085,1764),(27086,1764),(27087,1764),(27088,1764),(27089,1764),(27090,1764),(27091,1764),(27092,1764),(27093,1764),(27094,1765),(27095,1765),(27096,1765),(27097,1765),(27098,1765),(27099,1765),(27100,1766),(27101,1766),(27102,1766),(27103,1766),(27104,1766),(27105,1766),(27106,1767),(27107,1767),(27108,1767),(27109,1767),(27110,1767),(27111,1767),(27112,1768),(27113,1768),(27114,1768),(27115,1768),(27116,1768),(27117,1768),(27118,1769),(27119,1769),(27120,1769),(27121,1769),(27122,1769),(27123,1769),(27124,1770),(27125,1770),(27126,1770),(27127,1770),(27128,1770),(27129,1770),(27130,1771),(27131,1771),(27132,1771),(27133,1771),(27134,1771),(27135,1771),(27136,1772),(27137,1772),(27138,1772),(27139,1772),(27140,1772),(27141,1772),(27142,1773),(27143,1773),(27144,1773),(27145,1773),(27146,1773),(27147,1773),(27148,1774),(27149,1774),(27150,1774),(27151,1774),(27152,1774),(27153,1774),(27154,1775),(27155,1775),(27156,1775),(27157,1775),(27158,1775),(27159,1775),(27160,1776),(27161,1776),(27162,1776),(27163,1776),(27164,1776),(27165,1776),(27166,1777),(27167,1777),(27168,1777),(27169,1777),(27170,1777),(27171,1777),(27172,1778),(27173,1778),(27174,1778),(27175,1778),(27176,1778),(27177,1778),(27178,1779),(27179,1779),(27180,1779),(27181,1779),(27182,1779),(27183,1779),(27184,1780),(27185,1780),(27186,1780),(27187,1780),(27188,1780),(27189,1780),(27190,1780),(27191,1780),(27192,1780),(27193,1781),(27194,1781),(27195,1781),(27196,1781),(27197,1781),(27198,1781),(27199,1782),(27200,1782),(27201,1782),(27202,1782),(27203,1782),(27204,1782),(27205,1783),(27206,1783),(27207,1783),(27208,1783),(27209,1783),(27210,1783),(27211,1784),(27212,1784),(27213,1784),(27214,1784),(27215,1784),(27216,1784),(27217,1785),(27218,1785),(27219,1785),(27220,1785),(27221,1785),(27222,1785),(27223,1786),(27224,1786),(27225,1786),(27226,1786),(27227,1786),(27228,1786),(27229,1787),(27230,1787),(27231,1787),(27232,1787),(27233,1787),(27234,1787),(27235,1788),(27236,1788),(27237,1788),(27238,1788),(27239,1788),(27240,1788),(27241,1789),(27242,1789),(27243,1789),(27244,1789),(27245,1789),(27246,1789),(27247,1790),(27248,1790),(27249,1790),(27250,1790),(27251,1790),(27252,1790),(27253,1791),(27254,1791),(27255,1791),(27256,1791),(27257,1791),(27258,1791),(27259,1792),(27260,1792),(27261,1792),(27262,1792),(27263,1792),(27264,1792),(27265,1793),(27266,1793),(27267,1793),(27268,1793),(27269,1793),(27270,1793),(27271,1794),(27272,1794),(27273,1794),(27274,1794),(27275,1794),(27276,1794),(27277,1795),(27278,1795),(27279,1795),(27280,1795),(27281,1795),(27282,1795),(27283,1796),(27284,1796),(27285,1796),(27286,1796),(27287,1796),(27288,1796),(27289,1796),(27290,1796),(27291,1796),(27292,1797),(27293,1797),(27294,1797),(27295,1797),(27296,1797),(27297,1797),(27298,1798),(27299,1798),(27300,1798),(27301,1798),(27302,1798),(27303,1798),(27304,1799),(27305,1799),(27306,1799),(27307,1799),(27308,1799),(27309,1799),(27310,1800),(27311,1800),(27312,1800),(27313,1800),(27314,1800),(27315,1800),(27316,1801),(27317,1801),(27318,1801),(27319,1801),(27320,1801),(27321,1801),(27322,1802),(27323,1802),(27324,1802),(27325,1802),(27326,1802),(27327,1802),(27328,1803),(27329,1803),(27330,1803),(27331,1803),(27332,1803),(27333,1803),(27334,1804),(27335,1804),(27336,1804),(27337,1804),(27338,1804),(27339,1804),(27340,1805),(27341,1805),(27342,1805),(27343,1805),(27344,1805),(27345,1805),(27346,1806),(27347,1806),(27348,1806),(27349,1806),(27350,1806),(27351,1806),(27352,1807),(27353,1807),(27354,1807),(27355,1807),(27356,1807),(27357,1807),(27358,1808),(27359,1808),(27360,1808),(27361,1808),(27362,1808),(27363,1808),(27364,1809),(27365,1809),(27366,1809),(27367,1809),(27368,1809),(27369,1809),(27370,1810),(27371,1810),(27372,1810),(27373,1810),(27374,1810),(27375,1810),(27376,1811),(27377,1811),(27378,1811),(27379,1811),(27380,1811),(27381,1811),(27382,1812),(27383,1812),(27384,1812),(27385,1812),(27386,1812),(27387,1812),(27388,1812),(27389,1812),(27390,1812),(27391,1813),(27392,1813),(27393,1813),(27394,1813),(27395,1813),(27396,1813),(27397,1814),(27398,1814),(27399,1814),(27400,1814),(27401,1814),(27402,1814),(27403,1815),(27404,1815),(27405,1815),(27406,1815),(27407,1815),(27408,1815),(27409,1816),(27410,1816),(27411,1816),(27412,1816),(27413,1816),(27414,1816),(27415,1817),(27416,1817),(27417,1817),(27418,1817),(27419,1817),(27420,1817),(27421,1818),(27422,1818),(27423,1818),(27424,1818),(27425,1818),(27426,1818),(27427,1819),(27428,1819),(27429,1819),(27430,1819),(27431,1819),(27432,1819),(27433,1819),(27434,1819),(27435,1819),(27436,1820),(27437,1820),(27438,1820),(27439,1820),(27440,1820),(27441,1820),(27442,1821),(27443,1821),(27444,1821),(27445,1821),(27446,1821),(27447,1821),(27448,1822),(27449,1822),(27450,1822),(27451,1822),(27452,1822),(27453,1822),(27454,1823),(27455,1823),(27456,1823),(27457,1823),(27458,1823),(27459,1823),(27460,1824),(27461,1824),(27462,1824),(27463,1824),(27464,1824),(27465,1824),(27466,1825),(27467,1825),(27468,1825),(27469,1825),(27470,1825),(27471,1825),(27472,1826),(27473,1826),(27474,1826),(27475,1826),(27476,1826),(27477,1826),(27478,1826),(27479,1826),(27480,1826),(27481,1827),(27482,1827),(27483,1827),(27484,1827),(27485,1827),(27486,1827),(27487,1828),(27488,1828),(27489,1828),(27490,1828),(27491,1828),(27492,1828),(27493,1829),(27494,1829),(27495,1829),(27496,1829),(27497,1829),(27498,1829),(27499,1830),(27500,1830),(27501,1830),(27502,1830),(27503,1830),(27504,1830),(27505,1831),(27506,1831),(27507,1831),(27508,1831),(27509,1831),(27510,1831),(27511,1832),(27512,1832),(27513,1832),(27514,1832),(27515,1832),(27516,1832),(27517,1833),(27518,1833),(27519,1833),(27520,1833),(27521,1833),(27522,1833),(27523,1833),(27524,1833),(27525,1833),(27526,1834),(27527,1834),(27528,1834),(27529,1834),(27530,1834),(27531,1834),(27532,1835),(27533,1835),(27534,1835),(27535,1835),(27536,1835),(27537,1835),(27538,1836),(27539,1836),(27540,1836),(27541,1836),(27542,1836),(27543,1836),(27544,1837),(27545,1837),(27546,1837),(27547,1837),(27548,1837),(27549,1837),(27550,1838),(27551,1838),(27552,1838),(27553,1838),(27554,1838),(27555,1838),(27556,1839),(27557,1839),(27558,1839),(27559,1839),(27560,1839),(27561,1839),(27562,1840),(27563,1840),(27564,1840),(27565,1840),(27566,1840),(27567,1840),(27568,1840),(27569,1840),(27570,1840),(27571,1841),(27572,1841),(27573,1841),(27574,1841),(27575,1841),(27576,1841),(27577,1842),(27578,1842),(27579,1842),(27580,1842),(27581,1842),(27582,1842),(27583,1843),(27584,1843),(27585,1843),(27586,1843),(27587,1843),(27588,1843),(27589,1844),(27590,1844),(27591,1844),(27592,1844),(27593,1844),(27594,1844),(27595,1845),(27596,1845),(27597,1845),(27598,1845),(27599,1845),(27600,1845),(27601,1846),(27602,1846),(27603,1846),(27604,1846),(27605,1846),(27606,1846),(27607,1747),(27608,1747),(27609,1748),(27610,1749),(27611,1749),(27612,1750),(27613,1750),(27614,1751),(27615,1751),(27616,1752),(27617,1752),(27618,1753),(27619,1753),(27620,1754),(27621,1754),(27622,1755),(27623,1755),(27624,1756),(27625,1756),(27626,1757),(27627,1757),(27628,1758),(27629,1758),(27630,1759),(27631,1759),(27632,1760),(27633,1760),(27634,1761),(27635,1761),(27636,1762),(27637,1762),(27638,1763),(27639,1763),(27640,1764),(27641,1765),(27642,1765),(27643,1766),(27644,1766),(27645,1767),(27646,1767),(27647,1768),(27648,1768),(27649,1769),(27650,1769),(27651,1770),(27652,1770),(27653,1771),(27654,1771),(27655,1772),(27656,1772),(27657,1773),(27658,1773),(27659,1774),(27660,1774),(27661,1775),(27662,1775),(27663,1776),(27664,1776),(27665,1777),(27666,1777),(27667,1778),(27668,1778),(27669,1779),(27670,1779),(27671,1780),(27672,1781),(27673,1781),(27674,1782),(27675,1782),(27676,1783),(27677,1783),(27678,1784),(27679,1784),(27680,1785),(27681,1785),(27682,1786),(27683,1786),(27684,1787),(27685,1787),(27686,1788),(27687,1788),(27688,1789),(27689,1789),(27690,1790),(27691,1790),(27692,1791),(27693,1791),(27694,1792),(27695,1792),(27696,1793),(27697,1793),(27698,1794),(27699,1794),(27700,1795),(27701,1795),(27702,1796),(27703,1797),(27704,1797),(27705,1798),(27706,1798),(27707,1799),(27708,1799),(27709,1800),(27710,1800),(27711,1801),(27712,1801),(27713,1802),(27714,1802),(27715,1803),(27716,1803),(27717,1804),(27718,1804),(27719,1805),(27720,1805),(27721,1806),(27722,1806),(27723,1807),(27724,1807),(27725,1808),(27726,1808),(27727,1809),(27728,1809),(27729,1810),(27730,1810),(27731,1811),(27732,1811),(27733,1812),(27734,1813),(27735,1813),(27736,1814),(27737,1814),(27738,1815),(27739,1815),(27740,1816),(27741,1816),(27742,1817),(27743,1817),(27744,1818),(27745,1818),(27746,1819),(27747,1820),(27748,1820),(27749,1821),(27750,1821),(27751,1822),(27752,1822),(27753,1823),(27754,1823),(27755,1824),(27756,1824),(27757,1825),(27758,1825),(27759,1826),(27760,1827),(27761,1827),(27762,1828),(27763,1828),(27764,1829),(27765,1829),(27766,1830),(27767,1830),(27768,1831),(27769,1831),(27770,1832),(27771,1832),(27772,1833),(27773,1834),(27774,1834),(27775,1835),(27776,1835),(27777,1836),(27778,1836),(27779,1837),(27780,1837),(27781,1838),(27782,1838),(27783,1839),(27784,1839),(27785,1840),(27786,1841),(27787,1841),(27788,1842),(27789,1842),(27790,1843),(27791,1843),(27792,1844),(27793,1844),(27794,1845),(27795,1845),(27796,1846),(27797,1846),(27798,1847),(27799,1847),(27800,1847),(27801,1847),(27802,1847),(27803,1847),(27804,1847),(27805,1848),(27806,1848),(27807,1848),(27808,1848),(27809,1848),(27810,1848),(27811,1848),(27812,1849),(27813,1849),(27814,1849),(27815,1849),(27816,1849),(27817,1849),(27818,1849),(27819,1850),(27820,1850),(27821,1850),(27822,1850),(27823,1850),(27824,1850),(27825,1850),(27826,1851),(27827,1851),(27828,1851),(27829,1851),(27830,1851),(27831,1851),(27832,1851),(27833,1852),(27834,1852),(27835,1852),(27836,1852),(27837,1852),(27838,1852),(27839,1852),(27840,1853),(27841,1853),(27842,1853),(27843,1853),(27844,1853),(27845,1853),(27846,1853),(27847,1854),(27848,1854),(27849,1854),(27850,1854),(27851,1854),(27852,1854),(27853,1854),(27854,1855),(27855,1855),(27856,1855),(27857,1855),(27858,1855),(27859,1855),(27860,1855),(27861,1856),(27862,1856),(27863,1856),(27864,1856),(27865,1856),(27866,1856),(27867,1856),(27868,1857),(27869,1857),(27870,1857),(27871,1857),(27872,1857),(27873,1857),(27874,1857),(27875,1858),(27876,1858),(27877,1858),(27878,1858),(27879,1858),(27880,1858),(27881,1858),(27882,1859),(27883,1859),(27884,1859),(27885,1859),(27886,1859),(27887,1859),(27888,1859),(27889,1860),(27890,1860),(27891,1860),(27892,1860),(27893,1860),(27894,1860),(27895,1860),(27896,1861),(27897,1861),(27898,1861),(27899,1861),(27900,1861),(27901,1861),(27902,1861),(27903,1862),(27904,1862),(27905,1862),(27906,1862),(27907,1862),(27908,1862),(27909,1862),(27910,1863),(27911,1863),(27912,1863),(27913,1863),(27914,1863),(27915,1863),(27916,1863),(27917,1864),(27918,1864),(27919,1864),(27920,1864),(27921,1864),(27922,1864),(27923,1864),(27924,1865),(27925,1865),(27926,1865),(27927,1865),(27928,1865),(27929,1865),(27930,1865),(27931,1866),(27932,1866),(27933,1866),(27934,1866),(27935,1866),(27936,1866),(27937,1866),(27938,1867),(27939,1867),(27940,1867),(27941,1867),(27942,1867),(27943,1867),(27944,1867),(27945,1868),(27946,1868),(27947,1868),(27948,1868),(27949,1868),(27950,1868),(27951,1868),(27952,1869),(27953,1869),(27954,1869),(27955,1869),(27956,1869),(27957,1869),(27958,1869),(27959,1870),(27960,1870),(27961,1870),(27962,1870),(27963,1870),(27964,1870),(27965,1870),(27966,1871),(27967,1871),(27968,1871),(27969,1871),(27970,1871),(27971,1871),(27972,1871),(27973,1872),(27974,1872),(27975,1872),(27976,1872),(27977,1872),(27978,1872),(27979,1872),(27980,1873),(27981,1873),(27982,1873),(27983,1873),(27984,1873),(27985,1873),(27986,1873),(27987,1874),(27988,1874),(27989,1874),(27990,1874),(27991,1874),(27992,1874),(27993,1874),(27994,1875),(27995,1875),(27996,1875),(27997,1875),(27998,1875),(27999,1875),(28000,1875),(28001,1876),(28002,1876),(28003,1876),(28004,1876),(28005,1876),(28006,1876),(28007,1876),(28008,1877),(28009,1877),(28010,1877),(28011,1877),(28012,1877),(28013,1877),(28014,1877),(28015,1878),(28016,1878),(28017,1878),(28018,1878),(28019,1878),(28020,1878),(28021,1878),(28022,1879),(28023,1879),(28024,1879),(28025,1879),(28026,1879),(28027,1879),(28028,1879),(28029,1880),(28030,1880),(28031,1880),(28032,1880),(28033,1880),(28034,1880),(28035,1880),(28036,1881),(28037,1881),(28038,1881),(28039,1881),(28040,1881),(28041,1881),(28042,1881),(28043,1882),(28044,1882),(28045,1882),(28046,1882),(28047,1882),(28048,1882),(28049,1882),(28050,1883),(28051,1883),(28052,1883),(28053,1883),(28054,1883),(28055,1883),(28056,1883),(28057,1884),(28058,1884),(28059,1884),(28060,1884),(28061,1884),(28062,1884),(28063,1884),(28064,1885),(28065,1885),(28066,1885),(28067,1885),(28068,1885),(28069,1885),(28070,1885),(28071,1886),(28072,1886),(28073,1886),(28074,1886),(28075,1886),(28076,1886),(28077,1886),(28078,1887),(28079,1887),(28080,1887),(28081,1887),(28082,1887),(28083,1887),(28084,1887),(28085,1888),(28086,1888),(28087,1888),(28088,1888),(28089,1888),(28090,1888),(28091,1888),(28092,1889),(28093,1889),(28094,1889),(28095,1889),(28096,1889),(28097,1889),(28098,1889),(28099,1890),(28100,1890),(28101,1890),(28102,1890),(28103,1890),(28104,1890),(28105,1890),(28106,1891),(28107,1891),(28108,1891),(28109,1891),(28110,1891),(28111,1891),(28112,1891),(28113,1892),(28114,1892),(28115,1892),(28116,1892),(28117,1892),(28118,1892),(28119,1892),(28120,1893),(28121,1893),(28122,1893),(28123,1893),(28124,1893),(28125,1893),(28126,1893),(28127,1894),(28128,1894),(28129,1894),(28130,1894),(28131,1894),(28132,1894),(28133,1894),(28134,1895),(28135,1895),(28136,1895),(28137,1895),(28138,1895),(28139,1895),(28140,1895),(28141,1896),(28142,1896),(28143,1896),(28144,1896),(28145,1896),(28146,1896),(28147,1896),(28148,1897),(28149,1897),(28150,1897),(28151,1897),(28152,1897),(28153,1897),(28154,1897),(28155,1898),(28156,1898),(28157,1898),(28158,1898),(28159,1898),(28160,1898),(28161,1898),(28162,1899),(28163,1899),(28164,1899),(28165,1899),(28166,1899),(28167,1899),(28168,1899),(28169,1900),(28170,1900),(28171,1900),(28172,1900),(28173,1900),(28174,1900),(28175,1900),(28176,1901),(28177,1901),(28178,1901),(28179,1901),(28180,1901),(28181,1901),(28182,1901),(28183,1902),(28184,1902),(28185,1902),(28186,1902),(28187,1902),(28188,1902),(28189,1902),(28190,1903),(28191,1903),(28192,1903),(28193,1903),(28194,1903),(28195,1903),(28196,1903),(28197,1904),(28198,1904),(28199,1904),(28200,1904),(28201,1904),(28202,1904),(28203,1904),(28204,1905),(28205,1905),(28206,1905),(28207,1905),(28208,1905),(28209,1905),(28210,1905),(28211,1906),(28212,1906),(28213,1906),(28214,1906),(28215,1906),(28216,1906),(28217,1906),(28218,1907),(28219,1907),(28220,1907),(28221,1907),(28222,1907),(28223,1907),(28224,1907),(28225,1908),(28226,1908),(28227,1908),(28228,1908),(28229,1908),(28230,1908),(28231,1908),(28232,1909),(28233,1909),(28234,1909),(28235,1909),(28236,1909),(28237,1909),(28238,1909),(28239,1910),(28240,1910),(28241,1910),(28242,1910),(28243,1910),(28244,1910),(28245,1910),(28246,1911),(28247,1911),(28248,1911),(28249,1911),(28250,1911),(28251,1911),(28252,1911),(28253,1912),(28254,1912),(28255,1912),(28256,1912),(28257,1912),(28258,1912),(28259,1912),(28260,1913),(28261,1913),(28262,1913),(28263,1913),(28264,1913),(28265,1913),(28266,1913),(28267,1914),(28268,1914),(28269,1914),(28270,1914),(28271,1914),(28272,1914),(28273,1914),(28274,1915),(28275,1915),(28276,1915),(28277,1915),(28278,1915),(28279,1915),(28280,1915),(28281,1916),(28282,1916),(28283,1916),(28284,1916),(28285,1916),(28286,1916),(28287,1916),(28288,1917),(28289,1917),(28290,1917),(28291,1917),(28292,1917),(28293,1917),(28294,1917),(28295,1918),(28296,1918),(28297,1918),(28298,1918),(28299,1918),(28300,1918),(28301,1918),(28302,1919),(28303,1919),(28304,1919),(28305,1919),(28306,1919),(28307,1919),(28308,1919),(28309,1920),(28310,1920),(28311,1920),(28312,1920),(28313,1920),(28314,1920),(28315,1920),(28316,1921),(28317,1921),(28318,1921),(28319,1921),(28320,1921),(28321,1921),(28322,1921),(28323,1922),(28324,1922),(28325,1922),(28326,1922),(28327,1922),(28328,1922),(28329,1922),(28330,1923),(28331,1923),(28332,1923),(28333,1923),(28334,1923),(28335,1923),(28336,1923),(28337,1924),(28338,1924),(28339,1924),(28340,1924),(28341,1924),(28342,1924),(28343,1924),(28344,1925),(28345,1925),(28346,1925),(28347,1925),(28348,1925),(28349,1925),(28350,1925),(28351,1926),(28352,1926),(28353,1926),(28354,1926),(28355,1926),(28356,1926),(28357,1926),(28358,1927),(28359,1927),(28360,1927),(28361,1927),(28362,1927),(28363,1927),(28364,1927),(28365,1928),(28366,1928),(28367,1928),(28368,1928),(28369,1928),(28370,1928),(28371,1928),(28372,1929),(28373,1929),(28374,1929),(28375,1929),(28376,1929),(28377,1929),(28378,1929),(28379,1930),(28380,1930),(28381,1930),(28382,1930),(28383,1930),(28384,1930),(28385,1930),(28386,1931),(28387,1931),(28388,1931),(28389,1931),(28390,1931),(28391,1931),(28392,1931),(28393,1932),(28394,1932),(28395,1932),(28396,1932),(28397,1932),(28398,1932),(28399,1932),(28400,1933),(28401,1933),(28402,1933),(28403,1933),(28404,1933),(28405,1933),(28406,1933),(28407,1934),(28408,1934),(28409,1934),(28410,1934),(28411,1934),(28412,1934),(28413,1934),(28414,1935),(28415,1935),(28416,1935),(28417,1935),(28418,1935),(28419,1935),(28420,1935),(28421,1936),(28422,1936),(28423,1936),(28424,1936),(28425,1936),(28426,1936),(28427,1936),(28428,1937),(28429,1937),(28430,1937),(28431,1937),(28432,1937),(28433,1937),(28434,1937),(28435,1938),(28436,1938),(28437,1938),(28438,1938),(28439,1938),(28440,1938),(28441,1938),(28442,1939),(28443,1939),(28444,1939),(28445,1939),(28446,1939),(28447,1939),(28448,1939),(28449,1940),(28450,1940),(28451,1940),(28452,1940),(28453,1940),(28454,1940),(28455,1940),(28456,1941),(28457,1941),(28458,1941),(28459,1941),(28460,1941),(28461,1941),(28462,1941),(28463,1942),(28464,1942),(28465,1942),(28466,1942),(28467,1942),(28468,1942),(28469,1942),(28470,1943),(28471,1943),(28472,1943),(28473,1943),(28474,1943),(28475,1943),(28476,1943),(28477,1944),(28478,1944),(28479,1944),(28480,1944),(28481,1944),(28482,1944),(28483,1944),(28484,1945),(28485,1945),(28486,1945),(28487,1945),(28488,1945),(28489,1945),(28490,1945),(28491,1946),(28492,1946),(28493,1946),(28494,1946),(28495,1946),(28496,1946),(28497,1946),(28498,1847),(28499,1847),(28500,1847),(28501,1847),(28502,1847),(28503,1847),(28504,1847),(28505,1847),(28506,1847),(28507,1848),(28508,1848),(28509,1848),(28510,1848),(28511,1848),(28512,1848),(28513,1849),(28514,1849),(28515,1849),(28516,1849),(28517,1849),(28518,1849),(28519,1850),(28520,1850),(28521,1850),(28522,1850),(28523,1850),(28524,1850),(28525,1851),(28526,1851),(28527,1851),(28528,1851),(28529,1851),(28530,1851),(28531,1852),(28532,1852),(28533,1852),(28534,1852),(28535,1852),(28536,1852),(28537,1853),(28538,1853),(28539,1853),(28540,1853),(28541,1853),(28542,1853),(28543,1854),(28544,1854),(28545,1854),(28546,1854),(28547,1854),(28548,1854),(28549,1854),(28550,1854),(28551,1854),(28552,1855),(28553,1855),(28554,1855),(28555,1855),(28556,1855),(28557,1855),(28558,1856),(28559,1856),(28560,1856),(28561,1856),(28562,1856),(28563,1856),(28564,1857),(28565,1857),(28566,1857),(28567,1857),(28568,1857),(28569,1857),(28570,1858),(28571,1858),(28572,1858),(28573,1858),(28574,1858),(28575,1858),(28576,1859),(28577,1859),(28578,1859),(28579,1859),(28580,1859),(28581,1859),(28582,1860),(28583,1860),(28584,1860),(28585,1860),(28586,1860),(28587,1860),(28588,1861),(28589,1861),(28590,1861),(28591,1861),(28592,1861),(28593,1861),(28594,1861),(28595,1861),(28596,1861),(28597,1862),(28598,1862),(28599,1862),(28600,1862),(28601,1862),(28602,1862),(28603,1863),(28604,1863),(28605,1863),(28606,1863),(28607,1863),(28608,1863),(28609,1864),(28610,1864),(28611,1864),(28612,1864),(28613,1864),(28614,1864),(28615,1865),(28616,1865),(28617,1865),(28618,1865),(28619,1865),(28620,1865),(28621,1866),(28622,1866),(28623,1866),(28624,1866),(28625,1866),(28626,1866),(28627,1867),(28628,1867),(28629,1867),(28630,1867),(28631,1867),(28632,1867),(28633,1868),(28634,1868),(28635,1868),(28636,1868),(28637,1868),(28638,1868),(28639,1868),(28640,1868),(28641,1868),(28642,1869),(28643,1869),(28644,1869),(28645,1869),(28646,1869),(28647,1869),(28648,1870),(28649,1870),(28650,1870),(28651,1870),(28652,1870),(28653,1870),(28654,1871),(28655,1871),(28656,1871),(28657,1871),(28658,1871),(28659,1871),(28660,1872),(28661,1872),(28662,1872),(28663,1872),(28664,1872),(28665,1872),(28666,1873),(28667,1873),(28668,1873),(28669,1873),(28670,1873),(28671,1873),(28672,1874),(28673,1874),(28674,1874),(28675,1874),(28676,1874),(28677,1874),(28678,1875),(28679,1875),(28680,1875),(28681,1875),(28682,1875),(28683,1875),(28684,1875),(28685,1875),(28686,1875),(28687,1876),(28688,1876),(28689,1876),(28690,1876),(28691,1876),(28692,1876),(28693,1877),(28694,1877),(28695,1877),(28696,1877),(28697,1877),(28698,1877),(28699,1878),(28700,1878),(28701,1878),(28702,1878),(28703,1878),(28704,1878),(28705,1879),(28706,1879),(28707,1879),(28708,1879),(28709,1879),(28710,1879),(28711,1880),(28712,1880),(28713,1880),(28714,1880),(28715,1880),(28716,1880),(28717,1881),(28718,1881),(28719,1881),(28720,1881),(28721,1881),(28722,1881),(28723,1882),(28724,1882),(28725,1882),(28726,1882),(28727,1882),(28728,1882),(28729,1882),(28730,1882),(28731,1882),(28732,1883),(28733,1883),(28734,1883),(28735,1883),(28736,1883),(28737,1883),(28738,1884),(28739,1884),(28740,1884),(28741,1884),(28742,1884),(28743,1884),(28744,1885),(28745,1885),(28746,1885),(28747,1885),(28748,1885),(28749,1885),(28750,1886),(28751,1886),(28752,1886),(28753,1886),(28754,1886),(28755,1886),(28756,1887),(28757,1887),(28758,1887),(28759,1887),(28760,1887),(28761,1887),(28762,1888),(28763,1888),(28764,1888),(28765,1888),(28766,1888),(28767,1888),(28768,1889),(28769,1889),(28770,1889),(28771,1889),(28772,1889),(28773,1889),(28774,1889),(28775,1889),(28776,1889),(28777,1890),(28778,1890),(28779,1890),(28780,1890),(28781,1890),(28782,1890),(28783,1891),(28784,1891),(28785,1891),(28786,1891),(28787,1891),(28788,1891),(28789,1892),(28790,1892),(28791,1892),(28792,1892),(28793,1892),(28794,1892),(28795,1893),(28796,1893),(28797,1893),(28798,1893),(28799,1893),(28800,1893),(28801,1894),(28802,1894),(28803,1894),(28804,1894),(28805,1894),(28806,1894),(28807,1895),(28808,1895),(28809,1895),(28810,1895),(28811,1895),(28812,1895),(28813,1896),(28814,1896),(28815,1896),(28816,1896),(28817,1896),(28818,1896),(28819,1896),(28820,1896),(28821,1896),(28822,1897),(28823,1897),(28824,1897),(28825,1897),(28826,1897),(28827,1897),(28828,1898),(28829,1898),(28830,1898),(28831,1898),(28832,1898),(28833,1898),(28834,1899),(28835,1899),(28836,1899),(28837,1899),(28838,1899),(28839,1899),(28840,1900),(28841,1900),(28842,1900),(28843,1900),(28844,1900),(28845,1900),(28846,1901),(28847,1901),(28848,1901),(28849,1901),(28850,1901),(28851,1901),(28852,1902),(28853,1902),(28854,1902),(28855,1902),(28856,1902),(28857,1902),(28858,1903),(28859,1903),(28860,1903),(28861,1903),(28862,1903),(28863,1903),(28864,1903),(28865,1903),(28866,1903),(28867,1904),(28868,1904),(28869,1904),(28870,1904),(28871,1904),(28872,1904),(28873,1905),(28874,1905),(28875,1905),(28876,1905),(28877,1905),(28878,1905),(28879,1906),(28880,1906),(28881,1906),(28882,1906),(28883,1906),(28884,1906),(28885,1907),(28886,1907),(28887,1907),(28888,1907),(28889,1907),(28890,1907),(28891,1908),(28892,1908),(28893,1908),(28894,1908),(28895,1908),(28896,1908),(28897,1909),(28898,1909),(28899,1909),(28900,1909),(28901,1909),(28902,1909),(28903,1910),(28904,1910),(28905,1910),(28906,1910),(28907,1910),(28908,1910),(28909,1911),(28910,1911),(28911,1911),(28912,1911),(28913,1911),(28914,1911),(28915,1912),(28916,1912),(28917,1912),(28918,1912),(28919,1912),(28920,1912),(28921,1913),(28922,1913),(28923,1913),(28924,1913),(28925,1913),(28926,1913),(28927,1914),(28928,1914),(28929,1914),(28930,1914),(28931,1914),(28932,1914),(28933,1915),(28934,1915),(28935,1915),(28936,1915),(28937,1915),(28938,1915),(28939,1916),(28940,1916),(28941,1916),(28942,1916),(28943,1916),(28944,1916),(28945,1917),(28946,1917),(28947,1917),(28948,1917),(28949,1917),(28950,1917),(28951,1918),(28952,1918),(28953,1918),(28954,1918),(28955,1918),(28956,1918),(28957,1919),(28958,1919),(28959,1919),(28960,1919),(28961,1919),(28962,1919),(28963,1919),(28964,1919),(28965,1919),(28966,1920),(28967,1920),(28968,1920),(28969,1920),(28970,1920),(28971,1920),(28972,1921),(28973,1921),(28974,1921),(28975,1921),(28976,1921),(28977,1921),(28978,1922),(28979,1922),(28980,1922),(28981,1922),(28982,1922),(28983,1922),(28984,1923),(28985,1923),(28986,1923),(28987,1923),(28988,1923),(28989,1923),(28990,1924),(28991,1924),(28992,1924),(28993,1924),(28994,1924),(28995,1924),(28996,1925),(28997,1925),(28998,1925),(28999,1925),(29000,1925),(29001,1925),(29002,1926),(29003,1926),(29004,1926),(29005,1926),(29006,1926),(29007,1926),(29008,1927),(29009,1927),(29010,1927),(29011,1927),(29012,1927),(29013,1927),(29014,1928),(29015,1928),(29016,1928),(29017,1928),(29018,1928),(29019,1928),(29020,1929),(29021,1929),(29022,1929),(29023,1929),(29024,1929),(29025,1929),(29026,1930),(29027,1930),(29028,1930),(29029,1930),(29030,1930),(29031,1930),(29032,1931),(29033,1931),(29034,1931),(29035,1931),(29036,1931),(29037,1931),(29038,1932),(29039,1932),(29040,1932),(29041,1932),(29042,1932),(29043,1932),(29044,1933),(29045,1933),(29046,1933),(29047,1933),(29048,1933),(29049,1933),(29050,1934),(29051,1934),(29052,1934),(29053,1934),(29054,1934),(29055,1934),(29056,1935),(29057,1935),(29058,1935),(29059,1935),(29060,1935),(29061,1935),(29062,1935),(29063,1935),(29064,1935),(29065,1936),(29066,1936),(29067,1936),(29068,1936),(29069,1936),(29070,1936),(29071,1937),(29072,1937),(29073,1937),(29074,1937),(29075,1937),(29076,1937),(29077,1938),(29078,1938),(29079,1938),(29080,1938),(29081,1938),(29082,1938),(29083,1939),(29084,1939),(29085,1939),(29086,1939),(29087,1939),(29088,1939),(29089,1940),(29090,1940),(29091,1940),(29092,1940),(29093,1940),(29094,1940),(29095,1941),(29096,1941),(29097,1941),(29098,1941),(29099,1941),(29100,1941),(29101,1942),(29102,1942),(29103,1942),(29104,1942),(29105,1942),(29106,1942),(29107,1943),(29108,1943),(29109,1943),(29110,1943),(29111,1943),(29112,1943),(29113,1944),(29114,1944),(29115,1944),(29116,1944),(29117,1944),(29118,1944),(29119,1945),(29120,1945),(29121,1945),(29122,1945),(29123,1945),(29124,1945),(29125,1946),(29126,1946),(29127,1946),(29128,1946),(29129,1946),(29130,1946),(29131,1847),(29132,1848),(29133,1848),(29134,1849),(29135,1849),(29136,1850),(29137,1850),(29138,1851),(29139,1851),(29140,1852),(29141,1852),(29142,1853),(29143,1853),(29144,1854),(29145,1855),(29146,1855),(29147,1856),(29148,1856),(29149,1857),(29150,1857),(29151,1858),(29152,1858),(29153,1859),(29154,1859),(29155,1860),(29156,1860),(29157,1861),(29158,1862),(29159,1862),(29160,1863),(29161,1863),(29162,1864),(29163,1864),(29164,1865),(29165,1865),(29166,1866),(29167,1866),(29168,1867),(29169,1867),(29170,1868),(29171,1869),(29172,1869),(29173,1870),(29174,1870),(29175,1871),(29176,1871),(29177,1872),(29178,1872),(29179,1873),(29180,1873),(29181,1874),(29182,1874),(29183,1875),(29184,1876),(29185,1876),(29186,1877),(29187,1877),(29188,1878),(29189,1878),(29190,1879),(29191,1879),(29192,1880),(29193,1880),(29194,1881),(29195,1881),(29196,1882),(29197,1883),(29198,1883),(29199,1884),(29200,1884),(29201,1885),(29202,1885),(29203,1886),(29204,1886),(29205,1887),(29206,1887),(29207,1888),(29208,1888),(29209,1889),(29210,1890),(29211,1890),(29212,1891),(29213,1891),(29214,1892),(29215,1892),(29216,1893),(29217,1893),(29218,1894),(29219,1894),(29220,1895),(29221,1895),(29222,1896),(29223,1897),(29224,1897),(29225,1898),(29226,1898),(29227,1899),(29228,1899),(29229,1900),(29230,1900),(29231,1901),(29232,1901),(29233,1902),(29234,1902),(29235,1903),(29236,1904),(29237,1904),(29238,1905),(29239,1905),(29240,1906),(29241,1906),(29242,1907),(29243,1907),(29244,1908),(29245,1908),(29246,1909),(29247,1909),(29248,1910),(29249,1910),(29250,1911),(29251,1911),(29252,1912),(29253,1912),(29254,1913),(29255,1913),(29256,1914),(29257,1914),(29258,1915),(29259,1915),(29260,1916),(29261,1916),(29262,1917),(29263,1917),(29264,1918),(29265,1918),(29266,1919),(29267,1920),(29268,1920),(29269,1921),(29270,1921),(29271,1922),(29272,1922),(29273,1923),(29274,1923),(29275,1924),(29276,1924),(29277,1925),(29278,1925),(29279,1926),(29280,1926),(29281,1927),(29282,1927),(29283,1928),(29284,1928),(29285,1929),(29286,1929),(29287,1930),(29288,1930),(29289,1931),(29290,1931),(29291,1932),(29292,1932),(29293,1933),(29294,1933),(29295,1934),(29296,1934),(29297,1935),(29298,1936),(29299,1936),(29300,1937),(29301,1937),(29302,1938),(29303,1938),(29304,1939),(29305,1939),(29306,1940),(29307,1940),(29308,1941),(29309,1941),(29310,1942),(29311,1942),(29312,1943),(29313,1943),(29314,1944),(29315,1944),(29316,1945),(29317,1945),(29318,1946),(29319,1946),(29320,1947),(29321,1947),(29322,1947),(29323,1947),(29324,1947),(29325,1947),(29326,1947),(29327,1948),(29328,1948),(29329,1948),(29330,1948),(29331,1948),(29332,1948),(29333,1948),(29334,1949),(29335,1949),(29336,1949),(29337,1949),(29338,1949),(29339,1949),(29340,1949),(29341,1950),(29342,1950),(29343,1950),(29344,1950),(29345,1950),(29346,1950),(29347,1950),(29348,1951),(29349,1951),(29350,1951),(29351,1951),(29352,1951),(29353,1951),(29354,1951),(29355,1952),(29356,1952),(29357,1952),(29358,1952),(29359,1952),(29360,1952),(29361,1952),(29362,1953),(29363,1953),(29364,1953),(29365,1953),(29366,1953),(29367,1953),(29368,1953),(29369,1954),(29370,1954),(29371,1954),(29372,1954),(29373,1954),(29374,1954),(29375,1954),(29376,1955),(29377,1955),(29378,1955),(29379,1955),(29380,1955),(29381,1955),(29382,1955),(29383,1956),(29384,1956),(29385,1956),(29386,1956),(29387,1956),(29388,1956),(29389,1956),(29390,1957),(29391,1957),(29392,1957),(29393,1957),(29394,1957),(29395,1957),(29396,1957),(29397,1958),(29398,1958),(29399,1958),(29400,1958),(29401,1958),(29402,1958),(29403,1958),(29404,1959),(29405,1959),(29406,1959),(29407,1959),(29408,1959),(29409,1959),(29410,1959),(29411,1960),(29412,1960),(29413,1960),(29414,1960),(29415,1960),(29416,1960),(29417,1960),(29418,1961),(29419,1961),(29420,1961),(29421,1961),(29422,1961),(29423,1961),(29424,1961),(29425,1962),(29426,1962),(29427,1962),(29428,1962),(29429,1962),(29430,1962),(29431,1962),(29432,1963),(29433,1963),(29434,1963),(29435,1963),(29436,1963),(29437,1963),(29438,1963),(29439,1964),(29440,1964),(29441,1964),(29442,1964),(29443,1964),(29444,1964),(29445,1964),(29446,1965),(29447,1965),(29448,1965),(29449,1965),(29450,1965),(29451,1965),(29452,1965),(29453,1966),(29454,1966),(29455,1966),(29456,1966),(29457,1966),(29458,1966),(29459,1966),(29460,1967),(29461,1967),(29462,1967),(29463,1967),(29464,1967),(29465,1967),(29466,1967),(29467,1968),(29468,1968),(29469,1968),(29470,1968),(29471,1968),(29472,1968),(29473,1968),(29474,1969),(29475,1969),(29476,1969),(29477,1969),(29478,1969),(29479,1969),(29480,1969),(29481,1970),(29482,1970),(29483,1970),(29484,1970),(29485,1970),(29486,1970),(29487,1970),(29488,1971),(29489,1971),(29490,1971),(29491,1971),(29492,1971),(29493,1971),(29494,1971),(29495,1972),(29496,1972),(29497,1972),(29498,1972),(29499,1972),(29500,1972),(29501,1972),(29502,1973),(29503,1973),(29504,1973),(29505,1973),(29506,1973),(29507,1973),(29508,1973),(29509,1974),(29510,1974),(29511,1974),(29512,1974),(29513,1974),(29514,1974),(29515,1974),(29516,1975),(29517,1975),(29518,1975),(29519,1975),(29520,1975),(29521,1975),(29522,1975),(29523,1976),(29524,1976),(29525,1976),(29526,1976),(29527,1976),(29528,1976),(29529,1976),(29530,1977),(29531,1977),(29532,1977),(29533,1977),(29534,1977),(29535,1977),(29536,1977),(29537,1978),(29538,1978),(29539,1978),(29540,1978),(29541,1978),(29542,1978),(29543,1978),(29544,1979),(29545,1979),(29546,1979),(29547,1979),(29548,1979),(29549,1979),(29550,1979),(29551,1980),(29552,1980),(29553,1980),(29554,1980),(29555,1980),(29556,1980),(29557,1980),(29558,1981),(29559,1981),(29560,1981),(29561,1981),(29562,1981),(29563,1981),(29564,1981),(29565,1982),(29566,1982),(29567,1982),(29568,1982),(29569,1982),(29570,1982),(29571,1982),(29572,1983),(29573,1983),(29574,1983),(29575,1983),(29576,1983),(29577,1983),(29578,1983),(29579,1984),(29580,1984),(29581,1984),(29582,1984),(29583,1984),(29584,1984),(29585,1984),(29586,1985),(29587,1985),(29588,1985),(29589,1985),(29590,1985),(29591,1985),(29592,1985),(29593,1986),(29594,1986),(29595,1986),(29596,1986),(29597,1986),(29598,1986),(29599,1986),(29600,1987),(29601,1987),(29602,1987),(29603,1987),(29604,1987),(29605,1987),(29606,1987),(29607,1988),(29608,1988),(29609,1988),(29610,1988),(29611,1988),(29612,1988),(29613,1988),(29614,1989),(29615,1989),(29616,1989),(29617,1989),(29618,1989),(29619,1989),(29620,1989),(29621,1990),(29622,1990),(29623,1990),(29624,1990),(29625,1990),(29626,1990),(29627,1990),(29628,1991),(29629,1991),(29630,1991),(29631,1991),(29632,1991),(29633,1991),(29634,1991),(29635,1992),(29636,1992),(29637,1992),(29638,1992),(29639,1992),(29640,1992),(29641,1992),(29642,1993),(29643,1993),(29644,1993),(29645,1993),(29646,1993),(29647,1993),(29648,1993),(29649,1994),(29650,1994),(29651,1994),(29652,1994),(29653,1994),(29654,1994),(29655,1994),(29656,1995),(29657,1995),(29658,1995),(29659,1995),(29660,1995),(29661,1995),(29662,1995),(29663,1996),(29664,1996),(29665,1996),(29666,1996),(29667,1996),(29668,1996),(29669,1996),(29670,1997),(29671,1997),(29672,1997),(29673,1997),(29674,1997),(29675,1997),(29676,1997),(29677,1998),(29678,1998),(29679,1998),(29680,1998),(29681,1998),(29682,1998),(29683,1998),(29684,1999),(29685,1999),(29686,1999),(29687,1999),(29688,1999),(29689,1999),(29690,1999),(29691,2000),(29692,2000),(29693,2000),(29694,2000),(29695,2000),(29696,2000),(29697,2000),(29698,2001),(29699,2001),(29700,2001),(29701,2001),(29702,2001),(29703,2001),(29704,2001),(29705,2002),(29706,2002),(29707,2002),(29708,2002),(29709,2002),(29710,2002),(29711,2002),(29712,2003),(29713,2003),(29714,2003),(29715,2003),(29716,2003),(29717,2003),(29718,2003),(29719,2004),(29720,2004),(29721,2004),(29722,2004),(29723,2004),(29724,2004),(29725,2004),(29726,2005),(29727,2005),(29728,2005),(29729,2005),(29730,2005),(29731,2005),(29732,2005),(29733,2006),(29734,2006),(29735,2006),(29736,2006),(29737,2006),(29738,2006),(29739,2006),(29740,2007),(29741,2007),(29742,2007),(29743,2007),(29744,2007),(29745,2007),(29746,2007),(29747,2008),(29748,2008),(29749,2008),(29750,2008),(29751,2008),(29752,2008),(29753,2008),(29754,2009),(29755,2009),(29756,2009),(29757,2009),(29758,2009),(29759,2009),(29760,2009),(29761,2010),(29762,2010),(29763,2010),(29764,2010),(29765,2010),(29766,2010),(29767,2010),(29768,2011),(29769,2011),(29770,2011),(29771,2011),(29772,2011),(29773,2011),(29774,2011),(29775,2012),(29776,2012),(29777,2012),(29778,2012),(29779,2012),(29780,2012),(29781,2012),(29782,2013),(29783,2013),(29784,2013),(29785,2013),(29786,2013),(29787,2013),(29788,2013),(29789,2014),(29790,2014),(29791,2014),(29792,2014),(29793,2014),(29794,2014),(29795,2014),(29796,2015),(29797,2015),(29798,2015),(29799,2015),(29800,2015),(29801,2015),(29802,2015),(29803,2016),(29804,2016),(29805,2016),(29806,2016),(29807,2016),(29808,2016),(29809,2016),(29810,2017),(29811,2017),(29812,2017),(29813,2017),(29814,2017),(29815,2017),(29816,2017),(29817,2018),(29818,2018),(29819,2018),(29820,2018),(29821,2018),(29822,2018),(29823,2018),(29824,2019),(29825,2019),(29826,2019),(29827,2019),(29828,2019),(29829,2019),(29830,2019),(29831,2020),(29832,2020),(29833,2020),(29834,2020),(29835,2020),(29836,2020),(29837,2020),(29838,2021),(29839,2021),(29840,2021),(29841,2021),(29842,2021),(29843,2021),(29844,2021),(29845,2022),(29846,2022),(29847,2022),(29848,2022),(29849,2022),(29850,2022),(29851,2022),(29852,2023),(29853,2023),(29854,2023),(29855,2023),(29856,2023),(29857,2023),(29858,2023),(29859,2024),(29860,2024),(29861,2024),(29862,2024),(29863,2024),(29864,2024),(29865,2024),(29866,2025),(29867,2025),(29868,2025),(29869,2025),(29870,2025),(29871,2025),(29872,2025),(29873,2026),(29874,2026),(29875,2026),(29876,2026),(29877,2026),(29878,2026),(29879,2026),(29880,2027),(29881,2027),(29882,2027),(29883,2027),(29884,2027),(29885,2027),(29886,2027),(29887,2028),(29888,2028),(29889,2028),(29890,2028),(29891,2028),(29892,2028),(29893,2028),(29894,2029),(29895,2029),(29896,2029),(29897,2029),(29898,2029),(29899,2029),(29900,2029),(29901,2030),(29902,2030),(29903,2030),(29904,2030),(29905,2030),(29906,2030),(29907,2030),(29908,2031),(29909,2031),(29910,2031),(29911,2031),(29912,2031),(29913,2031),(29914,2031),(29915,2032),(29916,2032),(29917,2032),(29918,2032),(29919,2032),(29920,2032),(29921,2032),(29922,2033),(29923,2033),(29924,2033),(29925,2033),(29926,2033),(29927,2033),(29928,2033),(29929,2034),(29930,2034),(29931,2034),(29932,2034),(29933,2034),(29934,2034),(29935,2034),(29936,2035),(29937,2035),(29938,2035),(29939,2035),(29940,2035),(29941,2035),(29942,2035),(29943,2036),(29944,2036),(29945,2036),(29946,2036),(29947,2036),(29948,2036),(29949,2036),(29950,2037),(29951,2037),(29952,2037),(29953,2037),(29954,2037),(29955,2037),(29956,2037),(29957,2038),(29958,2038),(29959,2038),(29960,2038),(29961,2038),(29962,2038),(29963,2038),(29964,2039),(29965,2039),(29966,2039),(29967,2039),(29968,2039),(29969,2039),(29970,2039),(29971,2040),(29972,2040),(29973,2040),(29974,2040),(29975,2040),(29976,2040),(29977,2040),(29978,1947),(29979,1947),(29980,1947),(29981,1947),(29982,1947),(29983,1947),(29984,1948),(29985,1948),(29986,1948),(29987,1948),(29988,1948),(29989,1948),(29990,1949),(29991,1949),(29992,1949),(29993,1949),(29994,1949),(29995,1949),(29996,1950),(29997,1950),(29998,1950),(29999,1950),(30000,1950),(30001,1950),(30002,1951),(30003,1951),(30004,1951),(30005,1951),(30006,1951),(30007,1951),(30008,1951),(30009,1951),(30010,1951),(30011,1952),(30012,1952),(30013,1952),(30014,1952),(30015,1952),(30016,1952),(30017,1953),(30018,1953),(30019,1953),(30020,1953),(30021,1953),(30022,1953),(30023,1954),(30024,1954),(30025,1954),(30026,1954),(30027,1954),(30028,1954),(30029,1955),(30030,1955),(30031,1955),(30032,1955),(30033,1955),(30034,1955),(30035,1956),(30036,1956),(30037,1956),(30038,1956),(30039,1956),(30040,1956),(30041,1957),(30042,1957),(30043,1957),(30044,1957),(30045,1957),(30046,1957),(30047,1958),(30048,1958),(30049,1958),(30050,1958),(30051,1958),(30052,1958),(30053,1959),(30054,1959),(30055,1959),(30056,1959),(30057,1959),(30058,1959),(30059,1960),(30060,1960),(30061,1960),(30062,1960),(30063,1960),(30064,1960),(30065,1961),(30066,1961),(30067,1961),(30068,1961),(30069,1961),(30070,1961),(30071,1962),(30072,1962),(30073,1962),(30074,1962),(30075,1962),(30076,1962),(30077,1963),(30078,1963),(30079,1963),(30080,1963),(30081,1963),(30082,1963),(30083,1964),(30084,1964),(30085,1964),(30086,1964),(30087,1964),(30088,1964),(30089,1965),(30090,1965),(30091,1965),(30092,1965),(30093,1965),(30094,1965),(30095,1966),(30096,1966),(30097,1966),(30098,1966),(30099,1966),(30100,1966),(30101,1967),(30102,1967),(30103,1967),(30104,1967),(30105,1967),(30106,1967),(30107,1967),(30108,1967),(30109,1967),(30110,1968),(30111,1968),(30112,1968),(30113,1968),(30114,1968),(30115,1968),(30116,1969),(30117,1969),(30118,1969),(30119,1969),(30120,1969),(30121,1969),(30122,1970),(30123,1970),(30124,1970),(30125,1970),(30126,1970),(30127,1970),(30128,1971),(30129,1971),(30130,1971),(30131,1971),(30132,1971),(30133,1971),(30134,1972),(30135,1972),(30136,1972),(30137,1972),(30138,1972),(30139,1972),(30140,1973),(30141,1973),(30142,1973),(30143,1973),(30144,1973),(30145,1973),(30146,1974),(30147,1974),(30148,1974),(30149,1974),(30150,1974),(30151,1974),(30152,1975),(30153,1975),(30154,1975),(30155,1975),(30156,1975),(30157,1975),(30158,1976),(30159,1976),(30160,1976),(30161,1976),(30162,1976),(30163,1976),(30164,1977),(30165,1977),(30166,1977),(30167,1977),(30168,1977),(30169,1977),(30170,1978),(30171,1978),(30172,1978),(30173,1978),(30174,1978),(30175,1978),(30176,1979),(30177,1979),(30178,1979),(30179,1979),(30180,1979),(30181,1979),(30182,1980),(30183,1980),(30184,1980),(30185,1980),(30186,1980),(30187,1980),(30188,1981),(30189,1981),(30190,1981),(30191,1981),(30192,1981),(30193,1981),(30194,1982),(30195,1982),(30196,1982),(30197,1982),(30198,1982),(30199,1982),(30200,1983),(30201,1983),(30202,1983),(30203,1983),(30204,1983),(30205,1983),(30206,1983),(30207,1983),(30208,1983),(30209,1984),(30210,1984),(30211,1984),(30212,1984),(30213,1984),(30214,1984),(30215,1985),(30216,1985),(30217,1985),(30218,1985),(30219,1985),(30220,1985),(30221,1986),(30222,1986),(30223,1986),(30224,1986),(30225,1986),(30226,1986),(30227,1987),(30228,1987),(30229,1987),(30230,1987),(30231,1987),(30232,1987),(30233,1988),(30234,1988),(30235,1988),(30236,1988),(30237,1988),(30238,1988),(30239,1989),(30240,1989),(30241,1989),(30242,1989),(30243,1989),(30244,1989),(30245,1990),(30246,1990),(30247,1990),(30248,1990),(30249,1990),(30250,1990),(30251,1990),(30252,1990),(30253,1990),(30254,1991),(30255,1991),(30256,1991),(30257,1991),(30258,1991),(30259,1991),(30260,1992),(30261,1992),(30262,1992),(30263,1992),(30264,1992),(30265,1992),(30266,1993),(30267,1993),(30268,1993),(30269,1993),(30270,1993),(30271,1993),(30272,1994),(30273,1994),(30274,1994),(30275,1994),(30276,1994),(30277,1994),(30278,1995),(30279,1995),(30280,1995),(30281,1995),(30282,1995),(30283,1995),(30284,1996),(30285,1996),(30286,1996),(30287,1996),(30288,1996),(30289,1996),(30290,1997),(30291,1997),(30292,1997),(30293,1997),(30294,1997),(30295,1997),(30296,1997),(30297,1997),(30298,1997),(30299,1998),(30300,1998),(30301,1998),(30302,1998),(30303,1998),(30304,1998),(30305,1999),(30306,1999),(30307,1999),(30308,1999),(30309,1999),(30310,1999),(30311,2000),(30312,2000),(30313,2000),(30314,2000),(30315,2000),(30316,2000),(30317,2001),(30318,2001),(30319,2001),(30320,2001),(30321,2001),(30322,2001),(30323,2002),(30324,2002),(30325,2002),(30326,2002),(30327,2002),(30328,2002),(30329,2003),(30330,2003),(30331,2003),(30332,2003),(30333,2003),(30334,2003),(30335,2003),(30336,2003),(30337,2003),(30338,2004),(30339,2004),(30340,2004),(30341,2004),(30342,2004),(30343,2004),(30344,2005),(30345,2005),(30346,2005),(30347,2005),(30348,2005),(30349,2005),(30350,2006),(30351,2006),(30352,2006),(30353,2006),(30354,2006),(30355,2006),(30356,2007),(30357,2007),(30358,2007),(30359,2007),(30360,2007),(30361,2007),(30362,2008),(30363,2008),(30364,2008),(30365,2008),(30366,2008),(30367,2008),(30368,2009),(30369,2009),(30370,2009),(30371,2009),(30372,2009),(30373,2009),(30374,2010),(30375,2010),(30376,2010),(30377,2010),(30378,2010),(30379,2010),(30380,2010),(30381,2010),(30382,2010),(30383,2011),(30384,2011),(30385,2011),(30386,2011),(30387,2011),(30388,2011),(30389,2012),(30390,2012),(30391,2012),(30392,2012),(30393,2012),(30394,2012),(30395,2013),(30396,2013),(30397,2013),(30398,2013),(30399,2013),(30400,2013),(30401,2014),(30402,2014),(30403,2014),(30404,2014),(30405,2014),(30406,2014),(30407,2015),(30408,2015),(30409,2015),(30410,2015),(30411,2015),(30412,2015),(30413,2016),(30414,2016),(30415,2016),(30416,2016),(30417,2016),(30418,2016),(30419,2017),(30420,2017),(30421,2017),(30422,2017),(30423,2017),(30424,2017),(30425,2017),(30426,2017),(30427,2017),(30428,2018),(30429,2018),(30430,2018),(30431,2018),(30432,2018),(30433,2018),(30434,2019),(30435,2019),(30436,2019),(30437,2019),(30438,2019),(30439,2019),(30440,2020),(30441,2020),(30442,2020),(30443,2020),(30444,2020),(30445,2020),(30446,2021),(30447,2021),(30448,2021),(30449,2021),(30450,2021),(30451,2021),(30452,2022),(30453,2022),(30454,2022),(30455,2022),(30456,2022),(30457,2022),(30458,2023),(30459,2023),(30460,2023),(30461,2023),(30462,2023),(30463,2023),(30464,2024),(30465,2024),(30466,2024),(30467,2024),(30468,2024),(30469,2024),(30470,2024),(30471,2024),(30472,2024),(30473,2025),(30474,2025),(30475,2025),(30476,2025),(30477,2025),(30478,2025),(30479,2026),(30480,2026),(30481,2026),(30482,2026),(30483,2026),(30484,2026),(30485,2027),(30486,2027),(30487,2027),(30488,2027),(30489,2027),(30490,2027),(30491,2028),(30492,2028),(30493,2028),(30494,2028),(30495,2028),(30496,2028),(30497,2029),(30498,2029),(30499,2029),(30500,2029),(30501,2029),(30502,2029),(30503,2030),(30504,2030),(30505,2030),(30506,2030),(30507,2030),(30508,2030),(30509,2031),(30510,2031),(30511,2031),(30512,2031),(30513,2031),(30514,2031),(30515,2032),(30516,2032),(30517,2032),(30518,2032),(30519,2032),(30520,2032),(30521,2033),(30522,2033),(30523,2033),(30524,2033),(30525,2033),(30526,2033),(30527,2034),(30528,2034),(30529,2034),(30530,2034),(30531,2034),(30532,2034),(30533,2035),(30534,2035),(30535,2035),(30536,2035),(30537,2035),(30538,2035),(30539,2036),(30540,2036),(30541,2036),(30542,2036),(30543,2036),(30544,2036),(30545,2037),(30546,2037),(30547,2037),(30548,2037),(30549,2037),(30550,2037),(30551,2038),(30552,2038),(30553,2038),(30554,2038),(30555,2038),(30556,2038),(30557,2039),(30558,2039),(30559,2039),(30560,2039),(30561,2039),(30562,2039),(30563,2040),(30564,2040),(30565,2040),(30566,2040),(30567,2040),(30568,2040),(30569,2040),(30570,2040),(30571,2040),(30572,1947),(30573,1947),(30574,1948),(30575,1948),(30576,1949),(30577,1949),(30578,1950),(30579,1950),(30580,1951),(30581,1952),(30582,1952),(30583,1953),(30584,1953),(30585,1954),(30586,1954),(30587,1955),(30588,1955),(30589,1956),(30590,1956),(30591,1957),(30592,1957),(30593,1958),(30594,1958),(30595,1959),(30596,1959),(30597,1960),(30598,1960),(30599,1961),(30600,1961),(30601,1962),(30602,1962),(30603,1963),(30604,1963),(30605,1964),(30606,1964),(30607,1965),(30608,1965),(30609,1966),(30610,1966),(30611,1967),(30612,1968),(30613,1968),(30614,1969),(30615,1969),(30616,1970),(30617,1970),(30618,1971),(30619,1971),(30620,1972),(30621,1972),(30622,1973),(30623,1973),(30624,1974),(30625,1974),(30626,1975),(30627,1975),(30628,1976),(30629,1976),(30630,1977),(30631,1977),(30632,1978),(30633,1978),(30634,1979),(30635,1979),(30636,1980),(30637,1980),(30638,1981),(30639,1981),(30640,1982),(30641,1982),(30642,1983),(30643,1984),(30644,1984),(30645,1985),(30646,1985),(30647,1986),(30648,1986),(30649,1987),(30650,1987),(30651,1988),(30652,1988),(30653,1989),(30654,1989),(30655,1990),(30656,1991),(30657,1991),(30658,1992),(30659,1992),(30660,1993),(30661,1993),(30662,1994),(30663,1994),(30664,1995),(30665,1995),(30666,1996),(30667,1996),(30668,1997),(30669,1998),(30670,1998),(30671,1999),(30672,1999),(30673,2000),(30674,2000),(30675,2001),(30676,2001),(30677,2002),(30678,2002),(30679,2003),(30680,2004),(30681,2004),(30682,2005),(30683,2005),(30684,2006),(30685,2006),(30686,2007),(30687,2007),(30688,2008),(30689,2008),(30690,2009),(30691,2009),(30692,2010),(30693,2011),(30694,2011),(30695,2012),(30696,2012),(30697,2013),(30698,2013),(30699,2014),(30700,2014),(30701,2015),(30702,2015),(30703,2016),(30704,2016),(30705,2017),(30706,2018),(30707,2018),(30708,2019),(30709,2019),(30710,2020),(30711,2020),(30712,2021),(30713,2021),(30714,2022),(30715,2022),(30716,2023),(30717,2023),(30718,2024),(30719,2025),(30720,2025),(30721,2026),(30722,2026),(30723,2027),(30724,2027),(30725,2028),(30726,2028),(30727,2029),(30728,2029),(30729,2030),(30730,2030),(30731,2031),(30732,2031),(30733,2032),(30734,2032),(30735,2033),(30736,2033),(30737,2034),(30738,2034),(30739,2035),(30740,2035),(30741,2036),(30742,2036),(30743,2037),(30744,2037),(30745,2038),(30746,2038),(30747,2039),(30748,2039),(30749,2040),(30750,1044),(30751,1044),(30752,1044),(30753,1044),(30754,1060),(30755,1060),(30756,1060),(30757,1060),(30758,1076),(30759,1076),(30760,1076),(30761,1076),(30762,1092),(30763,1092),(30764,1092),(30765,1092),(30766,1108),(30767,1108),(30768,1108),(30769,1108),(30770,1114),(30771,1114),(30772,1114),(30773,1114),(30774,1130),(30775,1130),(30776,1130),(30777,1130),(30778,1146),(30779,1146),(30780,1146),(30781,1146),(30782,1162),(30783,1162),(30784,1162),(30785,1162),(30786,1178),(30787,1178),(30788,1178),(30789,1178),(30790,1194),(30791,1194),(30792,1194),(30793,1194),(30794,1210),(30795,1210),(30796,1210),(30797,1210),(30798,1220),(30799,1220),(30800,1220),(30801,1220),(30802,1236),(30803,1236),(30804,1236),(30805,1236),(30806,1252),(30807,1252),(30808,1252),(30809,1252),(30810,1268),(30811,1268),(30812,1268),(30813,1268),(30814,1284),(30815,1284),(30816,1284),(30817,1284),(30818,1380),(30819,1380),(30820,1380),(30821,1380),(30822,1300),(30823,1300),(30824,1300),(30825,1300),(30826,1316),(30827,1316),(30828,1316),(30829,1316),(30830,1332),(30831,1332),(30832,1332),(30833,1332),(30834,1348),(30835,1348),(30836,1348),(30837,1348),(30838,1348),(30839,1364),(30840,1364),(30841,1364),(30842,1364),(30843,1396),(30844,1396),(30845,1396),(30846,1396),(30847,1604),(30848,1604),(30849,1604),(30850,1604),(30851,1620),(30852,1620),(30853,1620),(30854,1620),(30855,1636),(30856,1636),(30857,1636),(30858,1636),(30859,1652),(30860,1652),(30861,1652),(30862,1652),(30863,1668),(30864,1668),(30865,1668),(30866,1668),(30867,1684),(30868,1684),(30869,1684),(30870,1684),(30871,1700),(30872,1700),(30873,1700),(30874,1700),(30875,1716),(30876,1716),(30877,1716),(30878,1716),(30879,1732),(30880,1732),(30881,1732),(30882,1732),(30883,1748),(30884,1748),(30885,1748),(30886,1748),(30887,1764),(30888,1764),(30889,1764),(30890,1764),(30891,1780),(30892,1780),(30893,1780),(30894,1780),(30895,1796),(30896,1796),(30897,1796),(30898,1796),(30899,1812),(30900,1812),(30901,1812),(30902,1812),(30903,1919),(30904,1919),(30905,1919),(30906,1919),(30907,1935),(30908,1935),(30909,1935),(30910,1935),(30911,1951),(30912,1951),(30913,1951),(30914,1951),(30915,1967),(30916,1967),(30917,1967),(30918,1967),(30919,1983),(30920,1983),(30921,1983),(30922,1983),(30923,1990),(30924,1990),(30925,1990),(30926,1990),(30927,1997),(30928,1997),(30929,1997),(30930,1997),(30931,2003),(30932,2003),(30933,2003),(30934,2003),(30935,2010),(30936,2010),(30937,2010),(30938,2010),(30939,2017),(30940,2017),(30941,2017),(30942,2017),(30943,2024),(30944,2024),(30945,2024),(30946,2024),(30947,2040),(30948,2040),(30949,2040),(30950,2040),(30951,62),(30952,62),(30953,62),(30954,62),(30955,78),(30956,78),(30957,78),(30958,78),(30959,94),(30960,94),(30961,94),(30962,94),(30963,110),(30964,110),(30965,110),(30966,110),(30967,126),(30968,126),(30969,126),(30970,126),(30971,142),(30972,142),(30973,142),(30974,142),(30975,158),(30976,158),(30977,158),(30978,158),(30979,174),(30980,174),(30981,174),(30982,174),(30983,190),(30984,190),(30985,190),(30986,190),(30987,206),(30988,206),(30989,206),(30990,206),(30991,222),(30992,222),(30993,222),(30994,222),(30995,238),(30996,238),(30997,238),(30998,238),(30999,254),(31000,254),(31001,254),(31002,254),(31003,270),(31004,270),(31005,270),(31006,270),(31007,286),(31008,286),(31009,286),(31010,286),(31011,414),(31012,414),(31013,414),(31014,414),(31015,302),(31016,302),(31017,302),(31018,302),(31019,398),(31020,398),(31021,398),(31022,398),(31023,318),(31024,318),(31025,318),(31026,318),(31027,334),(31028,334),(31029,334),(31030,334),(31031,350),(31032,350),(31033,350),(31034,350),(31035,366),(31036,366),(31037,366),(31038,366),(31039,382),(31040,382),(31041,382),(31042,382),(31043,430),(31044,430),(31045,430),(31046,430),(31047,638),(31048,638),(31049,638),(31050,638),(31051,654),(31052,654),(31053,654),(31054,654),(31055,670),(31056,670),(31057,670),(31058,670),(31059,676),(31060,676),(31061,676),(31062,676),(31063,682),(31064,682),(31065,682),(31066,682),(31067,688),(31068,688),(31069,688),(31070,688),(31071,694),(31072,694),(31073,694),(31074,694),(31075,700),(31076,700),(31077,700),(31078,700),(31079,706),(31080,706),(31081,706),(31082,706),(31083,712),(31084,712),(31085,712),(31086,712),(31087,718),(31088,718),(31089,718),(31090,718),(31091,724),(31092,724),(31093,724),(31094,724),(31095,893),(31096,893),(31097,893),(31098,893),(31099,898),(31100,898),(31101,898),(31102,898),(31103,911),(31104,911),(31105,911),(31106,911),(31107,924),(31108,924),(31109,924),(31110,924),(31111,937),(31112,937),(31113,937),(31114,937),(31115,950),(31116,950),(31117,950),(31118,950),(31119,963),(31120,963),(31121,963),(31122,963),(31123,976),(31124,976),(31125,976),(31126,976),(31127,989),(31128,989),(31129,989),(31130,989),(31131,1002),(31132,1002),(31133,1002),(31134,1002),(31135,1015),(31136,1015),(31137,1015),(31138,1015),(31139,1028),(31140,1028),(31141,1028),(31142,1028),(31143,1572),(31144,1572),(31145,1572),(31146,1572),(31147,1572),(31148,1572),(31149,1572),(31150,1572),(31151,1412),(31152,1412),(31153,1412),(31154,1412),(31155,1412),(31156,1428),(31157,1428),(31158,1444),(31159,1444),(31160,1588),(31161,1588),(31162,1588),(31163,1588),(31164,1588),(31165,1588),(31166,1588),(31167,1588),(31168,1460),(31169,1460),(31170,1492),(31171,1492),(31172,1492),(31173,1492),(31174,1492),(31175,1492),(31176,1492),(31177,1508),(31178,1508),(31179,1508),(31180,1508),(31181,1508),(31182,1508),(31183,1508),(31184,1508),(31185,1524),(31186,1540),(31187,1540),(31188,1540),(31189,1540),(31190,1540),(31191,1556),(31192,1556),(31193,1556),(31194,1556),(31195,1556),(31196,1556),(31197,1556),(31198,1556),(31199,1556),(31200,1556),(31201,1556),(31202,1819),(31203,1819),(31204,1819),(31205,1819),(31206,1819),(31207,1819),(31208,1819),(31209,1819),(31210,1819),(31211,1819),(31212,1819),(31213,1819),(31214,1826),(31215,1826),(31216,1826),(31217,1826),(31218,1826),(31219,1826),(31220,1826),(31221,1826),(31222,1826),(31223,1826),(31224,1833),(31225,1833),(31226,1833),(31227,1833),(31228,1833),(31229,1833),(31230,1833),(31231,1854),(31232,1854),(31233,1854),(31234,1861),(31235,1861),(31236,1861),(31237,1861),(31238,1861),(31239,1861),(31240,1861),(31241,1868),(31242,1868),(31243,1868),(31244,1868),(31245,1868),(31246,1868),(31247,1868),(31248,1875),(31249,1875),(31250,1875),(31251,1875),(31252,1882),(31253,1882),(31254,1882),(31255,1882),(31256,1889),(31257,1889),(31258,1889),(31259,1889),(31260,1889),(31261,1889),(31262,1889),(31263,1889),(31264,1889),(31265,1889),(31266,1896),(31267,1896),(31268,1903),(31269,1903),(31270,1903),(31271,1903),(31272,1903),(31273,1903),(31274,558),(31275,558),(31276,558),(31277,558),(31278,558),(31279,558),(31280,558),(31281,574),(31282,574),(31283,574),(31284,574),(31285,574),(31286,574),(31287,574),(31288,526),(31289,526),(31290,526),(31291,446),(31292,446),(31293,446),(31294,462),(31295,462),(31296,462),(31297,462),(31298,462),(31299,462),(31300,462),(31301,542),(31302,542),(31303,542),(31304,478),(31305,478),(31306,590),(31307,590),(31308,590),(31309,590),(31310,590),(31311,590),(31312,590),(31313,494),(31314,494),(31315,494),(31316,494),(31317,494),(31318,494),(31319,494),(31320,510),(31321,510),(31322,510),(31323,737),(31324,737),(31325,737),(31326,737),(31327,737),(31328,737),(31329,737),(31330,737),(31331,737),(31332,737),(31333,750),(31334,750),(31335,750),(31336,750),(31337,750),(31338,750),(31339,750),(31340,750),(31341,763),(31342,763),(31343,763),(31344,763),(31345,763),(31346,763),(31347,776),(31348,776),(31349,776),(31350,776),(31351,776),(31352,776),(31353,776),(31354,776),(31355,776),(31356,789),(31357,789),(31358,789),(31359,789),(31360,789),(31361,802),(31362,802),(31363,802),(31364,802),(31365,802),(31366,802),(31367,802),(31368,802),(31369,802),(31370,802),(31371,802),(31372,815),(31373,815),(31374,815),(31375,841),(31376,854),(31377,854),(31378,854),(31379,854),(31380,867),(31381,867),(31382,880),(31383,880),(31384,880),(31385,880),(31386,880),(31387,880),(31388,880),(31389,1044),(31390,1044),(31391,1044),(31392,1044),(31393,1044),(31394,1044),(31395,1044),(31396,1044),(31397,1044),(31398,1044),(31399,1044),(31400,1044),(31401,1060),(31402,1060),(31403,1060),(31404,1060),(31405,1060),(31406,1060),(31407,1060),(31408,1060),(31409,1060),(31410,1060),(31411,1060),(31412,1060),(31413,1076),(31414,1076),(31415,1076),(31416,1076),(31417,1076),(31418,1076),(31419,1076),(31420,1076),(31421,1076),(31422,1076),(31423,1076),(31424,1076),(31425,1092),(31426,1092),(31427,1092),(31428,1092),(31429,1092),(31430,1092),(31431,1092),(31432,1092),(31433,1092),(31434,1092),(31435,1092),(31436,1092),(31437,1108),(31438,1108),(31439,1108),(31440,1108),(31441,1108),(31442,1108),(31443,1108),(31444,1108),(31445,1108),(31446,1108),(31447,1108),(31448,1108),(31449,1114),(31450,1114),(31451,1114),(31452,1114),(31453,1114),(31454,1114),(31455,1114),(31456,1114),(31457,1114),(31458,1114),(31459,1114),(31460,1114),(31461,1130),(31462,1130),(31463,1130),(31464,1130),(31465,1130),(31466,1130),(31467,1130),(31468,1130),(31469,1130),(31470,1130),(31471,1130),(31472,1130),(31473,1146),(31474,1146),(31475,1146),(31476,1146),(31477,1146),(31478,1146),(31479,1146),(31480,1146),(31481,1146),(31482,1146),(31483,1146),(31484,1146),(31485,1162),(31486,1162),(31487,1162),(31488,1162),(31489,1162),(31490,1162),(31491,1162),(31492,1162),(31493,1162),(31494,1162),(31495,1162),(31496,1162),(31497,1178),(31498,1178),(31499,1178),(31500,1178),(31501,1178),(31502,1178),(31503,1178),(31504,1178),(31505,1178),(31506,1178),(31507,1178),(31508,1178),(31509,1194),(31510,1194),(31511,1194),(31512,1194),(31513,1194),(31514,1194),(31515,1194),(31516,1194),(31517,1194),(31518,1194),(31519,1194),(31520,1194),(31521,1210),(31522,1210),(31523,1210),(31524,1210),(31525,1210),(31526,1210),(31527,1210),(31528,1210),(31529,1210),(31530,1210),(31531,1210),(31532,1210),(31533,1220),(31534,1220),(31535,1220),(31536,1220),(31537,1220),(31538,1220),(31539,1220),(31540,1220),(31541,1220),(31542,1220),(31543,1220),(31544,1220),(31545,1236),(31546,1236),(31547,1236),(31548,1236),(31549,1236),(31550,1236),(31551,1236),(31552,1236),(31553,1236),(31554,1236),(31555,1236),(31556,1236),(31557,1252),(31558,1252),(31559,1252),(31560,1252),(31561,1252),(31562,1252),(31563,1252),(31564,1252),(31565,1252),(31566,1252),(31567,1252),(31568,1252),(31569,1268),(31570,1268),(31571,1268),(31572,1268),(31573,1268),(31574,1268),(31575,1268),(31576,1268),(31577,1268),(31578,1268),(31579,1268),(31580,1268),(31581,1284),(31582,1284),(31583,1284),(31584,1284),(31585,1284),(31586,1284),(31587,1284),(31588,1284),(31589,1284),(31590,1284),(31591,1284),(31592,1284),(31593,1380),(31594,1380),(31595,1380),(31596,1380),(31597,1380),(31598,1380),(31599,1380),(31600,1380),(31601,1380),(31602,1380),(31603,1380),(31604,1380),(31605,1300),(31606,1300),(31607,1300),(31608,1300),(31609,1300),(31610,1300),(31611,1300),(31612,1300),(31613,1300),(31614,1300),(31615,1300),(31616,1300),(31617,1316),(31618,1316),(31619,1316),(31620,1316),(31621,1316),(31622,1316),(31623,1316),(31624,1316),(31625,1316),(31626,1316),(31627,1316),(31628,1316),(31629,1332),(31630,1332),(31631,1332),(31632,1332),(31633,1332),(31634,1332),(31635,1332),(31636,1332),(31637,1332),(31638,1332),(31639,1332),(31640,1332),(31641,1348),(31642,1348),(31643,1348),(31644,1348),(31645,1348),(31646,1348),(31647,1348),(31648,1348),(31649,1348),(31650,1348),(31651,1348),(31652,1348),(31653,1348),(31654,1348),(31655,1364),(31656,1364),(31657,1364),(31658,1364),(31659,1364),(31660,1364),(31661,1364),(31662,1364),(31663,1364),(31664,1364),(31665,1364),(31666,1364),(31667,1396),(31668,1396),(31669,1396),(31670,1396),(31671,1396),(31672,1396),(31673,1396),(31674,1396),(31675,1396),(31676,1396),(31677,1396),(31678,1396),(31679,1572),(31680,1572),(31681,1572),(31682,1572),(31683,1572),(31684,1572),(31685,1572),(31686,1572),(31687,1572),(31688,1572),(31689,1572),(31690,1572),(31691,1572),(31692,1572),(31693,1572),(31694,1572),(31695,1572),(31696,1572),(31697,1572),(31698,1572),(31699,1412),(31700,1412),(31701,1412),(31702,1412),(31703,1412),(31704,1412),(31705,1412),(31706,1412),(31707,1412),(31708,1412),(31709,1412),(31710,1412),(31711,1412),(31712,1412),(31713,1428),(31714,1428),(31715,1428),(31716,1428),(31717,1428),(31718,1428),(31719,1428),(31720,1428),(31721,1444),(31722,1444),(31723,1444),(31724,1444),(31725,1444),(31726,1444),(31727,1444),(31728,1444),(31729,1588),(31730,1588),(31731,1588),(31732,1588),(31733,1588),(31734,1588),(31735,1588),(31736,1588),(31737,1588),(31738,1588),(31739,1588),(31740,1588),(31741,1588),(31742,1588),(31743,1588),(31744,1588),(31745,1588),(31746,1588),(31747,1588),(31748,1588),(31749,1460),(31750,1460),(31751,1460),(31752,1460),(31753,1460),(31754,1460),(31755,1460),(31756,1460),(31757,1476),(31758,1476),(31759,1476),(31760,1476),(31761,1492),(31762,1492),(31763,1492),(31764,1492),(31765,1492),(31766,1492),(31767,1492),(31768,1492),(31769,1492),(31770,1492),(31771,1492),(31772,1492),(31773,1492),(31774,1492),(31775,1492),(31776,1492),(31777,1492),(31778,1492),(31779,1508),(31780,1508),(31781,1508),(31782,1508),(31783,1508),(31784,1508),(31785,1508),(31786,1508),(31787,1508),(31788,1508),(31789,1508),(31790,1508),(31791,1508),(31792,1508),(31793,1508),(31794,1508),(31795,1508),(31796,1508),(31797,1508),(31798,1508),(31799,1524),(31800,1524),(31801,1524),(31802,1524),(31803,1524),(31804,1524),(31805,1540),(31806,1540),(31807,1540),(31808,1540),(31809,1540),(31810,1540),(31811,1540),(31812,1540),(31813,1540),(31814,1540),(31815,1540),(31816,1540),(31817,1540),(31818,1540),(31819,1556),(31820,1556),(31821,1556),(31822,1556),(31823,1556),(31824,1556),(31825,1556),(31826,1556),(31827,1556),(31828,1556),(31829,1556),(31830,1556),(31831,1556),(31832,1556),(31833,1556),(31834,1556),(31835,1556),(31836,1556),(31837,1556),(31838,1556),(31839,1556),(31840,1556),(31841,1556),(31842,1556),(31843,1556),(31844,1556),(31845,1604),(31846,1604),(31847,1604),(31848,1604),(31849,1604),(31850,1604),(31851,1604),(31852,1604),(31853,1604),(31854,1604),(31855,1604),(31856,1604),(31857,1620),(31858,1620),(31859,1620),(31860,1620),(31861,1620),(31862,1620),(31863,1620),(31864,1620),(31865,1620),(31866,1620),(31867,1620),(31868,1620),(31869,1636),(31870,1636),(31871,1636),(31872,1636),(31873,1636),(31874,1636),(31875,1636),(31876,1636),(31877,1636),(31878,1636),(31879,1636),(31880,1636),(31881,1652),(31882,1652),(31883,1652),(31884,1652),(31885,1652),(31886,1652),(31887,1652),(31888,1652),(31889,1652),(31890,1652),(31891,1652),(31892,1652),(31893,1668),(31894,1668),(31895,1668),(31896,1668),(31897,1668),(31898,1668),(31899,1668),(31900,1668),(31901,1668),(31902,1668),(31903,1668),(31904,1668),(31905,1684),(31906,1684),(31907,1684),(31908,1684),(31909,1684),(31910,1684),(31911,1684),(31912,1684),(31913,1684),(31914,1684),(31915,1684),(31916,1684),(31917,1700),(31918,1700),(31919,1700),(31920,1700),(31921,1700),(31922,1700),(31923,1700),(31924,1700),(31925,1700),(31926,1700),(31927,1700),(31928,1700),(31929,1716),(31930,1716),(31931,1716),(31932,1716),(31933,1716),(31934,1716),(31935,1716),(31936,1716),(31937,1716),(31938,1716),(31939,1716),(31940,1716),(31941,1732),(31942,1732),(31943,1732),(31944,1732),(31945,1732),(31946,1732),(31947,1732),(31948,1732),(31949,1732),(31950,1732),(31951,1732),(31952,1732),(31953,1748),(31954,1748),(31955,1748),(31956,1748),(31957,1748),(31958,1748),(31959,1748),(31960,1748),(31961,1748),(31962,1748),(31963,1748),(31964,1748),(31965,1764),(31966,1764),(31967,1764),(31968,1764),(31969,1764),(31970,1764),(31971,1764),(31972,1764),(31973,1764),(31974,1764),(31975,1764),(31976,1764),(31977,1780),(31978,1780),(31979,1780),(31980,1780),(31981,1780),(31982,1780),(31983,1780),(31984,1780),(31985,1780),(31986,1780),(31987,1780),(31988,1780),(31989,1796),(31990,1796),(31991,1796),(31992,1796),(31993,1796),(31994,1796),(31995,1796),(31996,1796),(31997,1796),(31998,1796),(31999,1796),(32000,1796),(32001,1812),(32002,1812),(32003,1812),(32004,1812),(32005,1812),(32006,1812),(32007,1812),(32008,1812),(32009,1812),(32010,1812),(32011,1812),(32012,1812),(32013,1819),(32014,1819),(32015,1819),(32016,1819),(32017,1819),(32018,1819),(32019,1819),(32020,1819),(32021,1819),(32022,1819),(32023,1819),(32024,1819),(32025,1819),(32026,1819),(32027,1819),(32028,1819),(32029,1819),(32030,1819),(32031,1819),(32032,1819),(32033,1819),(32034,1819),(32035,1819),(32036,1819),(32037,1819),(32038,1819),(32039,1819),(32040,1819),(32041,1826),(32042,1826),(32043,1826),(32044,1826),(32045,1826),(32046,1826),(32047,1826),(32048,1826),(32049,1826),(32050,1826),(32051,1826),(32052,1826),(32053,1826),(32054,1826),(32055,1826),(32056,1826),(32057,1826),(32058,1826),(32059,1826),(32060,1826),(32061,1826),(32062,1826),(32063,1826),(32064,1826),(32065,1833),(32066,1833),(32067,1833),(32068,1833),(32069,1833),(32070,1833),(32071,1833),(32072,1833),(32073,1833),(32074,1833),(32075,1833),(32076,1833),(32077,1833),(32078,1833),(32079,1833),(32080,1833),(32081,1833),(32082,1833),(32083,1840),(32084,1840),(32085,1840),(32086,1840),(32087,1847),(32088,1847),(32089,1847),(32090,1847),(32091,1854),(32092,1854),(32093,1854),(32094,1854),(32095,1854),(32096,1854),(32097,1854),(32098,1854),(32099,1854),(32100,1854),(32101,1861),(32102,1861),(32103,1861),(32104,1861),(32105,1861),(32106,1861),(32107,1861),(32108,1861),(32109,1861),(32110,1861),(32111,1861),(32112,1861),(32113,1861),(32114,1861),(32115,1861),(32116,1861),(32117,1861),(32118,1861),(32119,1868),(32120,1868),(32121,1868),(32122,1868),(32123,1868),(32124,1868),(32125,1868),(32126,1868),(32127,1868),(32128,1868),(32129,1868),(32130,1868),(32131,1868),(32132,1868),(32133,1868),(32134,1868),(32135,1868),(32136,1868),(32137,1875),(32138,1875),(32139,1875),(32140,1875),(32141,1875),(32142,1875),(32143,1875),(32144,1875),(32145,1875),(32146,1875),(32147,1875),(32148,1875),(32149,1882),(32150,1882),(32151,1882),(32152,1882),(32153,1882),(32154,1882),(32155,1882),(32156,1882),(32157,1882),(32158,1882),(32159,1882),(32160,1882),(32161,1889),(32162,1889),(32163,1889),(32164,1889),(32165,1889),(32166,1889),(32167,1889),(32168,1889),(32169,1889),(32170,1889),(32171,1889),(32172,1889),(32173,1889),(32174,1889),(32175,1889),(32176,1889),(32177,1889),(32178,1889),(32179,1889),(32180,1889),(32181,1889),(32182,1889),(32183,1889),(32184,1889),(32185,1896),(32186,1896),(32187,1896),(32188,1896),(32189,1896),(32190,1896),(32191,1896),(32192,1896),(32193,1903),(32194,1903),(32195,1903),(32196,1903),(32197,1903),(32198,1903),(32199,1903),(32200,1903),(32201,1903),(32202,1903),(32203,1903),(32204,1903),(32205,1903),(32206,1903),(32207,1903),(32208,1903),(32209,1919),(32210,1919),(32211,1919),(32212,1919),(32213,1919),(32214,1919),(32215,1919),(32216,1919),(32217,1919),(32218,1919),(32219,1919),(32220,1919),(32221,1935),(32222,1935),(32223,1935),(32224,1935),(32225,1935),(32226,1935),(32227,1935),(32228,1935),(32229,1935),(32230,1935),(32231,1935),(32232,1935),(32233,1951),(32234,1951),(32235,1951),(32236,1951),(32237,1951),(32238,1951),(32239,1951),(32240,1951),(32241,1951),(32242,1951),(32243,1951),(32244,1951),(32245,1967),(32246,1967),(32247,1967),(32248,1967),(32249,1967),(32250,1967),(32251,1967),(32252,1967),(32253,1967),(32254,1967),(32255,1967),(32256,1967),(32257,1983),(32258,1983),(32259,1983),(32260,1983),(32261,1983),(32262,1983),(32263,1983),(32264,1983),(32265,1983),(32266,1983),(32267,1983),(32268,1983),(32269,1990),(32270,1990),(32271,1990),(32272,1990),(32273,1990),(32274,1990),(32275,1990),(32276,1990),(32277,1990),(32278,1990),(32279,1990),(32280,1990),(32281,1997),(32282,1997),(32283,1997),(32284,1997),(32285,1997),(32286,1997),(32287,1997),(32288,1997),(32289,1997),(32290,1997),(32291,1997),(32292,1997),(32293,2003),(32294,2003),(32295,2003),(32296,2003),(32297,2003),(32298,2003),(32299,2003),(32300,2003),(32301,2003),(32302,2003),(32303,2003),(32304,2003),(32305,2010),(32306,2010),(32307,2010),(32308,2010),(32309,2010),(32310,2010),(32311,2010),(32312,2010),(32313,2010),(32314,2010),(32315,2010),(32316,2010),(32317,2017),(32318,2017),(32319,2017),(32320,2017),(32321,2017),(32322,2017),(32323,2017),(32324,2017),(32325,2017),(32326,2017),(32327,2017),(32328,2017),(32329,2024),(32330,2024),(32331,2024),(32332,2024),(32333,2024),(32334,2024),(32335,2024),(32336,2024),(32337,2024),(32338,2024),(32339,2024),(32340,2024),(32341,2040),(32342,2040),(32343,2040),(32344,2040),(32345,2040),(32346,2040),(32347,2040),(32348,2040),(32349,2040),(32350,2040),(32351,2040),(32352,2040),(32353,62),(32354,62),(32355,62),(32356,62),(32357,62),(32358,62),(32359,62),(32360,62),(32361,62),(32362,62),(32363,62),(32364,62),(32365,78),(32366,78),(32367,78),(32368,78),(32369,78),(32370,78),(32371,78),(32372,78),(32373,78),(32374,78),(32375,78),(32376,78),(32377,94),(32378,94),(32379,94),(32380,94),(32381,94),(32382,94),(32383,94),(32384,94),(32385,94),(32386,94),(32387,94),(32388,94),(32389,110),(32390,110),(32391,110),(32392,110),(32393,110),(32394,110),(32395,110),(32396,110),(32397,110),(32398,110),(32399,110),(32400,110),(32401,126),(32402,126),(32403,126),(32404,126),(32405,126),(32406,126),(32407,126),(32408,126),(32409,126),(32410,126),(32411,126),(32412,126),(32413,142),(32414,142),(32415,142),(32416,142),(32417,142),(32418,142),(32419,142),(32420,142),(32421,142),(32422,142),(32423,142),(32424,142),(32425,158),(32426,158),(32427,158),(32428,158),(32429,158),(32430,158),(32431,158),(32432,158),(32433,158),(32434,158),(32435,158),(32436,158),(32437,174),(32438,174),(32439,174),(32440,174),(32441,174),(32442,174),(32443,174),(32444,174),(32445,174),(32446,174),(32447,174),(32448,174),(32449,190),(32450,190),(32451,190),(32452,190),(32453,190),(32454,190),(32455,190),(32456,190),(32457,190),(32458,190),(32459,190),(32460,190),(32461,206),(32462,206),(32463,206),(32464,206),(32465,206),(32466,206),(32467,206),(32468,206),(32469,206),(32470,206),(32471,206),(32472,206),(32473,222),(32474,222),(32475,222),(32476,222),(32477,222),(32478,222),(32479,222),(32480,222),(32481,222),(32482,222),(32483,222),(32484,222),(32485,238),(32486,238),(32487,238),(32488,238),(32489,238),(32490,238),(32491,238),(32492,238),(32493,238),(32494,238),(32495,238),(32496,238),(32497,254),(32498,254),(32499,254),(32500,254),(32501,254),(32502,254),(32503,254),(32504,254),(32505,254),(32506,254),(32507,254),(32508,254),(32509,270),(32510,270),(32511,270),(32512,270),(32513,270),(32514,270),(32515,270),(32516,270),(32517,270),(32518,270),(32519,270),(32520,270),(32521,286),(32522,286),(32523,286),(32524,286),(32525,286),(32526,286),(32527,286),(32528,286),(32529,286),(32530,286),(32531,286),(32532,286),(32533,414),(32534,414),(32535,414),(32536,414),(32537,414),(32538,414),(32539,414),(32540,414),(32541,414),(32542,414),(32543,414),(32544,414),(32545,302),(32546,302),(32547,302),(32548,302),(32549,302),(32550,302),(32551,302),(32552,302),(32553,302),(32554,302),(32555,302),(32556,302),(32557,398),(32558,398),(32559,398),(32560,398),(32561,398),(32562,398),(32563,398),(32564,398),(32565,398),(32566,398),(32567,398),(32568,398),(32569,318),(32570,318),(32571,318),(32572,318),(32573,318),(32574,318),(32575,318),(32576,318),(32577,318),(32578,318),(32579,318),(32580,318),(32581,334),(32582,334),(32583,334),(32584,334),(32585,334),(32586,334),(32587,334),(32588,334),(32589,334),(32590,334),(32591,334),(32592,334),(32593,350),(32594,350),(32595,350),(32596,350),(32597,350),(32598,350),(32599,350),(32600,350),(32601,350),(32602,350),(32603,350),(32604,350),(32605,366),(32606,366),(32607,366),(32608,366),(32609,366),(32610,366),(32611,366),(32612,366),(32613,366),(32614,366),(32615,366),(32616,366),(32617,382),(32618,382),(32619,382),(32620,382),(32621,382),(32622,382),(32623,382),(32624,382),(32625,382),(32626,382),(32627,382),(32628,382),(32629,430),(32630,430),(32631,430),(32632,430),(32633,430),(32634,430),(32635,430),(32636,430),(32637,430),(32638,430),(32639,430),(32640,430),(32641,558),(32642,558),(32643,558),(32644,558),(32645,558),(32646,558),(32647,558),(32648,558),(32649,558),(32650,558),(32651,558),(32652,558),(32653,558),(32654,558),(32655,558),(32656,558),(32657,558),(32658,558),(32659,574),(32660,574),(32661,574),(32662,574),(32663,574),(32664,574),(32665,574),(32666,574),(32667,574),(32668,574),(32669,574),(32670,574),(32671,574),(32672,574),(32673,574),(32674,574),(32675,574),(32676,574),(32677,526),(32678,526),(32679,526),(32680,526),(32681,526),(32682,526),(32683,526),(32684,526),(32685,526),(32686,526),(32687,446),(32688,446),(32689,446),(32690,446),(32691,446),(32692,446),(32693,446),(32694,446),(32695,446),(32696,446),(32697,462),(32698,462),(32699,462),(32700,462),(32701,462),(32702,462),(32703,462),(32704,462),(32705,462),(32706,462),(32707,462),(32708,462),(32709,462),(32710,462),(32711,462),(32712,462),(32713,462),(32714,462),(32715,542),(32716,542),(32717,542),(32718,542),(32719,542),(32720,542),(32721,542),(32722,542),(32723,542),(32724,542),(32725,606),(32726,606),(32727,606),(32728,606),(32729,622),(32730,622),(32731,622),(32732,622),(32733,478),(32734,478),(32735,478),(32736,478),(32737,478),(32738,478),(32739,478),(32740,478),(32741,590),(32742,590),(32743,590),(32744,590),(32745,590),(32746,590),(32747,590),(32748,590),(32749,590),(32750,590),(32751,590),(32752,590),(32753,590),(32754,590),(32755,590),(32756,590),(32757,590),(32758,590),(32759,494),(32760,494),(32761,494),(32762,494),(32763,494),(32764,494),(32765,494),(32766,494),(32767,494),(32768,494),(32769,494),(32770,494),(32771,494),(32772,494),(32773,494),(32774,494),(32775,494),(32776,494),(32777,510),(32778,510),(32779,510),(32780,510),(32781,510),(32782,510),(32783,510),(32784,510),(32785,510),(32786,510),(32787,638),(32788,638),(32789,638),(32790,638),(32791,638),(32792,638),(32793,638),(32794,638),(32795,638),(32796,638),(32797,638),(32798,638),(32799,654),(32800,654),(32801,654),(32802,654),(32803,654),(32804,654),(32805,654),(32806,654),(32807,654),(32808,654),(32809,654),(32810,654),(32811,670),(32812,670),(32813,670),(32814,670),(32815,670),(32816,670),(32817,670),(32818,670),(32819,670),(32820,670),(32821,670),(32822,670),(32823,676),(32824,676),(32825,676),(32826,676),(32827,676),(32828,676),(32829,676),(32830,676),(32831,676),(32832,676),(32833,676),(32834,676),(32835,682),(32836,682),(32837,682),(32838,682),(32839,682),(32840,682),(32841,682),(32842,682),(32843,682),(32844,682),(32845,682),(32846,682),(32847,688),(32848,688),(32849,688),(32850,688),(32851,688),(32852,688),(32853,688),(32854,688),(32855,688),(32856,688),(32857,688),(32858,688),(32859,694),(32860,694),(32861,694),(32862,694),(32863,694),(32864,694),(32865,694),(32866,694),(32867,694),(32868,694),(32869,694),(32870,694),(32871,700),(32872,700),(32873,700),(32874,700),(32875,700),(32876,700),(32877,700),(32878,700),(32879,700),(32880,700),(32881,700),(32882,700),(32883,706),(32884,706),(32885,706),(32886,706),(32887,706),(32888,706),(32889,706),(32890,706),(32891,706),(32892,706),(32893,706),(32894,706),(32895,712),(32896,712),(32897,712),(32898,712),(32899,712),(32900,712),(32901,712),(32902,712),(32903,712),(32904,712),(32905,712),(32906,712),(32907,718),(32908,718),(32909,718),(32910,718),(32911,718),(32912,718),(32913,718),(32914,718),(32915,718),(32916,718),(32917,718),(32918,718),(32919,724),(32920,724),(32921,724),(32922,724),(32923,724),(32924,724),(32925,724),(32926,724),(32927,724),(32928,724),(32929,724),(32930,724),(32931,737),(32932,737),(32933,737),(32934,737),(32935,737),(32936,737),(32937,737),(32938,737),(32939,737),(32940,737),(32941,737),(32942,737),(32943,737),(32944,737),(32945,737),(32946,737),(32947,737),(32948,737),(32949,737),(32950,737),(32951,737),(32952,737),(32953,737),(32954,737),(32955,750),(32956,750),(32957,750),(32958,750),(32959,750),(32960,750),(32961,750),(32962,750),(32963,750),(32964,750),(32965,750),(32966,750),(32967,750),(32968,750),(32969,750),(32970,750),(32971,750),(32972,750),(32973,750),(32974,750),(32975,763),(32976,763),(32977,763),(32978,763),(32979,763),(32980,763),(32981,763),(32982,763),(32983,763),(32984,763),(32985,763),(32986,763),(32987,763),(32988,763),(32989,763),(32990,763),(32991,776),(32992,776),(32993,776),(32994,776),(32995,776),(32996,776),(32997,776),(32998,776),(32999,776),(33000,776),(33001,776),(33002,776),(33003,776),(33004,776),(33005,776),(33006,776),(33007,776),(33008,776),(33009,776),(33010,776),(33011,776),(33012,776),(33013,789),(33014,789),(33015,789),(33016,789),(33017,789),(33018,789),(33019,789),(33020,789),(33021,789),(33022,789),(33023,789),(33024,789),(33025,789),(33026,789),(33027,802),(33028,802),(33029,802),(33030,802),(33031,802),(33032,802),(33033,802),(33034,802),(33035,802),(33036,802),(33037,802),(33038,802),(33039,802),(33040,802),(33041,802),(33042,802),(33043,802),(33044,802),(33045,802),(33046,802),(33047,802),(33048,802),(33049,802),(33050,802),(33051,802),(33052,802),(33053,815),(33054,815),(33055,815),(33056,815),(33057,815),(33058,815),(33059,815),(33060,815),(33061,815),(33062,815),(33063,828),(33064,828),(33065,828),(33066,828),(33067,841),(33068,841),(33069,841),(33070,841),(33071,841),(33072,841),(33073,854),(33074,854),(33075,854),(33076,854),(33077,854),(33078,854),(33079,854),(33080,854),(33081,854),(33082,854),(33083,854),(33084,854),(33085,867),(33086,867),(33087,867),(33088,867),(33089,867),(33090,867),(33091,867),(33092,867),(33093,880),(33094,880),(33095,880),(33096,880),(33097,880),(33098,880),(33099,880),(33100,880),(33101,880),(33102,880),(33103,880),(33104,880),(33105,880),(33106,880),(33107,880),(33108,880),(33109,880),(33110,880),(33111,893),(33112,893),(33113,893),(33114,893),(33115,893),(33116,893),(33117,893),(33118,893),(33119,893),(33120,893),(33121,893),(33122,893),(33123,898),(33124,898),(33125,898),(33126,898),(33127,898),(33128,898),(33129,898),(33130,898),(33131,898),(33132,898),(33133,898),(33134,898),(33135,911),(33136,911),(33137,911),(33138,911),(33139,911),(33140,911),(33141,911),(33142,911),(33143,911),(33144,911),(33145,911),(33146,911),(33147,924),(33148,924),(33149,924),(33150,924),(33151,924),(33152,924),(33153,924),(33154,924),(33155,924),(33156,924),(33157,924),(33158,924),(33159,937),(33160,937),(33161,937),(33162,937),(33163,937),(33164,937),(33165,937),(33166,937),(33167,937),(33168,937),(33169,937),(33170,937),(33171,950),(33172,950),(33173,950),(33174,950),(33175,950),(33176,950),(33177,950),(33178,950),(33179,950),(33180,950),(33181,950),(33182,950),(33183,963),(33184,963),(33185,963),(33186,963),(33187,963),(33188,963),(33189,963),(33190,963),(33191,963),(33192,963),(33193,963),(33194,963),(33195,976),(33196,976),(33197,976),(33198,976),(33199,976),(33200,976),(33201,976),(33202,976),(33203,976),(33204,976),(33205,976),(33206,976),(33207,989),(33208,989),(33209,989),(33210,989),(33211,989),(33212,989),(33213,989),(33214,989),(33215,989),(33216,989),(33217,989),(33218,989),(33219,1002),(33220,1002),(33221,1002),(33222,1002),(33223,1002),(33224,1002),(33225,1002),(33226,1002),(33227,1002),(33228,1002),(33229,1002),(33230,1002),(33231,1015),(33232,1015),(33233,1015),(33234,1015),(33235,1015),(33236,1015),(33237,1015),(33238,1015),(33239,1015),(33240,1015),(33241,1015),(33242,1015),(33243,1028),(33244,1028),(33245,1028),(33246,1028),(33247,1028),(33248,1028),(33249,1028),(33250,1028),(33251,1028),(33252,1028),(33253,1028),(33254,1028),(33255,1220),(33256,1220),(33257,1220),(33258,1220),(33259,1220),(33260,1220),(33261,1220),(33262,1220),(33263,1220),(33264,1220),(33265,1220),(33266,1220),(33267,1220),(33268,1220),(33269,1220),(33270,1220),(33271,1220),(33272,1220),(33273,1220),(33274,1220),(33275,1220),(33276,1220),(33277,1236),(33278,1236),(33279,1236),(33280,1236),(33281,1236),(33282,1236),(33283,1236),(33284,1236),(33285,1236),(33286,1236),(33287,1236),(33288,1236),(33289,1236),(33290,1236),(33291,1236),(33292,1236),(33293,1236),(33294,1236),(33295,1236),(33296,1236),(33297,1236),(33298,1236),(33299,1252),(33300,1252),(33301,1252),(33302,1252),(33303,1252),(33304,1252),(33305,1252),(33306,1252),(33307,1252),(33308,1252),(33309,1252),(33310,1252),(33311,1252),(33312,1252),(33313,1252),(33314,1252),(33315,1252),(33316,1252),(33317,1252),(33318,1252),(33319,1252),(33320,1252),(33321,1268),(33322,1268),(33323,1268),(33324,1268),(33325,1268),(33326,1268),(33327,1268),(33328,1268),(33329,1268),(33330,1268),(33331,1268),(33332,1268),(33333,1268),(33334,1268),(33335,1268),(33336,1268),(33337,1268),(33338,1268),(33339,1268),(33340,1268),(33341,1268),(33342,1268),(33343,1284),(33344,1284),(33345,1284),(33346,1284),(33347,1284),(33348,1284),(33349,1284),(33350,1284),(33351,1284),(33352,1284),(33353,1284),(33354,1284),(33355,1284),(33356,1284),(33357,1284),(33358,1284),(33359,1284),(33360,1284),(33361,1284),(33362,1284),(33363,1284),(33364,1284),(33365,1380),(33366,1380),(33367,1380),(33368,1380),(33369,1380),(33370,1380),(33371,1380),(33372,1380),(33373,1380),(33374,1380),(33375,1380),(33376,1380),(33377,1380),(33378,1380),(33379,1380),(33380,1380),(33381,1380),(33382,1380),(33383,1380),(33384,1380),(33385,1380),(33386,1380),(33387,1300),(33388,1300),(33389,1300),(33390,1300),(33391,1300),(33392,1300),(33393,1300),(33394,1300),(33395,1300),(33396,1300),(33397,1300),(33398,1300),(33399,1300),(33400,1300),(33401,1300),(33402,1300),(33403,1300),(33404,1300),(33405,1300),(33406,1300),(33407,1300),(33408,1300),(33409,1316),(33410,1316),(33411,1316),(33412,1316),(33413,1316),(33414,1316),(33415,1316),(33416,1316),(33417,1316),(33418,1316),(33419,1316),(33420,1316),(33421,1316),(33422,1316),(33423,1316),(33424,1316),(33425,1316),(33426,1316),(33427,1316),(33428,1316),(33429,1316),(33430,1316),(33431,1332),(33432,1332),(33433,1332),(33434,1332),(33435,1332),(33436,1332),(33437,1332),(33438,1332),(33439,1332),(33440,1332),(33441,1332),(33442,1332),(33443,1332),(33444,1332),(33445,1332),(33446,1332),(33447,1332),(33448,1332),(33449,1332),(33450,1332),(33451,1332),(33452,1332),(33453,1348),(33454,1348),(33455,1348),(33456,1348),(33457,1348),(33458,1348),(33459,1348),(33460,1348),(33461,1348),(33462,1348),(33463,1348),(33464,1348),(33465,1348),(33466,1348),(33467,1348),(33468,1348),(33469,1348),(33470,1348),(33471,1348),(33472,1348),(33473,1348),(33474,1348),(33475,1348),(33476,1348),(33477,1364),(33478,1364),(33479,1364),(33480,1364),(33481,1364),(33482,1364),(33483,1364),(33484,1364),(33485,1364),(33486,1364),(33487,1364),(33488,1364),(33489,1364),(33490,1364),(33491,1364),(33492,1364),(33493,1364),(33494,1364),(33495,1364),(33496,1364),(33497,1364),(33498,1364),(33499,1396),(33500,1396),(33501,1396),(33502,1396),(33503,1396),(33504,1396),(33505,1396),(33506,1396),(33507,1396),(33508,1396),(33509,1396),(33510,1396),(33511,1396),(33512,1396),(33513,1396),(33514,1396),(33515,1396),(33516,1396),(33517,1396),(33518,1396),(33519,1396),(33520,1396),(33521,20),(33522,20),(33523,20),(33524,20),(33525,18),(33526,18),(33527,18),(33528,18),(33529,23),(33530,23),(33531,23),(33532,23),(33533,17),(33534,17),(33535,17),(33536,17),(33537,19),(33538,19),(33539,19),(33540,19),(33541,15),(33542,15),(33543,15),(33544,15),(33545,16),(33546,16),(33547,16),(33548,16),(33549,24),(33550,24),(33551,24),(33552,24),(33553,28),(33554,28),(33555,28),(33556,28),(33557,32),(33558,32),(33559,32),(33560,32),(33561,21),(33562,21),(33563,21),(33564,21),(33565,33),(33566,33),(33567,33),(33568,33),(33569,34),(33570,34),(33571,34),(33572,34),(33573,35),(33574,35),(33575,35),(33576,35),(33577,22),(33578,22),(33579,22),(33580,22),(33581,1),(33582,1),(33583,1),(33584,1),(33585,1),(33586,1),(33587,1),(33588,1),(33589,6),(33590,3),(33591,3),(33592,3),(33593,3),(33594,3),(33595,3),(33596,2),(33597,2),(33598,2),(33599,2),(33600,2),(33601,2),(33602,2),(33603,2),(33604,2),(33605,2),(33606,4),(33607,4),(33608,5),(33609,5),(33610,8),(33611,8),(33612,8),(33613,8),(33614,8),(33615,8),(33616,8),(33617,8),(33618,8),(33619,8),(33620,9),(33621,9),(33622,9),(33623,9),(33624,9),(33625,9),(33626,9),(33627,9),(33628,9),(33629,9),(33630,12),(33631,12),(33632,12),(33633,12),(33634,12),(33635,12),(33636,12),(33637,14),(33638,14),(33639,10),(33640,10),(33641,10),(33642,10),(33643,10),(33644,10),(33645,10),(33646,10),(33647,10),(33648,10),(33649,11),(33650,11),(33651,11),(33652,11),(33653,11),(33654,11),(33655,11),(33656,11),(33657,11),(33658,13),(33659,13),(33660,1),(33661,1),(33662,1),(33663,1),(33664,1),(33665,1),(33666,1),(33667,1),(33668,1),(33669,1),(33670,1),(33671,1),(33672,1),(33673,1),(33674,1),(33675,1),(33676,1),(33677,1),(33678,1),(33679,1),(33680,6),(33681,6),(33682,6),(33683,6),(33684,6),(33685,6),(33686,3),(33687,3),(33688,3),(33689,3),(33690,3),(33691,3),(33692,3),(33693,3),(33694,3),(33695,3),(33696,3),(33697,3),(33698,3),(33699,3),(33700,3),(33701,3),(33702,2),(33703,2),(33704,2),(33705,2),(33706,2),(33707,2),(33708,2),(33709,2),(33710,2),(33711,2),(33712,2),(33713,2),(33714,2),(33715,2),(33716,2),(33717,2),(33718,2),(33719,2),(33720,2),(33721,2),(33722,2),(33723,2),(33724,2),(33725,2),(33726,4),(33727,4),(33728,4),(33729,4),(33730,4),(33731,4),(33732,4),(33733,4),(33734,5),(33735,5),(33736,5),(33737,5),(33738,5),(33739,5),(33740,5),(33741,5),(33742,7),(33743,7),(33744,7),(33745,7),(33746,8),(33747,8),(33748,8),(33749,8),(33750,8),(33751,8),(33752,8),(33753,8),(33754,8),(33755,8),(33756,8),(33757,8),(33758,8),(33759,8),(33760,8),(33761,8),(33762,8),(33763,8),(33764,8),(33765,8),(33766,8),(33767,8),(33768,8),(33769,8),(33770,9),(33771,9),(33772,9),(33773,9),(33774,9),(33775,9),(33776,9),(33777,9),(33778,9),(33779,9),(33780,9),(33781,9),(33782,9),(33783,9),(33784,9),(33785,9),(33786,9),(33787,9),(33788,9),(33789,9),(33790,9),(33791,9),(33792,9),(33793,9),(33794,12),(33795,12),(33796,12),(33797,12),(33798,12),(33799,12),(33800,12),(33801,12),(33802,12),(33803,12),(33804,12),(33805,12),(33806,12),(33807,12),(33808,12),(33809,12),(33810,12),(33811,12),(33812,14),(33813,14),(33814,14),(33815,14),(33816,14),(33817,14),(33818,14),(33819,14),(33820,10),(33821,10),(33822,10),(33823,10),(33824,10),(33825,10),(33826,10),(33827,10),(33828,10),(33829,10),(33830,10),(33831,10),(33832,10),(33833,10),(33834,10),(33835,10),(33836,10),(33837,10),(33838,10),(33839,10),(33840,10),(33841,10),(33842,10),(33843,10),(33844,11),(33845,11),(33846,11),(33847,11),(33848,11),(33849,11),(33850,11),(33851,11),(33852,11),(33853,11),(33854,11),(33855,11),(33856,11),(33857,11),(33858,11),(33859,11),(33860,11),(33861,11),(33862,11),(33863,11),(33864,11),(33865,11),(33866,13),(33867,13),(33868,13),(33869,13),(33870,13),(33871,13),(33872,13),(33873,13),(33874,20),(33875,20),(33876,20),(33877,20),(33878,20),(33879,20),(33880,20),(33881,20),(33882,20),(33883,20),(33884,20),(33885,20),(33886,18),(33887,18),(33888,18),(33889,18),(33890,18),(33891,18),(33892,18),(33893,18),(33894,18),(33895,18),(33896,18),(33897,18),(33898,23),(33899,23),(33900,23),(33901,23),(33902,23),(33903,23),(33904,23),(33905,23),(33906,23),(33907,23),(33908,23),(33909,23),(33910,17),(33911,17),(33912,17),(33913,17),(33914,17),(33915,17),(33916,17),(33917,17),(33918,17),(33919,17),(33920,17),(33921,17),(33922,19),(33923,19),(33924,19),(33925,19),(33926,19),(33927,19),(33928,19),(33929,19),(33930,19),(33931,19),(33932,19),(33933,19),(33934,15),(33935,15),(33936,15),(33937,15),(33938,15),(33939,15),(33940,15),(33941,15),(33942,15),(33943,15),(33944,15),(33945,15),(33946,16),(33947,16),(33948,16),(33949,16),(33950,16),(33951,16),(33952,16),(33953,16),(33954,16),(33955,16),(33956,16),(33957,16),(33958,24),(33959,24),(33960,24),(33961,24),(33962,24),(33963,24),(33964,24),(33965,24),(33966,24),(33967,24),(33968,24),(33969,24),(33970,28),(33971,28),(33972,28),(33973,28),(33974,28),(33975,28),(33976,28),(33977,28),(33978,28),(33979,28),(33980,28),(33981,28),(33982,32),(33983,32),(33984,32),(33985,32),(33986,32),(33987,32),(33988,32),(33989,32),(33990,32),(33991,32),(33992,32),(33993,32),(33994,21),(33995,21),(33996,21),(33997,21),(33998,21),(33999,21),(34000,21),(34001,21),(34002,21),(34003,21),(34004,21),(34005,21),(34006,33),(34007,33),(34008,33),(34009,33),(34010,33),(34011,33),(34012,33),(34013,33),(34014,33),(34015,33),(34016,33),(34017,33),(34018,34),(34019,34),(34020,34),(34021,34),(34022,34),(34023,34),(34024,34),(34025,34),(34026,34),(34027,34),(34028,34),(34029,34),(34030,35),(34031,35),(34032,35),(34033,35),(34034,35),(34035,35),(34036,35),(34037,35),(34038,35),(34039,35),(34040,35),(34041,35),(34042,22),(34043,22),(34044,22),(34045,22),(34046,22),(34047,22),(34048,22),(34049,22),(34050,22),(34051,22),(34052,22),(34053,22);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_attribute_cl` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_bundle_option`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_bundle_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_product_bundle_option` (
  `option_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option ID',
  `parent_id` int unsigned NOT NULL COMMENT 'Parent ID',
  `required` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Required',
  `position` int unsigned NOT NULL DEFAULT '0' COMMENT 'Position',
  `type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'Type',
  PRIMARY KEY (`option_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_BUNDLE_OPTION_PARENT_ID` (`parent_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_BNDL_OPT_PARENT_ID_[[DBPREFIX]]CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`parent_id`) REFERENCES `[[dbprefix]]catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COMMENT='Catalog Product Bundle Option';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_bundle_option`
--

LOCK TABLES `[[dbprefix]]catalog_product_bundle_option` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_option` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_product_bundle_option` VALUES (1,45,1,1,'radio'),(2,45,1,2,'radio'),(3,45,1,3,'radio'),(4,45,1,4,'radio');
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_bundle_option_value`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_bundle_option_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_product_bundle_option_value` (
  `value_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `option_id` int unsigned NOT NULL COMMENT 'Option ID',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'Title',
  `parent_product_id` int unsigned NOT NULL COMMENT 'Parent Product ID',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `[[DBPREFIX]]CAT_PRD_BNDL_OPT_VAL_OPT_ID_PARENT_PRD_ID_STORE_ID` (`option_id`,`parent_product_id`,`store_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_BNDL_OPT_VAL_OPT_ID_[[DBPREFIX]]CAT_PRD_BNDL_OPT_OPT_ID` FOREIGN KEY (`option_id`) REFERENCES `[[dbprefix]]catalog_product_bundle_option` (`option_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COMMENT='Catalog Product Bundle Option Value';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_bundle_option_value`
--

LOCK TABLES `[[dbprefix]]catalog_product_bundle_option_value` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_option_value` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_product_bundle_option_value` VALUES (1,1,0,'Sprite Stasis Ball',45),(2,2,0,'Sprite Foam Yoga Brick',45),(3,3,0,'Sprite Yoga Strap',45),(4,4,0,'Sprite Foam Roller',45);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_option_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_bundle_price_index`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_bundle_price_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_product_bundle_price_index` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `customer_group_id` int unsigned NOT NULL COMMENT 'Customer Group ID',
  `min_price` decimal(20,6) NOT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) NOT NULL COMMENT 'Max Price',
  PRIMARY KEY (`entity_id`,`website_id`,`customer_group_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_BUNDLE_PRICE_INDEX_WEBSITE_ID` (`website_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_BUNDLE_PRICE_INDEX_CUSTOMER_GROUP_ID` (`customer_group_id`),
  CONSTRAINT `FK_8DB5B8954D6EEC1C9A89C61D561C2D39` FOREIGN KEY (`customer_group_id`) REFERENCES `[[dbprefix]]customer_group` (`customer_group_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_BNDL_PRICE_IDX_ENTT_ID_[[DBPREFIX]]CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `[[dbprefix]]catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_BNDL_PRICE_IDX_WS_ID_[[DBPREFIX]]STORE_WS_WS_ID` FOREIGN KEY (`website_id`) REFERENCES `[[dbprefix]]store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Catalog Product Bundle Price Index';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_bundle_price_index`
--

LOCK TABLES `[[dbprefix]]catalog_product_bundle_price_index` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_price_index` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_price_index` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_bundle_selection`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_bundle_selection`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_product_bundle_selection` (
  `selection_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Selection ID',
  `option_id` int unsigned NOT NULL COMMENT 'Option ID',
  `parent_product_id` int unsigned NOT NULL COMMENT 'Parent Product ID',
  `product_id` int unsigned NOT NULL COMMENT 'Product ID',
  `position` int unsigned NOT NULL DEFAULT '0' COMMENT 'Position',
  `is_default` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Default',
  `selection_price_type` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Selection Price Type',
  `selection_price_value` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Selection Price Value',
  `selection_qty` decimal(12,4) DEFAULT NULL COMMENT 'Selection Qty',
  `selection_can_change_qty` smallint NOT NULL DEFAULT '0' COMMENT 'Selection Can Change Qty',
  PRIMARY KEY (`selection_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_BUNDLE_SELECTION_OPTION_ID` (`option_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_BUNDLE_SELECTION_PRODUCT_ID` (`product_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_BNDL_SELECTION_OPT_ID_[[DBPREFIX]]CAT_PRD_BNDL_OPT_OPT_ID` FOREIGN KEY (`option_id`) REFERENCES `[[dbprefix]]catalog_product_bundle_option` (`option_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_BNDL_SELECTION_PRD_ID_[[DBPREFIX]]CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `[[dbprefix]]catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COMMENT='Catalog Product Bundle Selection';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_bundle_selection`
--

LOCK TABLES `[[dbprefix]]catalog_product_bundle_selection` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_selection` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_product_bundle_selection` VALUES (1,1,45,26,1,1,0,0.0000,1.0000,1),(2,1,45,29,2,0,0,0.0000,1.0000,1),(3,1,45,32,3,0,0,0.0000,1.0000,1),(4,2,45,21,1,1,0,0.0000,1.0000,1),(5,3,45,33,1,1,0,0.0000,1.0000,1),(6,3,45,34,2,0,0,0.0000,1.0000,1),(7,3,45,35,3,0,0,0.0000,1.0000,1),(8,4,45,22,1,1,0,0.0000,1.0000,1);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_selection` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_bundle_selection_price`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_bundle_selection_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_product_bundle_selection_price` (
  `selection_id` int unsigned NOT NULL COMMENT 'Selection ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `selection_price_type` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Selection Price Type',
  `selection_price_value` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Selection Price Value',
  `parent_product_id` int unsigned NOT NULL COMMENT 'Parent Product ID',
  PRIMARY KEY (`selection_id`,`parent_product_id`,`website_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_BUNDLE_SELECTION_PRICE_WEBSITE_ID` (`website_id`),
  CONSTRAINT `FK_48A0D40A08C88AC5E40947636D598C57` FOREIGN KEY (`selection_id`) REFERENCES `[[dbprefix]]catalog_product_bundle_selection` (`selection_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_BNDL_SELECTION_PRICE_WS_ID_[[DBPREFIX]]STORE_WS_WS_ID` FOREIGN KEY (`website_id`) REFERENCES `[[dbprefix]]store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Catalog Product Bundle Selection Price';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_bundle_selection_price`
--

LOCK TABLES `[[dbprefix]]catalog_product_bundle_selection_price` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_selection_price` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_selection_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_bundle_stock_index`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_bundle_stock_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_product_bundle_stock_index` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `stock_id` smallint unsigned NOT NULL COMMENT 'Stock ID',
  `option_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `stock_status` smallint DEFAULT '0' COMMENT 'Stock Status',
  PRIMARY KEY (`entity_id`,`website_id`,`stock_id`,`option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Catalog Product Bundle Stock Index';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_bundle_stock_index`
--

LOCK TABLES `[[dbprefix]]catalog_product_bundle_stock_index` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_stock_index` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_stock_index` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_category_cl`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_category_cl`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_product_category_cl` (
  `version_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Version ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  PRIMARY KEY (`version_id`)
) ENGINE=InnoDB AUTO_INCREMENT=19826 DEFAULT CHARSET=utf8mb4 COMMENT='[[dbprefix]]catalog_product_category_cl';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_category_cl`
--

LOCK TABLES `[[dbprefix]]catalog_product_category_cl` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_category_cl` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_product_category_cl` VALUES (1,1),(2,1),(3,1),(4,1),(5,1),(6,2),(7,2),(8,2),(9,2),(10,2),(11,2),(12,2),(13,2),(14,2),(15,3),(16,3),(17,3),(18,3),(19,3),(20,3),(21,4),(22,4),(23,4),(24,4),(25,4),(26,4),(27,4),(28,4),(29,4),(30,5),(31,5),(32,5),(33,5),(34,5),(35,5),(36,5),(37,5),(38,5),(39,6),(40,6),(41,6),(42,6),(43,6),(44,6),(45,7),(46,7),(47,7),(48,7),(49,7),(50,7),(51,8),(52,8),(53,8),(54,8),(55,8),(56,8),(57,9),(58,9),(59,9),(60,9),(61,9),(62,9),(63,10),(64,10),(65,10),(66,10),(67,10),(68,10),(69,10),(70,10),(71,10),(72,11),(73,11),(74,11),(75,11),(76,11),(77,11),(78,11),(79,11),(80,11),(81,12),(82,12),(83,12),(84,12),(85,12),(86,12),(87,13),(88,13),(89,13),(90,13),(91,13),(92,13),(93,13),(94,13),(95,13),(96,14),(97,14),(98,14),(99,14),(100,14),(101,14),(102,14),(103,14),(104,15),(105,15),(106,15),(107,15),(108,15),(109,16),(110,16),(111,16),(112,16),(113,16),(114,16),(115,16),(116,16),(117,16),(118,17),(119,17),(120,17),(121,17),(122,17),(123,17),(124,18),(125,18),(126,18),(127,18),(128,18),(129,18),(130,19),(131,19),(132,19),(133,19),(134,19),(135,19),(136,19),(137,19),(138,19),(139,19),(140,20),(141,20),(142,20),(143,20),(144,20),(145,20),(146,21),(147,21),(148,21),(149,21),(150,21),(151,21),(152,22),(153,22),(154,22),(155,22),(156,22),(157,22),(158,23),(159,23),(160,23),(161,23),(162,23),(163,23),(164,24),(165,24),(166,24),(167,24),(168,24),(169,24),(170,24),(171,25),(172,25),(173,25),(174,25),(175,25),(176,25),(177,25),(178,25),(179,26),(180,26),(181,26),(182,26),(183,26),(184,26),(185,26),(186,26),(187,27),(188,27),(189,27),(190,27),(191,27),(192,27),(193,27),(194,27),(195,28),(196,28),(197,28),(198,28),(199,28),(200,28),(201,28),(202,28),(203,29),(204,29),(205,29),(206,29),(207,29),(208,29),(209,29),(210,29),(211,30),(212,30),(213,30),(214,30),(215,30),(216,30),(217,30),(218,30),(219,31),(220,31),(221,31),(222,31),(223,31),(224,31),(225,31),(226,31),(227,32),(228,32),(229,32),(230,32),(231,32),(232,32),(233,32),(234,32),(235,33),(236,33),(237,33),(238,33),(239,33),(240,33),(241,34),(242,34),(243,34),(244,34),(245,34),(246,34),(247,34),(248,35),(249,35),(250,35),(251,35),(252,35),(253,35),(254,35),(255,36),(256,36),(257,36),(258,36),(259,36),(260,36),(261,37),(262,37),(263,37),(264,37),(265,37),(266,37),(267,38),(268,38),(269,38),(270,38),(271,38),(272,38),(273,38),(274,38),(275,38),(276,39),(277,39),(278,39),(279,39),(280,39),(281,39),(282,39),(283,39),(284,39),(285,40),(286,40),(287,40),(288,40),(289,40),(290,40),(291,40),(292,40),(293,40),(294,41),(295,41),(296,41),(297,41),(298,41),(299,41),(300,41),(301,42),(302,42),(303,42),(304,42),(305,42),(306,42),(307,42),(308,43),(309,43),(310,43),(311,43),(312,43),(313,43),(314,44),(315,44),(316,44),(317,44),(318,44),(319,44),(320,44),(321,44),(322,44),(323,45),(324,45),(325,45),(326,45),(327,45),(328,45),(329,45),(330,45),(331,45),(332,45),(333,45),(334,46),(335,46),(336,46),(337,46),(338,46),(339,47),(340,48),(341,49),(342,50),(343,51),(344,52),(345,53),(346,54),(347,55),(348,56),(349,57),(350,58),(351,59),(352,60),(353,61),(354,62),(355,63),(356,64),(357,65),(358,66),(359,67),(360,68),(361,69),(362,70),(363,71),(364,72),(365,73),(366,74),(367,75),(368,76),(369,77),(370,78),(371,79),(372,80),(373,81),(374,82),(375,83),(376,84),(377,85),(378,86),(379,87),(380,88),(381,89),(382,90),(383,91),(384,92),(385,93),(386,94),(387,95),(388,96),(389,97),(390,98),(391,99),(392,100),(393,101),(394,102),(395,103),(396,104),(397,105),(398,106),(399,107),(400,108),(401,109),(402,110),(403,111),(404,112),(405,113),(406,114),(407,115),(408,116),(409,117),(410,118),(411,119),(412,120),(413,121),(414,122),(415,123),(416,124),(417,125),(418,126),(419,127),(420,128),(421,129),(422,130),(423,131),(424,132),(425,133),(426,134),(427,135),(428,136),(429,137),(430,138),(431,139),(432,140),(433,141),(434,142),(435,143),(436,144),(437,145),(438,146),(439,47),(440,47),(441,47),(442,48),(443,48),(444,48),(445,49),(446,49),(447,49),(448,50),(449,50),(450,50),(451,51),(452,51),(453,51),(454,52),(455,52),(456,52),(457,53),(458,53),(459,53),(460,54),(461,54),(462,54),(463,55),(464,55),(465,55),(466,56),(467,56),(468,56),(469,57),(470,57),(471,57),(472,58),(473,58),(474,58),(475,59),(476,59),(477,59),(478,60),(479,60),(480,60),(481,61),(482,61),(483,61),(484,62),(485,62),(486,62),(487,63),(488,64),(489,65),(490,66),(491,67),(492,68),(493,69),(494,70),(495,71),(496,72),(497,73),(498,74),(499,75),(500,76),(501,77),(502,78),(503,79),(504,79),(505,79),(506,80),(507,80),(508,80),(509,81),(510,81),(511,81),(512,82),(513,82),(514,82),(515,83),(516,83),(517,83),(518,84),(519,84),(520,84),(521,85),(522,85),(523,85),(524,86),(525,86),(526,86),(527,87),(528,87),(529,87),(530,88),(531,88),(532,88),(533,89),(534,89),(535,89),(536,90),(537,90),(538,90),(539,91),(540,91),(541,91),(542,92),(543,92),(544,92),(545,93),(546,93),(547,93),(548,94),(549,94),(550,94),(551,95),(552,95),(553,95),(554,96),(555,96),(556,96),(557,97),(558,97),(559,97),(560,98),(561,98),(562,98),(563,99),(564,99),(565,99),(566,100),(567,100),(568,100),(569,101),(570,101),(571,101),(572,102),(573,102),(574,102),(575,103),(576,103),(577,103),(578,104),(579,104),(580,104),(581,105),(582,105),(583,105),(584,106),(585,106),(586,106),(587,107),(588,107),(589,107),(590,108),(591,108),(592,108),(593,109),(594,109),(595,109),(596,110),(597,110),(598,110),(599,111),(600,112),(601,113),(602,114),(603,115),(604,116),(605,117),(606,118),(607,119),(608,120),(609,121),(610,122),(611,123),(612,124),(613,125),(614,126),(615,127),(616,128),(617,129),(618,130),(619,131),(620,132),(621,133),(622,134),(623,135),(624,136),(625,137),(626,138),(627,139),(628,140),(629,141),(630,142),(631,143),(632,144),(633,145),(634,146),(635,47),(636,47),(637,47),(638,47),(639,47),(640,47),(641,48),(642,48),(643,48),(644,48),(645,48),(646,48),(647,49),(648,49),(649,49),(650,49),(651,49),(652,49),(653,50),(654,50),(655,50),(656,50),(657,50),(658,50),(659,51),(660,51),(661,51),(662,51),(663,51),(664,51),(665,52),(666,52),(667,52),(668,52),(669,52),(670,52),(671,53),(672,53),(673,53),(674,53),(675,53),(676,53),(677,54),(678,54),(679,54),(680,54),(681,54),(682,54),(683,55),(684,55),(685,55),(686,55),(687,55),(688,55),(689,56),(690,56),(691,56),(692,56),(693,56),(694,56),(695,57),(696,57),(697,57),(698,57),(699,57),(700,57),(701,58),(702,58),(703,58),(704,58),(705,58),(706,58),(707,59),(708,59),(709,59),(710,59),(711,59),(712,59),(713,60),(714,60),(715,60),(716,60),(717,60),(718,60),(719,61),(720,61),(721,61),(722,61),(723,61),(724,61),(725,62),(726,62),(727,62),(728,62),(729,62),(730,62),(731,62),(732,62),(733,62),(734,63),(735,63),(736,63),(737,63),(738,63),(739,63),(740,64),(741,64),(742,64),(743,64),(744,64),(745,64),(746,65),(747,65),(748,65),(749,65),(750,65),(751,65),(752,66),(753,66),(754,66),(755,66),(756,66),(757,66),(758,67),(759,67),(760,67),(761,67),(762,67),(763,67),(764,68),(765,68),(766,68),(767,68),(768,68),(769,68),(770,69),(771,69),(772,69),(773,69),(774,69),(775,69),(776,70),(777,70),(778,70),(779,70),(780,70),(781,70),(782,71),(783,71),(784,71),(785,71),(786,71),(787,71),(788,72),(789,72),(790,72),(791,72),(792,72),(793,72),(794,73),(795,73),(796,73),(797,73),(798,73),(799,73),(800,74),(801,74),(802,74),(803,74),(804,74),(805,74),(806,75),(807,75),(808,75),(809,75),(810,75),(811,75),(812,76),(813,76),(814,76),(815,76),(816,76),(817,76),(818,77),(819,77),(820,77),(821,77),(822,77),(823,77),(824,78),(825,78),(826,78),(827,78),(828,78),(829,78),(830,78),(831,78),(832,78),(833,79),(834,79),(835,79),(836,79),(837,79),(838,79),(839,80),(840,80),(841,80),(842,80),(843,80),(844,80),(845,81),(846,81),(847,81),(848,81),(849,81),(850,81),(851,82),(852,82),(853,82),(854,82),(855,82),(856,82),(857,83),(858,83),(859,83),(860,83),(861,83),(862,83),(863,84),(864,84),(865,84),(866,84),(867,84),(868,84),(869,85),(870,85),(871,85),(872,85),(873,85),(874,85),(875,86),(876,86),(877,86),(878,86),(879,86),(880,86),(881,87),(882,87),(883,87),(884,87),(885,87),(886,87),(887,88),(888,88),(889,88),(890,88),(891,88),(892,88),(893,89),(894,89),(895,89),(896,89),(897,89),(898,89),(899,90),(900,90),(901,90),(902,90),(903,90),(904,90),(905,91),(906,91),(907,91),(908,91),(909,91),(910,91),(911,92),(912,92),(913,92),(914,92),(915,92),(916,92),(917,93),(918,93),(919,93),(920,93),(921,93),(922,93),(923,94),(924,94),(925,94),(926,94),(927,94),(928,94),(929,94),(930,94),(931,94),(932,95),(933,95),(934,95),(935,95),(936,95),(937,95),(938,96),(939,96),(940,96),(941,96),(942,96),(943,96),(944,97),(945,97),(946,97),(947,97),(948,97),(949,97),(950,98),(951,98),(952,98),(953,98),(954,98),(955,98),(956,99),(957,99),(958,99),(959,99),(960,99),(961,99),(962,100),(963,100),(964,100),(965,100),(966,100),(967,100),(968,101),(969,101),(970,101),(971,101),(972,101),(973,101),(974,102),(975,102),(976,102),(977,102),(978,102),(979,102),(980,103),(981,103),(982,103),(983,103),(984,103),(985,103),(986,104),(987,104),(988,104),(989,104),(990,104),(991,104),(992,105),(993,105),(994,105),(995,105),(996,105),(997,105),(998,106),(999,106),(1000,106),(1001,106),(1002,106),(1003,106),(1004,107),(1005,107),(1006,107),(1007,107),(1008,107),(1009,107),(1010,108),(1011,108),(1012,108),(1013,108),(1014,108),(1015,108),(1016,109),(1017,109),(1018,109),(1019,109),(1020,109),(1021,109),(1022,110),(1023,110),(1024,110),(1025,110),(1026,110),(1027,110),(1028,110),(1029,110),(1030,110),(1031,111),(1032,111),(1033,111),(1034,111),(1035,111),(1036,111),(1037,112),(1038,112),(1039,112),(1040,112),(1041,112),(1042,112),(1043,113),(1044,113),(1045,113),(1046,113),(1047,113),(1048,113),(1049,114),(1050,114),(1051,114),(1052,114),(1053,114),(1054,114),(1055,115),(1056,115),(1057,115),(1058,115),(1059,115),(1060,115),(1061,116),(1062,116),(1063,116),(1064,116),(1065,116),(1066,116),(1067,117),(1068,117),(1069,117),(1070,117),(1071,117),(1072,117),(1073,118),(1074,118),(1075,118),(1076,118),(1077,118),(1078,118),(1079,119),(1080,119),(1081,119),(1082,119),(1083,119),(1084,119),(1085,120),(1086,120),(1087,120),(1088,120),(1089,120),(1090,120),(1091,121),(1092,121),(1093,121),(1094,121),(1095,121),(1096,121),(1097,122),(1098,122),(1099,122),(1100,122),(1101,122),(1102,122),(1103,123),(1104,123),(1105,123),(1106,123),(1107,123),(1108,123),(1109,124),(1110,124),(1111,124),(1112,124),(1113,124),(1114,124),(1115,125),(1116,125),(1117,125),(1118,125),(1119,125),(1120,125),(1121,126),(1122,126),(1123,126),(1124,126),(1125,126),(1126,126),(1127,126),(1128,126),(1129,126),(1130,127),(1131,127),(1132,127),(1133,127),(1134,127),(1135,127),(1136,128),(1137,128),(1138,128),(1139,128),(1140,128),(1141,128),(1142,129),(1143,129),(1144,129),(1145,129),(1146,129),(1147,129),(1148,130),(1149,130),(1150,130),(1151,130),(1152,130),(1153,130),(1154,131),(1155,131),(1156,131),(1157,131),(1158,131),(1159,131),(1160,132),(1161,132),(1162,132),(1163,132),(1164,132),(1165,132),(1166,133),(1167,133),(1168,133),(1169,133),(1170,133),(1171,133),(1172,134),(1173,134),(1174,134),(1175,134),(1176,134),(1177,134),(1178,135),(1179,135),(1180,135),(1181,135),(1182,135),(1183,135),(1184,136),(1185,136),(1186,136),(1187,136),(1188,136),(1189,136),(1190,137),(1191,137),(1192,137),(1193,137),(1194,137),(1195,137),(1196,138),(1197,138),(1198,138),(1199,138),(1200,138),(1201,138),(1202,139),(1203,139),(1204,139),(1205,139),(1206,139),(1207,139),(1208,140),(1209,140),(1210,140),(1211,140),(1212,140),(1213,140),(1214,141),(1215,141),(1216,141),(1217,141),(1218,141),(1219,141),(1220,142),(1221,142),(1222,142),(1223,142),(1224,142),(1225,142),(1226,142),(1227,142),(1228,142),(1229,143),(1230,143),(1231,143),(1232,143),(1233,143),(1234,143),(1235,144),(1236,144),(1237,144),(1238,144),(1239,144),(1240,144),(1241,145),(1242,145),(1243,145),(1244,145),(1245,145),(1246,145),(1247,146),(1248,146),(1249,146),(1250,146),(1251,146),(1252,146),(1253,147),(1254,148),(1255,149),(1256,150),(1257,151),(1258,152),(1259,153),(1260,154),(1261,155),(1262,156),(1263,157),(1264,158),(1265,159),(1266,160),(1267,161),(1268,162),(1269,163),(1270,164),(1271,165),(1272,166),(1273,167),(1274,168),(1275,169),(1276,170),(1277,171),(1278,172),(1279,173),(1280,174),(1281,175),(1282,176),(1283,177),(1284,178),(1285,179),(1286,180),(1287,181),(1288,182),(1289,183),(1290,184),(1291,185),(1292,186),(1293,187),(1294,188),(1295,189),(1296,190),(1297,191),(1298,192),(1299,193),(1300,194),(1301,195),(1302,196),(1303,197),(1304,198),(1305,199),(1306,200),(1307,201),(1308,202),(1309,203),(1310,204),(1311,205),(1312,206),(1313,207),(1314,208),(1315,209),(1316,210),(1317,211),(1318,212),(1319,213),(1320,214),(1321,215),(1322,216),(1323,217),(1324,218),(1325,219),(1326,220),(1327,221),(1328,222),(1329,223),(1330,224),(1331,225),(1332,226),(1333,227),(1334,228),(1335,229),(1336,230),(1337,231),(1338,232),(1339,233),(1340,234),(1341,235),(1342,236),(1343,237),(1344,238),(1345,239),(1346,240),(1347,241),(1348,242),(1349,243),(1350,244),(1351,245),(1352,246),(1353,147),(1354,148),(1355,149),(1356,150),(1357,151),(1358,152),(1359,153),(1360,154),(1361,155),(1362,156),(1363,157),(1364,158),(1365,159),(1366,160),(1367,161),(1368,162),(1369,163),(1370,164),(1371,165),(1372,166),(1373,167),(1374,168),(1375,169),(1376,170),(1377,171),(1378,172),(1379,173),(1380,174),(1381,175),(1382,176),(1383,177),(1384,178),(1385,179),(1386,180),(1387,181),(1388,182),(1389,183),(1390,184),(1391,185),(1392,186),(1393,187),(1394,188),(1395,189),(1396,190),(1397,191),(1398,192),(1399,193),(1400,194),(1401,195),(1402,196),(1403,197),(1404,198),(1405,199),(1406,200),(1407,201),(1408,202),(1409,203),(1410,204),(1411,205),(1412,206),(1413,207),(1414,208),(1415,209),(1416,210),(1417,211),(1418,212),(1419,213),(1420,214),(1421,215),(1422,216),(1423,217),(1424,218),(1425,219),(1426,220),(1427,221),(1428,222),(1429,223),(1430,224),(1431,225),(1432,226),(1433,227),(1434,228),(1435,229),(1436,230),(1437,231),(1438,232),(1439,233),(1440,234),(1441,235),(1442,236),(1443,237),(1444,238),(1445,239),(1446,240),(1447,241),(1448,242),(1449,243),(1450,244),(1451,245),(1452,246),(1453,147),(1454,147),(1455,147),(1456,147),(1457,147),(1458,147),(1459,148),(1460,148),(1461,148),(1462,148),(1463,148),(1464,148),(1465,149),(1466,149),(1467,149),(1468,149),(1469,149),(1470,149),(1471,150),(1472,150),(1473,150),(1474,150),(1475,150),(1476,150),(1477,151),(1478,151),(1479,151),(1480,151),(1481,151),(1482,151),(1483,152),(1484,152),(1485,152),(1486,152),(1487,152),(1488,152),(1489,153),(1490,153),(1491,153),(1492,153),(1493,153),(1494,153),(1495,154),(1496,154),(1497,154),(1498,154),(1499,154),(1500,154),(1501,155),(1502,155),(1503,155),(1504,155),(1505,155),(1506,155),(1507,156),(1508,156),(1509,156),(1510,156),(1511,156),(1512,156),(1513,157),(1514,157),(1515,157),(1516,157),(1517,157),(1518,157),(1519,158),(1520,158),(1521,158),(1522,158),(1523,158),(1524,158),(1525,158),(1526,158),(1527,158),(1528,159),(1529,159),(1530,159),(1531,159),(1532,159),(1533,159),(1534,160),(1535,160),(1536,160),(1537,160),(1538,160),(1539,160),(1540,161),(1541,161),(1542,161),(1543,161),(1544,161),(1545,161),(1546,162),(1547,162),(1548,162),(1549,162),(1550,162),(1551,162),(1552,163),(1553,163),(1554,163),(1555,163),(1556,163),(1557,163),(1558,164),(1559,164),(1560,164),(1561,164),(1562,164),(1563,164),(1564,165),(1565,165),(1566,165),(1567,165),(1568,165),(1569,165),(1570,166),(1571,166),(1572,166),(1573,166),(1574,166),(1575,166),(1576,167),(1577,167),(1578,167),(1579,167),(1580,167),(1581,167),(1582,168),(1583,168),(1584,168),(1585,168),(1586,168),(1587,168),(1588,169),(1589,169),(1590,169),(1591,169),(1592,169),(1593,169),(1594,170),(1595,170),(1596,170),(1597,170),(1598,170),(1599,170),(1600,171),(1601,171),(1602,171),(1603,171),(1604,171),(1605,171),(1606,172),(1607,172),(1608,172),(1609,172),(1610,172),(1611,172),(1612,173),(1613,173),(1614,173),(1615,173),(1616,173),(1617,173),(1618,174),(1619,174),(1620,174),(1621,174),(1622,174),(1623,174),(1624,174),(1625,174),(1626,174),(1627,175),(1628,175),(1629,175),(1630,175),(1631,175),(1632,175),(1633,176),(1634,176),(1635,176),(1636,176),(1637,176),(1638,176),(1639,177),(1640,177),(1641,177),(1642,177),(1643,177),(1644,177),(1645,178),(1646,178),(1647,178),(1648,178),(1649,178),(1650,178),(1651,179),(1652,179),(1653,179),(1654,179),(1655,179),(1656,179),(1657,180),(1658,180),(1659,180),(1660,180),(1661,180),(1662,180),(1663,181),(1664,181),(1665,181),(1666,181),(1667,181),(1668,181),(1669,182),(1670,182),(1671,182),(1672,182),(1673,182),(1674,182),(1675,183),(1676,183),(1677,183),(1678,183),(1679,183),(1680,183),(1681,184),(1682,184),(1683,184),(1684,184),(1685,184),(1686,184),(1687,185),(1688,185),(1689,185),(1690,185),(1691,185),(1692,185),(1693,186),(1694,186),(1695,186),(1696,186),(1697,186),(1698,186),(1699,187),(1700,187),(1701,187),(1702,187),(1703,187),(1704,187),(1705,188),(1706,188),(1707,188),(1708,188),(1709,188),(1710,188),(1711,189),(1712,189),(1713,189),(1714,189),(1715,189),(1716,189),(1717,190),(1718,190),(1719,190),(1720,190),(1721,190),(1722,190),(1723,190),(1724,190),(1725,190),(1726,191),(1727,191),(1728,191),(1729,191),(1730,191),(1731,191),(1732,192),(1733,192),(1734,192),(1735,192),(1736,192),(1737,192),(1738,193),(1739,193),(1740,193),(1741,193),(1742,193),(1743,193),(1744,194),(1745,194),(1746,194),(1747,194),(1748,194),(1749,194),(1750,195),(1751,195),(1752,195),(1753,195),(1754,195),(1755,195),(1756,196),(1757,196),(1758,196),(1759,196),(1760,196),(1761,196),(1762,197),(1763,197),(1764,197),(1765,197),(1766,197),(1767,197),(1768,198),(1769,198),(1770,198),(1771,198),(1772,198),(1773,198),(1774,199),(1775,199),(1776,199),(1777,199),(1778,199),(1779,199),(1780,200),(1781,200),(1782,200),(1783,200),(1784,200),(1785,200),(1786,201),(1787,201),(1788,201),(1789,201),(1790,201),(1791,201),(1792,202),(1793,202),(1794,202),(1795,202),(1796,202),(1797,202),(1798,203),(1799,203),(1800,203),(1801,203),(1802,203),(1803,203),(1804,204),(1805,204),(1806,204),(1807,204),(1808,204),(1809,204),(1810,205),(1811,205),(1812,205),(1813,205),(1814,205),(1815,205),(1816,206),(1817,206),(1818,206),(1819,206),(1820,206),(1821,206),(1822,206),(1823,206),(1824,206),(1825,207),(1826,207),(1827,207),(1828,207),(1829,207),(1830,207),(1831,208),(1832,208),(1833,208),(1834,208),(1835,208),(1836,208),(1837,209),(1838,209),(1839,209),(1840,209),(1841,209),(1842,209),(1843,210),(1844,210),(1845,210),(1846,210),(1847,210),(1848,210),(1849,211),(1850,211),(1851,211),(1852,211),(1853,211),(1854,211),(1855,212),(1856,212),(1857,212),(1858,212),(1859,212),(1860,212),(1861,213),(1862,213),(1863,213),(1864,213),(1865,213),(1866,213),(1867,214),(1868,214),(1869,214),(1870,214),(1871,214),(1872,214),(1873,215),(1874,215),(1875,215),(1876,215),(1877,215),(1878,215),(1879,216),(1880,216),(1881,216),(1882,216),(1883,216),(1884,216),(1885,217),(1886,217),(1887,217),(1888,217),(1889,217),(1890,217),(1891,218),(1892,218),(1893,218),(1894,218),(1895,218),(1896,218),(1897,219),(1898,219),(1899,219),(1900,219),(1901,219),(1902,219),(1903,220),(1904,220),(1905,220),(1906,220),(1907,220),(1908,220),(1909,221),(1910,221),(1911,221),(1912,221),(1913,221),(1914,221),(1915,222),(1916,222),(1917,222),(1918,222),(1919,222),(1920,222),(1921,222),(1922,222),(1923,222),(1924,223),(1925,223),(1926,223),(1927,223),(1928,223),(1929,223),(1930,224),(1931,224),(1932,224),(1933,224),(1934,224),(1935,224),(1936,225),(1937,225),(1938,225),(1939,225),(1940,225),(1941,225),(1942,226),(1943,226),(1944,226),(1945,226),(1946,226),(1947,226),(1948,227),(1949,227),(1950,227),(1951,227),(1952,227),(1953,227),(1954,228),(1955,228),(1956,228),(1957,228),(1958,228),(1959,228),(1960,229),(1961,229),(1962,229),(1963,229),(1964,229),(1965,229),(1966,230),(1967,230),(1968,230),(1969,230),(1970,230),(1971,230),(1972,231),(1973,231),(1974,231),(1975,231),(1976,231),(1977,231),(1978,232),(1979,232),(1980,232),(1981,232),(1982,232),(1983,232),(1984,233),(1985,233),(1986,233),(1987,233),(1988,233),(1989,233),(1990,234),(1991,234),(1992,234),(1993,234),(1994,234),(1995,234),(1996,235),(1997,235),(1998,235),(1999,235),(2000,235),(2001,235),(2002,236),(2003,236),(2004,236),(2005,236),(2006,236),(2007,236),(2008,237),(2009,237),(2010,237),(2011,237),(2012,237),(2013,237),(2014,238),(2015,238),(2016,238),(2017,238),(2018,238),(2019,238),(2020,238),(2021,238),(2022,238),(2023,239),(2024,239),(2025,239),(2026,239),(2027,239),(2028,239),(2029,240),(2030,240),(2031,240),(2032,240),(2033,240),(2034,240),(2035,241),(2036,241),(2037,241),(2038,241),(2039,241),(2040,241),(2041,242),(2042,242),(2043,242),(2044,242),(2045,242),(2046,242),(2047,243),(2048,243),(2049,243),(2050,243),(2051,243),(2052,243),(2053,244),(2054,244),(2055,244),(2056,244),(2057,244),(2058,244),(2059,245),(2060,245),(2061,245),(2062,245),(2063,245),(2064,245),(2065,246),(2066,246),(2067,246),(2068,246),(2069,246),(2070,246),(2071,247),(2072,248),(2073,249),(2074,250),(2075,251),(2076,252),(2077,253),(2078,254),(2079,255),(2080,256),(2081,257),(2082,258),(2083,259),(2084,260),(2085,261),(2086,262),(2087,263),(2088,264),(2089,265),(2090,266),(2091,267),(2092,268),(2093,269),(2094,270),(2095,271),(2096,272),(2097,273),(2098,274),(2099,275),(2100,276),(2101,277),(2102,278),(2103,279),(2104,280),(2105,281),(2106,282),(2107,283),(2108,284),(2109,285),(2110,286),(2111,287),(2112,288),(2113,289),(2114,290),(2115,291),(2116,292),(2117,293),(2118,294),(2119,295),(2120,296),(2121,297),(2122,298),(2123,299),(2124,300),(2125,301),(2126,302),(2127,303),(2128,304),(2129,305),(2130,306),(2131,307),(2132,308),(2133,309),(2134,310),(2135,311),(2136,312),(2137,313),(2138,314),(2139,315),(2140,316),(2141,317),(2142,318),(2143,319),(2144,320),(2145,321),(2146,322),(2147,323),(2148,324),(2149,325),(2150,326),(2151,327),(2152,328),(2153,329),(2154,330),(2155,331),(2156,332),(2157,333),(2158,334),(2159,335),(2160,336),(2161,337),(2162,338),(2163,339),(2164,340),(2165,341),(2166,342),(2167,343),(2168,344),(2169,345),(2170,346),(2171,247),(2172,248),(2173,249),(2174,250),(2175,251),(2176,252),(2177,253),(2178,254),(2179,255),(2180,256),(2181,257),(2182,258),(2183,259),(2184,260),(2185,261),(2186,262),(2187,263),(2188,264),(2189,265),(2190,266),(2191,267),(2192,268),(2193,269),(2194,270),(2195,271),(2196,272),(2197,273),(2198,274),(2199,275),(2200,276),(2201,277),(2202,278),(2203,279),(2204,280),(2205,281),(2206,282),(2207,283),(2208,284),(2209,285),(2210,286),(2211,287),(2212,287),(2213,287),(2214,288),(2215,288),(2216,288),(2217,289),(2218,289),(2219,289),(2220,290),(2221,290),(2222,290),(2223,291),(2224,291),(2225,291),(2226,292),(2227,292),(2228,292),(2229,293),(2230,293),(2231,293),(2232,294),(2233,294),(2234,294),(2235,295),(2236,295),(2237,295),(2238,296),(2239,296),(2240,296),(2241,297),(2242,297),(2243,297),(2244,298),(2245,298),(2246,298),(2247,299),(2248,299),(2249,299),(2250,300),(2251,300),(2252,300),(2253,301),(2254,301),(2255,301),(2256,302),(2257,302),(2258,302),(2259,303),(2260,304),(2261,305),(2262,306),(2263,307),(2264,308),(2265,309),(2266,310),(2267,311),(2268,312),(2269,313),(2270,314),(2271,315),(2272,316),(2273,317),(2274,318),(2275,319),(2276,320),(2277,321),(2278,322),(2279,323),(2280,324),(2281,325),(2282,326),(2283,327),(2284,328),(2285,329),(2286,330),(2287,331),(2288,332),(2289,333),(2290,334),(2291,335),(2292,336),(2293,337),(2294,338),(2295,339),(2296,340),(2297,341),(2298,342),(2299,343),(2300,344),(2301,345),(2302,346),(2303,247),(2304,247),(2305,247),(2306,247),(2307,247),(2308,247),(2309,248),(2310,248),(2311,248),(2312,248),(2313,248),(2314,248),(2315,249),(2316,249),(2317,249),(2318,249),(2319,249),(2320,249),(2321,250),(2322,250),(2323,250),(2324,250),(2325,250),(2326,250),(2327,251),(2328,251),(2329,251),(2330,251),(2331,251),(2332,251),(2333,252),(2334,252),(2335,252),(2336,252),(2337,252),(2338,252),(2339,253),(2340,253),(2341,253),(2342,253),(2343,253),(2344,253),(2345,254),(2346,254),(2347,254),(2348,254),(2349,254),(2350,254),(2351,254),(2352,254),(2353,254),(2354,255),(2355,255),(2356,255),(2357,255),(2358,255),(2359,255),(2360,256),(2361,256),(2362,256),(2363,256),(2364,256),(2365,256),(2366,257),(2367,257),(2368,257),(2369,257),(2370,257),(2371,257),(2372,258),(2373,258),(2374,258),(2375,258),(2376,258),(2377,258),(2378,259),(2379,259),(2380,259),(2381,259),(2382,259),(2383,259),(2384,260),(2385,260),(2386,260),(2387,260),(2388,260),(2389,260),(2390,261),(2391,261),(2392,261),(2393,261),(2394,261),(2395,261),(2396,262),(2397,262),(2398,262),(2399,262),(2400,262),(2401,262),(2402,263),(2403,263),(2404,263),(2405,263),(2406,263),(2407,263),(2408,264),(2409,264),(2410,264),(2411,264),(2412,264),(2413,264),(2414,265),(2415,265),(2416,265),(2417,265),(2418,265),(2419,265),(2420,266),(2421,266),(2422,266),(2423,266),(2424,266),(2425,266),(2426,267),(2427,267),(2428,267),(2429,267),(2430,267),(2431,267),(2432,268),(2433,268),(2434,268),(2435,268),(2436,268),(2437,268),(2438,269),(2439,269),(2440,269),(2441,269),(2442,269),(2443,269),(2444,270),(2445,270),(2446,270),(2447,270),(2448,270),(2449,270),(2450,270),(2451,270),(2452,270),(2453,271),(2454,271),(2455,271),(2456,271),(2457,271),(2458,271),(2459,272),(2460,272),(2461,272),(2462,272),(2463,272),(2464,272),(2465,273),(2466,273),(2467,273),(2468,273),(2469,273),(2470,273),(2471,274),(2472,274),(2473,274),(2474,274),(2475,274),(2476,274),(2477,275),(2478,275),(2479,275),(2480,275),(2481,275),(2482,275),(2483,276),(2484,276),(2485,276),(2486,276),(2487,276),(2488,276),(2489,277),(2490,277),(2491,277),(2492,277),(2493,277),(2494,277),(2495,278),(2496,278),(2497,278),(2498,278),(2499,278),(2500,278),(2501,279),(2502,279),(2503,279),(2504,279),(2505,279),(2506,279),(2507,280),(2508,280),(2509,280),(2510,280),(2511,280),(2512,280),(2513,281),(2514,281),(2515,281),(2516,281),(2517,281),(2518,281),(2519,282),(2520,282),(2521,282),(2522,282),(2523,282),(2524,282),(2525,283),(2526,283),(2527,283),(2528,283),(2529,283),(2530,283),(2531,284),(2532,284),(2533,284),(2534,284),(2535,284),(2536,284),(2537,285),(2538,285),(2539,285),(2540,285),(2541,285),(2542,285),(2543,286),(2544,286),(2545,286),(2546,286),(2547,286),(2548,286),(2549,286),(2550,286),(2551,286),(2552,287),(2553,287),(2554,287),(2555,287),(2556,287),(2557,287),(2558,288),(2559,288),(2560,288),(2561,288),(2562,288),(2563,288),(2564,289),(2565,289),(2566,289),(2567,289),(2568,289),(2569,289),(2570,290),(2571,290),(2572,290),(2573,290),(2574,290),(2575,290),(2576,291),(2577,291),(2578,291),(2579,291),(2580,291),(2581,291),(2582,292),(2583,292),(2584,292),(2585,292),(2586,292),(2587,292),(2588,293),(2589,293),(2590,293),(2591,293),(2592,293),(2593,293),(2594,294),(2595,294),(2596,294),(2597,294),(2598,294),(2599,294),(2600,295),(2601,295),(2602,295),(2603,295),(2604,295),(2605,295),(2606,296),(2607,296),(2608,296),(2609,296),(2610,296),(2611,296),(2612,297),(2613,297),(2614,297),(2615,297),(2616,297),(2617,297),(2618,298),(2619,298),(2620,298),(2621,298),(2622,298),(2623,298),(2624,299),(2625,299),(2626,299),(2627,299),(2628,299),(2629,299),(2630,300),(2631,300),(2632,300),(2633,300),(2634,300),(2635,300),(2636,301),(2637,301),(2638,301),(2639,301),(2640,301),(2641,301),(2642,302),(2643,302),(2644,302),(2645,302),(2646,302),(2647,302),(2648,302),(2649,302),(2650,302),(2651,303),(2652,303),(2653,303),(2654,303),(2655,303),(2656,303),(2657,304),(2658,304),(2659,304),(2660,304),(2661,304),(2662,304),(2663,305),(2664,305),(2665,305),(2666,305),(2667,305),(2668,305),(2669,306),(2670,306),(2671,306),(2672,306),(2673,306),(2674,306),(2675,307),(2676,307),(2677,307),(2678,307),(2679,307),(2680,307),(2681,308),(2682,308),(2683,308),(2684,308),(2685,308),(2686,308),(2687,309),(2688,309),(2689,309),(2690,309),(2691,309),(2692,309),(2693,310),(2694,310),(2695,310),(2696,310),(2697,310),(2698,310),(2699,311),(2700,311),(2701,311),(2702,311),(2703,311),(2704,311),(2705,312),(2706,312),(2707,312),(2708,312),(2709,312),(2710,312),(2711,313),(2712,313),(2713,313),(2714,313),(2715,313),(2716,313),(2717,314),(2718,314),(2719,314),(2720,314),(2721,314),(2722,314),(2723,315),(2724,315),(2725,315),(2726,315),(2727,315),(2728,315),(2729,316),(2730,316),(2731,316),(2732,316),(2733,316),(2734,316),(2735,317),(2736,317),(2737,317),(2738,317),(2739,317),(2740,317),(2741,318),(2742,318),(2743,318),(2744,318),(2745,318),(2746,318),(2747,318),(2748,318),(2749,318),(2750,319),(2751,319),(2752,319),(2753,319),(2754,319),(2755,319),(2756,320),(2757,320),(2758,320),(2759,320),(2760,320),(2761,320),(2762,321),(2763,321),(2764,321),(2765,321),(2766,321),(2767,321),(2768,322),(2769,322),(2770,322),(2771,322),(2772,322),(2773,322),(2774,323),(2775,323),(2776,323),(2777,323),(2778,323),(2779,323),(2780,324),(2781,324),(2782,324),(2783,324),(2784,324),(2785,324),(2786,325),(2787,325),(2788,325),(2789,325),(2790,325),(2791,325),(2792,326),(2793,326),(2794,326),(2795,326),(2796,326),(2797,326),(2798,327),(2799,327),(2800,327),(2801,327),(2802,327),(2803,327),(2804,328),(2805,328),(2806,328),(2807,328),(2808,328),(2809,328),(2810,329),(2811,329),(2812,329),(2813,329),(2814,329),(2815,329),(2816,330),(2817,330),(2818,330),(2819,330),(2820,330),(2821,330),(2822,331),(2823,331),(2824,331),(2825,331),(2826,331),(2827,331),(2828,332),(2829,332),(2830,332),(2831,332),(2832,332),(2833,332),(2834,333),(2835,333),(2836,333),(2837,333),(2838,333),(2839,333),(2840,334),(2841,334),(2842,334),(2843,334),(2844,334),(2845,334),(2846,334),(2847,334),(2848,334),(2849,335),(2850,335),(2851,335),(2852,335),(2853,335),(2854,335),(2855,336),(2856,336),(2857,336),(2858,336),(2859,336),(2860,336),(2861,337),(2862,337),(2863,337),(2864,337),(2865,337),(2866,337),(2867,338),(2868,338),(2869,338),(2870,338),(2871,338),(2872,338),(2873,339),(2874,339),(2875,339),(2876,339),(2877,339),(2878,339),(2879,340),(2880,340),(2881,340),(2882,340),(2883,340),(2884,340),(2885,341),(2886,341),(2887,341),(2888,341),(2889,341),(2890,341),(2891,342),(2892,342),(2893,342),(2894,342),(2895,342),(2896,342),(2897,343),(2898,343),(2899,343),(2900,343),(2901,343),(2902,343),(2903,344),(2904,344),(2905,344),(2906,344),(2907,344),(2908,344),(2909,345),(2910,345),(2911,345),(2912,345),(2913,345),(2914,345),(2915,346),(2916,346),(2917,346),(2918,346),(2919,346),(2920,346),(2921,347),(2922,348),(2923,349),(2924,350),(2925,351),(2926,352),(2927,353),(2928,354),(2929,355),(2930,356),(2931,357),(2932,358),(2933,359),(2934,360),(2935,361),(2936,362),(2937,363),(2938,364),(2939,365),(2940,366),(2941,367),(2942,368),(2943,369),(2944,370),(2945,371),(2946,372),(2947,373),(2948,374),(2949,375),(2950,376),(2951,377),(2952,378),(2953,379),(2954,380),(2955,381),(2956,382),(2957,383),(2958,384),(2959,385),(2960,386),(2961,387),(2962,388),(2963,389),(2964,390),(2965,391),(2966,392),(2967,393),(2968,394),(2969,395),(2970,396),(2971,397),(2972,398),(2973,399),(2974,400),(2975,401),(2976,402),(2977,403),(2978,404),(2979,405),(2980,406),(2981,407),(2982,408),(2983,409),(2984,410),(2985,411),(2986,412),(2987,413),(2988,414),(2989,415),(2990,416),(2991,417),(2992,418),(2993,419),(2994,420),(2995,421),(2996,422),(2997,423),(2998,424),(2999,425),(3000,426),(3001,427),(3002,428),(3003,429),(3004,430),(3005,431),(3006,432),(3007,433),(3008,434),(3009,435),(3010,436),(3011,437),(3012,438),(3013,439),(3014,440),(3015,441),(3016,442),(3017,443),(3018,444),(3019,445),(3020,446),(3021,347),(3022,348),(3023,349),(3024,350),(3025,351),(3026,352),(3027,353),(3028,354),(3029,355),(3030,356),(3031,357),(3032,358),(3033,359),(3034,360),(3035,361),(3036,362),(3037,363),(3038,364),(3039,365),(3040,366),(3041,367),(3042,368),(3043,369),(3044,370),(3045,371),(3046,372),(3047,373),(3048,374),(3049,375),(3050,376),(3051,377),(3052,378),(3053,379),(3054,380),(3055,381),(3056,382),(3057,383),(3058,383),(3059,383),(3060,384),(3061,384),(3062,384),(3063,385),(3064,385),(3065,385),(3066,386),(3067,386),(3068,386),(3069,387),(3070,387),(3071,387),(3072,388),(3073,388),(3074,388),(3075,389),(3076,389),(3077,389),(3078,390),(3079,390),(3080,390),(3081,391),(3082,391),(3083,391),(3084,392),(3085,392),(3086,392),(3087,393),(3088,393),(3089,393),(3090,394),(3091,394),(3092,394),(3093,395),(3094,395),(3095,395),(3096,396),(3097,396),(3098,396),(3099,397),(3100,397),(3101,397),(3102,398),(3103,398),(3104,398),(3105,399),(3106,400),(3107,401),(3108,402),(3109,403),(3110,404),(3111,405),(3112,406),(3113,407),(3114,408),(3115,409),(3116,410),(3117,411),(3118,412),(3119,413),(3120,414),(3121,415),(3122,416),(3123,417),(3124,418),(3125,419),(3126,420),(3127,421),(3128,422),(3129,423),(3130,424),(3131,425),(3132,426),(3133,427),(3134,428),(3135,429),(3136,430),(3137,431),(3138,432),(3139,433),(3140,434),(3141,435),(3142,436),(3143,437),(3144,438),(3145,439),(3146,440),(3147,441),(3148,442),(3149,443),(3150,444),(3151,445),(3152,446),(3153,347),(3154,347),(3155,347),(3156,347),(3157,347),(3158,347),(3159,348),(3160,348),(3161,348),(3162,348),(3163,348),(3164,348),(3165,349),(3166,349),(3167,349),(3168,349),(3169,349),(3170,349),(3171,350),(3172,350),(3173,350),(3174,350),(3175,350),(3176,350),(3177,350),(3178,350),(3179,350),(3180,351),(3181,351),(3182,351),(3183,351),(3184,351),(3185,351),(3186,352),(3187,352),(3188,352),(3189,352),(3190,352),(3191,352),(3192,353),(3193,353),(3194,353),(3195,353),(3196,353),(3197,353),(3198,354),(3199,354),(3200,354),(3201,354),(3202,354),(3203,354),(3204,355),(3205,355),(3206,355),(3207,355),(3208,355),(3209,355),(3210,356),(3211,356),(3212,356),(3213,356),(3214,356),(3215,356),(3216,357),(3217,357),(3218,357),(3219,357),(3220,357),(3221,357),(3222,358),(3223,358),(3224,358),(3225,358),(3226,358),(3227,358),(3228,359),(3229,359),(3230,359),(3231,359),(3232,359),(3233,359),(3234,360),(3235,360),(3236,360),(3237,360),(3238,360),(3239,360),(3240,361),(3241,361),(3242,361),(3243,361),(3244,361),(3245,361),(3246,362),(3247,362),(3248,362),(3249,362),(3250,362),(3251,362),(3252,363),(3253,363),(3254,363),(3255,363),(3256,363),(3257,363),(3258,364),(3259,364),(3260,364),(3261,364),(3262,364),(3263,364),(3264,365),(3265,365),(3266,365),(3267,365),(3268,365),(3269,365),(3270,366),(3271,366),(3272,366),(3273,366),(3274,366),(3275,366),(3276,366),(3277,366),(3278,366),(3279,367),(3280,367),(3281,367),(3282,367),(3283,367),(3284,367),(3285,368),(3286,368),(3287,368),(3288,368),(3289,368),(3290,368),(3291,369),(3292,369),(3293,369),(3294,369),(3295,369),(3296,369),(3297,370),(3298,370),(3299,370),(3300,370),(3301,370),(3302,370),(3303,371),(3304,371),(3305,371),(3306,371),(3307,371),(3308,371),(3309,372),(3310,372),(3311,372),(3312,372),(3313,372),(3314,372),(3315,373),(3316,373),(3317,373),(3318,373),(3319,373),(3320,373),(3321,374),(3322,374),(3323,374),(3324,374),(3325,374),(3326,374),(3327,375),(3328,375),(3329,375),(3330,375),(3331,375),(3332,375),(3333,376),(3334,376),(3335,376),(3336,376),(3337,376),(3338,376),(3339,377),(3340,377),(3341,377),(3342,377),(3343,377),(3344,377),(3345,378),(3346,378),(3347,378),(3348,378),(3349,378),(3350,378),(3351,379),(3352,379),(3353,379),(3354,379),(3355,379),(3356,379),(3357,380),(3358,380),(3359,380),(3360,380),(3361,380),(3362,380),(3363,381),(3364,381),(3365,381),(3366,381),(3367,381),(3368,381),(3369,382),(3370,382),(3371,382),(3372,382),(3373,382),(3374,382),(3375,382),(3376,382),(3377,382),(3378,383),(3379,383),(3380,383),(3381,383),(3382,383),(3383,383),(3384,384),(3385,384),(3386,384),(3387,384),(3388,384),(3389,384),(3390,385),(3391,385),(3392,385),(3393,385),(3394,385),(3395,385),(3396,386),(3397,386),(3398,386),(3399,386),(3400,386),(3401,386),(3402,387),(3403,387),(3404,387),(3405,387),(3406,387),(3407,387),(3408,388),(3409,388),(3410,388),(3411,388),(3412,388),(3413,388),(3414,389),(3415,389),(3416,389),(3417,389),(3418,389),(3419,389),(3420,390),(3421,390),(3422,390),(3423,390),(3424,390),(3425,390),(3426,391),(3427,391),(3428,391),(3429,391),(3430,391),(3431,391),(3432,392),(3433,392),(3434,392),(3435,392),(3436,392),(3437,392),(3438,393),(3439,393),(3440,393),(3441,393),(3442,393),(3443,393),(3444,394),(3445,394),(3446,394),(3447,394),(3448,394),(3449,394),(3450,395),(3451,395),(3452,395),(3453,395),(3454,395),(3455,395),(3456,396),(3457,396),(3458,396),(3459,396),(3460,396),(3461,396),(3462,397),(3463,397),(3464,397),(3465,397),(3466,397),(3467,397),(3468,398),(3469,398),(3470,398),(3471,398),(3472,398),(3473,398),(3474,398),(3475,398),(3476,398),(3477,399),(3478,399),(3479,399),(3480,399),(3481,399),(3482,399),(3483,400),(3484,400),(3485,400),(3486,400),(3487,400),(3488,400),(3489,401),(3490,401),(3491,401),(3492,401),(3493,401),(3494,401),(3495,402),(3496,402),(3497,402),(3498,402),(3499,402),(3500,402),(3501,403),(3502,403),(3503,403),(3504,403),(3505,403),(3506,403),(3507,404),(3508,404),(3509,404),(3510,404),(3511,404),(3512,404),(3513,405),(3514,405),(3515,405),(3516,405),(3517,405),(3518,405),(3519,406),(3520,406),(3521,406),(3522,406),(3523,406),(3524,406),(3525,407),(3526,407),(3527,407),(3528,407),(3529,407),(3530,407),(3531,408),(3532,408),(3533,408),(3534,408),(3535,408),(3536,408),(3537,409),(3538,409),(3539,409),(3540,409),(3541,409),(3542,409),(3543,410),(3544,410),(3545,410),(3546,410),(3547,410),(3548,410),(3549,411),(3550,411),(3551,411),(3552,411),(3553,411),(3554,411),(3555,412),(3556,412),(3557,412),(3558,412),(3559,412),(3560,412),(3561,413),(3562,413),(3563,413),(3564,413),(3565,413),(3566,413),(3567,414),(3568,414),(3569,414),(3570,414),(3571,414),(3572,414),(3573,414),(3574,414),(3575,414),(3576,415),(3577,415),(3578,415),(3579,415),(3580,415),(3581,415),(3582,416),(3583,416),(3584,416),(3585,416),(3586,416),(3587,416),(3588,417),(3589,417),(3590,417),(3591,417),(3592,417),(3593,417),(3594,418),(3595,418),(3596,418),(3597,418),(3598,418),(3599,418),(3600,419),(3601,419),(3602,419),(3603,419),(3604,419),(3605,419),(3606,420),(3607,420),(3608,420),(3609,420),(3610,420),(3611,420),(3612,421),(3613,421),(3614,421),(3615,421),(3616,421),(3617,421),(3618,422),(3619,422),(3620,422),(3621,422),(3622,422),(3623,422),(3624,423),(3625,423),(3626,423),(3627,423),(3628,423),(3629,423),(3630,424),(3631,424),(3632,424),(3633,424),(3634,424),(3635,424),(3636,425),(3637,425),(3638,425),(3639,425),(3640,425),(3641,425),(3642,426),(3643,426),(3644,426),(3645,426),(3646,426),(3647,426),(3648,427),(3649,427),(3650,427),(3651,427),(3652,427),(3653,427),(3654,428),(3655,428),(3656,428),(3657,428),(3658,428),(3659,428),(3660,429),(3661,429),(3662,429),(3663,429),(3664,429),(3665,429),(3666,430),(3667,430),(3668,430),(3669,430),(3670,430),(3671,430),(3672,430),(3673,430),(3674,430),(3675,431),(3676,431),(3677,431),(3678,431),(3679,431),(3680,431),(3681,432),(3682,432),(3683,432),(3684,432),(3685,432),(3686,432),(3687,433),(3688,433),(3689,433),(3690,433),(3691,433),(3692,433),(3693,434),(3694,434),(3695,434),(3696,434),(3697,434),(3698,434),(3699,435),(3700,435),(3701,435),(3702,435),(3703,435),(3704,435),(3705,436),(3706,436),(3707,436),(3708,436),(3709,436),(3710,436),(3711,437),(3712,437),(3713,437),(3714,437),(3715,437),(3716,437),(3717,438),(3718,438),(3719,438),(3720,438),(3721,438),(3722,438),(3723,439),(3724,439),(3725,439),(3726,439),(3727,439),(3728,439),(3729,440),(3730,440),(3731,440),(3732,440),(3733,440),(3734,440),(3735,441),(3736,441),(3737,441),(3738,441),(3739,441),(3740,441),(3741,442),(3742,442),(3743,442),(3744,442),(3745,442),(3746,442),(3747,443),(3748,443),(3749,443),(3750,443),(3751,443),(3752,443),(3753,444),(3754,444),(3755,444),(3756,444),(3757,444),(3758,444),(3759,445),(3760,445),(3761,445),(3762,445),(3763,445),(3764,445),(3765,446),(3766,446),(3767,446),(3768,446),(3769,446),(3770,446),(3771,446),(3772,446),(3773,446),(3774,447),(3775,448),(3776,449),(3777,450),(3778,451),(3779,452),(3780,453),(3781,454),(3782,455),(3783,456),(3784,457),(3785,458),(3786,459),(3787,460),(3788,461),(3789,462),(3790,463),(3791,464),(3792,465),(3793,466),(3794,467),(3795,468),(3796,469),(3797,470),(3798,471),(3799,472),(3800,473),(3801,474),(3802,475),(3803,476),(3804,477),(3805,478),(3806,479),(3807,480),(3808,481),(3809,482),(3810,483),(3811,484),(3812,485),(3813,486),(3814,487),(3815,488),(3816,489),(3817,490),(3818,491),(3819,492),(3820,493),(3821,494),(3822,495),(3823,496),(3824,497),(3825,498),(3826,499),(3827,500),(3828,501),(3829,502),(3830,503),(3831,504),(3832,505),(3833,506),(3834,507),(3835,508),(3836,509),(3837,510),(3838,511),(3839,512),(3840,513),(3841,514),(3842,515),(3843,516),(3844,517),(3845,518),(3846,519),(3847,520),(3848,521),(3849,522),(3850,523),(3851,524),(3852,525),(3853,526),(3854,527),(3855,528),(3856,529),(3857,530),(3858,531),(3859,532),(3860,533),(3861,534),(3862,535),(3863,536),(3864,537),(3865,538),(3866,539),(3867,540),(3868,541),(3869,542),(3870,543),(3871,544),(3872,545),(3873,546),(3874,447),(3875,447),(3876,447),(3877,448),(3878,448),(3879,448),(3880,449),(3881,449),(3882,449),(3883,450),(3884,450),(3885,450),(3886,451),(3887,451),(3888,451),(3889,452),(3890,452),(3891,452),(3892,453),(3893,453),(3894,453),(3895,454),(3896,454),(3897,454),(3898,455),(3899,455),(3900,455),(3901,456),(3902,456),(3903,456),(3904,457),(3905,457),(3906,457),(3907,458),(3908,458),(3909,458),(3910,459),(3911,459),(3912,459),(3913,460),(3914,460),(3915,460),(3916,461),(3917,461),(3918,461),(3919,462),(3920,462),(3921,462),(3922,463),(3923,464),(3924,465),(3925,466),(3926,467),(3927,468),(3928,469),(3929,470),(3930,471),(3931,472),(3932,473),(3933,474),(3934,475),(3935,476),(3936,477),(3937,478),(3938,479),(3939,480),(3940,481),(3941,482),(3942,483),(3943,484),(3944,485),(3945,486),(3946,487),(3947,488),(3948,489),(3949,490),(3950,491),(3951,492),(3952,493),(3953,494),(3954,495),(3955,496),(3956,497),(3957,498),(3958,499),(3959,500),(3960,501),(3961,502),(3962,503),(3963,504),(3964,505),(3965,506),(3966,507),(3967,508),(3968,509),(3969,510),(3970,511),(3971,512),(3972,513),(3973,514),(3974,515),(3975,516),(3976,517),(3977,518),(3978,519),(3979,520),(3980,521),(3981,522),(3982,523),(3983,524),(3984,525),(3985,526),(3986,527),(3987,528),(3988,529),(3989,530),(3990,531),(3991,532),(3992,533),(3993,534),(3994,535),(3995,536),(3996,537),(3997,538),(3998,539),(3999,540),(4000,541),(4001,542),(4002,543),(4003,544),(4004,545),(4005,546),(4006,447),(4007,447),(4008,447),(4009,447),(4010,447),(4011,447),(4012,448),(4013,448),(4014,448),(4015,448),(4016,448),(4017,448),(4018,449),(4019,449),(4020,449),(4021,449),(4022,449),(4023,449),(4024,450),(4025,450),(4026,450),(4027,450),(4028,450),(4029,450),(4030,451),(4031,451),(4032,451),(4033,451),(4034,451),(4035,451),(4036,452),(4037,452),(4038,452),(4039,452),(4040,452),(4041,452),(4042,453),(4043,453),(4044,453),(4045,453),(4046,453),(4047,453),(4048,454),(4049,454),(4050,454),(4051,454),(4052,454),(4053,454),(4054,455),(4055,455),(4056,455),(4057,455),(4058,455),(4059,455),(4060,456),(4061,456),(4062,456),(4063,456),(4064,456),(4065,456),(4066,457),(4067,457),(4068,457),(4069,457),(4070,457),(4071,457),(4072,458),(4073,458),(4074,458),(4075,458),(4076,458),(4077,458),(4078,459),(4079,459),(4080,459),(4081,459),(4082,459),(4083,459),(4084,460),(4085,460),(4086,460),(4087,460),(4088,460),(4089,460),(4090,461),(4091,461),(4092,461),(4093,461),(4094,461),(4095,461),(4096,462),(4097,462),(4098,462),(4099,462),(4100,462),(4101,462),(4102,462),(4103,462),(4104,462),(4105,463),(4106,463),(4107,463),(4108,463),(4109,463),(4110,463),(4111,464),(4112,464),(4113,464),(4114,464),(4115,464),(4116,464),(4117,465),(4118,465),(4119,465),(4120,465),(4121,465),(4122,465),(4123,466),(4124,466),(4125,466),(4126,466),(4127,466),(4128,466),(4129,467),(4130,467),(4131,467),(4132,467),(4133,467),(4134,467),(4135,468),(4136,468),(4137,468),(4138,468),(4139,468),(4140,468),(4141,469),(4142,469),(4143,469),(4144,469),(4145,469),(4146,469),(4147,470),(4148,470),(4149,470),(4150,470),(4151,470),(4152,470),(4153,471),(4154,471),(4155,471),(4156,471),(4157,471),(4158,471),(4159,472),(4160,472),(4161,472),(4162,472),(4163,472),(4164,472),(4165,473),(4166,473),(4167,473),(4168,473),(4169,473),(4170,473),(4171,474),(4172,474),(4173,474),(4174,474),(4175,474),(4176,474),(4177,475),(4178,475),(4179,475),(4180,475),(4181,475),(4182,475),(4183,476),(4184,476),(4185,476),(4186,476),(4187,476),(4188,476),(4189,477),(4190,477),(4191,477),(4192,477),(4193,477),(4194,477),(4195,478),(4196,478),(4197,478),(4198,478),(4199,478),(4200,478),(4201,478),(4202,478),(4203,478),(4204,479),(4205,479),(4206,479),(4207,479),(4208,479),(4209,479),(4210,480),(4211,480),(4212,480),(4213,480),(4214,480),(4215,480),(4216,481),(4217,481),(4218,481),(4219,481),(4220,481),(4221,481),(4222,482),(4223,482),(4224,482),(4225,482),(4226,482),(4227,482),(4228,483),(4229,483),(4230,483),(4231,483),(4232,483),(4233,483),(4234,484),(4235,484),(4236,484),(4237,484),(4238,484),(4239,484),(4240,485),(4241,485),(4242,485),(4243,485),(4244,485),(4245,485),(4246,486),(4247,486),(4248,486),(4249,486),(4250,486),(4251,486),(4252,487),(4253,487),(4254,487),(4255,487),(4256,487),(4257,487),(4258,488),(4259,488),(4260,488),(4261,488),(4262,488),(4263,488),(4264,489),(4265,489),(4266,489),(4267,489),(4268,489),(4269,489),(4270,490),(4271,490),(4272,490),(4273,490),(4274,490),(4275,490),(4276,491),(4277,491),(4278,491),(4279,491),(4280,491),(4281,491),(4282,492),(4283,492),(4284,492),(4285,492),(4286,492),(4287,492),(4288,493),(4289,493),(4290,493),(4291,493),(4292,493),(4293,493),(4294,494),(4295,494),(4296,494),(4297,494),(4298,494),(4299,494),(4300,494),(4301,494),(4302,494),(4303,495),(4304,495),(4305,495),(4306,495),(4307,495),(4308,495),(4309,496),(4310,496),(4311,496),(4312,496),(4313,496),(4314,496),(4315,497),(4316,497),(4317,497),(4318,497),(4319,497),(4320,497),(4321,498),(4322,498),(4323,498),(4324,498),(4325,498),(4326,498),(4327,499),(4328,499),(4329,499),(4330,499),(4331,499),(4332,499),(4333,500),(4334,500),(4335,500),(4336,500),(4337,500),(4338,500),(4339,501),(4340,501),(4341,501),(4342,501),(4343,501),(4344,501),(4345,502),(4346,502),(4347,502),(4348,502),(4349,502),(4350,502),(4351,503),(4352,503),(4353,503),(4354,503),(4355,503),(4356,503),(4357,504),(4358,504),(4359,504),(4360,504),(4361,504),(4362,504),(4363,505),(4364,505),(4365,505),(4366,505),(4367,505),(4368,505),(4369,506),(4370,506),(4371,506),(4372,506),(4373,506),(4374,506),(4375,507),(4376,507),(4377,507),(4378,507),(4379,507),(4380,507),(4381,508),(4382,508),(4383,508),(4384,508),(4385,508),(4386,508),(4387,509),(4388,509),(4389,509),(4390,509),(4391,509),(4392,509),(4393,510),(4394,510),(4395,510),(4396,510),(4397,510),(4398,510),(4399,510),(4400,510),(4401,510),(4402,511),(4403,511),(4404,511),(4405,511),(4406,511),(4407,511),(4408,512),(4409,512),(4410,512),(4411,512),(4412,512),(4413,512),(4414,513),(4415,513),(4416,513),(4417,513),(4418,513),(4419,513),(4420,514),(4421,514),(4422,514),(4423,514),(4424,514),(4425,514),(4426,515),(4427,515),(4428,515),(4429,515),(4430,515),(4431,515),(4432,516),(4433,516),(4434,516),(4435,516),(4436,516),(4437,516),(4438,517),(4439,517),(4440,517),(4441,517),(4442,517),(4443,517),(4444,518),(4445,518),(4446,518),(4447,518),(4448,518),(4449,518),(4450,519),(4451,519),(4452,519),(4453,519),(4454,519),(4455,519),(4456,520),(4457,520),(4458,520),(4459,520),(4460,520),(4461,520),(4462,521),(4463,521),(4464,521),(4465,521),(4466,521),(4467,521),(4468,522),(4469,522),(4470,522),(4471,522),(4472,522),(4473,522),(4474,523),(4475,523),(4476,523),(4477,523),(4478,523),(4479,523),(4480,524),(4481,524),(4482,524),(4483,524),(4484,524),(4485,524),(4486,525),(4487,525),(4488,525),(4489,525),(4490,525),(4491,525),(4492,526),(4493,526),(4494,526),(4495,526),(4496,526),(4497,526),(4498,526),(4499,526),(4500,526),(4501,527),(4502,527),(4503,527),(4504,527),(4505,527),(4506,527),(4507,528),(4508,528),(4509,528),(4510,528),(4511,528),(4512,528),(4513,529),(4514,529),(4515,529),(4516,529),(4517,529),(4518,529),(4519,530),(4520,530),(4521,530),(4522,530),(4523,530),(4524,530),(4525,531),(4526,531),(4527,531),(4528,531),(4529,531),(4530,531),(4531,532),(4532,532),(4533,532),(4534,532),(4535,532),(4536,532),(4537,533),(4538,533),(4539,533),(4540,533),(4541,533),(4542,533),(4543,534),(4544,534),(4545,534),(4546,534),(4547,534),(4548,534),(4549,535),(4550,535),(4551,535),(4552,535),(4553,535),(4554,535),(4555,536),(4556,536),(4557,536),(4558,536),(4559,536),(4560,536),(4561,537),(4562,537),(4563,537),(4564,537),(4565,537),(4566,537),(4567,538),(4568,538),(4569,538),(4570,538),(4571,538),(4572,538),(4573,539),(4574,539),(4575,539),(4576,539),(4577,539),(4578,539),(4579,540),(4580,540),(4581,540),(4582,540),(4583,540),(4584,540),(4585,541),(4586,541),(4587,541),(4588,541),(4589,541),(4590,541),(4591,542),(4592,542),(4593,542),(4594,542),(4595,542),(4596,542),(4597,542),(4598,542),(4599,542),(4600,543),(4601,543),(4602,543),(4603,543),(4604,543),(4605,543),(4606,544),(4607,544),(4608,544),(4609,544),(4610,544),(4611,544),(4612,545),(4613,545),(4614,545),(4615,545),(4616,545),(4617,545),(4618,546),(4619,546),(4620,546),(4621,546),(4622,546),(4623,546),(4624,547),(4625,548),(4626,549),(4627,550),(4628,551),(4629,552),(4630,553),(4631,554),(4632,555),(4633,556),(4634,557),(4635,558),(4636,559),(4637,560),(4638,561),(4639,562),(4640,563),(4641,564),(4642,565),(4643,566),(4644,567),(4645,568),(4646,569),(4647,570),(4648,571),(4649,572),(4650,573),(4651,574),(4652,575),(4653,576),(4654,577),(4655,578),(4656,579),(4657,580),(4658,581),(4659,582),(4660,583),(4661,584),(4662,585),(4663,586),(4664,587),(4665,588),(4666,589),(4667,590),(4668,591),(4669,592),(4670,593),(4671,594),(4672,595),(4673,596),(4674,597),(4675,598),(4676,599),(4677,600),(4678,601),(4679,602),(4680,603),(4681,604),(4682,605),(4683,606),(4684,607),(4685,608),(4686,609),(4687,610),(4688,611),(4689,612),(4690,613),(4691,614),(4692,615),(4693,616),(4694,617),(4695,618),(4696,619),(4697,620),(4698,621),(4699,622),(4700,623),(4701,624),(4702,625),(4703,626),(4704,627),(4705,628),(4706,629),(4707,630),(4708,631),(4709,632),(4710,633),(4711,634),(4712,635),(4713,636),(4714,637),(4715,638),(4716,639),(4717,640),(4718,641),(4719,642),(4720,643),(4721,644),(4722,645),(4723,646),(4724,547),(4725,548),(4726,549),(4727,550),(4728,551),(4729,552),(4730,553),(4731,554),(4732,555),(4733,556),(4734,557),(4735,558),(4736,559),(4737,560),(4738,561),(4739,562),(4740,563),(4741,564),(4742,565),(4743,566),(4744,567),(4745,568),(4746,569),(4747,570),(4748,571),(4749,572),(4750,573),(4751,574),(4752,575),(4753,576),(4754,577),(4755,578),(4756,579),(4757,580),(4758,581),(4759,582),(4760,583),(4761,584),(4762,585),(4763,586),(4764,587),(4765,588),(4766,589),(4767,590),(4768,591),(4769,592),(4770,593),(4771,594),(4772,595),(4773,596),(4774,597),(4775,598),(4776,599),(4777,600),(4778,601),(4779,602),(4780,603),(4781,604),(4782,605),(4783,606),(4784,607),(4785,608),(4786,609),(4787,610),(4788,611),(4789,612),(4790,613),(4791,614),(4792,615),(4793,616),(4794,617),(4795,618),(4796,619),(4797,620),(4798,621),(4799,622),(4800,623),(4801,624),(4802,625),(4803,626),(4804,627),(4805,628),(4806,629),(4807,630),(4808,631),(4809,632),(4810,633),(4811,634),(4812,635),(4813,636),(4814,637),(4815,638),(4816,639),(4817,640),(4818,641),(4819,642),(4820,643),(4821,644),(4822,645),(4823,646),(4824,547),(4825,547),(4826,547),(4827,547),(4828,547),(4829,547),(4830,548),(4831,548),(4832,548),(4833,548),(4834,548),(4835,548),(4836,549),(4837,549),(4838,549),(4839,549),(4840,549),(4841,549),(4842,550),(4843,550),(4844,550),(4845,550),(4846,550),(4847,550),(4848,551),(4849,551),(4850,551),(4851,551),(4852,551),(4853,551),(4854,552),(4855,552),(4856,552),(4857,552),(4858,552),(4859,552),(4860,553),(4861,553),(4862,553),(4863,553),(4864,553),(4865,553),(4866,554),(4867,554),(4868,554),(4869,554),(4870,554),(4871,554),(4872,555),(4873,555),(4874,555),(4875,555),(4876,555),(4877,555),(4878,556),(4879,556),(4880,556),(4881,556),(4882,556),(4883,556),(4884,557),(4885,557),(4886,557),(4887,557),(4888,557),(4889,557),(4890,558),(4891,558),(4892,558),(4893,558),(4894,558),(4895,558),(4896,558),(4897,558),(4898,558),(4899,559),(4900,559),(4901,559),(4902,559),(4903,559),(4904,559),(4905,560),(4906,560),(4907,560),(4908,560),(4909,560),(4910,560),(4911,561),(4912,561),(4913,561),(4914,561),(4915,561),(4916,561),(4917,562),(4918,562),(4919,562),(4920,562),(4921,562),(4922,562),(4923,563),(4924,563),(4925,563),(4926,563),(4927,563),(4928,563),(4929,564),(4930,564),(4931,564),(4932,564),(4933,564),(4934,564),(4935,565),(4936,565),(4937,565),(4938,565),(4939,565),(4940,565),(4941,566),(4942,566),(4943,566),(4944,566),(4945,566),(4946,566),(4947,567),(4948,567),(4949,567),(4950,567),(4951,567),(4952,567),(4953,568),(4954,568),(4955,568),(4956,568),(4957,568),(4958,568),(4959,569),(4960,569),(4961,569),(4962,569),(4963,569),(4964,569),(4965,570),(4966,570),(4967,570),(4968,570),(4969,570),(4970,570),(4971,571),(4972,571),(4973,571),(4974,571),(4975,571),(4976,571),(4977,572),(4978,572),(4979,572),(4980,572),(4981,572),(4982,572),(4983,573),(4984,573),(4985,573),(4986,573),(4987,573),(4988,573),(4989,574),(4990,574),(4991,574),(4992,574),(4993,574),(4994,574),(4995,574),(4996,574),(4997,574),(4998,575),(4999,575),(5000,575),(5001,575),(5002,575),(5003,575),(5004,576),(5005,576),(5006,576),(5007,576),(5008,576),(5009,576),(5010,577),(5011,577),(5012,577),(5013,577),(5014,577),(5015,577),(5016,578),(5017,578),(5018,578),(5019,578),(5020,578),(5021,578),(5022,579),(5023,579),(5024,579),(5025,579),(5026,579),(5027,579),(5028,580),(5029,580),(5030,580),(5031,580),(5032,580),(5033,580),(5034,581),(5035,581),(5036,581),(5037,581),(5038,581),(5039,581),(5040,582),(5041,582),(5042,582),(5043,582),(5044,582),(5045,582),(5046,583),(5047,583),(5048,583),(5049,583),(5050,583),(5051,583),(5052,584),(5053,584),(5054,584),(5055,584),(5056,584),(5057,584),(5058,585),(5059,585),(5060,585),(5061,585),(5062,585),(5063,585),(5064,586),(5065,586),(5066,586),(5067,586),(5068,586),(5069,586),(5070,587),(5071,587),(5072,587),(5073,587),(5074,587),(5075,587),(5076,588),(5077,588),(5078,588),(5079,588),(5080,588),(5081,588),(5082,589),(5083,589),(5084,589),(5085,589),(5086,589),(5087,589),(5088,590),(5089,590),(5090,590),(5091,590),(5092,590),(5093,590),(5094,590),(5095,590),(5096,590),(5097,591),(5098,591),(5099,591),(5100,591),(5101,591),(5102,591),(5103,592),(5104,592),(5105,592),(5106,592),(5107,592),(5108,592),(5109,593),(5110,593),(5111,593),(5112,593),(5113,593),(5114,593),(5115,594),(5116,594),(5117,594),(5118,594),(5119,594),(5120,594),(5121,595),(5122,595),(5123,595),(5124,595),(5125,595),(5126,595),(5127,596),(5128,596),(5129,596),(5130,596),(5131,596),(5132,596),(5133,597),(5134,597),(5135,597),(5136,597),(5137,597),(5138,597),(5139,598),(5140,598),(5141,598),(5142,598),(5143,598),(5144,598),(5145,599),(5146,599),(5147,599),(5148,599),(5149,599),(5150,599),(5151,600),(5152,600),(5153,600),(5154,600),(5155,600),(5156,600),(5157,601),(5158,601),(5159,601),(5160,601),(5161,601),(5162,601),(5163,602),(5164,602),(5165,602),(5166,602),(5167,602),(5168,602),(5169,603),(5170,603),(5171,603),(5172,603),(5173,603),(5174,603),(5175,604),(5176,604),(5177,604),(5178,604),(5179,604),(5180,604),(5181,605),(5182,605),(5183,605),(5184,605),(5185,605),(5186,605),(5187,606),(5188,606),(5189,606),(5190,606),(5191,606),(5192,606),(5193,606),(5194,606),(5195,606),(5196,607),(5197,607),(5198,607),(5199,607),(5200,607),(5201,607),(5202,608),(5203,608),(5204,608),(5205,608),(5206,608),(5207,608),(5208,609),(5209,609),(5210,609),(5211,609),(5212,609),(5213,609),(5214,610),(5215,610),(5216,610),(5217,610),(5218,610),(5219,610),(5220,611),(5221,611),(5222,611),(5223,611),(5224,611),(5225,611),(5226,612),(5227,612),(5228,612),(5229,612),(5230,612),(5231,612),(5232,613),(5233,613),(5234,613),(5235,613),(5236,613),(5237,613),(5238,614),(5239,614),(5240,614),(5241,614),(5242,614),(5243,614),(5244,615),(5245,615),(5246,615),(5247,615),(5248,615),(5249,615),(5250,616),(5251,616),(5252,616),(5253,616),(5254,616),(5255,616),(5256,617),(5257,617),(5258,617),(5259,617),(5260,617),(5261,617),(5262,618),(5263,618),(5264,618),(5265,618),(5266,618),(5267,618),(5268,619),(5269,619),(5270,619),(5271,619),(5272,619),(5273,619),(5274,620),(5275,620),(5276,620),(5277,620),(5278,620),(5279,620),(5280,621),(5281,621),(5282,621),(5283,621),(5284,621),(5285,621),(5286,622),(5287,622),(5288,622),(5289,622),(5290,622),(5291,622),(5292,622),(5293,622),(5294,622),(5295,623),(5296,623),(5297,623),(5298,623),(5299,623),(5300,623),(5301,624),(5302,624),(5303,624),(5304,624),(5305,624),(5306,624),(5307,625),(5308,625),(5309,625),(5310,625),(5311,625),(5312,625),(5313,626),(5314,626),(5315,626),(5316,626),(5317,626),(5318,626),(5319,627),(5320,627),(5321,627),(5322,627),(5323,627),(5324,627),(5325,628),(5326,628),(5327,628),(5328,628),(5329,628),(5330,628),(5331,629),(5332,629),(5333,629),(5334,629),(5335,629),(5336,629),(5337,630),(5338,630),(5339,630),(5340,630),(5341,630),(5342,630),(5343,631),(5344,631),(5345,631),(5346,631),(5347,631),(5348,631),(5349,632),(5350,632),(5351,632),(5352,632),(5353,632),(5354,632),(5355,633),(5356,633),(5357,633),(5358,633),(5359,633),(5360,633),(5361,634),(5362,634),(5363,634),(5364,634),(5365,634),(5366,634),(5367,635),(5368,635),(5369,635),(5370,635),(5371,635),(5372,635),(5373,636),(5374,636),(5375,636),(5376,636),(5377,636),(5378,636),(5379,637),(5380,637),(5381,637),(5382,637),(5383,637),(5384,637),(5385,638),(5386,638),(5387,638),(5388,638),(5389,638),(5390,638),(5391,638),(5392,638),(5393,638),(5394,639),(5395,639),(5396,639),(5397,639),(5398,639),(5399,639),(5400,640),(5401,640),(5402,640),(5403,640),(5404,640),(5405,640),(5406,641),(5407,641),(5408,641),(5409,641),(5410,641),(5411,641),(5412,642),(5413,642),(5414,642),(5415,642),(5416,642),(5417,642),(5418,643),(5419,643),(5420,643),(5421,643),(5422,643),(5423,643),(5424,644),(5425,644),(5426,644),(5427,644),(5428,644),(5429,644),(5430,645),(5431,645),(5432,645),(5433,645),(5434,645),(5435,645),(5436,646),(5437,646),(5438,646),(5439,646),(5440,646),(5441,646),(5442,647),(5443,648),(5444,649),(5445,650),(5446,651),(5447,652),(5448,653),(5449,654),(5450,655),(5451,656),(5452,657),(5453,658),(5454,659),(5455,660),(5456,661),(5457,662),(5458,663),(5459,664),(5460,665),(5461,666),(5462,667),(5463,668),(5464,669),(5465,670),(5466,671),(5467,672),(5468,673),(5469,674),(5470,675),(5471,676),(5472,677),(5473,678),(5474,679),(5475,680),(5476,681),(5477,682),(5478,683),(5479,684),(5480,685),(5481,686),(5482,687),(5483,688),(5484,689),(5485,690),(5486,691),(5487,692),(5488,693),(5489,694),(5490,695),(5491,696),(5492,697),(5493,698),(5494,699),(5495,700),(5496,701),(5497,702),(5498,703),(5499,704),(5500,705),(5501,706),(5502,707),(5503,708),(5504,709),(5505,710),(5506,711),(5507,712),(5508,713),(5509,714),(5510,715),(5511,716),(5512,717),(5513,718),(5514,719),(5515,720),(5516,721),(5517,722),(5518,723),(5519,724),(5520,725),(5521,726),(5522,727),(5523,728),(5524,729),(5525,730),(5526,731),(5527,732),(5528,733),(5529,734),(5530,735),(5531,736),(5532,737),(5533,738),(5534,739),(5535,740),(5536,741),(5537,742),(5538,743),(5539,744),(5540,745),(5541,746),(5542,647),(5543,648),(5544,649),(5545,650),(5546,651),(5547,652),(5548,653),(5549,654),(5550,655),(5551,656),(5552,657),(5553,658),(5554,659),(5555,660),(5556,661),(5557,662),(5558,663),(5559,664),(5560,665),(5561,666),(5562,667),(5563,668),(5564,669),(5565,670),(5566,671),(5567,672),(5568,673),(5569,674),(5570,675),(5571,676),(5572,677),(5573,678),(5574,679),(5575,680),(5576,681),(5577,682),(5578,683),(5579,684),(5580,685),(5581,686),(5582,687),(5583,688),(5584,689),(5585,689),(5586,689),(5587,690),(5588,690),(5589,690),(5590,691),(5591,691),(5592,691),(5593,692),(5594,692),(5595,692),(5596,693),(5597,693),(5598,693),(5599,694),(5600,694),(5601,694),(5602,695),(5603,696),(5604,697),(5605,698),(5606,699),(5607,700),(5608,701),(5609,702),(5610,703),(5611,704),(5612,705),(5613,706),(5614,707),(5615,708),(5616,709),(5617,710),(5618,711),(5619,712),(5620,713),(5621,713),(5622,713),(5623,714),(5624,714),(5625,714),(5626,715),(5627,715),(5628,715),(5629,716),(5630,716),(5631,716),(5632,717),(5633,717),(5634,717),(5635,718),(5636,718),(5637,718),(5638,719),(5639,720),(5640,721),(5641,722),(5642,723),(5643,724),(5644,725),(5645,725),(5646,725),(5647,726),(5648,726),(5649,726),(5650,727),(5651,727),(5652,727),(5653,728),(5654,728),(5655,728),(5656,729),(5657,729),(5658,729),(5659,730),(5660,730),(5661,730),(5662,731),(5663,731),(5664,731),(5665,732),(5666,732),(5667,732),(5668,733),(5669,733),(5670,733),(5671,734),(5672,734),(5673,734),(5674,735),(5675,735),(5676,735),(5677,736),(5678,736),(5679,736),(5680,737),(5681,737),(5682,737),(5683,738),(5684,738),(5685,738),(5686,738),(5687,739),(5688,739),(5689,739),(5690,739),(5691,740),(5692,740),(5693,740),(5694,740),(5695,741),(5696,741),(5697,741),(5698,741),(5699,742),(5700,742),(5701,742),(5702,742),(5703,743),(5704,743),(5705,743),(5706,743),(5707,744),(5708,744),(5709,744),(5710,744),(5711,745),(5712,745),(5713,745),(5714,745),(5715,746),(5716,746),(5717,746),(5718,746),(5719,647),(5720,647),(5721,647),(5722,647),(5723,647),(5724,647),(5725,648),(5726,648),(5727,648),(5728,648),(5729,648),(5730,648),(5731,649),(5732,649),(5733,649),(5734,649),(5735,649),(5736,649),(5737,650),(5738,650),(5739,650),(5740,650),(5741,650),(5742,650),(5743,651),(5744,651),(5745,651),(5746,651),(5747,651),(5748,651),(5749,652),(5750,652),(5751,652),(5752,652),(5753,652),(5754,652),(5755,653),(5756,653),(5757,653),(5758,653),(5759,653),(5760,653),(5761,654),(5762,654),(5763,654),(5764,654),(5765,654),(5766,654),(5767,654),(5768,654),(5769,654),(5770,655),(5771,655),(5772,655),(5773,655),(5774,655),(5775,655),(5776,656),(5777,656),(5778,656),(5779,656),(5780,656),(5781,656),(5782,657),(5783,657),(5784,657),(5785,657),(5786,657),(5787,657),(5788,658),(5789,658),(5790,658),(5791,658),(5792,658),(5793,658),(5794,659),(5795,659),(5796,659),(5797,659),(5798,659),(5799,659),(5800,660),(5801,660),(5802,660),(5803,660),(5804,660),(5805,660),(5806,661),(5807,661),(5808,661),(5809,661),(5810,661),(5811,661),(5812,662),(5813,662),(5814,662),(5815,662),(5816,662),(5817,662),(5818,663),(5819,663),(5820,663),(5821,663),(5822,663),(5823,663),(5824,664),(5825,664),(5826,664),(5827,664),(5828,664),(5829,664),(5830,665),(5831,665),(5832,665),(5833,665),(5834,665),(5835,665),(5836,666),(5837,666),(5838,666),(5839,666),(5840,666),(5841,666),(5842,667),(5843,667),(5844,667),(5845,667),(5846,667),(5847,667),(5848,668),(5849,668),(5850,668),(5851,668),(5852,668),(5853,668),(5854,669),(5855,669),(5856,669),(5857,669),(5858,669),(5859,669),(5860,670),(5861,670),(5862,670),(5863,670),(5864,670),(5865,670),(5866,670),(5867,670),(5868,670),(5869,671),(5870,671),(5871,671),(5872,671),(5873,671),(5874,671),(5875,672),(5876,672),(5877,672),(5878,672),(5879,672),(5880,672),(5881,673),(5882,673),(5883,673),(5884,673),(5885,673),(5886,673),(5887,674),(5888,674),(5889,674),(5890,674),(5891,674),(5892,674),(5893,675),(5894,675),(5895,675),(5896,675),(5897,675),(5898,675),(5899,676),(5900,676),(5901,676),(5902,676),(5903,676),(5904,676),(5905,676),(5906,676),(5907,676),(5908,677),(5909,677),(5910,677),(5911,677),(5912,677),(5913,677),(5914,678),(5915,678),(5916,678),(5917,678),(5918,678),(5919,678),(5920,679),(5921,679),(5922,679),(5923,679),(5924,679),(5925,679),(5926,680),(5927,680),(5928,680),(5929,680),(5930,680),(5931,680),(5932,681),(5933,681),(5934,681),(5935,681),(5936,681),(5937,681),(5938,682),(5939,682),(5940,682),(5941,682),(5942,682),(5943,682),(5944,682),(5945,682),(5946,682),(5947,683),(5948,683),(5949,683),(5950,683),(5951,683),(5952,683),(5953,684),(5954,684),(5955,684),(5956,684),(5957,684),(5958,684),(5959,685),(5960,685),(5961,685),(5962,685),(5963,685),(5964,685),(5965,686),(5966,686),(5967,686),(5968,686),(5969,686),(5970,686),(5971,687),(5972,687),(5973,687),(5974,687),(5975,687),(5976,687),(5977,688),(5978,688),(5979,688),(5980,688),(5981,688),(5982,688),(5983,688),(5984,688),(5985,688),(5986,689),(5987,689),(5988,689),(5989,689),(5990,689),(5991,689),(5992,690),(5993,690),(5994,690),(5995,690),(5996,690),(5997,690),(5998,691),(5999,691),(6000,691),(6001,691),(6002,691),(6003,691),(6004,692),(6005,692),(6006,692),(6007,692),(6008,692),(6009,692),(6010,693),(6011,693),(6012,693),(6013,693),(6014,693),(6015,693),(6016,694),(6017,694),(6018,694),(6019,694),(6020,694),(6021,694),(6022,694),(6023,694),(6024,694),(6025,695),(6026,695),(6027,695),(6028,695),(6029,695),(6030,695),(6031,696),(6032,696),(6033,696),(6034,696),(6035,696),(6036,696),(6037,697),(6038,697),(6039,697),(6040,697),(6041,697),(6042,697),(6043,698),(6044,698),(6045,698),(6046,698),(6047,698),(6048,698),(6049,699),(6050,699),(6051,699),(6052,699),(6053,699),(6054,699),(6055,700),(6056,700),(6057,700),(6058,700),(6059,700),(6060,700),(6061,700),(6062,700),(6063,700),(6064,701),(6065,701),(6066,701),(6067,701),(6068,701),(6069,701),(6070,702),(6071,702),(6072,702),(6073,702),(6074,702),(6075,702),(6076,703),(6077,703),(6078,703),(6079,703),(6080,703),(6081,703),(6082,704),(6083,704),(6084,704),(6085,704),(6086,704),(6087,704),(6088,705),(6089,705),(6090,705),(6091,705),(6092,705),(6093,705),(6094,706),(6095,706),(6096,706),(6097,706),(6098,706),(6099,706),(6100,706),(6101,706),(6102,706),(6103,707),(6104,707),(6105,707),(6106,707),(6107,707),(6108,707),(6109,708),(6110,708),(6111,708),(6112,708),(6113,708),(6114,708),(6115,709),(6116,709),(6117,709),(6118,709),(6119,709),(6120,709),(6121,710),(6122,710),(6123,710),(6124,710),(6125,710),(6126,710),(6127,711),(6128,711),(6129,711),(6130,711),(6131,711),(6132,711),(6133,712),(6134,712),(6135,712),(6136,712),(6137,712),(6138,712),(6139,712),(6140,712),(6141,712),(6142,713),(6143,713),(6144,713),(6145,713),(6146,713),(6147,713),(6148,714),(6149,714),(6150,714),(6151,714),(6152,714),(6153,714),(6154,715),(6155,715),(6156,715),(6157,715),(6158,715),(6159,715),(6160,716),(6161,716),(6162,716),(6163,716),(6164,716),(6165,716),(6166,717),(6167,717),(6168,717),(6169,717),(6170,717),(6171,717),(6172,718),(6173,718),(6174,718),(6175,718),(6176,718),(6177,718),(6178,718),(6179,718),(6180,718),(6181,719),(6182,719),(6183,719),(6184,719),(6185,719),(6186,719),(6187,720),(6188,720),(6189,720),(6190,720),(6191,720),(6192,720),(6193,721),(6194,721),(6195,721),(6196,721),(6197,721),(6198,721),(6199,722),(6200,722),(6201,722),(6202,722),(6203,722),(6204,722),(6205,723),(6206,723),(6207,723),(6208,723),(6209,723),(6210,723),(6211,724),(6212,724),(6213,724),(6214,724),(6215,724),(6216,724),(6217,724),(6218,724),(6219,724),(6220,725),(6221,725),(6222,725),(6223,725),(6224,725),(6225,725),(6226,726),(6227,726),(6228,726),(6229,726),(6230,726),(6231,726),(6232,727),(6233,727),(6234,727),(6235,727),(6236,727),(6237,727),(6238,728),(6239,728),(6240,728),(6241,728),(6242,728),(6243,728),(6244,729),(6245,729),(6246,729),(6247,729),(6248,729),(6249,729),(6250,730),(6251,730),(6252,730),(6253,730),(6254,730),(6255,730),(6256,731),(6257,731),(6258,731),(6259,731),(6260,731),(6261,731),(6262,732),(6263,732),(6264,732),(6265,732),(6266,732),(6267,732),(6268,733),(6269,733),(6270,733),(6271,733),(6272,733),(6273,733),(6274,734),(6275,734),(6276,734),(6277,734),(6278,734),(6279,734),(6280,735),(6281,735),(6282,735),(6283,735),(6284,735),(6285,735),(6286,736),(6287,736),(6288,736),(6289,736),(6290,736),(6291,736),(6292,737),(6293,737),(6294,737),(6295,737),(6296,737),(6297,737),(6298,737),(6299,737),(6300,737),(6301,738),(6302,738),(6303,738),(6304,738),(6305,738),(6306,738),(6307,739),(6308,739),(6309,739),(6310,739),(6311,739),(6312,739),(6313,740),(6314,740),(6315,740),(6316,740),(6317,740),(6318,740),(6319,741),(6320,741),(6321,741),(6322,741),(6323,741),(6324,741),(6325,742),(6326,742),(6327,742),(6328,742),(6329,742),(6330,742),(6331,743),(6332,743),(6333,743),(6334,743),(6335,743),(6336,743),(6337,744),(6338,744),(6339,744),(6340,744),(6341,744),(6342,744),(6343,745),(6344,745),(6345,745),(6346,745),(6347,745),(6348,745),(6349,746),(6350,746),(6351,746),(6352,746),(6353,746),(6354,746),(6355,747),(6356,748),(6357,749),(6358,750),(6359,751),(6360,752),(6361,753),(6362,754),(6363,755),(6364,756),(6365,757),(6366,758),(6367,759),(6368,760),(6369,761),(6370,762),(6371,763),(6372,764),(6373,765),(6374,766),(6375,767),(6376,768),(6377,769),(6378,770),(6379,771),(6380,772),(6381,773),(6382,774),(6383,775),(6384,776),(6385,777),(6386,778),(6387,779),(6388,780),(6389,781),(6390,782),(6391,783),(6392,784),(6393,785),(6394,786),(6395,787),(6396,788),(6397,789),(6398,790),(6399,791),(6400,792),(6401,793),(6402,794),(6403,795),(6404,796),(6405,797),(6406,798),(6407,799),(6408,800),(6409,801),(6410,802),(6411,803),(6412,804),(6413,805),(6414,806),(6415,807),(6416,808),(6417,809),(6418,810),(6419,811),(6420,812),(6421,813),(6422,814),(6423,815),(6424,816),(6425,817),(6426,818),(6427,819),(6428,820),(6429,821),(6430,822),(6431,823),(6432,824),(6433,825),(6434,826),(6435,827),(6436,828),(6437,829),(6438,830),(6439,831),(6440,832),(6441,833),(6442,834),(6443,835),(6444,836),(6445,837),(6446,838),(6447,839),(6448,840),(6449,841),(6450,842),(6451,843),(6452,844),(6453,845),(6454,846),(6455,747),(6456,747),(6457,747),(6458,747),(6459,748),(6460,748),(6461,748),(6462,748),(6463,749),(6464,749),(6465,749),(6466,749),(6467,750),(6468,750),(6469,750),(6470,750),(6471,751),(6472,751),(6473,751),(6474,751),(6475,752),(6476,752),(6477,752),(6478,752),(6479,753),(6480,753),(6481,753),(6482,753),(6483,754),(6484,754),(6485,754),(6486,754),(6487,755),(6488,755),(6489,755),(6490,755),(6491,756),(6492,756),(6493,756),(6494,756),(6495,757),(6496,757),(6497,757),(6498,757),(6499,758),(6500,758),(6501,758),(6502,758),(6503,759),(6504,759),(6505,759),(6506,759),(6507,760),(6508,760),(6509,760),(6510,760),(6511,761),(6512,761),(6513,761),(6514,761),(6515,762),(6516,762),(6517,762),(6518,762),(6519,763),(6520,763),(6521,763),(6522,763),(6523,764),(6524,764),(6525,764),(6526,765),(6527,765),(6528,765),(6529,766),(6530,766),(6531,766),(6532,767),(6533,767),(6534,767),(6535,768),(6536,768),(6537,768),(6538,769),(6539,769),(6540,769),(6541,770),(6542,770),(6543,770),(6544,771),(6545,771),(6546,771),(6547,772),(6548,772),(6549,772),(6550,773),(6551,773),(6552,773),(6553,774),(6554,774),(6555,774),(6556,775),(6557,775),(6558,775),(6559,776),(6560,776),(6561,776),(6562,777),(6563,777),(6564,777),(6565,777),(6566,778),(6567,778),(6568,778),(6569,778),(6570,779),(6571,779),(6572,779),(6573,779),(6574,780),(6575,780),(6576,780),(6577,780),(6578,781),(6579,781),(6580,781),(6581,781),(6582,782),(6583,782),(6584,782),(6585,782),(6586,783),(6587,783),(6588,783),(6589,783),(6590,784),(6591,784),(6592,784),(6593,784),(6594,785),(6595,785),(6596,785),(6597,785),(6598,786),(6599,786),(6600,786),(6601,786),(6602,787),(6603,787),(6604,787),(6605,787),(6606,788),(6607,788),(6608,788),(6609,788),(6610,789),(6611,789),(6612,789),(6613,789),(6614,790),(6615,790),(6616,790),(6617,790),(6618,791),(6619,791),(6620,791),(6621,791),(6622,792),(6623,792),(6624,792),(6625,792),(6626,793),(6627,793),(6628,793),(6629,793),(6630,794),(6631,794),(6632,794),(6633,794),(6634,795),(6635,795),(6636,795),(6637,795),(6638,796),(6639,796),(6640,796),(6641,796),(6642,797),(6643,797),(6644,797),(6645,797),(6646,798),(6647,798),(6648,798),(6649,798),(6650,799),(6651,799),(6652,799),(6653,799),(6654,800),(6655,800),(6656,800),(6657,800),(6658,801),(6659,801),(6660,801),(6661,801),(6662,802),(6663,802),(6664,802),(6665,802),(6666,803),(6667,803),(6668,803),(6669,803),(6670,804),(6671,804),(6672,804),(6673,804),(6674,805),(6675,805),(6676,805),(6677,805),(6678,806),(6679,806),(6680,806),(6681,806),(6682,807),(6683,807),(6684,807),(6685,807),(6686,808),(6687,808),(6688,808),(6689,808),(6690,809),(6691,809),(6692,809),(6693,809),(6694,810),(6695,810),(6696,810),(6697,810),(6698,811),(6699,811),(6700,811),(6701,811),(6702,812),(6703,812),(6704,812),(6705,812),(6706,813),(6707,813),(6708,813),(6709,813),(6710,814),(6711,814),(6712,814),(6713,814),(6714,815),(6715,815),(6716,815),(6717,815),(6718,816),(6719,816),(6720,816),(6721,816),(6722,817),(6723,817),(6724,817),(6725,817),(6726,818),(6727,818),(6728,818),(6729,818),(6730,819),(6731,819),(6732,819),(6733,819),(6734,820),(6735,820),(6736,820),(6737,820),(6738,821),(6739,821),(6740,821),(6741,821),(6742,822),(6743,822),(6744,822),(6745,822),(6746,823),(6747,823),(6748,823),(6749,823),(6750,824),(6751,824),(6752,824),(6753,824),(6754,825),(6755,825),(6756,825),(6757,825),(6758,826),(6759,826),(6760,826),(6761,826),(6762,827),(6763,827),(6764,827),(6765,827),(6766,828),(6767,828),(6768,828),(6769,828),(6770,829),(6771,829),(6772,829),(6773,829),(6774,829),(6775,830),(6776,830),(6777,830),(6778,830),(6779,830),(6780,831),(6781,831),(6782,831),(6783,831),(6784,831),(6785,832),(6786,832),(6787,832),(6788,832),(6789,832),(6790,833),(6791,833),(6792,833),(6793,833),(6794,833),(6795,834),(6796,834),(6797,834),(6798,834),(6799,834),(6800,835),(6801,835),(6802,835),(6803,835),(6804,835),(6805,836),(6806,836),(6807,836),(6808,836),(6809,836),(6810,837),(6811,837),(6812,837),(6813,837),(6814,837),(6815,838),(6816,838),(6817,838),(6818,838),(6819,838),(6820,839),(6821,839),(6822,839),(6823,839),(6824,839),(6825,840),(6826,840),(6827,840),(6828,840),(6829,840),(6830,841),(6831,841),(6832,841),(6833,841),(6834,841),(6835,842),(6836,842),(6837,842),(6838,842),(6839,843),(6840,843),(6841,843),(6842,843),(6843,844),(6844,844),(6845,844),(6846,844),(6847,845),(6848,845),(6849,845),(6850,845),(6851,846),(6852,846),(6853,846),(6854,846),(6855,747),(6856,747),(6857,747),(6858,747),(6859,747),(6860,747),(6861,748),(6862,748),(6863,748),(6864,748),(6865,748),(6866,748),(6867,749),(6868,749),(6869,749),(6870,749),(6871,749),(6872,749),(6873,750),(6874,750),(6875,750),(6876,750),(6877,750),(6878,750),(6879,750),(6880,750),(6881,750),(6882,751),(6883,751),(6884,751),(6885,751),(6886,751),(6887,751),(6888,752),(6889,752),(6890,752),(6891,752),(6892,752),(6893,752),(6894,753),(6895,753),(6896,753),(6897,753),(6898,753),(6899,753),(6900,754),(6901,754),(6902,754),(6903,754),(6904,754),(6905,754),(6906,755),(6907,755),(6908,755),(6909,755),(6910,755),(6911,755),(6912,756),(6913,756),(6914,756),(6915,756),(6916,756),(6917,756),(6918,757),(6919,757),(6920,757),(6921,757),(6922,757),(6923,757),(6924,758),(6925,758),(6926,758),(6927,758),(6928,758),(6929,758),(6930,759),(6931,759),(6932,759),(6933,759),(6934,759),(6935,759),(6936,760),(6937,760),(6938,760),(6939,760),(6940,760),(6941,760),(6942,761),(6943,761),(6944,761),(6945,761),(6946,761),(6947,761),(6948,762),(6949,762),(6950,762),(6951,762),(6952,762),(6953,762),(6954,763),(6955,763),(6956,763),(6957,763),(6958,763),(6959,763),(6960,763),(6961,763),(6962,763),(6963,764),(6964,764),(6965,764),(6966,764),(6967,764),(6968,764),(6969,765),(6970,765),(6971,765),(6972,765),(6973,765),(6974,765),(6975,766),(6976,766),(6977,766),(6978,766),(6979,766),(6980,766),(6981,767),(6982,767),(6983,767),(6984,767),(6985,767),(6986,767),(6987,768),(6988,768),(6989,768),(6990,768),(6991,768),(6992,768),(6993,769),(6994,769),(6995,769),(6996,769),(6997,769),(6998,769),(6999,770),(7000,770),(7001,770),(7002,770),(7003,770),(7004,770),(7005,771),(7006,771),(7007,771),(7008,771),(7009,771),(7010,771),(7011,772),(7012,772),(7013,772),(7014,772),(7015,772),(7016,772),(7017,773),(7018,773),(7019,773),(7020,773),(7021,773),(7022,773),(7023,774),(7024,774),(7025,774),(7026,774),(7027,774),(7028,774),(7029,775),(7030,775),(7031,775),(7032,775),(7033,775),(7034,775),(7035,776),(7036,776),(7037,776),(7038,776),(7039,776),(7040,776),(7041,776),(7042,776),(7043,776),(7044,777),(7045,777),(7046,777),(7047,777),(7048,777),(7049,777),(7050,778),(7051,778),(7052,778),(7053,778),(7054,778),(7055,778),(7056,779),(7057,779),(7058,779),(7059,779),(7060,779),(7061,779),(7062,780),(7063,780),(7064,780),(7065,780),(7066,780),(7067,780),(7068,781),(7069,781),(7070,781),(7071,781),(7072,781),(7073,781),(7074,782),(7075,782),(7076,782),(7077,782),(7078,782),(7079,782),(7080,783),(7081,783),(7082,783),(7083,783),(7084,783),(7085,783),(7086,784),(7087,784),(7088,784),(7089,784),(7090,784),(7091,784),(7092,785),(7093,785),(7094,785),(7095,785),(7096,785),(7097,785),(7098,786),(7099,786),(7100,786),(7101,786),(7102,786),(7103,786),(7104,787),(7105,787),(7106,787),(7107,787),(7108,787),(7109,787),(7110,788),(7111,788),(7112,788),(7113,788),(7114,788),(7115,788),(7116,789),(7117,789),(7118,789),(7119,789),(7120,789),(7121,789),(7122,789),(7123,789),(7124,789),(7125,790),(7126,790),(7127,790),(7128,790),(7129,790),(7130,790),(7131,791),(7132,791),(7133,791),(7134,791),(7135,791),(7136,791),(7137,792),(7138,792),(7139,792),(7140,792),(7141,792),(7142,792),(7143,793),(7144,793),(7145,793),(7146,793),(7147,793),(7148,793),(7149,794),(7150,794),(7151,794),(7152,794),(7153,794),(7154,794),(7155,795),(7156,795),(7157,795),(7158,795),(7159,795),(7160,795),(7161,796),(7162,796),(7163,796),(7164,796),(7165,796),(7166,796),(7167,797),(7168,797),(7169,797),(7170,797),(7171,797),(7172,797),(7173,798),(7174,798),(7175,798),(7176,798),(7177,798),(7178,798),(7179,799),(7180,799),(7181,799),(7182,799),(7183,799),(7184,799),(7185,800),(7186,800),(7187,800),(7188,800),(7189,800),(7190,800),(7191,801),(7192,801),(7193,801),(7194,801),(7195,801),(7196,801),(7197,802),(7198,802),(7199,802),(7200,802),(7201,802),(7202,802),(7203,802),(7204,802),(7205,802),(7206,803),(7207,803),(7208,803),(7209,803),(7210,803),(7211,803),(7212,804),(7213,804),(7214,804),(7215,804),(7216,804),(7217,804),(7218,805),(7219,805),(7220,805),(7221,805),(7222,805),(7223,805),(7224,806),(7225,806),(7226,806),(7227,806),(7228,806),(7229,806),(7230,807),(7231,807),(7232,807),(7233,807),(7234,807),(7235,807),(7236,808),(7237,808),(7238,808),(7239,808),(7240,808),(7241,808),(7242,809),(7243,809),(7244,809),(7245,809),(7246,809),(7247,809),(7248,810),(7249,810),(7250,810),(7251,810),(7252,810),(7253,810),(7254,811),(7255,811),(7256,811),(7257,811),(7258,811),(7259,811),(7260,812),(7261,812),(7262,812),(7263,812),(7264,812),(7265,812),(7266,813),(7267,813),(7268,813),(7269,813),(7270,813),(7271,813),(7272,814),(7273,814),(7274,814),(7275,814),(7276,814),(7277,814),(7278,815),(7279,815),(7280,815),(7281,815),(7282,815),(7283,815),(7284,815),(7285,815),(7286,815),(7287,816),(7288,816),(7289,816),(7290,816),(7291,816),(7292,816),(7293,817),(7294,817),(7295,817),(7296,817),(7297,817),(7298,817),(7299,818),(7300,818),(7301,818),(7302,818),(7303,818),(7304,818),(7305,819),(7306,819),(7307,819),(7308,819),(7309,819),(7310,819),(7311,820),(7312,820),(7313,820),(7314,820),(7315,820),(7316,820),(7317,821),(7318,821),(7319,821),(7320,821),(7321,821),(7322,821),(7323,822),(7324,822),(7325,822),(7326,822),(7327,822),(7328,822),(7329,823),(7330,823),(7331,823),(7332,823),(7333,823),(7334,823),(7335,824),(7336,824),(7337,824),(7338,824),(7339,824),(7340,824),(7341,825),(7342,825),(7343,825),(7344,825),(7345,825),(7346,825),(7347,826),(7348,826),(7349,826),(7350,826),(7351,826),(7352,826),(7353,827),(7354,827),(7355,827),(7356,827),(7357,827),(7358,827),(7359,828),(7360,828),(7361,828),(7362,828),(7363,828),(7364,828),(7365,828),(7366,828),(7367,828),(7368,829),(7369,829),(7370,829),(7371,829),(7372,829),(7373,829),(7374,830),(7375,830),(7376,830),(7377,830),(7378,830),(7379,830),(7380,831),(7381,831),(7382,831),(7383,831),(7384,831),(7385,831),(7386,832),(7387,832),(7388,832),(7389,832),(7390,832),(7391,832),(7392,833),(7393,833),(7394,833),(7395,833),(7396,833),(7397,833),(7398,834),(7399,834),(7400,834),(7401,834),(7402,834),(7403,834),(7404,835),(7405,835),(7406,835),(7407,835),(7408,835),(7409,835),(7410,836),(7411,836),(7412,836),(7413,836),(7414,836),(7415,836),(7416,837),(7417,837),(7418,837),(7419,837),(7420,837),(7421,837),(7422,838),(7423,838),(7424,838),(7425,838),(7426,838),(7427,838),(7428,839),(7429,839),(7430,839),(7431,839),(7432,839),(7433,839),(7434,840),(7435,840),(7436,840),(7437,840),(7438,840),(7439,840),(7440,841),(7441,841),(7442,841),(7443,841),(7444,841),(7445,841),(7446,841),(7447,841),(7448,841),(7449,842),(7450,842),(7451,842),(7452,842),(7453,842),(7454,842),(7455,843),(7456,843),(7457,843),(7458,843),(7459,843),(7460,843),(7461,844),(7462,844),(7463,844),(7464,844),(7465,844),(7466,844),(7467,845),(7468,845),(7469,845),(7470,845),(7471,845),(7472,845),(7473,846),(7474,846),(7475,846),(7476,846),(7477,846),(7478,846),(7479,847),(7480,848),(7481,849),(7482,850),(7483,851),(7484,852),(7485,853),(7486,854),(7487,855),(7488,856),(7489,857),(7490,858),(7491,859),(7492,860),(7493,861),(7494,862),(7495,863),(7496,864),(7497,865),(7498,866),(7499,867),(7500,868),(7501,869),(7502,870),(7503,871),(7504,872),(7505,873),(7506,874),(7507,875),(7508,876),(7509,877),(7510,878),(7511,879),(7512,880),(7513,881),(7514,882),(7515,883),(7516,884),(7517,885),(7518,886),(7519,887),(7520,888),(7521,889),(7522,890),(7523,891),(7524,892),(7525,893),(7526,894),(7527,895),(7528,896),(7529,897),(7530,898),(7531,899),(7532,900),(7533,901),(7534,902),(7535,903),(7536,904),(7537,905),(7538,906),(7539,907),(7540,908),(7541,909),(7542,910),(7543,911),(7544,912),(7545,913),(7546,914),(7547,915),(7548,916),(7549,917),(7550,918),(7551,919),(7552,920),(7553,921),(7554,922),(7555,923),(7556,924),(7557,925),(7558,926),(7559,927),(7560,928),(7561,929),(7562,930),(7563,931),(7564,932),(7565,933),(7566,934),(7567,935),(7568,936),(7569,937),(7570,938),(7571,939),(7572,940),(7573,941),(7574,942),(7575,943),(7576,944),(7577,945),(7578,946),(7579,847),(7580,847),(7581,847),(7582,847),(7583,848),(7584,848),(7585,848),(7586,848),(7587,849),(7588,849),(7589,849),(7590,849),(7591,850),(7592,850),(7593,850),(7594,850),(7595,851),(7596,851),(7597,851),(7598,851),(7599,852),(7600,852),(7601,852),(7602,852),(7603,853),(7604,853),(7605,853),(7606,853),(7607,854),(7608,854),(7609,854),(7610,854),(7611,855),(7612,855),(7613,855),(7614,855),(7615,856),(7616,856),(7617,856),(7618,856),(7619,857),(7620,857),(7621,857),(7622,857),(7623,858),(7624,858),(7625,858),(7626,858),(7627,859),(7628,859),(7629,859),(7630,859),(7631,860),(7632,860),(7633,860),(7634,860),(7635,861),(7636,861),(7637,861),(7638,861),(7639,862),(7640,862),(7641,862),(7642,862),(7643,863),(7644,863),(7645,863),(7646,863),(7647,864),(7648,864),(7649,864),(7650,864),(7651,865),(7652,865),(7653,865),(7654,865),(7655,866),(7656,866),(7657,866),(7658,866),(7659,867),(7660,867),(7661,867),(7662,867),(7663,868),(7664,868),(7665,868),(7666,869),(7667,869),(7668,869),(7669,870),(7670,870),(7671,870),(7672,871),(7673,871),(7674,871),(7675,872),(7676,872),(7677,872),(7678,873),(7679,873),(7680,873),(7681,874),(7682,874),(7683,874),(7684,875),(7685,875),(7686,875),(7687,876),(7688,876),(7689,876),(7690,877),(7691,877),(7692,877),(7693,878),(7694,878),(7695,878),(7696,879),(7697,879),(7698,879),(7699,880),(7700,880),(7701,880),(7702,881),(7703,881),(7704,881),(7705,882),(7706,882),(7707,882),(7708,883),(7709,883),(7710,883),(7711,884),(7712,884),(7713,884),(7714,885),(7715,885),(7716,885),(7717,886),(7718,886),(7719,886),(7720,887),(7721,887),(7722,887),(7723,888),(7724,888),(7725,888),(7726,889),(7727,889),(7728,889),(7729,890),(7730,890),(7731,890),(7732,891),(7733,891),(7734,891),(7735,892),(7736,892),(7737,892),(7738,893),(7739,893),(7740,893),(7741,894),(7742,895),(7743,896),(7744,897),(7745,898),(7746,899),(7747,899),(7748,899),(7749,900),(7750,900),(7751,900),(7752,901),(7753,901),(7754,901),(7755,902),(7756,902),(7757,902),(7758,903),(7759,903),(7760,903),(7761,904),(7762,904),(7763,904),(7764,905),(7765,905),(7766,905),(7767,906),(7768,906),(7769,906),(7770,907),(7771,907),(7772,907),(7773,908),(7774,908),(7775,908),(7776,909),(7777,909),(7778,909),(7779,910),(7780,910),(7781,910),(7782,911),(7783,911),(7784,911),(7785,912),(7786,913),(7787,914),(7788,915),(7789,916),(7790,917),(7791,918),(7792,919),(7793,920),(7794,921),(7795,922),(7796,923),(7797,924),(7798,925),(7799,925),(7800,925),(7801,926),(7802,926),(7803,926),(7804,927),(7805,927),(7806,927),(7807,928),(7808,928),(7809,928),(7810,929),(7811,929),(7812,929),(7813,930),(7814,930),(7815,930),(7816,931),(7817,931),(7818,931),(7819,932),(7820,932),(7821,932),(7822,933),(7823,933),(7824,933),(7825,934),(7826,934),(7827,934),(7828,935),(7829,935),(7830,935),(7831,936),(7832,936),(7833,936),(7834,937),(7835,937),(7836,937),(7837,938),(7838,938),(7839,938),(7840,939),(7841,939),(7842,939),(7843,940),(7844,940),(7845,940),(7846,941),(7847,941),(7848,941),(7849,942),(7850,942),(7851,942),(7852,943),(7853,943),(7854,943),(7855,944),(7856,944),(7857,944),(7858,945),(7859,945),(7860,945),(7861,946),(7862,946),(7863,946),(7864,847),(7865,847),(7866,847),(7867,847),(7868,847),(7869,847),(7870,848),(7871,848),(7872,848),(7873,848),(7874,848),(7875,848),(7876,849),(7877,849),(7878,849),(7879,849),(7880,849),(7881,849),(7882,850),(7883,850),(7884,850),(7885,850),(7886,850),(7887,850),(7888,851),(7889,851),(7890,851),(7891,851),(7892,851),(7893,851),(7894,852),(7895,852),(7896,852),(7897,852),(7898,852),(7899,852),(7900,853),(7901,853),(7902,853),(7903,853),(7904,853),(7905,853),(7906,854),(7907,854),(7908,854),(7909,854),(7910,854),(7911,854),(7912,854),(7913,854),(7914,854),(7915,855),(7916,855),(7917,855),(7918,855),(7919,855),(7920,855),(7921,856),(7922,856),(7923,856),(7924,856),(7925,856),(7926,856),(7927,857),(7928,857),(7929,857),(7930,857),(7931,857),(7932,857),(7933,858),(7934,858),(7935,858),(7936,858),(7937,858),(7938,858),(7939,859),(7940,859),(7941,859),(7942,859),(7943,859),(7944,859),(7945,860),(7946,860),(7947,860),(7948,860),(7949,860),(7950,860),(7951,861),(7952,861),(7953,861),(7954,861),(7955,861),(7956,861),(7957,862),(7958,862),(7959,862),(7960,862),(7961,862),(7962,862),(7963,863),(7964,863),(7965,863),(7966,863),(7967,863),(7968,863),(7969,864),(7970,864),(7971,864),(7972,864),(7973,864),(7974,864),(7975,865),(7976,865),(7977,865),(7978,865),(7979,865),(7980,865),(7981,866),(7982,866),(7983,866),(7984,866),(7985,866),(7986,866),(7987,867),(7988,867),(7989,867),(7990,867),(7991,867),(7992,867),(7993,867),(7994,867),(7995,867),(7996,868),(7997,868),(7998,868),(7999,868),(8000,868),(8001,868),(8002,869),(8003,869),(8004,869),(8005,869),(8006,869),(8007,869),(8008,870),(8009,870),(8010,870),(8011,870),(8012,870),(8013,870),(8014,871),(8015,871),(8016,871),(8017,871),(8018,871),(8019,871),(8020,872),(8021,872),(8022,872),(8023,872),(8024,872),(8025,872),(8026,873),(8027,873),(8028,873),(8029,873),(8030,873),(8031,873),(8032,874),(8033,874),(8034,874),(8035,874),(8036,874),(8037,874),(8038,875),(8039,875),(8040,875),(8041,875),(8042,875),(8043,875),(8044,876),(8045,876),(8046,876),(8047,876),(8048,876),(8049,876),(8050,877),(8051,877),(8052,877),(8053,877),(8054,877),(8055,877),(8056,878),(8057,878),(8058,878),(8059,878),(8060,878),(8061,878),(8062,879),(8063,879),(8064,879),(8065,879),(8066,879),(8067,879),(8068,880),(8069,880),(8070,880),(8071,880),(8072,880),(8073,880),(8074,880),(8075,880),(8076,880),(8077,881),(8078,881),(8079,881),(8080,881),(8081,881),(8082,881),(8083,882),(8084,882),(8085,882),(8086,882),(8087,882),(8088,882),(8089,883),(8090,883),(8091,883),(8092,883),(8093,883),(8094,883),(8095,884),(8096,884),(8097,884),(8098,884),(8099,884),(8100,884),(8101,885),(8102,885),(8103,885),(8104,885),(8105,885),(8106,885),(8107,886),(8108,886),(8109,886),(8110,886),(8111,886),(8112,886),(8113,887),(8114,887),(8115,887),(8116,887),(8117,887),(8118,887),(8119,888),(8120,888),(8121,888),(8122,888),(8123,888),(8124,888),(8125,889),(8126,889),(8127,889),(8128,889),(8129,889),(8130,889),(8131,890),(8132,890),(8133,890),(8134,890),(8135,890),(8136,890),(8137,891),(8138,891),(8139,891),(8140,891),(8141,891),(8142,891),(8143,892),(8144,892),(8145,892),(8146,892),(8147,892),(8148,892),(8149,893),(8150,893),(8151,893),(8152,893),(8153,893),(8154,893),(8155,893),(8156,893),(8157,893),(8158,894),(8159,894),(8160,894),(8161,894),(8162,894),(8163,894),(8164,895),(8165,895),(8166,895),(8167,895),(8168,895),(8169,895),(8170,896),(8171,896),(8172,896),(8173,896),(8174,896),(8175,896),(8176,897),(8177,897),(8178,897),(8179,897),(8180,897),(8181,897),(8182,898),(8183,898),(8184,898),(8185,898),(8186,898),(8187,898),(8188,898),(8189,898),(8190,898),(8191,899),(8192,899),(8193,899),(8194,899),(8195,899),(8196,899),(8197,900),(8198,900),(8199,900),(8200,900),(8201,900),(8202,900),(8203,901),(8204,901),(8205,901),(8206,901),(8207,901),(8208,901),(8209,902),(8210,902),(8211,902),(8212,902),(8213,902),(8214,902),(8215,903),(8216,903),(8217,903),(8218,903),(8219,903),(8220,903),(8221,904),(8222,904),(8223,904),(8224,904),(8225,904),(8226,904),(8227,905),(8228,905),(8229,905),(8230,905),(8231,905),(8232,905),(8233,906),(8234,906),(8235,906),(8236,906),(8237,906),(8238,906),(8239,907),(8240,907),(8241,907),(8242,907),(8243,907),(8244,907),(8245,908),(8246,908),(8247,908),(8248,908),(8249,908),(8250,908),(8251,909),(8252,909),(8253,909),(8254,909),(8255,909),(8256,909),(8257,910),(8258,910),(8259,910),(8260,910),(8261,910),(8262,910),(8263,911),(8264,911),(8265,911),(8266,911),(8267,911),(8268,911),(8269,911),(8270,911),(8271,911),(8272,912),(8273,912),(8274,912),(8275,912),(8276,912),(8277,912),(8278,913),(8279,913),(8280,913),(8281,913),(8282,913),(8283,913),(8284,914),(8285,914),(8286,914),(8287,914),(8288,914),(8289,914),(8290,915),(8291,915),(8292,915),(8293,915),(8294,915),(8295,915),(8296,916),(8297,916),(8298,916),(8299,916),(8300,916),(8301,916),(8302,917),(8303,917),(8304,917),(8305,917),(8306,917),(8307,917),(8308,918),(8309,918),(8310,918),(8311,918),(8312,918),(8313,918),(8314,919),(8315,919),(8316,919),(8317,919),(8318,919),(8319,919),(8320,920),(8321,920),(8322,920),(8323,920),(8324,920),(8325,920),(8326,921),(8327,921),(8328,921),(8329,921),(8330,921),(8331,921),(8332,922),(8333,922),(8334,922),(8335,922),(8336,922),(8337,922),(8338,923),(8339,923),(8340,923),(8341,923),(8342,923),(8343,923),(8344,924),(8345,924),(8346,924),(8347,924),(8348,924),(8349,924),(8350,924),(8351,924),(8352,924),(8353,925),(8354,925),(8355,925),(8356,925),(8357,925),(8358,925),(8359,926),(8360,926),(8361,926),(8362,926),(8363,926),(8364,926),(8365,927),(8366,927),(8367,927),(8368,927),(8369,927),(8370,927),(8371,928),(8372,928),(8373,928),(8374,928),(8375,928),(8376,928),(8377,929),(8378,929),(8379,929),(8380,929),(8381,929),(8382,929),(8383,930),(8384,930),(8385,930),(8386,930),(8387,930),(8388,930),(8389,931),(8390,931),(8391,931),(8392,931),(8393,931),(8394,931),(8395,932),(8396,932),(8397,932),(8398,932),(8399,932),(8400,932),(8401,933),(8402,933),(8403,933),(8404,933),(8405,933),(8406,933),(8407,934),(8408,934),(8409,934),(8410,934),(8411,934),(8412,934),(8413,935),(8414,935),(8415,935),(8416,935),(8417,935),(8418,935),(8419,936),(8420,936),(8421,936),(8422,936),(8423,936),(8424,936),(8425,937),(8426,937),(8427,937),(8428,937),(8429,937),(8430,937),(8431,937),(8432,937),(8433,937),(8434,938),(8435,938),(8436,938),(8437,938),(8438,938),(8439,938),(8440,939),(8441,939),(8442,939),(8443,939),(8444,939),(8445,939),(8446,940),(8447,940),(8448,940),(8449,940),(8450,940),(8451,940),(8452,941),(8453,941),(8454,941),(8455,941),(8456,941),(8457,941),(8458,942),(8459,942),(8460,942),(8461,942),(8462,942),(8463,942),(8464,943),(8465,943),(8466,943),(8467,943),(8468,943),(8469,943),(8470,944),(8471,944),(8472,944),(8473,944),(8474,944),(8475,944),(8476,945),(8477,945),(8478,945),(8479,945),(8480,945),(8481,945),(8482,946),(8483,946),(8484,946),(8485,946),(8486,946),(8487,946),(8488,947),(8489,948),(8490,949),(8491,950),(8492,951),(8493,952),(8494,953),(8495,954),(8496,955),(8497,956),(8498,957),(8499,958),(8500,959),(8501,960),(8502,961),(8503,962),(8504,963),(8505,964),(8506,965),(8507,966),(8508,967),(8509,968),(8510,969),(8511,970),(8512,971),(8513,972),(8514,973),(8515,974),(8516,975),(8517,976),(8518,977),(8519,978),(8520,979),(8521,980),(8522,981),(8523,982),(8524,983),(8525,984),(8526,985),(8527,986),(8528,987),(8529,988),(8530,989),(8531,990),(8532,991),(8533,992),(8534,993),(8535,994),(8536,995),(8537,996),(8538,997),(8539,998),(8540,999),(8541,1000),(8542,1001),(8543,1002),(8544,1003),(8545,1004),(8546,1005),(8547,1006),(8548,1007),(8549,1008),(8550,1009),(8551,1010),(8552,1011),(8553,1012),(8554,1013),(8555,1014),(8556,1015),(8557,1016),(8558,1017),(8559,1018),(8560,1019),(8561,1020),(8562,1021),(8563,1022),(8564,1023),(8565,1024),(8566,1025),(8567,1026),(8568,1027),(8569,1028),(8570,1029),(8571,1030),(8572,1031),(8573,1032),(8574,1033),(8575,1034),(8576,1035),(8577,1036),(8578,1037),(8579,1038),(8580,1039),(8581,1040),(8582,1041),(8583,1042),(8584,1043),(8585,1044),(8586,1045),(8587,1046),(8588,947),(8589,947),(8590,947),(8591,948),(8592,948),(8593,948),(8594,949),(8595,949),(8596,949),(8597,950),(8598,950),(8599,950),(8600,951),(8601,951),(8602,951),(8603,951),(8604,952),(8605,952),(8606,952),(8607,952),(8608,953),(8609,953),(8610,953),(8611,953),(8612,954),(8613,954),(8614,954),(8615,954),(8616,955),(8617,955),(8618,955),(8619,955),(8620,956),(8621,956),(8622,956),(8623,956),(8624,957),(8625,957),(8626,957),(8627,957),(8628,958),(8629,958),(8630,958),(8631,958),(8632,959),(8633,959),(8634,959),(8635,959),(8636,960),(8637,960),(8638,960),(8639,960),(8640,961),(8641,961),(8642,961),(8643,961),(8644,962),(8645,962),(8646,962),(8647,962),(8648,963),(8649,963),(8650,963),(8651,963),(8652,964),(8653,964),(8654,964),(8655,965),(8656,965),(8657,965),(8658,966),(8659,966),(8660,966),(8661,967),(8662,967),(8663,967),(8664,968),(8665,968),(8666,968),(8667,969),(8668,969),(8669,969),(8670,970),(8671,970),(8672,970),(8673,971),(8674,971),(8675,971),(8676,972),(8677,972),(8678,972),(8679,973),(8680,973),(8681,973),(8682,974),(8683,974),(8684,974),(8685,975),(8686,975),(8687,975),(8688,976),(8689,976),(8690,976),(8691,977),(8692,977),(8693,977),(8694,978),(8695,978),(8696,978),(8697,979),(8698,979),(8699,979),(8700,980),(8701,980),(8702,980),(8703,981),(8704,981),(8705,981),(8706,982),(8707,982),(8708,982),(8709,983),(8710,983),(8711,983),(8712,984),(8713,984),(8714,984),(8715,985),(8716,985),(8717,985),(8718,986),(8719,986),(8720,986),(8721,987),(8722,987),(8723,987),(8724,988),(8725,988),(8726,988),(8727,989),(8728,989),(8729,989),(8730,990),(8731,990),(8732,990),(8733,991),(8734,991),(8735,991),(8736,992),(8737,992),(8738,992),(8739,993),(8740,993),(8741,993),(8742,994),(8743,994),(8744,994),(8745,995),(8746,995),(8747,995),(8748,996),(8749,996),(8750,996),(8751,997),(8752,997),(8753,997),(8754,998),(8755,998),(8756,998),(8757,999),(8758,999),(8759,999),(8760,1000),(8761,1000),(8762,1000),(8763,1001),(8764,1001),(8765,1001),(8766,1002),(8767,1002),(8768,1002),(8769,1003),(8770,1004),(8771,1005),(8772,1006),(8773,1007),(8774,1008),(8775,1009),(8776,1010),(8777,1011),(8778,1012),(8779,1013),(8780,1014),(8781,1015),(8782,1016),(8783,1016),(8784,1016),(8785,1017),(8786,1017),(8787,1017),(8788,1018),(8789,1018),(8790,1018),(8791,1019),(8792,1019),(8793,1019),(8794,1020),(8795,1020),(8796,1020),(8797,1021),(8798,1021),(8799,1021),(8800,1022),(8801,1022),(8802,1022),(8803,1023),(8804,1023),(8805,1023),(8806,1024),(8807,1024),(8808,1024),(8809,1025),(8810,1025),(8811,1025),(8812,1026),(8813,1026),(8814,1026),(8815,1027),(8816,1027),(8817,1027),(8818,1028),(8819,1028),(8820,1028),(8821,1029),(8822,1029),(8823,1029),(8824,1029),(8825,1030),(8826,1030),(8827,1030),(8828,1030),(8829,1031),(8830,1031),(8831,1031),(8832,1031),(8833,1032),(8834,1032),(8835,1032),(8836,1032),(8837,1033),(8838,1033),(8839,1033),(8840,1033),(8841,1034),(8842,1034),(8843,1034),(8844,1034),(8845,1035),(8846,1035),(8847,1035),(8848,1035),(8849,1036),(8850,1036),(8851,1036),(8852,1036),(8853,1037),(8854,1037),(8855,1037),(8856,1037),(8857,1038),(8858,1038),(8859,1038),(8860,1038),(8861,1039),(8862,1039),(8863,1039),(8864,1039),(8865,1040),(8866,1040),(8867,1040),(8868,1040),(8869,1041),(8870,1041),(8871,1041),(8872,1041),(8873,1042),(8874,1042),(8875,1042),(8876,1042),(8877,1043),(8878,1043),(8879,1043),(8880,1043),(8881,1044),(8882,1044),(8883,1044),(8884,1044),(8885,1045),(8886,1045),(8887,1045),(8888,1046),(8889,1046),(8890,1046),(8891,947),(8892,947),(8893,947),(8894,947),(8895,947),(8896,947),(8897,948),(8898,948),(8899,948),(8900,948),(8901,948),(8902,948),(8903,949),(8904,949),(8905,949),(8906,949),(8907,949),(8908,949),(8909,950),(8910,950),(8911,950),(8912,950),(8913,950),(8914,950),(8915,950),(8916,950),(8917,950),(8918,951),(8919,951),(8920,951),(8921,951),(8922,951),(8923,951),(8924,952),(8925,952),(8926,952),(8927,952),(8928,952),(8929,952),(8930,953),(8931,953),(8932,953),(8933,953),(8934,953),(8935,953),(8936,954),(8937,954),(8938,954),(8939,954),(8940,954),(8941,954),(8942,955),(8943,955),(8944,955),(8945,955),(8946,955),(8947,955),(8948,956),(8949,956),(8950,956),(8951,956),(8952,956),(8953,956),(8954,957),(8955,957),(8956,957),(8957,957),(8958,957),(8959,957),(8960,958),(8961,958),(8962,958),(8963,958),(8964,958),(8965,958),(8966,959),(8967,959),(8968,959),(8969,959),(8970,959),(8971,959),(8972,960),(8973,960),(8974,960),(8975,960),(8976,960),(8977,960),(8978,961),(8979,961),(8980,961),(8981,961),(8982,961),(8983,961),(8984,962),(8985,962),(8986,962),(8987,962),(8988,962),(8989,962),(8990,963),(8991,963),(8992,963),(8993,963),(8994,963),(8995,963),(8996,963),(8997,963),(8998,963),(8999,964),(9000,964),(9001,964),(9002,964),(9003,964),(9004,964),(9005,965),(9006,965),(9007,965),(9008,965),(9009,965),(9010,965),(9011,966),(9012,966),(9013,966),(9014,966),(9015,966),(9016,966),(9017,967),(9018,967),(9019,967),(9020,967),(9021,967),(9022,967),(9023,968),(9024,968),(9025,968),(9026,968),(9027,968),(9028,968),(9029,969),(9030,969),(9031,969),(9032,969),(9033,969),(9034,969),(9035,970),(9036,970),(9037,970),(9038,970),(9039,970),(9040,970),(9041,971),(9042,971),(9043,971),(9044,971),(9045,971),(9046,971),(9047,972),(9048,972),(9049,972),(9050,972),(9051,972),(9052,972),(9053,973),(9054,973),(9055,973),(9056,973),(9057,973),(9058,973),(9059,974),(9060,974),(9061,974),(9062,974),(9063,974),(9064,974),(9065,975),(9066,975),(9067,975),(9068,975),(9069,975),(9070,975),(9071,976),(9072,976),(9073,976),(9074,976),(9075,976),(9076,976),(9077,976),(9078,976),(9079,976),(9080,977),(9081,977),(9082,977),(9083,977),(9084,977),(9085,977),(9086,978),(9087,978),(9088,978),(9089,978),(9090,978),(9091,978),(9092,979),(9093,979),(9094,979),(9095,979),(9096,979),(9097,979),(9098,980),(9099,980),(9100,980),(9101,980),(9102,980),(9103,980),(9104,981),(9105,981),(9106,981),(9107,981),(9108,981),(9109,981),(9110,982),(9111,982),(9112,982),(9113,982),(9114,982),(9115,982),(9116,983),(9117,983),(9118,983),(9119,983),(9120,983),(9121,983),(9122,984),(9123,984),(9124,984),(9125,984),(9126,984),(9127,984),(9128,985),(9129,985),(9130,985),(9131,985),(9132,985),(9133,985),(9134,986),(9135,986),(9136,986),(9137,986),(9138,986),(9139,986),(9140,987),(9141,987),(9142,987),(9143,987),(9144,987),(9145,987),(9146,988),(9147,988),(9148,988),(9149,988),(9150,988),(9151,988),(9152,989),(9153,989),(9154,989),(9155,989),(9156,989),(9157,989),(9158,989),(9159,989),(9160,989),(9161,990),(9162,990),(9163,990),(9164,990),(9165,990),(9166,990),(9167,991),(9168,991),(9169,991),(9170,991),(9171,991),(9172,991),(9173,992),(9174,992),(9175,992),(9176,992),(9177,992),(9178,992),(9179,993),(9180,993),(9181,993),(9182,993),(9183,993),(9184,993),(9185,994),(9186,994),(9187,994),(9188,994),(9189,994),(9190,994),(9191,995),(9192,995),(9193,995),(9194,995),(9195,995),(9196,995),(9197,996),(9198,996),(9199,996),(9200,996),(9201,996),(9202,996),(9203,997),(9204,997),(9205,997),(9206,997),(9207,997),(9208,997),(9209,998),(9210,998),(9211,998),(9212,998),(9213,998),(9214,998),(9215,999),(9216,999),(9217,999),(9218,999),(9219,999),(9220,999),(9221,1000),(9222,1000),(9223,1000),(9224,1000),(9225,1000),(9226,1000),(9227,1001),(9228,1001),(9229,1001),(9230,1001),(9231,1001),(9232,1001),(9233,1002),(9234,1002),(9235,1002),(9236,1002),(9237,1002),(9238,1002),(9239,1002),(9240,1002),(9241,1002),(9242,1003),(9243,1003),(9244,1003),(9245,1003),(9246,1003),(9247,1003),(9248,1004),(9249,1004),(9250,1004),(9251,1004),(9252,1004),(9253,1004),(9254,1005),(9255,1005),(9256,1005),(9257,1005),(9258,1005),(9259,1005),(9260,1006),(9261,1006),(9262,1006),(9263,1006),(9264,1006),(9265,1006),(9266,1007),(9267,1007),(9268,1007),(9269,1007),(9270,1007),(9271,1007),(9272,1008),(9273,1008),(9274,1008),(9275,1008),(9276,1008),(9277,1008),(9278,1009),(9279,1009),(9280,1009),(9281,1009),(9282,1009),(9283,1009),(9284,1010),(9285,1010),(9286,1010),(9287,1010),(9288,1010),(9289,1010),(9290,1011),(9291,1011),(9292,1011),(9293,1011),(9294,1011),(9295,1011),(9296,1012),(9297,1012),(9298,1012),(9299,1012),(9300,1012),(9301,1012),(9302,1013),(9303,1013),(9304,1013),(9305,1013),(9306,1013),(9307,1013),(9308,1014),(9309,1014),(9310,1014),(9311,1014),(9312,1014),(9313,1014),(9314,1015),(9315,1015),(9316,1015),(9317,1015),(9318,1015),(9319,1015),(9320,1015),(9321,1015),(9322,1015),(9323,1016),(9324,1016),(9325,1016),(9326,1016),(9327,1016),(9328,1016),(9329,1017),(9330,1017),(9331,1017),(9332,1017),(9333,1017),(9334,1017),(9335,1018),(9336,1018),(9337,1018),(9338,1018),(9339,1018),(9340,1018),(9341,1019),(9342,1019),(9343,1019),(9344,1019),(9345,1019),(9346,1019),(9347,1020),(9348,1020),(9349,1020),(9350,1020),(9351,1020),(9352,1020),(9353,1021),(9354,1021),(9355,1021),(9356,1021),(9357,1021),(9358,1021),(9359,1022),(9360,1022),(9361,1022),(9362,1022),(9363,1022),(9364,1022),(9365,1023),(9366,1023),(9367,1023),(9368,1023),(9369,1023),(9370,1023),(9371,1024),(9372,1024),(9373,1024),(9374,1024),(9375,1024),(9376,1024),(9377,1025),(9378,1025),(9379,1025),(9380,1025),(9381,1025),(9382,1025),(9383,1026),(9384,1026),(9385,1026),(9386,1026),(9387,1026),(9388,1026),(9389,1027),(9390,1027),(9391,1027),(9392,1027),(9393,1027),(9394,1027),(9395,1028),(9396,1028),(9397,1028),(9398,1028),(9399,1028),(9400,1028),(9401,1028),(9402,1028),(9403,1028),(9404,1029),(9405,1029),(9406,1029),(9407,1029),(9408,1029),(9409,1029),(9410,1030),(9411,1030),(9412,1030),(9413,1030),(9414,1030),(9415,1030),(9416,1031),(9417,1031),(9418,1031),(9419,1031),(9420,1031),(9421,1031),(9422,1032),(9423,1032),(9424,1032),(9425,1032),(9426,1032),(9427,1032),(9428,1033),(9429,1033),(9430,1033),(9431,1033),(9432,1033),(9433,1033),(9434,1034),(9435,1034),(9436,1034),(9437,1034),(9438,1034),(9439,1034),(9440,1035),(9441,1035),(9442,1035),(9443,1035),(9444,1035),(9445,1035),(9446,1036),(9447,1036),(9448,1036),(9449,1036),(9450,1036),(9451,1036),(9452,1037),(9453,1037),(9454,1037),(9455,1037),(9456,1037),(9457,1037),(9458,1038),(9459,1038),(9460,1038),(9461,1038),(9462,1038),(9463,1038),(9464,1039),(9465,1039),(9466,1039),(9467,1039),(9468,1039),(9469,1039),(9470,1040),(9471,1040),(9472,1040),(9473,1040),(9474,1040),(9475,1040),(9476,1041),(9477,1041),(9478,1041),(9479,1041),(9480,1041),(9481,1041),(9482,1042),(9483,1042),(9484,1042),(9485,1042),(9486,1042),(9487,1042),(9488,1043),(9489,1043),(9490,1043),(9491,1043),(9492,1043),(9493,1043),(9494,1044),(9495,1044),(9496,1044),(9497,1044),(9498,1044),(9499,1044),(9500,1044),(9501,1044),(9502,1044),(9503,1045),(9504,1045),(9505,1045),(9506,1045),(9507,1045),(9508,1045),(9509,1046),(9510,1046),(9511,1046),(9512,1046),(9513,1046),(9514,1046),(9515,1047),(9516,1048),(9517,1049),(9518,1050),(9519,1051),(9520,1052),(9521,1053),(9522,1054),(9523,1055),(9524,1056),(9525,1057),(9526,1058),(9527,1059),(9528,1060),(9529,1061),(9530,1062),(9531,1063),(9532,1064),(9533,1065),(9534,1066),(9535,1067),(9536,1068),(9537,1069),(9538,1070),(9539,1071),(9540,1072),(9541,1073),(9542,1074),(9543,1075),(9544,1076),(9545,1077),(9546,1078),(9547,1079),(9548,1080),(9549,1081),(9550,1082),(9551,1083),(9552,1084),(9553,1085),(9554,1086),(9555,1087),(9556,1088),(9557,1089),(9558,1090),(9559,1091),(9560,1092),(9561,1093),(9562,1094),(9563,1095),(9564,1096),(9565,1097),(9566,1098),(9567,1099),(9568,1100),(9569,1101),(9570,1102),(9571,1103),(9572,1104),(9573,1105),(9574,1106),(9575,1107),(9576,1108),(9577,1109),(9578,1110),(9579,1111),(9580,1112),(9581,1113),(9582,1114),(9583,1115),(9584,1116),(9585,1117),(9586,1118),(9587,1119),(9588,1120),(9589,1121),(9590,1122),(9591,1123),(9592,1124),(9593,1125),(9594,1126),(9595,1127),(9596,1128),(9597,1129),(9598,1130),(9599,1131),(9600,1132),(9601,1133),(9602,1134),(9603,1135),(9604,1136),(9605,1137),(9606,1138),(9607,1139),(9608,1140),(9609,1141),(9610,1142),(9611,1143),(9612,1144),(9613,1145),(9614,1146),(9615,1047),(9616,1047),(9617,1047),(9618,1048),(9619,1048),(9620,1048),(9621,1049),(9622,1049),(9623,1049),(9624,1050),(9625,1050),(9626,1050),(9627,1051),(9628,1051),(9629,1051),(9630,1052),(9631,1052),(9632,1052),(9633,1053),(9634,1053),(9635,1053),(9636,1054),(9637,1054),(9638,1054),(9639,1055),(9640,1055),(9641,1055),(9642,1056),(9643,1056),(9644,1056),(9645,1057),(9646,1057),(9647,1057),(9648,1058),(9649,1058),(9650,1058),(9651,1059),(9652,1059),(9653,1059),(9654,1060),(9655,1060),(9656,1060),(9657,1061),(9658,1062),(9659,1063),(9660,1064),(9661,1065),(9662,1066),(9663,1067),(9664,1068),(9665,1069),(9666,1070),(9667,1071),(9668,1072),(9669,1073),(9670,1074),(9671,1075),(9672,1076),(9673,1077),(9674,1078),(9675,1079),(9676,1080),(9677,1081),(9678,1082),(9679,1083),(9680,1084),(9681,1085),(9682,1086),(9683,1087),(9684,1088),(9685,1089),(9686,1090),(9687,1091),(9688,1092),(9689,1093),(9690,1094),(9691,1095),(9692,1096),(9693,1097),(9694,1098),(9695,1099),(9696,1100),(9697,1101),(9698,1102),(9699,1103),(9700,1104),(9701,1105),(9702,1106),(9703,1107),(9704,1108),(9705,1109),(9706,1110),(9707,1111),(9708,1112),(9709,1113),(9710,1114),(9711,1115),(9712,1115),(9713,1115),(9714,1115),(9715,1116),(9716,1116),(9717,1116),(9718,1116),(9719,1117),(9720,1117),(9721,1117),(9722,1117),(9723,1118),(9724,1118),(9725,1118),(9726,1118),(9727,1119),(9728,1119),(9729,1119),(9730,1119),(9731,1120),(9732,1120),(9733,1120),(9734,1120),(9735,1121),(9736,1121),(9737,1121),(9738,1121),(9739,1122),(9740,1122),(9741,1122),(9742,1122),(9743,1123),(9744,1123),(9745,1123),(9746,1123),(9747,1124),(9748,1124),(9749,1124),(9750,1124),(9751,1125),(9752,1125),(9753,1125),(9754,1125),(9755,1126),(9756,1126),(9757,1126),(9758,1126),(9759,1127),(9760,1127),(9761,1127),(9762,1127),(9763,1128),(9764,1128),(9765,1128),(9766,1128),(9767,1129),(9768,1129),(9769,1129),(9770,1129),(9771,1130),(9772,1130),(9773,1130),(9774,1130),(9775,1131),(9776,1131),(9777,1131),(9778,1131),(9779,1132),(9780,1132),(9781,1132),(9782,1132),(9783,1133),(9784,1133),(9785,1133),(9786,1133),(9787,1134),(9788,1134),(9789,1134),(9790,1134),(9791,1135),(9792,1135),(9793,1135),(9794,1135),(9795,1136),(9796,1136),(9797,1136),(9798,1136),(9799,1137),(9800,1137),(9801,1137),(9802,1137),(9803,1138),(9804,1138),(9805,1138),(9806,1138),(9807,1139),(9808,1139),(9809,1139),(9810,1139),(9811,1140),(9812,1140),(9813,1140),(9814,1140),(9815,1141),(9816,1141),(9817,1141),(9818,1141),(9819,1142),(9820,1142),(9821,1142),(9822,1142),(9823,1143),(9824,1143),(9825,1143),(9826,1143),(9827,1144),(9828,1144),(9829,1144),(9830,1144),(9831,1145),(9832,1145),(9833,1145),(9834,1145),(9835,1146),(9836,1146),(9837,1146),(9838,1146),(9839,1047),(9840,1047),(9841,1047),(9842,1047),(9843,1047),(9844,1047),(9845,1048),(9846,1048),(9847,1048),(9848,1048),(9849,1048),(9850,1048),(9851,1049),(9852,1049),(9853,1049),(9854,1049),(9855,1049),(9856,1049),(9857,1050),(9858,1050),(9859,1050),(9860,1050),(9861,1050),(9862,1050),(9863,1051),(9864,1051),(9865,1051),(9866,1051),(9867,1051),(9868,1051),(9869,1052),(9870,1052),(9871,1052),(9872,1052),(9873,1052),(9874,1052),(9875,1053),(9876,1053),(9877,1053),(9878,1053),(9879,1053),(9880,1053),(9881,1054),(9882,1054),(9883,1054),(9884,1054),(9885,1054),(9886,1054),(9887,1055),(9888,1055),(9889,1055),(9890,1055),(9891,1055),(9892,1055),(9893,1056),(9894,1056),(9895,1056),(9896,1056),(9897,1056),(9898,1056),(9899,1057),(9900,1057),(9901,1057),(9902,1057),(9903,1057),(9904,1057),(9905,1058),(9906,1058),(9907,1058),(9908,1058),(9909,1058),(9910,1058),(9911,1059),(9912,1059),(9913,1059),(9914,1059),(9915,1059),(9916,1059),(9917,1060),(9918,1060),(9919,1060),(9920,1060),(9921,1060),(9922,1060),(9923,1060),(9924,1060),(9925,1060),(9926,1061),(9927,1061),(9928,1061),(9929,1061),(9930,1061),(9931,1061),(9932,1062),(9933,1062),(9934,1062),(9935,1062),(9936,1062),(9937,1062),(9938,1063),(9939,1063),(9940,1063),(9941,1063),(9942,1063),(9943,1063),(9944,1064),(9945,1064),(9946,1064),(9947,1064),(9948,1064),(9949,1064),(9950,1065),(9951,1065),(9952,1065),(9953,1065),(9954,1065),(9955,1065),(9956,1066),(9957,1066),(9958,1066),(9959,1066),(9960,1066),(9961,1066),(9962,1067),(9963,1067),(9964,1067),(9965,1067),(9966,1067),(9967,1067),(9968,1068),(9969,1068),(9970,1068),(9971,1068),(9972,1068),(9973,1068),(9974,1069),(9975,1069),(9976,1069),(9977,1069),(9978,1069),(9979,1069),(9980,1070),(9981,1070),(9982,1070),(9983,1070),(9984,1070),(9985,1070),(9986,1071),(9987,1071),(9988,1071),(9989,1071),(9990,1071),(9991,1071),(9992,1072),(9993,1072),(9994,1072),(9995,1072),(9996,1072),(9997,1072),(9998,1073),(9999,1073),(10000,1073),(10001,1073),(10002,1073),(10003,1073),(10004,1074),(10005,1074),(10006,1074),(10007,1074),(10008,1074),(10009,1074),(10010,1075),(10011,1075),(10012,1075),(10013,1075),(10014,1075),(10015,1075),(10016,1076),(10017,1076),(10018,1076),(10019,1076),(10020,1076),(10021,1076),(10022,1076),(10023,1076),(10024,1076),(10025,1077),(10026,1077),(10027,1077),(10028,1077),(10029,1077),(10030,1077),(10031,1078),(10032,1078),(10033,1078),(10034,1078),(10035,1078),(10036,1078),(10037,1079),(10038,1079),(10039,1079),(10040,1079),(10041,1079),(10042,1079),(10043,1080),(10044,1080),(10045,1080),(10046,1080),(10047,1080),(10048,1080),(10049,1081),(10050,1081),(10051,1081),(10052,1081),(10053,1081),(10054,1081),(10055,1082),(10056,1082),(10057,1082),(10058,1082),(10059,1082),(10060,1082),(10061,1083),(10062,1083),(10063,1083),(10064,1083),(10065,1083),(10066,1083),(10067,1084),(10068,1084),(10069,1084),(10070,1084),(10071,1084),(10072,1084),(10073,1085),(10074,1085),(10075,1085),(10076,1085),(10077,1085),(10078,1085),(10079,1086),(10080,1086),(10081,1086),(10082,1086),(10083,1086),(10084,1086),(10085,1087),(10086,1087),(10087,1087),(10088,1087),(10089,1087),(10090,1087),(10091,1088),(10092,1088),(10093,1088),(10094,1088),(10095,1088),(10096,1088),(10097,1089),(10098,1089),(10099,1089),(10100,1089),(10101,1089),(10102,1089),(10103,1090),(10104,1090),(10105,1090),(10106,1090),(10107,1090),(10108,1090),(10109,1091),(10110,1091),(10111,1091),(10112,1091),(10113,1091),(10114,1091),(10115,1092),(10116,1092),(10117,1092),(10118,1092),(10119,1092),(10120,1092),(10121,1092),(10122,1092),(10123,1092),(10124,1093),(10125,1093),(10126,1093),(10127,1093),(10128,1093),(10129,1093),(10130,1094),(10131,1094),(10132,1094),(10133,1094),(10134,1094),(10135,1094),(10136,1095),(10137,1095),(10138,1095),(10139,1095),(10140,1095),(10141,1095),(10142,1096),(10143,1096),(10144,1096),(10145,1096),(10146,1096),(10147,1096),(10148,1097),(10149,1097),(10150,1097),(10151,1097),(10152,1097),(10153,1097),(10154,1098),(10155,1098),(10156,1098),(10157,1098),(10158,1098),(10159,1098),(10160,1099),(10161,1099),(10162,1099),(10163,1099),(10164,1099),(10165,1099),(10166,1100),(10167,1100),(10168,1100),(10169,1100),(10170,1100),(10171,1100),(10172,1101),(10173,1101),(10174,1101),(10175,1101),(10176,1101),(10177,1101),(10178,1102),(10179,1102),(10180,1102),(10181,1102),(10182,1102),(10183,1102),(10184,1103),(10185,1103),(10186,1103),(10187,1103),(10188,1103),(10189,1103),(10190,1104),(10191,1104),(10192,1104),(10193,1104),(10194,1104),(10195,1104),(10196,1105),(10197,1105),(10198,1105),(10199,1105),(10200,1105),(10201,1105),(10202,1106),(10203,1106),(10204,1106),(10205,1106),(10206,1106),(10207,1106),(10208,1107),(10209,1107),(10210,1107),(10211,1107),(10212,1107),(10213,1107),(10214,1108),(10215,1108),(10216,1108),(10217,1108),(10218,1108),(10219,1108),(10220,1108),(10221,1108),(10222,1108),(10223,1109),(10224,1109),(10225,1109),(10226,1109),(10227,1109),(10228,1109),(10229,1110),(10230,1110),(10231,1110),(10232,1110),(10233,1110),(10234,1110),(10235,1111),(10236,1111),(10237,1111),(10238,1111),(10239,1111),(10240,1111),(10241,1112),(10242,1112),(10243,1112),(10244,1112),(10245,1112),(10246,1112),(10247,1113),(10248,1113),(10249,1113),(10250,1113),(10251,1113),(10252,1113),(10253,1114),(10254,1114),(10255,1114),(10256,1114),(10257,1114),(10258,1114),(10259,1114),(10260,1114),(10261,1114),(10262,1115),(10263,1115),(10264,1115),(10265,1115),(10266,1115),(10267,1115),(10268,1116),(10269,1116),(10270,1116),(10271,1116),(10272,1116),(10273,1116),(10274,1117),(10275,1117),(10276,1117),(10277,1117),(10278,1117),(10279,1117),(10280,1118),(10281,1118),(10282,1118),(10283,1118),(10284,1118),(10285,1118),(10286,1119),(10287,1119),(10288,1119),(10289,1119),(10290,1119),(10291,1119),(10292,1120),(10293,1120),(10294,1120),(10295,1120),(10296,1120),(10297,1120),(10298,1121),(10299,1121),(10300,1121),(10301,1121),(10302,1121),(10303,1121),(10304,1122),(10305,1122),(10306,1122),(10307,1122),(10308,1122),(10309,1122),(10310,1123),(10311,1123),(10312,1123),(10313,1123),(10314,1123),(10315,1123),(10316,1124),(10317,1124),(10318,1124),(10319,1124),(10320,1124),(10321,1124),(10322,1125),(10323,1125),(10324,1125),(10325,1125),(10326,1125),(10327,1125),(10328,1126),(10329,1126),(10330,1126),(10331,1126),(10332,1126),(10333,1126),(10334,1127),(10335,1127),(10336,1127),(10337,1127),(10338,1127),(10339,1127),(10340,1128),(10341,1128),(10342,1128),(10343,1128),(10344,1128),(10345,1128),(10346,1129),(10347,1129),(10348,1129),(10349,1129),(10350,1129),(10351,1129),(10352,1130),(10353,1130),(10354,1130),(10355,1130),(10356,1130),(10357,1130),(10358,1130),(10359,1130),(10360,1130),(10361,1131),(10362,1131),(10363,1131),(10364,1131),(10365,1131),(10366,1131),(10367,1132),(10368,1132),(10369,1132),(10370,1132),(10371,1132),(10372,1132),(10373,1133),(10374,1133),(10375,1133),(10376,1133),(10377,1133),(10378,1133),(10379,1134),(10380,1134),(10381,1134),(10382,1134),(10383,1134),(10384,1134),(10385,1135),(10386,1135),(10387,1135),(10388,1135),(10389,1135),(10390,1135),(10391,1136),(10392,1136),(10393,1136),(10394,1136),(10395,1136),(10396,1136),(10397,1137),(10398,1137),(10399,1137),(10400,1137),(10401,1137),(10402,1137),(10403,1138),(10404,1138),(10405,1138),(10406,1138),(10407,1138),(10408,1138),(10409,1139),(10410,1139),(10411,1139),(10412,1139),(10413,1139),(10414,1139),(10415,1140),(10416,1140),(10417,1140),(10418,1140),(10419,1140),(10420,1140),(10421,1141),(10422,1141),(10423,1141),(10424,1141),(10425,1141),(10426,1141),(10427,1142),(10428,1142),(10429,1142),(10430,1142),(10431,1142),(10432,1142),(10433,1143),(10434,1143),(10435,1143),(10436,1143),(10437,1143),(10438,1143),(10439,1144),(10440,1144),(10441,1144),(10442,1144),(10443,1144),(10444,1144),(10445,1145),(10446,1145),(10447,1145),(10448,1145),(10449,1145),(10450,1145),(10451,1146),(10452,1146),(10453,1146),(10454,1146),(10455,1146),(10456,1146),(10457,1146),(10458,1146),(10459,1146),(10460,1147),(10461,1148),(10462,1149),(10463,1150),(10464,1151),(10465,1152),(10466,1153),(10467,1154),(10468,1155),(10469,1156),(10470,1157),(10471,1158),(10472,1159),(10473,1160),(10474,1161),(10475,1162),(10476,1163),(10477,1164),(10478,1165),(10479,1166),(10480,1167),(10481,1168),(10482,1169),(10483,1170),(10484,1171),(10485,1172),(10486,1173),(10487,1174),(10488,1175),(10489,1176),(10490,1177),(10491,1178),(10492,1179),(10493,1180),(10494,1181),(10495,1182),(10496,1183),(10497,1184),(10498,1185),(10499,1186),(10500,1187),(10501,1188),(10502,1189),(10503,1190),(10504,1191),(10505,1192),(10506,1193),(10507,1194),(10508,1195),(10509,1196),(10510,1197),(10511,1198),(10512,1199),(10513,1200),(10514,1201),(10515,1202),(10516,1203),(10517,1204),(10518,1205),(10519,1206),(10520,1207),(10521,1208),(10522,1209),(10523,1210),(10524,1211),(10525,1212),(10526,1213),(10527,1214),(10528,1215),(10529,1216),(10530,1217),(10531,1218),(10532,1219),(10533,1220),(10534,1221),(10535,1222),(10536,1223),(10537,1224),(10538,1225),(10539,1226),(10540,1227),(10541,1228),(10542,1229),(10543,1230),(10544,1231),(10545,1232),(10546,1233),(10547,1234),(10548,1235),(10549,1236),(10550,1237),(10551,1238),(10552,1239),(10553,1240),(10554,1241),(10555,1242),(10556,1243),(10557,1244),(10558,1245),(10559,1246),(10560,1147),(10561,1147),(10562,1147),(10563,1148),(10564,1148),(10565,1148),(10566,1149),(10567,1149),(10568,1149),(10569,1150),(10570,1150),(10571,1150),(10572,1151),(10573,1151),(10574,1151),(10575,1152),(10576,1152),(10577,1152),(10578,1153),(10579,1153),(10580,1153),(10581,1154),(10582,1154),(10583,1154),(10584,1155),(10585,1155),(10586,1155),(10587,1156),(10588,1156),(10589,1156),(10590,1157),(10591,1157),(10592,1157),(10593,1158),(10594,1158),(10595,1158),(10596,1159),(10597,1159),(10598,1159),(10599,1160),(10600,1160),(10601,1160),(10602,1161),(10603,1161),(10604,1161),(10605,1162),(10606,1162),(10607,1162),(10608,1163),(10609,1163),(10610,1163),(10611,1164),(10612,1164),(10613,1164),(10614,1165),(10615,1165),(10616,1165),(10617,1166),(10618,1166),(10619,1166),(10620,1167),(10621,1167),(10622,1167),(10623,1168),(10624,1168),(10625,1168),(10626,1169),(10627,1169),(10628,1169),(10629,1170),(10630,1170),(10631,1170),(10632,1171),(10633,1171),(10634,1171),(10635,1172),(10636,1172),(10637,1172),(10638,1173),(10639,1173),(10640,1173),(10641,1174),(10642,1174),(10643,1174),(10644,1175),(10645,1175),(10646,1175),(10647,1176),(10648,1176),(10649,1176),(10650,1177),(10651,1177),(10652,1177),(10653,1178),(10654,1178),(10655,1178),(10656,1179),(10657,1179),(10658,1179),(10659,1180),(10660,1180),(10661,1180),(10662,1181),(10663,1181),(10664,1181),(10665,1182),(10666,1182),(10667,1182),(10668,1183),(10669,1183),(10670,1183),(10671,1184),(10672,1184),(10673,1184),(10674,1185),(10675,1185),(10676,1185),(10677,1186),(10678,1186),(10679,1186),(10680,1187),(10681,1187),(10682,1187),(10683,1188),(10684,1188),(10685,1188),(10686,1189),(10687,1189),(10688,1189),(10689,1190),(10690,1190),(10691,1190),(10692,1191),(10693,1191),(10694,1191),(10695,1192),(10696,1192),(10697,1192),(10698,1193),(10699,1193),(10700,1193),(10701,1194),(10702,1194),(10703,1194),(10704,1195),(10705,1195),(10706,1195),(10707,1196),(10708,1196),(10709,1196),(10710,1197),(10711,1197),(10712,1197),(10713,1198),(10714,1198),(10715,1198),(10716,1199),(10717,1199),(10718,1199),(10719,1200),(10720,1200),(10721,1200),(10722,1201),(10723,1201),(10724,1201),(10725,1202),(10726,1202),(10727,1202),(10728,1203),(10729,1203),(10730,1203),(10731,1204),(10732,1204),(10733,1204),(10734,1205),(10735,1205),(10736,1205),(10737,1206),(10738,1206),(10739,1206),(10740,1207),(10741,1207),(10742,1207),(10743,1208),(10744,1208),(10745,1208),(10746,1209),(10747,1209),(10748,1209),(10749,1210),(10750,1210),(10751,1210),(10752,1211),(10753,1211),(10754,1211),(10755,1211),(10756,1212),(10757,1212),(10758,1212),(10759,1212),(10760,1213),(10761,1213),(10762,1213),(10763,1213),(10764,1214),(10765,1214),(10766,1214),(10767,1214),(10768,1215),(10769,1215),(10770,1215),(10771,1215),(10772,1216),(10773,1216),(10774,1216),(10775,1216),(10776,1217),(10777,1217),(10778,1217),(10779,1217),(10780,1218),(10781,1218),(10782,1218),(10783,1218),(10784,1219),(10785,1219),(10786,1219),(10787,1219),(10788,1220),(10789,1220),(10790,1220),(10791,1220),(10792,1221),(10793,1221),(10794,1221),(10795,1222),(10796,1222),(10797,1222),(10798,1223),(10799,1223),(10800,1223),(10801,1224),(10802,1224),(10803,1224),(10804,1225),(10805,1225),(10806,1225),(10807,1226),(10808,1226),(10809,1226),(10810,1227),(10811,1227),(10812,1227),(10813,1228),(10814,1228),(10815,1228),(10816,1229),(10817,1229),(10818,1229),(10819,1230),(10820,1230),(10821,1230),(10822,1231),(10823,1231),(10824,1231),(10825,1232),(10826,1232),(10827,1232),(10828,1233),(10829,1233),(10830,1233),(10831,1234),(10832,1234),(10833,1234),(10834,1235),(10835,1235),(10836,1235),(10837,1236),(10838,1236),(10839,1236),(10840,1237),(10841,1238),(10842,1239),(10843,1240),(10844,1241),(10845,1242),(10846,1243),(10847,1244),(10848,1245),(10849,1246),(10850,1147),(10851,1147),(10852,1147),(10853,1147),(10854,1147),(10855,1147),(10856,1148),(10857,1148),(10858,1148),(10859,1148),(10860,1148),(10861,1148),(10862,1149),(10863,1149),(10864,1149),(10865,1149),(10866,1149),(10867,1149),(10868,1150),(10869,1150),(10870,1150),(10871,1150),(10872,1150),(10873,1150),(10874,1151),(10875,1151),(10876,1151),(10877,1151),(10878,1151),(10879,1151),(10880,1152),(10881,1152),(10882,1152),(10883,1152),(10884,1152),(10885,1152),(10886,1153),(10887,1153),(10888,1153),(10889,1153),(10890,1153),(10891,1153),(10892,1154),(10893,1154),(10894,1154),(10895,1154),(10896,1154),(10897,1154),(10898,1155),(10899,1155),(10900,1155),(10901,1155),(10902,1155),(10903,1155),(10904,1156),(10905,1156),(10906,1156),(10907,1156),(10908,1156),(10909,1156),(10910,1157),(10911,1157),(10912,1157),(10913,1157),(10914,1157),(10915,1157),(10916,1158),(10917,1158),(10918,1158),(10919,1158),(10920,1158),(10921,1158),(10922,1159),(10923,1159),(10924,1159),(10925,1159),(10926,1159),(10927,1159),(10928,1160),(10929,1160),(10930,1160),(10931,1160),(10932,1160),(10933,1160),(10934,1161),(10935,1161),(10936,1161),(10937,1161),(10938,1161),(10939,1161),(10940,1162),(10941,1162),(10942,1162),(10943,1162),(10944,1162),(10945,1162),(10946,1162),(10947,1162),(10948,1162),(10949,1163),(10950,1163),(10951,1163),(10952,1163),(10953,1163),(10954,1163),(10955,1164),(10956,1164),(10957,1164),(10958,1164),(10959,1164),(10960,1164),(10961,1165),(10962,1165),(10963,1165),(10964,1165),(10965,1165),(10966,1165),(10967,1166),(10968,1166),(10969,1166),(10970,1166),(10971,1166),(10972,1166),(10973,1167),(10974,1167),(10975,1167),(10976,1167),(10977,1167),(10978,1167),(10979,1168),(10980,1168),(10981,1168),(10982,1168),(10983,1168),(10984,1168),(10985,1169),(10986,1169),(10987,1169),(10988,1169),(10989,1169),(10990,1169),(10991,1170),(10992,1170),(10993,1170),(10994,1170),(10995,1170),(10996,1170),(10997,1171),(10998,1171),(10999,1171),(11000,1171),(11001,1171),(11002,1171),(11003,1172),(11004,1172),(11005,1172),(11006,1172),(11007,1172),(11008,1172),(11009,1173),(11010,1173),(11011,1173),(11012,1173),(11013,1173),(11014,1173),(11015,1174),(11016,1174),(11017,1174),(11018,1174),(11019,1174),(11020,1174),(11021,1175),(11022,1175),(11023,1175),(11024,1175),(11025,1175),(11026,1175),(11027,1176),(11028,1176),(11029,1176),(11030,1176),(11031,1176),(11032,1176),(11033,1177),(11034,1177),(11035,1177),(11036,1177),(11037,1177),(11038,1177),(11039,1178),(11040,1178),(11041,1178),(11042,1178),(11043,1178),(11044,1178),(11045,1178),(11046,1178),(11047,1178),(11048,1179),(11049,1179),(11050,1179),(11051,1179),(11052,1179),(11053,1179),(11054,1180),(11055,1180),(11056,1180),(11057,1180),(11058,1180),(11059,1180),(11060,1181),(11061,1181),(11062,1181),(11063,1181),(11064,1181),(11065,1181),(11066,1182),(11067,1182),(11068,1182),(11069,1182),(11070,1182),(11071,1182),(11072,1183),(11073,1183),(11074,1183),(11075,1183),(11076,1183),(11077,1183),(11078,1184),(11079,1184),(11080,1184),(11081,1184),(11082,1184),(11083,1184),(11084,1185),(11085,1185),(11086,1185),(11087,1185),(11088,1185),(11089,1185),(11090,1186),(11091,1186),(11092,1186),(11093,1186),(11094,1186),(11095,1186),(11096,1187),(11097,1187),(11098,1187),(11099,1187),(11100,1187),(11101,1187),(11102,1188),(11103,1188),(11104,1188),(11105,1188),(11106,1188),(11107,1188),(11108,1189),(11109,1189),(11110,1189),(11111,1189),(11112,1189),(11113,1189),(11114,1190),(11115,1190),(11116,1190),(11117,1190),(11118,1190),(11119,1190),(11120,1191),(11121,1191),(11122,1191),(11123,1191),(11124,1191),(11125,1191),(11126,1192),(11127,1192),(11128,1192),(11129,1192),(11130,1192),(11131,1192),(11132,1193),(11133,1193),(11134,1193),(11135,1193),(11136,1193),(11137,1193),(11138,1194),(11139,1194),(11140,1194),(11141,1194),(11142,1194),(11143,1194),(11144,1194),(11145,1194),(11146,1194),(11147,1195),(11148,1195),(11149,1195),(11150,1195),(11151,1195),(11152,1195),(11153,1196),(11154,1196),(11155,1196),(11156,1196),(11157,1196),(11158,1196),(11159,1197),(11160,1197),(11161,1197),(11162,1197),(11163,1197),(11164,1197),(11165,1198),(11166,1198),(11167,1198),(11168,1198),(11169,1198),(11170,1198),(11171,1199),(11172,1199),(11173,1199),(11174,1199),(11175,1199),(11176,1199),(11177,1200),(11178,1200),(11179,1200),(11180,1200),(11181,1200),(11182,1200),(11183,1201),(11184,1201),(11185,1201),(11186,1201),(11187,1201),(11188,1201),(11189,1202),(11190,1202),(11191,1202),(11192,1202),(11193,1202),(11194,1202),(11195,1203),(11196,1203),(11197,1203),(11198,1203),(11199,1203),(11200,1203),(11201,1204),(11202,1204),(11203,1204),(11204,1204),(11205,1204),(11206,1204),(11207,1205),(11208,1205),(11209,1205),(11210,1205),(11211,1205),(11212,1205),(11213,1206),(11214,1206),(11215,1206),(11216,1206),(11217,1206),(11218,1206),(11219,1207),(11220,1207),(11221,1207),(11222,1207),(11223,1207),(11224,1207),(11225,1208),(11226,1208),(11227,1208),(11228,1208),(11229,1208),(11230,1208),(11231,1209),(11232,1209),(11233,1209),(11234,1209),(11235,1209),(11236,1209),(11237,1210),(11238,1210),(11239,1210),(11240,1210),(11241,1210),(11242,1210),(11243,1210),(11244,1210),(11245,1210),(11246,1211),(11247,1211),(11248,1211),(11249,1211),(11250,1211),(11251,1211),(11252,1212),(11253,1212),(11254,1212),(11255,1212),(11256,1212),(11257,1212),(11258,1213),(11259,1213),(11260,1213),(11261,1213),(11262,1213),(11263,1213),(11264,1214),(11265,1214),(11266,1214),(11267,1214),(11268,1214),(11269,1214),(11270,1215),(11271,1215),(11272,1215),(11273,1215),(11274,1215),(11275,1215),(11276,1216),(11277,1216),(11278,1216),(11279,1216),(11280,1216),(11281,1216),(11282,1217),(11283,1217),(11284,1217),(11285,1217),(11286,1217),(11287,1217),(11288,1218),(11289,1218),(11290,1218),(11291,1218),(11292,1218),(11293,1218),(11294,1219),(11295,1219),(11296,1219),(11297,1219),(11298,1219),(11299,1219),(11300,1220),(11301,1220),(11302,1220),(11303,1220),(11304,1220),(11305,1220),(11306,1220),(11307,1220),(11308,1220),(11309,1221),(11310,1221),(11311,1221),(11312,1221),(11313,1221),(11314,1221),(11315,1222),(11316,1222),(11317,1222),(11318,1222),(11319,1222),(11320,1222),(11321,1223),(11322,1223),(11323,1223),(11324,1223),(11325,1223),(11326,1223),(11327,1224),(11328,1224),(11329,1224),(11330,1224),(11331,1224),(11332,1224),(11333,1225),(11334,1225),(11335,1225),(11336,1225),(11337,1225),(11338,1225),(11339,1226),(11340,1226),(11341,1226),(11342,1226),(11343,1226),(11344,1226),(11345,1227),(11346,1227),(11347,1227),(11348,1227),(11349,1227),(11350,1227),(11351,1228),(11352,1228),(11353,1228),(11354,1228),(11355,1228),(11356,1228),(11357,1229),(11358,1229),(11359,1229),(11360,1229),(11361,1229),(11362,1229),(11363,1230),(11364,1230),(11365,1230),(11366,1230),(11367,1230),(11368,1230),(11369,1231),(11370,1231),(11371,1231),(11372,1231),(11373,1231),(11374,1231),(11375,1232),(11376,1232),(11377,1232),(11378,1232),(11379,1232),(11380,1232),(11381,1233),(11382,1233),(11383,1233),(11384,1233),(11385,1233),(11386,1233),(11387,1234),(11388,1234),(11389,1234),(11390,1234),(11391,1234),(11392,1234),(11393,1235),(11394,1235),(11395,1235),(11396,1235),(11397,1235),(11398,1235),(11399,1236),(11400,1236),(11401,1236),(11402,1236),(11403,1236),(11404,1236),(11405,1236),(11406,1236),(11407,1236),(11408,1237),(11409,1237),(11410,1237),(11411,1237),(11412,1237),(11413,1237),(11414,1238),(11415,1238),(11416,1238),(11417,1238),(11418,1238),(11419,1238),(11420,1239),(11421,1239),(11422,1239),(11423,1239),(11424,1239),(11425,1239),(11426,1240),(11427,1240),(11428,1240),(11429,1240),(11430,1240),(11431,1240),(11432,1241),(11433,1241),(11434,1241),(11435,1241),(11436,1241),(11437,1241),(11438,1242),(11439,1242),(11440,1242),(11441,1242),(11442,1242),(11443,1242),(11444,1243),(11445,1243),(11446,1243),(11447,1243),(11448,1243),(11449,1243),(11450,1244),(11451,1244),(11452,1244),(11453,1244),(11454,1244),(11455,1244),(11456,1245),(11457,1245),(11458,1245),(11459,1245),(11460,1245),(11461,1245),(11462,1246),(11463,1246),(11464,1246),(11465,1246),(11466,1246),(11467,1246),(11468,1247),(11469,1248),(11470,1249),(11471,1250),(11472,1251),(11473,1252),(11474,1253),(11475,1254),(11476,1255),(11477,1256),(11478,1257),(11479,1258),(11480,1259),(11481,1260),(11482,1261),(11483,1262),(11484,1263),(11485,1264),(11486,1265),(11487,1266),(11488,1267),(11489,1268),(11490,1269),(11491,1270),(11492,1271),(11493,1272),(11494,1273),(11495,1274),(11496,1275),(11497,1276),(11498,1277),(11499,1278),(11500,1279),(11501,1280),(11502,1281),(11503,1282),(11504,1283),(11505,1284),(11506,1285),(11507,1286),(11508,1287),(11509,1288),(11510,1289),(11511,1290),(11512,1291),(11513,1292),(11514,1293),(11515,1294),(11516,1295),(11517,1296),(11518,1297),(11519,1298),(11520,1299),(11521,1300),(11522,1301),(11523,1302),(11524,1303),(11525,1304),(11526,1305),(11527,1306),(11528,1307),(11529,1308),(11530,1309),(11531,1310),(11532,1311),(11533,1312),(11534,1313),(11535,1314),(11536,1315),(11537,1316),(11538,1317),(11539,1318),(11540,1319),(11541,1320),(11542,1321),(11543,1322),(11544,1323),(11545,1324),(11546,1325),(11547,1326),(11548,1327),(11549,1328),(11550,1329),(11551,1330),(11552,1331),(11553,1332),(11554,1333),(11555,1334),(11556,1335),(11557,1336),(11558,1337),(11559,1338),(11560,1339),(11561,1340),(11562,1341),(11563,1342),(11564,1343),(11565,1344),(11566,1345),(11567,1346),(11568,1247),(11569,1248),(11570,1249),(11571,1250),(11572,1251),(11573,1252),(11574,1253),(11575,1253),(11576,1253),(11577,1253),(11578,1254),(11579,1254),(11580,1254),(11581,1254),(11582,1255),(11583,1255),(11584,1255),(11585,1255),(11586,1256),(11587,1256),(11588,1256),(11589,1256),(11590,1257),(11591,1257),(11592,1257),(11593,1257),(11594,1258),(11595,1258),(11596,1258),(11597,1258),(11598,1259),(11599,1259),(11600,1259),(11601,1259),(11602,1260),(11603,1260),(11604,1260),(11605,1260),(11606,1261),(11607,1261),(11608,1261),(11609,1261),(11610,1262),(11611,1262),(11612,1262),(11613,1262),(11614,1263),(11615,1263),(11616,1263),(11617,1263),(11618,1264),(11619,1264),(11620,1264),(11621,1264),(11622,1265),(11623,1265),(11624,1265),(11625,1265),(11626,1266),(11627,1266),(11628,1266),(11629,1266),(11630,1267),(11631,1267),(11632,1267),(11633,1267),(11634,1268),(11635,1268),(11636,1268),(11637,1268),(11638,1269),(11639,1270),(11640,1271),(11641,1272),(11642,1273),(11643,1274),(11644,1275),(11645,1276),(11646,1277),(11647,1278),(11648,1279),(11649,1280),(11650,1281),(11651,1282),(11652,1283),(11653,1284),(11654,1285),(11655,1286),(11656,1287),(11657,1288),(11658,1289),(11659,1290),(11660,1291),(11661,1292),(11662,1293),(11663,1294),(11664,1295),(11665,1296),(11666,1297),(11667,1298),(11668,1299),(11669,1300),(11670,1301),(11671,1301),(11672,1301),(11673,1301),(11674,1302),(11675,1302),(11676,1302),(11677,1302),(11678,1303),(11679,1303),(11680,1303),(11681,1303),(11682,1304),(11683,1304),(11684,1304),(11685,1304),(11686,1305),(11687,1305),(11688,1305),(11689,1305),(11690,1306),(11691,1306),(11692,1306),(11693,1306),(11694,1307),(11695,1307),(11696,1307),(11697,1307),(11698,1308),(11699,1308),(11700,1308),(11701,1308),(11702,1309),(11703,1309),(11704,1309),(11705,1309),(11706,1310),(11707,1310),(11708,1310),(11709,1310),(11710,1311),(11711,1311),(11712,1311),(11713,1311),(11714,1312),(11715,1312),(11716,1312),(11717,1312),(11718,1313),(11719,1313),(11720,1313),(11721,1313),(11722,1314),(11723,1314),(11724,1314),(11725,1314),(11726,1315),(11727,1315),(11728,1315),(11729,1315),(11730,1316),(11731,1316),(11732,1316),(11733,1316),(11734,1317),(11735,1317),(11736,1317),(11737,1318),(11738,1318),(11739,1318),(11740,1319),(11741,1319),(11742,1319),(11743,1320),(11744,1320),(11745,1320),(11746,1321),(11747,1321),(11748,1321),(11749,1322),(11750,1322),(11751,1322),(11752,1323),(11753,1323),(11754,1323),(11755,1324),(11756,1324),(11757,1324),(11758,1325),(11759,1325),(11760,1325),(11761,1326),(11762,1326),(11763,1326),(11764,1327),(11765,1327),(11766,1327),(11767,1328),(11768,1328),(11769,1328),(11770,1329),(11771,1329),(11772,1329),(11773,1330),(11774,1330),(11775,1330),(11776,1331),(11777,1331),(11778,1331),(11779,1332),(11780,1332),(11781,1332),(11782,1333),(11783,1333),(11784,1333),(11785,1333),(11786,1334),(11787,1334),(11788,1334),(11789,1334),(11790,1335),(11791,1335),(11792,1335),(11793,1335),(11794,1336),(11795,1336),(11796,1336),(11797,1336),(11798,1337),(11799,1337),(11800,1337),(11801,1337),(11802,1338),(11803,1338),(11804,1338),(11805,1338),(11806,1339),(11807,1339),(11808,1339),(11809,1339),(11810,1340),(11811,1340),(11812,1340),(11813,1340),(11814,1341),(11815,1341),(11816,1341),(11817,1341),(11818,1342),(11819,1342),(11820,1342),(11821,1342),(11822,1343),(11823,1343),(11824,1343),(11825,1343),(11826,1344),(11827,1344),(11828,1344),(11829,1344),(11830,1345),(11831,1345),(11832,1345),(11833,1345),(11834,1346),(11835,1346),(11836,1346),(11837,1346),(11838,1247),(11839,1247),(11840,1247),(11841,1247),(11842,1247),(11843,1247),(11844,1248),(11845,1248),(11846,1248),(11847,1248),(11848,1248),(11849,1248),(11850,1249),(11851,1249),(11852,1249),(11853,1249),(11854,1249),(11855,1249),(11856,1250),(11857,1250),(11858,1250),(11859,1250),(11860,1250),(11861,1250),(11862,1251),(11863,1251),(11864,1251),(11865,1251),(11866,1251),(11867,1251),(11868,1252),(11869,1252),(11870,1252),(11871,1252),(11872,1252),(11873,1252),(11874,1252),(11875,1252),(11876,1252),(11877,1253),(11878,1253),(11879,1253),(11880,1253),(11881,1253),(11882,1253),(11883,1254),(11884,1254),(11885,1254),(11886,1254),(11887,1254),(11888,1254),(11889,1255),(11890,1255),(11891,1255),(11892,1255),(11893,1255),(11894,1255),(11895,1256),(11896,1256),(11897,1256),(11898,1256),(11899,1256),(11900,1256),(11901,1257),(11902,1257),(11903,1257),(11904,1257),(11905,1257),(11906,1257),(11907,1258),(11908,1258),(11909,1258),(11910,1258),(11911,1258),(11912,1258),(11913,1259),(11914,1259),(11915,1259),(11916,1259),(11917,1259),(11918,1259),(11919,1260),(11920,1260),(11921,1260),(11922,1260),(11923,1260),(11924,1260),(11925,1261),(11926,1261),(11927,1261),(11928,1261),(11929,1261),(11930,1261),(11931,1262),(11932,1262),(11933,1262),(11934,1262),(11935,1262),(11936,1262),(11937,1263),(11938,1263),(11939,1263),(11940,1263),(11941,1263),(11942,1263),(11943,1264),(11944,1264),(11945,1264),(11946,1264),(11947,1264),(11948,1264),(11949,1265),(11950,1265),(11951,1265),(11952,1265),(11953,1265),(11954,1265),(11955,1266),(11956,1266),(11957,1266),(11958,1266),(11959,1266),(11960,1266),(11961,1267),(11962,1267),(11963,1267),(11964,1267),(11965,1267),(11966,1267),(11967,1268),(11968,1268),(11969,1268),(11970,1268),(11971,1268),(11972,1268),(11973,1268),(11974,1268),(11975,1268),(11976,1269),(11977,1269),(11978,1269),(11979,1269),(11980,1269),(11981,1269),(11982,1270),(11983,1270),(11984,1270),(11985,1270),(11986,1270),(11987,1270),(11988,1271),(11989,1271),(11990,1271),(11991,1271),(11992,1271),(11993,1271),(11994,1272),(11995,1272),(11996,1272),(11997,1272),(11998,1272),(11999,1272),(12000,1273),(12001,1273),(12002,1273),(12003,1273),(12004,1273),(12005,1273),(12006,1274),(12007,1274),(12008,1274),(12009,1274),(12010,1274),(12011,1274),(12012,1275),(12013,1275),(12014,1275),(12015,1275),(12016,1275),(12017,1275),(12018,1276),(12019,1276),(12020,1276),(12021,1276),(12022,1276),(12023,1276),(12024,1277),(12025,1277),(12026,1277),(12027,1277),(12028,1277),(12029,1277),(12030,1278),(12031,1278),(12032,1278),(12033,1278),(12034,1278),(12035,1278),(12036,1279),(12037,1279),(12038,1279),(12039,1279),(12040,1279),(12041,1279),(12042,1280),(12043,1280),(12044,1280),(12045,1280),(12046,1280),(12047,1280),(12048,1281),(12049,1281),(12050,1281),(12051,1281),(12052,1281),(12053,1281),(12054,1282),(12055,1282),(12056,1282),(12057,1282),(12058,1282),(12059,1282),(12060,1283),(12061,1283),(12062,1283),(12063,1283),(12064,1283),(12065,1283),(12066,1284),(12067,1284),(12068,1284),(12069,1284),(12070,1284),(12071,1284),(12072,1284),(12073,1284),(12074,1284),(12075,1285),(12076,1285),(12077,1285),(12078,1285),(12079,1285),(12080,1285),(12081,1286),(12082,1286),(12083,1286),(12084,1286),(12085,1286),(12086,1286),(12087,1287),(12088,1287),(12089,1287),(12090,1287),(12091,1287),(12092,1287),(12093,1288),(12094,1288),(12095,1288),(12096,1288),(12097,1288),(12098,1288),(12099,1289),(12100,1289),(12101,1289),(12102,1289),(12103,1289),(12104,1289),(12105,1290),(12106,1290),(12107,1290),(12108,1290),(12109,1290),(12110,1290),(12111,1291),(12112,1291),(12113,1291),(12114,1291),(12115,1291),(12116,1291),(12117,1292),(12118,1292),(12119,1292),(12120,1292),(12121,1292),(12122,1292),(12123,1293),(12124,1293),(12125,1293),(12126,1293),(12127,1293),(12128,1293),(12129,1294),(12130,1294),(12131,1294),(12132,1294),(12133,1294),(12134,1294),(12135,1295),(12136,1295),(12137,1295),(12138,1295),(12139,1295),(12140,1295),(12141,1296),(12142,1296),(12143,1296),(12144,1296),(12145,1296),(12146,1296),(12147,1297),(12148,1297),(12149,1297),(12150,1297),(12151,1297),(12152,1297),(12153,1298),(12154,1298),(12155,1298),(12156,1298),(12157,1298),(12158,1298),(12159,1299),(12160,1299),(12161,1299),(12162,1299),(12163,1299),(12164,1299),(12165,1300),(12166,1300),(12167,1300),(12168,1300),(12169,1300),(12170,1300),(12171,1300),(12172,1300),(12173,1300),(12174,1301),(12175,1301),(12176,1301),(12177,1301),(12178,1301),(12179,1301),(12180,1302),(12181,1302),(12182,1302),(12183,1302),(12184,1302),(12185,1302),(12186,1303),(12187,1303),(12188,1303),(12189,1303),(12190,1303),(12191,1303),(12192,1304),(12193,1304),(12194,1304),(12195,1304),(12196,1304),(12197,1304),(12198,1305),(12199,1305),(12200,1305),(12201,1305),(12202,1305),(12203,1305),(12204,1306),(12205,1306),(12206,1306),(12207,1306),(12208,1306),(12209,1306),(12210,1307),(12211,1307),(12212,1307),(12213,1307),(12214,1307),(12215,1307),(12216,1308),(12217,1308),(12218,1308),(12219,1308),(12220,1308),(12221,1308),(12222,1309),(12223,1309),(12224,1309),(12225,1309),(12226,1309),(12227,1309),(12228,1310),(12229,1310),(12230,1310),(12231,1310),(12232,1310),(12233,1310),(12234,1311),(12235,1311),(12236,1311),(12237,1311),(12238,1311),(12239,1311),(12240,1312),(12241,1312),(12242,1312),(12243,1312),(12244,1312),(12245,1312),(12246,1313),(12247,1313),(12248,1313),(12249,1313),(12250,1313),(12251,1313),(12252,1314),(12253,1314),(12254,1314),(12255,1314),(12256,1314),(12257,1314),(12258,1315),(12259,1315),(12260,1315),(12261,1315),(12262,1315),(12263,1315),(12264,1316),(12265,1316),(12266,1316),(12267,1316),(12268,1316),(12269,1316),(12270,1316),(12271,1316),(12272,1316),(12273,1317),(12274,1317),(12275,1317),(12276,1317),(12277,1317),(12278,1317),(12279,1318),(12280,1318),(12281,1318),(12282,1318),(12283,1318),(12284,1318),(12285,1319),(12286,1319),(12287,1319),(12288,1319),(12289,1319),(12290,1319),(12291,1320),(12292,1320),(12293,1320),(12294,1320),(12295,1320),(12296,1320),(12297,1321),(12298,1321),(12299,1321),(12300,1321),(12301,1321),(12302,1321),(12303,1322),(12304,1322),(12305,1322),(12306,1322),(12307,1322),(12308,1322),(12309,1323),(12310,1323),(12311,1323),(12312,1323),(12313,1323),(12314,1323),(12315,1324),(12316,1324),(12317,1324),(12318,1324),(12319,1324),(12320,1324),(12321,1325),(12322,1325),(12323,1325),(12324,1325),(12325,1325),(12326,1325),(12327,1326),(12328,1326),(12329,1326),(12330,1326),(12331,1326),(12332,1326),(12333,1327),(12334,1327),(12335,1327),(12336,1327),(12337,1327),(12338,1327),(12339,1328),(12340,1328),(12341,1328),(12342,1328),(12343,1328),(12344,1328),(12345,1329),(12346,1329),(12347,1329),(12348,1329),(12349,1329),(12350,1329),(12351,1330),(12352,1330),(12353,1330),(12354,1330),(12355,1330),(12356,1330),(12357,1331),(12358,1331),(12359,1331),(12360,1331),(12361,1331),(12362,1331),(12363,1332),(12364,1332),(12365,1332),(12366,1332),(12367,1332),(12368,1332),(12369,1332),(12370,1332),(12371,1332),(12372,1333),(12373,1333),(12374,1333),(12375,1333),(12376,1333),(12377,1333),(12378,1334),(12379,1334),(12380,1334),(12381,1334),(12382,1334),(12383,1334),(12384,1335),(12385,1335),(12386,1335),(12387,1335),(12388,1335),(12389,1335),(12390,1336),(12391,1336),(12392,1336),(12393,1336),(12394,1336),(12395,1336),(12396,1337),(12397,1337),(12398,1337),(12399,1337),(12400,1337),(12401,1337),(12402,1338),(12403,1338),(12404,1338),(12405,1338),(12406,1338),(12407,1338),(12408,1339),(12409,1339),(12410,1339),(12411,1339),(12412,1339),(12413,1339),(12414,1340),(12415,1340),(12416,1340),(12417,1340),(12418,1340),(12419,1340),(12420,1341),(12421,1341),(12422,1341),(12423,1341),(12424,1341),(12425,1341),(12426,1342),(12427,1342),(12428,1342),(12429,1342),(12430,1342),(12431,1342),(12432,1343),(12433,1343),(12434,1343),(12435,1343),(12436,1343),(12437,1343),(12438,1344),(12439,1344),(12440,1344),(12441,1344),(12442,1344),(12443,1344),(12444,1345),(12445,1345),(12446,1345),(12447,1345),(12448,1345),(12449,1345),(12450,1346),(12451,1346),(12452,1346),(12453,1346),(12454,1346),(12455,1346),(12456,1347),(12457,1348),(12458,1349),(12459,1350),(12460,1351),(12461,1352),(12462,1353),(12463,1354),(12464,1355),(12465,1356),(12466,1357),(12467,1358),(12468,1359),(12469,1360),(12470,1361),(12471,1362),(12472,1363),(12473,1364),(12474,1365),(12475,1366),(12476,1367),(12477,1368),(12478,1369),(12479,1370),(12480,1371),(12481,1372),(12482,1373),(12483,1374),(12484,1375),(12485,1376),(12486,1377),(12487,1378),(12488,1379),(12489,1380),(12490,1381),(12491,1382),(12492,1383),(12493,1384),(12494,1385),(12495,1386),(12496,1387),(12497,1388),(12498,1389),(12499,1390),(12500,1391),(12501,1392),(12502,1393),(12503,1394),(12504,1395),(12505,1396),(12506,1397),(12507,1398),(12508,1399),(12509,1400),(12510,1401),(12511,1402),(12512,1403),(12513,1404),(12514,1405),(12515,1406),(12516,1407),(12517,1408),(12518,1409),(12519,1410),(12520,1411),(12521,1412),(12522,1413),(12523,1414),(12524,1415),(12525,1416),(12526,1417),(12527,1418),(12528,1419),(12529,1420),(12530,1421),(12531,1422),(12532,1423),(12533,1424),(12534,1425),(12535,1426),(12536,1427),(12537,1428),(12538,1429),(12539,1430),(12540,1431),(12541,1432),(12542,1433),(12543,1434),(12544,1435),(12545,1436),(12546,1437),(12547,1438),(12548,1439),(12549,1440),(12550,1441),(12551,1442),(12552,1443),(12553,1444),(12554,1445),(12555,1446),(12556,1347),(12557,1347),(12558,1347),(12559,1347),(12560,1348),(12561,1348),(12562,1348),(12563,1348),(12564,1349),(12565,1349),(12566,1349),(12567,1350),(12568,1350),(12569,1350),(12570,1351),(12571,1351),(12572,1351),(12573,1352),(12574,1352),(12575,1352),(12576,1353),(12577,1353),(12578,1353),(12579,1354),(12580,1354),(12581,1354),(12582,1355),(12583,1355),(12584,1355),(12585,1356),(12586,1356),(12587,1356),(12588,1357),(12589,1357),(12590,1357),(12591,1358),(12592,1358),(12593,1358),(12594,1359),(12595,1359),(12596,1359),(12597,1360),(12598,1360),(12599,1360),(12600,1361),(12601,1361),(12602,1361),(12603,1362),(12604,1362),(12605,1362),(12606,1363),(12607,1363),(12608,1363),(12609,1364),(12610,1364),(12611,1364),(12612,1365),(12613,1365),(12614,1365),(12615,1365),(12616,1366),(12617,1366),(12618,1366),(12619,1366),(12620,1367),(12621,1367),(12622,1367),(12623,1367),(12624,1368),(12625,1368),(12626,1368),(12627,1368),(12628,1369),(12629,1369),(12630,1369),(12631,1369),(12632,1370),(12633,1370),(12634,1370),(12635,1370),(12636,1371),(12637,1371),(12638,1371),(12639,1371),(12640,1372),(12641,1372),(12642,1372),(12643,1372),(12644,1373),(12645,1373),(12646,1373),(12647,1373),(12648,1374),(12649,1374),(12650,1374),(12651,1374),(12652,1375),(12653,1375),(12654,1375),(12655,1375),(12656,1376),(12657,1376),(12658,1376),(12659,1376),(12660,1377),(12661,1377),(12662,1377),(12663,1377),(12664,1378),(12665,1378),(12666,1378),(12667,1378),(12668,1379),(12669,1379),(12670,1379),(12671,1379),(12672,1380),(12673,1380),(12674,1380),(12675,1380),(12676,1381),(12677,1381),(12678,1381),(12679,1381),(12680,1382),(12681,1382),(12682,1382),(12683,1382),(12684,1383),(12685,1383),(12686,1383),(12687,1383),(12688,1384),(12689,1384),(12690,1384),(12691,1384),(12692,1385),(12693,1385),(12694,1385),(12695,1385),(12696,1386),(12697,1386),(12698,1386),(12699,1386),(12700,1387),(12701,1387),(12702,1387),(12703,1387),(12704,1388),(12705,1388),(12706,1388),(12707,1388),(12708,1389),(12709,1389),(12710,1389),(12711,1389),(12712,1390),(12713,1390),(12714,1390),(12715,1390),(12716,1391),(12717,1391),(12718,1391),(12719,1391),(12720,1392),(12721,1392),(12722,1392),(12723,1392),(12724,1393),(12725,1393),(12726,1393),(12727,1393),(12728,1394),(12729,1394),(12730,1394),(12731,1394),(12732,1395),(12733,1395),(12734,1395),(12735,1395),(12736,1396),(12737,1396),(12738,1396),(12739,1396),(12740,1397),(12741,1397),(12742,1397),(12743,1397),(12744,1398),(12745,1398),(12746,1398),(12747,1398),(12748,1399),(12749,1399),(12750,1399),(12751,1399),(12752,1400),(12753,1400),(12754,1400),(12755,1400),(12756,1401),(12757,1401),(12758,1401),(12759,1401),(12760,1402),(12761,1402),(12762,1402),(12763,1402),(12764,1403),(12765,1403),(12766,1403),(12767,1403),(12768,1404),(12769,1404),(12770,1404),(12771,1404),(12772,1405),(12773,1405),(12774,1405),(12775,1405),(12776,1406),(12777,1406),(12778,1406),(12779,1406),(12780,1407),(12781,1407),(12782,1407),(12783,1407),(12784,1408),(12785,1408),(12786,1408),(12787,1408),(12788,1409),(12789,1409),(12790,1409),(12791,1409),(12792,1410),(12793,1410),(12794,1410),(12795,1410),(12796,1411),(12797,1411),(12798,1411),(12799,1411),(12800,1412),(12801,1412),(12802,1412),(12803,1412),(12804,1413),(12805,1413),(12806,1413),(12807,1413),(12808,1414),(12809,1414),(12810,1414),(12811,1414),(12812,1415),(12813,1415),(12814,1415),(12815,1415),(12816,1416),(12817,1416),(12818,1416),(12819,1416),(12820,1417),(12821,1417),(12822,1417),(12823,1417),(12824,1418),(12825,1418),(12826,1418),(12827,1418),(12828,1419),(12829,1419),(12830,1419),(12831,1419),(12832,1420),(12833,1420),(12834,1420),(12835,1420),(12836,1421),(12837,1421),(12838,1421),(12839,1421),(12840,1422),(12841,1422),(12842,1422),(12843,1422),(12844,1423),(12845,1423),(12846,1423),(12847,1423),(12848,1424),(12849,1424),(12850,1424),(12851,1424),(12852,1425),(12853,1425),(12854,1425),(12855,1425),(12856,1426),(12857,1426),(12858,1426),(12859,1426),(12860,1427),(12861,1427),(12862,1427),(12863,1427),(12864,1428),(12865,1428),(12866,1428),(12867,1428),(12868,1429),(12869,1429),(12870,1429),(12871,1429),(12872,1429),(12873,1430),(12874,1430),(12875,1430),(12876,1430),(12877,1430),(12878,1431),(12879,1431),(12880,1431),(12881,1431),(12882,1431),(12883,1432),(12884,1432),(12885,1432),(12886,1432),(12887,1432),(12888,1433),(12889,1433),(12890,1433),(12891,1433),(12892,1433),(12893,1434),(12894,1434),(12895,1434),(12896,1434),(12897,1434),(12898,1435),(12899,1435),(12900,1435),(12901,1435),(12902,1435),(12903,1436),(12904,1436),(12905,1436),(12906,1436),(12907,1436),(12908,1437),(12909,1437),(12910,1437),(12911,1437),(12912,1437),(12913,1438),(12914,1438),(12915,1438),(12916,1438),(12917,1438),(12918,1439),(12919,1439),(12920,1439),(12921,1439),(12922,1439),(12923,1440),(12924,1440),(12925,1440),(12926,1440),(12927,1440),(12928,1441),(12929,1441),(12930,1441),(12931,1441),(12932,1441),(12933,1442),(12934,1442),(12935,1442),(12936,1442),(12937,1442),(12938,1443),(12939,1443),(12940,1443),(12941,1443),(12942,1443),(12943,1444),(12944,1444),(12945,1444),(12946,1444),(12947,1444),(12948,1445),(12949,1445),(12950,1445),(12951,1445),(12952,1445),(12953,1446),(12954,1446),(12955,1446),(12956,1446),(12957,1446),(12958,1347),(12959,1347),(12960,1347),(12961,1347),(12962,1347),(12963,1347),(12964,1348),(12965,1348),(12966,1348),(12967,1348),(12968,1348),(12969,1348),(12970,1348),(12971,1348),(12972,1348),(12973,1349),(12974,1349),(12975,1349),(12976,1349),(12977,1349),(12978,1349),(12979,1350),(12980,1350),(12981,1350),(12982,1350),(12983,1350),(12984,1350),(12985,1351),(12986,1351),(12987,1351),(12988,1351),(12989,1351),(12990,1351),(12991,1352),(12992,1352),(12993,1352),(12994,1352),(12995,1352),(12996,1352),(12997,1353),(12998,1353),(12999,1353),(13000,1353),(13001,1353),(13002,1353),(13003,1354),(13004,1354),(13005,1354),(13006,1354),(13007,1354),(13008,1354),(13009,1355),(13010,1355),(13011,1355),(13012,1355),(13013,1355),(13014,1355),(13015,1356),(13016,1356),(13017,1356),(13018,1356),(13019,1356),(13020,1356),(13021,1357),(13022,1357),(13023,1357),(13024,1357),(13025,1357),(13026,1357),(13027,1358),(13028,1358),(13029,1358),(13030,1358),(13031,1358),(13032,1358),(13033,1359),(13034,1359),(13035,1359),(13036,1359),(13037,1359),(13038,1359),(13039,1360),(13040,1360),(13041,1360),(13042,1360),(13043,1360),(13044,1360),(13045,1361),(13046,1361),(13047,1361),(13048,1361),(13049,1361),(13050,1361),(13051,1362),(13052,1362),(13053,1362),(13054,1362),(13055,1362),(13056,1362),(13057,1363),(13058,1363),(13059,1363),(13060,1363),(13061,1363),(13062,1363),(13063,1364),(13064,1364),(13065,1364),(13066,1364),(13067,1364),(13068,1364),(13069,1364),(13070,1364),(13071,1364),(13072,1365),(13073,1365),(13074,1365),(13075,1365),(13076,1365),(13077,1365),(13078,1366),(13079,1366),(13080,1366),(13081,1366),(13082,1366),(13083,1366),(13084,1367),(13085,1367),(13086,1367),(13087,1367),(13088,1367),(13089,1367),(13090,1368),(13091,1368),(13092,1368),(13093,1368),(13094,1368),(13095,1368),(13096,1369),(13097,1369),(13098,1369),(13099,1369),(13100,1369),(13101,1369),(13102,1370),(13103,1370),(13104,1370),(13105,1370),(13106,1370),(13107,1370),(13108,1371),(13109,1371),(13110,1371),(13111,1371),(13112,1371),(13113,1371),(13114,1372),(13115,1372),(13116,1372),(13117,1372),(13118,1372),(13119,1372),(13120,1373),(13121,1373),(13122,1373),(13123,1373),(13124,1373),(13125,1373),(13126,1374),(13127,1374),(13128,1374),(13129,1374),(13130,1374),(13131,1374),(13132,1375),(13133,1375),(13134,1375),(13135,1375),(13136,1375),(13137,1375),(13138,1376),(13139,1376),(13140,1376),(13141,1376),(13142,1376),(13143,1376),(13144,1377),(13145,1377),(13146,1377),(13147,1377),(13148,1377),(13149,1377),(13150,1378),(13151,1378),(13152,1378),(13153,1378),(13154,1378),(13155,1378),(13156,1379),(13157,1379),(13158,1379),(13159,1379),(13160,1379),(13161,1379),(13162,1380),(13163,1380),(13164,1380),(13165,1380),(13166,1380),(13167,1380),(13168,1380),(13169,1380),(13170,1380),(13171,1381),(13172,1381),(13173,1381),(13174,1381),(13175,1381),(13176,1381),(13177,1382),(13178,1382),(13179,1382),(13180,1382),(13181,1382),(13182,1382),(13183,1383),(13184,1383),(13185,1383),(13186,1383),(13187,1383),(13188,1383),(13189,1384),(13190,1384),(13191,1384),(13192,1384),(13193,1384),(13194,1384),(13195,1385),(13196,1385),(13197,1385),(13198,1385),(13199,1385),(13200,1385),(13201,1386),(13202,1386),(13203,1386),(13204,1386),(13205,1386),(13206,1386),(13207,1387),(13208,1387),(13209,1387),(13210,1387),(13211,1387),(13212,1387),(13213,1388),(13214,1388),(13215,1388),(13216,1388),(13217,1388),(13218,1388),(13219,1389),(13220,1389),(13221,1389),(13222,1389),(13223,1389),(13224,1389),(13225,1390),(13226,1390),(13227,1390),(13228,1390),(13229,1390),(13230,1390),(13231,1391),(13232,1391),(13233,1391),(13234,1391),(13235,1391),(13236,1391),(13237,1392),(13238,1392),(13239,1392),(13240,1392),(13241,1392),(13242,1392),(13243,1393),(13244,1393),(13245,1393),(13246,1393),(13247,1393),(13248,1393),(13249,1394),(13250,1394),(13251,1394),(13252,1394),(13253,1394),(13254,1394),(13255,1395),(13256,1395),(13257,1395),(13258,1395),(13259,1395),(13260,1395),(13261,1396),(13262,1396),(13263,1396),(13264,1396),(13265,1396),(13266,1396),(13267,1396),(13268,1396),(13269,1396),(13270,1397),(13271,1397),(13272,1397),(13273,1397),(13274,1397),(13275,1397),(13276,1398),(13277,1398),(13278,1398),(13279,1398),(13280,1398),(13281,1398),(13282,1399),(13283,1399),(13284,1399),(13285,1399),(13286,1399),(13287,1399),(13288,1400),(13289,1400),(13290,1400),(13291,1400),(13292,1400),(13293,1400),(13294,1401),(13295,1401),(13296,1401),(13297,1401),(13298,1401),(13299,1401),(13300,1402),(13301,1402),(13302,1402),(13303,1402),(13304,1402),(13305,1402),(13306,1403),(13307,1403),(13308,1403),(13309,1403),(13310,1403),(13311,1403),(13312,1404),(13313,1404),(13314,1404),(13315,1404),(13316,1404),(13317,1404),(13318,1405),(13319,1405),(13320,1405),(13321,1405),(13322,1405),(13323,1405),(13324,1406),(13325,1406),(13326,1406),(13327,1406),(13328,1406),(13329,1406),(13330,1407),(13331,1407),(13332,1407),(13333,1407),(13334,1407),(13335,1407),(13336,1408),(13337,1408),(13338,1408),(13339,1408),(13340,1408),(13341,1408),(13342,1409),(13343,1409),(13344,1409),(13345,1409),(13346,1409),(13347,1409),(13348,1410),(13349,1410),(13350,1410),(13351,1410),(13352,1410),(13353,1410),(13354,1411),(13355,1411),(13356,1411),(13357,1411),(13358,1411),(13359,1411),(13360,1412),(13361,1412),(13362,1412),(13363,1412),(13364,1412),(13365,1412),(13366,1412),(13367,1412),(13368,1412),(13369,1413),(13370,1413),(13371,1413),(13372,1413),(13373,1413),(13374,1413),(13375,1414),(13376,1414),(13377,1414),(13378,1414),(13379,1414),(13380,1414),(13381,1415),(13382,1415),(13383,1415),(13384,1415),(13385,1415),(13386,1415),(13387,1416),(13388,1416),(13389,1416),(13390,1416),(13391,1416),(13392,1416),(13393,1417),(13394,1417),(13395,1417),(13396,1417),(13397,1417),(13398,1417),(13399,1418),(13400,1418),(13401,1418),(13402,1418),(13403,1418),(13404,1418),(13405,1419),(13406,1419),(13407,1419),(13408,1419),(13409,1419),(13410,1419),(13411,1420),(13412,1420),(13413,1420),(13414,1420),(13415,1420),(13416,1420),(13417,1421),(13418,1421),(13419,1421),(13420,1421),(13421,1421),(13422,1421),(13423,1422),(13424,1422),(13425,1422),(13426,1422),(13427,1422),(13428,1422),(13429,1423),(13430,1423),(13431,1423),(13432,1423),(13433,1423),(13434,1423),(13435,1424),(13436,1424),(13437,1424),(13438,1424),(13439,1424),(13440,1424),(13441,1425),(13442,1425),(13443,1425),(13444,1425),(13445,1425),(13446,1425),(13447,1426),(13448,1426),(13449,1426),(13450,1426),(13451,1426),(13452,1426),(13453,1427),(13454,1427),(13455,1427),(13456,1427),(13457,1427),(13458,1427),(13459,1428),(13460,1428),(13461,1428),(13462,1428),(13463,1428),(13464,1428),(13465,1428),(13466,1428),(13467,1428),(13468,1429),(13469,1429),(13470,1429),(13471,1429),(13472,1429),(13473,1429),(13474,1430),(13475,1430),(13476,1430),(13477,1430),(13478,1430),(13479,1430),(13480,1431),(13481,1431),(13482,1431),(13483,1431),(13484,1431),(13485,1431),(13486,1432),(13487,1432),(13488,1432),(13489,1432),(13490,1432),(13491,1432),(13492,1433),(13493,1433),(13494,1433),(13495,1433),(13496,1433),(13497,1433),(13498,1434),(13499,1434),(13500,1434),(13501,1434),(13502,1434),(13503,1434),(13504,1435),(13505,1435),(13506,1435),(13507,1435),(13508,1435),(13509,1435),(13510,1436),(13511,1436),(13512,1436),(13513,1436),(13514,1436),(13515,1436),(13516,1437),(13517,1437),(13518,1437),(13519,1437),(13520,1437),(13521,1437),(13522,1438),(13523,1438),(13524,1438),(13525,1438),(13526,1438),(13527,1438),(13528,1439),(13529,1439),(13530,1439),(13531,1439),(13532,1439),(13533,1439),(13534,1440),(13535,1440),(13536,1440),(13537,1440),(13538,1440),(13539,1440),(13540,1441),(13541,1441),(13542,1441),(13543,1441),(13544,1441),(13545,1441),(13546,1442),(13547,1442),(13548,1442),(13549,1442),(13550,1442),(13551,1442),(13552,1443),(13553,1443),(13554,1443),(13555,1443),(13556,1443),(13557,1443),(13558,1444),(13559,1444),(13560,1444),(13561,1444),(13562,1444),(13563,1444),(13564,1444),(13565,1444),(13566,1444),(13567,1445),(13568,1445),(13569,1445),(13570,1445),(13571,1445),(13572,1445),(13573,1446),(13574,1446),(13575,1446),(13576,1446),(13577,1446),(13578,1446),(13579,1447),(13580,1448),(13581,1449),(13582,1450),(13583,1451),(13584,1452),(13585,1453),(13586,1454),(13587,1455),(13588,1456),(13589,1457),(13590,1458),(13591,1459),(13592,1460),(13593,1461),(13594,1462),(13595,1463),(13596,1464),(13597,1465),(13598,1466),(13599,1467),(13600,1468),(13601,1469),(13602,1470),(13603,1471),(13604,1472),(13605,1473),(13606,1474),(13607,1475),(13608,1476),(13609,1477),(13610,1478),(13611,1479),(13612,1480),(13613,1481),(13614,1482),(13615,1483),(13616,1484),(13617,1485),(13618,1486),(13619,1487),(13620,1488),(13621,1489),(13622,1490),(13623,1491),(13624,1492),(13625,1493),(13626,1494),(13627,1495),(13628,1496),(13629,1497),(13630,1498),(13631,1499),(13632,1500),(13633,1501),(13634,1502),(13635,1503),(13636,1504),(13637,1505),(13638,1506),(13639,1507),(13640,1508),(13641,1509),(13642,1510),(13643,1511),(13644,1512),(13645,1513),(13646,1514),(13647,1515),(13648,1516),(13649,1517),(13650,1518),(13651,1519),(13652,1520),(13653,1521),(13654,1522),(13655,1523),(13656,1524),(13657,1525),(13658,1526),(13659,1527),(13660,1528),(13661,1529),(13662,1530),(13663,1531),(13664,1532),(13665,1533),(13666,1534),(13667,1535),(13668,1536),(13669,1537),(13670,1538),(13671,1539),(13672,1540),(13673,1541),(13674,1542),(13675,1543),(13676,1544),(13677,1545),(13678,1546),(13679,1447),(13680,1447),(13681,1447),(13682,1447),(13683,1447),(13684,1448),(13685,1448),(13686,1448),(13687,1448),(13688,1448),(13689,1449),(13690,1449),(13691,1449),(13692,1449),(13693,1449),(13694,1450),(13695,1450),(13696,1450),(13697,1450),(13698,1450),(13699,1451),(13700,1451),(13701,1451),(13702,1451),(13703,1451),(13704,1452),(13705,1452),(13706,1452),(13707,1452),(13708,1452),(13709,1453),(13710,1453),(13711,1453),(13712,1453),(13713,1453),(13714,1454),(13715,1454),(13716,1454),(13717,1454),(13718,1454),(13719,1455),(13720,1455),(13721,1455),(13722,1455),(13723,1455),(13724,1456),(13725,1456),(13726,1456),(13727,1456),(13728,1456),(13729,1457),(13730,1457),(13731,1457),(13732,1457),(13733,1457),(13734,1458),(13735,1458),(13736,1458),(13737,1458),(13738,1458),(13739,1459),(13740,1459),(13741,1459),(13742,1459),(13743,1459),(13744,1460),(13745,1460),(13746,1460),(13747,1460),(13748,1460),(13749,1461),(13750,1461),(13751,1461),(13752,1461),(13753,1461),(13754,1462),(13755,1462),(13756,1462),(13757,1462),(13758,1462),(13759,1463),(13760,1463),(13761,1463),(13762,1463),(13763,1463),(13764,1464),(13765,1464),(13766,1464),(13767,1464),(13768,1464),(13769,1465),(13770,1465),(13771,1465),(13772,1465),(13773,1465),(13774,1466),(13775,1466),(13776,1466),(13777,1466),(13778,1466),(13779,1467),(13780,1467),(13781,1467),(13782,1467),(13783,1467),(13784,1468),(13785,1468),(13786,1468),(13787,1468),(13788,1468),(13789,1469),(13790,1469),(13791,1469),(13792,1469),(13793,1469),(13794,1470),(13795,1470),(13796,1470),(13797,1470),(13798,1470),(13799,1471),(13800,1471),(13801,1471),(13802,1471),(13803,1471),(13804,1472),(13805,1472),(13806,1472),(13807,1472),(13808,1472),(13809,1473),(13810,1473),(13811,1473),(13812,1473),(13813,1473),(13814,1474),(13815,1474),(13816,1474),(13817,1474),(13818,1474),(13819,1475),(13820,1475),(13821,1475),(13822,1475),(13823,1475),(13824,1476),(13825,1476),(13826,1476),(13827,1476),(13828,1476),(13829,1477),(13830,1477),(13831,1477),(13832,1477),(13833,1478),(13834,1478),(13835,1478),(13836,1478),(13837,1479),(13838,1479),(13839,1479),(13840,1479),(13841,1480),(13842,1480),(13843,1480),(13844,1480),(13845,1481),(13846,1481),(13847,1481),(13848,1481),(13849,1482),(13850,1482),(13851,1482),(13852,1482),(13853,1483),(13854,1483),(13855,1483),(13856,1483),(13857,1484),(13858,1484),(13859,1484),(13860,1484),(13861,1485),(13862,1485),(13863,1485),(13864,1485),(13865,1486),(13866,1486),(13867,1486),(13868,1486),(13869,1487),(13870,1487),(13871,1487),(13872,1487),(13873,1488),(13874,1488),(13875,1488),(13876,1488),(13877,1489),(13878,1489),(13879,1489),(13880,1489),(13881,1490),(13882,1490),(13883,1490),(13884,1490),(13885,1491),(13886,1491),(13887,1491),(13888,1491),(13889,1492),(13890,1492),(13891,1492),(13892,1492),(13893,1493),(13894,1493),(13895,1493),(13896,1493),(13897,1493),(13898,1494),(13899,1494),(13900,1494),(13901,1494),(13902,1494),(13903,1495),(13904,1495),(13905,1495),(13906,1495),(13907,1495),(13908,1496),(13909,1496),(13910,1496),(13911,1496),(13912,1496),(13913,1497),(13914,1497),(13915,1497),(13916,1497),(13917,1497),(13918,1498),(13919,1498),(13920,1498),(13921,1498),(13922,1498),(13923,1499),(13924,1499),(13925,1499),(13926,1499),(13927,1499),(13928,1500),(13929,1500),(13930,1500),(13931,1500),(13932,1500),(13933,1501),(13934,1501),(13935,1501),(13936,1501),(13937,1501),(13938,1502),(13939,1502),(13940,1502),(13941,1502),(13942,1502),(13943,1503),(13944,1503),(13945,1503),(13946,1503),(13947,1503),(13948,1504),(13949,1504),(13950,1504),(13951,1504),(13952,1504),(13953,1505),(13954,1505),(13955,1505),(13956,1505),(13957,1505),(13958,1506),(13959,1506),(13960,1506),(13961,1506),(13962,1506),(13963,1507),(13964,1507),(13965,1507),(13966,1507),(13967,1507),(13968,1508),(13969,1508),(13970,1508),(13971,1508),(13972,1508),(13973,1509),(13974,1509),(13975,1509),(13976,1509),(13977,1510),(13978,1510),(13979,1510),(13980,1510),(13981,1511),(13982,1511),(13983,1511),(13984,1511),(13985,1512),(13986,1512),(13987,1512),(13988,1512),(13989,1513),(13990,1513),(13991,1513),(13992,1513),(13993,1514),(13994,1514),(13995,1514),(13996,1514),(13997,1515),(13998,1515),(13999,1515),(14000,1515),(14001,1516),(14002,1516),(14003,1516),(14004,1516),(14005,1517),(14006,1517),(14007,1517),(14008,1517),(14009,1518),(14010,1518),(14011,1518),(14012,1518),(14013,1519),(14014,1519),(14015,1519),(14016,1519),(14017,1520),(14018,1520),(14019,1520),(14020,1520),(14021,1521),(14022,1521),(14023,1521),(14024,1521),(14025,1522),(14026,1522),(14027,1522),(14028,1522),(14029,1523),(14030,1523),(14031,1523),(14032,1523),(14033,1524),(14034,1524),(14035,1524),(14036,1524),(14037,1525),(14038,1525),(14039,1525),(14040,1525),(14041,1525),(14042,1526),(14043,1526),(14044,1526),(14045,1526),(14046,1526),(14047,1527),(14048,1527),(14049,1527),(14050,1527),(14051,1527),(14052,1528),(14053,1528),(14054,1528),(14055,1528),(14056,1528),(14057,1529),(14058,1529),(14059,1529),(14060,1529),(14061,1529),(14062,1530),(14063,1530),(14064,1530),(14065,1530),(14066,1530),(14067,1531),(14068,1531),(14069,1531),(14070,1531),(14071,1531),(14072,1532),(14073,1532),(14074,1532),(14075,1532),(14076,1532),(14077,1533),(14078,1533),(14079,1533),(14080,1533),(14081,1533),(14082,1534),(14083,1534),(14084,1534),(14085,1534),(14086,1534),(14087,1535),(14088,1535),(14089,1535),(14090,1535),(14091,1535),(14092,1536),(14093,1536),(14094,1536),(14095,1536),(14096,1536),(14097,1537),(14098,1537),(14099,1537),(14100,1537),(14101,1537),(14102,1538),(14103,1538),(14104,1538),(14105,1538),(14106,1538),(14107,1539),(14108,1539),(14109,1539),(14110,1539),(14111,1539),(14112,1540),(14113,1540),(14114,1540),(14115,1540),(14116,1540),(14117,1541),(14118,1541),(14119,1541),(14120,1541),(14121,1542),(14122,1542),(14123,1542),(14124,1542),(14125,1543),(14126,1543),(14127,1543),(14128,1543),(14129,1544),(14130,1544),(14131,1544),(14132,1544),(14133,1545),(14134,1545),(14135,1545),(14136,1545),(14137,1546),(14138,1546),(14139,1546),(14140,1546),(14141,1447),(14142,1447),(14143,1447),(14144,1447),(14145,1447),(14146,1447),(14147,1448),(14148,1448),(14149,1448),(14150,1448),(14151,1448),(14152,1448),(14153,1449),(14154,1449),(14155,1449),(14156,1449),(14157,1449),(14158,1449),(14159,1450),(14160,1450),(14161,1450),(14162,1450),(14163,1450),(14164,1450),(14165,1451),(14166,1451),(14167,1451),(14168,1451),(14169,1451),(14170,1451),(14171,1452),(14172,1452),(14173,1452),(14174,1452),(14175,1452),(14176,1452),(14177,1453),(14178,1453),(14179,1453),(14180,1453),(14181,1453),(14182,1453),(14183,1454),(14184,1454),(14185,1454),(14186,1454),(14187,1454),(14188,1454),(14189,1455),(14190,1455),(14191,1455),(14192,1455),(14193,1455),(14194,1455),(14195,1456),(14196,1456),(14197,1456),(14198,1456),(14199,1456),(14200,1456),(14201,1457),(14202,1457),(14203,1457),(14204,1457),(14205,1457),(14206,1457),(14207,1458),(14208,1458),(14209,1458),(14210,1458),(14211,1458),(14212,1458),(14213,1459),(14214,1459),(14215,1459),(14216,1459),(14217,1459),(14218,1459),(14219,1460),(14220,1460),(14221,1460),(14222,1460),(14223,1460),(14224,1460),(14225,1460),(14226,1460),(14227,1460),(14228,1461),(14229,1461),(14230,1461),(14231,1461),(14232,1461),(14233,1461),(14234,1462),(14235,1462),(14236,1462),(14237,1462),(14238,1462),(14239,1462),(14240,1463),(14241,1463),(14242,1463),(14243,1463),(14244,1463),(14245,1463),(14246,1464),(14247,1464),(14248,1464),(14249,1464),(14250,1464),(14251,1464),(14252,1465),(14253,1465),(14254,1465),(14255,1465),(14256,1465),(14257,1465),(14258,1466),(14259,1466),(14260,1466),(14261,1466),(14262,1466),(14263,1466),(14264,1467),(14265,1467),(14266,1467),(14267,1467),(14268,1467),(14269,1467),(14270,1468),(14271,1468),(14272,1468),(14273,1468),(14274,1468),(14275,1468),(14276,1469),(14277,1469),(14278,1469),(14279,1469),(14280,1469),(14281,1469),(14282,1470),(14283,1470),(14284,1470),(14285,1470),(14286,1470),(14287,1470),(14288,1471),(14289,1471),(14290,1471),(14291,1471),(14292,1471),(14293,1471),(14294,1472),(14295,1472),(14296,1472),(14297,1472),(14298,1472),(14299,1472),(14300,1473),(14301,1473),(14302,1473),(14303,1473),(14304,1473),(14305,1473),(14306,1474),(14307,1474),(14308,1474),(14309,1474),(14310,1474),(14311,1474),(14312,1475),(14313,1475),(14314,1475),(14315,1475),(14316,1475),(14317,1475),(14318,1476),(14319,1476),(14320,1476),(14321,1476),(14322,1476),(14323,1476),(14324,1476),(14325,1476),(14326,1476),(14327,1477),(14328,1477),(14329,1477),(14330,1477),(14331,1477),(14332,1477),(14333,1478),(14334,1478),(14335,1478),(14336,1478),(14337,1478),(14338,1478),(14339,1479),(14340,1479),(14341,1479),(14342,1479),(14343,1479),(14344,1479),(14345,1480),(14346,1480),(14347,1480),(14348,1480),(14349,1480),(14350,1480),(14351,1481),(14352,1481),(14353,1481),(14354,1481),(14355,1481),(14356,1481),(14357,1482),(14358,1482),(14359,1482),(14360,1482),(14361,1482),(14362,1482),(14363,1483),(14364,1483),(14365,1483),(14366,1483),(14367,1483),(14368,1483),(14369,1484),(14370,1484),(14371,1484),(14372,1484),(14373,1484),(14374,1484),(14375,1485),(14376,1485),(14377,1485),(14378,1485),(14379,1485),(14380,1485),(14381,1486),(14382,1486),(14383,1486),(14384,1486),(14385,1486),(14386,1486),(14387,1487),(14388,1487),(14389,1487),(14390,1487),(14391,1487),(14392,1487),(14393,1488),(14394,1488),(14395,1488),(14396,1488),(14397,1488),(14398,1488),(14399,1489),(14400,1489),(14401,1489),(14402,1489),(14403,1489),(14404,1489),(14405,1490),(14406,1490),(14407,1490),(14408,1490),(14409,1490),(14410,1490),(14411,1491),(14412,1491),(14413,1491),(14414,1491),(14415,1491),(14416,1491),(14417,1492),(14418,1492),(14419,1492),(14420,1492),(14421,1492),(14422,1492),(14423,1492),(14424,1492),(14425,1492),(14426,1493),(14427,1493),(14428,1493),(14429,1493),(14430,1493),(14431,1493),(14432,1494),(14433,1494),(14434,1494),(14435,1494),(14436,1494),(14437,1494),(14438,1495),(14439,1495),(14440,1495),(14441,1495),(14442,1495),(14443,1495),(14444,1496),(14445,1496),(14446,1496),(14447,1496),(14448,1496),(14449,1496),(14450,1497),(14451,1497),(14452,1497),(14453,1497),(14454,1497),(14455,1497),(14456,1498),(14457,1498),(14458,1498),(14459,1498),(14460,1498),(14461,1498),(14462,1499),(14463,1499),(14464,1499),(14465,1499),(14466,1499),(14467,1499),(14468,1500),(14469,1500),(14470,1500),(14471,1500),(14472,1500),(14473,1500),(14474,1501),(14475,1501),(14476,1501),(14477,1501),(14478,1501),(14479,1501),(14480,1502),(14481,1502),(14482,1502),(14483,1502),(14484,1502),(14485,1502),(14486,1503),(14487,1503),(14488,1503),(14489,1503),(14490,1503),(14491,1503),(14492,1504),(14493,1504),(14494,1504),(14495,1504),(14496,1504),(14497,1504),(14498,1505),(14499,1505),(14500,1505),(14501,1505),(14502,1505),(14503,1505),(14504,1506),(14505,1506),(14506,1506),(14507,1506),(14508,1506),(14509,1506),(14510,1507),(14511,1507),(14512,1507),(14513,1507),(14514,1507),(14515,1507),(14516,1508),(14517,1508),(14518,1508),(14519,1508),(14520,1508),(14521,1508),(14522,1508),(14523,1508),(14524,1508),(14525,1509),(14526,1509),(14527,1509),(14528,1509),(14529,1509),(14530,1509),(14531,1510),(14532,1510),(14533,1510),(14534,1510),(14535,1510),(14536,1510),(14537,1511),(14538,1511),(14539,1511),(14540,1511),(14541,1511),(14542,1511),(14543,1512),(14544,1512),(14545,1512),(14546,1512),(14547,1512),(14548,1512),(14549,1513),(14550,1513),(14551,1513),(14552,1513),(14553,1513),(14554,1513),(14555,1514),(14556,1514),(14557,1514),(14558,1514),(14559,1514),(14560,1514),(14561,1515),(14562,1515),(14563,1515),(14564,1515),(14565,1515),(14566,1515),(14567,1516),(14568,1516),(14569,1516),(14570,1516),(14571,1516),(14572,1516),(14573,1517),(14574,1517),(14575,1517),(14576,1517),(14577,1517),(14578,1517),(14579,1518),(14580,1518),(14581,1518),(14582,1518),(14583,1518),(14584,1518),(14585,1519),(14586,1519),(14587,1519),(14588,1519),(14589,1519),(14590,1519),(14591,1520),(14592,1520),(14593,1520),(14594,1520),(14595,1520),(14596,1520),(14597,1521),(14598,1521),(14599,1521),(14600,1521),(14601,1521),(14602,1521),(14603,1522),(14604,1522),(14605,1522),(14606,1522),(14607,1522),(14608,1522),(14609,1523),(14610,1523),(14611,1523),(14612,1523),(14613,1523),(14614,1523),(14615,1524),(14616,1524),(14617,1524),(14618,1524),(14619,1524),(14620,1524),(14621,1524),(14622,1524),(14623,1524),(14624,1525),(14625,1525),(14626,1525),(14627,1525),(14628,1525),(14629,1525),(14630,1526),(14631,1526),(14632,1526),(14633,1526),(14634,1526),(14635,1526),(14636,1527),(14637,1527),(14638,1527),(14639,1527),(14640,1527),(14641,1527),(14642,1528),(14643,1528),(14644,1528),(14645,1528),(14646,1528),(14647,1528),(14648,1529),(14649,1529),(14650,1529),(14651,1529),(14652,1529),(14653,1529),(14654,1530),(14655,1530),(14656,1530),(14657,1530),(14658,1530),(14659,1530),(14660,1531),(14661,1531),(14662,1531),(14663,1531),(14664,1531),(14665,1531),(14666,1532),(14667,1532),(14668,1532),(14669,1532),(14670,1532),(14671,1532),(14672,1533),(14673,1533),(14674,1533),(14675,1533),(14676,1533),(14677,1533),(14678,1534),(14679,1534),(14680,1534),(14681,1534),(14682,1534),(14683,1534),(14684,1535),(14685,1535),(14686,1535),(14687,1535),(14688,1535),(14689,1535),(14690,1536),(14691,1536),(14692,1536),(14693,1536),(14694,1536),(14695,1536),(14696,1537),(14697,1537),(14698,1537),(14699,1537),(14700,1537),(14701,1537),(14702,1538),(14703,1538),(14704,1538),(14705,1538),(14706,1538),(14707,1538),(14708,1539),(14709,1539),(14710,1539),(14711,1539),(14712,1539),(14713,1539),(14714,1540),(14715,1540),(14716,1540),(14717,1540),(14718,1540),(14719,1540),(14720,1540),(14721,1540),(14722,1540),(14723,1541),(14724,1541),(14725,1541),(14726,1541),(14727,1541),(14728,1541),(14729,1542),(14730,1542),(14731,1542),(14732,1542),(14733,1542),(14734,1542),(14735,1543),(14736,1543),(14737,1543),(14738,1543),(14739,1543),(14740,1543),(14741,1544),(14742,1544),(14743,1544),(14744,1544),(14745,1544),(14746,1544),(14747,1545),(14748,1545),(14749,1545),(14750,1545),(14751,1545),(14752,1545),(14753,1546),(14754,1546),(14755,1546),(14756,1546),(14757,1546),(14758,1546),(14759,1547),(14760,1548),(14761,1549),(14762,1550),(14763,1551),(14764,1552),(14765,1553),(14766,1554),(14767,1555),(14768,1556),(14769,1557),(14770,1558),(14771,1559),(14772,1560),(14773,1561),(14774,1562),(14775,1563),(14776,1564),(14777,1565),(14778,1566),(14779,1567),(14780,1568),(14781,1569),(14782,1570),(14783,1571),(14784,1572),(14785,1573),(14786,1574),(14787,1575),(14788,1576),(14789,1577),(14790,1578),(14791,1579),(14792,1580),(14793,1581),(14794,1582),(14795,1583),(14796,1584),(14797,1585),(14798,1586),(14799,1587),(14800,1588),(14801,1589),(14802,1590),(14803,1591),(14804,1592),(14805,1593),(14806,1594),(14807,1595),(14808,1596),(14809,1597),(14810,1598),(14811,1599),(14812,1600),(14813,1601),(14814,1602),(14815,1603),(14816,1604),(14817,1605),(14818,1606),(14819,1607),(14820,1608),(14821,1609),(14822,1610),(14823,1611),(14824,1612),(14825,1613),(14826,1614),(14827,1615),(14828,1616),(14829,1617),(14830,1618),(14831,1619),(14832,1620),(14833,1621),(14834,1622),(14835,1623),(14836,1624),(14837,1625),(14838,1626),(14839,1627),(14840,1628),(14841,1629),(14842,1630),(14843,1631),(14844,1632),(14845,1633),(14846,1634),(14847,1635),(14848,1636),(14849,1637),(14850,1638),(14851,1639),(14852,1640),(14853,1641),(14854,1642),(14855,1643),(14856,1644),(14857,1645),(14858,1646),(14859,1547),(14860,1547),(14861,1547),(14862,1547),(14863,1548),(14864,1548),(14865,1548),(14866,1548),(14867,1549),(14868,1549),(14869,1549),(14870,1549),(14871,1550),(14872,1550),(14873,1550),(14874,1550),(14875,1551),(14876,1551),(14877,1551),(14878,1551),(14879,1552),(14880,1552),(14881,1552),(14882,1552),(14883,1553),(14884,1553),(14885,1553),(14886,1553),(14887,1554),(14888,1554),(14889,1554),(14890,1554),(14891,1555),(14892,1555),(14893,1555),(14894,1555),(14895,1556),(14896,1556),(14897,1556),(14898,1556),(14899,1557),(14900,1557),(14901,1557),(14902,1558),(14903,1558),(14904,1558),(14905,1559),(14906,1559),(14907,1559),(14908,1560),(14909,1560),(14910,1560),(14911,1561),(14912,1561),(14913,1561),(14914,1562),(14915,1562),(14916,1562),(14917,1563),(14918,1563),(14919,1563),(14920,1564),(14921,1564),(14922,1564),(14923,1565),(14924,1565),(14925,1565),(14926,1566),(14927,1566),(14928,1566),(14929,1567),(14930,1567),(14931,1567),(14932,1568),(14933,1568),(14934,1568),(14935,1569),(14936,1569),(14937,1569),(14938,1570),(14939,1570),(14940,1570),(14941,1571),(14942,1571),(14943,1571),(14944,1572),(14945,1572),(14946,1572),(14947,1573),(14948,1573),(14949,1573),(14950,1574),(14951,1574),(14952,1574),(14953,1575),(14954,1575),(14955,1575),(14956,1576),(14957,1576),(14958,1576),(14959,1577),(14960,1577),(14961,1577),(14962,1578),(14963,1578),(14964,1578),(14965,1579),(14966,1579),(14967,1579),(14968,1580),(14969,1580),(14970,1580),(14971,1581),(14972,1581),(14973,1581),(14974,1582),(14975,1582),(14976,1582),(14977,1583),(14978,1583),(14979,1583),(14980,1584),(14981,1584),(14982,1584),(14983,1585),(14984,1585),(14985,1585),(14986,1586),(14987,1586),(14988,1586),(14989,1587),(14990,1587),(14991,1587),(14992,1588),(14993,1588),(14994,1588),(14995,1589),(14996,1589),(14997,1589),(14998,1589),(14999,1590),(15000,1590),(15001,1590),(15002,1590),(15003,1591),(15004,1591),(15005,1591),(15006,1591),(15007,1592),(15008,1592),(15009,1592),(15010,1592),(15011,1593),(15012,1593),(15013,1593),(15014,1593),(15015,1594),(15016,1594),(15017,1594),(15018,1594),(15019,1595),(15020,1595),(15021,1595),(15022,1595),(15023,1596),(15024,1596),(15025,1596),(15026,1596),(15027,1597),(15028,1597),(15029,1597),(15030,1597),(15031,1598),(15032,1598),(15033,1598),(15034,1598),(15035,1599),(15036,1599),(15037,1599),(15038,1599),(15039,1600),(15040,1600),(15041,1600),(15042,1600),(15043,1601),(15044,1601),(15045,1601),(15046,1601),(15047,1602),(15048,1602),(15049,1602),(15050,1602),(15051,1603),(15052,1603),(15053,1603),(15054,1603),(15055,1604),(15056,1604),(15057,1604),(15058,1604),(15059,1605),(15060,1606),(15061,1607),(15062,1608),(15063,1609),(15064,1610),(15065,1611),(15066,1612),(15067,1613),(15068,1614),(15069,1615),(15070,1616),(15071,1617),(15072,1618),(15073,1619),(15074,1620),(15075,1621),(15076,1621),(15077,1621),(15078,1621),(15079,1622),(15080,1622),(15081,1622),(15082,1622),(15083,1623),(15084,1623),(15085,1623),(15086,1623),(15087,1624),(15088,1624),(15089,1624),(15090,1624),(15091,1625),(15092,1625),(15093,1625),(15094,1625),(15095,1626),(15096,1626),(15097,1626),(15098,1626),(15099,1627),(15100,1627),(15101,1627),(15102,1627),(15103,1628),(15104,1628),(15105,1628),(15106,1628),(15107,1629),(15108,1629),(15109,1629),(15110,1629),(15111,1630),(15112,1630),(15113,1630),(15114,1630),(15115,1631),(15116,1631),(15117,1631),(15118,1631),(15119,1632),(15120,1632),(15121,1632),(15122,1632),(15123,1633),(15124,1633),(15125,1633),(15126,1633),(15127,1634),(15128,1634),(15129,1634),(15130,1634),(15131,1635),(15132,1635),(15133,1635),(15134,1635),(15135,1636),(15136,1636),(15137,1636),(15138,1636),(15139,1637),(15140,1638),(15141,1639),(15142,1640),(15143,1641),(15144,1642),(15145,1643),(15146,1644),(15147,1645),(15148,1646),(15149,1547),(15150,1547),(15151,1547),(15152,1547),(15153,1547),(15154,1547),(15155,1548),(15156,1548),(15157,1548),(15158,1548),(15159,1548),(15160,1548),(15161,1549),(15162,1549),(15163,1549),(15164,1549),(15165,1549),(15166,1549),(15167,1550),(15168,1550),(15169,1550),(15170,1550),(15171,1550),(15172,1550),(15173,1551),(15174,1551),(15175,1551),(15176,1551),(15177,1551),(15178,1551),(15179,1552),(15180,1552),(15181,1552),(15182,1552),(15183,1552),(15184,1552),(15185,1553),(15186,1553),(15187,1553),(15188,1553),(15189,1553),(15190,1553),(15191,1554),(15192,1554),(15193,1554),(15194,1554),(15195,1554),(15196,1554),(15197,1555),(15198,1555),(15199,1555),(15200,1555),(15201,1555),(15202,1555),(15203,1556),(15204,1556),(15205,1556),(15206,1556),(15207,1556),(15208,1556),(15209,1556),(15210,1556),(15211,1556),(15212,1557),(15213,1557),(15214,1557),(15215,1557),(15216,1557),(15217,1557),(15218,1558),(15219,1558),(15220,1558),(15221,1558),(15222,1558),(15223,1558),(15224,1559),(15225,1559),(15226,1559),(15227,1559),(15228,1559),(15229,1559),(15230,1560),(15231,1560),(15232,1560),(15233,1560),(15234,1560),(15235,1560),(15236,1561),(15237,1561),(15238,1561),(15239,1561),(15240,1561),(15241,1561),(15242,1562),(15243,1562),(15244,1562),(15245,1562),(15246,1562),(15247,1562),(15248,1563),(15249,1563),(15250,1563),(15251,1563),(15252,1563),(15253,1563),(15254,1564),(15255,1564),(15256,1564),(15257,1564),(15258,1564),(15259,1564),(15260,1565),(15261,1565),(15262,1565),(15263,1565),(15264,1565),(15265,1565),(15266,1566),(15267,1566),(15268,1566),(15269,1566),(15270,1566),(15271,1566),(15272,1567),(15273,1567),(15274,1567),(15275,1567),(15276,1567),(15277,1567),(15278,1568),(15279,1568),(15280,1568),(15281,1568),(15282,1568),(15283,1568),(15284,1569),(15285,1569),(15286,1569),(15287,1569),(15288,1569),(15289,1569),(15290,1570),(15291,1570),(15292,1570),(15293,1570),(15294,1570),(15295,1570),(15296,1571),(15297,1571),(15298,1571),(15299,1571),(15300,1571),(15301,1571),(15302,1572),(15303,1572),(15304,1572),(15305,1572),(15306,1572),(15307,1572),(15308,1572),(15309,1572),(15310,1572),(15311,1573),(15312,1573),(15313,1573),(15314,1573),(15315,1573),(15316,1573),(15317,1574),(15318,1574),(15319,1574),(15320,1574),(15321,1574),(15322,1574),(15323,1575),(15324,1575),(15325,1575),(15326,1575),(15327,1575),(15328,1575),(15329,1576),(15330,1576),(15331,1576),(15332,1576),(15333,1576),(15334,1576),(15335,1577),(15336,1577),(15337,1577),(15338,1577),(15339,1577),(15340,1577),(15341,1578),(15342,1578),(15343,1578),(15344,1578),(15345,1578),(15346,1578),(15347,1579),(15348,1579),(15349,1579),(15350,1579),(15351,1579),(15352,1579),(15353,1580),(15354,1580),(15355,1580),(15356,1580),(15357,1580),(15358,1580),(15359,1581),(15360,1581),(15361,1581),(15362,1581),(15363,1581),(15364,1581),(15365,1582),(15366,1582),(15367,1582),(15368,1582),(15369,1582),(15370,1582),(15371,1583),(15372,1583),(15373,1583),(15374,1583),(15375,1583),(15376,1583),(15377,1584),(15378,1584),(15379,1584),(15380,1584),(15381,1584),(15382,1584),(15383,1585),(15384,1585),(15385,1585),(15386,1585),(15387,1585),(15388,1585),(15389,1586),(15390,1586),(15391,1586),(15392,1586),(15393,1586),(15394,1586),(15395,1587),(15396,1587),(15397,1587),(15398,1587),(15399,1587),(15400,1587),(15401,1588),(15402,1588),(15403,1588),(15404,1588),(15405,1588),(15406,1588),(15407,1588),(15408,1588),(15409,1588),(15410,1589),(15411,1589),(15412,1589),(15413,1589),(15414,1589),(15415,1589),(15416,1590),(15417,1590),(15418,1590),(15419,1590),(15420,1590),(15421,1590),(15422,1591),(15423,1591),(15424,1591),(15425,1591),(15426,1591),(15427,1591),(15428,1592),(15429,1592),(15430,1592),(15431,1592),(15432,1592),(15433,1592),(15434,1593),(15435,1593),(15436,1593),(15437,1593),(15438,1593),(15439,1593),(15440,1594),(15441,1594),(15442,1594),(15443,1594),(15444,1594),(15445,1594),(15446,1595),(15447,1595),(15448,1595),(15449,1595),(15450,1595),(15451,1595),(15452,1596),(15453,1596),(15454,1596),(15455,1596),(15456,1596),(15457,1596),(15458,1597),(15459,1597),(15460,1597),(15461,1597),(15462,1597),(15463,1597),(15464,1598),(15465,1598),(15466,1598),(15467,1598),(15468,1598),(15469,1598),(15470,1599),(15471,1599),(15472,1599),(15473,1599),(15474,1599),(15475,1599),(15476,1600),(15477,1600),(15478,1600),(15479,1600),(15480,1600),(15481,1600),(15482,1601),(15483,1601),(15484,1601),(15485,1601),(15486,1601),(15487,1601),(15488,1602),(15489,1602),(15490,1602),(15491,1602),(15492,1602),(15493,1602),(15494,1603),(15495,1603),(15496,1603),(15497,1603),(15498,1603),(15499,1603),(15500,1604),(15501,1604),(15502,1604),(15503,1604),(15504,1604),(15505,1604),(15506,1604),(15507,1604),(15508,1604),(15509,1605),(15510,1605),(15511,1605),(15512,1605),(15513,1605),(15514,1605),(15515,1606),(15516,1606),(15517,1606),(15518,1606),(15519,1606),(15520,1606),(15521,1607),(15522,1607),(15523,1607),(15524,1607),(15525,1607),(15526,1607),(15527,1608),(15528,1608),(15529,1608),(15530,1608),(15531,1608),(15532,1608),(15533,1609),(15534,1609),(15535,1609),(15536,1609),(15537,1609),(15538,1609),(15539,1610),(15540,1610),(15541,1610),(15542,1610),(15543,1610),(15544,1610),(15545,1611),(15546,1611),(15547,1611),(15548,1611),(15549,1611),(15550,1611),(15551,1612),(15552,1612),(15553,1612),(15554,1612),(15555,1612),(15556,1612),(15557,1613),(15558,1613),(15559,1613),(15560,1613),(15561,1613),(15562,1613),(15563,1614),(15564,1614),(15565,1614),(15566,1614),(15567,1614),(15568,1614),(15569,1615),(15570,1615),(15571,1615),(15572,1615),(15573,1615),(15574,1615),(15575,1616),(15576,1616),(15577,1616),(15578,1616),(15579,1616),(15580,1616),(15581,1617),(15582,1617),(15583,1617),(15584,1617),(15585,1617),(15586,1617),(15587,1618),(15588,1618),(15589,1618),(15590,1618),(15591,1618),(15592,1618),(15593,1619),(15594,1619),(15595,1619),(15596,1619),(15597,1619),(15598,1619),(15599,1620),(15600,1620),(15601,1620),(15602,1620),(15603,1620),(15604,1620),(15605,1620),(15606,1620),(15607,1620),(15608,1621),(15609,1621),(15610,1621),(15611,1621),(15612,1621),(15613,1621),(15614,1622),(15615,1622),(15616,1622),(15617,1622),(15618,1622),(15619,1622),(15620,1623),(15621,1623),(15622,1623),(15623,1623),(15624,1623),(15625,1623),(15626,1624),(15627,1624),(15628,1624),(15629,1624),(15630,1624),(15631,1624),(15632,1625),(15633,1625),(15634,1625),(15635,1625),(15636,1625),(15637,1625),(15638,1626),(15639,1626),(15640,1626),(15641,1626),(15642,1626),(15643,1626),(15644,1627),(15645,1627),(15646,1627),(15647,1627),(15648,1627),(15649,1627),(15650,1628),(15651,1628),(15652,1628),(15653,1628),(15654,1628),(15655,1628),(15656,1629),(15657,1629),(15658,1629),(15659,1629),(15660,1629),(15661,1629),(15662,1630),(15663,1630),(15664,1630),(15665,1630),(15666,1630),(15667,1630),(15668,1631),(15669,1631),(15670,1631),(15671,1631),(15672,1631),(15673,1631),(15674,1632),(15675,1632),(15676,1632),(15677,1632),(15678,1632),(15679,1632),(15680,1633),(15681,1633),(15682,1633),(15683,1633),(15684,1633),(15685,1633),(15686,1634),(15687,1634),(15688,1634),(15689,1634),(15690,1634),(15691,1634),(15692,1635),(15693,1635),(15694,1635),(15695,1635),(15696,1635),(15697,1635),(15698,1636),(15699,1636),(15700,1636),(15701,1636),(15702,1636),(15703,1636),(15704,1636),(15705,1636),(15706,1636),(15707,1637),(15708,1637),(15709,1637),(15710,1637),(15711,1637),(15712,1637),(15713,1638),(15714,1638),(15715,1638),(15716,1638),(15717,1638),(15718,1638),(15719,1639),(15720,1639),(15721,1639),(15722,1639),(15723,1639),(15724,1639),(15725,1640),(15726,1640),(15727,1640),(15728,1640),(15729,1640),(15730,1640),(15731,1641),(15732,1641),(15733,1641),(15734,1641),(15735,1641),(15736,1641),(15737,1642),(15738,1642),(15739,1642),(15740,1642),(15741,1642),(15742,1642),(15743,1643),(15744,1643),(15745,1643),(15746,1643),(15747,1643),(15748,1643),(15749,1644),(15750,1644),(15751,1644),(15752,1644),(15753,1644),(15754,1644),(15755,1645),(15756,1645),(15757,1645),(15758,1645),(15759,1645),(15760,1645),(15761,1646),(15762,1646),(15763,1646),(15764,1646),(15765,1646),(15766,1646),(15767,1647),(15768,1648),(15769,1649),(15770,1650),(15771,1651),(15772,1652),(15773,1653),(15774,1654),(15775,1655),(15776,1656),(15777,1657),(15778,1658),(15779,1659),(15780,1660),(15781,1661),(15782,1662),(15783,1663),(15784,1664),(15785,1665),(15786,1666),(15787,1667),(15788,1668),(15789,1669),(15790,1670),(15791,1671),(15792,1672),(15793,1673),(15794,1674),(15795,1675),(15796,1676),(15797,1677),(15798,1678),(15799,1679),(15800,1680),(15801,1681),(15802,1682),(15803,1683),(15804,1684),(15805,1685),(15806,1686),(15807,1687),(15808,1688),(15809,1689),(15810,1690),(15811,1691),(15812,1692),(15813,1693),(15814,1694),(15815,1695),(15816,1696),(15817,1697),(15818,1698),(15819,1699),(15820,1700),(15821,1701),(15822,1702),(15823,1703),(15824,1704),(15825,1705),(15826,1706),(15827,1707),(15828,1708),(15829,1709),(15830,1710),(15831,1711),(15832,1712),(15833,1713),(15834,1714),(15835,1715),(15836,1716),(15837,1717),(15838,1718),(15839,1719),(15840,1720),(15841,1721),(15842,1722),(15843,1723),(15844,1724),(15845,1725),(15846,1726),(15847,1727),(15848,1728),(15849,1729),(15850,1730),(15851,1731),(15852,1732),(15853,1733),(15854,1734),(15855,1735),(15856,1736),(15857,1737),(15858,1738),(15859,1739),(15860,1740),(15861,1741),(15862,1742),(15863,1743),(15864,1744),(15865,1745),(15866,1746),(15867,1647),(15868,1648),(15869,1649),(15870,1650),(15871,1651),(15872,1652),(15873,1653),(15874,1654),(15875,1655),(15876,1656),(15877,1657),(15878,1658),(15879,1659),(15880,1660),(15881,1661),(15882,1662),(15883,1663),(15884,1664),(15885,1665),(15886,1666),(15887,1667),(15888,1668),(15889,1669),(15890,1669),(15891,1669),(15892,1670),(15893,1670),(15894,1670),(15895,1671),(15896,1671),(15897,1671),(15898,1672),(15899,1672),(15900,1672),(15901,1673),(15902,1673),(15903,1673),(15904,1674),(15905,1674),(15906,1674),(15907,1675),(15908,1675),(15909,1675),(15910,1676),(15911,1676),(15912,1676),(15913,1677),(15914,1677),(15915,1677),(15916,1678),(15917,1678),(15918,1678),(15919,1679),(15920,1679),(15921,1679),(15922,1680),(15923,1680),(15924,1680),(15925,1681),(15926,1681),(15927,1681),(15928,1682),(15929,1682),(15930,1682),(15931,1683),(15932,1683),(15933,1683),(15934,1684),(15935,1684),(15936,1684),(15937,1685),(15938,1686),(15939,1687),(15940,1688),(15941,1689),(15942,1690),(15943,1691),(15944,1692),(15945,1693),(15946,1694),(15947,1695),(15948,1696),(15949,1697),(15950,1698),(15951,1699),(15952,1700),(15953,1701),(15954,1701),(15955,1701),(15956,1701),(15957,1702),(15958,1702),(15959,1702),(15960,1702),(15961,1703),(15962,1703),(15963,1703),(15964,1703),(15965,1704),(15966,1704),(15967,1704),(15968,1704),(15969,1705),(15970,1705),(15971,1705),(15972,1705),(15973,1706),(15974,1706),(15975,1706),(15976,1706),(15977,1707),(15978,1707),(15979,1707),(15980,1707),(15981,1708),(15982,1708),(15983,1708),(15984,1708),(15985,1709),(15986,1709),(15987,1709),(15988,1709),(15989,1710),(15990,1710),(15991,1710),(15992,1710),(15993,1711),(15994,1711),(15995,1711),(15996,1711),(15997,1712),(15998,1712),(15999,1712),(16000,1712),(16001,1713),(16002,1713),(16003,1713),(16004,1713),(16005,1714),(16006,1714),(16007,1714),(16008,1714),(16009,1715),(16010,1715),(16011,1715),(16012,1715),(16013,1716),(16014,1716),(16015,1716),(16016,1716),(16017,1717),(16018,1717),(16019,1717),(16020,1718),(16021,1718),(16022,1718),(16023,1719),(16024,1719),(16025,1719),(16026,1720),(16027,1720),(16028,1720),(16029,1721),(16030,1721),(16031,1721),(16032,1722),(16033,1722),(16034,1722),(16035,1723),(16036,1723),(16037,1723),(16038,1724),(16039,1724),(16040,1724),(16041,1725),(16042,1725),(16043,1725),(16044,1726),(16045,1726),(16046,1726),(16047,1727),(16048,1727),(16049,1727),(16050,1728),(16051,1728),(16052,1728),(16053,1729),(16054,1729),(16055,1729),(16056,1730),(16057,1730),(16058,1730),(16059,1731),(16060,1731),(16061,1731),(16062,1732),(16063,1732),(16064,1732),(16065,1733),(16066,1733),(16067,1733),(16068,1734),(16069,1734),(16070,1734),(16071,1735),(16072,1735),(16073,1735),(16074,1736),(16075,1736),(16076,1736),(16077,1737),(16078,1737),(16079,1737),(16080,1738),(16081,1738),(16082,1738),(16083,1739),(16084,1739),(16085,1739),(16086,1740),(16087,1740),(16088,1740),(16089,1741),(16090,1741),(16091,1741),(16092,1742),(16093,1742),(16094,1742),(16095,1743),(16096,1743),(16097,1743),(16098,1744),(16099,1744),(16100,1744),(16101,1745),(16102,1745),(16103,1745),(16104,1746),(16105,1746),(16106,1746),(16107,1647),(16108,1647),(16109,1647),(16110,1647),(16111,1647),(16112,1647),(16113,1648),(16114,1648),(16115,1648),(16116,1648),(16117,1648),(16118,1648),(16119,1649),(16120,1649),(16121,1649),(16122,1649),(16123,1649),(16124,1649),(16125,1650),(16126,1650),(16127,1650),(16128,1650),(16129,1650),(16130,1650),(16131,1651),(16132,1651),(16133,1651),(16134,1651),(16135,1651),(16136,1651),(16137,1652),(16138,1652),(16139,1652),(16140,1652),(16141,1652),(16142,1652),(16143,1652),(16144,1652),(16145,1652),(16146,1653),(16147,1653),(16148,1653),(16149,1653),(16150,1653),(16151,1653),(16152,1654),(16153,1654),(16154,1654),(16155,1654),(16156,1654),(16157,1654),(16158,1655),(16159,1655),(16160,1655),(16161,1655),(16162,1655),(16163,1655),(16164,1656),(16165,1656),(16166,1656),(16167,1656),(16168,1656),(16169,1656),(16170,1657),(16171,1657),(16172,1657),(16173,1657),(16174,1657),(16175,1657),(16176,1658),(16177,1658),(16178,1658),(16179,1658),(16180,1658),(16181,1658),(16182,1659),(16183,1659),(16184,1659),(16185,1659),(16186,1659),(16187,1659),(16188,1660),(16189,1660),(16190,1660),(16191,1660),(16192,1660),(16193,1660),(16194,1661),(16195,1661),(16196,1661),(16197,1661),(16198,1661),(16199,1661),(16200,1662),(16201,1662),(16202,1662),(16203,1662),(16204,1662),(16205,1662),(16206,1663),(16207,1663),(16208,1663),(16209,1663),(16210,1663),(16211,1663),(16212,1664),(16213,1664),(16214,1664),(16215,1664),(16216,1664),(16217,1664),(16218,1665),(16219,1665),(16220,1665),(16221,1665),(16222,1665),(16223,1665),(16224,1666),(16225,1666),(16226,1666),(16227,1666),(16228,1666),(16229,1666),(16230,1667),(16231,1667),(16232,1667),(16233,1667),(16234,1667),(16235,1667),(16236,1668),(16237,1668),(16238,1668),(16239,1668),(16240,1668),(16241,1668),(16242,1668),(16243,1668),(16244,1668),(16245,1669),(16246,1669),(16247,1669),(16248,1669),(16249,1669),(16250,1669),(16251,1670),(16252,1670),(16253,1670),(16254,1670),(16255,1670),(16256,1670),(16257,1671),(16258,1671),(16259,1671),(16260,1671),(16261,1671),(16262,1671),(16263,1672),(16264,1672),(16265,1672),(16266,1672),(16267,1672),(16268,1672),(16269,1673),(16270,1673),(16271,1673),(16272,1673),(16273,1673),(16274,1673),(16275,1674),(16276,1674),(16277,1674),(16278,1674),(16279,1674),(16280,1674),(16281,1675),(16282,1675),(16283,1675),(16284,1675),(16285,1675),(16286,1675),(16287,1676),(16288,1676),(16289,1676),(16290,1676),(16291,1676),(16292,1676),(16293,1677),(16294,1677),(16295,1677),(16296,1677),(16297,1677),(16298,1677),(16299,1678),(16300,1678),(16301,1678),(16302,1678),(16303,1678),(16304,1678),(16305,1679),(16306,1679),(16307,1679),(16308,1679),(16309,1679),(16310,1679),(16311,1680),(16312,1680),(16313,1680),(16314,1680),(16315,1680),(16316,1680),(16317,1681),(16318,1681),(16319,1681),(16320,1681),(16321,1681),(16322,1681),(16323,1682),(16324,1682),(16325,1682),(16326,1682),(16327,1682),(16328,1682),(16329,1683),(16330,1683),(16331,1683),(16332,1683),(16333,1683),(16334,1683),(16335,1684),(16336,1684),(16337,1684),(16338,1684),(16339,1684),(16340,1684),(16341,1684),(16342,1684),(16343,1684),(16344,1685),(16345,1685),(16346,1685),(16347,1685),(16348,1685),(16349,1685),(16350,1686),(16351,1686),(16352,1686),(16353,1686),(16354,1686),(16355,1686),(16356,1687),(16357,1687),(16358,1687),(16359,1687),(16360,1687),(16361,1687),(16362,1688),(16363,1688),(16364,1688),(16365,1688),(16366,1688),(16367,1688),(16368,1689),(16369,1689),(16370,1689),(16371,1689),(16372,1689),(16373,1689),(16374,1690),(16375,1690),(16376,1690),(16377,1690),(16378,1690),(16379,1690),(16380,1691),(16381,1691),(16382,1691),(16383,1691),(16384,1691),(16385,1691),(16386,1692),(16387,1692),(16388,1692),(16389,1692),(16390,1692),(16391,1692),(16392,1693),(16393,1693),(16394,1693),(16395,1693),(16396,1693),(16397,1693),(16398,1694),(16399,1694),(16400,1694),(16401,1694),(16402,1694),(16403,1694),(16404,1695),(16405,1695),(16406,1695),(16407,1695),(16408,1695),(16409,1695),(16410,1696),(16411,1696),(16412,1696),(16413,1696),(16414,1696),(16415,1696),(16416,1697),(16417,1697),(16418,1697),(16419,1697),(16420,1697),(16421,1697),(16422,1698),(16423,1698),(16424,1698),(16425,1698),(16426,1698),(16427,1698),(16428,1699),(16429,1699),(16430,1699),(16431,1699),(16432,1699),(16433,1699),(16434,1700),(16435,1700),(16436,1700),(16437,1700),(16438,1700),(16439,1700),(16440,1700),(16441,1700),(16442,1700),(16443,1701),(16444,1701),(16445,1701),(16446,1701),(16447,1701),(16448,1701),(16449,1702),(16450,1702),(16451,1702),(16452,1702),(16453,1702),(16454,1702),(16455,1703),(16456,1703),(16457,1703),(16458,1703),(16459,1703),(16460,1703),(16461,1704),(16462,1704),(16463,1704),(16464,1704),(16465,1704),(16466,1704),(16467,1705),(16468,1705),(16469,1705),(16470,1705),(16471,1705),(16472,1705),(16473,1706),(16474,1706),(16475,1706),(16476,1706),(16477,1706),(16478,1706),(16479,1707),(16480,1707),(16481,1707),(16482,1707),(16483,1707),(16484,1707),(16485,1708),(16486,1708),(16487,1708),(16488,1708),(16489,1708),(16490,1708),(16491,1709),(16492,1709),(16493,1709),(16494,1709),(16495,1709),(16496,1709),(16497,1710),(16498,1710),(16499,1710),(16500,1710),(16501,1710),(16502,1710),(16503,1711),(16504,1711),(16505,1711),(16506,1711),(16507,1711),(16508,1711),(16509,1712),(16510,1712),(16511,1712),(16512,1712),(16513,1712),(16514,1712),(16515,1713),(16516,1713),(16517,1713),(16518,1713),(16519,1713),(16520,1713),(16521,1714),(16522,1714),(16523,1714),(16524,1714),(16525,1714),(16526,1714),(16527,1715),(16528,1715),(16529,1715),(16530,1715),(16531,1715),(16532,1715),(16533,1716),(16534,1716),(16535,1716),(16536,1716),(16537,1716),(16538,1716),(16539,1716),(16540,1716),(16541,1716),(16542,1717),(16543,1717),(16544,1717),(16545,1717),(16546,1717),(16547,1717),(16548,1718),(16549,1718),(16550,1718),(16551,1718),(16552,1718),(16553,1718),(16554,1719),(16555,1719),(16556,1719),(16557,1719),(16558,1719),(16559,1719),(16560,1720),(16561,1720),(16562,1720),(16563,1720),(16564,1720),(16565,1720),(16566,1721),(16567,1721),(16568,1721),(16569,1721),(16570,1721),(16571,1721),(16572,1722),(16573,1722),(16574,1722),(16575,1722),(16576,1722),(16577,1722),(16578,1723),(16579,1723),(16580,1723),(16581,1723),(16582,1723),(16583,1723),(16584,1724),(16585,1724),(16586,1724),(16587,1724),(16588,1724),(16589,1724),(16590,1725),(16591,1725),(16592,1725),(16593,1725),(16594,1725),(16595,1725),(16596,1726),(16597,1726),(16598,1726),(16599,1726),(16600,1726),(16601,1726),(16602,1727),(16603,1727),(16604,1727),(16605,1727),(16606,1727),(16607,1727),(16608,1728),(16609,1728),(16610,1728),(16611,1728),(16612,1728),(16613,1728),(16614,1729),(16615,1729),(16616,1729),(16617,1729),(16618,1729),(16619,1729),(16620,1730),(16621,1730),(16622,1730),(16623,1730),(16624,1730),(16625,1730),(16626,1731),(16627,1731),(16628,1731),(16629,1731),(16630,1731),(16631,1731),(16632,1732),(16633,1732),(16634,1732),(16635,1732),(16636,1732),(16637,1732),(16638,1732),(16639,1732),(16640,1732),(16641,1733),(16642,1733),(16643,1733),(16644,1733),(16645,1733),(16646,1733),(16647,1734),(16648,1734),(16649,1734),(16650,1734),(16651,1734),(16652,1734),(16653,1735),(16654,1735),(16655,1735),(16656,1735),(16657,1735),(16658,1735),(16659,1736),(16660,1736),(16661,1736),(16662,1736),(16663,1736),(16664,1736),(16665,1737),(16666,1737),(16667,1737),(16668,1737),(16669,1737),(16670,1737),(16671,1738),(16672,1738),(16673,1738),(16674,1738),(16675,1738),(16676,1738),(16677,1739),(16678,1739),(16679,1739),(16680,1739),(16681,1739),(16682,1739),(16683,1740),(16684,1740),(16685,1740),(16686,1740),(16687,1740),(16688,1740),(16689,1741),(16690,1741),(16691,1741),(16692,1741),(16693,1741),(16694,1741),(16695,1742),(16696,1742),(16697,1742),(16698,1742),(16699,1742),(16700,1742),(16701,1743),(16702,1743),(16703,1743),(16704,1743),(16705,1743),(16706,1743),(16707,1744),(16708,1744),(16709,1744),(16710,1744),(16711,1744),(16712,1744),(16713,1745),(16714,1745),(16715,1745),(16716,1745),(16717,1745),(16718,1745),(16719,1746),(16720,1746),(16721,1746),(16722,1746),(16723,1746),(16724,1746),(16725,1747),(16726,1748),(16727,1749),(16728,1750),(16729,1751),(16730,1752),(16731,1753),(16732,1754),(16733,1755),(16734,1756),(16735,1757),(16736,1758),(16737,1759),(16738,1760),(16739,1761),(16740,1762),(16741,1763),(16742,1764),(16743,1765),(16744,1766),(16745,1767),(16746,1768),(16747,1769),(16748,1770),(16749,1771),(16750,1772),(16751,1773),(16752,1774),(16753,1775),(16754,1776),(16755,1777),(16756,1778),(16757,1779),(16758,1780),(16759,1781),(16760,1782),(16761,1783),(16762,1784),(16763,1785),(16764,1786),(16765,1787),(16766,1788),(16767,1789),(16768,1790),(16769,1791),(16770,1792),(16771,1793),(16772,1794),(16773,1795),(16774,1796),(16775,1797),(16776,1798),(16777,1799),(16778,1800),(16779,1801),(16780,1802),(16781,1803),(16782,1804),(16783,1805),(16784,1806),(16785,1807),(16786,1808),(16787,1809),(16788,1810),(16789,1811),(16790,1812),(16791,1813),(16792,1814),(16793,1815),(16794,1816),(16795,1817),(16796,1818),(16797,1819),(16798,1820),(16799,1821),(16800,1822),(16801,1823),(16802,1824),(16803,1825),(16804,1826),(16805,1827),(16806,1828),(16807,1829),(16808,1830),(16809,1831),(16810,1832),(16811,1833),(16812,1834),(16813,1835),(16814,1836),(16815,1837),(16816,1838),(16817,1839),(16818,1840),(16819,1841),(16820,1842),(16821,1843),(16822,1844),(16823,1845),(16824,1846),(16825,1747),(16826,1747),(16827,1747),(16828,1748),(16829,1748),(16830,1748),(16831,1749),(16832,1750),(16833,1751),(16834,1752),(16835,1753),(16836,1754),(16837,1755),(16838,1756),(16839,1757),(16840,1758),(16841,1759),(16842,1760),(16843,1761),(16844,1762),(16845,1763),(16846,1764),(16847,1765),(16848,1765),(16849,1765),(16850,1766),(16851,1766),(16852,1766),(16853,1767),(16854,1767),(16855,1767),(16856,1768),(16857,1768),(16858,1768),(16859,1769),(16860,1769),(16861,1769),(16862,1770),(16863,1770),(16864,1770),(16865,1771),(16866,1771),(16867,1771),(16868,1772),(16869,1772),(16870,1772),(16871,1773),(16872,1773),(16873,1773),(16874,1774),(16875,1774),(16876,1774),(16877,1775),(16878,1775),(16879,1775),(16880,1776),(16881,1776),(16882,1776),(16883,1777),(16884,1777),(16885,1777),(16886,1778),(16887,1778),(16888,1778),(16889,1779),(16890,1779),(16891,1779),(16892,1780),(16893,1780),(16894,1780),(16895,1781),(16896,1781),(16897,1781),(16898,1781),(16899,1782),(16900,1782),(16901,1782),(16902,1782),(16903,1783),(16904,1783),(16905,1783),(16906,1783),(16907,1784),(16908,1784),(16909,1784),(16910,1784),(16911,1785),(16912,1785),(16913,1785),(16914,1785),(16915,1786),(16916,1786),(16917,1786),(16918,1786),(16919,1787),(16920,1787),(16921,1787),(16922,1787),(16923,1788),(16924,1788),(16925,1788),(16926,1788),(16927,1789),(16928,1789),(16929,1789),(16930,1789),(16931,1790),(16932,1790),(16933,1790),(16934,1790),(16935,1791),(16936,1791),(16937,1791),(16938,1791),(16939,1792),(16940,1792),(16941,1792),(16942,1792),(16943,1793),(16944,1793),(16945,1793),(16946,1793),(16947,1794),(16948,1794),(16949,1794),(16950,1794),(16951,1795),(16952,1795),(16953,1795),(16954,1795),(16955,1796),(16956,1796),(16957,1796),(16958,1796),(16959,1797),(16960,1797),(16961,1797),(16962,1797),(16963,1798),(16964,1798),(16965,1798),(16966,1798),(16967,1799),(16968,1799),(16969,1799),(16970,1799),(16971,1800),(16972,1800),(16973,1800),(16974,1800),(16975,1801),(16976,1801),(16977,1801),(16978,1801),(16979,1802),(16980,1802),(16981,1802),(16982,1802),(16983,1803),(16984,1803),(16985,1803),(16986,1803),(16987,1804),(16988,1804),(16989,1804),(16990,1804),(16991,1805),(16992,1805),(16993,1805),(16994,1805),(16995,1806),(16996,1806),(16997,1806),(16998,1806),(16999,1807),(17000,1807),(17001,1807),(17002,1807),(17003,1808),(17004,1808),(17005,1808),(17006,1808),(17007,1809),(17008,1809),(17009,1809),(17010,1809),(17011,1810),(17012,1810),(17013,1810),(17014,1810),(17015,1811),(17016,1811),(17017,1811),(17018,1811),(17019,1812),(17020,1812),(17021,1812),(17022,1812),(17023,1813),(17024,1813),(17025,1813),(17026,1813),(17027,1814),(17028,1814),(17029,1814),(17030,1814),(17031,1815),(17032,1815),(17033,1815),(17034,1815),(17035,1816),(17036,1816),(17037,1816),(17038,1816),(17039,1817),(17040,1817),(17041,1817),(17042,1817),(17043,1818),(17044,1818),(17045,1818),(17046,1818),(17047,1819),(17048,1819),(17049,1819),(17050,1819),(17051,1820),(17052,1820),(17053,1820),(17054,1820),(17055,1821),(17056,1821),(17057,1821),(17058,1821),(17059,1822),(17060,1822),(17061,1822),(17062,1822),(17063,1823),(17064,1823),(17065,1823),(17066,1823),(17067,1824),(17068,1824),(17069,1824),(17070,1824),(17071,1825),(17072,1825),(17073,1825),(17074,1825),(17075,1826),(17076,1826),(17077,1826),(17078,1826),(17079,1827),(17080,1827),(17081,1827),(17082,1827),(17083,1828),(17084,1828),(17085,1828),(17086,1828),(17087,1829),(17088,1829),(17089,1829),(17090,1829),(17091,1830),(17092,1830),(17093,1830),(17094,1830),(17095,1831),(17096,1831),(17097,1831),(17098,1831),(17099,1832),(17100,1832),(17101,1832),(17102,1832),(17103,1833),(17104,1833),(17105,1833),(17106,1833),(17107,1834),(17108,1834),(17109,1834),(17110,1835),(17111,1835),(17112,1835),(17113,1836),(17114,1836),(17115,1836),(17116,1837),(17117,1837),(17118,1837),(17119,1838),(17120,1838),(17121,1838),(17122,1839),(17123,1839),(17124,1839),(17125,1840),(17126,1840),(17127,1840),(17128,1841),(17129,1841),(17130,1841),(17131,1841),(17132,1842),(17133,1842),(17134,1842),(17135,1842),(17136,1843),(17137,1843),(17138,1843),(17139,1843),(17140,1844),(17141,1844),(17142,1844),(17143,1844),(17144,1845),(17145,1845),(17146,1845),(17147,1845),(17148,1846),(17149,1846),(17150,1846),(17151,1846),(17152,1747),(17153,1747),(17154,1747),(17155,1747),(17156,1747),(17157,1747),(17158,1748),(17159,1748),(17160,1748),(17161,1748),(17162,1748),(17163,1748),(17164,1748),(17165,1748),(17166,1748),(17167,1749),(17168,1749),(17169,1749),(17170,1749),(17171,1749),(17172,1749),(17173,1750),(17174,1750),(17175,1750),(17176,1750),(17177,1750),(17178,1750),(17179,1751),(17180,1751),(17181,1751),(17182,1751),(17183,1751),(17184,1751),(17185,1752),(17186,1752),(17187,1752),(17188,1752),(17189,1752),(17190,1752),(17191,1753),(17192,1753),(17193,1753),(17194,1753),(17195,1753),(17196,1753),(17197,1754),(17198,1754),(17199,1754),(17200,1754),(17201,1754),(17202,1754),(17203,1755),(17204,1755),(17205,1755),(17206,1755),(17207,1755),(17208,1755),(17209,1756),(17210,1756),(17211,1756),(17212,1756),(17213,1756),(17214,1756),(17215,1757),(17216,1757),(17217,1757),(17218,1757),(17219,1757),(17220,1757),(17221,1758),(17222,1758),(17223,1758),(17224,1758),(17225,1758),(17226,1758),(17227,1759),(17228,1759),(17229,1759),(17230,1759),(17231,1759),(17232,1759),(17233,1760),(17234,1760),(17235,1760),(17236,1760),(17237,1760),(17238,1760),(17239,1761),(17240,1761),(17241,1761),(17242,1761),(17243,1761),(17244,1761),(17245,1762),(17246,1762),(17247,1762),(17248,1762),(17249,1762),(17250,1762),(17251,1763),(17252,1763),(17253,1763),(17254,1763),(17255,1763),(17256,1763),(17257,1764),(17258,1764),(17259,1764),(17260,1764),(17261,1764),(17262,1764),(17263,1764),(17264,1764),(17265,1764),(17266,1765),(17267,1765),(17268,1765),(17269,1765),(17270,1765),(17271,1765),(17272,1766),(17273,1766),(17274,1766),(17275,1766),(17276,1766),(17277,1766),(17278,1767),(17279,1767),(17280,1767),(17281,1767),(17282,1767),(17283,1767),(17284,1768),(17285,1768),(17286,1768),(17287,1768),(17288,1768),(17289,1768),(17290,1769),(17291,1769),(17292,1769),(17293,1769),(17294,1769),(17295,1769),(17296,1770),(17297,1770),(17298,1770),(17299,1770),(17300,1770),(17301,1770),(17302,1771),(17303,1771),(17304,1771),(17305,1771),(17306,1771),(17307,1771),(17308,1772),(17309,1772),(17310,1772),(17311,1772),(17312,1772),(17313,1772),(17314,1773),(17315,1773),(17316,1773),(17317,1773),(17318,1773),(17319,1773),(17320,1774),(17321,1774),(17322,1774),(17323,1774),(17324,1774),(17325,1774),(17326,1775),(17327,1775),(17328,1775),(17329,1775),(17330,1775),(17331,1775),(17332,1776),(17333,1776),(17334,1776),(17335,1776),(17336,1776),(17337,1776),(17338,1777),(17339,1777),(17340,1777),(17341,1777),(17342,1777),(17343,1777),(17344,1778),(17345,1778),(17346,1778),(17347,1778),(17348,1778),(17349,1778),(17350,1779),(17351,1779),(17352,1779),(17353,1779),(17354,1779),(17355,1779),(17356,1780),(17357,1780),(17358,1780),(17359,1780),(17360,1780),(17361,1780),(17362,1780),(17363,1780),(17364,1780),(17365,1781),(17366,1781),(17367,1781),(17368,1781),(17369,1781),(17370,1781),(17371,1782),(17372,1782),(17373,1782),(17374,1782),(17375,1782),(17376,1782),(17377,1783),(17378,1783),(17379,1783),(17380,1783),(17381,1783),(17382,1783),(17383,1784),(17384,1784),(17385,1784),(17386,1784),(17387,1784),(17388,1784),(17389,1785),(17390,1785),(17391,1785),(17392,1785),(17393,1785),(17394,1785),(17395,1786),(17396,1786),(17397,1786),(17398,1786),(17399,1786),(17400,1786),(17401,1787),(17402,1787),(17403,1787),(17404,1787),(17405,1787),(17406,1787),(17407,1788),(17408,1788),(17409,1788),(17410,1788),(17411,1788),(17412,1788),(17413,1789),(17414,1789),(17415,1789),(17416,1789),(17417,1789),(17418,1789),(17419,1790),(17420,1790),(17421,1790),(17422,1790),(17423,1790),(17424,1790),(17425,1791),(17426,1791),(17427,1791),(17428,1791),(17429,1791),(17430,1791),(17431,1792),(17432,1792),(17433,1792),(17434,1792),(17435,1792),(17436,1792),(17437,1793),(17438,1793),(17439,1793),(17440,1793),(17441,1793),(17442,1793),(17443,1794),(17444,1794),(17445,1794),(17446,1794),(17447,1794),(17448,1794),(17449,1795),(17450,1795),(17451,1795),(17452,1795),(17453,1795),(17454,1795),(17455,1796),(17456,1796),(17457,1796),(17458,1796),(17459,1796),(17460,1796),(17461,1796),(17462,1796),(17463,1796),(17464,1797),(17465,1797),(17466,1797),(17467,1797),(17468,1797),(17469,1797),(17470,1798),(17471,1798),(17472,1798),(17473,1798),(17474,1798),(17475,1798),(17476,1799),(17477,1799),(17478,1799),(17479,1799),(17480,1799),(17481,1799),(17482,1800),(17483,1800),(17484,1800),(17485,1800),(17486,1800),(17487,1800),(17488,1801),(17489,1801),(17490,1801),(17491,1801),(17492,1801),(17493,1801),(17494,1802),(17495,1802),(17496,1802),(17497,1802),(17498,1802),(17499,1802),(17500,1803),(17501,1803),(17502,1803),(17503,1803),(17504,1803),(17505,1803),(17506,1804),(17507,1804),(17508,1804),(17509,1804),(17510,1804),(17511,1804),(17512,1805),(17513,1805),(17514,1805),(17515,1805),(17516,1805),(17517,1805),(17518,1806),(17519,1806),(17520,1806),(17521,1806),(17522,1806),(17523,1806),(17524,1807),(17525,1807),(17526,1807),(17527,1807),(17528,1807),(17529,1807),(17530,1808),(17531,1808),(17532,1808),(17533,1808),(17534,1808),(17535,1808),(17536,1809),(17537,1809),(17538,1809),(17539,1809),(17540,1809),(17541,1809),(17542,1810),(17543,1810),(17544,1810),(17545,1810),(17546,1810),(17547,1810),(17548,1811),(17549,1811),(17550,1811),(17551,1811),(17552,1811),(17553,1811),(17554,1812),(17555,1812),(17556,1812),(17557,1812),(17558,1812),(17559,1812),(17560,1812),(17561,1812),(17562,1812),(17563,1813),(17564,1813),(17565,1813),(17566,1813),(17567,1813),(17568,1813),(17569,1814),(17570,1814),(17571,1814),(17572,1814),(17573,1814),(17574,1814),(17575,1815),(17576,1815),(17577,1815),(17578,1815),(17579,1815),(17580,1815),(17581,1816),(17582,1816),(17583,1816),(17584,1816),(17585,1816),(17586,1816),(17587,1817),(17588,1817),(17589,1817),(17590,1817),(17591,1817),(17592,1817),(17593,1818),(17594,1818),(17595,1818),(17596,1818),(17597,1818),(17598,1818),(17599,1819),(17600,1819),(17601,1819),(17602,1819),(17603,1819),(17604,1819),(17605,1819),(17606,1819),(17607,1819),(17608,1820),(17609,1820),(17610,1820),(17611,1820),(17612,1820),(17613,1820),(17614,1821),(17615,1821),(17616,1821),(17617,1821),(17618,1821),(17619,1821),(17620,1822),(17621,1822),(17622,1822),(17623,1822),(17624,1822),(17625,1822),(17626,1823),(17627,1823),(17628,1823),(17629,1823),(17630,1823),(17631,1823),(17632,1824),(17633,1824),(17634,1824),(17635,1824),(17636,1824),(17637,1824),(17638,1825),(17639,1825),(17640,1825),(17641,1825),(17642,1825),(17643,1825),(17644,1826),(17645,1826),(17646,1826),(17647,1826),(17648,1826),(17649,1826),(17650,1826),(17651,1826),(17652,1826),(17653,1827),(17654,1827),(17655,1827),(17656,1827),(17657,1827),(17658,1827),(17659,1828),(17660,1828),(17661,1828),(17662,1828),(17663,1828),(17664,1828),(17665,1829),(17666,1829),(17667,1829),(17668,1829),(17669,1829),(17670,1829),(17671,1830),(17672,1830),(17673,1830),(17674,1830),(17675,1830),(17676,1830),(17677,1831),(17678,1831),(17679,1831),(17680,1831),(17681,1831),(17682,1831),(17683,1832),(17684,1832),(17685,1832),(17686,1832),(17687,1832),(17688,1832),(17689,1833),(17690,1833),(17691,1833),(17692,1833),(17693,1833),(17694,1833),(17695,1833),(17696,1833),(17697,1833),(17698,1834),(17699,1834),(17700,1834),(17701,1834),(17702,1834),(17703,1834),(17704,1835),(17705,1835),(17706,1835),(17707,1835),(17708,1835),(17709,1835),(17710,1836),(17711,1836),(17712,1836),(17713,1836),(17714,1836),(17715,1836),(17716,1837),(17717,1837),(17718,1837),(17719,1837),(17720,1837),(17721,1837),(17722,1838),(17723,1838),(17724,1838),(17725,1838),(17726,1838),(17727,1838),(17728,1839),(17729,1839),(17730,1839),(17731,1839),(17732,1839),(17733,1839),(17734,1840),(17735,1840),(17736,1840),(17737,1840),(17738,1840),(17739,1840),(17740,1840),(17741,1840),(17742,1840),(17743,1841),(17744,1841),(17745,1841),(17746,1841),(17747,1841),(17748,1841),(17749,1842),(17750,1842),(17751,1842),(17752,1842),(17753,1842),(17754,1842),(17755,1843),(17756,1843),(17757,1843),(17758,1843),(17759,1843),(17760,1843),(17761,1844),(17762,1844),(17763,1844),(17764,1844),(17765,1844),(17766,1844),(17767,1845),(17768,1845),(17769,1845),(17770,1845),(17771,1845),(17772,1845),(17773,1846),(17774,1846),(17775,1846),(17776,1846),(17777,1846),(17778,1846),(17779,1847),(17780,1848),(17781,1849),(17782,1850),(17783,1851),(17784,1852),(17785,1853),(17786,1854),(17787,1855),(17788,1856),(17789,1857),(17790,1858),(17791,1859),(17792,1860),(17793,1861),(17794,1862),(17795,1863),(17796,1864),(17797,1865),(17798,1866),(17799,1867),(17800,1868),(17801,1869),(17802,1870),(17803,1871),(17804,1872),(17805,1873),(17806,1874),(17807,1875),(17808,1876),(17809,1877),(17810,1878),(17811,1879),(17812,1880),(17813,1881),(17814,1882),(17815,1883),(17816,1884),(17817,1885),(17818,1886),(17819,1887),(17820,1888),(17821,1889),(17822,1890),(17823,1891),(17824,1892),(17825,1893),(17826,1894),(17827,1895),(17828,1896),(17829,1897),(17830,1898),(17831,1899),(17832,1900),(17833,1901),(17834,1902),(17835,1903),(17836,1904),(17837,1905),(17838,1906),(17839,1907),(17840,1908),(17841,1909),(17842,1910),(17843,1911),(17844,1912),(17845,1913),(17846,1914),(17847,1915),(17848,1916),(17849,1917),(17850,1918),(17851,1919),(17852,1920),(17853,1921),(17854,1922),(17855,1923),(17856,1924),(17857,1925),(17858,1926),(17859,1927),(17860,1928),(17861,1929),(17862,1930),(17863,1931),(17864,1932),(17865,1933),(17866,1934),(17867,1935),(17868,1936),(17869,1937),(17870,1938),(17871,1939),(17872,1940),(17873,1941),(17874,1942),(17875,1943),(17876,1944),(17877,1945),(17878,1946),(17879,1847),(17880,1847),(17881,1847),(17882,1847),(17883,1848),(17884,1848),(17885,1848),(17886,1848),(17887,1849),(17888,1849),(17889,1849),(17890,1849),(17891,1850),(17892,1850),(17893,1850),(17894,1850),(17895,1851),(17896,1851),(17897,1851),(17898,1851),(17899,1852),(17900,1852),(17901,1852),(17902,1852),(17903,1853),(17904,1853),(17905,1853),(17906,1853),(17907,1854),(17908,1854),(17909,1854),(17910,1854),(17911,1855),(17912,1855),(17913,1855),(17914,1855),(17915,1856),(17916,1856),(17917,1856),(17918,1856),(17919,1857),(17920,1857),(17921,1857),(17922,1857),(17923,1858),(17924,1858),(17925,1858),(17926,1858),(17927,1859),(17928,1859),(17929,1859),(17930,1859),(17931,1860),(17932,1860),(17933,1860),(17934,1860),(17935,1861),(17936,1861),(17937,1861),(17938,1861),(17939,1862),(17940,1862),(17941,1862),(17942,1863),(17943,1863),(17944,1863),(17945,1864),(17946,1864),(17947,1864),(17948,1865),(17949,1865),(17950,1865),(17951,1866),(17952,1866),(17953,1866),(17954,1867),(17955,1867),(17956,1867),(17957,1868),(17958,1868),(17959,1868),(17960,1869),(17961,1869),(17962,1869),(17963,1870),(17964,1870),(17965,1870),(17966,1871),(17967,1871),(17968,1871),(17969,1872),(17970,1872),(17971,1872),(17972,1873),(17973,1873),(17974,1873),(17975,1874),(17976,1874),(17977,1874),(17978,1875),(17979,1875),(17980,1875),(17981,1876),(17982,1876),(17983,1876),(17984,1876),(17985,1877),(17986,1877),(17987,1877),(17988,1877),(17989,1878),(17990,1878),(17991,1878),(17992,1878),(17993,1879),(17994,1879),(17995,1879),(17996,1879),(17997,1880),(17998,1880),(17999,1880),(18000,1880),(18001,1881),(18002,1881),(18003,1881),(18004,1881),(18005,1882),(18006,1882),(18007,1882),(18008,1882),(18009,1883),(18010,1883),(18011,1883),(18012,1884),(18013,1884),(18014,1884),(18015,1885),(18016,1885),(18017,1885),(18018,1886),(18019,1886),(18020,1886),(18021,1887),(18022,1887),(18023,1887),(18024,1888),(18025,1888),(18026,1888),(18027,1889),(18028,1889),(18029,1889),(18030,1890),(18031,1890),(18032,1890),(18033,1890),(18034,1891),(18035,1891),(18036,1891),(18037,1891),(18038,1892),(18039,1892),(18040,1892),(18041,1892),(18042,1893),(18043,1893),(18044,1893),(18045,1893),(18046,1894),(18047,1894),(18048,1894),(18049,1894),(18050,1895),(18051,1895),(18052,1895),(18053,1895),(18054,1896),(18055,1896),(18056,1896),(18057,1896),(18058,1897),(18059,1897),(18060,1897),(18061,1897),(18062,1898),(18063,1898),(18064,1898),(18065,1898),(18066,1899),(18067,1899),(18068,1899),(18069,1899),(18070,1900),(18071,1900),(18072,1900),(18073,1900),(18074,1901),(18075,1901),(18076,1901),(18077,1901),(18078,1902),(18079,1902),(18080,1902),(18081,1902),(18082,1903),(18083,1903),(18084,1903),(18085,1903),(18086,1904),(18087,1904),(18088,1904),(18089,1904),(18090,1905),(18091,1905),(18092,1905),(18093,1905),(18094,1906),(18095,1906),(18096,1906),(18097,1906),(18098,1907),(18099,1907),(18100,1907),(18101,1907),(18102,1908),(18103,1908),(18104,1908),(18105,1908),(18106,1909),(18107,1909),(18108,1909),(18109,1909),(18110,1910),(18111,1910),(18112,1910),(18113,1910),(18114,1911),(18115,1911),(18116,1911),(18117,1911),(18118,1912),(18119,1912),(18120,1912),(18121,1912),(18122,1913),(18123,1913),(18124,1913),(18125,1913),(18126,1914),(18127,1914),(18128,1914),(18129,1914),(18130,1915),(18131,1915),(18132,1915),(18133,1915),(18134,1916),(18135,1916),(18136,1916),(18137,1916),(18138,1917),(18139,1917),(18140,1917),(18141,1917),(18142,1918),(18143,1918),(18144,1918),(18145,1918),(18146,1919),(18147,1919),(18148,1919),(18149,1919),(18150,1920),(18151,1920),(18152,1920),(18153,1921),(18154,1921),(18155,1921),(18156,1922),(18157,1922),(18158,1922),(18159,1923),(18160,1923),(18161,1923),(18162,1924),(18163,1924),(18164,1924),(18165,1925),(18166,1925),(18167,1925),(18168,1926),(18169,1926),(18170,1926),(18171,1927),(18172,1927),(18173,1927),(18174,1928),(18175,1928),(18176,1928),(18177,1929),(18178,1929),(18179,1929),(18180,1930),(18181,1930),(18182,1930),(18183,1931),(18184,1931),(18185,1931),(18186,1932),(18187,1932),(18188,1932),(18189,1933),(18190,1933),(18191,1933),(18192,1934),(18193,1934),(18194,1934),(18195,1935),(18196,1935),(18197,1935),(18198,1936),(18199,1936),(18200,1936),(18201,1936),(18202,1937),(18203,1937),(18204,1937),(18205,1937),(18206,1938),(18207,1938),(18208,1938),(18209,1938),(18210,1939),(18211,1939),(18212,1939),(18213,1939),(18214,1940),(18215,1940),(18216,1940),(18217,1940),(18218,1941),(18219,1941),(18220,1941),(18221,1941),(18222,1942),(18223,1942),(18224,1942),(18225,1942),(18226,1943),(18227,1943),(18228,1943),(18229,1943),(18230,1944),(18231,1944),(18232,1944),(18233,1944),(18234,1945),(18235,1945),(18236,1945),(18237,1945),(18238,1946),(18239,1946),(18240,1946),(18241,1946),(18242,1847),(18243,1847),(18244,1847),(18245,1847),(18246,1847),(18247,1847),(18248,1847),(18249,1847),(18250,1847),(18251,1848),(18252,1848),(18253,1848),(18254,1848),(18255,1848),(18256,1848),(18257,1849),(18258,1849),(18259,1849),(18260,1849),(18261,1849),(18262,1849),(18263,1850),(18264,1850),(18265,1850),(18266,1850),(18267,1850),(18268,1850),(18269,1851),(18270,1851),(18271,1851),(18272,1851),(18273,1851),(18274,1851),(18275,1852),(18276,1852),(18277,1852),(18278,1852),(18279,1852),(18280,1852),(18281,1853),(18282,1853),(18283,1853),(18284,1853),(18285,1853),(18286,1853),(18287,1854),(18288,1854),(18289,1854),(18290,1854),(18291,1854),(18292,1854),(18293,1854),(18294,1854),(18295,1854),(18296,1855),(18297,1855),(18298,1855),(18299,1855),(18300,1855),(18301,1855),(18302,1856),(18303,1856),(18304,1856),(18305,1856),(18306,1856),(18307,1856),(18308,1857),(18309,1857),(18310,1857),(18311,1857),(18312,1857),(18313,1857),(18314,1858),(18315,1858),(18316,1858),(18317,1858),(18318,1858),(18319,1858),(18320,1859),(18321,1859),(18322,1859),(18323,1859),(18324,1859),(18325,1859),(18326,1860),(18327,1860),(18328,1860),(18329,1860),(18330,1860),(18331,1860),(18332,1861),(18333,1861),(18334,1861),(18335,1861),(18336,1861),(18337,1861),(18338,1861),(18339,1861),(18340,1861),(18341,1862),(18342,1862),(18343,1862),(18344,1862),(18345,1862),(18346,1862),(18347,1863),(18348,1863),(18349,1863),(18350,1863),(18351,1863),(18352,1863),(18353,1864),(18354,1864),(18355,1864),(18356,1864),(18357,1864),(18358,1864),(18359,1865),(18360,1865),(18361,1865),(18362,1865),(18363,1865),(18364,1865),(18365,1866),(18366,1866),(18367,1866),(18368,1866),(18369,1866),(18370,1866),(18371,1867),(18372,1867),(18373,1867),(18374,1867),(18375,1867),(18376,1867),(18377,1868),(18378,1868),(18379,1868),(18380,1868),(18381,1868),(18382,1868),(18383,1868),(18384,1868),(18385,1868),(18386,1869),(18387,1869),(18388,1869),(18389,1869),(18390,1869),(18391,1869),(18392,1870),(18393,1870),(18394,1870),(18395,1870),(18396,1870),(18397,1870),(18398,1871),(18399,1871),(18400,1871),(18401,1871),(18402,1871),(18403,1871),(18404,1872),(18405,1872),(18406,1872),(18407,1872),(18408,1872),(18409,1872),(18410,1873),(18411,1873),(18412,1873),(18413,1873),(18414,1873),(18415,1873),(18416,1874),(18417,1874),(18418,1874),(18419,1874),(18420,1874),(18421,1874),(18422,1875),(18423,1875),(18424,1875),(18425,1875),(18426,1875),(18427,1875),(18428,1875),(18429,1875),(18430,1875),(18431,1876),(18432,1876),(18433,1876),(18434,1876),(18435,1876),(18436,1876),(18437,1877),(18438,1877),(18439,1877),(18440,1877),(18441,1877),(18442,1877),(18443,1878),(18444,1878),(18445,1878),(18446,1878),(18447,1878),(18448,1878),(18449,1879),(18450,1879),(18451,1879),(18452,1879),(18453,1879),(18454,1879),(18455,1880),(18456,1880),(18457,1880),(18458,1880),(18459,1880),(18460,1880),(18461,1881),(18462,1881),(18463,1881),(18464,1881),(18465,1881),(18466,1881),(18467,1882),(18468,1882),(18469,1882),(18470,1882),(18471,1882),(18472,1882),(18473,1882),(18474,1882),(18475,1882),(18476,1883),(18477,1883),(18478,1883),(18479,1883),(18480,1883),(18481,1883),(18482,1884),(18483,1884),(18484,1884),(18485,1884),(18486,1884),(18487,1884),(18488,1885),(18489,1885),(18490,1885),(18491,1885),(18492,1885),(18493,1885),(18494,1886),(18495,1886),(18496,1886),(18497,1886),(18498,1886),(18499,1886),(18500,1887),(18501,1887),(18502,1887),(18503,1887),(18504,1887),(18505,1887),(18506,1888),(18507,1888),(18508,1888),(18509,1888),(18510,1888),(18511,1888),(18512,1889),(18513,1889),(18514,1889),(18515,1889),(18516,1889),(18517,1889),(18518,1889),(18519,1889),(18520,1889),(18521,1890),(18522,1890),(18523,1890),(18524,1890),(18525,1890),(18526,1890),(18527,1891),(18528,1891),(18529,1891),(18530,1891),(18531,1891),(18532,1891),(18533,1892),(18534,1892),(18535,1892),(18536,1892),(18537,1892),(18538,1892),(18539,1893),(18540,1893),(18541,1893),(18542,1893),(18543,1893),(18544,1893),(18545,1894),(18546,1894),(18547,1894),(18548,1894),(18549,1894),(18550,1894),(18551,1895),(18552,1895),(18553,1895),(18554,1895),(18555,1895),(18556,1895),(18557,1896),(18558,1896),(18559,1896),(18560,1896),(18561,1896),(18562,1896),(18563,1896),(18564,1896),(18565,1896),(18566,1897),(18567,1897),(18568,1897),(18569,1897),(18570,1897),(18571,1897),(18572,1898),(18573,1898),(18574,1898),(18575,1898),(18576,1898),(18577,1898),(18578,1899),(18579,1899),(18580,1899),(18581,1899),(18582,1899),(18583,1899),(18584,1900),(18585,1900),(18586,1900),(18587,1900),(18588,1900),(18589,1900),(18590,1901),(18591,1901),(18592,1901),(18593,1901),(18594,1901),(18595,1901),(18596,1902),(18597,1902),(18598,1902),(18599,1902),(18600,1902),(18601,1902),(18602,1903),(18603,1903),(18604,1903),(18605,1903),(18606,1903),(18607,1903),(18608,1903),(18609,1903),(18610,1903),(18611,1904),(18612,1904),(18613,1904),(18614,1904),(18615,1904),(18616,1904),(18617,1905),(18618,1905),(18619,1905),(18620,1905),(18621,1905),(18622,1905),(18623,1906),(18624,1906),(18625,1906),(18626,1906),(18627,1906),(18628,1906),(18629,1907),(18630,1907),(18631,1907),(18632,1907),(18633,1907),(18634,1907),(18635,1908),(18636,1908),(18637,1908),(18638,1908),(18639,1908),(18640,1908),(18641,1909),(18642,1909),(18643,1909),(18644,1909),(18645,1909),(18646,1909),(18647,1910),(18648,1910),(18649,1910),(18650,1910),(18651,1910),(18652,1910),(18653,1911),(18654,1911),(18655,1911),(18656,1911),(18657,1911),(18658,1911),(18659,1912),(18660,1912),(18661,1912),(18662,1912),(18663,1912),(18664,1912),(18665,1913),(18666,1913),(18667,1913),(18668,1913),(18669,1913),(18670,1913),(18671,1914),(18672,1914),(18673,1914),(18674,1914),(18675,1914),(18676,1914),(18677,1915),(18678,1915),(18679,1915),(18680,1915),(18681,1915),(18682,1915),(18683,1916),(18684,1916),(18685,1916),(18686,1916),(18687,1916),(18688,1916),(18689,1917),(18690,1917),(18691,1917),(18692,1917),(18693,1917),(18694,1917),(18695,1918),(18696,1918),(18697,1918),(18698,1918),(18699,1918),(18700,1918),(18701,1919),(18702,1919),(18703,1919),(18704,1919),(18705,1919),(18706,1919),(18707,1919),(18708,1919),(18709,1919),(18710,1920),(18711,1920),(18712,1920),(18713,1920),(18714,1920),(18715,1920),(18716,1921),(18717,1921),(18718,1921),(18719,1921),(18720,1921),(18721,1921),(18722,1922),(18723,1922),(18724,1922),(18725,1922),(18726,1922),(18727,1922),(18728,1923),(18729,1923),(18730,1923),(18731,1923),(18732,1923),(18733,1923),(18734,1924),(18735,1924),(18736,1924),(18737,1924),(18738,1924),(18739,1924),(18740,1925),(18741,1925),(18742,1925),(18743,1925),(18744,1925),(18745,1925),(18746,1926),(18747,1926),(18748,1926),(18749,1926),(18750,1926),(18751,1926),(18752,1927),(18753,1927),(18754,1927),(18755,1927),(18756,1927),(18757,1927),(18758,1928),(18759,1928),(18760,1928),(18761,1928),(18762,1928),(18763,1928),(18764,1929),(18765,1929),(18766,1929),(18767,1929),(18768,1929),(18769,1929),(18770,1930),(18771,1930),(18772,1930),(18773,1930),(18774,1930),(18775,1930),(18776,1931),(18777,1931),(18778,1931),(18779,1931),(18780,1931),(18781,1931),(18782,1932),(18783,1932),(18784,1932),(18785,1932),(18786,1932),(18787,1932),(18788,1933),(18789,1933),(18790,1933),(18791,1933),(18792,1933),(18793,1933),(18794,1934),(18795,1934),(18796,1934),(18797,1934),(18798,1934),(18799,1934),(18800,1935),(18801,1935),(18802,1935),(18803,1935),(18804,1935),(18805,1935),(18806,1935),(18807,1935),(18808,1935),(18809,1936),(18810,1936),(18811,1936),(18812,1936),(18813,1936),(18814,1936),(18815,1937),(18816,1937),(18817,1937),(18818,1937),(18819,1937),(18820,1937),(18821,1938),(18822,1938),(18823,1938),(18824,1938),(18825,1938),(18826,1938),(18827,1939),(18828,1939),(18829,1939),(18830,1939),(18831,1939),(18832,1939),(18833,1940),(18834,1940),(18835,1940),(18836,1940),(18837,1940),(18838,1940),(18839,1941),(18840,1941),(18841,1941),(18842,1941),(18843,1941),(18844,1941),(18845,1942),(18846,1942),(18847,1942),(18848,1942),(18849,1942),(18850,1942),(18851,1943),(18852,1943),(18853,1943),(18854,1943),(18855,1943),(18856,1943),(18857,1944),(18858,1944),(18859,1944),(18860,1944),(18861,1944),(18862,1944),(18863,1945),(18864,1945),(18865,1945),(18866,1945),(18867,1945),(18868,1945),(18869,1946),(18870,1946),(18871,1946),(18872,1946),(18873,1946),(18874,1946),(18875,1947),(18876,1948),(18877,1949),(18878,1950),(18879,1951),(18880,1952),(18881,1953),(18882,1954),(18883,1955),(18884,1956),(18885,1957),(18886,1958),(18887,1959),(18888,1960),(18889,1961),(18890,1962),(18891,1963),(18892,1964),(18893,1965),(18894,1966),(18895,1967),(18896,1968),(18897,1969),(18898,1970),(18899,1971),(18900,1972),(18901,1973),(18902,1974),(18903,1975),(18904,1976),(18905,1977),(18906,1978),(18907,1979),(18908,1980),(18909,1981),(18910,1982),(18911,1983),(18912,1984),(18913,1985),(18914,1986),(18915,1987),(18916,1988),(18917,1989),(18918,1990),(18919,1991),(18920,1992),(18921,1993),(18922,1994),(18923,1995),(18924,1996),(18925,1997),(18926,1998),(18927,1999),(18928,2000),(18929,2001),(18930,2002),(18931,2003),(18932,2004),(18933,2005),(18934,2006),(18935,2007),(18936,2008),(18937,2009),(18938,2010),(18939,2011),(18940,2012),(18941,2013),(18942,2014),(18943,2015),(18944,2016),(18945,2017),(18946,2018),(18947,2019),(18948,2020),(18949,2021),(18950,2022),(18951,2023),(18952,2024),(18953,2025),(18954,2026),(18955,2027),(18956,2028),(18957,2029),(18958,2030),(18959,2031),(18960,2032),(18961,2033),(18962,2034),(18963,2035),(18964,2036),(18965,2037),(18966,2038),(18967,2039),(18968,2040),(18969,1947),(18970,1947),(18971,1947),(18972,1947),(18973,1948),(18974,1948),(18975,1948),(18976,1948),(18977,1949),(18978,1949),(18979,1949),(18980,1949),(18981,1950),(18982,1950),(18983,1950),(18984,1950),(18985,1951),(18986,1951),(18987,1951),(18988,1951),(18989,1952),(18990,1953),(18991,1954),(18992,1955),(18993,1956),(18994,1957),(18995,1958),(18996,1959),(18997,1960),(18998,1961),(18999,1962),(19000,1963),(19001,1964),(19002,1965),(19003,1966),(19004,1967),(19005,1968),(19006,1968),(19007,1968),(19008,1969),(19009,1969),(19010,1969),(19011,1970),(19012,1970),(19013,1970),(19014,1971),(19015,1971),(19016,1971),(19017,1972),(19018,1972),(19019,1972),(19020,1973),(19021,1973),(19022,1973),(19023,1974),(19024,1974),(19025,1974),(19026,1975),(19027,1975),(19028,1975),(19029,1976),(19030,1976),(19031,1976),(19032,1977),(19033,1977),(19034,1977),(19035,1978),(19036,1978),(19037,1978),(19038,1979),(19039,1979),(19040,1979),(19041,1980),(19042,1980),(19043,1980),(19044,1981),(19045,1981),(19046,1981),(19047,1982),(19048,1982),(19049,1982),(19050,1983),(19051,1983),(19052,1983),(19053,1984),(19054,1985),(19055,1986),(19056,1987),(19057,1988),(19058,1989),(19059,1990),(19060,1991),(19061,1991),(19062,1991),(19063,1992),(19064,1992),(19065,1992),(19066,1993),(19067,1993),(19068,1993),(19069,1994),(19070,1994),(19071,1994),(19072,1995),(19073,1995),(19074,1995),(19075,1996),(19076,1996),(19077,1996),(19078,1997),(19079,1997),(19080,1997),(19081,1998),(19082,1998),(19083,1998),(19084,1999),(19085,1999),(19086,1999),(19087,2000),(19088,2000),(19089,2000),(19090,2001),(19091,2001),(19092,2001),(19093,2002),(19094,2002),(19095,2002),(19096,2003),(19097,2003),(19098,2003),(19099,2004),(19100,2005),(19101,2006),(19102,2007),(19103,2008),(19104,2009),(19105,2010),(19106,2011),(19107,2011),(19108,2011),(19109,2012),(19110,2012),(19111,2012),(19112,2013),(19113,2013),(19114,2013),(19115,2014),(19116,2014),(19117,2014),(19118,2015),(19119,2015),(19120,2015),(19121,2016),(19122,2016),(19123,2016),(19124,2017),(19125,2017),(19126,2017),(19127,2018),(19128,2018),(19129,2018),(19130,2019),(19131,2019),(19132,2019),(19133,2020),(19134,2020),(19135,2020),(19136,2021),(19137,2021),(19138,2021),(19139,2022),(19140,2022),(19141,2022),(19142,2023),(19143,2023),(19144,2023),(19145,2024),(19146,2024),(19147,2024),(19148,2025),(19149,2025),(19150,2025),(19151,2026),(19152,2026),(19153,2026),(19154,2027),(19155,2027),(19156,2027),(19157,2028),(19158,2028),(19159,2028),(19160,2029),(19161,2029),(19162,2029),(19163,2030),(19164,2030),(19165,2030),(19166,2031),(19167,2031),(19168,2031),(19169,2032),(19170,2032),(19171,2032),(19172,2033),(19173,2033),(19174,2033),(19175,2034),(19176,2034),(19177,2034),(19178,2035),(19179,2035),(19180,2035),(19181,2036),(19182,2036),(19183,2036),(19184,2037),(19185,2037),(19186,2037),(19187,2038),(19188,2038),(19189,2038),(19190,2039),(19191,2039),(19192,2039),(19193,2040),(19194,2040),(19195,2040),(19196,1947),(19197,1947),(19198,1947),(19199,1947),(19200,1947),(19201,1947),(19202,1948),(19203,1948),(19204,1948),(19205,1948),(19206,1948),(19207,1948),(19208,1949),(19209,1949),(19210,1949),(19211,1949),(19212,1949),(19213,1949),(19214,1950),(19215,1950),(19216,1950),(19217,1950),(19218,1950),(19219,1950),(19220,1951),(19221,1951),(19222,1951),(19223,1951),(19224,1951),(19225,1951),(19226,1951),(19227,1951),(19228,1951),(19229,1952),(19230,1952),(19231,1952),(19232,1952),(19233,1952),(19234,1952),(19235,1953),(19236,1953),(19237,1953),(19238,1953),(19239,1953),(19240,1953),(19241,1954),(19242,1954),(19243,1954),(19244,1954),(19245,1954),(19246,1954),(19247,1955),(19248,1955),(19249,1955),(19250,1955),(19251,1955),(19252,1955),(19253,1956),(19254,1956),(19255,1956),(19256,1956),(19257,1956),(19258,1956),(19259,1957),(19260,1957),(19261,1957),(19262,1957),(19263,1957),(19264,1957),(19265,1958),(19266,1958),(19267,1958),(19268,1958),(19269,1958),(19270,1958),(19271,1959),(19272,1959),(19273,1959),(19274,1959),(19275,1959),(19276,1959),(19277,1960),(19278,1960),(19279,1960),(19280,1960),(19281,1960),(19282,1960),(19283,1961),(19284,1961),(19285,1961),(19286,1961),(19287,1961),(19288,1961),(19289,1962),(19290,1962),(19291,1962),(19292,1962),(19293,1962),(19294,1962),(19295,1963),(19296,1963),(19297,1963),(19298,1963),(19299,1963),(19300,1963),(19301,1964),(19302,1964),(19303,1964),(19304,1964),(19305,1964),(19306,1964),(19307,1965),(19308,1965),(19309,1965),(19310,1965),(19311,1965),(19312,1965),(19313,1966),(19314,1966),(19315,1966),(19316,1966),(19317,1966),(19318,1966),(19319,1967),(19320,1967),(19321,1967),(19322,1967),(19323,1967),(19324,1967),(19325,1967),(19326,1967),(19327,1967),(19328,1968),(19329,1968),(19330,1968),(19331,1968),(19332,1968),(19333,1968),(19334,1969),(19335,1969),(19336,1969),(19337,1969),(19338,1969),(19339,1969),(19340,1970),(19341,1970),(19342,1970),(19343,1970),(19344,1970),(19345,1970),(19346,1971),(19347,1971),(19348,1971),(19349,1971),(19350,1971),(19351,1971),(19352,1972),(19353,1972),(19354,1972),(19355,1972),(19356,1972),(19357,1972),(19358,1973),(19359,1973),(19360,1973),(19361,1973),(19362,1973),(19363,1973),(19364,1974),(19365,1974),(19366,1974),(19367,1974),(19368,1974),(19369,1974),(19370,1975),(19371,1975),(19372,1975),(19373,1975),(19374,1975),(19375,1975),(19376,1976),(19377,1976),(19378,1976),(19379,1976),(19380,1976),(19381,1976),(19382,1977),(19383,1977),(19384,1977),(19385,1977),(19386,1977),(19387,1977),(19388,1978),(19389,1978),(19390,1978),(19391,1978),(19392,1978),(19393,1978),(19394,1979),(19395,1979),(19396,1979),(19397,1979),(19398,1979),(19399,1979),(19400,1980),(19401,1980),(19402,1980),(19403,1980),(19404,1980),(19405,1980),(19406,1981),(19407,1981),(19408,1981),(19409,1981),(19410,1981),(19411,1981),(19412,1982),(19413,1982),(19414,1982),(19415,1982),(19416,1982),(19417,1982),(19418,1983),(19419,1983),(19420,1983),(19421,1983),(19422,1983),(19423,1983),(19424,1983),(19425,1983),(19426,1983),(19427,1984),(19428,1984),(19429,1984),(19430,1984),(19431,1984),(19432,1984),(19433,1985),(19434,1985),(19435,1985),(19436,1985),(19437,1985),(19438,1985),(19439,1986),(19440,1986),(19441,1986),(19442,1986),(19443,1986),(19444,1986),(19445,1987),(19446,1987),(19447,1987),(19448,1987),(19449,1987),(19450,1987),(19451,1988),(19452,1988),(19453,1988),(19454,1988),(19455,1988),(19456,1988),(19457,1989),(19458,1989),(19459,1989),(19460,1989),(19461,1989),(19462,1989),(19463,1990),(19464,1990),(19465,1990),(19466,1990),(19467,1990),(19468,1990),(19469,1990),(19470,1990),(19471,1990),(19472,1991),(19473,1991),(19474,1991),(19475,1991),(19476,1991),(19477,1991),(19478,1992),(19479,1992),(19480,1992),(19481,1992),(19482,1992),(19483,1992),(19484,1993),(19485,1993),(19486,1993),(19487,1993),(19488,1993),(19489,1993),(19490,1994),(19491,1994),(19492,1994),(19493,1994),(19494,1994),(19495,1994),(19496,1995),(19497,1995),(19498,1995),(19499,1995),(19500,1995),(19501,1995),(19502,1996),(19503,1996),(19504,1996),(19505,1996),(19506,1996),(19507,1996),(19508,1997),(19509,1997),(19510,1997),(19511,1997),(19512,1997),(19513,1997),(19514,1997),(19515,1997),(19516,1997),(19517,1998),(19518,1998),(19519,1998),(19520,1998),(19521,1998),(19522,1998),(19523,1999),(19524,1999),(19525,1999),(19526,1999),(19527,1999),(19528,1999),(19529,2000),(19530,2000),(19531,2000),(19532,2000),(19533,2000),(19534,2000),(19535,2001),(19536,2001),(19537,2001),(19538,2001),(19539,2001),(19540,2001),(19541,2002),(19542,2002),(19543,2002),(19544,2002),(19545,2002),(19546,2002),(19547,2003),(19548,2003),(19549,2003),(19550,2003),(19551,2003),(19552,2003),(19553,2003),(19554,2003),(19555,2003),(19556,2004),(19557,2004),(19558,2004),(19559,2004),(19560,2004),(19561,2004),(19562,2005),(19563,2005),(19564,2005),(19565,2005),(19566,2005),(19567,2005),(19568,2006),(19569,2006),(19570,2006),(19571,2006),(19572,2006),(19573,2006),(19574,2007),(19575,2007),(19576,2007),(19577,2007),(19578,2007),(19579,2007),(19580,2008),(19581,2008),(19582,2008),(19583,2008),(19584,2008),(19585,2008),(19586,2009),(19587,2009),(19588,2009),(19589,2009),(19590,2009),(19591,2009),(19592,2010),(19593,2010),(19594,2010),(19595,2010),(19596,2010),(19597,2010),(19598,2010),(19599,2010),(19600,2010),(19601,2011),(19602,2011),(19603,2011),(19604,2011),(19605,2011),(19606,2011),(19607,2012),(19608,2012),(19609,2012),(19610,2012),(19611,2012),(19612,2012),(19613,2013),(19614,2013),(19615,2013),(19616,2013),(19617,2013),(19618,2013),(19619,2014),(19620,2014),(19621,2014),(19622,2014),(19623,2014),(19624,2014),(19625,2015),(19626,2015),(19627,2015),(19628,2015),(19629,2015),(19630,2015),(19631,2016),(19632,2016),(19633,2016),(19634,2016),(19635,2016),(19636,2016),(19637,2017),(19638,2017),(19639,2017),(19640,2017),(19641,2017),(19642,2017),(19643,2017),(19644,2017),(19645,2017),(19646,2018),(19647,2018),(19648,2018),(19649,2018),(19650,2018),(19651,2018),(19652,2019),(19653,2019),(19654,2019),(19655,2019),(19656,2019),(19657,2019),(19658,2020),(19659,2020),(19660,2020),(19661,2020),(19662,2020),(19663,2020),(19664,2021),(19665,2021),(19666,2021),(19667,2021),(19668,2021),(19669,2021),(19670,2022),(19671,2022),(19672,2022),(19673,2022),(19674,2022),(19675,2022),(19676,2023),(19677,2023),(19678,2023),(19679,2023),(19680,2023),(19681,2023),(19682,2024),(19683,2024),(19684,2024),(19685,2024),(19686,2024),(19687,2024),(19688,2024),(19689,2024),(19690,2024),(19691,2025),(19692,2025),(19693,2025),(19694,2025),(19695,2025),(19696,2025),(19697,2026),(19698,2026),(19699,2026),(19700,2026),(19701,2026),(19702,2026),(19703,2027),(19704,2027),(19705,2027),(19706,2027),(19707,2027),(19708,2027),(19709,2028),(19710,2028),(19711,2028),(19712,2028),(19713,2028),(19714,2028),(19715,2029),(19716,2029),(19717,2029),(19718,2029),(19719,2029),(19720,2029),(19721,2030),(19722,2030),(19723,2030),(19724,2030),(19725,2030),(19726,2030),(19727,2031),(19728,2031),(19729,2031),(19730,2031),(19731,2031),(19732,2031),(19733,2032),(19734,2032),(19735,2032),(19736,2032),(19737,2032),(19738,2032),(19739,2033),(19740,2033),(19741,2033),(19742,2033),(19743,2033),(19744,2033),(19745,2034),(19746,2034),(19747,2034),(19748,2034),(19749,2034),(19750,2034),(19751,2035),(19752,2035),(19753,2035),(19754,2035),(19755,2035),(19756,2035),(19757,2036),(19758,2036),(19759,2036),(19760,2036),(19761,2036),(19762,2036),(19763,2037),(19764,2037),(19765,2037),(19766,2037),(19767,2037),(19768,2037),(19769,2038),(19770,2038),(19771,2038),(19772,2038),(19773,2038),(19774,2038),(19775,2039),(19776,2039),(19777,2039),(19778,2039),(19779,2039),(19780,2039),(19781,2040),(19782,2040),(19783,2040),(19784,2040),(19785,2040),(19786,2040),(19787,2040),(19788,2040),(19789,2040),(19790,1220),(19791,1220),(19792,1220),(19793,1236),(19794,1236),(19795,1236),(19796,1252),(19797,1252),(19798,1252),(19799,1268),(19800,1268),(19801,1268),(19802,1284),(19803,1284),(19804,1284),(19805,1380),(19806,1380),(19807,1380),(19808,1300),(19809,1300),(19810,1300),(19811,1316),(19812,1316),(19813,1316),(19814,1332),(19815,1332),(19816,1332),(19817,1348),(19818,1348),(19819,1348),(19820,1364),(19821,1364),(19822,1364),(19823,1396),(19824,1396),(19825,1396);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_category_cl` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_entity`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_entity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_product_entity` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `attribute_set_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute Set ID',
  `type_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'simple' COMMENT 'Type ID',
  `sku` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'SKU',
  `has_options` smallint NOT NULL DEFAULT '0' COMMENT 'Has Options',
  `required_options` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Required Options',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  PRIMARY KEY (`entity_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_ATTRIBUTE_SET_ID` (`attribute_set_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_SKU` (`sku`)
) ENGINE=InnoDB AUTO_INCREMENT=2041 DEFAULT CHARSET=utf8mb4 COMMENT='Catalog Product Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_entity`
--

LOCK TABLES `[[dbprefix]]catalog_product_entity` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_product_entity` VALUES (1,15,'simple','24-MB01',0,0,'[[regtime]]','[[regtime]]'),(2,15,'simple','24-MB04',0,0,'[[regtime]]','[[regtime]]'),(3,15,'simple','24-MB03',0,0,'[[regtime]]','[[regtime]]'),(4,15,'simple','24-MB05',0,0,'[[regtime]]','[[regtime]]'),(5,15,'simple','24-MB06',0,0,'[[regtime]]','[[regtime]]'),(6,15,'simple','24-MB02',0,0,'[[regtime]]','[[regtime]]'),(7,15,'simple','24-UB02',0,0,'[[regtime]]','[[regtime]]'),(8,15,'simple','24-WB01',0,0,'[[regtime]]','[[regtime]]'),(9,15,'simple','24-WB02',0,0,'[[regtime]]','[[regtime]]'),(10,15,'simple','24-WB05',0,0,'[[regtime]]','[[regtime]]'),(11,15,'simple','24-WB06',0,0,'[[regtime]]','[[regtime]]'),(12,15,'simple','24-WB03',0,0,'[[regtime]]','[[regtime]]'),(13,15,'simple','24-WB07',0,0,'[[regtime]]','[[regtime]]'),(14,15,'simple','24-WB04',0,0,'[[regtime]]','[[regtime]]'),(15,11,'simple','24-UG06',0,0,'[[regtime]]','[[regtime]]'),(16,11,'simple','24-UG07',0,0,'[[regtime]]','[[regtime]]'),(17,11,'simple','24-UG04',0,0,'[[regtime]]','[[regtime]]'),(18,11,'simple','24-UG02',0,0,'[[regtime]]','[[regtime]]'),(19,11,'simple','24-UG05',0,0,'[[regtime]]','[[regtime]]'),(20,11,'simple','24-UG01',0,0,'[[regtime]]','[[regtime]]'),(21,11,'simple','24-WG084',0,0,'[[regtime]]','[[regtime]]'),(22,11,'simple','24-WG088',0,0,'[[regtime]]','[[regtime]]'),(23,11,'simple','24-UG03',0,0,'[[regtime]]','[[regtime]]'),(24,12,'simple','24-WG081-gray',0,0,'[[regtime]]','[[regtime]]'),(25,12,'simple','24-WG081-pink',0,0,'[[regtime]]','[[regtime]]'),(26,12,'simple','24-WG081-blue',0,0,'[[regtime]]','[[regtime]]'),(27,12,'simple','24-WG082-gray',0,0,'[[regtime]]','[[regtime]]'),(28,12,'simple','24-WG082-pink',0,0,'[[regtime]]','[[regtime]]'),(29,12,'simple','24-WG082-blue',0,0,'[[regtime]]','[[regtime]]'),(30,12,'simple','24-WG083-gray',0,0,'[[regtime]]','[[regtime]]'),(31,12,'simple','24-WG083-pink',0,0,'[[regtime]]','[[regtime]]'),(32,12,'simple','24-WG083-blue',0,0,'[[regtime]]','[[regtime]]'),(33,13,'simple','24-WG085',0,0,'[[regtime]]','[[regtime]]'),(34,13,'simple','24-WG086',0,0,'[[regtime]]','[[regtime]]'),(35,13,'simple','24-WG087',0,0,'[[regtime]]','[[regtime]]'),(36,11,'simple','24-MG04',0,0,'[[regtime]]','[[regtime]]'),(37,11,'simple','24-MG01',0,0,'[[regtime]]','[[regtime]]'),(38,11,'simple','24-MG03',0,0,'[[regtime]]','[[regtime]]'),(39,11,'simple','24-MG05',0,0,'[[regtime]]','[[regtime]]'),(40,11,'simple','24-MG02',0,0,'[[regtime]]','[[regtime]]'),(41,11,'simple','24-WG09',0,0,'[[regtime]]','[[regtime]]'),(42,11,'simple','24-WG01',0,0,'[[regtime]]','[[regtime]]'),(43,11,'simple','24-WG03',0,0,'[[regtime]]','[[regtime]]'),(44,11,'simple','24-WG02',0,0,'[[regtime]]','[[regtime]]'),(45,11,'bundle','24-WG080',1,1,'[[regtime]]','[[regtime]]'),(46,11,'grouped','24-WG085_Group',0,0,'[[regtime]]','[[regtime]]'),(47,9,'simple','MH01-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(48,9,'simple','MH01-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(49,9,'simple','MH01-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(50,9,'simple','MH01-S-Black',0,0,'[[regtime]]','[[regtime]]'),(51,9,'simple','MH01-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(52,9,'simple','MH01-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(53,9,'simple','MH01-M-Black',0,0,'[[regtime]]','[[regtime]]'),(54,9,'simple','MH01-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(55,9,'simple','MH01-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(56,9,'simple','MH01-L-Black',0,0,'[[regtime]]','[[regtime]]'),(57,9,'simple','MH01-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(58,9,'simple','MH01-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(59,9,'simple','MH01-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(60,9,'simple','MH01-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(61,9,'simple','MH01-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(62,9,'configurable','MH01',1,0,'[[regtime]]','[[regtime]]'),(63,9,'simple','MH02-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(64,9,'simple','MH02-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(65,9,'simple','MH02-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(66,9,'simple','MH02-S-Black',0,0,'[[regtime]]','[[regtime]]'),(67,9,'simple','MH02-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(68,9,'simple','MH02-S-Red',0,0,'[[regtime]]','[[regtime]]'),(69,9,'simple','MH02-M-Black',0,0,'[[regtime]]','[[regtime]]'),(70,9,'simple','MH02-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(71,9,'simple','MH02-M-Red',0,0,'[[regtime]]','[[regtime]]'),(72,9,'simple','MH02-L-Black',0,0,'[[regtime]]','[[regtime]]'),(73,9,'simple','MH02-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(74,9,'simple','MH02-L-Red',0,0,'[[regtime]]','[[regtime]]'),(75,9,'simple','MH02-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(76,9,'simple','MH02-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(77,9,'simple','MH02-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(78,9,'configurable','MH02',1,0,'[[regtime]]','[[regtime]]'),(79,9,'simple','MH03-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(80,9,'simple','MH03-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(81,9,'simple','MH03-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(82,9,'simple','MH03-S-Black',0,0,'[[regtime]]','[[regtime]]'),(83,9,'simple','MH03-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(84,9,'simple','MH03-S-Green',0,0,'[[regtime]]','[[regtime]]'),(85,9,'simple','MH03-M-Black',0,0,'[[regtime]]','[[regtime]]'),(86,9,'simple','MH03-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(87,9,'simple','MH03-M-Green',0,0,'[[regtime]]','[[regtime]]'),(88,9,'simple','MH03-L-Black',0,0,'[[regtime]]','[[regtime]]'),(89,9,'simple','MH03-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(90,9,'simple','MH03-L-Green',0,0,'[[regtime]]','[[regtime]]'),(91,9,'simple','MH03-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(92,9,'simple','MH03-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(93,9,'simple','MH03-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(94,9,'configurable','MH03',1,0,'[[regtime]]','[[regtime]]'),(95,9,'simple','MH04-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(96,9,'simple','MH04-XS-White',0,0,'[[regtime]]','[[regtime]]'),(97,9,'simple','MH04-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(98,9,'simple','MH04-S-Green',0,0,'[[regtime]]','[[regtime]]'),(99,9,'simple','MH04-S-White',0,0,'[[regtime]]','[[regtime]]'),(100,9,'simple','MH04-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(101,9,'simple','MH04-M-Green',0,0,'[[regtime]]','[[regtime]]'),(102,9,'simple','MH04-M-White',0,0,'[[regtime]]','[[regtime]]'),(103,9,'simple','MH04-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(104,9,'simple','MH04-L-Green',0,0,'[[regtime]]','[[regtime]]'),(105,9,'simple','MH04-L-White',0,0,'[[regtime]]','[[regtime]]'),(106,9,'simple','MH04-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(107,9,'simple','MH04-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(108,9,'simple','MH04-XL-White',0,0,'[[regtime]]','[[regtime]]'),(109,9,'simple','MH04-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(110,9,'configurable','MH04',1,0,'[[regtime]]','[[regtime]]'),(111,9,'simple','MH05-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(112,9,'simple','MH05-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(113,9,'simple','MH05-XS-White',0,0,'[[regtime]]','[[regtime]]'),(114,9,'simple','MH05-S-Green',0,0,'[[regtime]]','[[regtime]]'),(115,9,'simple','MH05-S-Red',0,0,'[[regtime]]','[[regtime]]'),(116,9,'simple','MH05-S-White',0,0,'[[regtime]]','[[regtime]]'),(117,9,'simple','MH05-M-Green',0,0,'[[regtime]]','[[regtime]]'),(118,9,'simple','MH05-M-Red',0,0,'[[regtime]]','[[regtime]]'),(119,9,'simple','MH05-M-White',0,0,'[[regtime]]','[[regtime]]'),(120,9,'simple','MH05-L-Green',0,0,'[[regtime]]','[[regtime]]'),(121,9,'simple','MH05-L-Red',0,0,'[[regtime]]','[[regtime]]'),(122,9,'simple','MH05-L-White',0,0,'[[regtime]]','[[regtime]]'),(123,9,'simple','MH05-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(124,9,'simple','MH05-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(125,9,'simple','MH05-XL-White',0,0,'[[regtime]]','[[regtime]]'),(126,9,'configurable','MH05',1,0,'[[regtime]]','[[regtime]]'),(127,9,'simple','MH06-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(128,9,'simple','MH06-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(129,9,'simple','MH06-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(130,9,'simple','MH06-S-Black',0,0,'[[regtime]]','[[regtime]]'),(131,9,'simple','MH06-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(132,9,'simple','MH06-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(133,9,'simple','MH06-M-Black',0,0,'[[regtime]]','[[regtime]]'),(134,9,'simple','MH06-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(135,9,'simple','MH06-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(136,9,'simple','MH06-L-Black',0,0,'[[regtime]]','[[regtime]]'),(137,9,'simple','MH06-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(138,9,'simple','MH06-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(139,9,'simple','MH06-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(140,9,'simple','MH06-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(141,9,'simple','MH06-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(142,9,'configurable','MH06',1,0,'[[regtime]]','[[regtime]]'),(143,9,'simple','MH07-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(144,9,'simple','MH07-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(145,9,'simple','MH07-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(146,9,'simple','MH07-S-Black',0,0,'[[regtime]]','[[regtime]]'),(147,9,'simple','MH07-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(148,9,'simple','MH07-S-Green',0,0,'[[regtime]]','[[regtime]]'),(149,9,'simple','MH07-M-Black',0,0,'[[regtime]]','[[regtime]]'),(150,9,'simple','MH07-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(151,9,'simple','MH07-M-Green',0,0,'[[regtime]]','[[regtime]]'),(152,9,'simple','MH07-L-Black',0,0,'[[regtime]]','[[regtime]]'),(153,9,'simple','MH07-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(154,9,'simple','MH07-L-Green',0,0,'[[regtime]]','[[regtime]]'),(155,9,'simple','MH07-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(156,9,'simple','MH07-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(157,9,'simple','MH07-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(158,9,'configurable','MH07',1,0,'[[regtime]]','[[regtime]]'),(159,9,'simple','MH08-XS-Brown',0,0,'[[regtime]]','[[regtime]]'),(160,9,'simple','MH08-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(161,9,'simple','MH08-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(162,9,'simple','MH08-S-Brown',0,0,'[[regtime]]','[[regtime]]'),(163,9,'simple','MH08-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(164,9,'simple','MH08-S-Red',0,0,'[[regtime]]','[[regtime]]'),(165,9,'simple','MH08-M-Brown',0,0,'[[regtime]]','[[regtime]]'),(166,9,'simple','MH08-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(167,9,'simple','MH08-M-Red',0,0,'[[regtime]]','[[regtime]]'),(168,9,'simple','MH08-L-Brown',0,0,'[[regtime]]','[[regtime]]'),(169,9,'simple','MH08-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(170,9,'simple','MH08-L-Red',0,0,'[[regtime]]','[[regtime]]'),(171,9,'simple','MH08-XL-Brown',0,0,'[[regtime]]','[[regtime]]'),(172,9,'simple','MH08-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(173,9,'simple','MH08-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(174,9,'configurable','MH08',1,0,'[[regtime]]','[[regtime]]'),(175,9,'simple','MH09-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(176,9,'simple','MH09-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(177,9,'simple','MH09-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(178,9,'simple','MH09-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(179,9,'simple','MH09-S-Green',0,0,'[[regtime]]','[[regtime]]'),(180,9,'simple','MH09-S-Red',0,0,'[[regtime]]','[[regtime]]'),(181,9,'simple','MH09-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(182,9,'simple','MH09-M-Green',0,0,'[[regtime]]','[[regtime]]'),(183,9,'simple','MH09-M-Red',0,0,'[[regtime]]','[[regtime]]'),(184,9,'simple','MH09-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(185,9,'simple','MH09-L-Green',0,0,'[[regtime]]','[[regtime]]'),(186,9,'simple','MH09-L-Red',0,0,'[[regtime]]','[[regtime]]'),(187,9,'simple','MH09-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(188,9,'simple','MH09-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(189,9,'simple','MH09-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(190,9,'configurable','MH09',1,0,'[[regtime]]','[[regtime]]'),(191,9,'simple','MH10-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(192,9,'simple','MH10-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(193,9,'simple','MH10-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(194,9,'simple','MH10-S-Black',0,0,'[[regtime]]','[[regtime]]'),(195,9,'simple','MH10-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(196,9,'simple','MH10-S-Red',0,0,'[[regtime]]','[[regtime]]'),(197,9,'simple','MH10-M-Black',0,0,'[[regtime]]','[[regtime]]'),(198,9,'simple','MH10-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(199,9,'simple','MH10-M-Red',0,0,'[[regtime]]','[[regtime]]'),(200,9,'simple','MH10-L-Black',0,0,'[[regtime]]','[[regtime]]'),(201,9,'simple','MH10-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(202,9,'simple','MH10-L-Red',0,0,'[[regtime]]','[[regtime]]'),(203,9,'simple','MH10-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(204,9,'simple','MH10-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(205,9,'simple','MH10-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(206,9,'configurable','MH10',1,0,'[[regtime]]','[[regtime]]'),(207,9,'simple','MH11-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(208,9,'simple','MH11-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(209,9,'simple','MH11-XS-White',0,0,'[[regtime]]','[[regtime]]'),(210,9,'simple','MH11-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(211,9,'simple','MH11-S-Red',0,0,'[[regtime]]','[[regtime]]'),(212,9,'simple','MH11-S-White',0,0,'[[regtime]]','[[regtime]]'),(213,9,'simple','MH11-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(214,9,'simple','MH11-M-Red',0,0,'[[regtime]]','[[regtime]]'),(215,9,'simple','MH11-M-White',0,0,'[[regtime]]','[[regtime]]'),(216,9,'simple','MH11-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(217,9,'simple','MH11-L-Red',0,0,'[[regtime]]','[[regtime]]'),(218,9,'simple','MH11-L-White',0,0,'[[regtime]]','[[regtime]]'),(219,9,'simple','MH11-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(220,9,'simple','MH11-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(221,9,'simple','MH11-XL-White',0,0,'[[regtime]]','[[regtime]]'),(222,9,'configurable','MH11',1,0,'[[regtime]]','[[regtime]]'),(223,9,'simple','MH12-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(224,9,'simple','MH12-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(225,9,'simple','MH12-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(226,9,'simple','MH12-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(227,9,'simple','MH12-S-Green',0,0,'[[regtime]]','[[regtime]]'),(228,9,'simple','MH12-S-Red',0,0,'[[regtime]]','[[regtime]]'),(229,9,'simple','MH12-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(230,9,'simple','MH12-M-Green',0,0,'[[regtime]]','[[regtime]]'),(231,9,'simple','MH12-M-Red',0,0,'[[regtime]]','[[regtime]]'),(232,9,'simple','MH12-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(233,9,'simple','MH12-L-Green',0,0,'[[regtime]]','[[regtime]]'),(234,9,'simple','MH12-L-Red',0,0,'[[regtime]]','[[regtime]]'),(235,9,'simple','MH12-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(236,9,'simple','MH12-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(237,9,'simple','MH12-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(238,9,'configurable','MH12',1,0,'[[regtime]]','[[regtime]]'),(239,9,'simple','MH13-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(240,9,'simple','MH13-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(241,9,'simple','MH13-XS-Lavender',0,0,'[[regtime]]','[[regtime]]'),(242,9,'simple','MH13-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(243,9,'simple','MH13-S-Green',0,0,'[[regtime]]','[[regtime]]'),(244,9,'simple','MH13-S-Lavender',0,0,'[[regtime]]','[[regtime]]'),(245,9,'simple','MH13-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(246,9,'simple','MH13-M-Green',0,0,'[[regtime]]','[[regtime]]'),(247,9,'simple','MH13-M-Lavender',0,0,'[[regtime]]','[[regtime]]'),(248,9,'simple','MH13-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(249,9,'simple','MH13-L-Green',0,0,'[[regtime]]','[[regtime]]'),(250,9,'simple','MH13-L-Lavender',0,0,'[[regtime]]','[[regtime]]'),(251,9,'simple','MH13-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(252,9,'simple','MH13-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(253,9,'simple','MH13-XL-Lavender',0,0,'[[regtime]]','[[regtime]]'),(254,9,'configurable','MH13',1,0,'[[regtime]]','[[regtime]]'),(255,9,'simple','MJ01-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(256,9,'simple','MJ01-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(257,9,'simple','MJ01-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(258,9,'simple','MJ01-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(259,9,'simple','MJ01-S-Red',0,0,'[[regtime]]','[[regtime]]'),(260,9,'simple','MJ01-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(261,9,'simple','MJ01-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(262,9,'simple','MJ01-M-Red',0,0,'[[regtime]]','[[regtime]]'),(263,9,'simple','MJ01-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(264,9,'simple','MJ01-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(265,9,'simple','MJ01-L-Red',0,0,'[[regtime]]','[[regtime]]'),(266,9,'simple','MJ01-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(267,9,'simple','MJ01-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(268,9,'simple','MJ01-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(269,9,'simple','MJ01-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(270,9,'configurable','MJ01',1,0,'[[regtime]]','[[regtime]]'),(271,9,'simple','MJ02-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(272,9,'simple','MJ02-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(273,9,'simple','MJ02-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(274,9,'simple','MJ02-S-Green',0,0,'[[regtime]]','[[regtime]]'),(275,9,'simple','MJ02-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(276,9,'simple','MJ02-S-Red',0,0,'[[regtime]]','[[regtime]]'),(277,9,'simple','MJ02-M-Green',0,0,'[[regtime]]','[[regtime]]'),(278,9,'simple','MJ02-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(279,9,'simple','MJ02-M-Red',0,0,'[[regtime]]','[[regtime]]'),(280,9,'simple','MJ02-L-Green',0,0,'[[regtime]]','[[regtime]]'),(281,9,'simple','MJ02-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(282,9,'simple','MJ02-L-Red',0,0,'[[regtime]]','[[regtime]]'),(283,9,'simple','MJ02-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(284,9,'simple','MJ02-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(285,9,'simple','MJ02-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(286,9,'configurable','MJ02',1,0,'[[regtime]]','[[regtime]]'),(287,9,'simple','MJ04-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(288,9,'simple','MJ04-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(289,9,'simple','MJ04-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(290,9,'simple','MJ04-S-Black',0,0,'[[regtime]]','[[regtime]]'),(291,9,'simple','MJ04-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(292,9,'simple','MJ04-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(293,9,'simple','MJ04-M-Black',0,0,'[[regtime]]','[[regtime]]'),(294,9,'simple','MJ04-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(295,9,'simple','MJ04-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(296,9,'simple','MJ04-L-Black',0,0,'[[regtime]]','[[regtime]]'),(297,9,'simple','MJ04-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(298,9,'simple','MJ04-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(299,9,'simple','MJ04-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(300,9,'simple','MJ04-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(301,9,'simple','MJ04-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(302,9,'configurable','MJ04',1,0,'[[regtime]]','[[regtime]]'),(303,9,'simple','MJ07-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(304,9,'simple','MJ07-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(305,9,'simple','MJ07-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(306,9,'simple','MJ07-S-Black',0,0,'[[regtime]]','[[regtime]]'),(307,9,'simple','MJ07-S-Red',0,0,'[[regtime]]','[[regtime]]'),(308,9,'simple','MJ07-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(309,9,'simple','MJ07-M-Black',0,0,'[[regtime]]','[[regtime]]'),(310,9,'simple','MJ07-M-Red',0,0,'[[regtime]]','[[regtime]]'),(311,9,'simple','MJ07-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(312,9,'simple','MJ07-L-Black',0,0,'[[regtime]]','[[regtime]]'),(313,9,'simple','MJ07-L-Red',0,0,'[[regtime]]','[[regtime]]'),(314,9,'simple','MJ07-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(315,9,'simple','MJ07-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(316,9,'simple','MJ07-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(317,9,'simple','MJ07-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(318,9,'configurable','MJ07',1,0,'[[regtime]]','[[regtime]]'),(319,9,'simple','MJ08-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(320,9,'simple','MJ08-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(321,9,'simple','MJ08-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(322,9,'simple','MJ08-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(323,9,'simple','MJ08-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(324,9,'simple','MJ08-S-Green',0,0,'[[regtime]]','[[regtime]]'),(325,9,'simple','MJ08-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(326,9,'simple','MJ08-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(327,9,'simple','MJ08-M-Green',0,0,'[[regtime]]','[[regtime]]'),(328,9,'simple','MJ08-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(329,9,'simple','MJ08-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(330,9,'simple','MJ08-L-Green',0,0,'[[regtime]]','[[regtime]]'),(331,9,'simple','MJ08-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(332,9,'simple','MJ08-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(333,9,'simple','MJ08-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(334,9,'configurable','MJ08',1,0,'[[regtime]]','[[regtime]]'),(335,9,'simple','MJ09-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(336,9,'simple','MJ09-XS-White',0,0,'[[regtime]]','[[regtime]]'),(337,9,'simple','MJ09-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(338,9,'simple','MJ09-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(339,9,'simple','MJ09-S-White',0,0,'[[regtime]]','[[regtime]]'),(340,9,'simple','MJ09-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(341,9,'simple','MJ09-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(342,9,'simple','MJ09-M-White',0,0,'[[regtime]]','[[regtime]]'),(343,9,'simple','MJ09-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(344,9,'simple','MJ09-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(345,9,'simple','MJ09-L-White',0,0,'[[regtime]]','[[regtime]]'),(346,9,'simple','MJ09-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(347,9,'simple','MJ09-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(348,9,'simple','MJ09-XL-White',0,0,'[[regtime]]','[[regtime]]'),(349,9,'simple','MJ09-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(350,9,'configurable','MJ09',1,0,'[[regtime]]','[[regtime]]'),(351,9,'simple','MJ10-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(352,9,'simple','MJ10-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(353,9,'simple','MJ10-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(354,9,'simple','MJ10-S-Black',0,0,'[[regtime]]','[[regtime]]'),(355,9,'simple','MJ10-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(356,9,'simple','MJ10-S-Red',0,0,'[[regtime]]','[[regtime]]'),(357,9,'simple','MJ10-M-Black',0,0,'[[regtime]]','[[regtime]]'),(358,9,'simple','MJ10-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(359,9,'simple','MJ10-M-Red',0,0,'[[regtime]]','[[regtime]]'),(360,9,'simple','MJ10-L-Black',0,0,'[[regtime]]','[[regtime]]'),(361,9,'simple','MJ10-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(362,9,'simple','MJ10-L-Red',0,0,'[[regtime]]','[[regtime]]'),(363,9,'simple','MJ10-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(364,9,'simple','MJ10-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(365,9,'simple','MJ10-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(366,9,'configurable','MJ10',1,0,'[[regtime]]','[[regtime]]'),(367,9,'simple','MJ11-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(368,9,'simple','MJ11-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(369,9,'simple','MJ11-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(370,9,'simple','MJ11-S-Black',0,0,'[[regtime]]','[[regtime]]'),(371,9,'simple','MJ11-S-Green',0,0,'[[regtime]]','[[regtime]]'),(372,9,'simple','MJ11-S-Red',0,0,'[[regtime]]','[[regtime]]'),(373,9,'simple','MJ11-M-Black',0,0,'[[regtime]]','[[regtime]]'),(374,9,'simple','MJ11-M-Green',0,0,'[[regtime]]','[[regtime]]'),(375,9,'simple','MJ11-M-Red',0,0,'[[regtime]]','[[regtime]]'),(376,9,'simple','MJ11-L-Black',0,0,'[[regtime]]','[[regtime]]'),(377,9,'simple','MJ11-L-Green',0,0,'[[regtime]]','[[regtime]]'),(378,9,'simple','MJ11-L-Red',0,0,'[[regtime]]','[[regtime]]'),(379,9,'simple','MJ11-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(380,9,'simple','MJ11-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(381,9,'simple','MJ11-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(382,9,'configurable','MJ11',1,0,'[[regtime]]','[[regtime]]'),(383,9,'simple','MJ06-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(384,9,'simple','MJ06-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(385,9,'simple','MJ06-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(386,9,'simple','MJ06-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(387,9,'simple','MJ06-S-Green',0,0,'[[regtime]]','[[regtime]]'),(388,9,'simple','MJ06-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(389,9,'simple','MJ06-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(390,9,'simple','MJ06-M-Green',0,0,'[[regtime]]','[[regtime]]'),(391,9,'simple','MJ06-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(392,9,'simple','MJ06-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(393,9,'simple','MJ06-L-Green',0,0,'[[regtime]]','[[regtime]]'),(394,9,'simple','MJ06-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(395,9,'simple','MJ06-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(396,9,'simple','MJ06-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(397,9,'simple','MJ06-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(398,9,'configurable','MJ06',1,0,'[[regtime]]','[[regtime]]'),(399,9,'simple','MJ03-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(400,9,'simple','MJ03-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(401,9,'simple','MJ03-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(402,9,'simple','MJ03-S-Black',0,0,'[[regtime]]','[[regtime]]'),(403,9,'simple','MJ03-S-Green',0,0,'[[regtime]]','[[regtime]]'),(404,9,'simple','MJ03-S-Red',0,0,'[[regtime]]','[[regtime]]'),(405,9,'simple','MJ03-M-Black',0,0,'[[regtime]]','[[regtime]]'),(406,9,'simple','MJ03-M-Green',0,0,'[[regtime]]','[[regtime]]'),(407,9,'simple','MJ03-M-Red',0,0,'[[regtime]]','[[regtime]]'),(408,9,'simple','MJ03-L-Black',0,0,'[[regtime]]','[[regtime]]'),(409,9,'simple','MJ03-L-Green',0,0,'[[regtime]]','[[regtime]]'),(410,9,'simple','MJ03-L-Red',0,0,'[[regtime]]','[[regtime]]'),(411,9,'simple','MJ03-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(412,9,'simple','MJ03-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(413,9,'simple','MJ03-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(414,9,'configurable','MJ03',1,0,'[[regtime]]','[[regtime]]'),(415,9,'simple','MJ12-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(416,9,'simple','MJ12-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(417,9,'simple','MJ12-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(418,9,'simple','MJ12-S-Black',0,0,'[[regtime]]','[[regtime]]'),(419,9,'simple','MJ12-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(420,9,'simple','MJ12-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(421,9,'simple','MJ12-M-Black',0,0,'[[regtime]]','[[regtime]]'),(422,9,'simple','MJ12-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(423,9,'simple','MJ12-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(424,9,'simple','MJ12-L-Black',0,0,'[[regtime]]','[[regtime]]'),(425,9,'simple','MJ12-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(426,9,'simple','MJ12-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(427,9,'simple','MJ12-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(428,9,'simple','MJ12-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(429,9,'simple','MJ12-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(430,9,'configurable','MJ12',1,0,'[[regtime]]','[[regtime]]'),(431,9,'simple','MS04-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(432,9,'simple','MS04-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(433,9,'simple','MS04-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(434,9,'simple','MS04-S-Black',0,0,'[[regtime]]','[[regtime]]'),(435,9,'simple','MS04-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(436,9,'simple','MS04-S-Red',0,0,'[[regtime]]','[[regtime]]'),(437,9,'simple','MS04-M-Black',0,0,'[[regtime]]','[[regtime]]'),(438,9,'simple','MS04-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(439,9,'simple','MS04-M-Red',0,0,'[[regtime]]','[[regtime]]'),(440,9,'simple','MS04-L-Black',0,0,'[[regtime]]','[[regtime]]'),(441,9,'simple','MS04-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(442,9,'simple','MS04-L-Red',0,0,'[[regtime]]','[[regtime]]'),(443,9,'simple','MS04-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(444,9,'simple','MS04-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(445,9,'simple','MS04-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(446,9,'configurable','MS04',1,0,'[[regtime]]','[[regtime]]'),(447,9,'simple','MS05-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(448,9,'simple','MS05-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(449,9,'simple','MS05-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(450,9,'simple','MS05-S-Black',0,0,'[[regtime]]','[[regtime]]'),(451,9,'simple','MS05-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(452,9,'simple','MS05-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(453,9,'simple','MS05-M-Black',0,0,'[[regtime]]','[[regtime]]'),(454,9,'simple','MS05-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(455,9,'simple','MS05-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(456,9,'simple','MS05-L-Black',0,0,'[[regtime]]','[[regtime]]'),(457,9,'simple','MS05-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(458,9,'simple','MS05-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(459,9,'simple','MS05-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(460,9,'simple','MS05-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(461,9,'simple','MS05-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(462,9,'configurable','MS05',1,0,'[[regtime]]','[[regtime]]'),(463,9,'simple','MS09-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(464,9,'simple','MS09-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(465,9,'simple','MS09-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(466,9,'simple','MS09-S-Black',0,0,'[[regtime]]','[[regtime]]'),(467,9,'simple','MS09-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(468,9,'simple','MS09-S-Red',0,0,'[[regtime]]','[[regtime]]'),(469,9,'simple','MS09-M-Black',0,0,'[[regtime]]','[[regtime]]'),(470,9,'simple','MS09-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(471,9,'simple','MS09-M-Red',0,0,'[[regtime]]','[[regtime]]'),(472,9,'simple','MS09-L-Black',0,0,'[[regtime]]','[[regtime]]'),(473,9,'simple','MS09-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(474,9,'simple','MS09-L-Red',0,0,'[[regtime]]','[[regtime]]'),(475,9,'simple','MS09-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(476,9,'simple','MS09-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(477,9,'simple','MS09-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(478,9,'configurable','MS09',1,0,'[[regtime]]','[[regtime]]'),(479,9,'simple','MS11-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(480,9,'simple','MS11-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(481,9,'simple','MS11-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(482,9,'simple','MS11-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(483,9,'simple','MS11-S-Green',0,0,'[[regtime]]','[[regtime]]'),(484,9,'simple','MS11-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(485,9,'simple','MS11-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(486,9,'simple','MS11-M-Green',0,0,'[[regtime]]','[[regtime]]'),(487,9,'simple','MS11-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(488,9,'simple','MS11-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(489,9,'simple','MS11-L-Green',0,0,'[[regtime]]','[[regtime]]'),(490,9,'simple','MS11-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(491,9,'simple','MS11-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(492,9,'simple','MS11-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(493,9,'simple','MS11-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(494,9,'configurable','MS11',1,0,'[[regtime]]','[[regtime]]'),(495,9,'simple','MS12-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(496,9,'simple','MS12-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(497,9,'simple','MS12-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(498,9,'simple','MS12-S-Black',0,0,'[[regtime]]','[[regtime]]'),(499,9,'simple','MS12-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(500,9,'simple','MS12-S-Red',0,0,'[[regtime]]','[[regtime]]'),(501,9,'simple','MS12-M-Black',0,0,'[[regtime]]','[[regtime]]'),(502,9,'simple','MS12-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(503,9,'simple','MS12-M-Red',0,0,'[[regtime]]','[[regtime]]'),(504,9,'simple','MS12-L-Black',0,0,'[[regtime]]','[[regtime]]'),(505,9,'simple','MS12-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(506,9,'simple','MS12-L-Red',0,0,'[[regtime]]','[[regtime]]'),(507,9,'simple','MS12-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(508,9,'simple','MS12-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(509,9,'simple','MS12-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(510,9,'configurable','MS12',1,0,'[[regtime]]','[[regtime]]'),(511,9,'simple','MS03-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(512,9,'simple','MS03-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(513,9,'simple','MS03-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(514,9,'simple','MS03-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(515,9,'simple','MS03-S-Green',0,0,'[[regtime]]','[[regtime]]'),(516,9,'simple','MS03-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(517,9,'simple','MS03-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(518,9,'simple','MS03-M-Green',0,0,'[[regtime]]','[[regtime]]'),(519,9,'simple','MS03-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(520,9,'simple','MS03-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(521,9,'simple','MS03-L-Green',0,0,'[[regtime]]','[[regtime]]'),(522,9,'simple','MS03-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(523,9,'simple','MS03-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(524,9,'simple','MS03-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(525,9,'simple','MS03-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(526,9,'configurable','MS03',1,0,'[[regtime]]','[[regtime]]'),(527,9,'simple','MS06-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(528,9,'simple','MS06-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(529,9,'simple','MS06-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(530,9,'simple','MS06-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(531,9,'simple','MS06-S-Green',0,0,'[[regtime]]','[[regtime]]'),(532,9,'simple','MS06-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(533,9,'simple','MS06-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(534,9,'simple','MS06-M-Green',0,0,'[[regtime]]','[[regtime]]'),(535,9,'simple','MS06-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(536,9,'simple','MS06-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(537,9,'simple','MS06-L-Green',0,0,'[[regtime]]','[[regtime]]'),(538,9,'simple','MS06-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(539,9,'simple','MS06-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(540,9,'simple','MS06-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(541,9,'simple','MS06-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(542,9,'configurable','MS06',1,0,'[[regtime]]','[[regtime]]'),(543,9,'simple','MS01-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(544,9,'simple','MS01-XS-Brown',0,0,'[[regtime]]','[[regtime]]'),(545,9,'simple','MS01-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(546,9,'simple','MS01-S-Black',0,0,'[[regtime]]','[[regtime]]'),(547,9,'simple','MS01-S-Brown',0,0,'[[regtime]]','[[regtime]]'),(548,9,'simple','MS01-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(549,9,'simple','MS01-M-Black',0,0,'[[regtime]]','[[regtime]]'),(550,9,'simple','MS01-M-Brown',0,0,'[[regtime]]','[[regtime]]'),(551,9,'simple','MS01-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(552,9,'simple','MS01-L-Black',0,0,'[[regtime]]','[[regtime]]'),(553,9,'simple','MS01-L-Brown',0,0,'[[regtime]]','[[regtime]]'),(554,9,'simple','MS01-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(555,9,'simple','MS01-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(556,9,'simple','MS01-XL-Brown',0,0,'[[regtime]]','[[regtime]]'),(557,9,'simple','MS01-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(558,9,'configurable','MS01',1,0,'[[regtime]]','[[regtime]]'),(559,9,'simple','MS02-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(560,9,'simple','MS02-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(561,9,'simple','MS02-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(562,9,'simple','MS02-S-Black',0,0,'[[regtime]]','[[regtime]]'),(563,9,'simple','MS02-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(564,9,'simple','MS02-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(565,9,'simple','MS02-M-Black',0,0,'[[regtime]]','[[regtime]]'),(566,9,'simple','MS02-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(567,9,'simple','MS02-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(568,9,'simple','MS02-L-Black',0,0,'[[regtime]]','[[regtime]]'),(569,9,'simple','MS02-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(570,9,'simple','MS02-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(571,9,'simple','MS02-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(572,9,'simple','MS02-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(573,9,'simple','MS02-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(574,9,'configurable','MS02',1,0,'[[regtime]]','[[regtime]]'),(575,9,'simple','MS10-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(576,9,'simple','MS10-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(577,9,'simple','MS10-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(578,9,'simple','MS10-S-Black',0,0,'[[regtime]]','[[regtime]]'),(579,9,'simple','MS10-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(580,9,'simple','MS10-S-Red',0,0,'[[regtime]]','[[regtime]]'),(581,9,'simple','MS10-M-Black',0,0,'[[regtime]]','[[regtime]]'),(582,9,'simple','MS10-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(583,9,'simple','MS10-M-Red',0,0,'[[regtime]]','[[regtime]]'),(584,9,'simple','MS10-L-Black',0,0,'[[regtime]]','[[regtime]]'),(585,9,'simple','MS10-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(586,9,'simple','MS10-L-Red',0,0,'[[regtime]]','[[regtime]]'),(587,9,'simple','MS10-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(588,9,'simple','MS10-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(589,9,'simple','MS10-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(590,9,'configurable','MS10',1,0,'[[regtime]]','[[regtime]]'),(591,9,'simple','MS07-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(592,9,'simple','MS07-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(593,9,'simple','MS07-XS-White',0,0,'[[regtime]]','[[regtime]]'),(594,9,'simple','MS07-S-Black',0,0,'[[regtime]]','[[regtime]]'),(595,9,'simple','MS07-S-Green',0,0,'[[regtime]]','[[regtime]]'),(596,9,'simple','MS07-S-White',0,0,'[[regtime]]','[[regtime]]'),(597,9,'simple','MS07-M-Black',0,0,'[[regtime]]','[[regtime]]'),(598,9,'simple','MS07-M-Green',0,0,'[[regtime]]','[[regtime]]'),(599,9,'simple','MS07-M-White',0,0,'[[regtime]]','[[regtime]]'),(600,9,'simple','MS07-L-Black',0,0,'[[regtime]]','[[regtime]]'),(601,9,'simple','MS07-L-Green',0,0,'[[regtime]]','[[regtime]]'),(602,9,'simple','MS07-L-White',0,0,'[[regtime]]','[[regtime]]'),(603,9,'simple','MS07-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(604,9,'simple','MS07-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(605,9,'simple','MS07-XL-White',0,0,'[[regtime]]','[[regtime]]'),(606,9,'configurable','MS07',1,0,'[[regtime]]','[[regtime]]'),(607,9,'simple','MS08-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(608,9,'simple','MS08-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(609,9,'simple','MS08-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(610,9,'simple','MS08-S-Black',0,0,'[[regtime]]','[[regtime]]'),(611,9,'simple','MS08-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(612,9,'simple','MS08-S-Red',0,0,'[[regtime]]','[[regtime]]'),(613,9,'simple','MS08-M-Black',0,0,'[[regtime]]','[[regtime]]'),(614,9,'simple','MS08-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(615,9,'simple','MS08-M-Red',0,0,'[[regtime]]','[[regtime]]'),(616,9,'simple','MS08-L-Black',0,0,'[[regtime]]','[[regtime]]'),(617,9,'simple','MS08-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(618,9,'simple','MS08-L-Red',0,0,'[[regtime]]','[[regtime]]'),(619,9,'simple','MS08-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(620,9,'simple','MS08-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(621,9,'simple','MS08-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(622,9,'configurable','MS08',1,0,'[[regtime]]','[[regtime]]'),(623,9,'simple','MT01-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(624,9,'simple','MT01-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(625,9,'simple','MT01-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(626,9,'simple','MT01-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(627,9,'simple','MT01-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(628,9,'simple','MT01-S-Red',0,0,'[[regtime]]','[[regtime]]'),(629,9,'simple','MT01-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(630,9,'simple','MT01-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(631,9,'simple','MT01-M-Red',0,0,'[[regtime]]','[[regtime]]'),(632,9,'simple','MT01-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(633,9,'simple','MT01-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(634,9,'simple','MT01-L-Red',0,0,'[[regtime]]','[[regtime]]'),(635,9,'simple','MT01-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(636,9,'simple','MT01-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(637,9,'simple','MT01-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(638,9,'configurable','MT01',1,0,'[[regtime]]','[[regtime]]'),(639,9,'simple','MT02-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(640,9,'simple','MT02-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(641,9,'simple','MT02-XS-White',0,0,'[[regtime]]','[[regtime]]'),(642,9,'simple','MT02-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(643,9,'simple','MT02-S-Red',0,0,'[[regtime]]','[[regtime]]'),(644,9,'simple','MT02-S-White',0,0,'[[regtime]]','[[regtime]]'),(645,9,'simple','MT02-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(646,9,'simple','MT02-M-Red',0,0,'[[regtime]]','[[regtime]]'),(647,9,'simple','MT02-M-White',0,0,'[[regtime]]','[[regtime]]'),(648,9,'simple','MT02-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(649,9,'simple','MT02-L-Red',0,0,'[[regtime]]','[[regtime]]'),(650,9,'simple','MT02-L-White',0,0,'[[regtime]]','[[regtime]]'),(651,9,'simple','MT02-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(652,9,'simple','MT02-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(653,9,'simple','MT02-XL-White',0,0,'[[regtime]]','[[regtime]]'),(654,9,'configurable','MT02',1,0,'[[regtime]]','[[regtime]]'),(655,9,'simple','MT03-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(656,9,'simple','MT03-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(657,9,'simple','MT03-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(658,9,'simple','MT03-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(659,9,'simple','MT03-S-Red',0,0,'[[regtime]]','[[regtime]]'),(660,9,'simple','MT03-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(661,9,'simple','MT03-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(662,9,'simple','MT03-M-Red',0,0,'[[regtime]]','[[regtime]]'),(663,9,'simple','MT03-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(664,9,'simple','MT03-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(665,9,'simple','MT03-L-Red',0,0,'[[regtime]]','[[regtime]]'),(666,9,'simple','MT03-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(667,9,'simple','MT03-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(668,9,'simple','MT03-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(669,9,'simple','MT03-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(670,9,'configurable','MT03',1,0,'[[regtime]]','[[regtime]]'),(671,9,'simple','MT04-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(672,9,'simple','MT04-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(673,9,'simple','MT04-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(674,9,'simple','MT04-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(675,9,'simple','MT04-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(676,9,'configurable','MT04',1,0,'[[regtime]]','[[regtime]]'),(677,9,'simple','MT05-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(678,9,'simple','MT05-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(679,9,'simple','MT05-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(680,9,'simple','MT05-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(681,9,'simple','MT05-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(682,9,'configurable','MT05',1,0,'[[regtime]]','[[regtime]]'),(683,9,'simple','MT06-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(684,9,'simple','MT06-S-Black',0,0,'[[regtime]]','[[regtime]]'),(685,9,'simple','MT06-M-Black',0,0,'[[regtime]]','[[regtime]]'),(686,9,'simple','MT06-L-Black',0,0,'[[regtime]]','[[regtime]]'),(687,9,'simple','MT06-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(688,9,'configurable','MT06',1,0,'[[regtime]]','[[regtime]]'),(689,9,'simple','MT07-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(690,9,'simple','MT07-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(691,9,'simple','MT07-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(692,9,'simple','MT07-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(693,9,'simple','MT07-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(694,9,'configurable','MT07',1,0,'[[regtime]]','[[regtime]]'),(695,9,'simple','MT08-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(696,9,'simple','MT08-S-Green',0,0,'[[regtime]]','[[regtime]]'),(697,9,'simple','MT08-M-Green',0,0,'[[regtime]]','[[regtime]]'),(698,9,'simple','MT08-L-Green',0,0,'[[regtime]]','[[regtime]]'),(699,9,'simple','MT08-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(700,9,'configurable','MT08',1,0,'[[regtime]]','[[regtime]]'),(701,9,'simple','MT09-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(702,9,'simple','MT09-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(703,9,'simple','MT09-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(704,9,'simple','MT09-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(705,9,'simple','MT09-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(706,9,'configurable','MT09',1,0,'[[regtime]]','[[regtime]]'),(707,9,'simple','MT10-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(708,9,'simple','MT10-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(709,9,'simple','MT10-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(710,9,'simple','MT10-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(711,9,'simple','MT10-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(712,9,'configurable','MT10',1,0,'[[regtime]]','[[regtime]]'),(713,9,'simple','MT11-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(714,9,'simple','MT11-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(715,9,'simple','MT11-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(716,9,'simple','MT11-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(717,9,'simple','MT11-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(718,9,'configurable','MT11',1,0,'[[regtime]]','[[regtime]]'),(719,9,'simple','MT12-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(720,9,'simple','MT12-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(721,9,'simple','MT12-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(722,9,'simple','MT12-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(723,9,'simple','MT12-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(724,9,'configurable','MT12',1,0,'[[regtime]]','[[regtime]]'),(725,10,'simple','MP01-32-Black',0,0,'[[regtime]]','[[regtime]]'),(726,10,'simple','MP01-32-Gray',0,0,'[[regtime]]','[[regtime]]'),(727,10,'simple','MP01-32-Purple',0,0,'[[regtime]]','[[regtime]]'),(728,10,'simple','MP01-33-Black',0,0,'[[regtime]]','[[regtime]]'),(729,10,'simple','MP01-33-Gray',0,0,'[[regtime]]','[[regtime]]'),(730,10,'simple','MP01-33-Purple',0,0,'[[regtime]]','[[regtime]]'),(731,10,'simple','MP01-34-Black',0,0,'[[regtime]]','[[regtime]]'),(732,10,'simple','MP01-34-Gray',0,0,'[[regtime]]','[[regtime]]'),(733,10,'simple','MP01-34-Purple',0,0,'[[regtime]]','[[regtime]]'),(734,10,'simple','MP01-36-Black',0,0,'[[regtime]]','[[regtime]]'),(735,10,'simple','MP01-36-Gray',0,0,'[[regtime]]','[[regtime]]'),(736,10,'simple','MP01-36-Purple',0,0,'[[regtime]]','[[regtime]]'),(737,10,'configurable','MP01',1,0,'[[regtime]]','[[regtime]]'),(738,10,'simple','MP02-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(739,10,'simple','MP02-32-Gray',0,0,'[[regtime]]','[[regtime]]'),(740,10,'simple','MP02-32-Red',0,0,'[[regtime]]','[[regtime]]'),(741,10,'simple','MP02-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(742,10,'simple','MP02-33-Gray',0,0,'[[regtime]]','[[regtime]]'),(743,10,'simple','MP02-33-Red',0,0,'[[regtime]]','[[regtime]]'),(744,10,'simple','MP02-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(745,10,'simple','MP02-34-Gray',0,0,'[[regtime]]','[[regtime]]'),(746,10,'simple','MP02-34-Red',0,0,'[[regtime]]','[[regtime]]'),(747,10,'simple','MP02-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(748,10,'simple','MP02-36-Gray',0,0,'[[regtime]]','[[regtime]]'),(749,10,'simple','MP02-36-Red',0,0,'[[regtime]]','[[regtime]]'),(750,10,'configurable','MP02',1,0,'[[regtime]]','[[regtime]]'),(751,10,'simple','MP03-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(752,10,'simple','MP03-32-Green',0,0,'[[regtime]]','[[regtime]]'),(753,10,'simple','MP03-32-Red',0,0,'[[regtime]]','[[regtime]]'),(754,10,'simple','MP03-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(755,10,'simple','MP03-33-Green',0,0,'[[regtime]]','[[regtime]]'),(756,10,'simple','MP03-33-Red',0,0,'[[regtime]]','[[regtime]]'),(757,10,'simple','MP03-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(758,10,'simple','MP03-34-Green',0,0,'[[regtime]]','[[regtime]]'),(759,10,'simple','MP03-34-Red',0,0,'[[regtime]]','[[regtime]]'),(760,10,'simple','MP03-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(761,10,'simple','MP03-36-Green',0,0,'[[regtime]]','[[regtime]]'),(762,10,'simple','MP03-36-Red',0,0,'[[regtime]]','[[regtime]]'),(763,10,'configurable','MP03',1,0,'[[regtime]]','[[regtime]]'),(764,10,'simple','MP04-32-Black',0,0,'[[regtime]]','[[regtime]]'),(765,10,'simple','MP04-32-Gray',0,0,'[[regtime]]','[[regtime]]'),(766,10,'simple','MP04-32-Green',0,0,'[[regtime]]','[[regtime]]'),(767,10,'simple','MP04-33-Black',0,0,'[[regtime]]','[[regtime]]'),(768,10,'simple','MP04-33-Gray',0,0,'[[regtime]]','[[regtime]]'),(769,10,'simple','MP04-33-Green',0,0,'[[regtime]]','[[regtime]]'),(770,10,'simple','MP04-34-Black',0,0,'[[regtime]]','[[regtime]]'),(771,10,'simple','MP04-34-Gray',0,0,'[[regtime]]','[[regtime]]'),(772,10,'simple','MP04-34-Green',0,0,'[[regtime]]','[[regtime]]'),(773,10,'simple','MP04-36-Black',0,0,'[[regtime]]','[[regtime]]'),(774,10,'simple','MP04-36-Gray',0,0,'[[regtime]]','[[regtime]]'),(775,10,'simple','MP04-36-Green',0,0,'[[regtime]]','[[regtime]]'),(776,10,'configurable','MP04',1,0,'[[regtime]]','[[regtime]]'),(777,10,'simple','MP05-32-Black',0,0,'[[regtime]]','[[regtime]]'),(778,10,'simple','MP05-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(779,10,'simple','MP05-32-Green',0,0,'[[regtime]]','[[regtime]]'),(780,10,'simple','MP05-33-Black',0,0,'[[regtime]]','[[regtime]]'),(781,10,'simple','MP05-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(782,10,'simple','MP05-33-Green',0,0,'[[regtime]]','[[regtime]]'),(783,10,'simple','MP05-34-Black',0,0,'[[regtime]]','[[regtime]]'),(784,10,'simple','MP05-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(785,10,'simple','MP05-34-Green',0,0,'[[regtime]]','[[regtime]]'),(786,10,'simple','MP05-36-Black',0,0,'[[regtime]]','[[regtime]]'),(787,10,'simple','MP05-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(788,10,'simple','MP05-36-Green',0,0,'[[regtime]]','[[regtime]]'),(789,10,'configurable','MP05',1,0,'[[regtime]]','[[regtime]]'),(790,10,'simple','MP06-32-Gray',0,0,'[[regtime]]','[[regtime]]'),(791,10,'simple','MP06-32-Green',0,0,'[[regtime]]','[[regtime]]'),(792,10,'simple','MP06-32-Orange',0,0,'[[regtime]]','[[regtime]]'),(793,10,'simple','MP06-33-Gray',0,0,'[[regtime]]','[[regtime]]'),(794,10,'simple','MP06-33-Green',0,0,'[[regtime]]','[[regtime]]'),(795,10,'simple','MP06-33-Orange',0,0,'[[regtime]]','[[regtime]]'),(796,10,'simple','MP06-34-Gray',0,0,'[[regtime]]','[[regtime]]'),(797,10,'simple','MP06-34-Green',0,0,'[[regtime]]','[[regtime]]'),(798,10,'simple','MP06-34-Orange',0,0,'[[regtime]]','[[regtime]]'),(799,10,'simple','MP06-36-Gray',0,0,'[[regtime]]','[[regtime]]'),(800,10,'simple','MP06-36-Green',0,0,'[[regtime]]','[[regtime]]'),(801,10,'simple','MP06-36-Orange',0,0,'[[regtime]]','[[regtime]]'),(802,10,'configurable','MP06',1,0,'[[regtime]]','[[regtime]]'),(803,10,'simple','MP07-32-Black',0,0,'[[regtime]]','[[regtime]]'),(804,10,'simple','MP07-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(805,10,'simple','MP07-32-Purple',0,0,'[[regtime]]','[[regtime]]'),(806,10,'simple','MP07-33-Black',0,0,'[[regtime]]','[[regtime]]'),(807,10,'simple','MP07-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(808,10,'simple','MP07-33-Purple',0,0,'[[regtime]]','[[regtime]]'),(809,10,'simple','MP07-34-Black',0,0,'[[regtime]]','[[regtime]]'),(810,10,'simple','MP07-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(811,10,'simple','MP07-34-Purple',0,0,'[[regtime]]','[[regtime]]'),(812,10,'simple','MP07-36-Black',0,0,'[[regtime]]','[[regtime]]'),(813,10,'simple','MP07-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(814,10,'simple','MP07-36-Purple',0,0,'[[regtime]]','[[regtime]]'),(815,10,'configurable','MP07',1,0,'[[regtime]]','[[regtime]]'),(816,10,'simple','MP08-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(817,10,'simple','MP08-32-Green',0,0,'[[regtime]]','[[regtime]]'),(818,10,'simple','MP08-32-Red',0,0,'[[regtime]]','[[regtime]]'),(819,10,'simple','MP08-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(820,10,'simple','MP08-33-Green',0,0,'[[regtime]]','[[regtime]]'),(821,10,'simple','MP08-33-Red',0,0,'[[regtime]]','[[regtime]]'),(822,10,'simple','MP08-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(823,10,'simple','MP08-34-Green',0,0,'[[regtime]]','[[regtime]]'),(824,10,'simple','MP08-34-Red',0,0,'[[regtime]]','[[regtime]]'),(825,10,'simple','MP08-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(826,10,'simple','MP08-36-Green',0,0,'[[regtime]]','[[regtime]]'),(827,10,'simple','MP08-36-Red',0,0,'[[regtime]]','[[regtime]]'),(828,10,'configurable','MP08',1,0,'[[regtime]]','[[regtime]]'),(829,10,'simple','MP09-32-Black',0,0,'[[regtime]]','[[regtime]]'),(830,10,'simple','MP09-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(831,10,'simple','MP09-32-Red',0,0,'[[regtime]]','[[regtime]]'),(832,10,'simple','MP09-33-Black',0,0,'[[regtime]]','[[regtime]]'),(833,10,'simple','MP09-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(834,10,'simple','MP09-33-Red',0,0,'[[regtime]]','[[regtime]]'),(835,10,'simple','MP09-34-Black',0,0,'[[regtime]]','[[regtime]]'),(836,10,'simple','MP09-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(837,10,'simple','MP09-34-Red',0,0,'[[regtime]]','[[regtime]]'),(838,10,'simple','MP09-36-Black',0,0,'[[regtime]]','[[regtime]]'),(839,10,'simple','MP09-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(840,10,'simple','MP09-36-Red',0,0,'[[regtime]]','[[regtime]]'),(841,10,'configurable','MP09',1,0,'[[regtime]]','[[regtime]]'),(842,10,'simple','MP10-32-Black',0,0,'[[regtime]]','[[regtime]]'),(843,10,'simple','MP10-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(844,10,'simple','MP10-32-Green',0,0,'[[regtime]]','[[regtime]]'),(845,10,'simple','MP10-33-Black',0,0,'[[regtime]]','[[regtime]]'),(846,10,'simple','MP10-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(847,10,'simple','MP10-33-Green',0,0,'[[regtime]]','[[regtime]]'),(848,10,'simple','MP10-34-Black',0,0,'[[regtime]]','[[regtime]]'),(849,10,'simple','MP10-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(850,10,'simple','MP10-34-Green',0,0,'[[regtime]]','[[regtime]]'),(851,10,'simple','MP10-36-Black',0,0,'[[regtime]]','[[regtime]]'),(852,10,'simple','MP10-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(853,10,'simple','MP10-36-Green',0,0,'[[regtime]]','[[regtime]]'),(854,10,'configurable','MP10',1,0,'[[regtime]]','[[regtime]]'),(855,10,'simple','MP11-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(856,10,'simple','MP11-32-Brown',0,0,'[[regtime]]','[[regtime]]'),(857,10,'simple','MP11-32-Green',0,0,'[[regtime]]','[[regtime]]'),(858,10,'simple','MP11-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(859,10,'simple','MP11-33-Brown',0,0,'[[regtime]]','[[regtime]]'),(860,10,'simple','MP11-33-Green',0,0,'[[regtime]]','[[regtime]]'),(861,10,'simple','MP11-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(862,10,'simple','MP11-34-Brown',0,0,'[[regtime]]','[[regtime]]'),(863,10,'simple','MP11-34-Green',0,0,'[[regtime]]','[[regtime]]'),(864,10,'simple','MP11-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(865,10,'simple','MP11-36-Brown',0,0,'[[regtime]]','[[regtime]]'),(866,10,'simple','MP11-36-Green',0,0,'[[regtime]]','[[regtime]]'),(867,10,'configurable','MP11',1,0,'[[regtime]]','[[regtime]]'),(868,10,'simple','MP12-32-Black',0,0,'[[regtime]]','[[regtime]]'),(869,10,'simple','MP12-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(870,10,'simple','MP12-32-Red',0,0,'[[regtime]]','[[regtime]]'),(871,10,'simple','MP12-33-Black',0,0,'[[regtime]]','[[regtime]]'),(872,10,'simple','MP12-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(873,10,'simple','MP12-33-Red',0,0,'[[regtime]]','[[regtime]]'),(874,10,'simple','MP12-34-Black',0,0,'[[regtime]]','[[regtime]]'),(875,10,'simple','MP12-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(876,10,'simple','MP12-34-Red',0,0,'[[regtime]]','[[regtime]]'),(877,10,'simple','MP12-36-Black',0,0,'[[regtime]]','[[regtime]]'),(878,10,'simple','MP12-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(879,10,'simple','MP12-36-Red',0,0,'[[regtime]]','[[regtime]]'),(880,10,'configurable','MP12',1,0,'[[regtime]]','[[regtime]]'),(881,10,'simple','MSH01-32-Black',0,0,'[[regtime]]','[[regtime]]'),(882,10,'simple','MSH01-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(883,10,'simple','MSH01-32-Red',0,0,'[[regtime]]','[[regtime]]'),(884,10,'simple','MSH01-33-Black',0,0,'[[regtime]]','[[regtime]]'),(885,10,'simple','MSH01-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(886,10,'simple','MSH01-33-Red',0,0,'[[regtime]]','[[regtime]]'),(887,10,'simple','MSH01-34-Black',0,0,'[[regtime]]','[[regtime]]'),(888,10,'simple','MSH01-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(889,10,'simple','MSH01-34-Red',0,0,'[[regtime]]','[[regtime]]'),(890,10,'simple','MSH01-36-Black',0,0,'[[regtime]]','[[regtime]]'),(891,10,'simple','MSH01-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(892,10,'simple','MSH01-36-Red',0,0,'[[regtime]]','[[regtime]]'),(893,10,'configurable','MSH01',1,0,'[[regtime]]','[[regtime]]'),(894,10,'simple','MSH02-32-Black',0,0,'[[regtime]]','[[regtime]]'),(895,10,'simple','MSH02-33-Black',0,0,'[[regtime]]','[[regtime]]'),(896,10,'simple','MSH02-34-Black',0,0,'[[regtime]]','[[regtime]]'),(897,10,'simple','MSH02-36-Black',0,0,'[[regtime]]','[[regtime]]'),(898,10,'configurable','MSH02',1,0,'[[regtime]]','[[regtime]]'),(899,10,'simple','MSH03-32-Black',0,0,'[[regtime]]','[[regtime]]'),(900,10,'simple','MSH03-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(901,10,'simple','MSH03-32-Green',0,0,'[[regtime]]','[[regtime]]'),(902,10,'simple','MSH03-33-Black',0,0,'[[regtime]]','[[regtime]]'),(903,10,'simple','MSH03-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(904,10,'simple','MSH03-33-Green',0,0,'[[regtime]]','[[regtime]]'),(905,10,'simple','MSH03-34-Black',0,0,'[[regtime]]','[[regtime]]'),(906,10,'simple','MSH03-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(907,10,'simple','MSH03-34-Green',0,0,'[[regtime]]','[[regtime]]'),(908,10,'simple','MSH03-36-Black',0,0,'[[regtime]]','[[regtime]]'),(909,10,'simple','MSH03-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(910,10,'simple','MSH03-36-Green',0,0,'[[regtime]]','[[regtime]]'),(911,10,'configurable','MSH03',1,0,'[[regtime]]','[[regtime]]'),(912,10,'simple','MSH04-32-Gray',0,0,'[[regtime]]','[[regtime]]'),(913,10,'simple','MSH04-32-Purple',0,0,'[[regtime]]','[[regtime]]'),(914,10,'simple','MSH04-32-Yellow',0,0,'[[regtime]]','[[regtime]]'),(915,10,'simple','MSH04-33-Gray',0,0,'[[regtime]]','[[regtime]]'),(916,10,'simple','MSH04-33-Purple',0,0,'[[regtime]]','[[regtime]]'),(917,10,'simple','MSH04-33-Yellow',0,0,'[[regtime]]','[[regtime]]'),(918,10,'simple','MSH04-34-Gray',0,0,'[[regtime]]','[[regtime]]'),(919,10,'simple','MSH04-34-Purple',0,0,'[[regtime]]','[[regtime]]'),(920,10,'simple','MSH04-34-Yellow',0,0,'[[regtime]]','[[regtime]]'),(921,10,'simple','MSH04-36-Gray',0,0,'[[regtime]]','[[regtime]]'),(922,10,'simple','MSH04-36-Purple',0,0,'[[regtime]]','[[regtime]]'),(923,10,'simple','MSH04-36-Yellow',0,0,'[[regtime]]','[[regtime]]'),(924,10,'configurable','MSH04',1,0,'[[regtime]]','[[regtime]]'),(925,10,'simple','MSH05-32-Black',0,0,'[[regtime]]','[[regtime]]'),(926,10,'simple','MSH05-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(927,10,'simple','MSH05-32-Gray',0,0,'[[regtime]]','[[regtime]]'),(928,10,'simple','MSH05-33-Black',0,0,'[[regtime]]','[[regtime]]'),(929,10,'simple','MSH05-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(930,10,'simple','MSH05-33-Gray',0,0,'[[regtime]]','[[regtime]]'),(931,10,'simple','MSH05-34-Black',0,0,'[[regtime]]','[[regtime]]'),(932,10,'simple','MSH05-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(933,10,'simple','MSH05-34-Gray',0,0,'[[regtime]]','[[regtime]]'),(934,10,'simple','MSH05-36-Black',0,0,'[[regtime]]','[[regtime]]'),(935,10,'simple','MSH05-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(936,10,'simple','MSH05-36-Gray',0,0,'[[regtime]]','[[regtime]]'),(937,10,'configurable','MSH05',1,0,'[[regtime]]','[[regtime]]'),(938,10,'simple','MSH06-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(939,10,'simple','MSH06-32-Gray',0,0,'[[regtime]]','[[regtime]]'),(940,10,'simple','MSH06-32-Red',0,0,'[[regtime]]','[[regtime]]'),(941,10,'simple','MSH06-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(942,10,'simple','MSH06-33-Gray',0,0,'[[regtime]]','[[regtime]]'),(943,10,'simple','MSH06-33-Red',0,0,'[[regtime]]','[[regtime]]'),(944,10,'simple','MSH06-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(945,10,'simple','MSH06-34-Gray',0,0,'[[regtime]]','[[regtime]]'),(946,10,'simple','MSH06-34-Red',0,0,'[[regtime]]','[[regtime]]'),(947,10,'simple','MSH06-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(948,10,'simple','MSH06-36-Gray',0,0,'[[regtime]]','[[regtime]]'),(949,10,'simple','MSH06-36-Red',0,0,'[[regtime]]','[[regtime]]'),(950,10,'configurable','MSH06',1,0,'[[regtime]]','[[regtime]]'),(951,10,'simple','MSH07-32-Black',0,0,'[[regtime]]','[[regtime]]'),(952,10,'simple','MSH07-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(953,10,'simple','MSH07-32-Purple',0,0,'[[regtime]]','[[regtime]]'),(954,10,'simple','MSH07-33-Black',0,0,'[[regtime]]','[[regtime]]'),(955,10,'simple','MSH07-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(956,10,'simple','MSH07-33-Purple',0,0,'[[regtime]]','[[regtime]]'),(957,10,'simple','MSH07-34-Black',0,0,'[[regtime]]','[[regtime]]'),(958,10,'simple','MSH07-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(959,10,'simple','MSH07-34-Purple',0,0,'[[regtime]]','[[regtime]]'),(960,10,'simple','MSH07-36-Black',0,0,'[[regtime]]','[[regtime]]'),(961,10,'simple','MSH07-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(962,10,'simple','MSH07-36-Purple',0,0,'[[regtime]]','[[regtime]]'),(963,10,'configurable','MSH07',1,0,'[[regtime]]','[[regtime]]'),(964,10,'simple','MSH08-32-Black',0,0,'[[regtime]]','[[regtime]]'),(965,10,'simple','MSH08-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(966,10,'simple','MSH08-32-Green',0,0,'[[regtime]]','[[regtime]]'),(967,10,'simple','MSH08-33-Black',0,0,'[[regtime]]','[[regtime]]'),(968,10,'simple','MSH08-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(969,10,'simple','MSH08-33-Green',0,0,'[[regtime]]','[[regtime]]'),(970,10,'simple','MSH08-34-Black',0,0,'[[regtime]]','[[regtime]]'),(971,10,'simple','MSH08-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(972,10,'simple','MSH08-34-Green',0,0,'[[regtime]]','[[regtime]]'),(973,10,'simple','MSH08-36-Black',0,0,'[[regtime]]','[[regtime]]'),(974,10,'simple','MSH08-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(975,10,'simple','MSH08-36-Green',0,0,'[[regtime]]','[[regtime]]'),(976,10,'configurable','MSH08',1,0,'[[regtime]]','[[regtime]]'),(977,10,'simple','MSH09-32-Black',0,0,'[[regtime]]','[[regtime]]'),(978,10,'simple','MSH09-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(979,10,'simple','MSH09-32-Green',0,0,'[[regtime]]','[[regtime]]'),(980,10,'simple','MSH09-33-Black',0,0,'[[regtime]]','[[regtime]]'),(981,10,'simple','MSH09-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(982,10,'simple','MSH09-33-Green',0,0,'[[regtime]]','[[regtime]]'),(983,10,'simple','MSH09-34-Black',0,0,'[[regtime]]','[[regtime]]'),(984,10,'simple','MSH09-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(985,10,'simple','MSH09-34-Green',0,0,'[[regtime]]','[[regtime]]'),(986,10,'simple','MSH09-36-Black',0,0,'[[regtime]]','[[regtime]]'),(987,10,'simple','MSH09-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(988,10,'simple','MSH09-36-Green',0,0,'[[regtime]]','[[regtime]]'),(989,10,'configurable','MSH09',1,0,'[[regtime]]','[[regtime]]'),(990,10,'simple','MSH10-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(991,10,'simple','MSH10-32-Green',0,0,'[[regtime]]','[[regtime]]'),(992,10,'simple','MSH10-32-Purple',0,0,'[[regtime]]','[[regtime]]'),(993,10,'simple','MSH10-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(994,10,'simple','MSH10-33-Green',0,0,'[[regtime]]','[[regtime]]'),(995,10,'simple','MSH10-33-Purple',0,0,'[[regtime]]','[[regtime]]'),(996,10,'simple','MSH10-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(997,10,'simple','MSH10-34-Green',0,0,'[[regtime]]','[[regtime]]'),(998,10,'simple','MSH10-34-Purple',0,0,'[[regtime]]','[[regtime]]'),(999,10,'simple','MSH10-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(1000,10,'simple','MSH10-36-Green',0,0,'[[regtime]]','[[regtime]]'),(1001,10,'simple','MSH10-36-Purple',0,0,'[[regtime]]','[[regtime]]'),(1002,10,'configurable','MSH10',1,0,'[[regtime]]','[[regtime]]'),(1003,10,'simple','MSH11-32-Black',0,0,'[[regtime]]','[[regtime]]'),(1004,10,'simple','MSH11-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(1005,10,'simple','MSH11-32-Red',0,0,'[[regtime]]','[[regtime]]'),(1006,10,'simple','MSH11-33-Black',0,0,'[[regtime]]','[[regtime]]'),(1007,10,'simple','MSH11-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(1008,10,'simple','MSH11-33-Red',0,0,'[[regtime]]','[[regtime]]'),(1009,10,'simple','MSH11-34-Black',0,0,'[[regtime]]','[[regtime]]'),(1010,10,'simple','MSH11-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(1011,10,'simple','MSH11-34-Red',0,0,'[[regtime]]','[[regtime]]'),(1012,10,'simple','MSH11-36-Black',0,0,'[[regtime]]','[[regtime]]'),(1013,10,'simple','MSH11-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(1014,10,'simple','MSH11-36-Red',0,0,'[[regtime]]','[[regtime]]'),(1015,10,'configurable','MSH11',1,0,'[[regtime]]','[[regtime]]'),(1016,10,'simple','MSH12-32-Black',0,0,'[[regtime]]','[[regtime]]'),(1017,10,'simple','MSH12-32-Gray',0,0,'[[regtime]]','[[regtime]]'),(1018,10,'simple','MSH12-32-Red',0,0,'[[regtime]]','[[regtime]]'),(1019,10,'simple','MSH12-33-Black',0,0,'[[regtime]]','[[regtime]]'),(1020,10,'simple','MSH12-33-Gray',0,0,'[[regtime]]','[[regtime]]'),(1021,10,'simple','MSH12-33-Red',0,0,'[[regtime]]','[[regtime]]'),(1022,10,'simple','MSH12-34-Black',0,0,'[[regtime]]','[[regtime]]'),(1023,10,'simple','MSH12-34-Gray',0,0,'[[regtime]]','[[regtime]]'),(1024,10,'simple','MSH12-34-Red',0,0,'[[regtime]]','[[regtime]]'),(1025,10,'simple','MSH12-36-Black',0,0,'[[regtime]]','[[regtime]]'),(1026,10,'simple','MSH12-36-Gray',0,0,'[[regtime]]','[[regtime]]'),(1027,10,'simple','MSH12-36-Red',0,0,'[[regtime]]','[[regtime]]'),(1028,10,'configurable','MSH12',1,0,'[[regtime]]','[[regtime]]'),(1029,9,'simple','WH01-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1030,9,'simple','WH01-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1031,9,'simple','WH01-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1032,9,'simple','WH01-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1033,9,'simple','WH01-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1034,9,'simple','WH01-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1035,9,'simple','WH01-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1036,9,'simple','WH01-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1037,9,'simple','WH01-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1038,9,'simple','WH01-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1039,9,'simple','WH01-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1040,9,'simple','WH01-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1041,9,'simple','WH01-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1042,9,'simple','WH01-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1043,9,'simple','WH01-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1044,9,'configurable','WH01',1,0,'[[regtime]]','[[regtime]]'),(1045,9,'simple','WH02-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1046,9,'simple','WH02-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1047,9,'simple','WH02-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1048,9,'simple','WH02-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1049,9,'simple','WH02-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1050,9,'simple','WH02-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1051,9,'simple','WH02-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1052,9,'simple','WH02-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1053,9,'simple','WH02-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1054,9,'simple','WH02-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1055,9,'simple','WH02-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1056,9,'simple','WH02-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1057,9,'simple','WH02-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1058,9,'simple','WH02-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1059,9,'simple','WH02-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1060,9,'configurable','WH02',1,0,'[[regtime]]','[[regtime]]'),(1061,9,'simple','WH03-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1062,9,'simple','WH03-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1063,9,'simple','WH03-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1064,9,'simple','WH03-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1065,9,'simple','WH03-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1066,9,'simple','WH03-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1067,9,'simple','WH03-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1068,9,'simple','WH03-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1069,9,'simple','WH03-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1070,9,'simple','WH03-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1071,9,'simple','WH03-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1072,9,'simple','WH03-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1073,9,'simple','WH03-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1074,9,'simple','WH03-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1075,9,'simple','WH03-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1076,9,'configurable','WH03',1,0,'[[regtime]]','[[regtime]]'),(1077,9,'simple','WH04-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1078,9,'simple','WH04-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1079,9,'simple','WH04-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1080,9,'simple','WH04-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1081,9,'simple','WH04-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1082,9,'simple','WH04-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1083,9,'simple','WH04-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1084,9,'simple','WH04-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1085,9,'simple','WH04-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1086,9,'simple','WH04-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1087,9,'simple','WH04-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1088,9,'simple','WH04-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1089,9,'simple','WH04-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1090,9,'simple','WH04-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1091,9,'simple','WH04-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1092,9,'configurable','WH04',1,0,'[[regtime]]','[[regtime]]'),(1093,9,'simple','WH05-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1094,9,'simple','WH05-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1095,9,'simple','WH05-XS-White',0,0,'[[regtime]]','[[regtime]]'),(1096,9,'simple','WH05-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1097,9,'simple','WH05-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1098,9,'simple','WH05-S-White',0,0,'[[regtime]]','[[regtime]]'),(1099,9,'simple','WH05-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1100,9,'simple','WH05-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1101,9,'simple','WH05-M-White',0,0,'[[regtime]]','[[regtime]]'),(1102,9,'simple','WH05-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1103,9,'simple','WH05-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1104,9,'simple','WH05-L-White',0,0,'[[regtime]]','[[regtime]]'),(1105,9,'simple','WH05-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1106,9,'simple','WH05-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1107,9,'simple','WH05-XL-White',0,0,'[[regtime]]','[[regtime]]'),(1108,9,'configurable','WH05',1,0,'[[regtime]]','[[regtime]]'),(1109,9,'simple','WH06-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1110,9,'simple','WH06-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1111,9,'simple','WH06-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1112,9,'simple','WH06-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1113,9,'simple','WH06-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1114,9,'configurable','WH06',1,0,'[[regtime]]','[[regtime]]'),(1115,9,'simple','WH07-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(1116,9,'simple','WH07-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1117,9,'simple','WH07-XS-White',0,0,'[[regtime]]','[[regtime]]'),(1118,9,'simple','WH07-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(1119,9,'simple','WH07-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1120,9,'simple','WH07-S-White',0,0,'[[regtime]]','[[regtime]]'),(1121,9,'simple','WH07-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(1122,9,'simple','WH07-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1123,9,'simple','WH07-M-White',0,0,'[[regtime]]','[[regtime]]'),(1124,9,'simple','WH07-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(1125,9,'simple','WH07-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1126,9,'simple','WH07-L-White',0,0,'[[regtime]]','[[regtime]]'),(1127,9,'simple','WH07-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(1128,9,'simple','WH07-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1129,9,'simple','WH07-XL-White',0,0,'[[regtime]]','[[regtime]]'),(1130,9,'configurable','WH07',1,0,'[[regtime]]','[[regtime]]'),(1131,9,'simple','WH08-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1132,9,'simple','WH08-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1133,9,'simple','WH08-XS-White',0,0,'[[regtime]]','[[regtime]]'),(1134,9,'simple','WH08-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1135,9,'simple','WH08-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1136,9,'simple','WH08-S-White',0,0,'[[regtime]]','[[regtime]]'),(1137,9,'simple','WH08-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1138,9,'simple','WH08-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1139,9,'simple','WH08-M-White',0,0,'[[regtime]]','[[regtime]]'),(1140,9,'simple','WH08-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1141,9,'simple','WH08-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1142,9,'simple','WH08-L-White',0,0,'[[regtime]]','[[regtime]]'),(1143,9,'simple','WH08-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1144,9,'simple','WH08-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1145,9,'simple','WH08-XL-White',0,0,'[[regtime]]','[[regtime]]'),(1146,9,'configurable','WH08',1,0,'[[regtime]]','[[regtime]]'),(1147,9,'simple','WH09-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1148,9,'simple','WH09-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1149,9,'simple','WH09-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1150,9,'simple','WH09-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1151,9,'simple','WH09-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1152,9,'simple','WH09-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1153,9,'simple','WH09-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1154,9,'simple','WH09-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1155,9,'simple','WH09-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1156,9,'simple','WH09-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1157,9,'simple','WH09-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1158,9,'simple','WH09-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1159,9,'simple','WH09-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1160,9,'simple','WH09-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1161,9,'simple','WH09-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1162,9,'configurable','WH09',1,0,'[[regtime]]','[[regtime]]'),(1163,9,'simple','WH10-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1164,9,'simple','WH10-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(1165,9,'simple','WH10-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1166,9,'simple','WH10-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1167,9,'simple','WH10-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(1168,9,'simple','WH10-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1169,9,'simple','WH10-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1170,9,'simple','WH10-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(1171,9,'simple','WH10-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1172,9,'simple','WH10-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1173,9,'simple','WH10-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(1174,9,'simple','WH10-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1175,9,'simple','WH10-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1176,9,'simple','WH10-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(1177,9,'simple','WH10-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1178,9,'configurable','WH10',1,0,'[[regtime]]','[[regtime]]'),(1179,9,'simple','WH11-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1180,9,'simple','WH11-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1181,9,'simple','WH11-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1182,9,'simple','WH11-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1183,9,'simple','WH11-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1184,9,'simple','WH11-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1185,9,'simple','WH11-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1186,9,'simple','WH11-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1187,9,'simple','WH11-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1188,9,'simple','WH11-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1189,9,'simple','WH11-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1190,9,'simple','WH11-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1191,9,'simple','WH11-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1192,9,'simple','WH11-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1193,9,'simple','WH11-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1194,9,'configurable','WH11',1,0,'[[regtime]]','[[regtime]]'),(1195,9,'simple','WH12-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(1196,9,'simple','WH12-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1197,9,'simple','WH12-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1198,9,'simple','WH12-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(1199,9,'simple','WH12-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1200,9,'simple','WH12-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1201,9,'simple','WH12-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(1202,9,'simple','WH12-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1203,9,'simple','WH12-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1204,9,'simple','WH12-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(1205,9,'simple','WH12-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1206,9,'simple','WH12-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1207,9,'simple','WH12-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(1208,9,'simple','WH12-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1209,9,'simple','WH12-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1210,9,'configurable','WH12',1,0,'[[regtime]]','[[regtime]]'),(1211,9,'simple','WJ01-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1212,9,'simple','WJ01-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1213,9,'simple','WJ01-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1214,9,'simple','WJ01-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1215,9,'simple','WJ01-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1216,9,'simple','WJ01-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1217,9,'simple','WJ01-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1218,9,'simple','WJ01-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1219,9,'simple','WJ01-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1220,9,'configurable','WJ01',1,0,'[[regtime]]','[[regtime]]'),(1221,9,'simple','WJ02-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1222,9,'simple','WJ02-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1223,9,'simple','WJ02-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(1224,9,'simple','WJ02-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1225,9,'simple','WJ02-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1226,9,'simple','WJ02-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(1227,9,'simple','WJ02-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1228,9,'simple','WJ02-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1229,9,'simple','WJ02-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(1230,9,'simple','WJ02-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1231,9,'simple','WJ02-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1232,9,'simple','WJ02-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(1233,9,'simple','WJ02-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1234,9,'simple','WJ02-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1235,9,'simple','WJ02-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(1236,9,'configurable','WJ02',1,0,'[[regtime]]','[[regtime]]'),(1237,9,'simple','WJ03-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1238,9,'simple','WJ03-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1239,9,'simple','WJ03-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1240,9,'simple','WJ03-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1241,9,'simple','WJ03-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1242,9,'simple','WJ03-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1243,9,'simple','WJ03-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1244,9,'simple','WJ03-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1245,9,'simple','WJ03-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1246,9,'simple','WJ03-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1247,9,'simple','WJ03-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1248,9,'simple','WJ03-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1249,9,'simple','WJ03-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1250,9,'simple','WJ03-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1251,9,'simple','WJ03-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1252,9,'configurable','WJ03',1,0,'[[regtime]]','[[regtime]]'),(1253,9,'simple','WJ04-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1254,9,'simple','WJ04-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1255,9,'simple','WJ04-XS-White',0,0,'[[regtime]]','[[regtime]]'),(1256,9,'simple','WJ04-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1257,9,'simple','WJ04-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1258,9,'simple','WJ04-S-White',0,0,'[[regtime]]','[[regtime]]'),(1259,9,'simple','WJ04-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1260,9,'simple','WJ04-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1261,9,'simple','WJ04-M-White',0,0,'[[regtime]]','[[regtime]]'),(1262,9,'simple','WJ04-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1263,9,'simple','WJ04-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1264,9,'simple','WJ04-L-White',0,0,'[[regtime]]','[[regtime]]'),(1265,9,'simple','WJ04-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1266,9,'simple','WJ04-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1267,9,'simple','WJ04-XL-White',0,0,'[[regtime]]','[[regtime]]'),(1268,9,'configurable','WJ04',1,0,'[[regtime]]','[[regtime]]'),(1269,9,'simple','WJ05-XS-Brown',0,0,'[[regtime]]','[[regtime]]'),(1270,9,'simple','WJ05-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1271,9,'simple','WJ05-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1272,9,'simple','WJ05-S-Brown',0,0,'[[regtime]]','[[regtime]]'),(1273,9,'simple','WJ05-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1274,9,'simple','WJ05-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1275,9,'simple','WJ05-M-Brown',0,0,'[[regtime]]','[[regtime]]'),(1276,9,'simple','WJ05-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1277,9,'simple','WJ05-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1278,9,'simple','WJ05-L-Brown',0,0,'[[regtime]]','[[regtime]]'),(1279,9,'simple','WJ05-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1280,9,'simple','WJ05-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1281,9,'simple','WJ05-XL-Brown',0,0,'[[regtime]]','[[regtime]]'),(1282,9,'simple','WJ05-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1283,9,'simple','WJ05-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1284,9,'configurable','WJ05',1,0,'[[regtime]]','[[regtime]]'),(1285,9,'simple','WJ07-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1286,9,'simple','WJ07-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1287,9,'simple','WJ07-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1288,9,'simple','WJ07-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1289,9,'simple','WJ07-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1290,9,'simple','WJ07-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1291,9,'simple','WJ07-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1292,9,'simple','WJ07-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1293,9,'simple','WJ07-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1294,9,'simple','WJ07-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1295,9,'simple','WJ07-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1296,9,'simple','WJ07-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1297,9,'simple','WJ07-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1298,9,'simple','WJ07-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1299,9,'simple','WJ07-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1300,9,'configurable','WJ07',1,0,'[[regtime]]','[[regtime]]'),(1301,9,'simple','WJ08-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(1302,9,'simple','WJ08-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1303,9,'simple','WJ08-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1304,9,'simple','WJ08-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(1305,9,'simple','WJ08-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1306,9,'simple','WJ08-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1307,9,'simple','WJ08-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(1308,9,'simple','WJ08-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1309,9,'simple','WJ08-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1310,9,'simple','WJ08-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(1311,9,'simple','WJ08-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1312,9,'simple','WJ08-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1313,9,'simple','WJ08-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(1314,9,'simple','WJ08-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1315,9,'simple','WJ08-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1316,9,'configurable','WJ08',1,0,'[[regtime]]','[[regtime]]'),(1317,9,'simple','WJ09-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1318,9,'simple','WJ09-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(1319,9,'simple','WJ09-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1320,9,'simple','WJ09-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1321,9,'simple','WJ09-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(1322,9,'simple','WJ09-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1323,9,'simple','WJ09-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1324,9,'simple','WJ09-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(1325,9,'simple','WJ09-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1326,9,'simple','WJ09-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1327,9,'simple','WJ09-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(1328,9,'simple','WJ09-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1329,9,'simple','WJ09-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1330,9,'simple','WJ09-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(1331,9,'simple','WJ09-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1332,9,'configurable','WJ09',1,0,'[[regtime]]','[[regtime]]'),(1333,9,'simple','WJ10-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1334,9,'simple','WJ10-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1335,9,'simple','WJ10-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1336,9,'simple','WJ10-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1337,9,'simple','WJ10-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1338,9,'simple','WJ10-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1339,9,'simple','WJ10-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1340,9,'simple','WJ10-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1341,9,'simple','WJ10-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1342,9,'simple','WJ10-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1343,9,'simple','WJ10-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1344,9,'simple','WJ10-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1345,9,'simple','WJ10-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1346,9,'simple','WJ10-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1347,9,'simple','WJ10-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1348,9,'configurable','WJ10',1,0,'[[regtime]]','[[regtime]]'),(1349,9,'simple','WJ11-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1350,9,'simple','WJ11-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1351,9,'simple','WJ11-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1352,9,'simple','WJ11-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1353,9,'simple','WJ11-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1354,9,'simple','WJ11-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1355,9,'simple','WJ11-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1356,9,'simple','WJ11-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1357,9,'simple','WJ11-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1358,9,'simple','WJ11-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1359,9,'simple','WJ11-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1360,9,'simple','WJ11-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1361,9,'simple','WJ11-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1362,9,'simple','WJ11-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1363,9,'simple','WJ11-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1364,9,'configurable','WJ11',1,0,'[[regtime]]','[[regtime]]'),(1365,9,'simple','WJ06-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1366,9,'simple','WJ06-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1367,9,'simple','WJ06-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1368,9,'simple','WJ06-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1369,9,'simple','WJ06-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1370,9,'simple','WJ06-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1371,9,'simple','WJ06-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1372,9,'simple','WJ06-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1373,9,'simple','WJ06-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1374,9,'simple','WJ06-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1375,9,'simple','WJ06-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1376,9,'simple','WJ06-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1377,9,'simple','WJ06-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1378,9,'simple','WJ06-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1379,9,'simple','WJ06-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1380,9,'configurable','WJ06',1,0,'[[regtime]]','[[regtime]]'),(1381,9,'simple','WJ12-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1382,9,'simple','WJ12-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1383,9,'simple','WJ12-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1384,9,'simple','WJ12-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1385,9,'simple','WJ12-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1386,9,'simple','WJ12-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1387,9,'simple','WJ12-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1388,9,'simple','WJ12-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1389,9,'simple','WJ12-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1390,9,'simple','WJ12-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1391,9,'simple','WJ12-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1392,9,'simple','WJ12-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1393,9,'simple','WJ12-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1394,9,'simple','WJ12-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1395,9,'simple','WJ12-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1396,9,'configurable','WJ12',1,0,'[[regtime]]','[[regtime]]'),(1397,9,'simple','WS02-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1398,9,'simple','WS02-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1399,9,'simple','WS02-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1400,9,'simple','WS02-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1401,9,'simple','WS02-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1402,9,'simple','WS02-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1403,9,'simple','WS02-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1404,9,'simple','WS02-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1405,9,'simple','WS02-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1406,9,'simple','WS02-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1407,9,'simple','WS02-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1408,9,'simple','WS02-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1409,9,'simple','WS02-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1410,9,'simple','WS02-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1411,9,'simple','WS02-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1412,9,'configurable','WS02',1,0,'[[regtime]]','[[regtime]]'),(1413,9,'simple','WS03-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1414,9,'simple','WS03-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1415,9,'simple','WS03-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1416,9,'simple','WS03-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1417,9,'simple','WS03-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1418,9,'simple','WS03-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1419,9,'simple','WS03-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1420,9,'simple','WS03-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1421,9,'simple','WS03-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1422,9,'simple','WS03-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1423,9,'simple','WS03-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1424,9,'simple','WS03-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1425,9,'simple','WS03-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1426,9,'simple','WS03-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1427,9,'simple','WS03-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1428,9,'configurable','WS03',1,0,'[[regtime]]','[[regtime]]'),(1429,9,'simple','WS04-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1430,9,'simple','WS04-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1431,9,'simple','WS04-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1432,9,'simple','WS04-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1433,9,'simple','WS04-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1434,9,'simple','WS04-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1435,9,'simple','WS04-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1436,9,'simple','WS04-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1437,9,'simple','WS04-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1438,9,'simple','WS04-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1439,9,'simple','WS04-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1440,9,'simple','WS04-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1441,9,'simple','WS04-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1442,9,'simple','WS04-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1443,9,'simple','WS04-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1444,9,'configurable','WS04',1,0,'[[regtime]]','[[regtime]]'),(1445,9,'simple','WS06-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(1446,9,'simple','WS06-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1447,9,'simple','WS06-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1448,9,'simple','WS06-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(1449,9,'simple','WS06-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1450,9,'simple','WS06-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1451,9,'simple','WS06-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(1452,9,'simple','WS06-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1453,9,'simple','WS06-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1454,9,'simple','WS06-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(1455,9,'simple','WS06-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1456,9,'simple','WS06-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1457,9,'simple','WS06-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(1458,9,'simple','WS06-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1459,9,'simple','WS06-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1460,9,'configurable','WS06',1,0,'[[regtime]]','[[regtime]]'),(1461,9,'simple','WS07-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1462,9,'simple','WS07-XS-White',0,0,'[[regtime]]','[[regtime]]'),(1463,9,'simple','WS07-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1464,9,'simple','WS07-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1465,9,'simple','WS07-S-White',0,0,'[[regtime]]','[[regtime]]'),(1466,9,'simple','WS07-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1467,9,'simple','WS07-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1468,9,'simple','WS07-M-White',0,0,'[[regtime]]','[[regtime]]'),(1469,9,'simple','WS07-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1470,9,'simple','WS07-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1471,9,'simple','WS07-L-White',0,0,'[[regtime]]','[[regtime]]'),(1472,9,'simple','WS07-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1473,9,'simple','WS07-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1474,9,'simple','WS07-XL-White',0,0,'[[regtime]]','[[regtime]]'),(1475,9,'simple','WS07-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1476,9,'configurable','WS07',1,0,'[[regtime]]','[[regtime]]'),(1477,9,'simple','WS08-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1478,9,'simple','WS08-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1479,9,'simple','WS08-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1480,9,'simple','WS08-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1481,9,'simple','WS08-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1482,9,'simple','WS08-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1483,9,'simple','WS08-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1484,9,'simple','WS08-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1485,9,'simple','WS08-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1486,9,'simple','WS08-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1487,9,'simple','WS08-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1488,9,'simple','WS08-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1489,9,'simple','WS08-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1490,9,'simple','WS08-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1491,9,'simple','WS08-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1492,9,'configurable','WS08',1,0,'[[regtime]]','[[regtime]]'),(1493,9,'simple','WS09-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1494,9,'simple','WS09-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1495,9,'simple','WS09-XS-White',0,0,'[[regtime]]','[[regtime]]'),(1496,9,'simple','WS09-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1497,9,'simple','WS09-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1498,9,'simple','WS09-S-White',0,0,'[[regtime]]','[[regtime]]'),(1499,9,'simple','WS09-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1500,9,'simple','WS09-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1501,9,'simple','WS09-M-White',0,0,'[[regtime]]','[[regtime]]'),(1502,9,'simple','WS09-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1503,9,'simple','WS09-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1504,9,'simple','WS09-L-White',0,0,'[[regtime]]','[[regtime]]'),(1505,9,'simple','WS09-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1506,9,'simple','WS09-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1507,9,'simple','WS09-XL-White',0,0,'[[regtime]]','[[regtime]]'),(1508,9,'configurable','WS09',1,0,'[[regtime]]','[[regtime]]'),(1509,9,'simple','WS10-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1510,9,'simple','WS10-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1511,9,'simple','WS10-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1512,9,'simple','WS10-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1513,9,'simple','WS10-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1514,9,'simple','WS10-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1515,9,'simple','WS10-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1516,9,'simple','WS10-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1517,9,'simple','WS10-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1518,9,'simple','WS10-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1519,9,'simple','WS10-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1520,9,'simple','WS10-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1521,9,'simple','WS10-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1522,9,'simple','WS10-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1523,9,'simple','WS10-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1524,9,'configurable','WS10',1,0,'[[regtime]]','[[regtime]]'),(1525,9,'simple','WS11-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1526,9,'simple','WS11-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1527,9,'simple','WS11-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1528,9,'simple','WS11-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1529,9,'simple','WS11-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1530,9,'simple','WS11-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1531,9,'simple','WS11-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1532,9,'simple','WS11-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1533,9,'simple','WS11-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1534,9,'simple','WS11-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1535,9,'simple','WS11-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1536,9,'simple','WS11-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1537,9,'simple','WS11-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1538,9,'simple','WS11-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1539,9,'simple','WS11-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1540,9,'configurable','WS11',1,0,'[[regtime]]','[[regtime]]'),(1541,9,'simple','WS12-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1542,9,'simple','WS12-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1543,9,'simple','WS12-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1544,9,'simple','WS12-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1545,9,'simple','WS12-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1546,9,'simple','WS12-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1547,9,'simple','WS12-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1548,9,'simple','WS12-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1549,9,'simple','WS12-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1550,9,'simple','WS12-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1551,9,'simple','WS12-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1552,9,'simple','WS12-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1553,9,'simple','WS12-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1554,9,'simple','WS12-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1555,9,'simple','WS12-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1556,9,'configurable','WS12',1,0,'[[regtime]]','[[regtime]]'),(1557,9,'simple','WS01-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1558,9,'simple','WS01-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1559,9,'simple','WS01-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1560,9,'simple','WS01-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1561,9,'simple','WS01-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1562,9,'simple','WS01-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1563,9,'simple','WS01-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1564,9,'simple','WS01-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1565,9,'simple','WS01-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1566,9,'simple','WS01-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1567,9,'simple','WS01-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1568,9,'simple','WS01-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1569,9,'simple','WS01-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1570,9,'simple','WS01-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1571,9,'simple','WS01-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1572,9,'configurable','WS01',1,0,'[[regtime]]','[[regtime]]'),(1573,9,'simple','WS05-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1574,9,'simple','WS05-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1575,9,'simple','WS05-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1576,9,'simple','WS05-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1577,9,'simple','WS05-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1578,9,'simple','WS05-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1579,9,'simple','WS05-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1580,9,'simple','WS05-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1581,9,'simple','WS05-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1582,9,'simple','WS05-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1583,9,'simple','WS05-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1584,9,'simple','WS05-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1585,9,'simple','WS05-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1586,9,'simple','WS05-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1587,9,'simple','WS05-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1588,9,'configurable','WS05',1,0,'[[regtime]]','[[regtime]]'),(1589,9,'simple','WB01-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1590,9,'simple','WB01-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(1591,9,'simple','WB01-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1592,9,'simple','WB01-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1593,9,'simple','WB01-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(1594,9,'simple','WB01-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1595,9,'simple','WB01-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1596,9,'simple','WB01-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(1597,9,'simple','WB01-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1598,9,'simple','WB01-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1599,9,'simple','WB01-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(1600,9,'simple','WB01-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1601,9,'simple','WB01-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1602,9,'simple','WB01-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(1603,9,'simple','WB01-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1604,9,'configurable','WB01',1,0,'[[regtime]]','[[regtime]]'),(1605,9,'simple','WB02-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1606,9,'simple','WB02-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1607,9,'simple','WB02-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1608,9,'simple','WB02-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1609,9,'simple','WB02-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1610,9,'simple','WB02-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1611,9,'simple','WB02-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1612,9,'simple','WB02-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1613,9,'simple','WB02-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1614,9,'simple','WB02-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1615,9,'simple','WB02-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1616,9,'simple','WB02-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1617,9,'simple','WB02-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1618,9,'simple','WB02-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1619,9,'simple','WB02-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1620,9,'configurable','WB02',1,0,'[[regtime]]','[[regtime]]'),(1621,9,'simple','WB03-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1622,9,'simple','WB03-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1623,9,'simple','WB03-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1624,9,'simple','WB03-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1625,9,'simple','WB03-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1626,9,'simple','WB03-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1627,9,'simple','WB03-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1628,9,'simple','WB03-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1629,9,'simple','WB03-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1630,9,'simple','WB03-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1631,9,'simple','WB03-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1632,9,'simple','WB03-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1633,9,'simple','WB03-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1634,9,'simple','WB03-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1635,9,'simple','WB03-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1636,9,'configurable','WB03',1,0,'[[regtime]]','[[regtime]]'),(1637,9,'simple','WB04-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1638,9,'simple','WB04-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1639,9,'simple','WB04-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1640,9,'simple','WB04-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1641,9,'simple','WB04-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1642,9,'simple','WB04-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1643,9,'simple','WB04-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1644,9,'simple','WB04-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1645,9,'simple','WB04-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1646,9,'simple','WB04-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1647,9,'simple','WB04-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1648,9,'simple','WB04-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1649,9,'simple','WB04-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1650,9,'simple','WB04-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1651,9,'simple','WB04-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1652,9,'configurable','WB04',1,0,'[[regtime]]','[[regtime]]'),(1653,9,'simple','WB05-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1654,9,'simple','WB05-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1655,9,'simple','WB05-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1656,9,'simple','WB05-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1657,9,'simple','WB05-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1658,9,'simple','WB05-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1659,9,'simple','WB05-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1660,9,'simple','WB05-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1661,9,'simple','WB05-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1662,9,'simple','WB05-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1663,9,'simple','WB05-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1664,9,'simple','WB05-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1665,9,'simple','WB05-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1666,9,'simple','WB05-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1667,9,'simple','WB05-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1668,9,'configurable','WB05',1,0,'[[regtime]]','[[regtime]]'),(1669,9,'simple','WT01-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1670,9,'simple','WT01-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1671,9,'simple','WT01-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1672,9,'simple','WT01-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1673,9,'simple','WT01-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1674,9,'simple','WT01-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1675,9,'simple','WT01-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1676,9,'simple','WT01-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1677,9,'simple','WT01-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1678,9,'simple','WT01-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1679,9,'simple','WT01-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1680,9,'simple','WT01-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1681,9,'simple','WT01-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1682,9,'simple','WT01-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1683,9,'simple','WT01-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1684,9,'configurable','WT01',1,0,'[[regtime]]','[[regtime]]'),(1685,9,'simple','WT02-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1686,9,'simple','WT02-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1687,9,'simple','WT02-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1688,9,'simple','WT02-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1689,9,'simple','WT02-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1690,9,'simple','WT02-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1691,9,'simple','WT02-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1692,9,'simple','WT02-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1693,9,'simple','WT02-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1694,9,'simple','WT02-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1695,9,'simple','WT02-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1696,9,'simple','WT02-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1697,9,'simple','WT02-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1698,9,'simple','WT02-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1699,9,'simple','WT02-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1700,9,'configurable','WT02',1,0,'[[regtime]]','[[regtime]]'),(1701,9,'simple','WT03-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1702,9,'simple','WT03-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1703,9,'simple','WT03-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1704,9,'simple','WT03-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1705,9,'simple','WT03-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1706,9,'simple','WT03-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1707,9,'simple','WT03-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1708,9,'simple','WT03-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1709,9,'simple','WT03-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1710,9,'simple','WT03-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1711,9,'simple','WT03-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1712,9,'simple','WT03-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1713,9,'simple','WT03-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1714,9,'simple','WT03-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1715,9,'simple','WT03-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1716,9,'configurable','WT03',1,0,'[[regtime]]','[[regtime]]'),(1717,9,'simple','WT04-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1718,9,'simple','WT04-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1719,9,'simple','WT04-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1720,9,'simple','WT04-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1721,9,'simple','WT04-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1722,9,'simple','WT04-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1723,9,'simple','WT04-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1724,9,'simple','WT04-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1725,9,'simple','WT04-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1726,9,'simple','WT04-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1727,9,'simple','WT04-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1728,9,'simple','WT04-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1729,9,'simple','WT04-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1730,9,'simple','WT04-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1731,9,'simple','WT04-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1732,9,'configurable','WT04',1,0,'[[regtime]]','[[regtime]]'),(1733,9,'simple','WT05-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1734,9,'simple','WT05-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1735,9,'simple','WT05-XS-White',0,0,'[[regtime]]','[[regtime]]'),(1736,9,'simple','WT05-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1737,9,'simple','WT05-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1738,9,'simple','WT05-S-White',0,0,'[[regtime]]','[[regtime]]'),(1739,9,'simple','WT05-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1740,9,'simple','WT05-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1741,9,'simple','WT05-M-White',0,0,'[[regtime]]','[[regtime]]'),(1742,9,'simple','WT05-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1743,9,'simple','WT05-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1744,9,'simple','WT05-L-White',0,0,'[[regtime]]','[[regtime]]'),(1745,9,'simple','WT05-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1746,9,'simple','WT05-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1747,9,'simple','WT05-XL-White',0,0,'[[regtime]]','[[regtime]]'),(1748,9,'configurable','WT05',1,0,'[[regtime]]','[[regtime]]'),(1749,9,'simple','WT06-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1750,9,'simple','WT06-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1751,9,'simple','WT06-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1752,9,'simple','WT06-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1753,9,'simple','WT06-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1754,9,'simple','WT06-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1755,9,'simple','WT06-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1756,9,'simple','WT06-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1757,9,'simple','WT06-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1758,9,'simple','WT06-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1759,9,'simple','WT06-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1760,9,'simple','WT06-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1761,9,'simple','WT06-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1762,9,'simple','WT06-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1763,9,'simple','WT06-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1764,9,'configurable','WT06',1,0,'[[regtime]]','[[regtime]]'),(1765,9,'simple','WT07-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1766,9,'simple','WT07-XS-White',0,0,'[[regtime]]','[[regtime]]'),(1767,9,'simple','WT07-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1768,9,'simple','WT07-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1769,9,'simple','WT07-S-White',0,0,'[[regtime]]','[[regtime]]'),(1770,9,'simple','WT07-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1771,9,'simple','WT07-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1772,9,'simple','WT07-M-White',0,0,'[[regtime]]','[[regtime]]'),(1773,9,'simple','WT07-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1774,9,'simple','WT07-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1775,9,'simple','WT07-L-White',0,0,'[[regtime]]','[[regtime]]'),(1776,9,'simple','WT07-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1777,9,'simple','WT07-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1778,9,'simple','WT07-XL-White',0,0,'[[regtime]]','[[regtime]]'),(1779,9,'simple','WT07-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1780,9,'configurable','WT07',1,0,'[[regtime]]','[[regtime]]'),(1781,9,'simple','WT08-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1782,9,'simple','WT08-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1783,9,'simple','WT08-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1784,9,'simple','WT08-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1785,9,'simple','WT08-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1786,9,'simple','WT08-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1787,9,'simple','WT08-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1788,9,'simple','WT08-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1789,9,'simple','WT08-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1790,9,'simple','WT08-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1791,9,'simple','WT08-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1792,9,'simple','WT08-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1793,9,'simple','WT08-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1794,9,'simple','WT08-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1795,9,'simple','WT08-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1796,9,'configurable','WT08',1,0,'[[regtime]]','[[regtime]]'),(1797,9,'simple','WT09-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1798,9,'simple','WT09-XS-White',0,0,'[[regtime]]','[[regtime]]'),(1799,9,'simple','WT09-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1800,9,'simple','WT09-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1801,9,'simple','WT09-S-White',0,0,'[[regtime]]','[[regtime]]'),(1802,9,'simple','WT09-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1803,9,'simple','WT09-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1804,9,'simple','WT09-M-White',0,0,'[[regtime]]','[[regtime]]'),(1805,9,'simple','WT09-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1806,9,'simple','WT09-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1807,9,'simple','WT09-L-White',0,0,'[[regtime]]','[[regtime]]'),(1808,9,'simple','WT09-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1809,9,'simple','WT09-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1810,9,'simple','WT09-XL-White',0,0,'[[regtime]]','[[regtime]]'),(1811,9,'simple','WT09-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1812,9,'configurable','WT09',1,0,'[[regtime]]','[[regtime]]'),(1813,10,'simple','WP01-28-Black',0,0,'[[regtime]]','[[regtime]]'),(1814,10,'simple','WP01-28-Gray',0,0,'[[regtime]]','[[regtime]]'),(1815,10,'simple','WP01-28-White',0,0,'[[regtime]]','[[regtime]]'),(1816,10,'simple','WP01-29-Black',0,0,'[[regtime]]','[[regtime]]'),(1817,10,'simple','WP01-29-Gray',0,0,'[[regtime]]','[[regtime]]'),(1818,10,'simple','WP01-29-White',0,0,'[[regtime]]','[[regtime]]'),(1819,10,'configurable','WP01',1,0,'[[regtime]]','[[regtime]]'),(1820,10,'simple','WP02-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1821,10,'simple','WP02-28-Purple',0,0,'[[regtime]]','[[regtime]]'),(1822,10,'simple','WP02-28-Red',0,0,'[[regtime]]','[[regtime]]'),(1823,10,'simple','WP02-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1824,10,'simple','WP02-29-Purple',0,0,'[[regtime]]','[[regtime]]'),(1825,10,'simple','WP02-29-Red',0,0,'[[regtime]]','[[regtime]]'),(1826,10,'configurable','WP02',1,0,'[[regtime]]','[[regtime]]'),(1827,10,'simple','WP03-28-Black',0,0,'[[regtime]]','[[regtime]]'),(1828,10,'simple','WP03-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1829,10,'simple','WP03-28-Purple',0,0,'[[regtime]]','[[regtime]]'),(1830,10,'simple','WP03-29-Black',0,0,'[[regtime]]','[[regtime]]'),(1831,10,'simple','WP03-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1832,10,'simple','WP03-29-Purple',0,0,'[[regtime]]','[[regtime]]'),(1833,10,'configurable','WP03',1,0,'[[regtime]]','[[regtime]]'),(1834,10,'simple','WP04-28-Black',0,0,'[[regtime]]','[[regtime]]'),(1835,10,'simple','WP04-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1836,10,'simple','WP04-28-White',0,0,'[[regtime]]','[[regtime]]'),(1837,10,'simple','WP04-29-Black',0,0,'[[regtime]]','[[regtime]]'),(1838,10,'simple','WP04-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1839,10,'simple','WP04-29-White',0,0,'[[regtime]]','[[regtime]]'),(1840,10,'configurable','WP04',1,0,'[[regtime]]','[[regtime]]'),(1841,10,'simple','WP05-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1842,10,'simple','WP05-28-Gray',0,0,'[[regtime]]','[[regtime]]'),(1843,10,'simple','WP05-28-Red',0,0,'[[regtime]]','[[regtime]]'),(1844,10,'simple','WP05-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1845,10,'simple','WP05-29-Gray',0,0,'[[regtime]]','[[regtime]]'),(1846,10,'simple','WP05-29-Red',0,0,'[[regtime]]','[[regtime]]'),(1847,10,'configurable','WP05',1,0,'[[regtime]]','[[regtime]]'),(1848,10,'simple','WP06-28-Black',0,0,'[[regtime]]','[[regtime]]'),(1849,10,'simple','WP06-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1850,10,'simple','WP06-28-Orange',0,0,'[[regtime]]','[[regtime]]'),(1851,10,'simple','WP06-29-Black',0,0,'[[regtime]]','[[regtime]]'),(1852,10,'simple','WP06-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1853,10,'simple','WP06-29-Orange',0,0,'[[regtime]]','[[regtime]]'),(1854,10,'configurable','WP06',1,0,'[[regtime]]','[[regtime]]'),(1855,10,'simple','WP07-28-Black',0,0,'[[regtime]]','[[regtime]]'),(1856,10,'simple','WP07-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1857,10,'simple','WP07-28-Orange',0,0,'[[regtime]]','[[regtime]]'),(1858,10,'simple','WP07-29-Black',0,0,'[[regtime]]','[[regtime]]'),(1859,10,'simple','WP07-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1860,10,'simple','WP07-29-Orange',0,0,'[[regtime]]','[[regtime]]'),(1861,10,'configurable','WP07',1,0,'[[regtime]]','[[regtime]]'),(1862,10,'simple','WP08-28-Black',0,0,'[[regtime]]','[[regtime]]'),(1863,10,'simple','WP08-28-Green',0,0,'[[regtime]]','[[regtime]]'),(1864,10,'simple','WP08-28-Red',0,0,'[[regtime]]','[[regtime]]'),(1865,10,'simple','WP08-29-Black',0,0,'[[regtime]]','[[regtime]]'),(1866,10,'simple','WP08-29-Green',0,0,'[[regtime]]','[[regtime]]'),(1867,10,'simple','WP08-29-Red',0,0,'[[regtime]]','[[regtime]]'),(1868,10,'configurable','WP08',1,0,'[[regtime]]','[[regtime]]'),(1869,10,'simple','WP09-28-Black',0,0,'[[regtime]]','[[regtime]]'),(1870,10,'simple','WP09-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1871,10,'simple','WP09-28-Purple',0,0,'[[regtime]]','[[regtime]]'),(1872,10,'simple','WP09-29-Black',0,0,'[[regtime]]','[[regtime]]'),(1873,10,'simple','WP09-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1874,10,'simple','WP09-29-Purple',0,0,'[[regtime]]','[[regtime]]'),(1875,10,'configurable','WP09',1,0,'[[regtime]]','[[regtime]]'),(1876,10,'simple','WP10-28-Black',0,0,'[[regtime]]','[[regtime]]'),(1877,10,'simple','WP10-28-Gray',0,0,'[[regtime]]','[[regtime]]'),(1878,10,'simple','WP10-28-White',0,0,'[[regtime]]','[[regtime]]'),(1879,10,'simple','WP10-29-Black',0,0,'[[regtime]]','[[regtime]]'),(1880,10,'simple','WP10-29-Gray',0,0,'[[regtime]]','[[regtime]]'),(1881,10,'simple','WP10-29-White',0,0,'[[regtime]]','[[regtime]]'),(1882,10,'configurable','WP10',1,0,'[[regtime]]','[[regtime]]'),(1883,10,'simple','WP11-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1884,10,'simple','WP11-28-Green',0,0,'[[regtime]]','[[regtime]]'),(1885,10,'simple','WP11-28-Red',0,0,'[[regtime]]','[[regtime]]'),(1886,10,'simple','WP11-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1887,10,'simple','WP11-29-Green',0,0,'[[regtime]]','[[regtime]]'),(1888,10,'simple','WP11-29-Red',0,0,'[[regtime]]','[[regtime]]'),(1889,10,'configurable','WP11',1,0,'[[regtime]]','[[regtime]]'),(1890,10,'simple','WP12-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1891,10,'simple','WP12-28-Gray',0,0,'[[regtime]]','[[regtime]]'),(1892,10,'simple','WP12-28-Green',0,0,'[[regtime]]','[[regtime]]'),(1893,10,'simple','WP12-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1894,10,'simple','WP12-29-Gray',0,0,'[[regtime]]','[[regtime]]'),(1895,10,'simple','WP12-29-Green',0,0,'[[regtime]]','[[regtime]]'),(1896,10,'configurable','WP12',1,0,'[[regtime]]','[[regtime]]'),(1897,10,'simple','WP13-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1898,10,'simple','WP13-28-Green',0,0,'[[regtime]]','[[regtime]]'),(1899,10,'simple','WP13-28-Orange',0,0,'[[regtime]]','[[regtime]]'),(1900,10,'simple','WP13-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1901,10,'simple','WP13-29-Green',0,0,'[[regtime]]','[[regtime]]'),(1902,10,'simple','WP13-29-Orange',0,0,'[[regtime]]','[[regtime]]'),(1903,10,'configurable','WP13',1,0,'[[regtime]]','[[regtime]]'),(1904,10,'simple','WSH01-28-Black',0,0,'[[regtime]]','[[regtime]]'),(1905,10,'simple','WSH01-28-Green',0,0,'[[regtime]]','[[regtime]]'),(1906,10,'simple','WSH01-28-Red',0,0,'[[regtime]]','[[regtime]]'),(1907,10,'simple','WSH01-29-Black',0,0,'[[regtime]]','[[regtime]]'),(1908,10,'simple','WSH01-29-Green',0,0,'[[regtime]]','[[regtime]]'),(1909,10,'simple','WSH01-29-Red',0,0,'[[regtime]]','[[regtime]]'),(1910,10,'simple','WSH01-30-Black',0,0,'[[regtime]]','[[regtime]]'),(1911,10,'simple','WSH01-30-Green',0,0,'[[regtime]]','[[regtime]]'),(1912,10,'simple','WSH01-30-Red',0,0,'[[regtime]]','[[regtime]]'),(1913,10,'simple','WSH01-31-Black',0,0,'[[regtime]]','[[regtime]]'),(1914,10,'simple','WSH01-31-Green',0,0,'[[regtime]]','[[regtime]]'),(1915,10,'simple','WSH01-31-Red',0,0,'[[regtime]]','[[regtime]]'),(1916,10,'simple','WSH01-32-Black',0,0,'[[regtime]]','[[regtime]]'),(1917,10,'simple','WSH01-32-Green',0,0,'[[regtime]]','[[regtime]]'),(1918,10,'simple','WSH01-32-Red',0,0,'[[regtime]]','[[regtime]]'),(1919,10,'configurable','WSH01',1,0,'[[regtime]]','[[regtime]]'),(1920,10,'simple','WSH02-28-Gray',0,0,'[[regtime]]','[[regtime]]'),(1921,10,'simple','WSH02-28-Orange',0,0,'[[regtime]]','[[regtime]]'),(1922,10,'simple','WSH02-28-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1923,10,'simple','WSH02-29-Gray',0,0,'[[regtime]]','[[regtime]]'),(1924,10,'simple','WSH02-29-Orange',0,0,'[[regtime]]','[[regtime]]'),(1925,10,'simple','WSH02-29-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1926,10,'simple','WSH02-30-Gray',0,0,'[[regtime]]','[[regtime]]'),(1927,10,'simple','WSH02-30-Orange',0,0,'[[regtime]]','[[regtime]]'),(1928,10,'simple','WSH02-30-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1929,10,'simple','WSH02-31-Gray',0,0,'[[regtime]]','[[regtime]]'),(1930,10,'simple','WSH02-31-Orange',0,0,'[[regtime]]','[[regtime]]'),(1931,10,'simple','WSH02-31-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1932,10,'simple','WSH02-32-Gray',0,0,'[[regtime]]','[[regtime]]'),(1933,10,'simple','WSH02-32-Orange',0,0,'[[regtime]]','[[regtime]]'),(1934,10,'simple','WSH02-32-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1935,10,'configurable','WSH02',1,0,'[[regtime]]','[[regtime]]'),(1936,10,'simple','WSH03-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1937,10,'simple','WSH03-28-Gray',0,0,'[[regtime]]','[[regtime]]'),(1938,10,'simple','WSH03-28-Orange',0,0,'[[regtime]]','[[regtime]]'),(1939,10,'simple','WSH03-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1940,10,'simple','WSH03-29-Gray',0,0,'[[regtime]]','[[regtime]]'),(1941,10,'simple','WSH03-29-Orange',0,0,'[[regtime]]','[[regtime]]'),(1942,10,'simple','WSH03-30-Blue',0,0,'[[regtime]]','[[regtime]]'),(1943,10,'simple','WSH03-30-Gray',0,0,'[[regtime]]','[[regtime]]'),(1944,10,'simple','WSH03-30-Orange',0,0,'[[regtime]]','[[regtime]]'),(1945,10,'simple','WSH03-31-Blue',0,0,'[[regtime]]','[[regtime]]'),(1946,10,'simple','WSH03-31-Gray',0,0,'[[regtime]]','[[regtime]]'),(1947,10,'simple','WSH03-31-Orange',0,0,'[[regtime]]','[[regtime]]'),(1948,10,'simple','WSH03-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(1949,10,'simple','WSH03-32-Gray',0,0,'[[regtime]]','[[regtime]]'),(1950,10,'simple','WSH03-32-Orange',0,0,'[[regtime]]','[[regtime]]'),(1951,10,'configurable','WSH03',1,0,'[[regtime]]','[[regtime]]'),(1952,10,'simple','WSH04-28-Black',0,0,'[[regtime]]','[[regtime]]'),(1953,10,'simple','WSH04-28-Green',0,0,'[[regtime]]','[[regtime]]'),(1954,10,'simple','WSH04-28-Orange',0,0,'[[regtime]]','[[regtime]]'),(1955,10,'simple','WSH04-29-Black',0,0,'[[regtime]]','[[regtime]]'),(1956,10,'simple','WSH04-29-Green',0,0,'[[regtime]]','[[regtime]]'),(1957,10,'simple','WSH04-29-Orange',0,0,'[[regtime]]','[[regtime]]'),(1958,10,'simple','WSH04-30-Black',0,0,'[[regtime]]','[[regtime]]'),(1959,10,'simple','WSH04-30-Green',0,0,'[[regtime]]','[[regtime]]'),(1960,10,'simple','WSH04-30-Orange',0,0,'[[regtime]]','[[regtime]]'),(1961,10,'simple','WSH04-31-Black',0,0,'[[regtime]]','[[regtime]]'),(1962,10,'simple','WSH04-31-Green',0,0,'[[regtime]]','[[regtime]]'),(1963,10,'simple','WSH04-31-Orange',0,0,'[[regtime]]','[[regtime]]'),(1964,10,'simple','WSH04-32-Black',0,0,'[[regtime]]','[[regtime]]'),(1965,10,'simple','WSH04-32-Green',0,0,'[[regtime]]','[[regtime]]'),(1966,10,'simple','WSH04-32-Orange',0,0,'[[regtime]]','[[regtime]]'),(1967,10,'configurable','WSH04',1,0,'[[regtime]]','[[regtime]]'),(1968,10,'simple','WSH05-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1969,10,'simple','WSH05-28-Purple',0,0,'[[regtime]]','[[regtime]]'),(1970,10,'simple','WSH05-28-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1971,10,'simple','WSH05-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1972,10,'simple','WSH05-29-Purple',0,0,'[[regtime]]','[[regtime]]'),(1973,10,'simple','WSH05-29-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1974,10,'simple','WSH05-30-Blue',0,0,'[[regtime]]','[[regtime]]'),(1975,10,'simple','WSH05-30-Purple',0,0,'[[regtime]]','[[regtime]]'),(1976,10,'simple','WSH05-30-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1977,10,'simple','WSH05-31-Blue',0,0,'[[regtime]]','[[regtime]]'),(1978,10,'simple','WSH05-31-Purple',0,0,'[[regtime]]','[[regtime]]'),(1979,10,'simple','WSH05-31-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1980,10,'simple','WSH05-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(1981,10,'simple','WSH05-32-Purple',0,0,'[[regtime]]','[[regtime]]'),(1982,10,'simple','WSH05-32-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1983,10,'configurable','WSH05',1,0,'[[regtime]]','[[regtime]]'),(1984,10,'simple','WSH06-28-Gray',0,0,'[[regtime]]','[[regtime]]'),(1985,10,'simple','WSH06-28-Orange',0,0,'[[regtime]]','[[regtime]]'),(1986,10,'simple','WSH06-28-Purple',0,0,'[[regtime]]','[[regtime]]'),(1987,10,'simple','WSH06-29-Gray',0,0,'[[regtime]]','[[regtime]]'),(1988,10,'simple','WSH06-29-Orange',0,0,'[[regtime]]','[[regtime]]'),(1989,10,'simple','WSH06-29-Purple',0,0,'[[regtime]]','[[regtime]]'),(1990,10,'configurable','WSH06',1,0,'[[regtime]]','[[regtime]]'),(1991,10,'simple','WSH07-28-Black',0,0,'[[regtime]]','[[regtime]]'),(1992,10,'simple','WSH07-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1993,10,'simple','WSH07-28-Purple',0,0,'[[regtime]]','[[regtime]]'),(1994,10,'simple','WSH07-29-Black',0,0,'[[regtime]]','[[regtime]]'),(1995,10,'simple','WSH07-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1996,10,'simple','WSH07-29-Purple',0,0,'[[regtime]]','[[regtime]]'),(1997,10,'configurable','WSH07',1,0,'[[regtime]]','[[regtime]]'),(1998,10,'simple','WSH08-28-Purple',0,0,'[[regtime]]','[[regtime]]'),(1999,10,'simple','WSH08-29-Purple',0,0,'[[regtime]]','[[regtime]]'),(2000,10,'simple','WSH08-30-Purple',0,0,'[[regtime]]','[[regtime]]'),(2001,10,'simple','WSH08-31-Purple',0,0,'[[regtime]]','[[regtime]]'),(2002,10,'simple','WSH08-32-Purple',0,0,'[[regtime]]','[[regtime]]'),(2003,10,'configurable','WSH08',1,0,'[[regtime]]','[[regtime]]'),(2004,10,'simple','WSH09-28-Gray',0,0,'[[regtime]]','[[regtime]]'),(2005,10,'simple','WSH09-28-Green',0,0,'[[regtime]]','[[regtime]]'),(2006,10,'simple','WSH09-28-White',0,0,'[[regtime]]','[[regtime]]'),(2007,10,'simple','WSH09-29-Gray',0,0,'[[regtime]]','[[regtime]]'),(2008,10,'simple','WSH09-29-Green',0,0,'[[regtime]]','[[regtime]]'),(2009,10,'simple','WSH09-29-White',0,0,'[[regtime]]','[[regtime]]'),(2010,10,'configurable','WSH09',1,0,'[[regtime]]','[[regtime]]'),(2011,10,'simple','WSH10-28-Black',0,0,'[[regtime]]','[[regtime]]'),(2012,10,'simple','WSH10-28-Orange',0,0,'[[regtime]]','[[regtime]]'),(2013,10,'simple','WSH10-28-White',0,0,'[[regtime]]','[[regtime]]'),(2014,10,'simple','WSH10-29-Black',0,0,'[[regtime]]','[[regtime]]'),(2015,10,'simple','WSH10-29-Orange',0,0,'[[regtime]]','[[regtime]]'),(2016,10,'simple','WSH10-29-White',0,0,'[[regtime]]','[[regtime]]'),(2017,10,'configurable','WSH10',1,0,'[[regtime]]','[[regtime]]'),(2018,10,'simple','WSH11-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(2019,10,'simple','WSH11-28-Orange',0,0,'[[regtime]]','[[regtime]]'),(2020,10,'simple','WSH11-28-Red',0,0,'[[regtime]]','[[regtime]]'),(2021,10,'simple','WSH11-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(2022,10,'simple','WSH11-29-Orange',0,0,'[[regtime]]','[[regtime]]'),(2023,10,'simple','WSH11-29-Red',0,0,'[[regtime]]','[[regtime]]'),(2024,10,'configurable','WSH11',1,0,'[[regtime]]','[[regtime]]'),(2025,10,'simple','WSH12-28-Green',0,0,'[[regtime]]','[[regtime]]'),(2026,10,'simple','WSH12-28-Purple',0,0,'[[regtime]]','[[regtime]]'),(2027,10,'simple','WSH12-28-Red',0,0,'[[regtime]]','[[regtime]]'),(2028,10,'simple','WSH12-29-Green',0,0,'[[regtime]]','[[regtime]]'),(2029,10,'simple','WSH12-29-Purple',0,0,'[[regtime]]','[[regtime]]'),(2030,10,'simple','WSH12-29-Red',0,0,'[[regtime]]','[[regtime]]'),(2031,10,'simple','WSH12-30-Green',0,0,'[[regtime]]','[[regtime]]'),(2032,10,'simple','WSH12-30-Purple',0,0,'[[regtime]]','[[regtime]]'),(2033,10,'simple','WSH12-30-Red',0,0,'[[regtime]]','[[regtime]]'),(2034,10,'simple','WSH12-31-Green',0,0,'[[regtime]]','[[regtime]]'),(2035,10,'simple','WSH12-31-Purple',0,0,'[[regtime]]','[[regtime]]'),(2036,10,'simple','WSH12-31-Red',0,0,'[[regtime]]','[[regtime]]'),(2037,10,'simple','WSH12-32-Green',0,0,'[[regtime]]','[[regtime]]'),(2038,10,'simple','WSH12-32-Purple',0,0,'[[regtime]]','[[regtime]]'),(2039,10,'simple','WSH12-32-Red',0,0,'[[regtime]]','[[regtime]]'),(2040,10,'configurable','WSH12',1,0,'[[regtime]]','[[regtime]]');
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_entity_datetime`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_entity_datetime`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_product_entity_datetime` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` datetime DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `[[DBPREFIX]]CAT_PRD_ENTT_DTIME_ENTT_ID_ATTR_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_DATETIME_ATTRIBUTE_ID` (`attribute_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_DATETIME_STORE_ID` (`store_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_DTIME_ATTR_ID_[[DBPREFIX]]EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_DTIME_ENTT_ID_[[DBPREFIX]]CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `[[dbprefix]]catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_DTIME_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `[[dbprefix]]store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COMMENT='Catalog Product Datetime Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_entity_datetime`
--

LOCK TABLES `[[dbprefix]]catalog_product_entity_datetime` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_datetime` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_product_entity_datetime` VALUES (1,79,0,2,'[[regtime]]'),(2,79,0,10,'[[regtime]]'),(3,79,0,11,'[[regtime]]'),(4,79,0,16,'[[regtime]]'),(5,79,0,41,'[[regtime]]'),(6,79,0,42,'[[regtime]]'),(7,102,1,1220,NULL),(8,95,1,1220,NULL),(9,80,1,1220,NULL),(10,102,1,1236,NULL),(11,95,1,1236,NULL),(12,80,1,1236,NULL),(13,102,1,1252,NULL),(14,95,1,1252,NULL),(15,80,1,1252,NULL),(16,102,1,1268,NULL),(17,95,1,1268,NULL),(18,80,1,1268,NULL),(19,102,1,1284,NULL),(20,95,1,1284,NULL),(21,80,1,1284,NULL),(22,102,1,1380,NULL),(23,95,1,1380,NULL),(24,80,1,1380,NULL),(25,102,1,1300,NULL),(26,95,1,1300,NULL),(27,80,1,1300,NULL),(28,102,1,1316,NULL),(29,95,1,1316,NULL),(30,80,1,1316,NULL),(31,102,1,1332,NULL),(32,95,1,1332,NULL),(33,80,1,1332,NULL),(34,102,1,1348,NULL),(35,95,1,1348,NULL),(36,80,1,1348,NULL),(37,102,1,1364,NULL),(38,95,1,1364,NULL),(39,80,1,1364,NULL),(40,102,1,1396,NULL),(41,95,1,1396,NULL),(42,80,1,1396,NULL);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_datetime` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_entity_decimal`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_entity_decimal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_product_entity_decimal` (
  `value_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` decimal(20,6) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `[[DBPREFIX]]CAT_PRD_ENTT_DEC_ENTT_ID_ATTR_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_DECIMAL_STORE_ID` (`store_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_DECIMAL_ATTRIBUTE_ID` (`attribute_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_DEC_ATTR_ID_[[DBPREFIX]]EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_DEC_ENTT_ID_[[DBPREFIX]]CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `[[dbprefix]]catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CATALOG_PRODUCT_EN