<?php

declare(strict_types=1);

/**
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 *
 * OpenSearch PHP client
 *
 * @link      https://github.com/opensearch-project/opensearch-php/
 * @copyright Copyright (c) Elasticsearch B.V (https://www.elastic.co)
 * @license   http://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
 * @license   https://www.gnu.org/licenses/lgpl-2.1.html GNU Lesser General Public License, Version 2.1
 *
 * Licensed to Elasticsearch B.V under one or more agreements.
 * Elasticsearch B.V licenses this file to you under the Apache 2.0 License or
 * the GNU Lesser General Public License, Version 2.1, at your option.
 * See the LICENSE file in the project root for more information.
 */

namespace OpenSearch\Endpoints\Cluster;

use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class Stats extends AbstractEndpoint
{
    protected $index_metric;
    protected $metric;
    protected $node_id;

    public function getURI(): string
    {
        $index_metric = $this->index_metric ?? null;
        $metric = $this->metric ?? null;
        $node_id = $this->node_id ?? null;
        if (isset($metric) && isset($index_metric) && isset($node_id)) {
            return "/_cluster/stats/$metric/$index_metric/nodes/$node_id";
        }
        if (isset($metric) && isset($node_id)) {
            return "/_cluster/stats/$metric/nodes/$node_id";
        }
        if (isset($node_id)) {
            return "/_cluster/stats/nodes/$node_id";
        }
        return "/_cluster/stats";
    }

    public function getParamWhitelist(): array
    {
        return [
            'flat_settings',
            'timeout',
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'GET';
    }

    public function setIndexMetric($index_metric): static
    {
        if (isset($index_metric) !== true) {
            return $this;
        }
        if (is_array($index_metric) === true) {
            $index_metric = implode(",", $index_metric);
        }
        $this->index_metric = $index_metric;

        return $this;
    }

    public function setMetric($metric): static
    {
        if (isset($metric) !== true) {
            return $this;
        }
        if (is_array($metric) === true) {
            $metric = implode(",", $metric);
        }
        $this->metric = $metric;

        return $this;
    }

    public function setNodeId($node_id): static
    {
        if (isset($node_id) !== true) {
            return $this;
        }
        if (is_array($node_id) === true) {
            $node_id = implode(",", $node_id);
        }
        $this->node_id = $node_id;

        return $this;
    }
}
