<?php

declare(strict_types=1);

/**
 *  Copyright OpenSearch Contributors
 *   SPDX-License-Identifier: Apache-2.0
 *
 *   The OpenSearch Contributors require contributions made to
 *   this file be licensed under the Apache-2.0 license or a
 *   compatible open source license.
 */

namespace OpenSearch\Endpoints\Ml;

use OpenSearch\Exception\RuntimeException;
use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class GetConnector extends AbstractEndpoint
{
    protected $connector_id;

    public function getURI(): string
    {
        $connector_id = $this->connector_id ?? null;
        if (isset($connector_id)) {
            return "/_plugins/_ml/connectors/$connector_id";
        }
        throw new RuntimeException('Missing parameter for the endpoint ml.get_connector');
    }

    public function getParamWhitelist(): array
    {
        return [
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'GET';
    }

    public function setConnectorId($connector_id): static
    {
        if (is_null($connector_id)) {
            return $this;
        }
        $this->connector_id = $connector_id;

        return $this;
    }
}
