<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Endpoints\Ml;

use OpenSearch\Exception\RuntimeException;
use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class UpdateConnector extends AbstractEndpoint
{
    protected $connector_id;

    public function getURI(): string
    {
        $connector_id = $this->connector_id ?? null;
        if (isset($connector_id)) {
            return "/_plugins/_ml/connectors/$connector_id";
        }
        throw new RuntimeException('Missing parameter for the endpoint ml.update_connector');
    }

    public function getParamWhitelist(): array
    {
        return [
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'PUT';
    }

    public function setBody($body): static
    {
        if (is_null($body)) {
            return $this;
        }
        $this->body = $body;

        return $this;
    }

    public function setConnectorId($connector_id): static
    {
        if (is_null($connector_id)) {
            return $this;
        }
        $this->connector_id = $connector_id;

        return $this;
    }
}
