<?php

declare(strict_types=1);

/**
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 *
 * OpenSearch PHP client
 *
 * @link      https://github.com/opensearch-project/opensearch-php/
 * @copyright Copyright (c) Elasticsearch B.V (https://www.elastic.co)
 * @license   http://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
 * @license   https://www.gnu.org/licenses/lgpl-2.1.html GNU Lesser General Public License, Version 2.1
 *
 * Licensed to Elasticsearch B.V under one or more agreements.
 * Elasticsearch B.V licenses this file to you under the Apache 2.0 License or
 * the GNU Lesser General Public License, Version 2.1, at your option.
 * See the LICENSE file in the project root for more information.
 */

namespace OpenSearch\Namespaces;

use OpenSearch\Endpoints\Cat\Aliases;
use OpenSearch\Endpoints\Cat\AllPitSegments;
use OpenSearch\Endpoints\Cat\Allocation;
use OpenSearch\Endpoints\Cat\ClusterManager;
use OpenSearch\Endpoints\Cat\Count;
use OpenSearch\Endpoints\Cat\Fielddata;
use OpenSearch\Endpoints\Cat\Health;
use OpenSearch\Endpoints\Cat\Help;
use OpenSearch\Endpoints\Cat\Indices;
use OpenSearch\Endpoints\Cat\Master;
use OpenSearch\Endpoints\Cat\NodeAttrs;
use OpenSearch\Endpoints\Cat\Nodes;
use OpenSearch\Endpoints\Cat\PendingTasks;
use OpenSearch\Endpoints\Cat\PitSegments;
use OpenSearch\Endpoints\Cat\Plugins;
use OpenSearch\Endpoints\Cat\Recovery;
use OpenSearch\Endpoints\Cat\Repositories;
use OpenSearch\Endpoints\Cat\SegmentReplication;
use OpenSearch\Endpoints\Cat\Segments;
use OpenSearch\Endpoints\Cat\Shards;
use OpenSearch\Endpoints\Cat\Snapshots;
use OpenSearch\Endpoints\Cat\Tasks;
use OpenSearch\Endpoints\Cat\Templates;
use OpenSearch\Endpoints\Cat\ThreadPool;

/**
 * Class CatNamespace
 *
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class CatNamespace extends AbstractNamespace
{
    /**
     * Shows information about aliases currently configured to indexes, including filter and routing information.
     *
     * $params['name']             = (array)
     * $params['expand_wildcards'] = (any)
     * $params['format']           = (string) A short version of the `Accept` header, such as `json` or `yaml`.
     * $params['h']                = (array) A comma-separated list of column names to display.
     * $params['help']             = (boolean) Returns help information. (Default = false)
     * $params['local']            = (boolean) Whether to return information from the local node only instead of from the cluster manager node. (Default = false)
     * $params['s']                = (array) A comma-separated list of column names or column aliases to sort by.
     * $params['v']                = (boolean) Enables verbose mode, which displays column headers. (Default = false)
     * $params['pretty']           = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']            = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace']      = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']           = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']      = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function aliases(array $params = [])
    {
        $name = $this->extractArgument($params, 'name');

        $endpoint = $this->endpointFactory->getEndpoint(Aliases::class);
        $endpoint->setParams($params);
        $endpoint->setName($name);

        return $this->performRequest($endpoint);
    }

    /**
     * Lists all active CAT point-in-time segments.
     *
     * $params['bytes']       = (any) The units used to display byte values.
     * $params['format']      = (string) A short version of the `Accept` header, such as `json` or `yaml`.
     * $params['h']           = (array) A comma-separated list of column names to display.
     * $params['help']        = (boolean) Returns help information. (Default = false)
     * $params['s']           = (array) A comma-separated list of column names or column aliases to sort by.
     * $params['v']           = (boolean) Enables verbose mode, which displays column headers. (Default = false)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function allPitSegments(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(AllPitSegments::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Provides a snapshot of how many shards are allocated to each data node and how much disk space they are using.
     *
     * $params['node_id']                 = (array) A comma-separated list of node IDs or names used to limit the returned information.
     * $params['bytes']                   = (any) The units used to display byte values.
     * $params['cluster_manager_timeout'] = (string) A timeout for connection to the cluster manager node.
     * $params['format']                  = (string) A short version of the HTTP `Accept` header, such as `json` or `yaml`.
     * $params['h']                       = (array) A comma-separated list of column names to display.
     * $params['help']                    = (boolean) Returns help information. (Default = false)
     * $params['local']                   = (boolean) Returns local information but does not retrieve the state from cluster-manager node. (Default = false)
     * $params['master_timeout']          = (string) A timeout for connection to the cluster manager node.
     * $params['s']                       = (array) A comma-separated list of column names or column aliases to sort by.
     * $params['v']                       = (boolean) Enables verbose mode, which displays column headers. (Default = false)
     * $params['pretty']                  = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']                   = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace']             = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']                  = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']             = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function allocation(array $params = [])
    {
        $node_id = $this->extractArgument($params, 'node_id');

        $endpoint = $this->endpointFactory->getEndpoint(Allocation::class);
        $endpoint->setParams($params);
        $endpoint->setNodeId($node_id);

        return $this->performRequest($endpoint);
    }

    /**
     * Returns information about the cluster-manager node.
     *
     * $params['cluster_manager_timeout'] = (string) A timeout for connection to the cluster manager node.
     * $params['format']                  = (string) A short version of the HTTP `Accept` header, such as `json` or `yaml`.
     * $params['h']                       = (array) A comma-separated list of column names to display.
     * $params['help']                    = (boolean) Returns help information. (Default = false)
     * $params['local']                   = (boolean) Returns local information but does not retrieve the state from the cluster manager node. (Default = false)
     * $params['master_timeout']          = (string) A timeout for connection to the cluster manager node.
     * $params['s']                       = (array) A comma-separated list of column names or column aliases to sort by.
     * $params['v']                       = (boolean) Enables verbose mode, which displays column headers. (Default = false)
     * $params['pretty']                  = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']                   = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace']             = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']                  = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']             = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function clusterManager(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(ClusterManager::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Provides quick access to the document count of the entire cluster or of an individual index.
     *
     * $params['index']       = (array) Comma-separated list of data streams, indexes, and aliases used to limit the request. Supports wildcards (`*`). To target all data streams and indexes, omit this parameter or use `*` or `_all`.
     * $params['format']      = (string) A short version of the `Accept` header, such as `json` or `yaml`.
     * $params['h']           = (array) A comma-separated list of column names to display.
     * $params['help']        = (boolean) Returns help information. (Default = false)
     * $params['s']           = (array) A comma-separated list of column names or column aliases to sort by.
     * $params['v']           = (boolean) Enables verbose mode, which displays column headers. (Default = false)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function count(array $params = [])
    {
        $index = $this->extractArgument($params, 'index');

        $endpoint = $this->endpointFactory->getEndpoint(Count::class);
        $endpoint->setParams($params);
        $endpoint->setIndex($index);

        return $this->performRequest($endpoint);
    }

    /**
     * Shows how much heap memory is currently being used by field data on every data node in the cluster.
     *
     * $params['fields']      = (array) A comma-separated list of fields used to limit the amount of returned information. To retrieve all fields, omit this parameter.
     * $params['bytes']       = (any) The units used to display byte values.
     * $params['format']      = (string) A short version of the `Accept` header, such as `json` or `yaml`.
     * $params['h']           = (array) A comma-separated list of column names to display.
     * $params['help']        = (boolean) Returns help information. (Default = false)
     * $params['s']           = (array) A comma-separated list of column names or column aliases to sort by.
     * $params['v']           = (boolean) Enables verbose mode, which displays column headers. (Default = false)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function fielddata(array $params = [])
    {
        $fields = $this->extractArgument($params, 'fields');

        $endpoint = $this->endpointFactory->getEndpoint(Fielddata::class);
        $endpoint->setParams($params);
        $endpoint->setFields($fields);

        return $this->performRequest($endpoint);
    }

    /**
     * Returns a concise representation of the cluster health.
     *
     * $params['format']      = (string) A short version of the `Accept` header, such as `json` or `yaml`.
     * $params['h']           = (array) A comma-separated list of column names to display.
     * $params['help']        = (boolean) Returns help information. (Default = false)
     * $params['s']           = (array) A comma-separated list of column names or column aliases to sort by.
     * $params['time']        = (any) The unit used to display time values.
     * $params['ts']          = (boolean) When `true`, returns `HH:MM:SS` and Unix epoch timestamps. (Default = true)
     * $params['v']           = (boolean) Enables verbose mode, which displays column headers. (Default = false)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function health(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(Health::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Returns help for the Cat APIs.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function help(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(Help::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Lists information related to indexes, that is, how much disk space they are using, how many shards they have, their health status, and so on.
     *
     * $params['index']                     = (array) A comma-separated list of data streams, indexes, and aliases used to limit the request. Supports wildcards (`*`). To target all data streams and indexes, omit this parameter or use `*` or `_all`.
     * $params['bytes']                     = (any) The units used to display byte values.
     * $params['cluster_manager_timeout']   = (string) The amount of time allowed to establish a connection to the cluster manager node.
     * $params['expand_wildcards']          = (any)
     * $params['format']                    = (string) A short version of the `Accept` header, such as `json` or `yaml`.
     * $params['h']                         = (array) A comma-separated list of column names to display.
     * $params['health']                    = (any) Limits indexes based on their health status. Supported values are `green`, `yellow`, and `red`.
     * $params['help']                      = (boolean) Returns help information. (Default = false)
     * $params['include_unloaded_segments'] = (boolean) Whether to include information from segments not loaded into memory. (Default = false)
     * $params['local']                     = (boolean) Returns local information but does not retrieve the state from the cluster manager node. (Default = false)
     * $params['master_timeout']            = (string) The amount of time allowed to establish a connection to the cluster manager node.
     * $params['pri']                       = (boolean) When `true`, returns information only from the primary shards. (Default = false)
     * $params['s']                         = (array) A comma-separated list of column names or column aliases to sort by.
     * $params['time']                      = (any) Specifies the time units.
     * $params['v']                         = (boolean) Enables verbose mode, which displays column headers. (Default = false)
     * $params['pretty']                    = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']                     = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace']               = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']                    = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']               = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function indices(array $params = [])
    {
        $index = $this->extractArgument($params, 'index');

        $endpoint = $this->endpointFactory->getEndpoint(Indices::class);
        $endpoint->setParams($params);
        $endpoint->setIndex($index);

        return $this->performRequest($endpoint);
    }

    /**
     * Returns information about the cluster-manager node.
     *
     * $params['cluster_manager_timeout'] = (string) The amount of time allowed to establish a connection to the cluster manager node.
     * $params['format']                  = (string) A short version of the `Accept` header, such as `json` or `yaml`.
     * $params['h']                       = (array) A comma-separated list of column names to display.
     * $params['help']                    = (boolean) Returns help information. (Default = false)
     * $params['local']                   = (boolean) Returns local information but does not retrieve the state from the cluster manager node. (Default = false)
     * $params['master_timeout']          = (string) The amount of time allowed to establish a connection to the cluster manager node.
     * $params['s']                       = (array) A comma-separated list of column names or column aliases to sort by.
     * $params['v']                       = (boolean) Enables verbose mode, which displays column headers. (Default = false)
     * $params['pretty']                  = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']                   = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace']             = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']                  = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']             = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function master(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(Master::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Returns information about custom node attributes.
     *
     * $params['cluster_manager_timeout'] = (string) The amount of time allowed to establish a connection to the cluster manager node.
     * $params['format']                  = (string) A short version of the `Accept` header, such as `json` or `yaml`.
     * $params['h']                       = (array) A comma-separated list of column names to display.
     * $params['help']                    = (boolean) Returns help information. (Default = false)
     * $params['local']                   = (boolean) Returns local information but does not retrieve the state from the cluster manager node. (Default = false)
     * $params['master_timeout']          = (string) The amount of time allowed to establish a connection to the cluster manager node.
     * $params['s']                       = (array) A comma-separated list of column names or column aliases to sort by.
     * $params['v']                       = (boolean) Enables verbose mode, which displays column headers. (Default = false)
     * $params['pretty']                  = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']                   = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace']             = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']                  = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']             = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function nodeattrs(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(NodeAttrs::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Returns basic statistics about the performance of cluster nodes.
     *
     * $params['bytes']                   = (any) The units used to display byte values.
     * $params['cluster_manager_timeout'] = (string) The amount of time allowed to establish a connection to the cluster manager node.
     * $params['format']                  = (string) A short version of the `Accept` header, such as `json` or `yaml`.
     * $params['full_id']                 = (any) When `true`, returns the full node ID. When `false`, returns the shortened node ID.
     * $params['h']                       = (array) A comma-separated list of column names to display.
     * $params['help']                    = (boolean) Returns help information. (Default = false)
     * $params['local']                   = (boolean) Returns local information but does not retrieve the state from the cluster manager node. (Default = false)
     * $params['master_timeout']          = (string) The amount of time allowed to establish a connection to the cluster manager node.
     * $params['s']                       = (array) A comma-separated list of column names or column aliases to sort by.
     * $params['time']                    = (any) Specifies the time units, for example, `5d` or `7h`. For more information, see [Supported units](https://opensearch.org/docs/latest/api-reference/units/).
     * $params['v']                       = (boolean) Enables verbose mode, which displays column headers. (Default = false)
     * $params['pretty']                  = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']                   = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace']             = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']                  = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']             = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function nodes(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(Nodes::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Returns a concise representation of the cluster's pending tasks.
     *
     * $params['cluster_manager_timeout'] = (string) The amount of time allowed to establish a connection to the cluster manager node.
     * $params['format']                  = (string) A short version of the `Accept` header, such as `json` or `yaml`.
     * $params['h']                       = (array) A comma-separated list of column names to display.
     * $params['help']                    = (boolean) Returns help information. (Default = false)
     * $params['local']                   = (boolean) Returns local information but does not retrieve the state from the cluster manager node. (Default = false)
     * $params['master_timeout']          = (string) The amount of time allowed to establish a connection to the cluster manager node.
     * $params['s']                       = (array) A comma-separated list of column names or column aliases to sort by.
     * $params['time']                    = (any) Specifies the time units, for example, `5d` or `7h`. For more information, see [Supported units](https://opensearch.org/docs/latest/api-reference/units/).
     * $params['v']                       = (boolean) Enables verbose mode, which displays column headers. (Default = false)
     * $params['pretty']                  = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']                   = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace']             = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']                  = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']             = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function pendingTasks(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(PendingTasks::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Lists one or several CAT point-in-time segments.
     *
     * $params['bytes']       = (any) The units used to display byte values.
     * $params['format']      = (string) A short version of the `Accept` header, such as `json` or `yaml`.
     * $params['h']           = (array) A comma-separated list of column names to display.
     * $params['help']        = (boolean) Returns help information. (Default = false)
     * $params['s']           = (array) A comma-separated list of column names or column aliases to sort by.
     * $params['v']           = (boolean) Enables verbose mode, which displays column headers. (Default = false)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function pitSegments(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpoint = $this->endpointFactory->getEndpoint(PitSegments::class);
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }

    /**
     * Returns information about the names, components, and versions of the installed plugins.
     *
     * $params['cluster_manager_timeout'] = (string) The amount of time allowed to establish a connection to the cluster manager node.
     * $params['format']                  = (string) A short version of the `Accept` header, such as `json` or `yaml`.
     * $params['h']                       = (array) A comma-separated list of column names to display.
     * $params['help']                    = (boolean) Returns help information. (Default = false)
     * $params['local']                   = (boolean) Returns local information but does not retrieve the state from the cluster manager node. (Default = false)
     * $params['master_timeout']          = (string) The amount of time allowed to establish a connection to the cluster manager node.
     * $params['s']                       = (array) A comma-separated list of column names or column aliases to sort by.
     * $params['v']                       = (boolean) Enables verbose mode, which displays column headers. (Default = false)
     * $params['pretty']                  = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']                   = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace']             = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']                  = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']             = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function plugins(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(Plugins::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Returns all completed and ongoing index and shard recoveries.
     *
     * $params['index']       = (array) A comma-separated list of data streams, indexes, and aliases used to limit the request. Supports wildcards (`*`). To target all data streams and indexes, omit this parameter or use `*` or `_all`.
     * $params['active_only'] = (boolean) If `true`, the response only includes ongoing shard recoveries. (Default = false)
     * $params['bytes']       = (any) The units used to display byte values.
     * $params['detailed']    = (boolean) When `true`, includes detailed information about shard recoveries. (Default = false)
     * $params['format']      = (string) A short version of the `Accept` header, such as `json` or `yaml`.
     * $params['h']           = (array) A comma-separated list of column names to display.
     * $params['help']        = (boolean) Returns help information. (Default = false)
     * $params['s']           = (array) A comma-separated list of column names or column aliases to sort by.
     * $params['time']        = (any) Specifies the time units, for example, `5d` or `7h`. For more information, see [Supported units](https://opensearch.org/docs/latest/api-reference/units/).
     * $params['v']           = (boolean) Enables verbose mode, which displays column headers. (Default = false)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function recovery(array $params = [])
    {
        $index = $this->extractArgument($params, 'index');

        $endpoint = $this->endpointFactory->getEndpoint(Recovery::class);
        $endpoint->setParams($params);
        $endpoint->setIndex($index);

        return $this->performRequest($endpoint);
    }

    /**
     * Returns information about all snapshot repositories for a cluster.
     *
     * $params['cluster_manager_timeout'] = (string) The amount of time allowed to establish a connection to the cluster manager node.
     * $params['format']                  = (string) A short version of the `Accept` header, such as `json` or `yaml`.
     * $params['h']                       = (array) A comma-separated list of column names to display.
     * $params['help']                    = (boolean) Returns help information. (Default = false)
     * $params['local']                   = (boolean) Returns local information but does not retrieve the state from the cluster manager node. (Default = false)
     * $params['master_timeout']          = (string) The amount of time allowed to establish a connection to the cluster manager node.
     * $params['s']                       = (array) A comma-separated list of column names or column aliases to sort by.
     * $params['v']                       = (boolean) Enables verbose mode, which displays column headers. (Default = false)
     * $params['pretty']                  = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']                   = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace']             = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']                  = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']             = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function repositories(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(Repositories::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Returns information about active and last-completed segment replication events on each replica shard, including related shard-level metrics. These metrics provide information about how far behind the primary shard the replicas are lagging.
     *
     * $params['index']              = (array) A comma-separated list of data streams, indexes, and aliases used to limit the request. Supports wildcards (`*`). To target all data streams and indexes, omit this parameter or use `*` or `_all`.
     * $params['active_only']        = (boolean) When `true`, the response only includes ongoing segment replication events. (Default = false)
     * $params['allow_no_indices']   = (boolean) Whether to ignore the index if a wildcard index expression resolves to no concrete indexes. This includes the `_all` string or when no indexes have been specified.
     * $params['bytes']              = (any) The units used to display byte values.
     * $params['completed_only']     = (boolean) When `true`, the response only includes the last-completed segment replication events. (Default = false)
     * $params['detailed']           = (boolean) When `true`, the response includes additional metrics for each stage of a segment replication event. (Default = false)
     * $params['expand_wildcards']   = (any)
     * $params['format']             = (string) A short version of the `Accept` header, such as `json` or `yaml`.
     * $params['h']                  = (array) A comma-separated list of column names to display.
     * $params['help']               = (boolean) Returns help information. (Default = false)
     * $params['ignore_throttled']   = (boolean) Whether specified concrete, expanded, or aliased indexes should be ignored when throttled.
     * $params['ignore_unavailable'] = (boolean) Whether the specified concrete indexes should be ignored when missing or closed.
     * $params['s']                  = (array) A comma-separated list of column names or column aliases to sort by.
     * $params['shards']             = (array) A comma-separated list of shards to display.
     * $params['time']               = (any) Specifies the time units, for example, `5d` or `7h`. For more information, see [Supported units](https://opensearch.org/docs/latest/api-reference/units/).
     * $params['timeout']            = (string) The operation timeout.
     * $params['v']                  = (boolean) Enables verbose mode, which displays column headers. (Default = false)
     * $params['pretty']             = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']              = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace']        = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']             = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']        = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function segmentReplication(array $params = [])
    {
        $index = $this->extractArgument($params, 'index');

        $endpoint = $this->endpointFactory->getEndpoint(SegmentReplication::class);
        $endpoint->setParams($params);
        $endpoint->setIndex($index);

        return $this->performRequest($endpoint);
    }

    /**
     * Provides low-level information about the segments in the shards of an index.
     *
     * $params['index']                   = (array) A comma-separated list of data streams, indexes, and aliases used to limit the request. Supports wildcards (`*`). To target all data streams and indexes, omit this parameter or use `*` or `_all`.
     * $params['bytes']                   = (any) The units used to display byte values.
     * $params['cluster_manager_timeout'] = (string) The amount of time allowed to establish a connection to the cluster manager node.
     * $params['format']                  = (string) A short version of the `Accept` header, such as `json` or `yaml`.
     * $params['h']                       = (array) A comma-separated list of column names to display.
     * $params['help']                    = (boolean) Returns help information. (Default = false)
     * $params['master_timeout']          = (string) The amount of time allowed to establish a connection to the cluster manager node.
     * $params['s']                       = (array) A comma-separated list of column names or column aliases to sort by.
     * $params['v']                       = (boolean) Enables verbose mode, which displays column headers. (Default = false)
     * $params['pretty']                  = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']                   = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace']             = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']                  = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']             = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function segments(array $params = [])
    {
        $index = $this->extractArgument($params, 'index');

        $endpoint = $this->endpointFactory->getEndpoint(Segments::class);
        $endpoint->setParams($params);
        $endpoint->setIndex($index);

        return $this->performRequest($endpoint);
    }

    /**
     * Lists the states of all primary and replica shards and how they are distributed.
     *
     * $params['index']                   = (array)
     * $params['bytes']                   = (any) The units used to display byte values.
     * $params['cluster_manager_timeout'] = (string) The amount of time allowed to establish a connection to the cluster manager node.
     * $params['format']                  = (string) A short version of the `Accept` header, such as `json` or `yaml`.
     * $params['h']                       = (array) A comma-separated list of column names to display.
     * $params['help']                    = (boolean) Returns help information. (Default = false)
     * $params['local']                   = (boolean) Returns local information but does not retrieve the state from the cluster manager node. (Default = false)
     * $params['master_timeout']          = (string) The amount of time allowed to establish a connection to the cluster manager node.
     * $params['s']                       = (array) A comma-separated list of column names or column aliases to sort by.
     * $params['time']                    = (any)
     * $params['v']                       = (boolean) Enables verbose mode, which displays column headers. (Default = false)
     * $params['pretty']                  = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']                   = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace']             = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']                  = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']             = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function shards(array $params = [])
    {
        $index = $this->extractArgument($params, 'index');

        $endpoint = $this->endpointFactory->getEndpoint(Shards::class);
        $endpoint->setParams($params);
        $endpoint->setIndex($index);

        return $this->performRequest($endpoint);
    }

    /**
     * Lists all of the snapshots stored in a specific repository.
     *
     * $params['repository']              = (array) A comma-separated list of snapshot repositories used to limit the request. Accepts wildcard expressions. `_all` returns all repositories. If any repository fails during the request, OpenSearch returns an error.
     * $params['cluster_manager_timeout'] = (string) The amount of time allowed to establish a connection to the cluster manager node.
     * $params['format']                  = (string) A short version of the `Accept` header, such as `json` or `yaml`.
     * $params['h']                       = (array) A comma-separated list of column names to display.
     * $params['help']                    = (boolean) Returns help information. (Default = false)
     * $params['ignore_unavailable']      = (boolean) When `true`, the response does not include information from unavailable snapshots. (Default = false)
     * $params['master_timeout']          = (string) The amount of time allowed to establish a connection to the cluster manager node.
     * $params['s']                       = (array) A comma-separated list of column names or column aliases to sort by.
     * $params['time']                    = (any) Specifies the time units, for example, `5d` or `7h`. For more information, see [Supported units](https://opensearch.org/docs/latest/api-reference/units/).
     * $params['v']                       = (boolean) Enables verbose mode, which displays column headers. (Default = false)
     * $params['pretty']                  = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']                   = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace']             = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']                  = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']             = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function snapshots(array $params = [])
    {
        $repository = $this->extractArgument($params, 'repository');

        $endpoint = $this->endpointFactory->getEndpoint(Snapshots::class);
        $endpoint->setParams($params);
        $endpoint->setRepository($repository);

        return $this->performRequest($endpoint);
    }

    /**
     * Lists the progress of all tasks currently running on the cluster.
     *
     * $params['actions']     = (array) The task action names used to limit the response.
     * $params['detailed']    = (boolean) If `true`, the response includes detailed information about shard recoveries. (Default = false)
     * $params['format']      = (string) A short version of the `Accept` header, such as `json` or `yaml`.
     * $params['h']           = (array) A comma-separated list of column names to display.
     * $params['help']        = (boolean) Returns help information. (Default = false)
     * $params['s']           = (array) A comma-separated list of column names or column aliases to sort by.
     * $params['time']        = (any) Specifies the time units, for example, `5d` or `7h`. For more information, see [Supported units](https://opensearch.org/docs/latest/api-reference/units/).
     * $params['v']           = (boolean) Enables verbose mode, which displays column headers. (Default = false)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     * $params['node_id']     = (array) A comma-separated list of node IDs or names used to limit the returned information. Use `_local` to return information from the node to which you're connecting, specify a specific node from which to get information, or keep the parameter empty to get information from all nodes.
     * $params['parent_task'] = (string) The parent task identifier, which is used to limit the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function tasks(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(Tasks::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Lists the names, patterns, order numbers, and version numbers of index templates.
     *
     * $params['name']                    = (string) The name of the template to return. Accepts wildcard expressions. If omitted, all templates are returned.
     * $params['cluster_manager_timeout'] = (string) The amount of time allowed to establish a connection to the cluster manager node.
     * $params['format']                  = (string) A short version of the `Accept` header, such as `json` or `yaml`.
     * $params['h']                       = (array) A comma-separated list of column names to display.
     * $params['help']                    = (boolean) Returns help information. (Default = false)
     * $params['local']                   = (boolean) Returns local information but does not retrieve the state from the cluster manager node. (Default = false)
     * $params['master_timeout']          = (string) The amount of time allowed to establish a connection to the cluster manager node.
     * $params['s']                       = (array) A comma-separated list of column names or column aliases to sort by.
     * $params['v']                       = (boolean) Enables verbose mode, which displays column headers. (Default = false)
     * $params['pretty']                  = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']                   = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace']             = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']                  = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']             = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function templates(array $params = [])
    {
        $name = $this->extractArgument($params, 'name');

        $endpoint = $this->endpointFactory->getEndpoint(Templates::class);
        $endpoint->setParams($params);
        $endpoint->setName($name);

        return $this->performRequest($endpoint);
    }

    /**
     * Returns cluster-wide thread pool statistics per node.By default the active, queued, and rejected statistics are returned for all thread pools.
     *
     * $params['thread_pool_patterns']    = (array) A comma-separated list of thread pool names used to limit the request. Accepts wildcard expressions.
     * $params['cluster_manager_timeout'] = (string) A timeout for connection to the cluster manager node.
     * $params['format']                  = (string) A short version of the `Accept` header, such as `json` or `yaml`.
     * $params['h']                       = (array) A comma-separated list of column names to display.
     * $params['help']                    = (boolean) Returns help information. (Default = false)
     * $params['local']                   = (boolean) Returns local information but does not retrieve the state from the cluster manager node. (Default = false)
     * $params['master_timeout']          = (string) The amount of time allowed to establish a connection to the cluster manager node.
     * $params['s']                       = (array) A comma-separated list of column names or column aliases to sort by.
     * $params['size']                    = (integer) The multiplier in which to display values.
     * $params['v']                       = (boolean) Enables verbose mode, which displays column headers. (Default = false)
     * $params['pretty']                  = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']                   = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace']             = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']                  = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']             = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function threadPool(array $params = [])
    {
        $thread_pool_patterns = $this->extractArgument($params, 'thread_pool_patterns');

        $endpoint = $this->endpointFactory->getEndpoint(ThreadPool::class);
        $endpoint->setParams($params);
        $endpoint->setThreadPoolPatterns($thread_pool_patterns);

        return $this->performRequest($endpoint);
    }

}
