<?php

declare(strict_types=1);

/**
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 *
 * OpenSearch PHP client
 *
 * @link      https://github.com/opensearch-project/opensearch-php/
 * @copyright Copyright (c) Elasticsearch B.V (https://www.elastic.co)
 * @license   http://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
 * @license   https://www.gnu.org/licenses/lgpl-2.1.html GNU Lesser General Public License, Version 2.1
 *
 * Licensed to Elasticsearch B.V under one or more agreements.
 * Elasticsearch B.V licenses this file to you under the Apache 2.0 License or
 * the GNU Lesser General Public License, Version 2.1, at your option.
 * See the LICENSE file in the project root for more information.
 */

namespace OpenSearch\Endpoints;

use OpenSearch\Serializers\SerializerInterface;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class Bulk extends AbstractEndpoint
{
    public function __construct(SerializerInterface $serializer)
    {
        $this->serializer = $serializer;
    }

    public function getURI(): string
    {
        $index = $this->index ?? null;
        if (isset($index)) {
            return "/$index/_bulk";
        }
        return "/_bulk";
    }

    public function getParamWhitelist(): array
    {
        return [
            '_source',
            '_source_excludes',
            '_source_includes',
            'pipeline',
            'refresh',
            'require_alias',
            'routing',
            'timeout',
            'wait_for_active_shards',
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'POST';
    }

    public function setBody(string|iterable|null $body): static
    {
        if (is_null($body)) {
            return $this;
        }

        if (is_string($body)) {
            if (!str_ends_with($body, "\n")) {
                $body .= "\n";
            }
            $this->body = $body;
            return $this;
        }

        // Must be an iterable.
        foreach ($body as $item) {
            $this->body .= $this->serializer->serialize($item) . "\n";
        }

        return $this;
    }

}
