<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Endpoints\FlowFramework;

use OpenSearch\Exception\RuntimeException;
use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class GetStatus extends AbstractEndpoint
{
    protected $workflow_id;

    public function getURI(): string
    {
        $workflow_id = $this->workflow_id ?? null;
        if (isset($workflow_id)) {
            return "/_plugins/_flow_framework/workflow/$workflow_id/_status";
        }
        throw new RuntimeException('Missing parameter for the endpoint flow_framework.get_status');
    }

    public function getParamWhitelist(): array
    {
        return [
            'all',
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'GET';
    }

    public function setWorkflowId($workflow_id): static
    {
        if (is_null($workflow_id)) {
            return $this;
        }
        $this->workflow_id = $workflow_id;

        return $this;
    }
}
