<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Endpoints\Ml;

use OpenSearch\Exception\RuntimeException;
use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class GetAgent extends AbstractEndpoint
{
    protected $agent_id;

    public function getURI(): string
    {
        $agent_id = $this->agent_id ?? null;
        if (isset($agent_id)) {
            return "/_plugins/_ml/agents/$agent_id";
        }
        throw new RuntimeException('Missing parameter for the endpoint ml.get_agent');
    }

    public function getParamWhitelist(): array
    {
        return [
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'GET';
    }

    public function setAgentId($agent_id): static
    {
        if (is_null($agent_id)) {
            return $this;
        }
        $this->agent_id = $agent_id;

        return $this;
    }
}
