<?php

declare(strict_types=1);

/**
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 *
 * OpenSearch PHP client
 *
 * @link      https://github.com/opensearch-project/opensearch-php/
 * @copyright Copyright (c) Elasticsearch B.V (https://www.elastic.co)
 * @license   http://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
 * @license   https://www.gnu.org/licenses/lgpl-2.1.html GNU Lesser General Public License, Version 2.1
 *
 * Licensed to Elasticsearch B.V under one or more agreements.
 * Elasticsearch B.V licenses this file to you under the Apache 2.0 License or
 * the GNU Lesser General Public License, Version 2.1, at your option.
 * See the LICENSE file in the project root for more information.
 */

namespace OpenSearch\Namespaces;

use OpenSearch\Endpoints\Tasks\Cancel;
use OpenSearch\Endpoints\Tasks\Get;
use OpenSearch\Endpoints\Tasks\ListTasks;

/**
 * Class TasksNamespace
 *
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class TasksNamespace extends AbstractNamespace
{
    /**
     * Cancels a task, if it can be cancelled through an API.
     *
     * $params['task_id']             = (string) ID of the task.
     * $params['actions']             = (any) Comma-separated list or wildcard expression of actions used to limit the request.
     * $params['nodes']               = (array) Comma-separated list of node IDs or names used to limit the request.
     * $params['parent_task_id']      = (string) Parent task ID used to limit the tasks.
     * $params['wait_for_completion'] = (boolean) Should the request block until the cancellation of the task and its descendant tasks is completed. Defaults to false (Default = false)
     * $params['pretty']              = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']               = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace']         = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']              = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']         = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function cancel(array $params = [])
    {
        $task_id = $this->extractArgument($params, 'task_id');

        $endpoint = $this->endpointFactory->getEndpoint(Cancel::class);
        $endpoint->setParams($params);
        $endpoint->setTaskId($task_id);

        return $this->performRequest($endpoint);
    }

    /**
     * Returns information about a task.
     *
     * $params['task_id']             = (string) ID of the task.
     * $params['timeout']             = (string) Period to wait for a response.If no response is received before the timeout expires, the request fails and returns an error.
     * $params['wait_for_completion'] = (boolean) If `true`, the request blocks until the task has completed. (Default = false)
     * $params['pretty']              = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']               = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace']         = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']              = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']         = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function get(array $params = [])
    {
        $task_id = $this->extractArgument($params, 'task_id');

        $endpoint = $this->endpointFactory->getEndpoint(Get::class);
        $endpoint->setParams($params);
        $endpoint->setTaskId($task_id);

        return $this->performRequest($endpoint);
    }

    /**
     * Returns a list of tasks.
     *
     * $params['actions']             = (any) Comma-separated list or wildcard expression of actions used to limit the request.
     * $params['detailed']            = (boolean) If `true`, the response includes detailed information about shard recoveries. (Default = false)
     * $params['group_by']            = (enum) Key used to group tasks in the response. (Options = nodes,none,parents)
     * $params['nodes']               = (array) Comma-separated list of node IDs or names to limit the returned information; use `_local` to return information from the node you're connecting to, leave empty to get information from all nodes.
     * $params['parent_task_id']      = (string) Parent task ID used to limit returned information. To return all tasks, omit this parameter or use a value of `-1`.
     * $params['timeout']             = (string) Period to wait for a response. If no response is received before the timeout expires, the request fails and returns an error.
     * $params['wait_for_completion'] = (boolean) If `true`, the request blocks until the operation is complete. (Default = false)
     * $params['pretty']              = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']               = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace']         = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']              = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']         = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function list(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(ListTasks::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Proxy function to list() to prevent BC break since 7.4.0
     */
    public function tasksList(array $params = [])
    {
        return $this->list($params);
    }
}
