<?php

/* System - Accounts
----------------------------------------------------------*/

if (!defined('PARENT') || !defined('MS_PERMISSIONS')) {
  include(PATH . 'control/system/headers/403.php');
}

// Check log in.
if (MS_PERMISSIONS == 'guest' || !isset($LI_ACC->id)) {
  header("Location:index.php?p=login");
  exit;
}

$title = $msg_header3;
$tz    = ($LI_ACC->timezone ? $LI_ACC->timezone : $SETTINGS->timezone);

include(PATH . 'control/header.php');

// Show.
$templateParams = [
  'TXT' => array(
    $msg_header13,
    $MSDT->mswDateTimeDisplay(strtotime(date('Y-m-d', $MSDT->mswUTC())), $SETTINGS->dateformat, $tz),
    $msg_public_dashboard1,
    $msg_public_dashboard2,
    $msg_public_dashboard3,
    $msg_public_dashboard4,
    $msg_public_dashboard5,
    str_replace('{name}', mswSH($LI_ACC->name), $msg_public_dashboard11),
    $msg_public_dashboard12,
    $msg_main2,
    $msg_public_account4,
    str_replace('{count}', $SETTINGS->popquestions, $msg_main10),
    str_replace('{count}', $SETTINGS->popquestions, $msg_public_main3),
    $msadminlangpublic[7],
    $msg_pkbase7,
    $msg_pkbase,
    mswSH($msadminlang3_1faq[4]),
    $msg_portal40,
    $msg_portal41
  ),
  'TXT2' => array(
    $msg_viewticket25,
    $msg_open36,
    $msg_open37,
    $msg_showticket18
  ),
  'TICKETS' => $MSTICKET->ticketList(MS_PERMISSIONS, array(
    0,
    99999
  ), false, 'AND `ticketStatus` NOT IN(\'close\',\'closed\')'),
  'DISPUTES' => $MSTICKET->disputeList(MS_PERMISSIONS, $LI_ACC->id, array(
    0,
    99999
  ), false, 'AND `ticketStatus` NOT IN(\'close\',\'closed\')'),
  'TICKETS_CNT' => $MSTICKET->ticketList(MS_PERMISSIONS, array(
    0,
    99999
  ), true, 'AND `ticketStatus` NOT IN(\'close\',\'closed\')'),
  'DISPUTES_CNT' => $MSTICKET->disputeList(MS_PERMISSIONS, $LI_ACC->id, array(
    0,
    99999
  ), true, 'AND `ticketStatus` NOT IN(\'close\',\'closed\')')
];

// Global vars.
include(PATH . 'control/global.php');

// Load template.
$latte->render('account-dashboard.tpl', $templateParams);

include(PATH . 'control/footer.php');

?>