<?php

/* System - Accounts
----------------------------------------------------------*/

if (!defined('PARENT') || !defined('MS_PERMISSIONS')) {
  include(PATH . 'control/system/headers/403.php');
}

// Session vars.exist only on initial load.
$ID    = ($SSN->active('create_id') == 'yes' ? (int) $SSN->get('create_id') : '0');
$pass  = ($SSN->active('create_pass') == 'yes' ? $SSN->get('create_pass') : '');
$email = ($SSN->active('create_email') == 'yes' ? $SSN->get('create_email') : '');
$tickn = ($SSN->active('create_tickno') == 'yes' ? $SSN->get('create_tickno') : '');

if ($ID > 0) {

  $title = $msg_main2 . ' (' . $msg_public_ticket4 . ')';

  include(PATH . 'control/header.php');

  $templateParams = [
    'TXT' => array(
      $msg_public_ticket4,
      $msg_newticket13,
      str_replace(array(
        '{ticket}',
        '{ticket_long}'
      ), array(
        $ID,
        mswTicketNumber($ID, $SETTINGS->minTickDigits, $tickn)
      ), $msg_public_ticket5),
      $msg_public_ticket6
    ),
    'ADD_TXT' => ($pass ? str_replace(array(
      '{email}',
      '{pass}',
      '{url}'
    ), array(
      mswSH($email),
      mswSH($pass),
      $SETTINGS->scriptpath
    ), $msg_public_ticket7) : ''),
    'ID' => $ID
  ];

  // Global vars.
  include(PATH . 'control/global.php');

  $latte->render('ticket-create-message.tpl', $templateParams);
  
  // Reset session vars.
  $SSN->delete(array('create_id', 'create_email', 'create_pass', 'create_tickno', 'fe_draft_add', 'fe_time_add'));

  include(PATH . 'control/footer.php');

} else {

  include(PATH . 'control/system/headers/403.php');

}

?>