<?php

/* System - FAQ
----------------------------------------------------------*/

// Check var and parent load.
if (!defined('PARENT') || !isset($_GET['a']) || !defined('MS_PERMISSIONS') || $SETTINGS->kbase == 'no') {
  include(PATH . 'control/system/headers/403.php');
}

// Security check.
mswVLDG($_GET['a']);

$QUE = mswSQL_table('faq', 'id', (int) $_GET['a'], 'AND `enFaq` = \'yes\'', '*');

if (!isset($QUE->question)) {
  include(PATH . 'control/system/headers/404.php');
}

// Is this private?
if ($QUE->private == 'yes' && !isset($LI_ACC->id)) {
  include(PATH . 'control/system/headers/403.php');
}

// Variables.
$title = $QUE->question . ' - ' . $msg_adheader17;
$subt  = $msg_header8;
$cky   = [];

// Check for category/search params.
if (isset($_GET['c']) && (int) $_GET['c'] > 0) {
  $CAT = mswSQL_table('categories', 'id', (int) $_GET['c'], 'AND `enCat` = \'yes\'', '`id`,`name`,`subcat`,`private`,`accounts`');
  if (isset($CAT->name)) {
    if (isset($CAT->subcat) && $CAT->subcat > 0) {
      $SUB = mswSQL_table('categories', 'id', $CAT->subcat);
    }
    // Is this private account based category?
    if ($CAT->private == 'yes' && !isset($LI_ACC->id)) {
      include(PATH . 'control/system/headers/403.php');
    }
    if ($CAT->private == 'yes' && !in_array($CAT->accounts, array(null, '', 'all')) && !in_array($LI_ACC->id, explode(',', $CAT->accounts))) {
      include(PATH . 'control/system/headers/403.php');
    }
  } else {
    include(PATH . 'control/system/headers/403.php');
  }
} else {
  // If category isn`t set in the url, get category from question.
  $CAT = mswSQL_table('categories', 'id', $QUE->cat, 'AND `enCat` = \'yes\'', '`name`,`subcat`,`private`,`accounts`');
  if (isset($CAT->name)) {
    if (isset($CAT->subcat) && $CAT->subcat > 0) {
      $SUB = mswSQL_table('categories', 'id', $CAT->subcat);
    }
    if ($CAT->private == 'yes' && !isset($LI_ACC->id)) {
      include(PATH . 'control/system/headers/403.php');
    }
    // Is this private account based category?
    if ($CAT->private == 'yes' && !in_array($CAT->accounts, array(null, '', 'all')) && !in_array($LI_ACC->id, explode(',', $CAT->accounts))) {
      include(PATH . 'control/system/headers/403.php');
    }
  } else {
    include(PATH . 'control/system/headers/403.php');
  }
}

// Header.
include(PATH . 'control/header.php');

// Cookie set.
if ($SSN->active_c('msp_admn_cookie') == 'yes') {
  $cky = unserialize($SSN->get_c('msp_admn_cookie'));
}

// Template initialisation.
$templateParams = [
  'TXT' => array(
    $msg_kbase52,
    $msg_kbase54,
    $msg_pkbase18,
    $msg_pkbase,
    mswSH($mspubliclang3_7[5] . ' - ' . $msg_pkbase2),
    $msadminlang3_1faq[5],
    $msg_pkbase7,
    $msadminlang3_1faq[6],
    $msadminlang3_1faq[7],
    $msg_kbase51,
    $msg_header8,
    $msadminlang3_1faq[8],
    $msadminlang3_1faq[9],
    str_replace('{date}', $MSDT->mswDateTimeDisplay($QUE->ts, $SETTINGS->dateformat), $msg_pkbase11),
    $msadminlang3_1faq[11],
    $mspubliclang3_7[3],
    $mspubliclang3_7[4]
  ),
  'PARENT' => (isset($CAT->id) ? (array) $CAT : []),
  'SUB' => (isset($SUB->id) ? (array) $SUB : []),
  'SCH_TXT' => $msg_header4,
  'ANSWER' => (array) $QUE,
  'ANSWER_TXT' => $MSPARSER->_display($QUE->answer),
  'MSDT' => $MSDT,
  'ATTACHMENTS' => $FAQ->attachments(),
  'FAQ_COOKIE_SET' => (in_array($_GET['a'], $cky) ? 'yes' : 'no'),
  'STATS' => $FAQ->stats($QUE->id)
];

// Global vars.
include(PATH . 'control/global.php');

// Load template.
if ($QUE->tmp && file_exists('content/' . MS_TEMPLATE_SET . '/custom-templates/' . $QUE->tmp)) {
  $latte->render('custom-templates/' . $QUE->tmp, $templateParams);
} else {
  $latte->render('faq-question.tpl', $templateParams);
}

// Load js triggers.
if (file_exists(PATH . 'content/' . MS_TEMPLATE_SET . '/html/js/print-friendly.htm')) {
  $jsHTML = str_replace(array(
    '{website}'
  ), array(
      mswJSClean($SETTINGS->website)
  ), mswTmp(PATH . 'content/' . MS_TEMPLATE_SET . '/html/js/print-friendly.htm', 'ok'));
}

// Footer.
include(PATH . 'control/footer.php');

?>