<?php

/* Admin - System Module
----------------------------------------------------------*/

if (!defined('PARENT') || !isset($MSTEAM->mailbox) || !class_exists('mailBox')) {
  include(PATH . 'control/system/header/403.php');
}

define('MAILBOX_LOADER', 1);

// Is mailbox enabled?
if ($MSTEAM->mailbox == 'no') {
  include(PATH . 'control/system/header/403.php');
}

$title    = $msg_adheader61 . ' (' . $msg_mailbox . ')';
$boxName  = $msg_mailbox;
$temp     = 'mailbox-folder.php';
$toLoad   = 'inbox';

$mswWysCfg = array(
  'lang' => ($msWysiwyg_cfg[0] != 'en' && file_exists(PATH . 'content/js/plugins/i18n-wysiwyg/' . $msWysiwyg_cfg[0] . '.min.js') ? $msWysiwyg_cfg[0] : ''),
  'textarea' => 'textarea[name="message"]'
);
define('WYSIWYG_ED', 'yes');

// Run auto purge..
if ($MSTEAM->mailPurge > 0 && $SSN->active('autoPurgeRan') == 'no') {
  $MSMB->autoPurge($MSTEAM->id, $MSTEAM->mailPurge);
  // We`ll set a session cookie here, this prevents it being run again in this session..
  $SSN->set(array('autoPurgeRan' => true));
}

// Load folder..
if (isset($_GET['f'])) {
  $temp = (in_array($_GET['f'], array(
    'outbox',
    'bin'
  )) ? $_GET['f'] : (int) $_GET['f']);
  switch ($temp) {
    case 'outbox':
      $title   = $msg_adheader61 . ' (' . $msg_mailbox2 . ')';
      $boxName = $msg_mailbox2;
      $toLoad  = 'outbox';
      break;
    case 'bin':
      $title   = $msg_adheader61 . ' (' . $msg_mailbox3 . ')';
      $boxName = $msg_mailbox3;
      $toLoad  = 'bin';
      break;
    default:
      if ($temp > 0) {
        $FLDER = mswSQL_table('mailfolders', 'id', $temp, 'AND `staffID` = \'' . $MSTEAM->id . '\'');
        if (isset($FLDER->folder)) {
          $boxName = mswSH($FLDER->folder);
          $title   = $msg_adheader61 . ' (' . $boxName . ')';
          $toLoad  = $FLDER->id;
        } else {
          include(PATH . 'control/system/header/403.php');
        }
      } else {
        include(PATH . 'control/system/header/403.php');
      }
      break;
  }
  $temp = 'mailbox-folder.php';
}

// New message..
if (isset($_GET['new'])) {
  $title = $msg_adheader61 . ' (' . $msg_mailbox4 . ')';
  $temp = 'new-message.php';
}

// View message..
if (isset($_GET['msg'])) {
  $MID   = (int) $_GET['msg'];
  // Check permissions..
  $perms = $MSMB->perms();
  if (empty($perms) || !in_array($MSTEAM->id, $perms)) {
    include(PATH . 'control/system/header/403.php');
  }
  // Load message..
  $MMSG = mswSQL_table('mailbox', 'id', $MID);
  if (!isset($MMSG->id)) {
    include(PATH . 'control/system/header/404.php');
  }
  // Mark as read..
  $MSMB->mark('mbread', $MSTEAM->id, array(
    $MID
  ));
  $title = $msg_adheader61 . ' (' . $msg_mailbox7 . ')';
  $temp  = 'view-message.php';
}

// Manage folders..
if (isset($_GET['folders']) && $MSTEAM->mailFolders > 0) {
  $title = $msg_adheader61 . ' (' . $msg_mailbox6 . ')';
  $temp = 'manage-folders.php';
}

include(PATH . 'content/header.php');
include(PATH . 'content/system/mailbox/' . $temp);
include(PATH . 'content/footer.php');

?>