<?php

/* CLASS FILE
----------------------------------*/

class tags {

  // List of allowed tags for WYSIWYG content display (admin)
  // Leave empty to allow all tags (not recommended)
  const ALLOWED_TAGS = [
    '<p>','<blockquote>','<h1>','<span>','<h2>','<h3>','<h4>',
    '<b>','<br>','<i>','<strike>','<sup>','<sub>','<a>','<img>',
    '<ul>','<li>','<ol>','<div>','<iframe>','<font>','<pre>','<code>'
  ];
  
  // List of allowed tags for WYSIWYG for visitor. Here anything not allowed
  // is filtered on submit. Leave empty to allow all tags (NOT recommended)
  const ALLOWED_VIS_TAGS = [
    '<p>','<span>','<b>','<br>','<i>','<ul>','<li>',
    '<ol>','<div>','<font>','<code>','<pre>','<a>'
  ];

  public static function filter($data, $vis = 'no') {
    return strip_tags((string) $data, ($vis == 'no' ? tags::ALLOWED_TAGS : tags::ALLOWED_VIS_TAGS));
  }

}

?>