<?php

/* INSTALLER
------------------------------------------------*/

header('Expires: Sun, 01 Jan 2014 00:00:00 GMT');
header('Cache-Control: no-store, no-cache, must-revalidate');
header('Cache-Control: post-check=0, pre-check=0', FALSE);
header('Pragma: no-cache');
header('Content-type: text/html; charset=utf-8');
if (isset($_SERVER['HTTP_USER_AGENT']) && (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE') !== false)) {
  header('X-UA-Compatible: IE=edge,chrome=1');
}

date_default_timezone_set('UTC');

define('PARENT', 1);
define('PATH', __dir__ . '/');
define('BASE_PATH', __dir__ . '/../');
define('INS_ROUTINE', 1);

include(PATH . 'control/config.php');
include(BASE_PATH . 'control/options.php');
if(file_exists(BASE_PATH . 'control/_cfg.php')){include(BASE_PATH . 'control/_cfg.php');}else{die('File "control/_cfg.php" is missing, please see installation instructions.');}

echo (!function_exists('json_decode') ? die('The JSON functions are not enabled on your server. Enable and restart server. If you are unsure please contact your host.') : '');

include(BASE_PATH . 'control/system/constants.php');

// AUTO LOADER > COMPOSER
include(BASE_PATH . 'control/lib/vendor/autoload.php');

// TRACY DEBUGGER
use Tracy\Debugger;
Debugger::$showBar = (defined('DEVELOPMENT_ENV') ? true : false);
Debugger::$strictMode = (defined('DEVELOPMENT_ENV') ? true : false);
Debugger::$errorTemplate = BASE_PATH . 'control/system/headers/500-debug.php';
Debugger::enable((defined('DEVELOPMENT_ENV') ? Debugger::DEVELOPMENT : Debugger::PRODUCTION), BASE_PATH . 'logs');

include(BASE_PATH . 'control/functions.php');
include(BASE_PATH . 'control/timezones.php');
include(BASE_PATH . 'control/db.php');

try {
  mswSQL_connect();
  include(PATH . 'control/functions.php');
  include(BASE_PATH . 'control/classes/system/class.json.php');

  include(PATH . 'control/arrays.php');

  $JSON     = new jsonHandler();
  $cmd      = (isset($_GET['s']) ? $_GET['s'] : '1');
  $title    = SCRIPT_NAME . ': Installation';
  $count    = 0;
  $defChar  = 'utf8mb4_general_ci';
  $sqlVer   = mswSQL_version();

  // Set limits
  $ini_get = ini_get_all();
  if (isset($ini_get['memory_limit']) && MS_SET_MEM_ALLOCATION_LIMIT) {
    ini_set('memory_limit', MS_SET_MEM_ALLOCATION_LIMIT);
  }
  set_time_limit(MS_SET_TIME_OUT_LIMIT);

  // Check if we should be loading the upgrade instead
  if (in_array(DB_PREFIX . 'settings', mswSQL_tablestatus())) {
    $SETTINGS = mswSQL_fetchobj(mswSQL_query("SELECT * FROM `" . DB_PREFIX . "settings` LIMIT 1", __file__, __line__));
    if (is_object($SETTINGS) && property_exists($SETTINGS, 'softwareVersion') && $SETTINGS->softwareVersion < SCRIPT_VERSION) {
      header("Location: upgrade.php");
      exit;
    }
  }

  if (isset($_GET['ajax-ops'])) {
    include(PATH . 'control/_ajax.php');
    exit;
  }

  include(PATH . 'content/header.php');
  include(PATH . 'content/install.php');
  include(PATH . 'content/footer.php');
} catch(Exception $e) {
  echo 'The installer cannot run. Error returned by server:<br><br>';
  echo '"<b>' . $e->getMessage() . '</b>"<br><br>';
  echo 'If you understand the reason for this error and can fix it locally, please update and reload page.<br><br>'; 
  echo 'If you do not understand this message, please <a href="https://www.maianmedia.com/support">contact us</a>.<br><br>';
  echo 'Sorry for any inconvenience.<br><br>Maian Media';
} catch(Error $e) {
  echo 'The installer cannot run. Error returned by server:<br><br>';
  echo '"<b>' . $e->getMessage() . '</b>"<br><br>';
  echo 'If you understand the reason for this error and can fix it locally, please update and reload page.<br><br>'; 
  echo 'If you do not understand this message, please <a href="https://www.maianmedia.com/support">contact us</a>.<br><br>';
  echo 'Sorry for any inconvenience.<br><br>Maian Media';
}


?>