
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `maian50`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]admin_pages`
--

CREATE TABLE `[[dbprefix]]admin_pages` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `ts` int(30) NOT NULL DEFAULT '0',
  `title` mediumtext,
  `information` mediumtext,
  `enPage` enum('yes','no') NOT NULL DEFAULT 'yes',
  `orderBy` int(8) NOT NULL DEFAULT '0',
  `accounts` mediumtext,
  `tmp` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]attachments`
--

CREATE TABLE `[[dbprefix]]attachments` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `ts` int(30) NOT NULL DEFAULT '0',
  `ticketID` varchar(20) NOT NULL DEFAULT '',
  `replyID` int(11) NOT NULL DEFAULT '0',
  `department` int(5) NOT NULL DEFAULT '0',
  `fileName` varchar(250) NOT NULL DEFAULT '',
  `fileSize` varchar(20) NOT NULL DEFAULT '',
  `mimeType` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `tickid_index` (`ticketID`),
  KEY `repid_index` (`replyID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ban`
--

CREATE TABLE `[[dbprefix]]ban` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL DEFAULT '',
  `ip` varchar(250) NOT NULL DEFAULT '',
  `count` int(5) NOT NULL DEFAULT '0',
  `banstamp` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]categories`
--

CREATE TABLE `[[dbprefix]]categories` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `summary` varchar(250) NOT NULL DEFAULT '',
  `enCat` enum('yes','no') NOT NULL DEFAULT 'yes',
  `orderBy` int(5) NOT NULL DEFAULT '0',
  `subcat` int(5) NOT NULL DEFAULT '0',
  `private` enum('yes','no') NOT NULL DEFAULT 'no',
  `accounts` mediumtext,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]categories`
--

INSERT INTO `[[dbprefix]]categories` VALUES
(1, 'Software Questions', 'This category relates to our software', 'yes', 1, 0, 'no', NULL),
(2, 'Company Questions', 'This category relates to our company', 'yes', 2, 0, 'no', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cusfields`
--

CREATE TABLE `[[dbprefix]]cusfields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fieldInstructions` varchar(250) NOT NULL DEFAULT '',
  `fieldType` enum('textarea','input','select','checkbox','calendar') NOT NULL DEFAULT 'input',
  `fieldReq` enum('yes','no') NOT NULL DEFAULT 'no',
  `fieldOptions` mediumtext,
  `fieldLoc` varchar(25) NOT NULL DEFAULT '',
  `orderBy` int(5) NOT NULL DEFAULT '0',
  `repeatPref` enum('yes','no') NOT NULL DEFAULT 'yes',
  `enField` enum('yes','no') NOT NULL DEFAULT 'yes',
  `departments` mediumtext,
  `accounts` mediumtext,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]departments`
--

CREATE TABLE `[[dbprefix]]departments` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `showDept` enum('yes','no') NOT NULL DEFAULT 'no',
  `dept_subject` mediumtext,
  `dept_comments` mediumtext,
  `orderBy` int(5) NOT NULL DEFAULT '0',
  `manual_assign` enum('yes','no') NOT NULL DEFAULT 'no',
  `days` mediumtext,
  `dept_priority` varchar(50) NOT NULL DEFAULT '',
  `auto_admin` enum('yes','no') NOT NULL DEFAULT 'yes',
  `auto_response` enum('yes','no') NOT NULL DEFAULT 'no',
  `response` mediumtext,
  `response_sbj` mediumtext,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]departments`
--

INSERT INTO `[[dbprefix]]departments` VALUES
(1, 'General Support', 'yes', '', '', 1, 'no', NULL, '', 'yes', 'no', NULL, NULL),
(2, 'Sales and Billing', 'yes', '', '', 2, 'no', NULL, '', 'yes', 'no', NULL, NULL),
(3, 'Technical Support', 'yes', '', '', 3, 'no', NULL, '', 'yes', 'no', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]disputes`
--

CREATE TABLE `[[dbprefix]]disputes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ticketID` int(15) NOT NULL DEFAULT '0',
  `visitorID` int(8) NOT NULL DEFAULT '0',
  `postPrivileges` enum('yes','no') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`id`),
  KEY `tickid_index` (`ticketID`),
  KEY `vis_index` (`visitorID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]faq`
--

CREATE TABLE `[[dbprefix]]faq` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `ts` int(30) NOT NULL DEFAULT '0',
  `question` mediumtext,
  `answer` mediumtext,
  `kviews` int(10) NOT NULL DEFAULT '0',
  `kuseful` int(10) NOT NULL DEFAULT '0',
  `knotuseful` int(10) NOT NULL DEFAULT '0',
  `enFaq` enum('yes','no') NOT NULL DEFAULT 'yes',
  `featured` enum('yes','no') NOT NULL DEFAULT 'no',
  `orderBy` int(5) NOT NULL DEFAULT '0',
  `cat` int(7) NOT NULL DEFAULT '0',
  `private` enum('yes','no') NOT NULL DEFAULT 'no',
  `tmp` varchar(250) NOT NULL DEFAULT '',
  `searchkeys` mediumtext,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]faq`
--

INSERT INTO `[[dbprefix]]faq` VALUES
(1, [[timestamp]], 'Why is our software the best?', 'This is a test question created when installing Maian Support\n\nPlease update or remove via your admin control panel', 0, 0, 0, 'yes', 'no', 1, 1, 'no', '', NULL),
(2, [[timestamp]], 'Why is our company the best?', 'This is a test question created when installing Maian Support\n\nPlease update or remove via your admin control panel', 0, 0, 0, 'yes', 'no', 2, 2, 'no', '', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]faqassign`
--

CREATE TABLE `[[dbprefix]]faqassign` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `question` int(7) NOT NULL DEFAULT '0',
  `itemID` int(7) NOT NULL DEFAULT '0',
  `desc` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `que_index` (`question`),
  KEY `att_index` (`itemID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]faqattach`
--

CREATE TABLE `[[dbprefix]]faqattach` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `ts` int(30) NOT NULL DEFAULT '0',
  `name` varchar(250) NOT NULL DEFAULT '',
  `remote` varchar(250) NOT NULL DEFAULT '',
  `path` varchar(250) NOT NULL DEFAULT '',
  `size` varchar(30) NOT NULL DEFAULT '',
  `orderBy` int(8) NOT NULL DEFAULT '0',
  `enAtt` enum('yes','no') NOT NULL DEFAULT 'yes',
  `mimeType` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]faqdl`
--

CREATE TABLE `[[dbprefix]]faqdl` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `question` int(7) NOT NULL DEFAULT '0',
  `token` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]faqhistory`
--

CREATE TABLE `[[dbprefix]]faqhistory` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `ts` int(30) NOT NULL DEFAULT '0',
  `faqID` int(11) NOT NULL DEFAULT '0',
  `action` mediumtext,
  `ip` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `faq_index` (`faqID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]imap`
--

CREATE TABLE `[[dbprefix]]imap` (
  `id` int(8) unsigned NOT NULL AUTO_INCREMENT,
  `im_piping` enum('yes','no') NOT NULL DEFAULT 'no',
  `im_protocol` enum('pop3','imap') NOT NULL DEFAULT 'pop3',
  `im_host` varchar(100) NOT NULL DEFAULT '',
  `im_user` varchar(250) NOT NULL DEFAULT '',
  `im_pass` varchar(100) NOT NULL DEFAULT '',
  `im_port` int(5) NOT NULL DEFAULT '110',
  `im_name` varchar(50) NOT NULL DEFAULT '',
  `im_flags` varchar(250) NOT NULL DEFAULT '',
  `im_attach` enum('yes','no') NOT NULL DEFAULT 'no',
  `im_move` varchar(50) NOT NULL DEFAULT '',
  `im_messages` int(3) NOT NULL DEFAULT '20',
  `im_ssl` enum('yes','no') NOT NULL DEFAULT 'no',
  `im_priority` varchar(250) NOT NULL DEFAULT '',
  `im_status` varchar(100) NOT NULL DEFAULT '',
  `im_dept` int(5) NOT NULL DEFAULT '0',
  `im_email` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]imapban`
--

CREATE TABLE `[[dbprefix]]imapban` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `filter` mediumtext,
  `account` enum('yes','no') NOT NULL DEFAULT 'yes',
  `spam` enum('yes','no') NOT NULL DEFAULT 'no',
  PRIMARY KEY (`id`),
  FULLTEXT KEY `filter` (`filter`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]imapban`
--

INSERT INTO `[[dbprefix]]imapban` VALUES
(1, 'mailer-daemon', 'yes', 'no');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]levels`
--

CREATE TABLE `[[dbprefix]]levels` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `display` enum('yes','no') NOT NULL DEFAULT 'no',
  `marker` varchar(100) NOT NULL DEFAULT '',
  `orderBy` int(5) NOT NULL DEFAULT '0',
  `colors` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]levels`
--

INSERT INTO `[[dbprefix]]levels` VALUES
(1, 'Low', 'yes', 'low', 1, 'a:2:{s:2:"fg";s:6:"000000";s:2:"bg";s:6:"CCECF2";}'),
(2, 'Medium', 'yes', 'medium', 2, 'a:2:{s:2:"fg";s:6:"FFFFFF";s:2:"bg";s:6:"B4A7BE";}'),
(3, 'High', 'yes', 'high', 3, 'a:2:{s:2:"fg";s:6:"FFFFFF";s:2:"bg";s:6:"D42449";}');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]log`
--

CREATE TABLE `[[dbprefix]]log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ts` int(30) NOT NULL DEFAULT '0',
  `userID` int(5) NOT NULL DEFAULT '0',
  `ip` varchar(250) NOT NULL DEFAULT '',
  `type` enum('user','acc') NOT NULL DEFAULT 'user',
  PRIMARY KEY (`id`),
  KEY `useid_index` (`userID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mailassoc`
--

CREATE TABLE `[[dbprefix]]mailassoc` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `staffID` int(8) NOT NULL DEFAULT '0',
  `mailID` int(8) NOT NULL DEFAULT '0',
  `folder` varchar(10) NOT NULL DEFAULT 'inbox',
  `status` enum('read','unread') NOT NULL DEFAULT 'unread',
  `lastUpdate` int(30) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `staff_index` (`staffID`),
  KEY `mail_index` (`mailID`),
  KEY `status_index` (`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mailbox`
--

CREATE TABLE `[[dbprefix]]mailbox` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ts` int(30) NOT NULL DEFAULT '0',
  `staffID` int(8) NOT NULL DEFAULT '0',
  `subject` varchar(250) NOT NULL DEFAULT '',
  `message` mediumtext,
  PRIMARY KEY (`id`),
  KEY `staff_index` (`staffID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mailfolders`
--

CREATE TABLE `[[dbprefix]]mailfolders` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `staffID` int(8) NOT NULL DEFAULT '0',
  `folder` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `staff_index` (`staffID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mailreplies`
--

CREATE TABLE `[[dbprefix]]mailreplies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ts` int(30) NOT NULL DEFAULT '0',
  `mailID` int(8) NOT NULL DEFAULT '0',
  `staffID` int(8) NOT NULL DEFAULT '0',
  `message` mediumtext,
  PRIMARY KEY (`id`),
  KEY `mail_index` (`mailID`),
  KEY `staff_index` (`staffID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pages`
--

CREATE TABLE `[[dbprefix]]pages` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `ts` int(30) NOT NULL DEFAULT '0',
  `title` mediumtext,
  `information` mediumtext,
  `enPage` enum('yes','no') NOT NULL DEFAULT 'yes',
  `orderBy` int(8) NOT NULL DEFAULT '0',
  `secure` enum('yes','no') NOT NULL DEFAULT 'no',
  `accounts` mediumtext,
  `tmp` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]portal`
--

CREATE TABLE `[[dbprefix]]portal` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `ts` int(30) NOT NULL DEFAULT '0',
  `email` varchar(250) NOT NULL DEFAULT '',
  `userPass` varchar(250) NOT NULL DEFAULT '',
  `enabled` enum('yes','no') NOT NULL DEFAULT 'yes',
  `verified` enum('yes','no') NOT NULL DEFAULT 'no',
  `timezone` varchar(50) NOT NULL DEFAULT '0',
  `ip` mediumtext,
  `notes` mediumtext,
  `reason` mediumtext,
  `system1` varchar(250) NOT NULL DEFAULT '',
  `system2` varchar(250) NOT NULL DEFAULT '',
  `language` varchar(100) NOT NULL DEFAULT '',
  `enableLog` enum('yes','no') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`id`),
  KEY `em_index` (`email`),
  KEY `nm_index` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]replies`
--

CREATE TABLE `[[dbprefix]]replies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ts` int(30) NOT NULL DEFAULT '0',
  `ticketID` int(15) NOT NULL DEFAULT '0',
  `comments` mediumtext,
  `mailBodyFilter` varchar(30) NOT NULL DEFAULT '',
  `replyType` enum('none','visitor','admin') NOT NULL DEFAULT 'none',
  `replyUser` int(8) NOT NULL DEFAULT '0',
  `isMerged` enum('yes','no') NOT NULL DEFAULT 'no',
  `ipAddresses` mediumtext,
  `disputeUser` int(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `tickid_index` (`ticketID`),
  KEY `repuse_index` (`replyUser`),
  KEY `disuse_index` (`disputeUser`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]responses`
--

CREATE TABLE `[[dbprefix]]responses` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `ts` int(30) NOT NULL DEFAULT '0',
  `title` mediumtext,
  `answer` mediumtext,
  `enResponse` enum('yes','no') NOT NULL DEFAULT 'yes',
  `orderBy` int(8) NOT NULL DEFAULT '0',
  `departments` mediumtext,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]settings`
--

CREATE TABLE `[[dbprefix]]settings` (
  `id` tinyint(1) NOT NULL AUTO_INCREMENT,
  `website` varchar(150) NOT NULL DEFAULT '',
  `email` varchar(250) NOT NULL DEFAULT '',
  `replyto` varchar(250) NOT NULL DEFAULT '',
  `scriptpath` varchar(250) NOT NULL DEFAULT '',
  `attachpath` varchar(250) NOT NULL DEFAULT '',
  `attachhref` varchar(250) NOT NULL DEFAULT '',
  `attachpathfaq` varchar(250) NOT NULL DEFAULT '',
  `attachhreffaq` varchar(250) NOT NULL DEFAULT '',
  `bfolder` varchar(250) NOT NULL DEFAULT '',
  `language` varchar(250) NOT NULL DEFAULT 'english',
  `langSets` mediumtext,
  `dateformat` varchar(20) NOT NULL DEFAULT 'D j M Y, G:ia',
  `timeformat` varchar(15) NOT NULL DEFAULT 'H:iA',
  `timezone` varchar(50) NOT NULL DEFAULT 'Europe/London',
  `weekStart` enum('mon','sun') NOT NULL DEFAULT 'sun',
  `jsDateFormat` varchar(15) NOT NULL DEFAULT 'DD/MM/YYYY',
  `kbase` enum('yes','no') NOT NULL DEFAULT 'yes',
  `enableVotes` enum('yes','no') NOT NULL DEFAULT 'yes',
  `multiplevotes` enum('yes','no') NOT NULL DEFAULT 'no',
  `popquestions` int(5) NOT NULL DEFAULT '0',
  `quePerPage` int(3) NOT NULL DEFAULT '10',
  `cookiedays` int(5) NOT NULL DEFAULT '0',
  `renamefaq` enum('yes','no') NOT NULL DEFAULT 'no',
  `attachment` enum('yes','no') NOT NULL DEFAULT 'no',
  `rename` enum('yes','no') NOT NULL DEFAULT 'no',
  `attachboxes` int(3) NOT NULL DEFAULT '2',
  `filetypes` mediumtext,
  `maxsize` int(15) NOT NULL DEFAULT '200',
  `afolder` varchar(50) NOT NULL DEFAULT '',
  `autoClose` int(5) NOT NULL DEFAULT '0',
  `autoCloseMail` enum('yes','no') NOT NULL DEFAULT 'yes',
  `smtp_host` varchar(100) NOT NULL DEFAULT 'localhost',
  `smtp_user` varchar(100) NOT NULL DEFAULT '',
  `smtp_pass` varchar(100) NOT NULL DEFAULT '',
  `smtp_port` int(4) NOT NULL DEFAULT '25',
  `smtp_security` varchar(10) NOT NULL DEFAULT '',
  `smtp_debug` enum('yes','no') NOT NULL DEFAULT 'no',
  `smtp_html` enum('yes','no') NOT NULL DEFAULT 'yes',
  `prodKey` char(60) NOT NULL DEFAULT '',
  `publicFooter` mediumtext,
  `adminFooter` mediumtext,
  `encoderVersion` varchar(5) NOT NULL DEFAULT '',
  `softwareVersion` varchar(10) NOT NULL DEFAULT '',
  `apiKey` varchar(100) NOT NULL DEFAULT '',
  `apiLog` enum('yes','no') NOT NULL DEFAULT 'no',
  `apiHandlers` varchar(100) NOT NULL DEFAULT '',
  `sysstatus` enum('yes','no') NOT NULL DEFAULT 'yes',
  `autoenable` date NOT NULL DEFAULT '1970-01-01',
  `disputes` enum('yes','no') NOT NULL DEFAULT 'no',
  `offlineReason` mediumtext,
  `createPref` enum('yes','no') NOT NULL DEFAULT 'yes',
  `createAcc` enum('yes','no') NOT NULL DEFAULT 'yes',
  `loginLimit` int(5) NOT NULL DEFAULT '0',
  `banTime` int(5) NOT NULL DEFAULT '0',
  `ticketHistory` enum('yes','no') NOT NULL DEFAULT 'yes',
  `backupEmails` mediumtext,
  `closenotify` enum('yes','no') NOT NULL DEFAULT 'no',
  `minPassValue` int(3) NOT NULL DEFAULT '8',
  `accProfNotify` enum('yes','no') NOT NULL DEFAULT 'yes',
  `newAccNotify` enum('yes','no') NOT NULL DEFAULT 'yes',
  `enableLog` enum('yes','no') NOT NULL DEFAULT 'yes',
  `defKeepLogs` varchar(100) NOT NULL DEFAULT '',
  `minTickDigits` int(2) NOT NULL DEFAULT '5',
  `enableMail` enum('yes','no') NOT NULL DEFAULT 'yes',
  `imap_debug` enum('yes','no') NOT NULL DEFAULT 'no',
  `imap_param` varchar(10) NOT NULL DEFAULT '',
  `imap_memory` varchar(3) NOT NULL DEFAULT '10',
  `imap_timeout` varchar(3) NOT NULL DEFAULT '120',
  `imap_attach` enum('yes','no') NOT NULL DEFAULT 'no',
  `imap_notify` enum('yes','no') NOT NULL DEFAULT 'no',
  `disputeAdminStop` enum('yes','no') NOT NULL DEFAULT 'no',
  `faqcounts` enum('yes','no') NOT NULL DEFAULT 'no',
  `closeadmin` enum('yes','no') NOT NULL DEFAULT 'no',
  `adminlock` enum('yes','no') NOT NULL DEFAULT 'no',
  `locktime` int(7) NOT NULL DEFAULT '0',
  `imap_clean` enum('yes','no') NOT NULL DEFAULT 'yes',
  `tawk` mediumtext,
  `tawk_home` enum('yes','no') NOT NULL DEFAULT 'no',
  `defdept` int(5) NOT NULL DEFAULT '0',
  `defprty` varchar(50) NOT NULL DEFAULT '',
  `rantick` enum('yes','no') NOT NULL DEFAULT 'no',
  `imap_open` enum('yes','no') NOT NULL DEFAULT 'no',
  `autospam` int(5) NOT NULL DEFAULT '0',
  `wordwrap` varchar(200) NOT NULL DEFAULT '',
  `timetrack` enum('yes','no') NOT NULL DEFAULT 'yes',
  `selfsign` enum('yes','no') NOT NULL DEFAULT 'no',
  `openlimit` enum('yes','no') NOT NULL DEFAULT 'no',
  `mail` enum('smtp','mail') NOT NULL DEFAULT 'smtp',
  `accautodel` int(5) NOT NULL DEFAULT '0',
  `visclose` enum('yes','no') NOT NULL DEFAULT 'no',
  `imapspamcloseacc` enum('yes','no') NOT NULL DEFAULT 'no',
  `navmenu` mediumtext,
  `faqHistory` enum('yes','no') NOT NULL DEFAULT 'no',
  `spam_score_header` varchar(100) NOT NULL DEFAULT '',
  `spam_score_value` varchar(100) NOT NULL DEFAULT '0',
  `en_cap` enum('yes','no') NOT NULL DEFAULT 'no',
  `tprefix` varchar(30) NOT NULL DEFAULT '',
  `notify_close` enum('yes','no') NOT NULL DEFAULT 'yes',
  `notify_open` enum('yes','no') NOT NULL DEFAULT 'yes',
  `notify_other` enum('yes','no') NOT NULL DEFAULT 'yes',
  `viscloseticket` enum('yes','no') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]settings`
--

INSERT INTO `[[dbprefix]]settings` VALUES
(1, '[[site_name]]', '[[admin_email]]', '', '[[softurl]]', '[[softpath]]/content/attachments', '[[softurl]]/content/attachments', '[[softpath]]/content/attachments-faq', '[[softurl]]/content/attachments-faq', '', 'english', 'a:1:{s:7:"english";s:12:"_default_set";}', 'd M Y', 'H:iA', 'Europe/London', 'sun', 'DD-MM-YYYY', 'yes', 'yes', 'yes', 10, 10, 360, 'no', 'yes', 'yes', 5, '.jpg|.zip|.gif|.rar|.png|.pdf', 1048576, 'admin', 0, 'yes', '', '', '', 587, '', 'no', 'yes', '[[prodKey]]', '', '', 'msw', '5.0', '[[apiKey]]', 'yes', 'json,xml', 'yes', '1970-01-01', 'no', '', 'no', 'yes', 5, 5, 'yes', '', 'no', 8, 'yes', 'yes', 'yes', 'a:2:{s:4:"user";s:2:"50";s:3:"acc";s:2:"50";}', 5, 'yes', 'yes', 'pipe', '0', '0', 'no', 'no', 'no', 'no', 'no', 'no', 0, 'yes', NULL, 'no', 0, '', 'no', 'no', 0, '', 'no', 'no', 'no', 'smtp', 0, 'no', 'no', NULL, 'no', '', '0', 'no', '', 'yes', 'yes', 'yes', 'yes');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]social`
--

CREATE TABLE `[[dbprefix]]social` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `desc` varchar(50) NOT NULL DEFAULT '',
  `param` mediumtext,
  `value` mediumtext,
  PRIMARY KEY (`id`),
  KEY `descK` (`desc`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]statuses`
--

CREATE TABLE `[[dbprefix]]statuses` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `perms` enum('yes','no') NOT NULL DEFAULT 'no',
  `marker` varchar(100) NOT NULL DEFAULT '',
  `orderBy` int(5) NOT NULL DEFAULT '0',
  `colors` varchar(200) NOT NULL DEFAULT '',
  `visitor` enum('yes','no') NOT NULL DEFAULT 'yes',
  `autoclose` enum('yes','no') NOT NULL DEFAULT 'no',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]statuses`
--

INSERT INTO `[[dbprefix]]statuses` VALUES
(1, 'Open', 'yes', 'open', 2, '', 'yes', 'no'),
(2, 'Closed', 'yes', 'close', 1, '', 'yes', 'no'),
(3, 'Locked', 'yes', 'closed', 3, '', 'yes', 'no');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ticketfields`
--

CREATE TABLE `[[dbprefix]]ticketfields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ticketID` varchar(20) NOT NULL DEFAULT '',
  `fieldID` int(15) NOT NULL DEFAULT '0',
  `replyID` int(15) NOT NULL DEFAULT '0',
  `fieldData` mediumtext,
  PRIMARY KEY (`id`),
  KEY `tickid_index` (`ticketID`),
  KEY `fldid_index` (`fieldID`),
  KEY `repid_index` (`replyID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tickethistory`
--

CREATE TABLE `[[dbprefix]]tickethistory` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `ts` int(30) NOT NULL DEFAULT '0',
  `ticketID` int(11) NOT NULL DEFAULT '0',
  `action` mediumtext,
  `ip` varchar(250) NOT NULL DEFAULT '',
  `staff` int(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `ticket_index` (`ticketID`),
  KEY `staff` (`staff`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tickets`
--

CREATE TABLE `[[dbprefix]]tickets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tickno` varchar(250) NOT NULL DEFAULT '',
  `ts` int(30) NOT NULL DEFAULT '0',
  `lastrevision` int(30) NOT NULL DEFAULT '0',
  `department` int(8) NOT NULL DEFAULT '0',
  `assignedto` varchar(250) NOT NULL DEFAULT '',
  `visitorID` int(8) NOT NULL DEFAULT '0',
  `subject` varchar(250) NOT NULL DEFAULT '',
  `mailBodyFilter` varchar(30) NOT NULL DEFAULT '',
  `comments` mediumtext,
  `priority` varchar(250) NOT NULL DEFAULT '',
  `ticketStatus` varchar(20) NOT NULL DEFAULT '',
  `ipAddresses` varchar(250) NOT NULL DEFAULT '',
  `ticketNotes` mediumtext,
  `isDisputed` enum('yes','no') NOT NULL DEFAULT 'no',
  `disPostPriv` enum('yes','no') NOT NULL DEFAULT 'yes',
  `source` varchar(10) NOT NULL DEFAULT 'standard',
  `spamFlag` enum('yes','no') NOT NULL DEFAULT 'no',
  `lockteam` int(7) NOT NULL DEFAULT '0',
  `lockrelease` int(30) NOT NULL DEFAULT '0',
  `worktime` varchar(50) NOT NULL DEFAULT '00:00:00',
  PRIMARY KEY (`id`),
  KEY `depid_index` (`department`),
  KEY `pry_index` (`priority`),
  KEY `isdis_index` (`isDisputed`),
  KEY `ts_index` (`ts`),
  KEY `vis_index` (`visitorID`),
  KEY `lockteam` (`lockteam`),
  KEY `ticketStatus` (`ticketStatus`),
  KEY `tickno` (`tickno`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]userdepts`
--

CREATE TABLE `[[dbprefix]]userdepts` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `userID` int(5) NOT NULL DEFAULT '0',
  `deptID` int(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `userid_index` (`userID`),
  KEY `depid_index` (`deptID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users`
--

CREATE TABLE `[[dbprefix]]users` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `ts` int(30) NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL DEFAULT '',
  `email` varchar(250) NOT NULL DEFAULT '',
  `email2` mediumtext,
  `accpass` varchar(250) NOT NULL DEFAULT '',
  `signature` mediumtext,
  `notify` enum('yes','no') NOT NULL DEFAULT 'yes',
  `pageAccess` mediumtext,
  `emailSigs` enum('yes','no') NOT NULL DEFAULT 'no',
  `notePadEnable` enum('yes','no') NOT NULL DEFAULT 'yes',
  `delPriv` enum('yes','no') NOT NULL DEFAULT 'no',
  `nameFrom` varchar(250) NOT NULL DEFAULT '',
  `emailFrom` varchar(250) NOT NULL DEFAULT '',
  `assigned` enum('yes','no') NOT NULL DEFAULT 'no',
  `timezone` varchar(50) NOT NULL DEFAULT '0',
  `enabled` enum('yes','no') NOT NULL DEFAULT 'yes',
  `notes` mediumtext,
  `ticketHistory` enum('yes','no') NOT NULL DEFAULT 'yes',
  `enableLog` enum('yes','no') NOT NULL DEFAULT 'yes',
  `mailbox` enum('yes','no') NOT NULL DEFAULT 'yes',
  `mailFolders` int(3) NOT NULL DEFAULT '5',
  `mailDeletion` enum('yes','no') NOT NULL DEFAULT 'yes',
  `mailScreen` enum('yes','no') NOT NULL DEFAULT 'yes',
  `mailCopy` enum('yes','no') NOT NULL DEFAULT 'yes',
  `mailPurge` int(3) NOT NULL DEFAULT '0',
  `addpages` mediumtext,
  `mergeperms` enum('yes','no') NOT NULL DEFAULT 'yes',
  `digest` enum('yes','no') NOT NULL DEFAULT 'yes',
  `profile` enum('yes','no') NOT NULL DEFAULT 'yes',
  `helplink` enum('yes','no') NOT NULL DEFAULT 'no',
  `defDays` int(3) NOT NULL DEFAULT '45',
  `editperms` mediumtext,
  `lock` enum('yes','no') NOT NULL DEFAULT 'yes',
  `close` enum('yes','no') NOT NULL DEFAULT 'yes',
  `admin` enum('yes','no') NOT NULL DEFAULT 'no',
  `timer` enum('yes','no') NOT NULL DEFAULT 'yes',
  `startwork` enum('yes','no') NOT NULL DEFAULT 'yes',
  `workedit` enum('yes','no') NOT NULL DEFAULT 'yes',
  `language` varchar(250) NOT NULL DEFAULT 'english',
  `spamnotify` enum('yes','no') NOT NULL DEFAULT 'yes',
  `savedstaff` mediumtext,
  `staffupnotify` enum('yes','no') NOT NULL DEFAULT 'no',
  `faqHistory` enum('yes','no') NOT NULL DEFAULT 'no',
  `digestops` mediumtext,
  `digestdays` mediumtext,
  `moveperms` enum('yes','no') NOT NULL DEFAULT 'no',
  `cstatus` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `email_index` (`email`),
  KEY `nty_index` (`notify`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]users`
--

INSERT INTO `[[dbprefix]]users` VALUES
(1, [[timestamp]], '[[admin_username]]', '[[admin_email]]', NULL, '[[admin_pass]]', '', 'yes', '', 'no', 'yes', 'yes', '[[admin_username]]', '[[admin_email]]', 'no', 'Europe/London', 'yes', NULL, 'yes', 'yes', 'yes', 5, 'yes', 'yes', 'yes', 0, NULL, 'yes', 'yes', 'yes', 'yes', 45, NULL, 'yes', 'yes', 'yes', 'no', 'yes', 'yes', 'english', 'yes', NULL, 'no', 'no', NULL, NULL, 'no', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]usersaccess`
--

CREATE TABLE `[[dbprefix]]usersaccess` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `page` varchar(100) NOT NULL DEFAULT '',
  `userID` varchar(250) NOT NULL DEFAULT '',
  `type` varchar(32) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `user_index` (`userID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
