<?php

/* CLASS FILE
----------------------------------*/

use Nette\Utils\Json AS UtilsJson;

class jsonHandler {

  public function encode($arr) {
    header('Content-type: application/json');
    try {
      return UtilsJson::encode($arr);
    } catch (Nette\Utils\JsonException $e) {
      return [
        'status' => 'err',
        'txt' => [
          'Json Error',
          $e->getMessage()
        ]
      ];
    }
  }

  public function decode($json) {
    try {
      $result = UtilsJson::decode($json, forceArrays: true);
    } catch (Nette\Utils\JsonException $e) {
      $result = $e->getMessage();
    }
    return $result;
  }

}

?>