<?php

/* GLOBAL TEMPLATE CONSTANTS
   Available in ALL .tpl files
-------------------------------------------------------------------------------------------*/

if (!defined('PARENT') || !defined('MS_PERMISSIONS') || !defined('MSW_LOGGED_IN') || !isset($SETTINGS) || empty($templateParams)) {
  include(PATH . 'control/system/headers/403.php');
}

$templateParams['CHARSET'] = (isset($msg_charset) ? $msg_charset : 'utf-8');
$templateParams['LANG'] = (isset($html_lang) ? $html_lang : 'en');
$templateParams['DIR'] = (isset($lang_dir) ? $lang_dir : 'ltr');
$templateParams['SETTINGS'] = (isset($SETTINGS) && property_exists($SETTINGS, 'id') ? $SETTINGS : new stdclass());
$templateParams['LOGGED_IN'] = MSW_LOGGED_IN;
$templateParams['USER_DATA'] = (MSW_LOGGED_IN == 'yes' && isset($LI_ACC) && property_exists($LI_ACC, 'id') ? $LI_ACC : '');
$templateParams['SYS_BASE_HREF'] = (isset($SETTINGS) && property_exists($SETTINGS, 'scriptpath') ? $SETTINGS->scriptpath . '/content/' . MS_TEMPLATE_SET . '/' : '');
$templateParams['FILE_LOADER'] = (isset($ms_js_css_loader) ? $ms_js_css_loader : '');
$cats = (isset($FAQ) && method_exists($FAQ, 'menu') ? $FAQ->menu(array(
  'account' => (MSW_LOGGED_IN == 'yes' && isset($LI_ACC->id) ? $LI_ACC->id : 0)
)) : '');
$templateParams['CATEGORIES'] = (isset($cats['string']) ? $cats['string'] : '');
$templateParams['CATEGORIES_MENU'] = (isset($cats['array']) ? $cats['array'] : []);
// Private categories only seen on login.
if (MSW_LOGGED_IN == 'yes' && isset($LI_ACC) && property_exists($LI_ACC, 'id')) {
  $pcats = (isset($FAQ) && method_exists($FAQ, 'menu') ? $FAQ->menu(array(
    'account' => $LI_ACC->id,
    'private_cats' => 'yes'
  )) : '');
  $templateParams['PRIVATE_CATEGORIES'] = (isset($pcats['string']) ? $pcats['string'] : '');
  $templateParams['PRIVATE_CATEGORIES_MENU'] = (isset($pcats['array']) ? $pcats['array'] : []);
}

// Custom page loader.
$cs_html = array('', [], []);
$pcs_html = array('', [], []);
if (isset($MSYS) && method_exists($MSYS, 'customPages')) {
  $cs_html = $MSYS->customPages(0, $msadminlangpublic);
}
if (isset($LI_ACC->id) && isset($MSYS) && method_exists($MSYS, 'customPages')) {
  $pcs_html = $MSYS->customPages($LI_ACC->id, $msadminlangpublic);
}
if (MSW_LOGGED_IN == 'yes' && isset($LI_ACC->id)) {
  $templateParams['PRIVATE_PAGES_MENU'] = $pcs_html[1];
}
$templateParams['OTHER_PAGES'] = $cs_html[0];
$templateParams['OTHER_PAGES_MENU'] = $cs_html[2];

$templateParams['T_STATUSES'] = (!empty($ticketStatusSel) ? $ticketStatusSel : []);
$templateParams['T_LEVELS'] = (!empty($ticketLevelSel) ? $ticketLevelSel : []);

// Load off canvas menu?
$templateParams['LOAD_OFF_CANVAS_MENU'] = ((isset($SETTINGS) && property_exists($SETTINGS, 'kbase') == 'yes' && $SETTINGS->kbase == 'yes') || (!empty($cs_html[1]) || !empty($cs_html[2]) || MSW_LOGGED_IN == 'yes') ? 'yes' : 'no');
$templateParams['OFF_CANVAS_PANEL_STATE'] = (isset($SSN) && method_exists($SSN, 'active') && $SSN->active('vis_menu_panel') == 'yes' ? $SSN->get('vis_menu_panel') : (MSW_LOGGED_IN == 'yes' ? 'mn1' : (isset($cats) && $cats ? 'ct1' : (isset($pcats) && $pcats ? 'pct1' : 'pg1'))));
$templateParams['PB_LNG'] = array(
  (isset($mspubliclang3_7) ? $mspubliclang3_7 : []),
  (isset($msadminlang3_1cspages[0]) ? $msadminlang3_1cspages[0] : ''),
  (isset($msg_pkbase7) ? $msg_pkbase7 : '')
);
$templateParams['CSRF_TOKEN'] = (isset($SSN) && method_exists($SSN, 'token') ? $SSN->get('csrf_token') : '');
$templateParams['PB_TXT_LNG'] = array(
  (isset($msg_main2) ? $msg_main2 : ''),
  (isset($msg_header11) ? $msg_header11 : ''),
  (isset($msg_header2) ? $msg_header2 : ''),
  (isset($msg_header15) ? $msg_header15 : ''),
  (isset($msg_header16) ? $msg_header16 : ''),
  (isset($mspubliclang4_2[0]) ? $mspubliclang4_2[0] : '')
);
$templateParams['PLATFORM'] = ($DETECT->isMobile() ? ($DETECT->isTablet() ? 'tablet' : 'mobile') : 'pc');
$templateParams['TABLE_HEAD_DECORATION'] = TABLE_HEAD_DECORATION;
$templateParams['SUBLINK_SEPARATOR'] = SUBLINK_SEPARATOR;

?>