<?php

/* SECURE TOKENS
------------------------------------*/

if (!defined('PARENT')) {
  echo '403';
  exit;
}

/* SECURITY TOKEN VAR
---------------------------------------*/

if (isset($SSN) && method_exists($SSN, 'active')) {

  if ($SSN->active('csrf_token') == 'no') {
    $SSN->set(array('csrf_token' => $SSN->token()));
  }

  // For POST ops
  define('CSRF_POST_VAL', (
    isset($_SERVER['HTTP_X_CSRF_TOKEN']) && $SSN->active('csrf_token') == 'yes' && 
    $_SERVER['HTTP_X_CSRF_TOKEN'] == $SSN->get('csrf_token') ? 'yes' : 'no')
  );

  // For GET ops
  define('CSRF_GET_VAL', (
    isset($_GET['csrf']) && $SSN->active('csrf_token') == 'yes' &&
    $_GET['csrf'] == $SSN->get('csrf_token') ? 'yes' : 'no')
  );

} else {
  
  define('CSRF_POST_VAL', 'void');
  define('CSRF_GET_VAL', 'void');

}

?>