
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `mautic604`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assets`
--

CREATE TABLE `[[dbprefix]]assets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned DEFAULT NULL,
  `is_published` tinyint(1) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `modified_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_out` datetime DEFAULT NULL,
  `checked_out_by` int(11) DEFAULT NULL,
  `checked_out_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `alias` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `storage_location` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remote_path` longtext COLLATE utf8mb4_unicode_ci,
  `original_file_name` longtext COLLATE utf8mb4_unicode_ci,
  `lang` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `download_count` int(11) NOT NULL,
  `unique_download_count` int(11) NOT NULL,
  `revision` int(11) NOT NULL,
  `extension` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mime` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `disallow` tinyint(1) DEFAULT NULL,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`id`),
  KEY `IDX_62FCE03812469DE2` (`category_id`),
  KEY `[[dbprefix]]asset_alias_search` (`alias`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]asset_downloads`
--

CREATE TABLE `[[dbprefix]]asset_downloads` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned DEFAULT NULL,
  `ip_id` int(10) unsigned DEFAULT NULL,
  `lead_id` bigint(20) unsigned DEFAULT NULL,
  `email_id` int(10) unsigned DEFAULT NULL,
  `date_download` datetime NOT NULL,
  `code` int(11) NOT NULL,
  `referer` longtext COLLATE utf8mb4_unicode_ci,
  `tracking_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `source` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `source_id` int(11) DEFAULT NULL,
  `utm_campaign` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_content` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_medium` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_source` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_term` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_EEC9FEBC5DA1941` (`asset_id`),
  KEY `IDX_EEC9FEBCA03F5E9F` (`ip_id`),
  KEY `IDX_EEC9FEBC55458D` (`lead_id`),
  KEY `IDX_EEC9FEBCA832C1C9` (`email_id`),
  KEY `[[dbprefix]]download_tracking_search` (`tracking_id`),
  KEY `[[dbprefix]]download_source_search` (`source`,`source_id`),
  KEY `[[dbprefix]]asset_date_download` (`date_download`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]audit_log`
--

CREATE TABLE `[[dbprefix]]audit_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `user_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bundle` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `object` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `object_id` bigint(20) unsigned NOT NULL,
  `action` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `details` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `date_added` datetime NOT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]object_search` (`object`,`object_id`),
  KEY `[[dbprefix]]timeline_search` (`bundle`,`object`,`action`,`object_id`),
  KEY `[[dbprefix]]date_added_index` (`date_added`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]bundle_grapesjsbuilder`
--

CREATE TABLE `[[dbprefix]]bundle_grapesjsbuilder` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `email_id` int(10) unsigned DEFAULT NULL,
  `custom_mjml` longtext COLLATE utf8mb4_unicode_ci,
  `draft_custom_mjml` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `IDX_776E26F6A832C1C9` (`email_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_items`
--

CREATE TABLE `[[dbprefix]]cache_items` (
  `item_id` varbinary(255) NOT NULL,
  `item_data` longblob NOT NULL,
  `item_lifetime` int(10) unsigned DEFAULT NULL,
  `item_time` int(10) unsigned NOT NULL,
  PRIMARY KEY (`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]campaigns`
--

CREATE TABLE `[[dbprefix]]campaigns` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned DEFAULT NULL,
  `is_published` tinyint(1) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `modified_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_out` datetime DEFAULT NULL,
  `checked_out_by` int(11) DEFAULT NULL,
  `checked_out_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `canvas_settings` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `allow_restart` tinyint(1) NOT NULL,
  `deleted` datetime DEFAULT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `uuid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`id`),
  KEY `IDX_A3905EEB12469DE2` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]campaign_events`
--

CREATE TABLE `[[dbprefix]]campaign_events` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `campaign_id` int(10) unsigned NOT NULL,
  `parent_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `event_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `event_order` int(11) NOT NULL,
  `properties` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  `deleted` datetime DEFAULT NULL,
  `trigger_date` datetime DEFAULT NULL,
  `trigger_interval` int(11) DEFAULT NULL,
  `trigger_interval_unit` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `trigger_hour` time DEFAULT NULL,
  `trigger_restricted_start_hour` time DEFAULT NULL,
  `trigger_restricted_stop_hour` time DEFAULT NULL,
  `trigger_restricted_dow` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `trigger_window` int(11) DEFAULT NULL,
  `trigger_mode` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `decision_path` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `temp_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `channel` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `channel_id` int(11) DEFAULT NULL,
  `failed_count` int(11) NOT NULL,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`id`),
  KEY `IDX_C6449CD4F639F774` (`campaign_id`),
  KEY `IDX_C6449CD4727ACA70` (`parent_id`),
  KEY `[[dbprefix]]campaign_event_search` (`type`,`event_type`),
  KEY `[[dbprefix]]campaign_event_type` (`event_type`),
  KEY `[[dbprefix]]campaign_event_channel` (`channel`,`channel_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]campaign_form_xref`
--

CREATE TABLE `[[dbprefix]]campaign_form_xref` (
  `campaign_id` int(10) unsigned NOT NULL,
  `form_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`campaign_id`,`form_id`),
  KEY `IDX_2D2EBC295FF69B7D` (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]campaign_leadlist_xref`
--

CREATE TABLE `[[dbprefix]]campaign_leadlist_xref` (
  `campaign_id` int(10) unsigned NOT NULL,
  `leadlist_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`campaign_id`,`leadlist_id`),
  KEY `IDX_454FC8DFB9FC8874` (`leadlist_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]campaign_leads`
--

CREATE TABLE `[[dbprefix]]campaign_leads` (
  `campaign_id` int(10) unsigned NOT NULL,
  `lead_id` bigint(20) unsigned NOT NULL,
  `date_added` datetime NOT NULL,
  `manually_removed` tinyint(1) NOT NULL,
  `manually_added` tinyint(1) NOT NULL,
  `date_last_exited` datetime DEFAULT NULL,
  `rotation` int(11) NOT NULL,
  PRIMARY KEY (`campaign_id`,`lead_id`),
  KEY `IDX_6B11599A55458D` (`lead_id`),
  KEY `[[dbprefix]]campaign_leads_date_added` (`date_added`),
  KEY `[[dbprefix]]campaign_leads_date_exited` (`date_last_exited`),
  KEY `[[dbprefix]]campaign_leads` (`campaign_id`,`manually_removed`,`lead_id`,`rotation`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]campaign_lead_event_failed_log`
--

CREATE TABLE `[[dbprefix]]campaign_lead_event_failed_log` (
  `log_id` bigint(20) unsigned NOT NULL,
  `date_added` datetime NOT NULL,
  `reason` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`log_id`),
  KEY `[[dbprefix]]campaign_event_failed_date` (`date_added`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]campaign_lead_event_log`
--

CREATE TABLE `[[dbprefix]]campaign_lead_event_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_id` int(10) unsigned NOT NULL,
  `lead_id` bigint(20) unsigned NOT NULL,
  `campaign_id` int(10) unsigned DEFAULT NULL,
  `ip_id` int(10) unsigned DEFAULT NULL,
  `rotation` int(11) NOT NULL,
  `date_triggered` datetime DEFAULT NULL,
  `is_scheduled` tinyint(1) NOT NULL,
  `trigger_date` datetime DEFAULT NULL,
  `system_triggered` tinyint(1) NOT NULL,
  `metadata` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `channel` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `channel_id` int(11) DEFAULT NULL,
  `non_action_path_taken` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]campaign_rotation` (`event_id`,`lead_id`,`rotation`),
  KEY `IDX_7DD906E671F7E88B` (`event_id`),
  KEY `IDX_7DD906E655458D` (`lead_id`),
  KEY `IDX_7DD906E6F639F774` (`campaign_id`),
  KEY `IDX_7DD906E6A03F5E9F` (`ip_id`),
  KEY `[[dbprefix]]campaign_event_upcoming_search` (`is_scheduled`,`lead_id`),
  KEY `[[dbprefix]]campaign_event_schedule_counts` (`campaign_id`,`is_scheduled`,`trigger_date`),
  KEY `[[dbprefix]]campaign_date_triggered` (`date_triggered`),
  KEY `[[dbprefix]]campaign_leads` (`lead_id`,`campaign_id`,`rotation`),
  KEY `[[dbprefix]]campaign_log_channel` (`channel`,`channel_id`,`lead_id`),
  KEY `[[dbprefix]]campaign_actions` (`campaign_id`,`event_id`,`date_triggered`),
  KEY `[[dbprefix]]campaign_stats` (`campaign_id`,`date_triggered`,`event_id`,`non_action_path_taken`),
  KEY `[[dbprefix]]campaign_trigger_date_order` (`trigger_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]campaign_summary`
--

CREATE TABLE `[[dbprefix]]campaign_summary` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `campaign_id` int(10) unsigned DEFAULT NULL,
  `event_id` int(10) unsigned NOT NULL,
  `date_triggered` datetime DEFAULT NULL COMMENT '(DC2Type:datetime_immutable)',
  `scheduled_count` int(11) NOT NULL,
  `triggered_count` int(11) NOT NULL,
  `non_action_path_taken_count` int(11) NOT NULL,
  `failed_count` int(11) NOT NULL,
  `log_counts_processed` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]campaign_event_date_triggered` (`campaign_id`,`event_id`,`date_triggered`),
  KEY `IDX_D90A1BEBF639F774` (`campaign_id`),
  KEY `IDX_D90A1BEB71F7E88B` (`event_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]categories`
--

CREATE TABLE `[[dbprefix]]categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `is_published` tinyint(1) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `modified_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_out` datetime DEFAULT NULL,
  `checked_out_by` int(11) DEFAULT NULL,
  `checked_out_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `alias` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(7) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bundle` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]category_alias_search` (`alias`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]channel_url_trackables`
--

CREATE TABLE `[[dbprefix]]channel_url_trackables` (
  `channel_id` int(11) NOT NULL,
  `redirect_id` bigint(20) unsigned NOT NULL,
  `channel` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hits` int(11) NOT NULL,
  `unique_hits` int(11) NOT NULL,
  PRIMARY KEY (`redirect_id`,`channel_id`),
  KEY `[[dbprefix]]channel_url_trackable_search` (`channel`,`channel_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]companies`
--

CREATE TABLE `[[dbprefix]]companies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `owner_id` int(10) unsigned DEFAULT NULL,
  `is_published` tinyint(1) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `modified_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_out` datetime DEFAULT NULL,
  `checked_out_by` int(11) DEFAULT NULL,
  `checked_out_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `social_cache` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `score` int(11) DEFAULT NULL,
  `companyemail` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `companyaddress1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `companyaddress2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `companyphone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `companycity` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `companystate` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `companyzipcode` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `companycountry` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `companyname` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `companywebsite` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `companyindustry` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `companydescription` longtext COLLATE utf8mb4_unicode_ci,
  `companynumber_of_employees` double DEFAULT NULL,
  `companyfax` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `companyannual_revenue` double DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_C2A780A17E3C61F9` (`owner_id`),
  KEY `companynumber_of_employees_search` (`companynumber_of_employees`),
  KEY `companyfax_search` (`companyfax`),
  KEY `companyannual_revenue_search` (`companyannual_revenue`),
  KEY `company_filter` (`companyname`,`companyemail`),
  KEY `company_match` (`companyname`,`companycity`,`companycountry`,`companystate`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]companies_leads`
--

CREATE TABLE `[[dbprefix]]companies_leads` (
  `company_id` int(11) NOT NULL,
  `lead_id` bigint(20) unsigned NOT NULL,
  `date_added` datetime NOT NULL,
  `is_primary` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`company_id`,`lead_id`),
  KEY `IDX_BC99B88555458D` (`lead_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contact_export_scheduler`
--

CREATE TABLE `[[dbprefix]]contact_export_scheduler` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `scheduled_datetime` datetime NOT NULL COMMENT '(DC2Type:datetime_immutable)',
  `data` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  PRIMARY KEY (`id`),
  KEY `IDX_E2B2EF02A76ED395` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contact_merge_records`
--

CREATE TABLE `[[dbprefix]]contact_merge_records` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `contact_id` bigint(20) unsigned NOT NULL,
  `date_added` datetime NOT NULL,
  `merged_id` int(11) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_A28DB68BE7A1254A` (`contact_id`),
  KEY `[[dbprefix]]contact_merge_date_added` (`date_added`),
  KEY `[[dbprefix]]contact_merge_ids` (`merged_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]dynamic_content`
--

CREATE TABLE `[[dbprefix]]dynamic_content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned DEFAULT NULL,
  `translation_parent_id` int(10) unsigned DEFAULT NULL,
  `variant_parent_id` int(10) unsigned DEFAULT NULL,
  `is_published` tinyint(1) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `modified_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_out` datetime DEFAULT NULL,
  `checked_out_by` int(11) DEFAULT NULL,
  `checked_out_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `sent_count` int(11) NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `utm_tags` json DEFAULT NULL,
  `lang` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `variant_settings` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `variant_start_date` datetime DEFAULT NULL,
  `filters` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `is_campaign_based` tinyint(1) NOT NULL DEFAULT '1',
  `slot_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`id`),
  KEY `IDX_68396C8112469DE2` (`category_id`),
  KEY `IDX_68396C819091A2FB` (`translation_parent_id`),
  KEY `IDX_68396C8191861123` (`variant_parent_id`),
  KEY `[[dbprefix]]is_campaign_based_index` (`is_campaign_based`),
  KEY `[[dbprefix]]slot_name_index` (`slot_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]dynamic_content_lead_data`
--

CREATE TABLE `[[dbprefix]]dynamic_content_lead_data` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `lead_id` bigint(20) unsigned NOT NULL,
  `dynamic_content_id` int(10) unsigned DEFAULT NULL,
  `date_added` datetime DEFAULT NULL,
  `slot` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_90D24DFF55458D` (`lead_id`),
  KEY `IDX_90D24DFFD9D0CD7` (`dynamic_content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]dynamic_content_stats`
--

CREATE TABLE `[[dbprefix]]dynamic_content_stats` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `dynamic_content_id` int(10) unsigned DEFAULT NULL,
  `lead_id` bigint(20) unsigned DEFAULT NULL,
  `date_sent` datetime NOT NULL,
  `source` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `source_id` int(11) DEFAULT NULL,
  `tokens` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `sent_count` int(11) DEFAULT NULL,
  `last_sent` datetime DEFAULT NULL,
  `sent_details` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  PRIMARY KEY (`id`),
  KEY `IDX_9FB6FBB4D9D0CD7` (`dynamic_content_id`),
  KEY `IDX_9FB6FBB455458D` (`lead_id`),
  KEY `[[dbprefix]]stat_dynamic_content_search` (`dynamic_content_id`,`lead_id`),
  KEY `[[dbprefix]]stat_dynamic_content_source_search` (`source`,`source_id`),
  KEY `[[dbprefix]]stat_dynamic_content_date_sent` (`date_sent`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]emails`
--

CREATE TABLE `[[dbprefix]]emails` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned DEFAULT NULL,
  `translation_parent_id` int(10) unsigned DEFAULT NULL,
  `variant_parent_id` int(10) unsigned DEFAULT NULL,
  `unsubscribeform_id` int(10) unsigned DEFAULT NULL,
  `preference_center_id` int(10) unsigned DEFAULT NULL,
  `is_published` tinyint(1) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `modified_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_out` datetime DEFAULT NULL,
  `checked_out_by` int(11) DEFAULT NULL,
  `checked_out_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `subject` longtext COLLATE utf8mb4_unicode_ci,
  `preheader_text` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `from_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `from_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reply_to_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bcc_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `use_owner_as_mailer` tinyint(1) DEFAULT NULL,
  `template` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `utm_tags` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `plain_text` longtext COLLATE utf8mb4_unicode_ci,
  `custom_html` longtext COLLATE utf8mb4_unicode_ci,
  `email_type` longtext COLLATE utf8mb4_unicode_ci,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `read_count` int(11) NOT NULL,
  `sent_count` int(11) NOT NULL,
  `variant_sent_count` int(11) NOT NULL,
  `variant_read_count` int(11) NOT NULL,
  `revision` int(11) NOT NULL,
  `lang` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `variant_settings` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `variant_start_date` datetime DEFAULT NULL,
  `dynamic_content` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `headers` json NOT NULL,
  `public_preview` tinyint(1) DEFAULT NULL,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`id`),
  KEY `IDX_57AC75E412469DE2` (`category_id`),
  KEY `IDX_57AC75E49091A2FB` (`translation_parent_id`),
  KEY `IDX_57AC75E491861123` (`variant_parent_id`),
  KEY `IDX_57AC75E42DC494F6` (`unsubscribeform_id`),
  KEY `IDX_57AC75E4834F9C5B` (`preference_center_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]emails_draft`
--

CREATE TABLE `[[dbprefix]]emails_draft` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `email_id` int(10) unsigned NOT NULL,
  `html` longtext COLLATE utf8mb4_unicode_ci,
  `template` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `public_preview` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_1EEDD2ABA832C1C9` (`email_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]email_assets_xref`
--

CREATE TABLE `[[dbprefix]]email_assets_xref` (
  `email_id` int(10) unsigned NOT NULL,
  `asset_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`email_id`,`asset_id`),
  KEY `IDX_1B35A8685DA1941` (`asset_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]email_copies`
--

CREATE TABLE `[[dbprefix]]email_copies` (
  `id` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_created` datetime NOT NULL,
  `body` longtext COLLATE utf8mb4_unicode_ci,
  `body_text` longtext COLLATE utf8mb4_unicode_ci,
  `subject` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]email_list_excluded`
--

CREATE TABLE `[[dbprefix]]email_list_excluded` (
  `email_id` int(10) unsigned NOT NULL,
  `leadlist_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`email_id`,`leadlist_id`),
  KEY `IDX_5AFC0DA3B9FC8874` (`leadlist_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]email_list_xref`
--

CREATE TABLE `[[dbprefix]]email_list_xref` (
  `email_id` int(10) unsigned NOT NULL,
  `leadlist_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`email_id`,`leadlist_id`),
  KEY `IDX_66A4422FB9FC8874` (`leadlist_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]email_stats`
--

CREATE TABLE `[[dbprefix]]email_stats` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `email_id` int(10) unsigned DEFAULT NULL,
  `lead_id` bigint(20) unsigned DEFAULT NULL,
  `list_id` int(10) unsigned DEFAULT NULL,
  `ip_id` int(10) unsigned DEFAULT NULL,
  `copy_id` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_address` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_sent` datetime NOT NULL,
  `is_read` tinyint(1) NOT NULL,
  `is_failed` tinyint(1) NOT NULL,
  `viewed_in_browser` tinyint(1) NOT NULL,
  `date_read` datetime DEFAULT NULL,
  `tracking_hash` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `retry_count` int(11) DEFAULT NULL,
  `source` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `source_id` int(11) DEFAULT NULL,
  `tokens` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `open_count` int(11) DEFAULT NULL,
  `last_opened` datetime DEFAULT NULL,
  `open_details` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `generated_sent_date` date GENERATED ALWAYS AS (concat(year(`date_sent`),'-',lpad(month(`date_sent`),2,'0'),'-',lpad(dayofmonth(`date_sent`),2,'0'))) VIRTUAL COMMENT '(DC2Type:generated)',
  PRIMARY KEY (`id`),
  KEY `IDX_8304FCC1A832C1C9` (`email_id`),
  KEY `IDX_8304FCC155458D` (`lead_id`),
  KEY `IDX_8304FCC13DAE168B` (`list_id`),
  KEY `IDX_8304FCC1A03F5E9F` (`ip_id`),
  KEY `IDX_8304FCC1A8752772` (`copy_id`),
  KEY `[[dbprefix]]stat_email_search` (`email_id`,`lead_id`),
  KEY `[[dbprefix]]stat_email_search2` (`lead_id`,`email_id`),
  KEY `[[dbprefix]]stat_email_failed_search` (`is_failed`),
  KEY `[[dbprefix]]is_read_date_sent` (`is_read`,`date_sent`),
  KEY `[[dbprefix]]stat_email_hash_search` (`tracking_hash`),
  KEY `[[dbprefix]]stat_email_source_search` (`source`,`source_id`),
  KEY `[[dbprefix]]email_date_sent` (`date_sent`),
  KEY `[[dbprefix]]email_date_read_lead` (`date_read`,`lead_id`),
  KEY `[[dbprefix]]stat_email_lead_id_date_sent` (`lead_id`,`date_sent`),
  KEY `[[dbprefix]]stat_email_email_id_is_read` (`email_id`,`is_read`),
  KEY `[[dbprefix]]generated_sent_date_email_id` (`generated_sent_date`,`email_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]email_stats_devices`
--

CREATE TABLE `[[dbprefix]]email_stats_devices` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `device_id` bigint(20) unsigned DEFAULT NULL,
  `stat_id` bigint(20) unsigned DEFAULT NULL,
  `ip_id` int(10) unsigned DEFAULT NULL,
  `date_opened` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_1D4A30B794A4C7D4` (`device_id`),
  KEY `IDX_1D4A30B79502F0B` (`stat_id`),
  KEY `IDX_1D4A30B7A03F5E9F` (`ip_id`),
  KEY `[[dbprefix]]date_opened_search` (`date_opened`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]email_stat_replies`
--

CREATE TABLE `[[dbprefix]]email_stat_replies` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `stat_id` bigint(20) unsigned NOT NULL,
  `date_replied` datetime NOT NULL,
  `message_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_C8FE27B9502F0B` (`stat_id`),
  KEY `[[dbprefix]]email_replies` (`stat_id`,`message_id`),
  KEY `[[dbprefix]]date_email_replied` (`date_replied`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]focus`
--

CREATE TABLE `[[dbprefix]]focus` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned DEFAULT NULL,
  `is_published` tinyint(1) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `modified_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_out` datetime DEFAULT NULL,
  `checked_out_by` int(11) DEFAULT NULL,
  `checked_out_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `focus_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `style` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `website` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `properties` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `utm_tags` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `form_id` int(11) DEFAULT NULL,
  `cache` longtext COLLATE utf8mb4_unicode_ci,
  `html_mode` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `editor` longtext COLLATE utf8mb4_unicode_ci,
  `html` longtext COLLATE utf8mb4_unicode_ci,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`id`),
  KEY `IDX_4EF887BC12469DE2` (`category_id`),
  KEY `[[dbprefix]]focus_type` (`focus_type`),
  KEY `[[dbprefix]]focus_style` (`style`),
  KEY `[[dbprefix]]focus_form` (`form_id`),
  KEY `[[dbprefix]]focus_name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]focus_stats`
--

CREATE TABLE `[[dbprefix]]focus_stats` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `focus_id` int(10) unsigned NOT NULL,
  `lead_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type_id` int(11) DEFAULT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_8A67AA3851804B42` (`focus_id`),
  KEY `IDX_8A67AA3855458D` (`lead_id`),
  KEY `[[dbprefix]]focus_type` (`type`),
  KEY `[[dbprefix]]focus_type_id` (`type`,`type_id`),
  KEY `[[dbprefix]]focus_date_added` (`date_added`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forms`
--

CREATE TABLE `[[dbprefix]]forms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned DEFAULT NULL,
  `is_published` tinyint(1) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `modified_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_out` datetime DEFAULT NULL,
  `checked_out_by` int(11) DEFAULT NULL,
  `checked_out_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `alias` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `form_attr` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cached_html` longtext COLLATE utf8mb4_unicode_ci,
  `post_action` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_action_property` longtext COLLATE utf8mb4_unicode_ci,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `template` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `in_kiosk_mode` tinyint(1) DEFAULT NULL,
  `render_style` tinyint(1) DEFAULT NULL,
  `form_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `no_index` tinyint(1) DEFAULT NULL,
  `progressive_profiling_limit` int(11) DEFAULT NULL,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`id`),
  KEY `IDX_D107D6A212469DE2` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]form_actions`
--

CREATE TABLE `[[dbprefix]]form_actions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_order` int(11) NOT NULL,
  `properties` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  `uuid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`id`),
  KEY `IDX_930AB96F5FF69B7D` (`form_id`),
  KEY `[[dbprefix]]form_action_type_search` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]form_fields`
--

CREATE TABLE `[[dbprefix]]form_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int(10) unsigned NOT NULL,
  `label` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `show_label` tinyint(1) DEFAULT NULL,
  `alias` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_custom` tinyint(1) NOT NULL,
  `custom_parameters` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `default_value` longtext COLLATE utf8mb4_unicode_ci,
  `is_required` tinyint(1) NOT NULL,
  `validation_message` longtext COLLATE utf8mb4_unicode_ci,
  `help_message` longtext COLLATE utf8mb4_unicode_ci,
  `field_order` int(11) DEFAULT NULL,
  `properties` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `validation` json DEFAULT NULL,
  `parent_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `conditions` json DEFAULT NULL,
  `label_attr` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `input_attr` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `container_attr` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lead_field` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `save_result` tinyint(1) DEFAULT NULL,
  `is_auto_fill` tinyint(1) DEFAULT NULL,
  `is_read_only` tinyint(1) NOT NULL DEFAULT '0',
  `show_when_value_exists` tinyint(1) DEFAULT NULL,
  `show_after_x_submissions` int(11) DEFAULT NULL,
  `always_display` tinyint(1) DEFAULT NULL,
  `mapped_object` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mapped_field` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`id`),
  KEY `IDX_3505EDC25FF69B7D` (`form_id`),
  KEY `[[dbprefix]]form_field_type_search` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]form_submissions`
--

CREATE TABLE `[[dbprefix]]form_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int(10) unsigned NOT NULL,
  `ip_id` int(10) unsigned DEFAULT NULL,
  `lead_id` bigint(20) unsigned DEFAULT NULL,
  `page_id` int(10) unsigned DEFAULT NULL,
  `tracking_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_submitted` datetime NOT NULL,
  `referer` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_779218425FF69B7D` (`form_id`),
  KEY `IDX_77921842A03F5E9F` (`ip_id`),
  KEY `IDX_7792184255458D` (`lead_id`),
  KEY `IDX_77921842C4663E4` (`page_id`),
  KEY `[[dbprefix]]form_submission_tracking_search` (`tracking_id`),
  KEY `[[dbprefix]]form_date_submitted` (`date_submitted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]imports`
--

CREATE TABLE `[[dbprefix]]imports` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `is_published` tinyint(1) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `modified_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_out` datetime DEFAULT NULL,
  `checked_out_by` int(11) DEFAULT NULL,
  `checked_out_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dir` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `original_file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `line_count` int(11) NOT NULL,
  `inserted_count` int(11) NOT NULL,
  `updated_count` int(11) NOT NULL,
  `ignored_count` int(11) NOT NULL,
  `priority` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `date_started` datetime DEFAULT NULL,
  `date_ended` datetime DEFAULT NULL,
  `object` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `properties` json DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]import_object` (`object`),
  KEY `[[dbprefix]]import_status` (`status`),
  KEY `[[dbprefix]]import_priority` (`priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]integration_entity`
--

CREATE TABLE `[[dbprefix]]integration_entity` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date_added` datetime NOT NULL,
  `integration` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `integration_entity` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `integration_entity_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `internal_entity` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `internal_entity_id` int(11) DEFAULT NULL,
  `last_sync_date` datetime DEFAULT NULL,
  `internal` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]integration_external_entity` (`integration`,`integration_entity`,`integration_entity_id`),
  KEY `[[dbprefix]]integration_internal_entity` (`integration`,`internal_entity`,`internal_entity_id`),
  KEY `[[dbprefix]]integration_entity_match` (`integration`,`internal_entity`,`integration_entity`),
  KEY `[[dbprefix]]integration_last_sync_date` (`integration`,`last_sync_date`),
  KEY `[[dbprefix]]internal_integration_entity` (`internal_entity_id`,`integration_entity_id`,`internal_entity`,`integration_entity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ip_addresses`
--

CREATE TABLE `[[dbprefix]]ip_addresses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ip_details` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]ip_search` (`ip_address`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]leads`
--

CREATE TABLE `[[dbprefix]]leads` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `owner_id` int(10) unsigned DEFAULT NULL,
  `stage_id` int(10) unsigned DEFAULT NULL,
  `is_published` tinyint(1) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `modified_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_out` datetime DEFAULT NULL,
  `checked_out_by` int(11) DEFAULT NULL,
  `checked_out_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `points` int(11) NOT NULL,
  `last_active` datetime DEFAULT NULL,
  `internal` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `social_cache` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `date_identified` datetime DEFAULT NULL,
  `preferred_profile_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `firstname` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lastname` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zipcode` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `timezone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fax` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `preferred_locale` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attribution_date` datetime DEFAULT NULL,
  `attribution` double DEFAULT NULL,
  `website` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `facebook` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `foursquare` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `instagram` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `linkedin` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `skype` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twitter` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `generated_email_domain` varchar(255)[[collation]] GENERATED ALWAYS AS (substr(`email`,(locate('@',`email`) + 1))) VIRTUAL COMMENT '(DC2Type:generated)',
  PRIMARY KEY (`id`),
  KEY `IDX_3BA888077E3C61F9` (`owner_id`),
  KEY `IDX_3BA888072298D193` (`stage_id`),
  KEY `[[dbprefix]]lead_date_added` (`date_added`),
  KEY `[[dbprefix]]lead_date_modified` (`date_modified`),
  KEY `[[dbprefix]]date_identified` (`date_identified`),
  KEY `fax_search` (`fax`),
  KEY `preferred_locale_search` (`preferred_locale`),
  KEY `attribution_date_search` (`attribution_date`),
  KEY `attribution_search` (`attribution`),
  KEY `website_search` (`website`),
  KEY `facebook_search` (`facebook`),
  KEY `foursquare_search` (`foursquare`),
  KEY `instagram_search` (`instagram`),
  KEY `linkedin_search` (`linkedin`),
  KEY `skype_search` (`skype`),
  KEY `twitter_search` (`twitter`),
  KEY `contact_attribution` (`attribution`,`attribution_date`),
  KEY `date_added_country_index` (`date_added`,`country`),
  KEY `[[dbprefix]]generated_email_domain` (`generated_email_domain`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lead_categories`
--

CREATE TABLE `[[dbprefix]]lead_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned NOT NULL,
  `lead_id` bigint(20) unsigned NOT NULL,
  `date_added` datetime NOT NULL,
  `manually_removed` tinyint(1) NOT NULL,
  `manually_added` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_5AE8EFC712469DE2` (`category_id`),
  KEY `IDX_5AE8EFC755458D` (`lead_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lead_companies_change_log`
--

CREATE TABLE `[[dbprefix]]lead_companies_change_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `lead_id` bigint(20) unsigned NOT NULL,
  `type` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `event_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_id` int(11) NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_61BDA7FF55458D` (`lead_id`),
  KEY `[[dbprefix]]company_date_added` (`date_added`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lead_devices`
--

CREATE TABLE `[[dbprefix]]lead_devices` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `lead_id` bigint(20) unsigned NOT NULL,
  `date_added` datetime NOT NULL,
  `client_info` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `device` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `device_os_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `device_os_shortname` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `device_os_version` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `device_os_platform` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `device_brand` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `device_model` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tracking_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_EFE73A4F7D05ABBE` (`tracking_id`),
  KEY `IDX_EFE73A4F55458D` (`lead_id`),
  KEY `[[dbprefix]]date_added_search` (`date_added`),
  KEY `[[dbprefix]]device_search` (`device`),
  KEY `[[dbprefix]]device_os_name_search` (`device_os_name`),
  KEY `[[dbprefix]]device_os_shortname_search` (`device_os_shortname`),
  KEY `[[dbprefix]]device_os_version_search` (`device_os_version`),
  KEY `[[dbprefix]]device_os_platform_search` (`device_os_platform`),
  KEY `[[dbprefix]]device_brand_search` (`device_brand`),
  KEY `[[dbprefix]]device_model_search` (`device_model`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lead_donotcontact`
--

CREATE TABLE `[[dbprefix]]lead_donotcontact` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `lead_id` bigint(20) unsigned DEFAULT NULL,
  `date_added` datetime NOT NULL,
  `reason` smallint(6) NOT NULL,
  `channel` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `channel_id` int(11) DEFAULT NULL,
  `comments` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `IDX_A0D8F40D55458D` (`lead_id`),
  KEY `[[dbprefix]]leadid_reason_channel` (`lead_id`,`channel`,`reason`),
  KEY `[[dbprefix]]dnc_reason_search` (`reason`),
  KEY `[[dbprefix]]dnc_date_added` (`date_added`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lead_event_log`
--

CREATE TABLE `[[dbprefix]]lead_event_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `lead_id` bigint(20) unsigned DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `user_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bundle` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `object` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `object_id` int(11) DEFAULT NULL,
  `date_added` datetime NOT NULL,
  `properties` json DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]lead_id_index` (`lead_id`),
  KEY `[[dbprefix]]lead_object_index` (`object`,`object_id`),
  KEY `[[dbprefix]]lead_timeline_index` (`bundle`,`object`,`action`,`object_id`),
  KEY `[[dbprefix]]IDX_SEARCH` (`bundle`,`object`,`action`,`object_id`,`date_added`),
  KEY `[[dbprefix]]lead_timeline_action_index` (`action`),
  KEY `[[dbprefix]]lead_date_added_index` (`date_added`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lead_fields`
--

CREATE TABLE `[[dbprefix]]lead_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `is_published` tinyint(1) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `modified_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_out` datetime DEFAULT NULL,
  `checked_out_by` int(11) DEFAULT NULL,
  `checked_out_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_group` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_required` tinyint(1) NOT NULL,
  `is_fixed` tinyint(1) NOT NULL,
  `is_visible` tinyint(1) NOT NULL,
  `is_short_visible` tinyint(1) NOT NULL DEFAULT '0',
  `is_listable` tinyint(1) NOT NULL,
  `is_publicly_updatable` tinyint(1) NOT NULL,
  `is_unique_identifer` tinyint(1) DEFAULT NULL,
  `is_index` tinyint(1) NOT NULL DEFAULT '0',
  `char_length_limit` int(11) DEFAULT NULL,
  `field_order` int(11) DEFAULT NULL,
  `object` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `properties` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `column_is_not_created` tinyint(1) NOT NULL DEFAULT '0',
  `original_is_published_value` tinyint(1) NOT NULL DEFAULT '0',
  `uuid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]idx_object_field_order_is_published` (`object`,`field_order`,`is_published`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=44 ;

--
-- Dumping data for table `[[dbprefix]]lead_fields`
--

INSERT INTO `[[dbprefix]]lead_fields` VALUES
(1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Title', 'title', 'lookup', 'core', NULL, 0, 1, 1, 0, 1, 0, 0, 0, 64, 1, 'lead', 'a:1:{s:4:"list";a:3:{i:0;s:2:"Mr";i:1;s:3:"Mrs";i:2;s:4:"Miss";}}', 0, 0, '52be439b-2bbd-46c9-8fe2-9d7a33935b54'),
(2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'First Name', 'firstname', 'text', 'core', NULL, 0, 1, 1, 1, 1, 0, 0, 0, 64, 2, 'lead', 'a:0:{}', 0, 0, 'a56f983e-ada0-4bed-b2dc-7d4652e6f94f'),
(3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Last Name', 'lastname', 'text', 'core', NULL, 0, 1, 1, 1, 1, 0, 0, 0, 64, 3, 'lead', 'a:0:{}', 0, 0, '328d3b7f-e9c8-4acc-b7eb-6e9acce3c09b'),
(4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Primary company', 'company', 'text', 'core', NULL, 0, 1, 1, 0, 1, 0, 0, 0, 64, 4, 'lead', 'a:0:{}', 0, 0, '4ee039f4-472c-46fd-8148-7dc0c79d674b'),
(5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Position', 'position', 'text', 'core', NULL, 0, 1, 1, 0, 1, 0, 0, 0, 64, 5, 'lead', 'a:0:{}', 0, 0, 'd457f56e-22a4-432b-9ba0-0144f6a2c20a'),
(6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Email', 'email', 'email', 'core', NULL, 0, 1, 1, 1, 1, 0, 1, 1, 64, 6, 'lead', 'a:0:{}', 0, 0, '4286e245-83a8-4d8b-9a40-21c5961c8118'),
(7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Mobile', 'mobile', 'tel', 'core', NULL, 0, 1, 1, 0, 1, 0, 0, 0, 64, 7, 'lead', 'a:0:{}', 0, 0, '3f80c048-2a93-42ae-afd8-ad6240d69bc4'),
(8, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Phone', 'phone', 'tel', 'core', NULL, 0, 1, 1, 0, 1, 0, 0, 0, 64, 8, 'lead', 'a:0:{}', 0, 0, 'ce3f71e8-7c16-4110-8812-2e46068c1425'),
(9, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Points', 'points', 'number', 'core', '0', 0, 1, 1, 0, 1, 0, 0, 0, 64, 9, 'lead', 'a:0:{}', 0, 0, '5694974d-b6e6-4478-a587-1ff14d748112'),
(10, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Fax', 'fax', 'tel', 'core', NULL, 0, 0, 1, 0, 1, 0, 0, 0, 64, 10, 'lead', 'a:0:{}', 0, 0, '60a7e2f3-7197-4fa4-95f5-eb5c5f1668c9'),
(11, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Address Line 1', 'address1', 'text', 'core', NULL, 0, 1, 1, 0, 1, 0, 0, 0, 64, 11, 'lead', 'a:0:{}', 0, 0, '0ebbd5ae-eaae-4be5-b3e7-0298537aaa35'),
(12, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Address Line 2', 'address2', 'text', 'core', NULL, 0, 1, 1, 0, 1, 0, 0, 0, 64, 12, 'lead', 'a:0:{}', 0, 0, '3883ecd0-656d-4c8d-a64e-8e34f5b97a83'),
(13, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'City', 'city', 'text', 'core', NULL, 0, 1, 1, 0, 1, 0, 0, 0, 64, 13, 'lead', 'a:0:{}', 0, 0, 'e11f6f06-cafa-4e99-862e-ed126599adf0'),
(14, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'State', 'state', 'region', 'core', NULL, 0, 1, 1, 0, 1, 0, 0, 0, 64, 14, 'lead', 'a:0:{}', 0, 0, 'e59a58a7-714e-4d3b-91c7-3c8328a57f21'),
(15, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Zip Code', 'zipcode', 'text', 'core', NULL, 0, 1, 1, 0, 1, 0, 0, 0, 64, 15, 'lead', 'a:0:{}', 0, 0, 'ce43ebd9-130f-48b9-88ac-e4219d111a95'),
(16, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Country', 'country', 'country', 'core', NULL, 0, 1, 1, 0, 1, 0, 0, 0, 64, 16, 'lead', 'a:0:{}', 0, 0, '43d4b070-5006-444f-a3ba-d786a6d1c715'),
(17, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Preferred Locale', 'preferred_locale', 'locale', 'core', NULL, 0, 1, 1, 0, 1, 0, 0, 0, 64, 17, 'lead', 'a:0:{}', 0, 0, '316133cb-c60d-42e4-a1cf-a6d399364b52'),
(18, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Preferred Timezone', 'timezone', 'timezone', 'core', NULL, 0, 1, 1, 0, 1, 0, 0, 0, 64, 18, 'lead', 'a:0:{}', 0, 0, 'f122b4af-99e8-473a-b3bc-4258e987009d'),
(19, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Date Last Active', 'last_active', 'datetime', 'core', NULL, 0, 1, 1, 0, 1, 0, 0, 0, 64, 19, 'lead', 'a:0:{}', 0, 0, '6160d980-a33d-42e6-a060-848061e24b36'),
(20, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Attribution Date', 'attribution_date', 'datetime', 'core', NULL, 0, 1, 1, 0, 1, 0, 0, 0, 64, 20, 'lead', 'a:0:{}', 0, 0, '66bd22d7-549c-4dc3-9a3d-8b50bbb89863'),
(21, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Attribution', 'attribution', 'number', 'core', NULL, 0, 1, 1, 0, 1, 0, 0, 0, 64, 21, 'lead', 'a:2:{s:9:"roundmode";i:4;s:5:"scale";i:2;}', 0, 0, '5205ed67-a89f-4a3e-a357-3bfb2ab36d4a'),
(22, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Website', 'website', 'url', 'core', NULL, 0, 0, 1, 0, 1, 0, 0, 0, 64, 22, 'lead', 'a:0:{}', 0, 0, '23abbe9a-f75b-4428-ac28-55ca51144daf'),
(23, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Facebook', 'facebook', 'text', 'social', NULL, 0, 0, 1, 0, 1, 0, 0, 0, 64, 23, 'lead', 'a:0:{}', 0, 0, '687e732b-c6db-484b-b3a9-692ad0fd8268'),
(24, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Foursquare', 'foursquare', 'text', 'social', NULL, 0, 0, 1, 0, 1, 0, 0, 0, 64, 24, 'lead', 'a:0:{}', 0, 0, '5def2994-d57e-4c88-b557-9970cfdd1ac1'),
(25, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Instagram', 'instagram', 'text', 'social', NULL, 0, 0, 1, 0, 1, 0, 0, 0, 64, 25, 'lead', 'a:0:{}', 0, 0, '937b4390-97f5-4f28-a781-a2856ece9f59'),
(26, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'mautic.lead.field.linkedin', 'linkedin', 'text', 'social', NULL, 0, 0, 1, 0, 1, 0, 0, 0, 64, 26, 'lead', 'a:0:{}', 0, 0, '51ed29a9-eea7-4cfa-bbef-9a944b76faa7'),
(27, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Skype', 'skype', 'text', 'social', NULL, 0, 0, 1, 0, 1, 0, 0, 0, 64, 27, 'lead', 'a:0:{}', 0, 0, 'ee925f14-327f-444f-9d22-095c602228fb'),
(28, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Twitter', 'twitter', 'text', 'social', NULL, 0, 0, 1, 0, 1, 0, 0, 0, 64, 28, 'lead', 'a:0:{}', 0, 0, '712d808b-0200-416a-9448-c589791416f3'),
(29, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Address 1', 'companyaddress1', 'text', 'core', NULL, 0, 1, 1, 0, 1, 0, 0, 0, 64, 1, 'company', 'a:0:{}', 0, 0, '577d0082-84f0-4be9-811b-a8cb4a6f2c00'),
(30, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Address 2', 'companyaddress2', 'text', 'core', NULL, 0, 1, 1, 0, 1, 0, 0, 0, 64, 2, 'company', 'a:0:{}', 0, 0, 'a1b7060c-c53b-4e04-a514-3f930f60deb3'),
(31, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Company Email', 'companyemail', 'email', 'core', NULL, 0, 1, 1, 0, 1, 0, 0, 0, 64, 3, 'company', 'a:0:{}', 0, 0, '0a07d95c-bd41-4ac2-a410-8ed59f71f7da'),
(32, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Phone', 'companyphone', 'tel', 'core', NULL, 0, 1, 1, 0, 1, 0, 0, 0, 64, 4, 'company', 'a:0:{}', 0, 0, '6415407c-691e-4afe-b51c-d0c2c2cd7078'),
(33, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'City', 'companycity', 'text', 'core', NULL, 0, 1, 1, 0, 1, 0, 0, 0, 64, 5, 'company', 'a:0:{}', 0, 0, '14179ecd-b362-46e8-8c92-a2eef33c52d1'),
(34, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'State', 'companystate', 'region', 'core', NULL, 0, 1, 1, 0, 1, 0, 0, 0, 64, 6, 'company', 'a:0:{}', 0, 0, '93190d9f-c31c-407e-b217-499ceafd9b0e'),
(35, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Zip Code', 'companyzipcode', 'text', 'core', NULL, 0, 1, 1, 0, 1, 0, 0, 0, 64, 7, 'company', 'a:0:{}', 0, 0, '850ff464-0d7e-4364-be4c-5060a3e9a8ca'),
(36, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Country', 'companycountry', 'country', 'core', NULL, 0, 1, 1, 0, 1, 0, 0, 0, 64, 8, 'company', 'a:0:{}', 0, 0, '53584fc6-80c5-446e-beec-949f24f654d4'),
(37, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Company Name', 'companyname', 'text', 'core', NULL, 1, 1, 1, 0, 1, 0, 1, 1, 64, 9, 'company', 'a:0:{}', 0, 0, 'b0e6842b-3e2a-4dca-b2a4-0e4abf3d7506'),
(38, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Website', 'companywebsite', 'url', 'core', NULL, 0, 1, 1, 0, 1, 0, 0, 0, 64, 10, 'company', 'a:0:{}', 0, 0, 'be75b21a-c7a9-43df-b17c-780863233929'),
(39, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Number of Employees', 'companynumber_of_employees', 'number', 'professional', NULL, 0, 0, 1, 0, 1, 0, 0, 0, 64, 11, 'company', 'a:2:{s:9:"roundmode";i:4;s:5:"scale";i:0;}', 0, 0, 'b6ab982b-f261-48af-9e2c-8790a5cef90c'),
(40, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Fax', 'companyfax', 'tel', 'professional', NULL, 0, 0, 1, 0, 1, 0, 0, 0, 64, 12, 'company', 'a:0:{}', 0, 0, 'c9adbbb7-7b9f-4c95-9e5c-95f13d38c889'),
(41, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Annual Revenue', 'companyannual_revenue', 'number', 'professional', NULL, 0, 0, 1, 0, 1, 0, 0, 0, 64, 13, 'company', 'a:2:{s:9:"roundmode";i:4;s:5:"scale";i:2;}', 0, 0, 'bb80bff7-5a3e-4f54-911e-f614c6fa7cab'),
(42, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Industry', 'companyindustry', 'select', 'professional', NULL, 0, 1, 1, 0, 1, 0, 0, 0, 64, 14, 'company', 'a:1:{s:4:"list";a:41:{i:0;a:2:{s:5:"label";s:19:"Aerospace & Defense";s:5:"value";s:19:"Aerospace & Defense";}i:1;a:2:{s:5:"label";s:11:"Agriculture";s:5:"value";s:11:"Agriculture";}i:2;a:2:{s:5:"label";s:7:"Apparel";s:5:"value";s:7:"Apparel";}i:3;a:2:{s:5:"label";s:21:"Automotive & Assembly";s:5:"value";s:21:"Automotive & Assembly";}i:4;a:2:{s:5:"label";s:7:"Banking";s:5:"value";s:7:"Banking";}i:5;a:2:{s:5:"label";s:13:"Biotechnology";s:5:"value";s:13:"Biotechnology";}i:6;a:2:{s:5:"label";s:9:"Chemicals";s:5:"value";s:9:"Chemicals";}i:7;a:2:{s:5:"label";s:14:"Communications";s:5:"value";s:14:"Communications";}i:8;a:2:{s:5:"label";s:12:"Construction";s:5:"value";s:12:"Construction";}i:9;a:2:{s:5:"label";s:23:"Consumer Packaged Goods";s:5:"value";s:23:"Consumer Packaged Goods";}i:10;a:2:{s:5:"label";s:9:"Education";s:5:"value";s:9:"Education";}i:11;a:2:{s:5:"label";s:11:"Electronics";s:5:"value";s:11:"Electronics";}i:12;a:2:{s:5:"label";s:6:"Energy";s:5:"value";s:6:"Energy";}i:13;a:2:{s:5:"label";s:11:"Engineering";s:5:"value";s:11:"Engineering";}i:14;a:2:{s:5:"label";s:13:"Entertainment";s:5:"value";s:13:"Entertainment";}i:15;a:2:{s:5:"label";s:13:"Environmental";s:5:"value";s:13:"Environmental";}i:16;a:2:{s:5:"label";s:7:"Finance";s:5:"value";s:7:"Finance";}i:17;a:2:{s:5:"label";s:15:"Food & Beverage";s:5:"value";s:15:"Food & Beverage";}i:18;a:2:{s:5:"label";s:10:"Government";s:5:"value";s:10:"Government";}i:19;a:2:{s:5:"label";s:10:"Healthcare";s:5:"value";s:10:"Healthcare";}i:20;a:2:{s:5:"label";s:11:"Hospitality";s:5:"value";s:11:"Hospitality";}i:21;a:2:{s:5:"label";s:9:"Insurance";s:5:"value";s:9:"Insurance";}i:22;a:2:{s:5:"label";s:9:"Machinery";s:5:"value";s:9:"Machinery";}i:23;a:2:{s:5:"label";s:13:"Manufacturing";s:5:"value";s:13:"Manufacturing";}i:24;a:2:{s:5:"label";s:5:"Media";s:5:"value";s:5:"Media";}i:25;a:2:{s:5:"label";s:15:"Metals & Mining";s:5:"value";s:15:"Metals & Mining";}i:26;a:2:{s:5:"label";s:14:"Not for Profit";s:5:"value";s:14:"Not for Profit";}i:27;a:2:{s:5:"label";s:9:"Oil & Gas";s:5:"value";s:9:"Oil & Gas";}i:28;a:2:{s:5:"label";s:17:"Packaging & Paper";s:5:"value";s:17:"Packaging & Paper";}i:29;a:2:{s:5:"label";s:36:"Private Equity & Principal Investors";s:5:"value";s:36:"Private Equity & Principal Investors";}i:30;a:2:{s:5:"label";s:10:"Recreation";s:5:"value";s:10:"Recreation";}i:31;a:2:{s:5:"label";s:11:"Real Estate";s:5:"value";s:11:"Real Estate";}i:32;a:2:{s:5:"label";s:6:"Retail";s:5:"value";s:6:"Retail";}i:33;a:2:{s:5:"label";s:14:"Semiconductors";s:5:"value";s:14:"Semiconductors";}i:34;a:2:{s:5:"label";s:8:"Shipping";s:5:"value";s:8:"Shipping";}i:35;a:2:{s:5:"label";s:13:"Social Sector";s:5:"value";s:13:"Social Sector";}i:36;a:2:{s:5:"label";s:10:"Technology";s:5:"value";s:10:"Technology";}i:37;a:2:{s:5:"label";s:18:"Telecommunications";s:5:"value";s:18:"Telecommunications";}i:38;a:2:{s:5:"label";s:14:"Transportation";s:5:"value";s:14:"Transportation";}i:39;a:2:{s:5:"label";s:9:"Utilities";s:5:"value";s:9:"Utilities";}i:40;a:2:{s:5:"label";s:5:"Other";s:5:"value";s:5:"Other";}}}', 0, 0, '8b37f4ba-2d09-4ee5-beb3-61a0133962cc'),
(43, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Description', 'companydescription', 'text', 'professional', NULL, 0, 1, 1, 0, 1, 0, 0, 0, 64, 15, 'company', 'a:0:{}', 0, 0, 'c5e15559-c15c-4a09-87ba-f477c906f77e');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lead_frequencyrules`
--

CREATE TABLE `[[dbprefix]]lead_frequencyrules` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `lead_id` bigint(20) unsigned NOT NULL,
  `date_added` datetime NOT NULL,
  `frequency_number` smallint(6) DEFAULT NULL,
  `frequency_time` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `channel` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `preferred_channel` tinyint(1) NOT NULL,
  `pause_from_date` datetime DEFAULT NULL,
  `pause_to_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_CD4A7B2C55458D` (`lead_id`),
  KEY `[[dbprefix]]channel_frequency` (`channel`),
  KEY `[[dbprefix]]idx_frequency_date_added` (`lead_id`,`date_added`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lead_ips_xref`
--

CREATE TABLE `[[dbprefix]]lead_ips_xref` (
  `lead_id` bigint(20) unsigned NOT NULL,
  `ip_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`lead_id`,`ip_id`),
  KEY `IDX_C2F93A4AA03F5E9F` (`ip_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lead_lists`
--

CREATE TABLE `[[dbprefix]]lead_lists` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned DEFAULT NULL,
  `is_published` tinyint(1) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `modified_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_out` datetime DEFAULT NULL,
  `checked_out_by` int(11) DEFAULT NULL,
  `checked_out_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `alias` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `public_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `filters` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  `is_global` tinyint(1) NOT NULL,
  `is_preference_center` tinyint(1) NOT NULL,
  `last_built_date` datetime DEFAULT NULL,
  `last_built_time` double DEFAULT NULL,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`id`),
  KEY `IDX_95CFBCC12469DE2` (`category_id`),
  KEY `[[dbprefix]]lead_list_alias` (`alias`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lead_lists_leads`
--

CREATE TABLE `[[dbprefix]]lead_lists_leads` (
  `leadlist_id` int(10) unsigned NOT NULL,
  `lead_id` bigint(20) unsigned NOT NULL,
  `date_added` datetime NOT NULL,
  `manually_removed` tinyint(1) NOT NULL,
  `manually_added` tinyint(1) NOT NULL,
  PRIMARY KEY (`leadlist_id`,`lead_id`),
  KEY `IDX_4A6C9DD855458D` (`lead_id`),
  KEY `[[dbprefix]]manually_removed` (`manually_removed`),
  KEY `[[dbprefix]]lead_id_lists_id_removed` (`lead_id`,`leadlist_id`,`manually_removed`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lead_notes`
--

CREATE TABLE `[[dbprefix]]lead_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `lead_id` bigint(20) unsigned NOT NULL,
  `is_published` tinyint(1) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `modified_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_out` datetime DEFAULT NULL,
  `checked_out_by` int(11) DEFAULT NULL,
  `checked_out_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `text` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_61C2E555458D` (`lead_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lead_points_change_log`
--

CREATE TABLE `[[dbprefix]]lead_points_change_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `lead_id` bigint(20) unsigned NOT NULL,
  `ip_id` int(10) unsigned DEFAULT NULL,
  `group_id` int(10) unsigned DEFAULT NULL,
  `type` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `event_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `delta` int(11) NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_B553E13D55458D` (`lead_id`),
  KEY `IDX_B553E13DA03F5E9F` (`ip_id`),
  KEY `IDX_B553E13DFE54D947` (`group_id`),
  KEY `[[dbprefix]]point_date_added` (`date_added`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lead_stages_change_log`
--

CREATE TABLE `[[dbprefix]]lead_stages_change_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `lead_id` bigint(20) unsigned NOT NULL,
  `stage_id` int(10) unsigned DEFAULT NULL,
  `event_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_527BE30255458D` (`lead_id`),
  KEY `IDX_527BE3022298D193` (`stage_id`),
  KEY `[[dbprefix]]lead_stages_change_log_date_added` (`date_added`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lead_tags`
--

CREATE TABLE `[[dbprefix]]lead_tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tag` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]lead_tag_search` (`tag`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lead_tags_xref`
--

CREATE TABLE `[[dbprefix]]lead_tags_xref` (
  `lead_id` bigint(20) unsigned NOT NULL,
  `tag_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`lead_id`,`tag_id`),
  KEY `IDX_C0616611BAD26311` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lead_utmtags`
--

CREATE TABLE `[[dbprefix]]lead_utmtags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `lead_id` bigint(20) unsigned NOT NULL,
  `date_added` datetime NOT NULL,
  `query` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `referer` longtext COLLATE utf8mb4_unicode_ci,
  `remote_host` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` longtext COLLATE utf8mb4_unicode_ci,
  `user_agent` longtext COLLATE utf8mb4_unicode_ci,
  `utm_campaign` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_content` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_medium` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_source` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_term` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_6235E33655458D` (`lead_id`),
  KEY `[[dbprefix]]utm_date_added` (`date_added`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]messages`
--

CREATE TABLE `[[dbprefix]]messages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned DEFAULT NULL,
  `is_published` tinyint(1) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `modified_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_out` datetime DEFAULT NULL,
  `checked_out_by` int(11) DEFAULT NULL,
  `checked_out_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`id`),
  KEY `IDX_E723E37C12469DE2` (`category_id`),
  KEY `[[dbprefix]]date_message_added` (`date_added`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_channels`
--

CREATE TABLE `[[dbprefix]]message_channels` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `message_id` int(10) unsigned NOT NULL,
  `channel` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `channel_id` int(11) DEFAULT NULL,
  `properties` json NOT NULL,
  `is_enabled` tinyint(1) NOT NULL,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]channel_index` (`message_id`,`channel`),
  KEY `IDX_45AAC703537A1329` (`message_id`),
  KEY `[[dbprefix]]channel_entity_index` (`channel`,`channel_id`),
  KEY `[[dbprefix]]channel_enabled_index` (`channel`,`is_enabled`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_queue`
--

CREATE TABLE `[[dbprefix]]message_queue` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_id` int(10) unsigned DEFAULT NULL,
  `lead_id` bigint(20) unsigned NOT NULL,
  `channel` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `channel_id` int(11) NOT NULL,
  `priority` smallint(6) NOT NULL,
  `max_attempts` smallint(6) NOT NULL,
  `attempts` smallint(6) NOT NULL,
  `success` tinyint(1) NOT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_published` datetime DEFAULT NULL,
  `scheduled_date` datetime DEFAULT NULL,
  `last_attempt` datetime DEFAULT NULL,
  `date_sent` datetime DEFAULT NULL,
  `options` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  PRIMARY KEY (`id`),
  KEY `IDX_DC4FC4A471F7E88B` (`event_id`),
  KEY `IDX_DC4FC4A455458D` (`lead_id`),
  KEY `[[dbprefix]]message_status_search` (`status`),
  KEY `[[dbprefix]]message_date_sent` (`date_sent`),
  KEY `[[dbprefix]]message_scheduled_date` (`scheduled_date`),
  KEY `[[dbprefix]]message_priority` (`priority`),
  KEY `[[dbprefix]]message_success` (`success`),
  KEY `[[dbprefix]]message_channel_search` (`channel`,`channel_id`),
  KEY `[[dbprefix]]message_queue_date_published` (`date_published`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]monitoring`
--

CREATE TABLE `[[dbprefix]]monitoring` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned DEFAULT NULL,
  `is_published` tinyint(1) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `modified_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_out` datetime DEFAULT NULL,
  `checked_out_by` int(11) DEFAULT NULL,
  `checked_out_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `lists` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `network_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `revision` int(11) NOT NULL,
  `stats` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `properties` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_DDD23EBB12469DE2` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]monitoring_leads`
--

CREATE TABLE `[[dbprefix]]monitoring_leads` (
  `monitor_id` int(10) unsigned NOT NULL,
  `lead_id` bigint(20) unsigned NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`monitor_id`,`lead_id`),
  KEY `IDX_FAB89BEE55458D` (`lead_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]monitor_post_count`
--

CREATE TABLE `[[dbprefix]]monitor_post_count` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `monitor_id` int(10) unsigned DEFAULT NULL,
  `post_date` date NOT NULL,
  `post_count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_FECA34514CE1C902` (`monitor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notifications`
--

CREATE TABLE `[[dbprefix]]notifications` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `type` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `header` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_added` datetime NOT NULL,
  `icon_class` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_read` tinyint(1) NOT NULL,
  `deduplicate` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_3C14F4FFA76ED395` (`user_id`),
  KEY `[[dbprefix]]notification_read_status` (`is_read`),
  KEY `[[dbprefix]]notification_type` (`type`),
  KEY `[[dbprefix]]notification_user_read_status` (`is_read`,`user_id`),
  KEY `[[dbprefix]]deduplicate_date_added` (`deduplicate`,`date_added`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]oauth2_accesstokens`
--

CREATE TABLE `[[dbprefix]]oauth2_accesstokens` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expires_at` bigint(20) DEFAULT NULL,
  `scope` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_5DD8E6825F37A13B` (`token`),
  KEY `IDX_5DD8E68219EB6921` (`client_id`),
  KEY `IDX_5DD8E682A76ED395` (`user_id`),
  KEY `[[dbprefix]]oauth2_access_token_search` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]oauth2_authcodes`
--

CREATE TABLE `[[dbprefix]]oauth2_authcodes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expires_at` bigint(20) DEFAULT NULL,
  `scope` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `redirect_uri` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_6D2C65DF5F37A13B` (`token`),
  KEY `IDX_6D2C65DF19EB6921` (`client_id`),
  KEY `IDX_6D2C65DFA76ED395` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]oauth2_clients`
--

CREATE TABLE `[[dbprefix]]oauth2_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `random_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `redirect_uris` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  `allowed_grant_types` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  PRIMARY KEY (`id`),
  KEY `IDX_CB545241D60322AC` (`role_id`),
  KEY `[[dbprefix]]client_id_search` (`random_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]oauth2_refreshtokens`
--

CREATE TABLE `[[dbprefix]]oauth2_refreshtokens` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expires_at` bigint(20) DEFAULT NULL,
  `scope` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_BAE3C1D15F37A13B` (`token`),
  KEY `IDX_BAE3C1D119EB6921` (`client_id`),
  KEY `IDX_BAE3C1D1A76ED395` (`user_id`),
  KEY `[[dbprefix]]oauth2_refresh_token_search` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]oauth2_user_client_xref`
--

CREATE TABLE `[[dbprefix]]oauth2_user_client_xref` (
  `client_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`client_id`,`user_id`),
  KEY `IDX_D0784954A76ED395` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pages`
--

CREATE TABLE `[[dbprefix]]pages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned DEFAULT NULL,
  `translation_parent_id` int(10) unsigned DEFAULT NULL,
  `variant_parent_id` int(10) unsigned DEFAULT NULL,
  `is_published` tinyint(1) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `modified_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_out` datetime DEFAULT NULL,
  `checked_out_by` int(11) DEFAULT NULL,
  `checked_out_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `template` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_html` longtext COLLATE utf8mb4_unicode_ci,
  `content` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `hits` int(11) NOT NULL,
  `unique_hits` int(11) NOT NULL,
  `variant_hits` int(11) NOT NULL,
  `revision` int(11) NOT NULL,
  `meta_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `head_script` longtext COLLATE utf8mb4_unicode_ci,
  `footer_script` longtext COLLATE utf8mb4_unicode_ci,
  `redirect_type` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `redirect_url` varchar(2048) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_preference_center` tinyint(1) DEFAULT NULL,
  `no_index` tinyint(1) DEFAULT NULL,
  `lang` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `variant_settings` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `variant_start_date` datetime DEFAULT NULL,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`id`),
  KEY `IDX_C4C282012469DE2` (`category_id`),
  KEY `IDX_C4C28209091A2FB` (`translation_parent_id`),
  KEY `IDX_C4C282091861123` (`variant_parent_id`),
  KEY `[[dbprefix]]page_alias_search` (`alias`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]page_hits`
--

CREATE TABLE `[[dbprefix]]page_hits` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `page_id` int(10) unsigned DEFAULT NULL,
  `redirect_id` bigint(20) unsigned DEFAULT NULL,
  `email_id` int(10) unsigned DEFAULT NULL,
  `lead_id` bigint(20) unsigned DEFAULT NULL,
  `ip_id` int(10) unsigned DEFAULT NULL,
  `device_id` bigint(20) unsigned DEFAULT NULL,
  `date_hit` datetime NOT NULL,
  `date_left` datetime DEFAULT NULL,
  `country` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `region` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `isp` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `organization` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code` int(11) NOT NULL,
  `referer` longtext COLLATE utf8mb4_unicode_ci,
  `url` longtext COLLATE utf8mb4_unicode_ci,
  `url_title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` longtext COLLATE utf8mb4_unicode_ci,
  `remote_host` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `page_language` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `browser_languages` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `tracking_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `source` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `source_id` int(11) DEFAULT NULL,
  `query` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  PRIMARY KEY (`id`),
  KEY `IDX_DDA85A6AC4663E4` (`page_id`),
  KEY `IDX_DDA85A6AB42D874D` (`redirect_id`),
  KEY `IDX_DDA85A6AA832C1C9` (`email_id`),
  KEY `IDX_DDA85A6A55458D` (`lead_id`),
  KEY `IDX_DDA85A6AA03F5E9F` (`ip_id`),
  KEY `IDX_DDA85A6A94A4C7D4` (`device_id`),
  KEY `[[dbprefix]]page_hit_tracking_search` (`tracking_id`),
  KEY `[[dbprefix]]page_hit_code_search` (`code`),
  KEY `[[dbprefix]]page_hit_source_search` (`source`,`source_id`),
  KEY `[[dbprefix]]date_hit_left_index` (`date_hit`,`date_left`),
  KEY `[[dbprefix]]page_hit_url` (`url`(128))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]page_redirects`
--

CREATE TABLE `[[dbprefix]]page_redirects` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `is_published` tinyint(1) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `modified_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_out` datetime DEFAULT NULL,
  `checked_out_by` int(11) DEFAULT NULL,
  `checked_out_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `redirect_id` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `hits` int(11) NOT NULL,
  `unique_hits` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]permissions`
--

CREATE TABLE `[[dbprefix]]permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `bundle` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bitwise` int(11) NOT NULL,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]unique_perm` (`bundle`,`name`,`role_id`),
  KEY `IDX_64E3168BD60322AC` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]plugins`
--

CREATE TABLE `[[dbprefix]]plugins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `is_missing` tinyint(1) NOT NULL,
  `bundle` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `author` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]unique_bundle` (`bundle`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]plugins`
--

INSERT INTO `[[dbprefix]]plugins` VALUES
(1, 'GrapesJS Builder', 'GrapesJS Builder with MJML support for Mautic', 0, 'GrapesJsBuilderBundle', '1.0.0', 'Mautic Community');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]plugin_integration_settings`
--

CREATE TABLE `[[dbprefix]]plugin_integration_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `plugin_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_published` tinyint(1) NOT NULL,
  `supported_features` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `api_keys` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  `feature_settings` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  PRIMARY KEY (`id`),
  KEY `IDX_7305A748EC942BCF` (`plugin_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]plugin_integration_settings`
--

INSERT INTO `[[dbprefix]]plugin_integration_settings` VALUES
(1, 1, 'GrapesJsBuilder', 1, 'a:0:{}', 'a:0:{}', 'a:0:{}'),
(2, NULL, 'OneSignal', 0, 'a:4:{i:0;s:6:"mobile";i:1;s:20:"landing_page_enabled";i:2;s:28:"welcome_notification_enabled";i:3;s:21:"tracking_page_enabled";}', 'a:0:{}', 'a:0:{}'),
(3, NULL, 'Twilio', 0, 'a:0:{}', 'a:0:{}', 'a:0:{}');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]points`
--

CREATE TABLE `[[dbprefix]]points` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned DEFAULT NULL,
  `group_id` int(10) unsigned DEFAULT NULL,
  `is_published` tinyint(1) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `modified_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_out` datetime DEFAULT NULL,
  `checked_out_by` int(11) DEFAULT NULL,
  `checked_out_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `repeatable` tinyint(1) NOT NULL,
  `delta` int(11) NOT NULL,
  `properties` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  `uuid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`id`),
  KEY `IDX_3C97139F12469DE2` (`category_id`),
  KEY `IDX_3C97139FFE54D947` (`group_id`),
  KEY `[[dbprefix]]point_type_search` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]point_groups`
--

CREATE TABLE `[[dbprefix]]point_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `is_published` tinyint(1) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `modified_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_out` datetime DEFAULT NULL,
  `checked_out_by` int(11) DEFAULT NULL,
  `checked_out_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]point_group_contact_score`
--

CREATE TABLE `[[dbprefix]]point_group_contact_score` (
  `contact_id` bigint(20) unsigned NOT NULL,
  `group_id` int(10) unsigned NOT NULL,
  `score` int(11) NOT NULL,
  PRIMARY KEY (`contact_id`,`group_id`),
  KEY `IDX_5C0CC8E7FE54D947` (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]point_lead_action_log`
--

CREATE TABLE `[[dbprefix]]point_lead_action_log` (
  `point_id` int(10) unsigned NOT NULL,
  `lead_id` bigint(20) unsigned NOT NULL,
  `ip_id` int(10) unsigned DEFAULT NULL,
  `date_fired` datetime NOT NULL,
  PRIMARY KEY (`point_id`,`lead_id`),
  KEY `IDX_16C00E6255458D` (`lead_id`),
  KEY `IDX_16C00E62A03F5E9F` (`ip_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]point_lead_event_log`
--

CREATE TABLE `[[dbprefix]]point_lead_event_log` (
  `event_id` int(10) unsigned NOT NULL,
  `lead_id` bigint(20) unsigned NOT NULL,
  `ip_id` int(10) unsigned DEFAULT NULL,
  `date_fired` datetime NOT NULL,
  PRIMARY KEY (`event_id`,`lead_id`),
  KEY `IDX_4ACC277055458D` (`lead_id`),
  KEY `IDX_4ACC2770A03F5E9F` (`ip_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]point_triggers`
--

CREATE TABLE `[[dbprefix]]point_triggers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned DEFAULT NULL,
  `group_id` int(10) unsigned DEFAULT NULL,
  `is_published` tinyint(1) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `modified_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_out` datetime DEFAULT NULL,
  `checked_out_by` int(11) DEFAULT NULL,
  `checked_out_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `points` int(11) NOT NULL,
  `color` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trigger_existing_leads` tinyint(1) NOT NULL,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`id`),
  KEY `IDX_AE2FAB8812469DE2` (`category_id`),
  KEY `IDX_AE2FAB88FE54D947` (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]point_trigger_events`
--

CREATE TABLE `[[dbprefix]]point_trigger_events` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `trigger_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_order` int(11) NOT NULL,
  `properties` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  `uuid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`id`),
  KEY `IDX_8539F3925FDDDCD6` (`trigger_id`),
  KEY `[[dbprefix]]trigger_type_search` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]push_ids`
--

CREATE TABLE `[[dbprefix]]push_ids` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lead_id` bigint(20) unsigned DEFAULT NULL,
  `push_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `mobile` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_73026E0255458D` (`lead_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]push_notifications`
--

CREATE TABLE `[[dbprefix]]push_notifications` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned DEFAULT NULL,
  `is_published` tinyint(1) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `modified_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_out` datetime DEFAULT NULL,
  `checked_out_by` int(11) DEFAULT NULL,
  `checked_out_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `lang` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` longtext COLLATE utf8mb4_unicode_ci,
  `heading` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `button` longtext COLLATE utf8mb4_unicode_ci,
  `utm_tags` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `notification_type` longtext COLLATE utf8mb4_unicode_ci,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `read_count` int(11) NOT NULL,
  `sent_count` int(11) NOT NULL,
  `mobile` tinyint(1) NOT NULL,
  `mobileSettings` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  `uuid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`id`),
  KEY `IDX_46FD6AD412469DE2` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]push_notification_list_xref`
--

CREATE TABLE `[[dbprefix]]push_notification_list_xref` (
  `notification_id` int(10) unsigned NOT NULL,
  `leadlist_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`notification_id`,`leadlist_id`),
  KEY `IDX_A0269247B9FC8874` (`leadlist_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]push_notification_stats`
--

CREATE TABLE `[[dbprefix]]push_notification_stats` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `notification_id` int(10) unsigned DEFAULT NULL,
  `lead_id` bigint(20) unsigned DEFAULT NULL,
  `list_id` int(10) unsigned DEFAULT NULL,
  `ip_id` int(10) unsigned DEFAULT NULL,
  `date_sent` datetime NOT NULL,
  `date_read` datetime DEFAULT NULL,
  `is_clicked` tinyint(1) NOT NULL,
  `date_clicked` datetime DEFAULT NULL,
  `tracking_hash` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `retry_count` int(11) DEFAULT NULL,
  `source` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `source_id` int(11) DEFAULT NULL,
  `tokens` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `click_count` int(11) DEFAULT NULL,
  `last_clicked` datetime DEFAULT NULL,
  `click_details` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  PRIMARY KEY (`id`),
  KEY `IDX_14F86419EF1A9D84` (`notification_id`),
  KEY `IDX_14F8641955458D` (`lead_id`),
  KEY `IDX_14F864193DAE168B` (`list_id`),
  KEY `IDX_14F86419A03F5E9F` (`ip_id`),
  KEY `[[dbprefix]]stat_notification_search` (`notification_id`,`lead_id`),
  KEY `[[dbprefix]]stat_notification_clicked_search` (`is_clicked`),
  KEY `[[dbprefix]]stat_notification_hash_search` (`tracking_hash`),
  KEY `[[dbprefix]]stat_notification_source_search` (`source`,`source_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]reports`
--

CREATE TABLE `[[dbprefix]]reports` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `is_published` tinyint(1) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `modified_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_out` datetime DEFAULT NULL,
  `checked_out_by` int(11) DEFAULT NULL,
  `checked_out_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `system` tinyint(1) NOT NULL,
  `source` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `columns` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `filters` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `table_order` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `graphs` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `group_by` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `aggregators` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `settings` json DEFAULT NULL,
  `is_scheduled` tinyint(1) NOT NULL,
  `schedule_unit` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `to_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `schedule_day` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `schedule_month_frequency` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]reports`
--

INSERT INTO `[[dbprefix]]reports` VALUES
(1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Visits published Pages', NULL, 1, 'page.hits', 'a:7:{i:0;s:11:"ph.date_hit";i:1;s:6:"ph.url";i:2;s:12:"ph.url_title";i:3;s:10:"ph.referer";i:4;s:12:"i.ip_address";i:5;s:7:"ph.city";i:6;s:10:"ph.country";}', 'a:2:{i:0;a:3:{s:6:"column";s:7:"ph.code";s:9:"condition";s:2:"eq";s:5:"value";s:3:"200";}i:1;a:3:{s:6:"column";s:14:"p.is_published";s:9:"condition";s:2:"eq";s:5:"value";s:1:"1";}}', 'a:1:{i:0;a:2:{s:6:"column";s:11:"ph.date_hit";s:9:"direction";s:3:"ASC";}}', 'a:8:{i:0;s:35:"mautic.page.graph.line.time.on.site";i:1;s:27:"mautic.page.graph.line.hits";i:2;s:38:"mautic.page.graph.pie.new.vs.returning";i:3;s:31:"mautic.page.graph.pie.languages";i:4;s:34:"mautic.page.graph.pie.time.on.site";i:5;s:27:"mautic.page.table.referrers";i:6;s:30:"mautic.page.table.most.visited";i:7;s:37:"mautic.page.table.most.visited.unique";}', 'a:0:{}', 'a:0:{}', '[]', 0, NULL, NULL, NULL, NULL, '2373013b-22ff-476f-af94-b35170d55b98'),
(2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Downloads of all Assets', NULL, 1, 'asset.downloads', 'a:7:{i:0;s:16:"ad.date_download";i:1;s:7:"a.title";i:2;s:12:"i.ip_address";i:3;s:11:"l.firstname";i:4;s:10:"l.lastname";i:5;s:7:"l.email";i:6;s:4:"a.id";}', 'a:1:{i:0;a:3:{s:6:"column";s:14:"a.is_published";s:9:"condition";s:2:"eq";s:5:"value";s:1:"1";}}', 'a:1:{i:0;a:2:{s:6:"column";s:16:"ad.date_download";s:9:"direction";s:3:"ASC";}}', 'a:4:{i:0;s:33:"mautic.asset.graph.line.downloads";i:1;s:31:"mautic.asset.graph.pie.statuses";i:2;s:34:"mautic.asset.table.most.downloaded";i:3;s:32:"mautic.asset.table.top.referrers";}', 'a:0:{}', 'a:0:{}', '[]', 0, NULL, NULL, NULL, NULL, '2e0ce5ce-3477-41d6-9e57-ae8fb8d32ebd'),
(3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Submissions of published Forms', NULL, 1, 'form.submissions', 'a:0:{}', 'a:1:{i:1;a:3:{s:6:"column";s:14:"f.is_published";s:9:"condition";s:2:"eq";s:5:"value";s:1:"1";}}', 'a:0:{}', 'a:3:{i:0;s:34:"mautic.form.graph.line.submissions";i:1;s:32:"mautic.form.table.most.submitted";i:2;s:31:"mautic.form.table.top.referrers";}', 'a:0:{}', 'a:0:{}', '[]', 0, NULL, NULL, NULL, NULL, '3c6f6bab-b2d1-46d3-b0f2-99ad83e2f6f3'),
(4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'All Emails', NULL, 1, 'email.stats', 'a:5:{i:0;s:12:"es.date_sent";i:1;s:12:"es.date_read";i:2;s:9:"e.subject";i:3;s:16:"es.email_address";i:4;s:4:"e.id";}', 'a:1:{i:0;a:3:{s:6:"column";s:14:"e.is_published";s:9:"condition";s:2:"eq";s:5:"value";s:1:"1";}}', 'a:1:{i:0;a:2:{s:6:"column";s:12:"es.date_sent";s:9:"direction";s:3:"ASC";}}', 'a:6:{i:0;s:29:"mautic.email.graph.line.stats";i:1;s:42:"mautic.email.graph.pie.ignored.read.failed";i:2;s:35:"mautic.email.table.most.emails.read";i:3;s:35:"mautic.email.table.most.emails.sent";i:4;s:43:"mautic.email.table.most.emails.read.percent";i:5;s:37:"mautic.email.table.most.emails.failed";}', 'a:0:{}', 'a:0:{}', '[]', 0, NULL, NULL, NULL, NULL, 'a21b201f-a3d8-4238-82bc-a251d261a232'),
(5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Leads and Points', NULL, 1, 'lead.pointlog', 'a:7:{i:0;s:13:"lp.date_added";i:1;s:7:"lp.type";i:2;s:13:"lp.event_name";i:3;s:11:"l.firstname";i:4;s:10:"l.lastname";i:5;s:7:"l.email";i:6;s:8:"lp.delta";}', 'a:0:{}', 'a:1:{i:0;a:2:{s:6:"column";s:13:"lp.date_added";s:9:"direction";s:3:"ASC";}}', 'a:6:{i:0;s:29:"mautic.lead.graph.line.points";i:1;s:29:"mautic.lead.table.most.points";i:2;s:29:"mautic.lead.table.top.actions";i:3;s:28:"mautic.lead.table.top.cities";i:4;s:31:"mautic.lead.table.top.countries";i:5;s:28:"mautic.lead.table.top.events";}', 'a:0:{}', 'a:0:{}', '[]', 0, NULL, NULL, NULL, NULL, 'ad3c466a-9a39-4d3e-ae8e-e7f50c6f67af');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]reports_schedulers`
--

CREATE TABLE `[[dbprefix]]reports_schedulers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `report_id` int(10) unsigned NOT NULL,
  `schedule_date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_DA2AB2234BD2A4C0` (`report_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]roles`
--

CREATE TABLE `[[dbprefix]]roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `is_published` tinyint(1) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `modified_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_out` datetime DEFAULT NULL,
  `checked_out_by` int(11) DEFAULT NULL,
  `checked_out_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `is_admin` tinyint(1) NOT NULL,
  `readable_permissions` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  `uuid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]roles`
--

INSERT INTO `[[dbprefix]]roles` VALUES
(1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Administrator', 'Full system access', 1, 'N;', '7a65dad5-bfd7-41cd-a627-ef54137637b3');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]saml_id_entry`
--

CREATE TABLE `[[dbprefix]]saml_id_entry` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `entity_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiryTimestamp` int(11) NOT NULL,
  PRIMARY KEY (`id`,`entity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sms_messages`
--

CREATE TABLE `[[dbprefix]]sms_messages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned DEFAULT NULL,
  `is_published` tinyint(1) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `modified_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_out` datetime DEFAULT NULL,
  `checked_out_by` int(11) DEFAULT NULL,
  `checked_out_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `lang` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `sms_type` longtext COLLATE utf8mb4_unicode_ci,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `sent_count` int(11) NOT NULL,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`id`),
  KEY `IDX_1ADA172C12469DE2` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sms_message_list_xref`
--

CREATE TABLE `[[dbprefix]]sms_message_list_xref` (
  `sms_id` int(10) unsigned NOT NULL,
  `leadlist_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`sms_id`,`leadlist_id`),
  KEY `IDX_CB0BB81AB9FC8874` (`leadlist_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sms_message_stats`
--

CREATE TABLE `[[dbprefix]]sms_message_stats` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sms_id` int(10) unsigned DEFAULT NULL,
  `lead_id` bigint(20) unsigned DEFAULT NULL,
  `list_id` int(10) unsigned DEFAULT NULL,
  `ip_id` int(10) unsigned DEFAULT NULL,
  `date_sent` datetime NOT NULL,
  `is_failed` tinyint(1) DEFAULT NULL,
  `tracking_hash` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `source` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `source_id` int(11) DEFAULT NULL,
  `tokens` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `details` json NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_DEE545F9BD5C7E60` (`sms_id`),
  KEY `IDX_DEE545F955458D` (`lead_id`),
  KEY `IDX_DEE545F93DAE168B` (`list_id`),
  KEY `IDX_DEE545F9A03F5E9F` (`ip_id`),
  KEY `[[dbprefix]]stat_sms_search` (`sms_id`,`lead_id`),
  KEY `[[dbprefix]]stat_sms_hash_search` (`tracking_hash`),
  KEY `[[dbprefix]]stat_sms_source_search` (`source`,`source_id`),
  KEY `[[dbprefix]]stat_sms_failed_search` (`is_failed`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stages`
--

CREATE TABLE `[[dbprefix]]stages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned DEFAULT NULL,
  `is_published` tinyint(1) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `modified_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_out` datetime DEFAULT NULL,
  `checked_out_by` int(11) DEFAULT NULL,
  `checked_out_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `weight` int(11) NOT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`id`),
  KEY `IDX_348FF7D212469DE2` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stage_lead_action_log`
--

CREATE TABLE `[[dbprefix]]stage_lead_action_log` (
  `stage_id` int(10) unsigned NOT NULL,
  `lead_id` bigint(20) unsigned NOT NULL,
  `ip_id` int(10) unsigned DEFAULT NULL,
  `date_fired` datetime NOT NULL,
  PRIMARY KEY (`stage_id`,`lead_id`),
  KEY `IDX_DE3FEB8A55458D` (`lead_id`),
  KEY `IDX_DE3FEB8AA03F5E9F` (`ip_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sync_object_field_change_report`
--

CREATE TABLE `[[dbprefix]]sync_object_field_change_report` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `integration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `object_id` bigint(20) unsigned NOT NULL,
  `object_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `modified_at` datetime NOT NULL,
  `column_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `column_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `column_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]object_composite_key` (`object_type`,`object_id`,`column_name`),
  KEY `[[dbprefix]]integration_object_composite_key` (`integration`,`object_type`,`object_id`,`column_name`),
  KEY `[[dbprefix]]integration_object_type_modification_composite_key` (`integration`,`object_type`,`modified_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sync_object_mapping`
--

CREATE TABLE `[[dbprefix]]sync_object_mapping` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date_created` datetime NOT NULL,
  `integration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `internal_object_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `internal_object_id` bigint(20) unsigned NOT NULL,
  `integration_object_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `integration_object_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_sync_date` datetime NOT NULL,
  `internal_storage` json NOT NULL,
  `is_deleted` tinyint(1) NOT NULL,
  `integration_reference_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]internal_object_id_idx` (`internal_object_id`),
  KEY `[[dbprefix]]integration_object` (`integration`,`integration_object_name`,`integration_object_id`,`integration_reference_id`),
  KEY `[[dbprefix]]integration_reference` (`integration`,`integration_object_name`,`integration_reference_id`,`integration_object_id`),
  KEY `[[dbprefix]]integration_integration_object_name_last_sync_date` (`integration`,`internal_object_name`,`last_sync_date`),
  KEY `[[dbprefix]]integration_last_sync_date` (`integration`,`last_sync_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tweets`
--

CREATE TABLE `[[dbprefix]]tweets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned DEFAULT NULL,
  `page_id` int(10) unsigned DEFAULT NULL,
  `asset_id` int(10) unsigned DEFAULT NULL,
  `is_published` tinyint(1) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `modified_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_out` datetime DEFAULT NULL,
  `checked_out_by` int(11) DEFAULT NULL,
  `checked_out_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `media_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `media_path` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `text` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sent_count` int(11) DEFAULT NULL,
  `favorite_count` int(11) DEFAULT NULL,
  `retweet_count` int(11) DEFAULT NULL,
  `lang` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_B115DD9312469DE2` (`category_id`),
  KEY `IDX_B115DD93C4663E4` (`page_id`),
  KEY `IDX_B115DD935DA1941` (`asset_id`),
  KEY `[[dbprefix]]sent_count_index` (`sent_count`),
  KEY `[[dbprefix]]favorite_count_index` (`favorite_count`),
  KEY `[[dbprefix]]retweet_count_index` (`retweet_count`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tweet_stats`
--

CREATE TABLE `[[dbprefix]]tweet_stats` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tweet_id` int(10) unsigned DEFAULT NULL,
  `lead_id` bigint(20) unsigned DEFAULT NULL,
  `twitter_tweet_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `handle` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_sent` datetime DEFAULT NULL,
  `is_failed` tinyint(1) DEFAULT NULL,
  `retry_count` int(11) DEFAULT NULL,
  `source` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `source_id` int(11) DEFAULT NULL,
  `favorite_count` int(11) DEFAULT NULL,
  `retweet_count` int(11) DEFAULT NULL,
  `response_details` json DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_828260011041E39B` (`tweet_id`),
  KEY `IDX_8282600155458D` (`lead_id`),
  KEY `[[dbprefix]]stat_tweet_search` (`tweet_id`,`lead_id`),
  KEY `[[dbprefix]]stat_tweet_search2` (`lead_id`,`tweet_id`),
  KEY `[[dbprefix]]stat_tweet_failed_search` (`is_failed`),
  KEY `[[dbprefix]]stat_tweet_source_search` (`source`,`source_id`),
  KEY `[[dbprefix]]favorite_count_index` (`favorite_count`),
  KEY `[[dbprefix]]retweet_count_index` (`retweet_count`),
  KEY `[[dbprefix]]tweet_date_sent` (`date_sent`),
  KEY `[[dbprefix]]twitter_tweet_id_index` (`twitter_tweet_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users`
--

CREATE TABLE `[[dbprefix]]users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `is_published` tinyint(1) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `modified_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_out` datetime DEFAULT NULL,
  `checked_out_by` int(11) DEFAULT NULL,
  `checked_out_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `first_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `timezone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `locale` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_login` datetime DEFAULT NULL,
  `last_active` datetime DEFAULT NULL,
  `preferences` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `signature` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_38BB68BCF85E0677` (`username`),
  UNIQUE KEY `UNIQ_38BB68BCE7927C74` (`email`),
  KEY `IDX_38BB68BCD60322AC` (`role_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]users`
--

INSERT INTO `[[dbprefix]]users` VALUES
(1, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[[admin_username]]', '[[admin_pass]]', '[[admin_fname]]', '[[admin_lname]]', '[[admin_email]]', NULL, '', '', NULL, NULL, 'a:0:{}', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_tokens`
--

CREATE TABLE `[[dbprefix]]user_tokens` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `authorizator` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `one_time_only` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_8606D0575CA2E8E5` (`secret`),
  KEY `IDX_8606D057A76ED395` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]video_hits`
--

CREATE TABLE `[[dbprefix]]video_hits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `lead_id` bigint(20) unsigned DEFAULT NULL,
  `ip_id` int(10) unsigned DEFAULT NULL,
  `date_hit` datetime NOT NULL,
  `date_left` datetime DEFAULT NULL,
  `country` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `region` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `isp` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `organization` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code` int(11) NOT NULL,
  `referer` longtext COLLATE utf8mb4_unicode_ci,
  `url` longtext COLLATE utf8mb4_unicode_ci,
  `user_agent` longtext COLLATE utf8mb4_unicode_ci,
  `remote_host` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `guid` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `page_language` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `browser_languages` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `channel` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `channel_id` int(11) DEFAULT NULL,
  `time_watched` int(11) DEFAULT NULL,
  `duration` int(11) DEFAULT NULL,
  `query` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  PRIMARY KEY (`id`),
  KEY `IDX_7A85981155458D` (`lead_id`),
  KEY `IDX_7A859811A03F5E9F` (`ip_id`),
  KEY `[[dbprefix]]video_date_hit` (`date_hit`),
  KEY `[[dbprefix]]video_channel_search` (`channel`,`channel_id`),
  KEY `[[dbprefix]]video_guid_lead_search` (`guid`,`lead_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]webhooks`
--

CREATE TABLE `[[dbprefix]]webhooks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned DEFAULT NULL,
  `is_published` tinyint(1) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `modified_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_out` datetime DEFAULT NULL,
  `checked_out_by` int(11) DEFAULT NULL,
  `checked_out_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `webhook_url` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `events_orderby_dir` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_A5ADB23712469DE2` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]webhook_events`
--

CREATE TABLE `[[dbprefix]]webhook_events` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `webhook_id` int(10) unsigned NOT NULL,
  `event_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_485036905C9BA60B` (`webhook_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]webhook_logs`
--

CREATE TABLE `[[dbprefix]]webhook_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `webhook_id` int(10) unsigned NOT NULL,
  `status_code` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `runtime` double DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_E28D7BFC5C9BA60B` (`webhook_id`),
  KEY `[[dbprefix]]webhook_id_date_added` (`webhook_id`,`date_added`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]webhook_queue`
--

CREATE TABLE `[[dbprefix]]webhook_queue` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `webhook_id` int(10) unsigned NOT NULL,
  `event_id` int(10) unsigned NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci,
  `payload_compressed` mediumblob,
  PRIMARY KEY (`id`),
  KEY `IDX_A939DE365C9BA60B` (`webhook_id`),
  KEY `IDX_A939DE3671F7E88B` (`event_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]widgets`
--

CREATE TABLE `[[dbprefix]]widgets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `is_published` tinyint(1) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `modified_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_out` datetime DEFAULT NULL,
  `checked_out_by` int(11) DEFAULT NULL,
  `checked_out_by_user` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `width` int(11) NOT NULL,
  `height` int(11) NOT NULL,
  `cache_timeout` int(11) DEFAULT NULL,
  `ordering` int(11) DEFAULT NULL,
  `params` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `[[dbprefix]]assets`
--
ALTER TABLE `[[dbprefix]]assets`
  ADD CONSTRAINT `FK_62FCE03812469DE2` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]categories` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]asset_downloads`
--
ALTER TABLE `[[dbprefix]]asset_downloads`
  ADD CONSTRAINT `FK_EEC9FEBC55458D` FOREIGN KEY (`lead_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_EEC9FEBC5DA1941` FOREIGN KEY (`asset_id`) REFERENCES `[[dbprefix]]assets` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_EEC9FEBCA03F5E9F` FOREIGN KEY (`ip_id`) REFERENCES `[[dbprefix]]ip_addresses` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_EEC9FEBCA832C1C9` FOREIGN KEY (`email_id`) REFERENCES `[[dbprefix]]emails` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]bundle_grapesjsbuilder`
--
ALTER TABLE `[[dbprefix]]bundle_grapesjsbuilder`
  ADD CONSTRAINT `FK_776E26F6A832C1C9` FOREIGN KEY (`email_id`) REFERENCES `[[dbprefix]]emails` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]campaigns`
--
ALTER TABLE `[[dbprefix]]campaigns`
  ADD CONSTRAINT `FK_A3905EEB12469DE2` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]categories` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]campaign_events`
--
ALTER TABLE `[[dbprefix]]campaign_events`
  ADD CONSTRAINT `FK_C6449CD4727ACA70` FOREIGN KEY (`parent_id`) REFERENCES `[[dbprefix]]campaign_events` (`id`),
  ADD CONSTRAINT `FK_C6449CD4F639F774` FOREIGN KEY (`campaign_id`) REFERENCES `[[dbprefix]]campaigns` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]campaign_form_xref`
--
ALTER TABLE `[[dbprefix]]campaign_form_xref`
  ADD CONSTRAINT `FK_2D2EBC295FF69B7D` FOREIGN KEY (`form_id`) REFERENCES `[[dbprefix]]forms` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_2D2EBC29F639F774` FOREIGN KEY (`campaign_id`) REFERENCES `[[dbprefix]]campaigns` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]campaign_leadlist_xref`
--
ALTER TABLE `[[dbprefix]]campaign_leadlist_xref`
  ADD CONSTRAINT `FK_454FC8DFB9FC8874` FOREIGN KEY (`leadlist_id`) REFERENCES `[[dbprefix]]lead_lists` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_454FC8DFF639F774` FOREIGN KEY (`campaign_id`) REFERENCES `[[dbprefix]]campaigns` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]campaign_leads`
--
ALTER TABLE `[[dbprefix]]campaign_leads`
  ADD CONSTRAINT `FK_6B11599A55458D` FOREIGN KEY (`lead_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_6B11599AF639F774` FOREIGN KEY (`campaign_id`) REFERENCES `[[dbprefix]]campaigns` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]campaign_lead_event_failed_log`
--
ALTER TABLE `[[dbprefix]]campaign_lead_event_failed_log`
  ADD CONSTRAINT `FK_67125498EA675D86` FOREIGN KEY (`log_id`) REFERENCES `[[dbprefix]]campaign_lead_event_log` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]campaign_lead_event_log`
--
ALTER TABLE `[[dbprefix]]campaign_lead_event_log`
  ADD CONSTRAINT `FK_7DD906E655458D` FOREIGN KEY (`lead_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_7DD906E671F7E88B` FOREIGN KEY (`event_id`) REFERENCES `[[dbprefix]]campaign_events` (`id`),
  ADD CONSTRAINT `FK_7DD906E6A03F5E9F` FOREIGN KEY (`ip_id`) REFERENCES `[[dbprefix]]ip_addresses` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_7DD906E6F639F774` FOREIGN KEY (`campaign_id`) REFERENCES `[[dbprefix]]campaigns` (`id`);

--
-- Constraints for table `[[dbprefix]]campaign_summary`
--
ALTER TABLE `[[dbprefix]]campaign_summary`
  ADD CONSTRAINT `FK_D90A1BEB71F7E88B` FOREIGN KEY (`event_id`) REFERENCES `[[dbprefix]]campaign_events` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_D90A1BEBF639F774` FOREIGN KEY (`campaign_id`) REFERENCES `[[dbprefix]]campaigns` (`id`);

--
-- Constraints for table `[[dbprefix]]channel_url_trackables`
--
ALTER TABLE `[[dbprefix]]channel_url_trackables`
  ADD CONSTRAINT `FK_E4E69ECB42D874D` FOREIGN KEY (`redirect_id`) REFERENCES `[[dbprefix]]page_redirects` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]companies`
--
ALTER TABLE `[[dbprefix]]companies`
  ADD CONSTRAINT `FK_C2A780A17E3C61F9` FOREIGN KEY (`owner_id`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]companies_leads`
--
ALTER TABLE `[[dbprefix]]companies_leads`
  ADD CONSTRAINT `FK_BC99B88555458D` FOREIGN KEY (`lead_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_BC99B885979B1AD6` FOREIGN KEY (`company_id`) REFERENCES `[[dbprefix]]companies` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]contact_export_scheduler`
--
ALTER TABLE `[[dbprefix]]contact_export_scheduler`
  ADD CONSTRAINT `FK_E2B2EF02A76ED395` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]contact_merge_records`
--
ALTER TABLE `[[dbprefix]]contact_merge_records`
  ADD CONSTRAINT `FK_A28DB68BE7A1254A` FOREIGN KEY (`contact_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]dynamic_content`
--
ALTER TABLE `[[dbprefix]]dynamic_content`
  ADD CONSTRAINT `FK_68396C8112469DE2` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]categories` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_68396C819091A2FB` FOREIGN KEY (`translation_parent_id`) REFERENCES `[[dbprefix]]dynamic_content` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_68396C8191861123` FOREIGN KEY (`variant_parent_id`) REFERENCES `[[dbprefix]]dynamic_content` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]dynamic_content_lead_data`
--
ALTER TABLE `[[dbprefix]]dynamic_content_lead_data`
  ADD CONSTRAINT `FK_90D24DFF55458D` FOREIGN KEY (`lead_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_90D24DFFD9D0CD7` FOREIGN KEY (`dynamic_content_id`) REFERENCES `[[dbprefix]]dynamic_content` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]dynamic_content_stats`
--
ALTER TABLE `[[dbprefix]]dynamic_content_stats`
  ADD CONSTRAINT `FK_9FB6FBB455458D` FOREIGN KEY (`lead_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_9FB6FBB4D9D0CD7` FOREIGN KEY (`dynamic_content_id`) REFERENCES `[[dbprefix]]dynamic_content` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]emails`
--
ALTER TABLE `[[dbprefix]]emails`
  ADD CONSTRAINT `FK_57AC75E412469DE2` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]categories` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_57AC75E42DC494F6` FOREIGN KEY (`unsubscribeform_id`) REFERENCES `[[dbprefix]]forms` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_57AC75E4834F9C5B` FOREIGN KEY (`preference_center_id`) REFERENCES `[[dbprefix]]pages` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_57AC75E49091A2FB` FOREIGN KEY (`translation_parent_id`) REFERENCES `[[dbprefix]]emails` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_57AC75E491861123` FOREIGN KEY (`variant_parent_id`) REFERENCES `[[dbprefix]]emails` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]emails_draft`
--
ALTER TABLE `[[dbprefix]]emails_draft`
  ADD CONSTRAINT `FK_1EEDD2ABA832C1C9` FOREIGN KEY (`email_id`) REFERENCES `[[dbprefix]]emails` (`id`);

--
-- Constraints for table `[[dbprefix]]email_assets_xref`
--
ALTER TABLE `[[dbprefix]]email_assets_xref`
  ADD CONSTRAINT `FK_1B35A8685DA1941` FOREIGN KEY (`asset_id`) REFERENCES `[[dbprefix]]assets` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_1B35A868A832C1C9` FOREIGN KEY (`email_id`) REFERENCES `[[dbprefix]]emails` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]email_list_excluded`
--
ALTER TABLE `[[dbprefix]]email_list_excluded`
  ADD CONSTRAINT `FK_5AFC0DA3A832C1C9` FOREIGN KEY (`email_id`) REFERENCES `[[dbprefix]]emails` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_5AFC0DA3B9FC8874` FOREIGN KEY (`leadlist_id`) REFERENCES `[[dbprefix]]lead_lists` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]email_list_xref`
--
ALTER TABLE `[[dbprefix]]email_list_xref`
  ADD CONSTRAINT `FK_66A4422FA832C1C9` FOREIGN KEY (`email_id`) REFERENCES `[[dbprefix]]emails` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_66A4422FB9FC8874` FOREIGN KEY (`leadlist_id`) REFERENCES `[[dbprefix]]lead_lists` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]email_stats`
--
ALTER TABLE `[[dbprefix]]email_stats`
  ADD CONSTRAINT `FK_8304FCC13DAE168B` FOREIGN KEY (`list_id`) REFERENCES `[[dbprefix]]lead_lists` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_8304FCC155458D` FOREIGN KEY (`lead_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_8304FCC1A03F5E9F` FOREIGN KEY (`ip_id`) REFERENCES `[[dbprefix]]ip_addresses` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_8304FCC1A832C1C9` FOREIGN KEY (`email_id`) REFERENCES `[[dbprefix]]emails` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_8304FCC1A8752772` FOREIGN KEY (`copy_id`) REFERENCES `[[dbprefix]]email_copies` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]email_stats_devices`
--
ALTER TABLE `[[dbprefix]]email_stats_devices`
  ADD CONSTRAINT `FK_1D4A30B794A4C7D4` FOREIGN KEY (`device_id`) REFERENCES `[[dbprefix]]lead_devices` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_1D4A30B79502F0B` FOREIGN KEY (`stat_id`) REFERENCES `[[dbprefix]]email_stats` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_1D4A30B7A03F5E9F` FOREIGN KEY (`ip_id`) REFERENCES `[[dbprefix]]ip_addresses` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]email_stat_replies`
--
ALTER TABLE `[[dbprefix]]email_stat_replies`
  ADD CONSTRAINT `FK_C8FE27B9502F0B` FOREIGN KEY (`stat_id`) REFERENCES `[[dbprefix]]email_stats` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]focus`
--
ALTER TABLE `[[dbprefix]]focus`
  ADD CONSTRAINT `FK_4EF887BC12469DE2` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]categories` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]focus_stats`
--
ALTER TABLE `[[dbprefix]]focus_stats`
  ADD CONSTRAINT `FK_8A67AA3851804B42` FOREIGN KEY (`focus_id`) REFERENCES `[[dbprefix]]focus` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_8A67AA3855458D` FOREIGN KEY (`lead_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]forms`
--
ALTER TABLE `[[dbprefix]]forms`
  ADD CONSTRAINT `FK_D107D6A212469DE2` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]categories` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]form_actions`
--
ALTER TABLE `[[dbprefix]]form_actions`
  ADD CONSTRAINT `FK_930AB96F5FF69B7D` FOREIGN KEY (`form_id`) REFERENCES `[[dbprefix]]forms` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]form_fields`
--
ALTER TABLE `[[dbprefix]]form_fields`
  ADD CONSTRAINT `FK_3505EDC25FF69B7D` FOREIGN KEY (`form_id`) REFERENCES `[[dbprefix]]forms` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]form_submissions`
--
ALTER TABLE `[[dbprefix]]form_submissions`
  ADD CONSTRAINT `FK_7792184255458D` FOREIGN KEY (`lead_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_779218425FF69B7D` FOREIGN KEY (`form_id`) REFERENCES `[[dbprefix]]forms` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_77921842A03F5E9F` FOREIGN KEY (`ip_id`) REFERENCES `[[dbprefix]]ip_addresses` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_77921842C4663E4` FOREIGN KEY (`page_id`) REFERENCES `[[dbprefix]]pages` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]leads`
--
ALTER TABLE `[[dbprefix]]leads`
  ADD CONSTRAINT `FK_3BA888072298D193` FOREIGN KEY (`stage_id`) REFERENCES `[[dbprefix]]stages` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_3BA888077E3C61F9` FOREIGN KEY (`owner_id`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]lead_categories`
--
ALTER TABLE `[[dbprefix]]lead_categories`
  ADD CONSTRAINT `FK_5AE8EFC712469DE2` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]categories` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_5AE8EFC755458D` FOREIGN KEY (`lead_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]lead_companies_change_log`
--
ALTER TABLE `[[dbprefix]]lead_companies_change_log`
  ADD CONSTRAINT `FK_61BDA7FF55458D` FOREIGN KEY (`lead_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]lead_devices`
--
ALTER TABLE `[[dbprefix]]lead_devices`
  ADD CONSTRAINT `FK_EFE73A4F55458D` FOREIGN KEY (`lead_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]lead_donotcontact`
--
ALTER TABLE `[[dbprefix]]lead_donotcontact`
  ADD CONSTRAINT `FK_A0D8F40D55458D` FOREIGN KEY (`lead_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]lead_event_log`
--
ALTER TABLE `[[dbprefix]]lead_event_log`
  ADD CONSTRAINT `FK_35D7D78955458D` FOREIGN KEY (`lead_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]lead_frequencyrules`
--
ALTER TABLE `[[dbprefix]]lead_frequencyrules`
  ADD CONSTRAINT `FK_CD4A7B2C55458D` FOREIGN KEY (`lead_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]lead_ips_xref`
--
ALTER TABLE `[[dbprefix]]lead_ips_xref`
  ADD CONSTRAINT `FK_C2F93A4A55458D` FOREIGN KEY (`lead_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_C2F93A4AA03F5E9F` FOREIGN KEY (`ip_id`) REFERENCES `[[dbprefix]]ip_addresses` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]lead_lists`
--
ALTER TABLE `[[dbprefix]]lead_lists`
  ADD CONSTRAINT `FK_95CFBCC12469DE2` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]categories` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]lead_lists_leads`
--
ALTER TABLE `[[dbprefix]]lead_lists_leads`
  ADD CONSTRAINT `FK_4A6C9DD855458D` FOREIGN KEY (`lead_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_4A6C9DD8B9FC8874` FOREIGN KEY (`leadlist_id`) REFERENCES `[[dbprefix]]lead_lists` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]lead_notes`
--
ALTER TABLE `[[dbprefix]]lead_notes`
  ADD CONSTRAINT `FK_61C2E555458D` FOREIGN KEY (`lead_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]lead_points_change_log`
--
ALTER TABLE `[[dbprefix]]lead_points_change_log`
  ADD CONSTRAINT `FK_B553E13D55458D` FOREIGN KEY (`lead_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_B553E13DA03F5E9F` FOREIGN KEY (`ip_id`) REFERENCES `[[dbprefix]]ip_addresses` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_B553E13DFE54D947` FOREIGN KEY (`group_id`) REFERENCES `[[dbprefix]]point_groups` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]lead_stages_change_log`
--
ALTER TABLE `[[dbprefix]]lead_stages_change_log`
  ADD CONSTRAINT `FK_527BE3022298D193` FOREIGN KEY (`stage_id`) REFERENCES `[[dbprefix]]stages` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_527BE30255458D` FOREIGN KEY (`lead_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]lead_tags_xref`
--
ALTER TABLE `[[dbprefix]]lead_tags_xref`
  ADD CONSTRAINT `FK_C061661155458D` FOREIGN KEY (`lead_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_C0616611BAD26311` FOREIGN KEY (`tag_id`) REFERENCES `[[dbprefix]]lead_tags` (`id`);

--
-- Constraints for table `[[dbprefix]]lead_utmtags`
--
ALTER TABLE `[[dbprefix]]lead_utmtags`
  ADD CONSTRAINT `FK_6235E33655458D` FOREIGN KEY (`lead_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]messages`
--
ALTER TABLE `[[dbprefix]]messages`
  ADD CONSTRAINT `FK_E723E37C12469DE2` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]categories` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]message_channels`
--
ALTER TABLE `[[dbprefix]]message_channels`
  ADD CONSTRAINT `FK_45AAC703537A1329` FOREIGN KEY (`message_id`) REFERENCES `[[dbprefix]]messages` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]message_queue`
--
ALTER TABLE `[[dbprefix]]message_queue`
  ADD CONSTRAINT `FK_DC4FC4A455458D` FOREIGN KEY (`lead_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_DC4FC4A471F7E88B` FOREIGN KEY (`event_id`) REFERENCES `[[dbprefix]]campaign_events` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]monitoring`
--
ALTER TABLE `[[dbprefix]]monitoring`
  ADD CONSTRAINT `FK_DDD23EBB12469DE2` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]categories` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]monitoring_leads`
--
ALTER TABLE `[[dbprefix]]monitoring_leads`
  ADD CONSTRAINT `FK_FAB89BEE4CE1C902` FOREIGN KEY (`monitor_id`) REFERENCES `[[dbprefix]]monitoring` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_FAB89BEE55458D` FOREIGN KEY (`lead_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]monitor_post_count`
--
ALTER TABLE `[[dbprefix]]monitor_post_count`
  ADD CONSTRAINT `FK_FECA34514CE1C902` FOREIGN KEY (`monitor_id`) REFERENCES `[[dbprefix]]monitoring` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]notifications`
--
ALTER TABLE `[[dbprefix]]notifications`
  ADD CONSTRAINT `FK_3C14F4FFA76ED395` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]oauth2_accesstokens`
--
ALTER TABLE `[[dbprefix]]oauth2_accesstokens`
  ADD CONSTRAINT `FK_5DD8E68219EB6921` FOREIGN KEY (`client_id`) REFERENCES `[[dbprefix]]oauth2_clients` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_5DD8E682A76ED395` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]oauth2_authcodes`
--
ALTER TABLE `[[dbprefix]]oauth2_authcodes`
  ADD CONSTRAINT `FK_6D2C65DF19EB6921` FOREIGN KEY (`client_id`) REFERENCES `[[dbprefix]]oauth2_clients` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_6D2C65DFA76ED395` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]oauth2_clients`
--
ALTER TABLE `[[dbprefix]]oauth2_clients`
  ADD CONSTRAINT `FK_CB545241D60322AC` FOREIGN KEY (`role_id`) REFERENCES `[[dbprefix]]roles` (`id`);

--
-- Constraints for table `[[dbprefix]]oauth2_refreshtokens`
--
ALTER TABLE `[[dbprefix]]oauth2_refreshtokens`
  ADD CONSTRAINT `FK_BAE3C1D119EB6921` FOREIGN KEY (`client_id`) REFERENCES `[[dbprefix]]oauth2_clients` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_BAE3C1D1A76ED395` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]oauth2_user_client_xref`
--
ALTER TABLE `[[dbprefix]]oauth2_user_client_xref`
  ADD CONSTRAINT `FK_D078495419EB6921` FOREIGN KEY (`client_id`) REFERENCES `[[dbprefix]]oauth2_clients` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_D0784954A76ED395` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]pages`
--
ALTER TABLE `[[dbprefix]]pages`
  ADD CONSTRAINT `FK_C4C282012469DE2` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]categories` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_C4C28209091A2FB` FOREIGN KEY (`translation_parent_id`) REFERENCES `[[dbprefix]]pages` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_C4C282091861123` FOREIGN KEY (`variant_parent_id`) REFERENCES `[[dbprefix]]pages` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]page_hits`
--
ALTER TABLE `[[dbprefix]]page_hits`
  ADD CONSTRAINT `FK_DDA85A6A55458D` FOREIGN KEY (`lead_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_DDA85A6A94A4C7D4` FOREIGN KEY (`device_id`) REFERENCES `[[dbprefix]]lead_devices` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_DDA85A6AA03F5E9F` FOREIGN KEY (`ip_id`) REFERENCES `[[dbprefix]]ip_addresses` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_DDA85A6AA832C1C9` FOREIGN KEY (`email_id`) REFERENCES `[[dbprefix]]emails` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_DDA85A6AB42D874D` FOREIGN KEY (`redirect_id`) REFERENCES `[[dbprefix]]page_redirects` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_DDA85A6AC4663E4` FOREIGN KEY (`page_id`) REFERENCES `[[dbprefix]]pages` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]permissions`
--
ALTER TABLE `[[dbprefix]]permissions`
  ADD CONSTRAINT `FK_64E3168BD60322AC` FOREIGN KEY (`role_id`) REFERENCES `[[dbprefix]]roles` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]plugin_integration_settings`
--
ALTER TABLE `[[dbprefix]]plugin_integration_settings`
  ADD CONSTRAINT `FK_7305A748EC942BCF` FOREIGN KEY (`plugin_id`) REFERENCES `[[dbprefix]]plugins` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]points`
--
ALTER TABLE `[[dbprefix]]points`
  ADD CONSTRAINT `FK_3C97139F12469DE2` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]categories` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_3C97139FFE54D947` FOREIGN KEY (`group_id`) REFERENCES `[[dbprefix]]point_groups` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]point_group_contact_score`
--
ALTER TABLE `[[dbprefix]]point_group_contact_score`
  ADD CONSTRAINT `FK_5C0CC8E7E7A1254A` FOREIGN KEY (`contact_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_5C0CC8E7FE54D947` FOREIGN KEY (`group_id`) REFERENCES `[[dbprefix]]point_groups` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]point_lead_action_log`
--
ALTER TABLE `[[dbprefix]]point_lead_action_log`
  ADD CONSTRAINT `FK_16C00E6255458D` FOREIGN KEY (`lead_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_16C00E62A03F5E9F` FOREIGN KEY (`ip_id`) REFERENCES `[[dbprefix]]ip_addresses` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_16C00E62C028CEA2` FOREIGN KEY (`point_id`) REFERENCES `[[dbprefix]]points` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]point_lead_event_log`
--
ALTER TABLE `[[dbprefix]]point_lead_event_log`
  ADD CONSTRAINT `FK_4ACC277055458D` FOREIGN KEY (`lead_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_4ACC277071F7E88B` FOREIGN KEY (`event_id`) REFERENCES `[[dbprefix]]point_trigger_events` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_4ACC2770A03F5E9F` FOREIGN KEY (`ip_id`) REFERENCES `[[dbprefix]]ip_addresses` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]point_triggers`
--
ALTER TABLE `[[dbprefix]]point_triggers`
  ADD CONSTRAINT `FK_AE2FAB8812469DE2` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]categories` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_AE2FAB88FE54D947` FOREIGN KEY (`group_id`) REFERENCES `[[dbprefix]]point_groups` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]point_trigger_events`
--
ALTER TABLE `[[dbprefix]]point_trigger_events`
  ADD CONSTRAINT `FK_8539F3925FDDDCD6` FOREIGN KEY (`trigger_id`) REFERENCES `[[dbprefix]]point_triggers` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]push_ids`
--
ALTER TABLE `[[dbprefix]]push_ids`
  ADD CONSTRAINT `FK_73026E0255458D` FOREIGN KEY (`lead_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]push_notifications`
--
ALTER TABLE `[[dbprefix]]push_notifications`
  ADD CONSTRAINT `FK_46FD6AD412469DE2` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]categories` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]push_notification_list_xref`
--
ALTER TABLE `[[dbprefix]]push_notification_list_xref`
  ADD CONSTRAINT `FK_A0269247B9FC8874` FOREIGN KEY (`leadlist_id`) REFERENCES `[[dbprefix]]lead_lists` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_A0269247EF1A9D84` FOREIGN KEY (`notification_id`) REFERENCES `[[dbprefix]]push_notifications` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]push_notification_stats`
--
ALTER TABLE `[[dbprefix]]push_notification_stats`
  ADD CONSTRAINT `FK_14F864193DAE168B` FOREIGN KEY (`list_id`) REFERENCES `[[dbprefix]]lead_lists` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_14F8641955458D` FOREIGN KEY (`lead_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_14F86419A03F5E9F` FOREIGN KEY (`ip_id`) REFERENCES `[[dbprefix]]ip_addresses` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_14F86419EF1A9D84` FOREIGN KEY (`notification_id`) REFERENCES `[[dbprefix]]push_notifications` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]reports_schedulers`
--
ALTER TABLE `[[dbprefix]]reports_schedulers`
  ADD CONSTRAINT `FK_DA2AB2234BD2A4C0` FOREIGN KEY (`report_id`) REFERENCES `[[dbprefix]]reports` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]sms_messages`
--
ALTER TABLE `[[dbprefix]]sms_messages`
  ADD CONSTRAINT `FK_1ADA172C12469DE2` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]categories` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]sms_message_list_xref`
--
ALTER TABLE `[[dbprefix]]sms_message_list_xref`
  ADD CONSTRAINT `FK_CB0BB81AB9FC8874` FOREIGN KEY (`leadlist_id`) REFERENCES `[[dbprefix]]lead_lists` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_CB0BB81ABD5C7E60` FOREIGN KEY (`sms_id`) REFERENCES `[[dbprefix]]sms_messages` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]sms_message_stats`
--
ALTER TABLE `[[dbprefix]]sms_message_stats`
  ADD CONSTRAINT `FK_DEE545F93DAE168B` FOREIGN KEY (`list_id`) REFERENCES `[[dbprefix]]lead_lists` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_DEE545F955458D` FOREIGN KEY (`lead_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_DEE545F9A03F5E9F` FOREIGN KEY (`ip_id`) REFERENCES `[[dbprefix]]ip_addresses` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_DEE545F9BD5C7E60` FOREIGN KEY (`sms_id`) REFERENCES `[[dbprefix]]sms_messages` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]stages`
--
ALTER TABLE `[[dbprefix]]stages`
  ADD CONSTRAINT `FK_348FF7D212469DE2` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]categories` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]stage_lead_action_log`
--
ALTER TABLE `[[dbprefix]]stage_lead_action_log`
  ADD CONSTRAINT `FK_DE3FEB8A2298D193` FOREIGN KEY (`stage_id`) REFERENCES `[[dbprefix]]stages` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_DE3FEB8A55458D` FOREIGN KEY (`lead_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_DE3FEB8AA03F5E9F` FOREIGN KEY (`ip_id`) REFERENCES `[[dbprefix]]ip_addresses` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]tweets`
--
ALTER TABLE `[[dbprefix]]tweets`
  ADD CONSTRAINT `FK_B115DD9312469DE2` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]categories` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_B115DD935DA1941` FOREIGN KEY (`asset_id`) REFERENCES `[[dbprefix]]assets` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_B115DD93C4663E4` FOREIGN KEY (`page_id`) REFERENCES `[[dbprefix]]pages` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]tweet_stats`
--
ALTER TABLE `[[dbprefix]]tweet_stats`
  ADD CONSTRAINT `FK_828260011041E39B` FOREIGN KEY (`tweet_id`) REFERENCES `[[dbprefix]]tweets` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_8282600155458D` FOREIGN KEY (`lead_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]users`
--
ALTER TABLE `[[dbprefix]]users`
  ADD CONSTRAINT `FK_38BB68BCD60322AC` FOREIGN KEY (`role_id`) REFERENCES `[[dbprefix]]roles` (`id`);

--
-- Constraints for table `[[dbprefix]]user_tokens`
--
ALTER TABLE `[[dbprefix]]user_tokens`
  ADD CONSTRAINT `FK_8606D057A76ED395` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]video_hits`
--
ALTER TABLE `[[dbprefix]]video_hits`
  ADD CONSTRAINT `FK_7A85981155458D` FOREIGN KEY (`lead_id`) REFERENCES `[[dbprefix]]leads` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_7A859811A03F5E9F` FOREIGN KEY (`ip_id`) REFERENCES `[[dbprefix]]ip_addresses` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]webhooks`
--
ALTER TABLE `[[dbprefix]]webhooks`
  ADD CONSTRAINT `FK_A5ADB23712469DE2` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]categories` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]webhook_events`
--
ALTER TABLE `[[dbprefix]]webhook_events`
  ADD CONSTRAINT `FK_485036905C9BA60B` FOREIGN KEY (`webhook_id`) REFERENCES `[[dbprefix]]webhooks` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]webhook_logs`
--
ALTER TABLE `[[dbprefix]]webhook_logs`
  ADD CONSTRAINT `FK_E28D7BFC5C9BA60B` FOREIGN KEY (`webhook_id`) REFERENCES `[[dbprefix]]webhooks` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]webhook_queue`
--
ALTER TABLE `[[dbprefix]]webhook_queue`
  ADD CONSTRAINT `FK_A939DE365C9BA60B` FOREIGN KEY (`webhook_id`) REFERENCES `[[dbprefix]]webhooks` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_A939DE3671F7E88B` FOREIGN KEY (`event_id`) REFERENCES `[[dbprefix]]webhook_events` (`id`) ON DELETE CASCADE;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
