@php
$randId = 'shpr'.md5($this->moduleId . $this->moduleType);
@endphp
<div wire:ignore>
    <div class="my-4">
        <div class="mb-2">
            <label> {{_e('Price range')}}</label>
        </div>
        <div class="form-range mt-1" id="js-shop-price-range-{{$randId}}"></div>
       <div class="mt-4">

           <div>
               <label>{{_e('From')}}</label>
               <div class="input-group">
                   <span class="input-group-text">$</span>
                   <input type="text" class="form-control"  wire:model="priceFrom" id="js-shop-price-range-from-{{$randId}}" aria-label="Amount (to the nearest dollar)">
               </div>
           </div>
           <div>
               <label>{{_e('To')}}</label>
               <div class="input-group">
                   <span class="input-group-text">$</span>
                   <input type="text" class="form-control" wire:model="priceTo" id="js-shop-price-range-to-{{$randId}}" aria-label="Amount (to the nearest dollar)">
               </div>
           </div>
       </div>
    </div>

    @include('microweber-module-shop::livewire.shop.filters.price_range.script', [
     'randId' => $randId,
     'minPrice' => $minPrice,
     'maxPrice' => $maxPrice,
     'priceFrom' => $priceFrom,
     'priceTo' => $priceTo,
     'filteredPriceFrom'=>$filteredPriceFrom,
     'filteredPriceTo'=>$filteredPriceTo,
     'filteredMinPrice'=>$filteredMinPrice,
     'filteredMaxPrice'=>$filteredMaxPrice,
     'priceRangeElement'=> 'js-shop-price-range-'.$randId,
     'priceFromElementId' => 'js-shop-price-range-from-'.$randId,
     'priceToElementId' => 'js-shop-price-range-to-'.$randId,
 ])

</div>
