
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `microweber2019`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]addresses`
--

CREATE TABLE `[[dbprefix]]addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address_street_1` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address_street_2` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `city` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `state` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `country_id` int(10) unsigned DEFAULT NULL,
  `zip` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fax` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_id` int(10) unsigned DEFAULT NULL,
  `company_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `company_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `company_vat` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `company_vat_registered` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]attributes`
--

CREATE TABLE `[[dbprefix]]attributes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` text COLLATE utf8_unicode_ci,
  `attribute_value` longtext COLLATE utf8_unicode_ci,
  `rel_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rel_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `attribute_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `session_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `edited_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cart`
--

CREATE TABLE `[[dbprefix]]cart` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` longtext COLLATE utf8_unicode_ci,
  `is_active` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `price` double(8,2) DEFAULT NULL,
  `currency` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `session_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `other_info` longtext COLLATE utf8_unicode_ci,
  `order_completed` int(11) DEFAULT NULL,
  `order_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `skip_promo_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `custom_fields_data` longtext COLLATE utf8_unicode_ci,
  `custom_fields_json` longtext COLLATE utf8_unicode_ci,
  `item_image` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `link` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cart_coupons`
--

CREATE TABLE `[[dbprefix]]cart_coupons` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `coupon_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `coupon_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `discount_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `discount_value` int(11) DEFAULT NULL,
  `total_amount` int(11) DEFAULT NULL,
  `uses_per_coupon` int(11) DEFAULT NULL,
  `uses_per_customer` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cart_coupon_logs`
--

CREATE TABLE `[[dbprefix]]cart_coupon_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `coupon_id` int(11) DEFAULT NULL,
  `customer_email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `coupon_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_ip` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `uses_count` int(11) DEFAULT NULL,
  `use_date` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cart_orders`
--

CREATE TABLE `[[dbprefix]]cart_orders` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `updated_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `order_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `amount` double(8,2) DEFAULT NULL,
  `transaction_id` longtext COLLATE utf8_unicode_ci,
  `shipping_service` longtext COLLATE utf8_unicode_ci,
  `shipping` double(8,2) DEFAULT NULL,
  `currency` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `currency_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `first_name` longtext COLLATE utf8_unicode_ci,
  `last_name` longtext COLLATE utf8_unicode_ci,
  `email` longtext COLLATE utf8_unicode_ci,
  `country` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `city` text COLLATE utf8_unicode_ci,
  `state` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `zip` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address` longtext COLLATE utf8_unicode_ci,
  `address2` longtext COLLATE utf8_unicode_ci,
  `phone` text COLLATE utf8_unicode_ci,
  `created_by` int(11) DEFAULT NULL,
  `edited_by` int(11) DEFAULT NULL,
  `session_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `order_completed` int(11) DEFAULT NULL,
  `is_paid` int(11) DEFAULT NULL,
  `url` text COLLATE utf8_unicode_ci,
  `user_ip` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `items_count` int(11) DEFAULT NULL,
  `custom_fields_data` longtext COLLATE utf8_unicode_ci,
  `payment_gw` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment_verify_token` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment_amount` double(8,2) DEFAULT NULL,
  `payment_currency` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment_status` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment_email` text COLLATE utf8_unicode_ci,
  `payment_receiver_email` text COLLATE utf8_unicode_ci,
  `payment_name` text COLLATE utf8_unicode_ci,
  `payment_country` text COLLATE utf8_unicode_ci,
  `payment_address` text COLLATE utf8_unicode_ci,
  `payment_city` text COLLATE utf8_unicode_ci,
  `payment_state` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment_zip` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment_phone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payer_id` text COLLATE utf8_unicode_ci,
  `payer_status` text COLLATE utf8_unicode_ci,
  `payment_type` text COLLATE utf8_unicode_ci,
  `payment_data` longtext COLLATE utf8_unicode_ci,
  `order_status` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment_shipping` double(8,2) DEFAULT NULL,
  `is_active` int(11) DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `price` double(8,2) DEFAULT NULL,
  `other_info` longtext COLLATE utf8_unicode_ci,
  `promo_code` longtext COLLATE utf8_unicode_ci,
  `skip_promo_code` int(11) DEFAULT NULL,
  `coupon_id` int(11) DEFAULT NULL,
  `discount_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `discount_value` double(8,2) DEFAULT NULL,
  `taxes_amount` double(8,2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cart_shipping`
--

CREATE TABLE `[[dbprefix]]cart_shipping` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `updated_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `is_active` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shipping_cost` double(8,2) DEFAULT NULL,
  `shipping_cost_max` double(8,2) DEFAULT NULL,
  `shipping_cost_above` double(8,2) DEFAULT NULL,
  `shipping_country` longtext COLLATE utf8_unicode_ci,
  `position` int(11) DEFAULT NULL,
  `shipping_type` longtext COLLATE utf8_unicode_ci,
  `shipping_price_per_size` double(8,2) DEFAULT NULL,
  `shipping_price_per_weight` double(8,2) DEFAULT NULL,
  `shipping_price_per_item` double(8,2) DEFAULT NULL,
  `shipping_price_custom` double(8,2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]cart_shipping`
--

INSERT INTO `[[dbprefix]]cart_shipping` VALUES
(1, '2023-10-18 12:27:38', NULL, '1', 0.00, NULL, NULL, 'Worldwide', NULL, 'fixed', NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]categories`
--

CREATE TABLE `[[dbprefix]]categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `updated_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `edited_by` int(11) DEFAULT NULL,
  `data_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `title` text COLLATE utf8_unicode_ci,
  `url` longtext COLLATE utf8_unicode_ci,
  `parent_id` int(11) DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `content` longtext COLLATE utf8_unicode_ci,
  `rel_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `position` int(11) DEFAULT NULL,
  `is_deleted` int(11) DEFAULT '0',
  `is_hidden` int(11) DEFAULT '0',
  `users_can_create_subcategories` int(11) DEFAULT NULL,
  `users_can_create_content` int(11) DEFAULT NULL,
  `users_can_create_content_allowed_usergroups` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `category_meta_title` text COLLATE utf8_unicode_ci,
  `category_meta_keywords` text COLLATE utf8_unicode_ci,
  `category_meta_description` text COLLATE utf8_unicode_ci,
  `category_subtype` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `category_subtype_settings` longtext COLLATE utf8_unicode_ci,
  `is_active` int(11) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]categories`
--

INSERT INTO `[[dbprefix]]categories` VALUES
(1, '[[regtime]]', '[[regtime]]', NULL, NULL, 'category', 'Category 1', 'category-1', 0, NULL, NULL, 'content', 3, 1, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'default', NULL, 1),
(2, '[[regtime]]', '[[regtime]]', NULL, NULL, 'category', 'Category 2', 'category-2', 0, NULL, NULL, 'content', 3, 2, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'default', NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]categories_items`
--

CREATE TABLE `[[dbprefix]]categories_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]categories_items`
--

INSERT INTO `[[dbprefix]]categories_items` VALUES
(1, 2, 'content', 6),
(2, 1, 'content', 7),
(3, 2, 'content', 9);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]comments`
--

CREATE TABLE `[[dbprefix]]comments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reply_to_comment_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rel_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `comment_name` text COLLATE utf8_unicode_ci,
  `comment_email` text COLLATE utf8_unicode_ci,
  `comment_website` text COLLATE utf8_unicode_ci,
  `comment_body` text COLLATE utf8_unicode_ci,
  `comment_subject` text COLLATE utf8_unicode_ci,
  `from_url` text COLLATE utf8_unicode_ci,
  `is_moderated` int(11) DEFAULT NULL,
  `is_spam` int(11) DEFAULT NULL,
  `is_new` int(11) DEFAULT NULL,
  `for_newsletter` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `edited_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `session_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user_ip` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]content`
--

CREATE TABLE `[[dbprefix]]content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `subtype` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `url` text COLLATE utf8_unicode_ci,
  `title` text COLLATE utf8_unicode_ci,
  `parent` int(11) DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `position` int(11) DEFAULT NULL,
  `content` longtext COLLATE utf8_unicode_ci,
  `content_body` longtext COLLATE utf8_unicode_ci,
  `is_active` int(11) DEFAULT '1',
  `subtype_value` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `custom_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `custom_type_value` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `active_site_template` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `layout_file` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `layout_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `layout_style` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `content_filename` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `original_link` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_home` int(11) DEFAULT '0',
  `is_pinged` int(11) DEFAULT '0',
  `is_shop` int(11) DEFAULT '0',
  `is_deleted` int(11) DEFAULT '0',
  `require_login` int(11) DEFAULT '0',
  `status` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `content_meta_title` text COLLATE utf8_unicode_ci,
  `content_meta_keywords` text COLLATE utf8_unicode_ci,
  `session_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `edited_by` int(11) DEFAULT NULL,
  `posted_at` datetime DEFAULT NULL,
  `draft_of` int(11) DEFAULT NULL,
  `copy_of` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]contentparent_index` (`parent`),
  KEY `[[dbprefix]]contentis_deleted_index` (`is_deleted`),
  KEY `[[dbprefix]]contentis_active_index` (`is_active`),
  KEY `[[dbprefix]]contentsubtype_index` (`subtype`),
  KEY `[[dbprefix]]contentcontent_type_index` (`content_type`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=12 ;

--
-- Dumping data for table `[[dbprefix]]content`
--

INSERT INTO `[[dbprefix]]content` VALUES
(1, 'page', 'static', 'home', 'Home', 0, NULL, 1, NULL, NULL, 1, NULL, NULL, NULL, NULL, 'index.php', NULL, NULL, NULL, NULL, 1, 0, 0, 0, 0, NULL, NULL, NULL, NULL, '2023-10-26 12:28:11', '2023-10-18 12:02:18', NULL, NULL, NULL, NULL, NULL, NULL),
(2, 'page', 'dynamic', 'blog', 'Blog', 0, NULL, 2, NULL, NULL, 1, NULL, NULL, NULL, NULL, 'layouts__blog.php', NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, NULL, NULL, NULL, NULL, '2023-10-26 12:27:50', '2023-10-18 12:04:36', NULL, NULL, NULL, NULL, NULL, NULL),
(3, 'page', 'dynamic', 'shop', 'Shop', 0, NULL, 3, NULL, NULL, 1, NULL, NULL, NULL, NULL, 'layouts__shop.php', NULL, NULL, NULL, NULL, 0, 0, 1, 0, 0, NULL, NULL, NULL, NULL, '2023-10-26 12:27:32', '2023-10-18 12:05:12', NULL, NULL, NULL, NULL, NULL, NULL),
(4, 'page', 'static', 'contact-us', 'Contact us', 0, NULL, 4, NULL, NULL, 1, NULL, NULL, NULL, NULL, 'layouts__contact_us.php', NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, NULL, NULL, NULL, NULL, '2023-10-26 12:27:09', '2023-10-18 12:07:47', NULL, NULL, NULL, NULL, NULL, NULL),
(5, 'post', 'post', 'my-blog-post', 'Story Title', 2, NULL, 5, '<p style="border:0px solid rgb(217,217,227);margin-bottom:1.25em;"><img alt="{SITE_URL}userfiles/media/default/gallery-1-1.jpg" src="{SITE_URL}userfiles/media/default/gallery-1-1.jpg" class="element" /><br /><br />Once upon a time, in the vast expanse of the universe, there existed a star named Sol. Sol was an ordinary star, but it held a secret that would change the course of the cosmos. Around Sol, there were several planets, but one of them stood out from the rest – Earth.</p><p style="border:0px solid rgb(217,217,227);margin-top:1.25em;margin-bottom:1.25em;">On Earth, life had flourished for billions of years, evolving from single-celled organisms to complex, intelligent beings. These beings were humans, and they were curious creatures, constantly looking to the sky and wondering about the mysteries of the universe.</p><p style="border:0px solid rgb(217,217,227);margin-top:1.25em;margin-bottom:1.25em;">One day, a brilliant scientist named Dr. Amelia Grayson stood in her observatory, peering through a massive telescope. She had dedicated her life to studying the cosmos and had made a remarkable discovery. Dr. Grayson had found evidence of a wormhole, a portal to other galaxies. It was a phenomenon that had long been theorized but never proven.</p><p style="border:0px solid rgb(217,217,227);margin-top:1.25em;margin-bottom:1.25em;">Excited by her discovery, Dr. Grayson gathered a team of brilliant scientists, engineers, and explorers to build a spacecraft capable of traveling through the wormhole. They named it "Stellar Voyager."</p><p style="border:0px solid rgb(217,217,227);margin-top:1.25em;margin-bottom:1.25em;">As the Stellar Voyager prepared for its maiden voyage, humanity watched with bated breath. The momentous day arrived when the spaceship was ready. Dr. Grayson and her crew boarded the vessel, and with a flash of light, the Stellar Voyager entered the wormhole.</p><p style="border:0px solid rgb(217,217,227);margin-top:1.25em;margin-bottom:1.25em;">Inside the wormhole, the laws of physics bent and twisted, and the crew felt as if they were traveling through a kaleidoscope of colors and shapes. After what felt like an eternity, they emerged on the other side, in a distant galaxy they had never seen before.</p><p style="border:0px solid rgb(217,217,227);margin-top:1.25em;margin-bottom:1.25em;">The galaxy was filled with breathtaking celestial wonders. They encountered alien species, made friends with some, and faced challenges with others. Together, they explored strange new worlds, discovered new forms of life, and uncovered the mysteries of the universe.</p><p style="border:0px solid rgb(217,217,227);margin-top:1.25em;margin-bottom:1.25em;">But the most profound revelation came when they met a highly advanced alien civilization. These beings had harnessed the power of love and compassion to create a harmonious society. They shared their wisdom and knowledge with the crew, teaching them the true interconnectedness of all life in the universe.</p><p style="border:0px solid rgb(217,217,227);margin-top:1.25em;margin-bottom:1.25em;">Dr. Grayson and her team returned to Earth profoundly changed by their journey. They brought back not only scientific knowledge but also a newfound sense of unity and empathy for all living beings. The story of their voyage through the wormhole spread across the planet, inspiring humanity to come together in pursuit of a more enlightened and peaceful future.</p><p style="border:0px solid rgb(217,217,227);margin-top:1.25em;margin-bottom:0px;">And so, the tale of the universe continued, with Earth now playing a role in the greater cosmic drama. It was a reminder that the universe is a vast, interconnected web of life, and every being, no matter how small or insignificant, is an integral part of its grand tapestry.</p>', NULL, 1, NULL, NULL, NULL, NULL, 'inherit', NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, NULL, NULL, NULL, NULL, '2023-10-23 13:14:14', '2023-10-18 12:08:05', NULL, NULL, NULL, NULL, NULL, NULL),
(6, 'product', 'product', 'example-product', 'Example Product two', 3, NULL, 6, NULL, NULL, 1, NULL, NULL, NULL, NULL, 'inherit', NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, NULL, NULL, NULL, NULL, '2023-10-23 12:58:43', '2023-10-18 12:08:26', NULL, NULL, NULL, NULL, NULL, NULL),
(7, 'product', 'product', 'example-product20231018122854', 'Example product one', 3, NULL, 7, NULL, NULL, 1, NULL, NULL, NULL, NULL, 'inherit', NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, NULL, NULL, NULL, NULL, '2023-10-23 12:57:25', '2023-10-18 12:28:54', NULL, NULL, NULL, NULL, NULL, NULL),
(9, 'product', 'product', 'another-new-product', 'Another new product', 3, NULL, 8, NULL, NULL, 1, NULL, NULL, NULL, NULL, 'inherit', NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, NULL, NULL, NULL, NULL, '2023-10-24 07:43:23', '2023-10-23 13:01:33', NULL, NULL, NULL, NULL, NULL, NULL),
(10, 'post', 'post', 'my-blog-post-1', 'Story Title Two', 2, NULL, 9, '<p style="border:0px solid rgb(217,217,227);margin-bottom:1.25em;"><img alt="{SITE_URL}userfiles/media/default/gallery-1-15.jpg" src="{SITE_URL}userfiles/media/default/gallery-1-15.jpg" class="element" /><br /><br />Once upon a time, in the vast expanse of the universe, there existed a star named Sol. Sol was an ordinary star, but it held a secret that would change the course of the cosmos. Around Sol, there were several planets, but one of them stood out from the rest – Earth.</p><p style="border:0px solid rgb(217,217,227);margin-top:1.25em;margin-bottom:1.25em;">On Earth, life had flourished for billions of years, evolving from single-celled organisms to complex, intelligent beings. These beings were humans, and they were curious creatures, constantly looking to the sky and wondering about the mysteries of the universe.</p><p style="border:0px solid rgb(217,217,227);margin-top:1.25em;margin-bottom:1.25em;">One day, a brilliant scientist named Dr. Amelia Grayson stood in her observatory, peering through a massive telescope. She had dedicated her life to studying the cosmos and had made a remarkable discovery. Dr. Grayson had found evidence of a wormhole, a portal to other galaxies. It was a phenomenon that had long been theorized but never proven.</p><p style="border:0px solid rgb(217,217,227);margin-top:1.25em;margin-bottom:1.25em;">Excited by her discovery, Dr. Grayson gathered a team of brilliant scientists, engineers, and explorers to build a spacecraft capable of traveling through the wormhole. They named it "Stellar Voyager."</p><p style="border:0px solid rgb(217,217,227);margin-top:1.25em;margin-bottom:1.25em;">As the Stellar Voyager prepared for its maiden voyage, humanity watched with bated breath. The momentous day arrived when the spaceship was ready. Dr. Grayson and her crew boarded the vessel, and with a flash of light, the Stellar Voyager entered the wormhole.</p><p style="border:0px solid rgb(217,217,227);margin-top:1.25em;margin-bottom:1.25em;">Inside the wormhole, the laws of physics bent and twisted, and the crew felt as if they were traveling through a kaleidoscope of colors and shapes. After what felt like an eternity, they emerged on the other side, in a distant galaxy they had never seen before.</p><p style="border:0px solid rgb(217,217,227);margin-top:1.25em;margin-bottom:1.25em;">The galaxy was filled with breathtaking celestial wonders. They encountered alien species, made friends with some, and faced challenges with others. Together, they explored strange new worlds, discovered new forms of life, and uncovered the mysteries of the universe.</p><p style="border:0px solid rgb(217,217,227);margin-top:1.25em;margin-bottom:1.25em;">But the most profound revelation came when they met a highly advanced alien civilization. These beings had harnessed the power of love and compassion to create a harmonious society. They shared their wisdom and knowledge with the crew, teaching them the true interconnectedness of all life in the universe.</p><p style="border:0px solid rgb(217,217,227);margin-top:1.25em;margin-bottom:1.25em;">Dr. Grayson and her team returned to Earth profoundly changed by their journey. They brought back not only scientific knowledge but also a newfound sense of unity and empathy for all living beings. The story of their voyage through the wormhole spread across the planet, inspiring humanity to come together in pursuit of a more enlightened and peaceful future.</p><p style="border:0px solid rgb(217,217,227);margin-top:1.25em;margin-bottom:0px;">And so, the tale of the universe continued, with Earth now playing a role in the greater cosmic drama. It was a reminder that the universe is a vast, interconnected web of life, and every being, no matter how small or insignificant, is an integral part of its grand tapestry.</p>', NULL, 1, NULL, NULL, NULL, NULL, 'inherit', NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, NULL, NULL, NULL, NULL, '2023-10-23 13:13:29', '2023-10-18 12:08:05', NULL, NULL, NULL, NULL, NULL, NULL),
(11, 'post', 'post', 'my-blog-post-1-1', 'Story Title Three', 2, NULL, 10, '<p style="border:0px solid rgb(217,217,227);margin-bottom:1.25em;" class="element"><img id="mw-image-1698066708825" alt="{SITE_URL}userfiles/media/default/gallery-1-7.jpg" src="{SITE_URL}userfiles/media/default/gallery-1-7.jpg" class="element"><br><br>Once upon a time, in the vast expanse of the universe, there existed a star named Sol. Sol was an ordinary star, but it held a secret that would change the course of the cosmos. Around Sol, there were several planets, but one of them stood out from the rest – Earth.</p><p style="border:0px solid rgb(217,217,227);margin-top:1.25em;margin-bottom:1.25em;" class="element">On Earth, life had flourished for billions of years, evolving from single-celled organisms to complex, intelligent beings. These beings were humans, and they were curious creatures, constantly looking to the sky and wondering about the mysteries of the universe.</p><p style="border:0px solid rgb(217,217,227);margin-top:1.25em;margin-bottom:1.25em;" class="element">One day, a brilliant scientist named Dr. Amelia Grayson stood in her observatory, peering through a massive telescope. She had dedicated her life to studying the cosmos and had made a remarkable discovery. Dr. Grayson had found evidence of a wormhole, a portal to other galaxies. It was a phenomenon that had long been theorized but never proven.</p><p style="border:0px solid rgb(217,217,227);margin-top:1.25em;margin-bottom:1.25em;" class="element">Excited by her discovery, Dr. Grayson gathered a team of brilliant scientists, engineers, and explorers to build a spacecraft capable of traveling through the wormhole. They named it "Stellar Voyager."</p><p style="border:0px solid rgb(217,217,227);margin-top:1.25em;margin-bottom:1.25em;" class="element">As the Stellar Voyager prepared for its maiden voyage, humanity watched with bated breath. The momentous day arrived when the spaceship was ready. Dr. Grayson and her crew boarded the vessel, and with a flash of light, the Stellar Voyager entered the wormhole.</p><p style="border:0px solid rgb(217,217,227);margin-top:1.25em;margin-bottom:1.25em;" class="element">Inside the wormhole, the laws of physics bent and twisted, and the crew felt as if they were traveling through a kaleidoscope of colors and shapes. After what felt like an eternity, they emerged on the other side, in a distant galaxy they had never seen before.</p><p style="border:0px solid rgb(217,217,227);margin-top:1.25em;margin-bottom:1.25em;" class="element">The galaxy was filled with breathtaking celestial wonders. They encountered alien species, made friends with some, and faced challenges with others. Together, they explored strange new worlds, discovered new forms of life, and uncovered the mysteries of the universe.</p><p style="border:0px solid rgb(217,217,227);margin-top:1.25em;margin-bottom:1.25em;" class="element">But the most profound revelation came when they met a highly advanced alien civilization. These beings had harnessed the power of love and compassion to create a harmonious society. They shared their wisdom and knowledge with the crew, teaching them the true interconnectedness of all life in the universe.</p><p style="border:0px solid rgb(217,217,227);margin-top:1.25em;margin-bottom:1.25em;" class="element">Dr. Grayson and her team returned to Earth profoundly changed by their journey. They brought back not only scientific knowledge but also a newfound sense of unity and empathy for all living beings. The story of their voyage through the wormhole spread across the planet, inspiring humanity to come together in pursuit of a more enlightened and peaceful future.</p><p style="border:0px solid rgb(217,217,227);margin-top:1.25em;margin-bottom:0px;" class="element">And so, the tale of the universe continued, with Earth now playing a role in the greater cosmic drama. It was a reminder that the universe is a vast, interconnected web of life, and every being, no matter how small or insignificant, is an integral part of its grand tapestry.</p>', NULL, 1, NULL, NULL, NULL, NULL, 'inherit', NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, NULL, NULL, NULL, NULL, '2023-10-23 13:12:11', '2023-10-18 12:08:05', NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]content_data`
--

CREATE TABLE `[[dbprefix]]content_data` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `updated_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `edited_by` int(11) DEFAULT NULL,
  `field_name` text COLLATE utf8_unicode_ci,
  `field_value` longtext COLLATE utf8_unicode_ci,
  `rel_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rel_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]content_data_rel_type_index` (`rel_type`),
  KEY `[[dbprefix]]content_data_rel_id_index` (`rel_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=31 ;

--
-- Dumping data for table `[[dbprefix]]content_data`
--

INSERT INTO `[[dbprefix]]content_data` VALUES
(1, '2023-10-23 13:20:02', '2023-10-18 12:08:27', 1, 1, 'has_special_price', '1', 'content', '6'),
(2, '2023-10-23 13:20:02', '2023-10-18 12:08:27', 1, 1, 'special_price', '10.90', 'content', '6'),
(3, '2023-10-18 12:08:27', '2023-10-18 12:08:27', 1, 1, 'sku', NULL, 'content', '6'),
(4, '2023-10-18 12:08:27', '2023-10-18 12:08:27', 1, 1, 'barcode', NULL, 'content', '6'),
(5, '2023-10-18 12:08:27', '2023-10-18 12:08:27', 1, 1, 'shipping_fixed_cost', NULL, 'content', '6'),
(6, '2023-10-18 12:08:27', '2023-10-18 12:08:27', 1, 1, 'weight', NULL, 'content', '6'),
(7, '2023-10-18 12:08:27', '2023-10-18 12:08:27', 1, 1, 'weight_type', 'kg', 'content', '6'),
(8, '2023-10-18 12:08:27', '2023-10-18 12:08:27', 1, 1, 'width', NULL, 'content', '6'),
(9, '2023-10-18 12:08:28', '2023-10-18 12:08:28', 1, 1, 'height', NULL, 'content', '6'),
(10, '2023-10-18 12:08:28', '2023-10-18 12:08:28', 1, 1, 'depth', NULL, 'content', '6'),
(11, '2023-10-18 12:28:55', '2023-10-18 12:28:55', 1, 1, 'has_special_price', '0', 'content', '7'),
(12, '2023-10-18 12:28:55', '2023-10-18 12:28:55', 1, 1, 'special_price', NULL, 'content', '7'),
(13, '2023-10-18 12:28:55', '2023-10-18 12:28:55', 1, 1, 'sku', NULL, 'content', '7'),
(14, '2023-10-18 12:28:55', '2023-10-18 12:28:55', 1, 1, 'barcode', NULL, 'content', '7'),
(15, '2023-10-18 12:28:55', '2023-10-18 12:28:55', 1, 1, 'shipping_fixed_cost', NULL, 'content', '7'),
(16, '2023-10-18 12:28:55', '2023-10-18 12:28:55', 1, 1, 'weight', NULL, 'content', '7'),
(17, '2023-10-18 12:28:55', '2023-10-18 12:28:55', 1, 1, 'weight_type', 'kg', 'content', '7'),
(18, '2023-10-18 12:28:56', '2023-10-18 12:28:56', 1, 1, 'width', NULL, 'content', '7'),
(19, '2023-10-18 12:28:56', '2023-10-18 12:28:56', 1, 1, 'height', NULL, 'content', '7'),
(20, '2023-10-18 12:28:56', '2023-10-18 12:28:56', 1, 1, 'depth', NULL, 'content', '7'),
(21, '2023-10-23 13:01:33', '2023-10-23 13:01:33', 1, 1, 'has_special_price', '0', 'content', '9'),
(22, '2023-10-23 13:01:33', '2023-10-23 13:01:33', 1, 1, 'special_price', NULL, 'content', '9'),
(23, '2023-10-23 13:01:33', '2023-10-23 13:01:33', 1, 1, 'sku', NULL, 'content', '9'),
(24, '2023-10-23 13:01:33', '2023-10-23 13:01:33', 1, 1, 'barcode', NULL, 'content', '9'),
(25, '2023-10-23 13:01:33', '2023-10-23 13:01:33', 1, 1, 'shipping_fixed_cost', NULL, 'content', '9'),
(26, '2023-10-23 13:01:33', '2023-10-23 13:01:33', 1, 1, 'weight', NULL, 'content', '9'),
(27, '2023-10-23 13:01:33', '2023-10-23 13:01:33', 1, 1, 'weight_type', 'kg', 'content', '9'),
(28, '2023-10-23 13:01:33', '2023-10-23 13:01:33', 1, 1, 'width', NULL, 'content', '9'),
(29, '2023-10-23 13:01:33', '2023-10-23 13:01:33', 1, 1, 'height', NULL, 'content', '9'),
(30, '2023-10-23 13:01:33', '2023-10-23 13:01:33', 1, 1, 'depth', NULL, 'content', '9');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]content_data_variants`
--

CREATE TABLE `[[dbprefix]]content_data_variants` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `custom_field_id` int(11) DEFAULT NULL,
  `custom_field_value_id` int(11) DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` text COLLATE utf8_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]content_fields`
--

CREATE TABLE `[[dbprefix]]content_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `updated_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `edited_by` int(11) DEFAULT NULL,
  `rel_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rel_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `field` text COLLATE utf8_unicode_ci,
  `value` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]content_fields`
--

INSERT INTO `[[dbprefix]]content_fields` VALUES
(4, '2023-10-25 12:30:12', '2023-10-25 12:30:12', 1, 1, 'module', '0', 'layout-footer-skin-19-p-footer-layout', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]content_fields_drafts`
--

CREATE TABLE `[[dbprefix]]content_fields_drafts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `updated_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `edited_by` int(11) DEFAULT NULL,
  `rel_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rel_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `field` text COLLATE utf8_unicode_ci,
  `value` longtext COLLATE utf8_unicode_ci,
  `session_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_temp` int(11) DEFAULT NULL,
  `url` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]content_related`
--

CREATE TABLE `[[dbprefix]]content_related` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content_id` int(11) DEFAULT NULL,
  `related_content_id` int(11) DEFAULT NULL,
  `position` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]content_revisions_history`
--

CREATE TABLE `[[dbprefix]]content_revisions_history` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `rel_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rel_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `field` text COLLATE utf8_unicode_ci,
  `value` longtext COLLATE utf8_unicode_ci,
  `updated_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `edited_by` int(11) DEFAULT NULL,
  `user_ip` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `checksum` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `session_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `url` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]countries`
--

CREATE TABLE `[[dbprefix]]countries` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phonecode` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]countries_id_index` (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=260 ;

--
-- Dumping data for table `[[dbprefix]]countries`
--

INSERT INTO `[[dbprefix]]countries` VALUES
(1, 'AF', 'Afghanistan', 93),
(2, 'AX', 'Aland Islands', 358),
(3, 'AL', 'Albania', 355),
(4, 'DZ', 'Algeria', 213),
(5, 'AS', 'American Samoa', 1),
(6, 'AD', 'Andorra', 376),
(7, 'AO', 'Angola', 244),
(8, 'AI', 'Anguilla', 1),
(9, 'AQ', 'Antarctica', 672),
(10, 'AG', 'Antigua and Barbuda', 1),
(11, 'AR', 'Argentina', 54),
(12, 'AM', 'Armenia', 374),
(13, 'AW', 'Aruba', 297),
(14, 'AC', 'Ascension Island', 0),
(15, 'AU', 'Australia', 61),
(16, 'AT', 'Austria', 43),
(17, 'AZ', 'Azerbaijan', 994),
(18, 'BS', 'Bahamas', 1),
(19, 'BH', 'Bahrain', 973),
(20, 'BD', 'Bangladesh', 880),
(21, 'BB', 'Barbados', 1),
(22, 'BY', 'Belarus', 375),
(23, 'BE', 'Belgium', 32),
(24, 'BZ', 'Belize', 501),
(25, 'BJ', 'Benin', 229),
(26, 'BM', 'Bermuda', 1),
(27, 'BT', 'Bhutan', 975),
(28, 'BO', 'Bolivia', 591),
(29, 'BQ', 'Bonaire, Sint Eustatius, and Saba', 599),
(30, 'BA', 'Bosnia and Herzegovina', 387),
(31, 'BW', 'Botswana', 267),
(32, 'BV', 'Bouvet Island', 47),
(33, 'BR', 'Brazil', 55),
(34, 'IO', 'British Indian Ocean Territory', 246),
(35, 'VG', 'British Virgin Islands', 1),
(36, 'BN', 'Brunei', 673),
(37, 'BG', 'Bulgaria', 359),
(38, 'BF', 'Burkina Faso', 226),
(39, 'BI', 'Burundi', 257),
(40, 'KH', 'Cambodia', 855),
(41, 'CM', 'Cameroon', 237),
(42, 'CA', 'Canada', 1),
(43, 'IC', 'Canary Islands', 0),
(44, 'CV', 'Cape Verde', 238),
(45, 'KY', 'Cayman Islands', 1),
(46, 'CF', 'Central African Republic', 236),
(47, 'EA', 'Ceuta and Melilla', 0),
(48, 'TD', 'Chad', 235),
(49, 'CL', 'Chile', 56),
(50, 'CN', 'China', 86),
(51, 'CX', 'Christmas Island', 61),
(52, 'CP', 'Clipperton Island', 0),
(53, 'CC', 'Cocos [Keeling] Islands', 61),
(54, 'CO', 'Colombia', 57),
(55, 'KM', 'Comoros', 269),
(56, 'CG', 'Congo - Brazzaville', 242),
(57, 'CD', 'Congo - Kinshasa', 243),
(58, 'CK', 'Cook Islands', 682),
(59, 'CR', 'Costa Rica', 506),
(60, 'CI', 'Côte d’Ivoire', 225),
(61, 'HR', 'Croatia', 385),
(62, 'CU', 'Cuba', 53),
(63, 'CW', 'Curaçao', 599),
(64, 'CY', 'Cyprus', 357),
(65, 'CZ', 'Czech Republic', 420),
(66, 'DK', 'Denmark', 45),
(67, 'DG', 'Diego Garcia', 0),
(68, 'DJ', 'Djibouti', 253),
(69, 'DM', 'Dominica', 1),
(70, 'DO', 'Dominican Republic', 1),
(71, 'EC', 'Ecuador', 593),
(72, 'EG', 'Egypt', 20),
(73, 'SV', 'El Salvador', 503),
(74, 'GQ', 'Equatorial Guinea', 240),
(75, 'ER', 'Eritrea', 291),
(76, 'EE', 'Estonia', 372),
(77, 'ET', 'Ethiopia', 251),
(78, 'EU', 'European Union', 0),
(79, 'FK', 'Falkland Islands', 500),
(80, 'FO', 'Faroe Islands', 298),
(81, 'FJ', 'Fiji', 679),
(82, 'FI', 'Finland', 358),
(83, 'FR', 'France', 33),
(84, 'GF', 'French Guiana', 594),
(85, 'PF', 'French Polynesia', 689),
(86, 'TF', 'French Southern Territories', 262),
(87, 'GA', 'Gabon', 241),
(88, 'GM', 'Gambia', 220),
(89, 'GE', 'Georgia', 995),
(90, 'DE', 'Germany', 49),
(91, 'GH', 'Ghana', 233),
(92, 'GI', 'Gibraltar', 350),
(93, 'GR', 'Greece', 30),
(94, 'GL', 'Greenland', 299),
(95, 'GD', 'Grenada', 1),
(96, 'GP', 'Guadeloupe', 590),
(97, 'GU', 'Guam', 1),
(98, 'GT', 'Guatemala', 502),
(99, 'GG', 'Guernsey', 44),
(100, 'GN', 'Guinea', 224),
(101, 'GW', 'Guinea-Bissau', 245),
(102, 'GY', 'Guyana', 592),
(103, 'HT', 'Haiti', 509),
(104, 'HM', 'Heard Island and McDonald Islands', 672),
(105, 'HN', 'Honduras', 504),
(106, 'HK', 'Hong Kong SAR China', 852),
(107, 'HU', 'Hungary', 36),
(108, 'IS', 'Iceland', 354),
(109, 'IN', 'India', 91),
(110, 'ID', 'Indonesia', 62),
(111, 'IR', 'Iran', 98),
(112, 'IQ', 'Iraq', 964),
(113, 'IE', 'Ireland', 353),
(114, 'IM', 'Isle of Man', 44),
(115, 'IL', 'Israel', 972),
(116, 'IT', 'Italy', 39),
(117, 'JM', 'Jamaica', 1),
(118, 'JP', 'Japan', 81),
(119, 'JE', 'Jersey', 44),
(120, 'JO', 'Jordan', 962),
(121, 'KZ', 'Kazakhstan', 7),
(122, 'KE', 'Kenya', 254),
(123, 'KI', 'Kiribati', 686),
(124, 'KW', 'Kuwait', 965),
(125, 'KG', 'Kyrgyzstan', 996),
(126, 'LA', 'Laos', 856),
(127, 'LV', 'Latvia', 371),
(128, 'LB', 'Lebanon', 961),
(129, 'LS', 'Lesotho', 266),
(130, 'LR', 'Liberia', 231),
(131, 'LY', 'Libya', 218),
(132, 'LI', 'Liechtenstein', 423),
(133, 'LT', 'Lithuania', 370),
(134, 'LU', 'Luxembourg', 352),
(135, 'MO', 'Macau SAR China', 853),
(136, 'MK', 'Macedonia', 389),
(137, 'MG', 'Madagascar', 261),
(138, 'MW', 'Malawi', 265),
(139, 'MY', 'Malaysia', 60),
(140, 'MV', 'Maldives', 960),
(141, 'ML', 'Mali', 223),
(142, 'MT', 'Malta', 356),
(143, 'MH', 'Marshall Islands', 692),
(144, 'MQ', 'Martinique', 596),
(145, 'MR', 'Mauritania', 222),
(146, 'MU', 'Mauritius', 230),
(147, 'YT', 'Mayotte', 262),
(148, 'MX', 'Mexico', 52),
(149, 'FM', 'Micronesia', 691),
(150, 'MD', 'Moldova', 373),
(151, 'MC', 'Monaco', 377),
(152, 'MN', 'Mongolia', 976),
(153, 'ME', 'Montenegro', 382),
(154, 'MS', 'Montserrat', 1),
(155, 'MA', 'Morocco', 212),
(156, 'MZ', 'Mozambique', 258),
(157, 'MM', 'Myanmar [Burma]', 95),
(158, 'NA', 'Namibia', 264),
(159, 'NR', 'Nauru', 674),
(160, 'NP', 'Nepal', 977),
(161, 'NL', 'Netherlands', 31),
(162, 'AN', 'Netherlands Antilles', 599),
(163, 'NC', 'New Caledonia', 687),
(164, 'NZ', 'New Zealand', 64),
(165, 'NI', 'Nicaragua', 505),
(166, 'NE', 'Niger', 227),
(167, 'NG', 'Nigeria', 234),
(168, 'NU', 'Niue', 683),
(169, 'NF', 'Norfolk Island', 672),
(170, 'KP', 'North Korea', 850),
(171, 'MP', 'Northern Mariana Islands', 1),
(172, 'NO', 'Norway', 47),
(173, 'OM', 'Oman', 968),
(174, 'QO', 'Outlying Oceania', 0),
(175, 'PK', 'Pakistan', 92),
(176, 'PW', 'Palau', 680),
(177, 'PS', 'Palestinian Territories', 970),
(178, 'PA', 'Panama', 507),
(179, 'PG', 'Papua New Guinea', 675),
(180, 'PY', 'Paraguay', 595),
(181, 'PE', 'Peru', 51),
(182, 'PH', 'Philippines', 63),
(183, 'PN', 'Pitcairn Islands', 64),
(184, 'PL', 'Poland', 48),
(185, 'PT', 'Portugal', 351),
(186, 'PR', 'Puerto Rico', 1),
(187, 'QA', 'Qatar', 974),
(188, 'RE', 'Réunion', 262),
(189, 'RO', 'Romania', 40),
(190, 'RU', 'Russia', 7),
(191, 'RW', 'Rwanda', 250),
(192, 'BL', 'Saint Barthélemy', 590),
(193, 'SH', 'Saint Helena', 290),
(194, 'KN', 'Saint Kitts and Nevis', 1),
(195, 'LC', 'Saint Lucia', 1),
(196, 'MF', 'Saint Martin', 590),
(197, 'PM', 'Saint Pierre and Miquelon', 508),
(198, 'VC', 'Saint Vincent and the Grenadines', 1),
(199, 'WS', 'Samoa', 685),
(200, 'SM', 'San Marino', 378),
(201, 'ST', 'São Tomé and Príncipe', 239),
(202, 'SA', 'Saudi Arabia', 966),
(203, 'SN', 'Senegal', 221),
(204, 'RS', 'Serbia', 381),
(205, 'CS', 'Serbia and Montenegro', 0),
(206, 'SC', 'Seychelles', 248),
(207, 'SL', 'Sierra Leone', 232),
(208, 'SG', 'Singapore', 65),
(209, 'SX', 'Sint Maarten', 1),
(210, 'SK', 'Slovakia', 421),
(211, 'SI', 'Slovenia', 386),
(212, 'SB', 'Solomon Islands', 677),
(213, 'SO', 'Somalia', 252),
(214, 'ZA', 'South Africa', 27),
(215, 'GS', 'South Georgia and the South Sandwich Islands', 500),
(216, 'KR', 'South Korea', 82),
(217, 'SS', 'South Sudan', 211),
(218, 'ES', 'Spain', 34),
(219, 'LK', 'Sri Lanka', 94),
(220, 'SD', 'Sudan', 249),
(221, 'SR', 'Suriname', 597),
(222, 'SJ', 'Svalbard and Jan Mayen', 47),
(223, 'SZ', 'Swaziland', 268),
(224, 'SE', 'Sweden', 46),
(225, 'CH', 'Switzerland', 41),
(226, 'SY', 'Syria', 963),
(227, 'TW', 'Taiwan', 886),
(228, 'TJ', 'Tajikistan', 992),
(229, 'TZ', 'Tanzania', 255),
(230, 'TH', 'Thailand', 66),
(231, 'TL', 'Timor-Leste', 670),
(232, 'TG', 'Togo', 228),
(233, 'TK', 'Tokelau', 690),
(234, 'TO', 'Tonga', 676),
(235, 'TT', 'Trinidad and Tobago', 1),
(236, 'TA', 'Tristan da Cunha', 0),
(237, 'TN', 'Tunisia', 216),
(238, 'TR', 'Turkey', 90),
(239, 'TM', 'Turkmenistan', 993),
(240, 'TC', 'Turks and Caicos Islands', 1),
(241, 'TV', 'Tuvalu', 688),
(242, 'UM', 'U.S. Minor Outlying Islands', 0),
(243, 'VI', 'U.S. Virgin Islands', 1),
(244, 'UG', 'Uganda', 256),
(245, 'UA', 'Ukraine', 380),
(246, 'AE', 'United Arab Emirates', 971),
(247, 'GB', 'United Kingdom', 44),
(248, 'US', 'United States', 1),
(249, 'UY', 'Uruguay', 598),
(250, 'UZ', 'Uzbekistan', 998),
(251, 'VU', 'Vanuatu', 678),
(252, 'VA', 'Vatican City', 39),
(253, 'VE', 'Venezuela', 58),
(254, 'VN', 'Vietnam', 84),
(255, 'WF', 'Wallis and Futuna', 681),
(256, 'EH', 'Western Sahara', 212),
(257, 'YE', 'Yemen', 967),
(258, 'ZM', 'Zambia', 260),
(259, 'ZW', 'Zimbabwe', 263);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]currencies`
--

CREATE TABLE `[[dbprefix]]currencies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `code` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `symbol` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `precision` int(11) NOT NULL,
  `thousand_separator` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `decimal_separator` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `swap_currency_symbol` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]customers`
--

CREATE TABLE `[[dbprefix]]customers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `company_id` int(10) unsigned DEFAULT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `first_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `last_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `active` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]custom_fields`
--

CREATE TABLE `[[dbprefix]]custom_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `rel_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rel_id` text COLLATE utf8_unicode_ci,
  `position` int(11) DEFAULT NULL,
  `type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` text COLLATE utf8_unicode_ci,
  `name_key` text COLLATE utf8_unicode_ci,
  `placeholder` text COLLATE utf8_unicode_ci,
  `error_text` text COLLATE utf8_unicode_ci,
  `updated_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `edited_by` int(11) DEFAULT NULL,
  `session_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `options` longtext COLLATE utf8_unicode_ci,
  `show_label` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT NULL,
  `required` int(11) DEFAULT NULL,
  `copy_of_field` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=72 ;

--
-- Dumping data for table `[[dbprefix]]custom_fields`
--

INSERT INTO `[[dbprefix]]custom_fields` VALUES
(1, NULL, NULL, NULL, 'text', 'Your Name', 'your-name', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\"}"', NULL, 1, NULL, NULL),
(2, NULL, NULL, NULL, 'text', 'Phone', 'phone', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\"}"', NULL, 1, NULL, NULL),
(3, NULL, NULL, NULL, 'email', 'Email', 'email', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"email\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\"}"', NULL, 1, NULL, NULL),
(4, NULL, NULL, NULL, 'text', 'Message', 'message', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\",\\"as_text_area\\":\\"1\\"}"', NULL, 1, NULL, NULL),
(5, NULL, NULL, NULL, 'text', 'Your Name', 'your-name', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\"}"', NULL, 1, NULL, NULL),
(6, NULL, NULL, NULL, 'text', 'Phone', 'phone', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\"}"', NULL, 1, NULL, NULL),
(7, NULL, NULL, NULL, 'email', 'Email', 'email', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"email\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\"}"', NULL, 1, NULL, NULL),
(8, NULL, NULL, NULL, 'text', 'Message', 'message', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\",\\"as_text_area\\":\\"1\\"}"', NULL, 1, NULL, NULL),
(9, NULL, NULL, NULL, 'text', 'Your Name', 'your-name', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\"}"', NULL, 1, NULL, NULL),
(10, NULL, NULL, NULL, 'text', 'Phone', 'phone', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\"}"', NULL, 1, NULL, NULL),
(11, NULL, NULL, NULL, 'email', 'Email', 'email', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"email\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\"}"', NULL, 1, NULL, NULL),
(12, NULL, NULL, NULL, 'text', 'Message', 'message', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\",\\"as_text_area\\":\\"1\\"}"', NULL, 1, NULL, NULL),
(13, NULL, NULL, NULL, 'text', 'Your Name', 'your-name', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\"}"', NULL, 1, NULL, NULL),
(14, NULL, NULL, NULL, 'text', 'Phone', 'phone', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\"}"', NULL, 1, NULL, NULL),
(15, NULL, NULL, NULL, 'email', 'Email', 'email', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"email\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\"}"', NULL, 1, NULL, NULL),
(16, NULL, NULL, NULL, 'text', 'Message', 'message', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\",\\"as_text_area\\":\\"1\\"}"', NULL, 1, NULL, NULL),
(17, NULL, NULL, NULL, 'text', 'First Name', 'first-name', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"6\\",\\"field_size_desktop\\":\\"6\\",\\"field_size_tablet\\":\\"6\\",\\"field_size_mobile\\":\\"6\\"}"', NULL, 1, NULL, NULL),
(18, NULL, NULL, NULL, 'text', 'Last Name', 'last-name', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"6\\",\\"field_size_desktop\\":\\"6\\",\\"field_size_tablet\\":\\"6\\",\\"field_size_mobile\\":\\"6\\"}"', NULL, 1, NULL, NULL),
(19, NULL, NULL, NULL, 'text', 'Phone', 'phone', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"6\\",\\"field_size_desktop\\":\\"6\\",\\"field_size_tablet\\":\\"6\\",\\"field_size_mobile\\":\\"6\\"}"', NULL, 1, NULL, NULL),
(20, NULL, NULL, NULL, 'email', 'Email', 'email', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"email\\",\\"field_size\\":\\"6\\",\\"field_size_desktop\\":\\"6\\",\\"field_size_tablet\\":\\"6\\",\\"field_size_mobile\\":\\"6\\"}"', NULL, 1, NULL, NULL),
(21, NULL, NULL, NULL, 'text', 'Message', 'message', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\",\\"as_text_area\\":\\"1\\"}"', NULL, 1, NULL, NULL),
(22, NULL, NULL, NULL, 'text', 'Name', 'name', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"6\\",\\"field_size_desktop\\":\\"6\\",\\"field_size_tablet\\":\\"6\\",\\"field_size_mobile\\":\\"6\\"}"', NULL, 1, NULL, NULL),
(23, NULL, NULL, NULL, 'email', 'Email', 'email', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"email\\",\\"field_size\\":\\"6\\",\\"field_size_desktop\\":\\"6\\",\\"field_size_tablet\\":\\"6\\",\\"field_size_mobile\\":\\"6\\"}"', NULL, 1, NULL, NULL),
(24, NULL, NULL, NULL, 'text', 'Message', 'message', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\",\\"as_text_area\\":\\"1\\"}"', NULL, 1, NULL, NULL),
(25, NULL, NULL, NULL, 'text', 'Full Name', 'full-name', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\"}"', NULL, 1, NULL, NULL),
(26, NULL, NULL, NULL, 'email', 'Email', 'email', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"email\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\"}"', NULL, 1, NULL, NULL),
(27, NULL, NULL, NULL, 'phone', 'Phone Number', 'phone-number', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"phone\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\"}"', NULL, 1, NULL, NULL),
(28, NULL, NULL, NULL, 'text', 'How many nights?', 'how-many-nights', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"6\\",\\"field_size_desktop\\":\\"6\\",\\"field_size_tablet\\":\\"6\\",\\"field_size_mobile\\":\\"6\\"}"', NULL, 1, NULL, NULL),
(29, NULL, NULL, NULL, 'text', 'How many guests?', 'how-many-guests', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"6\\",\\"field_size_desktop\\":\\"6\\",\\"field_size_tablet\\":\\"6\\",\\"field_size_mobile\\":\\"6\\"}"', NULL, 1, NULL, NULL),
(30, NULL, NULL, NULL, 'date', 'From', 'from', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"date\\",\\"field_size\\":\\"6\\",\\"field_size_desktop\\":\\"6\\",\\"field_size_tablet\\":\\"6\\",\\"field_size_mobile\\":\\"6\\"}"', NULL, 1, NULL, NULL),
(31, NULL, NULL, NULL, 'date', 'To', 'to', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"date\\",\\"field_size\\":\\"6\\",\\"field_size_desktop\\":\\"6\\",\\"field_size_tablet\\":\\"6\\",\\"field_size_mobile\\":\\"6\\"}"', NULL, 1, NULL, NULL),
(32, NULL, NULL, NULL, 'text', 'Message', 'message', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\",\\"as_text_area\\":\\"1\\"}"', NULL, 1, NULL, NULL),
(33, NULL, NULL, NULL, 'text', 'First Name', 'first-name', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"6\\",\\"field_size_desktop\\":\\"6\\",\\"field_size_tablet\\":\\"6\\",\\"field_size_mobile\\":\\"6\\"}"', NULL, 1, NULL, NULL),
(34, NULL, NULL, NULL, 'email', 'Email', 'email', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"email\\",\\"field_size\\":\\"6\\",\\"field_size_desktop\\":\\"6\\",\\"field_size_tablet\\":\\"6\\",\\"field_size_mobile\\":\\"6\\"}"', NULL, 1, NULL, NULL),
(35, NULL, NULL, NULL, 'email', 'Email', 'email', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"email\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\"}"', NULL, 1, NULL, NULL),
(36, NULL, NULL, NULL, 'text', 'First Name', 'first-name', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"6\\",\\"field_size_desktop\\":\\"6\\",\\"field_size_tablet\\":\\"6\\",\\"field_size_mobile\\":\\"6\\"}"', NULL, 1, NULL, NULL),
(37, NULL, NULL, NULL, 'email', 'Email', 'email', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"email\\",\\"field_size\\":\\"6\\",\\"field_size_desktop\\":\\"6\\",\\"field_size_tablet\\":\\"6\\",\\"field_size_mobile\\":\\"6\\"}"', NULL, 1, NULL, NULL),
(38, NULL, NULL, NULL, 'email', 'Email', 'email', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"email\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\"}"', NULL, 1, NULL, NULL),
(39, NULL, NULL, NULL, 'text', 'Name', 'name', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\"}"', NULL, 1, NULL, NULL),
(40, NULL, NULL, NULL, 'text', 'Full Name', 'full-name', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\"}"', NULL, 1, NULL, NULL),
(41, NULL, NULL, NULL, 'email', 'Email', 'email', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"email\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\"}"', NULL, 1, NULL, NULL),
(42, NULL, NULL, NULL, 'text', 'First Name', 'first-name', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"6\\",\\"field_size_desktop\\":\\"6\\",\\"field_size_tablet\\":\\"6\\",\\"field_size_mobile\\":\\"6\\"}"', NULL, 1, NULL, NULL),
(43, NULL, NULL, NULL, 'email', 'Email', 'email', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"email\\",\\"field_size\\":\\"6\\",\\"field_size_desktop\\":\\"6\\",\\"field_size_tablet\\":\\"6\\",\\"field_size_mobile\\":\\"6\\"}"', NULL, 1, NULL, NULL),
(44, NULL, NULL, NULL, 'text', 'Full Name', 'full-name', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\"}"', NULL, 1, NULL, NULL),
(45, NULL, NULL, NULL, 'email', 'Email', 'email', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"email\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\"}"', NULL, 1, NULL, NULL),
(46, NULL, NULL, NULL, 'text', 'How many nights?', 'how-many-nights', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"6\\",\\"field_size_desktop\\":\\"6\\",\\"field_size_tablet\\":\\"6\\",\\"field_size_mobile\\":\\"6\\"}"', NULL, 1, NULL, NULL),
(47, NULL, NULL, NULL, 'text', 'How many guests?', 'how-many-guests', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"6\\",\\"field_size_desktop\\":\\"6\\",\\"field_size_tablet\\":\\"6\\",\\"field_size_mobile\\":\\"6\\"}"', NULL, 1, NULL, NULL),
(48, NULL, NULL, NULL, 'date', 'From', 'from', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"date\\",\\"field_size\\":\\"6\\",\\"field_size_desktop\\":\\"6\\",\\"field_size_tablet\\":\\"6\\",\\"field_size_mobile\\":\\"6\\"}"', NULL, 1, NULL, NULL),
(49, NULL, NULL, NULL, 'date', 'To', 'to', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"date\\",\\"field_size\\":\\"6\\",\\"field_size_desktop\\":\\"6\\",\\"field_size_tablet\\":\\"6\\",\\"field_size_mobile\\":\\"6\\"}"', NULL, 1, NULL, NULL),
(50, NULL, NULL, NULL, 'text', 'Comment', 'comment', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\",\\"as_text_area\\":\\"1\\"}"', NULL, 1, NULL, NULL),
(51, NULL, NULL, NULL, 'text', 'First Name', 'first-name', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"6\\",\\"field_size_desktop\\":\\"6\\",\\"field_size_tablet\\":\\"6\\",\\"field_size_mobile\\":\\"6\\"}"', NULL, 1, NULL, NULL),
(52, NULL, NULL, NULL, 'email', 'Email', 'email', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"email\\",\\"field_size\\":\\"6\\",\\"field_size_desktop\\":\\"6\\",\\"field_size_tablet\\":\\"6\\",\\"field_size_mobile\\":\\"6\\"}"', NULL, 1, NULL, NULL),
(53, NULL, NULL, NULL, 'text', 'First Name', 'first-name', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"6\\",\\"field_size_desktop\\":\\"6\\",\\"field_size_tablet\\":\\"6\\",\\"field_size_mobile\\":\\"6\\"}"', NULL, 1, NULL, NULL),
(54, NULL, NULL, NULL, 'email', 'Email', 'email', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"email\\",\\"field_size\\":\\"6\\",\\"field_size_desktop\\":\\"6\\",\\"field_size_tablet\\":\\"6\\",\\"field_size_mobile\\":\\"6\\"}"', NULL, 1, NULL, NULL),
(55, NULL, NULL, NULL, 'price', 'price', 'price', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', NULL, NULL, 1, NULL, NULL),
(56, NULL, NULL, NULL, 'price', 'price', 'price', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', NULL, NULL, 1, NULL, NULL),
(57, NULL, NULL, NULL, 'price', 'price', 'price', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', NULL, NULL, 1, NULL, NULL),
(58, NULL, NULL, NULL, 'text', 'Your Name', 'your-name', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\"}"', NULL, 1, NULL, NULL),
(59, NULL, NULL, NULL, 'text', 'Phone', 'phone', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\"}"', NULL, 1, NULL, NULL),
(60, NULL, NULL, NULL, 'email', 'Email', 'email', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"email\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\"}"', NULL, 1, NULL, NULL),
(61, NULL, NULL, NULL, 'text', 'Message', 'message', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\",\\"as_text_area\\":\\"1\\"}"', NULL, 1, NULL, NULL),
(62, NULL, NULL, NULL, 'text', 'Your Name', 'your-name', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\"}"', NULL, 1, NULL, NULL),
(63, NULL, NULL, NULL, 'text', 'Phone', 'phone', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\"}"', NULL, 1, NULL, NULL),
(64, NULL, NULL, NULL, 'email', 'Email', 'email', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"email\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\"}"', NULL, 1, NULL, NULL),
(65, NULL, NULL, NULL, 'text', 'Message', 'message', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '"{\\"show_placeholder\\":\\"1\\",\\"field_type\\":\\"text\\",\\"field_size\\":\\"12\\",\\"field_size_desktop\\":\\"12\\",\\"field_size_tablet\\":\\"12\\",\\"field_size_mobile\\":\\"12\\",\\"as_text_area\\":\\"1\\"}"', NULL, 1, NULL, NULL),
(66, NULL, NULL, NULL, 'price', 'price', 'price', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', NULL, NULL, 1, NULL, NULL),
(67, NULL, NULL, NULL, 'price', 'price', 'price', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', NULL, NULL, 1, NULL, NULL),
(68, NULL, NULL, NULL, 'text', 'Your Name', 'your-name', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '{"show_placeholder":"1","field_type":"text","field_size":"12","field_size_desktop":"12","field_size_tablet":"12","field_size_mobile":"12"}', NULL, 1, NULL, NULL),
(69, NULL, NULL, NULL, 'text', 'Phone', 'phone', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '{"show_placeholder":"1","field_type":"text","field_size":"12","field_size_desktop":"12","field_size_tablet":"12","field_size_mobile":"12"}', NULL, 1, NULL, NULL),
(70, NULL, NULL, NULL, 'email', 'Email', 'email', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '{"show_placeholder":"1","field_type":"email","field_size":"12","field_size_desktop":"12","field_size_tablet":"12","field_size_mobile":"12"}', NULL, 1, NULL, NULL),
(71, NULL, NULL, NULL, 'text', 'Message', 'message', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 'eS2nXyGRHl4PJ60dnuJFxMznxrPTUoKCVrotcfrt', '{"show_placeholder":"1","field_type":"text","field_size":"12","field_size_desktop":"12","field_size_tablet":"12","field_size_mobile":"12","as_text_area":"1"}', NULL, 1, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]custom_fields_values`
--

CREATE TABLE `[[dbprefix]]custom_fields_values` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `custom_field_id` int(11) DEFAULT NULL,
  `value` text COLLATE utf8_unicode_ci,
  `position` int(11) DEFAULT NULL,
  `price_modifier` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]custom_fields_values`
--

INSERT INTO `[[dbprefix]]custom_fields_values` VALUES
(1, 10, '0', 1, NULL),
(2, 11, '10', 1, NULL),
(3, 66, '19.99', 1, NULL),
(4, 67, '15.90', 1, NULL),
(5, 68, '50', 1, NULL),
(6, 77, '10.9', 1, NULL),
(7, 78, '19.99', 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]elements`
--

CREATE TABLE `[[dbprefix]]elements` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `updated_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `expires_on` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `edited_by` int(11) DEFAULT NULL,
  `name` text COLLATE utf8_unicode_ci,
  `parent_id` int(11) DEFAULT NULL,
  `module_id` text COLLATE utf8_unicode_ci,
  `module` text COLLATE utf8_unicode_ci,
  `description` text COLLATE utf8_unicode_ci,
  `icon` text COLLATE utf8_unicode_ci,
  `author` text COLLATE utf8_unicode_ci,
  `website` text COLLATE utf8_unicode_ci,
  `help` text COLLATE utf8_unicode_ci,
  `type` text COLLATE utf8_unicode_ci,
  `installed` int(11) DEFAULT NULL,
  `ui` int(11) DEFAULT NULL,
  `position` int(11) DEFAULT NULL,
  `as_element` int(11) DEFAULT NULL,
  `allow_caching` int(11) DEFAULT NULL,
  `ui_admin` int(11) DEFAULT NULL,
  `ui_admin_iframe` int(11) DEFAULT NULL,
  `is_system` int(11) DEFAULT NULL,
  `is_integration` int(11) DEFAULT NULL,
  `version` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `notifications` int(11) DEFAULT NULL,
  `settings` text COLLATE utf8_unicode_ci,
  `categories` text COLLATE utf8_unicode_ci,
  `keywords` text COLLATE utf8_unicode_ci,
  `layout_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=26 ;

--
-- Dumping data for table `[[dbprefix]]elements`
--

INSERT INTO `[[dbprefix]]elements` VALUES
(1, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 'Arrows List', 0, NULL, 'arrows-list', '', '{SITE_URL}userfiles/elements/arrows-list.png', 'Microweber', 'http://microweber.com', NULL, NULL, NULL, 0, 3, 1, 0, 0, NULL, 0, 0, '0.1', NULL, NULL, 'custom', NULL, NULL),
(2, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 'Background Text', 0, NULL, 'background-text', '', '{SITE_URL}userfiles/elements/background-text.png', 'Microweber', 'http://microweber.com', NULL, NULL, NULL, 0, 7, 1, 0, 0, NULL, 0, 0, '0.1', NULL, NULL, 'custom', NULL, NULL),
(3, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 'Blockquoute', 0, NULL, 'blockquote', '', '{SITE_URL}userfiles/elements/blockquote.png', 'Microweber', 'http://microweber.com', NULL, NULL, NULL, 0, 6, 1, 0, 0, NULL, 0, 0, '0.1', NULL, NULL, 'custom', NULL, NULL),
(4, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 'Checked List', 0, NULL, 'checked-list', '', '{SITE_URL}userfiles/elements/checked-list.png', 'Microweber', 'http://microweber.com', NULL, NULL, NULL, 0, 4, 1, 0, 0, NULL, 0, 0, '0.1', NULL, NULL, 'custom', NULL, NULL),
(5, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 'Icon with Text', 0, NULL, 'icon-with-text', '', '{SITE_URL}userfiles/elements/icon-with-text.png', 'Microweber', 'http://microweber.com', NULL, NULL, NULL, 0, 10, 1, 0, 0, NULL, 0, 0, '0.1', NULL, NULL, 'custom', NULL, NULL),
(6, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 'Image with Title and Text', 0, NULL, 'image-with-title-and-text', '', '{SITE_URL}userfiles/elements/image-with-title-and-text.png', 'Microweber', 'http://microweber.com', NULL, NULL, NULL, 0, 19, 1, 0, 0, NULL, 0, 0, '0.1', NULL, NULL, 'custom', NULL, NULL),
(7, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 'Ordered List', 0, NULL, 'ordered-list', '', '{SITE_URL}userfiles/elements/ordered-list.png', 'Microweber', 'http://microweber.com', NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL, 0, 0, '0.1', NULL, NULL, 'custom', NULL, NULL),
(8, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 'Highlighted Paragraph', 0, NULL, 'paragraph-highlight', '', '{SITE_URL}userfiles/elements/paragraph-highlight.png', 'Microweber', 'http://microweber.com', NULL, NULL, NULL, 0, 7, 1, 0, 0, NULL, 0, 0, '0.1', NULL, NULL, 'custom', NULL, NULL),
(9, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 'Paragraph', 0, NULL, 'paragraph', '', '{SITE_URL}userfiles/elements/paragraph.png', 'Microweber', 'http://microweber.com', NULL, NULL, NULL, 0, 6, 1, 0, 0, NULL, 0, 0, '0.1', NULL, NULL, 'text', NULL, NULL),
(10, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 'Features', 0, NULL, 'skin-10', '', '{SITE_URL}userfiles/elements/skin-10.png', 'Microweber', 'http://microweber.com', NULL, NULL, NULL, 0, 18, 1, 0, 0, NULL, 0, 0, '0.1', NULL, NULL, 'custom', NULL, NULL),
(11, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 'Puzzle', 0, NULL, 'skin-11', '', '{SITE_URL}userfiles/elements/skin-11.png', 'Microweber', 'http://microweber.com', NULL, NULL, NULL, 0, 30, 1, 0, 0, NULL, 0, 0, '0.1', NULL, NULL, 'custom', NULL, NULL),
(12, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 'Text with Image', 0, NULL, 'skin-12', 'Simple image with some description text', '{SITE_URL}userfiles/elements/skin-12.png', 'Microweber', 'http://microweber.com', NULL, NULL, NULL, 0, 21, 1, 0, 0, NULL, 0, 0, '0.1', NULL, NULL, 'custom', NULL, NULL),
(13, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 'Image with Text', 0, NULL, 'skin-1', 'Simple image with some description text', '{SITE_URL}userfiles/elements/skin-1.png', 'Microweber', 'http://microweber.com', NULL, NULL, NULL, 0, 21, 1, 0, 0, NULL, 0, 0, '0.1', NULL, NULL, 'custom', NULL, NULL),
(14, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 'Left Image - Right Text', 0, NULL, 'skin-2', 'Simple image with some description text', '{SITE_URL}userfiles/elements/skin-2.png', 'Microweber', 'http://microweber.com', NULL, NULL, NULL, 0, 22, 1, 0, 0, NULL, 0, 0, '0.1', NULL, NULL, 'custom', NULL, NULL),
(15, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 'Parallax', 0, NULL, 'skin-3', 'Parallax image', '{SITE_URL}userfiles/elements/skin-3.png', 'Microweber', 'http://microweber.com', NULL, NULL, NULL, 0, 20, 1, 0, 0, NULL, 0, 0, '0.1', NULL, NULL, 'custom', NULL, NULL),
(16, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 'Right Image - Left Text', 0, NULL, 'skin-4', 'Simple image with some text description in middle', '{SITE_URL}userfiles/elements/skin-4.png', 'Microweber', 'http://microweber.com', NULL, NULL, NULL, 0, 23, 1, 0, 0, NULL, 0, 0, '0.1', NULL, NULL, 'custom', NULL, NULL),
(17, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 'Simple Title & Text', 0, NULL, 'skin-5', 'Simple title with some description text', '{SITE_URL}userfiles/elements/skin-5.png', 'Microweber', 'http://microweber.com', NULL, NULL, NULL, 0, 17, 1, 0, 0, NULL, 0, 0, '0.1', NULL, NULL, 'custom', NULL, NULL),
(18, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 'Text under Image', 0, NULL, 'skin-6', 'Two columns images with text', '{SITE_URL}userfiles/elements/skin-6.png', 'Microweber', 'http://microweber.com', NULL, NULL, NULL, 0, 25, 1, 0, 0, NULL, 0, 0, '0.1', NULL, NULL, 'custom', NULL, NULL),
(19, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 'Icons with Information', 0, NULL, 'skin-7', '', '{SITE_URL}userfiles/elements/skin-7.png', 'Microweber', 'http://microweber.com', NULL, NULL, NULL, 0, 17, 1, 0, 0, NULL, 0, 0, '0.1', NULL, NULL, 'custom', NULL, NULL),
(20, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 'Full screen Background Image with text', 0, NULL, 'skin-8', '', '{SITE_URL}userfiles/elements/skin-8.png', 'Microweber', 'http://microweber.com', NULL, NULL, NULL, 0, 27, 1, 0, 0, NULL, 0, 0, '0.1', NULL, NULL, 'custom', NULL, NULL),
(21, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 'Text with Image and Title', 0, NULL, 'text-with-image-and-title', '', '{SITE_URL}userfiles/elements/text-with-image-and-title.png', 'Microweber', 'http://microweber.com', NULL, NULL, NULL, 0, 19, 1, 0, 0, NULL, 0, 0, '0.1', NULL, NULL, 'custom', NULL, NULL),
(22, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 'Title with Text', 0, NULL, 'title-with-text', '', '{SITE_URL}userfiles/elements/title-with-text.png', 'Microweber', 'http://microweber.com', NULL, NULL, NULL, 0, 9, 1, 0, 0, NULL, 0, 0, '0.1', NULL, NULL, 'custom', NULL, NULL),
(23, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 'Two text columns with icon and title', 0, NULL, 'two-text-columns-with-icon-and-title', '', '{SITE_URL}userfiles/elements/two-text-columns-with-icon-and-title.png', 'Microweber', 'http://microweber.com', NULL, NULL, NULL, 0, 13, 1, 0, 0, NULL, 0, 0, '0.1', NULL, NULL, 'custom', NULL, NULL),
(24, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 'Two Text Columns', 0, NULL, 'two-text-columns', '', '{SITE_URL}userfiles/elements/two-text-columns.png', 'Microweber', 'http://microweber.com', NULL, NULL, NULL, 0, 11, 1, 0, 0, NULL, 0, 0, '0.1', NULL, NULL, 'custom', NULL, NULL),
(25, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 'Unordered List', 0, NULL, 'unordered-list', '', '{SITE_URL}userfiles/elements/unordered-list.png', 'Microweber', 'http://microweber.com', NULL, NULL, NULL, 0, 5, 1, 0, 0, NULL, 0, 0, '0.1', NULL, NULL, 'custom', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]export_feeds`
--

CREATE TABLE `[[dbprefix]]export_feeds` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `export_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `export_format` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `download_link` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `split_to_parts` int(11) DEFAULT NULL,
  `is_draft` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]failed_jobs`
--

CREATE TABLE `[[dbprefix]]failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `connection` text COLLATE utf8_unicode_ci NOT NULL,
  `queue` text COLLATE utf8_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forms_data`
--

CREATE TABLE `[[dbprefix]]forms_data` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `rel_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rel_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `list_id` int(11) DEFAULT NULL,
  `form_values` text COLLATE utf8_unicode_ci,
  `module_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user_ip` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_read` int(11) DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forms_data_values`
--

CREATE TABLE `[[dbprefix]]forms_data_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `form_data_id` int(11) DEFAULT NULL,
  `field_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `field_key` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `field_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `field_value` longtext COLLATE utf8_unicode_ci,
  `field_value_json` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forms_lists`
--

CREATE TABLE `[[dbprefix]]forms_lists` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `custom_data` text COLLATE utf8_unicode_ci,
  `module_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `last_export` datetime DEFAULT NULL,
  `last_sent` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forms_recipients`
--

CREATE TABLE `[[dbprefix]]forms_recipients` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]import_feeds`
--

CREATE TABLE `[[dbprefix]]import_feeds` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `import_to` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `parent_page` int(11) DEFAULT NULL,
  `source_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `source_url` text COLLATE utf8_unicode_ci,
  `source_file` text COLLATE utf8_unicode_ci,
  `source_file_realpath` text COLLATE utf8_unicode_ci,
  `source_file_size` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `source_content_realpath` text COLLATE utf8_unicode_ci,
  `last_import_start` datetime DEFAULT NULL,
  `last_import_end` datetime DEFAULT NULL,
  `last_downloaded_date` datetime DEFAULT NULL,
  `download_images` int(11) DEFAULT NULL,
  `split_to_parts` int(11) DEFAULT NULL,
  `mapped_tags` longtext COLLATE utf8_unicode_ci,
  `mapped_content_realpath` text COLLATE utf8_unicode_ci,
  `imported_content_ids` longtext COLLATE utf8_unicode_ci,
  `detected_content_tags` longtext COLLATE utf8_unicode_ci,
  `content_tag` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `primary_key` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `update_items` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `old_content_action` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `count_of_contents` int(11) DEFAULT NULL,
  `total_running` int(11) DEFAULT NULL,
  `is_draft` int(11) DEFAULT NULL,
  `custom_content_data_fields` longtext COLLATE utf8_unicode_ci,
  `category_separators` longtext COLLATE utf8_unicode_ci,
  `category_ids_separators` longtext COLLATE utf8_unicode_ci,
  `category_add_types` longtext COLLATE utf8_unicode_ci,
  `tags_separators` longtext COLLATE utf8_unicode_ci,
  `media_url_separators` longtext COLLATE utf8_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]jobs`
--

CREATE TABLE `[[dbprefix]]jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8_unicode_ci NOT NULL,
  `attempts` tinyint(3) unsigned NOT NULL,
  `reserved_at` int(10) unsigned DEFAULT NULL,
  `available_at` int(10) unsigned NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  `reserved` int(11) DEFAULT NULL,
  `mw_processed` int(11) DEFAULT NULL,
  `job_hash` longtext COLLATE utf8_unicode_ci,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]log`
--

CREATE TABLE `[[dbprefix]]log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `updated_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `edited_by` int(11) DEFAULT NULL,
  `rel_type` text COLLATE utf8_unicode_ci,
  `rel_id` text COLLATE utf8_unicode_ci,
  `position` int(11) DEFAULT NULL,
  `field` text COLLATE utf8_unicode_ci,
  `value` text COLLATE utf8_unicode_ci,
  `module` text COLLATE utf8_unicode_ci,
  `data_type` text COLLATE utf8_unicode_ci,
  `title` text COLLATE utf8_unicode_ci,
  `description` text COLLATE utf8_unicode_ci,
  `content` text COLLATE utf8_unicode_ci,
  `user_ip` text COLLATE utf8_unicode_ci,
  `session_id` text COLLATE utf8_unicode_ci,
  `is_system` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]login_attempts`
--

CREATE TABLE `[[dbprefix]]login_attempts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `username` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ip` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `success` int(11) DEFAULT NULL,
  `time` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mail_providers`
--

CREATE TABLE `[[dbprefix]]mail_providers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `provider_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `provider_settings` text COLLATE utf8_unicode_ci,
  `is_active` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mail_subscribers`
--

CREATE TABLE `[[dbprefix]]mail_subscribers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `rel_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rel_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mail_address` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mail_provider_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mail_templates`
--

CREATE TABLE `[[dbprefix]]mail_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `subject` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `message` text COLLATE utf8_unicode_ci,
  `from_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `from_email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `custom` text COLLATE utf8_unicode_ci,
  `copy_to` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `plain_text` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]media`
--

CREATE TABLE `[[dbprefix]]media` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` text COLLATE utf8_unicode_ci,
  `description` text COLLATE utf8_unicode_ci,
  `filename` text COLLATE utf8_unicode_ci,
  `media_type` text COLLATE utf8_unicode_ci,
  `rel_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rel_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `edited_by` int(11) DEFAULT NULL,
  `session_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `image_options` longtext COLLATE utf8_unicode_ci,
  `position` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=34 ;

--
-- Dumping data for table `[[dbprefix]]media`
--

INSERT INTO `[[dbprefix]]media` VALUES
(1, NULL, NULL, '{SITE_URL}userfiles/modules/pictures/default-images/gallery-1-1.jpg', 'picture', 'modules', 'module-pictures', 1, 1, '4GwdGKZdDiJO0i1wFeq1v9xAIxRN8cD5ujdCK88d', NULL, 9999999, '2023-10-18 16:29:19', '2023-10-18 16:29:19'),
(2, NULL, NULL, '{SITE_URL}userfiles/modules/pictures/default-images/gallery-1-2.jpg', 'picture', 'modules', 'module-pictures', 1, 1, '4GwdGKZdDiJO0i1wFeq1v9xAIxRN8cD5ujdCK88d', NULL, 9999999, '2023-10-18 16:29:20', '2023-10-18 16:29:20'),
(3, NULL, NULL, '{SITE_URL}userfiles/modules/pictures/default-images/gallery-1-3.jpg', 'picture', 'modules', 'module-pictures', 1, 1, '4GwdGKZdDiJO0i1wFeq1v9xAIxRN8cD5ujdCK88d', NULL, 9999999, '2023-10-18 16:29:20', '2023-10-18 16:29:20'),
(4, NULL, NULL, '{SITE_URL}userfiles/modules/pictures/default-images/gallery-1-4.jpg', 'picture', 'modules', 'module-pictures', 1, 1, '4GwdGKZdDiJO0i1wFeq1v9xAIxRN8cD5ujdCK88d', NULL, 9999999, '2023-10-18 16:29:20', '2023-10-18 16:29:20'),
(5, NULL, NULL, '{SITE_URL}userfiles/modules/pictures/default-images/gallery-1-5.jpg', 'picture', 'modules', 'module-pictures', 1, 1, '4GwdGKZdDiJO0i1wFeq1v9xAIxRN8cD5ujdCK88d', NULL, 9999999, '2023-10-18 16:29:20', '2023-10-18 16:29:20'),
(6, NULL, NULL, '{SITE_URL}userfiles/modules/pictures/default-images/gallery-1-6.jpg', 'picture', 'modules', 'module-pictures', 1, 1, '4GwdGKZdDiJO0i1wFeq1v9xAIxRN8cD5ujdCK88d', NULL, 9999999, '2023-10-18 16:29:21', '2023-10-18 16:29:21'),
(7, NULL, NULL, '{SITE_URL}userfiles/modules/pictures/default-images/gallery-1-7.jpg', 'picture', 'modules', 'module-pictures', 1, 1, '4GwdGKZdDiJO0i1wFeq1v9xAIxRN8cD5ujdCK88d', NULL, 9999999, '2023-10-18 16:29:21', '2023-10-18 16:29:21'),
(8, NULL, NULL, '{SITE_URL}userfiles/modules/pictures/default-images/gallery-1-8.jpg', 'picture', 'modules', 'module-pictures', 1, 1, '4GwdGKZdDiJO0i1wFeq1v9xAIxRN8cD5ujdCK88d', NULL, 9999999, '2023-10-18 16:29:21', '2023-10-18 16:29:21'),
(9, NULL, NULL, '{SITE_URL}userfiles/modules/pictures/default-images/gallery-1-1.jpg', 'picture', 'modules', 'mod-8859cdc87388966f5cf97fb7aefe7210-shop-products-pictures', 1, 1, '6157e0RkV9jhaioUs65OpTWvPpZmXc0VN9yR2mRx', NULL, 9999999, '2023-10-23 16:54:04', '2023-10-23 16:54:04'),
(10, NULL, NULL, '{SITE_URL}userfiles/modules/pictures/default-images/gallery-1-2.jpg', 'picture', 'modules', 'mod-8859cdc87388966f5cf97fb7aefe7210-shop-products-pictures', 1, 1, '6157e0RkV9jhaioUs65OpTWvPpZmXc0VN9yR2mRx', NULL, 9999999, '2023-10-23 16:54:04', '2023-10-23 16:54:04'),
(11, NULL, NULL, '{SITE_URL}userfiles/modules/pictures/default-images/gallery-1-3.jpg', 'picture', 'modules', 'mod-8859cdc87388966f5cf97fb7aefe7210-shop-products-pictures', 1, 1, '6157e0RkV9jhaioUs65OpTWvPpZmXc0VN9yR2mRx', NULL, 9999999, '2023-10-23 16:54:04', '2023-10-23 16:54:04'),
(12, NULL, NULL, '{SITE_URL}userfiles/modules/pictures/default-images/gallery-1-4.jpg', 'picture', 'modules', 'mod-8859cdc87388966f5cf97fb7aefe7210-shop-products-pictures', 1, 1, '6157e0RkV9jhaioUs65OpTWvPpZmXc0VN9yR2mRx', NULL, 9999999, '2023-10-23 16:54:04', '2023-10-23 16:54:04'),
(13, NULL, NULL, '{SITE_URL}userfiles/modules/pictures/default-images/gallery-1-5.jpg', 'picture', 'modules', 'mod-8859cdc87388966f5cf97fb7aefe7210-shop-products-pictures', 1, 1, '6157e0RkV9jhaioUs65OpTWvPpZmXc0VN9yR2mRx', NULL, 9999999, '2023-10-23 16:54:04', '2023-10-23 16:54:04'),
(14, NULL, NULL, '{SITE_URL}userfiles/modules/pictures/default-images/gallery-1-6.jpg', 'picture', 'modules', 'mod-8859cdc87388966f5cf97fb7aefe7210-shop-products-pictures', 1, 1, '6157e0RkV9jhaioUs65OpTWvPpZmXc0VN9yR2mRx', NULL, 9999999, '2023-10-23 16:54:04', '2023-10-23 16:54:04'),
(15, NULL, NULL, '{SITE_URL}userfiles/modules/pictures/default-images/gallery-1-7.jpg', 'picture', 'modules', 'mod-8859cdc87388966f5cf97fb7aefe7210-shop-products-pictures', 1, 1, '6157e0RkV9jhaioUs65OpTWvPpZmXc0VN9yR2mRx', NULL, 9999999, '2023-10-23 16:54:04', '2023-10-23 16:54:04'),
(16, NULL, NULL, '{SITE_URL}userfiles/modules/pictures/default-images/gallery-1-8.jpg', 'picture', 'modules', 'mod-8859cdc87388966f5cf97fb7aefe7210-shop-products-pictures', 1, 1, '6157e0RkV9jhaioUs65OpTWvPpZmXc0VN9yR2mRx', NULL, 9999999, '2023-10-23 16:54:04', '2023-10-23 16:54:04'),
(17, NULL, NULL, '{SITE_URL}userfiles/modules/pictures/default-images/gallery-1-1.jpg', 'picture', 'modules', 'mod-8859cdc87388966f5cf97fb7aefe7210-shop-products-pictures--1', 1, 1, '6157e0RkV9jhaioUs65OpTWvPpZmXc0VN9yR2mRx', NULL, 9999999, '2023-10-23 16:54:04', '2023-10-23 16:54:04'),
(18, NULL, NULL, '{SITE_URL}userfiles/modules/pictures/default-images/gallery-1-2.jpg', 'picture', 'modules', 'mod-8859cdc87388966f5cf97fb7aefe7210-shop-products-pictures--1', 1, 1, '6157e0RkV9jhaioUs65OpTWvPpZmXc0VN9yR2mRx', NULL, 9999999, '2023-10-23 16:54:04', '2023-10-23 16:54:04'),
(19, NULL, NULL, '{SITE_URL}userfiles/modules/pictures/default-images/gallery-1-3.jpg', 'picture', 'modules', 'mod-8859cdc87388966f5cf97fb7aefe7210-shop-products-pictures--1', 1, 1, '6157e0RkV9jhaioUs65OpTWvPpZmXc0VN9yR2mRx', NULL, 9999999, '2023-10-23 16:54:04', '2023-10-23 16:54:04'),
(20, NULL, NULL, '{SITE_URL}userfiles/modules/pictures/default-images/gallery-1-4.jpg', 'picture', 'modules', 'mod-8859cdc87388966f5cf97fb7aefe7210-shop-products-pictures--1', 1, 1, '6157e0RkV9jhaioUs65OpTWvPpZmXc0VN9yR2mRx', NULL, 9999999, '2023-10-23 16:54:05', '2023-10-23 16:54:05'),
(21, NULL, NULL, '{SITE_URL}userfiles/modules/pictures/default-images/gallery-1-5.jpg', 'picture', 'modules', 'mod-8859cdc87388966f5cf97fb7aefe7210-shop-products-pictures--1', 1, 1, '6157e0RkV9jhaioUs65OpTWvPpZmXc0VN9yR2mRx', NULL, 9999999, '2023-10-23 16:54:05', '2023-10-23 16:54:05'),
(22, NULL, NULL, '{SITE_URL}userfiles/modules/pictures/default-images/gallery-1-6.jpg', 'picture', 'modules', 'mod-8859cdc87388966f5cf97fb7aefe7210-shop-products-pictures--1', 1, 1, '6157e0RkV9jhaioUs65OpTWvPpZmXc0VN9yR2mRx', NULL, 9999999, '2023-10-23 16:54:05', '2023-10-23 16:54:05'),
(23, NULL, NULL, '{SITE_URL}userfiles/modules/pictures/default-images/gallery-1-7.jpg', 'picture', 'modules', 'mod-8859cdc87388966f5cf97fb7aefe7210-shop-products-pictures--1', 1, 1, '6157e0RkV9jhaioUs65OpTWvPpZmXc0VN9yR2mRx', NULL, 9999999, '2023-10-23 16:54:05', '2023-10-23 16:54:05'),
(24, NULL, NULL, '{SITE_URL}userfiles/modules/pictures/default-images/gallery-1-8.jpg', 'picture', 'modules', 'mod-8859cdc87388966f5cf97fb7aefe7210-shop-products-pictures--1', 1, 1, '6157e0RkV9jhaioUs65OpTWvPpZmXc0VN9yR2mRx', NULL, 9999999, '2023-10-23 16:54:05', '2023-10-23 16:54:05'),
(25, NULL, NULL, '{SITE_URL}userfiles/media/default/16316468-pump-bottle-03.jpg', 'picture', 'content', '7', 1, 1, 'WWuqAYN9GHg9g0XE9gLkeipWPKjWYnFsZz0bmQ9z', NULL, 9999999, '2023-10-23 16:57:17', '2023-10-23 16:57:17'),
(26, NULL, NULL, '{SITE_URL}userfiles/media/default/16316503-spray-bottle-03.jpg', 'picture', 'content', '7', 1, 1, 'WWuqAYN9GHg9g0XE9gLkeipWPKjWYnFsZz0bmQ9z', NULL, 9999999, '2023-10-23 16:57:18', '2023-10-23 16:57:18'),
(27, NULL, NULL, '{SITE_URL}userfiles/media/default/16892387-tall-bottle-07.jpg', 'picture', 'content', '6', 1, 1, 'WWuqAYN9GHg9g0XE9gLkeipWPKjWYnFsZz0bmQ9z', NULL, 9999999, '2023-10-23 16:58:18', '2023-10-23 16:58:18'),
(28, NULL, NULL, '{SITE_URL}userfiles/media/default/16891942-dropper-07.jpg', 'picture', 'content', '6', 1, 1, 'WWuqAYN9GHg9g0XE9gLkeipWPKjWYnFsZz0bmQ9z', NULL, 9999999, '2023-10-23 16:58:37', '2023-10-23 16:58:37'),
(29, NULL, NULL, '{SITE_URL}userfiles/media/default/26206270-03.jpg', 'picture', 'content', '9', 1, 1, 'WWuqAYN9GHg9g0XE9gLkeipWPKjWYnFsZz0bmQ9z', NULL, 9999999, '2023-10-23 17:01:15', '2023-10-23 17:01:33'),
(30, NULL, NULL, '{SITE_URL}userfiles/media/default/26206271-03.jpg', 'picture', 'content', '9', 1, 1, 'WWuqAYN9GHg9g0XE9gLkeipWPKjWYnFsZz0bmQ9z', NULL, 9999999, '2023-10-23 17:01:15', '2023-10-23 17:01:33'),
(31, NULL, NULL, '{SITE_URL}userfiles/media/default/gallery-1-7.jpg', 'picture', 'content', '11', 1, 1, 'WWuqAYN9GHg9g0XE9gLkeipWPKjWYnFsZz0bmQ9z', NULL, 9999999, '2023-10-23 17:11:39', '2023-10-23 17:11:39'),
(32, NULL, NULL, '{SITE_URL}userfiles/media/default/gallery-1-15.jpg', 'picture', 'content', '10', 1, 1, 'WWuqAYN9GHg9g0XE9gLkeipWPKjWYnFsZz0bmQ9z', NULL, 9999999, '2023-10-23 17:13:11', '2023-10-23 17:13:11'),
(33, NULL, NULL, '{SITE_URL}userfiles/media/default/gallery-1-1.jpg', 'picture', 'content', '5', 1, 1, 'WWuqAYN9GHg9g0XE9gLkeipWPKjWYnFsZz0bmQ9z', NULL, 9999999, '2023-10-23 17:14:11', '2023-10-23 17:14:11');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]media_thumbnails`
--

CREATE TABLE `[[dbprefix]]media_thumbnails` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `filename` text COLLATE utf8_unicode_ci,
  `image_options` longtext COLLATE utf8_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `uuid` char(36) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]menus`
--

CREATE TABLE `[[dbprefix]]menus` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` text COLLATE utf8_unicode_ci,
  `item_type` text COLLATE utf8_unicode_ci,
  `description` text COLLATE utf8_unicode_ci,
  `url` longtext COLLATE utf8_unicode_ci,
  `url_target` text COLLATE utf8_unicode_ci,
  `parent_id` int(11) DEFAULT NULL,
  `content_id` int(11) DEFAULT NULL,
  `categories_id` int(11) DEFAULT NULL,
  `position` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT NULL,
  `auto_populate` int(11) DEFAULT NULL,
  `size` text COLLATE utf8_unicode_ci,
  `default_image` text COLLATE utf8_unicode_ci,
  `rollover_image` text COLLATE utf8_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `menu_name` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=20 ;

--
-- Dumping data for table `[[dbprefix]]menus`
--

INSERT INTO `[[dbprefix]]menus` VALUES
(1, 'header_menu', 'menu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '2023-10-18 16:02:19', '2023-10-18 16:02:19', NULL),
(3, 'footer_menu', 'menu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '2023-10-18 16:02:20', '2023-10-18 16:02:20', NULL),
(12, '', 'menu_item', NULL, NULL, NULL, 1, 1, NULL, 99999, NULL, NULL, NULL, NULL, NULL, '2023-10-26 17:36:45', '2023-10-26 17:36:45', NULL),
(13, '', 'menu_item', NULL, NULL, NULL, 1, 2, NULL, 99999, NULL, NULL, NULL, NULL, NULL, '2023-10-26 17:36:50', '2023-10-26 17:36:50', NULL),
(14, '', 'menu_item', NULL, NULL, NULL, 1, 3, NULL, 99999, NULL, NULL, NULL, NULL, NULL, '2023-10-26 17:36:54', '2023-10-26 17:36:54', NULL),
(15, '', 'menu_item', NULL, NULL, NULL, 1, 4, NULL, 99999, NULL, NULL, NULL, NULL, NULL, '2023-10-26 17:36:58', '2023-10-26 17:36:58', NULL),
(16, '', 'menu_item', NULL, NULL, NULL, 3, 1, NULL, 99999, NULL, NULL, NULL, NULL, NULL, '2023-10-26 17:37:08', '2023-10-26 17:37:08', NULL),
(17, '', 'menu_item', NULL, NULL, NULL, 3, 2, NULL, 99999, NULL, NULL, NULL, NULL, NULL, '2023-10-26 17:37:11', '2023-10-26 17:37:11', NULL),
(18, '', 'menu_item', NULL, NULL, NULL, 3, 3, NULL, 99999, NULL, NULL, NULL, NULL, NULL, '2023-10-26 17:37:15', '2023-10-26 17:37:15', NULL),
(19, '', 'menu_item', NULL, NULL, NULL, 3, 4, NULL, 99999, NULL, NULL, NULL, NULL, NULL, '2023-10-26 17:37:19', '2023-10-26 17:37:19', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]migrations`
--

CREATE TABLE `[[dbprefix]]migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=82 ;

--
-- Dumping data for table `[[dbprefix]]migrations`
--

INSERT INTO `[[dbprefix]]migrations` VALUES
(1, '2014_01_07_073615_create_tagged_table', 1),
(2, '2014_01_07_073615_create_tags_table', 1),
(3, '2014_10_11_125754_create_currencies_table', 1),
(4, '2014_10_12_000000_create_user_table', 1),
(5, '2014_10_12_000001_update_users_table', 1),
(6, '2016_06_29_073615_create_tag_groups_table', 1),
(7, '2016_06_29_073615_update_tags_table', 1),
(8, '2017_05_06_173745_create_countries_table', 1),
(9, '2019_08_30_072639_create_addresses_table', 1),
(10, '2019_09_21_052540_create_tax_types_table', 1),
(11, '2019_11_25_021944_create_customers_table', 1),
(12, '2019_12_14_000001_create_personal_access_tokens_table', 1),
(13, '2020_00_00_000000_create_content_data_table', 1),
(14, '2020_00_00_000000_create_content_data_variants_table', 1),
(15, '2020_00_00_000000_create_content_table', 1),
(16, '2020_00_00_000000_create_forms_table', 1),
(17, '2020_00_00_000000_create_notifications_table', 1),
(18, '2020_00_00_000000_create_options_table', 1),
(19, '2020_00_00_000000_create_shop_table', 1),
(20, '2020_00_00_00000_create_permission_table', 1),
(21, '2020_00_00_00001_create_roles_table', 1),
(22, '2020_00_00_00002_create_model_has_permissions_table', 1),
(23, '2020_00_00_00003_create_model_has_roles_table', 1),
(24, '2020_00_00_00004_create_role_has_permissions_table', 1),
(25, '2020_03_13_083515_add_description_to_tags_table', 1),
(26, '2020_10_12_100000_create_password_resets_table', 1),
(27, '2020_10_29_090535_create_jobs_table', 1),
(28, '2020_10_29_090855_create_failed_jobs_table', 1),
(29, '2020_11_12_000000_update_customers_table', 1),
(30, '2021_01_13_100000_create_personal_access_clients', 1),
(31, '2021_01_14_000001_update_failed_jobs_table', 1),
(32, '2021_01_14_000003_add_new_fields_on_jobs_table', 1),
(33, '2021_01_19_000000_create_related_content', 1),
(34, '2021_02_04_000000_delete_old_backup_module', 1),
(35, '2021_02_12_000001_create_translation_keys_table', 1),
(36, '2021_02_12_000002_create_translation_texts_table', 1),
(37, '2021_02_19_000000_add_company_details_addresses_table', 1),
(38, '2021_02_24_000000_insert_countries', 1),
(39, '2021_03_04_000001_add_index_to_user_table', 1),
(40, '2021_03_08_000001_add_index_to_translation_tables', 1),
(41, '2021_03_17_000000_create_forms_recipients_table', 1),
(42, '2021_09_01_154745_create_multilanguage_translations', 1),
(43, '2021_09_01_154759_create_multilanguage_supported_locales', 1),
(44, '2021_09_02_000001_add_index_to_multilanguage_tables', 1),
(45, '2021_09_03_133600_change_en_uk_to_en_gb_locale', 1),
(46, '2021_09_08_133600_disable_old_version_multilanguage', 1),
(47, '2021_10_21_000000_create_forms_data_values_table', 1),
(48, '2021_10_22_000000_add_is_read_in_forms_data', 1),
(49, '2021_10_22_000000_add_updated_at_in_forms_data', 1),
(50, '2021_10_22_000000_migrate_old_forms_data', 1),
(51, '2022_00_00_000000_create_content_fields_table', 1),
(52, '2022_07_04_130209_create_menus_table', 1),
(53, '2022_10_04_000001_add_index_content_data_table', 1),
(54, '2022_10_04_000001_add_index_to_multilanguage_tables2', 1),
(55, '2022_12_09_000000_create_categories_table', 1),
(56, '2022_12_16_000000_update_categories_rel_type_in_tables', 1),
(57, '2023_00_00_000000_create_custom_fields_table', 1),
(58, '2023_00_00_000000_create_custom_fields_values_table', 1),
(59, '2023_00_00_000000_create_notifications_mails_log_table', 1),
(60, '2023_03_09_000001_add_name_field_to_users_table', 1),
(61, '2023_04_22_143828_add_locale_to_tagging_tags_table', 1),
(62, '2023_10_12_200000_add_two_factor_columns_to_users_table', 1),
(63, '2023_10_12_200002_add_user_columns_to_sessions_table', 1),
(64, '2023_10_25_000000_migrate_template_options_for_modules', 1),
(65, '2023_11_03_000001_add_two_factor_secret_to_users_table', 1),
(66, '2023_12_05_000000_add_price_modifier_to_custom_fields_values_table', 1),
(67, '2023_12_08_000000_add_uuid_to_media_thumbnails_table', 1),
(68, '2023_12_24_000000_migrate_background_image_module_options', 1),
(69, '2024_01_26_000000_offers_table', 1),
(70, '2024_03_21_000001_combined_tag_migrations', 1),
(71, '2024_03_21_000002_add_locale_to_tagging_tags_table3', 1),
(72, '2024_05_10_000001_migrate_old_version_213', 1),
(73, '2024_18_01_000000_add_html_field_notifications_mails_log_table', 1),
(74, '2020_07_02_000000_create_media_table', 2),
(75, '2020_07_02_000000_create_media_thumbnails_table', 2),
(76, '2021_03_04_000001_update_template_edit_field_names', 3),
(77, '2022_00_00_000001_create_import_feeds_table', 3),
(78, '2022_00_00_000003_create_export_feeds_table', 3),
(79, '2023_00_00_000000_create_comments_table2', 3),
(80, '2023_00_00_000001_add_deleted_at_to_comments_table', 3),
(81, '2023_00_00_000001_create_cart_coupons_log_table', 3);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]model_has_permissions`
--

CREATE TABLE `[[dbprefix]]model_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `model_type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `[[dbprefix]]model_has_permissions_model_type_model_id_index` (`model_type`,`model_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]model_has_roles`
--

CREATE TABLE `[[dbprefix]]model_has_roles` (
  `role_id` int(10) unsigned NOT NULL,
  `model_type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `[[dbprefix]]model_has_roles_model_type_model_id_index` (`model_type`,`model_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]modules`
--

CREATE TABLE `[[dbprefix]]modules` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `updated_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `expires_on` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `edited_by` int(11) DEFAULT NULL,
  `name` text COLLATE utf8_unicode_ci,
  `parent_id` int(11) DEFAULT NULL,
  `module_id` text COLLATE utf8_unicode_ci,
  `module` text COLLATE utf8_unicode_ci,
  `description` text COLLATE utf8_unicode_ci,
  `icon` text COLLATE utf8_unicode_ci,
  `author` text COLLATE utf8_unicode_ci,
  `website` text COLLATE utf8_unicode_ci,
  `help` text COLLATE utf8_unicode_ci,
  `type` text COLLATE utf8_unicode_ci,
  `installed` int(11) DEFAULT NULL,
  `ui` int(11) DEFAULT NULL,
  `position` int(11) DEFAULT NULL,
  `as_element` int(11) DEFAULT NULL,
  `allow_caching` int(11) DEFAULT NULL,
  `ui_admin` int(11) DEFAULT NULL,
  `ui_admin_iframe` int(11) DEFAULT NULL,
  `is_system` int(11) DEFAULT NULL,
  `is_integration` int(11) DEFAULT NULL,
  `version` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `notifications` int(11) DEFAULT NULL,
  `settings` text COLLATE utf8_unicode_ci,
  `categories` text COLLATE utf8_unicode_ci,
  `keywords` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=122 ;

--
-- Dumping data for table `[[dbprefix]]modules`
--

INSERT INTO `[[dbprefix]]modules` VALUES
(1, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Icon', 0, NULL, 'icon', 'Microweber', '{SITE_URL}userfiles/modules/default.svg', 'Microweber', 'http://microweber.com/', 'http://microweber.info/modules/title', NULL, 1, 1, 1, 1, 1, 0, NULL, 0, 0, '0.2', NULL, NULL, 'essentials', NULL),
(2, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Settings', 0, NULL, 'settings', NULL, '{SITE_URL}userfiles/modules/settings/settings.svg', 'Microweber', NULL, NULL, NULL, 1, 0, 4, NULL, 1, 0, NULL, 1, 0, '0.4', NULL, '{"routes":{"admin":"admin.settings.index"},"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/settings\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\Settings"}],"service_provider":["MicroweberPackages\\\\Modules\\\\Settings\\\\Providers\\\\SettingsServiceProvider"]}', 'admin', NULL),
(3, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Website Settings', 0, NULL, 'settings/group/website', NULL, '{SITE_URL}userfiles/modules/default.svg', 'Microweber', NULL, NULL, NULL, 1, 0, 400, NULL, 1, 0, NULL, 1, 0, '0.3', NULL, '{"translatable_options":["website_title","website_description","website_keywords"]}', 'admin', NULL),
(4, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Blog', 0, NULL, 'blog', NULL, '{SITE_URL}userfiles/modules/blog/blog.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 200, NULL, 1, 1, NULL, 1, 0, '0.2', NULL, '{"service_provider":["MicroweberPackages\\\\Blog\\\\BlogServiceProvider"]}', 'content', NULL),
(5, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Pagination', 0, NULL, 'pagination', 'Pagination module for your posts!', '{SITE_URL}userfiles/modules/pagination/pagination.svg', 'Bozhidar Slaveykov', NULL, NULL, NULL, 1, 0, 100, NULL, 1, 0, NULL, 0, 0, '0.01', NULL, NULL, 'navigation', NULL),
(6, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Audio', 0, NULL, 'audio', 'Microweber', '{SITE_URL}userfiles/modules/audio/audio.svg', 'Microweber', 'http://microweber.com/', 'http://microweber.info/modules/audio', NULL, 1, 1, 30, NULL, 1, 0, NULL, 0, 0, '0.20', NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/audio\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\Audio"}],"service_provider":["MicroweberPackages\\\\Modules\\\\Audio\\\\Providers\\\\AudioServiceProvider"]}', 'media', NULL),
(7, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'TOC', 0, NULL, 'toc', NULL, '{SITE_URL}userfiles/modules/default.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 39, NULL, 1, 0, NULL, 0, 0, '1', NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/toc\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\Toc"}],"service_provider":["MicroweberPackages\\\\Modules\\\\Toc\\\\Providers\\\\TocServiceProvider"]}', 'content', NULL),
(8, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Sharer', 0, NULL, 'sharer', NULL, '{SITE_URL}userfiles/modules/sharer/sharer.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 210, NULL, 1, 0, NULL, 0, 0, '1.3', NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/sharer\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\Sharer"}],"service_provider":["MicroweberPackages\\\\Modules\\\\Sharer\\\\Providers\\\\SharerServiceProvider"]}', 'social', NULL),
(9, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Tabs', 0, NULL, 'tabs', NULL, '{SITE_URL}userfiles/modules/tabs/tabs.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 52, NULL, 1, 0, NULL, 0, 0, '0.01', NULL, '{"translatable_options":["settings"],"allowed_html_option_keys":["settings"],"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/tabs\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\Tabs"}],"service_provider":["MicroweberPackages\\\\Modules\\\\Tabs\\\\Providers\\\\TabsServiceProvider"]}', 'miscellaneous', NULL),
(10, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Embed Code', 0, NULL, 'embed', NULL, '{SITE_URL}userfiles/modules/embed/embed.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 38, NULL, 1, 0, NULL, 0, 0, '0.6', NULL, '{"allowed_html_option_keys":["source_code"],"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/embed\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\Embed"}],"service_provider":["MicroweberPackages\\\\Modules\\\\Embed\\\\Providers\\\\EmbedServiceProvider"]}', 'miscellaneous', NULL),
(11, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Title', 0, NULL, 'title', 'Microweber', '{SITE_URL}userfiles/modules/title/title.svg', 'Microweber', 'http://microweber.com/', 'http://microweber.info/modules/title', NULL, 1, 1, 1, 1, 1, 0, NULL, 0, 0, '0.2', NULL, NULL, 'essentials', NULL),
(12, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Pop-Up', 0, NULL, 'popup', NULL, '{SITE_URL}userfiles/modules/popup/popup.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 36, NULL, 1, 0, NULL, 0, 0, '1.1', NULL, NULL, 'miscellaneous', NULL),
(13, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Social Links', 0, NULL, 'social_links', NULL, '{SITE_URL}userfiles/modules/social_links/social_links.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 9, NULL, 1, 0, NULL, 0, 0, '1', NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/social_links\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\SocialLinks"}],"service_provider":["MicroweberPackages\\\\Modules\\\\SocialLinks\\\\Providers\\\\SocialLinksServiceProvider"]}', 'social', NULL),
(14, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Schema.org', 0, NULL, 'schema_org', 'Microweber', '{SITE_URL}userfiles/modules/default.svg', 'Bozhidar Slaveykov', 'http://microweber.com/', NULL, NULL, 1, 0, 100, NULL, 1, 0, NULL, 0, 0, '1', NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/schema_org\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\SchemaOrg"}]}', 'miscellaneous', NULL),
(15, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Rating', 0, NULL, 'rating', 'Microweber', '{SITE_URL}userfiles/modules/rating/rating.svg', 'Microweber', 'http://microweber.com/', 'http://microweber.com', NULL, 1, 0, 100, NULL, 1, 0, NULL, 0, 0, '0.1', NULL, NULL, 'content', NULL),
(16, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Team Card', 0, NULL, 'teamcard', NULL, '{SITE_URL}userfiles/modules/teamcard/teamcard.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 57, NULL, 1, 0, NULL, 0, 0, '0.2', NULL, '{"translatable_options":["settings"],"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/teamcard\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\Teamcard"}],"service_provider":["MicroweberPackages\\\\Modules\\\\Teamcard\\\\Providers\\\\TeamcardServiceProvider"]}', 'miscellaneous', NULL),
(17, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Updates', 0, NULL, 'updates', NULL, '{SITE_URL}userfiles/modules/updates/updates.svg', 'Microweber', NULL, NULL, NULL, 1, 0, 50, NULL, 1, 1, NULL, 1, 0, '0.4', NULL, NULL, 'admin', NULL),
(18, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Table', 0, NULL, 'table', 'Table builder', '{SITE_URL}userfiles/modules/table/table.svg', 'Ezyweb.uk', NULL, NULL, NULL, 1, 0, 99, NULL, 1, 0, NULL, 0, 0, '0.2', NULL, NULL, 'essentials', NULL),
(19, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Slider', 0, NULL, 'slider_v2', NULL, '{SITE_URL}userfiles/modules/default.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 18, NULL, 1, 0, NULL, 0, 0, '0.2', NULL, '{"translatable_options":["settings"],"allowed_html_option_keys":["settings"],"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/slider_v2\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\SliderV2"}],"service_provider":["MicroweberPackages\\\\Modules\\\\SliderV2\\\\Providers\\\\SliderServiceProvider"]}', 'media', NULL),
(20, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Site stats', 0, NULL, 'site_stats', NULL, '{SITE_URL}userfiles/modules/site_stats/site_stats.svg', 'Microweber', NULL, NULL, 'stats', 1, 0, 9999, NULL, 1, 0, NULL, 0, 0, '0.7', NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/site_stats\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\SiteStats"}],"service_provider":["MicroweberPackages\\\\Modules\\\\SiteStats\\\\Providers\\\\SiteStatsServiceProvider"]}', NULL, NULL),
(21, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Posts List', 0, NULL, 'posts', NULL, '{SITE_URL}userfiles/modules/posts/posts.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 20, NULL, 1, 0, NULL, 1, 0, '0.3', NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/posts\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\Posts"}],"service_provider":["MicroweberPackages\\\\Modules\\\\Posts\\\\Providers\\\\PostsServiceProvider"]}', 'essentials', NULL),
(22, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Twitter feed', 0, NULL, 'twitter_feed', 'Feed of tweets', '{SITE_URL}userfiles/modules/twitter_feed/twitter_feed.svg', 'Peter Ivanov', NULL, NULL, NULL, 1, 1, 200, NULL, 1, 0, NULL, 0, 0, '0.4', NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/twitter_feed\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\TwitterFeed"}],"service_provider":["MicroweberPackages\\\\Modules\\\\TwitterFeed\\\\Providers\\\\TwitterFeedServiceProvider"]}', 'social', NULL),
(23, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Digital Download', 0, NULL, 'digital_download', NULL, '{SITE_URL}userfiles/modules/digital_download/digital_download.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 38, NULL, 1, 0, NULL, 0, 0, '0.6', NULL, NULL, 'miscellaneous', NULL),
(24, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Highlight Code', 0, NULL, 'highlight_code', NULL, '{SITE_URL}userfiles/modules/highlight_code/highlight_code.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 700, NULL, 1, 0, NULL, 0, 0, '1.3', NULL, '{"allowed_html_option_keys":["text"],"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/highlight_code\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\HighlightCode"}],"service_provider":["MicroweberPackages\\\\Modules\\\\HighlightCode\\\\Providers\\\\HighlightCodeServiceProvider"]}', 'other', NULL),
(25, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Help', 0, NULL, 'help', NULL, '{SITE_URL}userfiles/modules/help/help.svg', 'Microweber', NULL, NULL, NULL, 1, 0, 80, NULL, 1, 0, NULL, 0, 0, '0.3', NULL, NULL, 'help', NULL),
(26, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Custom fields', 0, NULL, 'custom_fields', NULL, '{SITE_URL}userfiles/modules/custom_fields/custom_fields.svg', 'Microweber', NULL, NULL, NULL, 1, 0, 15, NULL, 1, 0, NULL, 1, 0, NULL, NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/custom_fields\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\CustomFields"}],"service_provider":["MicroweberPackages\\\\Modules\\\\CustomFields\\\\Providers\\\\CustomFieldsServiceProvider"]}', NULL, NULL),
(27, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'FAQ', 0, NULL, 'faq', NULL, '{SITE_URL}userfiles/modules/faq/faq.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 57, NULL, 1, 0, NULL, 0, 0, '0.01', NULL, '{"translatable_options":["settings"],"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/faq\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\Faq"}],"service_provider":["MicroweberPackages\\\\Modules\\\\Faq\\\\Providers\\\\FaqServiceProvider"]}', 'miscellaneous', NULL),
(28, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Cloudflare', 0, NULL, 'cloudflare', 'Microweber', '{SITE_URL}userfiles/modules/default.svg', 'Bozhidar Slaveykov', 'http://microweber.com/', NULL, NULL, 1, 0, 100, NULL, 1, 0, NULL, 0, 0, '1', NULL, NULL, 'miscellaneous', NULL),
(29, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Search', 0, NULL, 'search', 'Module to search for content', '{SITE_URL}userfiles/modules/search/search.svg', 'Microweber', 'http://microweber.com/', 'http://microweber.info/modules/search', NULL, 1, 1, 34, NULL, 1, 0, NULL, 0, 0, '0.2', NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/search\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\Search"}],"service_provider":["MicroweberPackages\\\\Modules\\\\Search\\\\Providers\\\\SearchServiceProvider"]}', 'miscellaneous', NULL),
(30, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Google Maps', 0, NULL, 'google_maps', NULL, '{SITE_URL}userfiles/modules/google_maps/google_maps.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 19, NULL, 1, 0, NULL, 0, 0, '0.6', NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/google_maps\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\GoogleMaps\\\\"}],"service_provider":["MicroweberPackages\\\\Modules\\\\GoogleMaps\\\\Providers\\\\GoogleMapsServiceProvider"]}', 'essentials', NULL),
(31, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Unlock Package', 0, NULL, 'unlock-package', NULL, '{SITE_URL}userfiles/modules/unlock-package/icon.svg', 'Microweber', NULL, NULL, NULL, 1, 0, 999, NULL, 1, 0, NULL, 0, 0, '0.2', NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/unlock-package\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\UnlockPackage"}],"service_provider":["MicroweberPackages\\\\Modules\\\\UnlockPackage\\\\Providers\\\\UnlockPackageServiceProvider"]}', 'essentials', NULL),
(32, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Tweet Embed', 0, NULL, 'tweet_embed', NULL, '{SITE_URL}userfiles/modules/tweet_embed/tweet_embed.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 200, NULL, 1, 0, NULL, 0, 0, '1.1', NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/tweet_embed\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\TweetEmbed"}],"service_provider":["MicroweberPackages\\\\Modules\\\\TweetEmbed\\\\Providers\\\\TweetEmbedServiceProvider"]}', 'social', NULL),
(33, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Inline Table', 0, NULL, 'inline_table', 'Microweber', '{SITE_URL}userfiles/modules/inline_table/inline_table.svg', 'Inline table', 'http://microweber.com/', NULL, NULL, 1, 1, 100, 1, 1, 0, NULL, 0, 0, '1', NULL, NULL, 'miscellaneous', NULL),
(34, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Text Type Animation', 0, NULL, 'text-type', NULL, '{SITE_URL}userfiles/modules/text-type/text-type.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 39, NULL, 1, 0, NULL, 0, 0, '1', NULL, '{"allowed_html_option_keys":["text"],"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/text-type\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\TextType"}],"service_provider":["MicroweberPackages\\\\Modules\\\\TextType\\\\Providers\\\\TextTypeServiceProvider"]}', 'miscellaneous', NULL),
(35, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Facebook Like', 0, NULL, 'facebook_like', NULL, '{SITE_URL}userfiles/modules/facebook_like/facebook_like.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 10, NULL, 1, 0, NULL, 0, 0, '0.06', NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/facebook_like\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\FacebookLike"}],"service_provider":["MicroweberPackages\\\\Modules\\\\FacebookLike\\\\Providers\\\\FacebookLikeServiceProvider"]}', 'social', NULL),
(36, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Comments', 0, NULL, 'comments', NULL, '{SITE_URL}userfiles/modules/comments/comments.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 200, NULL, 1, 1, 1, 0, 0, '1.2', NULL, '{"routes":{"admin":"admin.comments.index"},"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/comments\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\Comments"}],"service_provider":["MicroweberPackages\\\\Modules\\\\Comments\\\\Providers\\\\CommentsServiceProvider"]}', 'content', NULL),
(37, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Spacer', 0, NULL, 'spacer', 'Microweber', '{SITE_URL}userfiles/modules/spacer/spacer.svg', 'Microweber', 'http://microweber.com/', 'http://microweber.info/modules/spacer', NULL, 1, 1, 3, NULL, 1, 0, NULL, 0, 0, '1.1', NULL, NULL, 'essentials', NULL),
(38, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Microweber - Editor Fonts', 0, NULL, 'editor/fonts', NULL, '{SITE_URL}userfiles/modules/default.svg', 'Microweber', NULL, NULL, NULL, 1, 0, 38, NULL, 1, 0, NULL, 0, 0, '0.1', NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/editor\\/fonts\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\Editor\\\\Fonts\\\\FontsSettings"}],"service_provider":["MicroweberPackages\\\\Modules\\\\Editor\\\\Fonts\\\\FontsSettings\\\\Providers\\\\FontsSettingsSettingsServiceProvider"]}', 'miscellaneous', NULL),
(39, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Content Revisions', 0, NULL, 'editor/content_revisions', NULL, '{SITE_URL}userfiles/modules/default.svg', NULL, NULL, NULL, NULL, 1, 0, 28, NULL, 1, 0, NULL, 0, 0, '0.05', NULL, NULL, 'other', NULL),
(40, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Editor Template Settings', 0, NULL, 'editor/template_settings_v2', NULL, '{SITE_URL}userfiles/modules/default.svg', 'Microweber', NULL, NULL, NULL, 1, 0, 200, NULL, 1, 0, NULL, 0, 0, '0.1', NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/editor\\/template_settings_v2\\/src\\/","namespace":"MicroweberPackages\\\\Editor\\\\TemplateSettingsV2\\\\"}],"service_provider":["MicroweberPackages\\\\Editor\\\\TemplateSettingsV2\\\\Providers\\\\EditorTemplateSettingsV2ServiceProvider"]}', NULL, NULL),
(41, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Accordion', 0, NULL, 'accordion', NULL, '{SITE_URL}userfiles/modules/accordion/accordion.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 52, NULL, 1, 0, NULL, 0, 0, '0.01', NULL, '{"translatable_options":["settings"],"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/accordion\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\Accordion"}],"service_provider":["MicroweberPackages\\\\Modules\\\\Accordion\\\\Providers\\\\AccordionServiceProvider"]}', 'miscellaneous', NULL),
(42, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'White label', 0, NULL, 'white_label', NULL, '{SITE_URL}userfiles/modules/white_label/white_label.svg', 'Microweber', NULL, NULL, NULL, 1, 0, 500, NULL, 1, 1, NULL, 0, 0, '0.4', NULL, '[]', 'advanced', NULL),
(43, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'White label WHMCS', 0, NULL, 'white_label/whmcs', NULL, '{SITE_URL}userfiles/modules/default.svg', 'Microweber', NULL, NULL, NULL, 1, 0, 500, NULL, 1, 0, NULL, 0, 0, '0.1', NULL, NULL, 'advanced', NULL),
(44, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Color Schemes', 0, NULL, 'white_label/admin_colors', NULL, '{SITE_URL}userfiles/modules/default.svg', NULL, NULL, NULL, NULL, 1, 0, 999, NULL, 1, 0, NULL, 0, 0, '0.1', NULL, NULL, 'other', NULL),
(45, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Templates Settings', 0, NULL, 'admin/modules/templates_settings', NULL, '{SITE_URL}userfiles/modules/admin/modules/templates_settings/icon.svg', 'Microweber', NULL, NULL, NULL, 1, 0, 0, NULL, 1, 0, NULL, 1, 0, '0.1', NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/admin\\/modules\\/templates_settings\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\Admin\\\\Modules\\\\TemplatesSettings"}],"service_provider":["MicroweberPackages\\\\Modules\\\\Admin\\\\Modules\\\\TemplatesSettings\\\\Providers\\\\TemplatesSettingsServiceProvider"]}', 'essentials', NULL),
(46, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Notifications', 0, NULL, 'admin/notifications', NULL, '{SITE_URL}userfiles/modules/admin/notifications/notifications.svg', 'Microweber', NULL, NULL, NULL, 1, 0, 1, NULL, 1, 1, NULL, 1, 0, '0.3', NULL, NULL, 'admin', NULL),
(47, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Import', 0, NULL, 'admin/old_import', NULL, '{SITE_URL}userfiles/modules/default.svg', 'Microweber', NULL, NULL, NULL, 1, 0, 99, NULL, 1, 0, NULL, 0, 0, '0.3', NULL, NULL, 'admin', NULL),
(48, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Queue', 0, NULL, 'admin/mics/queue', NULL, '{SITE_URL}userfiles/modules/default.svg', 'Microweber', NULL, NULL, NULL, 1, 0, NULL, NULL, 1, 0, NULL, 1, 0, '0.4', NULL, NULL, 'admin', NULL),
(49, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Content Export', 0, NULL, 'admin/content_export', NULL, '{SITE_URL}userfiles/modules/admin/content_export/content_export.svg', 'Microweber', NULL, NULL, NULL, 1, 0, 99, NULL, 1, 0, NULL, 0, 0, '0.3', NULL, NULL, 'admin', NULL),
(50, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Import Export Tool', 0, NULL, 'admin/import_export_tool', NULL, '{SITE_URL}userfiles/modules/admin/import_export_tool/import_export_tool.svg', 'Microweber', NULL, NULL, NULL, 1, 0, 99, NULL, 1, 1, NULL, 0, 0, '0.3', NULL, '{"routes":{"admin":"admin.import-export-tool.index"},"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/admin\\/import_export_tool\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\Admin\\\\ImportExportTool\\\\"}],"service_provider":["MicroweberPackages\\\\Modules\\\\Admin\\\\ImportExportTool\\\\ImportExportToolServiceProvider"]}', 'admin', NULL),
(51, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Admin Components - File Append', 0, NULL, 'admin/components/file_append', NULL, '{SITE_URL}userfiles/modules/default.svg', 'Microweber', NULL, NULL, NULL, 1, 0, 7, NULL, 1, 0, NULL, 1, 0, '1.1', NULL, '{"translatable_options":["append_files"]}', 'essentials', NULL),
(52, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Mail Providers', 0, NULL, 'admin/mail_providers', NULL, '{SITE_URL}userfiles/modules/admin/mail_providers/mail_providers.svg', 'Microweber', NULL, NULL, 'mail_providers_configuration', 1, 0, 100, NULL, 1, 0, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(53, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'MailerLite', 0, NULL, 'admin/mail_providers/mailerlite', NULL, '{SITE_URL}userfiles/modules/admin/mail_providers/mailerlite/mailerlite.svg', 'Microweber', NULL, NULL, 'mail_provider', 1, 0, 100, NULL, 1, 0, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(54, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'FlexMail', 0, NULL, 'admin/mail_providers/flexmail', NULL, '{SITE_URL}userfiles/modules/admin/mail_providers/flexmail/flexmail.svg', 'Microweber', NULL, NULL, 'mail_provider', 1, 0, 100, NULL, 1, 0, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(55, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Mail Templates', 0, NULL, 'admin/mail_templates', NULL, '{SITE_URL}userfiles/modules/admin/mail_templates/mail_templates.svg', 'Microweber', NULL, NULL, NULL, 1, 0, 100, NULL, 1, 0, NULL, 0, 0, NULL, NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/admin\\/mail_templates\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\MailTemplates"}],"service_provider":["MicroweberPackages\\\\Modules\\\\MailTemplates\\\\MailTemplatesServiceProvider"]}', NULL, NULL),
(56, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Backup', 0, NULL, 'admin/backup', NULL, '{SITE_URL}userfiles/modules/admin/backup/backup.svg', 'Microweber', NULL, NULL, NULL, 1, 0, 99, NULL, 1, 1, NULL, 0, 0, '2', NULL, NULL, 'admin', NULL),
(57, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Marquee', 0, NULL, 'marquee', NULL, '{SITE_URL}userfiles/modules/marquee/marquee.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 39, NULL, 1, 0, NULL, 0, 0, '1', NULL, '{"allowed_html_option_keys":["text"],"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/marquee\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\Marquee"}],"service_provider":["MicroweberPackages\\\\Modules\\\\Marquee\\\\Providers\\\\MarqueeServiceProvider"]}', 'miscellaneous', NULL),
(58, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Users', 0, NULL, 'users', NULL, '{SITE_URL}userfiles/modules/users/users.svg', 'Microweber', NULL, NULL, NULL, 1, 0, 9, NULL, 1, 1, NULL, 1, 0, '0.4', NULL, NULL, 'users', NULL),
(59, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Login', 0, NULL, 'users/login', NULL, '{SITE_URL}userfiles/modules/users/login/login.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 32, NULL, 0, 0, NULL, 0, 0, '0.2', NULL, NULL, 'users', NULL),
(60, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Registration', 0, NULL, 'users/register', 'Microweber', '{SITE_URL}userfiles/modules/users/register/register.svg', 'Microweber', 'http://microweber.com/', 'http://microweber.info/modules/users/registration', NULL, 1, 1, 33, NULL, 1, 0, NULL, 0, 0, '0.2', NULL, NULL, 'users', NULL),
(61, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'User Address', 0, NULL, 'users/profile/address', NULL, '{SITE_URL}userfiles/modules/users/profile/address/address.svg', 'Bozhidar Slaveykov', NULL, NULL, NULL, 1, 0, 9, NULL, 1, 0, NULL, 0, 0, '0.1', NULL, NULL, NULL, NULL),
(62, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Forgot password', 0, NULL, 'users/forgot_password', 'Microweber', '{SITE_URL}userfiles/modules/users/forgot_password/forgot_password.svg', 'Microweber', 'http://microweber.com/', 'http://microweber.info/modules/users/registration', NULL, 1, 1, 31, NULL, 1, 0, NULL, 0, 0, '0.2', NULL, NULL, 'users', NULL),
(63, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Examples of Microweber UI', 0, NULL, 'example_ui', NULL, '{SITE_URL}userfiles/modules/default.svg', 'Microweber', NULL, NULL, NULL, 1, 0, 999, NULL, 1, 0, NULL, 0, 0, '0.2', NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/example_ui\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\ExampleUi"}],"service_provider":["MicroweberPackages\\\\Modules\\\\ExampleUi\\\\Providers\\\\ExampleUiServiceProvider"]}', 'miscellaneous', NULL),
(64, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Cookie Notice', 0, NULL, 'cookie_notice', NULL, '{SITE_URL}userfiles/modules/cookie_notice/cookie_notice.svg', 'Ezyweb.uk', NULL, NULL, NULL, 1, 0, 99, NULL, 1, 1, NULL, 0, 0, '0.1', NULL, NULL, 'content', NULL),
(65, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Text', 0, NULL, 'text', 'Simple text', '{SITE_URL}userfiles/modules/text/text.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 2, 1, 1, 0, NULL, 0, 0, '0.2', NULL, NULL, 'essentials', NULL),
(66, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Empty Element', 0, NULL, 'text/empty_element', 'Microweber', '{SITE_URL}userfiles/modules/text/empty_element.svg', 'Microweber', 'http://microweber.com/', 'http://microweber.info/modules/title', NULL, 1, 1, 5, 1, 1, 0, NULL, 0, 0, '0.2', NULL, NULL, 'essentials', NULL),
(67, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Multiple Columns', 0, NULL, 'text/multiple_columns', 'Microweber', '{SITE_URL}userfiles/modules/text/multiple_columns.svg', 'Microweber', 'http://microweber.com/', 'http://microweber.info/modules/title', NULL, 1, 1, 8, 1, 1, 0, NULL, 0, 0, '0.2', NULL, NULL, 'essentials', NULL),
(68, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Video', 0, NULL, 'video', NULL, '{SITE_URL}userfiles/modules/video/video.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 6, NULL, 1, 0, NULL, 0, 0, '1.2', NULL, '{"allowed_html_option_keys":["embed_url"],"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/video\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\Video"}],"service_provider":["MicroweberPackages\\\\Modules\\\\Video\\\\Providers\\\\VideoServiceProvider"]}', 'media', NULL),
(69, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Picture Gallery', 0, NULL, 'pictures', NULL, '{SITE_URL}userfiles/modules/pictures/pictures.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 4, NULL, 1, 0, NULL, 1, 0, '1.11', NULL, '[]', 'media', NULL),
(70, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Newsletter', 0, NULL, 'newsletter', NULL, '{SITE_URL}userfiles/modules/newsletter/newsletter.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 55, NULL, 1, 1, NULL, 0, 0, '2.0', NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/newsletter\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\Newsletter"}],"service_provider":["MicroweberPackages\\\\Modules\\\\Newsletter\\\\Providers\\\\NewsletterServiceProvider"]}', 'marketing', NULL),
(71, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Tags', 0, NULL, 'tags', 'Tags module for your posts!', '{SITE_URL}userfiles/modules/tags/tags.svg', 'Bozhidar Slaveykov', NULL, NULL, NULL, 1, 1, 100, NULL, 1, 1, NULL, 0, 0, '0.1', NULL, NULL, 'miscellaneous', NULL),
(72, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Before/After', 0, NULL, 'beforeafter', NULL, '{SITE_URL}userfiles/modules/beforeafter/beforeafter.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 37, NULL, 1, 0, NULL, 0, 0, '1', NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/beforeafter\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\BeforeAfter"}],"service_provider":["MicroweberPackages\\\\Modules\\\\BeforeAfter\\\\Providers\\\\BeforeAfterServiceProvider"]}', 'media', NULL),
(73, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Testimonials', 0, NULL, 'testimonials', NULL, '{SITE_URL}userfiles/modules/testimonials/testimonials.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 99, NULL, 1, 1, NULL, 0, 0, '0.4', NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/testimonials\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\Testimonials"}],"service_provider":["MicroweberPackages\\\\Modules\\\\Testimonials\\\\Providers\\\\TestimonialsServiceProvider"]}', 'miscellaneous', NULL),
(74, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Facebook page', 0, NULL, 'facebook_page', 'Facebook page integration for your website!', '{SITE_URL}userfiles/modules/facebook_page/facebook_page.svg', '', NULL, NULL, NULL, 1, 1, 11, NULL, 1, 0, NULL, 0, 0, '0.01', NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/facebook_page\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\FacebookPage"}],"service_provider":["MicroweberPackages\\\\Modules\\\\FacebookPage\\\\Providers\\\\FacebookPageServiceProvider"]}', 'social', NULL),
(75, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Breadcrumb', 0, NULL, 'breadcrumb', 'Breadcrumb navigation', '{SITE_URL}userfiles/modules/default.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 54, NULL, 1, 0, NULL, 0, 0, '0.3', NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/breadcrumb\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\Breadcrumb"}],"service_provider":["MicroweberPackages\\\\Modules\\\\Breadcrumb\\\\Providers\\\\BreadcrumbServiceProvider"]}', 'miscellaneous', NULL),
(76, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Image Rollover', 0, NULL, 'image_rollover', NULL, '{SITE_URL}userfiles/modules/image_rollover/image_rollover.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 7, NULL, 1, 0, NULL, 0, 0, '1', NULL, NULL, 'media', NULL),
(77, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Multilanguage', 0, NULL, 'multilanguage', NULL, '{SITE_URL}userfiles/modules/multilanguage/multilanguage.svg', 'Bozhidar Slaveykov', NULL, NULL, NULL, 1, 1, 99, NULL, 1, 1, NULL, 0, 0, '4', NULL, NULL, 'miscellaneous', NULL),
(78, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Standalone Updater', 0, NULL, 'standalone-updater', NULL, '{SITE_URL}userfiles/modules/standalone-updater/standalone-updater.svg', 'bobi@microweber.com', NULL, NULL, NULL, 1, 0, 1, NULL, 1, 1, NULL, 1, 0, '5.3.8', NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/standalone-updater\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\StandaloneUpdater"}],"service_provider":["MicroweberPackages\\\\Modules\\\\StandaloneUpdater\\\\StandaloneUpdaterServiceProvider"]}', 'other', NULL),
(79, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'PDF', 0, NULL, 'pdf', NULL, '{SITE_URL}userfiles/modules/pdf/pdf.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 40, NULL, 1, 0, NULL, 0, 0, '1.1', NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/pdf\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\Pdf"}],"service_provider":["MicroweberPackages\\\\Modules\\\\Pdf\\\\Providers\\\\PdfServiceProvider"]}', 'miscellaneous', NULL),
(80, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Pages Menu', 0, NULL, 'pages', NULL, '{SITE_URL}userfiles/modules/pages/pages.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 28, NULL, 1, 0, NULL, 1, 0, '1.2', NULL, NULL, 'navigation', NULL),
(81, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Categories', 0, NULL, 'categories', NULL, '{SITE_URL}userfiles/modules/categories/categories.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 29, NULL, 1, 0, NULL, 1, 0, '0.1', NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/categories\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\Categories"}],"service_provider":["MicroweberPackages\\\\Modules\\\\Categories\\\\Providers\\\\CategoryServiceProvider"]}', 'navigation', NULL),
(82, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Categories Images', 0, NULL, 'categories/category_images', NULL, '{SITE_URL}userfiles/modules/categories/category_images/category_images.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 51, NULL, 1, 0, NULL, 1, 0, '0.1', NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/categories\\/category_images\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\Categories\\\\CategoryImages"}],"service_provider":["MicroweberPackages\\\\Modules\\\\Categories\\\\CategoryImages\\\\Providers\\\\CategoryImagesServiceProvider"]}', 'miscellaneous', NULL),
(83, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Logo', 0, NULL, 'logo', NULL, '{SITE_URL}userfiles/modules/logo/logo.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 39, NULL, 1, 0, NULL, 0, 0, '1.1', NULL, '{"translatable_options":["text","font_family","logotype","logoimage","size","settings"],"allowed_html_option_keys":["text"],"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/logo\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\Logo"}],"service_provider":["MicroweberPackages\\\\Modules\\\\Logo\\\\Providers\\\\LogoServiceProvider"]}', 'miscellaneous', NULL),
(84, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Layout Content', 0, NULL, 'layout_content', NULL, '{SITE_URL}userfiles/modules/layout_content/icon.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 0, NULL, 1, 0, NULL, 0, 0, '0.1', NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/layout_content\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\LayoutContent"}],"service_provider":["MicroweberPackages\\\\Modules\\\\LayoutContent\\\\Providers\\\\LayoutContentServiceProvider"]}', 'essentials', NULL),
(85, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Online shop', 0, NULL, 'shop', NULL, '{SITE_URL}userfiles/modules/shop/shop.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 200, NULL, 1, 1, NULL, 0, 0, '0.4', NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/shop\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\Shop"}],"service_provider":["MicroweberPackages\\\\Shop\\\\ShopServiceProvider","MicroweberPackages\\\\Modules\\\\Shop\\\\Providers\\\\ShopServiceProvider"]}', 'store', NULL),
(86, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Taxes', 0, NULL, 'shop/taxes', NULL, '{SITE_URL}userfiles/modules/shop/taxes/taxes.svg', 'Bozhidar Slaveykov', NULL, NULL, NULL, 1, 0, 30, NULL, 1, 0, NULL, 0, 0, '0.24', NULL, NULL, 'online shop', NULL),
(87, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Shipping', 0, NULL, 'shop/shipping', NULL, '{SITE_URL}userfiles/modules/shop/shipping/shipping.svg', 'Microweber', NULL, NULL, NULL, 1, 0, 26, NULL, 1, 1, NULL, 0, 0, '0.3', NULL, NULL, 'online shop', NULL),
(88, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Pickup from address', 0, NULL, 'shop/shipping/gateways/pickup', NULL, '{SITE_URL}userfiles/modules/shop/shipping/gateways/pickup/pickup.svg', 'Microweber', NULL, NULL, 'shipping_gateway', 1, 0, 900, NULL, 1, 0, NULL, 0, 0, '0.3', NULL, '{"checkout_position":0,"icon_class":"mdi mdi-walk","help_text":"get your order from address below","autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/shop\\/shipping\\/gateways\\/pickup\\/src\\/","namespace":"MicroweberPackages\\\\Shop\\\\Shipping\\\\Gateways\\\\Pickup\\\\"}],"service_provider":["MicroweberPackages\\\\Shop\\\\Shipping\\\\Gateways\\\\Pickup\\\\PickupEventServiceProvider","MicroweberPackages\\\\Shop\\\\Shipping\\\\Gateways\\\\Pickup\\\\PickupServiceProvider"]}', 'online shop', NULL),
(89, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Shipping to address', 0, NULL, 'shop/shipping/gateways/country', NULL, '{SITE_URL}userfiles/modules/shop/shipping/gateways/country/country.svg', 'Microweber', NULL, NULL, 'shipping_gateway', 1, 0, 100, NULL, 1, 0, NULL, 0, 0, '0.3', NULL, '{"checkout_position":1,"icon_class":"mdi mdi-truck-check-outline","help_text":"The order will be delivered to your address","autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/shop\\/shipping\\/gateways\\/country\\/src\\/","namespace":"MicroweberPackages\\\\Shop\\\\Shipping\\\\Gateways\\\\Country\\\\"}],"service_provider":["MicroweberPackages\\\\Shop\\\\Shipping\\\\Gateways\\\\Country\\\\ShippingToCountryEventServiceProvider","MicroweberPackages\\\\Shop\\\\Shipping\\\\Gateways\\\\Country\\\\ShippingToCountryServiceProvider"]}', 'online shop', NULL),
(90, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Checkout', 0, NULL, 'shop/checkout', NULL, '{SITE_URL}userfiles/modules/shop/checkout/checkout.svg', 'Microweber', NULL, NULL, NULL, 1, 0, 94, NULL, 0, 0, NULL, 0, 0, '0.3', NULL, NULL, 'online shop', NULL),
(91, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Products', 0, NULL, 'shop/products', NULL, '{SITE_URL}userfiles/modules/shop/products/products.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 32, NULL, 1, 1, NULL, 0, 0, '0.41', NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/shop\\/products\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\Shop\\\\Products"}],"service_provider":["MicroweberPackages\\\\Modules\\\\Shop\\\\Products\\\\Providers\\\\ProductsServiceProvider"]}', 'store', NULL),
(92, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Coupons', 0, NULL, 'shop/coupons', NULL, '{SITE_URL}userfiles/modules/shop/coupons/coupons.svg', 'Bozhidar Slaveykov', NULL, NULL, NULL, 1, 0, 26, NULL, 1, 1, NULL, 0, 0, '0.6', NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/shop\\/coupons\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\Shop\\\\Coupons\\\\"}],"service_provider":["MicroweberPackages\\\\Modules\\\\Shop\\\\Coupons\\\\Providers\\\\ShopCouponServiceProvider","MicroweberPackages\\\\Modules\\\\Shop\\\\Coupons\\\\Providers\\\\ShopCouponEventServiceProvider"]}', 'online shop', NULL),
(93, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Shopping Cart', 0, NULL, 'shop/cart', NULL, '{SITE_URL}userfiles/modules/shop/cart/cart.svg', 'Microweber', NULL, NULL, NULL, 1, 0, 23, NULL, 0, 0, NULL, 0, 0, '0.24', NULL, NULL, 'online shop', NULL),
(94, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Offers', 0, NULL, 'shop/offers', NULL, '{SITE_URL}userfiles/modules/shop/offers/offers.svg', 'Microweber', NULL, NULL, NULL, 1, 0, 27, NULL, 1, 1, NULL, 0, 0, '1.1', NULL, '{"service_provider":["MicroweberPackages\\\\Offer\\\\Providers\\\\EventServiceProvider","MicroweberPackages\\\\Offer\\\\Providers\\\\OfferServiceProvider"]}', 'online shop', NULL),
(95, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Customers', 0, NULL, 'shop/customers', NULL, '{SITE_URL}userfiles/modules/default.svg', 'Microweber', NULL, NULL, NULL, 1, 0, 2, NULL, 1, 0, NULL, 0, 0, '0.3', NULL, NULL, 'online shop', NULL),
(96, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Payments', 0, NULL, 'shop/payments', NULL, '{SITE_URL}userfiles/modules/shop/payments/payments.svg', 'Microweber', NULL, NULL, NULL, 1, 0, 27, NULL, 1, 1, NULL, 0, 0, '0.3', NULL, NULL, 'online shop', NULL),
(97, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'VoguePay payment', 0, NULL, 'shop/payments/gateways/voguepay', NULL, '{SITE_URL}userfiles/modules/shop/payments/gateways/voguepay/voguepay.png', 'Microweber', NULL, NULL, 'deprecated_payment_gateway', 1, 0, 139, NULL, 1, 0, NULL, 0, 0, NULL, NULL, NULL, 'online shop', NULL),
(98, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Przelewy24', 0, NULL, 'shop/payments/gateways/omnipay_przelewy24', NULL, '{SITE_URL}userfiles/modules/shop/payments/gateways/omnipay_przelewy24/omnipay_przelewy24.svg', 'Microweber', NULL, NULL, 'payment_gateway', 1, 0, 136, NULL, 1, 0, NULL, 0, 0, NULL, NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/shop\\/payments\\/gateways\\/omnipay_przelewy24\\/src\\/","namespace":"MicroweberPackages\\\\Payment\\\\Providers\\\\Przelewy24\\\\"}],"service_provider":["MicroweberPackages\\\\Payment\\\\Providers\\\\Przelewy24\\\\Przelewy24ServiceProvider"]}', 'online shop', NULL),
(99, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Bank Transfer', 0, NULL, 'shop/payments/gateways/bank_transfer', NULL, '{SITE_URL}userfiles/modules/shop/payments/gateways/bank_transfer/bank_transfer.svg', 'Bozhidar Slaveykov', NULL, NULL, 'payment_gateway', 1, 0, 110, NULL, 1, 0, NULL, 0, 0, '1.0', NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/shop\\/payments\\/gateways\\/bank_transfer\\/src\\/","namespace":"MicroweberPackages\\\\Payment\\\\Providers\\\\BankTransfer\\\\"}],"service_provider":["MicroweberPackages\\\\Payment\\\\Providers\\\\BankTransfer\\\\BankTransferServiceProvider"]}', 'online shop', NULL),
(100, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Pay on delivery', 0, NULL, 'shop/payments/gateways/pay_on_delivery', NULL, '{SITE_URL}userfiles/modules/shop/payments/gateways/pay_on_delivery/pay_on_delivery.svg', 'D.Velev (colocation.bg)', NULL, NULL, 'payment_gateway', 1, 0, 130, NULL, 1, 0, NULL, 0, 0, NULL, NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/shop\\/payments\\/gateways\\/pay_on_delivery\\/src\\/","namespace":"MicroweberPackages\\\\Payment\\\\Providers\\\\PayOnDelivery\\\\"}],"service_provider":["MicroweberPackages\\\\Payment\\\\Providers\\\\PayOnDelivery\\\\PayOnDeliveryServiceProvider"]}', 'online shop', NULL),
(101, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Authorize.Net', 0, NULL, 'shop/payments/gateways/omnipay_authorize_aim', NULL, '{SITE_URL}userfiles/modules/shop/payments/gateways/omnipay_authorize_aim/omnipay_authorize_aim.svg', 'Microweber', NULL, NULL, 'deprecated_payment_gateway', 1, 0, 132, NULL, 1, 0, NULL, 0, 0, NULL, NULL, NULL, 'online shop', NULL),
(102, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Paypal Express', 0, NULL, 'shop/payments/gateways/paypal', NULL, '{SITE_URL}userfiles/modules/shop/payments/gateways/paypal/paypal.svg', 'Microweber', NULL, NULL, 'payment_gateway', 1, 0, 110, NULL, 1, 0, NULL, 0, 0, NULL, NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/shop\\/payments\\/gateways\\/paypal\\/src\\/","namespace":"MicroweberPackages\\\\Payment\\\\Providers\\\\Paypal\\\\"}],"service_provider":["MicroweberPackages\\\\Payment\\\\Providers\\\\Paypal\\\\PaypalServiceProvider"]}', 'online shop', NULL),
(103, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Paypal Pro', 0, NULL, 'shop/payments/gateways/paypal_pro', NULL, '{SITE_URL}userfiles/modules/shop/payments/gateways/paypal_pro/paypal_pro.svg', 'Microweber', NULL, NULL, 'deprecated_payment_gateway', 1, 0, 111, NULL, 1, 0, NULL, 0, 0, NULL, NULL, NULL, 'online shop', NULL),
(104, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Stripe payment', 0, NULL, 'shop/payments/gateways/omnipay_stripe', NULL, '{SITE_URL}userfiles/modules/shop/payments/gateways/omnipay_stripe/omnipay_stripe.svg', 'Microweber', NULL, NULL, 'payment_gateway', 1, 0, 132, NULL, 1, 0, NULL, 0, 0, NULL, NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/shop\\/payments\\/gateways\\/omnipay_stripe\\/src\\/","namespace":"MicroweberPackages\\\\Payment\\\\Providers\\\\Stripe\\\\"}],"service_provider":["MicroweberPackages\\\\Payment\\\\Providers\\\\Stripe\\\\StripeServiceProvider"]}', 'online shop', NULL),
(105, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Mollie payment', 0, NULL, 'shop/payments/gateways/omnipay_mollie', NULL, '{SITE_URL}userfiles/modules/shop/payments/gateways/omnipay_mollie/omnipay_mollie.svg', 'Microweber', NULL, NULL, 'payment_gateway', 1, 0, 136, NULL, 1, 0, NULL, 0, 0, NULL, NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/shop\\/payments\\/gateways\\/omnipay_mollie\\/src\\/","namespace":"MicroweberPackages\\\\Payment\\\\Providers\\\\Mollie\\\\"}],"service_provider":["MicroweberPackages\\\\Payment\\\\Providers\\\\Mollie\\\\MollieServiceProvider"]}', 'online shop', NULL),
(106, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Invoices', 0, NULL, 'shop/invoices', NULL, '{SITE_URL}userfiles/modules/default.svg', 'Microweber', NULL, NULL, NULL, 1, 0, 2, NULL, 1, 0, NULL, 0, 0, '0.3', NULL, NULL, 'online shop', NULL),
(107, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Add to cart', 0, NULL, 'shop/cart_add', NULL, '{SITE_URL}userfiles/modules/shop/cart_add/cart_add.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 25, NULL, 0, 0, NULL, 0, 0, '0.26', NULL, NULL, 'store', NULL),
(108, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Contact form', 0, NULL, 'contact_form', NULL, '{SITE_URL}userfiles/modules/contact_form/contact_form.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 15, NULL, 1, 1, NULL, 1, 1, '0.2', NULL, '{"translatable_options":["email_autorespond_subject","email_autorespond"],"routes":{"admin":"admin.contact-form.index"},"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/contact_form\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\ContactForm\\\\"}],"service_provider":["MicroweberPackages\\\\Modules\\\\ContactForm\\\\ContactFormServiceProvider"]}', 'essentials', NULL);
INSERT INTO `[[dbprefix]]modules` VALUES
(109, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Button', 0, NULL, 'btn', NULL, '{SITE_URL}userfiles/modules/btn/btn.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 7, NULL, 1, 0, NULL, 1, 0, '1.1', NULL, '{"translatable_options":["button_action","button_onclick","popupcontent","url_blank","icon","text","url","link"],"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/btn\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\Btn"}],"service_provider":["MicroweberPackages\\\\Modules\\\\Btn\\\\Providers\\\\BtnServiceProvider"]}', 'essentials', NULL),
(110, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Google Analytics', 0, NULL, 'google_analytics', NULL, '{SITE_URL}userfiles/modules/google_analytics/google_analytics.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 200, NULL, 1, 1, 1, 0, 0, '1.2', NULL, '{"routes":{"admin":"admin.google_analytics.index"},"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/google_analytics\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\GoogleAnalytics"}],"service_provider":["MicroweberPackages\\\\Modules\\\\GoogleAnalytics\\\\Providers\\\\GoogleAnalyticsServiceProvider"]}', 'content', NULL),
(111, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Video Background', 0, NULL, 'video_background', NULL, '{SITE_URL}userfiles/modules/video_background/video_background.svg', 'Microweber', NULL, NULL, NULL, 1, 0, 38, NULL, 1, 0, NULL, 0, 0, '1', NULL, NULL, 'video, background', NULL),
(112, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Menu', 0, NULL, 'menu', 'Navigation menu for pages and links.', '{SITE_URL}userfiles/modules/menu/menu.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 27, NULL, 1, 1, NULL, 0, 0, '0.5', NULL, NULL, 'essentials', NULL),
(113, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Background Image', 0, NULL, 'background', 'Microweber', '{SITE_URL}userfiles/modules/background/background.svg', 'Microweber', 'http://microweber.com/', 'http://microweber.com/modules/background', NULL, 1, 0, 333, NULL, 1, 0, NULL, 0, 0, '1.2', NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/background\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\Background"}],"service_provider":["MicroweberPackages\\\\Modules\\\\Background\\\\Providers\\\\BackgroundImageServiceProvider"]}', 'media', NULL),
(114, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Content', 0, NULL, 'content', 'Shows dynamic content', '{SITE_URL}userfiles/modules/content/content.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 22, NULL, 1, 0, NULL, 0, 0, '0.1', NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/content\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\Content"}],"service_provider":["MicroweberPackages\\\\Modules\\\\Content\\\\Providers\\\\ContentServiceProvider"]}', 'essentials', NULL),
(115, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Layouts', 0, NULL, 'layouts', NULL, '{SITE_URL}userfiles/modules/layouts/layouts.svg', 'Microweber', NULL, NULL, NULL, 1, 0, 99, NULL, 1, 0, NULL, 0, 0, '0.1', NULL, '{"translatable_options":["title","type","icon","view"]}', 'content', NULL),
(116, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Layouts - Preview All', 0, NULL, 'layouts/preview-all', NULL, '{SITE_URL}userfiles/modules/layouts/preview-all/icon.svg', 'Microweber', NULL, NULL, NULL, 1, 0, 0, NULL, 1, 0, NULL, 0, 0, '0.1', NULL, '{"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/layouts\\/preview-all\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\Layouts\\\\PreviewAll"}],"service_provider":["MicroweberPackages\\\\Modules\\\\Layouts\\\\PreviewAll\\\\Providers\\\\LayoutsPreviewAllServiceProvider"]}', 'essentials', NULL),
(117, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Skills', 0, NULL, 'skills', NULL, '{SITE_URL}userfiles/modules/skills/skills.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 41, NULL, 1, 0, NULL, 0, 0, '1.2', NULL, NULL, 'other', NULL),
(118, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Files', 0, NULL, 'files', NULL, '{SITE_URL}userfiles/modules/files/files.svg', 'Microweber', NULL, NULL, NULL, 1, 0, 20, NULL, 1, 1, NULL, 0, 0, '0.2', NULL, NULL, 'media', NULL),
(119, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Slider (Deprecated)', 0, NULL, 'slider', NULL, '{SITE_URL}userfiles/modules/slider/slider.svg', 'Microweber', NULL, NULL, NULL, 1, 0, 18, NULL, 1, 0, NULL, 0, 0, '0.2', NULL, '{"translatable_options":["settings"],"allowed_html_option_keys":["settings"],"autoload_namespace":[{"path":"[[softpath_]]\\/userfiles\\/modules\\/slider\\/src\\/","namespace":"MicroweberPackages\\\\Modules\\\\Slider"}],"service_provider":["MicroweberPackages\\\\Modules\\\\Slider\\\\Providers\\\\SliderServiceProvider"]}', 'media', NULL),
(120, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Picture', 0, NULL, 'picture', 'Picture', '{SITE_URL}userfiles/modules/picture/picture.svg', 'Microweber', NULL, NULL, NULL, 1, 1, 3, 1, 1, 0, NULL, 0, 0, '0.25', NULL, NULL, 'essentials', 'picture,gallery,images,photos,slider,carousel,lightbox,photo,pictures'),
(121, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 'Captcha', 0, NULL, 'captcha', NULL, '{SITE_URL}userfiles/modules/captcha/captcha.svg', 'Microweber', NULL, NULL, NULL, 1, 0, 99, NULL, 0, 1, NULL, 0, 0, '0.1', NULL, NULL, 'users', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]module_templates`
--

CREATE TABLE `[[dbprefix]]module_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `updated_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `edited_by` int(11) DEFAULT NULL,
  `module_id` text COLLATE utf8_unicode_ci,
  `name` text COLLATE utf8_unicode_ci,
  `module` text COLLATE utf8_unicode_ci,
  `module_attrs` text COLLATE utf8_unicode_ci,
  `position` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]multilanguage_supported_locales`
--

CREATE TABLE `[[dbprefix]]multilanguage_supported_locales` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `locale` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `language` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `display_locale` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `display_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `display_icon` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `position` int(11) DEFAULT NULL,
  `is_active` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]multilanguage_supported_locales_locale_index` (`locale`),
  KEY `[[dbprefix]]multilanguage_supported_locales_language_index` (`language`),
  KEY `[[dbprefix]]multilanguage_supported_locales_is_active_index` (`is_active`),
  KEY `[[dbprefix]]multilanguage_supported_locales_display_locale_index` (`display_locale`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]multilanguage_supported_locales`
--

INSERT INTO `[[dbprefix]]multilanguage_supported_locales` VALUES
(1, 'en_US', 'en_US', NULL, NULL, NULL, 1, 'y', NULL, '2023-10-26 16:24:53');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]multilanguage_translations`
--

CREATE TABLE `[[dbprefix]]multilanguage_translations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `rel_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `rel_type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `field_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `field_value` text COLLATE utf8_unicode_ci,
  `locale` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]multilanguage_translations_locale_index` (`locale`),
  KEY `[[dbprefix]]multilanguage_translations_rel_id_index` (`rel_id`),
  KEY `[[dbprefix]]multilanguage_translations_rel_type_index` (`rel_type`),
  KEY `[[dbprefix]]multilanguage_translations_field_name_index` (`field_name`),
  FULLTEXT KEY `[[dbprefix]]multilanguage_translations_field_value_fulltext` (`field_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]newsletter_campaigns`
--

CREATE TABLE `[[dbprefix]]newsletter_campaigns` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` text COLLATE utf8_unicode_ci,
  `subject` text COLLATE utf8_unicode_ci,
  `from_name` text COLLATE utf8_unicode_ci,
  `created_at` datetime DEFAULT NULL,
  `email_template_id` int(11) DEFAULT NULL,
  `list_id` int(11) DEFAULT NULL,
  `sender_account_id` int(11) DEFAULT NULL,
  `sending_limit_per_day` int(11) DEFAULT NULL,
  `is_scheduled` int(11) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `is_done` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]newsletter_campaigns_send_log`
--

CREATE TABLE `[[dbprefix]]newsletter_campaigns_send_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `campaign_id` int(11) DEFAULT NULL,
  `subscriber_id` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `is_sent` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]newsletter_lists`
--

CREATE TABLE `[[dbprefix]]newsletter_lists` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` text COLLATE utf8_unicode_ci,
  `success_email_template_id` int(11) DEFAULT NULL,
  `success_sender_account_id` int(11) DEFAULT NULL,
  `unsubscription_sender_account_id` int(11) DEFAULT NULL,
  `unsubscription_email_template_id` int(11) DEFAULT NULL,
  `confirmation_email_template_id` int(11) DEFAULT NULL,
  `confirmation_sender_account_id` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]newsletter_sender_accounts`
--

CREATE TABLE `[[dbprefix]]newsletter_sender_accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` text COLLATE utf8_unicode_ci,
  `from_name` text COLLATE utf8_unicode_ci,
  `from_email` text COLLATE utf8_unicode_ci,
  `reply_email` text COLLATE utf8_unicode_ci,
  `created_at` datetime DEFAULT NULL,
  `account_type` text COLLATE utf8_unicode_ci,
  `smtp_username` text COLLATE utf8_unicode_ci,
  `smtp_password` text COLLATE utf8_unicode_ci,
  `smtp_host` text COLLATE utf8_unicode_ci,
  `smtp_port` text COLLATE utf8_unicode_ci,
  `mailchimp_secret` text COLLATE utf8_unicode_ci,
  `mailgun_domain` text COLLATE utf8_unicode_ci,
  `mailgun_secret` text COLLATE utf8_unicode_ci,
  `mandrill_secret` text COLLATE utf8_unicode_ci,
  `sparkpost_secret` text COLLATE utf8_unicode_ci,
  `amazon_ses_key` text COLLATE utf8_unicode_ci,
  `amazon_ses_secret` text COLLATE utf8_unicode_ci,
  `amazon_ses_region` text COLLATE utf8_unicode_ci,
  `account_pass` text COLLATE utf8_unicode_ci,
  `is_active` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]newsletter_subscribers`
--

CREATE TABLE `[[dbprefix]]newsletter_subscribers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` text COLLATE utf8_unicode_ci,
  `email` text COLLATE utf8_unicode_ci,
  `created_at` datetime DEFAULT NULL,
  `confirmation_code` text COLLATE utf8_unicode_ci,
  `is_subscribed` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]newsletter_subscribers_lists`
--

CREATE TABLE `[[dbprefix]]newsletter_subscribers_lists` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `subscriber_id` int(11) DEFAULT NULL,
  `list_id` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]newsletter_templates`
--

CREATE TABLE `[[dbprefix]]newsletter_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` text COLLATE utf8_unicode_ci,
  `text` text COLLATE utf8_unicode_ci,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notifications`
--

CREATE TABLE `[[dbprefix]]notifications` (
  `id` char(36) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `notifiable_type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `notifiable_id` bigint(20) unsigned NOT NULL,
  `data` text COLLATE utf8_unicode_ci NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notifications_mails_log`
--

CREATE TABLE `[[dbprefix]]notifications_mails_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `notifiable_type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `notifiable_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `html` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]oauth_personal_access_clients`
--

CREATE TABLE `[[dbprefix]]oauth_personal_access_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]offers`
--

CREATE TABLE `[[dbprefix]]offers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(11) DEFAULT NULL,
  `price_id` int(11) DEFAULT NULL,
  `offer_price` double(8,2) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `edited_by` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]offers`
--

INSERT INTO `[[dbprefix]]offers` VALUES
(1, 6, 67, 10.90, '2023-10-23 13:20:02', '2023-10-23 13:20:02', NULL, NULL, NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]options`
--

CREATE TABLE `[[dbprefix]]options` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `updated_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `option_key` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `option_value` longtext COLLATE utf8_unicode_ci,
  `option_key2` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `option_value2` text COLLATE utf8_unicode_ci,
  `position` int(11) DEFAULT NULL,
  `option_group` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `help` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `field_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `field_values` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `module` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_system` int(11) DEFAULT NULL,
  `option_value_prev` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=178 ;

--
-- Dumping data for table `[[dbprefix]]options`
--

INSERT INTO `[[dbprefix]]options` VALUES
(1, '2023-10-18 12:06:52', '2023-10-18 12:02:18', 'current_template', 'big', NULL, NULL, NULL, 'template', NULL, NULL, NULL, NULL, NULL, 1, NULL),
(2, '2023-10-18 12:02:22', '2023-10-18 12:02:22', 'language', 'en_US', NULL, NULL, NULL, 'website', NULL, NULL, NULL, NULL, NULL, 1, NULL),
(3, '2023-10-18 12:02:23', '2023-10-18 12:02:23', 'website_title', 'Microweber', NULL, NULL, NULL, 'website', NULL, NULL, NULL, NULL, NULL, 1, NULL),
(5, '2023-10-18 12:27:37', NULL, 'shipping_gw_shop/shipping/gateways/country', 'y', NULL, NULL, NULL, 'shipping', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(6, '2023-10-18 12:27:37', NULL, 'payment_gw_shop/payments/gateways/paypal', '1', NULL, NULL, NULL, 'payments', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(7, '2023-10-18 12:27:37', NULL, 'currency', 'USD', NULL, NULL, NULL, 'payments', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(8, '[[regtime]]', '2023-10-18 12:03:37', 'app_version', '2.0.19', NULL, NULL, NULL, 'website', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(9, '2023-10-18 12:03:38', '2023-10-18 12:03:38', 'facebook_enabled', '1', NULL, NULL, NULL, 'footer-layout-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(10, '2023-10-18 12:03:38', '2023-10-18 12:03:38', 'twitter_enabled', '1', NULL, NULL, NULL, 'footer-layout-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(11, '2023-10-18 12:03:38', '2023-10-18 12:03:38', 'linkedin_enabled', '1', NULL, NULL, NULL, 'footer-layout-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(12, '2023-10-18 12:03:38', '2023-10-18 12:03:38', 'default_settings_is_applied', '1', NULL, NULL, NULL, 'footer-layout-social-links', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(13, '2023-10-18 12:07:26', '2023-10-18 12:07:26', 'facebook_enabled', '1', NULL, NULL, NULL, 'mod-fbd02c8c1a59986f81f9fe8a6b5c7b1a-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(14, '2023-10-18 12:07:26', '2023-10-18 12:07:26', 'twitter_enabled', '1', NULL, NULL, NULL, 'mod-fbd02c8c1a59986f81f9fe8a6b5c7b1a-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(15, '2023-10-18 12:07:26', '2023-10-18 12:07:26', 'linkedin_enabled', '1', NULL, NULL, NULL, 'mod-fbd02c8c1a59986f81f9fe8a6b5c7b1a-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(16, '2023-10-18 12:07:26', '2023-10-18 12:07:26', 'default_settings_is_applied', '1', NULL, NULL, NULL, 'mod-fbd02c8c1a59986f81f9fe8a6b5c7b1a-social-links', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(17, '2023-10-18 12:07:26', '2023-10-18 12:07:26', 'facebook_enabled', '1', NULL, NULL, NULL, 'mod-14e16f763815d210ae7361deb27cbfb7-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(18, '2023-10-18 12:07:26', '2023-10-18 12:07:26', 'twitter_enabled', '1', NULL, NULL, NULL, 'mod-14e16f763815d210ae7361deb27cbfb7-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(19, '2023-10-18 12:07:26', '2023-10-18 12:07:26', 'linkedin_enabled', '1', NULL, NULL, NULL, 'mod-14e16f763815d210ae7361deb27cbfb7-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(20, '2023-10-18 12:07:26', '2023-10-18 12:07:26', 'default_settings_is_applied', '1', NULL, NULL, NULL, 'mod-14e16f763815d210ae7361deb27cbfb7-social-links', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(21, '2023-10-18 12:07:26', '2023-10-18 12:07:26', 'facebook_enabled', '1', NULL, NULL, NULL, 'mod-5a0580f2aa42c52752e3bb27204e9ec9-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(22, '2023-10-18 12:07:27', '2023-10-18 12:07:27', 'twitter_enabled', '1', NULL, NULL, NULL, 'mod-5a0580f2aa42c52752e3bb27204e9ec9-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(23, '2023-10-18 12:07:27', '2023-10-18 12:07:27', 'linkedin_enabled', '1', NULL, NULL, NULL, 'mod-5a0580f2aa42c52752e3bb27204e9ec9-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(24, '2023-10-18 12:07:27', '2023-10-18 12:07:27', 'default_settings_is_applied', '1', NULL, NULL, NULL, 'mod-5a0580f2aa42c52752e3bb27204e9ec9-social-links', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(25, '2023-10-18 12:07:27', '2023-10-18 12:07:27', 'facebook_enabled', '1', NULL, NULL, NULL, 'mod-14a33b6053bcdfdfb71898918baba8e6-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(26, '2023-10-18 12:07:27', '2023-10-18 12:07:27', 'twitter_enabled', '1', NULL, NULL, NULL, 'mod-14a33b6053bcdfdfb71898918baba8e6-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(27, '2023-10-18 12:07:27', '2023-10-18 12:07:27', 'linkedin_enabled', '1', NULL, NULL, NULL, 'mod-14a33b6053bcdfdfb71898918baba8e6-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(28, '2023-10-18 12:07:27', '2023-10-18 12:07:27', 'default_settings_is_applied', '1', NULL, NULL, NULL, 'mod-14a33b6053bcdfdfb71898918baba8e6-social-links', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(29, '2023-10-18 12:07:28', '2023-10-18 12:07:28', 'data-default-custom-fields-are-created', '1', NULL, NULL, NULL, 'mod-47f40861aed8362292d65fabef7a7957-contact-form-custom-fields', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(30, '2023-10-18 12:07:29', '2023-10-18 12:07:29', 'data-default-custom-fields-are-created', '1', NULL, NULL, NULL, 'mod-14a33b6053bcdfdfb71898918baba8e6-contact-form-custom-fields', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(31, '2023-10-18 12:07:31', '2023-10-18 12:07:31', 'data-default-custom-fields-are-created', '1', NULL, NULL, NULL, 'mod-b0327094166bb7d4e1821bac1cf7939f-contact-form-custom-fields', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(33, '2023-10-18 12:29:21', '2023-10-18 12:29:20', 'default_settings_is_applied', '1', NULL, NULL, NULL, 'module-pictures', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(35, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'facebook_enabled', '1', NULL, NULL, NULL, 'mod-71a6ff1747fc8beefe2b1d4ed34f5c40-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(36, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'twitter_enabled', '1', NULL, NULL, NULL, 'mod-71a6ff1747fc8beefe2b1d4ed34f5c40-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(37, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'linkedin_enabled', '1', NULL, NULL, NULL, 'mod-71a6ff1747fc8beefe2b1d4ed34f5c40-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(38, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'default_settings_is_applied', '1', NULL, NULL, NULL, 'mod-71a6ff1747fc8beefe2b1d4ed34f5c40-social-links', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(39, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'facebook_enabled', '1', NULL, NULL, NULL, 'mod-3c91075443e927301f067029531d9c25-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(40, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'twitter_enabled', '1', NULL, NULL, NULL, 'mod-3c91075443e927301f067029531d9c25-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(41, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'linkedin_enabled', '1', NULL, NULL, NULL, 'mod-3c91075443e927301f067029531d9c25-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(42, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'default_settings_is_applied', '1', NULL, NULL, NULL, 'mod-3c91075443e927301f067029531d9c25-social-links', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(43, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'facebook_enabled', '1', NULL, NULL, NULL, 'mod-fbe1af6bfff3641c67b68550a829f6da-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(44, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'twitter_enabled', '1', NULL, NULL, NULL, 'mod-fbe1af6bfff3641c67b68550a829f6da-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(45, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'linkedin_enabled', '1', NULL, NULL, NULL, 'mod-fbe1af6bfff3641c67b68550a829f6da-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(46, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'default_settings_is_applied', '1', NULL, NULL, NULL, 'mod-fbe1af6bfff3641c67b68550a829f6da-social-links', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(47, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'facebook_enabled', '1', NULL, NULL, NULL, 'mod-7f1e3b20d2161133ddaddf1525271214-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(48, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'twitter_enabled', '1', NULL, NULL, NULL, 'mod-7f1e3b20d2161133ddaddf1525271214-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(49, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'linkedin_enabled', '1', NULL, NULL, NULL, 'mod-7f1e3b20d2161133ddaddf1525271214-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(50, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'default_settings_is_applied', '1', NULL, NULL, NULL, 'mod-7f1e3b20d2161133ddaddf1525271214-social-links', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(51, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'facebook_enabled', '1', NULL, NULL, NULL, 'mod-c5c421c90da774b150da5350153d75e8-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(52, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'twitter_enabled', '1', NULL, NULL, NULL, 'mod-c5c421c90da774b150da5350153d75e8-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(53, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'linkedin_enabled', '1', NULL, NULL, NULL, 'mod-c5c421c90da774b150da5350153d75e8-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(54, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'default_settings_is_applied', '1', NULL, NULL, NULL, 'mod-c5c421c90da774b150da5350153d75e8-social-links', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(55, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'facebook_enabled', '1', NULL, NULL, NULL, 'mod-28c84462790f5a4c5bcaa00739535b61-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(56, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'twitter_enabled', '1', NULL, NULL, NULL, 'mod-28c84462790f5a4c5bcaa00739535b61-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(57, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'linkedin_enabled', '1', NULL, NULL, NULL, 'mod-28c84462790f5a4c5bcaa00739535b61-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(58, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'default_settings_is_applied', '1', NULL, NULL, NULL, 'mod-28c84462790f5a4c5bcaa00739535b61-social-links', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(59, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'title', 'Your story online', NULL, NULL, NULL, 'mod-28c84462790f5a4c5bcaa00739535b61-slider-v2', NULL, NULL, NULL, NULL, 'slider_v2', NULL, NULL),
(60, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'settings', '[{"url":"#","buttonText":"Button","title":"Your Title Slide 1","description":"A short description of this slide here.","image":"{SITE_URL}userfiles\\/modules\\/slider_v2\\/default-content\\/gallery-1-2.jpg","itemId":"slider-content-default-1","titleColor":"#ffffff","descriptionColor":"#ffffff","buttonColor":"#ffffff","buttonTextColor":"#000000","titleFontSize":"40","descriptionFontSize":"20","buttonFontSize":"20","titleFontFamily":"Arial","descriptionFontFamily":"Arial","imageBackgroundColor":"#000000","imageBackgroundOpacity":"60"},{"url":"#","buttonText":"Button","title":"Your Title Slide 2","description":"A short description of this slide here.","image":"{SITE_URL}userfiles\\/modules\\/slider_v2\\/default-content\\/gallery-1-3.jpg","itemId":"slider-content-default-2","titleColor":"#ffffff","descriptionColor":"#ffffff","buttonColor":"#ffffff","buttonTextColor":"#000000","titleFontSize":"40","descriptionFontSize":"20","buttonFontSize":"20","titleFontFamily":"Arial","descriptionFontFamily":"Arial","imageBackgroundColor":"#000000","imageBackgroundOpacity":"60"},{"url":"#","buttonText":"Button","title":"Your Title Slide 3","description":"A short description of this slide here.","image":"{SITE_URL}userfiles\\/modules\\/slider_v2\\/default-content\\/gallery-1-4.jpg","itemId":"slider-content-default-3","titleColor":"#ffffff","descriptionColor":"#ffffff","buttonColor":"#ffffff","buttonTextColor":"#000000","titleFontSize":"40","descriptionFontSize":"20","buttonFontSize":"20","titleFontFamily":"Arial","descriptionFontFamily":"Arial","imageBackgroundColor":"#000000","imageBackgroundOpacity":"60"}]', NULL, NULL, NULL, 'mod-28c84462790f5a4c5bcaa00739535b61-slider-v2', NULL, NULL, NULL, NULL, 'slider_v2', NULL, NULL),
(61, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'default_settings_is_applied', '1', NULL, NULL, NULL, 'mod-28c84462790f5a4c5bcaa00739535b61-slider-v2', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(62, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'data-default-custom-fields-are-created', '1', NULL, NULL, NULL, 'mod-7dccc5ba3c4270176868c9cdbf5fe584-contact-form-custom-fields', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(63, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'title', 'Your story online', NULL, NULL, NULL, 'mod-c6795de6a7f6a50a258c0b43ff15daf1-slider-v2', NULL, NULL, NULL, NULL, 'slider_v2', NULL, NULL),
(64, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'settings', '[{"url":"#","buttonText":"Button","title":"Your Title Slide 1","description":"A short description of this slide here.","image":"{SITE_URL}userfiles\\/modules\\/slider_v2\\/default-content\\/gallery-1-2.jpg","itemId":"slider-content-default-1","titleColor":"#ffffff","descriptionColor":"#ffffff","buttonColor":"#ffffff","buttonTextColor":"#000000","titleFontSize":"40","descriptionFontSize":"20","buttonFontSize":"20","titleFontFamily":"Arial","descriptionFontFamily":"Arial","imageBackgroundColor":"#000000","imageBackgroundOpacity":"60"},{"url":"#","buttonText":"Button","title":"Your Title Slide 2","description":"A short description of this slide here.","image":"{SITE_URL}userfiles\\/modules\\/slider_v2\\/default-content\\/gallery-1-3.jpg","itemId":"slider-content-default-2","titleColor":"#ffffff","descriptionColor":"#ffffff","buttonColor":"#ffffff","buttonTextColor":"#000000","titleFontSize":"40","descriptionFontSize":"20","buttonFontSize":"20","titleFontFamily":"Arial","descriptionFontFamily":"Arial","imageBackgroundColor":"#000000","imageBackgroundOpacity":"60"},{"url":"#","buttonText":"Button","title":"Your Title Slide 3","description":"A short description of this slide here.","image":"{SITE_URL}userfiles\\/modules\\/slider_v2\\/default-content\\/gallery-1-4.jpg","itemId":"slider-content-default-3","titleColor":"#ffffff","descriptionColor":"#ffffff","buttonColor":"#ffffff","buttonTextColor":"#000000","titleFontSize":"40","descriptionFontSize":"20","buttonFontSize":"20","titleFontFamily":"Arial","descriptionFontFamily":"Arial","imageBackgroundColor":"#000000","imageBackgroundOpacity":"60"}]', NULL, NULL, NULL, 'mod-c6795de6a7f6a50a258c0b43ff15daf1-slider-v2', NULL, NULL, NULL, NULL, 'slider_v2', NULL, NULL),
(65, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'default_settings_is_applied', '1', NULL, NULL, NULL, 'mod-c6795de6a7f6a50a258c0b43ff15daf1-slider-v2', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(66, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'data-default-custom-fields-are-created', '1', NULL, NULL, NULL, 'mod-e3700137f382aeec5918ef82c36d8f43-contact-form-custom-fields', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(67, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'data-default-custom-fields-are-created', '1', NULL, NULL, NULL, 'mod-71a6ff1747fc8beefe2b1d4ed34f5c40-contact-form-custom-fields', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(68, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'data-default-custom-fields-are-created', '1', NULL, NULL, NULL, 'mod-3c91075443e927301f067029531d9c25-contact-form-custom-fields', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(69, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'data-default-custom-fields-are-created', '1', NULL, NULL, NULL, 'mod-c5c11f276853c897ad30d5f671fe2c43-contact-form-custom-fields', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(70, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'data-default-custom-fields-are-created', '1', NULL, NULL, NULL, 'mod-fbe1af6bfff3641c67b68550a829f6da-contact-form-custom-fields', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(71, '2023-10-23 12:54:03', '2023-10-23 12:54:03', 'data-default-custom-fields-are-created', '1', NULL, NULL, NULL, 'mod-c411315c8f5edaad8f89e55a73356ce6-contact-form-custom-fields', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(72, '2023-10-23 12:54:04', '2023-10-23 12:54:04', 'data-default-custom-fields-are-created', '1', NULL, NULL, NULL, 'mod-86b15c0fee994a2de2a380620d363f95-contact-form-custom-fields', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(73, '2023-10-23 12:54:04', '2023-10-23 12:54:04', 'default_settings_is_applied', '1', NULL, NULL, NULL, 'mod-8859cdc87388966f5cf97fb7aefe7210-shop-products-pictures', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(74, '2023-10-23 12:54:04', '2023-10-23 12:54:04', 'data-default-custom-fields-are-created', '1', NULL, NULL, NULL, 'mod-9f3153224f34c3c6c721ab08fd59d2e3-contact-form-custom-fields', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(75, '2023-10-23 12:54:04', '2023-10-23 12:54:04', 'data-default-custom-fields-are-created', '1', NULL, NULL, NULL, 'mod-e0ebf5c23eb051d48e82431c7d898292-contact-form-custom-fields', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(76, '2023-10-23 12:54:04', '2023-10-23 12:54:04', 'data-default-custom-fields-are-created', '1', NULL, NULL, NULL, 'mod-4fbd4a3ba4b84120ee07b9113f122895-contact-form-custom-fields', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(77, '2023-10-23 12:54:04', '2023-10-23 12:54:04', 'data-default-custom-fields-are-created', '1', NULL, NULL, NULL, 'mod-37f37e558c82515857755e1a70d9d4b6-contact-form-custom-fields', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(78, '2023-10-23 12:54:05', '2023-10-23 12:54:04', 'default_settings_is_applied', '1', NULL, NULL, NULL, 'mod-8859cdc87388966f5cf97fb7aefe7210-shop-products-pictures--1', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(79, '2023-10-23 12:54:04', '2023-10-23 12:54:04', 'data-default-custom-fields-are-created', '1', NULL, NULL, NULL, 'mod-e9bd2b6da869d247a96bb91fa375a30e-contact-form-custom-fields', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(80, '2023-10-23 12:54:05', '2023-10-23 12:54:05', 'data-default-custom-fields-are-created', '1', NULL, NULL, NULL, 'mod-67234264f9002e4787b8f81383f1d18c-contact-form-custom-fields', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(81, '2023-10-23 12:54:05', '2023-10-23 12:54:05', 'data-default-custom-fields-are-created', '1', NULL, NULL, NULL, 'mod-d11b8c80012448c99791edd69f634882-contact-form-custom-fields', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(82, '2023-10-23 12:54:05', '2023-10-23 12:54:05', 'data-default-custom-fields-are-created', '1', NULL, NULL, NULL, 'mod-ec55e8b0b30442d5d272a91bbee861ba-contact-form-custom-fields', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(86, '2023-10-23 13:03:44', '2023-10-23 13:03:44', 'logotype', 'text', NULL, NULL, NULL, 'footer-logo-footer-layout', NULL, NULL, NULL, NULL, 'logo', NULL, NULL),
(87, '2023-10-23 13:03:53', '2023-10-23 13:03:46', 'text', 'BIG Template', NULL, NULL, NULL, 'footer-logo-footer-layout', NULL, NULL, NULL, NULL, 'logo', NULL, NULL),
(89, '2023-10-23 14:14:15', '2023-10-23 14:14:15', 'data-default-custom-fields-are-created', '1', NULL, NULL, NULL, 'mw-module-1698070398193-contact-form-custom-fields', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(103, '2023-10-25 08:42:12', '2023-10-25 08:42:12', 'height', '50px', NULL, NULL, NULL, 'spacer-layout--footer-layout-top', NULL, NULL, NULL, NULL, 'spacer', NULL, NULL),
(148, '2023-10-26 08:41:33', '2023-10-26 08:41:33', 'header_top_menu', '1', NULL, NULL, NULL, 'header-layout', NULL, NULL, NULL, NULL, 'menus/skin-1.php', NULL, NULL),
(149, '2023-10-26 08:41:36', '2023-10-26 08:41:36', 'search_bar', '1', NULL, NULL, NULL, 'header-layout', NULL, NULL, NULL, NULL, 'menus/skin-1.php', NULL, NULL),
(150, '2023-10-26 08:41:37', '2023-10-26 08:41:37', 'shopping_cart', '1', NULL, NULL, NULL, 'header-layout', NULL, NULL, NULL, NULL, 'menus/skin-1.php', NULL, NULL),
(151, '2023-10-26 08:41:39', '2023-10-26 08:41:39', 'contact_us_link', '1', NULL, NULL, NULL, 'header-layout', NULL, NULL, NULL, NULL, 'menus/skin-1.php', NULL, NULL),
(152, '2023-10-26 08:41:40', '2023-10-26 08:41:40', 'header_socials', '1', NULL, NULL, NULL, 'header-layout', NULL, NULL, NULL, NULL, 'menus/skin-1.php', NULL, NULL),
(153, '2023-10-26 08:41:40', '2023-10-26 08:41:40', 'facebook_enabled', '1', NULL, NULL, NULL, 'header-layout-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(154, '2023-10-26 08:41:40', '2023-10-26 08:41:40', 'twitter_enabled', '1', NULL, NULL, NULL, 'header-layout-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(155, '2023-10-26 08:41:40', '2023-10-26 08:41:40', 'linkedin_enabled', '1', NULL, NULL, NULL, 'header-layout-social-links', NULL, NULL, NULL, NULL, 'social_links', NULL, NULL),
(156, '2023-10-26 08:41:40', '2023-10-26 08:41:40', 'default_settings_is_applied', '1', NULL, NULL, NULL, 'header-layout-social-links', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(157, '2023-10-26 08:41:41', '2023-10-26 08:41:41', 'phone_text', '1', NULL, NULL, NULL, 'header-layout', NULL, NULL, NULL, NULL, 'menus/skin-1.php', NULL, NULL),
(158, '2023-10-26 08:41:42', '2023-10-26 08:41:42', 'profile_link', '1', NULL, NULL, NULL, 'header-layout', NULL, NULL, NULL, NULL, 'menus/skin-1.php', NULL, NULL),
(159, '2023-10-26 09:20:34', '2023-10-26 08:41:43', 'sticky_nav', '1', NULL, NULL, NULL, 'header-layout', NULL, NULL, NULL, NULL, 'menus/skin-1.php', NULL, NULL),
(160, '2023-10-26 09:20:08', '2023-10-26 08:41:43', 'multilanguage', '0', NULL, NULL, NULL, 'header-layout', NULL, NULL, NULL, NULL, 'menus/skin-1.php', NULL, NULL),
(161, '2023-10-26 09:09:32', '2023-10-26 09:09:32', 'logoimage', '{SITE_URL}userfiles/media/default/big-logo-1.svg', NULL, NULL, NULL, 'header-logo-header-layout', NULL, NULL, NULL, NULL, 'logo', NULL, NULL),
(162, '2023-10-26 09:09:42', '2023-10-26 09:09:35', 'size', '270', NULL, NULL, NULL, 'header-logo-header-layout', NULL, NULL, NULL, NULL, 'logo', NULL, NULL),
(163, '2023-10-26 09:26:23', '2023-10-26 09:11:14', 'is_active', 'n', NULL, NULL, NULL, 'multilanguage_settings', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(165, '2023-10-26 12:27:11', '2023-10-26 12:27:11', 'data-default-custom-fields-are-created', '1', NULL, NULL, NULL, 'module-layouts-4--1-contact-form-custom-fields', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(166, '2023-10-26 12:28:13', '2023-10-26 12:28:13', 'title', '', NULL, NULL, NULL, 'module-layouts-1--3-layout-content', NULL, NULL, NULL, NULL, 'layout_content', NULL, NULL),
(167, '2023-10-26 12:28:13', '2023-10-26 12:28:13', 'description', '', NULL, NULL, NULL, 'module-layouts-1--3-layout-content', NULL, NULL, NULL, NULL, 'layout_content', NULL, NULL),
(168, '2023-10-26 12:28:14', '2023-10-26 12:28:14', 'align', 'center', NULL, NULL, NULL, 'module-layouts-1--3-layout-content', NULL, NULL, NULL, NULL, 'layout_content', NULL, NULL),
(169, '2023-10-26 12:28:14', '2023-10-26 12:28:14', 'maxColumns', '3', NULL, NULL, NULL, 'module-layouts-1--3-layout-content', NULL, NULL, NULL, NULL, 'layout_content', NULL, NULL),
(170, '2023-10-26 12:28:14', '2023-10-26 12:28:14', 'maxColumnsTablet', '2', NULL, NULL, NULL, 'module-layouts-1--3-layout-content', NULL, NULL, NULL, NULL, 'layout_content', NULL, NULL),
(171, '2023-10-26 12:28:14', '2023-10-26 12:28:14', 'maxColumnsMobile', '1', NULL, NULL, NULL, 'module-layouts-1--3-layout-content', NULL, NULL, NULL, NULL, 'layout_content', NULL, NULL),
(172, '2023-10-26 12:28:14', '2023-10-26 12:28:14', 'buttonLink', '#', NULL, NULL, NULL, 'module-layouts-1--3-layout-content', NULL, NULL, NULL, NULL, 'layout_content', NULL, NULL),
(173, '2023-10-26 12:28:14', '2023-10-26 12:28:14', 'buttonText', '', NULL, NULL, NULL, 'module-layouts-1--3-layout-content', NULL, NULL, NULL, NULL, 'layout_content', NULL, NULL),
(174, '2023-10-26 12:28:14', '2023-10-26 12:28:14', 'contents', '[{"buttonLink":"#","buttonText":"Make It","description":"It all begins with an idea. Maybe you want to launch a business. Maybe you want to turn a hobby into something more. Or maybe you have a creative project to share with the world. Whatever it is, the way you tell your story online can make all the difference.","title":"Your Awesome Title","imageAltText":"Maybe you want to turn a hobby into something more","image":"{SITE_URL}userfiles\\/modules\\/layout_content\\/default-content\\/gallery-1-2.jpg","itemId":"layout-content-default-1"},{"buttonLink":"#","buttonText":"Make It","description":"It all begins with an idea. Maybe you want to launch a business. Maybe you want to turn a hobby into something more. Or maybe you have a creative project to share with the world. Whatever it is, the way you tell your story online can make all the difference.","title":"Your Awesome Title","imageAltText":"Maybe you want to launch a business","image":"{SITE_URL}userfiles\\/modules\\/layout_content\\/default-content\\/gallery-1-3.jpg","itemId":"layout-content-default-2"},{"buttonLink":"#","buttonText":"Make It","description":"It all begins with an idea. Maybe you want to launch a business. Maybe you want to turn a hobby into something more. Or maybe you have a creative project to share with the world. Whatever it is, the way you tell your story online can make all the difference. \\n\\n","title":"Your Awesome Title","imageAltText":"","image":"{SITE_URL}userfiles\\/modules\\/layout_content\\/default-content\\/gallery-1-4.jpg","itemId":"layout-content-default-3"}]', NULL, NULL, NULL, 'module-layouts-1--3-layout-content', NULL, NULL, NULL, NULL, 'layout_content', NULL, NULL),
(175, '2023-10-26 12:28:15', '2023-10-26 12:28:15', 'default_settings_is_applied', '1', NULL, NULL, NULL, 'module-layouts-1--3-layout-content', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(177, '[[regtime]]', '[[regtime]]', 'app_base_path', '[[softpath]]', NULL, NULL, NULL, 'website', NULL, NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]password_resets`
--

CREATE TABLE `[[dbprefix]]password_resets` (
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `[[dbprefix]]password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]permissions`
--

CREATE TABLE `[[dbprefix]]permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `guard_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]personal_access_tokens`
--

CREATE TABLE `[[dbprefix]]personal_access_tokens` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `tokenable_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]personal_access_tokens_token_unique` (`token`),
  KEY `[[dbprefix]]personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]rating`
--

CREATE TABLE `[[dbprefix]]rating` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `rel_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rel_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rating` int(11) DEFAULT NULL,
  `comment` text COLLATE utf8_unicode_ci,
  `updated_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `edited_by` int(11) DEFAULT NULL,
  `session_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]roles`
--

CREATE TABLE `[[dbprefix]]roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `guard_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_has_permissions`
--

CREATE TABLE `[[dbprefix]]role_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `role_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sessions`
--

CREATE TABLE `[[dbprefix]]sessions` (
  `id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8_unicode_ci NOT NULL,
  `last_activity` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `ip_address` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8_unicode_ci,
  UNIQUE KEY `[[dbprefix]]sessions_id_unique` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats_browser_agents`
--

CREATE TABLE `[[dbprefix]]stats_browser_agents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `browser_agent` text COLLATE utf8_unicode_ci,
  `browser_agent_hash` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `platform` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `platform_version` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `browser` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `browser_version` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `device` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_desktop` int(11) DEFAULT NULL,
  `is_mobile` int(11) DEFAULT NULL,
  `is_phone` int(11) DEFAULT NULL,
  `is_tablet` int(11) DEFAULT NULL,
  `robot_name` text COLLATE utf8_unicode_ci,
  `is_robot` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `language` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats_events`
--

CREATE TABLE `[[dbprefix]]stats_events` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `event_category` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `event_action` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `event_label` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `event_value` int(11) DEFAULT NULL,
  `utm_source` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `utm_medium` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `utm_campaign` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `utm_term` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `utm_content` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `utm_visitor_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `event_data` text COLLATE utf8_unicode_ci,
  `event_timestamp` datetime DEFAULT NULL,
  `session_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_sent` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats_geoip`
--

CREATE TABLE `[[dbprefix]]stats_geoip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `country_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `country_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `region` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `city` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `latitude` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `longitude` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats_referrers`
--

CREATE TABLE `[[dbprefix]]stats_referrers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `referrer` text COLLATE utf8_unicode_ci,
  `referrer_hash` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `referrer_domain_id` int(11) DEFAULT NULL,
  `referrer_path_id` int(11) DEFAULT NULL,
  `is_internal` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats_referrers_domains`
--

CREATE TABLE `[[dbprefix]]stats_referrers_domains` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `referrer_domain` text COLLATE utf8_unicode_ci,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats_referrers_paths`
--

CREATE TABLE `[[dbprefix]]stats_referrers_paths` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `referrer_domain_id` int(11) DEFAULT NULL,
  `referrer_path` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats_sessions`
--

CREATE TABLE `[[dbprefix]]stats_sessions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `session_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `session_hostname` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user_ip` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `browser_id` int(11) DEFAULT NULL,
  `referrer_id` int(11) DEFAULT NULL,
  `referrer_domain_id` int(11) DEFAULT NULL,
  `referrer_path_id` int(11) DEFAULT NULL,
  `geoip_id` int(11) DEFAULT NULL,
  `language` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats_urls`
--

CREATE TABLE `[[dbprefix]]stats_urls` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `content_id` int(11) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `url_hash` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats_visits_log`
--

CREATE TABLE `[[dbprefix]]stats_visits_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `url_id` int(11) DEFAULT NULL,
  `referrer_id` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `session_id_key` int(11) DEFAULT NULL,
  `view_count` int(11) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]system_licenses`
--

CREATE TABLE `[[dbprefix]]system_licenses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `updated_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `edited_by` int(11) DEFAULT NULL,
  `rel_type` text COLLATE utf8_unicode_ci,
  `rel_id` text COLLATE utf8_unicode_ci,
  `local_key` text COLLATE utf8_unicode_ci,
  `local_key_hash` text COLLATE utf8_unicode_ci,
  `registered_name` text COLLATE utf8_unicode_ci,
  `company_name` text COLLATE utf8_unicode_ci,
  `domains` text COLLATE utf8_unicode_ci,
  `status` text COLLATE utf8_unicode_ci,
  `product_id` int(11) DEFAULT NULL,
  `service_id` int(11) DEFAULT NULL,
  `billing_cycle` text COLLATE utf8_unicode_ci,
  `reg_on` datetime DEFAULT NULL,
  `due_on` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tagging_tagged`
--

CREATE TABLE `[[dbprefix]]tagging_tagged` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `taggable_id` int(10) unsigned NOT NULL,
  `taggable_type` varchar(125) COLLATE utf8_unicode_ci NOT NULL,
  `tag_name` varchar(125) COLLATE utf8_unicode_ci NOT NULL,
  `tag_slug` varchar(125) COLLATE utf8_unicode_ci NOT NULL,
  `tag_description` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]tagging_tagged_taggable_id_index` (`taggable_id`),
  KEY `[[dbprefix]]tagging_tagged_taggable_type_index` (`taggable_type`),
  KEY `[[dbprefix]]tagging_tagged_tag_slug_index` (`tag_slug`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]tagging_tagged`
--

INSERT INTO `[[dbprefix]]tagging_tagged` VALUES
(1, 7, 'content', 'Micoweber', 'micoweber', NULL),
(2, 7, 'content', 'Cms', 'cms', NULL),
(3, 7, 'content', 'Website Builder', 'website-builder', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tagging_tags`
--

CREATE TABLE `[[dbprefix]]tagging_tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(125) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(125) COLLATE utf8_unicode_ci NOT NULL,
  `suggest` tinyint(1) NOT NULL DEFAULT '0',
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  `tag_group_id` int(10) unsigned DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `locale` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]tagging_tags_slug_index` (`slug`),
  KEY `[[dbprefix]]tagging_tags_tag_group_id_foreign` (`tag_group_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]tagging_tags`
--

INSERT INTO `[[dbprefix]]tagging_tags` VALUES
(1, 'micoweber', 'Micoweber', 0, 1, NULL, NULL, 'en'),
(2, 'cms', 'Cms', 0, 1, NULL, NULL, 'en'),
(3, 'website-builder', 'Website Builder', 0, 1, NULL, NULL, 'en');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tagging_tag_groups`
--

CREATE TABLE `[[dbprefix]]tagging_tag_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(125) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(125) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]tagging_tag_groups_slug_index` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tax_types`
--

CREATE TABLE `[[dbprefix]]tax_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `rate` decimal(5,2) NOT NULL,
  `compound_tax` tinyint(4) NOT NULL DEFAULT '0',
  `collective_tax` tinyint(4) NOT NULL DEFAULT '0',
  `description` text COLLATE utf8_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]terms_accept_log`
--

CREATE TABLE `[[dbprefix]]terms_accept_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `updated_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `edited_by` int(11) DEFAULT NULL,
  `tos_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user_email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `user_ip` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]testimonials`
--

CREATE TABLE `[[dbprefix]]testimonials` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` text COLLATE utf8_unicode_ci,
  `content` text COLLATE utf8_unicode_ci,
  `read_more_url` text COLLATE utf8_unicode_ci,
  `created_on` datetime DEFAULT NULL,
  `project_name` text COLLATE utf8_unicode_ci,
  `client_company` text COLLATE utf8_unicode_ci,
  `client_role` text COLLATE utf8_unicode_ci,
  `client_picture` text COLLATE utf8_unicode_ci,
  `client_website` text COLLATE utf8_unicode_ci,
  `position` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]testimonials`
--

INSERT INTO `[[dbprefix]]testimonials` VALUES
(1, 'Wilma Hover', 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don''t look even slightly believable.', NULL, NULL, 'Default', 'Example Inc.', 'Creator', '{SITE_URL}userfiles/modules/teamcard/default-content/4.jpg', 'www.example.com', NULL),
(2, 'Hattie Nelson', 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don''t look even slightly believable.', NULL, NULL, 'Default', 'Example Inc.', 'Game Designer', '{SITE_URL}userfiles/modules/teamcard/default-content/1.jpg', 'www.example.com', NULL),
(3, 'John Doe', 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don''t look even slightly believable.', NULL, NULL, NULL, 'Example Inc.', 'Social Media Ninja', '{SITE_URL}userfiles/modules/teamcard/default-content/2.jpg', 'www.example.com', NULL),
(4, 'Mark Brown', 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don''t look even slightly believable.', NULL, NULL, 'Default', 'Example Inc.', 'Social Media Ninja', '{SITE_URL}userfiles/modules/teamcard/default-content/3.jpg', 'www.example.com', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]translation_keys`
--

CREATE TABLE `[[dbprefix]]translation_keys` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `translation_namespace` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `translation_group` varchar(255) COLLATE utf8_bin NOT NULL,
  `translation_key` text COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]translation_keys_translation_group_index` (`translation_group`),
  KEY `[[dbprefix]]translation_keys_translation_namespace_index` (`translation_namespace`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]translation_keys`
--

INSERT INTO `[[dbprefix]]translation_keys` VALUES
(1, '*', '*', 'Remove');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]translation_texts`
--

CREATE TABLE `[[dbprefix]]translation_texts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `translation_key_id` int(11) NOT NULL,
  `translation_text` text COLLATE utf8_unicode_ci NOT NULL,
  `translation_locale` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]translation_texts_translation_key_id_index` (`translation_key_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users`
--

CREATE TABLE `[[dbprefix]]users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `password` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_active` int(11) DEFAULT NULL,
  `is_admin` int(11) DEFAULT NULL,
  `is_verified` int(11) DEFAULT NULL,
  `is_public` int(11) DEFAULT NULL,
  `last_login` datetime DEFAULT NULL,
  `last_login_ip` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `edited_by` int(11) DEFAULT NULL,
  `remember_token` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `basic_mode` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `first_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `middle_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `last_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `thumbnail` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `api_key` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user_information` text COLLATE utf8_unicode_ci,
  `subscr_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `role` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `medium` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `oauth_uid` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `oauth_provider` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `oauth_token` text COLLATE utf8_unicode_ci,
  `oauth_token_secret` text COLLATE utf8_unicode_ci,
  `profile_url` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `website_url` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `password_reset_hash` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email_verified_at` datetime DEFAULT NULL,
  `two_factor_recovery_codes` text COLLATE utf8_unicode_ci,
  `two_factor_secret` text COLLATE utf8_unicode_ci,
  `updated_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `expires_on` datetime DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]users_username_unique` (`username`),
  UNIQUE KEY `[[dbprefix]]users_email_unique` (`email`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]users`
--

INSERT INTO `[[dbprefix]]users` VALUES
(1, '[[admin_username]]', '[[admin_pass]]', '[[admin_email]]', 1, 1, 0, NULL, '[[regtime]]', '[[clientip]]', NULL, 1, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users_oauth`
--

CREATE TABLE `[[dbprefix]]users_oauth` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `provider` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data_email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data_token` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data_avatar` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data_raw` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `[[dbprefix]]tagging_tags`
--
ALTER TABLE `[[dbprefix]]tagging_tags`
  ADD CONSTRAINT `[[dbprefix]]tagging_tags_tag_group_id_foreign` FOREIGN KEY (`tag_group_id`) REFERENCES `[[dbprefix]]tagging_tag_groups` (`id`);

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
