<?php

namespace Spatie\SchemaOrg;

use BadMethodCallException;
use Closure;
use JsonSerializable;
use ReflectionClass;
use ReflectionNamedType;
use Spatie\SchemaOrg\Exceptions\InvalidType;
use Spatie\SchemaOrg\Exceptions\TypeAlreadyInMultiTypedEntity;
use Spatie\SchemaOrg\Exceptions\TypeNotInMultiTypedEntity;

/**
 * @method self|ThreeDimensionalModel 3DModel(\Closure|null $callback = null)
 * @method self|AMRadioChannel aMRadioChannel(\Closure|null $callback = null)
 * @method self|APIReference aPIReference(\Closure|null $callback = null)
 * @method self|AboutPage aboutPage(\Closure|null $callback = null)
 * @method self|AcceptAction acceptAction(\Closure|null $callback = null)
 * @method self|Accommodation accommodation(\Closure|null $callback = null)
 * @method self|AccountingService accountingService(\Closure|null $callback = null)
 * @method self|AchieveAction achieveAction(\Closure|null $callback = null)
 * @method self|Action action(\Closure|null $callback = null)
 * @method self|ActionAccessSpecification actionAccessSpecification(\Closure|null $callback = null)
 * @method self|ActionStatusType actionStatusType(\Closure|null $callback = null)
 * @method self|ActivateAction activateAction(\Closure|null $callback = null)
 * @method self|AddAction addAction(\Closure|null $callback = null)
 * @method self|AdministrativeArea administrativeArea(\Closure|null $callback = null)
 * @method self|AdultEntertainment adultEntertainment(\Closure|null $callback = null)
 * @method self|AdultOrientedEnumeration adultOrientedEnumeration(\Closure|null $callback = null)
 * @method self|AdvertiserContentArticle advertiserContentArticle(\Closure|null $callback = null)
 * @method self|AggregateOffer aggregateOffer(\Closure|null $callback = null)
 * @method self|AggregateRating aggregateRating(\Closure|null $callback = null)
 * @method self|AgreeAction agreeAction(\Closure|null $callback = null)
 * @method self|Airline airline(\Closure|null $callback = null)
 * @method self|Airport airport(\Closure|null $callback = null)
 * @method self|AlignmentObject alignmentObject(\Closure|null $callback = null)
 * @method self|AllocateAction allocateAction(\Closure|null $callback = null)
 * @method self|AmpStory ampStory(\Closure|null $callback = null)
 * @method self|AmusementPark amusementPark(\Closure|null $callback = null)
 * @method self|AnalysisNewsArticle analysisNewsArticle(\Closure|null $callback = null)
 * @method self|AnatomicalStructure anatomicalStructure(\Closure|null $callback = null)
 * @method self|AnatomicalSystem anatomicalSystem(\Closure|null $callback = null)
 * @method self|AnimalShelter animalShelter(\Closure|null $callback = null)
 * @method self|Answer answer(\Closure|null $callback = null)
 * @method self|Apartment apartment(\Closure|null $callback = null)
 * @method self|ApartmentComplex apartmentComplex(\Closure|null $callback = null)
 * @method self|AppendAction appendAction(\Closure|null $callback = null)
 * @method self|ApplyAction applyAction(\Closure|null $callback = null)
 * @method self|ApprovedIndication approvedIndication(\Closure|null $callback = null)
 * @method self|Aquarium aquarium(\Closure|null $callback = null)
 * @method self|ArchiveComponent archiveComponent(\Closure|null $callback = null)
 * @method self|ArchiveOrganization archiveOrganization(\Closure|null $callback = null)
 * @method self|ArriveAction arriveAction(\Closure|null $callback = null)
 * @method self|ArtGallery artGallery(\Closure|null $callback = null)
 * @method self|Artery artery(\Closure|null $callback = null)
 * @method self|Article article(\Closure|null $callback = null)
 * @method self|AskAction askAction(\Closure|null $callback = null)
 * @method self|AskPublicNewsArticle askPublicNewsArticle(\Closure|null $callback = null)
 * @method self|AssessAction assessAction(\Closure|null $callback = null)
 * @method self|AssignAction assignAction(\Closure|null $callback = null)
 * @method self|Atlas atlas(\Closure|null $callback = null)
 * @method self|Attorney attorney(\Closure|null $callback = null)
 * @method self|Audience audience(\Closure|null $callback = null)
 * @method self|AudioObject audioObject(\Closure|null $callback = null)
 * @method self|AudioObjectSnapshot audioObjectSnapshot(\Closure|null $callback = null)
 * @method self|Audiobook audiobook(\Closure|null $callback = null)
 * @method self|AuthorizeAction authorizeAction(\Closure|null $callback = null)
 * @method self|AutoBodyShop autoBodyShop(\Closure|null $callback = null)
 * @method self|AutoDealer autoDealer(\Closure|null $callback = null)
 * @method self|AutoPartsStore autoPartsStore(\Closure|null $callback = null)
 * @method self|AutoRental autoRental(\Closure|null $callback = null)
 * @method self|AutoRepair autoRepair(\Closure|null $callback = null)
 * @method self|AutoWash autoWash(\Closure|null $callback = null)
 * @method self|AutomatedTeller automatedTeller(\Closure|null $callback = null)
 * @method self|AutomotiveBusiness automotiveBusiness(\Closure|null $callback = null)
 * @method self|BackgroundNewsArticle backgroundNewsArticle(\Closure|null $callback = null)
 * @method self|Bakery bakery(\Closure|null $callback = null)
 * @method self|BankAccount bankAccount(\Closure|null $callback = null)
 * @method self|BankOrCreditUnion bankOrCreditUnion(\Closure|null $callback = null)
 * @method self|BarOrPub barOrPub(\Closure|null $callback = null)
 * @method self|Barcode barcode(\Closure|null $callback = null)
 * @method self|Beach beach(\Closure|null $callback = null)
 * @method self|BeautySalon beautySalon(\Closure|null $callback = null)
 * @method self|BedAndBreakfast bedAndBreakfast(\Closure|null $callback = null)
 * @method self|BedDetails bedDetails(\Closure|null $callback = null)
 * @method self|BedType bedType(\Closure|null $callback = null)
 * @method self|BefriendAction befriendAction(\Closure|null $callback = null)
 * @method self|BikeStore bikeStore(\Closure|null $callback = null)
 * @method self|BioChemEntity bioChemEntity(\Closure|null $callback = null)
 * @method self|Blog blog(\Closure|null $callback = null)
 * @method self|BlogPosting blogPosting(\Closure|null $callback = null)
 * @method self|BloodTest bloodTest(\Closure|null $callback = null)
 * @method self|BoardingPolicyType boardingPolicyType(\Closure|null $callback = null)
 * @method self|BoatReservation boatReservation(\Closure|null $callback = null)
 * @method self|BoatTerminal boatTerminal(\Closure|null $callback = null)
 * @method self|BoatTrip boatTrip(\Closure|null $callback = null)
 * @method self|BodyMeasurementTypeEnumeration bodyMeasurementTypeEnumeration(\Closure|null $callback = null)
 * @method self|BodyOfWater bodyOfWater(\Closure|null $callback = null)
 * @method self|Bone bone(\Closure|null $callback = null)
 * @method self|Book book(\Closure|null $callback = null)
 * @method self|BookFormatType bookFormatType(\Closure|null $callback = null)
 * @method self|BookSeries bookSeries(\Closure|null $callback = null)
 * @method self|BookStore bookStore(\Closure|null $callback = null)
 * @method self|BookmarkAction bookmarkAction(\Closure|null $callback = null)
 * @method self|BorrowAction borrowAction(\Closure|null $callback = null)
 * @method self|BowlingAlley bowlingAlley(\Closure|null $callback = null)
 * @method self|BrainStructure brainStructure(\Closure|null $callback = null)
 * @method self|Brand brand(\Closure|null $callback = null)
 * @method self|BreadcrumbList breadcrumbList(\Closure|null $callback = null)
 * @method self|Brewery brewery(\Closure|null $callback = null)
 * @method self|Bridge bridge(\Closure|null $callback = null)
 * @method self|BroadcastChannel broadcastChannel(\Closure|null $callback = null)
 * @method self|BroadcastEvent broadcastEvent(\Closure|null $callback = null)
 * @method self|BroadcastFrequencySpecification broadcastFrequencySpecification(\Closure|null $callback = null)
 * @method self|BroadcastService broadcastService(\Closure|null $callback = null)
 * @method self|BrokerageAccount brokerageAccount(\Closure|null $callback = null)
 * @method self|BuddhistTemple buddhistTemple(\Closure|null $callback = null)
 * @method self|BusOrCoach busOrCoach(\Closure|null $callback = null)
 * @method self|BusReservation busReservation(\Closure|null $callback = null)
 * @method self|BusStation busStation(\Closure|null $callback = null)
 * @method self|BusStop busStop(\Closure|null $callback = null)
 * @method self|BusTrip busTrip(\Closure|null $callback = null)
 * @method self|BusinessAudience businessAudience(\Closure|null $callback = null)
 * @method self|BusinessEntityType businessEntityType(\Closure|null $callback = null)
 * @method self|BusinessEvent businessEvent(\Closure|null $callback = null)
 * @method self|BusinessFunction businessFunction(\Closure|null $callback = null)
 * @method self|BuyAction buyAction(\Closure|null $callback = null)
 * @method self|CDCPMDRecord cDCPMDRecord(\Closure|null $callback = null)
 * @method self|CableOrSatelliteService cableOrSatelliteService(\Closure|null $callback = null)
 * @method self|CafeOrCoffeeShop cafeOrCoffeeShop(\Closure|null $callback = null)
 * @method self|Campground campground(\Closure|null $callback = null)
 * @method self|CampingPitch campingPitch(\Closure|null $callback = null)
 * @method self|Canal canal(\Closure|null $callback = null)
 * @method self|CancelAction cancelAction(\Closure|null $callback = null)
 * @method self|Car car(\Closure|null $callback = null)
 * @method self|CarUsageType carUsageType(\Closure|null $callback = null)
 * @method self|Casino casino(\Closure|null $callback = null)
 * @method self|CategoryCode categoryCode(\Closure|null $callback = null)
 * @method self|CategoryCodeSet categoryCodeSet(\Closure|null $callback = null)
 * @method self|CatholicChurch catholicChurch(\Closure|null $callback = null)
 * @method self|Cemetery cemetery(\Closure|null $callback = null)
 * @method self|Chapter chapter(\Closure|null $callback = null)
 * @method self|CheckAction checkAction(\Closure|null $callback = null)
 * @method self|CheckInAction checkInAction(\Closure|null $callback = null)
 * @method self|CheckOutAction checkOutAction(\Closure|null $callback = null)
 * @method self|CheckoutPage checkoutPage(\Closure|null $callback = null)
 * @method self|ChemicalSubstance chemicalSubstance(\Closure|null $callback = null)
 * @method self|ChildCare childCare(\Closure|null $callback = null)
 * @method self|ChildrensEvent childrensEvent(\Closure|null $callback = null)
 * @method self|ChooseAction chooseAction(\Closure|null $callback = null)
 * @method self|Church church(\Closure|null $callback = null)
 * @method self|City city(\Closure|null $callback = null)
 * @method self|CityHall cityHall(\Closure|null $callback = null)
 * @method self|CivicStructure civicStructure(\Closure|null $callback = null)
 * @method self|Claim claim(\Closure|null $callback = null)
 * @method self|ClaimReview claimReview(\Closure|null $callback = null)
 * @method self|Clip clip(\Closure|null $callback = null)
 * @method self|ClothingStore clothingStore(\Closure|null $callback = null)
 * @method self|Code code(\Closure|null $callback = null)
 * @method self|Collection collection(\Closure|null $callback = null)
 * @method self|CollectionPage collectionPage(\Closure|null $callback = null)
 * @method self|CollegeOrUniversity collegeOrUniversity(\Closure|null $callback = null)
 * @method self|ComedyClub comedyClub(\Closure|null $callback = null)
 * @method self|ComedyEvent comedyEvent(\Closure|null $callback = null)
 * @method self|ComicCoverArt comicCoverArt(\Closure|null $callback = null)
 * @method self|ComicIssue comicIssue(\Closure|null $callback = null)
 * @method self|ComicSeries comicSeries(\Closure|null $callback = null)
 * @method self|ComicStory comicStory(\Closure|null $callback = null)
 * @method self|Comment comment(\Closure|null $callback = null)
 * @method self|CommentAction commentAction(\Closure|null $callback = null)
 * @method self|CommunicateAction communicateAction(\Closure|null $callback = null)
 * @method self|CompleteDataFeed completeDataFeed(\Closure|null $callback = null)
 * @method self|CompoundPriceSpecification compoundPriceSpecification(\Closure|null $callback = null)
 * @method self|ComputerLanguage computerLanguage(\Closure|null $callback = null)
 * @method self|ComputerStore computerStore(\Closure|null $callback = null)
 * @method self|ConfirmAction confirmAction(\Closure|null $callback = null)
 * @method self|Consortium consortium(\Closure|null $callback = null)
 * @method self|ConstraintNode constraintNode(\Closure|null $callback = null)
 * @method self|ConsumeAction consumeAction(\Closure|null $callback = null)
 * @method self|ContactPage contactPage(\Closure|null $callback = null)
 * @method self|ContactPoint contactPoint(\Closure|null $callback = null)
 * @method self|ContactPointOption contactPointOption(\Closure|null $callback = null)
 * @method self|Continent continent(\Closure|null $callback = null)
 * @method self|ControlAction controlAction(\Closure|null $callback = null)
 * @method self|ConvenienceStore convenienceStore(\Closure|null $callback = null)
 * @method self|Conversation conversation(\Closure|null $callback = null)
 * @method self|CookAction cookAction(\Closure|null $callback = null)
 * @method self|Corporation corporation(\Closure|null $callback = null)
 * @method self|CorrectionComment correctionComment(\Closure|null $callback = null)
 * @method self|Country country(\Closure|null $callback = null)
 * @method self|Course course(\Closure|null $callback = null)
 * @method self|CourseInstance courseInstance(\Closure|null $callback = null)
 * @method self|Courthouse courthouse(\Closure|null $callback = null)
 * @method self|CoverArt coverArt(\Closure|null $callback = null)
 * @method self|CovidTestingFacility covidTestingFacility(\Closure|null $callback = null)
 * @method self|CreateAction createAction(\Closure|null $callback = null)
 * @method self|CreativeWork creativeWork(\Closure|null $callback = null)
 * @method self|CreativeWorkSeason creativeWorkSeason(\Closure|null $callback = null)
 * @method self|CreativeWorkSeries creativeWorkSeries(\Closure|null $callback = null)
 * @method self|CreditCard creditCard(\Closure|null $callback = null)
 * @method self|Crematorium crematorium(\Closure|null $callback = null)
 * @method self|CriticReview criticReview(\Closure|null $callback = null)
 * @method self|CssSelectorType cssSelectorType(\Closure|null $callback = null)
 * @method self|CurrencyConversionService currencyConversionService(\Closure|null $callback = null)
 * @method self|DDxElement dDxElement(\Closure|null $callback = null)
 * @method self|DanceEvent danceEvent(\Closure|null $callback = null)
 * @method self|DanceGroup danceGroup(\Closure|null $callback = null)
 * @method self|DataCatalog dataCatalog(\Closure|null $callback = null)
 * @method self|DataDownload dataDownload(\Closure|null $callback = null)
 * @method self|DataFeed dataFeed(\Closure|null $callback = null)
 * @method self|DataFeedItem dataFeedItem(\Closure|null $callback = null)
 * @method self|Dataset dataset(\Closure|null $callback = null)
 * @method self|DatedMoneySpecification datedMoneySpecification(\Closure|null $callback = null)
 * @method self|DayOfWeek dayOfWeek(\Closure|null $callback = null)
 * @method self|DaySpa daySpa(\Closure|null $callback = null)
 * @method self|DeactivateAction deactivateAction(\Closure|null $callback = null)
 * @method self|DefenceEstablishment defenceEstablishment(\Closure|null $callback = null)
 * @method self|DefinedRegion definedRegion(\Closure|null $callback = null)
 * @method self|DefinedTerm definedTerm(\Closure|null $callback = null)
 * @method self|DefinedTermSet definedTermSet(\Closure|null $callback = null)
 * @method self|DeleteAction deleteAction(\Closure|null $callback = null)
 * @method self|DeliveryChargeSpecification deliveryChargeSpecification(\Closure|null $callback = null)
 * @method self|DeliveryEvent deliveryEvent(\Closure|null $callback = null)
 * @method self|DeliveryMethod deliveryMethod(\Closure|null $callback = null)
 * @method self|DeliveryTimeSettings deliveryTimeSettings(\Closure|null $callback = null)
 * @method self|Demand demand(\Closure|null $callback = null)
 * @method self|Dentist dentist(\Closure|null $callback = null)
 * @method self|DepartAction departAction(\Closure|null $callback = null)
 * @method self|DepartmentStore departmentStore(\Closure|null $callback = null)
 * @method self|DepositAccount depositAccount(\Closure|null $callback = null)
 * @method self|DiagnosticLab diagnosticLab(\Closure|null $callback = null)
 * @method self|DiagnosticProcedure diagnosticProcedure(\Closure|null $callback = null)
 * @method self|Diet diet(\Closure|null $callback = null)
 * @method self|DietarySupplement dietarySupplement(\Closure|null $callback = null)
 * @method self|DigitalDocument digitalDocument(\Closure|null $callback = null)
 * @method self|DigitalDocumentPermission digitalDocumentPermission(\Closure|null $callback = null)
 * @method self|DigitalDocumentPermissionType digitalDocumentPermissionType(\Closure|null $callback = null)
 * @method self|DigitalPlatformEnumeration digitalPlatformEnumeration(\Closure|null $callback = null)
 * @method self|DisagreeAction disagreeAction(\Closure|null $callback = null)
 * @method self|DiscoverAction discoverAction(\Closure|null $callback = null)
 * @method self|DiscussionForumPosting discussionForumPosting(\Closure|null $callback = null)
 * @method self|DislikeAction dislikeAction(\Closure|null $callback = null)
 * @method self|Distance distance(\Closure|null $callback = null)
 * @method self|Distillery distillery(\Closure|null $callback = null)
 * @method self|DonateAction donateAction(\Closure|null $callback = null)
 * @method self|DoseSchedule doseSchedule(\Closure|null $callback = null)
 * @method self|DownloadAction downloadAction(\Closure|null $callback = null)
 * @method self|DrawAction drawAction(\Closure|null $callback = null)
 * @method self|Drawing drawing(\Closure|null $callback = null)
 * @method self|DrinkAction drinkAction(\Closure|null $callback = null)
 * @method self|DriveWheelConfigurationValue driveWheelConfigurationValue(\Closure|null $callback = null)
 * @method self|Drug drug(\Closure|null $callback = null)
 * @method self|DrugClass drugClass(\Closure|null $callback = null)
 * @method self|DrugCost drugCost(\Closure|null $callback = null)
 * @method self|DrugCostCategory drugCostCategory(\Closure|null $callback = null)
 * @method self|DrugLegalStatus drugLegalStatus(\Closure|null $callback = null)
 * @method self|DrugPregnancyCategory drugPregnancyCategory(\Closure|null $callback = null)
 * @method self|DrugPrescriptionStatus drugPrescriptionStatus(\Closure|null $callback = null)
 * @method self|DrugStrength drugStrength(\Closure|null $callback = null)
 * @method self|DryCleaningOrLaundry dryCleaningOrLaundry(\Closure|null $callback = null)
 * @method self|Duration duration(\Closure|null $callback = null)
 * @method self|EUEnergyEfficiencyEnumeration eUEnergyEfficiencyEnumeration(\Closure|null $callback = null)
 * @method self|EatAction eatAction(\Closure|null $callback = null)
 * @method self|EducationEvent educationEvent(\Closure|null $callback = null)
 * @method self|EducationalAudience educationalAudience(\Closure|null $callback = null)
 * @method self|EducationalOccupationalCredential educationalOccupationalCredential(\Closure|null $callback = null)
 * @method self|EducationalOccupationalProgram educationalOccupationalProgram(\Closure|null $callback = null)
 * @method self|EducationalOrganization educationalOrganization(\Closure|null $callback = null)
 * @method self|Electrician electrician(\Closure|null $callback = null)
 * @method self|ElectronicsStore electronicsStore(\Closure|null $callback = null)
 * @method self|ElementarySchool elementarySchool(\Closure|null $callback = null)
 * @method self|EmailMessage emailMessage(\Closure|null $callback = null)
 * @method self|Embassy embassy(\Closure|null $callback = null)
 * @method self|EmergencyService emergencyService(\Closure|null $callback = null)
 * @method self|EmployeeRole employeeRole(\Closure|null $callback = null)
 * @method self|EmployerAggregateRating employerAggregateRating(\Closure|null $callback = null)
 * @method self|EmployerReview employerReview(\Closure|null $callback = null)
 * @method self|EmploymentAgency employmentAgency(\Closure|null $callback = null)
 * @method self|EndorseAction endorseAction(\Closure|null $callback = null)
 * @method self|EndorsementRating endorsementRating(\Closure|null $callback = null)
 * @method self|Energy energy(\Closure|null $callback = null)
 * @method self|EnergyConsumptionDetails energyConsumptionDetails(\Closure|null $callback = null)
 * @method self|EnergyEfficiencyEnumeration energyEfficiencyEnumeration(\Closure|null $callback = null)
 * @method self|EnergyStarEnergyEfficiencyEnumeration energyStarEnergyEfficiencyEnumeration(\Closure|null $callback = null)
 * @method self|EngineSpecification engineSpecification(\Closure|null $callback = null)
 * @method self|EntertainmentBusiness entertainmentBusiness(\Closure|null $callback = null)
 * @method self|EntryPoint entryPoint(\Closure|null $callback = null)
 * @method self|Enumeration enumeration(\Closure|null $callback = null)
 * @method self|Episode episode(\Closure|null $callback = null)
 * @method self|Event event(\Closure|null $callback = null)
 * @method self|EventAttendanceModeEnumeration eventAttendanceModeEnumeration(\Closure|null $callback = null)
 * @method self|EventReservation eventReservation(\Closure|null $callback = null)
 * @method self|EventSeries eventSeries(\Closure|null $callback = null)
 * @method self|EventStatusType eventStatusType(\Closure|null $callback = null)
 * @method self|EventVenue eventVenue(\Closure|null $callback = null)
 * @method self|ExchangeRateSpecification exchangeRateSpecification(\Closure|null $callback = null)
 * @method self|ExerciseAction exerciseAction(\Closure|null $callback = null)
 * @method self|ExerciseGym exerciseGym(\Closure|null $callback = null)
 * @method self|ExercisePlan exercisePlan(\Closure|null $callback = null)
 * @method self|ExhibitionEvent exhibitionEvent(\Closure|null $callback = null)
 * @method self|FAQPage fAQPage(\Closure|null $callback = null)
 * @method self|FMRadioChannel fMRadioChannel(\Closure|null $callback = null)
 * @method self|FastFoodRestaurant fastFoodRestaurant(\Closure|null $callback = null)
 * @method self|Festival festival(\Closure|null $callback = null)
 * @method self|FilmAction filmAction(\Closure|null $callback = null)
 * @method self|FinancialProduct financialProduct(\Closure|null $callback = null)
 * @method self|FinancialService financialService(\Closure|null $callback = null)
 * @method self|FindAction findAction(\Closure|null $callback = null)
 * @method self|FireStation fireStation(\Closure|null $callback = null)
 * @method self|Flight flight(\Closure|null $callback = null)
 * @method self|FlightReservation flightReservation(\Closure|null $callback = null)
 * @method self|FloorPlan floorPlan(\Closure|null $callback = null)
 * @method self|Florist florist(\Closure|null $callback = null)
 * @method self|FollowAction followAction(\Closure|null $callback = null)
 * @method self|FoodEstablishment foodEstablishment(\Closure|null $callback = null)
 * @method self|FoodEstablishmentReservation foodEstablishmentReservation(\Closure|null $callback = null)
 * @method self|FoodEvent foodEvent(\Closure|null $callback = null)
 * @method self|FoodService foodService(\Closure|null $callback = null)
 * @method self|FundingAgency fundingAgency(\Closure|null $callback = null)
 * @method self|FundingScheme fundingScheme(\Closure|null $callback = null)
 * @method self|FurnitureStore furnitureStore(\Closure|null $callback = null)
 * @method self|Game game(\Closure|null $callback = null)
 * @method self|GameAvailabilityEnumeration gameAvailabilityEnumeration(\Closure|null $callback = null)
 * @method self|GamePlayMode gamePlayMode(\Closure|null $callback = null)
 * @method self|GameServer gameServer(\Closure|null $callback = null)
 * @method self|GameServerStatus gameServerStatus(\Closure|null $callback = null)
 * @method self|GardenStore gardenStore(\Closure|null $callback = null)
 * @method self|GasStation gasStation(\Closure|null $callback = null)
 * @method self|GatedResidenceCommunity gatedResidenceCommunity(\Closure|null $callback = null)
 * @method self|GenderType genderType(\Closure|null $callback = null)
 * @method self|Gene gene(\Closure|null $callback = null)
 * @method self|GeneralContractor generalContractor(\Closure|null $callback = null)
 * @method self|GeoCircle geoCircle(\Closure|null $callback = null)
 * @method self|GeoCoordinates geoCoordinates(\Closure|null $callback = null)
 * @method self|GeoShape geoShape(\Closure|null $callback = null)
 * @method self|GeospatialGeometry geospatialGeometry(\Closure|null $callback = null)
 * @method self|GiveAction giveAction(\Closure|null $callback = null)
 * @method self|GolfCourse golfCourse(\Closure|null $callback = null)
 * @method self|GovernmentBenefitsType governmentBenefitsType(\Closure|null $callback = null)
 * @method self|GovernmentBuilding governmentBuilding(\Closure|null $callback = null)
 * @method self|GovernmentOffice governmentOffice(\Closure|null $callback = null)
 * @method self|GovernmentOrganization governmentOrganization(\Closure|null $callback = null)
 * @method self|GovernmentPermit governmentPermit(\Closure|null $callback = null)
 * @method self|GovernmentService governmentService(\Closure|null $callback = null)
 * @method self|Grant grant(\Closure|null $callback = null)
 * @method self|GroceryStore groceryStore(\Closure|null $callback = null)
 * @method self|Guide guide(\Closure|null $callback = null)
 * @method self|HVACBusiness hVACBusiness(\Closure|null $callback = null)
 * @method self|Hackathon hackathon(\Closure|null $callback = null)
 * @method self|HairSalon hairSalon(\Closure|null $callback = null)
 * @method self|HardwareStore hardwareStore(\Closure|null $callback = null)
 * @method self|HealthAndBeautyBusiness healthAndBeautyBusiness(\Closure|null $callback = null)
 * @method self|HealthAspectEnumeration healthAspectEnumeration(\Closure|null $callback = null)
 * @method self|HealthClub healthClub(\Closure|null $callback = null)
 * @method self|HealthInsurancePlan healthInsurancePlan(\Closure|null $callback = null)
 * @method self|HealthPlanCostSharingSpecification healthPlanCostSharingSpecification(\Closure|null $callback = null)
 * @method self|HealthPlanFormulary healthPlanFormulary(\Closure|null $callback = null)
 * @method self|HealthPlanNetwork healthPlanNetwork(\Closure|null $callback = null)
 * @method self|HealthTopicContent healthTopicContent(\Closure|null $callback = null)
 * @method self|HighSchool highSchool(\Closure|null $callback = null)
 * @method self|HinduTemple hinduTemple(\Closure|null $callback = null)
 * @method self|HobbyShop hobbyShop(\Closure|null $callback = null)
 * @method self|HomeAndConstructionBusiness homeAndConstructionBusiness(\Closure|null $callback = null)
 * @method self|HomeGoodsStore homeGoodsStore(\Closure|null $callback = null)
 * @method self|Hospital hospital(\Closure|null $callback = null)
 * @method self|Hostel hostel(\Closure|null $callback = null)
 * @method self|Hotel hotel(\Closure|null $callback = null)
 * @method self|HotelRoom hotelRoom(\Closure|null $callback = null)
 * @method self|House house(\Closure|null $callback = null)
 * @method self|HousePainter housePainter(\Closure|null $callback = null)
 * @method self|HowTo howTo(\Closure|null $callback = null)
 * @method self|HowToDirection howToDirection(\Closure|null $callback = null)
 * @method self|HowToItem howToItem(\Closure|null $callback = null)
 * @method self|HowToSection howToSection(\Closure|null $callback = null)
 * @method self|HowToStep howToStep(\Closure|null $callback = null)
 * @method self|HowToSupply howToSupply(\Closure|null $callback = null)
 * @method self|HowToTip howToTip(\Closure|null $callback = null)
 * @method self|HowToTool howToTool(\Closure|null $callback = null)
 * @method self|HyperToc hyperToc(\Closure|null $callback = null)
 * @method self|HyperTocEntry hyperTocEntry(\Closure|null $callback = null)
 * @method self|IPTCDigitalSourceEnumeration iPTCDigitalSourceEnumeration(\Closure|null $callback = null)
 * @method self|IceCreamShop iceCreamShop(\Closure|null $callback = null)
 * @method self|IgnoreAction ignoreAction(\Closure|null $callback = null)
 * @method self|ImageGallery imageGallery(\Closure|null $callback = null)
 * @method self|ImageObject imageObject(\Closure|null $callback = null)
 * @method self|ImageObjectSnapshot imageObjectSnapshot(\Closure|null $callback = null)
 * @method self|ImagingTest imagingTest(\Closure|null $callback = null)
 * @method self|IndividualPhysician individualPhysician(\Closure|null $callback = null)
 * @method self|IndividualProduct individualProduct(\Closure|null $callback = null)
 * @method self|InfectiousAgentClass infectiousAgentClass(\Closure|null $callback = null)
 * @method self|InfectiousDisease infectiousDisease(\Closure|null $callback = null)
 * @method self|InformAction informAction(\Closure|null $callback = null)
 * @method self|InsertAction insertAction(\Closure|null $callback = null)
 * @method self|InstallAction installAction(\Closure|null $callback = null)
 * @method self|InsuranceAgency insuranceAgency(\Closure|null $callback = null)
 * @method self|Intangible intangible(\Closure|null $callback = null)
 * @method self|InteractAction interactAction(\Closure|null $callback = null)
 * @method self|InteractionCounter interactionCounter(\Closure|null $callback = null)
 * @method self|InternetCafe internetCafe(\Closure|null $callback = null)
 * @method self|InvestmentFund investmentFund(\Closure|null $callback = null)
 * @method self|InvestmentOrDeposit investmentOrDeposit(\Closure|null $callback = null)
 * @method self|InviteAction inviteAction(\Closure|null $callback = null)
 * @method self|Invoice invoice(\Closure|null $callback = null)
 * @method self|ItemAvailability itemAvailability(\Closure|null $callback = null)
 * @method self|ItemList itemList(\Closure|null $callback = null)
 * @method self|ItemListOrderType itemListOrderType(\Closure|null $callback = null)
 * @method self|ItemPage itemPage(\Closure|null $callback = null)
 * @method self|JewelryStore jewelryStore(\Closure|null $callback = null)
 * @method self|JobPosting jobPosting(\Closure|null $callback = null)
 * @method self|JoinAction joinAction(\Closure|null $callback = null)
 * @method self|Joint joint(\Closure|null $callback = null)
 * @method self|LakeBodyOfWater lakeBodyOfWater(\Closure|null $callback = null)
 * @method self|Landform landform(\Closure|null $callback = null)
 * @method self|LandmarksOrHistoricalBuildings landmarksOrHistoricalBuildings(\Closure|null $callback = null)
 * @method self|Language language(\Closure|null $callback = null)
 * @method self|LearningResource learningResource(\Closure|null $callback = null)
 * @method self|LeaveAction leaveAction(\Closure|null $callback = null)
 * @method self|LegalForceStatus legalForceStatus(\Closure|null $callback = null)
 * @method self|LegalService legalService(\Closure|null $callback = null)
 * @method self|LegalValueLevel legalValueLevel(\Closure|null $callback = null)
 * @method self|Legislation legislation(\Closure|null $callback = null)
 * @method self|LegislationObject legislationObject(\Closure|null $callback = null)
 * @method self|LegislativeBuilding legislativeBuilding(\Closure|null $callback = null)
 * @method self|LendAction lendAction(\Closure|null $callback = null)
 * @method self|Library library(\Closure|null $callback = null)
 * @method self|LibrarySystem librarySystem(\Closure|null $callback = null)
 * @method self|LifestyleModification lifestyleModification(\Closure|null $callback = null)
 * @method self|Ligament ligament(\Closure|null $callback = null)
 * @method self|LikeAction likeAction(\Closure|null $callback = null)
 * @method self|LinkRole linkRole(\Closure|null $callback = null)
 * @method self|LiquorStore liquorStore(\Closure|null $callback = null)
 * @method self|ListItem listItem(\Closure|null $callback = null)
 * @method self|ListenAction listenAction(\Closure|null $callback = null)
 * @method self|LiteraryEvent literaryEvent(\Closure|null $callback = null)
 * @method self|LiveBlogPosting liveBlogPosting(\Closure|null $callback = null)
 * @method self|LoanOrCredit loanOrCredit(\Closure|null $callback = null)
 * @method self|LocalBusiness localBusiness(\Closure|null $callback = null)
 * @method self|LocationFeatureSpecification locationFeatureSpecification(\Closure|null $callback = null)
 * @method self|Locksmith locksmith(\Closure|null $callback = null)
 * @method self|LodgingBusiness lodgingBusiness(\Closure|null $callback = null)
 * @method self|LodgingReservation lodgingReservation(\Closure|null $callback = null)
 * @method self|LoseAction loseAction(\Closure|null $callback = null)
 * @method self|LymphaticVessel lymphaticVessel(\Closure|null $callback = null)
 * @method self|Manuscript manuscript(\Closure|null $callback = null)
 * @method self|Map map(\Closure|null $callback = null)
 * @method self|MapCategoryType mapCategoryType(\Closure|null $callback = null)
 * @method self|MarryAction marryAction(\Closure|null $callback = null)
 * @method self|Mass mass(\Closure|null $callback = null)
 * @method self|MathSolver mathSolver(\Closure|null $callback = null)
 * @method self|MaximumDoseSchedule maximumDoseSchedule(\Closure|null $callback = null)
 * @method self|MeasurementMethodEnum measurementMethodEnum(\Closure|null $callback = null)
 * @method self|MeasurementTypeEnumeration measurementTypeEnumeration(\Closure|null $callback = null)
 * @method self|MediaEnumeration mediaEnumeration(\Closure|null $callback = null)
 * @method self|MediaGallery mediaGallery(\Closure|null $callback = null)
 * @method self|MediaManipulationRatingEnumeration mediaManipulationRatingEnumeration(\Closure|null $callback = null)
 * @method self|MediaObject mediaObject(\Closure|null $callback = null)
 * @method self|MediaReview mediaReview(\Closure|null $callback = null)
 * @method self|MediaReviewItem mediaReviewItem(\Closure|null $callback = null)
 * @method self|MediaSubscription mediaSubscription(\Closure|null $callback = null)
 * @method self|MedicalAudience medicalAudience(\Closure|null $callback = null)
 * @method self|MedicalAudienceType medicalAudienceType(\Closure|null $callback = null)
 * @method self|MedicalBusiness medicalBusiness(\Closure|null $callback = null)
 * @method self|MedicalCause medicalCause(\Closure|null $callback = null)
 * @method self|MedicalClinic medicalClinic(\Closure|null $callback = null)
 * @method self|MedicalCode medicalCode(\Closure|null $callback = null)
 * @method self|MedicalCondition medicalCondition(\Closure|null $callback = null)
 * @method self|MedicalConditionStage medicalConditionStage(\Closure|null $callback = null)
 * @method self|MedicalContraindication medicalContraindication(\Closure|null $callback = null)
 * @method self|MedicalDevice medicalDevice(\Closure|null $callback = null)
 * @method self|MedicalDevicePurpose medicalDevicePurpose(\Closure|null $callback = null)
 * @method self|MedicalEntity medicalEntity(\Closure|null $callback = null)
 * @method self|MedicalEnumeration medicalEnumeration(\Closure|null $callback = null)
 * @method self|MedicalEvidenceLevel medicalEvidenceLevel(\Closure|null $callback = null)
 * @method self|MedicalGuideline medicalGuideline(\Closure|null $callback = null)
 * @method self|MedicalGuidelineContraindication medicalGuidelineContraindication(\Closure|null $callback = null)
 * @method self|MedicalGuidelineRecommendation medicalGuidelineRecommendation(\Closure|null $callback = null)
 * @method self|MedicalImagingTechnique medicalImagingTechnique(\Closure|null $callback = null)
 * @method self|MedicalIndication medicalIndication(\Closure|null $callback = null)
 * @method self|MedicalIntangible medicalIntangible(\Closure|null $callback = null)
 * @method self|MedicalObservationalStudy medicalObservationalStudy(\Closure|null $callback = null)
 * @method self|MedicalObservationalStudyDesign medicalObservationalStudyDesign(\Closure|null $callback = null)
 * @method self|MedicalOrganization medicalOrganization(\Closure|null $callback = null)
 * @method self|MedicalProcedure medicalProcedure(\Closure|null $callback = null)
 * @method self|MedicalProcedureType medicalProcedureType(\Closure|null $callback = null)
 * @method self|MedicalRiskCalculator medicalRiskCalculator(\Closure|null $callback = null)
 * @method self|MedicalRiskEstimator medicalRiskEstimator(\Closure|null $callback = null)
 * @method self|MedicalRiskFactor medicalRiskFactor(\Closure|null $callback = null)
 * @method self|MedicalRiskScore medicalRiskScore(\Closure|null $callback = null)
 * @method self|MedicalScholarlyArticle medicalScholarlyArticle(\Closure|null $callback = null)
 * @method self|MedicalSign medicalSign(\Closure|null $callback = null)
 * @method self|MedicalSignOrSymptom medicalSignOrSymptom(\Closure|null $callback = null)
 * @method self|MedicalSpecialty medicalSpecialty(\Closure|null $callback = null)
 * @method self|MedicalStudy medicalStudy(\Closure|null $callback = null)
 * @method self|MedicalStudyStatus medicalStudyStatus(\Closure|null $callback = null)
 * @method self|MedicalSymptom medicalSymptom(\Closure|null $callback = null)
 * @method self|MedicalTest medicalTest(\Closure|null $callback = null)
 * @method self|MedicalTestPanel medicalTestPanel(\Closure|null $callback = null)
 * @method self|MedicalTherapy medicalTherapy(\Closure|null $callback = null)
 * @method self|MedicalTrial medicalTrial(\Closure|null $callback = null)
 * @method self|MedicalTrialDesign medicalTrialDesign(\Closure|null $callback = null)
 * @method self|MedicalWebPage medicalWebPage(\Closure|null $callback = null)
 * @method self|MedicineSystem medicineSystem(\Closure|null $callback = null)
 * @method self|MeetingRoom meetingRoom(\Closure|null $callback = null)
 * @method self|MensClothingStore mensClothingStore(\Closure|null $callback = null)
 * @method self|Menu menu(\Closure|null $callback = null)
 * @method self|MenuItem menuItem(\Closure|null $callback = null)
 * @method self|MenuSection menuSection(\Closure|null $callback = null)
 * @method self|MerchantReturnEnumeration merchantReturnEnumeration(\Closure|null $callback = null)
 * @method self|MerchantReturnPolicy merchantReturnPolicy(\Closure|null $callback = null)
 * @method self|MerchantReturnPolicySeasonalOverride merchantReturnPolicySeasonalOverride(\Closure|null $callback = null)
 * @method self|Message message(\Closure|null $callback = null)
 * @method self|MiddleSchool middleSchool(\Closure|null $callback = null)
 * @method self|MobileApplication mobileApplication(\Closure|null $callback = null)
 * @method self|MobilePhoneStore mobilePhoneStore(\Closure|null $callback = null)
 * @method self|MolecularEntity molecularEntity(\Closure|null $callback = null)
 * @method self|MonetaryAmount monetaryAmount(\Closure|null $callback = null)
 * @method self|MonetaryAmountDistribution monetaryAmountDistribution(\Closure|null $callback = null)
 * @method self|MonetaryGrant monetaryGrant(\Closure|null $callback = null)
 * @method self|MoneyTransfer moneyTransfer(\Closure|null $callback = null)
 * @method self|MortgageLoan mortgageLoan(\Closure|null $callback = null)
 * @method self|Mosque mosque(\Closure|null $callback = null)
 * @method self|Motel motel(\Closure|null $callback = null)
 * @method self|Motorcycle motorcycle(\Closure|null $callback = null)
 * @method self|MotorcycleDealer motorcycleDealer(\Closure|null $callback = null)
 * @method self|MotorcycleRepair motorcycleRepair(\Closure|null $callback = null)
 * @method self|MotorizedBicycle motorizedBicycle(\Closure|null $callback = null)
 * @method self|Mountain mountain(\Closure|null $callback = null)
 * @method self|MoveAction moveAction(\Closure|null $callback = null)
 * @method self|Movie movie(\Closure|null $callback = null)
 * @method self|MovieClip movieClip(\Closure|null $callback = null)
 * @method self|MovieRentalStore movieRentalStore(\Closure|null $callback = null)
 * @method self|MovieSeries movieSeries(\Closure|null $callback = null)
 * @method self|MovieTheater movieTheater(\Closure|null $callback = null)
 * @method self|MovingCompany movingCompany(\Closure|null $callback = null)
 * @method self|Muscle muscle(\Closure|null $callback = null)
 * @method self|Museum museum(\Closure|null $callback = null)
 * @method self|MusicAlbum musicAlbum(\Closure|null $callback = null)
 * @method self|MusicAlbumProductionType musicAlbumProductionType(\Closure|null $callback = null)
 * @method self|MusicAlbumReleaseType musicAlbumReleaseType(\Closure|null $callback = null)
 * @method self|MusicComposition musicComposition(\Closure|null $callback = null)
 * @method self|MusicEvent musicEvent(\Closure|null $callback = null)
 * @method self|MusicGroup musicGroup(\Closure|null $callback = null)
 * @method self|MusicPlaylist musicPlaylist(\Closure|null $callback = null)
 * @method self|MusicRecording musicRecording(\Closure|null $callback = null)
 * @method self|MusicRelease musicRelease(\Closure|null $callback = null)
 * @method self|MusicReleaseFormatType musicReleaseFormatType(\Closure|null $callback = null)
 * @method self|MusicStore musicStore(\Closure|null $callback = null)
 * @method self|MusicVenue musicVenue(\Closure|null $callback = null)
 * @method self|MusicVideoObject musicVideoObject(\Closure|null $callback = null)
 * @method self|NGO nGO(\Closure|null $callback = null)
 * @method self|NLNonprofitType nLNonprofitType(\Closure|null $callback = null)
 * @method self|NailSalon nailSalon(\Closure|null $callback = null)
 * @method self|Nerve nerve(\Closure|null $callback = null)
 * @method self|NewsArticle newsArticle(\Closure|null $callback = null)
 * @method self|NewsMediaOrganization newsMediaOrganization(\Closure|null $callback = null)
 * @method self|Newspaper newspaper(\Closure|null $callback = null)
 * @method self|NightClub nightClub(\Closure|null $callback = null)
 * @method self|NonprofitType nonprofitType(\Closure|null $callback = null)
 * @method self|Notary notary(\Closure|null $callback = null)
 * @method self|NoteDigitalDocument noteDigitalDocument(\Closure|null $callback = null)
 * @method self|NutritionInformation nutritionInformation(\Closure|null $callback = null)
 * @method self|Observation observation(\Closure|null $callback = null)
 * @method self|Occupation occupation(\Closure|null $callback = null)
 * @method self|OccupationalExperienceRequirements occupationalExperienceRequirements(\Closure|null $callback = null)
 * @method self|OccupationalTherapy occupationalTherapy(\Closure|null $callback = null)
 * @method self|OceanBodyOfWater oceanBodyOfWater(\Closure|null $callback = null)
 * @method self|Offer offer(\Closure|null $callback = null)
 * @method self|OfferCatalog offerCatalog(\Closure|null $callback = null)
 * @method self|OfferForLease offerForLease(\Closure|null $callback = null)
 * @method self|OfferForPurchase offerForPurchase(\Closure|null $callback = null)
 * @method self|OfferItemCondition offerItemCondition(\Closure|null $callback = null)
 * @method self|OfferShippingDetails offerShippingDetails(\Closure|null $callback = null)
 * @method self|OfficeEquipmentStore officeEquipmentStore(\Closure|null $callback = null)
 * @method self|OnDemandEvent onDemandEvent(\Closure|null $callback = null)
 * @method self|OnlineBusiness onlineBusiness(\Closure|null $callback = null)
 * @method self|OnlineStore onlineStore(\Closure|null $callback = null)
 * @method self|OpeningHoursSpecification openingHoursSpecification(\Closure|null $callback = null)
 * @method self|OpinionNewsArticle opinionNewsArticle(\Closure|null $callback = null)
 * @method self|Optician optician(\Closure|null $callback = null)
 * @method self|Order order(\Closure|null $callback = null)
 * @method self|OrderAction orderAction(\Closure|null $callback = null)
 * @method self|OrderItem orderItem(\Closure|null $callback = null)
 * @method self|OrderStatus orderStatus(\Closure|null $callback = null)
 * @method self|Organization organization(\Closure|null $callback = null)
 * @method self|OrganizationRole organizationRole(\Closure|null $callback = null)
 * @method self|OrganizeAction organizeAction(\Closure|null $callback = null)
 * @method self|OutletStore outletStore(\Closure|null $callback = null)
 * @method self|OwnershipInfo ownershipInfo(\Closure|null $callback = null)
 * @method self|PaintAction paintAction(\Closure|null $callback = null)
 * @method self|Painting painting(\Closure|null $callback = null)
 * @method self|PalliativeProcedure palliativeProcedure(\Closure|null $callback = null)
 * @method self|ParcelDelivery parcelDelivery(\Closure|null $callback = null)
 * @method self|ParentAudience parentAudience(\Closure|null $callback = null)
 * @method self|Park park(\Closure|null $callback = null)
 * @method self|ParkingFacility parkingFacility(\Closure|null $callback = null)
 * @method self|PathologyTest pathologyTest(\Closure|null $callback = null)
 * @method self|Patient patient(\Closure|null $callback = null)
 * @method self|PawnShop pawnShop(\Closure|null $callback = null)
 * @method self|PayAction payAction(\Closure|null $callback = null)
 * @method self|PaymentCard paymentCard(\Closure|null $callback = null)
 * @method self|PaymentChargeSpecification paymentChargeSpecification(\Closure|null $callback = null)
 * @method self|PaymentMethod paymentMethod(\Closure|null $callback = null)
 * @method self|PaymentService paymentService(\Closure|null $callback = null)
 * @method self|PaymentStatusType paymentStatusType(\Closure|null $callback = null)
 * @method self|PeopleAudience peopleAudience(\Closure|null $callback = null)
 * @method self|PerformAction performAction(\Closure|null $callback = null)
 * @method self|PerformanceRole performanceRole(\Closure|null $callback = null)
 * @method self|PerformingArtsTheater performingArtsTheater(\Closure|null $callback = null)
 * @method self|PerformingGroup performingGroup(\Closure|null $callback = null)
 * @method self|Periodical periodical(\Closure|null $callback = null)
 * @method self|Permit permit(\Closure|null $callback = null)
 * @method self|Person person(\Closure|null $callback = null)
 * @method self|PetStore petStore(\Closure|null $callback = null)
 * @method self|Pharmacy pharmacy(\Closure|null $callback = null)
 * @method self|Photograph photograph(\Closure|null $callback = null)
 * @method self|PhotographAction photographAction(\Closure|null $callback = null)
 * @method self|PhysicalActivity physicalActivity(\Closure|null $callback = null)
 * @method self|PhysicalActivityCategory physicalActivityCategory(\Closure|null $callback = null)
 * @method self|PhysicalExam physicalExam(\Closure|null $callback = null)
 * @method self|PhysicalTherapy physicalTherapy(\Closure|null $callback = null)
 * @method self|Physician physician(\Closure|null $callback = null)
 * @method self|PhysiciansOffice physiciansOffice(\Closure|null $callback = null)
 * @method self|Place place(\Closure|null $callback = null)
 * @method self|PlaceOfWorship placeOfWorship(\Closure|null $callback = null)
 * @method self|PlanAction planAction(\Closure|null $callback = null)
 * @method self|Play play(\Closure|null $callback = null)
 * @method self|PlayAction playAction(\Closure|null $callback = null)
 * @method self|PlayGameAction playGameAction(\Closure|null $callback = null)
 * @method self|Playground playground(\Closure|null $callback = null)
 * @method self|Plumber plumber(\Closure|null $callback = null)
 * @method self|PodcastEpisode podcastEpisode(\Closure|null $callback = null)
 * @method self|PodcastSeason podcastSeason(\Closure|null $callback = null)
 * @method self|PodcastSeries podcastSeries(\Closure|null $callback = null)
 * @method self|PoliceStation policeStation(\Closure|null $callback = null)
 * @method self|PoliticalParty politicalParty(\Closure|null $callback = null)
 * @method self|Pond pond(\Closure|null $callback = null)
 * @method self|PostOffice postOffice(\Closure|null $callback = null)
 * @method self|PostalAddress postalAddress(\Closure|null $callback = null)
 * @method self|PostalCodeRangeSpecification postalCodeRangeSpecification(\Closure|null $callback = null)
 * @method self|Poster poster(\Closure|null $callback = null)
 * @method self|PreOrderAction preOrderAction(\Closure|null $callback = null)
 * @method self|PrependAction prependAction(\Closure|null $callback = null)
 * @method self|Preschool preschool(\Closure|null $callback = null)
 * @method self|PresentationDigitalDocument presentationDigitalDocument(\Closure|null $callback = null)
 * @method self|PreventionIndication preventionIndication(\Closure|null $callback = null)
 * @method self|PriceComponentTypeEnumeration priceComponentTypeEnumeration(\Closure|null $callback = null)
 * @method self|PriceSpecification priceSpecification(\Closure|null $callback = null)
 * @method self|PriceTypeEnumeration priceTypeEnumeration(\Closure|null $callback = null)
 * @method self|Product product(\Closure|null $callback = null)
 * @method self|ProductCollection productCollection(\Closure|null $callback = null)
 * @method self|ProductGroup productGroup(\Closure|null $callback = null)
 * @method self|ProductModel productModel(\Closure|null $callback = null)
 * @method self|ProductReturnEnumeration productReturnEnumeration(\Closure|null $callback = null)
 * @method self|ProductReturnPolicy productReturnPolicy(\Closure|null $callback = null)
 * @method self|ProfessionalService professionalService(\Closure|null $callback = null)
 * @method self|ProfilePage profilePage(\Closure|null $callback = null)
 * @method self|ProgramMembership programMembership(\Closure|null $callback = null)
 * @method self|Project project(\Closure|null $callback = null)
 * @method self|PronounceableText pronounceableText(\Closure|null $callback = null)
 * @method self|Property property(\Closure|null $callback = null)
 * @method self|PropertyValue propertyValue(\Closure|null $callback = null)
 * @method self|PropertyValueSpecification propertyValueSpecification(\Closure|null $callback = null)
 * @method self|Protein protein(\Closure|null $callback = null)
 * @method self|PsychologicalTreatment psychologicalTreatment(\Closure|null $callback = null)
 * @method self|PublicSwimmingPool publicSwimmingPool(\Closure|null $callback = null)
 * @method self|PublicToilet publicToilet(\Closure|null $callback = null)
 * @method self|PublicationEvent publicationEvent(\Closure|null $callback = null)
 * @method self|PublicationIssue publicationIssue(\Closure|null $callback = null)
 * @method self|PublicationVolume publicationVolume(\Closure|null $callback = null)
 * @method self|QAPage qAPage(\Closure|null $callback = null)
 * @method self|QualitativeValue qualitativeValue(\Closure|null $callback = null)
 * @method self|QuantitativeValue quantitativeValue(\Closure|null $callback = null)
 * @method self|QuantitativeValueDistribution quantitativeValueDistribution(\Closure|null $callback = null)
 * @method self|Quantity quantity(\Closure|null $callback = null)
 * @method self|Question question(\Closure|null $callback = null)
 * @method self|Quiz quiz(\Closure|null $callback = null)
 * @method self|Quotation quotation(\Closure|null $callback = null)
 * @method self|QuoteAction quoteAction(\Closure|null $callback = null)
 * @method self|RVPark rVPark(\Closure|null $callback = null)
 * @method self|RadiationTherapy radiationTherapy(\Closure|null $callback = null)
 * @method self|RadioBroadcastService radioBroadcastService(\Closure|null $callback = null)
 * @method self|RadioChannel radioChannel(\Closure|null $callback = null)
 * @method self|RadioClip radioClip(\Closure|null $callback = null)
 * @method self|RadioEpisode radioEpisode(\Closure|null $callback = null)
 * @method self|RadioSeason radioSeason(\Closure|null $callback = null)
 * @method self|RadioSeries radioSeries(\Closure|null $callback = null)
 * @method self|RadioStation radioStation(\Closure|null $callback = null)
 * @method self|Rating rating(\Closure|null $callback = null)
 * @method self|ReactAction reactAction(\Closure|null $callback = null)
 * @method self|ReadAction readAction(\Closure|null $callback = null)
 * @method self|RealEstateAgent realEstateAgent(\Closure|null $callback = null)
 * @method self|RealEstateListing realEstateListing(\Closure|null $callback = null)
 * @method self|ReceiveAction receiveAction(\Closure|null $callback = null)
 * @method self|Recipe recipe(\Closure|null $callback = null)
 * @method self|Recommendation recommendation(\Closure|null $callback = null)
 * @method self|RecommendedDoseSchedule recommendedDoseSchedule(\Closure|null $callback = null)
 * @method self|RecyclingCenter recyclingCenter(\Closure|null $callback = null)
 * @method self|RefundTypeEnumeration refundTypeEnumeration(\Closure|null $callback = null)
 * @method self|RegisterAction registerAction(\Closure|null $callback = null)
 * @method self|RejectAction rejectAction(\Closure|null $callback = null)
 * @method self|RentAction rentAction(\Closure|null $callback = null)
 * @method self|RentalCarReservation rentalCarReservation(\Closure|null $callback = null)
 * @method self|RepaymentSpecification repaymentSpecification(\Closure|null $callback = null)
 * @method self|ReplaceAction replaceAction(\Closure|null $callback = null)
 * @method self|ReplyAction replyAction(\Closure|null $callback = null)
 * @method self|Report report(\Closure|null $callback = null)
 * @method self|ReportageNewsArticle reportageNewsArticle(\Closure|null $callback = null)
 * @method self|ReportedDoseSchedule reportedDoseSchedule(\Closure|null $callback = null)
 * @method self|ResearchOrganization researchOrganization(\Closure|null $callback = null)
 * @method self|ResearchProject researchProject(\Closure|null $callback = null)
 * @method self|Researcher researcher(\Closure|null $callback = null)
 * @method self|Reservation reservation(\Closure|null $callback = null)
 * @method self|ReservationPackage reservationPackage(\Closure|null $callback = null)
 * @method self|ReservationStatusType reservationStatusType(\Closure|null $callback = null)
 * @method self|ReserveAction reserveAction(\Closure|null $callback = null)
 * @method self|Reservoir reservoir(\Closure|null $callback = null)
 * @method self|Residence residence(\Closure|null $callback = null)
 * @method self|Resort resort(\Closure|null $callback = null)
 * @method self|Restaurant restaurant(\Closure|null $callback = null)
 * @method self|RestrictedDiet restrictedDiet(\Closure|null $callback = null)
 * @method self|ResumeAction resumeAction(\Closure|null $callback = null)
 * @method self|ReturnAction returnAction(\Closure|null $callback = null)
 * @method self|ReturnFeesEnumeration returnFeesEnumeration(\Closure|null $callback = null)
 * @method self|ReturnLabelSourceEnumeration returnLabelSourceEnumeration(\Closure|null $callback = null)
 * @method self|ReturnMethodEnumeration returnMethodEnumeration(\Closure|null $callback = null)
 * @method self|Review review(\Closure|null $callback = null)
 * @method self|ReviewAction reviewAction(\Closure|null $callback = null)
 * @method self|ReviewNewsArticle reviewNewsArticle(\Closure|null $callback = null)
 * @method self|RiverBodyOfWater riverBodyOfWater(\Closure|null $callback = null)
 * @method self|Role role(\Closure|null $callback = null)
 * @method self|RoofingContractor roofingContractor(\Closure|null $callback = null)
 * @method self|Room room(\Closure|null $callback = null)
 * @method self|RsvpAction rsvpAction(\Closure|null $callback = null)
 * @method self|RsvpResponseType rsvpResponseType(\Closure|null $callback = null)
 * @method self|SaleEvent saleEvent(\Closure|null $callback = null)
 * @method self|SatiricalArticle satiricalArticle(\Closure|null $callback = null)
 * @method self|Schedule schedule(\Closure|null $callback = null)
 * @method self|ScheduleAction scheduleAction(\Closure|null $callback = null)
 * @method self|ScholarlyArticle scholarlyArticle(\Closure|null $callback = null)
 * @method self|School school(\Closure|null $callback = null)
 * @method self|SchoolDistrict schoolDistrict(\Closure|null $callback = null)
 * @method self|ScreeningEvent screeningEvent(\Closure|null $callback = null)
 * @method self|Sculpture sculpture(\Closure|null $callback = null)
 * @method self|SeaBodyOfWater seaBodyOfWater(\Closure|null $callback = null)
 * @method self|SearchAction searchAction(\Closure|null $callback = null)
 * @method self|SearchRescueOrganization searchRescueOrganization(\Closure|null $callback = null)
 * @method self|SearchResultsPage searchResultsPage(\Closure|null $callback = null)
 * @method self|Season season(\Closure|null $callback = null)
 * @method self|Seat seat(\Closure|null $callback = null)
 * @method self|SeekToAction seekToAction(\Closure|null $callback = null)
 * @method self|SelfStorage selfStorage(\Closure|null $callback = null)
 * @method self|SellAction sellAction(\Closure|null $callback = null)
 * @method self|SendAction sendAction(\Closure|null $callback = null)
 * @method self|Series series(\Closure|null $callback = null)
 * @method self|Service service(\Closure|null $callback = null)
 * @method self|ServiceChannel serviceChannel(\Closure|null $callback = null)
 * @method self|ShareAction shareAction(\Closure|null $callback = null)
 * @method self|SheetMusic sheetMusic(\Closure|null $callback = null)
 * @method self|ShippingDeliveryTime shippingDeliveryTime(\Closure|null $callback = null)
 * @method self|ShippingRateSettings shippingRateSettings(\Closure|null $callback = null)
 * @method self|ShoeStore shoeStore(\Closure|null $callback = null)
 * @method self|ShoppingCenter shoppingCenter(\Closure|null $callback = null)
 * @method self|ShortStory shortStory(\Closure|null $callback = null)
 * @method self|SingleFamilyResidence singleFamilyResidence(\Closure|null $callback = null)
 * @method self|SiteNavigationElement siteNavigationElement(\Closure|null $callback = null)
 * @method self|SizeGroupEnumeration sizeGroupEnumeration(\Closure|null $callback = null)
 * @method self|SizeSpecification sizeSpecification(\Closure|null $callback = null)
 * @method self|SizeSystemEnumeration sizeSystemEnumeration(\Closure|null $callback = null)
 * @method self|SkiResort skiResort(\Closure|null $callback = null)
 * @method self|SocialEvent socialEvent(\Closure|null $callback = null)
 * @method self|SocialMediaPosting socialMediaPosting(\Closure|null $callback = null)
 * @method self|SoftwareApplication softwareApplication(\Closure|null $callback = null)
 * @method self|SoftwareSourceCode softwareSourceCode(\Closure|null $callback = null)
 * @method self|SolveMathAction solveMathAction(\Closure|null $callback = null)
 * @method self|SomeProducts someProducts(\Closure|null $callback = null)
 * @method self|SpeakableSpecification speakableSpecification(\Closure|null $callback = null)
 * @method self|SpecialAnnouncement specialAnnouncement(\Closure|null $callback = null)
 * @method self|Specialty specialty(\Closure|null $callback = null)
 * @method self|SportingGoodsStore sportingGoodsStore(\Closure|null $callback = null)
 * @method self|SportsActivityLocation sportsActivityLocation(\Closure|null $callback = null)
 * @method self|SportsClub sportsClub(\Closure|null $callback = null)
 * @method self|SportsEvent sportsEvent(\Closure|null $callback = null)
 * @method self|SportsOrganization sportsOrganization(\Closure|null $callback = null)
 * @method self|SportsTeam sportsTeam(\Closure|null $callback = null)
 * @method self|SpreadsheetDigitalDocument spreadsheetDigitalDocument(\Closure|null $callback = null)
 * @method self|StadiumOrArena stadiumOrArena(\Closure|null $callback = null)
 * @method self|State state(\Closure|null $callback = null)
 * @method self|Statement statement(\Closure|null $callback = null)
 * @method self|StatisticalPopulation statisticalPopulation(\Closure|null $callback = null)
 * @method self|StatisticalVariable statisticalVariable(\Closure|null $callback = null)
 * @method self|StatusEnumeration statusEnumeration(\Closure|null $callback = null)
 * @method self|SteeringPositionValue steeringPositionValue(\Closure|null $callback = null)
 * @method self|Store store(\Closure|null $callback = null)
 * @method self|StructuredValue structuredValue(\Closure|null $callback = null)
 * @method self|StupidType stupidType(\Closure|null $callback = null)
 * @method self|SubscribeAction subscribeAction(\Closure|null $callback = null)
 * @method self|Substance substance(\Closure|null $callback = null)
 * @method self|SubwayStation subwayStation(\Closure|null $callback = null)
 * @method self|Suite suite(\Closure|null $callback = null)
 * @method self|SuperficialAnatomy superficialAnatomy(\Closure|null $callback = null)
 * @method self|SurgicalProcedure surgicalProcedure(\Closure|null $callback = null)
 * @method self|SuspendAction suspendAction(\Closure|null $callback = null)
 * @method self|Syllabus syllabus(\Closure|null $callback = null)
 * @method self|Synagogue synagogue(\Closure|null $callback = null)
 * @method self|TVClip tVClip(\Closure|null $callback = null)
 * @method self|TVEpisode tVEpisode(\Closure|null $callback = null)
 * @method self|TVSeason tVSeason(\Closure|null $callback = null)
 * @method self|TVSeries tVSeries(\Closure|null $callback = null)
 * @method self|Table table(\Closure|null $callback = null)
 * @method self|TakeAction takeAction(\Closure|null $callback = null)
 * @method self|TattooParlor tattooParlor(\Closure|null $callback = null)
 * @method self|Taxi taxi(\Closure|null $callback = null)
 * @method self|TaxiReservation taxiReservation(\Closure|null $callback = null)
 * @method self|TaxiService taxiService(\Closure|null $callback = null)
 * @method self|TaxiStand taxiStand(\Closure|null $callback = null)
 * @method self|Taxon taxon(\Closure|null $callback = null)
 * @method self|TechArticle techArticle(\Closure|null $callback = null)
 * @method self|TelevisionChannel televisionChannel(\Closure|null $callback = null)
 * @method self|TelevisionStation televisionStation(\Closure|null $callback = null)
 * @method self|TennisComplex tennisComplex(\Closure|null $callback = null)
 * @method self|TextDigitalDocument textDigitalDocument(\Closure|null $callback = null)
 * @method self|TextObject textObject(\Closure|null $callback = null)
 * @method self|TheaterEvent theaterEvent(\Closure|null $callback = null)
 * @method self|TheaterGroup theaterGroup(\Closure|null $callback = null)
 * @method self|TherapeuticProcedure therapeuticProcedure(\Closure|null $callback = null)
 * @method self|Thesis thesis(\Closure|null $callback = null)
 * @method self|Thing thing(\Closure|null $callback = null)
 * @method self|Ticket ticket(\Closure|null $callback = null)
 * @method self|TieAction tieAction(\Closure|null $callback = null)
 * @method self|TipAction tipAction(\Closure|null $callback = null)
 * @method self|TireShop tireShop(\Closure|null $callback = null)
 * @method self|TouristAttraction touristAttraction(\Closure|null $callback = null)
 * @method self|TouristDestination touristDestination(\Closure|null $callback = null)
 * @method self|TouristInformationCenter touristInformationCenter(\Closure|null $callback = null)
 * @method self|TouristTrip touristTrip(\Closure|null $callback = null)
 * @method self|ToyStore toyStore(\Closure|null $callback = null)
 * @method self|TrackAction trackAction(\Closure|null $callback = null)
 * @method self|TradeAction tradeAction(\Closure|null $callback = null)
 * @method self|TrainReservation trainReservation(\Closure|null $callback = null)
 * @method self|TrainStation trainStation(\Closure|null $callback = null)
 * @method self|TrainTrip trainTrip(\Closure|null $callback = null)
 * @method self|TransferAction transferAction(\Closure|null $callback = null)
 * @method self|TravelAction travelAction(\Closure|null $callback = null)
 * @method self|TravelAgency travelAgency(\Closure|null $callback = null)
 * @method self|TreatmentIndication treatmentIndication(\Closure|null $callback = null)
 * @method self|Trip trip(\Closure|null $callback = null)
 * @method self|TypeAndQuantityNode typeAndQuantityNode(\Closure|null $callback = null)
 * @method self|UKNonprofitType uKNonprofitType(\Closure|null $callback = null)
 * @method self|USNonprofitType uSNonprofitType(\Closure|null $callback = null)
 * @method self|UnRegisterAction unRegisterAction(\Closure|null $callback = null)
 * @method self|UnitPriceSpecification unitPriceSpecification(\Closure|null $callback = null)
 * @method self|UpdateAction updateAction(\Closure|null $callback = null)
 * @method self|UseAction useAction(\Closure|null $callback = null)
 * @method self|UserBlocks userBlocks(\Closure|null $callback = null)
 * @method self|UserCheckins userCheckins(\Closure|null $callback = null)
 * @method self|UserComments userComments(\Closure|null $callback = null)
 * @method self|UserDownloads userDownloads(\Closure|null $callback = null)
 * @method self|UserInteraction userInteraction(\Closure|null $callback = null)
 * @method self|UserLikes userLikes(\Closure|null $callback = null)
 * @method self|UserPageVisits userPageVisits(\Closure|null $callback = null)
 * @method self|UserPlays userPlays(\Closure|null $callback = null)
 * @method self|UserPlusOnes userPlusOnes(\Closure|null $callback = null)
 * @method self|UserReview userReview(\Closure|null $callback = null)
 * @method self|UserTweets userTweets(\Closure|null $callback = null)
 * @method self|VacationRental vacationRental(\Closure|null $callback = null)
 * @method self|Vehicle vehicle(\Closure|null $callback = null)
 * @method self|Vein vein(\Closure|null $callback = null)
 * @method self|Vessel vessel(\Closure|null $callback = null)
 * @method self|VeterinaryCare veterinaryCare(\Closure|null $callback = null)
 * @method self|VideoGallery videoGallery(\Closure|null $callback = null)
 * @method self|VideoGame videoGame(\Closure|null $callback = null)
 * @method self|VideoGameClip videoGameClip(\Closure|null $callback = null)
 * @method self|VideoGameSeries videoGameSeries(\Closure|null $callback = null)
 * @method self|VideoObject videoObject(\Closure|null $callback = null)
 * @method self|VideoObjectSnapshot videoObjectSnapshot(\Closure|null $callback = null)
 * @method self|ViewAction viewAction(\Closure|null $callback = null)
 * @method self|VirtualLocation virtualLocation(\Closure|null $callback = null)
 * @method self|VisualArtsEvent visualArtsEvent(\Closure|null $callback = null)
 * @method self|VisualArtwork visualArtwork(\Closure|null $callback = null)
 * @method self|VitalSign vitalSign(\Closure|null $callback = null)
 * @method self|Volcano volcano(\Closure|null $callback = null)
 * @method self|VoteAction voteAction(\Closure|null $callback = null)
 * @method self|WPAdBlock wPAdBlock(\Closure|null $callback = null)
 * @method self|WPFooter wPFooter(\Closure|null $callback = null)
 * @method self|WPHeader wPHeader(\Closure|null $callback = null)
 * @method self|WPSideBar wPSideBar(\Closure|null $callback = null)
 * @method self|WantAction wantAction(\Closure|null $callback = null)
 * @method self|WarrantyPromise warrantyPromise(\Closure|null $callback = null)
 * @method self|WarrantyScope warrantyScope(\Closure|null $callback = null)
 * @method self|WatchAction watchAction(\Closure|null $callback = null)
 * @method self|Waterfall waterfall(\Closure|null $callback = null)
 * @method self|WearAction wearAction(\Closure|null $callback = null)
 * @method self|WearableMeasurementTypeEnumeration wearableMeasurementTypeEnumeration(\Closure|null $callback = null)
 * @method self|WearableSizeGroupEnumeration wearableSizeGroupEnumeration(\Closure|null $callback = null)
 * @method self|WearableSizeSystemEnumeration wearableSizeSystemEnumeration(\Closure|null $callback = null)
 * @method self|WebAPI webAPI(\Closure|null $callback = null)
 * @method self|WebApplication webApplication(\Closure|null $callback = null)
 * @method self|WebContent webContent(\Closure|null $callback = null)
 * @method self|WebPage webPage(\Closure|null $callback = null)
 * @method self|WebPageElement webPageElement(\Closure|null $callback = null)
 * @method self|WebSite webSite(\Closure|null $callback = null)
 * @method self|WholesaleStore wholesaleStore(\Closure|null $callback = null)
 * @method self|WinAction winAction(\Closure|null $callback = null)
 * @method self|Winery winery(\Closure|null $callback = null)
 * @method self|WorkBasedProgram workBasedProgram(\Closure|null $callback = null)
 * @method self|WorkersUnion workersUnion(\Closure|null $callback = null)
 * @method self|WriteAction writeAction(\Closure|null $callback = null)
 * @method self|XPathType xPathType(\Closure|null $callback = null)
 * @method self|Zoo zoo(\Closure|null $callback = null)
 */
class MultiTypedEntity implements Type, JsonSerializable
{
    /** @var Type[] */
    protected $nodes = [];

    /** @var string */
    protected $nonce = '';

    /**
     * This overloads all \Spatie\SchemaOrg\Schema construction methods.
     * You can call them the same like on the \Spatie\SchemaOrg\Schema class.
     * But you can also use the extended signatures.
     *
     * MultiTypedEntity::organisation(): Organisation
     * MultiTypedEntity::organisation(function(Organisation $organisation, MultiTypedEntity $mte) {}): MultiTypedEntity
     *
     * @see \Spatie\SchemaOrg\Schema
     *
     * @param string $method
     * @param array $arguments
     *
     * @return $this|Type
     *
     * @throws \ReflectionException
     * @throws \BadMethodCallException
     */
    public function __call(string $method, array $arguments)
    {
        if (is_callable([Schema::class, $method])) {
            $type = (new ReflectionClass(Schema::class))->getMethod($method)->getReturnType();

            if (! $type instanceof ReflectionNamedType) {
                throw new BadMethodCallException(sprintf('The method "%s" has an invalid return type which does not resolve to "%s".', $method, ReflectionNamedType::class));
            }

            $schema = $this->getOrCreate($type->getName());

            if (isset($arguments[0]) && is_callable($arguments[0])) {
                call_user_func($arguments[0], $schema, $this);

                return $this;
            }

            return $schema;
        }

        throw new BadMethodCallException(sprintf('The method "%s" does not exist on class "%s".', $method, get_class($this)));
    }

    public function if(bool $condition, Closure $callback)
    {
        if ($condition) {
            $callback($this);
        }

        return $this;
    }

    public function add(Type $schema): self
    {
        $type = get_class($schema);

        if ($this->has($type)) {
            throw new TypeAlreadyInMultiTypedEntity(sprintf('The multi typed entity already has an item of type "%s".', $type));
        }

        return $this->set($schema);
    }

    public function has(string $type): bool
    {
        return array_key_exists($type, $this->nodes);
    }

    public function set(Type $schema)
    {
        $this->nodes[get_class($schema)] = $schema;

        return $this;
    }

    public function setNonce(string $nonce)
    {
        $this->nonce = $nonce;

        return $this;
    }

    public function get(string $type): Type
    {
        if (! $this->has($type)) {
            throw new TypeNotInMultiTypedEntity(sprintf('The multi typed entity does not have an item of type "%s".', $type));
        }

        return $this->nodes[$type];
    }

    public function getOrCreate(string $type): Type
    {
        if (! is_subclass_of($type, Type::class)) {
            throw new InvalidType(sprintf('The given type "%s" is not an instance of "%s".', $type, Type::class));
        }

        if (! $this->has($type)) {
            $this->set(new $type());
        }

        return $this->get($type);
    }

    public function toArray(): array
    {
        $properties = [];
        $types = [];

        foreach($this->nodes as $node) {
            $temp = $this->serializeNode($node);

            if(isset($temp['@type'])) {
                array_push($types, $temp['@type']);
                unset($temp['@type']);
            }

            $properties = array_merge($properties, $temp);
        }

        return [
            '@context' => $this->getContext(),
            '@type' => array_unique($types),
        ] + $properties;
    }

    protected function serializeNode($node)
    {
        if (is_array($node)) {
            return array_map([$this, 'serializeNode'], array_values($node));
        }

        if ($node instanceof Type) {
            $node = $node->toArray();
            unset($node['@context']);
        }

        return $node;
    }

    public function getNodes(): array
    {
        return $this->nodes;
    }

    public function getContext(): string
    {
        return 'https://schema.org';
    }

    public function nonceAttr(): string
    {
        if ($this->nonce) {
            $attr = ' nonce="'.$this->nonce.'"';
        } else {
            $attr = '';
        }

        return $attr;
    }

    public function toScript(): string
    {
        return '<script type="application/ld+json"'.$this->nonceAttr().'>'.json_encode($this, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES).'</script>';
    }

    public function jsonSerialize(): mixed
    {
        return $this->toArray();
    }

    public function __toString(): string
    {
        return $this->toScript();
    }
}
