<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'install', language 'pt', version '5.0'.
 *
 * @package     install
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['admindirerror'] = 'A pasta de administração especificada não está correta';
$string['admindirname'] = 'Pasta de administração';
$string['admindirsetting'] = 'Alguns servidores Web utilizam a pasta <strong>admin</strong> em URLs especiais de acesso a funcionalidades especiais, como é o caso de painéis de controlo. Algumas situações podem criar conflitos com a localização normal das páginas de administração do Moodle. Estes problemas podem ser resolvidos renomeando a pasta <strong>admin</strong> na instalação do Moodle e indicando aqui o novo nome a utilizar. Exemplo:<br /><br /><b>moodleadmin</b><br /><br />Esta ação resolverá os problemas de acesso das hiperligações para as funcionalidades de administração do Moodle.';
$string['admindirsettinghead'] = 'A configurar a pasta de administração...';
$string['admindirsettingsub'] = 'Alguns servidores Web utilizam a pasta <strong>admin</strong> em URLs especiais de acesso a funcionalidades especiais, como é o caso de painéis de controlo. Algumas situações podem criar conflitos com a localização normal das páginas de administração do Moodle. Estes problemas podem ser resolvidos renomeando a pasta <strong>admin</strong> na instalação do Moodle e indicando aqui o novo nome a utilizar. Exemplo:<br /><br /><b>moodleadmin</b><br /><br />Esta ação resolverá os problemas de acesso das hiperligações para as funcionalidades de administração do Moodle.';
$string['availablelangs'] = 'Pacotes linguísticos disponíveis';
$string['caution'] = 'Atenção';
$string['chooselanguage'] = 'Selecione um idioma';
$string['chooselanguagehead'] = 'Selecione um idioma';
$string['chooselanguagesub'] = 'Selecione o idioma a utilizar durante a instalação. O idioma escolhido será definido como o predefinido, mas poderá depois selecionar outro(s) idioma(s) para o site e para os utilizadores.';
$string['cliadminemail'] = 'Novo endereço de e-mail do utilizador administrador';
$string['cliadminpassword'] = 'Nova senha do administrador';
$string['cliadminusername'] = 'Nome de utilizador do administrador';
$string['clialreadyconfigured'] = 'O ficheiro config.php já existe. Use \'admin/cli/install_database.php\' para instalar o Moodle para este site.';
$string['clialreadyinstalled'] = 'O ficheiro config.php já existe, use admin/cli/install_database.php para atualizar o Moodle para este site.';
$string['cliinstallfinished'] = 'A instalação foi concluída com sucesso.';
$string['cliinstallheader'] = 'Programa para instalação do Moodle <b>{$a}</b> através da linha de comandos';
$string['climustagreelicense'] = 'No modo não interativo terá que aceitar a licença proposta indicando a opção <b>--agree-license</b>';
$string['cliskipdatabase'] = 'A ignorar a instalação da base de dados.';
$string['clisupportemail'] = 'Endereço de e-mail do suporte';
$string['clitablesexist'] = 'A instalação através da linha de comandos (CLI) não pode continuar porque a base de dados já contém as tabelas a criar.';
$string['compatibilitysettings'] = 'A verificar a configuração do PHP...';
$string['compatibilitysettingshead'] = 'A verificar a configuração do PHP...';
$string['compatibilitysettingssub'] = 'O servidor deve passar todos os testes com sucesso para que o Moodle possa funcionar corretamente';
$string['configfilenotwritten'] = 'O script de instalação não conseguiu criar o ficheiro <b>config.php</b> de forma automática, provavelmente por não ter permissão de escrita na pasta do Moodle. Para resolver este problema, pode copiar o código que se segue, manualmente, para o ficheiro <b>config.php</b> situado na raíz da pasta Moodle.';
$string['configfilewritten'] = 'o ficheiro <b>config.php</b> foi criado com sucesso';
$string['configurationcomplete'] = 'A configuração foi concluída com sucesso';
$string['configurationcompletehead'] = 'A configuração foi concluída com sucesso';
$string['configurationcompletesub'] = 'O Moodle tentou guardar a configuração indicada num ficheiro situado na raiz da pasta do Moodle.';
$string['database'] = 'Base de dados';
$string['databasehead'] = 'Configurações da base de dados';
$string['databasehost'] = 'Servidor da base de dados';
$string['databasename'] = 'Nome da base de dados';
$string['databasepass'] = 'Senha da base de dados';
$string['databaseport'] = 'Porta da base de dados';
$string['databasesocket'] = 'Socket Unix';
$string['databasetypehead'] = 'Escolha o <i>driver</i> da base de dados';
$string['databasetypesub'] = 'O Moodle permite a utilização de vários tipos de base de dados. Contacte o administrador do servidor caso não haja informação disponível sobre este assunto.';
$string['databaseuser'] = 'Utilizador da base de dados';
$string['dataroot'] = 'Pasta dos dados';
$string['datarooterror'] = 'Não foi possível encontrar ou criar a pasta dos dados que indicada. Corrija o caminho indicado ou crie a pasta manualmente.';
$string['datarootpermission'] = 'Permissões da pasta dos dados';
$string['datarootpublicerror'] = 'A pasta dos dados que especificou está acessível diretamente através da Internet. Por questões de segurança deve utilizar uma pasta diferente.';
$string['dbconnectionerror'] = 'Não foi possível estabelecer a ligação à base de dados indicada. Verifique a configuração da base de dados.';
$string['dbcreationerror'] = 'Erro na criação da base de dados. Não foi possível criar a base de dados com as configurações indicadas.';
$string['dbhost'] = 'Servidor do alojamento';
$string['dbpass'] = 'Senha';
$string['dbport'] = 'Porta';
$string['dbprefix'] = 'Prefixo das tabelas';
$string['dbtype'] = 'Tipo';
$string['directorysettings'] = '<p>Confirme as localizações para esta instalação do Moodle.</p>
<p><b>Endereço Web:</b>
Indique o endereço web completo de acesso ao Moodle. Caso o site possa ser acedido através de vários URL, selecione o mais frequentemente utilizado pelos alunos. Não inclua a barra "/" no fim do URL.</p>
<p><b>Pasta do Moodle:</b>
Indique o caminho completo para a pasta desta instalação. Assegure-se de que as maiúsculas e minúsculas estão corretas.</p>
<p><b>Pasta dos dados:</b>
Indique a pasta onde serão guardados os ficheiros enviados para o Moodle. O utilizador do Moodle no servidor web (normalmente <b>nobody</b> ou <b>apache</b>) deve ter permissão de <b>leitura</b> e <b>escrita</b> nessa pasta, mas esta não deve estar diretamente acessível através da Internet. Se não existir, será tentada a criação da pasta.</p>';
$string['directorysettingshead'] = 'Confirme as localizações para esta instalação do Moodle';
$string['directorysettingssub'] = '<p>Confirme as localizações para esta instalação do Moodle.</p><p><b>Endereço Web:</b> Indique o endereço web completo de acesso ao Moodle. Caso o site possa ser acedido através de vários URL, selecione o mais frequentemente utilizado pelos alunos. Não inclua a barra "/" no fim do URL.</p><p><b>Pasta do Moodle:</b> Indique o caminho completo para a pasta desta instalação. Assegure-se de que as maiúsculas e minúsculas estão corretas.</p><p><b>Pasta dos dados:</b> Indique a pasta onde serão guardados os ficheiros enviados para o Moodle. O utilizador do Moodle no servidor web (normalmente <b>nobody</b> ou <b>apache</b>) deve ter permissão de <b>leitura</b> e <b>escrita</b> nessa pasta, mas esta não deve estar diretamente acessível através da Internet.</p>';
$string['dirroot'] = 'Pasta do Moodle';
$string['dirrooterror'] = 'O valor do campo <b>pasta do Moodle</b> não parece ser válido porque não foram encontrados os ficheiros de instalação do Moodle. Foi reposto o valor original indicado em baixo.';
$string['download'] = 'Descarregar';
$string['downloadlanguagebutton'] = 'Descarregar pacote linguístico <b>{$a}</b>;';
$string['downloadlanguagehead'] = 'Instalar pacote linguístico';
$string['downloadlanguagenotneeded'] = 'Pode continuar o processo de instalação usando o pacote linguístico original ({$a}).';
$string['downloadlanguagesub'] = 'Nesta fase pode escolher o idioma a utilizar durante a instalação. <br /><br />Se não for possível obter o pacote linguístico indicado o processo de instalação decorrerá no idioma original do Moodle (inglês).<br /><br />Após a conclusão da instalação é possível proceder à instalação de pacotes linguísticos adicionais.';
$string['doyouagree'] = 'Concorda? (sim/não):';
$string['environmenthead'] = 'A verificar sistema...';
$string['environmentsub'] = 'Estamos a verificar se os vários componentes do seu sistema respeitam os requisitos do sistema';
$string['environmentsub2'] = 'Cada nova versão do Moodle tem pré-requisitos mínimos relativamente à versão do PHP e extensões necessárias para o seu correto funcionamento. Estes pré-requisitos são verificados sempre que o Moodle é instalado ou atualizado. Contacte o administrador do servidor caso seja necessário atualizar a versão do PHP ou instalar novas extensões.';
$string['errorsinenvironment'] = 'A verificação do sistema falhou!';
$string['fail'] = 'Falha';
$string['fileuploads'] = 'Envio de ficheiros';
$string['fileuploadserror'] = 'Esta opção deve estar ativa';
$string['fileuploadshelp'] = '<p>Aparentemente a possibilidade de enviar ficheiros está desativada ao nível do servidor.</p><p>Neste caso, o Moodle poderá ser instalado, mas, sem essa funcionalidade, não será possível, por exemplo, os utilizadores submeterem ficheiros nas disciplinas ou definir uma foto para o seu perfil.</p><p>Para ativar o envio de ficheiros é necessário alterar a configuração do PHP (ficheiro php.ini), definindo o valor do parâmetro <b>file_upload</b> para "1".</p>';
$string['inputdatadirectory'] = 'Pasta dos dados:';
$string['inputwebadress'] = 'Endereço web:';
$string['inputwebdirectory'] = 'Pasta do Moodle:';
$string['installation'] = 'Instalação';
$string['invaliddbprefix'] = 'Prefixo inválido. O prefixo pode ser apenas letras minúsculas e underscore.';
$string['langdownloaderror'] = 'Não foi possível descarregar o idioma \'<b>{$a}</b>\' . O processo de instalação continuará em Inglês.';
$string['langdownloadok'] = 'O idioma \'<b>{$a}</b>\' foi instalado com sucesso. O processo de instalação continuará neste idioma.';
$string['memorylimit'] = 'Limite de memória';
$string['memorylimiterror'] = 'O limite de memória definido na configuração do PHP é muito baixo... poderá originar problemas mais tarde.';
$string['mysqliextensionisnotpresentinphp'] = 'O PHP não foi corretamente configurado com a extensão MySQLi para que possa comunicar com MySQL. Verifique o ficheiro php.ini ou recompile o PHP.';
$string['nativeauroramysql'] = 'Aurora MySQL (native/auroramysql)';
$string['nativeauroramysqlhelp'] = '<p>A base de dados é onde a maioria das configurações e dos dados do Moodle são armazenados e têm de ser configurados aqui.</p>
<p>O nome da base de dados, o nome de utilizador e a senha são campos obrigatórios. O prefixo das tabelas é opcional.</p>
<p>O nome da base de dados pode conter apenas caracteres alfanuméricos, o símbolo de dólar ($) e underscore (_).</p>
<p>Se a base de dados ainda não existir, e o utilizador que especificar tiver permissão para tal, o Moodle tentará criar uma nova base de dados com as permissões e configurações corretas.</p>
<p>Este driver não é compatível com o mecanismo legado MyISAM.</p>';
$string['nativemariadb'] = 'MariaDB (native/mariadb)';
$string['nativemariadbhelp'] = '<p>A base de dados é onde a maioria das configurações e dos dados do Moodle são armazenados e deverá ser configurada aqui.</p>
<p>O nome da base de dados, o nome de utilizador e a senha são campos obrigatórios. O prefixo da tabela é opcional.</p>
<p>O nome da base de dados apenas pode conter caracteres alfanuméricos, o símbolo do dólar ($) e underscore (_).</p>
<p>Se a base de dados ainda não existir, e se o utilizador que especificar tiver permissão para tal, o Moodle tentará criar uma nova base de dados com as permissões e configurações corretas.</p>
<p>Este driver não é compatível com o mecanismo legado MyISAM.</p>';
$string['nativemysqli'] = '	
Improved MySQL (native/mysqli)';
$string['nativemysqlihelp'] = '<p>A base de dados é onde a maioria das configurações e dados do Moodle são armazenados e devem ser configurados aqui.</p>
<p>O nome da base de dados, o nome de utilizador e a senha são campos obrigatórios. O prefixo da tabela é opcional.</p>
<p>O nome da base de dados apenas pode conter caracteres alfanuméricos, o símbolo do dólar ($) e underscore (_).</p>
<p>Se a base de dados não existir, e o utilizador que especificar tiver permissão, o Moodle tentará criar uma nova base de dados com as permissões e configurações corretas.</p>';
$string['nativepgsql'] = 'PostgreSQL (native/pgsql)';
$string['nativepgsqlhelp'] = '<p>A base de dados é onde a maioria das configurações e dados do Moodle são armazenados e devem ser configurados aqui.</p>
<p>O nome da base de dados, o nome de utilizador, a senha e o prefixo da tabela são campos obrigatórios.</p>
<p>A base de dados tem de estar criada e o utilizador tem de ter acesso tanto para ler como para escrever nela.</p>';
$string['nativesqlsrv'] = 'SQL*Server Microsoft (native/sqlsrv)';
$string['nativesqlsrvhelp'] = 'Deverá agora configurar a base de dados onde será guardada a maior parte da informação do Moodle. Esta base de dados deverá ter sido criada previamente, assim como uma conta de acesso à mesma. A definição de um prefixo para os nomes das tabelas é obrigatório.';
$string['nativesqlsrvnodriver'] = 'Os Drivers Microsoft para servidores SQL para PHP não estão instalados ou configurados corretamente.';
$string['pass'] = 'Instalação realizada com sucesso!';
$string['paths'] = 'Caminhos';
$string['pathserrcreatedataroot'] = 'O programa de instalação não conseguiu criar a pasta dos dados <b>{$a->dataroot}</b>.';
$string['pathshead'] = 'Confirmar caminhos';
$string['pathsrodataroot'] = 'A pasta dos dados é só de leitura (não permite escrita).';
$string['pathsroparentdataroot'] = 'A pasta ascendente <b>{$a->parent}</b> não tem permissões de escrita. O programa de instalação não conseguiu criar a pasta <b>{$a->dataroot}</b>.';
$string['pathssubadmindir'] = 'Alguns servidores Web utilizam a pasta <strong>admin</strong> em URLs especiais de acesso a funcionalidades especiais, como é o caso de painéis de controlo. Algumas situações podem criar conflitos com a localização normal das páginas de administração do Moodle. Estes problemas podem ser resolvidos renomeando a pasta <strong>admin</strong> na instalação do Moodle e indicando aqui o novo nome a utilizar. Exemplo:<br /><br /><b>moodleadmin</b><br /><br />Esta ação resolverá os problemas de acesso das hiperligações para as funcionalidades de administração do Moodle.';
$string['pathssubdataroot'] = '<p>Pasta onde o Moodle irá armazenar todo o conteúdo dos ficheiros enviados pelos utilizadores.</p>
<p>O utilizador do Moodle no servidor web (normalmente <b>nobody</b>, <b>apache</b> ou <b>www-data</b>) deve ter permissão de <b>leitura</b> e de <b>escrita</b> nessa pasta.
<p>Não pode ser acessível diretamente através da web.</p>
<p>Se a pasta não existir, o processo de instalação tentará criá-la.</p>';
$string['pathssubdirroot'] = 'Caminho completo para a pasta que contém o código Moodle.';
$string['pathssubwwwroot'] = 'Endereço web completo de acesso ao Moodle. Não é possível aceder ao Moodle usando mais do que um endereço. Se o site tiver mais do que um endereço público, devem ser configurados redirecionamentos permanentes em todos eles, à exceção deste. Se o site pode ser acedido a partir da Internet e de Intranet, use o endereço público aqui. Se o endereço atual não está correto, altere o endereço indicado na barra de endereço do seu navegador e reinicie a instalação.';
$string['pathsunsecuredataroot'] = 'A localização da pasta dos dados não é segura.';
$string['pathswrongadmindir'] = 'A pasta <b>admin</b> não existe';
$string['pgsqlextensionisnotpresentinphp'] = 'O PHP não foi corretamente configurado com a extensão PGSQL (de forma a permitir a comunicação com servidor PostgreSQL). Verifique o ficheiro de configuração ou recompile o PHP.';
$string['phpextension'] = 'Extensão <b>{$a}</b> do PHP';
$string['phpversion'] = 'Versão do PHP';
$string['releasenoteslink'] = 'Para obter mais informações sobre esta versão do Moodle consulte as notas de lançamento na página {$a}';
$string['safemode'] = '<i>Safe mode</i>';
$string['safemodeerror'] = 'O Moodle poderá ter problemas de funcionamento se a configuração do PHP estiver em <i>Safe mode</i>';
$string['safemodehelp'] = '<p>O Moodle pode ter vários problemas quando executado com <b>Safe mode</b> ativo.</p><p>É possível continuar a instalação com esta configuração, mas poderá originar problemas no futuro, por exemplo, a impossibilidade de criar novos ficheiros.</p>';
$string['sessionautostart'] = 'Início automático de sessão';
$string['sessionautostarterror'] = 'Esta configuração não deve estar ativa';
$string['sessionautostarthelp'] = '<p>Para o correto funcionamento do Moodle é necessário que a funcionalidade de sessões do PHP esteja ativa.</p><p>Esta ativação é definida no ficheiro de configuração do PHP através do parâmetro <b>session.auto_start</b>.</p>';
$string['sqliteextensionisnotpresentinphp'] = 'O PHP não foi corretamente configurado com a extensão SQLite. Verifique o ficheiro de configuração ou recompile o PHP.';
$string['upgradingqtypeplugin'] = 'A atualizar o módulo <b>question/type</b>';
$string['welcomep10'] = '{$a->installername} ({$a->installerversion})';
$string['welcomep20'] = 'A apresentação desta página confirma a correta instalação e ativação do pacote <strong>{$a->packname} {$a->packversion}</strong> no servidor.';
$string['welcomep30'] = 'Esta versão do pacote <strong>{$a->installername}</strong> inclui as aplicações necessárias para o correto funcionamento do  <strong>Moodle</strong>, nomeadamente:';
$string['welcomep40'] = 'Este pacote inclui o lançamento <strong>{$a->moodlerelease} ({$a->moodleversion})</strong> do Moodle .';
$string['welcomep50'] = 'A utilização de todas as aplicações incluídas neste pacote é limitada pelas respetivas licenças. O pacote completo <strong>{$a->installername}</strong> é <ahref="https://www.opensource.org/docs/definition_plain.html">código aberto</a> e é distribuído nos termos da licença <a href="http://www.gnu.org/copyleft/gpl.html">GPL</a>.';
$string['welcomep60'] = 'As páginas seguintes irão acompanhá-lo através de algumas etapas simples para configurar e definir o <strong>Moodle</strong> no seu computador. Pode aceitar as configurações predefinidas ou, opcionalmente, alterá-las para adaptar às suas próprias necessidades.';
$string['welcomep70'] = 'Clique no botão \'Seguinte\' para continuar a configuração do <strong>Moodle</strong>.';
$string['wwwroot'] = 'Endereço web';
$string['wwwrooterror'] = 'O valor do campo <b>Endereço web</b> não parece ser válido porque não foram encontrados os ficheiros de instalação do Moodle. Foi reposto o valor original indicado em baixo.';
