<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_exacomp', language 'es_mx', version '5.0'.
 *
 * @package     block_exacomp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['AND'] = 'Y';
$string['LA_FRI'] = 'VIE';
$string['LA_MON'] = 'LUN';
$string['LA_THU'] = 'JUE';
$string['LA_TUE'] = 'MAR';
$string['LA_WED'] = 'MIÉ';
$string['LA_assessment'] = 'evaluación';
$string['LA_backtoview'] = 'regresar a vista original';
$string['LA_enddate'] = 'fecha final';
$string['LA_from_m'] = 'de';
$string['LA_from_n'] = 'de';
$string['LA_learning'] = '¿Qué puedo aprender?';
$string['LA_no_example'] = 'no hay ejemplo disponible';
$string['LA_no_learningagenda'] = 'No hay agenda de aprendizaje disponible para esta semana.';
$string['LA_no_student_selected'] = '-- sin estudiante seleccionado --';
$string['LA_plan'] = 'plan de trabajo';
$string['LA_select_student'] = 'Por favor seleccione un estudiante para ver su agenda de aprendizaje.';
$string['LA_startdate'] = 'fecha de inicio';
$string['LA_student'] = 'Est';
$string['LA_teacher'] = 'Prof';
$string['LA_to'] = 'hasta';
$string['LA_todo'] = '¿Qué hago yo?';
$string['OR'] = 'O';
$string['access_roles'] = 'Roles con acceso a webservice';
$string['active_show'] = 'activos (mostrarlos)';
$string['add_competence_insert_learning_progress'] = 'Para insertar una nueva competencia primeramente debe seleccionar o añadir unnivel de dificultad';
$string['add_content_to_crosssub'] = 'El Asunto interdisciplinario todavía está vacío';
$string['add_crosssub'] = 'Crear Asunto interdisciplinario';
$string['add_descriptors_to_crosssub'] = 'Añadir competencia a Asunto interdisciplinario';
$string['add_drafts_to_course'] = 'Añadir borradores al curso';
$string['add_example_for_all_students_to_schedule'] = 'Atención: Aquí Usted puede añadir ejemplos de las agendas de todos los estudiantes. Esto requiere confirmación extra.';
$string['add_example_for_all_students_to_schedule_confirmation'] = 'Usted está a punto de añadir  los ejemplos a las agendas de todos los estudiantes. ¿Quiere continuar?';
$string['add_example_for_group_to_schedule'] = 'Atención: Aquí puede añadir ejemplos a las agendas de todos los estudiantes del grupo seleccionado. Esto requiere confirmación adicional.';
$string['add_example_for_group_to_schedule_confirmation'] = 'Que tal si añade los ejemplos a las agendas de todos los estudiantes de este grupo. ¿desea continuar?';
$string['add_new_importtask'] = 'Añadir un nuevo trabajo de importación';
$string['add_new_taxonomie'] = 'Añadir un nuevo nivel de dificultad';
$string['add_niveau'] = 'Añadir nivel';
$string['admin_config_pending'] = 'La pre-selección de rejillas de competencia necesita ser realizada por el administrador de Moodle';
$string['all_activities'] = 'Todas las actividades';
$string['all_modules'] = 'todas las actividades';
$string['all_students'] = 'todos los estudiantes';
$string['allniveaus'] = 'Todos los niveles de dificultad';
$string['allow_resubmission'] = 'Añadir un nuevo envío para este ejemplo';
$string['allow_resubmission_info'] = 'No está permitido re-enviar el ejemplo.';
$string['allstudents'] = 'Todos los estudiantes';
$string['also_taxonomies_from_import'] = 'También hay niveles de dificultad de la importación';
$string['apply_filter'] = 'aplicar filtro';
$string['assessment_SelfEval_useVerbose'] = 'opciones de retroalimentación verbosa para estudiantes';
$string['assessment_date'] = 'fecha de la evaluación';
$string['assign_dakora_teacher'] = 'asignar profesor para asuntos interdisciplinarios';
$string['assign_dakora_teacher_link'] = 'Clic aquí para asignar profesor para asuntos interdisciplinarios';
$string['assign_descriptor_no_crosssubjects_available'] = 'Ho hay Asuntos interdisciplinarios disponibles.';
$string['assign_descriptor_to_crosssubject'] = 'Asignar la competencia "{$a}" a los siguientes Asuntos-interdisciplinarios:';
$string['assigndone'] = 'tarea hecha:';
$string['assigned_example'] = 'Ejemplo Asignado';
$string['assignments'] = 'Tareas';
$string['associated_activities'] = 'Actividades Moodle Asociadas:';
$string['available_crosssubjects'] = 'Asuntos Interdisciplinarios no publicados';
$string['block_exacomp_assign_activities_old_method_body'] = 'Esta pestaña fue reemplazada de manera predeterminada por la pestaña "Relacionar actividades de Moodle"';
$string['block_exacomp_assign_activities_old_method_head'] = 'Mostrar pestaña "Asignar actividades de Moodle" antiguo';
$string['block_exacomp_dakora_language_file_body'] = 'Utilice el <a href="https://exabis.at/sprachgenerator" target="_blank">generador de idiomas</a> para crear un archivo de idioma personalizado';
$string['block_exacomp_dakora_language_file_head'] = 'Archivo de idioma personalizado para Dakora';
$string['block_exacomp_disable_create_grid_body'] = 'Los usuarios no podrán crear nuevas rejillas';
$string['block_exacomp_disable_create_grid_head'] = 'Deshabiltar creación de rejilla';
$string['block_exacomp_elove_student_self_assessment_body'] = '';
$string['block_exacomp_elove_student_self_assessment_head'] = 'Permitir auto-evaluación para estudiantes en la App Elove';
$string['block_exacomp_external_trainer'] = 'Entrenador';
$string['block_exacomp_external_trainer_allstudents'] = 'Todos los Estudiantes';
$string['block_exacomp_external_trainer_assign'] = 'Asignar entrenador externo';
$string['block_exacomp_external_trainer_assign_body'] = 'Esto es necesario para usar la App Elove.';
$string['block_exacomp_external_trainer_assign_head'] = 'Permitir asignación de entrenadores externos para estudiantes.';
$string['block_exacomp_external_trainer_student'] = 'Estudiante';
$string['block_exacomp_link_to_dakora_app'] = 'a Dakora-App';
$string['block_exacomp_logging_body'] = 'Las acciones relevantes se anotarán en bitácoras.';
$string['block_exacomp_logging_head'] = 'Activar bitácora';
$string['block_exacomp_notifications_body'] = 'Los usuarios serán notificados después de las acciones relevantes';
$string['block_exacomp_notifications_head'] = 'activar notificaciones';
$string['blocking_event'] = 'Crear evento bloqueador';
$string['blocking_event_create'] = 'Añadir al almacenamiento de planeación';
$string['blocking_event_title'] = 'título';
$string['blocktitle'] = 'Rejilla de competencia';
$string['cachedef_visibility_cache'] = 'Caché para mejorar desempeño mientras se revisan visibilidades';
$string['childcompetencies_compProfile'] = 'Competencias infantiles';
$string['choose_student'] = 'Elegir estudiantes:';
$string['choosecourse'] = 'Seleccionar curso:';
$string['choosecoursetemplate'] = 'Seleccionar curso para importar actividades de Moodle desde rejilla de competencias:';
$string['choosedaterange'] = 'Elija un rango de fecha:';
$string['choosestudent'] = 'Elegir estudiante';
$string['choosesubject'] = 'Elegir asunto:';
$string['choosetopic'] = 'Elegir tópico:';
$string['city'] = 'Ciudad';
$string['cleardaterange'] = 'Borrar rango';
$string['close'] = 'Cerrar';
$string['columnselect'] = 'Selección de columna';
$string['comp'] = 'Tópico';
$string['comp_-1'] = 'sin información';
$string['comp_-1_short'] = 'si';
$string['comp_0'] = 'no ganado';
$string['comp_0_short'] = 'ng';
$string['comp_1'] = 'parcialmente';
$string['comp_1_short'] = 'pg';
$string['comp_2'] = 'mayoritariamente';
$string['comp_2_short'] = 'mg';
$string['comp_3'] = 'completamente';
$string['comp_3_short'] = 'cg';
$string['comp_based'] = 'ordenar por competencias';
$string['comp_field_idea'] = 'Habilidad';
$string['competence_associations'] = 'Asociaciones';
$string['competence_associations_explaination'] = 'El material {$a} está asociado con los siguientes estándares:';
$string['competence_grid_additionalinfo'] = 'calificación';
$string['competence_grid_niveau'] = 'nivel de dificultad';
$string['competence_locked'] = 'Existe evaluación o material de aprendizaje es usado';
$string['competence_overview_student_short'] = 'E:';
$string['competence_overview_teacher_short'] = 'P:';
$string['competencegrid_nodata'] = 'En caso de que la rejilla de competencia esté vacía, los resultados para el asunto elegido no son asignados a un nivel en el archivo-de-datos. Esto puede componerse al asociar resultados con niveles en www.edustandards.org  y reimportar el archivo XML.';
$string['completed_config'] = 'La configuración de Rejilla de Competencias Exabis está finalizada.';
$string['completefile'] = 'Completar archivo';
$string['comps_and_material'] = 'resultados y ejercicios';
$string['conf_badges'] = 'configurar insignias';
$string['conf_comps'] = 'configurar competencias';
$string['confirm_delete'] = '¿Realmente desea eliminar este Asunto interdisciplinario?';
$string['contactcomps'] = 'Contraer todo';
$string['course_assessment_config_infotext'] = 'elegir un esquema de evaluación';
$string['course_assessment_settings'] = 'Evaluación del curso';
$string['course_assessment_use_global'] = 'Usar configuraciones de evaluación global';
$string['create_docx'] = 'generar DOCX';
$string['create_docx_report'] = 'generar docx';
$string['create_html'] = 'generar vista previa HTML';
$string['create_html_report'] = 'generar previsualización HTML';
$string['create_new_area'] = 'Área nueva';
$string['create_new_crosssub'] = 'Crear nuevo Asunto interdisciplinario';
$string['create_new_topic'] = 'Nuevo tema';
$string['create_pdf'] = 'generar PDF';
$string['create_pdf_report'] = 'generar PDF';
$string['create_report'] = 'generar reporte';
$string['cross_based'] = 'Para Temas Iterdisciplinarios';
$string['crosssubject'] = 'Asunto interdisciplinario';
$string['crosssubject_drafts'] = 'Borrador de Asunto interdisciplinario';
$string['crosssubject_files'] = 'archivos temascruzados';
$string['dakora_niveau_after_descriptor_title'] = 'Nivel';
$string['dakora_string1'] = 'frase en inglés1';
$string['dakora_string2'] = 'frase en inglés2';
$string['dakora_string3'] = 'frase en inglés3';
$string['dakora_teachers'] = 'ProfesoresDakora';
$string['data_imported_title'] = 'Importar datos inmediatamente';
$string['dataerr'] = '¡Se requiere al menos un filtro!';
$string['de:unittest_string2'] = 'resultados_unittest_frase2';
$string['de:unittest_string3'] = 'resultados_unittest_frase3';
$string['delete...'] = 'Eliminar...';
$string['delete_competency_that_has_children_with_gradings'] = '¡Los hijos de esta competencia ya tienen calificaciones! ¡Elimínelas solo si está seguro!';
$string['delete_competency_that_has_gradings'] = '¡Esta competencia ya tiene calificaciones!¡Elimínela solo si está seguro!';
$string['delete_competency_that_is_used_in_course'] = '¡Atención! Esta rejilla se utiliza en los siguientes cursos:';
$string['delete_confirmation'] = '¿Realmente quiere eliminar "{$a}"?';
$string['delete_confirmation_descr'] = '¿Realmente desea eliminar la competencia "{$a}"?';
$string['delete_crosssub'] = 'Eliminar Asunto interdisciplinario';
$string['delete_drafts'] = 'Eliminar borradores seleccionados';
$string['delete_ics_imports_confirmation'] = 'Estás a punto de eliminar tus tareas importadas para esta programación semanal, ¿deseas continuar?';
$string['delete_imports'] = 'eliminar mis importaciones';
$string['delete_level_from_another_source'] = 'Contenido de otra fuente. Si los elimina aquí, también se eliminarán de la otra fuente. ¡Bórrelos solo si está seguro!';
$string['delete_level_has_children_from_another_source'] = '¡Tiene hijos de otra fuente! Si no elimina a los hijos primero y elimina este tema, también eliminará de la otra fuente.';
$string['delete_niveau'] = 'Eliminar nivel';
$string['delete_own'] = 'Eliminar resultados/estándares individuales';
$string['delete_own_confirm'] = '¿Está Usted seguro de querer eliminarlos  resultados/estándares individuales ?';
$string['delete_success'] = 'Los resultados/estándares individuales han sido eliminados';
$string['delete_unconnected_examples'] = 'Si Usted está des-seleccionando tópicos que están asociados con ejemplos usados en la agenda semanal, estos ejemplos serán removidos.';
$string['description'] = 'Descripción';
$string['description_createtoken'] = 'Otorgar permiso adicional al rol "usuario autenticado" en: Administración del sitio / Usuarios / Permisos / Definir roles
4.1 Seleccionar Usuario Autenticado
4.2 Hacer clic en "Editar"
4.3 Filtrar para createtoken
4.4 Permitir moodle/webservice:createtoken';
$string['description_edit_badge_comps'] = 'Aquí puede Usted asociar la insignia seleccionada con resultados.';
$string['description_example'] = 'Descripción';
$string['descriptor'] = 'competencia';
$string['descriptor_add_category'] = 'Añadir nuevo nivel de dificultad:';
$string['descriptor_categories'] = 'Editar nivel de dificultad:';
$string['descriptor_categories_description'] = 'Elegir el nivel de dificultad para esta (sub)competencia/material de aprendizaje. Usted también puede añadir un nuevo nivel de dificultad o elegir no seleccionar un nivel de dificultad.';
$string['descriptor_child'] = 'competencia hija';
$string['descriptor_description'] = 'Crear su primer descriptor:';
$string['descriptor_label'] = 'Titulo de competencia';
$string['descriptor_submission_info'] = 'Está a punto de agregar un trabajo al descriptor "{$a}". Su trabajo se guardará en Exabis ePortfolio y los profesores podrán verlo allí.';
$string['descriptors'] = 'Competencias';
$string['deselect_all'] = 'des-seleccionar todo';
$string['dest_course'] = 'Destino de actividades importadas';
$string['difficulty_group_report'] = 'nivel de dificultad';
$string['diggrapp_cannotcreatetoken'] = 'No puedo tener acceso a esta instalación de Moodle';
$string['dismiss_gradingisold'] = '¿Desea olvidar esta advertencia?';
$string['display_settings'] = 'mostrar configuraciones';
$string['distribute_weekly_schedule'] = 'Distribuir agenda semanal';
$string['do_demo_import'] = 'importar datos demostrativos para ver como funciona la rejilla de Competencia Exabis';
$string['doimport'] = 'Importar rejilla de competencia';
$string['doimport_again'] = 'Importar rejillas de competencia/resultados adicionales';
$string['doimport_own'] = 'Importar resultados/estándares individuales';
$string['donotleave_page_message'] = 'Tiene cambios sin guardar en esta página. ¿Quiere salir de esta página y descartar los cambios o permanecer en ella?';
$string['download_activites'] = 'Descargar actividades';
$string['editor'] = 'Editado por';
$string['edulevel_without_assignment_title'] = 'Sin una asignación específica';
$string['empty_pre_planning_confirm'] = 'Los ejemplos añadidos de todos los profesores son eliminados. ¿Esta seguro de querer hacer esto?';
$string['empty_pre_planning_storage'] = 'Vaciar almacenamiento de planeación';
$string['empty_trash'] = 'Vaciar cesto de basura';
$string['enable_rest'] = 'Protocolo REST no habilitado';
$string['enrol_users'] = 'Inscribir a los usuarios para poder usar exacomp.';
$string['eportitem_notshared'] = '(no compartido)';
$string['eportitem_shared'] = '(compartido)';
$string['eportitems'] = 'Artefactos ePortafolio enviados:';
$string['evaluationdate'] = 'Fecha de la Evaluación';
$string['eventscompetenceassigned'] = 'Competencia asignada';
$string['eventscrosssubjectadded'] = 'Asunto interdisciplinario añadido';
$string['eventsexampleadded'] = 'Ejemplo añadido a agenda semanal';
$string['eventsexamplecommented'] = 'Ejemplo comentado';
$string['eventsexamplegraded'] = 'Ejemplo calificado';
$string['eventsexamplesubmitted'] = 'Ejemplo enviado';
$string['eventsimportcompleted'] = 'Importación completada';
$string['exa_evaluation'] = 'material de aprendizaje';
$string['exacomp:addinstance'] = 'Añadir un bloque de Rejilla de Competencia Exabis al curso';
$string['exacomp:admin'] = 'vista general de acciones de administrador en un curso';
$string['exacomp:assignstudents'] = 'Asignar entrenadores externos';
$string['exacomp:deleteexamples'] = 'eliminar ejemplos';
$string['exacomp:editingteacher'] = 'Profesor editor';
$string['exacomp:myaddinstance'] = 'Añadir un bloque de Rejilla de Competencia Exabis a Mi Moodle';
$string['exacomp:student'] = 'vista general de acciones de estudiante en un curso';
$string['exacomp:teacher'] = 'vista general de acciones de profesor en un curso';
$string['exacomp:use'] = 'usar Rejilla de Competencia Exabis';
$string['exacomp_not_found'] = 'Exacompservice no encontrado';
$string['examp_based'] = 'ordenar por ejemplos';
$string['example'] = 'Ejemplo';
$string['example_add_taxonomy'] = 'Añadir nueva taxonomía';
$string['example_pool'] = 'Lote de ejemplos';
$string['example_pool_example_button'] = 'en el grupo de ejemplos para {$a->fullname}';
$string['example_pool_example_button_forall'] = 'en el grupo de ejemplo para todos los participantes del curso';
$string['example_sorting_notice'] = 'Pro favor primeramente guarde los cambios.';
$string['example_submission_header'] = 'Editar ejemplo {$a}';
$string['example_submission_info'] = 'Usted está a punto de editar el ejemplo "{$a}". Su envbío será guardado en Exabis ePortfolio y los profesores podrán verlo allí.';
$string['example_submission_message'] = 'El estudiante {$a->student} entregó un nuevo envío en {$a->course}.';
$string['example_submission_subject'] = 'Envío nuevo';
$string['example_trash'] = 'Cesto de basura';
$string['example_upload_header'] = 'Subir mi propio ejemplo/trabajo';
$string['exaport_not_found'] = 'Exaportservice no encontrado';
$string['existing_crosssub'] = 'asuntos cruzados esistentes en este curso';
$string['expandcomps'] = 'Expander todo';
$string['explainconfig'] = 'Sus resultados ya han sido importados. En esta configuración Usted tiene que hacer la selección de las principales rejillas de competencia que le gustaría usar en esta instalación Moodle.';
$string['explaineditactivities_subjects'] = '';
$string['export_all_standards'] = 'Exportar todas las rejillas de competencia de esta instalación Moodle';
$string['export_password_message'] = 'Recuerde la contraseña "<strong>{$a}</strong>" antes de continuar';
$string['export_selective'] = 'Seleccionar rejillas de competencia para exportar';
$string['exportieren'] = 'Exportar';
$string['extern_task'] = 'Trabajo esterno';
$string['filerequired'] = 'Debe seleccionarse un archivo';
$string['files'] = 'Archivos';
$string['filterClear'] = 'Borrar filtro';
$string['filteredtaxonomies'] = 'Los ejemplos son filtrados de acuerdo a las taxonomías siguientes:';
$string['first_configuration_step'] = 'El primer paso de la configuración es importar algunos datos hacia Rejilla de Competencia Exabis.';
$string['freematerials'] = 'materiales gratuitos';
$string['from'] = 'de';
$string['globalgradings'] = 'calificaciones globales';
$string['grade_Deficient'] = 'deficiente';
$string['grade_Insufficient'] = 'insuficiente';
$string['grade_Satisfactory'] = 'satisfactoria';
$string['grade_Sufficient'] = 'suficiente';
$string['grade_Verygood'] = 'muy buena';
$string['grade_example_related'] = 'Evaluar descriptores y competencias relacionadas';
$string['grade_good'] = 'buena';
$string['grading'] = 'Calificación';
$string['grading_scheme'] = 'esquema de calificación';
$string['grid_creating_is_disabled'] = '¡La creación de rejilla está deshabilitada!';
$string['groupcategory'] = 'Categoría';
$string['header_edit_mode'] = 'El modo de edición está activado';
$string['help_content'] = '<h1>Video Introductorio</h1>
<iframe width="640" height="360" src="//www.youtube.com/embed/EL4Vb3_17EM?feature=player_embedded" frameborder="0" allowfullscreen></iframe>';
$string['help_crosssubject'] = 'La compilación de un asunto es hecha para toda la intalación Moodle (la escuela) usando la pestaña de la ruta de aprendizaje. Auí Usted puede selectivamente desactivar competencias, subcompetencias y materiales específicos-de-curso. El material de aprendizaje individual también puede ser añadido. Esto es entonces añadido automáticamente  a las rutas de aprendizaje.';
$string['hide_for_all_students'] = 'Ocultar para todos los estudiantes';
$string['hide_solution'] = 'Ocultar solución';
$string['hide_solution_disabled'] = 'La solución ya está oculta para todos los estudiantes';
$string['hideevaluation'] = 'Para ocultar auto-evaluación haga  click <a href="{$a}">aquí</a>';
$string['hideevaluation_student'] = 'Para ocultar evaluación del entrenador haga  click <a href="{$a}">aquí</a>';
$string['ics_provide_link_text'] = 'Por favor proporcione un enlace.';
$string['import_activate_scheduled_tasks'] = 'Activar estos trabajos';
$string['import_activities'] = 'Importar actividaddes desde un curso de plantilla hacia su curso';
$string['import_category_mapping_column_exacomp'] = 'Título niveldificultad Exacomp';
$string['import_category_mapping_column_level'] = 'Nivel';
$string['import_category_mapping_column_level_descriptor'] = 'Competencia / Competencia hija';
$string['import_category_mapping_column_level_example'] = 'Material';
$string['import_category_mapping_column_xml'] = 'Título XML';
$string['import_category_mapping_needed'] = 'Esquema de calificación donde XML es diferente del esquema exacomp. Por favor configure las correlaciones correctamente e intente importar de nuevo.';
$string['import_from_related_komet'] = 'importar/actualizar rejillas desde KOMET relacionado inmediatamente';
$string['import_from_related_komet_help'] = 'Si la actualización automática de las rejillas de competencias a través de KOMET está activada en segundo plano a través de la configuración general, la actualización se puede ejecutar de inmediato.<br>
La actualización automática se puede configurar a través de Administración del sitio - Plugins - Bloques - Rejilla de competencias Exabis: URL del servidor';
$string['import_ics'] = 'importar calendario';
$string['import_ics_loading_time'] = 'Importación iniciada.';
$string['import_mapping_as_is'] = 'Usar como está';
$string['import_mapping_delete'] = 'Eliminar';
$string['import_max_execution_time'] = 'Importante: El límite actual en Serversettings limita la Importación a que corra hasta un máximo de {$a} segundos. Si la importación tarda más, no se importarán ningún dato y el navegado puede mostrar "500 Internal Server Error"  (Error 500 Interno del Servidor).';
$string['import_select_file'] = 'Seleccionar archivo:';
$string['import_selectgrids_needed'] = 'Seleccionar asuntos para importación:';
$string['import_source'] = 'Importado desde: {$a}';
$string['import_used_preselected_from_previous'] = 'Si previamente se ha importado un XML, estos valores están pre-seleccionados';
$string['importdone'] = 'los datos han sido importados desde XML';
$string['importfail'] = 'ha ocurrido un error durante la importación';
$string['importinfo'] = 'Por favor cree sus rejillas de competencias en  <a target="_blank" href="https://comet.edustandards.org">www.edustandards.org</a>.';
$string['importpending'] = '¡todavía no se importó ningún dato!';
$string['importsuccess'] = '¡Los datos fueron importados exitosamente!';
$string['importsuccess_own'] = '¡Los datos individuales fueron importados exitosamente!';
$string['importtask_all_subjects'] = 'Todos los asuntos';
$string['importtask_disabled'] = 'Deshabilitado';
$string['importtask_link'] = 'Enlace a orígen';
$string['importtask_title'] = 'Título';
$string['importwebservice'] = 'Es posible tener los datos actualizados vía una <a href="{$a}">Server-URL</a>.';
$string['infolink'] = 'Información adicional:';
$string['innersection1'] = 'Vista de rejilla';
$string['innersection2'] = 'Estadísticas';
$string['innersection3'] = 'Comparación: Profesor-Estudiante';
$string['instruction'] = 'Instrucción';
$string['instruction_content'] = 'Esta es una vista general para recursos educativos que están asociados con estándares y marcar competencias para estudiantes. Los estudiantes pueden valorar sus competencias. Las actividades de Moodle que fueron seleccionadas por estudiantes son mostradas con un ícono rojo. Los artefactos de ePortafolios de estudiantes son mostrados en íconos azules.';
$string['inwork'] = '{$a->inWork}/{$a->total} en trabajo';
$string['is_teacherexample'] = 'Es el ejemplo del profesor';
$string['isgraded'] = 'El ejemplo ya está calificado y por lo tanto ya no es posible un envío';
$string['legend_activities'] = 'Actividades Moodle';
$string['legend_eportfolio'] = 'ePortfolio';
$string['legend_notask'] = 'No se han enviado actividades/eexámenes para este resultado';
$string['legend_upload'] = 'Suba su propio trabajo/ejemplo';
$string['link'] = 'Enlace';
$string['linkerr'] = '¡El enlace dado no es válido!';
$string['links'] = 'enlaces';
$string['local'] = 'Local';
$string['manage_crosssubs'] = 'Regresar a vista general';
$string['materials_compProfile'] = 'Materiales';
$string['messageprovider:comment'] = 'Comentarios del profesor para un ejemplo';
$string['messageprovider:grading'] = 'Notificar al estudiante que un profesor calificó competencias';
$string['messageprovider:self_assessment'] = 'Estudiante valoró algunas competencias propias';
$string['messageprovider:submission'] = 'Notificarle al profesor que un estudiante ha enviado un ítem';
$string['messageprovider:weekly_schedule'] = 'El profesor añadió ejemplo nuevo a la agenda semanal';
$string['messagetocourse'] = 'Mandar mensaje a todos los estudiantes';
$string['module_filter'] = 'filtrar actividades';
$string['module_used_availabilitycondition_competences'] = 'Otorgar competencias exabis relacionadas cuando se cumpla la condición';
$string['move_down'] = 'Mover abajo';
$string['move_up'] = 'Mover arriba';
$string['my_badges'] = 'Mis Insignias';
$string['my_comps'] = 'Mis Competencias';
$string['mybadges'] = 'Mis insignias';
$string['n1.unit'] = '1. unidad';
$string['n10.unit'] = '10. unidad';
$string['n2.unit'] = '2. unidad';
$string['n3.unit'] = '3. unidad';
$string['n4.unit'] = '4. unidad';
$string['n5.unit'] = '5. unidad';
$string['n6.unit'] = '6. unidad';
$string['n7.unit'] = '7. unidad';
$string['n8.unit'] = '8. unidad';
$string['n9.unit'] = '9. unidad';
$string['name'] = 'Nombre';
$string['name_example'] = 'Nombre';
$string['new'] = 'nuevo';
$string['new_column'] = 'nueva columna';
$string['new_crosssub'] = 'Crear nuevo asunto interdisciplinario';
$string['new_niveau'] = 'Nuevo progreso de aprendizaje';
$string['new_topic'] = 'nuevo Tema';
$string['newer_grading_tooltip'] = 'La calificación podría no estar actualizada. </br> Un descriptorhijo ha sido calificado.';
$string['newsubmission'] = 'Envío Nuevo';
$string['next_step'] = 'Este paso de la configuración ha sido completado. Haga clic aquí para continuar la configuración.';
$string['next_step_first_teacher_step'] = 'Haga clic aquí para continuar la configuración.';
$string['next_step_teacher'] = 'La configuración que tiene que ser hecha por el administrador ahora ya está completada. Para continuar con la configuración específica del curso, haga clic aquí.';
$string['niveau'] = 'Nivel de Dificultad';
$string['niveau_description'] = 'Crear su primer Nivel de Dificultad:';
$string['niveau_filter'] = 'Filtrar Niveles de dificultad';
$string['niveau_short'] = 'Nivel';
$string['no_activities_selected'] = 'por favor, asocie actividades de Moodle con competencias';
$string['no_activities_selected_student'] = 'Todavía no hay datos disponibles';
$string['no_badges_yet'] = 'sin insignias disponibles';
$string['no_course_activities'] = 'No se encontraron actividades Moodle en este curso - haga clic aquí para crear algunas.';
$string['no_course_templates'] = 'No se puede encontrar ningún curso para usar como plantilla';
$string['no_crosssubjs'] = 'Sin asuntos interdisciplinarios disponibles.';
$string['no_entries_found'] = 'no se encontraron entradas';
$string['no_external_trainer'] = 'Sin entrenadores esternos asignados';
$string['no_permission'] = 'Permisos no configurados';
$string['no_permission_user'] = 'Permisos no establecidos para el rol "usuario autenticado"';
$string['no_specification'] = 'sin valoraciones';
$string['no_student'] = '-- sin  participantes seleccionados --';
$string['no_student_edit'] = 'modo edición - sin participante';
$string['no_students_crosssub'] = 'Sin estudiantes asignados a este asunto interdisciplinario.';
$string['no_topics_selected'] = 'La configuración de Rejilla de Competencia Exabis aun no está completada. Por favor elija un tópico con el cual a Usted le gustaría asociar actividades Moodle';
$string['nocrosssubsub'] = 'Asuntos Interdisciplinarios Generales';
$string['noschedules_pre_planning_storage'] = 'El almacenamiento de pre-planeación ha sido vaciado; use la rejilla de competencia para poner nuevos ejemplos en el almacenamiento de pre-planeación.';
$string['nostudents'] = 'Sin estudiantes';
$string['notification_example_comment_body'] = 'Estimado/a {$a->receiver}, </br></br>{$a->teacher} comentó en {$a->course} el ejemplo {$a->example}.</br></br> Este mensaje ha sido generado desde el sitio Moodle {$a->site}.';
$string['notification_example_comment_body_noSiteName'] = 'Estimado {$a->receiver}, </br></br>{$a->teacher} comentó en {$a->course} el ejemplo {$a->example}.</br></br>';
$string['notification_example_comment_context'] = 'Comentario';
$string['notification_example_comment_subject'] = '{$a->site}: Nuevo comentario para ejemplo {$a->example}';
$string['notification_example_comment_subject_noSiteName'] = 'Nuevo comentario para el ejemplo {$a->example}';
$string['notification_grading_body'] = 'Estimado/a {$a->receiver}, </br></br>Usted tiene nuevas calificaciones en {$a->course} de {$a->teacher}.</br></br> Este mensaje ha sido generado desde el sitio Moodle {$a->site}.';
$string['notification_grading_body_noSiteName'] = 'Estimado {$a->receiver}, </br></br>Recibió nuevas calificaciones en {$a->course} de {$a->teacher}.</br></br>';
$string['notification_grading_context'] = 'Calificación';
$string['notification_grading_subject'] = '{$a->site}: Nueva calificación en curso {$a->course}';
$string['notification_grading_subject_noSiteName'] = 'Nueva calificación en el curso {$a->course}';
$string['notification_self_assessment_body'] = 'Estimado/a Sr./Sra./Srita. {$a->receiver}, </br></br> {$a->student} tiene nuevas auto-evaluaciones en {$a->course}.</br></br> Este mensaje ha sido generado desde el sitio Moodle {$a->site}.';
$string['notification_self_assessment_body_noSiteName'] = 'Estimado señor/señora {$a->receiver}: <br></br> {$a->student} tiene nuevas autoevaluaciones en {$a->course}.</br></br>';
$string['notification_self_assessment_context'] = 'auto evaluación';
$string['notification_self_assessment_subject'] = '{$a->site}: Nuevas auto evaluaciones en {$a->course}';
$string['notification_self_assessment_subject_noSiteName'] = 'Nueva auto evaluación en {$a->course}';
$string['notification_submission_body'] = 'Estimado/a Sr./Sra/Srita {$a->receiver}, </br></br> {$a->student} envió {$a->example} on {$a->date} en {$a->time}. El envío puede verse en ePortfolio: <a href={$a->viewurl}>{$a->example}</a> </br></br> Este mensaje ha sido generado desde el sitio Moodle {$a->site}.';
$string['notification_submission_body_noSiteName'] = 'Estimado Sr./Sra. {$a->receiver}: <br></br> {$a->student} envió {$a->example} el {$a->date} a las {$a->time}. El envío se puede ver en ePortfolio: <a href={$a->viewurl}>{$a->example}</a> </br></br>';
$string['notification_submission_context'] = 'Envío';
$string['notification_submission_subject'] = '{$a->site}: {$a->student} envió una solución para {$a->example}';
$string['notification_submission_subject_noSiteName'] = '{$a->student} envió una solución para {$a->example}';
$string['notification_weekly_schedule_body'] = 'Estimado/a {$a->receiver}, </br></br>{$a->teacher} añadió un ejemplo en {$a->course} a la agenda semanal de usted.</br></br> Este mensaje ha sido generado desde el sitio Moodle {$a->site}.';
$string['notification_weekly_schedule_body_noSiteName'] = 'Estimado {$a->receiver}, </br></br>{$a->teacher} agregó un ejemplo en {$a->course} a su cronograma semanal.</br></br>';
$string['notification_weekly_schedule_context'] = 'Agenda semanal';
$string['notification_weekly_schedule_subject'] = '{$a->site}: Nuevo ejemplo en la agenda';
$string['notification_weekly_schedule_subject_noSiteName'] = 'Nuevo ejemplo en la agenda';
$string['noxmlfile'] = 'No hay datos disponibles para importar. Por favor visite <a href="https://github.com/gtn/edustandards">https://github.com/gtn/edustandards</a> para descargar los resultados requeridos al directorio XML del bloque.';
$string['numb'] = 'Número';
$string['number_of_found_students'] = 'número de estudiantes encontrados';
$string['number_of_students'] = 'número de estudiantes';
$string['oldxmlfile'] = 'Usted está empleando un archivo XML obsoleto. Por favor cree nuevos resultados/estándares en <a href="https://comet.edustandards.org">www.edustandards.org</a> or visit <a href="http://www.github.com/gtn/edustandards">github.com/gtn/edustandards</a>  para descargar un archivo XML disponible al directorio de bloques XML.';
$string['opencomps'] = 'Elegir sus competencias';
$string['optional_step'] = 'Aun no hay participantes en su curso. Si Usted quiere inscribir algunos por favor use este enlace.';
$string['output_current_assessments'] = 'salida de evaluaciones actuales';
$string['override_notice1'] = 'Esta entrada fue editada por';
$string['override_notice2'] = 'antes. ¿Continuar?';
$string['overview'] = 'Esta es una vista general de todos los estudiantes y las competencias del curso.';
$string['overview_examples_report_title'] = 'Resumen de los ejemplos';
$string['own_additions'] = 'Adiciones curriculares:';
$string['participating_student'] = 'estudiante';
$string['pendingbadges'] = 'Insignias pendientes';
$string['pendingcomp'] = 'competencias pendientes';
$string['period'] = 'período';
$string['periodselect'] = 'Seleccionar período';
$string['please_choose'] = 'Por favor seleccione';
$string['please_choose_preselection'] = 'Por favor seleccione los asuntos de donde quiere ser eliminado.';
$string['please_select_topic_first'] = 'Por favor seleccione un tema de competencia en la barra izquierda';
$string['pluginname'] = 'Rejilla de Competencias Exabis';
$string['points_limit_forcourse'] = 'Valor más altopara Puntos';
$string['pre_planning_materials_assigned'] = 'Se asignaron materiales seleccionados a los estudiantes/grupos seleccionados.';
$string['pre_planning_storage'] = 'Almacenamiento de planeación';
$string['pre_planning_storage_added'] = 'Ejemplo añadido al planeamiento de pre-planeación';
$string['pre_planning_storage_already_contains'] = 'El ejemplo ya está en el almacenamiento de planeación.';
$string['pre_planning_storage_disabled'] = 'Ejemplo oculto no puede añadirse al almacenamiento de planeación.';
$string['pre_planning_storage_example_button'] = 'En mi almacenamiento de planificación';
$string['pre_planning_storage_popup_button'] = 'Almacenamiento de planificación';
$string['print'] = 'Imprimir';
$string['privacy:metadata:block_exacompcmassign'] = 'Almacenamiento para mecanismo de auto calificar: no necesita ser exportado';
$string['privacy:metadata:block_exacompcmassign:coursemoduleid'] = 'Id de módulo de curso';
$string['privacy:metadata:block_exacompcmassign:relateddata'] = 'Datos, relacionados al estudiante';
$string['privacy:metadata:block_exacompcmassign:timemodified'] = 'sello de tiempo';
$string['privacy:metadata:block_exacompcmassign:userid'] = 'IDs de estudiantes';
$string['privacy:metadata:block_exacompcompuser'] = 'Almacenamiento para evaluaciones de estudiantes';
$string['privacy:metadata:block_exacompcompuser:additionalinfo'] = 'Resultado de evaluación';
$string['privacy:metadata:block_exacompcompuser:compid'] = 'Competencia que fue evaluada';
$string['privacy:metadata:block_exacompcompuser:comptype'] = 'Tipo de competencia evaluada';
$string['privacy:metadata:block_exacompcompuser:courseid'] = 'Curso';
$string['privacy:metadata:block_exacompcompuser:evalniveauid'] = 'Nivel de dificultad de evaluación';
$string['privacy:metadata:block_exacompcompuser:globalgradings'] = 'valor global';
$string['privacy:metadata:block_exacompcompuser:gradinghistory'] = 'historia de calificación';
$string['privacy:metadata:block_exacompcompuser:gradingisold'] = '¿es antigua?';
$string['privacy:metadata:block_exacompcompuser:personalisedtext'] = 'texto personalizado adicional';
$string['privacy:metadata:block_exacompcompuser:reviewerid'] = 'Revisor que evaluó';
$string['privacy:metadata:block_exacompcompuser:role'] = 'Rol del revisor que evaluó';
$string['privacy:metadata:block_exacompcompuser:timestamp'] = 'Fecha de evaluación';
$string['privacy:metadata:block_exacompcompuser:userid'] = 'Estudiante que fue evaluado';
$string['privacy:metadata:block_exacompcompuser:value'] = 'Resultado de la evaluación';
$string['privacy:metadata:block_exacompcrossstud_mm'] = 'Compartir temas transversales con los estudiantes';
$string['privacy:metadata:block_exacompcrossstud_mm:crosssubjid'] = 'ID tema transversal';
$string['privacy:metadata:block_exacompcrossstud_mm:studentid'] = 'Estudiante';
$string['privacy:metadata:block_exacompcrosssubjects'] = 'Temas transversales, creados por el usuario';
$string['privacy:metadata:block_exacompcrosssubjects:courseid'] = 'ID del curso';
$string['privacy:metadata:block_exacompcrosssubjects:creatorid'] = 'ID del creador';
$string['privacy:metadata:block_exacompcrosssubjects:description'] = 'Descripción';
$string['privacy:metadata:block_exacompcrosssubjects:groupcategory'] = 'categoría del grupo';
$string['privacy:metadata:block_exacompcrosssubjects:shared'] = 'compartido o no';
$string['privacy:metadata:block_exacompcrosssubjects:subjectid'] = 'Id de asunto relacionado';
$string['privacy:metadata:block_exacompcrosssubjects:title'] = 'Título';
$string['privacy:metadata:block_exacompdescrvisibility'] = 'Descriptores de visibilidad para usuarios';
$string['privacy:metadata:block_exacompdescrvisibility:courseid'] = 'Id del curso';
$string['privacy:metadata:block_exacompdescrvisibility:descrid'] = 'ID de competencia';
$string['privacy:metadata:block_exacompdescrvisibility:studentid'] = 'Estudiante';
$string['privacy:metadata:block_exacompdescrvisibility:visible'] = 'Marcador visible';
$string['privacy:metadata:block_exacompexameval'] = 'Almacenamiento para evaluaciones del estudiante (ejemplos)';
$string['privacy:metadata:block_exacompexameval:additionalinfo'] = 'Valor de la evaluación del profesor (se utiliza para algunos tipos de evaluación)';
$string['privacy:metadata:block_exacompexameval:courseid'] = 'Curso';
$string['privacy:metadata:block_exacompexameval:exampleid'] = 'Ejemplo';
$string['privacy:metadata:block_exacompexameval:resubmission'] = 'Se permite/no se permite el reenvío';
$string['privacy:metadata:block_exacompexameval:student_evaluation'] = 'Auto evaluación';
$string['privacy:metadata:block_exacompexameval:studentid'] = 'Estudiante que fue evaluado';
$string['privacy:metadata:block_exacompexameval:teacher_evaluation'] = 'Valor de evaluación del rpofesor';
$string['privacy:metadata:block_exacompexameval:teacher_reviewerid'] = 'Profesor que evaluó';
$string['privacy:metadata:block_exacompexameval:timestamp_student'] = 'Hora de auto evaluación';
$string['privacy:metadata:block_exacompexameval:timestamp_teacher'] = 'Hora de evaluación del profesor';
$string['privacy:metadata:block_exacompexampvisibility'] = 'Ejemplos de visibilidad para los usuarios';
$string['privacy:metadata:block_exacompexampvisibility:courseid'] = 'Id del curso';
$string['privacy:metadata:block_exacompexampvisibility:exampleid'] = 'ID del material';
$string['privacy:metadata:block_exacompexampvisibility:studentid'] = 'Estudiante';
$string['privacy:metadata:block_exacompexampvisibility:visible'] = 'Marcador visble';
$string['privacy:metadata:block_exacompexternaltrainer'] = 'Entrenadores externos para estudiantes';
$string['privacy:metadata:block_exacompexternaltrainer:studentid'] = 'Estudiante';
$string['privacy:metadata:block_exacompexternaltrainer:trainerid'] = 'Entrenador';
$string['privacy:metadata:block_exacompglobalgradings'] = 'Texto de calificación global para un asunto/tópico/competencia';
$string['privacy:metadata:block_exacompglobalgradings:compid'] = 'ID de competencia';
$string['privacy:metadata:block_exacompglobalgradings:comptype'] = 'tipo de competencia: 0 - descriptor; 1 - tópico';
$string['privacy:metadata:block_exacompglobalgradings:globalgradings'] = 'contenido de calificación global';
$string['privacy:metadata:block_exacompglobalgradings:userid'] = 'Id del estudiante';
$string['privacy:metadata:block_exacompprofilesettings'] = 'cual curso a incluir en el perfil de competencia';
$string['privacy:metadata:block_exacompprofilesettings:block'] = 'bloque asociado: exacomp, exastud o exaport';
$string['privacy:metadata:block_exacompprofilesettings:feedback'] = 'retroalimentación verbal debería ser mostrada (para revisiones exastud)';
$string['privacy:metadata:block_exacompprofilesettings:itemid'] = 'ID del curso';
$string['privacy:metadata:block_exacompprofilesettings:userid'] = 'Estudiante';
$string['privacy:metadata:block_exacompschedule'] = 'ejemplos, añadidos a la lista de agenda del estudiante';
$string['privacy:metadata:block_exacompschedule:courseid'] = 'Curso';
$string['privacy:metadata:block_exacompschedule:creatorid'] = 'Creador de registro programado';
$string['privacy:metadata:block_exacompschedule:deleted'] = 'Marcador de registro eliminado';
$string['privacy:metadata:block_exacompschedule:distributionid'] = 'Id de distribuciòn';
$string['privacy:metadata:block_exacompschedule:endtime'] = 'Hora de fin';
$string['privacy:metadata:block_exacompschedule:exampleid'] = 'Ejemplo agendado';
$string['privacy:metadata:block_exacompschedule:sorting'] = 'Ordenación de registros';
$string['privacy:metadata:block_exacompschedule:source'] = 'E/P como un tipo';
$string['privacy:metadata:block_exacompschedule:start'] = 'Hora de inicio';
$string['privacy:metadata:block_exacompschedule:studentid'] = 'Estudiante';
$string['privacy:metadata:block_exacompschedule:timecreated'] = 'Registro de hora de creaciòn';
$string['privacy:metadata:block_exacompschedule:timemodified'] = 'Registro de hora de ediciòn';
$string['privacy:metadata:block_exacompsolutvisibility'] = 'cuales soluciones de ejemplos están visibles';
$string['privacy:metadata:block_exacompsolutvisibility:courseid'] = 'ID del curso';
$string['privacy:metadata:block_exacompsolutvisibility:exampleid'] = 'ID del ejemplo';
$string['privacy:metadata:block_exacompsolutvisibility:studentid'] = 'Estudiante';
$string['privacy:metadata:block_exacompsolutvisibility:visible'] = 'marcador visble';
$string['privacy:metadata:block_exacomptopicvisibility'] = 'cuales tópicos son visibles';
$string['privacy:metadata:block_exacomptopicvisibility:courseid'] = 'ID del curso';
$string['privacy:metadata:block_exacomptopicvisibility:studentid'] = 'Estudiante';
$string['privacy:metadata:block_exacomptopicvisibility:topicid'] = 'ID de tópico';
$string['privacy:metadata:block_exacomptopicvisibility:visible'] = 'marcador visble';
$string['privacy:metadata:block_exacompwsdata'] = 'datos temporales para servicios web';
$string['privacy:metadata:block_exacompwsdata:data'] = 'contenido de datos';
$string['privacy:metadata:block_exacompwsdata:token'] = 'valor del token';
$string['privacy:metadata:block_exacompwsdata:userid'] = 'Usuario';
$string['profile_settings_choose_courses'] = 'Al usar Rejilla de Competencia Exabis los entrenadores valoran las competencias de Usted en varios asuntos. Usted puede seleccionar cuales cursos incluir en el perfil de competencia.';
$string['profoundness_0'] = 'no alcanzada';
$string['profoundness_1'] = 'Parcialmente ganada';
$string['profoundness_2'] = 'Completamente ganada';
$string['profoundness_basic'] = 'Competencia básca';
$string['profoundness_description'] = 'Descripción';
$string['profoundness_entirely'] = 'Enteramente  lograda';
$string['profoundness_extended'] = 'Competencia extendida';
$string['profoundness_mainly'] = 'Principalmente lograda';
$string['progress'] = 'Progreso';
$string['questlink'] = 'Relacionar preguntas';
$string['radargrapherror'] = 'Gráfica de Radar solo puede ser mostrada con 3-13 ejes';
$string['radargraphtitle'] = 'Gráfica de Radar';
$string['ready_to_activate'] = 'Esta insignia está lista para ser activada:';
$string['really_delete'] = '¿Está seguro de que desea eliminar los elementos seleccionados?';
$string['report_competencefield'] = 'campo de competencia';
$string['report_learniningmaterial'] = 'material de aprendizaje';
$string['report_subject'] = 'estandar educativo';
$string['report_type'] = 'tipo de Reporte';
$string['reports'] = 'Tipo de reporte';
$string['result'] = 'resultado';
$string['save'] = 'Guardar';
$string['save_as_draft'] = 'Guardar asunto interdisciplinario como borrador';
$string['save_changes_competence_evaluation'] = 'Los cambios fueron guardados';
$string['save_crosssub'] = 'Guardar cambios';
$string['save_hvp_activity'] = 'Guardar actividad HVP';
$string['save_pre_planning_selection'] = 'Añadir ejemplos seleccionados a agenda semanal de estudiantes seleccionados';
$string['save_selection'] = 'Confirmar';
$string['save_success'] = 'cambiso exitosos';
$string['scheduler_import_settings'] = 'Configuraciones para importación del agendador';
$string['schedulerimport'] = 'Importar trabajos del agendador';
$string['schooltype_without_assignment_title'] = 'Sin una asignación específica';
$string['second_configuration_step'] = 'En este paso de la configuración, Usted tiene que pre-seleccionar rejillas de competencia..';
$string['select_all'] = 'seleccionar todos';
$string['select_student'] = 'Por favor, seleccione primeramente un estudiante';
$string['select_student_weekly_schedule'] = 'Por favor seleccione un estudiante para ver su agenda semanal.';
$string['select_subjects'] = 'Seleccionar Asuntos';
$string['selectcourse_filter'] = 'Filtrar';
$string['selectcourse_filter_emptyresult'] = 'Nada para mostrar';
$string['selectcourse_filter_onlyselected'] = 'Mostrar solo rejillas seleccionadas';
$string['selectcourse_filter_schooltype'] = 'Tipo de escuela';
$string['selectcourse_filter_submit'] = 'Filtrar';
$string['selfEvalVerbose.1'] = 'no aplica';
$string['selfEvalVerbose.2'] = 'generalmente no cierto';
$string['selfEvalVerbose.3'] = 'generalmente aplica';
$string['selfEvalVerbose.4'] = 'verdadero';
$string['selfEvalVerbose.defaultValue_long'] = 'no aplica; realmente falso; realmente aplica; cierto';
$string['selfEvalVerbose.defaultValue_short'] = 'na; rf; ra; c';
$string['selfEvalVerboseExample.1'] = 'sin resolver';
$string['selfEvalVerboseExample.2'] = 'resuelto con ayuda';
$string['selfEvalVerboseExample.3'] = 'resueto independientemente';
$string['selfEvalVerboseExample.defaultValue_long'] = 'no-resuelto; resuelto con ayuda; resuelto independientemente';
$string['selfEvalVerboseExample.defaultValue_short'] = 'nr; ra; ri';
$string['selfevaluation'] = 'auto evaluación';
$string['selfevaluation_short'] = 'AuEva';
$string['seperatordaterange'] = 'a';
$string['settings_addblock_to_newcourse'] = 'Añadir bloque a nuevo curso';
$string['settings_addblock_to_newcourse_description'] = 'El bloque "Rejilla de Competencias Exabis" será añadido a cada nuevo curso automáticamente. La posición del bloque insertado depende del tema Moodle seleccionadowill be added to every new course automatically. Position of inserted block depends on selected Moodle theme';
$string['settings_addblock_to_newcourse_option_left'] = 'a la región Izquierda';
$string['settings_addblock_to_newcourse_option_no'] = 'No';
$string['settings_addblock_to_newcourse_option_right'] = 'A la región Derecha';
$string['settings_addblock_to_newcourse_option_yes'] = 'Si';
$string['settings_additional_grading'] = 'Calificación adaptada';
$string['settings_additional_grading_description'] = 'Calificación limitada de "no ganado(0)" - "completamente ganado(3)"';
$string['settings_admin_preconfiguration_none'] = 'Sin preconfiguración';
$string['settings_admin_scheme'] = 'Configuración Predefinida';
$string['settings_admin_scheme_description'] = 'La calificación puede hacerse en diferentes niveles de dificultad.';
$string['settings_admin_scheme_none'] = 'sin niveles globales de dificultad';
$string['settings_applogin_enabled'] = 'Habilitar ingreso por App';
$string['settings_applogin_enabled_description'] = 'Permite el inicio de sesión desde Apps Exabis (Diggr+, Dakora, Dakora+, elove)';
$string['settings_applogin_redirect_urls_description'] = '';
$string['settings_assessment_SelfEval'] = 'Valoración del estudiante';
$string['settings_assessment_SelfEval_verboses'] = 'Verbosas para auto-evaluacion';
$string['settings_assessment_SelfEval_verboses_edit'] = 'editar verbosas';
$string['settings_assessment_SelfEval_verboses_long_columntitle'] = 'Largo';
$string['settings_assessment_SelfEval_verboses_short_columntitle'] = 'corto';
$string['settings_assessment_SelfEval_verboses_validate_error_long'] = 'Títulos largos: hasta 4 entradas, delimitador ";", máximo 20 caracteres por entrda (4 para formato corto)';
$string['settings_assessment_are_you_sure_to_change'] = '¿Realmente desea cambiar el esquema de calificación? Las calificaciones existentes pueden perderse o tener valores incorrectos';
$string['settings_assessment_diffLevel'] = 'Nivel de evaluación global';
$string['settings_assessment_diffLevel_options'] = 'Opciones de Nivel de Dificultad';
$string['settings_assessment_diffLevel_options_default'] = 'F,R,D,MD';
$string['settings_assessment_diffLevel_options_description'] = 'lista de Niveles de Dificultad; por ejemplo F,R,D,MD';
$string['settings_assessment_grade_limit'] = 'Valor más alto para calificación';
$string['settings_assessment_grade_limit_description'] = 'calificación de esquema de evaluación, límite para entrada';
$string['settings_assessment_grade_negativ'] = 'Valor de reprobado para la calificación';
$string['settings_assessment_grade_negativ_description'] = 'Valor de la calificación del esquema de evaluación, cuando el estudiante no aprueba la calificación';
$string['settings_assessment_grade_verbose'] = 'calificaciones verbalizadas (ES)';
$string['settings_assessment_grade_verbose_default'] = 'muy buena, buena, satisfactoria, suficiente, deficiente, insuficiente';
$string['settings_assessment_grade_verbose_description'] = 'Valores verbalizados de las calificaciones, separados por comas. El número debe coincidir con el valor de "Calificación más alta"  de arriba. Por ejemplo: muy bien, bien, satisfactorio, suficiente, deficiente, insuficiente';
$string['settings_assessment_grade_verbose_negative'] = 'Calificación verbalizada de reprobado (EN)';
$string['settings_assessment_grade_verbose_negative_description'] = 'Valor detallado del esquema de evaluación, cuando el estudiante no aprueba la calificación';
$string['settings_assessment_points_limit'] = 'Valor más alto para puntos';
$string['settings_assessment_points_limit_description'] = 'puntos del esquema de evaluación, límite para entrada';
$string['settings_assessment_points_negativ'] = 'Valor de reprobado para Puntos';
$string['settings_assessment_points_negativ_description'] = 'Valor en puntos del esquema de evaluación, cuando el estudiante no aprueba la calificación';
$string['settings_assessment_scheme_0'] = 'Ninguno';
$string['settings_assessment_scheme_1'] = 'Calificación';
$string['settings_assessment_scheme_2'] = 'Verbosa';
$string['settings_assessment_scheme_3'] = 'Puntos';
$string['settings_assessment_scheme_4'] = 'Si/No';
$string['settings_assessment_target_childcomp'] = 'Competencia hija';
$string['settings_assessment_target_comp'] = 'Competencia';
$string['settings_assessment_target_example'] = 'Material';
$string['settings_assessment_target_subject'] = 'Asunto';
$string['settings_assessment_target_theme'] = 'Tema (inerdisciplinario)';
$string['settings_assessment_target_topic'] = 'Tópico';
$string['settings_assessment_verbose_lowerisbetter'] = 'Un valor más bajo es mejor';
$string['settings_assessment_verbose_lowerisbetter_description'] = 'Cuanto menor sea la evaluación, mejor.';
$string['settings_assessment_verbose_options'] = 'Opciones Verbosas (ES)';
$string['settings_assessment_verbose_options_default'] = 'no ganada, parcialmente ganada, principalmente ganada, completamente ganada';
$string['settings_assessment_verbose_options_description'] = 'lista de Opciones Verbosas; por ejemplo, no ganada, parcialmente ganada, principalmente ganada, completamente ganada';
$string['settings_assessment_verbose_options_short'] = 'Opciones verbosas (ES) cortas';
$string['settings_assessment_verbose_options_short_default'] = 'Mb, B, Su, Po, In';
$string['settings_assessment_verbose_options_short_description'] = 'lista de Opciones Verbosas; por ejemplo, no ganada, parcialmente ganada, principalmente ganada, completamente ganada';
$string['settings_autotest'] = 'Calificación automática mediante actividades Moodle';
$string['settings_autotest_description'] = 'Las Competencias o Tareas que están asociadas con actividades son ganadas automáticamente si se alcanza el requerimiento de finalización de la actividad.';
$string['settings_configxmlserverurl'] = 'URL es un archivo XML, el cual es usado para mantener las entradas de la base de datos actualizadas';
$string['settings_dakora_show_eportfolio'] = 'mostrar ePortfolio';
$string['settings_dakora_show_eportfolio_description'] = '';
$string['settings_dakora_show_overview'] = 'Mostrar descripción general';
$string['settings_dakora_show_overview_description'] = '';
$string['settings_dakora_teacher_link'] = 'Clic para asignar los dakorateachers (profesoresDakora)';
$string['settings_dakora_timeout'] = 'Timeout Dakora (Segundos)';
$string['settings_dakora_timeout_description'] = '';
$string['settings_dakora_url'] = 'Url para Dakora-App';
$string['settings_dakora_url_description'] = '';
$string['settings_default_de_value'] = 'valor DE';
$string['settings_description_nurdakora'] = '<b>Solo Dakora App</b>';
$string['settings_description_nurdakoraplus'] = '<b>Solo DakoraPlus App</b>';
$string['settings_description_nurdiggr'] = '<b>Solo Diggr+ y elove App</b>';
$string['settings_description_nurmoodleunddakora'] = '<b>Solo Moodle y Dakora App</b>';
$string['settings_disable_js_assign_competencies'] = 'deshabilitar JS en la selección del estudiante en la página de "Rejilla de competencia"';
$string['settings_disable_js_assign_competencies_description'] = 'Si la "Rejilla de competencia" tiene un tiempo muy largo de generación de página, esta casilla podría resolver este problema.';
$string['settings_disable_js_editactivities'] = 'Deshabilitar JS en la selección de estudiantes en la página "Asignar actividades de Moodle"';
$string['settings_disable_js_editactivities_description'] = 'Si la opción "Asignar actividades de Moodle" (en la configuración) tiene un tiempo de generación de página largo, esta casilla de verificación puede resolver este problema.';
$string['settings_example_autograding'] = 'valoración automática de materiales paternos';
$string['settings_example_autograding_description'] = 'Cuando todos los ejemplos hijos hayan sido calificados,  el material paterno debería de ser valorado automáticamente.';
$string['settings_example_upload_global'] = 'Carga de material global';
$string['settings_example_upload_global_description'] = 'Los materiales cargados por un profesor están disponibles globalmente. Si se utiliza la misma rejilla en un curso diferente, el material será visible.';
$string['settings_explanation_tooltipp'] = 'Los resultados del informe de grupo se reducen mediante filtros de arriba hacia abajo, pero no de abajo hacia arriba.
Por ejemplo, si está activo un único filtro "nivel de dificultad G" en las competencias, el resultado será el siguiente:
- todos los estándares educativos
- todos los campos de competencia
- competencias filtradas por el nivel de dificultad G y
- competencias secundarias de las competencias que tienen un nivel de dificultad G.';
$string['settings_export_password'] = 'Protección de contraseña (cifrado AES-256) para la exportación de rejillas de competencia';
$string['settings_export_password_description'] = '(Sólo disponible a partir de la versión 7.2 de PHP)';
$string['settings_heading_apps'] = 'Configuración para Apps';
$string['settings_heading_assessment'] = 'Evaluación';
$string['settings_heading_general'] = 'General';
$string['settings_heading_performance'] = 'desempeño';
$string['settings_heading_performance_description'] = 'Intente cambiar estos parámetros si algunas páginas funcionan muy lentamente. Puede haber cambios en visualización/sabilidad.';
$string['settings_heading_scheme'] = 'Esquema de evaluación genérico';
$string['settings_heading_security'] = 'Seguridad';
$string['settings_heading_security_description'] = '';
$string['settings_heading_technical'] = 'Administrativo';
$string['settings_heading_visualisation'] = 'Visualización';
$string['settings_interval'] = 'Duración de la unidad';
$string['settings_interval_description'] = 'Duración de las unidades en la agenda';
$string['settings_msteams_client_secret_description'] = '';
$string['settings_new_app_login'] = 'Usar App-Ingreso SSO';
$string['settings_new_app_login_description'] = 'El nuevo App-Ingreso le permite a los usuarios el ingresar con todos los plugins para ingreso de Moodle. Esta configuración no es compatible con el plugin de ludificación (gamification).';
$string['settings_periods'] = 'Entradas del horario';
$string['settings_periods_description'] = 'La agenda semanal puede ser adaptada a cualquier horario. Use una fila en el área de texto para cada entrada de hora. Usted puede usar cualquier formato que prefiers, como por ejemplo "1a hora" o  "07:30 - 09:00".';
$string['settings_schedulebegin'] = 'Principio de agenda';
$string['settings_schedulebegin_description'] = 'Tiempo de inicio para la primera unidad en la agenda. Formato hh:mm';
$string['settings_scheduleunits'] = 'Cantidad de unidades';
$string['settings_scheduleunits_description'] = 'Cantidad de unidades en la agenda';
$string['settings_schoolname'] = 'Nombre y dirección de la escuela';
$string['settings_schoolname_default'] = 'Nombre y dirección de la escuela';
$string['settings_schoolname_description'] = '';
$string['settings_setapp_enabled'] = 'Habilitar funciones de SET-App';
$string['settings_setapp_enabled_description'] = 'Permitir la creación de usuarios en la App.';
$string['settings_show_teacherdescriptors_global'] = 'Competencias globales del profesor';
$string['settings_show_teacherdescriptors_global_description'] = 'Las competencias creadas por un profesor están disponibles globalmente. Si se utiliza la misma rejilla en otro curso, la competencia será visible.';
$string['settings_sourceId'] = 'ID del origen';
$string['settings_sourceId_description'] = 'ID generada automáticamente de esta instalación Exacomp. Esta ID no puede ser cambiada';
$string['settings_sso_create_users'] = 'SSO: Crear nuevos usuarios';
$string['settings_sso_create_users_description'] = '';
$string['settings_testlimit'] = 'Porcentaje-del-examen necesario para ganar competencia';
$string['settings_testlimit_description'] = 'Este porcentaje tiene que alcanzarse para ganar la competencia';
$string['settings_usebadges'] = 'Conectar con Insignias Moodle';
$string['settings_usebadges_description'] = 'Activar para asociar insignias con competencias';
$string['settings_xmlserverurl'] = 'URL del servidor';
$string['share_crosssub'] = 'Compartir asunto interdisciplinario con participantes';
$string['share_crosssub_for_further_use'] = 'Compartir el asunto interdisciplinario con estudiantes.';
$string['share_crosssub_with_all'] = 'Compartir el asunto interdisciplinario "{$a}" con todos los participantes:';
$string['share_crosssub_with_students'] = 'Compartir el asunto interdisciplinario "{$a}" con los siguientes participantes:';
$string['show_all_course_examples'] = 'Mostrar ejemplos de todos los cursos';
$string['show_all_descriptors'] = 'Mostrar todos los resultados en vista general';
$string['show_all_taxonomies'] = 'Todas las taxonomías';
$string['show_course_crosssubs'] = 'Mostrar asuntos interdisciplinarios usados';
$string['show_solution'] = 'Mostrar solución';
$string['showevaluation'] = 'Para mostrar auto-evaluación, hacer clic <a href="{$a}">aquí</a>';
$string['showevaluation_student'] = 'Para mostrar evaluación-por-entrenador, hacer clic <a href="{$a}">aquí</a>';
$string['solution'] = 'Solución';
$string['sorting'] = 'elegir ordenamiento:';
$string['specificcontent'] = 'tópicos específicos del sitio';
$string['statistic'] = 'Vista general';
$string['statistic_type_descriptor'] = 'Cambiar a estadísticas descritoras';
$string['statistic_type_example'] = 'Cambiar a estadísticas ejemplo';
$string['student'] = 'Estudiante';
$string['student_assessment'] = 'evaluación del estudiante';
$string['studentcomp'] = 'auto evaluar competencias';
$string['students_competences'] = 'competencias del estudiante';
$string['studentshortcut'] = 'Est';
$string['subject'] = 'asunto';
$string['subject_singular'] = 'Campo de competencia';
$string['submission'] = 'Envío';
$string['submissionmissing'] = 'Debe enviarse al menos un enlace o archivo';
$string['submit_example'] = 'Enviar';
$string['tab_admin_configuration'] = 'Pre-selección de rejillas de competencia';
$string['tab_admin_import'] = 'Importar/Exportar';
$string['tab_admin_settings'] = 'Configuraciones Administrativas';
$string['tab_admin_taxonomies'] = 'Niveles de dificultad';
$string['tab_badges'] = 'Mis insignias';
$string['tab_competence_gridoverview'] = 'Descripción general';
$string['tab_competence_overview'] = 'Rejilla de Competencia';
$string['tab_competence_profile'] = 'Perfil de Competencia';
$string['tab_competence_profile_profile'] = 'Perfil';
$string['tab_competence_profile_settings'] = 'Configuraciones';
$string['tab_cross_subjects'] = 'Asuntos Interdisciplinarios';
$string['tab_cross_subjects_course'] = 'Asuntos Interdisciplinarios del Curso';
$string['tab_cross_subjects_overview'] = 'Vista General';
$string['tab_examples'] = 'Ejemplos y trabajos';
$string['tab_group_reports'] = 'Reportes de Grupo';
$string['tab_help'] = 'Ayuda';
$string['tab_profoundness'] = 'Competencias Básicas y Extendidas';
$string['tab_student_all'] = 'Todas las competencias ganadas';
$string['tab_teacher_report_annex'] = 'Anexar';
$string['tab_teacher_report_annex_delete_template'] = 'eliminar';
$string['tab_teacher_report_annex_template'] = 'plantilla docx';
$string['tab_teacher_report_annex_title'] = 'Anexar al reporte de desarrollo del aprendizaje';
$string['tab_teacher_report_general'] = 'Reporte general';
$string['tab_teacher_report_profoundness'] = 'Competencias básicas y extendidas';
$string['tab_teacher_report_profoundness_title'] = 'Competencias básicas y extendidas';
$string['tab_teacher_settings'] = 'Configuraciones';
$string['tab_teacher_settings_activitiestodescriptors'] = 'Relacionar actividades de Moodle';
$string['tab_teacher_settings_assignactivities'] = 'Asignar actividades Moodle';
$string['tab_teacher_settings_badges'] = 'Editar insignias';
$string['tab_teacher_settings_configuration'] = 'Configuración';
$string['tab_teacher_settings_course_assessment'] = 'Evaluación del curso';
$string['tab_teacher_settings_new_subject'] = 'Crear nuevo asunto';
$string['tab_teacher_settings_questiontodescriptors'] = 'Relacionar preguntas de Moodle';
$string['tab_teacher_settings_selection'] = 'Selección de asunto';
$string['tab_teacher_settings_selection_st'] = 'Selección de tipo-de-escuela';
$string['tab_teacher_settings_taxonomies'] = 'Niveles de dificultad';
$string['tab_teacher_settings_taxonomies_help'] = 'Tanto los materiales de aprendizaje como las competencias pueden proporcionarse con niveles de dificultad (normalmente se hace en la herramienta de registro de la rejilla de competencias de KOMET).</br>
Los materiales de aprendizaje pueden filtrarse según los niveles de dificultad.</br>
Otro término para los niveles de dificultad es taxonomías; por ejemplo, la taxonomía de Bloom puede utilizarse para clasificar el nivel de aprendizaje (consulte <a href=\'https://en.wikipedia.org/wiki/Bloom%27s_taxonomy\' target=\'_blank\'>https://en.wikipedia.org/wiki/Bloom%27s_taxonomy</a>)';
$string['tab_weekly_schedule'] = 'Agenda Semanal';
$string['task_example'] = 'Trabajos';
$string['taxonomies'] = 'taxonomías';
$string['taxonomy'] = 'Taxonomía';
$string['taxonomy_was_deleted'] = 'Nivel de dificultad fue eliminado';
$string['teacher'] = 'Profesor';
$string['teacher_assessment'] = 'evaluación del profesor';
$string['teacher_first_configuration_step'] = 'El primer paso en la configuración del curso es ajustar configuraciones generales para su curso.';
$string['teacher_second_configuration_step'] = 'Een el segundo paso de la configuración tienen que seleccionarse los tópicos en los cuales trabajar.';
$string['teacher_third_configuration_step'] = 'El paso siguiente es asociar actividades de Moodle con competencias';
$string['teacher_third_configuration_step_link'] = '(Opcional: Si no desea trabajar con actividades, desactive la configuración "Yo quiero trabajar con actividades Moodle" en la pestaña "Configuración")';
$string['teacher_tipp'] = 'sugerencia';
$string['teacher_tipp_1'] = 'Esta competencia ha sido asociada con';
$string['teacher_tipp_2'] = 'Las actividades Moodle se han alcanzado con';
$string['teacher_tipp_3'] = 'resultados.';
$string['teachercomp'] = 'competencias ganadas';
$string['teacherevaluation'] = 'evaluación del entrenador';
$string['teacherevaluation_short'] = 'Prof';
$string['teachershortcut'] = 'P';
$string['textalign'] = 'Alternar alineación del texto';
$string['tick_some'] = '¡Por favor, haga una selección!';
$string['timeframe_example'] = 'Periodo de tiempo';
$string['timeline_available'] = 'Disponible';
$string['titlenotemtpy'] = 'Se necesita un nombre.';
$string['to'] = 'para';
$string['to_award'] = 'Para otorgar esta insignia en exacomp Usted tiene que configurar competencias';
$string['to_award_role'] = 'Para otorgar esta insignia en exacomp Usted tiene que añadir el criterio "Expedición manual por rol"';
$string['to_weekly_schedule'] = 'Hacia agenda semanal';
$string['topic'] = 'Tópico';
$string['topic_3dchart'] = 'Gráfica 3D';
$string['topic_3dchart_empty'] = 'Sin calificaciones disponibles';
$string['topic_description'] = 'Crear su primer tópico:';
$string['topic_submission_info'] = 'Debe agregar un trabajo al tema "{$a}". Su trabajo se guardará en el ePortfolio de Exabis y los profesores podrán verlo allí.';
$string['topicgrading'] = 'Calificación total del tema:';
$string['total'] = 'total';
$string['total_example'] = 'Ejemplo Completo';
$string['transferable_skills'] = 'Habilidades transferibles';
$string['unittest_string'] = 'result_unittest_frase';
$string['unknown_src'] = 'Origen desconocido';
$string['unload_notice'] = '¿Está seguro? Los cambios no guardados se perderán.';
$string['upload_ics_file'] = 'Seleccionar el archivo:';
$string['use_available_crosssub'] = 'USar borrador para crear nuevo asunto interdisciplinario:';
$string['use_grade_verbose_competenceprofile'] = 'calificaciones verbosas perfil de competencia';
$string['use_grade_verbose_competenceprofile_descr'] = 'usar calificaciones verbosas en perfil de competencia';
$string['use_isglobal'] = 'curso global';
$string['usehideglobalsubjects'] = 'Ocultar asuntos globales';
$string['usenostudents'] = 'Usar sin estudiantes';
$string['usenumbering'] = 'Habilitar numeración automática en la rejilla de competencia';
$string['useprofoundness'] = 'Usar competencias básicas y eextendidas';
$string['usernosubmission'] = '{$a}  no ha enviado ninguna tarea o examen Moodle asociados con este resultado';
$string['uses_activities'] = 'Yo trabajo con actividades Moodle';
$string['usesubjectgrading'] = 'Habilitar calificaciones de asunto';
$string['usetopicgrading'] = 'Habilitar calificaciones de tópico';
$string['value_not_allowed'] = 'Error: Los valores necesitan ser números entre 1.0 y 6.0';
$string['value_too_large'] = 'Error: Valores arriba de {limit} no están permitidos';
$string['value_too_low'] = 'Error: Valores abajo de 1.0 no están permitidos';
$string['warning_use_activities'] = 'Advertencia: Usted está ahora trabajando con actividades de Moodle que están asociadas con competencias. Por favor verifique que que sean usados los mismos resultados de antes.';
$string['weekly_schedule'] = 'Agenda semanal';
$string['weekly_schedule_added'] = 'Ejemplo añadido a la agenda semanal';
$string['weekly_schedule_added_all'] = 'Ejemplo añadido a la agenda semanal de todos los eestudiantes.';
$string['weekly_schedule_already_existing_for_one'] = 'El ejemplo ya ha sido añadido al menos a una agenda semanal de estudiante.';
$string['weekly_schedule_already_exists'] = 'El ejeemplo ya está en la agenda semanal';
$string['weekly_schedule_disabled'] = 'Eejemplo oculto no puede ser añadido a agenda semanal';
$string['weekly_schedule_link_to_grid'] = 'Para añadir ejemplos a la agenda, por favor use la vista general';
$string['yes_no_No'] = 'No';
$string['yes_no_Yes'] = 'Si';
