<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_treestudyplan', language 'es_mx', version '5.0'.
 *
 * @package     local_treestudyplan
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add_association'] = 'Añadir';
$string['advanced_backup'] = 'Respaldar a archivo';
$string['advanced_backup_page'] = 'Respaldar página de plan de estudio activo';
$string['advanced_backup_plan'] = 'Respaldar plan de estudio';
$string['advanced_backup_restore'] = 'Respaldar y restaurar';
$string['advanced_bulk_course_timing'] = 'Sincronizar tiempos del curso a períodos';
$string['advanced_bulk_course_timing_desc'] = 'Sincronizar la fecha de inicio y finalización de todos los cursos en la página del plan de estudios actualmente activo con los períodos en los que se encuentran.';
$string['advanced_cascade_cohortsync'] = 'Sincronizar cohorte en cascada';
$string['advanced_cascade_cohortsync_desc'] = 'Agregar la inscripción sincronizada de cohortes a cada curso de este plan de estudios para todas las cohortes vinculadas a este plan de estudios';
$string['advanced_cascade_cohortsync_title'] = 'Sincronizar cohorte en cascada';
$string['advanced_confirm_header'] = 'Está seguro';
$string['advanced_converted'] = 'convertido';
$string['advanced_course_manipulation_title'] = 'Manipulación del curso';
$string['advanced_create_from_template'] = 'Crear a partir de plantilla';
$string['advanced_error'] = 'error';
$string['advanced_export'] = 'Exportar a archivo';
$string['advanced_export_csv_page'] = 'Exportar página actual como CSV';
$string['advanced_export_csv_plan'] = 'Exportar plan de estudio como CSV';
$string['advanced_failed'] = 'fallido';
$string['advanced_force_scale_button'] = 'Aplicar';
$string['advanced_force_scale_confirm'] = '¿Está seguro de querer configurar todos los calificables asociados a esta escala?';
$string['advanced_force_scale_desc'] = 'Cambiar todos los resultados calificables asociados con este plan de estudio para escalar la calificación con la escala seleccionada. Esto sólo afectará a los calificables que aún no tengan calificaciones.';
$string['advanced_force_scale_title'] = 'Forzar escalas';
$string['advanced_import_from_file'] = 'Cargar desde archivo';
$string['advanced_locked'] = 'bloqueado';
$string['advanced_multiple'] = 'múltiple';
$string['advanced_pick_scale'] = 'Elegir escala';
$string['advanced_purge'] = 'Eliminar';
$string['advanced_purge_page'] = 'Eliminar página activa';
$string['advanced_purge_page_expl'] = 'Eliminar la página del plan de estudio activo actual. Esto no se puede recuperar.';
$string['advanced_purge_plan'] = 'Eliminar TODO COMPLETO el plan de estudio';
$string['advanced_purge_plan_expl'] = 'Eliminar TODO COMPLETO el plan de estudio. Esto no se puede recuperar.';
$string['advanced_restore'] = 'Restaurar desde archivo';
$string['advanced_restore_lines'] = 'Importar contenido desde un respaldo de página de plan de estudio';
$string['advanced_restore_pages'] = 'Importar páginas desde un respaldo de plan de estudio';
$string['advanced_skipped'] = 'saltado';
$string['advanced_tools'] = 'Avanzado';
$string['advanced_tools_heading'] = 'Herramientas avanzadas';
$string['advanced_warning'] = 'Estas herramientas avanzadas deben utilizarse con el máximo cuidado. Asegúrese de saber lo que está haciendo al usarlas.';
$string['advanced_warning_title'] = 'Advertencia';
$string['aggregation_all'] = 'Completar todo';
$string['aggregation_any'] = 'Completar uno o más';
$string['aggregation_one'] = 'Lograr';
$string['aggregation_overall_all'] = 'Completar todos los siguientes para completar este curso';
$string['aggregation_overall_any'] = 'Completar uno o más de los siguientes para completar este curso';
$string['aggregation_overall_one'] = 'Completar los siguientes para completar este curso';
$string['allgraded'] = 'Todo calificado';
$string['associate_coaches'] = 'Buscar entrenadores para agregar';
$string['associate_cohorts'] = 'Buscar cohortes para agregar';
$string['associate_users'] = 'Buscar usuarios para agregar';
$string['associated_coaches'] = 'Entrenadores enlazados';
$string['associated_cohorts'] = 'Cohortes enlazados';
$string['associated_users'] = 'Usuarios enlazados';
$string['associations'] = 'Asociaciones';
$string['associations_empty'] = 'Sin asociaciones activas';
$string['associations_search'] = 'Buscar';
$string['autocohortsync_name'] = 'Sincronización automática de cohortes del plan de estudios en cascada';
$string['back'] = 'Regresar';
$string['badgedisabled'] = 'Esta insignia actualmente no está disponible';
$string['badgeinfo'] = 'Detalles de la insignia';
$string['badgeissuedstats'] = 'Emisión de progreso';
$string['badges'] = 'Insignias';
$string['badgesearchinstruction'] = 'Escribir 3 o más caracteres para buscar insignias';
$string['bistate_aggregator_desc'] = 'Los resultados se completaron o no (por ejemplo, no se iniciaron, están en progreso o reprobados). Se respaldan los resultados requeridos para su finalización. Usted puede configurar para cada plan de estudios cuántos resultados obtenidos dan como resultado una puntuación de módulo completado, bueno o excelente.';
$string['bistate_aggregator_title'] = 'Manual: Resultados completados y requeridos';
$string['cfg_grades'] = 'Configurar la calificación y la interpretación de la escala';
$string['cfg_grades_desc'] = '';
$string['cfg_grades_desc_head'] = 'Configure cómo se presentan los resultados de los resultados.';
$string['cfg_grades_grades'] = 'Configurar la interpretación de la calificación de puntos';
$string['cfg_grades_scales'] = 'Configurar la interpretación de la calificación de la escala';
$string['cfg_help'] = 'Documentación del plugin del plan de estudio';
$string['cfg_manageshares'] = 'Gestionar el uso compartido obligatorio de planes de estudio.';
$string['cfg_plans'] = 'Gestionar planes de estudio';
$string['cfg_uploadshares'] = 'Subir plan de estudios obligatorio para compartir.';
$string['choose_aggregation_style'] = 'Elegir estilo de agregación';
$string['cleanup_name'] = 'Trabajos de mantenimiento periódico de los planes de estudio';
$string['coacheditmode'] = 'Editar contenido';
$string['coaches'] = 'Entrenadores';
$string['coaching_plans'] = 'Planes de estudio de coaching';
$string['cohorts'] = 'Cohortes';
$string['competency_aggregator_desc'] = 'Usar las competencias enlazadas al curso';
$string['competency_aggregator_title'] = 'Competencias del curso';
$string['competency_details'] = 'Detalles';
$string['competency_heading'] = 'Competencia';
$string['competency_not_configured'] = 'Las competencias del curso aún no han sido configuradas.';
$string['completed'] = 'Completado';
$string['completed_fail'] = 'Reprobado';
$string['completed_pass'] = 'Aprobado';
$string['completion_completed'] = 'Completado';
$string['completion_completed_badge'] = 'Emitido';
$string['completion_excellent'] = 'Excelente';
$string['completion_failed'] = 'Reprobado';
$string['completion_good'] = 'Bueno';
$string['completion_incomplete'] = 'No iniciado';
$string['completion_incomplete_badge'] = 'No emitido';
$string['completion_not_configured'] = 'La finalización del curso aún no se ha configurado.';
$string['completion_not_enabled'] = 'La finalización no está habilitada en este curso';
$string['completion_passed'] = 'Aprobado';
$string['completion_pending'] = 'Pendiente de revisión';
$string['completion_progress'] = 'En progreso';
$string['condition_50'] = 'La mitad de las entradas necesitan ser completadas';
$string['condition_67'] = '2/3 de las entradas necesitan ser completadas';
$string['condition_all'] = 'Todas las entradas deben completarse';
$string['condition_any'] = 'Una o más entradas deben completarse';
$string['condition_default'] = 'Predeterminado para este elemento';
$string['configure_competency'] = 'Configurar competencias del curso';
$string['configure_completion'] = 'Configurar competencias del curso';
$string['confirm_cancel'] = 'Cancelar';
$string['confirm_ok'] = 'Confirmar';
$string['context'] = 'Categoría';
$string['core_aggregator_desc'] = 'Utilizar la finalización del núcleo de Moodle';
$string['core_aggregator_title'] = 'Finalización del curso Moodle';
$string['course-invalid'] = 'Error';
$string['course_period_span'] = 'Abarca';
$string['course_period_span_desc'] = 'Si el espacio inmediatamente después de este curso está libre, el curso se puede ampliar para abarcar varios períodos.';
$string['course_timing_desc'] = 'La fecha de inicio y finalización del curso no coincide con la fecha de inicio y finalización de su(s) período(s) en el plan de estudios.';
$string['course_timing_hidewarning'] = 'Ocultar esta advertencia la próxima vez';
$string['course_timing_off'] = 'El horario del curso no coincide con el del período. Haga clic aquí para corregir.';
$string['course_timing_ok'] = 'El horario del curso coincide con el horario del período';
$string['course_timing_question'] = '¿Quiere actualizar la hora de inicio y finalización del curso para que coincida con la del(los) período(s)?';
$string['course_timing_rememberchoice'] = 'Recordar mi elección para futuras desajustes de fechas';
$string['course_timing_title'] = 'El horario del curso no coincide con el horario del período';
$string['course_timing_warning'] = 'No tienes permiso para actualizar automáticamente la fecha de inicio y finalización de este curso. Actualización automática de tiempo no disponible';
$string['courses'] = 'Cursos';
$string['coursetiming_future'] = 'Curso próximo';
$string['coursetiming_past'] = 'Curso anterior';
$string['coursetiming_present'] = 'Curso actual';
$string['csvcolumnmissing'] = 'Faltan columnas obligatorias en su archivo CSV: {$a}. Revisa la ortografía de los nombres de las columnas.';
$string['currentpage'] = 'Página actualmente activa:';
$string['dateexpire'] = 'Expira en';
$string['dateissued'] = 'Emitido en';
$string['default_line_name'] = 'Cursos';
$string['default_line_shortname'] = 'Cursos';
$string['defaultaggregation'] = 'Agregación predeterminada';
$string['delete_association'] = 'Eliminar';
$string['drophere'] = 'Soltar aquí';
$string['duration'] = 'Duración';
$string['edit_plan'] = 'Editar plan de estudio';
$string['editmode_modules_hidden'] = 'Módulos ocultos en modo de edición';
$string['error'] = 'Error';
$string['error:cannotviewcategory'] = 'Error: No tiene acceso para ver esta categoría o contexto: {$a}';
$string['error:coachdisabled'] = 'La página del entrenador ha sido deshabilitada por el administrador del sistema.';
$string['error:invalid_invitekey'] = 'Necesita una invitación para ver los datos a través de este portal.';
$string['error:invitationsdisabled'] = 'En este sitio se ha desactivado compartir planes de estudio con terceros.';
$string['error:nocategoriesvisible'] = 'Error: No tiene permisos de visualización en ninguna categoría. Por lo tanto la lista de cursos permanece vacía.';
$string['error:nostudyplaneditaccess'] = 'Error: No tiene acceso para administrar planes de estudio en esta categoría o contexto: {$a}';
$string['error:nostudyplanviewaccess'] = 'Error: No tiene acceso para ver los planes de estudio en esta categoría o contexto: {$a}';
$string['error:nosuchcompetency'] = 'Advertencia: Esta competencia ya no existe';
$string['error:usernotassociated'] = 'Error: El estudiante solicitado no está asociado a este plan de estudios';
$string['flow'] = 'Flujo';
$string['grade_include'] = 'Incluye';
$string['grade_points'] = 'Puntos máximos de calificación';
$string['grade_require'] = 'Requiere';
$string['graded'] = 'Calificado';
$string['incomplete'] = 'No iniciado';
$string['individuals'] = 'Individuos';
$string['infofield_position_above'] = 'Resultados del curso de arriba';
$string['infofield_position_below'] = 'Resultados del curso de abajo';
$string['infofield_position_footer'] = 'Pie de página';
$string['infofield_position_header'] = 'Encabezado';
$string['invalid_invitekey_title'] = 'Clave de invitación requerida';
$string['invite_button_new'] = 'Nueva invitación';
$string['invite_confirm_delete'] = '¿Está seguro de que desea eliminar/revocar la invitación para {$a}?';
$string['invite_confirm_resend'] = '¿Está seguro de que desea enviar nuevamente el enlace de invitación a {$a}?';
$string['invite_date'] = 'Fecha de creación';
$string['invite_desc_edit'] = 'Editar una invitación existente';
$string['invite_desc_new'] = 'Crear una nueva invitación';
$string['invite_description'] = 'Puedes invitar a tus padres o tutores a ver tus resultados. Quienes reciban tu enlace para compartir podrán ver tus calificaciones hasta que revoques la invitación.<br>Tu institución educativa podría enviar publicaciones obligatorias hasta una fecha específica. De ser así, se indicarán aquí, pero no podrás editarlas ni eliminarlas hasta que llegue esa fecha.';
$string['invite_email'] = 'Email';
$string['invite_identifier'] = 'Marca del instituto';
$string['invite_locked_error'] = 'No puedes editar ni eliminar esta invitación porque está bloqueada.';
$string['invite_mail_managed_text'] = 'Estimado/a {$a->invitee}: Le invitamos a consultar el plan de estudios y el progreso de {$a->user}. El siguiente enlace le permite acceder en cualquier momento a los resultados más recientes. Guarde este enlace en sus favoritos. Haga clic en el siguiente enlace para ver el plan de estudios: <br> <a href="{$a->link}">{$a->link}</a></p> <p>Atentamente, La Administración</p>';
$string['invite_mail_subject'] = 'Boleta de calificación compartida de {$a->sender}';
$string['invite_mail_text'] = '<p>Estimado {$a->invitee},</p> <p>Me gustaría invitarlo a ver mi plan de estudio y mi progreso.</p> <p>El siguiente enlace le brinda acceso en cualquier momento para ver los resultados más recientes. No dudes en marcar este enlace en tu navegador.</p> <p>Haz clic en el enlace a continuación para ver el plan de estudios:<br> <a href="{$a->link}">{$a->link}</a></p> <p>Saludos cordiales, <br> {$a->sender}</p>';
$string['invite_manage_description'] = 'En esta página puede gestionar las invitaciones obligatorias a compartir planes de estudio; por ejemplo, si su organización está legalmente obligada a compartir el progreso de los estudiantes con los padres o tutores. Para adaptarse a diferentes escenarios, estas invitaciones obligatorias tienen una fecha de vencimiento. Esta puede establecerse, por ejemplo, en la mayoría de edad del estudiante. Después de la fecha de vencimiento, la invitación funciona como una invitación normal y el usuario puede editarla o eliminarla.';
$string['invite_manage_nomadatoryshares'] = 'Actualmente no hay acciones obligatorias para este usuario.';
$string['invite_manage_nouserselected'] = 'Seleccione un usuario para ver y administrar sus acciones obligatorias registradas';
$string['invite_manage_resent_msg'] = 'Se ha enviado la invitación para {$a->username} a {$a->name}&lt;{$a->email}&gt; ha sido enviada';
$string['invite_manage_selectuser'] = 'Seleccione usuario para ver comparticiones';
$string['invite_manage_tablecaption'] = 'Comparticiones obligatorias del plan de estudios';
$string['invite_name'] = 'Nombre del invitado';
$string['invite_notlocked'] = 'No bloqueado';
$string['invite_resent_msg'] = 'La invitación para {$a->name} &lt{$a->email}&gt;  ha sido enviada';
$string['invite_selectuser'] = 'Seleccionar usuario';
$string['invite_table_empty'] = 'Sin invitaciones activas';
$string['invite_tablecaption'] = 'Invitaciones activas';
$string['invite_tooltip_delete'] = 'Eliminar invitación';
$string['invite_tooltip_edit'] = 'Editar invitación';
$string['invite_tooltip_resend'] = 'Re-enviar invitación';
$string['invite_tooltip_testlink'] = 'Ver cómo son mostrados sus resultados';
$string['invite_unlock_date'] = 'Invitación bloqueada hasta';
$string['invite_unlocked'] = 'Desbloqueada';
$string['item_configuration'] = 'Configurar elemento de estudio';
$string['item_delete_message'] = '¿Está seguro de que desea eliminar el {item} {name} de la línea de estudio {line} en {period}?';
$string['line_can_enrol'] = 'Usted puede registrarse para esta línea';
$string['line_cannot_enrol'] = 'Usted NO puede registrarse a sí mismo para esta línea';
$string['line_enrol'] = 'Registrar';
$string['line_enrol_question'] = '¿Quiere registrarse usted mismo en {$a}?';
$string['line_enrol_student_question'] = '¿Quiere registrar a {$a} en esta línea?';
$string['line_enrollable:0'] = 'No se necesita registrarse';
$string['line_enrollable:1'] = 'Registro por los propios estudiantes';
$string['line_enrollable:2'] = 'Registro por usuario con rol';
$string['line_enrollable:3'] = 'Registro por los propios estudiantes o por usuario con rol';
$string['line_enrolled'] = 'Registrado';
$string['line_enrolled_in'] = 'Registrado en {$a}';
$string['line_enrollment'] = 'Registro';
$string['line_enrollments'] = 'Registros';
$string['line_is_enrolled'] = 'Usted está registrado para esta línea';
$string['line_notenrolled'] = 'No registrado';
$string['line_unenrol'] = 'Des-registrar';
$string['line_unenrol_student_question'] = '¿Quieres quitar el registro de {$a} de esta línea?';
$string['link_coach'] = 'Planes de estudio de coaching';
$string['link_editplan'] = 'Administrar planes de estudio';
$string['link_myreport'] = 'Mi plan de estudio';
$string['link_studyplans'] = 'Planes de estudio';
$string['link_viewplan'] = 'Planes de estudio';
$string['manage_invites'] = 'Compartir acceso a plan de estudio';
$string['min_completed'] = 'Umbral de finalización';
$string['min_progress'] = 'Umbral de progreso';
$string['myreport_teachermode'] = 'Planes de estudio que yo estoy enseñando';
$string['name'] = 'Nombre';
$string['nav_invited'] = 'Ver plan de estudio por invitación';
$string['no_form_data'] = 'La información proporcionada era incorrecta. Es probable que usted haya cargado un ícono en un formato no compatible. Por favor verifique sus datos de entrada y vuelva a intentarlo.';
$string['no_templates'] = 'No hay plantillas disponibles Marcar un plan de estudio como plantilla para habilitar la creación basada en plantillas.';
$string['noenddate'] = 'En progreso';
$string['nogrades'] = 'Sin calificaciones';
$string['not_enrolled'] = 'No inscrito';
$string['open'] = 'Abrir';
$string['overall'] = 'Curso';
$string['overviewreport:all'] = 'Resumen del resultado';
$string['overviewreport:period'] = 'Resumen del resultado para este período';
$string['period'] = 'Período';
$string['period_default_fullname'] = 'Período {$a}';
$string['period_default_shortname'] = 'P{$a}';
$string['period_edit'] = 'Cambiar detalles del período';
$string['periods'] = 'Períodos';
$string['pluginname'] = 'Planes de estudio';
$string['privacy:metadata'] = 'Este plugin almacena un enlace entre los usuarios y sus planes de estudio asociados. También es necesario almacenar una dirección de correo electrónico y un identificador proporcionado por el usuario, que puede ser un nombre, para enviar invitaciones para ver el plan de estudio a quien el usuario elija por correo electrónico.';
$string['privacy:metadata:coach'] = 'Vincula a un usuario como entrenador a un plan de estudios';
$string['privacy:metadata:coach:studyplan_id'] = 'El plan de estudio';
$string['privacy:metadata:coach:user_id'] = 'El UserID del usuario';
$string['privacy:metadata:invit'] = 'Las invitaciones actualmente activas para ver el plan de estudios';
$string['privacy:metadata:invit:date'] = 'Fecha en que se creó la invitación';
$string['privacy:metadata:invit:email'] = 'Dirección de correo electrónico del destinatario de la invitación';
$string['privacy:metadata:invit:identifier'] = 'Marca proporcionada por el instituto educativo para esta invitación';
$string['privacy:metadata:invit:name'] = 'Nombre/Identificador ingresado por el usuario para el destinatario de las invitaciones';
$string['privacy:metadata:invit:unlockdate'] = 'Si se proporciona, el usuario no podrá editar ni eliminar la invitación hasta este momento.';
$string['privacy:metadata:invit:user_id'] = 'ID de usuario del usuario que compartió su plan de estudios';
$string['privacy:metadata:lineuser'] = 'Registra a un usuario como inscrito en una línea dentro de un plan de estudios.';
$string['privacy:metadata:lineuser:enrolled'] = 'Si el usuario está registrado o no';
$string['privacy:metadata:lineuser:enrolledby'] = 'ID de usuario opcional de otro usuario que registró al usuario en esta línea';
$string['privacy:metadata:lineuser:line_id'] = 'La línea de estudio en la que está inscrito el usuario (o no)';
$string['privacy:metadata:lineuser:timeenrolled'] = 'El momento de la inscripción';
$string['privacy:metadata:lineuser:user_id'] = 'El ID de usuario del usuario';
$string['privacy:metadata:teachers'] = 'Tabla en caché para vincular a los profesores con los planes de estudio';
$string['privacy:metadata:teachers:studyplan_id'] = 'El plan de estudios en el que el profesor imparte al menos un curso';
$string['privacy:metadata:teachers:teacher_id'] = 'El ID de usuario del profesor';
$string['privacy:metadata:user'] = 'Vínculos entre usuarios individuales y planes de estudio';
$string['privacy:metadata:user:studyplan_id'] = 'El plan de estudio';
$string['privacy:metadata:user:user_id'] = 'El ID de usuario del usuario';
$string['refreshteacherlist_name'] = 'Actualizar la lista del plan de estudio del profesor';
$string['report'] = 'Reporte del progreso';
$string['report_index'] = 'Ver reporte del progreso del estudiante';
$string['report_invited'] = 'Reporte del progreso para {$a}';
$string['required'] = 'Requerido';
$string['required_goal'] = 'Resultado requerido';
$string['result'] = 'Resultado';
$string['results'] = 'Resultados';
$string['search'] = 'Buscar';
$string['select_conditions'] = 'Condición de finalización';
$string['select_grades'] = 'Calificaciones incluidas en el reporte';
$string['select_scaleitem'] = 'Elegir...';
$string['selected'] = 'Seleccionar';
$string['selectstudent'] = 'Elegir estudiante';
$string['selectstudent_btn'] = 'Seleccionar vista';
$string['selectstudent_details'] = 'Seleccione un estudiante de la lista a continuación para ver su progreso en este plan de estudios.';
$string['send'] = 'Enviar';
$string['setting_aggregation_mode'] = 'Estilo predeterminado de agregación';
$string['setting_bistate_accept_pending_submitted'] = 'Aceptar el resultado enviado pero no calificado como "progreso"';
$string['setting_bistate_heading'] = 'Valores predeterminados para los resultados Completados + Requeridos';
$string['setting_bistate_support_failed'] = 'Soportar resultado "Reprobado"';
$string['setting_bistate_thresh_completed'] = 'Umbral para finalizado (%)';
$string['setting_bistate_thresh_excellent'] = 'Umbral para excelente(%)';
$string['setting_bistate_thresh_good'] = 'Umbral para bueno (%)';
$string['setting_bistate_thresh_progress'] = 'Umbral para progreso (%)';
$string['setting_competency_detailfield'] = 'Campo de detalle de competencia';
$string['setting_competency_displayname'] = 'Título mostrado de competencia';
$string['setting_competency_heading'] = 'Predeterminados para competencias del curso';
$string['setting_competency_support_failed'] = 'Soportar resultado "Reprobado"';
$string['setting_competency_thresh_completed'] = 'Umbral para completado (%)';
$string['setting_continueperiodnumberingnewpage'] = 'Continuar numeración del período en página nueva';
$string['setting_copystudylinesnewpage'] = 'Copiar líneas de estudio de última página a nueva página';
$string['setting_courseprogressbar'] = 'Mostrar barra de progreso en curso';
$string['setting_csync_autoremove_field'] = 'Eliminación automática';
$string['setting_csync_creategroup_field'] = 'Crear grupos';
$string['setting_csync_enable_field'] = 'Sincronización automática de cohortes';
$string['setting_csync_heading'] = 'Crear automáticamente una sincronización de cohorte en todos los cursos vinculados a un plan de estudios para todas las cohortes vinculadas a un plan de estudios.';
$string['setting_csync_remember_manual_csync_field'] = 'Recordar sincronizaciones existentes de cohortes';
$string['setting_csync_role_field'] = 'Rol';
$string['setting_csync_users_field'] = 'Inscribir usuarios enlazados';
$string['setting_defaulticon'] = 'Imagen predeterminada de plan de estudio';
$string['setting_display_field'] = 'Nombre de curso a mostrar';
$string['setting_display_heading'] = 'Mostrar';
$string['setting_enablecoach'] = 'Habilitar rol de entrenador';
$string['setting_enableplansharing'] = 'Habilitar compartir plan de estudio';
$string['setting_feature_heading'] = 'Características';
$string['setting_hivizdropslots'] = 'Campos de caída de alta visibilidad';
$string['setting_infofield1_field'] = 'Añadir detalles del curso desde el campo (1)';
$string['setting_infofield1_position'] = 'Posición del campo de información del curso (1)';
$string['setting_infofield1_title'] = 'Título para los detalles del curso del campo (1).';
$string['setting_infofield2_field'] = 'Añadir detalles del curso desde el campo (2)';
$string['setting_infofield2_position'] = 'Posición del campo de información del curso (2)';
$string['setting_infofield2_title'] = 'Título para los detalles del curso del campo (2).';
$string['setting_infofield3_field'] = 'Añadir detalles del curso desde el campo (3)';
$string['setting_infofield3_position'] = 'Posición del campo de información del curso (3)';
$string['setting_infofield3_title'] = 'Título para los detalles del curso del campo (3).';
$string['setting_infofield4_field'] = 'Añadir detalles del curso desde el campo (4)';
$string['setting_infofield4_position'] = 'Posición del campo de información del curso (4)';
$string['setting_infofield4_title'] = 'Título para los detalles del curso del campo (4).';
$string['setting_infofield5_field'] = 'Añadir detalles del curso desde el campo (5)';
$string['setting_infofield5_position'] = 'Posición del campo de información del curso (5)';
$string['setting_infofield5_title'] = 'Título para los detalles del curso del campo (5).';
$string['setting_infofields_heading'] = 'Campos de información extra del curso';
$string['setting_limitcourselist'] = 'Limitar la lista de cursos a la categoría del plan de estudios';
$string['setting_primary_nav_combine'] = 'Combinar enlaces al menú de navegación primario debajo de uno desplegable';
$string['setting_primary_nav_items'] = 'Añadir enlaces a Plan de estudios al menú de navegación primario';
$string['setting_showprevnextarrows'] = 'Mostrar flechas junto a los menús desplegables del selector de estudiantes';
$string['setting_timelessperiods'] = 'Periodos y páginas atemporales';
$string['setting_toolboxcoursesonly'] = 'Mostrar solo los cursos en la caja de herramientas';
$string['setting_toolboxleft'] = 'Barra de herramientas del lado izquierdo de forma predeterminada';
$string['settingdesc_aggregation_mode'] = 'Elegir un estilo de agregación predeterminado para los nuevos planes de estudio';
$string['settingdesc_bistate_accept_pending_submitted'] = 'Si está habilitado, los resultados enviados pero no calificados seguirán contando para el progreso. Si está deshabilitado, solo contarán los resultados calificados';
$string['settingdesc_bistate_heading'] = 'Establecer los valores predeterminados para este método de agregación';
$string['settingdesc_bistate_support_failed'] = 'Cuando haya pasado la fecha de finalización del curso, marcar el curso como "Reprobado" en lugar de "Progreso"';
$string['settingdesc_bistate_thresh_completed'] = 'Porcentaje mínimo de resultados completados para el resultado "Completado"';
$string['settingdesc_bistate_thresh_excellent'] = 'Porcentaje mínimo de resultados completados para obtener el resultado "Excelente"';
$string['settingdesc_bistate_thresh_good'] = 'Porcentaje mínimo de resultados completados para obtener el resultado "Bueno"';
$string['settingdesc_bistate_thresh_progress'] = 'Porcentaje mínimo de resultados que no se deben reprobar para calificar para el resultado de progreso. <br><strong>Solo es relevante si se soiportan resultados "Reprobado"</strong>';
$string['settingdesc_competency_detailfield'] = 'El campo de competencia utilizado para los detalles de la competencia';
$string['settingdesc_competency_displayname'] = 'El campo de competencia utilizado como título en el plan de estudios';
$string['settingdesc_competency_heading'] = 'Establecer los valores predeterminados para este método de agregación';
$string['settingdesc_competency_support_failed'] = 'Cuando haya pasado la fecha de finalización del curso, marcar el curso como "Reprobado" en lugar de "Progreso"';
$string['settingdesc_competency_thresh_completed'] = 'Porcentaje mínimo de competencias competentes para el resultado “Completado”';
$string['settingdesc_continueperiodnumberingnewpage'] = 'Al crear una nueva página, el nombre predeterminado de los períodos continuará la secuencia existente (por ejemplo, P5, P6, P7, P8) en lugar de iniciar una nueva secuencia (P1, P2, P3, P4)';
$string['settingdesc_copystudylinesnewpage'] = 'Al crear una nueva página, llenarla con una copia vacía de las líneas de estudio de la página anterior.';
$string['settingdesc_courseprogressbar'] = 'Mostrar una barra de progreso en la ventana emergente del curso.';
$string['settingdesc_csync_autoremove_field'] = 'Eliminar la sincronización de los cursos una vez que una cohorte se elimina del plan de estudios.';
$string['settingdesc_csync_creategroup_field'] = 'Crea un grupo en el curso para cada sincronización de cohorte.';
$string['settingdesc_csync_enable_field'] = 'Habilitar sincronización automática de cohorte.';
$string['settingdesc_csync_heading'] = '';
$string['settingdesc_csync_remember_manual_csync_field'] = 'Marcar las sincronizaciones de cohortes que se crearon manualmente anteriormente, para que no se eliminen durante la sincronización automática si las cohortes se eliminan del plan de estudio.';
$string['settingdesc_csync_role_field'] = 'El rol a utilizar para la inscripción automática a la sincronización de cohortes creada en los cursos.';
$string['settingdesc_csync_users_field'] = 'Inscribir también a todos los usuarios que estén vinculados explícitamente a un plan de estudios en los cursos de ese plan de estudios.';
$string['settingdesc_defaulticon'] = 'Configurar la imagen predeterminada para mostrar en los planes de estudio si no se establece ninguna imagen específica.';
$string['settingdesc_display_field'] = 'Seleccione el campo que se utilizará para el nombre para mostrar de un curso en el plan de estudios.';
$string['settingdesc_display_heading'] = 'Configuración de visualización del plan de estudio.';
$string['settingdesc_enablecoach'] = 'El rol de entrenador permite que un entrenador tenga acceso específico a un plan de estudio con acceso limitado para modificarlo.';
$string['settingdesc_enableplansharing'] = 'Permitir que los estudiantes compartan el acceso al plan de estudio con otros a través de un enlace único.';
$string['settingdesc_feature_heading'] = 'Configurar las características del plan de estudio.';
$string['settingdesc_hivizdropslots'] = 'Otorgar visibilidad adicional a los campos desplegables al editar un plan de estudio.';
$string['settingdesc_infofield1_field'] = 'Campo de información a mostrar';
$string['settingdesc_infofield1_position'] = 'Dónde colocar este campo de información en la pantalla emergente del curso';
$string['settingdesc_infofield1_title'] = 'Título para el campo de información del curso. Una línea por idioma. Termine con "|<langcode>" para localizar. Dejar en blanco para no establecer ningún título';
$string['settingdesc_infofield2_field'] = 'Campo de información a mostrar';
$string['settingdesc_infofield2_position'] = 'Dónde colocar este campo de información en la pantalla emergente del curso';
$string['settingdesc_infofield2_title'] = 'Título para el campo de información del curso. Una línea por idioma. Termine con "|<langcode>" para localizar. Dejar en blanco para no establecer ningún título';
$string['settingdesc_infofield3_field'] = 'Campo de información a mostrar';
$string['settingdesc_infofield3_position'] = 'Dónde colocar este campo de información en la pantalla emergente del curso';
$string['settingdesc_infofield3_title'] = 'Título para el campo de información del curso. Una línea por idioma. Termine con "|<langcode>" para localizar. Dejar en blanco para no establecer ningún título';
$string['settingdesc_infofield4_field'] = 'Campo de información a mostrar';
$string['settingdesc_infofield4_position'] = 'Dónde colocar este campo de información en la pantalla emergente del curso';
$string['settingdesc_infofield4_title'] = 'Título para el campo de información del curso. Una línea por idioma. Termine con "|<langcode>" para localizar. Dejar en blanco para no establecer ningún título';
$string['settingdesc_infofield5_field'] = 'Campo de información a mostrar';
$string['settingdesc_infofield5_position'] = 'Dónde colocar este campo de información en la pantalla emergente del curso';
$string['settingdesc_infofield5_title'] = 'Título para el campo de información del curso. Una línea por idioma. Termine con "|<langcode>" para localizar. Dejar en blanco para no establecer ningún título';
$string['settingdesc_infofields_heading'] = 'Seleccione hasta 5 campos o campos personalizados para agregar a la ventana emergente del curso.';
$string['settingdesc_limitcourselist'] = 'Limitar la lista de cursos disponibles para un plan de estudios a la categoría en la que se encuentra el plan de estudios.';
$string['settingdesc_primary_nav_combine'] = 'Combinar todos los enlaces disponibles de navegación primaria para el plugin de Plan de estudios debajo de un elemento desplegable, si hubiera varios enlaces';
$string['settingdesc_primary_nav_items'] = 'Añadir enlaces para el Plan de estudio al menú primario. Tenga en cuenta que si usted deshabilita esto, tendrá que añadir sus propios enlaces a las páginas del Plan de estudio.';
$string['settingdesc_showprevnextarrows'] = 'Mostrar flechas para el estudiante anterior y siguiente en el selector de estudiantes en el modo de entrenamiento y visualización.';
$string['settingdesc_timelessperiods'] = 'No incluya información de tiempo en períodos o páginas.';
$string['settingdesc_toolboxcoursesonly'] = 'Oculte las insignias y las pestañas de flujo en la caja de herramientas y mostrar solo los cursos.';
$string['settingdesc_toolboxleft'] = 'Mostrar la barra de herramientas del curso y del componente en el lado izquierdo de forma predeterminada, en lugar del lado derecho de la pantalla.';
$string['settingspage'] = 'Configuraciones del plan de estudio';
$string['settingspage_csync'] = 'Sincronizar cohortes y usuarios vinculados a los cursos';
$string['share_badge'] = 'Compartir insignia';
$string['share_report'] = 'Compartir';
$string['showoverview'] = 'Vista del profesor';
$string['student_from_plan_enrolled'] = 'El estudiante de este plan de estudios está inscrito en el curso';
$string['student_not_tracked'] = 'No inscrito en este curso';
$string['students_from_plan_enrolled'] = 'Los estudiantes de este plan de estudios están inscritos en el curso';
$string['studyitem_confirm_remove'] = '¿Está seguro de que desea eliminar el módulo {$a}?';
$string['studyline_add'] = 'Añadir línea de estudio';
$string['studyline_color'] = 'Color del fondo';
$string['studyline_confirm_remove'] = '¿Está seguro de que desea eliminar la línea de estudio {$a}?';
$string['studyline_edit'] = 'Editar línea de estudio';
$string['studyline_editmode'] = 'Editar líneas de estudio';
$string['studyline_enrollable'] = 'Registro';
$string['studyline_enrolroles'] = 'Roles permitidos';
$string['studyline_name'] = 'Nombre completo';
$string['studyline_name_ph'] = '';
$string['studyline_remove'] = 'Eliminar línea de estudio';
$string['studyline_shortname'] = 'Nombre corto';
$string['studyline_shortname_ph'] = '';
$string['studyplan_add'] = 'Añadir plan de estudio';
$string['studyplan_confirm_remove'] = '¿Está seguro de que desea eliminar la página del plan de estudios {$a}?';
$string['studyplan_context'] = 'Categoría';
$string['studyplan_description'] = 'Descripción';
$string['studyplan_description_ph'] = '';
$string['studyplan_details'] = 'Acerca de';
$string['studyplan_duration'] = 'Duración';
$string['studyplan_edit'] = 'editar plan de estudio';
$string['studyplan_emptytemplate'] = 'Plan de estudio vacío';
$string['studyplan_enddate'] = 'Fin del plan de estudio';
$string['studyplan_fromtemplate'] = 'Basado en plantilla';
$string['studyplan_future'] = 'Planes de estudio próximos';
$string['studyplan_icon'] = 'Imagen para este plan de estudio';
$string['studyplan_idnumber'] = 'Número ID';
$string['studyplan_idnumber_ph'] = '';
$string['studyplan_name'] = 'Nombre completo';
$string['studyplan_name_ph'] = '';
$string['studyplan_noneselected'] = 'Elegir un plan de estudio';
$string['studyplan_past'] = 'Panes de estudio anteriores';
$string['studyplan_periods'] = 'Número de períodos en plan';
$string['studyplan_present'] = 'Planes de estudio actuales';
$string['studyplan_remove'] = 'Quitar plan de estudio';
$string['studyplan_report'] = 'Vista resumida de resultado de plan de estudio';
$string['studyplan_select'] = 'Plan de estudio:';
$string['studyplan_select_placeholder'] = 'Seleccionar plan de estudio';
$string['studyplan_shortname'] = 'Nombre corto';
$string['studyplan_shortname_ph'] = '';
$string['studyplan_slots'] = 'Número de columnas en plan';
$string['studyplan_startdate'] = 'Fecha de inicio del plan';
$string['studyplan_suspend'] = 'Suspender plan de estudio';
$string['studyplan_suspend_details'] = 'Suspender el plan de estudios para todos excepto los administradores encargados del plan de estudios';
$string['studyplan_template'] = 'Marcar como plantilla';
$string['studyplan_template_details'] = 'Marcar este plan de estudio como una posible plantilla para nuevos planes de estudio';
$string['studyplanpage'] = 'Página de plan de estudio';
$string['studyplanpage_add'] = 'Añadir página de plan de estudio';
$string['studyplanpage_confirm_remove'] = '¿Está seguro de que desea eliminar la página del plan de estudios {$a}?';
$string['studyplanpage_edit'] = 'Editar página de plan de estudio';
$string['studyplanpage_info_periodsextended'] = 'Advertencia: Usted ha añadido periodos a la página del plan de estudios. Estos nuevos períodos han generado automáticamente períodos de tiempo que pueden estar fuera del tiempo de finalización designado en esta página. Por favor verifique las horas de inicio y finalización correctas para cada período.';
$string['studyplanpage_remove'] = 'Quitar página de plan de estudio';
$string['suspended'] = 'Suspendido';
$string['tool-badge'] = 'Insignia';
$string['tool-finish'] = 'Terminar';
$string['tool-junction'] = 'Unión';
$string['tool-start'] = 'Iniciar/continuar';
$string['toolbar-right'] = 'Mostrar esta barra a la derecha';
$string['toolbox'] = 'Componentes';
$string['toolbox_toggle'] = 'Insertar componentes y cursos';
$string['treestudyplan:coach'] = 'Disponible como entrenador';
$string['treestudyplan:configure'] = 'Configurar planes de estudio';
$string['treestudyplan:editstudyplan'] = 'Administrar planes de estudio';
$string['treestudyplan:forcescales'] = 'Avanzado: Permitir que el administrador del plan de estudio fuerce las escalas de asignación según la configuración (solo en modos manuales)';
$string['treestudyplan:lineunenrol'] = 'Administrar la inscripción de alumnos en filas';
$string['treestudyplan:manageshares'] = 'Gestionar el uso compartido obligatorio del plan de estudios';
$string['treestudyplan:selectowngradables'] = 'Los profesores pueden seleccionar calificables en sus propios cursos en el modo de vista del plan de estudio (solo modos manuales)';
$string['treestudyplan:viewuserreports'] = 'Ver plan de estudios de otros';
$string['tristate_aggregator_desc'] = 'Los resultados se califican como progreso, completado y excelente. Los módulos se pueden configurar para requerir una cantidad específica de resultados completados';
$string['tristate_aggregator_title'] = 'Manual: Progreso/Completado/Excelente Clásico';
$string['ungraded'] = 'Necesita calificarse';
$string['unknown'] = 'Estado de calificación desconocido';
$string['unrated'] = 'No valorado';
$string['unsubmitted'] = 'Sin envío';
$string['uploadshares'] = 'Subir comparticiones obligatorias del plan de estudios';
$string['uploadshares_created'] = 'Número de comparticiones creadas: {$a}';
$string['uploadshares_errors'] = 'Número de errores: {$a}';
$string['uploadshares_help'] = 'Suba aquí un archivo CSV con las comparticiones obligatorias del plan de estudios. El archivo CSV debe contener las siguientes columnas: <ul><li><b>userid</b> ID de usuario del usuario para el que se añadirá la compartición.</li><li><b>invitename</b> Nombre o cargo del destinatario de la compartición.</li><li><b>inviteemail</b> Correo electrónico del destinatario de la compartición.</li><li><b>unlockdate</b> Fecha en la que se desbloquea la acción, que el usuario puede modificar o eliminar.</li><li><b>identifier</b> (opcional) <i>(opcional)</i> Etiqueta de identificación opcional para esta compartición.</li>';
$string['uploadshares_result:created'] = 'Creada';
$string['uploadshares_result:dateinvalid'] = 'Formato inválido de fecha';
$string['uploadshares_result:datepast'] = 'Desbloquear fecha en el pasado.';
$string['uploadshares_result:emailinvalid'] = 'Dirección inválida de Email';
$string['uploadshares_result:exists'] = 'Ya existe';
$string['uploadshares_result:updated'] = 'Actualizado';
$string['uploadshares_result:usernotfound'] = 'Usuario no encontrado';
$string['uploadshares_results'] = 'Subir resultados de comparticiones obligatorias';
$string['uploadshares_skipped'] = 'Número de líneas omitidas: {$a}';
$string['uploadshares_total'] = 'Número de líneas manejadas: {$a}';
$string['uploadshares_updated'] = 'Número de comparticiones actualizadas: {$a}';
$string['users'] = 'Usuarios';
$string['view_completion_report'] = 'Ver informe detallado de finalización del curso';
$string['view_feedback'] = 'Ver retroalimentación';
$string['view_plan'] = 'Ver planes de estudio';
$string['warning_incomplete_nograderq'] = 'Debido a que la calificación no está marcada como un requisito, su calificación aprobatoria no registra la finalización.';
$string['warning_incomplete_pass'] = 'La calificación aprobatoria no es suficiente para completar la tarea, verifique los criterios de finalización.';
$string['when'] = 'cuando';
