<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'publication', language 'es_mx', version '5.0'.
 *
 * @package     publication
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add_uploads'] = 'Añadir archivos';
$string['allfiles'] = 'Envíos de archivo';
$string['allowedfiletypes'] = 'Tipos de archivo aceptados';
$string['allowedfiletypes_err'] = '¡ Revise lo que puso! Extensión de archivo o separadores inválidos';
$string['allowedfiletypes_help'] = 'Los tipos de archivo aceptados pueden ser restringidos al ingresar una lista separada por comas de mimetypes, como por ejemplo \'video/mp4, audio/mp3, image/png, image/jpeg\', o extensiones de archivo incluyendo el punto, como por ejemplo \'.png, .jpg\'. Si el campo se deja vacío, entonces todos los tipos de archivo están permitidos.';
$string['allowsubmissionsanddescriptionfromdatesummary'] = 'Los detalles de la tarea y el formato para envío estarán disponibles en <strong>{$a}</strong>';
$string['allowsubmissionsfromdate'] = 'A partir de';
$string['allowsubmissionsfromdate_help'] = 'Si esta opción está habilitada, los participantes no pueden enviar sus archivos antes de esta fecha. Si la opción está deshabilitada, los participantes pueden comenzar a enviar archivos de inmediato.';
$string['allowsubmissionsfromdate_import'] = 'Aprobación a partir de';
$string['allowsubmissionsfromdate_upload'] = 'Subir a partir de';
$string['allowsubmissionsfromdatesummary'] = 'Esta Tarea aceptará envíos a partir de <strong>{$a}</strong>';
$string['alwaysshowdescription'] = 'Siempre  mostrar descripción';
$string['alwaysshowdescription_help'] = 'Si está deshabilitada, la descripción de la tarea anterior solo será visible para los estudiantes en la fecha de "Subida/Aprobación desde".';
$string['approval_required'] = 'Decisión pendiente';
$string['approval_timeover'] = 'Usted solamente puede cambiar su consentimiento durante el período de edición.';
$string['approvalchange'] = 'Estado de publicación cambiado';
$string['approvalfromdate'] = 'Aprobación a partir de';
$string['approvalfromdate_help'] = 'El estado de aprobación NO puede ser cambiado antes de esta fecha. Esta configuración solo es relevante cuando la aprobación de Estudiante o de Grupo no sea automática.';
$string['approvalsettings'] = 'Configuraciones de publicación';
$string['approvaltodate'] = 'Aprobación hasta';
$string['approvaltodate_help'] = 'El estado de aprobación NO puede ser cambiado después de esta fecha. Esta configuración solo es relevante cuando la aprobación de Estudiante o de Grupo no sea automática.';
$string['approvaltodatevalidation'] = 'La fecha de aprobación hasta cierta fecha debe ser después d ela fecha de aprobación a partir de.';
$string['approved'] = 'Aprobado';
$string['approveusers'] = 'Dar aprobación';
$string['assignment'] = 'Tarea';
$string['assignment_help'] = 'Elija la tarea para importar archivos desde envíos individuales o de grupo.';
$string['assignment_notfound'] = 'La tarea desde la cual fueron importados los archivos, ya no pudo encontrarse.';
$string['assignment_notset'] = 'No se han elegido Tareas.';
$string['availability'] = 'Período de edición (subir o aprobar)';
$string['availabilityrestriction'] = 'Aplicar restricciones de disponibilidad a la lista de usuarios';
$string['availabilityrestriction_admin'] = 'Configuración predeterminada para restricciones de disponibilidad para la lista de usuarios';
$string['availabilityrestriction_admin_desc'] = 'Los usuarios que no puedan acceder a la actividad debido a restricciones de disponibilidad serán eliminados de la lista.<br>Esto solo incluye las condiciones que están marcadas como aplicadas a las listas de usuarios. Por ejemplo, se incluyen las condiciones de grupo, pero no las condiciones de fecha.';
$string['availabilityrestriction_help'] = 'Los usuarios que no puedan acceder a la actividad debido a restricciones de disponibilidad serán eliminados de la lista.<br>Esto solo incluye las condiciones que están marcadas como aplicadas a las listas de usuarios. Por ejemplo, se incluyen las condiciones de grupo, pero no las condiciones de fecha.';
$string['choose'] = 'Elija por favor...';
$string['completiondetail:upload'] = 'Subir un archivo';
$string['completionupload'] = 'El estudiante debe subir un archivo';
$string['configautoimport'] = 'Si Usted prefiere que los envíos de los estudiantes sean importados automáticamente dentro de las instancias de carpeta del estudiante. Esta característica puede ser habilitada/deshabilitada para cada instancia de carpeta del estudiante en forma separada.';
$string['configmaxbytes'] = 'Tamaño máximo por defecto para todos los archivos en la carpeta del estudiante.';
$string['configmaxfiles'] = 'Número máximo por defecto de anexos permitidos por usuario.';
$string['courseuploadlimit'] = 'Límite de subidas del curso';
$string['currentlynotapproved'] = '* Actualmente no-aprobado o rechazado para publicación..';
$string['cutoffdate'] = 'Fecha límite';
$string['cutoffdate_help'] = 'Si se configura, las tareas no aceptarán envíos después de esta fecha si no hubiera una extensión.';
$string['cutoffdate_import'] = 'Última aprobación hasta';
$string['cutoffdate_upload'] = 'Última subida hasta';
$string['cutoffdatefromdatevalidation'] = 'La fecha de corte debe ser posterior a la fecha de "permitir envíos a partir de".';
$string['cutoffdatevalidation'] = 'La fecha de corte no puede ser antes de la fecha esperada.';
$string['details'] = 'Detalles';
$string['downloadall'] = 'Descargar todos los envíos de archivos';
$string['duedate'] = 'Hasta';
$string['duedate_help'] = 'ESi esta opción está habilitada, los participantes no podrán enviar sus archivos después de esta fecha. Si la opción está deshabilitada, los participantes podrán enviarlos para siempre.';
$string['duedate_import'] = 'Probar para';
$string['duedate_upload'] = 'Subir a';
$string['duedatevalidation'] = 'La fehca esperada debe ser despues de la fecha de "permitir envíos después de ".';
$string['edit_timeover'] = 'Los archivos solamente pueden ser editados dentro del período de edición.';
$string['edit_uploads'] = 'Subir/editar archivos';
$string['email:filechange:footer'] = '</ul><br />or favor compruebe si su permiso para publicación es requerido.';
$string['email:filechange_import:header'] = 'Lo siguientes archivos de la Tarea <b>\'{$a->assign}\'</b> fueron importados dentro de <b>\'{$a->publication}\'</b> en {$a->dayupdated} a las {$a->timeupdated}:<br /><ul>';
$string['email:filechange_import:subject'] = 'Archivo(s) importado(s)';
$string['email:filechange_upload:header'] = '<b>{$a->username}</b> ha subido los siguienets archivos a  <b>\'{$a->publication}\'</b> en {$a->dayupdated} a las {$a->timeupdated}:<br /><ul>';
$string['email:filechange_upload:subject'] = 'Archivo(s) subido(s)';
$string['email:statuschange:filename'] = '<li>\'{$a->filename}\' a \'<b>{$a->apstatus}</b>\'</li>';
$string['email:statuschange:footer'] = '</ul>';
$string['email:statuschange:header'] = 'El estado de publicación de lso archivos siguientes <b>\'{$a->publication}\'</b> fue cambiado en {$a->dayupdated} a las {$a->timeupdated} por <b>{$a->username}</b>:<br /><ul>';
$string['email:statuschange:subject'] = 'Estado de publicación cambiado';
$string['entiresperpage'] = 'Participantes mostrados por página';
$string['eventoverridecreated'] = 'Anulación de publicación creada';
$string['eventoverridedeleted'] = 'Anulación de publicación eliminada';
$string['eventoverrideupdated'] = 'Anulación de publicación actualizada';
$string['eventpublicationapprovalchanged'] = 'Aprobación de archivo de publicación cambiada';
$string['eventpublicationduedateextended'] = 'Fecha esperada de publicación  extendida';
$string['eventpublicationfiledeleted'] = 'Archivo de publicación eliminado';
$string['eventpublicationfileimported'] = 'Archivo de publicación importado';
$string['eventpublicationfileuploaded'] = 'Archivo de publicación subido';
$string['extensionduedate'] = 'Extensión de fecha esperada';
$string['extensionnotafterduedate'] = 'La extensión de fecha esperada debe ser después de la fecha esperada.';
$string['extensionnotafterfromdate'] = 'La extensión de fecha esperada debe ser después de la fecha a partir de la cual se permiten los envíos';
$string['extensionto'] = 'Extensión para';
$string['filedetails'] = 'Detalles';
$string['filesofthesetypes'] = 'Pueden añadirse archivos de estos tipos:';
$string['filter'] = 'Filtro';
$string['filter:allfiles'] = 'Todos los envíos de archivo';
$string['filter:approvalrequired'] = 'Decisión pendiente';
$string['filter:approved'] = 'Envíos de archivo aprobados';
$string['filter:nofiles'] = 'Sin envío de archivos';
$string['filter:nofilter'] = 'Sin filtro';
$string['filter:rejected'] = 'Envíos de archivo rechazados';
$string['giveapproval'] = 'Dar aprobación';
$string['go'] = 'Ir';
$string['grantextension'] = 'Otorgar extensión';
$string['group_approved'] = 'Aprobado por todos los miembros del grupo.';
$string['guideline'] = 'Publicación de envíos de archivo';
$string['hidden'] = 'No publicado';
$string['importfrom_err'] = 'Usted tiene que elegir una tarea desde donde desea importar envíos de archivo.';
$string['maxbytes'] = 'Tamaño máximo de anexo';
$string['maxbytes_help'] = 'Archivos subidos por estudiantes pueden ser hasta de este tamaño.';
$string['maxfiles'] = 'Número máximo de anexos';
$string['maxfiles_help'] = 'Cada estudiante podrá subir hasta este número de archivos para su envío.';
$string['messageprovider:publication_updates'] = 'Notificaciones de publicación';
$string['mode'] = 'Modo';
$string['mode_help'] = 'Elija si es que los estudiantes pueden subir documentos aquí o si su envío de una tarea deberá de ser importado.';
$string['modeimport'] = 'Importar archivos desde una actividad de Tarea';
$string['modeupload'] = 'Subir archivos directamente en la actividad actual';
$string['modulename'] = 'Carpeta del estudiante';
$string['modulename_help'] = 'La carpeta de estudiantes ofrece las siguientes funciones:<br><ul><li>Los estudiantes pueden cargar archivos o importarlos desde una actividad de tarea.</li><li>Los archivos se publicarán (se harán visibles para todos) automáticamente o después de que los estudiantes o profesores aprueben su publicación.</li><li>Los estudiantes o profesores recibirán una notificación cuando carguen o modifiquen un archivo, o cuando se importe o actualice un archivo desde una actividad de tarea. Además, los estudiantes o profesores recibirán una notificación sobre cualquier cambio en el estado de publicación.</li></ul>';
$string['modulenameplural'] = 'Carpetas de estudiantes';
$string['myfiles'] = 'Archivos propios';
$string['mygroupfiles'] = 'Mis archivos del grupo';
$string['name'] = 'Nombre';
$string['noentries'] = 'Sin entradas';
$string['nofiles'] = 'Sin archivos disponibles';
$string['nofilestodisplay'] = 'Actualmente no hay archivos disponibles o aun no publicados.';
$string['nofilestozip'] = 'Sin archivos para comprimir en ZIP';
$string['nonexistentfiletypes'] = 'Los siguientes tipos de archivos no fueron reconocidos: {$a}';
$string['nopublicationsincourse'] = 'No hay instancia de carpeta de estudiante en este curso.';
$string['nothing_to_show_groups'] = 'Nada para mostrar - sin grupos disponibles';
$string['nothing_to_show_users'] = 'Nada para mostrar - sin estudiantes disponibles';
$string['nothingtodisplay'] = 'No hay entradas para mostrar';
$string['notice'] = '<strong>Aviso: </strong>';
$string['notice_changes_possible_in_original'] = 'Los acmbios a archivos existetes solo son posibles en la actividad de tarea original.';
$string['notice_files_imported'] = 'Los archivos mostrados son importados desde una actividad de tarea.';
$string['notice_files_imported_group'] = 'Los archivos mostrados son de un envío de grupo, importados de una actividad de tarea.';
$string['notice_group_all_teachernotrequired'] = 'Los archivos solo serán publicados para todos los estudiantes con la aprobación de  <strong>TODOS los miembros del grupo.</strong>';
$string['notice_group_all_teacherrequired'] = 'Los archivos solo se publicarán para todos los estudiantes con la aprobación de <strong>TODOS los miembros del grupo y el profesor.</strong> Los profesores se reservan el derecho de rechazar la publicación de sus archivos en cualquier momento.';
$string['notice_group_one_teachernotrequired'] = 'Los archivos solo serán publicados para todos los estudiantes con la aprobación de  <strong>AL MENOS UN miembro del grupo.</strong>';
$string['notice_group_one_teacherrequired'] = 'Los archivos solo serán publicados para todos los estudiantes con la aprobación de  <strong>AL MENOS UN miembro del grupo y el profesor.</strong> Los profesores se reservan el dercho de rechazar la publicación de sus archivos en cualquier momento.';
$string['notice_import_studentnotrequired_teachernotrequired'] = 'Los archivos serán publicados (serán hechos visibles para todos) <strong>automáticamente..</strong>';
$string['notice_import_studentnotrequired_teacherrequired'] = 'Los archivos serán publicados (serán hechos visibles para todos)  solo <strong>después de la aprobación de profesores.</strong>  Los profesores se reservan el dercho de rechazar la publicación de sus archivos en cualquier momento.';
$string['notice_import_studentrequired_teachernotrequired'] = 'Los archivos serán publicados (serán hechos visibles para todos)   después de <strong>su aprobación de usted.</strong>';
$string['notice_import_studentrequired_teacherrequired'] = 'Los archivos serán publicados (serán hechos visibles para todos) después de <strong>su aprobación de usted y la aprobación de los profesores.</strong>  Los profesores se reservan el dercho de rechazar la publicación de sus archivos en cualquier momento.';
$string['notice_obtainapproval_import_both'] = 'Como profesor, puede rechazar la aprobación de publicación en cualquier momento, si un archivo no cumple con los requisitos definidos.';
$string['notice_obtainapproval_import_studentonly'] = 'En el espíritu de la ley de Derechos de Autor (copyright), le pedimos que solicite autorización para publicar archivos de participantes en una manera separada.<br>
Como un profesor, usted puede rechazar la aprobación para publicación en cualquier momento, si un archivo no cumple con los requisitos definidos.';
$string['notice_obtainapproval_upload_automatic'] = 'En el espíritu de la ley de Derechos de Autor (copyright), le pedimos que solicite autorización para publicar archivos de participantes en una manera separada.<br>
Como un profesor, usted puede rechazar la aprobación para publicación en cualquier momento, si un archivo no cumple con los requisitos definidos.';
$string['notice_obtainapproval_upload_teacher'] = 'En el espíritu de la ley de Derechos de Autor (copyright), le pedimos que solicite autorización para publicar archivos de participantes en una manera separada.<br>
Como un profesor, usted puede rechazar la aprobación para publicación en cualquier momento, si un archivo no cumple con los requisitos definidos.';
$string['notice_obtainteacherapproval_studentsapproval'] = 'En el espíritu de la ley de Derechos de Autor (copyright), le pedimos que solicite autorización para publicar archivos de participantes en una manera separada.';
$string['notice_upload_studentnotrequired_teachernotrequired'] = 'Todos los archivos que suba aquí serán publicados (serán hechos visibles para todos)  <strong>automáticamente.</strong>';
$string['notice_upload_studentnotrequired_teacherrequired'] = 'Todos los archivos que suba aquí serán publicados (serán hechos visibles para todos)  después de <strong>su aprobación de usted y la aprobación de los profesores.</strong>  Los profesores se reservan el dercho de rechazar la publicación de sus archivos en cualquier momento.';
$string['notice_upload_studentrequired_teachernotrequired'] = 'Todos los archivos que suba aquí serán publicados (serán hechos visibles para todos)  después de <strong>su aprobación de usted.</strong';
$string['notice_upload_studentrequired_teacherrequired'] = 'Todos los archivos que suba aquí serán publicados (serán hechos visibles para todos)  después de <strong>su aprobación de usted y la aprobación de los profesores.</strong>  Los profesores se reservan el dercho de rechazar la publicación de sus archivos en cualquier momento.';
$string['notifications'] = 'Notificaciones';
$string['notify:filechange'] = 'Notificaciones acerca de archivos enviados o importados';
$string['notify:filechange_admin'] = 'Configuración predeterminada de notificación apara cambios de archivo - enviado o importado';
$string['notify:filechange_help'] = 'Dependiendo de la configuración, si se habilita, los estudiantes y/o los profesores recibirán una notificación cuando los estudiantes suban o cambien un archivo, o cuando el archivo es importado o actualizado desde una actividad de tarea.';
$string['notify:setting:0'] = 'Sin notificaciones';
$string['notify:setting:1'] = 'Solo profesores';
$string['notify:setting:2'] = 'Solo estudiantes';
$string['notify:setting:3'] = 'Ambos, profesores y estudiantes';
$string['notify:statuschange'] = 'Notificaciones acerca de cambios del estado de publicación';
$string['notify:statuschange_admin'] = 'Configuración predeterminada de notificaciones acerca de cambios del estado de publicación';
$string['notify:statuschange_help'] = 'Dependiendo de la configuración, si se habilita, los estudiantes y/o los profesores recibirán una notificación cuandoel estado de la publicación de uno de los archivos sea cambiado.';
$string['notifystudents'] = 'Notificar a estudiantes acerca de cambios en la publicaciónn';
$string['notifystudents_help'] = 'Si se habilita, los estudiantes recibirán una notificación cuando cambie el estado de alguno de sus archivos subidos.';
$string['notifyteacher'] = 'Notificar a profesores acerca de archivos subidos';
$string['notifyteacher_help'] = 'Si se habilita, los evaluadores recibirán una notificación cuando un estudiante suba un archivo,';
$string['obtainapproval_automatic'] = 'Automático';
$string['obtainapproval_required'] = 'Requerido';
$string['obtaingroupapproval'] = 'Aprobación por grupo';
$string['obtaingroupapproval_admin'] = 'Configuración predeterminada de aprobación por grupo';
$string['obtaingroupapproval_admin_desc'] = 'Esta configuración determina la configuración predeterminada de aprobación para miembros del grupo. Esta configuración se vuelve relevante <strong>solo</strong> cuando el modo es configurado a "Importar archivos desde una actividad de Tarea" y la tarea tiene envío grupal.';
$string['obtaingroupapproval_all'] = 'Requerido de TODOS los miembros';
$string['obtaingroupapproval_help'] = 'Esta opción determina cómo se lleva a cabo la publicación (visibilidad) de los envíos de archivos por parte de los grupos: <br /><ul><li><strong>Automático</strong>: no se requiere la aprobación de los miembros del grupo. En el espíritu de la ley de derechos de autor, le solicitamos que solicite la aprobación para publicar archivos de los estudiantes de una manera separada.</li><li><strong>Requerido de al menos UN miembro</strong>: al menos un miembro del grupo debe aprobar</li><li><strong>Requerido de TODOS los miembros</strong>: todos los miembros del grupo deben aprobar</li></ul>';
$string['obtaingroupapproval_single'] = 'Requerido de por lo menos UN miembro';
$string['obtaingroupapproval_title'] = 'Aprobación de grupo';
$string['obtainstudentapproval'] = 'Aprobación de estudiante';
$string['obtainstudentapproval_admin'] = 'Configuración predeterminada de aprobación de estudiante';
$string['obtainstudentapproval_admin_desc'] = 'esta configuración determina la configuración predeterminada de aprobación por estudiantes.';
$string['obtainstudentapproval_help'] = 'Esta opción determina cómo se lleva a cabo la publicación (visibilidad) de los envíos de archivos con la aprobación de los estudiantes: <br><ul><li><strong>Automático</strong>: no se requiere la aprobación de los estudiantes. En el espíritu de la ley de derechos de autor, le solicitamos que solicite la aprobación de los estudiantes para publicar archivos de una manera separada.</li><li><strong>Requerido</strong>: los estudiantes deben aprobar manualmente el archivo para su publicación</li></ul>';
$string['obtainstudentapproval_no'] = 'Automática';
$string['obtainstudentapproval_yes'] = 'Requerido';
$string['obtainteacherapproval'] = 'Aprobación de profesor';
$string['obtainteacherapproval_admin'] = 'Configuración predeterminada de aprobación de profesor';
$string['obtainteacherapproval_admin_desc'] = 'esta configuración determina la configuración predeterminada de aprobación para profesores.';
$string['obtainteacherapproval_help'] = 'Esta opción determina cómo se lleva a cabo la publicación (visibilidad) de los envíos de archivos con la aprobación de los profesores: <br><ul><li><strong>Automático</strong>: no se requiere la aprobación de los profesores.</li><li><strong>Requerido</strong>: los profesores deben aprobar manualmente el archivo para su publicación.</li></ul>';
$string['obtainteacherapproval_no'] = 'Automática';
$string['obtainteacherapproval_yes'] = 'Requerido';
$string['optionalsettings'] = 'Opciones';
$string['overdue'] = 'Fecha límite de período de edición ha pasado';
$string['override:add:group'] = 'Añadir anulación de grupo';
$string['override:add:user'] = 'Añadir anulación de usuario';
$string['override:approval:from'] = 'Aprobación desde {$a->from}';
$string['override:approval:fromto'] = 'Aprobación desde {$a->from} hasta {$a->to}';
$string['override:approval:to'] = 'Aprobación hasta{$a->to}';
$string['override:delete:ask'] = '¿Está seguro de querer eliminar la anulación para {$a->userorgroup} {$a->fullname}?';
$string['override:delete:success'] = 'Anulación eliminada exitosamente';
$string['override:group:choose'] = 'Elegir un grupo';
$string['override:invalidid'] = 'ID de anulación inválida';
$string['override:nothingtochange'] = '¡No hay configuraciones que puedan ser anuladas con las configuraciones actuales de la actividad!';
$string['override:save:success'] = 'Anulación guardada exitosamente';
$string['override:submission:from'] = 'Permitir envíos desde {$a->from}';
$string['override:submission:fromto'] = 'Permitir envíos desde {$a->from} hasta {$a->to}';
$string['override:submission:to'] = 'Permitir envíos hasta {$a->to}';
$string['override:user:choose'] = 'Elegir un usuario';
$string['overrides:empty'] = 'Sin anulaciones';
$string['overview'] = 'Vista general';
$string['pending'] = 'Pendiente';
$string['pluginadministration'] = 'Administración de la carpeta del estudiante';
$string['pluginname'] = 'Carpeta del estudiante';
$string['privacy:metadata:approval'] = 'Si es que el miembro de grupo la aha aprobado o rechazado para publicación.';
$string['privacy:metadata:contenthash'] = 'Hash SHA1 del contenido del archivo, usado para determinar si el archivo cambió.';
$string['privacy:metadata:extduedates'] = 'Almacena información acerca de fechas esperadas anuladas/extendidas para mod_publication.';
$string['privacy:metadata:extensionduedate'] = 'La fecha esperada efectiva para estudiantes está siendo anulada/extendida.';
$string['privacy:metadata:fileid'] = 'Identificador del archivo.';
$string['privacy:metadata:filename'] = 'El nombre del archivo.';
$string['privacy:metadata:files'] = 'Almacena información (identificador, a quien pertenece, de donde viene, hash del contenido, nombre del archivo y si fue aprobado por profesor o estudiante) acerca de archivos subidos/importados dentro de mod_publication.';
$string['privacy:metadata:groupapproval'] = 'Almacena información acerca de aprobación o rechazo de archivos por miembros de grupo, importados un envío del grupo.';
$string['privacy:metadata:publicationfileexplanation'] = 'Los archivos y los envíos de texto en línea convertidos por este plugin son almacenados vía API de archivo de Moodle.';
$string['privacy:metadata:publicationperpage'] = '¡Cuantas entradas deberían de mostrarse en una sola página de tabla!';
$string['privacy:metadata:studentapproval'] = 'Si es que el estudiante ha aprobado o rechazado la publicación de un archivo.';
$string['privacy:metadata:teacherapproval'] = 'Si es que el profesor ha aprobado o rechazado la publicación de un archivo.';
$string['privacy:metadata:timecreated'] = 'La hora y fecha de cuando fue creado el registro de datos.';
$string['privacy:metadata:timemodified'] = 'La hora y fecha más reciente de cuando fue actualizado/modificado el registro de datos.';
$string['privacy:metadata:type'] = 'Marca el origen del archivo (subido por estudiante, importado desde envío de tarea o texto_en_línea convertido desde envío de tarea).';
$string['privacy:metadata:userid'] = 'Identificador del usuario.';
$string['privacy:path:files'] = 'Archivos';
$string['privacy:path:resources'] = 'Recursos';
$string['privacy:type:import'] = 'Archivo importado';
$string['privacy:type:onlinetext'] = 'texto_en_línea importado';
$string['privacy:type:upload'] = 'Archivo subido';
$string['publication:addinstance'] = 'Añadir una nueva carpeta del estudiante';
$string['publication:approve'] = 'Decidir si es que los archivos deberían estar publicados (visibles para todos los estudiantes.';
$string['publication:grantextension'] = 'Otorgar extensión';
$string['publication:manageoverrides'] = 'Gestionar anulaciones';
$string['publication:receiveteachernotification'] = 'Recibir notificaciones para profesores';
$string['publication:upload'] = 'Subir archivos a una carpeta de estudiante';
$string['publication:view'] = 'Ver carpeta del estudiante';
$string['publicationstatus'] = 'Publicación';
$string['publicationstatus_help'] = 'El estado de la publicación representa la aprobación del profesor y la publicación final: <ul><li><i class="fa fa-check text-success fa-fw"></i> El archivo es publicado y por lo tanto es visible para todos los participantes</li><li><i class="fa fa-times text-danger fa-fw"></i> El archivo NO es publicado (no se ha dado aprobación o ha sido rechazado) y por lo tanto nNO es visible</li></ul>';
$string['publicfiles'] = 'Archivos publicados';
$string['published_aftercheck'] = 'Aprobación de profesores requerida';
$string['published_immediately'] = 'Aprobar automáticamente';
$string['rejected'] = 'Rechazado';
$string['rejectusers'] = 'Rechazar';
$string['reset'] = 'Revertir';
$string['reset_userdata'] = 'Todos los datos';
$string['resetstudentapproval'] = 'Revertir aprobación de estudiante';
$string['save_changes'] = 'Guardar cambios';
$string['saveapproval'] = 'Guardar cambios';
$string['savestudentapprovalwarning'] = '¿Está Usted seguro de querer guardar estos cambios? El estado de la publicación no puede ser cambiado una vez que sea configurado.';
$string['saveteacherapproval'] = 'Guardar cambios';
$string['search:activity'] = 'Carpeta de estudiante - información de actividad';
$string['show_details'] = 'Mostrar detalles';
$string['status'] = 'Estatus';
$string['status:approved'] = 'Aprobado';
$string['status:approvednot'] = 'Rechazado';
$string['status:approvedrevoke'] = 'Revocada';
$string['student_approve'] = 'Aprobar';
$string['student_approved'] = 'Aprobado por estudiante.';
$string['student_approved_automatically'] = 'Aprobado por estudiante automáticamente.';
$string['student_pending'] = 'Decisión del estudiante pendiente';
$string['student_reject'] = 'Rechazar';
$string['student_rejected'] = 'Rechazado del estudiante';
$string['studentapproval'] = 'Aprobación (estudiantes)';
$string['studentapproval_help'] = 'En la columna "Aprobación (estudiantes)" la retroalimentación a los estudiantes es mostrada:<br><ul><li><i class="fa fa-question fa-fw text-advertencia"></i> - Decisión pendiente</li><li><i class="fa fa-check text-éxito fa-fw"></i> - Aprobación dada</li><li><i class="fa fa-times text-peligro fa-fw"></i> - Aprobación rechazada</li></ul>';
$string['submissionsettings'] = 'Configuraciones del envío';
$string['teacher_approve'] = 'Aprobar';
$string['teacher_approved'] = 'Aprobado por profesor.';
$string['teacher_approved_automatically'] = 'Aprobado por profesor automáticamente.';
$string['teacher_pending'] = 'La decisión del profesor está pendiente.';
$string['teacher_reject'] = 'Rechazar';
$string['teacher_rejected'] = 'No publicado (rechazado)';
$string['teacherapproval'] = 'Aprobación';
$string['teacherapproval_help'] = 'Aprobación/rechazo actual de los archivos, es decir, si son visibles para todos los participantes: <br><ul><li><strong>Elegir...</strong>: decisión pendiente/no se ha dado la aprobación o se han rechazado; estos archivos no son visibles.</li><li><strong>Aprobar</strong>: aprobación concedida; estos archivos se publican y, por lo tanto, son visibles para todos.</li><li><strong>Rechazar</strong>: no se ha dado la aprobación; estos archivos no se publican y, por lo tanto, no son visibles.</li></ul>';
$string['total'] = 'Total';
$string['updatefiles'] = 'Subir archivos';
$string['updatefileswarning'] = 'Los archivos ya importados serán reemplazados o eliminados si los archivos originales en la tarea son refrescados o eliminados. Las configuraciones del estudiante, como por ejemplo la aprobación para publicación, permanecen como están.';
$string['uploaded'] = 'Subido';
$string['uploadnotopen'] = '¡Está cerrada la subida de archivos!';
$string['visibility'] = 'Publicado';
$string['visible'] = 'Publicado';
$string['visibleforstudents'] = 'Publicado';
$string['visibleforstudents_no'] = 'Este archivo NO está publicado (No es visible a los estudiantes).';
$string['visibleforstudents_yes'] = 'Este archivo si está publicado (visible a los estudiantes).';
$string['withselected'] = 'Con los seleccionados...';
$string['zipusers'] = 'Descargar envíos de archivos seleccionados';
