<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'questionnaire', language 'es_mx', version '5.0'.
 *
 * @package     questionnaire
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessibility:rate:choice'] = 'Fila {$a->rowposition}, {$a->choicetitle}: Columna {$a->colposition}, {$a->choiceanswer}.';
$string['action'] = 'Acción';
$string['activityoverview'] = 'Usted tiene cuestionarios pendientes de contestar';
$string['additionalinfo'] = 'Info adicional';
$string['additionalinfo_help'] = 'Texto a mostrar en la parte superior de la primera página del cuestionario (por ejemplo: instrucciones, información de contexto, etc).';
$string['addnewquestion'] = 'Añadiendo {$a} pregunta';
$string['addnewsection'] = 'Añadir nueva sección';
$string['addquestion'] = 'Añadir pregunta ...';
$string['addquestions'] = 'Añadir preguntas';
$string['addquestiontosection'] = 'Añadir pregunta a sección';
$string['addselqtype'] = 'Añadir tipo de pregunta seleccionada';
$string['alignment'] = 'Alineación de botones de selección';
$string['alignment_help'] = 'Seleccionar alineación de botones. vertical (por defecto) u horizontal.';
$string['alignment_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['all'] = 'Todos';
$string['allnameddegrees'] = 'Grados nombrados';
$string['allnameddegrees_help'] = 'Especificar texto a mostrar para valorar valores en lugar del número. Deje un valor vacío para no usarlo.';
$string['alreadyfilled'] = 'Usted ya ha llenado este cuestionario para nosotros {$a}. Gracias';
$string['andaveragevalues'] = 'y valores promedio';
$string['anonymous'] = 'Anónimo';
$string['answer'] = 'Respuesta';
$string['answergiven'] = 'Esta respuesta dada';
$string['answernotgiven'] = 'Esta respuesta no dada';
$string['answerquestions'] = 'Contestar las preguntas...';
$string['answers'] = 'Respuestas';
$string['attempted'] = 'Este cuestionario ha sido enviado.';
$string['attemptstillinprogress'] = 'En progreso. Guardado en:';
$string['autonumbering'] = 'Auto numeración';
$string['autonumbering_help'] = 'Auto numeración de preguntas y páginas. Usted querría desactivar la auto-numeración para los cuestionarios con ramificaciones condicionales.';
$string['autonumberno'] = 'No numerar las preguntas o páginas';
$string['autonumberpages'] = 'Auto numerar páginas';
$string['autonumberpagesandquestions'] = 'Auto numerar páginas y preguntas';
$string['autonumberquestions'] = 'Auto numerar preguntas';
$string['average'] = 'Promedio';
$string['averageposition'] = 'Posición promedio';
$string['averagerank'] = 'Ranking promedio';
$string['averagesrow'] = 'Promedios (donde aplique):';
$string['bodytext'] = 'TTexto del cuerpo';
$string['boxesnbexact'] = 'exactamente {$a} caja(s).';
$string['boxesnbmax'] = 'un máximo de {$a} caja(s).';
$string['boxesnbmin'] = 'un mínimo de {$a} caja(s).';
$string['boxesnbreq'] = 'Para esta pregunta Usted debe seleccionar';
$string['by'] = 'por';
$string['cannotviewpublicresponses'] = 'Usted no puede ver respuestas a este cuestionario público.';
$string['centerlabel'] = 'Etiqueta central';
$string['chart:bipolar'] = 'Barras bipolares';
$string['chart:hbar'] = 'Barras horizontales';
$string['chart:radar'] = 'Radar';
$string['chart:rose'] = 'Rosa';
$string['chart:type'] = 'Tipo de gráfica';
$string['chart:type_help'] = 'Seleccione el tipo de gráfica que quiera usar para esta retroalimentación';
$string['chart:vprogress'] = 'Barra de progreso vertical';
$string['checkallradiobuttons'] = '¡Por favor elija <strong>{$a}</strong> botones de selección!';
$string['checkboxes'] = 'Casillas de selección';
$string['checkboxes_help'] = 'Introduzca una opción por línea para que el usuario seleccione una o varias respuestas.';
$string['checkboxes_link'] = 'mod/questionnaire/questions#Check_Boxes';
$string['checkbreaksadded'] = 'Nuevo(s) Salto(s) de página insertado(s) en posición(es)';
$string['checkbreaksok'] = '¡ Todos los saltos de página requeridos están presentes !';
$string['checkbreaksremoved'] = 'Removidos  {$a} Salto(s) de Página extra(s).';
$string['checknotstarted'] = 'Selección no iniciada';
$string['checkstarted'] = 'Selección iniciada';
$string['clicktoswitch'] = '(hacer clic para cambiar)';
$string['closebeforeopen'] = 'Usted ha especificado una fecha de cierre anterior a la fecha de apertura.';
$string['closed'] = 'Este cuestionario se cerró en {$a}. Gracias.';
$string['closedate'] = 'Permitir respuestas hasta';
$string['closeson'] = 'El cuestionario se cierra en {$a}';
$string['completionsubmit'] = 'Los estudiantes deben enviar este cuestionario (questionnaire) para completarlo';
$string['condition'] = 'Condición';
$string['confalts'] = '- O - <br />Página de confirmación';
$string['configemailreporting'] = 'Permitir reportes por Email';
$string['configemailreportinglong'] = 'Habilitar opciones para que algunos reportes se envíen por Email directamente a las direcciones de Email especificadas.';
$string['configmaxsections'] = 'Máximo de secciones de retroalimentación';
$string['configusergraph'] = 'Mostrar gráficas para retroalimentación de "Prueba de Personalidad"';
$string['configusergraphlong'] = 'Usar la biblioteca (\'\'library\'\')  <a href="http://www.rgraph.net/">Rgraph</a> para mostrar gráficas de retroalimentación de "Prueba de Personalidad".';
$string['confirmdelallresp'] = '¿Está seguro de querer borrar TODAS las respuestas a este cuestionario?';
$string['confirmdelchildren'] = 'Si Usted elimina esta pregunta, sus preguntas hijas serán también eliminadas:';
$string['confirmdeletesection'] = '¿Está seguro de querer eliminar la sección de retroalimentación "{$a}"?';
$string['confirmdelgroupresp'] = '¿Está seguro de querer borrar TODAS las respuestas de {$a}?';
$string['confirmdelquestion'] = '¿ Esta Usted seguro de querer eliminar la pregunta en la posición {$a}?';
$string['confirmdelquestionresps'] = 'Esto eliminará la(s) respuesta(s) {$a} que ya están dadas para esta pregunta.';
$string['confirmdelresp'] = '¿Está seguro de querer borrar TODAS las respuestas de&nbsp;{$a}&nbsp;?';
$string['confirmremovequestion'] = '¿Está seguro de querer eliminar la pregunta"{$a->qname}" de la sección "{$a->sname}"?';
$string['confpage'] = 'Texto de encabezado';
$string['confpage_help'] = 'Encabezado (en negritas) y texto del cuerpo para página de "Confirmación" se muestra después de que el usuario complete este cuestionario. (URL,si existe, tiene prioridad por sobre el texto de confirmación). Si deja vacío este campo, se mostrará un mensaje por defecto al terminar el cuestionario (Gracias por completar este Cuestionario).';
$string['confpagedesc'] = 'Encabezado (en negritas) y texto del cuerpo para página de "Confirmación" se muestra después de que el usuario complete este cuestionario. (URL,si existe, tiene prioridad por sobre el texto de confirmación)';
$string['contentoptions'] = 'Opciones de contenido';
$string['couldnotcreatenewsurvey'] = '¡No pudo crearse una nueva encuesta!';
$string['couldnotdelresp'] = 'No se pudo borrar respuesta';
$string['createcontent'] = 'Definir nuevo contenido';
$string['createcontent_help'] = 'Elija uno de los botones de selección. \'Crear nuevo\' funciona por defecto.';
$string['createcontent_link'] = 'mod/questionnaire/mod#Content_Options';
$string['createnew'] = 'Crear nuevo';
$string['crontask'] = 'Trabajo de limpieza del cuestionario';
$string['date'] = 'Fecha';
$string['date_help'] = 'Usar este tipo de pregunta si espera que la respuesta sea una fecha en el formato correcto.';
$string['date_link'] = 'mod/questionnaire/questions#Date';
$string['dateformatting'] = 'Usar formato día/mes/año format,por ejemplo: para Marzo 14 de 1945  :&nbsp; <strong>1945-03-04</strong>';
$string['deleteallresponses'] = 'Borrar TODAS las respuestas';
$string['deletecurrentquestion'] = 'Borrar pregunta {$a}';
$string['deletedallgroupresp'] = 'Borrar TODAS las respuestas del grupo {$a}';
$string['deletedallresp'] = 'Respuestas del cuestionario borradas';
$string['deletedisabled'] = 'Este ítem no puede eliminarse';
$string['deletedresp'] = 'Respuesta borrada';
$string['deleteresp'] = 'Borrar esta respuesta';
$string['deletesection'] = 'Eliminar esta sección';
$string['deletingresp'] = 'Borrando respuesta';
$string['dependencies'] = 'Dependencias';
$string['dependquestion'] = 'Pregunta Padre';
$string['dependquestion_help'] = 'Usted puede seleccionar una pregunta padre y una opción elegible para esta pregunta. Una pregunta hija solemente se le mostrará al estudiante si su pregunta padre y opción padre han sido previamente seleccionadas.';
$string['dependquestion_link'] = 'mod/questionnaire/questions#Parent_Question';
$string['didnotrespondtoquestion'] = 'No respondió a la pregunta';
$string['directwarnings'] = 'Las dependencias directas a esta pregunta serán removidas. Esto afectará:';
$string['displaymethod'] = 'Método de visualización no definido por la pregunta';
$string['download'] = 'Descargar';
$string['downloadpdf'] = 'Descargar PDF';
$string['downloadtextformat'] = 'Descargar';
$string['downloadtextformat_help'] = 'Esta característica le permite guardar todas las respuestas de un questionnaire en un archivo de formato soportado seleccionable.
Usted puede elegir incluir ítems de datos extra en la exportación, y también puede elegir enviar automáticamente el archivo a usuarios seleccionados.';
$string['downloadtextformat_link'] = 'mod/questionnaire/report#Download_in_text_format';
$string['downloadtypes'] = 'Tipo de reporte';
$string['dropdown'] = 'Caja desplegable';
$string['dropdown_help'] = 'No hay ninguna ventaja real en usar la caja desplegable sobre usar los botones de selección, excepto quizás en una lista de opciones bastante larga, para ahorrar espacio de pantalla.';
$string['dropdown_link'] = 'mod/questionnaire/questions#Dropdown_Box';
$string['edit'] = 'Editar';
$string['editingfeedback'] = 'Editando configuraciones de retroalimentación';
$string['editingquestionnaire'] = 'Editando Configuraciones del Cuestionario';
$string['editquestion'] = 'Editando pregunta {$a}';
$string['email'] = 'Email';
$string['emailextra'] = 'Enviar descarga a Emails';
$string['emailextra_help'] = 'Enviará el archivo descargado a las direcciones de Email enlistadas, separadas por comas. Tenga en cuenta que NO se hacen revisiones de seguridad ni privacidad.
 \'allowemailreporting\' debe estar habilitado en las configuraciones del módulo para acceder a esto.';
$string['emailroles'] = 'Enviar descarga a roles';
$string['emailroles_help'] = 'Enviará vía Email el archivo descargado a todos los roles con la capacidad "mod/questionnaire:submissionnotification" .
 \'allowemailreporting\' debe estar habilitado en las configuraciones del módulo para acceder a esto.';
$string['emailsend'] = 'Enviar reportes';
$string['emailsnotspecified'] = 'No se especificó Email(s)';
$string['emailssent'] = 'Descargas enviadas a Email(s) específico(s).';
$string['errnewname'] = 'Perdón, pero ya está en uso. Elija un nuevo nombre,';
$string['erroropening'] = 'Error al abrir Cuestionario.';
$string['errortable'] = 'Error por tabla de sistema corrupta';
$string['essaybox'] = 'Caja para ensayo';
$string['essaybox_help'] = 'Esta pregunta mostrará una caja de texto simple con x columnas  para área-de-texto y con y (área-de-texto) hileras (número de líneas de texto).

Si deja vacíos  tanto x como y en su valor de 0 por defecto, (o si los pone a 0), entonces el editor HTML de Moodle se mostrará con alto y ancho estándar (si está disponible en el perfil y contexto del curso/usuario).';
$string['event_all_responses_deleted'] = 'Todas las respuestas eliminadas';
$string['event_all_responses_saved_as_text'] = 'Todas las respuestas guardadas como texto';
$string['event_all_responses_viewed'] = 'Reporte de Todas las Respuestas visto';
$string['event_individual_responses_viewed'] = 'Reporte de Respuestas Individuales visto';
$string['event_non_respondents_viewed'] = 'No-respondentes vistos';
$string['event_previewed'] = 'Cuestionario pre-visualizado';
$string['event_question_created'] = 'Cuestionario creado';
$string['event_question_deleted'] = 'Cuestionario eliminado';
$string['event_response_deleted'] = 'Respuesta Individual eliminada';
$string['event_resumed'] = 'Intento continuado';
$string['event_saved'] = 'Respuestas guardadas';
$string['event_submitted'] = 'Respuestas enviadas';
$string['feedback'] = 'Retroalimentación';
$string['feedback_help'] = 'Ayuda de retroalimentación';
$string['feedback_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Messages';
$string['feedbackaddmorefeedbacks'] = 'Añadir {no} más campos de retroalimentación';
$string['feedbackbysection'] = 'Retroalimentación de secciones';
$string['feedbackdefaultlabel'] = '[Nueva sección]';
$string['feedbackeditingglobal'] = 'Editando Retroalimentación Global de Cuestionario';
$string['feedbackeditingmessages'] = 'Editando Mensajes de Retroalimentación del Cuestionario';
$string['feedbackeditingsections'] = 'Editando Secciones de Retroalimentación del Cuestionario';
$string['feedbackeditmessages'] = 'Guardar configuraciones de Secciones y editar Mensajes de Retroalimentación';
$string['feedbackeditsections'] = 'Guardar configuraciones de Secciones y editar Secciones de Retroalimentación';
$string['feedbackerrorboundaryformat'] = 'Los límites del puntaje de retroalimentación deben ser, o un porcentaje, o un número. El valor que Usted escribió en el límite {$a} no es reconocido.';
$string['feedbackerrorboundaryoutofrange'] = 'Los límites del puntaje de retroalimentación deben ser entre 0% y 100%. El valor que Usted escribió en el límite {$a} está fuera del rango.';
$string['feedbackerrorjunkinboundary'] = 'Usted debe llenar las cajas de límite del puntaje de reatroalimentación sin dejar ningún hueco.';
$string['feedbackerrorjunkinfeedback'] = 'Usted debe llenar las cajas de retroalimentación sin dejar ningún hueco.';
$string['feedbackerrororder'] = 'Los límites de los puntajes de retroalimentación deben de estar en órden, con el más alto primero. El valor que escribió Usted en el límite {$a} está fuera de secuencia.';
$string['feedbackglobal'] = 'Retroalimentación Global';
$string['feedbackglobalheading'] = 'Encabezado de Retroalimentación Global';
$string['feedbackglobalmessages'] = 'Mensajes de Retroalimentación Global';
$string['feedbackhdr'] = 'Retroalimentaciones';
$string['feedbackheading'] = 'Encabezado de retroalimentación';
$string['feedbackheading_help'] = 'En el campo de encabezado de la retroalimentación Usted puede usar 2 variables: $scorepercent y $oppositescorepercent.';
$string['feedbackmessages'] = 'mensajes de sección {$a}';
$string['feedbacknextsection'] = 'Siguiente sección {$a}';
$string['feedbacknone'] = 'Sin mensajes de retroalimentación';
$string['feedbacknotes'] = 'Notas de retroalimentación';
$string['feedbacknotes_help'] = 'El texto escrito aquí se mostrará a los encuestados al final de su Reporte de Retroalimentación';
$string['feedbackoptions'] = 'Opciones de retroalimentación';
$string['feedbackoptions_help'] = 'Las opciones de retroalimentación están disponibles si su cuestionario contiene los siguientes tipos de preguntas y configuraciones de preguntas:
Botones de selección; Caja desplegable, Si/No, o Valorar (normal o escala Osgood). Esas preguntas deberán configurarse como obligatorias; su campo para Nombre de Pregunta NO deberá estar vacío y las opciones para Respuestas posibles deben contener un valor.';
$string['feedbackoptions_link'] = 'mod/questionnaire/personality_test';
$string['feedbackremovequestionfromsection'] = 'Esta pregunta es parte de la sección de retroalimentación [{$a}]';
$string['feedbackremovesection'] = 'El remover esta pregunta removerá completamente la sección de retroalimentación [{$a}]';
$string['feedbackreport'] = 'Reporte de Retroalimentación';
$string['feedbackscore'] = 'Puntaje de retroalimentación';
$string['feedbackscoreboundary'] = 'Límite de Puntaje de Retroalimentación';
$string['feedbackscores'] = 'Mostrar Puntajes';
$string['feedbackscores_help'] = 'Mostrar la tabla de puntajes de retroalimentación';
$string['feedbacksection'] = 'Sección';
$string['feedbacksectionheading'] = 'Encabezado de sección {$a}';
$string['feedbacksectionheadingmissing'] = '¡ Usted debe escribir un Encabezado para esta sección de retroalimentación !';
$string['feedbacksectionheadingtext'] = 'Encabezado';
$string['feedbacksectionlabel'] = 'Etiqueta';
$string['feedbacksectionlabel_help'] = 'Esta etiqueta será usada en las gráficas/diagramas. ¡ Por favor hágala tan corta como sea posible !';
$string['feedbacksectionquestions'] = '{$a} preguntas de sección';
$string['feedbacksections'] = 'Secciones de Retroalimentación';
$string['feedbacksectionsselect'] = 'Secciones';
$string['feedbacksectionsselect_help'] = 'Poner sus preguntas dentro de esas Secciones';
$string['feedbacksectionsselect_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Sections_2';
$string['feedbacksettingssaved'] = 'Configuraciones de retroalimentación guardadas';
$string['feedbacktype'] = 'Tipo de retroalimentación';
$string['field'] = 'Pregunta {$a}';
$string['fieldlength'] = 'Largo de caja de texto';
$string['fieldlength_help'] = 'Para la pregunta de tipo **Caja de Texto**, introduzca el **Largo de Caja de Texto** y la **Longitud Máxima del Texto** para el texto que será tecleado por quien responde.

Los valore por defecto son 20 caracteres para el ancho de la caja de Texto y 25 caracteres para la longitud máxima del texto introducido.';
$string['finished'] = '¡ Usted ha contestado todas las preguntas en este cuestionario (questionnaire) !';
$string['firstrespondent'] = 'Primera persona en responder';
$string['formateditor'] = 'Editor HTML';
$string['formatplain'] = 'Texto simple';
$string['grade'] = 'Calificación del envío';
$string['gradesdeleted'] = 'Calificaciones del cuestionario eliminadas';
$string['headingtext'] = 'Texto del encabezado';
$string['horizontal'] = 'Horizontal';
$string['id'] = 'ID';
$string['includechoicecodes'] = 'Incluir códigos de opciones';
$string['includechoicetext'] = 'Incluir texto de opciones';
$string['includeincomplete'] = 'Incluir respuestas incompletas';
$string['includerankaverages'] = 'Incluir promedios de ranking de pregunta';
$string['incorrectcourseid'] = 'ID del curso es incorrecta';
$string['incorrectmodule'] = 'ID del módulo del curso era incorrecta';
$string['incorrectquestionnaire'] = 'El cuestionario es incorrecto';
$string['indirectwarnings'] = 'Esta lista muestra las preguntas indirectamente dependientes y las dependencias restantes para preguntas directamente dependientes:';
$string['invalidincrement'] = 'Tenga en cuenta que los incrementos de valor deben ser menores que el valor máximo. Por ejemplo, en una escala de 1-10, el valor del incremento probablemente sería 1.';
$string['invalidminmaxrange'] = 'Este tipo de pregunta soporta un rango máximo absoluto de -100 a +100. Nosotros esperamos que la gran mayoría de los diseños de cuestionarios a usar estén en el rango de 1-10 o -10 a +10.';
$string['invalidrange'] = 'El valor máximo del deslizador debe ser mayor que el valor mínimo del deslizador.';
$string['invalidresponse'] = 'Se especificó una respuesta no válida';
$string['invalidresponserecord'] = 'Se especificó un registro de respuesta no válido';
$string['invalidsectionid'] = 'Se especificó sección de retroalimentación inválida';
$string['invalidstartingvalue'] = 'El valor inicial debe ser igual o estar entre los valores mínimo y máximo. Por ejemplo, si se usa una escala de 1-10, el valor inicial podría ser 5.';
$string['invalidsurveyid'] = 'ID del Cuestionario no válida';
$string['kindofratescale'] = 'Tipo de escalas';
$string['kindofratescale_help'] = 'Haga clic derecho para ver la documentación Moodle más abajo';
$string['kindofratescale_link'] = 'mod/questionnaire/questions#Type_of_rate_scale';
$string['lastrespondent'] = 'Última persona en responder';
$string['leftlabel'] = 'Etiqueta izquierda';
$string['leftpart'] = '{$a->min} es {$a->leftlabel}';
$string['leftpartdefault'] = '{$a->min} es el rango del deslizador mínimo';
$string['length'] = 'Largo';
$string['managequestions'] = 'Gestionar preguntas';
$string['managequestions_help'] = 'En la sección para Gestionar Preguntas, de la página para Editar Preguntas, Usted puede conducir un número de operaciones sobre preguntas de un Cuestionario.(questionnaire).';
$string['managequestions_link'] = 'mod/questionnaire/questions#Manage_questions';
$string['mandatory'] = 'Obligatorio - Todas estas dependencias deben cumplirse.';
$string['maxdigitsallowed'] = 'Máx dígitos permitidos';
$string['maxdigitsallowed_help'] = 'Use **Max. dígitos permitidos** para configurar un límite al número de caracteres ingresados para una Pregunta Numérica. ¡Tenga en cuenta que el punto decimal también cuenta como un caracter!';
$string['maxdigitsallowed_link'] = 'mod/questionnaire/questions#Numeric';
$string['maxforcedresponses'] = 'Máx respuestas forzadas';
$string['maxforcedresponses_help'] = 'Use estos parámetros para forzar a los respondentes a selccionar un mínimo de  **Min.** cajas y un máximo de **Max.** casillas de selección. Para forzar un número exacto de casillas de selección seleccionadas, configure **Min.** y **Max.** al mismo valor. Si solamente desea un solo valor min o max, simplemente deje el otro valor a su configuración por defecto de **0**. Si Usted configura **Min.** o **Max.** a valores diferentes de su valor por defecto de **0**, se mostrará un mensaje de advertencia si el encuestado no cumple con los requisitos. Obviamente, Usted debería de hacer claros los requisitos para el encuestado, ya sea en las instrucciones generales o en el texto de las preguntas relevantes.';
$string['maxrange'] = 'Rango máximo del deslizador (derecha)';
$string['maxrange_help'] = 'Configurar el valor máximo del rango del lado derecho. El predeterminado es 100, pero podría ser cualquier número entre 1-100. Si el valor mínimo para el lado izquierdo es un valor negativo, el rango máximo será expresado con un signo positivo (+).';
$string['maxtextlength'] = 'Máx. longitud texto';
$string['maxtextlength_help'] = 'Para el tipo de pregunta de Caja de Texto, ingrese la longitud de la Caja de Ingreso y la Longitud Máxima del texto a ser ingresado por el encuestado.
Los valores por defecto son 20 caracteres para el ancho de la Caja de Ingreso y 25 caracteres para la longitud máxima del texto ingresado.';
$string['messageprovider:message'] = 'Recordatorio del cuestionario (questionnnaire)';
$string['messageprovider:notification'] = 'Envío de Questionnaire';
$string['middlepart'] = ', {$a->centreval} es {$a->middlelabel}';
$string['middlepartdefault'] = ', {$a->centreval} es promedio';
$string['middlepartwithtwovalues'] = ', {$a->centreval1} y {$a->centreval2} son {$a->middlelabel}';
$string['middlepartwithtwovaluesdefault'] = ', {$a->centreval1} y {$a->centreval2} son promedio';
$string['minforcedresponses'] = 'Mín respuestas forzadas';
$string['minforcedresponses_help'] = 'Use estos parámetros para forzar a los usuarios a responder un mínimo de  **Min.** cajas y un máximo f **Max.** casillas de verificación. Para forzar un número exacto de casillas de elección seleccionadas, configure **Min.** y **Max.**al mismo valor. Si solamente desea un valor mínimo o máximo, entonces dejeel otro valor a su configuración de valor de **0** por defecto. Si configura **Min.** o **Max.** a valores diferentes a su valor por  defecto de **0** , se mostrará un mensaje de advertencia si quien responde no cumple con sus requisitos. Obviamente, Usted debe poner muy claros los requisitos para quien responda en las instrucciones generales de su Cuestionario o en el texto de las preguntas relevantes.';
$string['minrange'] = 'Rango máximo del deslizador (izquierda)';
$string['minrange_help'] = 'Configurar el valor mínimo del rango del lado izquierdo. El predeterminado es 1, pero podría ser ta bajo como -100. Si usted usa un número negativo (-100 a -1), el máximo del lado derecho será expresado con un  signo positivo (+)., el rango máximo será expresado con un signo positivo (+).';
$string['misconfigured'] = 'El curso está mal configurado';
$string['missingname'] = 'La pregunta {$a} no puede usarse en esta sección de retroalimentación debido a que no tiene un nombre.';
$string['missingnameandrequired'] = 'La pregunta {$a} no puede usarse en esta sección de retroalimentación debido a que no tiene un nombre y no es obligatoria.';
$string['missingquestion'] = 'Por favor conteste esta pregunta obligatoria';
$string['missingquestions'] = 'Por favor conteste las preguntas obligatorias:';
$string['missingrequired'] = 'La pregunta {$a} no puede usarse en esta sección de retroalimentación debido a que no es obligatoria.';
$string['modulename'] = 'Cuestionario';
$string['modulename_help'] = 'El módulo de cuestionario (questionnaire) le permite construir encuestas empleando una variedad de tipos de preguntas, para recolectar datos de sus usuarios.';
$string['modulename_link'] = 'mod/questionnaire/view';
$string['modulenameplural'] = 'Cuestionarios';
$string['movedisabled'] = 'Este ítem no puede moverse';
$string['myresponses'] = 'Todas sus respuestas';
$string['myresponsetitle'] = 'Su(s) {$a} respuesta(s)';
$string['myresults'] = 'Sus resultados';
$string['name'] = 'Nombre';
$string['navigate'] = 'Permitir preguntas ramificadas';
$string['navigate_help'] = 'Habilitar Si/No y preguntas de Botón de Selección para tener preguntas Hijas, que dependen de las opciones en su cuestionario (questionnaire).';
$string['navigate_link'] = 'mod/questionnaire/conditional_branching';
$string['navigatetosection'] = 'Ir a sección de retroalimentación';
$string['next'] = 'Siguiente';
$string['nextpage'] = 'Página siguiente';
$string['nlines'] = '{$a} líneas';
$string['noanswer'] = 'Sin respuesta';
$string['noattempts'] = 'No se han hecho intentos para contestar este cuestionario';
$string['nodata'] = 'Sin fecha';
$string['noduplicates'] = 'Sin opciones duplicadas';
$string['noduplicateschoiceserror'] = '¡ Usted debe escribir al menos 2 respuestas posibles para la opción de "Sin opciones duplicadas"  !';
$string['non_respondents'] = 'Usuarios que todavía no han enviado sus respuestas a este cuestionario (questionnaire)';
$string['noneinuse'] = 'Este cuestionario no tiene ninguna pregunta';
$string['nopermissions'] = 'Lo sentimos, pero usted no tiene permisos para ver esta página o realizar esta acción.';
$string['nopublicsurveys'] = 'Sin cuestionarios públicos';
$string['noresponsedata'] = 'Sin respuestas para esta pregunta';
$string['noresponses'] = 'Sin respuestas';
$string['normal'] = 'Normal';
$string['not_started'] = 'no iniciado';
$string['notanumber'] = '<strong>{$a}</strong> no es un formato numérico aceptable';
$string['notapplicable'] = 'N/A';
$string['notapplicablecolumn'] = 'columna N/A';
$string['notavail'] = 'Este questionnaire ya no está disponible. Pídale a su profesor que lo elimine.';
$string['noteligible'] = 'Usted no es elegible para contestar este cuestionario';
$string['notemplatesurveys'] = 'No hay plantillas de cuestionario';
$string['notenoughscaleitems'] = '¡ Usted debe escribir un valor mínimo de 2 ítems de escala !';
$string['notificationfull'] = 'Envío completo';
$string['notifications'] = 'Enviar notificaciones de envío';
$string['notifications_help'] = 'Notificar roles con la capacidad "mod/questionnaire:submissionnotification" capability when a submission is made.cuando se haga un envío.';
$string['notifications_link'] = 'mod/questionnaire/mod#Submission_Notifications';
$string['notificationsimple'] = 'Solamente notificación';
$string['notopen'] = 'Este cuestionarió no abrirá hasta {$a}.';
$string['notrequired'] = 'La respuesta no es requerida';
$string['notset'] = 'no configurado';
$string['nousersselected'] = 'Sin usuarios seleccionados';
$string['num'] = '#';
$string['numattemptsmade'] = 'Se han hecho {$a} intentos de contestar este cuestionario';
$string['numberfloat'] = 'El número que Usted tecleó  <strong>{$a->number}</strong> ha sido reformateado/redondeado con  <strong>{$a->precision}</strong> decimal(es).';
$string['numberofdecimaldigits'] = 'Número  de decimales';
$string['numberofdecimaldigits_help'] = 'Use **Número de dígitos decimales** para especificar el formato del Valor promedio contado y mostrado en la página del Reporte del questionnaire.';
$string['numberofdecimaldigits_link'] = 'mod/questionnaire/questions#Numeric';
$string['numberscaleitems'] = 'Número de items de escala';
$string['numberscaleitems_help'] = 'Número de items de escala es el *número de items* que se empleará en su escala. Normalmente Usted usaría un valor de 3 a 5.Valor por defecto: **5**.';
$string['numeric'] = 'Numérico';
$string['numeric_help'] = 'Use este tipo de pregunta si espera que la respuesta sea un número en el formato correcto.';
$string['of'] = 'de';
$string['openafterclose'] = 'Usted ha especificado una fecha de apertura posterior a la fecha de cierre.';
$string['opendate'] = 'Permitir respuestas a partir de';
$string['option'] = 'opción {$a}';
$string['optional'] = 'Opcional - Al menos una de estas dependencias tiene que ser cumplida.';
$string['optionalname'] = 'Nombre de Pregunta';
$string['optionalname_help'] = 'El Nombre de Pregunta se emplea solamente cuando Usted exporta las respuestas en formato CSV/Excel. Si Usted nunca exporta a CSV/Excel, entonces no se preocupe para nada por el Nombre de pregunta. Si planea exportar regularmente sus datos de cuestionarios hacia CSV, entonces tiene que decidir entre dos opciones para nombrar las preguntas.';
$string['optionalname_link'] = 'mod/questionnaire/questions#Question_Name';
$string['or'] = '- O -';
$string['order_ascending'] = 'Orden ascendente';
$string['order_default'] = 'Ver orden por defecto';
$string['order_descending'] = 'Orden descendiente';
$string['orderresponses'] = 'Ordenar respuestas';
$string['orderresponses_help'] = 'Cuando se muestran todas las respuestas, Usted puede ordenarlas por número de respuestas (la columna de Promedio) para los siguientes 4 tipos de preguntas:

* botón de selección única
* lista desplegable de opción única
* opciones múltiples (casillas)
* preguntas para ordenar (incluyendo escalas Likert).

Cuando Usted llega a la página de Todas las respuestas, por defecto todas las respuestas están ordenadas tal como las puso la persona que las escribió.
Usted puede elegir ordenarlas por orden ascendente o descendente.';
$string['orderresponses_link'] = 'mod/questionnaire/report#Order_Responses';
$string['osgood'] = 'Osgood';
$string['other'] = 'Otro:';
$string['otherempty'] = 'Si elige esta opción, ¡Usted deberá introducir texto  en la caja de texto!';
$string['overviewnumresplog'] = 'respuestas';
$string['overviewnumresplog1'] = 'respuesta';
$string['overviewnumrespvw'] = 'respuestas';
$string['overviewnumrespvw1'] = 'respuesta';
$string['owner'] = 'Propietario';
$string['page'] = 'Página';
$string['pageof'] = 'Página {$a->page} de {$a->totpages}';
$string['parent'] = 'Padre';
$string['participant'] = 'Participante';
$string['pleasecomplete'] = 'Por favor, complete esta elección.';
$string['pluginadministration'] = 'Administración del cuestionario';
$string['pluginname'] = 'Cuestionario';
$string['position'] = 'posición';
$string['possibleanswers'] = 'Respuestas posibles';
$string['posteddata'] = 'Alcanzó la página con datos publicados:';
$string['preview_label'] = 'Vista previa';
$string['preview_questionnaire'] = 'Vista previa de Cuestionario';
$string['previewing'] = 'Pre-visualisar cuestionario';
$string['previous'] = 'Previa';
$string['previouspage'] = 'Página previa';
$string['print'] = 'Imprimir esta Respuesta';
$string['printblank'] = 'Imprimir vacío';
$string['printblanktooltip'] = 'Abrir ventana amistosa para impresora con cuestionario vacío';
$string['printtooltip'] = 'Abrir ventana amistosa para impresora con respuesta actual';
$string['privacy:metadata:questionnaire_resp_multiple'] = 'Una respuesta de pregunta de opción múltiple.';
$string['privacy:metadata:questionnaire_resp_multiple:choice_id'] = 'LaA ID de un registro de opción para esta respuesta.';
$string['privacy:metadata:questionnaire_resp_multiple:question_id'] = 'La ID del registro de pregunta para esta respuesta.';
$string['privacy:metadata:questionnaire_resp_multiple:response_id'] = 'La ID del registro de respuesta para esta respuesta.';
$string['privacy:metadata:questionnaire_resp_single'] = 'Una respuesta de pregunta de opción única.';
$string['privacy:metadata:questionnaire_resp_single:choice_id'] = 'La ID del registro de opción para esta respuesta.';
$string['privacy:metadata:questionnaire_resp_single:question_id'] = 'La ID del registro de pregunta para esta respuesta.';
$string['privacy:metadata:questionnaire_resp_single:response_id'] = 'La ID del registro de respuesta para esta respuesta.';
$string['privacy:metadata:questionnaire_response'] = 'Una respuesta en progreso o enviada';
$string['privacy:metadata:questionnaire_response:complete'] = 'El estado de finalización de respuesta.';
$string['privacy:metadata:questionnaire_response:grade'] = 'La calificación para esta respuesta.';
$string['privacy:metadata:questionnaire_response:questionnaireid'] = 'La ID del registro del questionnaire para esta respuesta.';
$string['privacy:metadata:questionnaire_response:submitted'] = 'El sello de tiempo para el guardado más reciente para esta respuesta.';
$string['privacy:metadata:questionnaire_response:userid'] = 'La ID del usuario para esta respuesta.';
$string['privacy:metadata:questionnaire_response_bool'] = 'Una respuesta de pregunta booleana (si/no).';
$string['privacy:metadata:questionnaire_response_bool:choice_id'] = 'La respuesta booleana específica.';
$string['privacy:metadata:questionnaire_response_bool:question_id'] = 'La ID del registro de pregunta para esta respuesta.';
$string['privacy:metadata:questionnaire_response_bool:response_id'] = 'La ID del registro de respuesta para esta respuesta.';
$string['privacy:metadata:questionnaire_response_date'] = 'Una respuesta de pregunta fecha.';
$string['privacy:metadata:questionnaire_response_date:question_id'] = 'La ID del registro de pregunta para esta respuesta.';
$string['privacy:metadata:questionnaire_response_date:response'] = 'La respuesta de fecha específica.';
$string['privacy:metadata:questionnaire_response_date:response_id'] = 'La ID del registro de respuesta para esta respuesta.';
$string['privacy:metadata:questionnaire_response_other'] = 'Una respuesta \'otra\' de opción de texto.';
$string['privacy:metadata:questionnaire_response_other:choice_id'] = 'La ID del registro de opción para esta respuesta.';
$string['privacy:metadata:questionnaire_response_other:question_id'] = 'La ID del registro de pregunta para esta respuesta.';
$string['privacy:metadata:questionnaire_response_other:response'] = 'La respuesta de texto específica.';
$string['privacy:metadata:questionnaire_response_other:response_id'] = 'La ID del registro de respuesta para esta respuesta.';
$string['privacy:metadata:questionnaire_response_rank'] = 'Una respuesta de pregunta ordenamiento';
$string['privacy:metadata:questionnaire_response_rank:choice_id'] = 'La ID del registro de opción para esta respuesta.';
$string['privacy:metadata:questionnaire_response_rank:question_id'] = 'La ID del registro de pregunta para esta respuesta.';
$string['privacy:metadata:questionnaire_response_rank:rankvalue'] = 'La respuesta de ranking específico';
$string['privacy:metadata:questionnaire_response_rank:response_id'] = 'La ID del registro de respuesta para esta respuesta.';
$string['privacy:metadata:questionnaire_response_text'] = 'Una respuesta de pregunta de texto.';
$string['privacy:metadata:questionnaire_response_text:question_id'] = 'La ID del registro de pregunta para esta respuesta.';
$string['privacy:metadata:questionnaire_response_text:response'] = 'La respuesta de texto específico.';
$string['privacy:metadata:questionnaire_response_text:response_id'] = 'La ID del registro de respuesta para esta respuesta.';
$string['private'] = 'Privado';
$string['progressbar'] = 'Mostrar barra de progreso';
$string['progressbar_info'] = 'Questionnaire {$a} completo.';
$string['progresshelp'] = 'Barra de progreso';
$string['progresshelp_help'] = 'Muévase a la siguiente página para llenar la barra de progreso';
$string['public'] = 'Público';
$string['publiccopy'] = 'Copia:';
$string['publicoriginal'] = 'Original:';
$string['qtype'] = 'Tipo';
$string['qtype_help'] = 'Elegir si  a los usuarios se les permitirá responder una vez, diariamente, semanalmente, mensualmente o un número ilimitado de (muchas) veces.';
$string['qtypedaily'] = 'responder diariamente';
$string['qtypemonthly'] = 'responder mensualmente';
$string['qtypeonce'] = 'responder una vez';
$string['qtypeunlimited'] = 'responder muchas';
$string['qtypeweekly'] = 'responder semanalmente';
$string['questionnaire:addinstance'] = 'Añadir un nuevo cuestionario (questionnaire)';
$string['questionnaire:copysurveys'] = 'Copiar plantilla y cuestionarios privados';
$string['questionnaire:createpublic'] = 'Crear cuestionarios públicos';
$string['questionnaire:createtemplates'] = 'Crear plantilla de cuestionarios';
$string['questionnaire:deleteresponses'] = 'Borrar cualquier respuesta';
$string['questionnaire:downloadresponses'] = 'Descargar respuesta en archivo CSV';
$string['questionnaire:editquestions'] = 'Crear y editar preguntas de cuestionario';
$string['questionnaire:manage'] = 'Crear y editar cuestionarios';
$string['questionnaire:message'] = 'Enviar mensaje a los que no contestaron';
$string['questionnaire:preview'] = 'Vista previa de cuestionarios (questionnaires)';
$string['questionnaire:printblank'] = 'Imprimir cuestionario vacío';
$string['questionnaire:readallresponseanytime'] = 'Leer todas las respuestas en cualquier momento';
$string['questionnaire:readallresponses'] = 'Leer resumen de respuestas, sujeto a tiempos de apertura';
$string['questionnaire:readownresponses'] = 'Leer sus propias respuestas';
$string['questionnaire:submissionnotification'] = 'Recibir notificaciones para cada envío';
$string['questionnaire:submit'] = 'Completar y enviar cuestionario';
$string['questionnaire:view'] = 'Ver un cuestionario';
$string['questionnaire:viewsingleresponse'] = 'Ver respuestas individuales completas';
$string['questionnaireadministration'] = 'Administración del cuestionario';
$string['questionnairecloses'] = 'Cuestionario cierra';
$string['questionnaireopens'] = 'Cuestionario abre';
$string['questionnairereport'] = 'Reporte de Cuestionario';
$string['questionnum'] = 'Pregunta #';
$string['questions'] = 'Preguntas';
$string['questionsinsection'] = 'Preguntas en esta sección:';
$string['questiontypes'] = 'Tipos de preguntas';
$string['questiontypes_help'] = 'Vea debajo  la documentación de Moodle';
$string['questiontypes_link'] = 'mod/questionnaire/questions#Question_Types';
$string['radiobuttons'] = 'Botones de Selección';
$string['radiobuttons_help'] = 'En este tipo de pregunta, el respondente debe seleccionar una de las opciones ofrecidas.';
$string['radiobuttons_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['rank'] = 'Rankeo';
$string['ratescale'] = 'Valorar (escala 1..5)';
$string['ratescale_help'] = 'Vea debajo la documentación de Moodle';
$string['ratescale_link'] = 'mod/questionnaire/questions#Rate_.28scale_1..5.29';
$string['realm'] = 'Tipo de cuestionario';
$string['realm_help'] = '* **Existen tres tipos de Cuestionarios:**
* Privado - solamente pertenece al curso donde está definido.
* Plantilla - puede ser copiado y editado.
* Público - puede compartirse entre cursos.';
$string['realm_link'] = 'mod/questionnaire/qsettings#Questionnaire_Type';
$string['redirecturl'] = 'La URL a donde se re-direcciona un usuario después de completar este cuestionario.';
$string['remove'] = 'Borrar';
$string['removeallquestionnaireattempts'] = 'Eliminar todas las respuestas de cuestionario (questionnaire)';
$string['removenotinuse'] = 'Este cuestionario solía depender de un cuastionario público que ha sido eliminado.
Ya no puede usarse más y debería ser eliminado.';
$string['required'] = 'Respuesta es necesaria';
$string['required_help'] = 'Si elige ***Si***,será obligatorio responder a esta preguntá, Por ejemplo: el respondente no podrá enviar el cuestionario mientras no haya respondido a esta pregunta.';
$string['required_link'] = 'mod/questionnaire/questions#Response_Required';
$string['requiredparameter'] = 'Faltó un parámetro necesario';
$string['reset'] = 'Reiniciar';
$string['respeligiblerepl'] = '(remplazada por anulaciones de rol)';
$string['respondent'] = 'Respondente';
$string['respondenteligibleall'] = 'todos';
$string['respondenteligiblestudents'] = 'solamente estudiantes';
$string['respondenteligibleteachers'] = 'solamente profesores';
$string['respondents'] = 'Respondentes';
$string['respondenttype'] = 'Tipo respondiente';
$string['respondenttype_help'] = 'Usted puede mostrar los nombres completos de los usuarios con cada respuesta configurando esto a "fullname" (nombre completo). Usted puede esconder la identidad de los usuarios en las respuestas  configurándolo a "anónimo".';
$string['respondenttype_link'] = 'mod/questionnaire/mod#Respondent_Type';
$string['respondenttypeanonymous'] = 'anónimo';
$string['respondenttypefullname'] = 'fullname (nombrecompleto)';
$string['response'] = 'Respuesta';
$string['responsefieldlines'] = 'Tamaño de caja de entrada';
$string['responseformat'] = 'Formato de respuesta';
$string['responseoptions'] = 'Opciones de respuesta';
$string['responses'] = 'Respuestas';
$string['responseview'] = 'Los estudiantes pueden ver TODAS las respuestas';
$string['responseview_help'] = 'Usted puede especificar quién puede ver las respuestas de todos los respondentes a cuestionarios enviados (tablas estadísticas generales)';
$string['responseview_link'] = 'mod/questionnaire/mod#Response_viewing';
$string['responseviewstudentsalways'] = 'Siempre';
$string['responseviewstudentsnever'] = 'Nunca';
$string['responseviewstudentswhenanswered'] = 'Después de contestar el cuestionario';
$string['responseviewstudentswhenclosed'] = 'Después de que se cierre el cuestionario';
$string['restrictedtoteacher'] = '¡Estas funciones están restringidas a los profesores editores exclusivamente!';
$string['resume'] = 'Guardar/Continuar respuestas';
$string['resume_help'] = 'Configurar esta opción les permite a los usuarios guardar sus respuestas al questionnaire antes de enviarlas. Los usuarios pueden dejar sin terminar el questionnaire y continuarlo desde el punto guardado posteriormente.';
$string['resume_link'] = 'mod/questionnaire/mod#Save/Resume_answers';
$string['resumesurvey'] = 'Continuar el cuestionario';
$string['return'] = 'Regresar';
$string['rightlabel'] = 'Etiqueta derecha';
$string['rightpart'] = 'y {$a->max} es {$a->rightlabel}';
$string['rightpartdefault'] = 'y {$a->max} es rango deslizador máximo';
$string['save'] = 'Guardar';
$string['save_and_exit'] = 'Guardar y salir';
$string['saveasnew'] = 'Guardar como Pregunta Nueva';
$string['savedbutnotsubmitted'] = 'Este cuestionario ha sido guardado pero no ha sido enviado.';
$string['savedprogress'] = 'Su progreso ha sido guardado. Usted podrá regresar en cualquier momento para completar este cuestionario.';
$string['saveeditedquestion'] = 'Guardar pregunta {$a}';
$string['savesettings'] = 'Guardar configuraciones';
$string['search:activity'] = 'Cuestionario - información de actividad';
$string['search:question'] = 'Cuestionario - preguntas';
$string['section'] = 'Descripción';
$string['sectionbreak'] = '----- Salto de página -----';
$string['sectionbreak_help'] = '----- Salto de página -----';
$string['sectionsnotset'] = '¡ Usted debe seleccionar al menos UNA pregunta por sección !<br />Sección(es) no seleccionada(s): {$a}';
$string['sectiontext'] = 'Etiqueta';
$string['sectiontext_help'] = 'Esta no es una pregunta, sino un texto (corto) que se mostrará como introducción a una serie de preguntas.';
$string['selecttheme'] = 'Elija un tema CSS para usar con este cuestionario.';
$string['send'] = 'Enviar';
$string['send_message'] = 'Enviar mensaje a usuarios seleccionados';
$string['send_message_to'] = 'Mandar mensaje a:';
$string['sendemail'] = 'Mandar email';
$string['sendemail_help'] = 'Manda una copia de cada envío a la(s) dirección(es) especificada(s).
Usted puede escribir más de una dirección separándolas con comas.
Déjela en blanco para no tener respaldo de E-mail. \'allowemailreporting\' debe estar habilitado en las configuraciones del módulo para acceder a esto.';
$string['set'] = 'configurada';
$string['settings'] = 'Configuraciones';
$string['settingssaved'] = 'Configuraciones guardadas';
$string['show_nonrespondents'] = 'No respondentes';
$string['slider'] = 'Deslizador';
$string['slider_help'] = 'La pregunta de Deslizador le permite a los respondentes seleccionar un valor de un rango continuo al arrastrar un deslizador entre dos extremos. También se puede configurar un valor central.';
$string['started'] = 'iniciado';
$string['startingvalue'] = 'Valor inicial del Deslizador';
$string['startingvalue_help'] = 'El valor inicial del deslizador especifica en donde debería aparecer primeramente el deslizador para los respondentes. El predeterminado es 1 porque el rango es desconocido. Usted podría querer iniciar en el centro del rango al darle un valor central (un rango de 1-100 tiene un valor central de 50).';
$string['stepvalue'] = 'Valor de incremento del Deslizador';
$string['stepvalue_help'] = 'El valor del incremento del deslizador especifica qué tan finamente quiere usted que los respondentes indiquen su respuesta en el rango. La pregunta tiene un rango predeterminado de 1-100, con un incremento de uno, lo que permite que los respondentes den valores de 70, 71, 72, 73, 74, etc. Pero usted podría configurar incrementos de cinco en cinco, permitiendo a los respondentes dar valores de 60, 65, 70, 75, 80, etc, o inclusive podría configurar un rango de 1-10 con incrementos de 1.';
$string['strfdate'] = '%d/%m/%Y';
$string['strfdateformatcsv'] = 'd/m/Y H:i:s';
$string['strictdateformatting'] = 'Ingrese la fecha usando el selector de fecha inferior.';
$string['subject'] = 'Asunto';
$string['submissionnotificationhtmlanon'] = 'Hay un nuevo <a href="{$a->submissionurl}">envío</a> al questionnaire  "{$a->name}".';
$string['submissionnotificationhtmluser'] = '<a href="{$a->profileurl}">{$a->username}</a> tiene un nuevo <a href="{$a->submissionurl}">envío</a> al cuestionario  "{$a->name}" en el curso  "{$a->coursename}".';
$string['submissionnotificationsubject'] = 'Nuevo envío de questionnaire';
$string['submissionnotificationtextanon'] = 'Hay un nuevo envío ({$a->submissionurl}) al questionnaire  "{$a->name}".';
$string['submissionnotificationtextuser'] = '{$a->username} ({$a->profileurl}) tiene un nuevo envío ({$a->submissionurl}) al cuestionario  "{$a->name}" en el curso "{$a->coursename}".';
$string['submitoptions'] = 'Opciones de envíos';
$string['submitpreview'] = 'Vista previa del envío';
$string['submitpreviewcorrect'] = 'Este envío sería aceptado como correctamente llenado.';
$string['submitsurvey'] = 'Enviar cuestionarios';
$string['submitted'] = 'Enviado en:';
$string['subtitle'] = 'Subtítulo';
$string['subtitle_help'] = 'Susbtítulo del cuestionario. Aparece debajo del título en la primera página solamente.';
$string['summary'] = 'Resumen';
$string['summaryreportattached'] = 'Reporte de resumen de Questionnaire anexo';
$string['surveynotexists'] = 'cuestionario no existe.';
$string['surveyowner'] = 'Usted debe ser el propietario del cuestionario para realizar esta operación.';
$string['surveyresponse'] = 'Respuestas del cuestionario';
$string['template'] = 'Plantilla';
$string['templatenotviewable'] = 'Plantillas de cuestionario no son visibles';
$string['text'] = 'Texto de pregunta';
$string['textareacolumns'] = 'Columnas área-de-texto';
$string['textareacolumns_help'] = 'área-de-textoEsta pregunta mostrará una caja de texto simple con **x** *Columnas áreadetexto* (o area *width*) y con **y** *área-de-texto hileras* (número de *lines* de texto). Si deja ambas x tanto como y en su valor **0** por defecto (o si lo pone a  **0**), entonces el editor de HTML se mostrará con un alto y ancho estándares (si está disponible en el contexto de curso/usuario y perfil del usuario).';
$string['textarearows'] = 'Hileras área-de-texto';
$string['textbox'] = 'Caja de texto';
$string['textbox_help'] = 'Para la pregunta de tipo Caja de Texto, introduzca el largo de la caja de entrada y la longitud máxima del texto que escribirá el que conteste. Los valores por defecto son 20 caracteres para el ancho de la caja de texto y 25 caracteres para la longitud máxima del texto introducido.';
$string['textdownloadoptions'] = 'Opciones para descargar CSV';
$string['thank_head'] = 'Gracias por completar este cuestionario';
$string['theme'] = 'Tema gráfico';
$string['thismonth'] = 'este mes';
$string['thisresponse'] = 'Esta respuesta';
$string['thisweek'] = 'esta semana';
$string['thousands'] = 'No usar separadores de millares';
$string['title'] = 'Título';
$string['title_help'] = 'Título del cuestionario, que aparecerá arriba de cada página. Por defecto el título se configura al nombre del Cuestionario, pero puede editarlo a su gusto.';
$string['today'] = 'hoy';
$string['total'] = 'Total';
$string['totalofnumbers'] = 'Total de números ingresados';
$string['totalresponses'] = 'Total de respuestas a pregunta';
$string['type'] = 'Tipo de pregunta';
$string['unanswered'] = 'No contestada';
$string['undefinedquestiontype'] = '!Tipo de pregunta no-definida!';
$string['unknown'] = 'Desconocida';
$string['unknownaction'] = 'Acción especificada de cuestionario desconocida...';
$string['url'] = 'URL de confirmación';
$string['url_help'] = 'La URL a donde será re-dirigido un usuario después de completar este cuestionario.';
$string['useprivate'] = 'Copiar existente';
$string['usepublic'] = 'Usar público';
$string['usetemplate'] = 'Usar plantilla';
$string['vertical'] = 'Vertical';
$string['view'] = 'Ver';
$string['viewallresponses'] = 'Ver todas las respuestas';
$string['viewallresponses_help'] = 'Si el cuestionario se configura a **Modo Grupo**: *Grupos Visibles*, o se configura a *Grupos Separados* y el usuario actual tiene la capacidad de *moodle/site:accessallgroups*  (en el contexto actual), y los grupos han sido definidos en el grupo actual, entonces el usuario tiene acceso a una lista desplegable de grupos. Esta lista desplegable le permite al usuario "filtrar" las respuestas del cuestionario por grupos. Si la configuración es  **Modo de Grupo**: *Grupos Separados*, entonces los usuarios que no tengan la capacidad de *moodle/site:accessallgroups* (usualmente estudiantes o profesores no-editores, etc.) solamente podrán ver las respuestas del grupo(s) a donde pertenecen.';
$string['viewallresponses_link'] = 'Viewing_Questionnaire_responses#Group_filtering';
$string['viewbyresponse'] = 'Lista de respuestas';
$string['viewindividualresponse'] = 'Respuestas individuales';
$string['viewindividualresponse_help'] = 'Elija los nombres de quienes respondieron en la lista inferior para ver sus respuestas individuales';
$string['viewresponses'] = 'Todas las respuestass ({$a})';
$string['viewyourresponses'] = 'Ver su(s) respuesta(s)';
$string['warning'] = 'Advertencia, error encontrado.';
$string['where'] = 'donde';
$string['wronganswers'] = 'Algo está mal con sus respuestas (vea debajo)';
$string['wrongdateformat'] = 'La fecha introducida: <strong>{$a}</strong> no corresponde al formato mostrado en el ejemplo.';
$string['wrongdaterange'] = '¡ERROR! El año debe estar en el rango entre 1902 y 2037.';
$string['wrongformat'] = 'Algo está mal con su respuesta a la pregunta: ';
$string['wrongformats'] = 'Algo está mal con su respuesta a las preguntas:&nbsp;';
$string['yesno'] = 'Si/No';
$string['yesno_help'] = 'Pregunta Si/No simple.';
$string['yourresponse'] = 'Ver su(s) respuesta(s)';
$string['yourresponses'] = 'Ver su(s) respuesta(s)';
